-- STRUCTURE 
-- [1] : Integer - ID of the music (new system)
-- [2] : String - Path of the music file
-- [3] : Integer - Length of the music file in seconds

-- Get localization
local GJB = LibStub("AceAddon-3.0"):GetAddon("GarrisonJukeBox")
local L = GJB.L -- local L = LibStub("AceLocale-3.0"):GetLocale("GarrisonJukeBox")

-- Wrath of the Lich King
local music = {
	{
		id = 48,
		name = L["TITLE_MAIN_THEME"],
		files = {
			{546, "Sound\\Music\\GlueScreenMusic\\WotLK_main_title.mp3", 544},
		},
	},
	{
		id = 49,
		name = L["TITLE_STORMPEAKS"],
		files = {
			{547, "Sound\\Music\\ZoneMusic\\StormPeaks\\SP_GeneralWalkA_Day01.mp3", 86},
			{548, "Sound\\Music\\ZoneMusic\\StormPeaks\\SP_GeneralWalkA_Night01.mp3", 88},
			{549, "Sound\\Music\\ZoneMusic\\StormPeaks\\SP_GeneralWalkADark_Uni01.mp3", 120},
			{550, "Sound\\Music\\ZoneMusic\\StormPeaks\\SP_GeneralWalkB_Day02.mp3", 82},
			{551, "Sound\\Music\\ZoneMusic\\StormPeaks\\SP_GeneralWalkB_Night02.mp3", 82},
			{552, "Sound\\Music\\ZoneMusic\\StormPeaks\\SP_GeneralWalkB_Uni02.mp3", 82},
			{553, "Sound\\Music\\ZoneMusic\\StormPeaks\\SP_GeneralWalkC_Day03.mp3", 64},
			{554, "Sound\\Music\\ZoneMusic\\StormPeaks\\SP_GeneralWalkC_Night03.mp3", 58},
			{555, "Sound\\Music\\ZoneMusic\\StormPeaks\\SP_GeneralWalkC_Uni03.mp3", 58},
			{556, "Sound\\Music\\ZoneMusic\\StormPeaks\\SP_GeneralWalkD_Day04.mp3", 55},
			{557, "Sound\\Music\\ZoneMusic\\StormPeaks\\SP_GeneralWalkD_Night04.mp3", 52},
			{558, "Sound\\Music\\ZoneMusic\\StormPeaks\\SP_GeneralWalkD_Uni04.mp3", 54},
			{559, "Sound\\Music\\ZoneMusic\\StormPeaks\\SP_GeneralWalkE_Day05.mp3", 83},
			{560, "Sound\\Music\\ZoneMusic\\StormPeaks\\SP_GeneralWalkE_Night05.mp3", 74},
			{561, "Sound\\Music\\ZoneMusic\\StormPeaks\\SP_GeneralWalkE_Uni05.mp3", 83},
		},
	},
	{
		id = 50,
		name = L["TITLE_DALARAN"],
		files = {
			{562, "Sound\\Music\\ZoneMusic\\Dalaran\\DC_GeneralWalkUni01.mp3", 67},
			{563, "Sound\\Music\\ZoneMusic\\Dalaran\\DC_GeneralWalkUni02.mp3", 42},
			{564, "Sound\\Music\\ZoneMusic\\Dalaran\\DC_GeneralWalkUni03.mp3", 70},
			{565, "Sound\\Music\\ZoneMusic\\Dalaran\\DC_GeneralWalkUni04.mp3", 88},
			{566, "Sound\\Music\\ZoneMusic\\Dalaran\\DC_IntroUni01.mp3", 68},
			{567, "Sound\\Music\\ZoneMusic\\Dalaran\\DC_SewerWalkUni01.mp3", 66},
			{568, "Sound\\Music\\ZoneMusic\\Dalaran\\DC_SewerWalkUni02.mp3", 101},
			{569, "Sound\\Music\\ZoneMusic\\Dalaran\\DC_SewerWalkUni03.mp3", 72},
			{570, "Sound\\Music\\ZoneMusic\\Dalaran\\DC_SewerWalkUni04.mp3", 65},
			{571, "Sound\\Music\\ZoneMusic\\Dalaran\\DC_SpireWalkUni01.mp3", 91},
		},
	},
	{
		id = 51,
		name = L["TITLE_ICECROWNGLACIER"],
		files = {
			{572, "Sound\\Music\\ZoneMusic\\IcecrownGlacier\\IC_GeneralIntro_01.mp3", 58},
			{573, "Sound\\Music\\ZoneMusic\\IcecrownGlacier\\IC_GeneralIntro_02.mp3", 56},
			{574, "Sound\\Music\\ZoneMusic\\IcecrownGlacier\\IC_GeneralIntro_03.mp3", 57},
			{575, "Sound\\Music\\ZoneMusic\\IcecrownGlacier\\IC_GeneralWalk_Day01.mp3", 75},
			{576, "Sound\\Music\\ZoneMusic\\IcecrownGlacier\\IC_GeneralWalk_Day02.mp3", 101},
			{577, "Sound\\Music\\ZoneMusic\\IcecrownGlacier\\IC_GeneralWalk_Day03.mp3", 62},
			{578, "Sound\\Music\\ZoneMusic\\IcecrownGlacier\\IC_GeneralWalk_Day04.mp3", 98},
			{579, "Sound\\Music\\ZoneMusic\\IcecrownGlacier\\IC_GeneralWalk_Night01.mp3", 99},
			{580, "Sound\\Music\\ZoneMusic\\IcecrownGlacier\\IC_GeneralWalk_Night02.mp3", 81},
			{581, "Sound\\Music\\ZoneMusic\\IcecrownGlacier\\IC_GeneralWalk_Night03.mp3", 94},
			{582, "Sound\\Music\\ZoneMusic\\IcecrownGlacier\\IC_GeneralWalk_Night04.mp3", 64},
			{583, "Sound\\Music\\ZoneMusic\\IcecrownGlacier\\IC_GeneralWalk_Night05.mp3", 102},
		},
	},
	{
		id = 52,
		name = L["TITLE_CRYSTALSONGFOREST"],
		files = {
			{584, "Sound\\Music\\ZoneMusic\\Crystalsong\\CS_CrystalsongWalkUni01.mp3", 113},
			{585, "Sound\\Music\\ZoneMusic\\Crystalsong\\CS_CrystalsongWalkUni02.mp3", 98},
			{586, "Sound\\Music\\ZoneMusic\\Crystalsong\\CS_CrystalsongWalkUni03.mp3", 72},
			{587, "Sound\\Music\\ZoneMusic\\Crystalsong\\CS_CrystalsongWalkUni04.mp3", 113},
			{588, "Sound\\Music\\ZoneMusic\\Crystalsong\\CS_CrystalsongWalkUni05.mp3", 107},
		},
	},
	{
		id = 53,
		name = L["TITLE_DRAGONBLIGHT"],
		files = {
			{589, "Sound\\Music\\ZoneMusic\\Dragonblight\\DB_GeneralIntro_01.mp3", 92},
			{590, "Sound\\Music\\ZoneMusic\\Dragonblight\\DB_GeneralIntro_02.mp3", 93},
			{591, "Sound\\Music\\ZoneMusic\\Dragonblight\\DB_GeneralIntro_03.mp3", 92},
			{592, "Sound\\Music\\ZoneMusic\\Dragonblight\\DB_GeneralIntro_04.mp3", 92},
			{593, "Sound\\Music\\ZoneMusic\\Dragonblight\\DB_GeneralWalk_Day01.mp3", 75},
			{594, "Sound\\Music\\ZoneMusic\\Dragonblight\\DB_GeneralWalk_Day02.mp3", 57},
			{595, "Sound\\Music\\ZoneMusic\\Dragonblight\\DB_GeneralWalk_Day03.mp3", 120},
			{596, "Sound\\Music\\ZoneMusic\\Dragonblight\\DB_GeneralWalk_Day04.mp3", 76},
			{597, "Sound\\Music\\ZoneMusic\\Dragonblight\\DB_GeneralWalk_Day05.mp3", 93},
			{598, "Sound\\Music\\ZoneMusic\\Dragonblight\\DB_GeneralWalk_Day06.mp3", 93},
			{599, "Sound\\Music\\ZoneMusic\\Dragonblight\\DB_GeneralWalk_Day07.mp3", 92},
			{600, "Sound\\Music\\ZoneMusic\\Dragonblight\\DB_GeneralWalk_Day08.mp3", 93},
			{601, "Sound\\Music\\ZoneMusic\\Dragonblight\\DB_GeneralWalk_Night01.mp3", 73},
			{602, "Sound\\Music\\ZoneMusic\\Dragonblight\\DB_GeneralWalk_Night02.mp3", 57},
			{603, "Sound\\Music\\ZoneMusic\\Dragonblight\\DB_GeneralWalk_Night03.mp3", 119},
			{604, "Sound\\Music\\ZoneMusic\\Dragonblight\\DB_GeneralWalk_Night04.mp3", 76},
			{605, "Sound\\Music\\ZoneMusic\\Dragonblight\\DB_GeneralWalk_Night05.mp3", 93},
			{606, "Sound\\Music\\ZoneMusic\\Dragonblight\\DB_GeneralWalk_Night06.mp3", 92},
			{607, "Sound\\Music\\ZoneMusic\\Dragonblight\\DB_GeneralWalk_Night07.mp3", 93},
			{608, "Sound\\Music\\ZoneMusic\\Dragonblight\\DB_GeneralWalk_Night08.mp3", 93},
			{609, "Sound\\Music\\ZoneMusic\\Dragonblight\\DB_Tusk_Indule_Day01.mp3", 129},
			{610, "Sound\\Music\\ZoneMusic\\Dragonblight\\DB_Tusk_Indule_Day02.mp3", 62},
			{611, "Sound\\Music\\ZoneMusic\\Dragonblight\\DB_Tusk_InduleDay01.mp3", 129},
			{612, "Sound\\Music\\ZoneMusic\\Dragonblight\\DB_Tusk_InduleDay02.mp3", 60},
			{613, "Sound\\Music\\ZoneMusic\\Dragonblight\\DB_Tusk_InduleDay03.mp3", 39},
			{614, "Sound\\Music\\ZoneMusic\\Dragonblight\\DB_Tusk_InduleNight01.mp3", 132},
			{615, "Sound\\Music\\ZoneMusic\\Dragonblight\\DB_Tusk_InduleNight02.mp3", 64},
			{616, "Sound\\Music\\ZoneMusic\\Dragonblight\\DB_Tusk_InduleNight03.mp3", 39},
		},
	},
	{
		id = 54,
		name = L["TITLE_HOWLINGFJORD"],
		files = {
			{617, "Sound\\Music\\ZoneMusic\\HowlingFjord\\HF_DistWalkUni01.mp3", 30},
			{618, "Sound\\Music\\ZoneMusic\\HowlingFjord\\HF_DistWalkUni02.mp3", 47},
			{619, "Sound\\Music\\ZoneMusic\\HowlingFjord\\HF_DistWalkUni03.mp3", 52},
			{620, "Sound\\Music\\ZoneMusic\\HowlingFjord\\HF_DistWalkUni04.mp3", 26},
			{621, "Sound\\Music\\ZoneMusic\\HowlingFjord\\HF_DistWalkUni05.mp3", 22},
			{622, "Sound\\Music\\ZoneMusic\\HowlingFjord\\HF_DistWalkUni06.mp3", 41},
			{623, "Sound\\Music\\ZoneMusic\\HowlingFjord\\HF_DistWalkUni07.mp3", 23},
			{624, "Sound\\Music\\ZoneMusic\\HowlingFjord\\HF_GeneralWalk_Day01.mp3", 110},
			{625, "Sound\\Music\\ZoneMusic\\HowlingFjord\\HF_GeneralWalk_Day02.mp3", 75},
			{626, "Sound\\Music\\ZoneMusic\\HowlingFjord\\HF_GeneralWalk_Day03.mp3", 90},
			{627, "Sound\\Music\\ZoneMusic\\HowlingFjord\\HF_GeneralWalk_Day04.mp3", 64},
			{628, "Sound\\Music\\ZoneMusic\\HowlingFjord\\HF_GeneralWalk_Day05.mp3", 124},
			{629, "Sound\\Music\\ZoneMusic\\HowlingFjord\\HF_GeneralWalk_Day06.mp3", 114},
			{630, "Sound\\Music\\ZoneMusic\\HowlingFjord\\HF_GeneralWalk_Day07.mp3", 149},
			{631, "Sound\\Music\\ZoneMusic\\HowlingFjord\\HF_GeneralWalk_Night01.mp3", 106},
			{632, "Sound\\Music\\ZoneMusic\\HowlingFjord\\HF_GeneralWalk_Night02.mp3", 91},
			{633, "Sound\\Music\\ZoneMusic\\HowlingFjord\\HF_GeneralWalk_Night03.mp3", 84},
			{634, "Sound\\Music\\ZoneMusic\\HowlingFjord\\HF_GeneralWalk_Night04.mp3", 157},
			{635, "Sound\\Music\\ZoneMusic\\HowlingFjord\\HF_Tusk_KamaguaDay01.mp3", 95},
			{636, "Sound\\Music\\ZoneMusic\\HowlingFjord\\HF_Tusk_KamaguaDay02.mp3", 54},
			{637, "Sound\\Music\\ZoneMusic\\HowlingFjord\\HF_Tusk_KamaguaNight01.mp3", 99},
			{638, "Sound\\Music\\ZoneMusic\\HowlingFjord\\HF_Tusk_KamaguaNight02.mp3", 80},
		},
	},
	{
		id = 55,
		name = L["TITLE_SCHOLAZARBASIN"],
		files = {
			{639, "Sound\\Music\\ZoneMusic\\SholazarBasin\\SB_CrystalsWalkUni01.mp3", 130},
			{640, "Sound\\Music\\ZoneMusic\\SholazarBasin\\SB_CrystalsWalkUni02.mp3", 143},
			{641, "Sound\\Music\\ZoneMusic\\SholazarBasin\\SB_FireWalkUni01.mp3", 107},
			{642, "Sound\\Music\\ZoneMusic\\SholazarBasin\\SB_FireWalkUni02.mp3", 93},
			{643, "Sound\\Music\\ZoneMusic\\SholazarBasin\\SB_FireWalkUni03.mp3", 57},
			{644, "Sound\\Music\\ZoneMusic\\SholazarBasin\\SB_FireWalkUni04.mp3", 107},
			{645, "Sound\\Music\\ZoneMusic\\SholazarBasin\\SB_LifebloodCaveWalkUni01.mp3", 81},
			{646, "Sound\\Music\\ZoneMusic\\SholazarBasin\\SB_LifebloodCaveWalkUni02.mp3", 99},
			{647, "Sound\\Music\\ZoneMusic\\SholazarBasin\\SB_LifebloodCaveWalkUni03.mp3", 99},
			{648, "Sound\\Music\\ZoneMusic\\SholazarBasin\\SB_MakersTerraceWalkUni01.mp3", 75},
			{649, "Sound\\Music\\ZoneMusic\\SholazarBasin\\SB_MakersTerraceWalkUni02.mp3", 94},
			{650, "Sound\\Music\\ZoneMusic\\SholazarBasin\\SB_PathofLifeWardenWalkUni01.mp3", 136},
			{651, "Sound\\Music\\ZoneMusic\\SholazarBasin\\SB_PathofLifeWardenWalkUni02.mp3", 161},
			{652, "Sound\\Music\\ZoneMusic\\SholazarBasin\\SB_SholazarWalkDay01.mp3", 175},
			{653, "Sound\\Music\\ZoneMusic\\SholazarBasin\\SB_SholazarWalkDay02.mp3", 114},
			{654, "Sound\\Music\\ZoneMusic\\SholazarBasin\\SB_SholazarWalkDay03.mp3", 105},
			{655, "Sound\\Music\\ZoneMusic\\SholazarBasin\\SB_SholazarWalkDay04.mp3", 112},
			{656, "Sound\\Music\\ZoneMusic\\SholazarBasin\\SB_SholazarWalkDay05.mp3", 123},
			{657, "Sound\\Music\\ZoneMusic\\SholazarBasin\\SB_SholazarWalkDay06.mp3", 142},
			{658, "Sound\\Music\\ZoneMusic\\SholazarBasin\\SB_SholazarWalkNight01.mp3", 115},
			{659, "Sound\\Music\\ZoneMusic\\SholazarBasin\\SB_SholazarWalkNight02.mp3", 137},
			{660, "Sound\\Music\\ZoneMusic\\SholazarBasin\\SB_SholazarWalkNight03.mp3", 132},
			{661, "Sound\\Music\\ZoneMusic\\SholazarBasin\\SB_SholazarWalkNight04.mp3", 91},
			{662, "Sound\\Music\\ZoneMusic\\SholazarBasin\\SB_SholazarWalkNight05.mp3", 99},
		},
	},
	{
		id = 56,
		name = L["TITLE_ESCAPEFROMARTHAS"],
		files = {
			{663, "Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_HallsofChase.mp3", 106},
		},
	},
	{
		id = 57,
		name = L["TITLE_LADYORLICH"],
		files = {
			{664, "Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_LadyortheLich.mp3", 75},
		},
	},
	{
		id = 58,
		name = L["TITLE_CALL_OT_CRUSADE"],
		files = {
			{665, "Sound\\Music\\ZoneMusic\\ArgentColiseum\\CR_TourneyBattle01UniWalk.mp3", 145},
			{666, "Sound\\Music\\ZoneMusic\\ArgentColiseum\\CR_TourneyBattle02UniWalk.mp3", 185},
			{667, "Sound\\Music\\ZoneMusic\\ArgentColiseum\\CR_TourneyBattle03UniWalk.mp3", 162},
			{668, "Sound\\Music\\ZoneMusic\\ArgentColiseum\\CR_TourneyBattle04UniWalk.mp3", 160},
			{669, "Sound\\Music\\ZoneMusic\\ArgentColiseum\\CR_TourneyBattle05UniWalk.mp3", 193},
			{670, "Sound\\Music\\ZoneMusic\\ArgentColiseum\\CR_TourneyBattle06UniWalk.mp3", 185},
		},
	},
	{
		id = 59,
		name = L["TITLE_ARGENT_TOURNAMENT"],
		files = {
			{671, "Sound\\Music\\ZoneMusic\\ArgentTournament\\AT_HeraldEvent.mp3", 13},
			{672, "Sound\\Music\\ZoneMusic\\ArgentTournament\\AT_JoustEvent.mp3", 123},
			{673, "Sound\\Music\\ZoneMusic\\ArgentTournament\\AT_Tourney01NightWalk.mp3", 156},
			{674, "Sound\\Music\\ZoneMusic\\ArgentTournament\\AT_Tourney02DayWalk.mp3", 157},
			{675, "Sound\\Music\\ZoneMusic\\ArgentTournament\\AT_Tourney03NightWalkUniWalk.mp3", 162},
			{676, "Sound\\Music\\ZoneMusic\\ArgentTournament\\AT_Tourney05NightWalk.mp3", 164},
			{677, "Sound\\Music\\ZoneMusic\\ArgentTournament\\AT_Tourney06DayWalk.mp3", 144},
			{678, "Sound\\Music\\ZoneMusic\\ArgentTournament\\AT_Tourney07NightWalk.mp3", 185},
			{679, "Sound\\Music\\ZoneMusic\\ArgentTournament\\AT_Tourney08NightWalk.mp3", 189},
			{680, "Sound\\Music\\ZoneMusic\\ArgentTournament\\AT_Tourney09DayWalk.mp3", 151},
			{681, "Sound\\Music\\ZoneMusic\\ArgentTournament\\AT_Tourney10DayWalk.mp3", 151},
		},
	},
	{
		id = 60,
		name = L["TITLE_AZJOLNERUB"],
		files = {
			{682, "Sound\\Music\\ZoneMusic\\AzjolNerub\\AN_GeneralIntro_01.mp3", 62},
			{683, "Sound\\Music\\ZoneMusic\\AzjolNerub\\AN_GeneralIntro_02.mp3", 98},
			{684, "Sound\\Music\\ZoneMusic\\AzjolNerub\\AN_GeneralIntro_03.mp3", 111},
			{685, "Sound\\Music\\ZoneMusic\\AzjolNerub\\AN_GeneralIntro_04.mp3", 62},
			{686, "Sound\\Music\\ZoneMusic\\AzjolNerub\\AN_GeneralIntro_05.mp3", 76},
			{687, "Sound\\Music\\ZoneMusic\\AzjolNerub\\AN_GeneralIntro_06.mp3", 107},
			{688, "Sound\\Music\\ZoneMusic\\AzjolNerub\\AN_GeneralIntro_07.mp3", 107},
			{689, "Sound\\Music\\ZoneMusic\\AzjolNerub\\AN_GeneralIntro_08.mp3", 104},
			{690, "Sound\\Music\\ZoneMusic\\AzjolNerub\\AN_GeneralWalk_01.mp3", 61},
			{691, "Sound\\Music\\ZoneMusic\\AzjolNerub\\AN_GeneralWalk_02.mp3", 98},
			{692, "Sound\\Music\\ZoneMusic\\AzjolNerub\\AN_GeneralWalk_03.mp3", 110},
			{693, "Sound\\Music\\ZoneMusic\\AzjolNerub\\AN_GeneralWalk_04.mp3", 63},
			{694, "Sound\\Music\\ZoneMusic\\AzjolNerub\\AN_GeneralWalk_05.mp3", 76},
			{695, "Sound\\Music\\ZoneMusic\\AzjolNerub\\AN_GeneralWalk_06.mp3", 104},
			{696, "Sound\\Music\\ZoneMusic\\AzjolNerub\\AN_GeneralWalk_07.mp3", 62},
			{697, "Sound\\Music\\ZoneMusic\\AzjolNerub\\AN_GeneralWalk_08.mp3", 62},
			{698, "Sound\\Music\\ZoneMusic\\AzjolNerub\\AN_GeneralWalk_09.mp3", 98},
			{699, "Sound\\Music\\ZoneMusic\\AzjolNerub\\AN_GeneralWalk_10.mp3", 98},
			{700, "Sound\\Music\\ZoneMusic\\AzjolNerub\\AN_GeneralWalk_11.mp3", 111},
			{701, "Sound\\Music\\ZoneMusic\\AzjolNerub\\AN_GeneralWalk_12.mp3", 110},
			{702, "Sound\\Music\\ZoneMusic\\AzjolNerub\\AN_GeneralWalk_13.mp3", 63},
			{703, "Sound\\Music\\ZoneMusic\\AzjolNerub\\AN_GeneralWalk_14.mp3", 63},
			{704, "Sound\\Music\\ZoneMusic\\AzjolNerub\\AN_GeneralWalk_15.mp3", 76},
			{705, "Sound\\Music\\ZoneMusic\\AzjolNerub\\AN_GeneralWalk_16.mp3", 77},
		},
	},
	{
		id = 61,
		name = L["TITLE_BOREANTUNDRA"],
		files = {
			{706, "Sound\\Music\\ZoneMusic\\BoreanTundra\\BO_ColdarraWalkUni01.mp3", 64},
			{707, "Sound\\Music\\ZoneMusic\\BoreanTundra\\BO_ColdarraWalkUni02.mp3", 63},
			{708, "Sound\\Music\\ZoneMusic\\BoreanTundra\\BO_ColdarraWalkUni03.mp3", 124},
			{709, "Sound\\Music\\ZoneMusic\\BoreanTundra\\BO_GeneralWalk_Day01.mp3", 73},
			{710, "Sound\\Music\\ZoneMusic\\BoreanTundra\\BO_GeneralWalk_Day02.mp3", 101},
			{711, "Sound\\Music\\ZoneMusic\\BoreanTundra\\BO_GeneralWalk_Day03.mp3", 78},
			{712, "Sound\\Music\\ZoneMusic\\BoreanTundra\\BO_GeneralWalk_Day04.mp3", 112},
			{713, "Sound\\Music\\ZoneMusic\\BoreanTundra\\BO_GeneralWalk_Day05.mp3", 73},
			{714, "Sound\\Music\\ZoneMusic\\BoreanTundra\\BO_GeneralWalk_Day06.mp3", 115},
			{715, "Sound\\Music\\ZoneMusic\\BoreanTundra\\BO_GeneralWalk_Day07.mp3", 86},
			{716, "Sound\\Music\\ZoneMusic\\BoreanTundra\\BO_GeneralWalk_Day08.mp3", 71},
			{717, "Sound\\Music\\ZoneMusic\\BoreanTundra\\BO_GeneralWalk_Night01.mp3", 73},
			{718, "Sound\\Music\\ZoneMusic\\BoreanTundra\\BO_GeneralWalk_Night02.mp3", 115},
			{719, "Sound\\Music\\ZoneMusic\\BoreanTundra\\BO_GeneralWalk_Night03.mp3", 88},
			{720, "Sound\\Music\\ZoneMusic\\BoreanTundra\\BO_GeneralWalk_Night04.mp3", 70},
			{721, "Sound\\Music\\ZoneMusic\\BoreanTundra\\BO_GeneralWalk_Night05.mp3", 77},
			{722, "Sound\\Music\\ZoneMusic\\BoreanTundra\\BO_GeneralWalk_Night06.mp3", 100},
			{723, "Sound\\Music\\ZoneMusic\\BoreanTundra\\BO_GeneralWalk_Night07.mp3", 78},
			{724, "Sound\\Music\\ZoneMusic\\BoreanTundra\\BO_GeneralWalk_Night08.mp3", 111},
			{725, "Sound\\Music\\ZoneMusic\\BoreanTundra\\BO_GeyserField_General01.mp3", 58},
			{726, "Sound\\Music\\ZoneMusic\\BoreanTundra\\BO_GeyserField_General02.mp3", 48},
			{727, "Sound\\Music\\ZoneMusic\\BoreanTundra\\BO_GeyserField_General03.mp3", 62},
			{728, "Sound\\Music\\ZoneMusic\\BoreanTundra\\BO_Riplash_Day01.mp3", 151},
			{729, "Sound\\Music\\ZoneMusic\\BoreanTundra\\BO_Riplash_Day02.mp3", 186},
			{730, "Sound\\Music\\ZoneMusic\\BoreanTundra\\BO_Riplash_Day03.mp3", 161},
			{731, "Sound\\Music\\ZoneMusic\\BoreanTundra\\BO_Riplash_Intro01.mp3", 153},
			{732, "Sound\\Music\\ZoneMusic\\BoreanTundra\\BO_Riplash_Intro02.mp3", 177},
			{733, "Sound\\Music\\ZoneMusic\\BoreanTundra\\BO_Riplash_Night01.mp3", 159},
			{734, "Sound\\Music\\ZoneMusic\\BoreanTundra\\BO_Riplash_Night02.mp3", 79},
			{735, "Sound\\Music\\ZoneMusic\\BoreanTundra\\BO_Riplash_Night03.mp3", 76},
			{736, "Sound\\Music\\ZoneMusic\\BoreanTundra\\BO_Riplash_Night04.mp3", 95},
			{737, "Sound\\Music\\ZoneMusic\\BoreanTundra\\BO_Tusk_KaskalaDay01.mp3", 101},
			{738, "Sound\\Music\\ZoneMusic\\BoreanTundra\\BO_Tusk_KaskalaDay02.mp3", 79},
			{739, "Sound\\Music\\ZoneMusic\\BoreanTundra\\BO_Tusk_KaskalaNight01.mp3", 99},
			{740, "Sound\\Music\\ZoneMusic\\BoreanTundra\\BO_Tusk_KaskalaNight02.mp3", 59},
		},
	},
	{
		id = 62,
		name = L["TITLE_EBONHOLD"],
		files = {
			{741, "Sound\\Music\\ZoneMusic\\Ebon Hold\\EH_AssaultUni01.mp3", 65},
			{742, "Sound\\Music\\ZoneMusic\\Ebon Hold\\EH_AssaultUni02.mp3", 70},
			{743, "Sound\\Music\\ZoneMusic\\Ebon Hold\\EH_AssaultUni03.mp3", 65},
			{744, "Sound\\Music\\ZoneMusic\\Ebon Hold\\EH_AssaultUni04.mp3", 67},
			{745, "Sound\\Music\\ZoneMusic\\Ebon Hold\\EH_AssaultUni05.mp3", 117},
			{746, "Sound\\Music\\ZoneMusic\\Ebon Hold\\EH_AssaultUni06.mp3", 93},
			{747, "Sound\\Music\\ZoneMusic\\Ebon Hold\\EH_AssaultUni07.mp3", 96},
			{748, "Sound\\Music\\ZoneMusic\\Ebon Hold\\EH_GeneralWalkUni01.mp3", 82},
			{749, "Sound\\Music\\ZoneMusic\\Ebon Hold\\EH_GeneralWalkUni02.mp3", 78},
			{750, "Sound\\Music\\ZoneMusic\\Ebon Hold\\EH_GeneralWalkUni03.mp3", 82},
		},
	},
	{
		id = 63,
		name = L["TITLE_GRIZZLYHILLS"],
		files = {
			{751, "Sound\\Music\\ZoneMusic\\GrizzlyHills\\GH_GeneralWalk_A_Day01.mp3", 94},
			{752, "Sound\\Music\\ZoneMusic\\GrizzlyHills\\GH_GeneralWalk_A_Day02.mp3", 144},
			{753, "Sound\\Music\\ZoneMusic\\GrizzlyHills\\GH_GeneralWalk_A_Day03.mp3", 88},
			{754, "Sound\\Music\\ZoneMusic\\GrizzlyHills\\GH_GeneralWalk_A_Day04.mp3", 95},
			{755, "Sound\\Music\\ZoneMusic\\GrizzlyHills\\GH_GeneralWalk_A_Night01.mp3", 130},
			{756, "Sound\\Music\\ZoneMusic\\GrizzlyHills\\GH_GeneralWalk_A_Night02.mp3", 141},
			{757, "Sound\\Music\\ZoneMusic\\GrizzlyHills\\GH_GeneralWalk_B_Day01.mp3", 107},
			{758, "Sound\\Music\\ZoneMusic\\GrizzlyHills\\GH_GeneralWalk_B_Day02.mp3", 108},
			{759, "Sound\\Music\\ZoneMusic\\GrizzlyHills\\GH_GeneralWalk_B_Night01.mp3", 101},
			{760, "Sound\\Music\\ZoneMusic\\GrizzlyHills\\GH_GeneralWalk_B_Night02.mp3", 116},
			{761, "Sound\\Music\\ZoneMusic\\GrizzlyHills\\GH_Intro1Uni01.mp3", 284},
			{762, "Sound\\Music\\ZoneMusic\\GrizzlyHills\\GH_Intro2Uni01.mp3", 149},
			{763, "Sound\\Music\\ZoneMusic\\GrizzlyHills\\GH_WalkDay01.mp3", 141},
			{764, "Sound\\Music\\ZoneMusic\\GrizzlyHills\\GH_WalkDay02.mp3", 138},
			{765, "Sound\\Music\\ZoneMusic\\GrizzlyHills\\GH_WalkDay03.mp3", 238},
			{766, "Sound\\Music\\ZoneMusic\\GrizzlyHills\\GH_WalkDay04.mp3", 111},
			{767, "Sound\\Music\\ZoneMusic\\GrizzlyHills\\GH_WalkDay05.mp3", 97},
			{768, "Sound\\Music\\ZoneMusic\\GrizzlyHills\\GH_WalkDay06.mp3", 155},
			{769, "Sound\\Music\\ZoneMusic\\GrizzlyHills\\GH_WalkDay07.mp3", 155},
			{770, "Sound\\Music\\ZoneMusic\\GrizzlyHills\\GH_WalkDay08.mp3", 88},
			{771, "Sound\\Music\\ZoneMusic\\GrizzlyHills\\GH_WalkDay09.mp3", 88},
			{772, "Sound\\Music\\ZoneMusic\\GrizzlyHills\\GH_WalkNight01.mp3", 101},
			{773, "Sound\\Music\\ZoneMusic\\GrizzlyHills\\GH_WalkNight02.mp3", 111},
			{774, "Sound\\Music\\ZoneMusic\\GrizzlyHills\\GH_WalkNight03.mp3", 99},
			{775, "Sound\\Music\\ZoneMusic\\GrizzlyHills\\GH_WalkNight04.mp3", 155},
			{776, "Sound\\Music\\ZoneMusic\\GrizzlyHills\\GH_WalkNight05.mp3", 149},
			{777, "Sound\\Music\\ZoneMusic\\GrizzlyHills\\GH_WalkNight06.mp3", 133},
		},
	},
	{
		id = 64,
		name = L["TITLE_ICC1"],
		files = {
			{778, "Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_BronzeJam.mp3", 116},
			{779, "Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_CrimsonHall1.mp3", 121},
			{780, "Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_CrimsonHall2.mp3", 73},
			{781, "Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_CrimsonHall3.mp3", 61},
			{782, "Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_CrimsonHall4.mp3", 130},
			{783, "Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_ForgeofSouls1.mp3", 103},
			{784, "Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_ForgeofSouls2.mp3", 87},
			{785, "Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_ForgeofSouls3.mp3", 97},
			{786, "Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_ForgeofSouls4.mp3", 99},
			{787, "Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_Frostmourne1.mp3", 103},
			{788, "Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_Frostmourne2.mp3", 103},
			{789, "Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_Frostmourne3.mp3", 103},
			{790, "Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_Gunships.mp3", 73},
			{791, "Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_GunStrings.mp3", 61},
			{792, "Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_HallsofChase.mp3", 106},
			{793, "Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_IceFortress.mp3", 133},
			{794, "Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_HallsofReflection.mp3", 157},
			{795, "Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_IceFortress1.mp3", 153},
			{796, "Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_IceFortress2.mp3", 105},
			{797, "Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_IceFortress3.mp3", 80},
			{798, "Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_IceFortress4.mp3", 106},
			{799, "Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_LadyortheLich.mp3", 75},
			{800, "Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_LetHimPass.mp3", 92},
			{801, "Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_LightsHammer1.mp3", 108},
			{802, "Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_LightsHammer2.mp3", 40},
			{803, "Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_LightsHammer3.mp3", 83},
			{804, "Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_LightsHammer4.mp3", 102},
			{805, "Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_LightsHammer5.mp3", 58},
			{806, "Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_LightsHammer6.mp3", 108},
			{807, "Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_ReflectedHalls1.mp3", 60},
			{808, "Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_ReflectedHalls2.mp3", 75},
			{809, "Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_ReflectedHalls3.mp3", 67},
			{810, "Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_ReflectedHalls4.mp3", 129},
			{811, "Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_ReflectedHalls5.mp3", 59},
		},
	},
	{
		id = 65,
		name = L["TITLE_ICC2"],
		files = {
			{812, "Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_FrozenThrone_01.mp3", 24},
			{813, "Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_FrozenThrone_02.mp3", 41},
			{814, "Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_FrozenThrone_03.mp3", 20},
			{815, "Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_FrozenThrone_04.mp3", 15},
			{816, "Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_FrozenThrone_05.mp3", 10},
			{817, "Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_FrozenThrone_06.mp3", 20},
			{818, "Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_FrozenThrone_07.mp3", 283},
			{819, "Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_RunK_01.mp3", 27},
			{820, "Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_RunK_02.mp3", 27},
			{821, "Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_RunK_03.mp3", 27},
			{822, "Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_RunL_01.mp3", 23},
			{823, "Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_RunL_02.mp3", 42},
			{824, "Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_Sindragosa.mp3", 68},
			{825, "Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_SindraStrings.mp3", 66},
			{826, "Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_StingH_01.mp3", 27},
			{827, "Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_StingH_02.mp3", 16},
			{828, "Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_StingH_03.mp3", 25},
			{829, "Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_StingH_04.mp3", 26},
			{830, "Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_StingH_05.mp3", 27},
			{831, "Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_StingH_06.mp3", 27},
			{832, "Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_Summit1.mp3", 103},
			{833, "Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_Summit2.mp3", 103},
			{834, "Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_Summit3.mp3", 103},
			{835, "Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_Summit4.mp3", 103},
			{836, "Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_Summit5.mp3", 103},
		},
	},
	{
		id = 66,
		name = L["TITLE_ICC3"],
		files = {
			{837, "Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_WalkA_01.mp3", 98},
			{838, "Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_WalkA_02.mp3", 97},
			{839, "Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_WalkA_03.mp3", 91},
			{840, "Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_WalkA_04.mp3", 98},
			{841, "Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_WalkA_05.mp3", 100},
			{842, "Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_WalkA_06.mp3", 52},
			{843, "Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_WalkB_01.mp3", 52},
			{844, "Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_WalkD_01.mp3", 43},
			{845, "Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_WalkD_02.mp3", 42},
			{846, "Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_WalkD_03.mp3", 42},
			{847, "Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_WalkD_04.mp3", 43},
			{848, "Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_WalkD_05.mp3", 43},
			{849, "Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_WalkD_06.mp3", 43},
			{850, "Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_WalkE_01.mp3", 29},
			{851, "Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_WalkE_02.mp3", 29},
			{852, "Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_WalkE_03.mp3", 28},
			{853, "Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_WalkE_04.mp3", 29},
			{854, "Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_WalkE_05.mp3", 28},
			{855, "Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_WalkF_01.mp3", 49},
			{856, "Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_WalkF_02.mp3", 47},
			{857, "Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_WalkF_03.mp3", 43},
			{858, "Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_WalkF_04.mp3", 48},
			{859, "Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_WalkF_05.mp3", 43},
			{860, "Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_WalkF_06.mp3", 43},
			{861, "Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_WalkF_07.mp3", 43},
			{862, "Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_WalkF_08.mp3", 42},
			{863, "Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_WalkG_01.mp3", 24},
			{864, "Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_WalkG_02.mp3", 24},
			{865, "Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_WalkG_03.mp3", 24},
			{866, "Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_WalkG_04.mp3", 23},
			{867, "Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_WalkG_05.mp3", 25},
			{868, "Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_WalkG_06.mp3", 24},
			{869, "Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_WalkJ_01.mp3", 82},
			{870, "Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_WalkJ_02.mp3", 82},
			{871, "Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_WalkJ_03.mp3", 81},
			{872, "Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_WalkJ_04.mp3", 82},
			{873, "Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_WalkJ_05.mp3", 82},
			{874, "Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_WalkJ_06.mp3", 82},
			{875, "Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_WalkM_01.mp3", 156},
			{876, "Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_WalkZ_01.mp3", 46},
			{877, "Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_WalkZ_02.mp3", 46},
		},
	},
	{
		id = 67,
		name = L["TITLE_WINTERGRASP"],
		files = {
			{878, "Sound\\Music\\ZoneMusic\\LakeWintergrasp\\WG_Contested_01.mp3", 40},
			{879, "Sound\\Music\\ZoneMusic\\LakeWintergrasp\\WG_Contested_02.mp3", 93},
			{880, "Sound\\Music\\ZoneMusic\\LakeWintergrasp\\WG_Contested_03.mp3", 57},
			{881, "Sound\\Music\\ZoneMusic\\LakeWintergrasp\\WG_GeneralWalk_01.mp3", 92},
			{882, "Sound\\Music\\ZoneMusic\\LakeWintergrasp\\WG_GeneralWalk_02.mp3", 62},
			{883, "Sound\\Music\\ZoneMusic\\LakeWintergrasp\\WG_GeneralWalk_03.mp3", 92},
			{884, "Sound\\Music\\ZoneMusic\\LakeWintergrasp\\WG_GeneralWalk_04.mp3", 43},
			{885, "Sound\\Music\\ZoneMusic\\LakeWintergrasp\\WG_GeneralWalk_05.mp3", 57},
		},
	},
	{
		id = 68,
		name = L["TITLE_NEXUS"],
		files = {
			{886, "Sound\\Music\\ZoneMusic\\Nexus\\NZ_NexusActionWalkUni01.mp3", 76},
			{887, "Sound\\Music\\ZoneMusic\\Nexus\\NZ_NexusActionWalkUni02.mp3", 68},
			{888, "Sound\\Music\\ZoneMusic\\Nexus\\NZ_NexusActionWalkUni03.mp3", 102},
			{889, "Sound\\Music\\ZoneMusic\\Nexus\\NZ_NexusActionWalkUni04.mp3", 107},
			{890, "Sound\\Music\\ZoneMusic\\Nexus\\NZ_NexusActionWalkUni05.mp3", 90},
			{891, "Sound\\Music\\ZoneMusic\\Nexus\\NZ_NexusHailWalkUni01.mp3", 57},
			{892, "Sound\\Music\\ZoneMusic\\Nexus\\NZ_NexusHailWalkUni02.mp3", 65},
			{893, "Sound\\Music\\ZoneMusic\\Nexus\\NZ_NexusPulseWalkUni01.mp3", 61},
			{894, "Sound\\Music\\ZoneMusic\\Nexus\\NZ_NexusPulseWalkUni02.mp3", 70},
			{895, "Sound\\Music\\ZoneMusic\\Nexus\\NZ_NexusQuietWalkUni01.mp3", 114},
			{896, "Sound\\Music\\ZoneMusic\\Nexus\\NZ_NexusQuietWalkUni02.mp3", 111},
			{897, "Sound\\Music\\ZoneMusic\\Nexus\\NZ_NexusQuietWalkUni03.mp3", 56},
			{898, "Sound\\Music\\ZoneMusic\\Nexus\\NZ_NexusQuietWalkUni04.mp3", 71},
		},
	},
	{
		id = 69,
		name = L["TITLE_IRONDWARVES"],
		files = {
			{899, "Sound\\Music\\ZoneMusic\\Northrend\\IronDwarf\\NR_Dwarf_GeneralWalkA_Day01.mp3", 99},
			{900, "Sound\\Music\\ZoneMusic\\Northrend\\IronDwarf\\NR_Dwarf_GeneralWalkA_Night01.mp3", 99},
			{901, "Sound\\Music\\ZoneMusic\\Northrend\\IronDwarf\\NR_Dwarf_GeneralWalkADark_Uni01.mp3", 112},
			{902, "Sound\\Music\\ZoneMusic\\Northrend\\IronDwarf\\NR_Dwarf_GeneralWalkB_Day02.mp3", 97},
			{903, "Sound\\Music\\ZoneMusic\\Northrend\\IronDwarf\\NR_Dwarf_GeneralWalkB_Night02.mp3", 95},
			{904, "Sound\\Music\\ZoneMusic\\Northrend\\IronDwarf\\NR_Dwarf_GeneralWalkB_Uni02.mp3", 164},
			{905, "Sound\\Music\\ZoneMusic\\Northrend\\IronDwarf\\NR_Dwarf_GeneralWalkC_Day03.mp3", 42},
			{906, "Sound\\Music\\ZoneMusic\\Northrend\\IronDwarf\\NR_Dwarf_GeneralWalkC_Night03.mp3", 42},
			{907, "Sound\\Music\\ZoneMusic\\Northrend\\IronDwarf\\NR_Dwarf_GeneralWalkC_Uni03.mp3", 42},
			{908, "Sound\\Music\\ZoneMusic\\Northrend\\IronDwarf\\NR_Dwarf_GeneralWalkCDark_Uni04.mp3", 82},
			{909, "Sound\\Music\\ZoneMusic\\Northrend\\IronDwarf\\NR_Dwarf_GeneralWalkD_Day04.mp3", 45},
			{910, "Sound\\Music\\ZoneMusic\\Northrend\\IronDwarf\\NR_Dwarf_GeneralWalkD_Night04.mp3", 45},
			{911, "Sound\\Music\\ZoneMusic\\Northrend\\IronDwarf\\NR_Dwarf_GeneralWalkDDark_Uni05.mp3", 69},
		},
	},
	{
		id = 70,
		name = L["TITLE_NR_TRANSPORT"],
		files = {
			{912, "Sound\\Music\\ZoneMusic\\Northrend\\NorthrendTransport\\NR_NorthrendTransportGeneralDay.mp3", 152},
			{913, "Sound\\Music\\ZoneMusic\\Northrend\\NorthrendTransport\\NR_NorthrendTransportGeneralNight.mp3", 92},
		},
	},
	{
		id = 71,
		name = L["TITLE_NR_ORCS"],
		files = {
			{914, "Sound\\Music\\ZoneMusic\\Northrend\\Orc\\NR_Orc_General_Intro01.mp3", 27},
			{915, "Sound\\Music\\ZoneMusic\\Northrend\\Orc\\NR_Orc_GeneralWalk_Day01.mp3", 23},
			{916, "Sound\\Music\\ZoneMusic\\Northrend\\Orc\\NR_Orc_GeneralWalk_Day02.mp3", 23},
			{917, "Sound\\Music\\ZoneMusic\\Northrend\\Orc\\NR_Orc_GeneralWalk_Day03.mp3", 23},
			{918, "Sound\\Music\\ZoneMusic\\Northrend\\Orc\\NR_Orc_GeneralWalk_Day04.mp3", 45},
			{919, "Sound\\Music\\ZoneMusic\\Northrend\\Orc\\NR_Orc_GeneralWalk_Night01.mp3", 78},
			{920, "Sound\\Music\\ZoneMusic\\Northrend\\Orc\\NR_Orc_GeneralWalk_Night02.mp3", 80},
			{921, "Sound\\Music\\ZoneMusic\\Northrend\\Orc\\NR_Orc_GeneralWalk_Night03.mp3", 79},
		},
	},
	{
		id = 72,
		name = L["TITLE_NR_TAUNKA"],
		files = {
			{922, "Sound\\Music\\ZoneMusic\\Northrend\\Taunka\\NR_Taunka_GeneralWalkA_Day01.mp3", 138},
			{923, "Sound\\Music\\ZoneMusic\\Northrend\\Taunka\\NR_Taunka_GeneralWalkA_Night01.mp3", 141},
			{924, "Sound\\Music\\ZoneMusic\\Northrend\\Taunka\\NR_Taunka_GeneralWalkA_Uni01.mp3", 140},
			{925, "Sound\\Music\\ZoneMusic\\Northrend\\Taunka\\NR_Taunka_GeneralWalkB_Day02.mp3", 127},
			{926, "Sound\\Music\\ZoneMusic\\Northrend\\Taunka\\NR_Taunka_GeneralWalkB_Night02.mp3", 127},
			{927, "Sound\\Music\\ZoneMusic\\Northrend\\Taunka\\NR_Taunka_GeneralWalkC_Day03.mp3", 108},
			{928, "Sound\\Music\\ZoneMusic\\Northrend\\Taunka\\NR_Taunka_GeneralWalkC_Night03.mp3", 108},
			{929, "Sound\\Music\\ZoneMusic\\Northrend\\Taunka\\NR_Taunka_GeneralWalkD_Day04.mp3", 70},
			{930, "Sound\\Music\\ZoneMusic\\Northrend\\Taunka\\NR_Taunka_GeneralWalkD_Night04.mp3", 69},
			{931, "Sound\\Music\\ZoneMusic\\Northrend\\Taunka\\NR_Taunka_GeneralWalkD_Uni02.mp3", 70},
			{932, "Sound\\Music\\ZoneMusic\\Northrend\\Taunka\\NR_Taunka_GeneralWalkE_Uni03.mp3", 73},
		},
	},
	{
		id = 73,
		name = L["TITLE_NR_TROLLS"],
		files = {
			{933, "Sound\\Music\\ZoneMusic\\Northrend\\Troll\\NR_Troll_General01.mp3", 46},
			{934, "Sound\\Music\\ZoneMusic\\Northrend\\Troll\\NR_Troll_General02.mp3", 55},
			{935, "Sound\\Music\\ZoneMusic\\Northrend\\Troll\\NR_Troll_General03.mp3", 38},
			{936, "Sound\\Music\\ZoneMusic\\Northrend\\Troll\\NR_Troll_General04.mp3", 44},
		},
	},
	{
		id = 74,
		name = L["TITLE_ULDUAR1"],
		files = {
			{937, "Sound\\Music\\ZoneMusic\\Ulduar\\UL_LightningBattleWalk.mp3", 52},
			{938, "Sound\\Music\\ZoneMusic\\Ulduar\\UL_LightningGeneralWalk01.mp3", 33},
			{939, "Sound\\Music\\ZoneMusic\\Ulduar\\UL_LightningGeneralWalk02.mp3", 40},
			{940, "Sound\\Music\\ZoneMusic\\Ulduar\\UL_LightningGeneralWalk03.mp3", 35},
			{941, "Sound\\Music\\ZoneMusic\\Ulduar\\UL_LightningIntro.mp3", 82},
			{942, "Sound\\Music\\ZoneMusic\\Ulduar\\UL_StoneBattleWalk.mp3", 52},
			{943, "Sound\\Music\\ZoneMusic\\Ulduar\\UL_StoneGeneralWalk01.mp3", 40},
			{944, "Sound\\Music\\ZoneMusic\\Ulduar\\UL_StoneGeneralWalk02.mp3", 40},
			{945, "Sound\\Music\\ZoneMusic\\Ulduar\\UL_StoneGeneralWalk03.mp3", 35},
			{946, "Sound\\Music\\ZoneMusic\\Ulduar\\UL_StoneIntro.mp3", 85},
		},
	},
	{
		id = 75,
		name = L["TITLE_ULDUAR2"],
		files = {
			{947, "Sound\\Music\\ZoneMusic\\UlduarRaidExt\\UR_UlduarRaidExtAction01.mp3", 31},
			{948, "Sound\\Music\\ZoneMusic\\UlduarRaidExt\\UR_UlduarRaidExtAction02.mp3", 137},
			{949, "Sound\\Music\\ZoneMusic\\UlduarRaidExt\\UR_UlduarRaidExtAction03.mp3", 136},
			{950, "Sound\\Music\\ZoneMusic\\UlduarRaidExt\\UR_UlduarRaidExtAction04.mp3", 53},
			{951, "Sound\\Music\\ZoneMusic\\UlduarRaidExt\\UR_UlduarRaidExtAction05.mp3", 93},
			{952, "Sound\\Music\\ZoneMusic\\UlduarRaidExt\\UR_UlduarRaidExtAction06.mp3", 93},
			{953, "Sound\\Music\\ZoneMusic\\UlduarRaidExt\\UR_UlduarRaidExtAction07.mp3", 40},
			{954, "Sound\\Music\\ZoneMusic\\UlduarRaidExt\\UR_UlduarRaidExtAction08.mp3", 40},
			{955, "Sound\\Music\\ZoneMusic\\UlduarRaidExt\\UR_UlduarRaidExtAction09.mp3", 28},
			{956, "Sound\\Music\\ZoneMusic\\UlduarRaidExt\\UR_UlduarRaidExtAction10.mp3", 28},
			{957, "Sound\\Music\\ZoneMusic\\UlduarRaidExt\\UR_UlduarRaidExtAction11.mp3", 27},
			{958, "Sound\\Music\\ZoneMusic\\UlduarRaidExt\\UR_UlduarRaidExtAction12.mp3", 28},
			{959, "Sound\\Music\\ZoneMusic\\UlduarRaidExt\\UR_UlduarRaidExtAction13.mp3", 27},
			{960, "Sound\\Music\\ZoneMusic\\UlduarRaidExt\\UR_UlduarRaidExtAction14.mp3", 36},
			{961, "Sound\\Music\\ZoneMusic\\UlduarRaidExt\\UR_UlduarRaidExtAction15.mp3", 36},
			{962, "Sound\\Music\\ZoneMusic\\UlduarRaidExt\\UR_UlduarRaidExtAction16.mp3", 36},
			{963, "Sound\\Music\\ZoneMusic\\UlduarRaidExt\\UR_UlduarRaidExtIntro01.mp3", 12},
			{964, "Sound\\Music\\ZoneMusic\\UlduarRaidExt\\UR_UlduarRaidExtIntro02.mp3", 14},
			{965, "Sound\\Music\\ZoneMusic\\UlduarRaidExt\\UR_UlduarRaidExtIntro03.mp3", 14},
			{966, "Sound\\Music\\ZoneMusic\\UlduarRaidExt\\UR_UlduarRaidExtIntro04.mp3", 17},
			{967, "Sound\\Music\\ZoneMusic\\UlduarRaidExt\\UR_UlduarRaidExtIntro05.mp3", 13},
			{968, "Sound\\Music\\ZoneMusic\\UlduarRaidExt\\UR_UlduarRaidExtIntro06.mp3", 13},
			{969, "Sound\\Music\\ZoneMusic\\UlduarRaidExt\\UR_UlduarRaidExtIntro07.mp3", 12},
			{970, "Sound\\Music\\ZoneMusic\\UlduarRaidExt\\UR_UlduarRaidExtIntro08.mp3", 26},
			{971, "Sound\\Music\\ZoneMusic\\UlduarRaidExt\\UR_UlduarRaidExtIntro09.mp3", 25},
			{972, "Sound\\Music\\ZoneMusic\\UlduarRaidExt\\UR_UlduarRaidExtWalk01.mp3", 36},
			{973, "Sound\\Music\\ZoneMusic\\UlduarRaidExt\\UR_UlduarRaidExtWalk02.mp3", 33},
			{974, "Sound\\Music\\ZoneMusic\\UlduarRaidExt\\UR_UlduarRaidExtWalk03.mp3", 87},
			{975, "Sound\\Music\\ZoneMusic\\UlduarRaidExt\\UR_UlduarRaidExtWalk04.mp3", 87},
			{976, "Sound\\Music\\ZoneMusic\\UlduarRaidExt\\UR_UlduarRaidExtWalk05.mp3", 87},
			{977, "Sound\\Music\\ZoneMusic\\UlduarRaidExt\\UR_UlduarRaidExtWalk06.mp3", 26},
			{978, "Sound\\Music\\ZoneMusic\\UlduarRaidExt\\UR_UlduarRaidExtWalk07.mp3", 57},
			{979, "Sound\\Music\\ZoneMusic\\UlduarRaidExt\\UR_UlduarRaidExtWalk08.mp3", 53},
			{980, "Sound\\Music\\ZoneMusic\\UlduarRaidExt\\UR_UlduarRaidExtWalk09.mp3", 27},
			{981, "Sound\\Music\\ZoneMusic\\UlduarRaidExt\\UR_UlduarRaidExtWalk10.mp3", 28},
			{982, "Sound\\Music\\ZoneMusic\\UlduarRaidExt\\UR_UlduarRaidExtWalk11.mp3", 28},
		},
	},
	{
		id = 76,
		name = L["TITLE_ULDUAR3"],
		files = {
			{983, "Sound\\Music\\ZoneMusic\\UlduarRaidInt\\UR_AlgalonBattle01Walk.mp3", 162},
			{984, "Sound\\Music\\ZoneMusic\\UlduarRaidInt\\UR_AlgalonBattle02Walk.mp3", 131},
			{985, "Sound\\Music\\ZoneMusic\\UlduarRaidInt\\UR_AlgalonHeroIntro.mp3", 148},
			{986, "Sound\\Music\\ZoneMusic\\UlduarRaidInt\\UR_AlgalonPlanetaryHallWalk.mp3", 148},
			{987, "Sound\\Music\\ZoneMusic\\UlduarRaidInt\\UR_AlgalonVoicesWalk.mp3", 148},
			{988, "Sound\\Music\\ZoneMusic\\UlduarRaidInt\\UR_FourSigilsHallWalk.mp3", 123},
			{989, "Sound\\Music\\ZoneMusic\\UlduarRaidInt\\UR_FourSigilsHeroIntro.mp3", 218},
			{990, "Sound\\Music\\ZoneMusic\\UlduarRaidInt\\UR_HallsInstrumentalWalk.mp3", 115},
			{991, "Sound\\Music\\ZoneMusic\\UlduarRaidInt\\UR_HallsofIronHeroEvent.mp3", 196},
			{992, "Sound\\Music\\ZoneMusic\\UlduarRaidInt\\UR_HallsPastWalk.mp3", 112},
			{993, "Sound\\Music\\ZoneMusic\\UlduarRaidInt\\UR_MimironBWalk.mp3", 172},
			{994, "Sound\\Music\\ZoneMusic\\UlduarRaidInt\\UR_MimironCWalk.mp3", 97},
			{995, "Sound\\Music\\ZoneMusic\\UlduarRaidInt\\UR_MimironDWalk.mp3", 96},
			{996, "Sound\\Music\\ZoneMusic\\UlduarRaidInt\\UR_MimironEWalk.mp3", 82},
			{997, "Sound\\Music\\ZoneMusic\\UlduarRaidInt\\UR_MimironFWalk.mp3", 179},
			{998, "Sound\\Music\\ZoneMusic\\UlduarRaidInt\\UR_MimironGhostsWalk.mp3", 179},
			{999, "Sound\\Music\\ZoneMusic\\UlduarRaidInt\\UR_MimironHeroIntro.mp3", 172},
			{1000, "Sound\\Music\\ZoneMusic\\UlduarRaidInt\\UR_SigilGhostsWalk.mp3", 75},
			{1001, "Sound\\Music\\ZoneMusic\\UlduarRaidInt\\UR_TitanGhostsWalk.mp3", 113},
			{1002, "Sound\\Music\\ZoneMusic\\UlduarRaidInt\\UR_TitanHallsHeroWalk.mp3", 113},
			{1003, "Sound\\Music\\ZoneMusic\\UlduarRaidInt\\UR_TitanMechWalk.mp3", 127},
			{1004, "Sound\\Music\\ZoneMusic\\UlduarRaidInt\\UR_TitanOrchestraIntro.mp3", 102},
			{1005, "Sound\\Music\\ZoneMusic\\UlduarRaidInt\\UR_TitanSigilsWalk.mp3", 57},
			{1006, "Sound\\Music\\ZoneMusic\\UlduarRaidInt\\UR_TitanYoggWalk.mp3", 94},
			{1007, "Sound\\Music\\ZoneMusic\\UlduarRaidInt\\UR_UlduarToneWalk.mp3", 106},
			{1008, "Sound\\Music\\ZoneMusic\\UlduarRaidInt\\UR_YoggLiteWalk.mp3", 105},
			{1009, "Sound\\Music\\ZoneMusic\\UlduarRaidInt\\UR_YoggSaronHeroIntro.mp3", 105},
			{1010, "Sound\\Music\\ZoneMusic\\UlduarRaidInt\\UR_YoggWoodsWalk.mp3", 82},
		},
	},
	{
		id = 77,
		name = L["TITLE_UTGARDEKEEP"],
		files = {
			{1011, "Sound\\Music\\ZoneMusic\\Utgarde Keep\\UK_GeneralWalkUni01.mp3", 56},
			{1012, "Sound\\Music\\ZoneMusic\\Utgarde Keep\\UK_GeneralWalkUni02.mp3", 52},
			{1013, "Sound\\Music\\ZoneMusic\\Utgarde Keep\\UK_GeneralWalkUni03.mp3", 54},
			{1014, "Sound\\Music\\ZoneMusic\\Utgarde Keep\\UK_GeneralWalkUni04.mp3", 26},
			{1015, "Sound\\Music\\ZoneMusic\\Utgarde Keep\\UK_GeneralWalkUni05.mp3", 30},
			{1016, "Sound\\Music\\ZoneMusic\\Utgarde Keep\\UK_QuietWalkUni01.mp3", 108},
			{1017, "Sound\\Music\\ZoneMusic\\Utgarde Keep\\UK_QuietWalkUni02.mp3", 107},
		},
	},
	{
		id = 78,
		name = L["TITLE_VIOLETHOLD"],
		files = {
			{1018, "Sound\\Music\\ZoneMusic\\VioletHold\\VH_GeneralWalkUni01.mp3", 83},
			{1019, "Sound\\Music\\ZoneMusic\\VioletHold\\VH_GeneralWalkUni02.mp3", 83},
			{1020, "Sound\\Music\\ZoneMusic\\VioletHold\\VH_GeneralWalkUni03.mp3", 69},
		},
	},
	{
		id = 79,
		name = L["TITLE_ZULDRAK"],
		files = {
			{1021, "Sound\\Music\\ZoneMusic\\ZulDrak\\ZD_GeneralIntro_01.mp3", 98},
			{1022, "Sound\\Music\\ZoneMusic\\ZulDrak\\ZD_GeneralIntro_02.mp3", 98},
			{1023, "Sound\\Music\\ZoneMusic\\ZulDrak\\ZD_GeneralIntro_03.mp3", 128},
			{1024, "Sound\\Music\\ZoneMusic\\ZulDrak\\ZD_GeneralIntro_04.mp3", 126},
			{1025, "Sound\\Music\\ZoneMusic\\ZulDrak\\ZD_GeneralIntro_05.mp3", 129},
			{1026, "Sound\\Music\\ZoneMusic\\ZulDrak\\ZD_GeneralIntro_06.mp3", 125},
			{1027, "Sound\\Music\\ZoneMusic\\ZulDrak\\ZD_GeneralWalk_Day01.mp3", 89},
			{1028, "Sound\\Music\\ZoneMusic\\ZulDrak\\ZD_GeneralWalk_Day02.mp3", 90},
			{1029, "Sound\\Music\\ZoneMusic\\ZulDrak\\ZD_GeneralWalk_Day03.mp3", 101},
			{1030, "Sound\\Music\\ZoneMusic\\ZulDrak\\ZD_GeneralWalk_Day04.mp3", 92},
			{1031, "Sound\\Music\\ZoneMusic\\ZulDrak\\ZD_GeneralWalk_Night01.mp3", 90},
			{1032, "Sound\\Music\\ZoneMusic\\ZulDrak\\ZD_GeneralWalk_Night02.mp3", 90},
			{1033, "Sound\\Music\\ZoneMusic\\ZulDrak\\ZD_GeneralWalk_Night03.mp3", 101},
			{1034, "Sound\\Music\\ZoneMusic\\ZulDrak\\ZD_GeneralWalk_Night04.mp3", 93},
			{1035, "Sound\\Music\\ZoneMusic\\ZulDrak\\ZD_HarKoa_Intro01.mp3", 28},
			{1036, "Sound\\Music\\ZoneMusic\\ZulDrak\\ZD_HarKoa_Intro02.mp3", 27},
			{1037, "Sound\\Music\\ZoneMusic\\ZulDrak\\ZD_MamToth_Intro01.mp3", 30},
			{1038, "Sound\\Music\\ZoneMusic\\ZulDrak\\ZD_MamToth_Intro02.mp3", 27},
			{1039, "Sound\\Music\\ZoneMusic\\ZulDrak\\ZD_QuetzLun_Intro01.mp3", 32},
			{1040, "Sound\\Music\\ZoneMusic\\ZulDrak\\ZD_QuetzLun_Intro02.mp3", 27},
			{1041, "Sound\\Music\\ZoneMusic\\ZulDrak\\ZD_Rhunok_Intro01.mp3", 30},
			{1042, "Sound\\Music\\ZoneMusic\\ZulDrak\\ZD_Rhunok_Intro02.mp3", 27},
			{1043, "Sound\\Music\\ZoneMusic\\ZulDrak\\ZD_Sseratus_Intro01.mp3", 28},
			{1044, "Sound\\Music\\ZoneMusic\\ZulDrak\\ZD_Sseratus_Intro02.mp3", 27},
		},
	},
	{
		id = 80,
		name = L["TITLE_CULLINGSTRAT"],
		files = {
			{1045, "Sound\\Music\\ZoneMusic\\StratholmePast\\CT_StratholmePastAlleyEnd.mp3", 28},
			{1046, "Sound\\Music\\ZoneMusic\\StratholmePast\\CT_StratholmePastAlleyIntro.mp3", 99},
			{1047, "Sound\\Music\\ZoneMusic\\StratholmePast\\CT_StratholmePastBattleWalk01.mp3", 94},
			{1048, "Sound\\Music\\ZoneMusic\\StratholmePast\\CT_StratholmePastBattleWalk02.mp3", 36},
			{1049, "Sound\\Music\\ZoneMusic\\StratholmePast\\CT_StratholmePastBattleWalk03.mp3", 36},
			{1050, "Sound\\Music\\ZoneMusic\\StratholmePast\\CT_StratholmePastEndStinger.mp3", 28},
			{1051, "Sound\\Music\\ZoneMusic\\StratholmePast\\CT_StratholmePastIndoorsIntro.mp3", 99},
			{1052, "Sound\\Music\\ZoneMusic\\StratholmePast\\CT_StratholmePastIntro.mp3", 32},
			{1053, "Sound\\Music\\ZoneMusic\\StratholmePast\\CT_StratholmePastMalGanis.mp3", 67},
			{1054, "Sound\\Music\\ZoneMusic\\StratholmePast\\CT_StratholmePastOutdoorsIntro.mp3", 37},
			{1055, "Sound\\Music\\ZoneMusic\\StratholmePast\\CT_StratholmePastOutdoorsWalkANight.mp3", 32},
			{1056, "Sound\\Music\\ZoneMusic\\StratholmePast\\CT_StratholmePastOutdoorsWalkAUni.mp3", 32},
			{1057, "Sound\\Music\\ZoneMusic\\StratholmePast\\CT_StratholmePastOutdoorsWalkBNight.mp3", 36},
			{1058, "Sound\\Music\\ZoneMusic\\StratholmePast\\CT_StratholmePastOutdoorsWalkBUni.mp3", 37},
			{1059, "Sound\\Music\\ZoneMusic\\StratholmePast\\CT_StratholmePastWalkUni.mp3", 102},
		},
	},
	{
		id = 81,
		name = L["TITLE_OBSIDIAN_SANCTUM"],
		files = {
			{1060, "Sound\\Music\\ZoneMusic\\OS1.mp3", 82},
			{1061, "Sound\\Music\\ZoneMusic\\OS2.mp3", 86},
			{1062, "Sound\\Music\\ZoneMusic\\OS3.mp3", 119},
			{1063, "Sound\\Music\\ZoneMusic\\OS4.mp3", 57},
			{1064, "Sound\\Music\\ZoneMusic\\OS5.mp3", 87},
		},
	},
}

GJB.musictable[GJB.EXP_WOTLK] = music
