-- STRUCTURE 
-- [1] : Integer - ID of the music (new system)
-- [2] : String - Path of the music file
-- [3] : Integer - Length of the music file in seconds

-- Get localization
local GJB = LibStub("AceAddon-3.0"):GetAddon("GarrisonJukeBox")
local L = GJB.L -- local L = LibStub("AceLocale-3.0"):GetLocale("GarrisonJukeBox")

-- Mists of Pandaria
local music = {
	{
		id = 142,
		name = L["TITLE_MAIN_THEME"],
		files = {
			{1600, "Sound\\Music\\Pandaria\\MUS_50_HeartofPandaria_01.mp3", 480},
		},
	},
	{
		id = 143,
		name = L["TITLE_MOGU"],
		files = {
			{1601, "Sound\\Music\\Pandaria\\FlyBy_52_MoguBridge_MX_SFX.mp3", 42},
			{1602, "Sound\\Music\\Pandaria\\FlyBy_52_MoguSecret_MX_SFX.mp3", 27},
			{1603, "Sound\\Music\\Pandaria\\MUS_50_Mogu_A_Hero_01.mp3", 85},
			{1604, "Sound\\Music\\Pandaria\\MUS_50_Mogu_A_Hero_02.mp3", 90},
			{1605, "Sound\\Music\\Pandaria\\MUS_50_Mogu_B_01.mp3", 92},
			{1606, "Sound\\Music\\Pandaria\\MUS_50_Mogu_B_02.mp3", 34},
			{1607, "Sound\\Music\\Pandaria\\MUS_50_Mogu_B_03.mp3", 77},
			{1608, "Sound\\Music\\Pandaria\\MUS_50_Mogu_B_04.mp3", 61},
			{1609, "Sound\\Music\\Pandaria\\MUS_50_Mogu_B_05.mp3", 80},
			{1610, "Sound\\Music\\Pandaria\\MUS_50_Mogu_B_06.mp3", 82},
			{1611, "Sound\\Music\\Pandaria\\MUS_50_Mogu_B_Hero_01.mp3", 138},
			{1612, "Sound\\Music\\Pandaria\\MUS_52_AncientMogu_A_01.mp3", 128},
			{1613, "Sound\\Music\\Pandaria\\MUS_52_AncientMogu_A_02.mp3", 61},
			{1614, "Sound\\Music\\Pandaria\\MUS_52_AncientMogu_A_03.mp3", 59},
			{1615, "Sound\\Music\\Pandaria\\MUS_52_AncientMogu_A_04.mp3", 71},
			{1616, "Sound\\Music\\Pandaria\\MUS_52_AncientMogu_A_Hero_01.mp3", 133},
			{1617, "Sound\\Music\\Pandaria\\MUS_52_AncientMogu_B_01.mp3", 46},
			{1618, "Sound\\Music\\Pandaria\\MUS_52_AncientMogu_B_Hero_01.mp3", 58},
			{1619, "Sound\\Music\\Pandaria\\MUS_52_AncientMogu_B_Stinger_01.mp3", 9},
			{1620, "Sound\\Music\\Pandaria\\MUS_52_AncientMogu_C_01.mp3", 83},
			{1621, "Sound\\Music\\Pandaria\\MUS_52_AncientMogu_C_02.mp3", 78},
			{1622, "Sound\\Music\\Pandaria\\MUS_52_AncientMogu_C_03.mp3", 26},
			{1623, "Sound\\Music\\Pandaria\\MUS_52_AncientMogu_C_04.mp3", 186},
			{1624, "Sound\\Music\\Pandaria\\MUS_52_AncientMogu_C_05.mp3", 155},
			{1625, "Sound\\Music\\Pandaria\\MUS_52_AncientMogu_C_06.mp3", 141},
			{1626, "Sound\\Music\\Pandaria\\MUS_52_AncientMogu_C_Hero_01.mp3", 167},
			{1627, "Sound\\Music\\Pandaria\\MUS_52_AncientMogu_C_Stinger_01.mp3", 13},
			{1628, "Sound\\Music\\Pandaria\\MUS_52_AncientMogu_C_Stinger_02.mp3", 14},
			{1629, "Sound\\Music\\Pandaria\\MUS_52_AncientMogu_D_01.mp3", 112},
			{1630, "Sound\\Music\\Pandaria\\MUS_52_AncientMogu_D_02.mp3", 85},
			{1631, "Sound\\Music\\Pandaria\\MUS_52_AncientMogu_D_Hero_01.mp3", 117},
			{1632, "Sound\\Music\\Pandaria\\MUS_52_AncientPandaria_A_01.mp3", 100},
			{1633, "Sound\\Music\\Pandaria\\MUS_52_AncientPandaria_Hero_01.mp3", 100},
			{1634, "Sound\\Music\\Pandaria\\MUS_52_GodsAndMonster_01.mp3", 159},
		},
	},
	{
		id = 144,
		name = L["TITLE_AUGUSTCELESTIALS"],
		files = {
			{1635, "Sound\\Music\\Pandaria\\MUS_50_AugustCelestials_01.mp3", 61},
			{1636, "Sound\\Music\\Pandaria\\MUS_50_AugustCelestials_02.mp3", 65},
			{1637, "Sound\\Music\\Pandaria\\MUS_50_AugustCelestials_03.mp3", 59},
			{1638, "Sound\\Music\\Pandaria\\MUS_50_AugustCelestials_04.mp3", 91},
			{1639, "Sound\\Music\\Pandaria\\MUS_50_AugustCelestials_05.mp3", 150},
			{1640, "Sound\\Music\\Pandaria\\MUS_50_AugustCelestials_Hero_01.mp3", 130},
			{1641, "Sound\\Music\\Pandaria\\MUS_50_BalloonRide_Hero_01.mp3", 169},
		},
	},
	{
		id = 145,
		name = L["TITLE_BAMBOO"],
		files = {
			{1642, "Sound\\Music\\Pandaria\\MUS_50_Bamboo_01.mp3", 46},
			{1643, "Sound\\Music\\Pandaria\\MUS_50_Bamboo_02.mp3", 52},
			{1644, "Sound\\Music\\Pandaria\\MUS_50_Bamboo_03.mp3", 69},
			{1645, "Sound\\Music\\Pandaria\\MUS_50_Bamboo_04.mp3", 98},
			{1646, "Sound\\Music\\Pandaria\\MUS_50_Bamboo_Hero_01.mp3", 88},
			{1647, "Sound\\Music\\Pandaria\\MUS_50_Bamboo_Night_01.mp3", 61},
			{1648, "Sound\\Music\\Pandaria\\MUS_50_Bamboo_Night_Hero_01.mp3", 102},
		},
	},
	{
		id = 146,
		name = L["TITLE_BATTLE4PANDARIA"],
		files = {
			{1649, "Sound\\Music\\Pandaria\\MUS_50_BattleforPandaria_Hero_01.mp3", 67},
			{1650, "Sound\\Music\\Pandaria\\MUS_50_BattleforPandaria_Hero_02.mp3", 61},
		},
	},
	{
		id = 147,
		name = L["TITLE_BREWING"],
		files = {
			{1651, "Sound\\Music\\Pandaria\\MUS_50_BottomsUp_01.mp3", 87},
			{1652, "Sound\\Music\\Pandaria\\MUS_50_BottomsUp_Hero_01.mp3", 88},
			{1653, "Sound\\Music\\Pandaria\\MUS_50_Darkbrew_01.mp3", 88},
			{1654, "Sound\\Music\\Pandaria\\MUS_50_Darkbrew_Hero_01.mp3", 61},
		},
	},
	{
		id = 148,
		name = L["TITLE_DREADWASTES"],
		files = {
			{1655, "Sound\\Music\\Pandaria\\MUS_50_DreadWastes_A_Hero_01.mp3", 84},
			{1656, "Sound\\Music\\Pandaria\\MUS_50_DreadWastes_A_Hero_02.mp3", 72},
			{1657, "Sound\\Music\\Pandaria\\MUS_50_Mantid_A_01.mp3", 35},
			{1658, "Sound\\Music\\Pandaria\\MUS_50_Mantid_A_02.mp3", 88},
			{1659, "Sound\\Music\\Pandaria\\MUS_50_Mantid_A_03.mp3", 109},
			{1660, "Sound\\Music\\Pandaria\\MUS_50_Mantid_A_Hero_01.mp3", 95},
		},
	},
	{
		id = 149,
		name = L["TITLE_GATE_OT_SETTING_SUN"],
		files = {
			{1661, "Sound\\Music\\Pandaria\\MUS_50_GateoftheSettingSun_B_01.mp3", 97},
			{1662, "Sound\\Music\\Pandaria\\MUS_50_GateoftheSettingSun_B_Hero_01.mp3", 81},
			{1663, "Sound\\Music\\Pandaria\\MUS_50_GateoftheSettingSun_B_Hero_02.mp3", 52},
		},
	},
	{
		id = 150,
		name = L["TITLE_HOZEN"],
		files = {
			{1664, "Sound\\Music\\Pandaria\\MUS_50_Hozen_A_01.mp3", 57},
			{1665, "Sound\\Music\\Pandaria\\MUS_50_Hozen_A_02.mp3", 34},
			{1666, "Sound\\Music\\Pandaria\\MUS_50_Hozen_A_03.mp3", 42},
			{1667, "Sound\\Music\\Pandaria\\MUS_50_Hozen_A_04.mp3", 50},
			{1668, "Sound\\Music\\Pandaria\\MUS_50_Hozen_A_05.mp3", 78},
			{1669, "Sound\\Music\\Pandaria\\MUS_50_Hozen_A_06.mp3", 105},
			{1670, "Sound\\Music\\Pandaria\\MUS_50_Hozen_A_07.mp3", 32},
			{1671, "Sound\\Music\\Pandaria\\MUS_50_Hozen_A_08.mp3", 30},
			{1672, "Sound\\Music\\Pandaria\\MUS_50_Hozen_A_09.mp3", 40},
			{1673, "Sound\\Music\\Pandaria\\MUS_50_Hozen_A_10.mp3", 58},
			{1674, "Sound\\Music\\Pandaria\\MUS_50_Hozen_A_11.mp3", 68},
			{1675, "Sound\\Music\\Pandaria\\MUS_50_Hozen_A_12.mp3", 55},
			{1676, "Sound\\Music\\Pandaria\\MUS_50_Hozen_A_13.mp3", 31},
			{1677, "Sound\\Music\\Pandaria\\MUS_50_Hozen_A_Hero_01.mp3", 108},
			{1678, "Sound\\Music\\Pandaria\\MUS_50_Hozen_B_01.mp3", 49},
			{1679, "Sound\\Music\\Pandaria\\MUS_50_Hozen_B_02.mp3", 49},
			{1680, "Sound\\Music\\Pandaria\\MUS_50_Hozen_B_03.mp3", 49},
			{1681, "Sound\\Music\\Pandaria\\MUS_50_Hozen_B_Hero_01.mp3", 49},
			{1682, "Sound\\Music\\Pandaria\\MUS_50_Hozen_Walk_01.mp3", 75},
		},
	},
	{
		id = 151,
		name = L["TITLE_RSASARANGWILDS"],
		files = {
			{1683, "Sound\\Music\\Pandaria\\MUS_50_KrasarangWilds_A_Hero_01.mp3", 90},
			{1684, "Sound\\Music\\Pandaria\\MUS_50_KrasarangWilds_A_Hero_02.mp3", 75},
			{1685, "Sound\\Music\\Pandaria\\MUS_50_KrasarangWilds_B_Hero_01.mp3", 82},
			{1686, "Sound\\Music\\Pandaria\\MUS_50_KrasarangWilds_B_Hero_02.mp3", 60},
			{1687, "Sound\\Music\\Pandaria\\MUS_50_KrasarangWilds_B_Hero_03.mp3", 70},
		},
	},
	{
		id = 152,
		name = L["TITLE_KUNLAISUMMIT"],
		files = {
			{1688, "Sound\\Music\\Pandaria\\MUS_50_KunLaiSummit_A_Hero_01.mp3", 51},
			{1689, "Sound\\Music\\Pandaria\\MUS_50_KunLaiSummit_A_Hero_02.mp3", 64},
			{1690, "Sound\\Music\\Pandaria\\MUS_50_KunLaiSummit_A_Hero_03.mp3", 79},
			{1691, "Sound\\Music\\Pandaria\\MUS_50_KunLaiSummit_A_Hero_04.mp3", 46},
			{1692, "Sound\\Music\\Pandaria\\MUS_50_KunLaiSummit_B_Hero_01.mp3", 158},
			{1693, "Sound\\Music\\Pandaria\\MUS_50_KunLaiSummit_C_Hero_01.mp3", 72},
			{1694, "Sound\\Music\\Pandaria\\MUS_50_KunLaiSummit_C_Hero_02.mp3", 77},
		},
	},
	{
		id = 153,
		name = L["TITLE_MONKS"],
		files = {
			{1695, "Sound\\Music\\Pandaria\\MUS_50_Monk_Brewmaster_A_01.mp3", 87},
			{1696, "Sound\\Music\\Pandaria\\MUS_50_Monk_Brewmaster_A_Hero_01.mp3", 79},
			{1697, "Sound\\Music\\Pandaria\\MUS_50_Monk_Mistweaver_A_01.mp3", 124},
			{1698, "Sound\\Music\\Pandaria\\MUS_50_Monk_Mistweaver_A_02.mp3", 91},
			{1699, "Sound\\Music\\Pandaria\\MUS_50_Monk_Mistweaver_A_03.mp3", 92},
			{1700, "Sound\\Music\\Pandaria\\MUS_50_Monk_Mistweaver_A_Hero_01.mp3", 48},
			{1701, "Sound\\Music\\Pandaria\\MUS_50_Monk_Mistweaver_A_Hero_02.mp3", 79},
			{1702, "Sound\\Music\\Pandaria\\MUS_50_Monk_Mistweaver_A_Walk_01.mp3", 69},
			{1703, "Sound\\Music\\Pandaria\\MUS_50_Monk_Mistweaver_A_Walk_02.mp3", 59},
			{1704, "Sound\\Music\\Pandaria\\MUS_50_Monk_Mistweaver_B_01.mp3", 89},
			{1705, "Sound\\Music\\Pandaria\\MUS_50_Monk_Mistweaver_B_02.mp3", 91},
			{1706, "Sound\\Music\\Pandaria\\MUS_50_Monk_Mistweaver_B_03.mp3", 66},
			{1707, "Sound\\Music\\Pandaria\\MUS_50_Monk_Mistweaver_B_04.mp3", 70},
			{1708, "Sound\\Music\\Pandaria\\MUS_50_Monk_Mistweaver_B_Hero_01.mp3", 87},
			{1709, "Sound\\Music\\Pandaria\\MUS_50_Monk_Windwalker_A_01.mp3", 157},
			{1710, "Sound\\Music\\Pandaria\\MUS_50_Monk_Windwalker_A_02.mp3", 105},
			{1711, "Sound\\Music\\Pandaria\\MUS_50_Monk_Windwalker_A_03.mp3", 68},
			{1712, "Sound\\Music\\Pandaria\\MUS_50_Monk_Windwalker_A_Hero_01.mp3", 93},
			{1713, "Sound\\Music\\Pandaria\\MUS_50_Monk_Windwalker_A_Hero_02.mp3", 81},
			{1714, "Sound\\Music\\Pandaria\\MUS_50_Monk_Windwalker_A_Walk_01.mp3", 108},
			{1715, "Sound\\Music\\Pandaria\\MUS_50_Monk_Windwalker_A_Walk_02.mp3", 118},
			{1716, "Sound\\Music\\Pandaria\\MUS_50_Monk_Windwalker_A_Walk_03.mp3", 94},
			{1717, "Sound\\Music\\Pandaria\\MUS_50_Monk_Windwalker_A_Walk_04.mp3", 71},
		},
	},
	{
		id = 154,
		name = L["TITLE_PANDARIA"],
		files = {
			{1718, "Sound\\Music\\Pandaria\\MUS_50_Pandaria_A_01.mp3", 38},
			{1719, "Sound\\Music\\Pandaria\\MUS_50_Pandaria_A_02.mp3", 53},
			{1720, "Sound\\Music\\Pandaria\\MUS_50_Pandaria_A_03.mp3", 79},
			{1721, "Sound\\Music\\Pandaria\\MUS_50_Pandaria_A_Choir_01.mp3", 92},
			{1722, "Sound\\Music\\Pandaria\\MUS_50_Pandaria_A_Hero_01.mp3", 91},
			{1723, "Sound\\Music\\Pandaria\\MUS_50_Pandaria_B_01.mp3", 55},
			{1724, "Sound\\Music\\Pandaria\\MUS_50_Pandaria_B_Hero_01.mp3", 80},
			{1725, "Sound\\Music\\Pandaria\\MUS_50_Pandaria_B_Hero_02.mp3", 71},
			{1726, "Sound\\Music\\Pandaria\\MUS_50_Pandaria_C_Hero_01.mp3", 43},
			{1727, "Sound\\Music\\Pandaria\\MUS_50_Pandaria_C_Hero_02.mp3", 75},
			{1728, "Sound\\Music\\Pandaria\\MUS_50_Pandaria_C_Hero_03.mp3", 67},
			{1729, "Sound\\Music\\Pandaria\\MUS_50_Pandaria_C_Walk_01.mp3", 69},
			{1730, "Sound\\Music\\Pandaria\\MUS_50_Pandaria_C_Walk_02.mp3", 63},
			{1731, "Sound\\Music\\Pandaria\\MUS_50_Pandaria_C_Walk_03.mp3", 110},
			{1732, "Sound\\Music\\Pandaria\\MUS_50_Pandaria_D_01.mp3", 53},
			{1733, "Sound\\Music\\Pandaria\\MUS_50_Pandaria_D_02.mp3", 60},
			{1734, "Sound\\Music\\Pandaria\\MUS_50_Pandaria_D_03.mp3", 43},
			{1735, "Sound\\Music\\Pandaria\\MUS_50_Pandaria_D_Hero_01.mp3", 116},
			{1736, "Sound\\Music\\Pandaria\\MUS_50_PandariaPVP_Hero_01.mp3", 134},
			{1737, "Sound\\Music\\Pandaria\\MUS_50_PandariaPVP_Hero_02.mp3", 66},
		},
	},
	{
		id = 155,
		name = L["TITLE_SCARLETMONASTERY"],
		files = {
			{1738, "Sound\\Music\\Pandaria\\MUS_50_ScarletMonastery_A_Hero_01.mp3", 83},
			{1739, "Sound\\Music\\Pandaria\\MUS_50_ScarletMonastery_A_Hero_02.mp3", 54},
			{1740, "Sound\\Music\\Pandaria\\MUS_50_ScarletMonastery_A_Hero_03.mp3", 117},
		},
	},
	{
		id = 156,
		name = L["TITLE_SCHOLOMANCE"],
		files = {
			{1741, "Sound\\Music\\Pandaria\\MUS_50_Scholomance_A_01.mp3", 59},
			{1742, "Sound\\Music\\Pandaria\\MUS_50_Scholomance_A_02.mp3", 68},
			{1743, "Sound\\Music\\Pandaria\\MUS_50_Scholomance_A_03.mp3", 61},
			{1744, "Sound\\Music\\Pandaria\\MUS_50_Scholomance_A_04.mp3", 78},
			{1745, "Sound\\Music\\Pandaria\\MUS_50_Scholomance_A_05.mp3", 67},
			{1746, "Sound\\Music\\Pandaria\\MUS_50_Scholomance_A_06.mp3", 81},
			{1747, "Sound\\Music\\Pandaria\\MUS_50_Scholomance_A_07.mp3", 74},
			{1748, "Sound\\Music\\Pandaria\\MUS_50_Scholomance_A_08.mp3", 78},
			{1749, "Sound\\Music\\Pandaria\\MUS_50_Scholomance_A_09.mp3", 91},
			{1750, "Sound\\Music\\Pandaria\\MUS_50_Scholomance_A_10.mp3", 84},
			{1751, "Sound\\Music\\Pandaria\\MUS_50_Scholomance_A_11.mp3", 58},
			{1752, "Sound\\Music\\Pandaria\\MUS_50_Scholomance_A_12.mp3", 103},
		},
	},
	{
		id = 157,
		name = L["TITLE_SERPENTHEART"],
		files = {
			{1753, "Sound\\Music\\Pandaria\\MUS_50_SerpentsHeart_Hero_01.mp3", 93},
			{1754, "Sound\\Music\\Pandaria\\MUS_50_SerpentsHeart_Hero_02.mp3", 84},
			{1755, "Sound\\Music\\Pandaria\\MUS_50_SerpentsHeart_Hero_03.mp3", 93},
			{1756, "Sound\\Music\\Pandaria\\MUS_50_SerpentsHeart_Night_Hero_01.mp3", 110},
			{1757, "Sound\\Music\\Pandaria\\MUS_50_SerpentsHeart_Night_Hero_02.mp3", 91},
			{1758, "Sound\\Music\\Pandaria\\MUS_50_SerpentsHeart_Night_Walk_01.mp3", 131},
			{1759, "Sound\\Music\\Pandaria\\MUS_50_SerpentsHeart_Night_Walk_02.mp3", 71},
			{1760, "Sound\\Music\\Pandaria\\MUS_50_SerpentsHeart_Night_Walk_03.mp3", 102},
		},
	},
	{
		id = 158,
		name = L["TITLE_SHA"],
		files = {
			{1761, "Sound\\Music\\Pandaria\\MUS_50_Sha_01.mp3", 67},
			{1762, "Sound\\Music\\Pandaria\\MUS_50_Sha_02.mp3", 66},
			{1763, "Sound\\Music\\Pandaria\\MUS_50_Sha_Hero_01.mp3", 70},
			{1764, "Sound\\Music\\Pandaria\\MUS_50_Sha_Stinger_Heavy_01.mp3", 26},
			{1765, "Sound\\Music\\Pandaria\\MUS_50_Sha_Stinger_Heavy_02.mp3", 18},
			{1766, "Sound\\Music\\Pandaria\\MUS_50_Sha_Stinger_Heavy_03.mp3", 21},
			{1767, "Sound\\Music\\Pandaria\\MUS_50_Sha_Stinger_Lite_01.mp3", 20},
			{1768, "Sound\\Music\\Pandaria\\MUS_50_Sha_Stinger_Lite_02.mp3", 18},
			{1769, "Sound\\Music\\Pandaria\\MUS_50_Sha_Stinger_Lite_03.mp3", 18},
			{1770, "Sound\\Music\\Pandaria\\MUS_50_Sha_Stinger_Lite_04.mp3", 19},
			{1771, "Sound\\Music\\Pandaria\\MUS_50_Sha_Stinger_Med_01.mp3", 24},
			{1772, "Sound\\Music\\Pandaria\\MUS_50_Sha_Stinger_Med_02.mp3", 15},
			{1773, "Sound\\Music\\Pandaria\\MUS_50_ShaWalk_Hero_01.mp3", 85},
			{1774, "Sound\\Music\\Pandaria\\MUS_50_ShaWalk_Hero_02.mp3", 57},
			{1775, "Sound\\Music\\Pandaria\\MUS_50_ShaWalk_Hero_03.mp3", 88},
			{1776, "Sound\\Music\\Pandaria\\MUS_50_ShaWalk_Hero_04.mp3", 61},
			{1777, "Sound\\Music\\Pandaria\\MUS_50_ShoSha_A_01.mp3", 19},
			{1778, "Sound\\Music\\Pandaria\\MUS_50_ShoSha_A_02.mp3", 20},
			{1779, "Sound\\Music\\Pandaria\\MUS_50_ShoSha_A_03.mp3", 20},
			{1780, "Sound\\Music\\Pandaria\\MUS_50_ShoSha_A_04.mp3", 20},
			{1781, "Sound\\Music\\Pandaria\\MUS_50_ShoSha_A_05.mp3", 19},
			{1782, "Sound\\Music\\Pandaria\\MUS_50_ShoSha_B_01.mp3", 20},
			{1783, "Sound\\Music\\Pandaria\\MUS_50_ShoSha_B_02.mp3", 20},
			{1784, "Sound\\Music\\Pandaria\\MUS_50_ShoSha_B_03.mp3", 20},
			{1785, "Sound\\Music\\Pandaria\\MUS_50_ShoSha_B_04.mp3", 20},
			{1786, "Sound\\Music\\Pandaria\\MUS_50_ShoSha_B_05.mp3", 19},
			{1787, "Sound\\Music\\Pandaria\\MUS_50_ShoSha_B_06.mp3", 24},
			{1788, "Sound\\Music\\Pandaria\\MUS_54_ShaAmbient_01.mp3", 53},
			{1789, "Sound\\Music\\Pandaria\\MUS_54_ShaAmbient_02.mp3", 59},
			{1790, "Sound\\Music\\Pandaria\\MUS_54_ShaAmbient_03.mp3", 59},
			{1791, "Sound\\Music\\Pandaria\\MUS_54_ShaAmbient_04.mp3", 59},
			{1792, "Sound\\Music\\Pandaria\\MUS_54_ShaAmbient_Hero.mp3", 114},
			{1793, "Sound\\Music\\Pandaria\\MUS_54_ShaAngry_01.mp3", 58},
			{1794, "Sound\\Music\\Pandaria\\MUS_54_ShaAngry_02.mp3", 61},
			{1795, "Sound\\Music\\Pandaria\\MUS_54_ShaAngry_Hero.mp3", 133},
			{1796, "Sound\\Music\\Pandaria\\MUS_54_ShaDescendant_01.mp3", 44},
			{1797, "Sound\\Music\\Pandaria\\MUS_54_ShaDescendant_02.mp3", 49},
			{1798, "Sound\\Music\\Pandaria\\MUS_54_ShaDescendant_03.mp3", 45},
			{1799, "Sound\\Music\\Pandaria\\MUS_54_ShaDescendant_Hero.mp3", 88},
			{1800, "Sound\\Music\\Pandaria\\MUS_54_ShaVocaline_01.mp3", 19},
			{1801, "Sound\\Music\\Pandaria\\MUS_54_ShaVocaline_02.mp3", 60},
			{1802, "Sound\\Music\\Pandaria\\MUS_54_ShaVocaline_03.mp3", 60},
			{1803, "Sound\\Music\\Pandaria\\MUS_54_ShaVocaline_Hero.mp3", 66},
		},
	},
	{
		id = 159,
		name = L["TITLE_SHADOPAN"],
		files = {
			{1804, "Sound\\Music\\Pandaria\\MUS_50_ShadoPan_A_Hero_01.mp3", 75},
			{1805, "Sound\\Music\\Pandaria\\MUS_50_ShadoPan_A_Hero_02.mp3", 63},
			{1806, "Sound\\Music\\Pandaria\\MUS_50_ShadoPan_A_Hero_03.mp3", 172},
			{1807, "Sound\\Music\\Pandaria\\MUS_50_ShadoPan_A_Walk_01.mp3", 54},
			{1808, "Sound\\Music\\Pandaria\\MUS_50_ShadoPan_A_Walk_02.mp3", 66},
			{1809, "Sound\\Music\\Pandaria\\MUS_50_ShadoPan_B_Hero_01.mp3", 116},
			{1810, "Sound\\Music\\Pandaria\\MUS_50_ShadoPan_B_Hero_02.mp3", 76},
		},
	},
	{
		id = 160,
		name = L["TITLE_SHENZINSU"],
		files = {
			{1811, "Sound\\Music\\Pandaria\\MUS_50_ShenZinSu_01.mp3", 99},
			{1812, "Sound\\Music\\Pandaria\\MUS_50_ShenZinSu_02.mp3", 114},
			{1813, "Sound\\Music\\Pandaria\\MUS_50_ShenZinSu_03.mp3", 114},
			{1814, "Sound\\Music\\Pandaria\\MUS_50_ShenZinSu_Hero_01.mp3", 51},
			{1815, "Sound\\Music\\Pandaria\\MUS_50_ShenZinSu_Hero_02.mp3", 67},
		},
	},
	{
		id = 161,
		name = L["TITLE_SIEGENIUZAOTEMPLE"],
		files = {
			{1816, "Sound\\Music\\Pandaria\\MUS_50_SiegeofNiuzaoTemple_Hero_01.mp3", 78},
			{1817, "Sound\\Music\\Pandaria\\MUS_50_SiegeofNiuzaoTemple_Hero_02.mp3", 55},
			{1818, "Sound\\Music\\Pandaria\\MUS_50_SiegeofNiuzaoTemple_Hero_03.mp3", 58},
		},
	},
	{
		id = 162,
		name = L["TITLE_SPIRITCAVE"],
		files = {
			{1819, "Sound\\Music\\Pandaria\\MUS_50_SpiritCave_01.mp3", 91},
			{1820, "Sound\\Music\\Pandaria\\MUS_50_SpiritCave_02.mp3", 98},
			{1821, "Sound\\Music\\Pandaria\\MUS_50_SpiritCave_03.mp3", 98},
			{1822, "Sound\\Music\\Pandaria\\MUS_50_SpiritCave_04.mp3", 70},
			{1823, "Sound\\Music\\Pandaria\\MUS_50_SpiritCave_05.mp3", 129},
			{1824, "Sound\\Music\\Pandaria\\MUS_50_SpiritCave_06.mp3", 131},
			{1825, "Sound\\Music\\Pandaria\\MUS_50_SpiritCave_Hero_01.mp3", 130},
			{1826, "Sound\\Music\\Pandaria\\MUS_50_SpiritPath_01.mp3", 74},
			{1827, "Sound\\Music\\Pandaria\\MUS_50_SpiritPath_02.mp3", 73},
			{1828, "Sound\\Music\\Pandaria\\MUS_50_SpiritPath_03.mp3", 77},
			{1829, "Sound\\Music\\Pandaria\\MUS_50_SpiritPath_04.mp3", 51},
			{1830, "Sound\\Music\\Pandaria\\MUS_50_SpiritPath_Hero_01.mp3", 72},
			{1831, "Sound\\Music\\Pandaria\\MUS_50_Spirits_A_01.mp3", 52},
			{1832, "Sound\\Music\\Pandaria\\MUS_50_Spirits_A_02.mp3", 72},
			{1833, "Sound\\Music\\Pandaria\\MUS_50_Spirits_A_03.mp3", 67},
			{1834, "Sound\\Music\\Pandaria\\MUS_50_Spirits_A_04.mp3", 83},
			{1835, "Sound\\Music\\Pandaria\\MUS_50_SpiritsB_01.mp3", 74},
			{1836, "Sound\\Music\\Pandaria\\MUS_50_SpiritsB_02.mp3", 73},
		},
	},
	{
		id = 163,
		name = L["TITLE_TEMPLE5DAWNS"],
		files = {
			{1837, "Sound\\Music\\Pandaria\\MUS_50_TempleoftheFiveDawns_01.mp3", 68},
			{1838, "Sound\\Music\\Pandaria\\MUS_50_TempleoftheFiveDawns_02.mp3", 64},
			{1839, "Sound\\Music\\Pandaria\\MUS_50_TempleoftheFiveDawns_03.mp3", 70},
			{1840, "Sound\\Music\\Pandaria\\MUS_50_TempleoftheFiveDawns_04.mp3", 40},
			{1841, "Sound\\Music\\Pandaria\\MUS_50_TempleoftheFiveDawns_05.mp3", 39},
			{1842, "Sound\\Music\\Pandaria\\MUS_50_TempleoftheFiveDawns_06.mp3", 48},
			{1843, "Sound\\Music\\Pandaria\\MUS_50_TempleoftheFiveDawns_07.mp3", 43},
			{1844, "Sound\\Music\\Pandaria\\MUS_50_TempleoftheFiveDawns_08.mp3", 11},
			{1845, "Sound\\Music\\Pandaria\\MUS_50_TempleoftheFiveDawns_09.mp3", 93},
			{1846, "Sound\\Music\\Pandaria\\MUS_50_TempleoftheFiveDawns_10.mp3", 100},
			{1847, "Sound\\Music\\Pandaria\\MUS_50_TempleoftheFiveDawns_11.mp3", 52},
			{1848, "Sound\\Music\\Pandaria\\MUS_50_TempleoftheFiveDawns_12.mp3", 19},
			{1849, "Sound\\Music\\Pandaria\\MUS_50_TempleoftheFiveDawns_Hero_01.mp3", 101},
		},
	},
	{
		id = 164,
		name = L["TITLE_TEMPLEJADESERPENT"],
		files = {
			{1850, "Sound\\Music\\Pandaria\\MUS_50_TempleoftheJadeSerpent_Hero_01.mp3", 75},
			{1851, "Sound\\Music\\Pandaria\\MUS_50_TempleoftheJadeSerpent_Hero_02.mp3", 88},
			{1852, "Sound\\Music\\Pandaria\\MUS_50_TempleoftheJadeSerpent_Hero_03.mp3", 73},
		},
	},
	{
		id = 165,
		name = L["TITLE_SHRINE"],
		files = {
			{1853, "Sound\\Music\\Pandaria\\MUS_50_Toast_A_01.mp3", 54},
			{1854, "Sound\\Music\\Pandaria\\MUS_50_Toast_A_Hero_01.mp3", 91},
			{1855, "Sound\\Music\\Pandaria\\MUS_50_Toast_B_02.mp3", 87},
			{1856, "Sound\\Music\\Pandaria\\MUS_50_Toast_B_03.mp3", 87},
			{1857, "Sound\\Music\\Pandaria\\MUS_50_Toast_B_04.mp3", 88},
			{1858, "Sound\\Music\\Pandaria\\MUS_50_Toast_B_Hero_01.mp3", 91},
		},
	},
	{
		id = 166,
		name = L["TITLE_TOWNLONGSTEPPES"],
		files = {
			{1859, "Sound\\Music\\Pandaria\\MUS_50_TownlongSteppes_A_Hero_01.mp3", 95},
			{1860, "Sound\\Music\\Pandaria\\MUS_50_TownlongSteppes_A_Hero_02.mp3", 114},
			{1861, "Sound\\Music\\Pandaria\\MUS_50_TownlongSteppes_B_01.mp3", 97},
			{1862, "Sound\\Music\\Pandaria\\MUS_50_TownlongSteppes_B_02.mp3", 90},
			{1863, "Sound\\Music\\Pandaria\\MUS_50_TownlongSteppes_B_Hero_01.mp3", 105},
			{1864, "Sound\\Music\\Pandaria\\MUS_50_TownlongSteppes_C_Hero_01.mp3", 80},
			{1865, "Sound\\Music\\Pandaria\\MUS_50_TownlongSteppes_C_Hero_02.mp3", 58},
			{1866, "Sound\\Music\\Pandaria\\MUS_50_TownlongSteppes_C_Hero_03.mp3", 67},
			{1867, "Sound\\Music\\Pandaria\\MUS_50_TownlongSteppes_C_Night_Hero_01.mp3", 58},
			{1868, "Sound\\Music\\Pandaria\\MUS_50_TownlongSteppes_C_Night_Hero_02.mp3", 70},
			{1869, "Sound\\Music\\Pandaria\\MUS_50_TownlongSteppes_C_Night_Hero_03.mp3", 70},
			{1870, "Sound\\Music\\Pandaria\\MUS_50_TownlongSteppes_D_01.mp3", 63},
			{1871, "Sound\\Music\\Pandaria\\MUS_50_TownlongSteppes_D_Hero_01.mp3", 42},
			{1872, "Sound\\Music\\Pandaria\\MUS_50_TownlongSteppes_D_Hero_02.mp3", 70},
		},
	},
	{
		id = 167,
		name = L["TITLE_GECKO"],
		files = {
			{1873, "Sound\\Music\\Pandaria\\MUS_50_VEB_A_01.mp3", 57},
			{1874, "Sound\\Music\\Pandaria\\MUS_50_VEB_A_02.mp3", 55},
			{1875, "Sound\\Music\\Pandaria\\MUS_50_VEB_A_03.mp3", 38},
			{1876, "Sound\\Music\\Pandaria\\MUS_50_VEB_A_04.mp3", 50},
			{1877, "Sound\\Music\\Pandaria\\MUS_50_VEB_A_05.mp3", 52},
			{1878, "Sound\\Music\\Pandaria\\MUS_50_VEB_A_06.mp3", 85},
			{1879, "Sound\\Music\\Pandaria\\MUS_50_VEB_A_Hero_01.mp3", 122},
		},
	},
	{
		id = 168,
		name = L["TITLE_FAMILY"],
		files = {
			{1880, "Sound\\Music\\Pandaria\\MUS_50_VEB_B_01.mp3", 110},
			{1881, "Sound\\Music\\Pandaria\\MUS_50_VEB_B_02.mp3", 111},
			{1882, "Sound\\Music\\Pandaria\\MUS_50_VEB_B_03.mp3", 111},
			{1883, "Sound\\Music\\Pandaria\\MUS_50_VEB_B_Hero_01.mp3", 113},
			{1884, "Sound\\Music\\Pandaria\\MUS_50_VEB_B_Night_01.mp3", 69},
			{1885, "Sound\\Music\\Pandaria\\MUS_50_VEB_B_Night_02.mp3", 45},
			{1886, "Sound\\Music\\Pandaria\\MUS_50_VEB_B_Night_03.mp3", 109},
			{1887, "Sound\\Music\\Pandaria\\MUS_50_VEB_B_Night_04.mp3", 122},
			{1888, "Sound\\Music\\Pandaria\\MUS_50_VEB_B_Night_05.mp3", 124},
			{1889, "Sound\\Music\\Pandaria\\MUS_50_VEB_B_Night_06.mp3", 117},
		},
	},
	{
		id = 169,
		name = L["TITLE_VALEETERNAL"],
		files = {
			{1890, "Sound\\Music\\Pandaria\\MUS_50_VEB_C_Hero_01.mp3", 26},
			{1891, "Sound\\Music\\Pandaria\\MUS_50_VEB_C_Hero_02.mp3", 29},
			{1892, "Sound\\Music\\Pandaria\\MUS_50_VEB_D_Hero_01.mp3", 73},
			{1893, "Sound\\Music\\Pandaria\\MUS_50_VEB_D_Hero_02.mp3", 71},
			{1894, "Sound\\Music\\Pandaria\\MUS_50_VEB_D_Hero_03.mp3", 52},
			{1895, "Sound\\Music\\Pandaria\\MUS_50_VEB_D_Hero_04.mp3", 50},
			{1896, "Sound\\Music\\Pandaria\\MUS_50_VFW_A_01.mp3", 52},
			{1897, "Sound\\Music\\Pandaria\\MUS_50_VFW_A_02.mp3", 82},
			{1898, "Sound\\Music\\Pandaria\\MUS_50_VFW_A_03.mp3", 53},
			{1899, "Sound\\Music\\Pandaria\\MUS_50_VFW_A_04.mp3", 81},
			{1900, "Sound\\Music\\Pandaria\\MUS_50_VFW_A_05.mp3", 54},
			{1901, "Sound\\Music\\Pandaria\\MUS_50_VFW_A_06.mp3", 81},
			{1902, "Sound\\Music\\Pandaria\\MUS_50_VFW_A_07.mp3", 54},
			{1903, "Sound\\Music\\Pandaria\\MUS_50_VFW_A_08.mp3", 102},
			{1904, "Sound\\Music\\Pandaria\\MUS_50_VFW_A_Hero_01.mp3", 51},
			{1905, "Sound\\Music\\Pandaria\\MUS_50_VFW_A_Hero_02.mp3", 82},
			{1906, "Sound\\Music\\Pandaria\\MUS_50_Windspire_01.mp3", 86},
			{1907, "Sound\\Music\\Pandaria\\MUS_50_Windspire_02.mp3", 117},
			{1908, "Sound\\Music\\Pandaria\\MUS_50_Windspire_03.mp3", 115},
			{1909, "Sound\\Music\\Pandaria\\MUS_50_Windspire_Hero_01.mp3", 87},
			{1910, "Sound\\Music\\Pandaria\\MUS_54_ValeHealing.mp3", 87},
		},
	},
	{
		id = 170,
		name = L["TITLE_ALLIANCE"],
		files = {
			{1911, "Sound\\Music\\Pandaria\\MUS_51_AllianceBattleMarch_01.mp3", 119},
			{1912, "Sound\\Music\\Pandaria\\MUS_51_AllianceBattleMarch_02.mp3", 119},
			{1913, "Sound\\Music\\Pandaria\\MUS_51_AllianceBattleMarch_Hero_01.mp3", 119},
			{1914, "Sound\\Music\\Pandaria\\MUS_51_ForTheAlliance_01.mp3", 128},
			{1915, "Sound\\Music\\Pandaria\\MUS_51_ForTheAlliance_02.mp3", 100},
			{1916, "Sound\\Music\\Pandaria\\MUS_51_ForTheAlliance_03.mp3", 66},
			{1917, "Sound\\Music\\Pandaria\\MUS_51_ForTheAlliance_04.mp3", 67},
			{1918, "Sound\\Music\\Pandaria\\MUS_51_ForTheAlliance_05.mp3", 67},
			{1919, "Sound\\Music\\Pandaria\\MUS_51_ForTheAlliance_Hero_01.mp3", 128},
			{1920, "Sound\\Music\\Pandaria\\MUS_54_ForThePandarenAlliance_A_01.mp3", 62},
			{1921, "Sound\\Music\\Pandaria\\MUS_54_ForThePandarenAlliance_A_02.mp3", 79},
			{1922, "Sound\\Music\\Pandaria\\MUS_54_ForThePandarenAlliance_B_01.mp3", 61},
			{1923, "Sound\\Music\\Pandaria\\MUS_54_ForThePandarenAlliance_B_02.mp3", 78},
		},
	},
	{
		id = 171,
		name = L["TITLE_HORDE"],
		files = {
			{1924, "Sound\\Music\\Pandaria\\MUS_51_GarroshTheme_A_01.mp3", 163},
			{1925, "Sound\\Music\\Pandaria\\MUS_51_GarroshTheme_A_02.mp3", 166},
			{1926, "Sound\\Music\\Pandaria\\MUS_51_GarroshTheme_A_Hero_01.mp3", 166},
			{1927, "Sound\\Music\\Pandaria\\MUS_51_GarroshTheme_B_01.mp3", 175},
			{1928, "Sound\\Music\\Pandaria\\MUS_51_GarroshTheme_B_02.mp3", 174},
			{1929, "Sound\\Music\\Pandaria\\MUS_51_GarroshTheme_B_Hero_01.mp3", 175},
			{1930, "Sound\\Music\\Pandaria\\MUS_51_GarroshTheme_Big_DivineBellFinale.mp3", 123},
			{1931, "Sound\\Music\\Pandaria\\MUS_54_NoQuarter_01.mp3", 108},
			{1932, "Sound\\Music\\Pandaria\\MUS_54_NoQuarter_02.mp3", 77},
			{1933, "Sound\\Music\\Pandaria\\MUS_54_NoQuarter_03.mp3", 68},
			{1934, "Sound\\Music\\Pandaria\\MUS_54_NoQuarter_04.mp3", 84},
			{1935, "Sound\\Music\\Pandaria\\MUS_54_NoQuarter_Hero.mp3", 108},
			{1936, "Sound\\Music\\Pandaria\\MUS_54_Overlord_01.mp3", 69},
			{1937, "Sound\\Music\\Pandaria\\MUS_54_Overlord_02.mp3", 65},
			{1938, "Sound\\Music\\Pandaria\\MUS_54_Overlord_03.mp3", 27},
			{1939, "Sound\\Music\\Pandaria\\MUS_54_Overlord_Hero.mp3", 69},
		},
	},
	{
		id = 172,
		name = L["TITLE_KIRINTOR"],
		files = {
			{1940, "Sound\\Music\\Pandaria\\MUS_51_JainaHomeland_Lyrical_01.mp3", 107},
			{1941, "Sound\\Music\\Pandaria\\MUS_51_JainaHomeland_Lyrical_02.mp3", 106},
			{1942, "Sound\\Music\\Pandaria\\MUS_51_JainaHomeland_Lyrical_Hero_01.mp3", 107},
			{1943, "Sound\\Music\\Pandaria\\MUS_51_JainaHomeland_Military_01.mp3", 102},
			{1944, "Sound\\Music\\Pandaria\\MUS_51_JainaHomeland_Military_02.mp3", 103},
			{1945, "Sound\\Music\\Pandaria\\MUS_51_JainaHomeland_Military_03.mp3", 41},
			{1946, "Sound\\Music\\Pandaria\\MUS_51_JainaHomeland_Military_Hero_01.mp3", 104},
			{1947, "Sound\\Music\\Pandaria\\MUS_51_Theramores_Fall_Scene_01.mp3", 56},
		},
	},
	{
		id = 173,
		name = L["TITLE_SUNREAVERS"],
		files = {
			{1948, "Sound\\Music\\Pandaria\\MUS_51_Sunreavers_01.mp3", 59},
			{1949, "Sound\\Music\\Pandaria\\MUS_51_Sunreavers_02.mp3", 58},
			{1950, "Sound\\Music\\Pandaria\\MUS_51_Sunreavers_03.mp3", 76},
			{1951, "Sound\\Music\\Pandaria\\MUS_51_Sunreavers_04.mp3", 65},
			{1952, "Sound\\Music\\Pandaria\\MUS_51_Sunreavers_05.mp3", 23},
			{1953, "Sound\\Music\\Pandaria\\MUS_51_Sunreavers_06.mp3", 19},
			{1954, "Sound\\Music\\Pandaria\\MUS_51_Sunreavers_07.mp3", 22},
			{1955, "Sound\\Music\\Pandaria\\MUS_51_Sunreavers_08.mp3", 23},
			{1956, "Sound\\Music\\Pandaria\\MUS_51_Sunreavers_09.mp3", 36},
			{1957, "Sound\\Music\\Pandaria\\MUS_51_Sunreavers_10.mp3", 58},
			{1958, "Sound\\Music\\Pandaria\\MUS_51_Sunreavers_11.mp3", 58},
			{1959, "Sound\\Music\\Pandaria\\MUS_51_Sunreavers_12.mp3", 57},
			{1960, "Sound\\Music\\Pandaria\\MUS_51_Sunreavers_13.mp3", 112},
			{1961, "Sound\\Music\\Pandaria\\MUS_51_Sunreavers_14.mp3", 34},
			{1962, "Sound\\Music\\Pandaria\\MUS_51_Sunreavers_15.mp3", 12},
			{1963, "Sound\\Music\\Pandaria\\MUS_51_Sunreavers_16.mp3", 65},
			{1964, "Sound\\Music\\Pandaria\\MUS_51_Sunreavers_17.mp3", 10},
			{1965, "Sound\\Music\\Pandaria\\MUS_51_Sunreavers_18.mp3", 9},
			{1966, "Sound\\Music\\Pandaria\\MUS_51_Sunreavers_19.mp3", 9},
			{1967, "Sound\\Music\\Pandaria\\MUS_51_Sunreavers_Hero_01.mp3", 130},
			{1968, "Sound\\Music\\Pandaria\\MUS_51_Theramores_Fall_Scene_01.mp3", 56},
		},
	},
	{
		id = 174,
		name = L["TITLE_ISLEOFTHUNDER"],
		files = {
			{1969, "Sound\\Music\\Pandaria\\MUS_52_ItIsDone_A_01.mp3", 39},
			{1970, "Sound\\Music\\Pandaria\\MUS_52_ItIsDone_A_02.mp3", 46},
			{1971, "Sound\\Music\\Pandaria\\MUS_52_ItIsDone_A_03.mp3", 49},
			{1972, "Sound\\Music\\Pandaria\\MUS_52_ItIsDone_A_04.mp3", 91},
			{1973, "Sound\\Music\\Pandaria\\MUS_52_ItIsDone_A_05.mp3", 53},
			{1974, "Sound\\Music\\Pandaria\\MUS_52_Mysterioso_A_01.mp3", 74},
			{1975, "Sound\\Music\\Pandaria\\MUS_52_Mysterioso_A_02.mp3", 74},
			{1976, "Sound\\Music\\Pandaria\\MUS_52_Mysterioso_Hero_01.mp3", 74},
			{1977, "Sound\\Music\\Pandaria\\MUS_52_ThunderIsle_A_01.mp3", 87},
			{1978, "Sound\\Music\\Pandaria\\MUS_52_ThunderIsle_A_02.mp3", 87},
			{1979, "Sound\\Music\\Pandaria\\MUS_52_ThunderIsle_A_03.mp3", 66},
			{1980, "Sound\\Music\\Pandaria\\MUS_52_ThunderIsle_A_04.mp3", 22},
			{1981, "Sound\\Music\\Pandaria\\MUS_52_ThunderIsle_A_05.mp3", 124},
			{1982, "Sound\\Music\\Pandaria\\MUS_52_ThunderIsle_A_06.mp3", 60},
			{1983, "Sound\\Music\\Pandaria\\MUS_52_ThunderIsle_A_07.mp3", 71},
			{1984, "Sound\\Music\\Pandaria\\MUS_52_ThunderIsle_A_Hero_01.mp3", 114},
			{1985, "Sound\\Music\\Pandaria\\MUS_52_ThunderIsle_A_Stinger_01.mp3", 9},
			{1986, "Sound\\Music\\Pandaria\\MUS_52_ThunderIsle_A_Stinger_02.mp3", 8},
			{1987, "Sound\\Music\\Pandaria\\MUS_52_ThunderIsle_A_Stinger_03.mp3", 6},
			{1988, "Sound\\Music\\Pandaria\\MUS_52_ThunderIsle_A_Stinger_04.mp3", 9},
			{1989, "Sound\\Music\\Pandaria\\MUS_52_ThunderIsle_B_01.mp3", 66},
			{1990, "Sound\\Music\\Pandaria\\MUS_52_ThunderIsle_B_02.mp3", 73},
			{1991, "Sound\\Music\\Pandaria\\MUS_52_ThunderIsle_B_03.mp3", 94},
			{1992, "Sound\\Music\\Pandaria\\MUS_52_ThunderIsle_B_04.mp3", 106},
			{1993, "Sound\\Music\\Pandaria\\MUS_52_ThunderIsle_B_05.mp3", 97},
			{1994, "Sound\\Music\\Pandaria\\MUS_52_ThunderIsle_B_Hero_01.mp3", 121},
			{1995, "Sound\\Music\\Pandaria\\MUS_52_ThunderIsle_C_01.mp3", 95},
			{1996, "Sound\\Music\\Pandaria\\MUS_52_ThunderIsle_C_02.mp3", 98},
			{1997, "Sound\\Music\\Pandaria\\MUS_52_ThunderIsle_C_03.mp3", 119},
			{1998, "Sound\\Music\\Pandaria\\MUS_52_ThunderIsle_C_04.mp3", 48},
			{1999, "Sound\\Music\\Pandaria\\MUS_52_ThunderIsle_C_Hero_01.mp3", 121},
			{2000, "Sound\\Music\\Pandaria\\MUS_52_ThunderIsle_C_Stinger_01.mp3", 11},
			{2001, "Sound\\Music\\Pandaria\\MUS_52_ThunderIsle_C_Stinger_02.mp3", 23},
			{2002, "Sound\\Music\\Pandaria\\MUS_52_ThunderIsle_C_Stinger_03.mp3", 9},
		},
	},
	{
		id = 175,
		name = L["TITLE_THUNDERKING"],
		files = {
			{2003, "Sound\\Music\\Pandaria\\MUS_52_ThunderKing_A_01.mp3", 42},
			{2004, "Sound\\Music\\Pandaria\\MUS_52_ThunderKing_A_02.mp3", 10},
			{2005, "Sound\\Music\\Pandaria\\MUS_52_ThunderKing_A_03.mp3", 56},
			{2006, "Sound\\Music\\Pandaria\\MUS_52_ThunderKing_A_Hero_01.mp3", 97},
			{2007, "Sound\\Music\\Pandaria\\MUS_52_ThunderKing_A_Stinger_01.mp3", 8},
			{2008, "Sound\\Music\\Pandaria\\MUS_52_ThunderKing_A_Stinger_02.mp3", 13},
			{2009, "Sound\\Music\\Pandaria\\MUS_52_ThunderKing_A_Stinger_03.mp3", 12},
			{2010, "Sound\\Music\\Pandaria\\MUS_52_ThunderKing_A_Stinger_04.mp3", 12},
			{2011, "Sound\\Music\\Pandaria\\MUS_52_ThunderKing_A_Stinger_05.mp3", 14},
			{2012, "Sound\\Music\\Pandaria\\MUS_52_ThunderKing_A_Stinger_06.mp3", 15},
			{2013, "Sound\\Music\\Pandaria\\MUS_52_ThunderKing_A_Stinger_07.mp3", 13},
			{2014, "Sound\\Music\\Pandaria\\MUS_52_ThunderKing_B_01.mp3", 44},
			{2015, "Sound\\Music\\Pandaria\\MUS_52_ThunderKing_B_Hero_01.mp3", 44},
			{2016, "Sound\\Music\\Pandaria\\MUS_52_ThunderKing_C_Stinger_01.mp3", 3},
			{2017, "Sound\\Music\\Pandaria\\MUS_52_TrovesOfTheThunderKing_01.mp3", 309},
			{2018, "Sound\\Music\\Pandaria\\MUS_53_EmperorRevealed.mp3", 139},
		},
	},
	{
		id = 176,
		name = L["TITLE_TROLLS"],
		files = {
			{2019, "Sound\\Music\\Pandaria\\MUS_52_TrollBattle_A_01.mp3", 40},
			{2020, "Sound\\Music\\Pandaria\\MUS_52_TrollBattle_A_02.mp3", 84},
			{2021, "Sound\\Music\\Pandaria\\MUS_52_TrollBattle_A_03.mp3", 56},
			{2022, "Sound\\Music\\Pandaria\\MUS_52_TrollBattle_B_01.mp3", 41},
			{2023, "Sound\\Music\\Pandaria\\MUS_52_TrollBattle_B_02.mp3", 80},
			{2024, "Sound\\Music\\Pandaria\\MUS_52_TrollBattle_B_03.mp3", 54},
			{2025, "Sound\\Music\\Pandaria\\MUS_52_Zandalari_1_A_01.mp3", 72},
			{2026, "Sound\\Music\\Pandaria\\MUS_52_Zandalari_1_A_02.mp3", 80},
			{2027, "Sound\\Music\\Pandaria\\MUS_52_Zandalari_1_A_03.mp3", 75},
			{2028, "Sound\\Music\\Pandaria\\MUS_52_Zandalari_1_B_01.mp3", 72},
			{2029, "Sound\\Music\\Pandaria\\MUS_52_Zandalari_1_B_02.mp3", 80},
			{2030, "Sound\\Music\\Pandaria\\MUS_52_Zandalari_1_B_03.mp3", 74},
			{2031, "Sound\\Music\\Pandaria\\MUS_52_Zandalari_1_C_01.mp3", 64},
			{2032, "Sound\\Music\\Pandaria\\MUS_52_Zandalari_1_C_02.mp3", 79},
			{2033, "Sound\\Music\\Pandaria\\MUS_52_Zandalari_2_A_01.mp3", 77},
			{2034, "Sound\\Music\\Pandaria\\MUS_52_Zandalari_2_A_02.mp3", 50},
			{2035, "Sound\\Music\\Pandaria\\MUS_52_Zandalari_2_A_03.mp3", 38},
			{2036, "Sound\\Music\\Pandaria\\MUS_52_Zandalari_2_A_04.mp3", 49},
			{2037, "Sound\\Music\\Pandaria\\MUS_52_Zandalari_2_A_05.mp3", 64},
			{2038, "Sound\\Music\\Pandaria\\MUS_52_Zandalari_2_B_01.mp3", 118},
			{2039, "Sound\\Music\\Pandaria\\MUS_52_Zandalari_2_B_02.mp3", 46},
			{2040, "Sound\\Music\\Pandaria\\MUS_52_Zandalari_2_B_03.mp3", 64},
			{2041, "Sound\\Music\\Pandaria\\MUS_52_Zandalari_2_C_01.mp3", 77},
			{2042, "Sound\\Music\\Pandaria\\MUS_52_Zandalari_2_C_02.mp3", 50},
			{2043, "Sound\\Music\\Pandaria\\MUS_52_Zandalari_2_C_03.mp3", 33},
			{2044, "Sound\\Music\\Pandaria\\MUS_52_ZandalariProphecy_01.mp3", 170},
		},
	},
	{
		id = 177,
		name = L["TITLE_WRATHION"],
		files = {
			{2045, "Sound\\Music\\Pandaria\\MUS_52_Wrathion_A_02.mp3", 36},
			{2046, "Sound\\Music\\Pandaria\\MUS_52_Wrathion_A_03.mp3", 65},
			{2047, "Sound\\Music\\Pandaria\\MUS_52_Wrathion_A_Hero_01.mp3", 159},
			{2048, "Sound\\Music\\Pandaria\\MUS_52_Wrathion_B_01.mp3", 79},
			{2049, "Sound\\Music\\Pandaria\\MUS_52_Wrathion_B_02.mp3", 39},
			{2050, "Sound\\Music\\Pandaria\\MUS_52_Wrathion_B_03.mp3", 65},
			{2051, "Sound\\Music\\Pandaria\\MUS_53_Wrathion_C_01.mp3", 78},
			{2052, "Sound\\Music\\Pandaria\\MUS_53_Wrathion_C_02.mp3", 45},
		},
	},
	{
		id = 178,
		name = L["TITLE_CORRUPTEDVALE"],
		files = {
			{2053, "Sound\\Music\\Pandaria\\MUS_54_CorruptedVale_Day_01.mp3", 69},
			{2054, "Sound\\Music\\Pandaria\\MUS_54_CorruptedVale_Day_02.mp3", 38},
			{2055, "Sound\\Music\\Pandaria\\MUS_54_CorruptedVale_Day_03.mp3", 41},
			{2056, "Sound\\Music\\Pandaria\\MUS_54_CorruptedVale_Day_04.mp3", 58},
			{2057, "Sound\\Music\\Pandaria\\MUS_54_CorruptedVale_Day_Hero.mp3", 107},
			{2058, "Sound\\Music\\Pandaria\\MUS_54_CorruptedVale_Night_01.mp3", 40},
			{2059, "Sound\\Music\\Pandaria\\MUS_54_CorruptedVale_Night_02.mp3", 35},
			{2060, "Sound\\Music\\Pandaria\\MUS_54_CorruptedVale_Night_03.mp3", 35},
			{2061, "Sound\\Music\\Pandaria\\MUS_54_CorruptedVale_Night_04.mp3", 105},
			{2062, "Sound\\Music\\Pandaria\\MUS_54_CorruptedVale_Night_05.mp3", 53},
			{2063, "Sound\\Music\\Pandaria\\MUS_54_CorruptedVale_Night_Hero.mp3", 140},
			{2064, "Sound\\Music\\Pandaria\\MUS_54_GoodMourning_Hero.mp3", 84},
		},
	},
	{
		id = 179,
		name = L["TITLE_DOOMHAMMER"],
		files = {
			{2065, "Sound\\Music\\Pandaria\\MUS_54_Doomhammer_01.mp3", 124},
			{2066, "Sound\\Music\\Pandaria\\MUS_54_Doomhammer_02.mp3", 110},
			{2067, "Sound\\Music\\Pandaria\\MUS_54_Doomhammer_03.mp3", 67},
			{2068, "Sound\\Music\\Pandaria\\MUS_54_Doomhammer_04.mp3", 69},
			{2069, "Sound\\Music\\Pandaria\\MUS_54_Doomhammer_05.mp3", 81},
			{2070, "Sound\\Music\\Pandaria\\MUS_54_Doomhammer_Hero.mp3", 124},
		},
	},
	{
		id = 180,
		name = L["TITLE_LEGENDARY"],
		files = {
			{2071, "Sound\\Music\\Pandaria\\MUS_54_Legendary_01.mp3", 36},
			{2072, "Sound\\Music\\Pandaria\\MUS_54_Legendary_02.mp3", 50},
			{2073, "Sound\\Music\\Pandaria\\MUS_54_Legendary_03.mp3", 105},
			{2074, "Sound\\Music\\Pandaria\\MUS_54_Legendary_04.mp3", 60},
			{2075, "Sound\\Music\\Pandaria\\MUS_54_Legendary_05.mp3", 87},
			{2076, "Sound\\Music\\Pandaria\\MUS_54_Legendary_06.mp3", 7},
			{2077, "Sound\\Music\\Pandaria\\MUS_54_Legendary_07.mp3", 34},
			{2078, "Sound\\Music\\Pandaria\\MUS_54_Legendary_08.mp3", 72},
			{2079, "Sound\\Music\\Pandaria\\MUS_54_Legendary_09.mp3", 63},
			{2080, "Sound\\Music\\Pandaria\\MUS_54_Legendary_10.mp3", 23},
			{2081, "Sound\\Music\\Pandaria\\MUS_54_Legendary_Hero.mp3", 107},
		},
	},
	{
		id = 181,
		name = L["TITLE_MOKRAH"],
		files = {
			{2082, "Sound\\Music\\Pandaria\\MUS_54_Mok-Rah_01.mp3", 50},
			{2083, "Sound\\Music\\Pandaria\\MUS_54_Mok-Rah_02.mp3", 19},
			{2084, "Sound\\Music\\Pandaria\\MUS_54_Mok-Rah_03.mp3", 46},
			{2085, "Sound\\Music\\Pandaria\\MUS_54_Mok-Rah_04.mp3", 57},
			{2086, "Sound\\Music\\Pandaria\\MUS_54_Mok-Rah_05.mp3", 55},
			{2087, "Sound\\Music\\Pandaria\\MUS_54_Mok-Rah_06.mp3", 55},
			{2088, "Sound\\Music\\Pandaria\\MUS_54_Mok-Rah_07.mp3", 58},
			{2089, "Sound\\Music\\Pandaria\\MUS_54_Mok-Rah_08.mp3", 79},
			{2090, "Sound\\Music\\Pandaria\\MUS_54_Mok-Rah_Hero.mp3", 122},
		},
	},
	{
		id = 182,
		name = L["TITLE_WANDERINGISLE"],
		files = {
			{2091, "Sound\\Music\\ZoneMusic\\WanderingIsle\\MUS_50_WanderingIsleA_Hero_UU01.mp3", 101},
			{2092, "Sound\\Music\\ZoneMusic\\WanderingIsle\\MUS_50_WanderingIsleA_UU01.mp3", 97},
			{2093, "Sound\\Music\\ZoneMusic\\WanderingIsle\\MUS_50_WanderingIsleA_UU02.mp3", 107},
			{2094, "Sound\\Music\\ZoneMusic\\WanderingIsle\\MUS_50_WanderingIsleA_UU03.mp3", 68},
			{2095, "Sound\\Music\\ZoneMusic\\WanderingIsle\\MUS_50_WanderingIsleA_UU04.mp3", 108},
			{2096, "Sound\\Music\\ZoneMusic\\WanderingIsle\\MUS_50_WanderingIsleA_UU05.mp3", 54},
			{2097, "Sound\\Music\\ZoneMusic\\WanderingIsle\\MUS_50_WanderingIsleB_Hero_UU01.mp3", 135},
			{2098, "Sound\\Music\\ZoneMusic\\WanderingIsle\\MUS_50_WanderingIsleB_UU01.mp3", 87},
			{2099, "Sound\\Music\\ZoneMusic\\WanderingIsle\\MUS_50_WanderingIsleC_Hero_UU01.mp3", 84},
			{2100, "Sound\\Music\\ZoneMusic\\WanderingIsle\\MUS_50_WanderingIsleC_UU01.mp3", 88},
			{2101, "Sound\\Music\\ZoneMusic\\WanderingIsle\\MUS_50_WanderingIsleC_UU02.mp3", 75},
			{2102, "Sound\\Music\\ZoneMusic\\WanderingIsle\\MUS_50_WanderingIsleC_UU03.mp3", 88},
			{2103, "Sound\\Music\\ZoneMusic\\WanderingIsle\\MUS_50_WanderingIsleC_UU04.mp3", 82},
		},
	},
	{
		id = 183,
		name = L["TITLE_VALLEY4WINDS"],
		files = {
			{2104, "Sound\\Music\\Pandaria\\MUS_50_TheHeartland_Hero_01.mp3", 85},
			{2105, "Sound\\Music\\Pandaria\\MUS_50_TheHeartland_Hero_02.mp3", 58},
			{2106, "Sound\\Music\\Pandaria\\MUS_50_TheHeartland_Hero_03.mp3", 87},
			{2107, "Sound\\Music\\Pandaria\\MUS_50_TheHeartland_Hero_04.mp3", 147},
			{2108, "Sound\\Music\\Pandaria\\MUS_50_TheRiver_01.mp3", 42},
			{2109, "Sound\\Music\\Pandaria\\MUS_50_TheRiver_02.mp3", 58},
			{2110, "Sound\\Music\\Pandaria\\MUS_50_TheRiver_03.mp3", 51},
			{2111, "Sound\\Music\\Pandaria\\MUS_50_TheRiver_04.mp3", 64},
			{2112, "Sound\\Music\\Pandaria\\MUS_50_TheRiver_05.mp3", 124},
			{2113, "Sound\\Music\\Pandaria\\MUS_50_TheRiver_06.mp3", 129},
			{2114, "Sound\\Music\\Pandaria\\MUS_50_TheRiver_07.mp3", 126},
			{2115, "Sound\\Music\\Pandaria\\MUS_50_TheRiver_Hero_01.mp3", 133},
			{2116, "Sound\\Music\\Pandaria\\MUS_50_WoodofStaves_Hero_01.mp3", 64},
			{2117, "Sound\\Music\\Pandaria\\MUS_50_WoodofStaves_Hero_02.mp3", 76},
			{2118, "Sound\\Music\\Pandaria\\MUS_50_WoodofStaves_Hero_03.mp3", 65},
			{2594, "Sound\\Music\\Pandaria\\MUS_54_ValleyOfTheFourWindsNA_v1.mp3", 129},
		},
	},
	{
		id = 184,
		name = L["TITLE_SONG_LIULANG"],
		files = {
			{2119, "Sound\\Music\\Pandaria\\MUS_50_SongofLiulang_Inst_01.mp3", 125},
			{2120, "Sound\\Music\\Pandaria\\MUS_50_SongofLiulang_Inst_02.mp3", 166},
			{2121, "Sound\\Music\\Pandaria\\MUS_50_SongofLiulang_Inst_03.mp3", 52},
			{2122, "Sound\\Music\\Pandaria\\MUS_50_SongofLiulang_Inst_04.mp3", 45},
			{2123, "Sound\\Music\\Pandaria\\MUS_50_SongofLiulang_Inst_05.mp3", 82},
			{2124, "Sound\\Music\\Pandaria\\MUS_50_SongofLiulang_Inst_06.mp3", 72},
			{2125, "Sound\\Music\\Pandaria\\MUS_50_SongofLiulang_Inst_07.mp3", 114},
			{2126, "Sound\\Music\\Pandaria\\MUS_50_SongofLiulang_Inst_Hero_01.mp3", 168},
			{2127, "Sound\\Music\\Pandaria\\MUS_50_SongofLiulang_VOX_Hero_01.mp3", 170},
			{2128, "Sound\\Music\\Pandaria\\MUS_50_SongofLiulang_VOX_Lite_01.mp3", 234},
		},
	},
	{
		id = 185,
		name = L["TITLE_SERPENTRACE"],
		files = {
			{2129, "Sound\\Music\\Pandaria\\MUS_50_SerpentRiders_01.mp3", 152},
			{2130, "Sound\\Music\\Pandaria\\MUS_50_SerpentRiders_Hero_01.mp3", 152},
			{2131, "Sound\\Music\\Pandaria\\MUS_50_SerpentRiders_SerpentRace.mp3", 238},
			{2132, "Sound\\Music\\Pandaria\\MUS_50_SerpentRiders_Victory_Stinger.mp3", 39},
		},
	},
}

GJB.musictable[GJB.EXP_MOP] = music
