-- STRUCTURE 
-- [1] : Integer - ID of the music (new system)
-- [2] : String - Path of the music file
-- [3] : Integer - Length of the music file in seconds

-- Get localization
local GJB = LibStub("AceAddon-3.0"):GetAddon("GarrisonJukeBox")
local L = GJB.L -- local L = LibStub("AceLocale-3.0"):GetLocale("GarrisonJukeBox")

-- Cataclysm
local music = {
	{
		id = 82,
		name = L["TITLE_MAIN_THEME"],
		files = {
			{1065, "Sound\\Music\\cataclysm\\MUS_Shattering_UU01.mp3", 725},
		},
	},
	{
		id = 83,
		name = L["TITLE_DRUIDS_OT_FLAME"],
		files = {
			{1066, "Sound\\Music\\cataclysm\\MUS_42_DruidsoftheFlameA_Hero_UU01.mp3", 91},
			{1067, "Sound\\Music\\cataclysm\\MUS_42_DruidsoftheFlameA_UU01.mp3", 84},
			{1068, "Sound\\Music\\cataclysm\\MUS_42_DruidsoftheFlameA_UU02.mp3", 89},
			{1069, "Sound\\Music\\cataclysm\\MUS_42_DruidsoftheFlameA_UU03.mp3", 44},
			{1070, "Sound\\Music\\cataclysm\\MUS_42_DruidsoftheFlameB_Hero_UU01.mp3", 88},
			{1071, "Sound\\Music\\cataclysm\\MUS_42_DruidsoftheFlameB_UU01.mp3", 87},
			{1072, "Sound\\Music\\cataclysm\\MUS_42_DruidsoftheFlameB_UU02.mp3", 86},
			{1073, "Sound\\Music\\cataclysm\\MUS_42_DruidsoftheFlameB_UU03.mp3", 86},
		},
	},
	{
		id = 84,
		name = L["TITLE_ELEMENTALAIR"],
		files = {
			{1074, "Sound\\Music\\cataclysm\\MUS_42_Elemental_AirA_UU01.mp3", 47},
			{1075, "Sound\\Music\\cataclysm\\MUS_42_Elemental_AirA_UU02.mp3", 38},
			{1076, "Sound\\Music\\cataclysm\\MUS_42_Elemental_AirB_UU01.mp3", 44},
			{1077, "Sound\\Music\\cataclysm\\MUS_42_Elemental_AirB_UU02.mp3", 54},
			{1078, "Sound\\Music\\cataclysm\\MUS_42_Elemental_AirC_UU01.mp3", 61},
			{1079, "Sound\\Music\\cataclysm\\MUS_42_Elemental_AirD_UU01.mp3", 34},
			{1080, "Sound\\Music\\cataclysm\\MUS_42_Elemental_AirD_UU02.mp3", 34},
		},
	},
	{
		id = 85,
		name = L["TITLE_ELEMENTALEARTH"],
		files = {
			{1081, "Sound\\Music\\cataclysm\\MUS_42_Elemental_EarthA_UU01.mp3", 58},
			{1082, "Sound\\Music\\cataclysm\\MUS_42_Elemental_EarthA_UU02.mp3", 80},
			{1083, "Sound\\Music\\cataclysm\\MUS_42_Elemental_EarthA_UU03.mp3", 65},
			{1084, "Sound\\Music\\cataclysm\\MUS_42_Elemental_EarthA_UU04.mp3", 58},
		},
	},
	{
		id = 86,
		name = L["TITLE_ELEMENTALWATER"],
		files = {
			{1085, "Sound\\Music\\cataclysm\\MUS_42_Elemental_WaterA_UD01.mp3", 67},
			{1086, "Sound\\Music\\cataclysm\\MUS_42_Elemental_WaterA_UN01.mp3", 67},
			{1087, "Sound\\Music\\cataclysm\\MUS_42_Elemental_WaterB_UD01.mp3", 34},
			{1088, "Sound\\Music\\cataclysm\\MUS_42_Elemental_WaterB_UN01.mp3", 34},
			{1089, "Sound\\Music\\cataclysm\\MUS_42_Elemental_WaterC_UD01.mp3", 63},
			{1090, "Sound\\Music\\cataclysm\\MUS_42_Elemental_WaterC_UN01.mp3", 67},
		},
	},
	{
		id = 87,
		name = L["TITLE_ELEMENTALBONDS"],
		files = {
			{1091, "Sound\\Music\\cataclysm\\MUS_42_ElementalBondsA_UU01.mp3", 54},
			{1092, "Sound\\Music\\cataclysm\\MUS_42_ElementalBondsA_UU02.mp3", 54},
			{1093, "Sound\\Music\\cataclysm\\MUS_42_ElementalBondsA_UU03.mp3", 54},
			{1094, "Sound\\Music\\cataclysm\\MUS_42_ElementalBondsB_UU01.mp3", 29},
			{1095, "Sound\\Music\\cataclysm\\MUS_42_ElementalBondsB_UU02.mp3", 26},
		},
	},
	{
		id = 88,
		name = L["TITLE_THRALLAGGRA"],
		files = {
			{1096, "Sound\\Music\\cataclysm\\MUS_42_ThrallAggraA_ED01.mp3", 72},
			{1097, "Sound\\Music\\cataclysm\\MUS_42_ThrallAggraA_EN01.mp3", 61},
			{1098, "Sound\\Music\\cataclysm\\MUS_42_ThrallAggraB_ED01.mp3", 53},
			{1099, "Sound\\Music\\cataclysm\\MUS_42_ThrallAggraB_EN01.mp3", 44},
			{1100, "Sound\\Music\\cataclysm\\MUS_42_ThrallAggraC_EU01.mp3", 57},
			{1101, "Sound\\Music\\cataclysm\\MUS_42_ThrallAggraC_EU02.mp3", 57},
			{1102, "Sound\\Music\\cataclysm\\MUS_43_ThrallEarthWarder_UU01.mp3", 62},
			{1103, "Sound\\Music\\cataclysm\\MUS_43_ThrallEarthWarder_UU02.mp3", 42},
			{1104, "Sound\\Music\\cataclysm\\MUS_43_ThrallEarthWarder_UU03.mp3", 47},
			{1105, "Sound\\Music\\cataclysm\\MUS_43_ThrallEarthWarder_UU04.mp3", 29},
		},
	},
	{
		id = 89,
		name = L["TITLE_NIGHTELVES"],
		files = {
			{1106, "Sound\\Music\\cataclysm\\MUS_NightElves_GU01.mp3", 160},
			{1107, "Sound\\Music\\cataclysm\\MUS_NightElves_GU02.mp3", 85},
			{1108, "Sound\\Music\\cataclysm\\MUS_NightElves_GU03.mp3", 85},
			{1109, "Sound\\Music\\cataclysm\\MUS_NightElves_GU04.mp3", 81},
			{1110, "Sound\\Music\\cataclysm\\MUS_NightElves_GU05.mp3", 81},
			{1111, "Sound\\Music\\cataclysm\\MUS_SirenQuest_EU01.mp3", 42},
		},
	},
	{
		id = 90,
		name = L["TITLE_AFTERMATH"],
		files = {
			{1112, "Sound\\Music\\cataclysm\\MUS_Aftermath_UU01.mp3", 125},
			{1113, "Sound\\Music\\cataclysm\\MUS_Aftermath_UU02.mp3", 125},
			{1114, "Sound\\Music\\cataclysm\\MUS_Aftermath_UU03.mp3", 58},
			{1115, "Sound\\Music\\cataclysm\\MUS_Aftermath_UU04.mp3", 82},
		},
	},
	{
		id = 91,
		name = L["TITLE_DRAGONSOUL"],
		files = {
			{1116, "Sound\\Music\\cataclysm\\MUS_43_DragonSoulA_Hero_UU01.mp3", 32},
			{1117, "Sound\\Music\\cataclysm\\MUS_43_DragonSoulA_Moment_01.mp3", 31},
			{1118, "Sound\\Music\\cataclysm\\MUS_43_DragonSoulA_Moment_02.mp3", 32},
			{1119, "Sound\\Music\\cataclysm\\MUS_43_DragonSoulA_Moment_03.mp3", 32},
			{1120, "Sound\\Music\\cataclysm\\MUS_43_DragonSoulA_Moment_04.mp3", 60},
			{1121, "Sound\\Music\\cataclysm\\MUS_43_DragonSoulB_UU01.mp3", 47},
			{1122, "Sound\\Music\\cataclysm\\MUS_43_DragonSoulB_UU02.mp3", 49},
			{1123, "Sound\\Music\\cataclysm\\MUS_43_DragonSoulB_UU03.mp3", 51},
			{1124, "Sound\\Music\\cataclysm\\MUS_43_Gunships_Hero_UU01.mp3", 189},
			{1125, "Sound\\Music\\cataclysm\\MUS_43_Gunships_Stinger_01.mp3", 15},
			{1126, "Sound\\Music\\cataclysm\\MUS_43_Gunships_Stinger_02.mp3", 14},
			{1127, "Sound\\Music\\cataclysm\\MUS_43_Gunships_Stinger_03.mp3", 5},
			{1128, "Sound\\Music\\cataclysm\\MUS_43_Gunships_Stinger_04.mp3", 10},
			{1129, "Sound\\Music\\cataclysm\\MUS_43_Gunships_UU01.mp3", 31},
			{1130, "Sound\\Music\\cataclysm\\MUS_43_Gunships_UU02.mp3", 18},
			{1131, "Sound\\Music\\cataclysm\\MUS_43_Gunships_UU03.mp3", 42},
			{1132, "Sound\\Music\\cataclysm\\MUS_43_Gunships_UU04.mp3", 45},
		},
	},
	{
		id = 92,
		name = L["TITLE_DEATHWING"],
		files = {
			{1133, "Sound\\Music\\cataclysm\\MUS_43_DeathwingCorruption_UU01.mp3", 35},
			{1134, "Sound\\Music\\cataclysm\\MUS_43_DeathwingCorruption_UU02.mp3", 34},
			{1135, "Sound\\Music\\cataclysm\\MUS_43_DeathwingCorruption_UU03.mp3", 32},
			{1136, "Sound\\Music\\cataclysm\\MUS_43_DeathwingCorruption_UU04.mp3", 59},
			{1137, "Sound\\Music\\cataclysm\\MUS_43_DeathwingCorruption_UU05.mp3", 58},
			{1138, "Sound\\Music\\cataclysm\\MUS_43_DeathwingCorruption_UU06.mp3", 31},
			{1139, "Sound\\Music\\cataclysm\\MUS_43_DeathwingCorruption_UU07.mp3", 70},
			{1140, "Sound\\Music\\cataclysm\\MUS_43_DeathwingOutro_UU01.mp3", 58},
			{1141, "Sound\\Music\\cataclysm\\MUS_43_DeathwingsFall_Hero_UU01.mp3", 147},
			{1142, "Sound\\Music\\cataclysm\\MUS_43_DeathwingsFall_UU01.mp3", 111},
			{1143, "Sound\\Music\\cataclysm\\MUS_43_DeathwingsFall_UU02.mp3", 104},
		},
	},
	{
		id = 93,
		name = L["TITLE_FANGS_OT_FATHER"],
		files = {
			{1144, "Sound\\Music\\cataclysm\\MUS_43_FangsOfTheFatherA_Hero_UU01.mp3", 121},
			{1145, "Sound\\Music\\cataclysm\\MUS_43_FangsOfTheFatherA_UU01.mp3", 97},
			{1146, "Sound\\Music\\cataclysm\\MUS_43_FangsOfTheFatherA_UU02.mp3", 99},
			{1147, "Sound\\Music\\cataclysm\\MUS_43_FangsOfTheFatherA_UU03.mp3", 92},
			{1148, "Sound\\Music\\cataclysm\\MUS_43_FangsOfTheFatherB_UU01.mp3", 77},
			{1149, "Sound\\Music\\cataclysm\\MUS_43_FangsOfTheFatherB_UU02.mp3", 61},
			{1150, "Sound\\Music\\cataclysm\\MUS_43_FangsOfTheFatherB_UU03.mp3", 61},
			{1151, "Sound\\Music\\cataclysm\\MUS_43_FangsOfTheFatherC_Hero_UU01.mp3", 151},
			{1152, "Sound\\Music\\cataclysm\\MUS_43_FangsOfTheFatherC_UU02.mp3", 80},
			{1153, "Sound\\Music\\cataclysm\\MUS_43_FangsOfTheFatherC_UU03.mp3", 74},
			{1154, "Sound\\Music\\cataclysm\\MUS_43_FangsOfTheFatherC_UU04.mp3", 63},
		},
	},
	{
		id = 94,
		name = L["TITLE_HAUNTED"],
		files = {
			{1155, "Sound\\Music\\cataclysm\\MUS_Haunted_UU01.mp3", 111},
			{1156, "Sound\\Music\\cataclysm\\MUS_Haunted_UU02.mp3", 128},
			{1157, "Sound\\Music\\cataclysm\\MUS_Haunted_UU03.mp3", 109},
		},
	},
	{
		id = 95,
		name = L["TITLE_WARSHIPS"],
		files = {
			{1158, "Sound\\Music\\cataclysm\\MUS_43_Warships_Hero_01.mp3", 90},
			{1159, "Sound\\Music\\cataclysm\\MUS_43_Warships_UU01.mp3", 66},
			{1160, "Sound\\Music\\cataclysm\\MUS_43_Warships_UU02.mp3", 29},
		},
	},
	{
		id = 96,
		name = L["TITLE_NIGHTWALK"],
		files = {
			{1161, "Sound\\Music\\cataclysm\\MUS_43_NightWalk_UU01.mp3", 59},
			{1162, "Sound\\Music\\cataclysm\\MUS_43_NightWalk_UU02.mp3", 60},
			{1163, "Sound\\Music\\cataclysm\\MUS_43_NightWalk_UU03.mp3", 59},
			{1164, "Sound\\Music\\cataclysm\\MUS_43_NightWalk_UU04.mp3", 59},
		},
	},
	{
		id = 97,
		name = L["TITLE_TWILIGHTHIGHLANDS"],
		files = {
			{1165, "Sound\\Music\\cataclysm\\MUS_43_TwilightsHammer_UU01.mp3", 113},
			{1166, "Sound\\Music\\cataclysm\\MUS_43_TwilightsHammer_UU02.mp3", 55},
			{1167, "Sound\\Music\\cataclysm\\MUS_TwilightHighlands_GU01.mp3", 68},
			{1168, "Sound\\Music\\cataclysm\\MUS_TwilightHighlands_GU02.mp3", 67},
			{1169, "Sound\\Music\\cataclysm\\MUS_TwilightHighlands_GU03.mp3", 67},
			{1170, "Sound\\Music\\cataclysm\\MUS_TwilightHighlands_GU04.mp3", 78},
			{1171, "Sound\\Music\\cataclysm\\MUS_TwilightHighlands_GU05.mp3", 67},
			{1172, "Sound\\Music\\cataclysm\\MUS_TwilightsHammer_UU01.mp3", 92},
			{1173, "Sound\\Music\\cataclysm\\MUS_TwilightsHammer_UU02.mp3", 48},
			{1174, "Sound\\Music\\cataclysm\\MUS_TwilightsHammer_UU03.mp3", 48},
			{1175, "Sound\\Music\\cataclysm\\MUS_TwilightVale_GU01.mp3", 110},
			{1176, "Sound\\Music\\cataclysm\\MUS_TwilightVale_GU02.mp3", 81},
			{1177, "Sound\\Music\\cataclysm\\MUS_TwilightVale_GU03.mp3", 80},
			{1178, "Sound\\Music\\cataclysm\\MUS_TwilightVale_GU04.mp3", 62},
			{1179, "Sound\\Music\\cataclysm\\MUS_TwilightVale_GU05.mp3", 46},
		},
	},
	{
		id = 98,
		name = L["TITLE_WELLOFETERNITY"],
		files = {
			{1180, "Sound\\Music\\cataclysm\\MUS_43_WellOfEternity_Hero_UU01.mp3", 84},
			{1181, "Sound\\Music\\cataclysm\\MUS_43_WellOfEternity_UU01.mp3", 84},
			{1182, "Sound\\Music\\cataclysm\\MUS_43_WellOfEternity_UU02.mp3", 84},
			{1183, "Sound\\Music\\cataclysm\\MUS_43_WellOfEternity_UU03.mp3", 92},
			{1184, "Sound\\Music\\cataclysm\\MUS_43_WellOfEternity_UU04.mp3", 102},
			{1185, "Sound\\Music\\cataclysm\\MUS_43_WellOfEternity_UU05.mp3", 85},
			{1186, "Sound\\Music\\cataclysm\\MUS_43_WellOfEternity_UU06.mp3", 85},
		},
	},
	{
		id = 99,
		name = L["TITLE_ZINAZSHARI"],
		files = {
			{1187, "Sound\\Music\\cataclysm\\MUS_43_ZinAzshari_Hero_UU01.mp3", 177},
			{1188, "Sound\\Music\\cataclysm\\MUS_43_ZinAzshari_UU01.mp3", 92},
			{1189, "Sound\\Music\\cataclysm\\MUS_43_ZinAzshari_UU02.mp3", 71},
			{1190, "Sound\\Music\\cataclysm\\MUS_43_ZinAzshari_UU03.mp3", 51},
			{1191, "Sound\\Music\\cataclysm\\MUS_43_ZinAzshari_UU04.mp3", 107},
			{1192, "Sound\\Music\\cataclysm\\MUS_43_ZinAzshari_UU05.mp3", 46},
			{1193, "Sound\\Music\\cataclysm\\MUS_43_ZinAzshari_UU06.mp3", 113},
		},
	},
	{
		id = 100,
		name = L["TITLE_RAGE_OT_FIRELANDS"],
		files = {
			{1194, "Sound\\Music\\cataclysm\\MUS_42_FirelandsA_Hero_UU01.mp3", 103},
			{1195, "Sound\\Music\\cataclysm\\MUS_42_FirelandsA_UU01.mp3", 91},
			{1196, "Sound\\Music\\cataclysm\\MUS_42_FirelandsA_UU02.mp3", 76},
			{1197, "Sound\\Music\\cataclysm\\MUS_42_FirelandsA_UU03.mp3", 58},
			{1198, "Sound\\Music\\cataclysm\\MUS_42_FirelandsB_Hero_UU01.mp3", 108},
			{1199, "Sound\\Music\\cataclysm\\MUS_42_FirelandsB_UU01.mp3", 63},
			{1200, "Sound\\Music\\cataclysm\\MUS_42_FirelandsB_UU02.mp3", 53},
			{1201, "Sound\\Music\\cataclysm\\MUS_42_FirelandsB_UU03.mp3", 65},
			{1202, "Sound\\Music\\cataclysm\\MUS_42_FirelandsB_UU04.mp3", 52},
			{1203, "Sound\\Music\\cataclysm\\MUS_AdventureA_Hero_UU01.mp3", 141},
			{1204, "Sound\\Music\\cataclysm\\MUS_AdventureA_Moment_UU01.mp3", 13},
			{1205, "Sound\\Music\\cataclysm\\MUS_AdventureA_Moment_UU02.mp3", 15},
			{1206, "Sound\\Music\\cataclysm\\MUS_AdventureA_Moment_UU03.mp3", 22},
			{1207, "Sound\\Music\\cataclysm\\MUS_AdventureA_Moment_UU04.mp3", 16},
			{1208, "Sound\\Music\\cataclysm\\MUS_AdventureA_UU01.mp3", 52},
			{1209, "Sound\\Music\\cataclysm\\MUS_AdventureA_UU03.mp3", 35},
			{1210, "Sound\\Music\\cataclysm\\MUS_AdventureA_UU04.mp3", 49},
			{1211, "Sound\\Music\\cataclysm\\MUS_AdventureA_UU05.mp3", 53},
			{1212, "Sound\\Music\\cataclysm\\MUS_AdventureA_UU06.mp3", 43},
			{1213, "Sound\\Music\\cataclysm\\MUS_Firelands_GU01.mp3", 148},
		},
	},
	{
		id = 101,
		name = L["TITLE_GILNEAS"],
		files = {
			{1214, "Sound\\Music\\cataclysm\\MUS_AllianceHero_UU01.mp3", 195},
			{1215, "Sound\\Music\\cataclysm\\MUS_Cataclysm_UU01.mp3", 79},
			{1216, "Sound\\Music\\cataclysm\\MUS_Cataclysm_UU02.mp3", 71},
			{1217, "Sound\\Music\\cataclysm\\MUS_Cataclysm_UU03.mp3", 61},
			{1218, "Sound\\Music\\cataclysm\\MUS_Cataclysm_UU04.mp3", 111},
			{1219, "Sound\\Music\\cataclysm\\MUS_Cataclysm_UU05.mp3", 73},
			{1220, "Sound\\Music\\cataclysm\\MUS_Cataclysm_UU06.mp3", 48},
			{1221, "Sound\\Music\\cataclysm\\MUS_GilneasEvent_E01.mp3", 32},
			{1222, "Sound\\Music\\cataclysm\\MUS_GilneasEvent_E02.mp3", 24},
			{1223, "Sound\\Music\\cataclysm\\MUS_GilneasEvent_E03.mp3", 28},
			{1224, "Sound\\Music\\cataclysm\\MUS_GilneasEvent_E04.mp3", 108},
		},
	},
	{
		id = 102,
		name = L["TITLE_BARROWDENS"],
		files = {
			{1225, "Sound\\Music\\cataclysm\\MUS_BarrowDens_GU01.mp3", 64},
			{1226, "Sound\\Music\\cataclysm\\MUS_BarrowDens_GU02.mp3", 50},
			{1227, "Sound\\Music\\cataclysm\\MUS_BarrowDens_GU03.mp3", 66},
			{1228, "Sound\\Music\\cataclysm\\MUS_BarrowDens_GU04.mp3", 51},
			{1229, "Sound\\Music\\cataclysm\\MUS_BarrowDens_GU05.mp3", 58},
		},
	},
	{
		id = 103,
		name = L["TITLE_CHOGALL"],
		files = {
			{1230, "Sound\\Music\\cataclysm\\MUS_ChoGall_E01.mp3", 169},
			{1231, "Sound\\Music\\cataclysm\\MUS_ChoGall_E02.mp3", 60},
			{1232, "Sound\\Music\\cataclysm\\MUS_ChoGall_E03.mp3", 29},
			{1233, "Sound\\Music\\cataclysm\\MUS_ChoGall_E04.mp3", 19},
		},
	},
	{
		id = 104,
		name = L["TITLE_COLDMOUNTAINS"],
		files = {
			{1234, "Sound\\Music\\cataclysm\\MUS_ColdMountain_GU01.mp3", 151},
			{1235, "Sound\\Music\\cataclysm\\MUS_ColdMountain_GU02.mp3", 39},
			{1236, "Sound\\Music\\cataclysm\\MUS_ColdMountain_GU03.mp3", 70},
			{1237, "Sound\\Music\\cataclysm\\MUS_ColdMountain_GU04.mp3", 32},
			{1238, "Sound\\Music\\cataclysm\\MUS_ColdMountain_GU05.mp3", 31},
			{1239, "Sound\\Music\\cataclysm\\MUS_ColdMountain_GU06.mp3", 48},
			{1240, "Sound\\Music\\cataclysm\\MUS_ColdMountain_GU07.mp3", 68},
			{1241, "Sound\\Music\\cataclysm\\MUS_ColdMountain_GU08.mp3", 71},
		},
	},
	{
		id = 105,
		name = L["TITLE_HYJAL"],
		files = {
			{1242, "Sound\\Music\\cataclysm\\MUS_DarkwhisperGorge_GU01.mp3", 119},
			{1243, "Sound\\Music\\cataclysm\\MUS_DarkwhisperGorge_GU02.mp3", 118},
			{1244, "Sound\\Music\\cataclysm\\MUS_Fire_UU01.mp3", 62},
			{1245, "Sound\\Music\\cataclysm\\MUS_Fire_UU02.mp3", 43},
			{1246, "Sound\\Music\\cataclysm\\MUS_GuardiansofHyjal_GU01.mp3", 133},
			{1247, "Sound\\Music\\cataclysm\\MUS_GuardiansofHyjal_GU02.mp3", 137},
			{1248, "Sound\\Music\\cataclysm\\MUS_GuardiansofHyjal_GU03.mp3", 80},
			{1249, "Sound\\Music\\cataclysm\\MUS_GuardiansofHyjal_GU04.mp3", 143},
			{1250, "Sound\\Music\\cataclysm\\MUS_Hyjal_GU01.mp3", 84},
			{1251, "Sound\\Music\\cataclysm\\MUS_Hyjal_GU02.mp3", 84},
			{1252, "Sound\\Music\\cataclysm\\MUS_Hyjal_GU03.mp3", 84},
			{1253, "Sound\\Music\\cataclysm\\MUS_Hyjal_GU04.mp3", 116},
			{1254, "Sound\\Music\\cataclysm\\MUS_LandWillWeep_UU01.mp3", 53},
			{1255, "Sound\\Music\\cataclysm\\MUS_LandWillWeep_UU02.mp3", 53},
			{1256, "Sound\\Music\\cataclysm\\MUS_Nordrassil_GU01.mp3", 117},
			{1257, "Sound\\Music\\cataclysm\\MUS_Nordrassil_GU02.mp3", 115},
			{1258, "Sound\\Music\\cataclysm\\MUS_Nordrassil_GU03.mp3", 117},
			{1259, "Sound\\Music\\cataclysm\\MUS_Crypt_UU01.mp3", 105},
			{1260, "Sound\\Music\\cataclysm\\MUS_FlowerAura_EU_01.mp3", 28},
			{1261, "Sound\\Music\\cataclysm\\MUS_Mysterious_UU01.mp3", 99},
		},
	},
	{
		id = 106,
		name = L["TITLE_DEEPHOLM"],
		files = {
			{1262, "Sound\\Music\\cataclysm\\MUS_Deepholm_GU01.mp3", 123},
			{1263, "Sound\\Music\\cataclysm\\MUS_Deepholm_GU02.mp3", 126},
			{1264, "Sound\\Music\\cataclysm\\MUS_DeepholmEvent_E01.mp3", 114},
			{1265, "Sound\\Music\\cataclysm\\MUS_DeepholmEvent_E02.mp3", 136},
			{1266, "Sound\\Music\\cataclysm\\MUS_Elemental_UU01.mp3", 59},
			{1267, "Sound\\Music\\cataclysm\\MUS_Elemental_UU02.mp3", 40},
			{1268, "Sound\\Music\\cataclysm\\MUS_Elemental_UU03.mp3", 38},
			{1269, "Sound\\Music\\cataclysm\\MUS_Elemental_UU04.mp3", 131},
			{1270, "Sound\\Music\\cataclysm\\MUS_Elemental_UU05.mp3", 72},
			{1271, "Sound\\Music\\cataclysm\\MUS_Elemental_UU06.mp3", 46},
			{1272, "Sound\\Music\\cataclysm\\MUS_Elemental_UU07.mp3", 69},
			{1273, "Sound\\Music\\cataclysm\\MUS_Scarred_UU01.mp3", 78},
			{1274, "Sound\\Music\\cataclysm\\MUS_Scarred_UU02.mp3", 27},
			{1275, "Sound\\Music\\cataclysm\\MUS_Scarred_UU03.mp3", 35},
			{1276, "Sound\\Music\\cataclysm\\MUS_Scarred_UU04.mp3", 51},
			{1277, "Sound\\Music\\cataclysm\\MUS_PiratesSurrender_UU01.mp3", 128},
		},
	},
	{
		id = 107,
		name = L["TITLE_EYE_OT_VORTEX"],
		files = {
			{1278, "Sound\\Music\\cataclysm\\MUS_EyeOfTheVortex_GU01.mp3", 97},
			{1279, "Sound\\Music\\cataclysm\\MUS_EyeOfTheVortex_GU02.mp3", 49},
			{1280, "Sound\\Music\\cataclysm\\MUS_EyeOfTheVortex_GU03.mp3", 69},
			{1281, "Sound\\Music\\cataclysm\\MUS_DarkEvent_E01.mp3", 39},
		},
	},
	{
		id = 108,
		name = L["TITLE_GOBLINS"],
		files = {
			{1282, "Sound\\Music\\cataclysm\\MUS_Goblin_UU01.mp3", 24},
			{1283, "Sound\\Music\\cataclysm\\MUS_Goblin_UU02.mp3", 12},
			{1284, "Sound\\Music\\cataclysm\\MUS_Goblin_UU03.mp3", 9},
			{1285, "Sound\\Music\\cataclysm\\MUS_Goblin_UU04.mp3", 14},
			{1286, "Sound\\Music\\cataclysm\\MUS_Goblin_UU05.mp3", 19},
			{1287, "Sound\\Music\\cataclysm\\MUS_Goblin_UU06.mp3", 18},
			{1288, "Sound\\Music\\cataclysm\\MUS_Goblin_UU07.mp3", 10},
			{1289, "Sound\\Music\\cataclysm\\MUS_Goblin_UU08.mp3", 47},
			{1290, "Sound\\Music\\cataclysm\\MUS_Goblin_UU09.mp3", 86},
			{1291, "Sound\\Music\\cataclysm\\MUS_Goblin_UU10.mp3", 47},
			{1292, "Sound\\Music\\cataclysm\\MUS_Goblin_UU11.mp3", 45},
			{1293, "Sound\\Music\\cataclysm\\MUS_Goblin_UU12.mp3", 46},
			{1294, "Sound\\Music\\cataclysm\\MUS_Goblin_UU13.mp3", 47},
			{1295, "Sound\\Music\\cataclysm\\MUS_Goblin_UU14.mp3", 47},
			{1296, "Sound\\Music\\cataclysm\\MUS_Goblin_UU15.mp3", 47},
			{1297, "Sound\\Music\\cataclysm\\MUS_Goblin_UU16.mp3", 87},
			{1298, "Sound\\Music\\cataclysm\\MUS_Goblin_UU17.mp3", 86},
			{1299, "Sound\\Music\\cataclysm\\MUS_Goblin_UU18.mp3", 85},
			{1300, "Sound\\Music\\cataclysm\\MUS_Goblin_UU19.mp3", 24},
			{1301, "Sound\\Music\\cataclysm\\MUS_Goblin_UU20.mp3", 11},
			{1302, "Sound\\Music\\cataclysm\\MUS_Goblin_UU21.mp3", 11},
			{1303, "Sound\\Music\\cataclysm\\MUS_Goblin_UU22.mp3", 19},
			{1304, "Sound\\Music\\cataclysm\\MUS_Goblin_UU23.mp3", 8},
			{1305, "Sound\\Music\\cataclysm\\MUS_Goblin_UU24.mp3", 14},
			{1306, "Sound\\Music\\cataclysm\\MUS_Goblin_UU25.mp3", 14},
			{1307, "Sound\\Music\\cataclysm\\MUS_Goblin_UU26.mp3", 19},
			{1308, "Sound\\Music\\cataclysm\\MUS_Goblin_UU27.mp3", 19},
			{1309, "Sound\\Music\\cataclysm\\MUS_Goblin_UU28.mp3", 19},
			{1310, "Sound\\Music\\cataclysm\\MUS_Goblin_UU29.mp3", 16},
			{1311, "Sound\\Music\\cataclysm\\MUS_Goblin_UU30.mp3", 18},
			{1312, "Sound\\Music\\cataclysm\\MUS_Goblin_UU31.mp3", 19},
			{1313, "Sound\\Music\\cataclysm\\MUS_Goblin_UU32.mp3", 14},
			{1314, "Sound\\Music\\cataclysm\\MUS_Goblin_UU33.mp3", 15},
			{1315, "Sound\\Music\\cataclysm\\MUS_Goblin_UU34.mp3", 18},
			{1316, "Sound\\Music\\cataclysm\\MUS_Goblin_UU35.mp3", 17},
			{1317, "Sound\\Music\\cataclysm\\MUS_Goblin_UU36.mp3", 16},
			{1318, "Sound\\Music\\cataclysm\\MUS_Goblin_UU37.mp3", 17},
			{1319, "Sound\\Music\\cataclysm\\MUS_Goblin_UU38.mp3", 8},
			{1320, "Sound\\Music\\cataclysm\\MUS_Goblin_UU39.mp3", 8},
			{1321, "Sound\\Music\\cataclysm\\MUS_Goblin_UU40.mp3", 10},
			{1322, "Sound\\Music\\cataclysm\\MUS_Goblin_UU41.mp3", 17},
			{1323, "Sound\\Music\\cataclysm\\MUS_Goblin_UU42.mp3", 18},
			{1324, "Sound\\Music\\cataclysm\\MUS_Goblin_UU43.mp3", 21},
			{1325, "Sound\\Music\\cataclysm\\MUS_Goblin_UU44.mp3", 20},
			{1326, "Sound\\Music\\cataclysm\\MUS_Goblin_UU45.mp3", 16},
			{1327, "Sound\\Music\\cataclysm\\MUS_Goblin_UU46.mp3", 18},
			{1328, "Sound\\Music\\cataclysm\\MUS_Goblin_UU47.mp3", 51},
			{1329, "Sound\\Music\\cataclysm\\MUS_GoblinHotRodRadioLoop_EU01.mp3", 165},
			{1330, "Sound\\Music\\cataclysm\\MUS_LIRescue_EU01.mp3", 37},
			{1331, "Sound\\Music\\cataclysm\\MUS_LIRescue_EU02.mp3", 11},
			{1332, "Sound\\Music\\cataclysm\\MUS_LIRescue_EU03.mp3", 53},
			{1333, "Sound\\Music\\cataclysm\\MUS_LIRescue_EU04.mp3", 87},
		},
	},
	{
		id = 109,
		name = L["TITLE_ULDUM"],
		files = {
			{1334, "Sound\\Music\\cataclysm\\MUS_LostCity_GU01.mp3", 133},
			{1335, "Sound\\Music\\cataclysm\\MUS_LostCity_GU02.mp3", 118},
			{1336, "Sound\\Music\\cataclysm\\MUS_LostCity_GU03.mp3", 80},
			{1337, "Sound\\Music\\cataclysm\\MUS_LostCity_GU04.mp3", 98},
			{1338, "Sound\\Music\\cataclysm\\MUS_LostCity_GU05.mp3", 72},
			{1339, "Sound\\Music\\cataclysm\\MUS_Skywall_GU01.mp3", 159},
			{1340, "Sound\\Music\\cataclysm\\MUS_Skywall_GU02.mp3", 207},
			{1341, "Sound\\Music\\cataclysm\\MUS_Skywall_GU03.mp3", 109},
			{1342, "Sound\\Music\\cataclysm\\MUS_Skywall_GU04.mp3", 117},
			{1343, "Sound\\Music\\cataclysm\\MUS_Skywall_GU05.mp3", 140},
			{1344, "Sound\\Music\\cataclysm\\MUS_Skywall_GU06.mp3", 42},
			{1345, "Sound\\Music\\cataclysm\\MUS_Skywall_GU07.mp3", 42},
			{1346, "Sound\\Music\\cataclysm\\MUS_Skywall_GU08.mp3", 42},
			{1347, "Sound\\Music\\cataclysm\\MUS_Skywall_GU09.mp3", 207},
			{1348, "Sound\\Music\\cataclysm\\MUS_Skywall_GU10.mp3", 109},
			{1349, "Sound\\Music\\cataclysm\\MUS_Treasure_UU01.mp3", 158},
			{1350, "Sound\\Music\\cataclysm\\MUS_Treasure_UU02.mp3", 91},
			{1351, "Sound\\Music\\cataclysm\\MUS_Treasure_UU03.mp3", 63},
			{1352, "Sound\\Music\\cataclysm\\MUS_Treasure_UU04.mp3", 69},
			{1353, "Sound\\Music\\cataclysm\\MUS_Treasure_UU05.mp3", 77},
			{1354, "Sound\\Music\\cataclysm\\MUS_Treasure_UU06.mp3", 70},
			{1355, "Sound\\Music\\cataclysm\\MUS_UldumA_GU01.mp3", 134},
			{1356, "Sound\\Music\\cataclysm\\MUS_UldumA_GU02.mp3", 44},
			{1357, "Sound\\Music\\cataclysm\\MUS_UldumA_GU03.mp3", 94},
			{1358, "Sound\\Music\\cataclysm\\MUS_UldumA_GU04.mp3", 110},
			{1359, "Sound\\Music\\cataclysm\\MUS_UldumA_GU05.mp3", 110},
			{1360, "Sound\\Music\\cataclysm\\MUS_UldumB_GU01.mp3", 126},
			{1361, "Sound\\Music\\cataclysm\\MUS_UldumB_GU02.mp3", 127},
			{1362, "Sound\\Music\\cataclysm\\MUS_UldumB_GU03.mp3", 127},
			{1363, "Sound\\Music\\cataclysm\\MUS_UldumB_GU04.mp3", 56},
			{1364, "Sound\\Music\\cataclysm\\MUS_UldumB_GU05.mp3", 57},
			{1365, "Sound\\Music\\cataclysm\\MUS_UldumB_GU06.mp3", 93},
			{1366, "Sound\\Music\\cataclysm\\MUS_UldumEvent_E01.mp3", 79},
		},
	},
	{
		id = 110,
		name = L["TITLE_VASHJIR"],
		files = {
			{1367, "Sound\\Music\\cataclysm\\MUS_Rift_UU01.mp3", 90},
			{1368, "Sound\\Music\\cataclysm\\MUS_Rift_UU02.mp3", 63},
			{1369, "Sound\\Music\\cataclysm\\MUS_Rift_UU03.mp3", 32},
			{1370, "Sound\\Music\\cataclysm\\MUS_Rift_UU04.mp3", 61},
			{1371, "Sound\\Music\\cataclysm\\MUS_Vashjir_GU01.mp3", 98},
			{1372, "Sound\\Music\\cataclysm\\MUS_Vashjir_GU02.mp3", 98},
			{1373, "Sound\\Music\\cataclysm\\MUS_Vashjir_GU03.mp3", 153},
			{1374, "Sound\\Music\\cataclysm\\MUS_Vashjir_GU04.mp3", 48},
			{1375, "Sound\\Music\\cataclysm\\MUS_Vashjir_GU05.mp3", 92},
			{1376, "Sound\\Music\\cataclysm\\MUS_Vashjir_GU06.mp3", 153},
			{1377, "Sound\\Music\\cataclysm\\MUS_Vashjir_GU07.mp3", 91},
			{1378, "Sound\\Music\\cataclysm\\MUS_Vashjir_GU08.mp3", 46},
			{1379, "Sound\\Music\\cataclysm\\MUS_Vashjir_GU09.mp3", 132},
			{1380, "Sound\\Music\\cataclysm\\MUS_VashjirNaga_GU01.mp3", 87},
			{1381, "Sound\\Music\\cataclysm\\MUS_VashjirNaga_GU02.mp3", 97},
			{1382, "Sound\\Music\\cataclysm\\MUS_VashjirNaga_GU03.mp3", 97},
			{1383, "Sound\\Music\\cataclysm\\MUS_VashjirNaga_GU04.mp3", 97},
			{1384, "Sound\\Music\\cataclysm\\MUS_VashjirNaga_GU05.mp3", 127},
			{1385, "Sound\\Music\\cataclysm\\MUS_VashjirNaga_GU06.mp3", 113},
			{1386, "Sound\\Music\\cataclysm\\MUS_VashjirNagaThrone_GU01.mp3", 43},
			{1387, "Sound\\Music\\cataclysm\\MUS_VashjirNagaThrone_GU02.mp3", 89},
			{1388, "Sound\\Music\\cataclysm\\MUS_VashjirNagaThrone_GU03.mp3", 96},
			{1389, "Sound\\Music\\cataclysm\\MUS_VashjirNagaThrone_GU04.mp3", 96},
			{1390, "Sound\\Music\\cataclysm\\MUS_VashjirNagaThrone_GU05.mp3", 91},
			{1391, "Sound\\Music\\cataclysm\\MUS_VashjirNagaThrone_GU06.mp3", 92},
		},
	},
	{
		id = 111,
		name = L["TITLE_SHADOWS"],
		files = {
			{1392, "Sound\\Music\\cataclysm\\MUS_Shadows_UU01.mp3", 90},
			{1393, "Sound\\Music\\cataclysm\\MUS_Shadows_UU02.mp3", 29},
			{1394, "Sound\\Music\\cataclysm\\MUS_Shadows_UU03.mp3", 53},
			{1395, "Sound\\Music\\cataclysm\\MUS_Shadows_UU04.mp3", 70},
			{1396, "Sound\\Music\\cataclysm\\MUS_Shadows_UU05.mp3", 60},
		},
	},
	{
		id = 112,
		name = L["TITLE_WORDS_AND_MUSIC"],
		files = {
			{1397, "Sound\\Music\\cataclysm\\MUS_WordsAndMusicByEvent_E01.mp3", 52},
		},
	},
	{
		id = 113,
		name = L["TITLE_CHAMBEROTASPECTS"],
		files = {
			{1398, "Sound\\Music\\ZoneMusic\\ChamberOfTheAspects\\CA_AspectsGeneralWalkADay01.mp3", 93},
			{1399, "Sound\\Music\\ZoneMusic\\ChamberOfTheAspects\\CA_AspectsGeneralWalkADay02.mp3", 133},
			{1400, "Sound\\Music\\ZoneMusic\\ChamberOfTheAspects\\CA_AspectsGeneralWalkADay03.mp3", 75},
			{1401, "Sound\\Music\\ZoneMusic\\ChamberOfTheAspects\\CA_AspectsGeneralWalkADay04.mp3", 65},
			{1402, "Sound\\Music\\ZoneMusic\\ChamberOfTheAspects\\CA_AspectsGeneralWalkANight01.mp3", 90},
			{1403, "Sound\\Music\\ZoneMusic\\ChamberOfTheAspects\\CA_AspectsGeneralWalkANight02.mp3", 133},
			{1404, "Sound\\Music\\ZoneMusic\\ChamberOfTheAspects\\CA_AspectsGeneralWalkANight03.mp3", 75},
			{1405, "Sound\\Music\\ZoneMusic\\ChamberOfTheAspects\\CA_AspectsGeneralWalkANight04.mp3", 65},
			{1406, "Sound\\Music\\ZoneMusic\\ChamberOfTheAspects\\CA_AspectsGeneralWalkAUni01.mp3", 75},
			{1407, "Sound\\Music\\ZoneMusic\\ChamberOfTheAspects\\CA_AspectsGeneralWalkAUni02.mp3", 65},
			{1408, "Sound\\Music\\ZoneMusic\\ChamberOfTheAspects\\CA_AspectsIntroADay01.mp3", 73},
			{1409, "Sound\\Music\\ZoneMusic\\ChamberOfTheAspects\\CA_AspectsIntroANight01.mp3", 73},
		},
	},
}

GJB.musictable[GJB.EXP_CATA1] = music
