-- STRUCTURE 
-- [1] : Integer - ID of the music (new system)
-- [2] : String - Path of the music file
-- [3] : Integer - Length of the music file in seconds

-- Get localization
local GJB = LibStub("AceAddon-3.0"):GetAddon("GarrisonJukeBox")
local L = GJB.L -- local L = LibStub("AceLocale-3.0"):GetLocale("GarrisonJukeBox")

-- The Burning Crusade
local music = {
	{
		id = 25,
		name = L["TITLE_MAIN_THEME"],
		files = {
			{167, "Sound\\Music\\GlueScreenMusic\\BC_main_theme.mp3", 226},
		},
	},
	{
		id = 26,
		name = L["TITLE_LAMENTOTHIGHBORNE"],
		files = {
			{168, "Sound\\Music\\GlueScreenMusic\\BCCredits_Lament_of_the_Highborne.mp3", 171},
		},
	},
	{
		id = 27,
		name = L["TITLE_OUTLAND_GENERAL"],
		files = {
			{169, "Sound\\Music\\ZoneMusic\\OutlandGeneral\\OL_ActionWalkUni01.mp3", 80},
			{170, "Sound\\Music\\ZoneMusic\\OutlandGeneral\\OL_AllianceBaseWalkUni01.mp3", 134},
			{171, "Sound\\Music\\ZoneMusic\\OutlandGeneral\\OL_AllianceBaseWalkUni02.mp3", 110},
			{172, "Sound\\Music\\ZoneMusic\\OutlandGeneral\\OL_ArakkoaIntroUni01.mp3", 18},
			{173, "Sound\\Music\\ZoneMusic\\OutlandGeneral\\OL_ArakkoaIntroUni02.mp3", 14},
			{174, "Sound\\Music\\ZoneMusic\\OutlandGeneral\\OL_BloodElfBaseWalkUni01.mp3", 120},
			{175, "Sound\\Music\\ZoneMusic\\OutlandGeneral\\OL_BloodElfBaseWalkUni02.mp3", 121},
			{176, "Sound\\Music\\ZoneMusic\\OutlandGeneral\\OL_BurningLegionIntroUni01.mp3", 16},
			{177, "Sound\\Music\\ZoneMusic\\OutlandGeneral\\OL_BurningLegionIntroUni02.mp3", 35},
			{178, "Sound\\Music\\ZoneMusic\\OutlandGeneral\\OL_CenarionIntroUni01.mp3", 44},
			{179, "Sound\\Music\\ZoneMusic\\OutlandGeneral\\OL_CenarionIntroUni02.mp3", 45},
			{180, "Sound\\Music\\ZoneMusic\\OutlandGeneral\\OL_CenarionIntroUni03.mp3", 71},
			{181, "Sound\\Music\\ZoneMusic\\OutlandGeneral\\OL_Corrupt01.mp3", 61},
			{182, "Sound\\Music\\ZoneMusic\\OutlandGeneral\\OL_Corrupt02.mp3", 62},
			{183, "Sound\\Music\\ZoneMusic\\OutlandGeneral\\OL_Corrupt03.mp3", 74},
			{184, "Sound\\Music\\ZoneMusic\\OutlandGeneral\\OL_Corrupt04.mp3", 71},
			{185, "Sound\\Music\\ZoneMusic\\OutlandGeneral\\OL_Corrupt05.mp3", 72},
			{186, "Sound\\Music\\ZoneMusic\\OutlandGeneral\\OL_Corrupt06.mp3", 74},
			{187, "Sound\\Music\\ZoneMusic\\OutlandGeneral\\OL_Corrupt07.mp3", 52},
			{188, "Sound\\Music\\ZoneMusic\\OutlandGeneral\\OL_CorruptIntro.mp3", 75},
			{189, "Sound\\Music\\ZoneMusic\\OutlandGeneral\\OL_CrystalIntroUni01.mp3", 26},
			{190, "Sound\\Music\\ZoneMusic\\OutlandGeneral\\OL_CrystalIntroUni02.mp3", 21},
			{191, "Sound\\Music\\ZoneMusic\\OutlandGeneral\\OL_CrystalIntroUni03.mp3", 21},
			{192, "Sound\\Music\\ZoneMusic\\OutlandGeneral\\OL_DemonIntroUni01.mp3", 46},
			{193, "Sound\\Music\\ZoneMusic\\OutlandGeneral\\OL_DraeneiBaseWalkUni01.mp3", 106},
			{194, "Sound\\Music\\ZoneMusic\\OutlandGeneral\\OL_DraeneiBaseWalkUni02r.mp3", 99},
			{195, "Sound\\Music\\ZoneMusic\\OutlandGeneral\\OL_FelOrcIntroUni01.mp3", 16},
			{196, "Sound\\Music\\ZoneMusic\\OutlandGeneral\\OL_FelOrcIntroUni02.mp3", 15},
			{197, "Sound\\Music\\ZoneMusic\\OutlandGeneral\\OL_HistoricIntroUni01.mp3", 79},
			{198, "Sound\\Music\\ZoneMusic\\OutlandGeneral\\OL_HordeBaseWalkUni01.mp3", 40},
			{199, "Sound\\Music\\ZoneMusic\\OutlandGeneral\\OL_HordeBaseWalkUni02.mp3", 37},
			{200, "Sound\\Music\\ZoneMusic\\OutlandGeneral\\OL_HordeBaseWalkUni03.mp3", 66},
			{201, "Sound\\Music\\ZoneMusic\\OutlandGeneral\\OL_HordeBaseWalkUni04.mp3", 68},
			{202, "Sound\\Music\\ZoneMusic\\OutlandGeneral\\OL_IllidansArmyIntroUni01.mp3", 35},
			{203, "Sound\\Music\\ZoneMusic\\OutlandGeneral\\OL_OgreIntroUni01.mp3", 28},
			{204, "Sound\\Music\\ZoneMusic\\OutlandGeneral\\OL_OgreIntroUni02.mp3", 25},
			{205, "Sound\\Music\\ZoneMusic\\OutlandGeneral\\OL_OrcIntroUni01.mp3", 11},
			{206, "Sound\\Music\\ZoneMusic\\OutlandGeneral\\OL_OrcIntroUni02.mp3", 17},
			{207, "Sound\\Music\\ZoneMusic\\OutlandGeneral\\OL_OrcIntroUni03.mp3", 11},
			{208, "Sound\\Music\\ZoneMusic\\OutlandGeneral\\OL_OrcIntroUni04.mp3", 13},
			{209, "Sound\\Music\\ZoneMusic\\OutlandGeneral\\OL_ScenicIntroUni01.mp3", 31},
			{210, "Sound\\Music\\ZoneMusic\\OutlandGeneral\\OL_ShamanIntroUni01.mp3", 44},
			{211, "Sound\\Music\\ZoneMusic\\OutlandGeneral\\OL_ShamanIntroUni02.mp3", 53},
		},
	},
	{
		id = 28,
		name = L["TITLE_AZUREMIST"],
		files = {
			{212, "Sound\\Music\\ZoneMusic\\Azuremyst\\AI_DraeneiWalkUni05.mp3", 191},
			{213, "Sound\\Music\\ZoneMusic\\Azuremyst\\AI_DraeneiWalkUni06.mp3", 110},
			{214, "Sound\\Music\\ZoneMusic\\Azuremyst\\AI_DraeneiWalkUni07r.mp3", 110},
			{215, "Sound\\Music\\ZoneMusic\\Azuremyst\\AI_DraeneiWalkUni08r.mp3", 99},
			{216, "Sound\\Music\\ZoneMusic\\Azuremyst\\AI_NagaWalkUni01.mp3", 103},
			{217, "Sound\\Music\\ZoneMusic\\Azuremyst\\AI_NagaWalkUni02.mp3", 74},
			{218, "Sound\\Music\\ZoneMusic\\Azuremyst\\AI_NagaWalkUni03.mp3", 150},
			{219, "Sound\\Music\\ZoneMusic\\Azuremyst\\AI_NagaWalkUni04.mp3", 73},
			{220, "Sound\\Music\\ZoneMusic\\Azuremyst\\AI_NagaWalkUni05.mp3", 98},
			{221, "Sound\\Music\\ZoneMusic\\Azuremyst\\AI_OwlkinWalkUni01.mp3", 49},
			{222, "Sound\\Music\\ZoneMusic\\Azuremyst\\AI_OwlkinWalkUni02.mp3", 45},
			{223, "Sound\\Music\\ZoneMusic\\Azuremyst\\AV_DraeneiWalkUni01.mp3", 206},
			{224, "Sound\\Music\\ZoneMusic\\Azuremyst\\AV_DraeneiWalkUni02.mp3", 124},
			{225, "Sound\\Music\\ZoneMusic\\Azuremyst\\AV_DraeneiWalkUni02r.mp3", 129},
			{226, "Sound\\Music\\ZoneMusic\\Azuremyst\\AV_DraeneiWalkUni03.mp3", 188},
			{227, "Sound\\Music\\ZoneMusic\\Azuremyst\\AV_DraeneiWalkUni03r.mp3", 188},
			{228, "Sound\\Music\\ZoneMusic\\Azuremyst\\AV_DraeneiWalkUni04.mp3", 158},
		},
	},
	{
		id = 29,
		name = L["TITLE_EXODAR"],
		files = {
			{229, "Sound\\Music\\ZoneMusic\\Azuremyst\\AI_ExodarIntro01.mp3", 82},
			{230, "Sound\\Music\\ZoneMusic\\Azuremyst\\AI_ExodarWalkUni01.mp3", 109},
			{231, "Sound\\Music\\ZoneMusic\\Azuremyst\\AI_ExodarWalkUni02.mp3", 107},
			{232, "Sound\\Music\\ZoneMusic\\Azuremyst\\AI_ExodarWalkUni03.mp3", 93},
		},
	},
	{
		id = 30,
		name = L["TITLE_BLOODMIST"],
		files = {
			{233, "Sound\\Music\\ZoneMusic\\Bloodmyst\\BI_NagaIntro01.mp3", 31},
			{234, "Sound\\Music\\ZoneMusic\\Bloodmyst\\BI_NagaIntro01r.mp3", 25},
			{235, "Sound\\Music\\ZoneMusic\\Bloodmyst\\BI_SatyrWalkUni01r.mp3", 126},
			{236, "Sound\\Music\\ZoneMusic\\Bloodmyst\\BI_SatyrWalkUni02.mp3", 129},
			{237, "Sound\\Music\\ZoneMusic\\Bloodmyst\\BI_SatyrWalkUni03.mp3", 114},
			{238, "Sound\\Music\\ZoneMusic\\Bloodmyst\\BI_SatyrWalkUni04.mp3", 69},
			{239, "Sound\\Music\\ZoneMusic\\Bloodmyst\\BI_SatyrWalkUni05.mp3", 144},
		},
	},
	{
		id = 31,
		name = L["TITLE_BLACKTEMPLE"],
		files = {
			{240, "Sound\\Music\\ZoneMusic\\BlackTemple\\BT_ArrivalWalkHero01.mp3", 164},
			{241, "Sound\\Music\\ZoneMusic\\BlackTemple\\BT_ArrivalWalkUni02.mp3", 81},
			{242, "Sound\\Music\\ZoneMusic\\BlackTemple\\BT_ArrivalWalkUni03.mp3", 74},
			{243, "Sound\\Music\\ZoneMusic\\BlackTemple\\BT_ArrivalWalkUni04.mp3", 64},
			{244, "Sound\\Music\\ZoneMusic\\BlackTemple\\BT_IllidariWalkHero09.mp3", 74},
			{245, "Sound\\Music\\ZoneMusic\\BlackTemple\\BT_IllidariWalkUni01.mp3", 61},
			{246, "Sound\\Music\\ZoneMusic\\BlackTemple\\BT_IllidariWalkUni02.mp3", 71},
			{247, "Sound\\Music\\ZoneMusic\\BlackTemple\\BT_IllidariWalkUni03.mp3", 78},
			{248, "Sound\\Music\\ZoneMusic\\BlackTemple\\BT_IllidariWalkUni04.mp3", 91},
			{249, "Sound\\Music\\ZoneMusic\\BlackTemple\\BT_IllidariWalkUni05.mp3", 90},
			{250, "Sound\\Music\\ZoneMusic\\BlackTemple\\BT_IllidariWalkUni06.mp3", 29},
			{251, "Sound\\Music\\ZoneMusic\\BlackTemple\\BT_IllidariWalkUni07.mp3", 78},
			{252, "Sound\\Music\\ZoneMusic\\BlackTemple\\BT_IllidariWalkUni08.mp3", 65},
			{253, "Sound\\Music\\ZoneMusic\\BlackTemple\\BT_IllidariWalkUni10.mp3", 75},
			{254, "Sound\\Music\\ZoneMusic\\BlackTemple\\BT_IllidariWalkUni11.mp3", 35},
			{255, "Sound\\Music\\ZoneMusic\\BlackTemple\\BT_KaraborWalkUni01.mp3", 106},
			{256, "Sound\\Music\\ZoneMusic\\BlackTemple\\BT_KaraborWalkUni02.mp3", 88},
			{257, "Sound\\Music\\ZoneMusic\\BlackTemple\\BT_KaraborWalkUni03.mp3", 57},
			{258, "Sound\\Music\\ZoneMusic\\BlackTemple\\BT_KaraborWalkUni04.mp3", 126},
			{259, "Sound\\Music\\ZoneMusic\\BlackTemple\\BT_PreludeEvent01.mp3", 253},
			{260, "Sound\\Music\\ZoneMusic\\BlackTemple\\BT_ReliquaryWalkHero01.mp3", 112},
			{261, "Sound\\Music\\ZoneMusic\\BlackTemple\\BT_ReliquaryWalkUni02.mp3", 66},
			{262, "Sound\\Music\\ZoneMusic\\BlackTemple\\BT_ReliquaryWalkUni03.mp3", 79},
			{263, "Sound\\Music\\ZoneMusic\\BlackTemple\\BT_ReliquaryWalkUni04.mp3", 63},
			{264, "Sound\\Music\\ZoneMusic\\BlackTemple\\BT_ReliquaryWalkUni05.mp3", 75},
			{265, "Sound\\Music\\ZoneMusic\\BlackTemple\\BT_ReliquaryWalkUni06.mp3", 125},
			{266, "Sound\\Music\\ZoneMusic\\BlackTemple\\BT_ReliquaryWalkUni07.mp3", 64},
			{267, "Sound\\Music\\ZoneMusic\\BlackTemple\\BT_ReliquaryWalkUni08.mp3", 88},
			{268, "Sound\\Music\\ZoneMusic\\BlackTemple\\BT_SanctuaryWalkHero01.mp3", 131},
			{269, "Sound\\Music\\ZoneMusic\\BlackTemple\\BT_SanctuaryWalkUni02.mp3", 65},
			{270, "Sound\\Music\\ZoneMusic\\BlackTemple\\BT_SanctuaryWalkUni03.mp3", 66},
			{271, "Sound\\Music\\ZoneMusic\\BlackTemple\\BT_SanctuaryWalkUni04.mp3", 65},
			{272, "Sound\\Music\\ZoneMusic\\BlackTemple\\BT_SanctuaryWalkUni05.mp3", 56},
			{273, "Sound\\Music\\ZoneMusic\\BlackTemple\\BT_SanctuaryWalkUni06.mp3", 58},
			{274, "Sound\\Music\\ZoneMusic\\BlackTemple\\BT_SanctuaryWalkUni07.mp3", 64},
			{275, "Sound\\Music\\ZoneMusic\\BlackTemple\\BT_SanctuaryWalkUni08.mp3", 57},
			{276, "Sound\\Music\\ZoneMusic\\BlackTemple\\BT_StormWalkHero02.mp3", 73},
			{277, "Sound\\Music\\ZoneMusic\\BlackTemple\\BT_StormWalkUni01.mp3", 67},
			{278, "Sound\\Music\\ZoneMusic\\BlackTemple\\BT_StormWalkUni03.mp3", 32},
			{279, "Sound\\Music\\ZoneMusic\\BlackTemple\\BT_StormWalkUni04.mp3", 48},
			{280, "Sound\\Music\\ZoneMusic\\BlackTemple\\BT_SummitWalkUni01.mp3", 59},
			{281, "Sound\\Music\\ZoneMusic\\BlackTemple\\BT_SummitWalkUni02.mp3", 69},
			{282, "Sound\\Music\\ZoneMusic\\BlackTemple\\BT_SummitWalkUni03.mp3", 41},
			{283, "Sound\\Music\\ZoneMusic\\BlackTemple\\BT_SummitWalkUni04.mp3", 114},
			{284, "Sound\\Music\\ZoneMusic\\BlackTemple\\BT_SummitWalkUni05.mp3", 51},
		},
	},
	{
		id = 32,
		name = L["TITLE_BLADESEDGE"],
		files = {
			{285, "Sound\\Music\\ZoneMusic\\BladesEdge\\BL_DryForestWalkUni01.mp3", 89},
			{286, "Sound\\Music\\ZoneMusic\\BladesEdge\\BL_DryForestWalkUni02.mp3", 127},
			{287, "Sound\\Music\\ZoneMusic\\BladesEdge\\BL_DryForestWalkUni03.mp3", 131},
			{288, "Sound\\Music\\ZoneMusic\\BladesEdge\\BL_GeneralWalkUni01.mp3", 80},
			{289, "Sound\\Music\\ZoneMusic\\BladesEdge\\BL_GeneralWalkUni02.mp3", 75},
			{290, "Sound\\Music\\ZoneMusic\\BladesEdge\\BL_GeneralWalkUni03.mp3", 158},
			{291, "Sound\\Music\\ZoneMusic\\BladesEdge\\BL_GeneralWalkUni04.mp3", 110},
			{292, "Sound\\Music\\ZoneMusic\\BladesEdge\\BL_GeneralWalkUni05.mp3", 110},
			{293, "Sound\\Music\\ZoneMusic\\BladesEdge\\BL_OgreWalkUni01.mp3", 75},
			{294, "Sound\\Music\\ZoneMusic\\BladesEdge\\BL_OgreWalkUni02.mp3", 110},
		},
	},
	{
		id = 33,
		name = L["TITLE_CAVERNSOFTIME"],
		files = {
			{295, "Sound\\Music\\ZoneMusic\\CavernsOfTime\\CT_BrazensFlightIntroUni.mp3", 93},
			{296, "Sound\\Music\\ZoneMusic\\CavernsOfTime\\CT_CavernsWalk1Uni.mp3", 112},
			{297, "Sound\\Music\\ZoneMusic\\CavernsOfTime\\CT_CavernsWalk2Uni.mp3", 120},
			{298, "Sound\\Music\\ZoneMusic\\CavernsOfTime\\CT_CavernsWalk3Uni.mp3", 169},
			{299, "Sound\\Music\\ZoneMusic\\CavernsOfTime\\CT_CavernsWalk4Uni.mp3", 130},
			{300, "Sound\\Music\\ZoneMusic\\CavernsOfTime\\CT_CavernsWalk5Uni.mp3", 151},
			{301, "Sound\\Music\\ZoneMusic\\CavernsOfTime\\CT_CavernsWalk6Uni.mp3", 161},
			{302, "Sound\\Music\\ZoneMusic\\CavernsOfTime\\CT_CavernsWalk7Uni.mp3", 178},
			{303, "Sound\\Music\\ZoneMusic\\CavernsOfTime\\CT_CavernsWalk8Uni.mp3", 140},
			{304, "Sound\\Music\\ZoneMusic\\CavernsOfTime\\CT_CavernsWalk9Uni.mp3", 161},
		},
	},
	{
		id = 34,
		name = L["TITLE_ESCDURNHOLDE"],
		files = {
			{305, "Sound\\Music\\ZoneMusic\\CavernsOfTime\\CT_DurnholdeCellarWalk1Uni.mp3", 104},
			{306, "Sound\\Music\\ZoneMusic\\CavernsOfTime\\CT_DurnholdeCellarWalk2Uni.mp3", 59},
			{307, "Sound\\Music\\ZoneMusic\\CavernsOfTime\\CT_DurnholdeCellarWalk3Uni.mp3", 66},
			{308, "Sound\\Music\\ZoneMusic\\CavernsOfTime\\CT_DurnholdeKeepExtWalk1Uni.mp3", 81},
			{309, "Sound\\Music\\ZoneMusic\\CavernsOfTime\\CT_DurnholdeKeepExtWalk2Uni.mp3", 66},
			{310, "Sound\\Music\\ZoneMusic\\CavernsOfTime\\CT_DurnholdeKeepExtWalk3Uni.mp3", 70},
			{311, "Sound\\Music\\ZoneMusic\\CavernsOfTime\\CT_DurnholdeKeepExtWalk4Uni.mp3", 58},
			{312, "Sound\\Music\\ZoneMusic\\CavernsOfTime\\CT_DurnholdeKeepExtWalk5Uni.mp3", 93},
			{313, "Sound\\Music\\ZoneMusic\\CavernsOfTime\\CT_DurnholdeKeepExtWalk6Uni.mp3", 60},
			{314, "Sound\\Music\\ZoneMusic\\CavernsOfTime\\CT_DurnholdeKeepIntWalk1Uni.mp3", 69},
			{315, "Sound\\Music\\ZoneMusic\\CavernsOfTime\\CT_DurnholdeKeepIntWalk2Uni.mp3", 123},
			{316, "Sound\\Music\\ZoneMusic\\CavernsOfTime\\CT_DurnholdeKeepIntWalk3Uni.mp3", 73},
			{317, "Sound\\Music\\ZoneMusic\\CavernsOfTime\\CT_EscapeDurnIntroUni.mp3", 112},
			{318, "Sound\\Music\\ZoneMusic\\CavernsOfTime\\CT_HillsbradExtWalk1Uni.mp3", 62},
			{319, "Sound\\Music\\ZoneMusic\\CavernsOfTime\\CT_HillsbradExtWalk2Uni.mp3", 56},
			{320, "Sound\\Music\\ZoneMusic\\CavernsOfTime\\CT_TarrenMillExtWalk1Uni.mp3", 78},
			{321, "Sound\\Music\\ZoneMusic\\CavernsOfTime\\CT_TarrenMillExtWalk2Uni.mp3", 66},
			{322, "Sound\\Music\\ZoneMusic\\CavernsOfTime\\CT_TarrenMillExtWalk3Uni.mp3", 62},
			{323, "Sound\\Music\\ZoneMusic\\CavernsOfTime\\CT_ThrallEscapeIntroUni.mp3", 45},
		},
	},
	{
		id = 35,
		name = L["TITLE_HYJAL"],
		files = {
			{324, "Sound\\Music\\ZoneMusic\\CavernsOfTime\\CT_HyjalExtWalk7Uni.mp3", 66},
			{325, "Sound\\Music\\ZoneMusic\\CavernsOfTime\\CT_HyjalExtWalk8Uni.mp3", 70},
			{326, "Sound\\Music\\ZoneMusic\\CavernsOfTime\\CT_HyjalExtWalk9Uni.mp3", 73},
			{327, "Sound\\Music\\ZoneMusic\\CavernsOfTime\\CT_HyjalExtWalkUni01.mp3", 69},
			{328, "Sound\\Music\\ZoneMusic\\CavernsOfTime\\CT_HyjalExtWalkUni02.mp3", 48},
			{329, "Sound\\Music\\ZoneMusic\\CavernsOfTime\\CT_HyjalExtWalkUni03.mp3", 45},
			{330, "Sound\\Music\\ZoneMusic\\CavernsOfTime\\CT_HyjalExtWalkUni04.mp3", 85},
			{331, "Sound\\Music\\ZoneMusic\\CavernsOfTime\\CT_HyjalExtWalkUni05.mp3", 47},
			{332, "Sound\\Music\\ZoneMusic\\CavernsOfTime\\CT_HyjalExtWalkUni06.mp3", 46},
			{333, "Sound\\Music\\ZoneMusic\\CavernsOfTime\\CT_HyjalExtWalkUni10.mp3", 66},
			{334, "Sound\\Music\\ZoneMusic\\CavernsOfTime\\CT_HyjalExtWalkUni11.mp3", 49},
			{335, "Sound\\Music\\ZoneMusic\\CavernsOfTime\\CT_HyjalExtWalkUni12.mp3", 67},
		},
	},
	{
		id = 36,
		name = L["TITLE_BLACKMORASS"],
		files = {
			{336, "Sound\\Music\\ZoneMusic\\CavernsOfTime\\CT_MorassPortalIntro01.mp3", 28},
			{337, "Sound\\Music\\ZoneMusic\\CavernsOfTime\\CT_MorassWalkUni01.mp3", 108},
			{338, "Sound\\Music\\ZoneMusic\\CavernsOfTime\\CT_MorassWalkUni02.mp3", 80},
			{339, "Sound\\Music\\ZoneMusic\\CavernsOfTime\\CT_MorassWalkUni03.mp3", 114},
			{340, "Sound\\Music\\ZoneMusic\\CavernsOfTime\\CT_MorassWalkUni04.mp3", 123},
			{341, "Sound\\Music\\ZoneMusic\\CavernsOfTime\\CT_MorassWalkUni05.mp3", 73},
		},
	},
	{
		id = 37,
		name = L["TITLE_EVERSONG"],
		files = {
			{342, "Sound\\Music\\ZoneMusic\\Eversong\\ES_BuildingWalkDay01.mp3", 65},
			{343, "Sound\\Music\\ZoneMusic\\Eversong\\ES_BuildingWalkDay02.mp3", 68},
			{344, "Sound\\Music\\ZoneMusic\\Eversong\\ES_BuildingWalkNight01.mp3", 84},
			{345, "Sound\\Music\\ZoneMusic\\Eversong\\ES_BuildingWalkNight02.mp3", 83},
			{346, "Sound\\Music\\ZoneMusic\\Eversong\\ES_RuinsWalkDay01.mp3", 48},
			{347, "Sound\\Music\\ZoneMusic\\Eversong\\ES_RuinsWalkDay02.mp3", 72},
			{348, "Sound\\Music\\ZoneMusic\\Eversong\\ES_RuinsWalkDay03.mp3", 70},
			{349, "Sound\\Music\\ZoneMusic\\Eversong\\ES_RuinsWalkNight01.mp3", 51},
			{350, "Sound\\Music\\ZoneMusic\\Eversong\\ES_RuinsWalkNight02.mp3", 83},
			{351, "Sound\\Music\\ZoneMusic\\Eversong\\ES_RuinsWalkNight03.mp3", 67},
			{352, "Sound\\Music\\ZoneMusic\\Eversong\\ES_ScenicIntroNight01.mp3", 97},
			{353, "Sound\\Music\\ZoneMusic\\Eversong\\ES_ScortchedWalkDay01.mp3", 116},
			{354, "Sound\\Music\\ZoneMusic\\Eversong\\ES_ScortchedWalkDay02.mp3", 103},
			{355, "Sound\\Music\\ZoneMusic\\Eversong\\ES_ScortchedWalkNight01.mp3", 69},
			{356, "Sound\\Music\\ZoneMusic\\Eversong\\ES_ScortchedWalkNight02.mp3", 61},
			{357, "Sound\\Music\\ZoneMusic\\Eversong\\ES_SilvermoonIntro01.mp3", 132},
			{358, "Sound\\Music\\ZoneMusic\\Eversong\\ES_SilvermoonWalkDay01.mp3", 64},
			{359, "Sound\\Music\\ZoneMusic\\Eversong\\ES_SilvermoonWalkDay02.mp3", 79},
			{360, "Sound\\Music\\ZoneMusic\\Eversong\\ES_SilvermoonWalkDay03.mp3", 65},
			{361, "Sound\\Music\\ZoneMusic\\Eversong\\ES_SilvermoonWalkNight01.mp3", 177},
			{362, "Sound\\Music\\ZoneMusic\\Eversong\\ES_SilvermoonWalkNight02.mp3", 71},
			{363, "Sound\\Music\\ZoneMusic\\Eversong\\ES_SilvermoonWalkNight03.mp3", 80},
			{364, "Sound\\Music\\ZoneMusic\\Eversong\\ES_SunstriderWalkDay01.mp3", 80},
			{365, "Sound\\Music\\ZoneMusic\\Eversong\\ES_SunstriderWalkDay02.mp3", 58},
			{366, "Sound\\Music\\ZoneMusic\\Eversong\\ES_SunstriderWalkDay03.mp3", 67},
			{367, "Sound\\Music\\ZoneMusic\\Eversong\\ES_SunstriderWalkNight01.mp3", 100},
			{368, "Sound\\Music\\ZoneMusic\\Eversong\\ES_SunstriderWalkNight02.mp3", 100},
			{369, "Sound\\Music\\ZoneMusic\\Eversong\\ES_SunstriderWalkNight03.mp3", 86},
		},
	},
	{
		id = 38,
		name = L["TITLE_GHOSTLANDS"],
		files = {
			{370, "Sound\\Music\\ZoneMusic\\Ghostlands\\GL_EversongDarkWalkUni01.mp3", 62},
			{371, "Sound\\Music\\ZoneMusic\\Ghostlands\\GL_EversongDarkWalkUni02.mp3", 62},
			{372, "Sound\\Music\\ZoneMusic\\Ghostlands\\GL_EversongDarkWalkUni03.mp3", 64},
			{373, "Sound\\Music\\ZoneMusic\\Ghostlands\\GL_EversongDarkWalkUni04.mp3", 60},
			{374, "Sound\\Music\\ZoneMusic\\Ghostlands\\GL_Forest1WalkDay01.mp3", 67},
			{375, "Sound\\Music\\ZoneMusic\\Ghostlands\\GL_Forest1WalkDay02.mp3", 70},
			{376, "Sound\\Music\\ZoneMusic\\Ghostlands\\GL_Forest1WalkNight01.mp3", 67},
			{377, "Sound\\Music\\ZoneMusic\\Ghostlands\\GL_Forest2WalkDay01.mp3", 83},
			{378, "Sound\\Music\\ZoneMusic\\Ghostlands\\GL_Forest2WalkNight01.mp3", 59},
			{379, "Sound\\Music\\ZoneMusic\\Ghostlands\\GL_Forest2WalkNight02.mp3", 60},
			{380, "Sound\\Music\\ZoneMusic\\Ghostlands\\GL_Forest3WalkDay01.mp3", 154},
			{381, "Sound\\Music\\ZoneMusic\\Ghostlands\\GL_Forest3WalkNight01.mp3", 51},
			{382, "Sound\\Music\\ZoneMusic\\Ghostlands\\GL_Forest3WalkNight02.mp3", 28},
			{383, "Sound\\Music\\ZoneMusic\\Ghostlands\\GL_Forest3WalkNight03.mp3", 44},
			{384, "Sound\\Music\\ZoneMusic\\Ghostlands\\GL_ScenicWalkUni01.mp3", 89},
			{385, "Sound\\Music\\ZoneMusic\\Ghostlands\\GL_ScenicWalkUni02.mp3", 81},
			{386, "Sound\\Music\\ZoneMusic\\Ghostlands\\GL_ScenicWalkUni03.mp3", 78},
			{387, "Sound\\Music\\ZoneMusic\\Ghostlands\\GL_ShalandisWalkUni01.mp3", 131},
			{388, "Sound\\Music\\ZoneMusic\\Ghostlands\\GL_ShalandisWalkUni02.mp3", 104},
			{389, "Sound\\Music\\ZoneMusic\\Ghostlands\\GL_ShalandisWalkUni03.mp3", 67},
		},
	},
	{
		id = 39,
		name = L["TITLE_HELLFIRE"],
		files = {
			{390, "Sound\\Music\\ZoneMusic\\HellfirePeninsula\\BL_HE_OgreWalkUni01.mp3", 75},
			{391, "Sound\\Music\\ZoneMusic\\HellfirePeninsula\\BL_HE_OgreWalkUni02.mp3", 110},
			{392, "Sound\\Music\\ZoneMusic\\HellfirePeninsula\\HE_ArmouryIntroUni01.mp3", 14},
			{393, "Sound\\Music\\ZoneMusic\\HellfirePeninsula\\HE_CitadelDemonWalkUni01.mp3", 53},
			{394, "Sound\\Music\\ZoneMusic\\HellfirePeninsula\\HE_CitadelDemonWalkUni02.mp3", 63},
			{395, "Sound\\Music\\ZoneMusic\\HellfirePeninsula\\HE_CitadelIntroUni01.mp3", 19},
			{396, "Sound\\Music\\ZoneMusic\\HellfirePeninsula\\HE_GeneralWalkUni01.mp3", 130},
			{397, "Sound\\Music\\ZoneMusic\\HellfirePeninsula\\HE_GeneralWalkUni02.mp3", 66},
			{398, "Sound\\Music\\ZoneMusic\\HellfirePeninsula\\HE_GeneralWalkUni03.mp3", 59},
			{399, "Sound\\Music\\ZoneMusic\\HellfirePeninsula\\HE_GeneralWalkUni04.mp3", 96},
			{400, "Sound\\Music\\ZoneMusic\\HellfirePeninsula\\HE_GeneralWalkUni05.mp3", 126},
			{401, "Sound\\Music\\ZoneMusic\\HellfirePeninsula\\HE_PathOfGloryIntroUni01.mp3", 18},
			{402, "Sound\\Music\\ZoneMusic\\HellfirePeninsula\\HE_RampartsWalkUni01.mp3", 62},
			{403, "Sound\\Music\\ZoneMusic\\HellfirePeninsula\\HE_RampartsWalkUni02.mp3", 69},
			{404, "Sound\\Music\\ZoneMusic\\HellfirePeninsula\\HE_StairsIntroUni01.mp3", 18},
			{405, "Sound\\Music\\ZoneMusic\\HellfirePeninsula\\HE_WistfulIntroUni01.mp3", 25},
			{406, "Sound\\Music\\ZoneMusic\\HellfirePeninsula\\HE_WistfulIntroUni02.mp3", 17},
		},
	},
	{
		id = 40,
		name = L["TITLE_KARAZHAN"],
		files = {
			{407, "Sound\\Music\\ZoneMusic\\Karazhan\\KA_BackstageWalkUni01.mp3", 98},
			{408, "Sound\\Music\\ZoneMusic\\Karazhan\\KA_BackstageWalkUni02.mp3", 98},
			{409, "Sound\\Music\\ZoneMusic\\Karazhan\\KA_FoyerIntroUni01.mp3", 117},
			{410, "Sound\\Music\\ZoneMusic\\Karazhan\\KA_FoyerWalkUni01.mp3", 113},
			{411, "Sound\\Music\\ZoneMusic\\Karazhan\\KA_FoyerWalkUni02.mp3", 112},
			{412, "Sound\\Music\\ZoneMusic\\Karazhan\\KA_FoyerWalkUni03.mp3", 124},
			{413, "Sound\\Music\\ZoneMusic\\Karazhan\\KA_FoyerWalkUni04.mp3", 31},
			{414, "Sound\\Music\\ZoneMusic\\Karazhan\\KA_GeneralWalkUni01.mp3", 130},
			{415, "Sound\\Music\\ZoneMusic\\Karazhan\\KA_GeneralWalkUni02.mp3", 123},
			{416, "Sound\\Music\\ZoneMusic\\Karazhan\\KA_GeneralWalkUni03.mp3", 119},
			{417, "Sound\\Music\\ZoneMusic\\Karazhan\\KA_GeneralWalkUni04.mp3", 112},
			{418, "Sound\\Music\\ZoneMusic\\Karazhan\\KA_GeneralWalkUni05.mp3", 125},
			{419, "Sound\\Music\\ZoneMusic\\Karazhan\\KA_GeneralWalkUni06.mp3", 92},
			{420, "Sound\\Music\\ZoneMusic\\Karazhan\\KA_GeneralWalkUni07.mp3", 81},
			{421, "Sound\\Music\\ZoneMusic\\Karazhan\\KA_LibraryWalkUni01.mp3", 128},
			{422, "Sound\\Music\\ZoneMusic\\Karazhan\\KA_LibraryWalkUni02.mp3", 147},
			{423, "Sound\\Music\\ZoneMusic\\Karazhan\\KA_LibraryWalkUni03.mp3", 126},
			{424, "Sound\\Music\\ZoneMusic\\Karazhan\\KA_LibraryWalkUni04.mp3", 124},
			{425, "Sound\\Music\\ZoneMusic\\Karazhan\\KA_MalchezarWalkUni01.mp3", 124},
			{426, "Sound\\Music\\ZoneMusic\\Karazhan\\KA_MalchezarWalkUni02.mp3", 112},
			{427, "Sound\\Music\\ZoneMusic\\Karazhan\\KA_MalchezarWalkUni03.mp3", 114},
			{428, "Sound\\Music\\ZoneMusic\\Karazhan\\KA_OperaHarpsiWalkUni01.mp3", 82},
			{429, "Sound\\Music\\ZoneMusic\\Karazhan\\KA_OperaOrganWalkUni01.mp3", 80},
			{430, "Sound\\Music\\ZoneMusic\\Karazhan\\KA_StableIntroUni01.mp3", 53},
			{431, "Sound\\Music\\ZoneMusic\\Karazhan\\KA_StableWalkUni01.mp3", 96},
			{432, "Sound\\Music\\ZoneMusic\\Karazhan\\KA_StableWalkUni02.mp3", 111},
			{433, "Sound\\Music\\ZoneMusic\\Karazhan\\KA_StableWalkUni03.mp3", 114},
			{434, "Sound\\Music\\ZoneMusic\\Karazhan\\KA_TowerWalkUni01.mp3", 94},
			{435, "Sound\\Music\\ZoneMusic\\Karazhan\\KA_TowerWalkUni02.mp3", 115},
			{436, "Sound\\Music\\ZoneMusic\\Karazhan\\KA_TowerWalkUni03.mp3", 127},
		},
	},
	{
		id = 41,
		name = L["TITLE_NAGRAND"],
		files = {
			{437, "Sound\\Music\\ZoneMusic\\Nagrand\\NA_DiamondIntroUni01.mp3", 73},
			{438, "Sound\\Music\\ZoneMusic\\Nagrand\\NA_GeneralWalkDay01.mp3", 72},
			{439, "Sound\\Music\\ZoneMusic\\Nagrand\\NA_GeneralWalkDay02.mp3", 100},
			{440, "Sound\\Music\\ZoneMusic\\Nagrand\\NA_GeneralWalkDay03.mp3", 63},
			{441, "Sound\\Music\\ZoneMusic\\Nagrand\\NA_GeneralWalkNight01.mp3", 88},
			{442, "Sound\\Music\\ZoneMusic\\Nagrand\\NA_GeneralWalkNight02.mp3", 80},
			{443, "Sound\\Music\\ZoneMusic\\Nagrand\\NA_GeneralWalkNight03.mp3", 166},
		},
	},
	{
		id = 42,
		name = L["TITLE_NETHERSTORM"],
		files = {
			{444, "Sound\\Music\\ZoneMusic\\Netherstorm\\NS_GeneralWalkUni01.mp3", 150},
			{445, "Sound\\Music\\ZoneMusic\\Netherstorm\\NS_GeneralWalkUni02.mp3", 175},
			{446, "Sound\\Music\\ZoneMusic\\Netherstorm\\NS_GeneralWalkUni03.mp3", 178},
			{447, "Sound\\Music\\ZoneMusic\\Netherstorm\\NS_GeneralWalkUni04.mp3", 181},
			{448, "Sound\\Music\\ZoneMusic\\Netherstorm\\NS_GeneralWalkUni05.mp3", 184},
			{449, "Sound\\Music\\ZoneMusic\\Netherstorm\\NS_GeneralWalkUni06.mp3", 192},
			{450, "Sound\\Music\\ZoneMusic\\Netherstorm\\NS_GeneralWalkUni07.mp3", 193},
			{451, "Sound\\Music\\ZoneMusic\\Netherstorm\\NS_GeneralWalkUni08.mp3", 169},
			{452, "Sound\\Music\\ZoneMusic\\Netherstorm\\NS_GeneralWalkUni09.mp3", 199},
			{453, "Sound\\Music\\ZoneMusic\\Netherstorm\\NS_GeneralWalkUni10.mp3", 223},
			{454, "Sound\\Music\\ZoneMusic\\Netherstorm\\NS_MushroomIntroUni01.mp3", 39},
			{455, "Sound\\Music\\ZoneMusic\\Netherstorm\\NS_MushroomIntroUni02.mp3", 33},
			{456, "Sound\\Music\\ZoneMusic\\Netherstorm\\NS_MushroomIntroUni03.mp3", 37},
			{457, "Sound\\Music\\ZoneMusic\\Netherstorm\\NS_NetherplantIntroUni01.mp3", 44},
			{458, "Sound\\Music\\ZoneMusic\\Netherstorm\\NS_NetherplantIntroUni02.mp3", 51},
			{459, "Sound\\Music\\ZoneMusic\\Netherstorm\\NS_NetherplantIntroUni03.mp3", 47},
			{460, "Sound\\Music\\ZoneMusic\\Netherstorm\\NS_NetherplantIntroUni04.mp3", 45},
		},
	},
	{
		id = 43,
		name = L["TITLE_SUNWELL"],
		files = {
			{461, "Sound\\Music\\ZoneMusic\\Sunwell\\SW_AssemblyChamberWalkUni01.mp3", 82},
			{462, "Sound\\Music\\ZoneMusic\\Sunwell\\SW_AssemblyChamberWalkUni02.mp3", 88},
			{463, "Sound\\Music\\ZoneMusic\\Sunwell\\SW_FelEnergyWalkUni01.mp3", 126},
			{464, "Sound\\Music\\ZoneMusic\\Sunwell\\SW_IsleDarkWalkUni01.mp3", 139},
			{465, "Sound\\Music\\ZoneMusic\\Sunwell\\SW_IsleDarkWalkUni02.mp3", 137},
			{466, "Sound\\Music\\ZoneMusic\\Sunwell\\SW_IsleDarkWalkUni03.mp3", 126},
			{467, "Sound\\Music\\ZoneMusic\\Sunwell\\SW_IsleLightWalkUni01.mp3", 115},
			{468, "Sound\\Music\\ZoneMusic\\Sunwell\\SW_IsleLightWalkUni02.mp3", 119},
			{469, "Sound\\Music\\ZoneMusic\\Sunwell\\SW_IsleLightWalkUni03.mp3", 90},
			{470, "Sound\\Music\\ZoneMusic\\Sunwell\\SW_IsleMedWalkUni01.mp3", 117},
			{471, "Sound\\Music\\ZoneMusic\\Sunwell\\SW_IsleMedWalkUni02.mp3", 126},
			{472, "Sound\\Music\\ZoneMusic\\Sunwell\\SW_IsleMedWalkUni03.mp3", 88},
			{473, "Sound\\Music\\ZoneMusic\\Sunwell\\SW_MagistersArrivalWalkUni01.mp3", 87},
			{474, "Sound\\Music\\ZoneMusic\\Sunwell\\SW_MagistersAsylumWalkUni01.mp3", 97},
			{475, "Sound\\Music\\ZoneMusic\\Sunwell\\SW_MagistersAsylumWalkUni02.mp3", 95},
			{476, "Sound\\Music\\ZoneMusic\\Sunwell\\SW_MagistersAsylumWalkUni03.mp3", 65},
			{477, "Sound\\Music\\ZoneMusic\\Sunwell\\SW_MagistersTerraceWalkUni01.mp3", 88},
			{478, "Sound\\Music\\ZoneMusic\\Sunwell\\SW_MagistersTerraceWalkUni02.mp3", 90},
			{479, "Sound\\Music\\ZoneMusic\\Sunwell\\SW_MagistersTerraceWalkUni03.mp3", 89},
			{480, "Sound\\Music\\ZoneMusic\\Sunwell\\SW_MagistersTerraceWalkUni04.mp3", 91},
			{481, "Sound\\Music\\ZoneMusic\\Sunwell\\SW_MagistersTerraceWalkUni05.mp3", 123},
			{482, "Sound\\Music\\ZoneMusic\\Sunwell\\SW_PlateauSunwellArrivalWalkUni01.mp3", 138},
			{483, "Sound\\Music\\ZoneMusic\\Sunwell\\SW_PlateauSunwellWalkUni01.mp3", 85},
			{484, "Sound\\Music\\ZoneMusic\\Sunwell\\SW_PlateauSunwellWalkUni02.mp3", 78},
			{485, "Sound\\Music\\ZoneMusic\\Sunwell\\SW_PlateauSunwellWalkUni03.mp3", 90},
			{486, "Sound\\Music\\ZoneMusic\\Sunwell\\SW_PlateauSunwellWalkUni04.mp3", 91},
			{487, "Sound\\Music\\ZoneMusic\\Sunwell\\SW_PlateauSunwellWalkUni05.mp3", 93},
			{488, "Sound\\Music\\ZoneMusic\\Sunwell\\SW_PlateauSunwellWalkUni06.mp3", 87},
			{489, "Sound\\Music\\ZoneMusic\\Sunwell\\SW_QuelDanasWalkUni01.mp3", 108},
			{490, "Sound\\Music\\ZoneMusic\\Sunwell\\SW_QuelDanasWalkUni02.mp3", 84},
			{491, "Sound\\Music\\ZoneMusic\\Sunwell\\SW_SanctumWalkUni01.mp3", 85},
			{492, "Sound\\Music\\ZoneMusic\\Sunwell\\SW_ShorelAranWalkUni01.mp3", 87},
			{493, "Sound\\Music\\ZoneMusic\\Sunwell\\SW_SunwellBombingRunUni01.mp3", 259},
			{494, "Sound\\Music\\ZoneMusic\\Sunwell\\SW_SunwellFlybyUni01.mp3", 57},
			{495, "Sound\\Music\\ZoneMusic\\Sunwell\\SW_TheWellWalkUni01.mp3", 98},
			{496, "Sound\\Music\\ZoneMusic\\Sunwell\\SW_TheWellWalkUni02.mp3", 95},
			{497, "Sound\\Music\\ZoneMusic\\Sunwell\\SW_TheWellWalkUni03.mp3", 95},
		},
	},
	{
		id = 44,
		name = L["TITLE_SHADOWMOON"],
		files = {
			{498, "Sound\\Music\\ZoneMusic\\ShadowmoonValley\\SV_GeneralWalkUni01.mp3", 67},
			{499, "Sound\\Music\\ZoneMusic\\ShadowmoonValley\\SV_GeneralWalkUni02.mp3", 112},
			{500, "Sound\\Music\\ZoneMusic\\ShadowmoonValley\\SV_GeneralWalkUni03.mp3", 106},
			{501, "Sound\\Music\\ZoneMusic\\ShadowmoonValley\\SV_GeneralWalkUni04.mp3", 93},
			{502, "Sound\\Music\\ZoneMusic\\ShadowmoonValley\\SV_GeneralWalkUni05.mp3", 93},
			{503, "Sound\\Music\\ZoneMusic\\ShadowmoonValley\\SV_GeneralWalkUni06.mp3", 67},
		},
	},
	{
		id = 45,
		name = L["TITLE_TEMPESTKEEP"],
		files = {
			{504, "Sound\\Music\\ZoneMusic\\TempestKeep\\tk_TempestKeep_AMB_11.mp3", 46},
			{505, "Sound\\Music\\ZoneMusic\\TempestKeep\\tk_TempestKeep_AMB_12.mp3", 96},
			{506, "Sound\\Music\\ZoneMusic\\TempestKeep\\tk_TempestKeep_AMB_13.mp3", 67},
			{507, "Sound\\Music\\ZoneMusic\\TempestKeep\\tk_TempestKeep_AMB_14.mp3", 88},
			{508, "Sound\\Music\\ZoneMusic\\TempestKeep\\tk_TempestKeep_AMB_16.mp3", 58},
			{509, "Sound\\Music\\ZoneMusic\\TempestKeep\\tk_TempestKeep_AMB_17.mp3", 62},
			{510, "Sound\\Music\\ZoneMusic\\TempestKeep\\tk_TempestKeep_AMB_18.mp3", 85},
			{511, "Sound\\Music\\ZoneMusic\\TempestKeep\\tk_TempestKeep_AMB_19.mp3", 48},
			{512, "Sound\\Music\\ZoneMusic\\TempestKeep\\tk_TempestKeep_AMB_20.mp3", 47},
			{513, "Sound\\Music\\ZoneMusic\\TempestKeep\\tk_TempestKeep_AMB_22.mp3", 34},
			{514, "Sound\\Music\\ZoneMusic\\TempestKeep\\tk_TempestKeep_AMB_23.mp3", 67},
			{515, "Sound\\Music\\ZoneMusic\\TempestKeep\\tk_TempestKeep_BTL10.mp3", 59},
			{516, "Sound\\Music\\ZoneMusic\\TempestKeep\\tk_TempestKeep_BTL11.mp3", 81},
			{517, "Sound\\Music\\ZoneMusic\\TempestKeep\\tk_TempestKeep_BTL13.mp3", 36},
			{518, "Sound\\Music\\ZoneMusic\\TempestKeep\\tk_TempestKeep_STG14.mp3", 11},
			{519, "Sound\\Music\\ZoneMusic\\TempestKeep\\tk_TempestKeep_STG15.mp3", 11},
			{520, "Sound\\Music\\ZoneMusic\\TempestKeep\\tk_TempestKeep_STG16.mp3", 11},
		},
	},
	{
		id = 46,
		name = L["TITLE_ZANGARMASH"],
		files = {
			{521, "Sound\\Music\\ZoneMusic\\ZangarMarsh\\ZA_CoilfangWalkUni01.mp3", 133},
			{522, "Sound\\Music\\ZoneMusic\\ZangarMarsh\\ZA_CoilfangWalkUni02.mp3", 99},
			{523, "Sound\\Music\\ZoneMusic\\ZangarMarsh\\ZA_CoilfangWalkUni03.mp3", 109},
			{524, "Sound\\Music\\ZoneMusic\\ZangarMarsh\\ZA_GeneralWalkUni01.mp3", 81},
			{525, "Sound\\Music\\ZoneMusic\\ZangarMarsh\\ZA_GeneralWalkUni02.mp3", 120},
			{526, "Sound\\Music\\ZoneMusic\\ZangarMarsh\\ZA_GeneralWalkUni03.mp3", 59},
			{527, "Sound\\Music\\ZoneMusic\\ZangarMarsh\\ZA_GeneralWalkUni04.mp3", 103},
			{528, "Sound\\Music\\ZoneMusic\\ZangarMarsh\\ZA_GeneralWalkUni05.mp3", 71},
			{529, "Sound\\Music\\ZoneMusic\\ZangarMarsh\\ZA_GeneralWalkUni06.mp3", 89},
		},
	},
	{
		id = 47,
		name = L["TITLE_TEROKKAR"],
		files = {
			{530, "Sound\\Music\\ZoneMusic\\Terokkar\\TF_AuchindounWalkUni01.mp3", 120},
			{531, "Sound\\Music\\ZoneMusic\\Terokkar\\TF_AuchindounWalkUni02.mp3", 150},
			{532, "Sound\\Music\\ZoneMusic\\Terokkar\\TF_AuchindounWalkUni03.mp3", 120},
			{533, "Sound\\Music\\ZoneMusic\\Terokkar\\TF_BoneWalkUni01.mp3", 65},
			{534, "Sound\\Music\\ZoneMusic\\Terokkar\\TF_BoneWalkUni02.mp3", 63},
			{535, "Sound\\Music\\ZoneMusic\\Terokkar\\TF_BoneWalkUni03.mp3", 56},
			{536, "Sound\\Music\\ZoneMusic\\Terokkar\\TF_BoneWalkUni04.mp3", 189},
			{537, "Sound\\Music\\ZoneMusic\\Terokkar\\TF_ForestWalkUni01.mp3", 150},
			{538, "Sound\\Music\\ZoneMusic\\Terokkar\\TF_ForestWalkUni02.mp3", 190},
			{539, "Sound\\Music\\ZoneMusic\\Terokkar\\TF_ForestWalkUni03.mp3", 187},
			{540, "Sound\\Music\\ZoneMusic\\Terokkar\\TF_ShattrathWalkUni01.mp3", 137},
			{541, "Sound\\Music\\ZoneMusic\\Terokkar\\TF_ShattrathWalkUni02.mp3", 100},
			{542, "Sound\\Music\\ZoneMusic\\Terokkar\\TF_ShattrathWalkUni03.mp3", 92},
			{543, "Sound\\Music\\ZoneMusic\\Terokkar\\TF_ShattrathWalkUni04.mp3", 82},
			{544, "Sound\\Music\\ZoneMusic\\Terokkar\\TF_ShattrathWalkUni05.mp3", 117},
			{545, "Sound\\Music\\ZoneMusic\\Terokkar\\TF_ShattrathWalkUni06.mp3", 137},
		},
	},
}

GJB.musictable[GJB.EXP_BC] = music
