----------------------------------------------------------------------------------------------
--
-- This patch adds CHAT_MSG_GUILD_ITEM_LOOTED to GreenWall's event listener.
-- We try to handle this in the same way GW handles the CHAT_MSG_GUILD_ACHIEVEMENT event:
-- when a rare item shows up in chat, we check if we're the player who posted it to chat,
-- and if so, post it to GreenWall in achievement format.
--
----------------------------------------------------------------------------------------------


-- First step is to hook into GreenWall_OnEvent.
-- We replace the function as soon as GW-Loot loads.
-- Check that GreenWall has correctly loaded.  It's a dependency, so it should load before we do...
if(gw and GreenWallInterfaceFrame)then
	
	-- GreenWall doesn't normally listen for CHAT_MSG_GUILD_ITEM_LOOTED, so set that up here
	GreenWallInterfaceFrame:RegisterEvent('CHAT_MSG_GUILD_ITEM_LOOTED')
	
	-- Hook into the function here.  (The remaining code won't be called until an event occurs)
	local old_GreenWall_OnEvent = GreenWall_OnEvent
	function GreenWall_OnEvent(self, event, ...)
		old_GreenWall_OnEvent(self, event, ...)
		
		-- From here, we try to emulate the existing OnEvent function as closely as possible.
		if not gw.addon_loaded then
			return
		end
		
		-- GreenWall uses CHAT_MSG_LOOT for detecting item drops.
		-- We use CHAT_MSG_GUILD_ITEM_LOOTED instead, so we can be sure a guildwide announcement occurred.
		if event == 'CHAT_MSG_GUILD_ITEM_LOOTED' then
			local message, sender, _, _, _, flags, _, chanNum = select(1, ...)

			-- -- As of 1.9.0, GreenWall is SUPPOSED to broadcast legendary items, but it's really inconsistent about it.  
			-- If it starts working again, uncomment out these lines to filter GW-Loot's own legendary broadcast.
			-- local item=gw.GetItemString(message)
			-- if(item and gw.IsLegendary(item))then return end
			
			gw.Debug(GW_LOG_DEBUG, 'event=%s, sender=%s, message=%s', event, sender, message)					

			-- The first difference is that "sender" doesn't contain the player's realm name,
			-- so we trim gw.player's name before comparing it to sender.			
			local player=Ambiguate(gw.player,"none")
			
			-- The second difference is GreenWall expects the message to start with %s.
			-- For whatever reason, guild item loot announcements start with $s instead.
			message="%"..(string.sub(message,2))
			
			if gw.iCmp(sender, player) then				
				-- Then we just send the message as loot, and we're done.
						-- (actually right now we're sending as achievement like we used to because loot has a different format)
				gw.config.channel.guild:send(GW_MTYPE_ACHIEVEMENT, message)
			end	
		end
	end
else -- else gw and/or GreenWallInterfaceFrame do not exist
	print("GW-Loot couldn't start correctly because GreenWall hasn't loaded yet.")
end


-- -- v0.2: display a one-time-only notification
-- GWLOOT_EventHandlerFrame = CreateFrame("Frame")
-- function GWLOOT_EventHandlerFrame:OnEvent(event, addon)
	-- if(event=="ADDON_LOADED" and addon=="GW-Loot")then
		-- if((not GWLOOT_SAVEDATA) or (not GWLOOT_SAVEDATA.displayed_notice_v02))then
			-- C_Timer.After(5,function()print("Message from GW-Loot: GreenWall v1.9.0 now supports legendary item broadcasts! GW-Loot will continue to broadcast rare mounts, but you no longer need it if you're only interested in legendary drops.")end)
			-- GWLOOT_SAVEDATA={}
			-- GWLOOT_SAVEDATA.displayed_notice_v02=true
			-- self:UnregisterEvent("ADDON_LOADED")	
		-- end
	-- end
-- end
-- GWLOOT_EventHandlerFrame:RegisterEvent("ADDON_LOADED")
-- GWLOOT_EventHandlerFrame:SetScript("OnEvent", GWLOOT_EventHandlerFrame.OnEvent)
