--[[
GTAWastedSound
Plays the Grand Theft Auto Wasted sound when your character dies.
]]

-- Constants
local SOUND_PATH    = "Interface\\AddOns\\GTAWastedSound\\queue.ogg" -- Path to sound file
local SOUND_CHANNEL = "Master"                                      -- Audio channel to play the sound on

-- Create a frame to listen for events without polluting the global namespace
local frame = CreateFrame("Frame")

-- Register for the PLAYER_DEAD event
frame:RegisterEvent("PLAYER_DEAD")

-- Event handler: wrap PlaySoundFile in pcall to guard against missing files or other errors
local function OnEvent(self, event, ...)
    local ok, err = pcall(PlaySoundFile, SOUND_PATH, SOUND_CHANNEL)
    if not ok then
        DEFAULT_CHAT_FRAME:AddMessage(
            "[GTAWastedSound] Failed to play sound: " .. tostring(err)
        )
    end
end

-- Attach the handler
frame:SetScript("OnEvent", OnEvent)
