local frame = CreateFrame("Frame",nil,UIParent)
local L=L4S[GetLocale()];
if type(L)~="table" then L=L4S["enUS"]; end

local DEF_BindMarks={
	target={}, 
	arrow={},
	flag={},
	heart={},
	shield={},
	sword={},
	umbrella={},
	repair={},
	magnet={},
	clock={},
	eye={},
	green_elephant={},
	paw={},
	radiation={},
	fire={},
	sheet={},
	water={},
	wind={}
}
local TFrames={};
local textPath="Interface\\AddOns\\4S\\Textures\\";
local TypeGroup=nil;
local lastKDA4S={GUID="",T=0};
local backdrop = {
    bgFile = "Interface\\DialogFrame\\UI-DialogBox-Background",
    edgeFile = "Interface\\Tooltips\\UI-Tooltip-Border",   
    edgeSize = 16,
    insets = { left = 3, right = 3, top = 3, bottom = 3 }
}
local backdrop_active = {
    bgFile = "Interface\\DialogFrame\\UI-DialogBox-Gold-Background",
    edgeFile = "Interface\\DialogFrame\\UI-DialogBox-Gold-Border",   
    edgeSize = 16,
    insets = { left = 3, right = 3, top = 3, bottom = 3 }
}
UFrames={MAIN={},GROUP={}};
v4SEARCH={MAIN={},GROUP={}};
function frame:CreateEditBox(point, parentFrame, relativeFrame, relativePoint,xOffset,yOffset)
	local eb = CreateFrame("EditBox", nil, parentFrame);
	eb:SetPoint(point, relativeFrame, relativePoint, xOffset, yOffset);
	eb:SetFontObject(GameFontNormal)
	eb:SetSize(140,25);
	eb:SetBackdrop(backdrop);
	eb:ClearFocus()
	eb:SetAutoFocus(false)
	return eb;
end
function frame:CreateButton(p1,p2,pF,rF,X,Y,W,H,Backdrop,text)
	local inh="GameMenuButtonTemplate";
	if Backdrop then inh=nil; end
	
	local btn = CreateFrame("Button", nil, pF,inh);
	btn:SetPoint(p1,rF,p2,X,Y); btn:SetSize(W,H); 
	btn:SetNormalFontObject("GameFontNormalLarge");
	btn:SetHighlightFontObject("GameFontHighlightLarge");
	if Backdrop then btn:SetBackdrop(Backdrop); end
	if text then btn:SetText(text); end
	return btn;
end
local function ScrollFrame_OnMouseWheel(self, delta)
	local newValue = self:GetVerticalScroll() - (delta * 30);
	
	if (newValue < 0) then
		newValue = 0;
	elseif (newValue > self:GetVerticalScrollRange()) then
		newValue = self:GetVerticalScrollRange();
	end
	
	self:SetVerticalScroll(newValue);
end
function frame:CreateMenu(W,H)
	local UIConfig = CreateFrame("Frame", "SMenuConfig", UIParent, "UIPanelDialogTemplate");
	UIConfig:SetMovable(true) 
	UIConfig:EnableMouse(true)
	UIConfig:SetClampedToScreen(true)
	UIConfig:SetSize(W+20,H);
	UIConfig:SetPoint("CENTER"); 
	UIConfig:SetScript("OnMouseDown", UIConfig.StartMoving)
	UIConfig:SetScript("OnMouseUp", UIConfig.StopMovingOrSizing)
	
	UIConfig.title=UIConfig:CreateFontString(nil, "OVERLAY", "GameFontHighlight")
	UIConfig.title:ClearAllPoints();
	UIConfig.title:SetPoint("CENTER", SMenuConfigTitleBG, "CENTER", 6, 1);
	UIConfig.title:SetText("|cffFFFFFF"..L["TITLE_BINDMENU"].."|r");	 
	
	UIConfig.ScrollFrame = CreateFrame("ScrollFrame", nil, UIConfig, "UIPanelScrollFrameTemplate");
	UIConfig.ScrollFrame:SetPoint("TOPLEFT", SMenuConfigDialogBG, "TOPLEFT", 4, -8);
	UIConfig.ScrollFrame:SetPoint("BOTTOMRIGHT", SMenuConfigDialogBG, "BOTTOMRIGHT", -3, 4);
	UIConfig.ScrollFrame:SetClipsChildren(true);
	UIConfig.ScrollFrame:SetScript("OnMouseWheel", ScrollFrame_OnMouseWheel);
	
	UIConfig.ScrollFrame.ScrollBar:ClearAllPoints();
    UIConfig.ScrollFrame.ScrollBar:SetPoint("TOPLEFT", UIConfig.ScrollFrame, "TOPRIGHT", -12, -18);
    UIConfig.ScrollFrame.ScrollBar:SetPoint("BOTTOMRIGHT", UIConfig.ScrollFrame, "BOTTOMRIGHT", -7, 18);
	
	UIConfig.child = CreateFrame("Frame", nil, UIConfig.ScrollFrame);
	UIConfig.child:SetSize(W,H);
	UIConfig.ScrollFrame:SetScrollChild(UIConfig.child);	
	
	UIConfig:Hide();
	return UIConfig;
end
local bindMenu=frame:CreateMenu(395,500);
function frame:ReturnType()
	if (IsInGroup() or IsInRaid()) and GetNumGroupMembers() >1 then return "GROUP"; end
	return "MAIN";
end
function frame:TableCount(t)
	local i=0;
	for k,v in pairs(t) do i=i+1; end
	return i;
end
function frame:PlateForGUID(GUID)
	for i=1,200 do
		if UnitGUID("nameplate"..i) == GUID then
			return _G.C_NamePlate.GetNamePlateForUnit("nameplate"..i);
		end
	end
	return nil;
end
function frame:GUIDForName(Name,part)
	if type(Name)~="string" then return nil; end
	Name=string.lower(Name);
	for i=1,100 do
		local uname=GetUnitName("nameplate"..i,true);
		if uname~=nil then
			uname=string.lower(uname);
			if (uname == Name) or (part==true and string.match(uname,Name)) then return UnitGUID("nameplate"..i); end 
		end
	end
	return nil;
end

function frame:TableToString(tbl)
    local result = "{"
    for k, v in pairs(tbl) do
        if type(k) == "string" then
            result = result.."[\""..k.."\"]".."="
        end
        if type(v) == "table" then
            result = result..frame:TableToString(v)
        elseif type(v) == "boolean" then
            result = result..tostring(v)
        else
            result = result.."\""..v.."\""
        end
        result = result..","
    end
    if result ~= "" then
        result = result:sub(1, result:len()-1)
    end
    return result.."}"
end
function frame:MARK(FramePoint,name,pathmark)
	local f = CreateFrame("BUTTON",name,UIParent);
	f:SetFrameStrata("BACKGROUND");f:SetSize(50,50);
	f.texture=f:CreateTexture(); f.texture:SetTexture(pathmark); f.texture:SetAllPoints(f); 
	f:SetPoint("BOTTOM",FramePoint,"CENTER", 0, 5);
	return f;
end
function frame:UpdateIndicator(GNPFU,GUID,PARAM)
	local T=frame:ReturnType();
	local Del=0;
	if type(UFrames[T])~="table" then UFrames[T]={}; end
	if type(UFrames[T][GUID])~="table" then UFrames[T][GUID]={}; end
	if tonumber(PARAM.DEL)==1 then Del=1; PARAM.DEL=0; end 
	if type(BindMarks[PARAM.MARK])~="table" then
		for k,v in pairs(BindMarks) do
			if k~=nil then PARAM.MARK=k; break; end
		end
	end
	
	UFrames[T][GUID]=PARAM; 
	
	if type(TFrames[GUID]) == "table" then
		TFrames[GUID]:Hide(); 
		if tonumber(PARAM.HIDE)==1 or Del==1 then TFrames[GUID].texture:SetTexture(""); end
		if Del==1 then TFrames[GUID]=nil; UFrames[T][GUID]=nil; end
	end
	if tonumber(PARAM.HIDE)==1 or Del==1 or type(GNPFU)~="table" then return ""; end
	
	TFrames[GUID] = frame:MARK(GNPFU,"B4S_"..GUID,textPath..PARAM.MARK); 
	TFrames[GUID]:Show();
	TFrames[GUID]:SetScript("OnClick", function(self)
		local un,c=self:GetName():gsub("B4S_","");
		local locClass, engClass, locRace, engRace, gender, name, serv =GetPlayerInfoByGUID(un);
		if serv=="" or serv==nil  then serv=GetRealmName(); end
		--print(name.."-"..serv)
		--DEFAULT_CHAT_FRAME:AddMessage("/target "..name.."-"..serv);
		TargetUnit("mouseover");
	end)
end
 
function frame:mSetMarks(T_uGUID, T_NamePlate, Mark)
	if T_uGUID ~=nil then
		local T=frame:ReturnType(); 
		if T_NamePlate==nil then T_NamePlate=frame:PlateForGUID(T_uGUID); end
		
		if type(BindMarks[Mark])~="table" then
			for k,v in pairs(BindMarks) do
				if k~=nil then Mark=k; break; end
			end
		end
		
		local PARAM={MARK=Mark,HIDE=0}
				
		if type(TFrames[T_uGUID])=="table" and TFrames[T_uGUID].texture:GetTexture()==textPath..Mark then
			PARAM.DEL=1;
		end
		
		if T=="GROUP" then
			SendAddonMessage("KDSEND4S",frame:TableToString({SENDER=_G.UnitGUID("player"),TARGET={[T_uGUID]=PARAM}}),IsInGroup(2) and "INSTANCE_CHAT" or IsInRaid() and "RAID" or "PARTY");
		else
			PARAM.TIME=time();
		end
		frame:UpdateIndicator(T_NamePlate,T_uGUID,PARAM);
	end
end
 
 
 local function sCMD(msg,editBox)
	local T=frame:ReturnType();
	local i=0; local msgL={}; for v in string.gmatch(string.lower(msg),"([^%s]+)") do i=i+1; msgL[i]=v; end
	i=0; local msgN={}; for v in string.gmatch(msg,"([^%s]+)") do i=i+1; msgN[i]=v; end	
	
	if msgL[1] == 'search' then
		if msgL[2]==nil then msgL[2]="target"; end
		if msgL[3]==nil then msgL[3]="arrow"; end
		msgL[2]=string.lower(msgL[2]);
		local gn=GetUnitName(msgL[2],true); 
		if gn~=nil then msgL[2]=string.lower(gn); end

		if v4SEARCH[T][msgL[2]]==nil or v4SEARCH[T][msgL[2]]=="" or v4SEARCH[T][msgL[2]]~=msgL[3] then 
			v4SEARCH[T][msgL[2]]=msgL[3];
		else 
			v4SEARCH[T][msgL[2]]="";
		end
		
		for i=1,200 do
			local npUID=UnitGUID("nameplate"..i);
			if npUID~=nil then
				local Name=GetUnitName("nameplate"..i,true);
				if Name~=nil and (msgL[2] == string.lower(Name) or string.match(string.lower(Name),msgL[2])) then 
					frame:mSetMarks(npUID,_G.C_NamePlate.GetNamePlateForUnit("nameplate"..i),msgL[3]);
				end
			end
		end
		
	end
	
    if msgL[1] == 'mark' then
		local GUID=frame:GUIDForName(msgL[2],true);
		
		if msgL[2]==nil then
			GUID=_G.UnitGUID("target");
		elseif GUID==nil then
			GUID=_G.UnitGUID(msgL[2]);
		end
		if GUID~=nil then
			if msgL[4]~=nil then
				for i=1,200 do
					local npUID=UnitGUID("nameplate"..i);
					if npUID~=nil and npUID ~= GUID and type(TFrames[npUID])=="table" and TFrames[npUID].texture:GetTexture()==textPath..msgN[3] then
						frame:mSetMarks(npUID,_G.C_NamePlate.GetNamePlateForUnit("nameplate"..i),msgN[3]);
					end
				end
			end
			frame:mSetMarks(GUID,frame:PlateForGUID(GUID),msgN[3]);
		end 
	end
	
    if msgL[1] == 'reset' then
		if msgL[2]=='all' then UFrames={MAIN={},GROUP={}}; v4SEARCH={MAIN={},GROUP={}}; end
		if msgL[2]=='main' then UFrames.MAIN={}; end
		if msgL[2]=='group' then Frames.GROUP={}; end
		if msgL[2]=='search' then v4SEARCH={MAIN={},GROUP={}}; end
	   ReloadUI();
	end
	
    if msgL[1] == 'bind' then
		if msgL[2]=='reset' then BindMarks=nil; ReloadUI(); end
		if msgL[2]==nil then
			if bindMenu:IsShown() then 
				bindMenu:Hide();
			else
				bindMenu:SetHeight(GetScreenHeight()-200);
				for k,keys in pairs(BindMarks) do
					local tstr="";
					for _,v in pairs(keys) do tstr=tstr.." "..v; end
					bindMenu.marks[k].bind:SetText(tstr:match "^%s*(.-)%s*$");
				end
				bindMenu:Show();
		   end
		end
	end

end
 

function frame:UpdateStatusGroup() 
	local T=frame:ReturnType()
	if T=="MAIN" then
		for GUID,v in pairs(TFrames) do
			TFrames[GUID]:Hide(); TFrames[GUID].texture:SetTexture("");
		end
		TFrames={};
		for GUID,v in pairs(UFrames[T]) do
			if tonumber(v.HIDE)~=1 then 
				local plate=frame:PlateForGUID(GUID);
				if plate~=nil then 
					frame:UpdateIndicator(plate,GUID,v);
				end
			end
		end
		UFrames.GROUP={};TypeGroup=nil;
	else 
		if TypeGroup==nil then 
			for GUID,v in pairs(TFrames) do
				TFrames[GUID]:Hide(); TFrames[GUID].texture:SetTexture("");
			end
			TFrames={};TypeGroup=1;
			SendAddonMessage("KDQ4S",frame:TableToString({SENDER=_G.UnitGUID("player")}),IsInGroup(2) and "INSTANCE_CHAT" or IsInRaid() and "RAID" or "PARTY");
		end
	end  
end  
  
function frame:CHAT_MSG_ADDON(...)
	local args = {...}
	local T=frame:ReturnType();
	
	if (args[1] == "KDSEND4S") then
		local OBJ = loadstring("return "..args[2])()
		if type(OBJ)=="table" and _G.UnitGUID("player")~=OBJ.SENDER then 
			for k,v in pairs(OBJ.TARGET) do
				UFrames["GROUP"][k]=v;
				local plate=frame:PlateForGUID(k);
				if plate~=nil then
					frame:UpdateIndicator(plate,k,v);
				end
			end
		end
	end
	
	if args[1]=="KDQ4S" then
		local OBJ = loadstring("return "..args[2])()
		if type(OBJ)=="table" and _G.UnitGUID("player")~=OBJ.SENDER and frame:TableCount(UFrames["GROUP"])>0 then
			for k,v in pairs(UFrames["GROUP"]) do
				SendAddonMessage("KDA4S",frame:TableToString({T=time(),S=_G.UnitGUID("player"),G={[k]=v}}),IsInGroup(2) and "INSTANCE_CHAT" or IsInRaid() and "RAID" or "PARTY");
			end
		end
	end
	
	if args[1]=="KDA4S" then
		local OBJ = loadstring("return "..args[2])()
		if type(OBJ)=="table" and _G.UnitGUID("player")~=OBJ.S then 
			if lastKDA4S.GUID ~= OBJ.S then
				if tonumber(OBJ.T) >= (lastKDA4S.T+10) then
					lastKDA4S={GUID=OBJ.S,T=time()};
				else
					return "";
				end 
			end  
				for k,v in pairs(OBJ.G) do
					UFrames["GROUP"][k]=v; 
					local plate=frame:PlateForGUID(k);
					if plate~=nil then
						frame:UpdateIndicator(plate,k,v);
					end
				end 
		end
	end

end 
 

 
function frame:FORBIDDEN_NAME_PLATE_UNIT_ADDED(UToken) frame:NAME_PLATE_UNIT_ADDED(UToken); end
function frame:NAME_PLATE_UNIT_ADDED(UToken)
	local T=frame:ReturnType();
	local GNPFU=_G.C_NamePlate.GetNamePlateForUnit(UToken);
	local GUID=UnitGUID(UToken); local UN=GetUnitName(UToken,true);
	local isSearch=nil;
	
	if UN~=nil and type(GNPFU)=="table" then
		UN=string.lower(UN);
		for k,v in pairs(v4SEARCH[T]) do
			k=string.lower(k);
			if k == UN or string.match(UN,k) then
				if UFrames[T][GUID]==nil then UFrames[T][GUID]={TIME=time()}; end
				isSearch=1;
				if v=="" then
					UFrames[T][GUID].HIDE=1; UFrames[T][GUID].DEL=1;
				else 
					UFrames[T][GUID].MARK=v; UFrames[T][GUID].HIDE=0;
				end
			end
		end
	end
	
	if type(GNPFU)=="table" and type(UFrames[T][GUID])=="table" then 
		if isSearch==nil then UFrames[T][GUID].HIDE=0; end
		frame:UpdateIndicator(GNPFU,GUID,UFrames[T][GUID]);
	end
end

function frame:FORBIDDEN_NAME_PLATE_UNIT_REMOVED(UToken) frame:NAME_PLATE_UNIT_REMOVED(UToken); end
function frame:NAME_PLATE_UNIT_REMOVED(UToken)
	local GNPFU=_G.C_NamePlate.GetNamePlateForUnit(UToken);
	local GUID=UnitGUID(UToken);
	local T=frame:ReturnType();
	if type(GNPFU)=="table" and type(UFrames[T][GUID])=="table"  then
		UFrames[T][GUID].HIDE=1; 
		frame:UpdateIndicator(GNPFU,GUID,UFrames[T][GUID]);
	end
end

function frame:GROUP_ROSTER_UPDATE(arg1)
	frame:UpdateStatusGroup();
end


function frame:ADDON_LOADED(arg1)
	if (arg1 == "BindMarks" and type(BindMarks)~="table") or not BindMarks then BindMarks=DEF_BindMarks; end
	
	bindMenu.marks={};
	bindMenu.count=0; bindMenu.H=0; local x=0;
	for mname,keys in pairs(BindMarks) do
		bindMenu.count=bindMenu.count+1;  local sK=""; 
		for _,n in pairs(keys) do if sK~="" then sK=sK.." "; end sK=sK..n; end 
		local tmpF=frame:CreateButton("TOPLEFT","TOPLEFT",bindMenu.ScrollFrame,bindMenu.child,x,-bindMenu.H,120,160,backdrop,nil);
		tmpF.name=mname;
		tmpF.texture=tmpF:CreateTexture();
		tmpF.texture:SetSize(120, 120); 
		tmpF.texture:SetPoint("TOPLEFT",tmpF, "TOPLEFT",0,-5);
		tmpF.texture:SetTexture(textPath..mname);
		
		tmpF.title=tmpF:CreateFontString(nil, "OVERLAY", "GameFontHighlight")
		tmpF.title:ClearAllPoints(); 
		tmpF.title:SetPoint("BOTTOM", tmpF, "BOTTOM", 0,23);
		tmpF.title:SetWidth(120)
		tmpF.title:SetText(mname);

		tmpF.bind=tmpF:CreateFontString(nil, "OVERLAY", "GameFontNormal")
		tmpF.bind:ClearAllPoints(); 
		tmpF.bind:SetPoint("BOTTOM", tmpF, "BOTTOM", 0,3);
		tmpF.bind:SetWidth(120)

		tmpF:SetScript("OnClick", function(self, key)
			for mname,elem in pairs(bindMenu.marks) do
				if elem.name~=self.name then bindMenu.marks[elem.name].F_click=nil; bindMenu.marks[elem.name]:SetBackdrop(backdrop); end
			end
			if bindMenu.marks[self.name].F_click then 
				bindMenu.marks[self.name]:SetBackdrop(backdrop);
				bindMenu.marks[self.name].F_click=nil; 
			else
				bindMenu.marks[self.name]:SetBackdrop(backdrop_active);
				bindMenu.marks[self.name].F_click=1;
			end
		end)
		
		bindMenu.marks[mname]=tmpF;
		x=x+125;
		if (bindMenu.count % 3) == 0 then bindMenu.H=bindMenu.H+165; x=0; end
	end 
	if (bindMenu.count % 3) == 0 then bindMenu.H=bindMenu.H-165; end
	
	bindMenu.saveBtn = frame:CreateButton("CENTER","BOTTOM",bindMenu.ScrollFrame,bindMenu.child,0,20,100,30,nil,L["SAVE"])
	bindMenu.saveBtn:SetScript("OnClick", function(self, key)
	
		for mname,elem in pairs(bindMenu.marks) do
			BindMarks[mname]={}; local i=0;
			if elem.bind:GetText() then
				for v in string.gmatch(elem.bind:GetText(),"[^%s]+") do 
					i=i+1; BindMarks[mname][i]=v;
				end
			end
		end
		
		bindMenu:Hide();
	end)

	bindMenu.child:SetHeight(bindMenu.H+220); 
	
	UFrames.GROUP={};
	--UFrames={MAIN={},GROUP={}};
	RegisterAddonMessagePrefix("KDSEND4S")
	RegisterAddonMessagePrefix("KDQ4S")
	RegisterAddonMessagePrefix("KDA4S")
	
	frame:UpdateStatusGroup();
end
function frame:PLAYER_LOGOUT(arg1)
	UFrames.GROUP={};
	--UFrames={MAIN={},GROUP={}};
end
--#####################################################################################
frame:SetPropagateKeyboardInput(true);
frame:SetScript("OnKeyDown", function(self, key)
if type(BindMarks)=="table" then
for m,allk in pairs(BindMarks) do 
	local arrlen=0;for k,v in pairs(allk) do arrlen=arrlen+1;end
	local klen=0;
	for k,v in pairs(allk) do
		if v=="SHIFT" and IsShiftKeyDown() then klen=klen+1; end
		if v=="CTRL" and IsControlKeyDown() then klen=klen+1; end
		if v=="ALT" and IsAltKeyDown() then klen=klen+1; end
		if key==v then klen=klen+1; end 
		if klen==arrlen then 
			frame:mSetMarks(_G.UnitGUID("target"), _G.C_NamePlate.GetNamePlateForUnit("target"), m);
		end 
		
	end
	if bindMenu:IsShown() and bindMenu.marks[m].F_click then
		local kstring="";
		if IsControlKeyDown() then kstring=kstring.."CTRL "; end  
		if IsShiftKeyDown() then kstring=kstring.."SHIFT "; end
		if IsAltKeyDown() then kstring=kstring.."ALT "; end
		if(key ~= "LSHIFT" and key ~= "RSHIFT" and key ~= "LCTRL" and  key ~= "RCTRL" and key ~= "LALT" and key ~= "RALT" and key ~= "SCREENSHOT" ) then kstring=kstring..key:gsub("UMPAD", ""):gsub("BACKSPACE", "BS");  end
		if(key == "ESCAPE") then kstring="";  end
		bindMenu.marks[m].bind:SetText(kstring);
		if(key == "ESCAPE") then bindMenu.marks[m].F_click=nil; bindMenu.marks[m]:SetBackdrop(backdrop);  end
	end		
end
end 

end)


SLASH_SLASHCMD4S1='/4s'; SlashCmdList["SLASHCMD4S"] = sCMD;

frame:RegisterEvent("ADDON_LOADED");
frame:RegisterEvent("PLAYER_LOGOUT");
frame:RegisterEvent("FORBIDDEN_NAME_PLATE_UNIT_ADDED");
frame:RegisterEvent("FORBIDDEN_NAME_PLATE_UNIT_REMOVED");
frame:RegisterEvent("NAME_PLATE_UNIT_ADDED");
frame:RegisterEvent("NAME_PLATE_UNIT_REMOVED");
frame:RegisterEvent("CHAT_MSG_ADDON")
frame:RegisterEvent("GROUP_ROSTER_UPDATE");
frame:SetScript("OnEvent",function(self, event, ...) self[event](self, ...) end)
