---------------------------------------------------------
-- First Blood
-- Create Date: 3/5/2018
-- Version 3.0
---------------------------------------------------------

local FBTimer, FBCounter
FBDB = FBDB or { ["Enabled"] = true, ["Counter"] = 60, ["AlertOnly"] = false, ["PvPOnly"] = true, ["RandomSounds"] = true, ["Debug"] = false }
local bit_band = bit.band
local bit_bor = bit.bor
local kill_confirmed = 0

local function hasFlag(flags, flag)
	return bit_band(flags, flag) == flag
end

---------------------------------------------------------

-- List of Sounds
local soundFiles = {
	"Interface\\AddOns\\FirstBlood\\Sounds\\assassin.mp3",
	"Interface\\AddOns\\FirstBlood\\Sounds\\biggamehunter.mp3",
	"Interface\\AddOns\\FirstBlood\\Sounds\\biohazard.mp3",
	"Interface\\AddOns\\FirstBlood\\Sounds\\blazeofglory.mp3",
	"Interface\\AddOns\\FirstBlood\\Sounds\\bloodbath.mp3",
	"Interface\\AddOns\\FirstBlood\\Sounds\\bluestreak.mp3",
	"Interface\\AddOns\\FirstBlood\\Sounds\\bottomfeeder.mp3",
	"Interface\\AddOns\\FirstBlood\\Sounds\\bullseye.mp3",
	"Interface\\AddOns\\FirstBlood\\Sounds\\carjacked.mp3",
	"Interface\\AddOns\\FirstBlood\\Sounds\\comboking.mp3",
	"Interface\\AddOns\\FirstBlood\\Sounds\\denied.mp3",
	"Interface\\AddOns\\FirstBlood\\Sounds\\dominating.mp3",
	"Interface\\AddOns\\FirstBlood\\Sounds\\doublekill.mp3",
	"Interface\\AddOns\\FirstBlood\\Sounds\\eagleeye.mp3",
	"Interface\\AddOns\\FirstBlood\\Sounds\\eradication.mp3",
	"Interface\\AddOns\\FirstBlood\\Sounds\\excellent.mp3",
	"Interface\\AddOns\\FirstBlood\\Sounds\\extermination.mp3",
	"Interface\\AddOns\\FirstBlood\\Sounds\\flakmaster.mp3",
	"Interface\\AddOns\\FirstBlood\\Sounds\\gunslinger.mp3",
	"Interface\\AddOns\\FirstBlood\\Sounds\\hattrick.mp3",
	"Interface\\AddOns\\FirstBlood\\Sounds\\headhunter.mp3",
	"Interface\\AddOns\\FirstBlood\\Sounds\\headshot.mp3",
	"Interface\\AddOns\\FirstBlood\\Sounds\\hijacked.mp3",
	"Interface\\AddOns\\FirstBlood\\Sounds\\hitandrun.mp3",
	"Interface\\AddOns\\FirstBlood\\Sounds\\impressive.mp3",
	"Interface\\AddOns\\FirstBlood\\Sounds\\jackhammer.mp3",
	"Interface\\AddOns\\FirstBlood\\Sounds\\juggernaut.mp3",
	"Interface\\AddOns\\FirstBlood\\Sounds\\killingmachine.mp3",
	"Interface\\AddOns\\FirstBlood\\Sounds\\killingspree.mp3",
	"Interface\\AddOns\\FirstBlood\\Sounds\\maniac.mp3",
	"Interface\\AddOns\\FirstBlood\\Sounds\\massacre.mp3",
	"Interface\\AddOns\\FirstBlood\\Sounds\\megakill.mp3",
	"Interface\\AddOns\\FirstBlood\\Sounds\\monsterkill.mp3",
	"Interface\\AddOns\\FirstBlood\\Sounds\\multikill.mp3",
	"Interface\\AddOns\\FirstBlood\\Sounds\\nodebuster.mp3",
	"Interface\\AddOns\\FirstBlood\\Sounds\\outstanding.mp3",
	"Interface\\AddOns\\FirstBlood\\Sounds\\pancake.mp3",
	"Interface\\AddOns\\FirstBlood\\Sounds\\payback.mp3",
	"Interface\\AddOns\\FirstBlood\\Sounds\\rampage.mp3",
	"Interface\\AddOns\\FirstBlood\\Sounds\\rejected.mp3",
	"Interface\\AddOns\\FirstBlood\\Sounds\\retribution.mp3",
	"Interface\\AddOns\\FirstBlood\\Sounds\\roadkill.mp3",
	"Interface\\AddOns\\FirstBlood\\Sounds\\termination.mp3",
	"Interface\\AddOns\\FirstBlood\\Sounds\\topgun.mp3",
	"Interface\\AddOns\\FirstBlood\\Sounds\\ultrakill.mp3",
	"Interface\\AddOns\\FirstBlood\\Sounds\\unreal.mp3",
	"Interface\\AddOns\\FirstBlood\\Sounds\\unstoppable.mp3",
	"Interface\\AddOns\\FirstBlood\\Sounds\\vengeance.mp3",
	"Interface\\AddOns\\FirstBlood\\Sounds\\warpath.mp3"
}

local numSounds = #soundFiles

---------------------------------------------------------
local OnEvent = function(self, event, ...)
	self[event](self, event, ...) -- watches multiple event functions
end

---------------------------------------------------------
local f = CreateFrame("Frame", nil, UIParent)
f:RegisterEvent("VARIABLES_LOADED")
f:RegisterEvent("PLAYER_DEAD")
f:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED")
f:SetScript("OnEvent", OnEvent)
---------------------------------------------------------

function f:PLAYER_DEAD()
	FBCounter = 0
end
	
function f:VARIABLES_LOADED()
	if FBDB.Counter == nil then
		if FBDB.Debug then
			DEFAULT_CHAT_FRAME:AddMessage("|cff8A0707First Blood|r Adding Alerts")
		end
		FBDB.Counter = 60
	end
	if FBDB.Enabled == nil then
		if FBDB.Debug then
			DEFAULT_CHAT_FRAME:AddMessage("|cff8A0707First Blood|r Adding Alerts")
		end
		FBDB.Enabled = true
	end
	if FBDB.AlertOnly == nil then
		if FBDB.Debug then
			DEFAULT_CHAT_FRAME:AddMessage("|cff8A0707First Blood|r Adding Alerts")
		end
		FBDB.AlertOnly = false
	end
	if FBDB.PvPOnly == nil then
		if FBDB.Debug then
			DEFAULT_CHAT_FRAME:AddMessage("|cff8A0707First Blood|r Adding PvPOnly")
		end
		FBDB.PvPOnly = true
	end
	if FBDB.RandomSounds == nil then
		if FBDB.Debug then
			DEFAULT_CHAT_FRAME:AddMessage("|cff8A0707First Blood|r Adding RandomSounds")
		end
		FBDB.RandomSounds = true
	end
	if FBDB.Debug == nil then
		if FBDB.Debug then
			DEFAULT_CHAT_FRAME:AddMessage("|cff8A0707First Blood|r Adding Debug")
		end
		FBDB.Debug = false
	end
	f:UnregisterEvent("VARIABLES_LOADED")
	DEFAULT_CHAT_FRAME:AddMessage("|cff8A0707First Blood|r Loaded")
	SLASH_FirstBlood1 = "/firstblood"
	SlashCmdList["FirstBlood"] = function(msg)
		if msg == 'toggle' then
			FBDB.Enabled = not FBDB.Enabled
			DEFAULT_CHAT_FRAME:AddMessage("|cff8A0707First Blood|r: Enabled = "..tostring(FBDB.Enabled))
		elseif msg == '10' then
			FBDB.Counter = 10
			DEFAULT_CHAT_FRAME:AddMessage("|cff8A0707First Blood|r: Set to 10 Seconds")
			do return end
		elseif msg == '20' then
			FBDB.Counter = 20
			DEFAULT_CHAT_FRAME:AddMessage("|cff8A0707First Blood|r: Set to 20 Seconds")
			do return end
		elseif msg == '30' then
			FBDB.Counter = 30
			DEFAULT_CHAT_FRAME:AddMessage("|cff8A0707First Blood|r: Set to 30 Seconds")
			do return end
		elseif msg == '40' then
			FBDB.Counter = 40
			DEFAULT_CHAT_FRAME:AddMessage("|cff8A0707First Blood|r: Set to 40 Seconds")
			do return end
		elseif msg == '50' then
			FBDB.Counter = 50	
			DEFAULT_CHAT_FRAME:AddMessage("|cff8A0707First Blood|r: Set to 50 Seconds")
			do return end
		elseif msg == '60' then
			FBDB.Counter = 60
			DEFAULT_CHAT_FRAME:AddMessage("|cff8A0707First Blood|r: Set to 60 Seconds")
			do return end
		elseif msg == '120' then
			FBDB.Counter = 120
			DEFAULT_CHAT_FRAME:AddMessage("|cff8A0707First Blood|r: Set to 120 Seconds")
			do return end
		elseif msg == 'alert' then
			FBDB.AlertOnly = not FBDB.AlertOnly
			DEFAULT_CHAT_FRAME:AddMessage("|cff8A0707First Blood|r: Killing Blows while muted = "..tostring(FBDB.AlertOnly))
		elseif msg == 'pvp' then
			FBDB.PvPOnly = not FBDB.PvPOnly
			DEFAULT_CHAT_FRAME:AddMessage("|cff8A0707First Blood|r: Killing Blows in PvP Only = "..tostring(FBDB.PvPOnly))
		elseif msg == 'random' then
			FBDB.RandomSounds = not FBDB.RandomSounds
			DEFAULT_CHAT_FRAME:AddMessage("|cff8A0707First Blood|r: New! Random Sounds = "..tostring(FBDB.RandomSounds))
		elseif msg == 'config' then
			DEFAULT_CHAT_FRAME:AddMessage("|cff8A0707First Blood|r: [enabled] = "..tostring(FBDB.Enabled))
			DEFAULT_CHAT_FRAME:AddMessage("|cff8A0707First Blood|r: [10-60] Seconds Set To = "..tostring(FBDB.Counter))
			DEFAULT_CHAT_FRAME:AddMessage("|cff8A0707First Blood|r: [alert] Killing Blows while muted = "..tostring(FBDB.AlertOnly))
			DEFAULT_CHAT_FRAME:AddMessage("|cff8A0707First Blood|r: [pvp] Killing Blows in PvP Only = "..tostring(FBDB.PvPOnly))
			DEFAULT_CHAT_FRAME:AddMessage("|cff8A0707First Blood|r: [random] New! Random Sounds = "..tostring(FBDB.RandomSounds))
			DEFAULT_CHAT_FRAME:AddMessage("|cff8A0707First Blood|r: [debug] Debug = "..tostring(FBDB.Debug))
		elseif msg == 'debug' then
			FBDB.Debug = not FBDB.Debug
			DEFAULT_CHAT_FRAME:AddMessage("|cff8A0707First Blood|r: Debug = "..tostring(FBDB.Debug))
		else
		DEFAULT_CHAT_FRAME:AddMessage("|cff8A0707First Blood|r: Options")
		DEFAULT_CHAT_FRAME:AddMessage("|cff8A0707First Blood|r: /firstblood toggle - to Enable or Disable Addon")
		DEFAULT_CHAT_FRAME:AddMessage("|cff8A0707First Blood|r: /firstblood 10-60  - (in 10 second Increments) to change the time needed between kills")
		DEFAULT_CHAT_FRAME:AddMessage("|cff8A0707First Blood|r: /firstblood pvp  - Toggle this to announce killing blows in PvE and PvP (Default: True [PvP Only])")
		DEFAULT_CHAT_FRAME:AddMessage("|cff8A0707First Blood|r: /firstblood random  - Disabling this will stop random and restore original sounds (Default: Enabled")
		DEFAULT_CHAT_FRAME:AddMessage("|cff8A0707First Blood|r: /firstblood alert  - Enabling this will turn the WoW sound on for killing blow alerts only (Useful if you play WoW without sound)")
		end
	end
end

function f:COMBAT_LOG_EVENT_UNFILTERED(event, timestamp, eventType, hideCaster, sourceGUID, sourceName, sourceFlags, sourceRaidFlags, destGUID, destName, destFlags, destRaidFlags, spellId, spellName, spellSchool, auraType, ...)
	if (eventType == "PARTY_KILL") and hasFlag(sourceFlags, COMBATLOG_OBJECT_AFFILIATION_MINE) and FBDB.Enabled then
		if FBDB.PvPOnly and hasFlag(destFlags, COMBATLOG_OBJECT_TYPE_PLAYER) then
				kill_confirmed = 1
				if FBDB.Debug then
					DEFAULT_CHAT_FRAME:AddMessage("|cff8A0707First Blood|r: kill confirmed pvp")
				end
		elseif (not FBDB.PvPOnly) then
				kill_confirmed = 1
				if FBDB.Debug then
					DEFAULT_CHAT_FRAME:AddMessage("|cff8A0707First Blood|r: kill confirmed pve")
				end
		else
			if FBDB.Debug then
				DEFAULT_CHAT_FRAME:AddMessage("|cff8A0707First Blood|r: no kill for you")
			end
			do return end
		end
			if kill_confirmed == 1 and (not FBTimer or (GetTime() - FBTimer > FBDB.Counter)) then
				if FBDB.Debug then
					DEFAULT_CHAT_FRAME:AddMessage("|cff8A0707First Blood|r: Sound on")
				end
				if FBDB.AlertOnly then
					SetCVar("Sound_EnableAllSound", 1)
					C_Timer.After(2.2, function() ToggleSound() end)
				end
				PlaySoundFile("Interface\\AddOns\\FirstBlood\\Sounds\\firstblood.mp3")
				if FBDB.Debug then
					DEFAULT_CHAT_FRAME:AddMessage("|cff8A0707First Blood|r: kill 1")
				end
				FBCounter = 1
			elseif kill_confirmed == 1 and (GetTime() - FBTimer <= FBDB.Counter) then
				FBCounter = FBCounter + 1
				if (FBCounter == 2) then
					if FBDB.AlertOnly then
						SetCVar("Sound_EnableAllSound", 1)
						C_Timer.After(2.2, function() ToggleSound() end)
					end
					if FBDB.RandomSounds then
						PlaySoundFile(soundFiles[random(1, numSounds)])
						if FBDB.Debug then
							DEFAULT_CHAT_FRAME:AddMessage("|cff8A0707First Blood|r: random 1")
						end
					else				
						PlaySoundFile("Interface\\AddOns\\FirstBlood\\Sounds\\dominating.mp3")
						if FBDB.Debug then
							DEFAULT_CHAT_FRAME:AddMessage("|cff8A0707First Blood|r: kill 2")
						end
					end
				elseif (FBCounter == 3) then
					if FBDB.AlertOnly then
						SetCVar("Sound_EnableAllSound", 1)
						C_Timer.After(2.2, function() ToggleSound() end)
					end
					if FBDB.RandomSounds then
						PlaySoundFile(soundFiles[random(1, numSounds)])
						if FBDB.Debug then	
							DEFAULT_CHAT_FRAME:AddMessage("|cff8A0707First Blood|r: random 2")
						end	
					else
						PlaySoundFile("Interface\\AddOns\\FirstBlood\\Sounds\\killingspree.mp3")
						if FBDB.Debug then
							DEFAULT_CHAT_FRAME:AddMessage("|cff8A0707First Blood|r: kill 3")
						end	
					end
				elseif (FBCounter == 4) then
					if FBDB.AlertOnly then
						SetCVar("Sound_EnableAllSound", 1)
						C_Timer.After(2.2, function() ToggleSound() end)
					end
					if FBDB.RandomSounds then
						PlaySoundFile(soundFiles[random(1, numSounds)])
						if FBDB.Debug then	
							DEFAULT_CHAT_FRAME:AddMessage("|cff8A0707First Blood|r: random 3")
						end
					else
						PlaySoundFile("Interface\\AddOns\\FirstBlood\\Sounds\\unstoppable.mp3")
						if FBDB.Debug then
							DEFAULT_CHAT_FRAME:AddMessage("|cff8A0707First Blood|r: kill 4")
						end
					end
				elseif (FBCounter == 5) then
					if FBDB.AlertOnly then
						SetCVar("Sound_EnableAllSound", 1)
						C_Timer.After(2.2, function() ToggleSound() end)
					end
					if FBDB.RandomSounds then
						PlaySoundFile(soundFiles[random(1, numSounds)])
						if FBDB.Debug then
							DEFAULT_CHAT_FRAME:AddMessage("|cff8A0707First Blood|r: random 4")
						end
					else
						PlaySoundFile("Interface\\AddOns\\FirstBlood\\Sounds\\termination.mp3")
						if FBDB.Debug then
							DEFAULT_CHAT_FRAME:AddMessage("|cff8A0707First Blood|r: kill 5")
						end
					end
				elseif (FBCounter >= 6) then
					if FBDB.AlertOnly then
						SetCVar("Sound_EnableAllSound", 1)
						C_Timer.After(2.2, function() ToggleSound() end)
					end
						PlaySoundFile("Interface\\AddOns\\FirstBlood\\Sounds\\godlike.mp3")
						if FBDB.Debug then
							DEFAULT_CHAT_FRAME:AddMessage("|cff8A0707First Blood|r: godlike")
						end
						if (not FBDB.PvPOnly) then
							if FBDB.Debug then
							DEFAULT_CHAT_FRAME:AddMessage("|cff8A0707First Blood|r: reset to random 1")
							end
							FBCounter = 1
						end
					end
			end
			kill_confirmed = 0
		if FBDB.Debug then
			DEFAULT_CHAT_FRAME:AddMessage("|cff8A0707First Blood|r: kill confirmed cleared")	
		end
		FBTimer = GetTime()
	end
end

function ToggleSound()
	if GetCVar("Sound_EnableAllSound") == "0" then SetCVar("Sound_EnableAllSound", 1) else SetCVar("Sound_EnableAllSound", 0) end
	if FBDB.Debug then
		DEFAULT_CHAT_FRAME:AddMessage("|cff8A0707First Blood|r: Sound off")
	end
end