﻿-- SETTINGS MODULE --

-- options frame
hopAddon.optionsFrame = CreateFrame("Frame","hopOptions",hopAddon)
hopAddon.optionsFrame:SetFrameLevel(10)
hopAddon.optionsFrame:SetSize(400,425)
hopAddon.optionsFrame:SetPoint("CENTER",UIParent,"CENTER",0,0)
hopAddon.optionsFrame:SetBackdrop({bgFile = "Interface\\DialogFrame\\UI-DialogBox-Background", 
					edgeFile = "Interface\\DialogFrame\\UI-DialogBox-Border", 
					tile = true, tileSize = 32, edgeSize = 32, 
					insets = { left = 11, right = 11, top = 12, bottom = 10 }});
hopAddon.optionsFrame:Hide()

hopAddon.optionsFrame.header = hopAddon.optionsFrame:CreateTexture(nil,"ARTWORK")
hopAddon.optionsFrame.header:SetSize(300,68)
hopAddon.optionsFrame.header:SetPoint("TOP",0,12)
hopAddon.optionsFrame.header:SetTexture("Interface\\DialogFrame\\UI-DialogBox-Header")

hopAddon.optionsFrame.headerString = hopAddon.optionsFrame:CreateFontString("headerString", "OVERLAY", "GameFontNormal")
hopAddon.optionsFrame.headerString:SetPoint("TOP",0,-4)
hopAddon.optionsFrame.headerString:SetText("Filter v"..SERVERHOP_VERSION)

hopAddon.optionsFrame.closeButton = CreateFrame("Button", "optionsInFrameCloseBut", hopAddon.optionsFrame,"BrowserButtonTemplate")
hopAddon.optionsFrame.closeButton:SetSize(25,25)
hopAddon.optionsFrame.closeButton:SetPoint("TOPRIGHT",-6,-6)
hopAddon.optionsFrame.closeButton.Icon = hopAddon.optionsFrame.closeButton:CreateTexture("optionsClosetex","OVERLAY")
hopAddon.optionsFrame.closeButton.Icon:SetSize(14,14)
hopAddon.optionsFrame.closeButton.Icon:SetPoint("CENTER",0,0)
hopAddon.optionsFrame.closeButton.Icon:SetTexture("Interface\\Buttons\\UI-StopButton")
hopAddon.optionsFrame.closeButton:SetScript("OnClick", function(btn)
	hopAddon.optionsFrame:Hide()
	PlaySound(PlaySoundKitID and "igMainMenuOptionCheckBoxOn" or 856)	
end)

hopAddon.optionsFrame:SetMovable(true)
hopAddon.optionsFrame:EnableMouse(true)
hopAddon.optionsFrame:RegisterForDrag("LeftButton")
hopAddon.optionsFrame:SetScript("OnDragStart", hopAddon.optionsFrame.StartMoving)
hopAddon.optionsFrame:SetScript("OnDragStop", hopAddon.optionsFrame.StopMovingOrSizing)


-- Author Notes Frame
hopAddon.optionsFrame.optionsAuthor = CreateFrame("Frame",nil,hopAddon.optionsFrame)
local authorFrame = hopAddon.optionsFrame.optionsAuthor
authorFrame:SetBackdrop({ 
					edgeFile = "Interface\\Tooltips\\UI-Tooltip-Border", 
					tile = true, tileSize = 16, edgeSize = 16, 
					insets = { left = 5, right = 5, top = 5, bottom = 5 }});
authorFrame:SetSize(360,75)
authorFrame:SetPoint("BOTTOM",0,20)
authorFrame:SetBackdropBorderColor(0.6,0.6,0.6,1)
authorFrame:Show()

authorFrame.updateString = authorFrame:CreateFontString("updateString", "OVERLAY", "GameFontNormal")
authorFrame.updateString:SetWidth(330)
authorFrame.updateString:SetJustifyH("LEFT")
authorFrame.updateString:SetPoint("TOPLEFT",15,-15)
authorFrame.updateString:SetText(HOPADDON_UPDATESTRING)

authorFrame.linkBox = CreateFrame("EditBox", nil, authorFrame, "LFGListEditBoxTemplate")
authorFrame.linkBox:SetPoint("BOTTOM",0,10)
authorFrame.linkBox:SetSize(320,20)
authorFrame.linkBox:SetText("https://www.curseforge.com/wow/addons/filter")
authorFrame.linkBox:SetScript("OnTextChanged", function(self,userInput)
	authorFrame.linkBox:SetText("https://www.curseforge.com/wow/addons/filter")
end)

-- TAB LIST --
hopAddon.optionsFrame.tabList = CreateFrame("Frame",nil,hopAddon.optionsFrame)
local optionTabs = hopAddon.optionsFrame.tabList
optionTabs:SetBackdrop({ 
					edgeFile = "Interface\\Tooltips\\UI-Tooltip-Border", 
					tile = true, tileSize = 16, edgeSize = 16, 
					insets = { left = 5, right = 5, top = 5, bottom = 5 }});

optionTabs:SetSize(110,160)
optionTabs:SetPoint("TOPLEFT",20,-30)
optionTabs:Show()

local tabList = {}

local function CreateOptionsTab(index,text)
	-- creating tab
	local frame = CreateFrame("Frame",nil,hopAddon.optionsFrame)
	frame:SetBackdrop({ 
						edgeFile = "Interface\\Tooltips\\UI-Tooltip-Border", 
						tile = true, tileSize = 16, edgeSize = 16, 
						insets = { left = 5, right = 5, top = 5, bottom = 5 }});

	frame:SetSize(240,290)
	frame:SetPoint("TOPRIGHT",-20,-30)
	frame:SetBackdropBorderColor(0.6,0.6,0.6,1)
	frame:Hide()
	
	-- creating button
	local button = CreateFrame("Button", nil, optionTabs)
	button:SetSize(110,25)
	button:SetPoint("TOPLEFT",0,-5-index*25)

	local highlightTexture = button:CreateTexture()
	highlightTexture:SetPoint("TOPLEFT",2,0)
	highlightTexture:SetPoint("BOTTOMRIGHT",-2,1)
	highlightTexture:SetTexture("Interface\\QuestFrame\\UI-QuestLogTitleHighlight")
	button:SetHighlightTexture(highlightTexture,"ADD")

	button.textName = button:CreateFontString(nil, "OVERLAY", "GameFontNormal")
	button.textName:SetSize(156,36)
	button.textName:SetPoint("LEFT",button,"LEFT",8,0)
	button.textName:SetJustifyH("LEFT")
	button.textName:SetText(text)
	
	button.textName:SetTextColor(1,0.82,0,1)

	button:SetScript("OnClick",function(btn)
		-- Hiding all
		for i=1,#tabList do
			tabList[i].frame:Hide()
			tabList[i].button.textName:SetTextColor(1,0.82,0,1)
		end
		
		-- Showing selected
		frame:Show()
		button.textName:SetTextColor(1,1,1,1)
	end)
	
	t = {}
	t.frame = frame
	t.button = button
	
	table.insert(tabList,t)
	
	return frame,button
end

-- Global options frame
hopAddon.optionsFrame.globalOptionsFrame,optionTabs.buttonGlobal = CreateOptionsTab(0,GRAPHICS_LABEL)
local globalOptions = hopAddon.optionsFrame.globalOptionsFrame
optionTabs.buttonGlobal.textName:SetTextColor(1,1,1,1)
globalOptions:Show()

globalOptions.stringGlobalOptions = globalOptions:CreateFontString("globalOptions","OVERLAY","GameFontNormal")
globalOptions.stringGlobalOptions:SetPoint("TOPLEFT",15,-15)
globalOptions.stringGlobalOptions:SetText(GRAPHICS_LABEL)

globalOptions.MinimapCheckButton = CreateFrame("CheckButton","MinimapCheck",globalOptions,"ChatConfigCheckButtonTemplate")
globalOptions.MinimapCheckButton:SetPoint("TOPLEFT",15,-35)
getglobal(globalOptions.MinimapCheckButton:GetName() .. 'Text'):SetText(HOPADDON_MINIMAPOPTIONS)
globalOptions.MinimapCheckButton.tooltip = HOPADDON_MINIMAPOPTIONS_DESCR
globalOptions.MinimapCheckButton:SetChecked(true)
globalOptions.MinimapCheckButton:SetEnabled(false) -- <- Just for 1.1.1 before fix!


globalOptions.stringMinimap = globalOptions:CreateFontString("sh_minimapLayer", "OVERLAY", "GameFontDisable") -- GameFontNormal <- Just for 1.1.0a before fix!
globalOptions.stringMinimap:SetPoint("TOPLEFT",30,-64)
globalOptions.stringMinimap:SetJustifyH("RIGHT")
globalOptions.stringMinimap:SetSize(60,20)
globalOptions.stringMinimap:SetText(SERVERHOP_LAYER)


globalOptions.minimapStrataDrop = CreateFrame("Frame", "SH_MinimapStrataDrop", globalOptions, "UIDropDownMenuTemplate")
local drop = globalOptions.minimapStrataDrop
drop:SetPoint("TOPLEFT",80,-60)

-- list of options in droplist
SH_minimapStrataDropTable = {
	"BACKGROUND",
	"LOW",
	"MEDIUM",
	"HIGH",
	"DIALOG",
}

function minimapStrataDropOnClick(self)
	UIDropDownMenu_SetSelectedID(drop, self:GetID())
	hopAddon.minimap.objects["ServerHop"]:SetFrameStrata(SH_minimapStrataDropTable[self:GetID()])
end

drop.initialize = function(self,level)
	if not level then return end
	local info = UIDropDownMenu_CreateInfo()
	for k,v in pairs(SH_minimapStrataDropTable) do
		info = UIDropDownMenu_CreateInfo()
		info.text = v
		info.value = v
		info.func = minimapStrataDropOnClick
		UIDropDownMenu_AddButton(info,level)
	end
end
UIDropDownMenu_Initialize(drop, drop.initialize)
UIDropDownMenu_SetSelectedID(drop, 3)
UIDropDownMenu_SetText(drop,"MEDIUM")
UIDropDownMenu_SetWidth(drop,80)
UIDropDownMenu_DisableDropDown(drop) -- <- Just for 1.1.0a before fix!

globalOptions.MinimapCheckButton:SetScript("OnClick", function(btn)
	if btn:GetChecked() then
		UIDropDownMenu_EnableDropDown(drop)
	else
		UIDropDownMenu_DisableDropDown(drop)
	end

	hopAddon.var.minimapDB.global.minimap.hide = not hopAddon.var.minimapDB.global.minimap.hide
	if hopAddon.var.minimapDB.global.minimap.hide then
		hopAddon.minimap:Hide("ServerHop")
	else
		hopAddon.minimap:Show("ServerHop")
		hopAddon.minimap.objects["ServerHop"]:SetFrameStrata(SH_minimapStrataDropTable[UIDropDownMenu_GetSelectedID(drop)])
	end
	PlaySound(PlaySoundKitID and "igMainMenuOptionCheckBoxOn" or 856)		
end)



globalOptions.statusCheckButton = CreateFrame("CheckButton","statusCheckBtn",globalOptions,"ChatConfigCheckButtonTemplate")
globalOptions.statusCheckButton:SetPoint("TOPLEFT",15,-95)
getglobal(globalOptions.statusCheckButton:GetName() .. 'Text'):SetText(HOPADDON_SHOWSTATUSOPTION)
globalOptions.statusCheckButton.tooltip = HOPADDON_SHOWSTATUSTOOLTIP
globalOptions.statusCheckButton:SetChecked(true)

globalOptions.stringStatusPosition = globalOptions:CreateFontString("sh_statusposition", "OVERLAY", "GameFontNormal")
globalOptions.stringStatusPosition:SetPoint("TOPLEFT",30,-124)
globalOptions.stringStatusPosition:SetJustifyH("RIGHT")
globalOptions.stringStatusPosition:SetSize(60,20)
globalOptions.stringStatusPosition:SetText(SERVERHOP_LAYOUT)



globalOptions.statusFrameDrop = CreateFrame("Frame", "SH_StatusFrameDrop", globalOptions, "UIDropDownMenuTemplate")
local drop = globalOptions.statusFrameDrop
drop:SetPoint("TOPLEFT",80,-120)
function statusFrameDropOnClick(self)
	UIDropDownMenu_SetSelectedID(drop, self:GetID())
	hopAddon.SH_MoveStatusFrame(self:GetID())
end
-- list of options in droplist
SH_statusFrameDropTable = {
	HOPADDON_LEFT,
	HOPADDON_RIGHT,
}
drop.initialize = function(self,level)
	if not level then return end
	local info = UIDropDownMenu_CreateInfo()
	for k,v in pairs(SH_statusFrameDropTable) do
		info = UIDropDownMenu_CreateInfo()
		info.text = v
		info.value = v
		info.func = statusFrameDropOnClick
		UIDropDownMenu_AddButton(info,level)
	end
end
UIDropDownMenu_Initialize(drop, drop.initialize)
UIDropDownMenu_SetSelectedID(drop, 2)
UIDropDownMenu_SetText(drop,HOPADDON_RIGHT)
UIDropDownMenu_SetWidth(drop,80)


globalOptions.statusCheckButton:SetScript("OnClick", function(btn)
	if btn:GetChecked() then
		UIDropDownMenu_EnableDropDown(drop)
	else
		UIDropDownMenu_DisableDropDown(drop)
	end
	if hopAddon.hopStatus:IsShown() then
		hopAddon.hopStatus:Hide()
	elseif IsInGroup() or IsInRaid() then
		hopAddon.hopStatus:Show()
	end
	PlaySound(PlaySoundKitID and "igMainMenuOptionCheckBoxOn" or 856)
end)

globalOptions.chatNotifButton = CreateFrame("CheckButton","FilterChatNotifCheckBtn",globalOptions,"ChatConfigCheckButtonTemplate")
globalOptions.chatNotifButton:SetPoint("TOPLEFT",15,-155)
getglobal(globalOptions.chatNotifButton:GetName() .. 'Text'):SetText(HOPADDON_NOTIFCHECK)
globalOptions.chatNotifButton.tooltip = HOPADDON_NOTIFTOOLTIP
globalOptions.chatNotifButton:SetChecked(true)


local availableLanguages = C_LFGList.GetAvailableLanguageSearchFilter();
local defaultLanguages = C_LFGList.GetDefaultLanguageSearchFilter();

local canChangeLanguages = false;
for i=1, #availableLanguages do
	if ( not defaultLanguages[availableLanguages[i]] ) then
		canChangeLanguages = true;
		break;
	end
end

if ( canChangeLanguages ) then
	globalOptions.languageFilterButton = CreateFrame("Button","catFiltersBtn",globalOptions,"UIMenuButtonStretchTemplate")
	globalOptions.languageFilterButton:SetText(HOPADDON_LANGUAGEFILTER)
	globalOptions.languageFilterButton:SetSize(160,25)
	globalOptions.languageFilterButton:SetPoint("BOTTOM",globalOptions,"BOTTOM",0,55)
	globalOptions.languageFilterButton:SetScript("OnClick", function(self)
		ToggleDropDownMenu(1, nil, LFGListLanguageFilterDropDownFrame, self, 0, -2, "MENU");
	end)
end

globalOptions.buttonClearBL = CreateFrame("Button",nil,globalOptions,"UIGoldBorderButtonTemplate")
globalOptions.buttonClearBL:SetSize(210,28)
globalOptions.buttonClearBL:SetPoint("BOTTOM", globalOptions, "BOTTOM", 0,15)
globalOptions.buttonClearBL:SetText(SERVERHOP_CLEARLEADERBL)

globalOptions.buttonClearBL:SetScript("OnClick", function(btn)
	hopAddon.tables.LeadersBL = {}
	GameTooltip:Hide()
	PlaySound(PlaySoundKitID and "igMainMenuOptionCheckBoxOn" or 856)		
end)
globalOptions.buttonClearBL:SetScript("OnEnter",function(self)
	GameTooltip:SetOwner(self, "ANCHOR_TOPLEFT",0,5);
	--GameTooltip:SetText(self.tooltip,nil,nil,nil,nil,1);
	for i=1,#hopAddon.tables.LeadersBL do
		GameTooltip:AddLine(hopAddon.tables.LeadersBL[i])
	end
	GameTooltip:Show()
end)
globalOptions.buttonClearBL:SetScript("OnLeave",function(self)
	GameTooltip:Hide()
end)

-- CREDITS TAB --

hopAddon.optionsFrame.aboutTab,optionTabs.aboutTabSelector = CreateOptionsTab(5,HOPADDON_CREDITS)
local aboutTab = hopAddon.optionsFrame.aboutTab

aboutTab.headerCont = aboutTab:CreateFontString("rolestring", "OVERLAY", "GameFontNormal")
aboutTab.headerCont:SetPoint("TOPLEFT",15,-15)
aboutTab.headerCont:SetJustifyH("LEFT")
aboutTab.headerCont:SetText(HOPADDON_AUTHORCONT)

aboutTab.stringCont = aboutTab:CreateFontString("rolestring", "OVERLAY", "GameFontNormal")
aboutTab.stringCont:SetPoint("TOPLEFT",15,-25)
aboutTab.stringCont:SetJustifyH("LEFT")
aboutTab.stringCont:SetTextColor(1,1,1,1)
aboutTab.stringCont:SetText(BNet_GetClientEmbeddedTexture("Battlenet", 14).."ChronoAS#2758 (EU)")

aboutTab.headerCont = aboutTab:CreateFontString("rolestring", "OVERLAY", "GameFontNormal")
aboutTab.headerCont:SetPoint("TOPLEFT",15,-40)
aboutTab.headerCont:SetJustifyH("LEFT")
aboutTab.headerCont:SetText(HOPADDON_MAINTAINERCONT)

aboutTab.stringCont = aboutTab:CreateFontString("rolestring", "OVERLAY", "GameFontNormal")
aboutTab.stringCont:SetPoint("TOPLEFT",15,-50)
aboutTab.stringCont:SetJustifyH("LEFT")
aboutTab.stringCont:SetTextColor(1,1,1,1)
aboutTab.stringCont:SetText(BNet_GetClientEmbeddedTexture("Battlenet", 14).."Estrogen#2801 (EU)")

aboutTab.string = aboutTab:CreateFontString("rolestring", "OVERLAY", "GameFontNormal")
aboutTab.string:SetPoint("TOPLEFT",15,-65)
aboutTab.string:SetText(HOPADDON_TESTERS)

aboutTab.helpedStringList = aboutTab:CreateFontString("rolestring", "OVERLAY", "GameFontNormal")
aboutTab.helpedStringList:SetPoint("TOPLEFT",30,-80)
aboutTab.helpedStringList:SetText("Тарики - Fordragon EU\nСтурворм - Fordragon EU\n\nТревиз - Borean Tundra EU\nKugelwerfer - Blackmoore EU\nChokobo - Aggramar US")
aboutTab.helpedStringList:SetJustifyH("LEFT")
aboutTab.helpedStringList:SetTextColor(1,1,1,1)

aboutTab.helpedTex1 = aboutTab:CreateTexture("horde","OVERLAY")
aboutTab.helpedTex1:SetPoint("TOPLEFT",5,-76)
aboutTab.helpedTex1:SetTexture("Interface\\BattlefieldFrame\\Battleground-Horde.png")
aboutTab.helpedTex2 = aboutTab:CreateTexture("alliance","OVERLAY")
aboutTab.helpedTex2:SetPoint("TOPLEFT",5,-112)
aboutTab.helpedTex2:SetTexture("Interface\\BattlefieldFrame\\Battleground-Alliance.png")

aboutTab.stringThanks = aboutTab:CreateFontString("rolestring", "OVERLAY", "GameFontNormal")
aboutTab.stringThanks:SetPoint("BOTTOMLEFT",10,10)
aboutTab.stringThanks:SetJustifyH("CENTER")
aboutTab.stringThanks:SetWidth(220)
aboutTab.stringThanks:SetText(HOPADDON_COMMUNITYTHANKS)

-- ATTACHING TO THE MAIN MODULE --

-- button on main frame
hopAddon.buttonOptions = CreateFrame("Button","optionsOnMain",hopAddon,"BrowserButtonTemplate")
hopAddon.buttonOptions:SetSize(25,25)
hopAddon.buttonOptions:SetPoint("TOPLEFT",6,4)
hopAddon.buttonOptions.Icon = hopAddon.buttonOptions:CreateTexture("butOptionsTex","OVERLAY")
hopAddon.buttonOptions.Icon:SetSize(14,14)
hopAddon.buttonOptions.Icon:SetPoint("CENTER",0,0)
hopAddon.buttonOptions.Icon:SetTexture("Interface\\Buttons\\UI-OptionsButton")
hopAddon.buttonOptions.tooltip = OPTIONS
-- override on enter, onhide event is inside template
hopAddon.buttonOptions:SetScript("OnEnter", function(button)
	GameTooltip:SetOwner(button, "ANCHOR_LEFT", 0, -25)
	GameTooltip:SetText(OPTIONS, 1, 1, 1, true)
	GameTooltip:Show()
end)
-- toggle options frame on click
hopAddon.buttonOptions:SetScript("OnClick", function(button)
	if not hopAddon.optionsFrame:IsShown() then
		hopAddon.optionsFrame:Show()
	else
		hopAddon.optionsFrame:Hide()	
	end
	PlaySound(PlaySoundKitID and "igMainMenuOptionCheckBoxOn" or 856)	
end)