-- Populating hopAddon frame

-- close button in the topright corner
hopAddon.closeButton = CreateFrame("Button", nil, hopAddon,"BrowserButtonTemplate")
hopAddon.closeButton:SetSize(25,25)
hopAddon.closeButton:SetPoint("TOPRIGHT",-4,4)
hopAddon.closeButton.Icon = hopAddon.closeButton:CreateTexture(nil,"OVERLAY")
hopAddon.closeButton.Icon:SetSize(14,14)
hopAddon.closeButton.Icon:SetPoint("CENTER",0,0)
hopAddon.closeButton.Icon:SetTexture("Interface\\Buttons\\UI-StopButton")
hopAddon.closeButton:SetScript("OnClick", function(btn)
	hopAddon.favouritesFrame:Hide()
	hopAddon:Hide()
end)

local customOptions = hopAddon.optionsFrame.customSearchOptionsFrame

local function ServerHop_EventSystem(self, event, ...)
	local arg1 = ...
	if event == "ADDON_LOADED" and arg1 == "Filter" then	


		if FilterSettings ~= nil then

			if FilterSettings["POINT"] ~= nil and FilterSettings["X"] ~= nil and FilterSettings["Y"] ~= nil then
				hopAddon:ClearAllPoints()	
				hopAddon:SetPoint(FilterSettings["POINT"],FilterSettings["X"],FilterSettings["Y"])
			end

			if FilterSettings["ISSHOWN"] then
				hopAddon:Show()
			end

			if FilterSettings["TANK"] ~= nil then
				SHtankButton.CheckButton:SetChecked(FilterSettings["TANK"])
			end
			if FilterSettings["HEALER"] ~= nil then
				SHhealerButton.CheckButton:SetChecked(FilterSettings["HEALER"])
			end
			if FilterSettings["DAMAGER"] ~= nil then
				SHdamagerButton.CheckButton:SetChecked(FilterSettings["DAMAGER"])
			end						
			
			if FilterSettings["STATUS_FRAME"] ~= nil and FilterSettings["STATUS_FRAME"] == false then
				hopAddon.optionsFrame.globalOptionsFrame.statusCheckButton:SetChecked(false)
				UIDropDownMenu_DisableDropDown(hopAddon.optionsFrame.globalOptionsFrame.statusFrameDrop)
			end
			if FilterSettings["STATUS_FRAME_POSITION"] ~= nil then
				UIDropDownMenu_SetSelectedID(hopAddon.optionsFrame.globalOptionsFrame.statusFrameDrop, FilterSettings["STATUS_FRAME_POSITION"])
				UIDropDownMenu_SetText(hopAddon.optionsFrame.globalOptionsFrame.statusFrameDrop, SH_statusFrameDropTable[FilterSettings["STATUS_FRAME_POSITION"]])
				
				hopAddon.SH_MoveStatusFrame(FilterSettings["STATUS_FRAME_POSITION"])
			end

			if FilterSettings["MINIMAP_SETTINGS"] ~= nil then
				hopAddon.var.minimapDB.global.minimap = FilterSettings["MINIMAP_SETTINGS"]
				if FilterSettings["MINIMAP_SETTINGS"].hide == true then
					hopAddon.optionsFrame.globalOptionsFrame.MinimapCheckButton:SetChecked(false)
					UIDropDownMenu_DisableDropDown(hopAddon.optionsFrame.globalOptionsFrame.minimapStrataDrop)
					hopAddon.var.minimapDB.global.minimap = FilterSettings["MINIMAP_SETTINGS"]
					hopAddon.var.minimapDB.global.minimap.hide = false
					hopAddon_MiniMapInit()
					hopAddon.var.minimapDB.global.minimap.hide = true
				end
			end
			
			if FilterSettings["MINIMAP_STRATA"] ~= nil then
				UIDropDownMenu_SetSelectedID(hopAddon.optionsFrame.globalOptionsFrame.minimapStrataDrop, FilterSettings["MINIMAP_STRATA"])
				UIDropDownMenu_SetText(hopAddon.optionsFrame.globalOptionsFrame.minimapStrataDrop, SH_minimapStrataDropTable[FilterSettings["MINIMAP_STRATA"]])
				if hopAddon.minimap.objects["Filter"] then
					hopAddon.minimap.objects["Filter"]:SetFrameStrata(SH_minimapStrataDropTable[FilterSettings["MINIMAP_STRATA"]])
				end
			end					

		else
			FilterSettings = {}
		end
		
		if FilterSettingsGlobal ~= nil then
			if FilterSettingsGlobal["FAVOURITES"] ~= nil then
				hopAddon.tables.searchFavourites = FilterSettingsGlobal["FAVOURITES"]
			end
		else
			FilterSettingsGlobal = {}
		end
		
		hopAddon.searchFrame.dropDown.activeValue = 6
		hopAddon.searchFrame.dropDown.text:SetText(C_LFGList.GetCategoryInfo(hopAddon.searchFrame.dropDown.activeValue))

		if not hopAddon.minimapInit then hopAddon_MiniMapInit() end

	elseif event == "PLAYER_LOGIN" then
		C_LFGList.RequestAvailableActivities();
		hopAddon_GatherPvPRealms(GetCurrentRegion())
		hopAddon:GetZoneList()
		hopAddon.var.currentZone = hopAddon:GetMyZoneID()

		hopAddon_MiniMapAnim()

	elseif event == "PLAYER_LOGOUT" then
	
		local point, relativeTo, relativePoint, xOfs, yOfs = hopAddon:GetPoint()
		FilterSettings["POINT"] = point
		FilterSettings["X"] = xOfs
		FilterSettings["Y"] = yOfs
		FilterSettings["ISSHOWN"] = hopAddon:IsShown()

		FilterSettings["TANK"] = SHtankButton.CheckButton:GetChecked()
		FilterSettings["HEALER"] = SHdamagerButton.CheckButton:GetChecked()
		FilterSettings["DAMAGER"] = SHhealerButton.CheckButton:GetChecked()				

		FilterSettings["STATUS_FRAME"] = hopAddon.optionsFrame.globalOptionsFrame.statusCheckButton:GetChecked()
		FilterSettings["STATUS_FRAME_POSITION"] = UIDropDownMenu_GetSelectedID(hopAddon.optionsFrame.globalOptionsFrame.statusFrameDrop)
		
		local position = hopAddon.var.minimapDB.global.minimap.minimapPos
		local visibility = not hopAddon.optionsFrame.globalOptionsFrame.MinimapCheckButton:GetChecked()
		local arr = {minimapPos = position,hide = visibility, }
		FilterSettings["MINIMAP_SETTINGS"] = arr
		FilterSettings["MINIMAP_STRATA"] = UIDropDownMenu_GetSelectedID(hopAddon.optionsFrame.globalOptionsFrame.minimapStrataDrop)

		FilterSettingsGlobal["FAVOURITES"] = hopAddon.tables.searchFavourites
	end
	
end


--Events
hopAddon:SetScript("OnEvent", ServerHop_EventSystem)
hopAddon:RegisterEvent("ADDON_LOADED")
hopAddon:RegisterEvent("PLAYER_LOGIN")
hopAddon:RegisterEvent("PLAYER_LOGOUT")