local frame_size_default = {180, 16}
local updelapsed = 1
local cevmoffset = -2
local cevday = -1
local cevindex = -1
local cevcount = -1
local seek_events = 0
local frame_id = 0
HALLOWTIMER_CALENDAR_UPDATE_RANGE = 6
HALLOWTIMER_EVENT_MAX_LETTERS = 24
local calendar_updating = false
local debug_printing = false
local tt_tooltip = ""
local tt_text = "Preparing"
local can_show_config = false
local events = {


}
local evb = {}
local eve = {}
local depth1 = 0
local execqueue = nil

--[[
Returns a%b
]]
HallowTimer_Modulo = function(a, b)
	return a-(floor(a/b)*b)
end

--[[
Gets the number of days in a month
Takes:
  month, year
]]
HallowTimer_GetNumberOfDays = function(month, year)
	if month == 1 or month == 3 or month == 5 or month == 7 or month == 8 or month == 10 or month == 12 then
		return 31
	elseif month == 2 then
		if HallowTimer_Modulo(year, 4) == 0 then
			if HallowTimer_Modulo(year, 100) == 0 then
				if HallowTimer_Modulo(year, 400) == 0 then
					return 29
				else
					return 28
				end
			else
				return 29
			end
		else
			return 28
		end
	elseif month == 4 or month == 6 or month == 9 or month == 11 then
		return 30
	end
end

local months = {
	30, 31, 30, 31,
	31, 29, 31,
	[0] = { 2015, 9 }
}

local ela = 0
local hr, min = GetGameTime()
local sec = 0
local weekday, month, day, year = CalendarGetDate()
local main_p = 0
local short_p = 0
local vshort_p = 0
local configversion = "2.1.0"
local VERSION = "2.1.4a"
local versionnotices = 20100
local default = {420, 280}
local longtime = 7
local shorttime = 1
local vshorttime = 1/12
localstimer = function()
	return startday, shortday, shorthour, vshortday, vshorthour, vshortmin, eventday, eventhour, eventmin, day, hr, min, sec, main_p, short_p, vshort_p, "|||", weekday, month, day, year, hr, min,  sec
end


local offset = 5/12



for k, v in pairs(events) do
	if v[6] then
		eve[v[1]] = k
		v[5][1] = events[evb[v[1]]][5][4]
		v[5][2] = events[evb[v[1]]][5][3]
		v[5][3] = events[evb[v[1]]][5][2]
		v[5][4] = events[evb[v[1]]][5][1]
		v[5][4][4] = 1
	else
		evb[v[1]] = k
	end
	if v[7] == nil then v[7] = 0 end
end

--if (year == 2015 and
--month == 10 and
--day >= startday and day <= eventday) or (hr == -1 and min == -1) then

local h3 = CreateFont("HallowTimerH3")
h3:SetFont("Fonts\\FRIZQT__.TTF", 11)
local h2 = CreateFont("HallowTimerH2")
h2:SetFont("Fonts\\FRIZQT__.TTF", 12)
local timeframe = CreateFrame("SIMPLEHTML", nil, UIParent)
timeframe.dfmt = "<p>|H%{EVENT_ID}|h|cffffa000%{EVENT_NAME_BR}|r|h in:<br />|cffffff00|r%{DAYSD}%{HOURS}:%{MINS}</p>"
timeframe.fmt = timeframe.dfmt
timeframe.texture = timeframe:CreateTexture()
timeframe.texture:SetColorTexture(0, 0, 0, 0.5)
timeframe.texture:SetAllPoints(timeframe)
timeframe:SetFontObject(h3)
timeframe:SetFont("Fonts\\FRIZQT__.TTF", 11)
timeframe:SetText(timeframe.fmt)
timeframe:Hide()
timeframe.sticky = 0
timeframe:SetHyperlinksEnabled(true)
timeframe:SetScript("OnHyperlinkClick", function(self, link, text, btn)
	--print("TARGET", link)
	local target = link--:gsub("_+_", "'")
	--if btn == "LeftButton" then
		if target ~= "0" then
			glob_pos_hallowtimer.w = target
		else
			glob_pos_hallowtimer.w = nil
		end
	--end
	timeframe.sticky = 0
	timeframe:Hide()
end)
timeframe:SetHeight(200)
localshl =  function()
	print(timeframe:GetHyperlinksEnabled())
end

--[[
Gets month and year based on the offset from current month
]]
local HallowTimer_GetMonthFromOffset =  function(o)
	local m = month + o
	local y = year
	while m > 12 do
		y = y + 1
		m = m - 12
	end
	while m < 1 do
		y = y - 1
		m = m + 12
	end
	return m, y
end


local HallowTimer_Queue = function(fnc, ...) --------------------------------------------- QUEUE EXECUTION
	if execqueue ~= nil then--[[
		glob_hallowtimer.frames[frame_id][#glob_hallowtimer.frames[frame_id]+1] = "QUEUE FULL!!!!!!!!!!"]]
		error("EXECUTION QUEUE FULL, frame_id = ".. frame_id)
	end
	execqueue = {fnc, {...}}--[[
	glob_hallowtimer.frames[frame_id][#glob_hallowtimer.frames[frame_id]+1] = "queue"]]
end


local HallowTimer_DebugSeekNextEvent = function(s)
--[[
	if cevmday == 27 and cevmoffset == 0 then
		print(s, cevmoffset, cevmday, cevcount, cevindex)
	end
]]
end

local HallowTimer_SeekNextEvent = function() ------------------------------------------------------------- SEARCH THE CALENDAR FOR EVENTS
	--[[glob_hallowtimer.frames[frame_id][#glob_hallowtimer.frames[frame_id]+1] = "SeekNextEvent"]]
	if seek_events > 0 then
	seek_events = 2
	--print("SeekNextEvent") -- TODO: Remove
	local weekday, month, day, year = CalendarGetDate();
--[[	glob_hallowtimer.frames[frame_id][#glob_hallowtimer.frames[frame_id]+1] = {"CalendarGetDate", weekday, month, day, year, "CalendarSetAbsMonth"}]]
	CalendarSetAbsMonth(month, year);
	if cevcount ~= -1 then
		if cevcount == cevindex then
			cevcount = -1
			HallowTimer_DebugSeekNextEvent("==cevcount")
		else
			cevindex = cevindex + 1
			--print("Opening: ", cevmoffset, cevmday, cevindex, cevcount) -- TODO: Remove
			CalendarSetAbsMonth(HallowTimer_GetMonthFromOffset(cevmoffset))
			HallowTimer_DebugSeekNextEvent("<cevcount")
			CalendarOpenEvent(0, cevmday, cevindex)--[[
			glob_hallowtimer.frames[frame_id][#glob_hallowtimer.frames[frame_id]+1] = {0, cevmday, cevindex, "CalendarOpenEvent"}]]
			return
		end
	end
	while cevcount == -1 do
		if cevmoffset == -2 then
			cevmoffset = -1
			cevmday = -1
		end
		if cevmday > 31 then
			cevmoffset = cevmoffset + 1
			cevmday = -1
			if cevmoffset > HALLOWTIMER_CALENDAR_UPDATE_RANGE then
				cevcount = -1
				cevmoffset = -2
				seek_events = 0
				glob_hallowtimer.last_update = year .. month
				print("|cff00ffffFESTIVALTIMER|r Update finished")--[[
				glob_hallowtimer.frames[frame_id][#glob_hallowtimer.frames[frame_id]+1] = {"BeginUpdateBar", "Queue"}]]
				HallowTimer_Queue(HallowTimer_BeginUpdateBar)
				return
			end
		end
		if cevmday == -1 then
			if cevmoffset == -1 then
				cevmday = day - 1
			else
				cevmday = 0
			end
			cevcount = -1
		end
		cevmday = cevmday + 1
		CalendarSetAbsMonth(HallowTimer_GetMonthFromOffset(cevmoffset))
		local tempcnt = CalendarGetNumDayEvents(0, cevmday)--[[
		glob_hallowtimer.frames[frame_id][#glob_hallowtimer.frames[frame_id]+1] = {0, cevmday, "CalendarGetNumDayEvents", tempcnt }]]
		--print("CalendarGetNumDayEvents", tempcnt, cevmoffset, cevmday)
		HallowTimer_DebugSeekNextEvent("Before test " .. tempcnt)
		if tempcnt >= 1 then
			cevcount = tempcnt
			cevindex = 1
			HallowTimer_DebugSeekNextEvent(">1")
			--print("Opening: ", cevmoffset, cevmday, cevindex, cevcount) -- TODO: Remove
			CalendarSetAbsMonth(HallowTimer_GetMonthFromOffset(cevmoffset))
			CalendarOpenEvent(0, cevmday, cevindex)--[[
			glob_hallowtimer.frames[frame_id][#glob_hallowtimer.frames[frame_id]+1] = {0, cevmday, cevindex, "CalendarOpenEvent" }]]
			return
		end
	end
	end
end

--[[
Gets a list of upcoming events within the next x days with same numeration as on the global list
]]
HallowTimer_GetUpcomingEvents = function(x)
	--print("upcoming") -- TODO: REMOVE
	local upc = {}
	local current = { year = year, month = month, day = day, hour = hr, minute = min }
	for k, v in pairs(glob_hallowtimer.events) do
		local diff =  HallowTimer_GetEventTimeDiff(current, v)
		if diff < x and diff > 0 then
			upc[k] = v
		end
	end
	return upc
end

--[[
Gets the list of events currently registered into HallowTimer. The list can be updated.
]]
HallowTimer_GetAllEvents = function()
	return glob_hallowtimer.events
end

--[[
Gets the beginning event of the specific ending event
Returns:
  event
  number on list
 or
  nil if unable to find the beginning (ie. single-day event)
]]
HallowTimer_GetBeginOf = function(ev)
	local n = -1
	if ev.sequence ~= "END" then
		return nil
	end
	for k, v in pairs(glob_hallowtimer.events) do
		if HallowTimer_CompareEvents(ev, v) then
			--print("Compared")
			n = k
			--print(n)
			for i = n-1, 1, -1 do
			--[[
				if ev.title == "Lunar Festival" then
					print(i, n)
				end]]
				if ev.title == glob_hallowtimer.events[i].title and ev.type == glob_hallowtimer.events[i].type and ev.caltype == glob_hallowtimer.events[i].caltype then
					--print("match")
					--[[
					if ev.title == "Lunar Festival" then
						print("match")
					end]]
					return glob_hallowtimer.events[i], i
				end
			end
			return nil
		end
	end
	return nil
end

--local clui

--[[
Starts the update of HallowTimer calendar
]]
HallowTimer_UpdateCalendar = function()
	local clui = Calendar_LoadUI
	Calendar_LoadUI =  function(...)
		if seek_events ~= 0 then
			print("|cff00ffffFESTIVALTIMER|r Calendar opened, UI broken! Please reload UI")
			seek_events = 0
			glob_hallowtimer.last_update = nil
			glob_hallowtimer.events = {}
			
			StaticPopupDialogs["HALLOWTIMER_BROKEN_UI"] = {
				text = "The calendar has been opened while FestivalTimer has been updating event database and the UI needs to be reloaded.",
				button1 = "Reload",
				button2 = "Later",
				OnAccept = function()
					ReloadUI()
				end,
				timeout = 0,
				whileDead = true,
				hideOnEscape = true,
				preferredIndex = 3
			}
			StaticPopup_Show("HALLOWTIMER_BROKEN_UI")
		end
		clui(...)
	end
	print("|cff00ffffFESTIVALTIMER|r Updating event database, please wait...")
	updelapsed = 0
	seek_events = 1
	local weekday, month, day, year = CalendarGetDate();
	CalendarSetAbsMonth(month, year);
	OpenCalendar()
end

--[[
Compares two events in HallowTimer format
Takes:
  ev1, ev2 = events to compare
Returns:
  true or false
]]
HallowTimer_CompareEvents = function(ev1, ev2)
	return (ev1.title == ev2.title) and (ev1.year == ev2.year) and (ev1.month == ev2.month) and (ev1.day == ev2.day) and (ev1.hour == ev2.hour) and (ev1.minute == ev2.minute) and (ev1.sequence == ev2.sequence) and (ev1.type == ev2.type) and (ev1.caltype == ev2.caltype)
end

--[[
Returns the difference in time (in days) between two events. The value may be non-integer and negative (if the first argument occurs later than the second)
]]
HallowTimer_GetEventTimeDiff = function(ev1, ev2, stop)
	local nonstop = (stop == nil)
	if stop == nil then stop = 600 end
	if debug_printing then
		print("GetEventTimeDiff")
	end
	--print("diff") -- TODO: REMOVE
	if ev1 == nil or ev2 == nil then
		return -10000
	end
	local cm, cy, diff = ev1.month, ev1.year, 0
	--print(cm, cy, diff)
	while cm < ev2.month or cy < ev2.year do
		diff = diff + HallowTimer_GetNumberOfDays(cm, cy)
		if diff > stop + 1 then
			--return stop
		end
		cm = cm + 1
		if cm == 13 then
			cm = 1
			cy = cy + 1
		end
	end
	while cm > ev2.month or cy > ev2.year do
		if diff < -stop - 1 then
			--return -stop
		end
		cm = cm - 1
		if cm == 0 then
			cm = 12
			cy = cy - 1
		end
		diff = diff - HallowTimer_GetNumberOfDays(cm, cy)
	end
	diff = diff + ev2.day - ev1.day
	diff = diff + (ev2.hour - ev1.hour) / 24
	diff = diff + (ev2.minute - ev1.minute) / 24 / 60
	if debug_printing then
		print(diff)
	end
	return diff
end

local GetMaxLineLen = function(s)
	local lines = {}
	s:gsub("([^\n]+)", function(t)
		lines[#lines+1] = t
	end)
	local max = 0
	for k, v in pairs(lines) do
		if v:len() > max then
			max = v:len()
		end
	end
	return max
end

local frame = CreateFrame("FRAME", "HallowTimerFrame", UIParent)
frame:RegisterEvent("ADDON_LOADED")
frame:RegisterEvent("PLAYER_LOGIN")
frame:RegisterEvent("CALENDAR_UPDATE_EVENT_LIST")
frame:RegisterEvent("CALENDAR_UPDATE_EVENT")
frame:RegisterEvent("CALENDAR_OPEN_EVENT")
frame:SetScript("OnEvent", function(self, event, ...)
	depth1 = depth1 + 1
	if event == "ADDON_LOADED" and ... == "HallowTimer" then
	frame:SetMovable(true)
	frame:EnableMouse(true)
	if glob_pos_hallowtimer == nil then
		glob_pos_hallowtimer = {x = default[1], y = default[2], c = "reset", d = default, s = frame_size_default}
	end
	if glob_pos_hallowtimer.c == "restore" then
		glob_pos_hallowtimer.x = glob_pos_hallowtimer.r[1]
		glob_pos_hallowtimer.y = glob_pos_hallowtimer.r[2]
		glob_pos_hallowtimer.s = glob_pos_hallowtimer.r.s
		glob_pos_hallowtimer.r = nil
		glob_pos_hallowtimer.c = configversion
		glob_hallowtimer = glob_pos_hallowtimer.r.ht
		print("Previous configuration has been restored. You can reset to the default configuration using the '/fest reset' command")
	end
	if glob_pos_hallowtimer.c ~= "1.0.1" and glob_pos_hallowtimer.c:sub(1, 2) ~= "2." then
		local restore = {glob_pos_hallowtimer.x, glob_pos_hallowtimer.y, s = {glob_pos_hallowtimer.s[1], glob_pos_hallowtimer.s[2]}, ht = glob_hallowtimer}
		local cause = glob_pos_hallowtimer.c == "reset" and "FestivalTimer configuration reset " or "Old configuration version "
		glob_pos_hallowtimer = {x = default[1], y = default[2], c = configversion, r = restore, d = default}
		glob_hallowtimer = { events = {}, colorprog = { 1, 1, 1, 1 }, colorempty = { 0, 0, 0, 1 }, match_enabled = true, match = { "Hallow's End", "Anniversary", "Pilgrim's Bounty", "Winter Veil", "Lunar Festival", "Love is in the Air", "Noblegarden", "Children's Week", "Midsummer Fire Festival", "Harvest Festival", "Brewfest" } }
		print(cause .. " has been detected and will be overwritten. You can restore the last configuration using the '/fest restore' command")
	end
	if glob_pos_hallowtimer.c ~= configversion then
		glob_hallowtimer.last_update = nil
		glob_hallowtimer.events = {}
	end
	if glob_pos_hallowtimer.c == "1.0.1" then
		glob_hallowtimer = { events = {}, colorprog = { 1, 1, 1, 1 }, colorempty = { 0, 0, 0, 1 }, match_enabled = true, match = { "Hallow's End", "Anniversary", "Pilgrim's Bounty", "Winter Veil", "Lunar Festival", "Love is in the Air", "Noblegarden", "Children's Week", "Midsummer Fire Festival", "Harvest Festival", "Brewfest" } }
		glob_pos_hallowtimer.c = configversion
	end
	if glob_pos_hallowtimer.s == nil then
		glob_pos_hallowtimer.s = frame_size_default
	end
	if glob_pos_hallowtimer.ver ~= versionnotices then
		glob_pos_hallowtimer.ver = versionnotices
		StaticPopupDialogs["HALLOWTIMER_VERSION_NOTICE"] = {
			text = "Welcome to FestivalTimer |cffff8000" .. VERSION .. "|r!\nType /fest to open the configuration UI.\n\nUse the left mouse button to move the bar.\nRight-click the bar to make the popup sticky so you can choose which event to track by clicking its name.\nMiddle-click the bar to make the popup appear at the bottom or top.\n\nBy default, the bar will not appear unless there is a major world event upcoming in 7 days (ex. Hallow's End, Lunar Festival). You can change this behavoir by adding more events to the match list or setting their maximum time for countdown\n\nAlso, please do not open the calendar window while the event database updates.",
			button1 = "Ok",
			timeout = 0,
			whileDead = true,
			hideOnEscape = true,
			preferredIndex = 3
		}
		StaticPopup_Show("HALLOWTIMER_VERSION_NOTICE")
	end
	glob_pos_hallowtimer.c = configversion
	self:SetUserPlaced(false)
	self:ClearAllPoints()
	self:SetPoint("TOPLEFT", UIParent, "BOTTOMLEFT", glob_pos_hallowtimer.x, glob_pos_hallowtimer.y)
	self:SetSize(glob_pos_hallowtimer.s[1], glob_pos_hallowtimer.s[2])
	self:SetWidth(glob_pos_hallowtimer.s[1])
	self:SetHeight(glob_pos_hallowtimer.s[2])
	if glob_pos_hallowtimer.fb ~= 1 then
		timeframe:SetPoint("BOTTOMLEFT", "HallowTimerFrame", "TOPLEFT")
		timeframe:SetPoint("BOTTOMRIGHT", "HallowTimerFrame", "TOPRIGHT")
	else
		timeframe:SetPoint("TOPLEFT", "HallowTimerFrame", "BOTTOMLEFT")
		timeframe:SetPoint("TOPRIGHT", "HallowTimerFrame", "BOTTOMRIGHT")
	end
	
	if TitanPanelButton_OnLoad then
		HallowTimerConfigUI.ttonly = CreateFrame("CHECKBUTTON", "HallowTimerConfigUITitanPanelOnly", HallowTimerConfigUI, "ChatConfigCheckButtonTemplate")
		HallowTimerConfigUI.ttonly:SetPoint("TOPLEFT", HallowTimerEventList, "BOTTOMLEFT")
		HallowTimerConfigUI.ttonly:SetSize(20, 20)
		HallowTimerConfigUITitanPanelOnlyText:SetText("TitanPanel Only")
		HallowTimerConfigUI.ttonly.tooltip = "Will hide the progressbar as long as TitanPanel is enabled"
		HallowTimerConfigUI.ttonly:SetScript("OnClick", function(self)
			glob_hallowtimer.tp_only = self:GetChecked()
		end)
		HallowTimerConfigUI.ttonly:SetChecked(glob_hallowtimer.tp_only or false)
		
		HallowTimerEventList:SetPoint("BOTTOM", 0, 30)
				
		TitanPanelRightClickMenu_PrepareHallowTimerMenu = function(...)
			--print("Prepare")
			TitanPanelRightClickMenu_AddTitle("Festival Timer")
			TitanPanelRightClickMenu_AddCommand("Configure", "HallowTimer_Configuring", "HallowTimer_ToggleConfiguration")
			--TitanPanelRightClickMenu_AddSpacer();
			--TitanPanelRightClickMenu_AddCommand(TITAN_PANEL_MENU_HIDE, "HallowTimer", TITAN_PANEL_MENU_FUNC_HIDE);
		end
		--[[local uddmi = UIDropDownMenu_Initialize
		UIDropDownMenu_Initialize = function(self, ...)
			print(self:GetName(), ...)
			return uddmi(self, ...)
		end]]
		local TTParent = CreateFrame("FRAME", nil, UIParent)
		local tip = CreateFrame("BUTTON", "TitanPanelHallowTimerButton", TTParent, "TitanPanelTextTemplate")
		TitanHallowTimerToltipText = function()
				return tt_tooltip
			end
		TitanHallowTimerButtonText = function()
				return tt_text
			end
		tip.registry = {
			id = "HallowTimer",
			category = "General",
			version = VERSION,
			menuText = "Festival Timer",
			tooltipTitle = "Festival Timer",
			tooltipTextFunction = "TitanHallowTimerToltipText",
			buttonTextFunction = "TitanHallowTimerButtonText",
			--frequency = 6
		}
		tip:HookScript("OnLoad", function()
			print("OnLoad")
		end)
		--[[UIDropDownMenu_Initialize(TitanPanelHallowTimerButtonRightClickManu, function()
			local info = {
				text = "Configure",
				value = "HallowTimer_Configuring",
				func ]] HallowTimer_ToggleConfiguration= function()
					if can_show_config then
						if HallowTimer_Configuring then
							HallowTimerConfigUI:Hide()
						else
							HallowTimerConfigUI:Show()
						end
							
					else
						print("|cff00ffffFESTIVALTIMER|r Configuration window not ready")
					end
				end--[[
			}
			UIDropDownMenu_AddButton(info)
		end, "MENU")]]
		--tip:SetSize(100, 20)
		--tip.button = 
		--TitanRightClickMenu_OnLoad(TitanPanelHallowTimerButtonRightClickMenu)
	end
	
	--[[
	if glob_hallowtimer.frames == nil then
		glob_hallowtimer.frames = {}
	end
	]]
	end
	--[[
	if glob_hallowtimer.frames[frame_id] == nil then
		glob_hallowtimer.frames[frame_id] = {}
	end
	glob_hallowtimer.frames[frame_id][#glob_hallowtimer.frames[frame_id]+1] = {event, ..., seek_events = seek_events}
	]]
	if event == "PLAYER_LOGIN" then
		--self:Hide()
		weekday, month, day, year = CalendarGetDate()
		hr, min = GetGameTime()
		self:SetUserPlaced(false)
		self:ClearAllPoints()
		self:SetPoint("TOPLEFT", UIParent, "BOTTOMLEFT", glob_pos_hallowtimer.x, glob_pos_hallowtimer.y)
	end
	if event:match("CALENDAR") then
		--print("-", event, seek_events, depth1) -- TODO: Remove
	end
	if event == "CALENDAR_UPDATE_EVENT_LIST" then ------------------------------------------------------------ UPDATE THE CALENDAR
		if seek_events == 1 then
			seek_events = 2
			--print("List updated") -- TODO: Remove
			if glob_hallowtimer == nil then
				glob_hallowtimer = {events = {}}
			end
			for k, v in pairs(glob_hallowtimer.events) do
				v.confirmed = 0
			end
			HallowTimer_Queue(HallowTimer_SeekNextEvent)
		end
		depth1 = depth1 - 1
		return
	end
	if --[[event == "CALENDAR_UPDATE_EVENT" or]] event == "CALENDAR_OPEN_EVENT" --[[or event == "CALENDAR_UPDATE_EVENT_LIST"]] then ----------------------------------------------------------------- GET THE FOUND EVENT
		if seek_events == 2 then
			--print("Found event") -- TODO: Remove
			--if CalendarEventGetCalendarType() == "ONGOING" then
			--	depth1 = depth1 - 1
			--	return
			--end
			
			local current_event = {}
			local current_event_day = {CalendarGetDayEvent(0, cevmday, cevindex)}
			--for k, v in pairs(current_event) do
				--print(k, v)
			--end
			current_event.title = current_event_day[1]
			current_event.day = cevmday
			current_event.month, current_event.year = HallowTimer_GetMonthFromOffset(cevmoffset)
			current_event.hour = current_event_day[2]
			current_event.minute = current_event_day[3]
			current_event.caltype = current_event_day[4]
			current_event.sequence = current_event_day[5]
			current_event.type = current_event_day[6]
			current_event.countdown = 7
			--[[
			if cevmday == 27 and cevmoffset == 0 then
				for k, v in pairs(current_event) do
					print(k, v)
				end
			end
			]]
			local inlist = 0
			
			if current_event.sequence == "START" then
				current_event.name = current_event.title .. " begins"
			elseif current_event.sequence == "END" then
				current_event.name = current_event.title .. " ends"
			elseif current_event.caltype == "RAID_LOCKOUT" or current_event.caltype == "RAID_RESET" then
				current_event.name = current_event.title .. " resets"
			else
				current_event.name = current_event.title
			end
			
			current_event.uname = current_event.name
			
			local linez = 0
			while GetMaxLineLen(current_event.name) > HALLOWTIMER_EVENT_MAX_LETTERS do
				local broken = fasle
				for i = linez+HALLOWTIMER_EVENT_MAX_LETTERS, linez+1, -1 do
					if current_event.name:sub(i, i) == " " then
						current_event.name = current_event.name:sub(1, i-1) .. "\n" .. current_event.name:sub(i+1)
						linez = i
						broken = true
						break
					end
				end
				if not broken then
					for i = linez+HALLOWTIMER_EVENT_MAX_LETTERS, current_event.name:len() do
						if current_event.name:sub(i, i) == " " then
							current_event.name = current_event.name:sub(1, i-1) .. "\n" .. current_event.name:sub(i+1)
							linez = i
							broken = true
							break
						end
					end
				end
				if not broken then
					break
				end
			end
			
			if current_event.sequence ~= "ONGOING" then
				for k, v in pairs(glob_hallowtimer.events) do
					if HallowTimer_CompareEvents(v, current_event) then
						inlist = 1
						v.confirmed = 1
						break
					end
				end
				if inlist == 0 then
					glob_hallowtimer.events[#glob_hallowtimer.events+1] = current_event
					local begin, _ = HallowTimer_GetBeginOf(current_event)
					if begin ~= nil then
						--[[if current_event.title == "Lunar Festival" then
							print("Begin ~= nil")
							debug_printing = true
						end]]
						current_event.countdown = HallowTimer_GetEventTimeDiff(begin, current_event)
						--[[if current_event.title == "Lunar Festival" then
							print(current_event.countdown)
						end]]
						--debug_printing = false
					end
					--[[if current_event.title == "Lunar Festival" then
						print(current_event.countdown)
					end]]
				end
			--	print("INLIST", inlist) -- TODO: Remove
			end--[[
			glob_hallowtimer.frames[frame_id][#glob_hallowtimer.frames[frame_id]+1] = current_event
			]]
			HallowTimer_Queue(HallowTimer_SeekNextEvent)
		end
		depth1 = depth1 - 1
		return
	end
	if event:match("CALENDAR") then
		--print("+", event, seek_events, depth1) -- TODO: Remove
	end
	depth1 = depth1 - 1
end)

HallowTimer_PrintSeekEvents = function()
	print(seek_events)
end

HallowTimer_MatchesCountdownName = function(e)
	if glob_hallowtimer.match_enabled == false then return true end
	for k, v in pairs(glob_hallowtimer.match) do
		if e.title:match(v) then
			return true
		end
	end
	return false
end

local lowest = function(t)
	local r = 100000
	for k, v in pairs(t) do
		if type(k) == "number" and k < r then
			r = k
		end
	end
	return r
end

local highest = function(t)
	local r = 0
	for k, v in pairs(t) do
		if type(k) == "number" and k > r then
			r = k
		end
	end
	return r
end

--[[
Begins the bar updates
]]

local RemoveGaps = function(t)
	local i = 0
	local min = lowest(t)
	local max = highest(t)
	for k = min, max do
		local v = t[k]
		if type(k) == "number" and k ~= 0 and v ~= nil then
			i = i + 1
			t[k] = nil
			t[i] = v
		end
	end
end

local texts = {}

HallowTimer_GetMouseoverEvent = function(z)
	local x = z
	if x == nil then
		x = GetMouseFocus()
	end
	local t
	if x then
		local y = x:GetName()
		local n = tonumber(y:match("HallowTimerEventListScrollFrameButton(%d+)"))
		t = HallowTimer_GetUpcomingEvents(32)
		local i = 0
		for k, v in pairs(t) do
			i = i + 1
			if i == n then
				x = v
				break
			end
		end
	end
	return x
end
HallowTimer_DumpEventInfo = function(x)
	if x.hour ~= nil then
		-- event table given
		for k, v in pairs(x) do
			print("[" .. k .. "]: " .. v)
		end
	end
end

HallowTimer_BeginUpdateBar = function()
	frame:SemiShow()
	local i = 0
	events = HallowTimer_GetUpcomingEvents(32)
	RemoveGaps(events)
	local min = lowest(events)
	local max = highest(events)
	for j = min, max do
		local v = events[j]
		if v ~= nil then
		--print(k, v.name) -- TODO: Remove
			i = i + 1
			texts[i] = v.uname .. "\n" .. v.year .. "/" .. v.day .. "/" .. v.month .. " " .. v.hour .. ":" .. v.minute
		end
	end
	--HallowTimerConfigUI:Show()
	can_show_config = true
	updelapsed = 0
end

HallowTimer_GetCountdownEvents = function()
--	print("countdown") -- TODO: REMOVE
	local upc = {}
	local current = { year = year, month = month, day = day, hour = hr, minute = min }
	--print(current.year, current.month)
	for k, v in pairs(glob_hallowtimer.events) do
		local diff =  HallowTimer_GetEventTimeDiff(current, v)
		if v.countdown ~= nil and diff < v.countdown and diff > 0 and HallowTimer_MatchesCountdownName(v) then
			upc[k] = v
		end
	end
	return upc
end

HallowTimer_TableDump = function(t)
	local text = "{"
	for k, v in pairs(t) do
		text = text .. " [\"" .. k .. "\"] = "
		if type(v) == "table" then
			text = text .. HallowTimer_TableDump(v)
		else
			text = text .. v
		end
		text = text .. ", "
	end
	text = text .. "}"
end

frame.hidden = 1
frame.texture = frame:CreateTexture()
frame.texture:SetColorTexture(0, 0.2, 1, 0.5)
frame.texture:SetAllPoints(frame)
frame.short = CreateFrame("FRAME", nil, frame)
frame.short.texture = frame.short:CreateTexture()
frame.short.texture:SetColorTexture(0, 1, 0.2, 1)
frame.short.texture:SetAllPoints(frame.short)
frame.short.vshort = CreateFrame("FRAME", nil, frame.short)
frame.short.vshort.texture = frame.short.vshort:CreateTexture()
frame.short.vshort.texture:SetColorTexture(1, 0, 0, 1)
frame.short.vshort.texture:SetAllPoints(frame.short.vshort)
frame.short.vshort.tend = CreateFrame("FRAME", nil, frame.short.vshort)
frame.short.vshort.tend.texture = frame.short.vshort.tend:CreateTexture()
frame.short.vshort.tend.texture:SetColorTexture(0, 0, 0, 1)
frame.short.vshort.tend.texture:SetAllPoints(frame.short.vshort.tend)
frame:SetPoint("TOPLEFT", UIParent, "TOPLEFT", 100, -100)
frame.short:SetPoint("TOP", frame, "TOP")
frame.short:SetPoint("LEFT", frame, "LEFT")
frame.short:SetPoint("BOTTOM", frame, "BOTTOM")
frame.short.vshort:SetPoint("TOP", frame, "TOP")
frame.short.vshort:SetPoint("LEFT", frame, "LEFT")
frame.short.vshort:SetPoint("BOTTOM", frame, "BOTTOM")
frame.short.vshort.tend:SetPoint("TOP", frame, "TOP")
frame.short.vshort.tend:SetPoint("LEFT", frame, "LEFT")
frame.short.vshort.tend:SetPoint("BOTTOM", frame, "BOTTOM")
frame.short:SetWidth(15)
frame:Show()
frame:SetScript("OnMouseDown", function(self, button)
	if button == "LeftButton" then
		self:StartMoving()
	end
	if button == "RightButton" then
		timeframe.sticky = (timeframe.sticky == 1 and 0 or 1)
	end
	if button == "MiddleButton" then
		glob_pos_hallowtimer.fb = (glob_pos_hallowtimer.fb == 1 and 0 or 1)
		timeframe:ClearAllPoints()
		if glob_pos_hallowtimer.fb ~= 1 then
			timeframe:SetPoint("BOTTOMLEFT", "HallowTimerFrame", "TOPLEFT")
			timeframe:SetPoint("BOTTOMRIGHT", "HallowTimerFrame", "TOPRIGHT")
		else
			timeframe:SetPoint("TOPLEFT", "HallowTimerFrame", "BOTTOMLEFT")
			timeframe:SetPoint("TOPRIGHT", "HallowTimerFrame", "BOTTOMRIGHT")
		end
	end
end)
frame:SetScript("OnHide", function(self, btn)
	timeframe:Hide()
end)
frame.SemiHide = function(self)
	frame.hidden = 1
	frame:Show()
	frame:SetAlpha(0) -- TODO: Set to 0
end
frame.SemiShow = function(self)
	frame.hidden = 0
	frame:Show()
	frame:SetAlpha(1)
end
frame:SetScript("OnMouseUp", function(self, btn)
	--print("UP")
	self:StopMovingOrSizing()
	glob_pos_hallowtimer.x = self.GetLeft(self)
	glob_pos_hallowtimer.y = self.GetTop(self)
	self:SetUserPlaced(false)
end)
frame:SetScript("OnEnter", function(self, mot)
	if self.hidden == 0 then
		timeframe:Show()
	end
end)
frame:SetScript("OnLeave", function(self, mot)
	if timeframe.sticky == 0 then timeframe:Hide() end
end)
function GetTimePercentage(sd, sh, sm, ss, ed, eh, em, es, cd, ch, cm, cs)
	local starttime = ((ss / 60 + sm) / 60 + sh) / 24 + sd
	local curtime   = ((cs / 60 + cm) / 60 + ch) / 24 + cd
	local endtime   = ((es / 60 + em) / 60 + eh) / 24 + ed
	local p = (curtime - starttime) / (endtime - starttime)
	if p < 0 then p = 0 end
	if p > 1 then p = 1 end
	return p
end
		
local function clamp(v)
	if v < 0  then
		return 0
	end
	if v > 1 then
		return 1
	end
	return v
end

local function is_before(cm, ct, em, et)
	return ((ct <= et + 1/3600/24 and cm == em) or (cm < em))
end
local function is_after(cm, ct, em, et)
	return ((ct >= et and cm == em) or (cm > em))
end
local function add_days(m, t, days)
	local cm = m
	local cd = t + days
	while days >= months[cm - months[0][1]*12 - months[0][2] + 1]+1 do
		cd = cd - months[cm - months[0][1]*12 - months[0][2] + 1]
		cm = cm + 1
	end
	return cm-m, cd-t
end

HallowTimer_GetPreviousMonth = function(m, y)
	if m == 1 then
		return 12, y-1
	else
		return m-1, y
	end
end
HallowTimer_GetNextMonth = function(m, y)
	if m == 12 then
		return 1, y+1
	else
		return m+1, y
	end
end

local tt_init = false


local htela = 60
		

frame:SetScript("OnUpdate", function(self, elapsed)
	htela = htela + elapsed
	self:SemiShow()
	frame_id = frame_id + 1
	if execqueue ~= nil then
		local exq = execqueue
		execqueue = nil
		exq[1](unpack(exq[2]))
		return
	end
	if updelapsed == 2 then
		if not tt_init then

			tt_init = true
		end
		if year .. month ~= glob_hallowtimer.last_update then
			HallowTimer_UpdateCalendar()
		else
			HallowTimer_BeginUpdateBar()
		end
	end
	if updelapsed == 1 then
		updelapsed = 2
	end

		ela = ela + elapsed

		local awaiting = {}
		local nextevent =nil
		local cmd = 0
		local pmd = 0
		local nmd = 0
		cmd = HallowTimer_GetNumberOfDays(month, year)
		local pm, nm = 0, 0
		pmd = HallowTimer_GetNumberOfDays(HallowTimer_GetPreviousMonth(month, year))
		nmd = HallowTimer_GetNumberOfDays(HallowTimer_GetNextMonth(month, year))
		local cm = year * 12 + month
		local ct = day + hr / 24 + min / 24 / 60 + sec / 24 / 3600
		local em = 0
		local et = 0
		local shm = 0
		local sht = 0
		local vsm = 0
		local vst = 0
		local sm, st
		local nextevent_a
		for k, v in pairs(HallowTimer_GetCountdownEvents()) do

			if tonumber(glob_pos_hallowtimer.w) == k then
				nextevent = v
				break
			end
			
			if HallowTimer_GetEventTimeDiff(nextevent, v) < 0 then
				nextevent = v
			end
			
		end
		if nextevent == nil then self:SemiHide() end
		sec = sec + elapsed
		if sec >= 60 then
			min = min + 1
			sec = sec - 60
			if min >= 60 then
				hr = hr + 1
				min = min - 60
				if hr >= 24 then
					day = day + 1
					hr = hr - 24
					if day > cmd then
						month = month + 1
						day = day - cmd
						if month >= 13 then
							year = year + 1
							month = month - 12
						end
					end
				end
			end
		end
		local ctm, stm, etm, shtm, vstm
		if nextevent ~= nil then

			ctm = {
				day = day,
				month = month,
				year = year,
				hour = hr,
				minute = min
			}
			etm = nextevent
			main_p   = clamp(((nextevent.countdown-HallowTimer_GetEventTimeDiff(ctm, nextevent))/nextevent.countdown))   --GetTimePercentage(startday, 0, 0, 0, eventday, eventhour, eventmin, 0, day, hr, min, sec)
			short_p  = clamp((shorttime-HallowTimer_GetEventTimeDiff(ctm, nextevent))/shorttime) --GetTimePercentage(shortday, shorthour, 0,        0, eventday, eventhour, eventmin, 0, day, hr, min, sec)
			vshort_p = clamp((vshorttime-HallowTimer_GetEventTimeDiff(ctm, nextevent))/vshorttime) --GetTimePercentage(vshortday,vshorthour,vshortmin,0, eventday, eventhour, eventmin, 0, day, hr, min, sec)
			if short_p > main_p then short_p = main_p end
			if vshort_p > short_p then vshort_p = short_p end
			local colorempty = glob_hallowtimer.colorempty
			local colorprog = glob_hallowtimer.colorprog
			if nextevent.colorempty then
				colorempty = nextevent.colorempty
			end
			if nextevent.colorprog then
				colorprog = nextevent.colorprog
			end
			frame.texture:SetColorTexture(unpack(colorempty))
			frame.short.texture:SetColorTexture(unpack(colorprog))
			frame.short.vshort.texture:SetColorTexture(1, 1, 1, 0)
				frame.short.vshort.tend.texture:SetColorTexture(1, 1, 1, 0)

			tt_text = nextevent.uname .. " soon"
			
			frame.short:SetWidth(main_p * glob_pos_hallowtimer.s[1])
			frame.short.vshort:SetWidth(short_p * glob_pos_hallowtimer.s[1])
			frame.short.vshort.tend:SetWidth(vshort_p * glob_pos_hallowtimer.s[1])
			frame.short:Show()
			frame.short.vshort:Show()
			frame.short.vshort.tend:Show()
			if day ~= 0 then
			if main_p == 0 then
				frame.short:Hide()
			end
			if short_p == 0 then
				frame.short.vshort:Hide()
			end
			if vshort_p == 0 then
				frame.short.vshort.tend:Hide()
			end

			local text = "<html><body>"
			if timeframe.sticky == 0 then
			timeframe:SetHeight(timeframe:GetContentHeight())
			for k, v in pairs(HallowTimer_GetCountdownEvents()) do
				local sf = "%02d"
				local timetill = HallowTimer_GetEventTimeDiff(ctm, v)
				local t = { EVENT_NAME = v.name,
						 EVENT_NAME_BR = v.name:gsub("\n", "<br />"), 
						 DAYS = math.floor((timetill)), 
						 HOURS = string.format(sf, math.floor(((timetill) - math.floor((timetill))) * 24)),
						 MINS = string.format(sf, math.floor(((timetill)* 24 - math.floor((timetill)* 24)) * 60)),
						 SECS = string.format(sf, math.floor(((timetill)* 24 * 60 - math.floor((timetill)* 24 * 60)) * 60)),
						 EVSE = "error",
						 EVENT_ID = k,
						 EVENT_ENDING = v.sequence == "ENDING" and 1 or 0 }
				t.DAYSD = t.DAYS == 0 and "" or string.format("%sd, ", t.DAYS)
				local textn = timeframe.fmt:gsub("%%\{([A-Z_]*)\}", function(arg)
					return t[arg]
				end)
				timeframe:SetHyperlinksEnabled(true)
				text = text .. textn
			end
			if glob_pos_hallowtimer.w then
				text = text .. ("<p>|H0|h|cffff0000Reset|r|h</p>")
			end
				if timeframe:IsVisible() then
				timeframe:Hide()
				timeframe:Show()
				end
			text = text .. "</body></html>"
			tt_tooltip = text:gsub("<html><body><p>", ""):gsub("</p></body></html>", ""):gsub("<br />", "\n"):gsub("</p><p>", "\n"):gsub("<html><body></body></html>", "No upcoming events"):gsub("|H[0-9]+|h|cffffa000", ""):gsub("|r|h", "")
			timeframe:SetText(text)
			end

			end
			local tempmin
			_, tempmin = GetGameTime()
			if (tempmin) > (min) and (tempmin - min <= 2) then
				sec = 0
				min = tempmin
			end
		else
			tt_text = "No upcoming events"
			tt_tooltip = "No upcoming events"
		end
	if TitanPanelPluginHandle_OnUpdate and htela > 60 then
		htela = 0
		TitanPanelPluginHandle_OnUpdate("HallowTimer", TITAN_PANEL_UPDATE_ALL)
	end
		if ela > 1 then
			ela = 0
			--print ("NEVENT", nextevent, "CT", ctm, "ST", stm, "ET", etm, "MAIN", main_p, "SHORT", short_p, "VSH", vshort_p)
		end
	if TitanPanelButton_OnLoad and glob_hallowtimer.tp_only then
		self:SemiHide()
	end
end)

HallowTimer_Reset = function()
	glob_pos_hallowtimer.c = "reset"
	ReloadUI()
end

HallowTimer_Restore = function()
	glob_pos_hallowtimer.c = "restore"
	ReloadUI()
end

HallowTimer_ChangeBgColor = function(r, g, b, a)
	glob_hallowtimer.colorempty = {r, g, b, a}
end

HallowTimer_ChangeFgColor = function(r, g, b, a)
	glob_hallowtimer.colorprog = {r, g, b, a}
end
HallowTimer_Help = function()
	print("Usage: /fest reset - Restores the default configuration")
	print("Usage: /fest restore - Restores the configuration from before reset")
	print("Usage: /fest color fg |cffffff00red green blue|r - Sets the color of the bar's left side")
	print("Usage: /fest color bg |cffffff00red green blue|r - Sets the color of the bar's right side")
	print("Usage: Right-click the bar and then click the event name or reset button to make the bar indicate time until the selected or the nearest event")
end


SLASH_HALTIM1 = "/hallowtimer"
SLASH_HALTIM2 = "/fest"
SlashCmdList.HALTIM = function(arg, ...)
	if arg == "reset" then
		HallowTimer_Reset()
	elseif arg == "restore" then
			HallowTimer_Restore()
	elseif arg:match("^color") then
		local c, r, g, b = arg:match("^color (%w+) ([0-9%.]+) ([0-9%.]+) ([0-9%.]+)")
		if c == nil or r == nil or g == nil or b == nil then
			HallowTimer_Help()
			return
		end
		if c == "fg" then
			HallowTimer_ChangeFgColor(r, g, b, 1)
		elseif c == "bg" then
			HallowTimer_ChangeBgColor(r, g, b, 1)
		end
	elseif arg == nil or arg == "" or arg == "config" then
		if can_show_config then
			HallowTimerConfigUI:Show()
		else
			print("|cff00ffffFESTIVALTIMER|r Configuration window not ready")
		end
	else
		HallowTimer_Help()
	end
end

local UpdateChildren = function(self, ch)
	if ch == nil then
		ch = 20
	end
	self:SetHeight(ch*#self.texts)
	local offset = HybridScrollFrame_GetOffset(self.frame)
	for k, v in pairs(self.frame.buttons) do
		if self.texts[k+offset] then
			v:SetText(self.texts[k+offset])
			v:Show()
			if self.selected == k+offset then
				v.seltex:Show()
			else
				v.seltex:Hide()
			end
			v.id = k+offset
		else
			v:Hide()
		end
	end
	HybridScrollFrame_Update(self.frame, self:GetHeight(), self:GetHeight())
end

local SelectItem = function(self, it)
	self.selected = it
	self:UpdateChildren()
end

local listfont = CreateFont("HallowTimerEventListFont")
listfont:CopyFontObject(GameFontNormal)
listfont:SetFont("Fonts\\FRIZQT__.TTF", 8, "OUTLINE")


local reuse = {tc = {}}
local CreateTextChildren = function(self, it, ch)
	if ch == nil then
		ch = 20
	end
	self.frame.buttonHeight = ch
	HybridScrollFrame_CreateButtons(self.frame, "EventListButtonTemplate")
	local selfie = self
	for k, v in pairs(self.frame.buttons) do
		v:SetScript("OnClick", function(self, ...)
			selfie:SelectItem(self.id)
			if selfie.OnSelectItem then
				selfie:OnSelectItem(self.id)
			end
		end)
	end
	self.texts = it
	self:UpdateChildren(ch)
	
end


local Scroll = function(self, delta)
	local ns = self:GetVerticalScroll() + delta * -0.6
	
	if ns > self:GetVerticalScrollRange() then
		ns = self:GetVerticalScrollRange()
	elseif ns < 0 then
		ns = 0
	end
	self.bar:SetValue(ns)
end
	
local eventsframebackdrop = {
 bgFile = "Interface\\DialogFrame\\UI-DialogBox-Background-Dark",
 edgeFile = "Interface\\DialogFrame\\UI-DialogBox-Border",
 tileSize = 32,
 edgeSize = 32,
 insets = {
 	left = 11, right = 12, top = 12, bottom = 9
 }
}

local CreateScrollList = function(n, p)
	local eventsFrame = CreateFrame("FRAME", n, p)
	local eventsScrollFrame = CreateFrame("SCROLLFRAME", n .. "ScrollFrame", eventsFrame, "BasicHybridScrollFrameTemplate")
	eventsScrollFrame.scrollBar.doNotHide = true
	eventsScrollFrame:ClearAllPoints()
	eventsScrollFrame:SetPoint("TOPRIGHT", -30, -10)
	eventsScrollFrame:SetPoint("BOTTOMLEFT", 10, 10)
	eventsFrame:SetBackdrop(eventsframebackdrop)
	eventsScrollFrame.dynamic = function(o)
		local d = math.floor(o/20)
		return d, o-(d*20)
	end
	
	eventsScrollFrame:SetScript("OnVerticalScroll", function(self)
		self.scrollChild:UpdateChildren()
	end)
	--F
	eventsScrollFrame:HookScript("OnMouseWheel", function(self, ...)
		self.scrollChild:UpdateChildren()
	end)
	
	local eventsUIframe = eventsScrollFrame:GetScrollChild()--CreateFrame("FRAME", "HallowTimerEventListUIFrame", nil)
	eventsUIframe:SetWidth(eventsScrollFrame:GetWidth())
	eventsUIframe:SetHeight(600)
	eventsUIframe.frame = eventsScrollFrame
	eventsUIframe.UpdateChildren = UpdateChildren
	eventsUIframe.CreateTextChildren = CreateTextChildren
	eventsUIframe.SelectItem = SelectItem
	eventsFrame.child = eventsUIframe
	return eventsFrame
end

local configUI = CreateFrame("FRAME", "HallowTimerConfigUI", UIParent)
configUI:SetFrameStrata("DIALOG")
configUI:SetPoint("CENTER")
configUI:SetSize(500, 500)
configUI:SetBackdrop(eventsframebackdrop)

configUI.label1 = CreateFrame("SIMPLEHTML", nil, configUI)
configUI.label1:SetPoint("TOPLEFT", configUI, "TOPRIGHT", -260, -10)
configUI.label1:SetSize(120, 12)
configUI.label1:SetText("   Upcoming Events")
configUI.label1:SetFont("Fonts\\FRIZQT__.TTF", 11)

configUI.update = CreateFrame("BUTTON", "HallowTimerUpdateButton", configUI, "UIPanelButtonTemplate")
configUI.update:SetPoint("TOPLEFT", configUI.label1, "TOPRIGHT")
configUI.update:SetSize(100, 12)
configUI.update:SetText("Update Database")
configUI.update:SetNormalFontObject(listfont)
configUI.update:SetHighlightFontObject(listfont)
configUI.update:SetScript("OnClick", function(self)
	updelapsed = 1
	glob_hallowtimer.last_update = nil
	--glob_hallowtimer.events = {}
end)

local ShowColorFrame = function(r, g, b, a, target)
	ColorPickerFrame:Hide()
	local anil = (a == nil)
	local oldcolor = {r, g, b, a}
	local ct = target
	local func = function()
		local r, g, b = ColorPickerFrame:GetColorRGB()
		local a
		if anil then
			a = 1
		else
			a = OpacitySliderFrame:GetValue()
		end
		ct[1] = r ct[2] = g ct[3] = b ct[4] = a
	end
	ColorPickerFrame.func = func
	ColorPickerFrame.opacityFunc = func
	ColorPickerFrame.cancelFunc = function()
		ct[1] = oldcolor[1] ct[2] = oldcolor[2] ct[3] = oldcolor[3] ct[4] = (oldcolor[4] or 1)
	end
	ColorPickerFrame:SetColorRGB(r, g, b)
	ColorPickerFrame.hasOpacity = (a ~= nil)
	ColorPickerFrame.opacity = a
	ColorPickerFrame.previousValues = {r, g, b, a}
	ColorPickerFrame:Show()
end

configUI.label2 = CreateFrame("SIMPLEHTML", nil, configUI)
configUI.label2:SetPoint("TOPLEFT", configUI, "TOPLEFT", 12, -10)
configUI.label2:SetSize(200, 20)
configUI.label2:SetText("Foreground color  (click to change)")
configUI.label2:SetFont("Fonts\\FRIZQT__.TTF", 11)

configUI.fgcolor = CreateFrame("BUTTON", "HallowTimerFgColorButton", configUI)
configUI.fgcolor.texture = configUI.fgcolor:CreateTexture()
configUI.fgcolor.texture:SetAllPoints()
configUI.fgcolor:SetPoint("TOPLEFT", configUI.label2, "BOTTOMLEFT", 0, 3)
configUI.fgcolor:SetSize(20, 20)
configUI.fgcolor:SetScript("OnClick", function()
	ShowColorFrame(glob_hallowtimer.colorprog[1], glob_hallowtimer.colorprog[2], glob_hallowtimer.colorprog[3], nil, glob_hallowtimer.colorprog)
end)

configUI.fgcolor:SetScript("OnUpdate", function(self)
	self.texture:SetColorTexture(unpack(glob_hallowtimer.colorprog))
end)


configUI.label3 = CreateFrame("SIMPLEHTML", nil, configUI)
configUI.label3:SetPoint("TOPLEFT", configUI.fgcolor, "BOTTOMLEFT", 0, -12)
configUI.label3:SetSize(200, 20)
configUI.label3:SetText("Background color  (click to change)")
configUI.label3:SetFont("Fonts\\FRIZQT__.TTF", 11)

configUI.bgcolor = CreateFrame("BUTTON", "HallowTimerFgColorButton", configUI)
configUI.bgcolor.texture = configUI.bgcolor:CreateTexture()
configUI.bgcolor.texture:SetAllPoints()
configUI.bgcolor:SetPoint("TOPLEFT", configUI.label3, "BOTTOMLEFT", 0, 3)
configUI.bgcolor:SetSize(20, 20)
configUI.bgcolor:SetScript("OnClick", function()
	ShowColorFrame(glob_hallowtimer.colorempty[1], glob_hallowtimer.colorempty[2], glob_hallowtimer.colorempty[3], glob_hallowtimer.colorempty[4], glob_hallowtimer.colorempty)
end)

configUI.bgcolor:SetScript("OnUpdate", function(self)
	self.texture:SetColorTexture(unpack(glob_hallowtimer.colorempty))
end)


configUI.label4 = CreateFrame("SIMPLEHTML", nil, configUI)
configUI.label4:SetPoint("TOPLEFT", configUI.bgcolor, "BOTTOMLEFT", 0, -12)
configUI.label4:SetSize(200, 20)
configUI.label4:SetText("Match list  (events to track)")
configUI.label4:SetFont("Fonts\\FRIZQT__.TTF", 11)

configUI.matchlist = CreateScrollList("HallowTimerMatchList", configUI)
configUI.matchlist:SetPoint("TOPLEFT", configUI.label4, "BOTTOMLEFT", 0, -2)
configUI.matchlist:SetPoint("BOTTOMRIGHT", configUI, "BOTTOMLEFT", 200, 30)
configUI.matchlist.child.OnSelectItem = function(self, id)
	configUI.deletebtn:Enable()
end

configUI.deletebtn = CreateFrame("BUTTON", "HallowTimerMatchDeleteButton", configUI, "UIPanelButtonTemplate")
configUI.deletebtn:SetPoint("TOPLEFT", configUI.matchlist, "BOTTOMLEFT")
configUI.deletebtn:SetPoint("BOTTOMRIGHT", configUI, "BOTTOMLEFT", 100, 10)
configUI.deletebtn:SetText("Remove")
configUI.deletebtn:SetNormalFontObject(listfont)
configUI.deletebtn:SetHighlightFontObject(listfont)
configUI.deletebtn:SetDisabledFontObject(listfont)
configUI.deletebtn:SetScript("OnClick", function(self)
	glob_hallowtimer.match[configUI.matchlist.child.selected] = nil
	configUI.matchlist.child.selected = 0
	self:Disable()
	RemoveGaps(glob_hallowtimer.match)
	configUI.matchlist.child:UpdateChildren()
end)
configUI.deletebtn:Disable()

configUI.closebtn = CreateFrame("BUTTON", "HallowTimerConfigurationCloseButton", configUI, "UIPanelButtonTemplate")
configUI.closebtn:SetPoint("TOPLEFT", configUI.deletebtn, "TOPRIGHT")
configUI.closebtn:SetPoint("BOTTOMRIGHT", configUI, "BOTTOMLEFT", 200, 10)
configUI.closebtn:SetText("Close window")
configUI.closebtn:SetNormalFontObject(listfont)
configUI.closebtn:SetHighlightFontObject(listfont)
local eventConfigUI = CreateFrame("FRAME", "HallowTimerEventConfigUI", UIParent)
local eventsFrame = CreateScrollList("HallowTimerEventList", configUI)
configUI.closebtn:SetScript("OnClick", function(self)
	configUI:Hide()
	eventConfigUI:Hide()
	eventsFrame.child.selected = 0
	eventsFrame.child:UpdateChildren()
end)
configUI:SetScript("OnUpdate", function(self)
	--print("OnShow")
	HallowTimerMatchList.child:CreateTextChildren(glob_hallowtimer.match)
	HallowTimerEventListScrollFrameScrollChild:CreateTextChildren(texts)
	--HallowTimerMatchList:Hide()
	--HallowTimerEventList:Hide()
	--HallowTimerMatchList:Show()
	--HallowTimerEventList:Show()
end)

eventsFrame:SetPoint("RIGHT", -10, 0)
eventsFrame:SetPoint("TOP", configUI.label1, "BOTTOM")
eventsFrame:SetPoint("BOTTOM", 0, 10)
eventsFrame:SetWidth(280)

eventConfigUI:SetFrameStrata("DIALOG")
eventConfigUI:SetPoint("LEFT", configUI, "RIGHT")
eventConfigUI:SetPoint("TOP", configUI, "TOP")
eventConfigUI:SetPoint("BOTTOM", configUI, "BOTTOM")
eventConfigUI:SetWidth(200)
eventConfigUI:SetBackdrop(eventsframebackdrop)
eventConfigUI:Hide()
eventConfigUI.label1 = CreateFrame("SIMPLEHTML", nil, eventConfigUI)
eventConfigUI.label1:SetPoint("TOPLEFT", 12, -12)
eventConfigUI.label1:SetSize(100, 12)
eventConfigUI.label1:SetText("Countdown")
eventConfigUI.label1:SetFont("Fonts\\FRIZQT__.TTF", 11)
eventConfigUI.countdown = CreateFrame("SLIDER", "HallowTimerEventConfigUICountdownSlider", eventConfigUI, "OptionsSliderTemplate")
eventConfigUI.countdown:SetHeight(20)
eventConfigUI.countdown:SetPoint("RIGHT", -16, 0)
eventConfigUI.countdown.tooltipText = "Maximum number of days to countdown. If it is less then this amount before the event, it will not be shown."
eventConfigUI.countdown:SetPoint("TOPLEFT", eventConfigUI.label1, "BOTTOMLEFT", 16, 0)
eventConfigUI.countdown:SetValueStep(1)
eventConfigUI.countdown:SetMinMaxValues(1, 28)

eventConfigUI.add = CreateFrame("BUTTON", "HallowTimerConfigurationCloseButton", eventConfigUI, "UIPanelButtonTemplate")
eventConfigUI.add:SetPoint("TOPLEFT", eventConfigUI.countdown, "BOTTOMLEFT", 0, -20)
eventConfigUI.add:SetSize(100, 20)
eventConfigUI.add:SetText("Add to match")
eventConfigUI.add:SetNormalFontObject(listfont)
eventConfigUI.add:SetHighlightFontObject(listfont)
eventConfigUI.add:SetScript("OnClick", function(self)
	glob_hallowtimer.match[#glob_hallowtimer.match+1] = events[eventsFrame.child.selected].title
end)

eventConfigUI.label2 = CreateFrame("SIMPLEHTML", nil, eventConfigUI)
eventConfigUI.label2:SetPoint("TOPLEFT", eventConfigUI.add, "BOTTOMLEFT", 0, -2)
eventConfigUI.label2:SetSize(160, 12)
eventConfigUI.label2:SetText("Click to enable the tracking of this event")
eventConfigUI.label2:SetFont("Fonts\\FRIZQT__.TTF", 11)


HallowTimerEventConfigUICountdownSliderLow:SetText("1")
HallowTimerEventConfigUICountdownSliderHigh:SetText("28")
HallowTimerEventConfigUICountdownSlider:SetScript("OnValueChanged", function(self, val)
	local v = val
	v = math.floor(v)
	HallowTimerEventConfigUICountdownSliderText:SetText(v)
	events[eventsFrame.child.selected].countdown = v
end)
eventConfigUI:SetScript("OnShow", function(self)
	self.countdown:SetValue(events[eventsFrame.child.selected].countdown)
end)

configUI:SetScript("OnShow", function()
	HallowTimer_Configuring = true
end)

configUI:SetScript("OnHide", function()
	HallowTimer_Configuring = false
end)

eventsFrame.child.OnSelectItem = function(self, id)
	eventConfigUI:Hide()
	eventConfigUI:Show()
end


configUI:Hide()