----Broker Manager for Farmed
local menuRow1={}
local menuRow2={}

if not LibStub then return end

local LDB = LibStub("LibDataBroker-1.1")
local tip = LibStub('LibQTip-1.0')


Farmed_Broker = LibStub("AceAddon-3.0"):NewAddon("Broker_Farmed", "AceConsole-3.0", "AceTimer-3.0", "AceEvent-3.0")

local FarmedDB_NeedsBreak=true; --Hold the next line for adding to the menu

local function FarmDBTooltip_ClickLine(line, setName, button)
	if (setName=="Open") then farmed_show(); end
	if (setName=="Configure") then InterfaceOptionsFrame_OpenToCategory(farmed_config.optdlg) end
	
	if (setName=="Refresh") then 
			farmed_buildlist();
			 farmed_gen();
			 farmed_Message(farmed_lang_refresComplete);
	end
	
	if (setName=="Reset") then 
		farmed_resetTracking(); 
		farmed_gen();
	end

	Farmed_Broker.tooltip:Hide();
	
end


local function FarmedDBTooltip_Show(frame)
	FarmedDBTooltip_Init();
	Farmed_Broker.tooltip:SmartAnchorTo(frame)
	Farmed_Broker.tooltip:SetAutoHideDelay(1, frame)
	Farmed_Broker.tooltip:Show()
end

function FarmedDBTooltip_Init()
	if (Farmed_Broker==nil) then 
			return;
	end
	
	FarmedDB_NeedsBreak=true

	if tip:IsAcquired("Broker_farmed") then tip:Release(Farmed_Broker.tooltip) end
	Farmed_Broker.tooltip = tip:Acquire("Broker_farmed", 2, "LEFT", "RIGHT")
	
	--write Menu Items
		Farmed_Broker.tooltip:AddLine("|TInterface\\Icons\\INV_Misc_Bag_11.blp:16|t"..farmed_lang_bkr_open, "","10")
		Farmed_Broker.tooltip:SetLineScript(1, "OnMouseDown", FarmDBTooltip_ClickLine, "Open")

		Farmed_Broker.tooltip:AddLine("|TInterface\\Icons\\INV_Gizmo_02.blp:16|t"..farmed_lang_bkr_config, "")
		Farmed_Broker.tooltip:SetLineScript(2, "OnMouseDown", FarmDBTooltip_ClickLine, "Configure")
		
		Farmed_Broker.tooltip:AddLine("|TInterface\\Icons\\INV_gizmo_felironbomb.blp:16|t"..farmed_lang_bkr_refresh, "")
		Farmed_Broker.tooltip:SetLineScript(3, "OnMouseDown", FarmDBTooltip_ClickLine, "Refresh")
		
		FarmedDB_AddSeperator()
		Farmed_Broker.tooltip:AddLine("|TInterface\\Icons\\INV_Gizmo_supersappercharge.blp:16|t"..farmed_lang_bkr_resetsession, "")
		Farmed_Broker.tooltip:SetLineScript(5, "OnMouseDown", FarmDBTooltip_ClickLine, "Reset")
		FarmedDB_AddSeperator()
		--Farmed_Broker.tooltip:AddLine("|cff00ff00-------------------|r", "");
	
		maxr=#menuRow1;
		
		local shade_row=false
		 for n = 1,maxr do 
			if 	(menuRow1[n] =="<br>") then
				 FarmedDB_AddSeperator()
				 shade_row=false
			else
				local row, col= Farmed_Broker.tooltip:AddLine(menuRow1[n], menuRow2[n]);
				
				if shade_row then 
					 Farmed_Broker.tooltip:SetLineColor(row,0.047,0.188,.266,1)
				end
				
				shade_row= not shade_row;
			end
			
		 end
	
end
function FarmedDB_AddLineBreak()
	FarmedDBTooltip_AddLine("<br>","")	
end

function FarmedDB_AddSeperator()
	Farmed_Broker.tooltip:AddSeparator(1, .5, .5, .5, 1)
end


function FarmedDBTooltip_Clear()
	menuRow1={}
	menuRow2={}
end


function FarmedDBTooltip_AddLine(LineText,LineCount)
	
	-- add Line
	 table.insert(menuRow1,""..LineText)
	 table.insert(menuRow2,""..LineCount)

end

function UpdateDBlabel(txt)
	if Farmed_Broker~=nil then
		Farmed_Broker.lDBObject.text="Farmed - " .. txt;
	end
end

function Farmed_Broker:OnInitialize()
    -- Called when the addon is loaded
    self.lDBObject = {
		type = 'data source',
		text = 'Farmed',
		icon = 'Interface\\Icons\\INV_Misc_Gem_Diamond_06.blp',
		OnEnter = FarmedDBTooltip_Show,
	}
	
	LDB:NewDataObject("Farmed", self.lDBObject)
	
	FarmedDBTooltip_Init();
end
