farmed_show=true  --  Declare Saved Variables
farmed_tracking_init=false;
farmed_tracking_init_attempts=1;


farmed_options = 
{
    show=true,
    slotcount=true,
    ore=true,
    herb = true,
    element=true,
    meat=true,
    gems=true,
    cloth=true,
    leather=true,
    other=true,
    uncommon=true,
    rare=true,
	itemcount=false;
    enchanting=true,
    money=true,
    consumable=true,
	cooking=true, -- new for padaria
	annouce=true,
	annoucechat=true,
	quest=true,
	garrison=true,
	trappableAlerts=true,
  
};

--- Loot Maassges Processing strings
local LOOT_SELF_REGEX = gsub(LOOT_ITEM_SELF, "%%s", "(.+)")
local LOOT_REGEX = gsub(LOOT_ITEM, "%%s", "(.+)")
local TRADESKILL_REGEX = gsub(LOOT_ITEM_CREATED_SELF , "%%s", "(.+)")


--- Debug Mode?

farmed_showdebug=false;
-- farmed_showdebug=true;

--- Global Item Type Arrays

farmed_ore={};
farmed_meat={};
farmed_gem={};
farmed_cloth={};
farmed_leather={};
farmed_herb={};
farmed_element={};
farmed_other={};
farmed_enchanting={};
farmed_consumable={};
farmed_cooking={}; -- New for pandaria
farmed_quest={};

farmed_tracking={}; -- holds item counts from trcking resets
farmed_tracking_money=GetMoney();


--- Declare Other Variables

farmed_looted={nil,nil,nil,nil,nil,nil,nil,nil,nil,nil,nil,nil,nil,nil,nil,nil,nil,nil,nil,nil,nil,nil,nil,nil,nil}
farmed_looted_curr={0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
farmed_looted_count=0

--farmed_timber_count=GetItemCount(114781)
--- Debug Status
function farmed_ToggleDebug()

	farmed_showdebug = not  farmed_showdebug;

	if (farmed_showdebug) then
		 farmed_Status("Debug is ON");
	else
		farmed_Status("Debug is OFF");
	end

end

--- Debug Status
function farmed_Debugstatus()

	--farmed_showdebug=true;
	--farmed_buildlist()

	 ---debug array sizes
   farmed_Status("===Unique Items Listed===");
   farmed_Status("Metals/Ore : " .. #farmed_ore);
   farmed_Status("Meat : " .. #farmed_meat);
   farmed_Status("Gems : " .. #farmed_gem);
   farmed_Status("Cloth : " .. #farmed_cloth);
   farmed_Status("Leather : " .. #farmed_leather);
   farmed_Status("Elemental : " .. #farmed_element);
   farmed_Status("Other : " .. #farmed_other);
   farmed_Status("Enchanting : " .. #farmed_enchanting);
   farmed_Status("Consumable : " .. #farmed_consumable);
   farmed_Status("Quest : " .. #farmed_quest);
   farmed_Status("Cooking : " .. #farmed_cooking);
	farmed_Status("===Options===");
	farmed_Status(" show = "..farmed_bool2string(farmed_options.show));
	farmed_Status(" slotcount = "..farmed_bool2string(farmed_options.slotcount));
	farmed_Status(" ore = "..farmed_bool2string(farmed_options.ore));
	farmed_Status(" herb = "..farmed_bool2string(farmed_options.herb));
	farmed_Status(" element = "..farmed_bool2string(farmed_options.element));
	farmed_Status(" meat = "..farmed_bool2string(farmed_options.meat));
	farmed_Status(" gems = "..farmed_bool2string(farmed_options.gems));
	farmed_Status(" leather = "..farmed_bool2string(farmed_options.leather));
	farmed_Status(" cloth = "..farmed_bool2string(farmed_options.cloth));
	farmed_Status(" other = "..farmed_bool2string(farmed_options.other));
	farmed_Status(" uncommon = "..farmed_bool2string(farmed_options.uncommon));
	farmed_Status(" rare = "..farmed_bool2string(farmed_options.rare));
	farmed_Status(" itemcount = "..farmed_bool2string(farmed_options.itemcount));
	farmed_Status(" enchanting = "..farmed_bool2string(farmed_options.enchanting));
	farmed_Status(" consumable = "..farmed_bool2string(farmed_options.consumable));
	farmed_Status(" annouce = "..farmed_bool2string(farmed_options.annouce));
	farmed_Status(" annoucechat = "..farmed_bool2string(farmed_options.annoucechat));
	farmed_Status(" quest = "..farmed_bool2string(farmed_options.quest));
	farmed_Status(" cooking = "..farmed_bool2string(farmed_options.cooking));
	farmed_Status(" Garrison = "..farmed_bool2string(farmed_options.garrison));
	farmed_Status(" Auto refresh = "..farmed_bool2string(farmed_options.autoUpdate));
	farmed_Status("===Other===");
	farmed_Status(" Debug = "..farmed_bool2string(farmed_showdebug));
  farmed_Status(" Initialised = "..farmed_bool2string(farmed_tracking_init));
  farmed_Status(" Init Attempts = "..farmed_tracking_init_attempts);
	farmed_Status(" Data Version = "..farmed_options.version);
  farmed_Status(" Display Mode = "..farmed_options.displayMode);
	if (not (farmed_tmr_started == nil)) then
		farmed_Status(" Last Auto Refresh = "..farmed_tmr_started);
	else
		farmed_Status(" Last Auto Refresh = None");
	end

  farmed_Status("===Session Tracking===");
  farmed_Status("[item] [inbag]/[started with]/[farmed]");

  for index,value in pairs(farmed_tracking) do 
    cnt=GetItemCount(index);
    diff=farmed_getTrackingChange(index);
    farmed_Status(index.." ["..cnt.."]/["..value.."]/["..diff.."]");

  end


end

function farmed_bool2string(vBool)
	
	if (vBool) then
		return "<true>"
	else
		return "<false>"
	end

end




--- Init Code and Support Functions

function farmed_Message(msg)
    DEFAULT_CHAT_FRAME:AddMessage("|cFF2080D0[Farmed]|r "..msg);
end

function farmed_Debug(msg)
    if (farmed_showdebug) then  
        DEFAULT_CHAT_FRAME:AddMessage("|cFF2080D0[Farmed]|cFFFF0000{Debug}|r "..msg);
    end
end

function farmed_Status(msg)
    
        DEFAULT_CHAT_FRAME:AddMessage("|cFF2080D0[Farmed]|cFFFF0000{Status}|r "..msg);

end

function farmed_Upgrade()


	if (farmed_options.version==nil) then
		farmed_options.version=2;
		farmed_options.autoUpdate=true;
		farmed_Status("Updated options data to version 2,");
	end

  if (farmed_options.version==2) then
    farmed_options.version=3;
    farmed_options.displayMode=1;
    farmed_Status("Updated options data to version 3.");
  end

end

farmed_tmr_started=nil;


function farmed_startTimer()
	farmed_Debug("Timer Start Entered");
	if (not (farmed_tmr_started == nil)) then
		return; -- Already Running.
	end
	farmed_Debug("Not running.");
	 if (farmed_options.autoUpdate==false) then
	 	return; -- disabled, switch off
	 end
	 farmed_Debug("Auto Update ON.");
	C_Timer.After(30, function () farmed_executeTimer() end);

	farmed_tmr_started=date();

	farmed_Debug("Timer Started.");


end

function farmed_executeTimer()
  

	farmed_tmr_started=nil;

	 if (farmed_options.autoUpdate==false) then
	 	return; -- disabled, switch off
	 end

	farmed_startTimer();

	if (UnitAffectingCombat("PLAYER")) then
		farmed_Debug("Timer refresh aborted - in combet.");
	end

	farmed_buildlist();
	farmed_gen();
	farmed_Debug("Auto refresh executed.");

end

function farmed_OnLoad(self)
	
	farmed_Debug("On Load Called.");
    SLASH_FARMED1="/farmed";
    SlashCmdList["FARMED"] = farmed_SlashCommand;
    
   

    
  
   
    
    self:SetScript("OnEvent", farmed_event);
    
    self:RegisterEvent("ADDON_LOADED");
    self:RegisterEvent("BAG_UPDATE");
   -- this:RegisterEvent("ITEM_LOCK_CHANGED");
    self:RegisterEvent("VARIABLES_LOADED");
    self:RegisterEvent("LOOT_OPENED");
  	self:RegisterEvent("CHAT_MSG_TRADESKILLS");
  	self:RegisterEvent("CHAT_MSG_LOOT");
  	self:RegisterEvent("LOOT_CLOSED");
  	self:RegisterEvent("ITEM_PUSH");
  	self:RegisterEvent("CURRENCY_DISPLAY_UPDATE");
  	self:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED")

    self:RegisterEvent("PLAYER_MONEY")


    self:RegisterEvent("BAG_OPEN");


    
    
    farmed_Message(farmed_lang_loaded);
    farmed_startTimer();

   

    --farmed_gen();

end
-- Build inital list of items;
function farmed_buildlist()

    farmed_cleanupTracking();
   
     for n= 0,NUM_BAG_SLOTS do
        local slots = GetContainerNumSlots(n);
                    
        for f= 1,slots do
            local il=GetContainerItemLink(n,f);
            if (il~=nil) then
                farmed_addtolist(il);
            end
            
        end
   end
   
   ---debug array sizes
   farmed_Debug("Metals/Ore : " .. #farmed_ore);
   farmed_Debug("Meat : " .. #farmed_meat);
   farmed_Debug("Gems : " .. #farmed_gem);
   farmed_Debug("Cloth : " .. #farmed_cloth);
   farmed_Debug("Leather : " .. #farmed_leather);
   farmed_Debug("Elemental : " .. #farmed_element);
   farmed_Debug("Other : " .. #farmed_other);
   farmed_Debug("Enchanting : " .. #farmed_enchanting);
   farmed_Debug("Consumable : " .. #farmed_consumable);
   farmed_Debug("Quest : " .. #farmed_quest);
   farmed_Debug("Cooking : " .. #farmed_cooking);
 
   
 
   

end

-- Add item to list
function farmed_addtolist(il)
    
    local spos = string.find(il,"Hitem:",1);
	if (spos==nil) then
	 return
	end
	
    local epos = string.find(il,":",spos+7);
	if (epos==nil) then
	 return
	end
                         
    local nitem = tonumber(strsub(il,spos+6,epos-1));
    
    local itemName, itemLink, itemRarity, itemLevel, itemMinLevel, itemType, itemSubType, itemStackCount, itemEquipLoc, itemTexture = GetItemInfo(il);
    
    --if (itemType~=farmed_lang_gem and itemType~=farmed_lang_othercat and itemType~=farmed_lang_consumable) then
     if (itemType==nil or (string.find(farmed_lang_ItemFilter, itemType) ~= nil and string.find(farmed_lang_othercatIDs, "#"..nitem..";")==nil )) then --- not aopplicable
        return
	end

    
    farmed_Debug("Considering: " .. nitem .. " : " .. itemName ..", " .. itemType .. "-" .. itemSubType);
    
	
	
    if (itemSubType==farmed_lang_ore) then
        farmed_addtolist2(farmed_ore,nitem);
	elseif (itemSubType==farmed_lang_cooking) then -- adde for padaria
        farmed_addtolist2(farmed_cooking,nitem);
    elseif (itemSubType==farmed_lang_meat) then
        farmed_addtolist2(farmed_meat,nitem);
    elseif (itemSubType==farmed_lang_cloth) then
        farmed_addtolist2(farmed_cloth,nitem);
    elseif (itemSubType==farmed_lang_leather) then
        farmed_addtolist2(farmed_leather,nitem);
    elseif (itemSubType==farmed_lang_herb) then
        farmed_addtolist2(farmed_herb,nitem);
    elseif (itemSubType==farmed_lang_element) then
        farmed_addtolist2(farmed_element,nitem);
    elseif (itemSubType==farmed_lang_enchanting) then
        farmed_addtolist2(farmed_enchanting,nitem);
    elseif (itemType==farmed_lang_gem) then
        farmed_addtolist2(farmed_gem,nitem);
    elseif (itemSubType==farmed_lang_othercat) then
        farmed_addtolist2(farmed_other,nitem);
    elseif (itemSubType==farmed_lang_othercat1) then
        farmed_addtolist2(farmed_other,nitem);
    elseif (itemSubType==farmed_lang_othercat2) then
        farmed_addtolist2(farmed_other,nitem);
	elseif ( string.find(farmed_lang_othercatIDs, ""..nitem..";", 1)~=nil) then --- added 5.4 to supprt custom items in category
        farmed_addtolist2(farmed_other,nitem);
    elseif (itemType==farmed_lang_consumable) then
        farmed_addtolist2(farmed_consumable,nitem);
	 elseif (itemType==farmed_lang_quest) then
        farmed_addtolist2(farmed_quest,nitem);
		
		
		
    end
end

function farmed_addtolist2(iarray,ino)
    farmed_Debug("   Checking List: " .. ino);
    local isFound= false;
    
    for index,value in ipairs(iarray) do 
        if (value==ino) then 
            isFound=true;
        end
    end
    
    if (isFound==false) then
        farmed_Debug("Added: " .. ino);
        tinsert(iarray,1,ino);
    end

end
function farmed_isListable(ItemID)
	
	if (ItemID == nil) then return false end -- safety to resolve bug 69
	
	
	local itemName, itemLink, itemRarity, itemLevel, itemMinLevel, itemType, itemSubType, itemStackCount, itemEquipLoc, itemTexture = GetItemInfo(ItemID);
	
	if (itemType==nil or (string.find(farmed_lang_ItemFilter, itemType) ~= nil and string.find(farmed_lang_othercatIDs, "#"..ItemID..";")==nil )) then --- not aopplicable
        return false
	end

    
    farmed_Debug("Considering: " .. ItemID .. " : " .. itemName ..", " .. itemType .. "-" .. itemSubType);
    
    if (itemSubType==farmed_lang_ore) then
        return true
	elseif (itemSubType==farmed_lang_cooking) then
        return true
    elseif (itemSubType==farmed_lang_meat) then
        return true
    elseif (itemSubType==farmed_lang_cloth) then
        return true
    elseif (itemSubType==farmed_lang_leather) then
        return true
    elseif (itemSubType==farmed_lang_herb) then
        return true
    elseif (itemSubType==farmed_lang_element) then
        return true
    elseif (itemSubType==farmed_lang_enchanting) then
        return true
    elseif (itemType==farmed_lang_gem) then
        return true
    elseif (itemSubType==farmed_lang_othercat) then
        return true
    elseif (itemSubType==farmed_lang_othercat1) then
        return true
    elseif (itemSubType==farmed_lang_othercat2) then
        return true
	elseif ( string.find(farmed_lang_othercatIDs, "#"..ItemID..";")~=nil) then --- added 5.4 to supprt custom items in category
		return true
    elseif (itemType==farmed_lang_consumable) then
        return true
	elseif (itemType==farmed_lang_quest) then
        return true
    end
	
	return false;
end
-- Command Line Manager

function farmed_SlashCommand(msg)
   
    
    msg = string.lower(msg);
   local args = {};
   for word in string.gmatch(msg, "[^%s]+") do
   	table.insert(args, word);
   end
   
   ----PROCESS COMMAND LINE
   if type(args[1])~="string" then
		stropt=nil
	else
		stropt=string.lower(args[1]);
	end
   if ( stropt ) then
	  if ( stropt == farmed_lang_optshow) then
	     farmed_show();
	  elseif ( stropt == farmed_lang_opthide) then
	      farmed_hide();
       elseif ( stropt == farmed_lang_optconfig ) then
	      InterfaceOptionsFrame_OpenToCategory(farmed_config.optdlg);
	   elseif ( stropt == farmed_lang_cmdRefresh ) then
	      farmed_buildlist();
		  farmed_gen();
		  farmed_Message(farmed_lang_refresComplete);
		elseif ( stropt == farmed_lang_cmdStatus ) then
	      farmed_Debugstatus();
	  elseif ( stropt == farmed_lang_cmdDebug ) then
	      farmed_ToggleDebug();

    elseif ( stropt == farmed_lang_cmdReset ) then
        farmed_resetTracking();
        farmed_gen();


      else
         farmed_Message("|cffff0000"..farmed_lang_opterr);
		 
		 farmed_Message(farmed_lang_optmain);
        farmed_Message(farmed_lang_optcom1);
        farmed_Message(farmed_lang_optcom2);
        farmed_Message(farmed_lang_optcom3);
        farmed_Message(farmed_lang_optcom4);
        farmed_Message(farmed_lang_optcom5);
        farmed_Message(farmed_lang_optcom6);
        farmed_Message(farmed_lang_optcom7);
        
      end
    else
        farmed_Message(farmed_lang_optmain);
        farmed_Message(farmed_lang_optcom1);
        farmed_Message(farmed_lang_optcom2);
        farmed_Message(farmed_lang_optcom3);
        farmed_Message(farmed_lang_optcom4);
        farmed_Message(farmed_lang_optcom5);
        farmed_Message(farmed_lang_optcom6);
        farmed_Message(farmed_lang_optcom7);
    end
end

function farmed_toggle()
    if (farmed_options.show) then
        farmed_hide();
    else
        farmed_show();
    end
end

function farmed_show_set(val)
	if (val) then
		farmed_show();
	else
		farmed_hide();
	end
end



function farmed_show()
    farmed_options.show=true;
    Farmed:Show();
end

function farmed_hide()
    Farmed:Hide();
    farmed_options.show=false;
end

function farmed_write(htmltext, rows)
    Farmed_html:SetText(htmltext);
    --resize window to take into account html size
    Farmed_html:SetHeight((rows*12));
    Farmed:SetHeight((rows*12)+15);
end

--- Get current item counts for tracking
function farmed_resetTracking()
	farmed_tracking=nil;
	farmed_tracking={};
  farmed_tracking_money=GetMoney();
	farmed_updateTracking();
  
end
--- Get current item counts for tracking
function farmed_updateTracking()

	for n= 0,NUM_BAG_SLOTS do
		local slots = GetContainerNumSlots(n);
		for f= 1,slots do
			il=GetContainerItemLink(n,f);
			if (il==nil) then
				-- ignore free slots
			else
				if (farmed_tracking[il]==nil) then
				
					cnt=GetItemCount(il);
					farmed_tracking[il]=cnt;
					farmed_Debug("Tracking added: "..il.." : "..farmed_tracking[il]);
				end
			end
		end
	end
end

--- Clean up tracking (for items sold/used/destroyed)
function farmed_cleanupTracking()
	for index,value in pairs(farmed_tracking) do 
		farmed_Debug("Checking: "..index); 
		cnt=GetItemCount(index);

		if (cnt==nil or cnt<1) then
			farmed_Debug("Tracking: "..index.." : reset.");
			farmed_tracking[index] = 0; -- -- reset to no longer in bag
		elseif  (cnt<value) then
			farmed_Debug("Tracking: "..index.." : adjusted.");
			farmed_tracking[index] = value; -- -- reset to no longer in bag
		end

	end
end

--- Get the tracking value for an item
function farmed_getTrackingValue(il) -- link item
	if (farmed_tracking[il]==nil) then
		return 0;
	else
		return farmed_tracking[il]
	end
end

--- Get Change in Sesssion (tracked)
function farmed_getTrackingChange(il) -- link item
  sp=0 -- default 0
  if (farmed_tracking[il]==nil) then
    sp=0;
  else
    sp = farmed_tracking[il];
  end

  cnt=GetItemCount(il);
    

  return cnt-sp;
  
end

---Update the tracking value for an item
function farmed_setTrackingValue(il,value) -- link item, count
	farmed_tracking[il]=value;
end

--- Core Processing Loop
function farmed_gen()
    local rowcount=2;
	
	---Reset DB Menu
	FarmedDBTooltip_Clear();
	--------------
	
    local html="<html><body>";
    
    --- Get Money
  if (farmed_options.money) then
        html = html .. "<h2>|cFF91D0F2" .. farmed_lang_money .. " |r";
        
        nmoney=GetMoney();
        ncopper = mod(nmoney,100);
        ngold = floor(nmoney/10000);
        nsilver=floor((nmoney-(ngold*10000))/100);

        --nmoney=ngold; -- display gold only

        goldDiff = floor((nmoney-farmed_tracking_money)/10000);

        golddiffText = GetCoinTextureString(math.abs(goldDiff)*10000);
        if (goldDiff>0) then
          golddiffText="|cFF008000+"..golddiffText;
        elseif (goldDiff<0) then
          golddiffText="|cFFFF4040-"..golddiffText;
        else
           golddiffText="|cFFCCCCCC - ";
        end  



        
        html = html .. GetCoinTextureString(ngold*10000).." ["..golddiffText.."|r]<br/><br/></h2>" 
		
		--add line to data broker
			
			FarmedDBTooltip_AddLine("|cFF91D0F2" .. farmed_lang_money .. " |r",GetCoinTextureString(ngold*10000).."|r");
      FarmedDBTooltip_AddLine("",golddiffText);
		--------------------------
        rowcount=rowcount+2;
  end
    
    --- Get Bag Slot Count and items 

        local totslots=0;
        local freeslots=0;
        local itemblock="";
        local itemcount=0;
		local itemcount_rare=0;
		local itemcount_uncommon=0;
        local il=nil;
        
        ----Count Up Free space
        
				
				
		for n= 0,NUM_BAG_SLOTS do
			local freeSlot, bagType = GetContainerNumFreeSlots(n);
			local bagSize = GetContainerNumSlots(n);
			
			totslots=totslots+bagSize;
			freeslots=freeslots+freeSlot;
		end
		
		
		if (farmed_options.slotcount) then
			html = html .. "<h2>|cFF91D0F2" .. farmed_lang_bags .. " |cFFFFF000";
			html = html .. freeslots .."/" .. totslots .. " |r</h2>";
			rowcount=rowcount+1;
			
			--add line to data broker
			FarmedDBTooltip_AddLine("|cFF91D0F2" .. farmed_lang_bags,"|cFFFFF000"
					.. freeslots .."/" .. totslots .. " |r")
			FarmedDB_AddLineBreak()
			--------------------------
		
		end
		--Update DB Label
			UpdateDBlabel("|cFFFFF000".. freeslots .."/" .. totslots .. " |r");
		--------------------------
		
		
		--List BOE items
		 if (farmed_options.rare or farmed_options.uncommon) then
			
			html = html .. "<h3><br/>|cFF91D0F2" .. farmed_lang_items .. " " .. farmed_lang_gathered .. "|r</h3>";
			
			--add line to data broker
					FarmedDBTooltip_AddLine("|cFF91D0F2" .. farmed_lang_items .. " " .. farmed_lang_gathered .. "|r","")
						
			--------------------------
			---Check for items
					
        
	
			for n= 0,NUM_BAG_SLOTS do
				local slots = GetContainerNumSlots(n);
				totslots=totslots+slots;
				
				for f= 1,slots do
					il=GetContainerItemLink(n,f);
					if (il==nil) then
						freeslots=freeslots+1;
					else
						 FarmedScanningTooltip:ClearLines();
						FarmedScanningTooltip:SetBagItem(n,f);
						if ((FarmedScanningTooltipTextLeft2:GetText() ~= "Soulbound") and (FarmedScanningTooltipTextLeft2:GetText() 
											~= "Quest Item")) then
							local itemName, itemLink, itemRarity, itemLevel, itemMinLevel, itemType, itemSubType, itemStackCount, 
															itemEquipLoc, itemTexture = GetItemInfo(il);
							if (itemType~=nil) then 
								if (string.find(farmed_lang_ItemFilter, itemType) ~= nil) then
									if ((farmed_options.uncommon and itemRarity==2) or (farmed_options.rare and itemRarity>2)) then
										
										if itemRarity==2 then
											itemcount_uncommon=itemcount_uncommon+1;
										else
											itemcount_rare=itemcount_rare+1;
										end
										
										
										if not farmed_options.itemcount then
											local r,g,b, colcode = GetItemQualityColor(itemRarity);
											colcode="|c"..colcode
										   itemblock = itemblock .. "<P>|T"..itemTexture..":16|t<A href = 'B"..n..f.."'>" .. colcode .. itemName .. "|r</A></P>";
										   FarmedDBTooltip_AddLine("|T"..itemTexture..":16|t"..colcode .. itemName .. "|r","")
											 -- itemblock = itemblock .. "<p>"..itemLink.."</p>";
											itemcount=itemcount+1;
											if (strlen(itemName)>30) then
												itemcount=itemcount+1;
											end
										end
										
									end
								end
							end
						end
					end
				end
			
			end
			
			
			
			if farmed_options.itemcount then
			
				if farmed_options.uncommon then
					local r,g,b, colcode = GetItemQualityColor(2);
					colcode="|c"..colcode
					itemblock = itemblock .. "<P>"..colcode .. farmed_lang_ic_uncommon ..": |r"..itemcount_uncommon.."</P>";
					FarmedDBTooltip_AddLine(colcode .. farmed_lang_ic_uncommon ..": |r"..itemcount_uncommon .. "|r","")
					itemcount=itemcount+1
				end
				
				if farmed_options.rare then
					local r,g,b, colcode = GetItemQualityColor(3);
					colcode="|c"..colcode
					local r,g,b, colcode1 = GetItemQualityColor(4);
					colcode1="|c"..colcode1
					itemblock = itemblock .. "<P>"..colcode .. farmed_lang_ic_rare.."|r/"..colcode1..farmed_lang_ic_epic.."|r: |r"..itemcount_rare.."</P>";
					FarmedDBTooltip_AddLine(colcode .. farmed_lang_ic_rare.."|r/"..colcode1..farmed_lang_ic_epic.."|r: |r"..itemcount_rare .. "|r","")
					
					itemcount=itemcount+1
				end
				
			end
			
			
			if (itemcount>0) then
					
					html = html .. itemblock;
					rowcount=rowcount+itemcount+2;
			else
				FarmedDBTooltip_AddLine("|cffffffff"..farmed_lang_none.."|r","")
			end
            FarmedDB_AddLineBreak()
        end
       
		
        
    --end
	
	
	---- Garrison Checks
	if (farmed_options.garrison) then
		FarmedDBTooltip_AddLine("|cFF91D0F2" .. farmed_lang_garrison .. " " .. farmed_lang_gathered .. "|r","")
		html = html .. "<h3><br/>|cFF91D0F2" .. farmed_lang_garrison .. " " .. farmed_lang_gathered .. "|r</h3>";
		
		-- currency
		local name, amount, texturePath, earnedThisWeek, weeklyMax, totalMax, isDiscovered = GetCurrencyInfo(824)
		
		html = html .. "<P>|cffBF6000".. farmed_lang_gresource ..": |cFFCF8840".. amount .."/" .. totalMax .. " |r</P>";
		FarmedDBTooltip_AddLine("|cffBF6000".. farmed_lang_gresource ,"|cFFCF8840".. amount .."/" .. totalMax)
		rowcount=rowcount+2
		--mats
		for n=1, #farmed_def_types_garrisonmats do
			local val = GetItemCount(farmed_def_types_garrisonmats[n])
			
			--html = html .. "<P>|cffffffff   - ".. farmed_lang_week ..": |cFFFFF000".. earnedThisWeek .."/" .. weeklyMax .. " |r</P>";
			--FarmedDBTooltip_AddLine("|cffffffff   - ".. farmed_lang_week ,"|cFFFFF000".. earnedThisWeek .."/" .. weeklyMax)
			if (val>0) then
				html = html .. "<P>|cffff8000".. farmed_lang_garrisonmats[n] ..": |cFFFFC000".. val .. " |r</P>";
				FarmedDBTooltip_AddLine("|cffff8000".. farmed_lang_garrisonmats[n] ,"|cFFFFC000".. val)
				rowcount=rowcount+1
			end
		end
		
	end
			
    --- Process List
    
    local resh, resc;
	
	 if (farmed_options.cooking) then
		--FarmedDB_AddLineBreak()
        resh, resc = farmed_checkbag(farmed_cooking,farmed_lang_cooking);
        html = html ..resh;
        rowcount=rowcount+resc;
    end
    
    if (farmed_options.ore) then
		--FarmedDB_AddLineBreak()
        resh, resc = farmed_checkbag(farmed_ore,farmed_lang_ore);
        html = html ..resh;
        rowcount=rowcount+resc;
    end
    
    if (farmed_options.meat) then
		--FarmedDB_AddLineBreak()
        resh, resc = farmed_checkbag(farmed_meat,farmed_lang_meat);
        html = html ..resh;
        rowcount=rowcount+resc;
    end
    
    if (farmed_options.herb) then
		--FarmedDB_AddLineBreak()
        resh, resc = farmed_checkbag(farmed_herb,farmed_lang_herb);
        html = html ..resh;
        rowcount=rowcount+resc;
    end
    
    if (farmed_options.element) then
		--FarmedDB_AddLineBreak()
        resh, resc = farmed_checkbag(farmed_element,farmed_lang_element);
        html = html ..resh;
        rowcount=rowcount+resc;
    end
    
    if (farmed_options.gems) then
		--FarmedDB_AddLineBreak()
        resh, resc = farmed_checkbag(farmed_gem,farmed_lang_gem);
        html = html ..resh;
        rowcount=rowcount+resc;
    end
    
    if (farmed_options.cloth) then
		--FarmedDB_AddLineBreak()
        resh, resc = farmed_checkbag(farmed_cloth,farmed_lang_cloth);
        html = html ..resh;
        rowcount=rowcount+resc;
    end
    
    if (farmed_options.leather) then
		--FarmedDB_AddLineBreak()
        resh, resc = farmed_checkbag(farmed_leather,farmed_lang_leather);
        html = html ..resh;
        rowcount=rowcount+resc;
    end
    
    if (farmed_options.other) then
		--FarmedDB_AddLineBreak()
        resh, resc = farmed_checkbag(farmed_other,farmed_lang_other);
        html = html ..resh;
        rowcount=rowcount+resc;
    end
    
     if (farmed_options.enchanting) then
		--FarmedDB_AddLineBreak()
        resh, resc = farmed_checkbag(farmed_enchanting,farmed_lang_enchanting);
        html = html ..resh;
        rowcount=rowcount+resc;
    end
    
    if (farmed_options.consumable) then
		--FarmedDB_AddLineBreak()
        resh, resc = farmed_checkbag(farmed_consumable,farmed_lang_consumable);
        html = html ..resh;
        rowcount=rowcount+resc;
    end
	
	 if (farmed_options.quest) then
		--FarmedDB_AddLineBreak()
        resh, resc = farmed_checkbag(farmed_quest,farmed_lang_quest);
        html = html ..resh;
        rowcount=rowcount+resc;
    end
    --Finish HTML
    
    html =html .."</body></html>";
    
   -- farmed_Message(html);
    
    farmed_write(html, rowcount)
end

function farmed_safehtml(str)
	str=string.gsub(str,"<","[");
	str=string.gsub(str,">","]");
	str=string.gsub(str,"/","\\");
	str=string.gsub(str,"&","+");

	
	return str;

end
function farmed_checkbag(typearray,typename)
    
    local htmlblock=""
    
    local has_title=false;
    local icount=0;
    local rc=0;
    if (typearray~=nil) then
        for index,value in ipairs(typearray) do 
            
            local icount=GetItemCount(value);
            local sessDiff=farmed_getTrackingChange(value);

            if ((icount >0 and farmed_options.displayMode<3) or (farmed_options.displayMode==3) ) then -- Show bag count and >0 or show diff
            
                local itemName, itemLink, itemRarity, itemLevel, itemMinLevel, itemType, itemSubType, itemStackCount, itemEquipLoc, itemTexture = GetItemInfo(value);
                
                local sessDiff=farmed_getTrackingChange(itemLink);
                
                if (farmed_options.displayMode<3 or (sessDiff~=0  and farmed_options.displayMode==3) ) then -- Show bagcount or show diff >0

                    --- Create Count Text
                    local sessText=""..sessDiff;
                    if (sessDiff>0) then
                      sessText="|cFF008000+"..sessText;
                    elseif (sessDiff<0) then
                      sessText="|cFFFF4040"..sessText;
                    else
                      sessText="|cFFCCCCCC - ";
                    end

                    local displayCountText="";

                    if (farmed_options.displayMode==1) then -- Display Both counts
                       displayCountText =  icount .."|r ["..sessText.."|r]";
                    elseif (farmed_options.displayMode==2) then -- Display Bag Only
                        displayCountText =  icount;
                    else -- Display Session Only
                        displayCountText =  sessText;

                    end
                    -- End Count Text

                    if (has_title==false) then
                        FarmedDB_AddLineBreak();
                        htmlblock = htmlblock .. "<h3><br/>|cFF91D0F2" .. farmed_safehtml(typename) .. " " .. farmed_lang_gathered .. "|r</h3>";
                        rc=rc+2;
                        has_title=true;
    					
              					--add line to data broker
              					FarmedDBTooltip_AddLine("|cFF91D0F2" .. farmed_safehtml(typename) .. " " .. farmed_lang_gathered .. "|r","")
              					--------------------------
                    end
                    
                     local r,g,b
                    if (itemRarity==nil or itemRarity<0 or itemRarity>6) then
                        r=1;
                        g=0;
                        b=0;
                    else
                        r,g,b, colcode = GetItemQualityColor(itemRarity);
    					           colcode="|c"..colcode
                    end
                    
                    htmlblock = htmlblock .. "<p>|T"..itemTexture..":16|t<A href='I"..value.."'>" .. colcode .. farmed_safehtml(itemName) 
                                  .. "</A>: |cFFFFF000"..displayCountText.." |r</p>";
                    rc=rc+1;
                    --add line to data broker
    					       FarmedDBTooltip_AddLine("|T"..itemTexture..":16|t"
    									         ..colcode .. farmed_safehtml(itemName).."|r","|cFFFFF000" .. displayCountText .." |r");
    				--------------------------
    				
    				
                    --farmed_Message(htmlblock);
              end
            end
        end
    end
    return htmlblock, rc;
end




function farmed_showitem(citem)

		if (citem==nil) then
			return
		end
		
        GameTooltip_SetDefaultAnchor(GameTooltip, Farmed);
       --farmed_Message("link clicked:" .. citem);
        
       
        
        if (strsub(citem,1,1)=="B") then
            local nbag = tonumber(strsub(citem,2,2));
            local nslot= tonumber(strsub(citem,3));
            --farmed_Message("link clicked:B=" .. nbag..", S="..nslot);
            
            ---local il=GetContainerItemLink(nbag,nslot);
            
            GameTooltip:SetBagItem(nbag,nslot);
            GameTooltip:Show();
            --GameTooltip:SetBagItem(nbag, nslot);
        else
            nitem = tonumber(strsub(citem,2));
            local itemName, itemLink, itemRarity, itemLevel, itemMinLevel, itemType, itemSubType, itemStackCount, itemEquipLoc, itemTexture = GetItemInfo(nitem);
              for n= 0,NUM_BAG_SLOTS do
                local slots = GetContainerNumSlots(n);
                for f= 1,slots do
                    il=GetContainerItemLink(n,f);
                    if (il~=nil) then
                        spos = string.find(il,"Hitem:",1);
                        epos = string.find(il,":",spos+7);
                        
                        --farmed_Message(strsub(il,spos+6,epos-1) .. " -> " .. nitem);
                        
                        if (nitem == tonumber(strsub(il,spos+6,epos-1))) then
                            GameTooltip:SetBagItem(n,f);
                            GameTooltip:Show();
                        end
                        
                    end
                end
            end
                        
             --GameTooltip:SetHyperlink(itemLink);
        end
        
end

function farmed_checkTrapping()
	 if (GetItemCount(115010)+GetItemCount(115009)+GetItemCount(113991))<1 then -- no trap in bag.
		return
	end
	
	 if UnitAffectingCombat("player")  and  UnitExists("target")  and farmed_options.trappableAlerts==true then
		
		local guid, name = UnitGUID("target"), UnitName("target")
		local type, zero, server_id, instance_id, zone_uid, npc_id, spawn_uid = strsplit("-",guid);
		if (npc_id~=nil) then 
			if strfind(farmed_lang_trappable, npc_id..",")~=nil then
			
				if (UnitHealth("target")/UnitHealthMax("target"))<.501 and  UnitCanAttack("player", "target") then
					
					UIErrorsFrame:AddMessage(farmed_lang_trapinstr.." |cffffff00"..name, 1, 1, 1, 53, 5)
					 PlaySound(SOUNDKIT.RAID_WARNING)
				end
			
			end
		end
	 end
	 
end

function farmed_init_addon()

  if (farmed_tracking_init) then
    return
  end

  if (GetContainerNumSlots(0)==0) then -- bags not intialised;
    farmed_Status("Init attempt "..farmed_tracking_init_attempts.. " failed.");
    farmed_tracking_init_attempts=farmed_tracking_init_attempts+1;
    C_Timer.After(2, function () farmed_init_addon(); end);
    return;
  end

  farmed_tracking_init=true;

  farmed_Upgrade();
  farmed_lang_Init();
  farmed_CreateConfig();
  farmed_resetTracking(); -- Init Tracking data
  farmed_buildlist();
  farmed_gen();
  
  if (farmed_options.show==false) then
      farmed_hide();
  end

  if farmed_options.itemcount==nil then farmed_options.itemcount=false end;
         
          
         
    
  farmed_gen();

  farmed_Status("Farmed Intiilaized.");

end
--Event Management
function farmed_event(self, event, ...)



  local arg = ...;

	  farmed_Debug("Event : " ..event.."::"..SafeNil(arg));
	
    if (event=="ADDON_LOADED") then
     
     -- C_Timer.After(5, function () farmed_init_addon(); end);
      -- farmed_init_addon();
         
	elseif (event=="COMBAT_LOG_EVENT_UNFILTERED") then
		farmed_checkTrapping()
	 
            
    elseif (event=="CURRENCY_DISPLAY_UPDATE") then 
        farmed_gen();
        
    elseif (event=="VARIABLES_LOADED") then
    --		farmed_Upgrade();
		--	farmed_lang_Init();
		--	 farmed_CreateConfig();
    --   farmed_resetTracking(); -- Init Tracking data
		--	 farmed_buildlist();
		--	 farmed_gen();
			
    --        if (farmed_options.show==false) then
    --           farmed_hide();
    --        end
        
		--	     if farmed_options.itemcount==nil then farmed_options.itemcount=false end;
           
            
           
			
		--     farmed_gen();
      C_Timer.After(2, function () farmed_init_addon(); end);

    elseif (event=="PLAYER_MONEY") then 
        farmed_gen();
			
   -- elseif (event=="BAG_UPDATE") then
        
     --   farmed_gen();
        
   -- elseif (event=="ITEM_LOCK_CHANGED") then
        
        
       -- if (arg2==nil or arg1==nil) then -- An errro slot
        --    return;
       -- end
       -- if (arg1<1 or arg1>NUM_BAG_SLOTS) then --not in bags
		--		return;
		--end
        
        --Add  to list?
       -- il=GetContainerItemLink(arg1,arg2);
        --farmed_addtolist(il);
        
        --farmed_gen();
    
    
    elseif (event=="CHAT_MSG_LOOT" or event=="LOOT_ITEM_CREATED_SELF" ) then
		local lootmsg=arg1
		if (lootmsg==nil) then 
			return;
		end
		
		if (string.find(lootmsg, TRADESKILL_REGEX) or string.find(lootmsg, LOOT_SELF_REGEX)) then
			farmed_gen();
		end 
			
		return;

	
    elseif (event=="LOOT_OPENED") then
	--farmed_Message("Looting")
	farmed_looted_count=0
		for n=1,GetNumLootItems() do
			if ( GetLootSlotLink(n)==nil) then
				--nothing
			else
				il=GetLootSlotLink(n);
				farmed_addtolist(il);
				
				--Record for alter anouncements
				
				local _, _, itemId = string.find(il, "item:(%d+):")
				farmed_looted[farmed_looted_count]=itemId
				farmed_looted_curr[farmed_looted_count]=GetItemCount(itemId)
				farmed_looted_count=farmed_looted_count+1;
				
				
			end
		end
		
		--farmed_Message("Cached "..farmed_looted_count.." items.")

	elseif (event=="BAG_UPDATE") then
	 if farmed_tracking_init then 

	--- Check for timber count changes
    	for n=1,#farmed_def_types_garrisonmats do
    		if farmed_garrison_counts[n]~=GetItemCount(farmed_def_types_garrisonmats[n]) then
    			if (farmed_options.announcechat and farmed_options.garrison) then -- timber
    				local icount=GetItemCount(farmed_def_types_garrisonmats[n])
    				local idiff=icount-farmed_garrison_counts[n]
    				
    				local itemName, itemLink, itemRarity, itemLevel, itemMinLevel, itemType, itemSubType, itemStackCount, itemEquipLoc, itemTexture = GetItemInfo(farmed_def_types_garrisonmats[n]);
    				if (itemLink~=nil) then
    					local csign=""
    					
    					if idiff>0 then csign="+" end
    						
    					farmed_Message("|cffffff00"..icount.."|r x "..itemLink.." |cff00ff00["..csign..idiff.."]")
    				end
    				farmed_gen();
    				
    			end
    			
    			farmed_garrison_counts[n]=GetItemCount(farmed_def_types_garrisonmats[n])
    		end
    	end
	 
	
    	--- Check loot
    	
    	
    	--farmed_Message("Looted Items")
    		if farmed_looted_count>0 then
    		
    			for n=0, farmed_looted_count-1 do
    			
    				
    				local itemId = farmed_looted[n]
    				
    				
    				
    			
    				
    				if (not farmed_isListable(itemId)) then return end
    				
    				
    				local itemName, itemLink, itemRarity, itemLevel, itemMinLevel, itemType, itemSubType, itemStackCount, itemEquipLoc, itemTexture = GetItemInfo(itemId);
    				
    				--Get number of items
    				local icount=0 --- default of 0
    				icount=GetItemCount(itemId);
    				idiff=icount-farmed_looted_curr[n]
    				
    				
    				
    				if (idiff>0) then
    				
    					if farmed_options.announcechat then farmed_Message("|cffffff00"..icount.."|r x "..itemLink.." |cff00ff00[+"..idiff.."]") end;
    					if farmed_options.announce then UIErrorsFrame:AddMessage("Farmed |cffffff00"..icount.."|r x "..itemLink.." |cff00ff00[+"..idiff.."]", 1, 1, 1, 53, 5) end;
    				end
    				
    				farmed_looted_curr[n]=icount
    			end
    		end
    		
    		
    		farmed_gen();
    		
    	elseif (event=="BAG_OPEN") then
    		farmed_gen();
    	end

    end
end

function SafeNil(StringVar)
		if (StringVaar== nil) then
			return "";
		end

		return StringVar;
end 


