--========================================================--
--                EBFM WorldQuest                         --
--                                                        --
-- Author      :  kurapica125@outlook.com                 --
-- Create Date :  2017/03/07                              --
--========================================================--

--========================================================--
Scorpio     "EnhanceBattlefieldMinimap.WorldQuest"   "1.0.0"
--========================================================--

----------------------------------------------
-------------- Module Event Handler ----------
----------------------------------------------
function OnLoad(self)
    _SVDB:SetDefault { ShowWorldQuest = true }

    TaskPOIArray = List()
end

__SlashCmd__("ebfm", "worldquest", _Locale["on/off - show world quest marks"])
function ToggleWorldQuest(opt)
    if opt == "on" then
        if not _SVDB.ShowWorldQuest then
            _SVDB.ShowWorldQuest = true
            EBFM_REFRESH()
            UpdateHitRectInsets()
        end
    elseif opt == "off" then
        if _SVDB.ShowWorldQuest then
            _SVDB.ShowWorldQuest = false
            TaskPOIArray:Each("x=>x:Hide()")
        end
    else
        return false
    end
end

----------------------------------------------
-------------- System Event Handler ----------
----------------------------------------------
__SystemEvent__() __Async__()
function EBFM_REFRESH()
    if not _SVDB.ShowWorldQuest then return end

    Next()

    local mapAreaID     = GetCurrentMapAreaID()
    local taskInfo      = C_TaskQuest.GetQuestsForPlayerByMapID(mapAreaID)
    local numTaskPOIs   = taskInfo and #taskInfo or 0

    local hasWorldQuests= false
    local taskIconIndex = 1

    if ( numTaskPOIs > 0 ) then
        for i, info in ipairs(taskInfo) do
            if ( HaveQuestData(info.questId) ) then
                local taskPOI
                local isWorldQuest = QuestUtils_IsQuestWorldQuest(info.questId)
                if ( isWorldQuest ) then
                    taskPOI = TryCreatingWorldQuestPOI(info, taskIconIndex)
                else
                    taskPOI = TryCreatingBonusObjectivePOI(info, taskIconIndex)
                end

                if ( taskPOI ) then
                    AddPOIButton(taskPOI, info.x, info.y, isWorldQuest and WORLD_MAP_POI_FRAME_LEVEL_OFFSETS.WORLD_QUEST or WORLD_MAP_POI_FRAME_LEVEL_OFFSETS.BONUS_OBJECTIVE)
                    taskPOI.questID = info.questId
                    taskPOI.numObjectives = info.numObjectives
                    taskPOI:Show()

                    taskIconIndex = taskIconIndex + 1

                    if ( isWorldQuest ) then
                        hasWorldQuests = true
                    end
                end
            end
        end
    end

    -- Hide unused icons in the pool
    for i = taskIconIndex, #TaskPOIArray do
        TaskPOIArray[i]:Hide()
    end
end

__SystemEvent__()
function EBFM_UPDATE_HITRECT(left, right, top, bottom)
    for _, btn in ipairs(TaskPOIArray) do
        if btn:IsShown() then
            local x, y = btn:GetCenter()
            if x and y and x >= left and x <= right and y >= bottom and y <= top then
                btn:EnableMouse(true)
            else
                btn:EnableMouse(false)
            end
        end
    end
end

function GetTaskPOI(index)
    local button = TaskPOIArray[index]

    while #TaskPOIArray < index do
        button = CreateFrame("Button", nil, BattlefieldMinimapPOI)
        button:SetFlattensRenderLayers(true)
        button:RegisterForClicks("LeftButtonUp", "RightButtonUp")
        button:SetScript("OnEnter", HijackTaskPOI_OnEnter)
        button:SetScript("OnLeave", HijackTaskPOI_OnLeave)
        button:SetScript("OnClick", TaskPOI_OnClick)

        button.UpdateTooltip = HijackTaskPOI_OnEnter

        button.Texture = button:CreateTexture(nil, "BACKGROUND")
        button.Texture:SetPoint("CENTER")

        button.RewardRing = button:CreateTexture("nil", "BACKGROUND", -2)
        button.RewardRing:SetPoint("TOPLEFT", -4, 4)
        button.RewardRing:SetPoint("BOTTOMRIGHT", 4, -4)
        button.RewardRing:SetTexture("Interface/AddOns/EnhanceBattlefieldMinimap/resource/ring.tga")
        button.RewardRing:Hide()

        button.Glow = button:CreateTexture(nil, "BACKGROUND", -2)
        button.Glow:SetSize(50, 50)
        button.Glow:SetPoint("CENTER")
        button.Glow:SetTexture("Interface/WorldMap/UI-QuestPoi-IconGlow.tga")
        button.Glow:SetBlendMode("ADD")

        button.SelectedGlow = button:CreateTexture(nil, "OVERLAY", 2)
        button.SelectedGlow:SetBlendMode("ADD")

        button.CriteriaMatchGlow = button:CreateTexture(nil, "BACKGROUND", -1)
        button.CriteriaMatchGlow:SetAlpha(.6)
        button.CriteriaMatchGlow:SetBlendMode("ADD")

        button.SpellTargetGlow = button:CreateTexture(nil, "OVERLAY", 1)
        button.SpellTargetGlow:SetAtlas("worldquest-questmarker-abilityhighlight", true)
        button.SpellTargetGlow:SetAlpha(.6)
        button.SpellTargetGlow:SetBlendMode("ADD")
        button.SpellTargetGlow:SetPoint("CENTER", 0, 0)

        button.Underlay = button:CreateTexture(nil, "BACKGROUND")
        button.Underlay:SetWidth(34)
        button.Underlay:SetHeight(34)
        button.Underlay:SetPoint("CENTER", 0, -1)

        button.TimeLowFrame = CreateFrame("Frame", nil, button)
        button.TimeLowFrame:SetSize(22, 22)
        button.TimeLowFrame:SetPoint("CENTER", -10, -10)
        button.TimeLowFrame.Texture = button.TimeLowFrame:CreateTexture(nil, "OVERLAY")
        button.TimeLowFrame.Texture:SetAllPoints(button.TimeLowFrame)
        button.TimeLowFrame.Texture:SetAtlas("worldquest-icon-clock")

        WorldMap_ResetPOI(button, true, false)

        TaskPOIArray:Insert(button)
    end

    return button
end

function TryCreatingWorldQuestPOI(info, taskIconIndex)
    if ( WorldMap_IsWorldQuestSuppressed(info.questId) or not WorldMap_DoesWorldQuestInfoPassFilters(info) ) then
        return nil
    end

    local tagID, tagName, worldQuestType, rarity, isElite, tradeskillLineIndex = GetQuestTagInfo(info.questId)

    local taskPOI = GetTaskPOI(taskIconIndex)
    local selected = info.questId == GetSuperTrackedQuestID()

    local isCriteria = WorldMapFrame.UIElementsFrame.BountyBoard:IsWorldQuestCriteriaForSelectedBounty(info.questId)
    local isSpellTarget = SpellCanTargetQuest() and IsQuestIDValidSpellTarget(info.questId)

    taskPOI.worldQuest = true
    taskPOI.Texture:SetDrawLayer("OVERLAY")
    taskPOI.RewardRing:Hide()

    WorldMap_SetupWorldQuestButton(taskPOI, worldQuestType, rarity, isElite, tradeskillLineIndex, info.inProgress, selected, isCriteria, isSpellTarget)

    C_TaskQuest.RequestPreloadRewardData(info.questId)

    if rarity ~= LE_WORLD_QUEST_QUALITY_EPIC then
        local _, texture, name, quality, r, g, b
        local qid = info.questId
        if GetNumQuestLogRewards(qid) > 0 then
            _, texture, _, quality = GetQuestLogRewardInfo(1, qid)
            r, g, b = GetItemQualityColor(quality)
        elseif GetQuestLogRewardMoney(qid) > 0 then
            texture = "Interface/ICONS/INV_Misc_Coin_01"
            r, g, b = 0.85, 0.7, 0
        elseif GetNumQuestLogRewardCurrencies(qid) > 0 then
            for i = 1, GetNumQuestLogRewardCurrencies(qid)  do
               name, texture = GetQuestLogRewardCurrencyInfo(i, qid)
               if name == WORLD_QUEST_REWARD_FILTERS_ORDER_RESOURCES then
                  break
               end
            end
            r, g, b = 0.6, 0.4, 0.1
        end

        if texture then
            taskPOI.Texture:SetSize(taskPOI:GetSize())
            SetPortraitToTexture(taskPOI.Texture, texture)
            if not isElite then
                taskPOI.RewardRing:SetVertexColor(r, g, b)
                taskPOI.RewardRing:Show()
            end
        end
    end

    return taskPOI
end

function TryCreatingBonusObjectivePOI(info, taskIconIndex)
    local taskPOI = GetTaskPOI(taskIconIndex)

    taskPOI:SetSize(24, 24)
    taskPOI:SetNormalTexture(nil)
    taskPOI:SetPushedTexture(nil)
    taskPOI:SetHighlightTexture(nil)
    taskPOI.Underlay:Hide()
    taskPOI.Texture:SetAtlas("QuestBonusObjective")
    taskPOI.Texture:SetSize(24, 24)
    taskPOI.Texture:SetDrawLayer("BACKGROUND")
    taskPOI.TimeLowFrame:Hide()
    taskPOI.CriteriaMatchGlow:Hide()
    taskPOI.SpellTargetGlow:Hide()
    taskPOI.Glow:Hide()
    taskPOI.SelectedGlow:Hide()
    taskPOI.worldQuest = false

    return taskPOI
end

function HijackTaskPOI_OnEnter(self)
    WorldMap_HijackTooltip(BattlefieldMinimapScroll)
    return TaskPOI_OnEnter(self)
end

function HijackTaskPOI_OnLeave(self)
    TaskPOI_OnLeave(self)
    WorldMap_RestoreTooltip()
end
