--========================================================--
--                EBFM Scenario                              --
--                                                        --
-- Author      :  kurapica125@outlook.com                 --
-- Create Date :  2017/03/07                              --
--========================================================--

--========================================================--
Scorpio     "EnhanceBattlefieldMinimap.Scenario"      "1.0.0"
--========================================================--

REFRESH_TASK_ID = 0
ScenarioPOITooltips = {}
ScenarioPOIFrame = false
DISPLAY_BLOB_TIP = false

----------------------------------------------
-------------- Module Event Handler ----------
----------------------------------------------
function OnLoad(self)
    _SVDB:SetDefault { ShowScenarioPOI = true }

    POIArray	= List()
end

__SlashCmd__("ebfm", "scenario", _Locale["on/off - show scenario marks"])
function ToggleQuest(opt)
    if opt == "on" then
        _SVDB.ShowScenarioPOI = true
        EBFM_REFRESH()
        if ScenarioPOIFrame then
        	RefreshScenarioPOI(ScenarioPOIFrame)
        end
        UpdateHitRectInsets()
    elseif opt == "off" then
        _SVDB.ShowScenarioPOI = false
        POIArray:Each("x=>x:Hide()")
    else
        return false
    end
end

----------------------------------------------
-------------- System Event Handler ----------
----------------------------------------------
__SystemEvent__()
function EBFM_INITED()
    ScenarioPOIFrame = CreateFrame("ScenarioPOIFrame", nil, BattlefieldMinimapPOI)
    ScenarioPOIFrame:SetAllPoints(BattlefieldMinimapPOI)

    ScenarioPOIFrame:SetFillTexture("Interface\\WorldMap\\UI-QuestBlob-Inside")
	ScenarioPOIFrame:SetBorderTexture("Interface\\WorldMap\\UI-QuestBlob-Outside")
	ScenarioPOIFrame:SetFillAlpha(128)
	ScenarioPOIFrame:SetBorderAlpha(192)
	ScenarioPOIFrame:SetBorderScalar(1.0)

	ScenarioPOIFrame:SetScript("OnShow", RefreshScenarioPOI)

	return RefreshScenarioPOI(ScenarioPOIFrame)
end

__SystemEvent__() __Async__()
function EBFM_REFRESH()
    if not _SVDB.ShowScenarioPOI then return end

    Next()

	local scenarioIconInfo = C_Scenario.GetScenarioIconInfo()
	local numScenarioPOIs = scenarioIconInfo and #scenarioIconInfo or 0

	-- Draw scenario icons
	local scenarioIconCount = 1
	if scenarioIconInfo then
		for _, info  in pairs(scenarioIconInfo) do
			--textureIndex, x, y, name
			local textureIndex = info.index
			local x = info.x
			local y = info.y
			local name = info.description

			local scenarioPOIName = "WorldMapFrameScenarioPOI"..scenarioIconCount
			local scenarioPOI = GetPOIButton(scenarioIconCount)

			local x1, x2, y1, y2 = GetObjectIconTextureCoords(textureIndex)
			scenarioPOI.texture:SetTexCoord(x1, x2, y1, y2)
			AddPOIButton(scenarioPOI, x, y, WORLD_MAP_POI_FRAME_LEVEL_OFFSETS.SCENARIO)
			scenarioPOI.name = scenarioPOIName
			scenarioPOI:Show()
			ScenarioPOITooltips[scenarioPOIName] = name

			scenarioIconCount = scenarioIconCount + 1
		end
	end

	-- Hide unused icons in the pool
	for i=scenarioIconCount, #POIArray do
		POIArray[i]:Hide()
	end
end

__SystemEvent__()
function EBFM_UPDATE_HITRECT(left, right, top, bottom)
    for _, btn in ipairs(POIArray) do
        if not btn:IsShown() then return end
        local x, y = btn:GetCenter()
        if x and y and x >= left and x <= right and y >= bottom and y <= top then
            btn:EnableMouse(true)
        else
            btn:EnableMouse(false)
        end
    end
end

function GetPOIButton(index)
    local button = POIArray[index]

    while #POIArray < index do
		button = CreateFrame("Button", nil, BattlefieldMinimapPOI)
		button:SetWidth(32)
		button:SetHeight(32)
		button:SetScript("OnEnter", ScenarioPOI_OnEnter)
		button:SetScript("OnLeave", ScenarioPOI_OnLeave)

		local texture = button:CreateTexture(nil, "BACKGROUND")
		texture:SetWidth(16)
		texture:SetHeight(16)
		texture:SetPoint("CENTER", 0, 0)
		texture:SetTexture("Interface\\Minimap\\ObjectIconsAtlas")
		button.texture = texture

        POIArray:Insert(button)
    end

    return button
end

function ScenarioPOI_OnEnter(self)
	WorldMap_HijackTooltip(BattlefieldMinimapScroll)

	if(ScenarioPOITooltips[self.name] ~= nil) then
		WorldMapTooltip:SetOwner(self, "ANCHOR_RIGHT")
		WorldMapTooltip:SetText(ScenarioPOITooltips[self.name])
		WorldMapTooltip:Show()
	end
end

function ScenarioPOI_OnLeave()
	WorldMapTooltip:Hide()
	WorldMap_RestoreTooltip()
end

__Async__()
function RefreshScenarioPOI(self)
	REFRESH_TASK_ID = REFRESH_TASK_ID + 1
	local task = REFRESH_TASK_ID

	while task == REFRESH_TASK_ID and _SVDB.ShowScenarioPOI and self:IsVisible() do
		self:DrawNone()
		self:DrawAll()

		Delay(1)
	end

	self:DrawNone()
end

__SystemEvent__()
function EBFM_MOUSE_OVER(cx, cy)
    if ScenarioPOIFrame and (not WorldMapTooltip:IsShown() or DISPLAY_BLOB_TIP) then
        -- Check the Blob
        local hasScenarioTooltip = ScenarioPOIFrame:UpdateMouseOverTooltip(cx, cy)

		if hasScenarioTooltip then
            DISPLAY_BLOB_TIP = true
            WorldMap_HijackTooltip(BattlefieldMinimapScroll)
			WorldMapScenarioPOI_SetTooltip(ScenarioPOIFrame)
		else
            DISPLAY_BLOB_TIP = false
			WorldMapTooltip:Hide()
			WorldMap_RestoreTooltip()
		end
    end
end
