--========================================================--
--                EBFM Quest                              --
--                                                        --
-- Author      :  kurapica125@outlook.com                 --
-- Create Date :  2017/03/07                              --
--========================================================--

--========================================================--
Scorpio     "EnhanceBattlefieldMinimap.Quest"        "1.0.0"
--========================================================--

local BattlefieldMinimapBlob
local MDL_INITED = false
local NEW_POITABLE = {}
local OLD_StoryLine_OnEnter
local DISPLAY_BLOB_TIP = false

----------------------------------------------
-------------- Module Event Handler ----------
----------------------------------------------
function OnLoad(self)
    _SVDB:SetDefault { ShowQuestPOI = true }

    StoryLinePOI = List()
end

__SlashCmd__("ebfm", "quest", _Locale["on/off - show quest marks"])
function ToggleQuest(opt)
    if opt == "on" then
        _SVDB.ShowQuestPOI = true
        EBFM_REFRESH()
        UpdateHitRectInsets()
    elseif opt == "off" then
        _SVDB.ShowQuestPOI = false
        EBFM_REFRESH()
    else
        return false
    end
end

----------------------------------------------
-------------- System Event Handler ----------
----------------------------------------------
__SystemEvent__()
function EBFM_INITED()
    QuestPOI_Initialize(BattlefieldMinimapPOI, WorldMapPOIButton_Init)

    BattlefieldMinimapBlob = CreateFrame("QuestPOIFrame", "BattlefieldMinimapBlobFrame", BattlefieldMinimapPOI)
    BattlefieldMinimapBlob:SetAllPoints(BattlefieldMinimapPOI)
    WorldMapBlobFrame_OnLoad(BattlefieldMinimapBlob)

    MDL_INITED = true

    QuestMapFrame_UpdateAll()
end

__SystemEvent__()
__SecureHook__ "WorldMapPOIFrame_Update"
function EBFM_REFRESH()
    if not MDL_INITED then return end

    QuestPOI_ResetUsage(BattlefieldMinimapPOI)

    if not _SVDB.ShowQuestPOI then
    	BattlefieldMinimapBlob:DrawNone()
        QuestPOI_HideUnusedButtons(BattlefieldMinimapPOI)
        return
    end

    local poiTable = NEW_POITABLE
    if not poiTable then return end

    local detailQuestID = QuestMapFrame_GetDetailQuestID()
    local poiButton
    for index, questID in pairs(poiTable) do
        if ( not detailQuestID or questID == detailQuestID ) then
            local _, posX, posY = QuestPOIGetIconInfo(questID)
            if ( posX and posY ) then
                if ( IsQuestComplete(questID) ) then
                    poiButton = QuestPOI_GetButton(BattlefieldMinimapPOI, questID, "map", nil)
                else
                    -- if a quest is being viewed there is only going to be one POI and it's going to have number 1
                    poiButton = QuestPOI_GetButton(BattlefieldMinimapPOI, questID, "numeric", (detailQuestID and 1) or index)
                end
                AddPOIButton(poiButton, posX, posY, WORLD_MAP_POI_FRAME_LEVEL_OFFSETS.TRACKED_QUEST)
            end
        end
    end
    WorldMapPOIFrame_SelectPOI(GetSuperTrackedQuestID())
    QuestPOI_HideUnusedButtons(BattlefieldMinimapPOI)

    -- Draw Stroy Line
    local numUsedStoryLineFrames = 0
    local mapID, isContinent = GetCurrentMapAreaID()
    if ( not isContinent and mapID > 0 ) then
		for i = 1, C_Questline.GetNumAvailableQuestlines() do
			local questLineName, questName, x, y, isHidden, floorLocation = C_Questline.GetQuestlineInfoByIndex(i)
			local showQuest = questLineName and x > 0 and y > 0
			if ( showQuest and isHidden ) then
				local _, _, active = GetTrackingInfo(MINIMAP_TRACK_HIDDEN_QUESTS)
				showQuest = active
			end
			if ( showQuest ) then
				numUsedStoryLineFrames = numUsedStoryLineFrames + 1
				local frame = GetStoryLine(numUsedStoryLineFrames)
				frame.index = i
				AddPOIButton(frame, x, y, WORLD_MAP_POI_FRAME_LEVEL_OFFSETS.STORY_LINE)
				if ( isHidden ) then
					frame.Texture:SetAtlas("TrivialQuests", true)
				else
					frame.Texture:SetAtlas("QuestNormal", true)
				end
				frame.Below:SetShown(floorLocation == LE_QUESTLINE_FLOOR_LOCATION_BELOW)
				frame.Above:SetShown(floorLocation == LE_QUESTLINE_FLOOR_LOCATION_ABOVE)
				frame.Texture:SetDesaturated(floorLocation ~= LE_QUESTLINE_FLOOR_LOCATION_SAME)
				frame:Show()
			end
		end
	end
	for i = numUsedStoryLineFrames + 1, #StoryLinePOI do
		StoryLinePOI[i]:Hide()
	end
end

__SecureHook__ "QuestMapFrame_UpdateAll"
function UpdateAllQuest()
    if WorldMapFrame:IsShown() or not MDL_INITED or not _SVDB.ShowQuestPOI then return end

    wipe(NEW_POITABLE)
    if ( QuestMapUpdateAllQuests() > 0 and GetCVarBool("questPOI") ) then
        GetQuestPOIs(NEW_POITABLE)
    end
    EBFM_REFRESH()
    UpdateHitRectInsets()
end

__Async__()
function DrawQuestBlobs()
    BattlefieldMinimapBlob:DrawNone()

    Next()

    local questID = QuestMapFrame_GetDetailQuestID() or GetSuperTrackedQuestID()
    if not IsQuestComplete(questID) then
        BattlefieldMinimapBlob:DrawBlob(questID, true)
    end
end

__SystemEvent__()
function EBFM_MOUSE_OVER(cx, cy)
    if not WorldMapTooltip:IsShown() or DISPLAY_BLOB_TIP then
        -- Check the Blob
        local qid, numObj = BattlefieldMinimapBlob:UpdateMouseOverTooltip(cx, cy)

        if numObj then
            DISPLAY_BLOB_TIP = true
            WorldMap_HijackTooltip(BattlefieldMinimapScroll)
            WorldMapQuestPOI_SetTooltip(nil, qid, numObj)
        else
            DISPLAY_BLOB_TIP = false
            WorldMapTooltip:Hide()
            WorldMap_RestoreTooltip()
        end
    end
end

__SystemEvent__()
function EBFM_UPDATE_HITRECT(left, right, top, bottom)
    if not MDL_INITED then return end

    for _, poiType in pairs(BattlefieldMinimapPOI.poiTable) do
        for _, poiButton in pairs(poiType) do
            if poiButton.used and poiButton:IsShown() then
                local x, y = poiButton:GetCenter()
                if x and y and x >= left and x <= right and y >= bottom and y <= top then
                    poiButton:EnableMouse(true)
                else
                    poiButton:EnableMouse(false)
                end
            end
        end
    end

    for _, btn in ipairs(StoryLinePOI) do
        if not btn:IsShown() then return end
        local x, y = btn:GetCenter()
        if x and y and x >= left and x <= right and y >= bottom and y <= top then
            btn:EnableMouse(true)
        else
            btn:EnableMouse(false)
        end
    end
end

function WorldMapPOIButton_Init(self)
    self:SetScript("OnEnter", WorldMapPOIButton_OnEnter)
    self:SetScript("OnLeave", WorldMapPOIButton_OnLeave)
end

function WorldMapPOIButton_OnEnter(self)
    WorldMap_HijackTooltip(BattlefieldMinimapScroll)
    WorldMapQuestPOI_SetTooltip(self, GetQuestLogIndexByID(self.questID))

    local _, posX, posY = QuestPOIGetIconInfo(self.questID)
    for _, poiType in pairs(BattlefieldMinimapPOI.poiTable) do
        for _, poiButton in pairs(poiType) do
            if ( poiButton ~= self and poiButton.used ) then
                local _, otherPosX, otherPosY = QuestPOIGetIconInfo(poiButton.questID)

                if ((math.pow(posX - otherPosX, 2) + math.pow(posY - otherPosY, 2)) < BLOB_OVERLAP_DELTA) then
                    WorldMapQuestPOI_AppendTooltip(poiButton, GetQuestLogIndexByID(poiButton.questID))
                end
            end
        end
    end
end

function WorldMapPOIButton_OnLeave(self)
    WorldMapTooltip:Hide()
    WorldMap_RestoreTooltip()
end

function WorldMapPOIFrame_SelectPOI(questID)
    -- POIs can overlap each other, bring the selection to the top
    local poiButton = QuestPOI_FindButton(BattlefieldMinimapPOI, questID)
    if ( poiButton ) then
        QuestPOI_SelectButton(poiButton)
        poiButton:Raise()
    else
        QuestPOI_ClearSelection(BattlefieldMinimapPOI)
    end
    DrawQuestBlobs()
end

function GetStoryLine(index)
	local frame = StoryLinePOI[index]
	while #StoryLinePOI < index do
		frame = CreateFrame("Frame", nil, BattlefieldMinimapPOI, "WorldMapStoryLineTemplate")
		frame:SetFrameStrata("High")
		StoryLinePOI:Insert(frame)
		if not OLD_StoryLine_OnEnter then
			OLD_StoryLine_OnEnter = frame:GetScript("OnEnter")
		end
		frame:SetScript("OnEnter", StoryLine_OnEnter)
        frame:SetScript("OnLeave", StoryLine_OnLeave)
	end
	return frame
end

function StoryLine_OnEnter(self)
	WorldMap_HijackTooltip(BattlefieldMinimapScroll)
	OLD_StoryLine_OnEnter(self)
end

function StoryLine_OnLeave(self)
    WorldMapTooltip:Hide()
    WorldMap_RestoreTooltip()
end
