--========================================================--
--                EBFM Landmarks                          --
--                                                        --
-- Author      :  kurapica125@outlook.com                 --
-- Create Date :  2017/03/07                              --
--========================================================--

--========================================================--
Scorpio     "EnhanceBattlefieldMinimap.Landmarks"    "1.0.0"
--========================================================--

----------------------------------------------
-------------- Module Event Handler ----------
----------------------------------------------
function OnLoad(self)
    _SVDB:SetDefault { ShowLandmark = true }

    POIArray       = List()
    GraveyardArray = List()
end

__SlashCmd__("ebfm", "landmark", _Locale["on/off - show land marks"])
function ToggleLandmark(opt)
    if opt == "on" then
        if not _SVDB.ShowLandmark then
            _SVDB.ShowLandmark = true
            EBFM_REFRESH()
            UpdateHitRectInsets()
        end
    elseif opt == "off" then
        if _SVDB.ShowLandmark then
            _SVDB.ShowLandmark = false
            POIArray:Each("x=>x:Hide()")
            GraveyardArray:Each("x=>x:Hide()")
        end
    else
        return false
    end
end

----------------------------------------------
-------------- System Event Handler ----------
----------------------------------------------
__SystemEvent__() __Async__()
function EBFM_REFRESH()
    if not _SVDB.ShowLandmark then return end

    Next()

    local numPOIs           = GetNumMapLandmarks()
    local numGraveyards     = 0
    local currentGraveyard  = GetCemeteryPreference()
    local mapID             = GetCurrentMapAreaID()

    for i = 1, max(#POIArray, numPOIs) do
        local poi = GetPOIButton(i)
        if i <= numPOIs then
            local landmarkType, name, description, textureIndex, x, y, mapLinkID, inBattleMap, graveyardID, areaID, poiID, isObjectIcon, atlasIcon, displayAsBanner, mapFloor, textureKitPrefix = C_WorldMap.GetMapLandmarkInfo(i)
            if( not WorldMap_ShouldShowLandmark(landmarkType) or (mapID ~= WORLDMAP_WINTERGRASP_ID and areaID == WORLDMAP_WINTERGRASP_POI_AREAID) or displayAsBanner ) then
                poi:Hide()
            else
                AddPOIButton(poi, x, y, WorldMap_GetFrameLevelForLandmark(landmarkType))
                if ( landmarkType == LE_MAP_LANDMARK_TYPE_NORMAL and WorldMap_IsSpecialPOI(poiID) ) then    --We have special handling for Isle of the Thunder King
                    WorldMap_HandleSpecialPOI(poi, poiID)
                else
                    WorldMap_ResetPOI(poi, isObjectIcon, atlasIcon, textureKitPrefix)

                    if (not atlasIcon) then
                        local x1, x2, y1, y2
                        if (isObjectIcon) then
                            x1, x2, y1, y2 = GetObjectIconTextureCoords(textureIndex)
                        else
                            x1, x2, y1, y2 = GetPOITextureCoords(textureIndex)
                        end
                        poi.Texture:SetTexCoord(x1, x2, y1, y2)
                        poi.HighlightTexture:SetTexCoord(x1, x2, y1, y2)
                    else
                        poi.Texture:SetTexCoord(0, 1, 0, 1)
                        poi.HighlightTexture:SetTexCoord(0, 1, 0, 1)
                    end

                    poi.name = name
                    poi.description = description
                    poi.mapLinkID = mapLinkID
                    poi.mapFloor = mapFloor
                    poi.poiID = poiID
                    poi.landmarkType = landmarkType
                    poi.textureKitPrefix = textureKitPrefix
                    if ( graveyardID and graveyardID > 0 ) then
                        poi.graveyard = graveyardID
                        numGraveyards = numGraveyards + 1
                        local graveyard = GetGraveyardButton(numGraveyards)
                        graveyard:SetPoint("CENTER", poi)
                        graveyard:SetFrameLevel(poi:GetFrameLevel() - 1)
                        graveyard:Show()
                        if ( currentGraveyard == graveyardID ) then
                            graveyard.texture:SetTexture("Interface\\WorldMap\\GravePicker-Selected")
                        else
                            graveyard.texture:SetTexture("Interface\\WorldMap\\GravePicker-Unselected")
                        end
                        poi:Hide()     -- lame way to force tooltip redraw
                    else
                        poi.graveyard = nil
                    end
                end
                poi:Show()
            end
        else
            poi:Hide()
        end
    end

    for i = numGraveyards + 1, #GraveyardArray do
        GraveyardArray[i]:Hide()
    end
end

__SystemEvent__()
function EBFM_UPDATE_HITRECT(left, right, top, bottom)
    for _, btn in ipairs(POIArray) do
        if not btn:IsShown() then return end
        local x, y = btn:GetCenter()
        if x and y and x >= left and x <= right and y >= bottom and y <= top then
            btn:EnableMouse(true)
        else
            btn:EnableMouse(false)
        end
    end
    for _, btn in ipairs(GraveyardArray) do
        if not btn:IsShown() then return end
        local x, y = btn:GetCenter()
        if x and y and x >= left and x <= right and y >= bottom and y <= top then
            btn:EnableMouse(true)
        else
            btn:EnableMouse(false)
        end
    end
end

function GetPOIButton(index)
    local button = POIArray[index]

    while #POIArray < index do
        button = CreateFrame("Button", nil, BattlefieldMinimapPOI)
        button:RegisterForClicks("LeftButtonUp", "RightButtonUp")
        button:SetScript("OnEnter", HJWorldMapPOI_OnEnter)
        button:SetScript("OnLeave", HJWorldMapPOI_OnLeave)
        button:SetScript("OnClick", HJWorldMapPOI_OnClick)

        button.UpdateTooltip = HJWorldMapPOI_OnEnter

        button.Texture = button:CreateTexture(nil, "BACKGROUND")
        button.HighlightTexture = button:CreateTexture(nil, "HIGHLIGHT")
        button.HighlightTexture:SetBlendMode("ADD")
        button.HighlightTexture:SetAlpha(.4)
        button.HighlightTexture:SetAllPoints(button.Texture)

        POIArray:Insert(button)

        WorldMap_ResetPOI(button)
    end

    return button
end

function GetGraveyardButton(index)
    local button = GraveyardArray[index]

    while #GraveyardArray < index do
        button = CreateFrame("Button", nil, BattlefieldMinimapPOI)
        button:SetWidth(32)
        button:SetHeight(32)
        button:RegisterForClicks("LeftButtonUp", "RightButtonUp")
        button:SetScript("OnEnter", nil)
        button:SetScript("OnLeave", nil)
        button:SetScript("OnClick", nil)

        local texture = button:CreateTexture(nil, "ARTWORK")
        texture:SetWidth(48)
        texture:SetHeight(48)
        texture:SetPoint("CENTER", 0, 0)
        button.texture = texture

        GraveyardArray:Insert(button)
    end

    return button
end

function HJWorldMapPOI_OnEnter(self)
    WorldMap_HijackTooltip(BattlefieldMinimapScroll)
    WorldMapPOI_OnEnter(self)
    return WorldMapFrame_EvaluateAreaLabels()
end

function HJWorldMapPOI_OnLeave(self)
    WorldMapPOI_OnLeave(self)
    WorldMap_RestoreTooltip()
    return WorldMapFrame_EvaluateAreaLabels()
end

function HJWorldMapPOI_OnClick(self, button)
    if self.mapLinkID or self.graveyard then
        return WorldMapPOI_OnClick(self, "fakebutton")
    else
        _Addon.OnMouseDown(BattlefieldMinimap, button)
        _Addon.OnMouseUp(BattlefieldMinimap, button)
    end
end
