--========================================================--
--                EBFM HandyNotes                         --
--                                                        --
-- Author      :  kurapica125@outlook.com                 --
-- Create Date :  2017/03/04                              --
--========================================================--

--========================================================--
Scorpio     "EnhanceBattlefieldMinimap.HandyNotes"   "1.0.0"
--========================================================--

if not IsAddOnLoaded("HandyNotes") then return end

----------------------------------------------
-------------------- Objects -----------------
----------------------------------------------
PinArray            = List()
PinCache            = Recycle()
HBD                 = LibStub("HereBeDragons-1.0")
HBDPins             = LibStub("HereBeDragons-Pins-1.0")

local MDL_INITED    = false

function PinCache:New()
    local button = CreateFrame("Button", nil, BattlefieldMinimapPOI)
    button:Hide()
    button:SetFrameLevel(5)
    button:EnableMouse(true)
    button:SetWidth(12)
    button:SetHeight(12)

    button:SetScript("OnEnter", pinsHandler_OnEnter)
    button:SetScript("OnLeave", pinsHandler_OnLeave)

    local texture = button:CreateTexture(nil, "OVERLAY")
    texture:SetAllPoints(button)
    button.texture = texture

    return button
end

function PinCache:OnPush(btn)
    btn:Hide()
end

----------------------------------------------
-------------- Module Event Handler ----------
----------------------------------------------
__Async__()
function OnLoad(self)
    _SVDB:SetDefault { ShowHandyNotes = true }
end

__SlashCmd__("ebfm", "handynotes", _Locale["on/off - show HandyNotes's marks"])
function ToggleHandyNotes(opt)
    if opt == "on" then
        if not _SVDB.ShowHandyNotes then
            _SVDB.ShowHandyNotes = true
            DrawHandNotes()
            UpdateHitRectInsets()
        end
    elseif opt == "off" then
        if _SVDB.ShowHandyNotes then
            _SVDB.ShowHandyNotes = false
            PinArray:Each(function(btn) PinCache(btn) end)
            wipe(PinArray)
        end
    else
        return false
    end
end

__SystemEvent__()
function EBFM_INITED()
    MDL_INITED = true
    _M:SecureHook(HandyNotes, "UpdateWorldMapPlugin")
end

__SystemEvent__ "EBFM_REFRESH"
function DrawHandNotes()
    if not MDL_INITED then return end
    if not _SVDB.ShowHandyNotes then return end

    for name, handler in pairs(HandyNotes.plugins) do
        UpdateWorldMapPlugin(HandyNotes, name)
    end
end

__SystemEvent__()
function EBFM_UPDATE_HITRECT(left, right, top, bottom)
    for _, btn in ipairs(PinArray) do
        local x, y = btn:GetCenter()
        if x and y and x >= left and x <= right and y >= bottom and y <= top then
            btn:EnableMouse(true)
        else
            btn:EnableMouse(false)
        end
    end
end

function UpdateWorldMapPlugin(self, name)
    if not MDL_INITED or not _SVDB.ShowHandyNotes then return end
    if not BattlefieldMinimap:IsShown() then return end

    ClearForPlugin(name)

    local mapFile, mapID, level = self:WhereAmI()
    local pluginHandler = self.plugins[name]
    local frameLevel = BattlefieldMinimapPOI:GetFrameLevel() + 5
    local frameStrata = BattlefieldMinimapPOI:GetFrameStrata()
    local tWidth = BattlefieldMinimapPOI:GetWidth()
    local tHeight = BattlefieldMinimapPOI:GetHeight()

    for coord, mapFile2, iconpath, scale, alpha, level2 in pluginHandler:GetNodes(mapFile, false, level) do

        -- Scarlet Enclave check, only do stuff if we're on that map, since we have no zone translation for it yet in Astrolabe
        if mapFile2 ~= "ScarletEnclave" or mapFile2 == mapFile then
            local icon = PinCache()
            icon:SetFrameStrata(frameStrata)
            icon:SetFrameLevel(frameLevel)

            local t = icon.texture
            if type(iconpath) == "table" then
                if iconpath.tCoordLeft then
                    t:SetTexCoord(iconpath.tCoordLeft, iconpath.tCoordRight, iconpath.tCoordTop, iconpath.tCoordBottom)
                else
                    t:SetTexCoord(0, 1, 0, 1)
                end
                if iconpath.r then
                    t:SetVertexColor(iconpath.r, iconpath.g, iconpath.b, iconpath.a)
                else
                    t:SetVertexColor(1, 1, 1, 1)
                end
                t:SetTexture(iconpath.icon)
            else
                t:SetTexCoord(0, 1, 0, 1)
                t:SetVertexColor(1, 1, 1, 1)
                t:SetTexture(iconpath)
            end

            local x, y = floor(coord / 10000) / 10000, (coord % 10000) / 10000
            local mapID2 = HandyNotes:GetMapFiletoMapID(mapFile2 or mapFile)

            if not mapID2 then
                icon:ClearAllPoints()
                icon:SetPoint("CENTER", BattlefieldMinimapPOI, "TOPLEFT", x * tWidth, -y * tHeight)
                icon:Show()
            else
                -- HBDPins:AddWorldMapIconMF("HandyNotes" .. name, icon, mapID2, level2 or level, x, y)
                local mapFloor = level2 or level
                local xCoord, yCoord, instanceID = HBD:GetWorldCoordinatesFromZone(x, y, mapID2, mapFloor)

                if xCoord then
                    local currentMapID, currentMapFloor = GetWorldMapLocation()
                    if currentMapID and HBD.mapData[currentMapID] and (HBD.mapData[currentMapID].instance == instanceID or currentMapID == WORLDMAP_AZEROTH_ID)
                       and (not mapFloor or (currentMapFloor == mapFloor and (mapFloor == 0 or currentMapID == mapID2))) then

                        if currentMapID == WORLDMAP_AZEROTH_ID then
                            currentMapFloor = instanceID
                        end

                        local x, y = HBD:GetZoneCoordinatesFromWorld(xCoord, yCoord, currentMapID, currentMapFloor)

                        if x and y then
                            icon:ClearAllPoints()
                            icon:SetPoint("CENTER", BattlefieldMinimapPOI, "TOPLEFT", x * tWidth, -y * tHeight)
                            icon:Show()
                        end
                    end
                end
            end
            t:ClearAllPoints()
            t:SetAllPoints(icon) -- Not sure why this is necessary, but people are reporting weirdly sized textures

            icon.pluginName = name
            icon.coord = coord
            icon.mapFile = mapFile2 or mapFile

            if icon:IsShown() then
                PinArray:Insert(icon)
            else
                PinCache(icon)
            end
        end
    end
    return UpdateHitRectInsets()
end

function ClearForPlugin(name)
    for i = #PinArray, 1, -1 do
        local btn = PinArray[i]
        if btn.pluginName == name then
            PinArray:RemoveByIndex(i)
            PinCache(btn)
        end
    end
end

function pinsHandler_OnEnter(self)
    pcall(HandyNotes.plugins[self.pluginName].OnEnter, self, self.mapFile, self.coord)
end
function pinsHandler_OnLeave(self)
    pcall(HandyNotes.plugins[self.pluginName].OnLeave, self, self.mapFile, self.coord)
end

function GetWorldMapLocation()
    local mapID, mapFloor = GetCurrentMapAreaID(), GetCurrentMapDungeonLevel()

    -- override the mapID for the azeroth world map
    if mapID == -1 and GetCurrentMapContinent() == 0 and GetCurrentMapZone() == 0 then
        mapID = WORLDMAP_AZEROTH_ID
        mapFloor = 0
    end

    return mapID, mapFloor
end

