--========================================================--
--                EBFM Encounter                          --
--                                                        --
-- Author      :  kurapica125@outlook.com                 --
-- Create Date :  2017/03/07                              --
--========================================================--

--========================================================--
Scorpio     "EnhanceBattlefieldMinimap.Encounter"    "1.0.0"
--========================================================--

local OLD_Encounter_OnEnter
local OLD_Encounter_OnClick
local OLD_Encounter_OnLeave
local MDL_INITED = false
local IN_ENCOUNTER = false
local HIDDEN_ENCOUNTER = {}

----------------------------------------------
-------------- Module Event Handler ----------
----------------------------------------------
function OnLoad(self)
    _SVDB:SetDefault { ShowEncounter = true }

    EncounterPOI = List()
end

__SlashCmd__("ebfm", "encounter", _Locale["on/off - show boss marks"])
function ToggleQuest(opt)
    if opt == "on" then
        _SVDB.ShowEncounter = true
        EBFM_REFRESH()
        UpdateHitRectInsets()
    elseif opt == "off" then
        _SVDB.ShowEncounter = false
        EncounterPOI:Each("x=>x:Hide()")
    else
        return false
    end
end

__SystemEvent__()
function EBFM_INITED()
	MDL_INITED = true
end

__SystemEvent__()
function EBFM_REFRESH()
	if not MDL_INITED or not _SVDB.ShowEncounter then return end
	if IN_ENCOUNTER then return end

    local width = BattlefieldMinimap:GetWidth()
    local height = BattlefieldMinimap:GetHeight()
	local bossButton, questPOI, displayInfo, _
	local index = 1
	local enIdx = 1
	local x, y, instanceID, name, description, encounterID = EJ_GetMapEncounter(index, false)
	while name do
		if not HIDDEN_ENCOUNTER[encounterID] then
			bossButton = GetEncounter(enIdx)
			enIdx = enIdx + 1

			bossButton.instanceID = instanceID
			bossButton.encounterID = encounterID
			bossButton.tooltipTitle = name
			bossButton.tooltipText = description
			bossButton:SetPoint("CENTER", BattlefieldMinimap, "BOTTOMLEFT", x*width, y*height)

			_, _, _, displayInfo = EJ_GetCreatureInfo(1, encounterID)
			bossButton.displayInfo = displayInfo
			if ( displayInfo ) then
				SetPortraitTexture(bossButton.bgImage, displayInfo)
			else
				bossButton.bgImage:SetTexture("DoesNotExist")
			end
			bossButton:Show()
		end

		index = index + 1
		x, y, instanceID, name, description, encounterID = EJ_GetMapEncounter(index, false)
	end

	for i = enIdx, #EncounterPOI do
		EncounterPOI[i]:Hide()
	end
end

__SystemEvent__()
function EBFM_UPDATE_HITRECT(left, right, top, bottom)
	local scale = BattlefieldMinimap:GetScale() / _SVDB.ScaleModifier
	left 	= left / scale
	right 	= right / scale
	top 	= top / scale
	bottom 	= bottom / scale
	for _, btn in ipairs(EncounterPOI) do
		if not btn:IsShown() then return end
		local x, y = btn:GetCenter()
		if x and y and x >= left and x <= right and y >= bottom and y <= top then
			btn:EnableMouse(true)
		else
			btn:EnableMouse(false)
		end
	end
end

__SystemEvent__ "UNIT_PORTRAIT_UPDATE"
function EncounterJournal_UpdateMapButtonPortraits()
	if ( MDL_INITED and BattlefieldMinimapScroll:IsShown() ) then
		local index = 1
		local bossButton = EncounterPOI[index]
		while ( bossButton and bossButton:IsShown() ) do
			SetPortraitTexture(bossButton.bgImage, bossButton.displayInfo)
			index = index + 1
			bossButton = EncounterPOI[index]
		end
	end
end

__SystemEvent__()
function ENCOUNTER_START()
	IN_ENCOUNTER = true
    EncounterPOI:Each("x=>x:Hide()")
end

__SystemEvent__()
function ENCOUNTER_END()
	IN_ENCOUNTER = false
	if MDL_INITED then
		EBFM_REFRESH()
		UpdateHitRectInsets()
	end
end

function GetEncounter(index)
	local frame = EncounterPOI[index]
	while #EncounterPOI < index do
		frame = CreateFrame("Button", "Test"..index, BattlefieldMinimap, "EncounterMapButtonTemplate")
		frame:SetSize(12, 12)
		frame.bgImage:SetSize(8, 8)
		frame:SetFrameStrata("High")
		EncounterPOI:Insert(frame)
		if not OLD_Encounter_OnEnter then
			OLD_Encounter_OnEnter = frame:GetScript("OnEnter")
		end
		if not OLD_Encounter_OnClick then
			OLD_Encounter_OnClick = frame:GetScript("OnClick")
		end
		if not OLD_Encounter_OnLeave then
			OLD_Encounter_OnLeave = frame:GetScript("OnLeave")
		end
		frame:RegisterForClicks("AnyUp")
		frame:SetScript("OnEnter", Encounter_OnEnter)
		frame:SetScript("OnClick", Encounter_OnClick)
		frame:SetScript("OnLeave", Encounter_OnLeave)
	end
	return frame
end

function Encounter_OnEnter(self)
	WorldMap_HijackTooltip(BattlefieldMinimapScroll)
	OLD_Encounter_OnEnter(self)
end

function Encounter_OnLeave(self)
	OLD_Encounter_OnLeave(self)
	WorldMap_RestoreTooltip()
end

function Encounter_OnClick(self, button)
	if button == "RightButton" then
		if self.encounterID then
			HIDDEN_ENCOUNTER[self.encounterID] = true
			EBFM_REFRESH()
		end
	else
		return OLD_Encounter_OnClick(self, button)
	end
end
