local addonName, addon = ...

-- Initialize localization
local L = nil
local AL = LibStub:GetLibrary("AceLocale-3.0", true)
if AL then
	if type(addon.LoadTranslations) == "function" then
		addon:LoadTranslations(AL)
		addon.LoadTranslations = nil
	end
	L = AL:GetLocale(addonName)
	AL = nil
else
	L = setmetatable({}, {__index = function(t,k) t[k] = k return k end })
end
addon.L = L

EL_Types = {
	[1] = L["Friendly"],
	[2] = L["Hostile"],
	[3] = L["Happy"],
	[4] = L["Neutral"],
	[5] = L["Unhappy"],
	[6] = L["Custom"],
	[7] = L["Taunts"],
	[8] = L["Affection"],
	[9] = L["Greetings"],
	[10] = L["Combat"],
	[11] = L["Self-Deprecating"],
	[12] = L["Reactions"],
	[13] = L["Other"],
}

EL_React = {
	[0] = "",
	[1] = L["Action"],
	[2] = L["Vocal"],
	[3] = L["AV"],
}

-- CUSTOM EMOTE VARIABLES: <Target>, <He>, <His>, <he>, <his>
-- The text for custom emotes should NOT contain the player's name at the beginning. It will be sent with a /e preceeding it.
-- NOTE: They MUST start with category 6, no matter how many other categories are added.
-- ALSO NOTE: If you add a custom emote, you MUST include the "["custom"] = {1}," line or it will be improperly indexed as having a slash command!

EL_Emotes = {
	["escape"] = { -- CUSTOM EMOTE
		["types"] = {6},
		["none"] = L["escape"],
		["target"] = L["escape_target"],
		["react"] = 0,
		["custom"] = {1},
	},
	["bio"] = { -- CUSTOM EMOTE
		["types"] = {6,13},
		["none"] = L["bio"],
		["target"] = L["bio_target"],
		["react"] = 0,
		["custom"] = {1},
	},
	["bladeintro"] = { -- CUSTOM EMOTE
		["types"] = {6,2},
		["none"] = L["bladeintro"],
		["target"] = L["bladeintro_target"],
		["react"] = 0,
		["custom"] = {1},
	},
	["agree"] = { -- Begin Blizzard emotes
		["types"] = {12},
		["none"] = L["agree"],
		["target"] = L["agree_target"],
		["react"] = 0,
		["custom"] = {0},
	},
	["amaze"] = {
		["types"] = {12},
		["none"] = L["amaze"],
		["target"] = L["amaze_target"],
		["react"] = 0,
		["custom"] = {0},
	},
	["angry"] = {
		["types"] = {2},
		["none"] = L["angry"],
		["target"] = L["angry_target"],
		["react"] = 1,
		["custom"] = {0},
	},
	["apologize"] = {
		["types"] = {11},
		["none"] = L["apologize"],
		["target"] = L["apologize_target"],
		["react"] = 0,
		["custom"] = {0},
	},
	["applaud"] = {
		["types"] = {12},
		["none"] = L["applaud"],
		["target"] = L["applaud_target"],
		["react"] = 3,
		["custom"] = {0},
	},
	["arm"] = {
		["types"] = {1, 8},
		["none"] = L["arm"],
		["target"] = L["arm_target"],
		["react"] = 0,
		["custom"] = {0},
	},
	["attacktarget"] = {
		["types"] = {10},
		["none"] = L["attacktarget"],
		["target"] = L["attacktarget_target"],
		["react"] = 3,
		["custom"] = {0},
	},
	["bark"] = {
		["types"] = {13},
		["none"] = L["bark"],
		["target"] = L["bark_target"],
		["react"] = 0,
		["custom"] = {0},
	},
	["bashful"] = {
		["types"] = {8},
		["none"] = L["bashful"],
		["target"] = L["bashful_target"],
		["react"] = 1,
		["custom"] = {0},
	},
	["beckon"] = {
		["types"] = {9},
		["none"] = L["beckon"],
		["target"] = L["beckon_target"],
		["react"] = 0,
		["custom"] = {0},
	},
	["beg"] = {
		["types"] = {11},
		["none"] = L["beg"],
		["target"] = L["beg_target"],
		["react"] = 1,
		["custom"] = {0},
	},
	["belch"] = {
		["types"] = {7},
		["none"] = L["belch"],
		["target"] = L["belch_target"],
		["react"] = 0,
		["custom"] = {0},
	},
	["bite"] = {
		["types"] = {2},
		["none"] = L["bite"],
		["target"] = L["bite_target"],
		["react"] = 0,
		["custom"] = {0},
	},
	["bleed"] = {
		["types"] = {13},
		["none"] = L["bleed"],
		["target"] = L["bleed_target"],
		["react"] = 0,
		["custom"] = {0},
	},
	["blink"] = {
		["types"] = {12},
		["none"] = L["blink"],
		["target"] = L["blink_target"],
		["react"] = 0,
		["custom"] = {0},
	},
	["blush"] = {
		["types"] = {8},
		["none"] = L["blush"],
		["target"] = L["blush_target"],
		["react"] = 1,
		["custom"] = {0},
	},
	["boggle"] = {
		["types"] = {12},
		["none"] = L["boggle"],
		["target"] = L["boggle_target"],
		["react"] = 1,
		["custom"] = {0},
	},
	["bonk"] = {
		["types"] = {12},
		["none"] = L["bonk"],
		["target"] = L["bonk_target"],
		["react"] = 0,
		["custom"] = {0},
	},
	["bored"] = {
		["types"] = {5},
		["none"] = L["bored"],
		["target"] = L["bored_target"],
		["react"] = 2,
		["custom"] = {0},
	},
	["bounce"] = {
		["types"] = {3},
		["none"] = L["bounce"],
		["target"] = L["bounce_target"],
		["react"] = 0,
		["custom"] = {0},
	},
	["bow"] = {
		["types"] = {9},
		["none"] = L["bow"],
		["target"] = L["bow_target"],
		["react"] = 1,
		["custom"] = {0},
	},
	["brandish"] = {
		["types"] = {2},
		["none"] = L["brandish"],
		["target"] = L["brandish_target"],
		["react"] = 0,
		["custom"] = {0},
	},
	["brb"] = {
		["types"] = {4,10,12},
		["none"] = L["brb"],
		["target"] = L["brb_target"],
		["react"] = 0,
		["custom"] = {0},
	},
	["cackle"] = {
		["types"] = {3},
		["none"] = L["cackle"],
		["target"] = L["cackle_target"],
		["react"] = 3,
		["custom"] = {0},
	},
	["calm"] = {
		["types"] = {4},
		["none"] = L["calm"],
		["target"] = L["calm_target"],
		["react"] = 0,
		["custom"] = {0},
	},
	["charge"] = {
		["types"] = {10},
		["none"] = L["charge"],
		["target"] = L["charge_target"],
		["react"] = 3,
		["custom"] = {0},
	},
	["cheer"] = {
		["types"] = {3,12},
		["none"] = L["cheer"],
		["target"] = L["cheer_target"],
		["react"] = 3,
		["custom"] = {0},
	},
	["chicken"] = {
		["types"] = {7},
		["none"] = L["chicken"],
		["target"] = L["chicken_target"],
		["react"] = 3,
		["custom"] = {0},
	},
	["chuckle"] = {
		["types"] = {3},
		["none"] = L["chuckle"],
		["target"] = L["chuckle_target"],
		["react"] = 3,
		["custom"] = {0},
	},
	["clap"] = {
		["types"] = {3,12},
		["none"] = L["clap"],
		["target"] = L["clap_target"],
		["react"] = 3,
		["custom"] = {0},
	},
	["cold"] = {
		["types"] = {13},
		["none"] = L["cold"],
		["target"] = L["cold_target"],
		["react"] = 0,
		["custom"] = {0},
	},
	["comfort"] = {
		["types"] = {8},
		["none"] = L["comfort"],
		["target"] = L["comfort_target"],
		["react"] = 0,
		["custom"] = {0},
	},
	["commend"] = {
		["types"] = {10},
		["none"] = L["commend"],
		["target"] = L["commend_target"],
		["react"] = 3,
		["custom"] = {0},
	},
	["confused"] = {
		["types"] = {11,12},
		["none"] = L["confused"],
		["target"] = L["confused_target"],
		["react"] = 1,
		["custom"] = {0},
	},
	["congrats"] = {
		["types"] = {10,12},
		["none"] = L["congrats"],
		["target"] = L["congrats_target"],
		["react"] = 3,
		["custom"] = {0},
	},
	["cough"] = {
		["types"] = {13},
		["none"] = L["cough"],
		["target"] = L["cough_target"],
		["react"] = 0,
		["custom"] = {0},
	},
	["cower"] = {
		["types"] = {11},
		["none"] = L["cower"],
		["target"] = L["cower_target"],
		["react"] = 0,
		["custom"] = {0},
	},
	["crack"] = {
		["types"] = {2},
		["none"] = L["crack"],
		["target"] = L["crack_target"],
		["react"] = 0,
		["custom"] = {0},
	},
	["cringe"] = {
		["types"] = {11},
		["none"] = L["cringe"],
		["target"] = L["cringe_target"],
		["react"] = 0,
		["custom"] = {0},
	},
	["cry"] = {
		["types"] = {5},
		["none"] = L["cry"],
		["target"] = L["cry_target"],
		["react"] = 3,
		["custom"] = {0},
	},
	["cuddle"] = {
		["types"] = {8},
		["none"] = L["cuddle"],
		["target"] = L["cuddle_target"],
		["react"] = 0,
		["custom"] = {0},
	},
	["curious"] = {
		["types"] = {12},
		["none"] = L["curious"],
		["target"] = L["curious_target"],
		["react"] = 1,
		["custom"] = {0},
	},
	["curtsey"] = {
		["types"] = {9},
		["none"] = L["curtsey"],
		["target"] = L["curtsey_target"],
		["react"] = 1,
		["custom"] = {0},
	},
	["dance"] = {
		["types"] = {3,8},
		["none"] = L["dance"],
		["target"] = L["dance_target"],
		["react"] = 1,
		["custom"] = {0},
	},
	["ding"] = {
		["types"] = {3,4},
		["none"] = L["ding"],
		["target"] = L["ding_target"],
		["react"] = 0,
		["custom"] = {0},
	},
	["doom"] = {
		["types"] = {2},
		["none"] = L["doom"],
		["target"] = L["doom_target"],
		["react"] = 0,
		["custom"] = {0},
	},
	["drink"] = {
		["types"] = {1},
		["none"] = L["drink"],
		["target"] = L["drink_target"],
		["react"] = 1,
		["custom"] = {0},
	},
	["drool"] = {
		["types"] = {13},
		["none"] = L["drool"],
		["target"] = L["drool_target"],
		["react"] = 0,
		["custom"] = {0},
	},
	["duck"] = {
		["types"] = {12},
		["none"] = L["duck"],
		["target"] = L["duck_target"],
		["react"] = 0,
		["custom"] = {0},
	},
	["eat"] = {
		["types"] = {13},
		["none"] = L["eat"],
		["target"] = L["eat_target"],
		["react"] = 1,
		["custom"] = {0},
	},
	["excited"] = {
		["types"] = {1},
		["none"] = L["excited"],
		["target"] = L["excited"],
		["react"] = 1,
		["custom"] = {0},
	},
	["eye"] = {
		["types"] = {13},
		["none"] = L["eye"],
		["target"] = L["eye_target"],
		["react"] = 0,
		["custom"] = {0},
	},
	["facepalm"] = {
		["types"] = {7,12},
		["none"] = L["facepalm"],
		["target"] = L["facepalm_target"],
		["react"] = 0,
		["custom"] = {0},
	},
	["fart"] = {
		["types"] = {7,11},
		["none"] = L["fart"],
		["target"] = L["fart_target"],
		["react"] = 0,
		["custom"] = {0},
	},
	["fidget"] = {
		["types"] = {5},
		["none"] = L["fidget"],
		["target"] = L["fidget_target"],
		["react"] = 0,
		["custom"] = {0},
	},
	["flee"] = {
		["types"] = {10},
		["none"] = L["flee"],
		["target"] = L["flee_target"],
		["react"] = 3,
		["custom"] = {0},
	},
	["flex"] = {
		["types"] = {8},
		["none"] = L["flex"],
		["target"] = L["flex_target"],
		["react"] = 1,
		["custom"] = {0},
	},
	["flirt"] = {
		["types"] = {8},
		["none"] = L["flirt"],
		["target"] = L["flirt_target"],
		["react"] = 3,
		["custom"] = {0},
	},
	["flop"] = {
		["types"] = {11},
		["none"] = L["flop"],
		["target"] = L["flop_target"],
		["react"] = 0,
		["custom"] = {0},
	},
	["followme"] = {
		["types"] = {10},
		["none"] = L["followme"],
		["target"] = L["followme_target"],
		["react"] = 3,
		["custom"] = {0},
	},
	["frown"] = {
		["types"] = {5},
		["none"] = L["frown"],
		["target"] = L["frown_target"],
		["react"] = 0,
		["custom"] = {0},
	},
	["gasp"] = {
		["types"] = {12},
		["none"] = L["gasp"],
		["target"] = L["gasp_target"],
		["react"] = 1,
		["custom"] = {0},
	},
	["gaze"] = {
		["types"] = {13},
		["none"] = L["gaze"],
		["target"] = L["gaze_target"],
		["react"] = 0,
		["custom"] = {0},
	},
	["giggle"] = {
		["types"] = {3},
		["none"] = L["giggle"],
		["target"] = L["giggle_target"],
		["react"] = 3,
		["custom"] = {0},
	},
	["glare"] = {
		["types"] = {2},
		["none"] = L["glare"],
		["target"] = L["glare_target"],
		["react"] = 0,
		["custom"] = {0},
	},
	["gloat"] = {
		["types"] = {7},
		["none"] = L["gloat"],
		["target"] = L["gloat_target"],
		["react"] = 3,
		["custom"] = {0},
	},
	["golfclap"] = {
		["types"] = {7},
		["none"] = L["golfclap"],
		["target"] = L["golfclap_target"],
		["react"] = 3,
		["custom"] = {0},
	},
	["goodbye"] = {
		["types"] = {9},
		["none"] = L["goodbye"],
		["target"] = L["goodbye_target"],
		["react"] = 3,
		["custom"] = {0},
	},
	["greet"] = {
		["types"] = {9},
		["none"] = L["greet"],
		["target"] = L["greet_target"],
		["react"] = 1,
		["custom"] = {0},
	},
	["grin"] = {
		["types"] = {3},
		["none"] = L["grin"],
		["target"] = L["grin_target"],
		["react"] = 0,
		["custom"] = {0},
	},
	["groan"] = {
		["types"] = {13},
		["none"] = L["groan"],
		["target"] = L["groan_target"],
		["react"] = 0,
		["custom"] = {0},
	},
	["grovel"] = {
		["types"] = {11},
		["none"] = L["grovel"],
		["target"] = L["grovel_target"],
		["react"] = 1,
		["custom"] = {0},
	},
	["growl"] = {
		["types"] = {2},
		["none"] = L["growl"],
		["target"] = L["growl_target"],
		["react"] = 1,
		["custom"] = {0},
	},
	["guffaw"] = {
		["types"] = {3},
		["none"] = L["guffaw"],
		["target"] = L["guffaw_target"],
		["react"] = 3,
		["custom"] = {0},
	},
	["hail"] = {
		["types"] = {9},
		["none"] = L["hail"],
		["target"] = L["hail_target"],
		["react"] = 1,
		["custom"] = {0},
	},
	["happy"] = {
		["types"] = {3},
		["none"] = L["happy"],
		["target"] = L["happy_target"],
		["react"] = 0,
		["custom"] = {0},
	},
	["healme"] = {
		["types"] = {10},
		["none"] = L["healme"],
		["target"] = L["healme_target"],
		["react"] = 3,
		["custom"] = {0},
	},
	["hello"] = {
		["types"] = {9},
		["none"] = L["hello"],
		["target"] = L["hello_target"],
		["react"] = 3,
		["custom"] = {0},
	},
	["helpme"] = {
		["types"] = {10},
		["none"] = L["helpme"],
		["target"] = L["helpme_target"],
		["react"] = 3,
		["custom"] = {0},
	},
	["highfive"] = {
		["types"] = {3,9,12},
		["none"] = L["highfive"],
		["target"] = L["highfive_target"],
		["react"] = 0,
		["custom"] = {0},
	},
	["holdhand"] = {
		["types"] = {1,5,8},
		["none"] = L["holdhand"],
		["target"] = L["holdhand_target"],
		["react"] = 0,
		["custom"] = {0},
	},
	["hug"] = {
		["types"] = {8},
		["none"] = L["hug"],
		["target"] = L["hug_target"],
		["react"] = 0,
		["custom"] = {0},
	},
	["hungry"] = {
		["types"] = {4},
		["none"] = L["hungry"],
		["target"] = L["hungry_target"],
		["react"] = 0,
		["custom"] = {0},
	},
	["incoming"] = {
		["types"] = {10},
		["none"] = L["incoming"],
		["target"] = L["incoming_target"],
		["react"] = 3,
		["custom"] = {0},
	},
	["insult"] = {
		["types"] = {7},
		["none"] = L["insult"],
		["target"] = L["insult_target"],
		["react"] = 1,
		["custom"] = {0},
	},
	["introduce"] = {
		["types"] = {9},
		["none"] = L["introduce"],
		["target"] = L["introduce_target"],
		["react"] = 0,
		["custom"] = {0},
	},
	["jk"] = {
		["types"] = {13},
		["none"] = L["jk"],
		["target"] = L["jk_target"],
		["react"] = 0,
		["custom"] = {0},
	},
	["kiss"] = {
		["types"] = {8},
		["none"] = L["kiss"],
		["target"] = L["kiss_target"],
		["react"] = 3,
		["custom"] = {0},
	},
	["kneel"] = {
		["types"] = {4},
		["none"] = L["kneel"],
		["target"] = L["kneel_target"],
		["react"] = 1,
		["custom"] = {0},
	},
	["laugh"] = {
		["types"] = {3},
		["none"] = L["laugh"],
		["target"] = L["laugh_target"],
		["react"] = 3,
		["custom"] = {0},
	},
	["lavish"] = {
		["types"] = {1},
		["none"] = L["lavish"],
		["target"] = L["lavish_target"],
		["react"] = 0,
		["custom"] = {0},
	},
	["lay"] = {
		["types"] = {4},
		["none"] = L["lay"],
		["target"] = L["lay_target"],
		["react"] = 1,
		["custom"] = {0},
	},
	["lick"] = {
		["types"] = {8},
		["none"] = L["lick"],
		["target"] = L["lick_target"],
		["react"] = 0,
		["custom"] = {0},
	},
	["listen"] = {
		["types"] = {1},
		["none"] = L["listen"],
		["target"] = L["listen_target"],
		["react"] = 0,
		["custom"] = {0},
	},
	["lost"] = {
		["types"] = {5},
		["none"] = L["lost"],
		["target"] = L["lost_target"],
		["react"] = 1,
		["custom"] = {0},
	},
	["love"] = {
		["types"] = {8},
		["none"] = L["love"],
		["target"] = L["love_target"],
		["react"] = 0,
		["custom"] = {0},
	},
	["massage"] = {
		["types"] = {8},
		["none"] = L["massage"],
		["target"] = L["massage_target"],
		["react"] = 0,
		["custom"] = {0},
	},
	["moan"] = {
		["types"] = {8},
		["none"] = L["moan"],
		["target"] = L["moan_target"],
		["react"] = 0,
		["custom"] = {0},
	},
	["mock"] = {
		["types"] = {5},
		["none"] = L["mock"],
		["target"] = L["mock_target"],
		["react"] = 0,
		["custom"] = {0},
	},
	["moo"] = {
		["types"] = {9},
		["none"] = L["moo"],
		["target"] = L["moo_target"],
		["react"] = 2,
		["custom"] = {0},
	},
	["moon"] = {
		["types"] = {7},
		["none"] = L["moon"],
		["target"] = L["moon_target"],
		["react"] = 0,
		["custom"] = {0},
	},
	["mourn"] = {
		["types"] = {13},
		["none"] = L["mourn"],
		["target"] = L["mourn_target"],
		["react"] = 3,
		["custom"] = {0},
	},
	["no"] = {
		["types"] = {4},
		["none"] = L["no"],
		["target"] = L["no_target"],
		["react"] = 3,
		["custom"] = {0},
	},
	["nod"] = {
		["types"] = {4},
		["none"] = L["nod"],
		["target"] = L["nod_target"],
		["react"] = 3,
		["custom"] = {0},
	},
	["nosepick"] = {
		["types"] = {13},
		["none"] = L["nosepick"],
		["target"] = L["nosepick_target"],
		["react"] = 0,
		["custom"] = {0},
	},
	["oom"] = {
		["types"] = {10},
		["none"] = L["oom"],
		["target"] = L["oom_target"],
		["react"] = 3,
		["custom"] = {0},
	},
	["openfire"] = {
		["types"] = {10},
		["none"] = L["openfire"],
		["target"] = L["openfire_target"],
		["react"] = 3,
		["custom"] = {0},
	},
	["panic"] = {
		["types"] = {11},
		["none"] = L["panic"],
		["target"] = L["panic_target"],
		["react"] = 0,
		["custom"] = {0},
	},
	["pat"] = {
		["types"] = {8},
		["none"] = L["pat"],
		["target"] = L["pat_target"],
		["react"] = 0,
		["custom"] = {0},
	},
	["peer"] = {
		["types"] = {4},
		["none"] = L["peer"],
		["target"] = L["peer_target"],
		["react"] = 0,
		["custom"] = {0},
	},
	["pity"] = {
		["types"] = {7},
		["none"] = L["pity"],
		["target"] = L["pity_target"],
		["react"] = 0,
		["custom"] = {0},
	},
	["plead"] = {
		["types"] = {11},
		["none"] = L["plead"],
		["target"] = L["plead_target"],
		["react"] = 1,
		["custom"] = {0},
	},
	["point"] = {
		["types"] = {10},
		["none"] = L["point"],
		["target"] = L["point_target"],
		["react"] = 1,
		["custom"] = {0},
	},
	["poke"] = {
		["types"] = {4},
		["none"] = L["poke"],
		["target"] = L["poke_target"],
		["react"] = 0,
		["custom"] = {0},
	},
	["ponder"] = {
		["types"] = {12},
		["none"] = L["ponder"],
		["target"] = L["ponder_target"],
		["react"] = 1,
		["custom"] = {0},
	},
	["pounce"] = {
		["types"] = {8},
		["none"] = L["pounce"],
		["target"] = L["pounce_target"],
		["react"] = 0,
		["custom"] = {0},
	},
	["pray"] = {
		["types"] = {4},
		["none"] = L["pray"],
		["target"] = L["pray_target"],
		["react"] = 1,
		["custom"] = {0},
	},
	["purr"] = {
		["types"] = {8},
		["none"] = L["purr"],
		["target"] = L["purr_target"],
		["react"] = 0,
		["custom"] = {0},
	},
	["puzzled"] = {
		["types"] = {12},
		["none"] = L["puzzled"],
		["target"] = L["puzzled_target"],
		["react"] = 1,
		["custom"] = {0},
	},
	["question"] = {
		["types"] = {13},
		["none"] = L["question"],
		["target"] = L["question_target"],
		["react"] = 1,
		["custom"] = {0},
	},
	["raise"] = {
		["types"] = {13},
		["none"] = L["raise"],
		["target"] = L["raise_target"],
		["react"] = 0,
		["custom"] = {0},
	},
	["rasp"] = {
		["types"] = {7},
		["none"] = L["rasp"],
		["target"] = L["rasp_target"],
		["react"] = 3,
		["custom"] = {0},
	},
	["ready"] = {
		["types"] = {10},
		["none"] = L["ready"],
		["target"] = L["ready_target"],
		["react"] = 0,
		["custom"] = {0},
	},
	["rear"] = {
		["types"] = {7},
		["none"] = L["rear"],
		["target"] = L["rear_target"],
		["react"] = 0,
		["custom"] = {0},
	},
	["regret"] = {
		["types"] = {2,5,7,10,12},
		["none"] = L["regret"],
		["target"] = L["regret_target"],
		["react"] = 0,
		["custom"] = {0},
	},
	["roar"] = {
		["types"] = {2},
		["none"] = L["roar"],
		["target"] = L["roar_target"],
		["react"] = 1,
		["custom"] = {0},
	},
	["rofl"] = {
		["types"] = {3},
		["none"] = L["rofl"],
		["target"] = L["rofl_target"],
		["react"] = 3,
		["custom"] = {0},
	},
	["rolleyes"] = {
		["types"] = {4,12},
		["none"] = L["rolleyes"],
		["target"] = L["rolleyes_target"],
		["react"] = 3,
		["custom"] = {0},
	},
	["rude"] = {
		["types"] = {7},
		["none"] = L["rude"],
		["target"] = L["rude_target"],
		["react"] = 1,
		["custom"] = {0},
	},
	["salute"] = {
		["types"] = {1},
		["none"] = L["salute"],
		["target"] = L["salute_target"],
		["react"] = 1,
		["custom"] = {0},
	},
	["scared"] = {
		["types"] = {11},
		["none"] = L["scared"],
		["target"] = L["scared_target"],
		["react"] = 0,
		["custom"] = {0},
	},
	["scratch"] = {
		["types"] = {13},
		["none"] = L["scratch"],
		["target"] = L["scratch_target"],
		["react"] = 0,
		["custom"] = {0},
	},
	["sexy"] = {
		["types"] = {8},
		["none"] = L["sexy"],
		["target"] = L["sexy"],
		["react"] = 0,
		["custom"] = {0},
	},
	["shimmy"] = {
		["types"] = {13},
		["none"] = L["shimmy"],
		["target"] = L["shimmy_target"],
		["react"] = 0,
		["custom"] = {0},
	},
	["shiver"] = {
		["types"] = {13},
		["none"] = L["shiver"],
		["target"] = L["shiver_target"],
		["react"] = 0,
		["custom"] = {0},
	},
	["shoo"] = {
		["types"] = {7},
		["none"] = L["shoo"],
		["target"] = L["shoo_target"],
		["react"] = 0,
		["custom"] = {0},
	},
	["shrug"] = {
		["types"] = {12},
		["none"] = L["shrug"],
		["target"] = L["shrug_target"],
		["react"] = 1,
		["custom"] = {0},
	},
	["shy"] = {
		["types"] = {8},
		["none"] = L["shy"],
		["target"] = L["shy_target"],
		["react"] = 1,
		["custom"] = {0},
	},
	["sigh"] = {
		["types"] = {5},
		["none"] = L["sigh"],
		["target"] = L["sigh_target"],
		["react"] = 2,
		["custom"] = {0},
	},
	["silly"] = {
		["types"] = {3},
		["none"] = L["silly"],
		["target"] = L["silly_target"],
		["react"] = 3,
		["custom"] = {0},
	},
	["slap"] = {
		["types"] = {7},
		["none"] = L["slap"],
		["target"] = L["slap_target"],
		["react"] = 0,
		["custom"] = {0},
	},
	["sleep"] = {
		["types"] = {13},
		["none"] = L["sleep"],
		["target"] = L["sleep_target"],
		["react"] = 1,
		["custom"] = {0},
	},
	["smell"] = {
		["types"] = {7},
		["none"] = L["smell"],
		["target"] = L["smell_target"],
		["react"] = 0,
		["custom"] = {0},
	},
	["smile"] = {
		["types"] = {3},
		["none"] = L["smile"],
		["target"] = L["smile_target"],
		["react"] = 0,
		["custom"] = {0},
	},
	["smirk"] = {
		["types"] = {3},
		["none"] = L["smirk"],
		["target"] = L["smirk_target"],
		["react"] = 0,
		["custom"] = {0},
	},
	["snarl"] = {
		["types"] = {2},
		["none"] = L["snarl"],
		["target"] = L["snarl_target"],
		["react"] = 0,
		["custom"] = {0},
	},
	["snicker"] = {
		["types"] = {3},
		["none"] = L["snicker"],
		["target"] = L["snicker_target"],
		["react"] = 0,
		["custom"] = {0},
	},
	["sniff"] = {
		["types"] = {12},
		["none"] = L["sniff"],
		["target"] = L["sniff_target"],
		["react"] = 0,
		["custom"] = {0},
	},
	["snub"] = {
		["types"] = {2},
		["none"] = L["snub"],
		["target"] = L["snub_target"],
		["react"] = 0,
		["custom"] = {0},
	},
	["soothe"] = {
		["types"] = {8},
		["none"] = L["soothe"],
		["target"] = L["soothe_target"],
		["react"] = 0,
		["custom"] = {0},
	},
	["spit"] = {
		["types"] = {7},
		["none"] = L["spit"],
		["target"] = L["spit_target"],
		["react"] = 0,
		["custom"] = {0},
	},
	["stare"] = {
		["types"] = {2},
		["none"] = L["stare"],
		["target"] = L["stare_target"],
		["react"] = 0,
		["custom"] = {0},
	},
	["surprised"] = {
		["types"] = {12},
		["none"] = L["surprised"],
		["target"] = L["surprised_target"],
		["react"] = 0,
		["custom"] = {0},
	},
	["surrender"] = {
		["types"] = {5},
		["none"] = L["surrender"],
		["target"] = L["surrender_target"],
		["react"] = 1,
		["custom"] = {0},
	},
	["talk"] = {
		["types"] = {1,9,12,13},
		["none"] = L["talk"],
		["target"] = L["talk_target"],
		["react"] = 1,
		["custom"] = {0},
	},
	["tap"] = {
		["types"] = {12},
		["none"] = L["tap"],
		["target"] = L["tap_target"],
		["react"] = 0,
		["custom"] = {0},
	},
	["taunt"] = {
		["types"] = {7},
		["none"] = L["taunt"],
		["target"] = L["taunt_target"],
		["react"] = 0,
		["custom"] = {0},
	},
	["tease"] = {
		["types"] = {8},
		["none"] = L["tease"],
		["target"] = L["tease_target"],
		["react"] = 0,
		["custom"] = {0},
	},
	["thank"] = {
		["types"] = {1},
		["none"] = L["thank"],
		["target"] = L["thank_target"],
		["react"] = 0,
		["custom"] = {0},
	},
	["think"] = {
		["types"] = {4,12},
		["none"] = L["think"],
		["target"] = L["think_target"],
		["react"] = 0,
		["custom"] = {0},
	},
	["thirsty"] = {
		["types"] = {13},
		["none"] = L["thirsty"],
		["target"] = L["thirsty_target"],
		["react"] = 0,
		["custom"] = {0},
	},
	["tickle"] = {
		["types"] = {8},
		["none"] = L["tickle"],
		["target"] = L["tickle_target"],
		["react"] = 0,
		["custom"] = {0},
	},
	["tired"] = {
		["types"] = {13},
		["none"] = L["tired"],
		["target"] = L["tired_target"],
		["react"] = 0,
		["custom"] = {0},
	},
	["train"] = {
		["types"] = {12,13},
		["none"] = L["train"],
		["target"] = L["train_target"],
		["react"] = 3,
		["custom"] = {0},
	},
	["veto"] = {
		["types"] = {13},
		["none"] = L["veto"],
		["target"] = L["veto_target"],
		["react"] = 0,
		["custom"] = {0},
	},
	["victory"] = {
		["types"] = {12},
		["none"] = L["victory"],
		["target"] = L["victory_target"],
		["react"] = 1,
		["custom"] = {0},
	},
	["violin"] = {
		["types"] = {7},
		["none"] = L["violin"],
		["target"] = L["violin_target"],
		["react"] = 3,
		["custom"] = {0},
	},
	["wait"] = {
		["types"] = {10},
		["none"] = L["wait"],
		["target"] = L["wait_target"],
		["react"] = 3,
		["custom"] = {0},
	},
	["wave"] = {
		["types"] = {9},
		["none"] = L["wave"],
		["target"] = L["wave_target"],
		["react"] = 0,
		["custom"] = {0},
	},
	["welcome"] = {
		["types"] = {9},
		["none"] = L["welcome"],
		["target"] = L["welcome_target"],
		["react"] = 3,
		["custom"] = {0},
	},
	["whine"] = {
		["types"] = {11},
		["none"] = L["whine"],
		["target"] = L["whine_target"],
		["react"] = 0,
		["custom"] = {0},
	},
	["whistle"] = {
		["types"] = {13},
		["none"] = L["whistle"],
		["target"] = L["whistle_target"],
		["react"] = 2,
		["custom"] = {0},
	},
	["whoa"] = {
		["types"] = {4,12},
		["none"] = L["whoa"],
		["target"] = L["whoa_target"],
		["react"] = 3,
		["custom"] = {0},
	},
	["wink"] = {
		["types"] = {8},
		["none"] = L["wink"],
		["target"] = L["wink_target"],
		["react"] = 0,
		["custom"] = {0},
	},
	["work"] = {
		["types"] = {13},
		["none"] = L["work"],
		["target"] = L["work_target"],
		["react"] = 0,
		["custom"] = {0},
	},
	["yawn"] = {
		["types"] = {13},
		["none"] = L["yawn"],
		["target"] = L["yawn_target"],
		["react"] = 2,
		["custom"] = {0},
	},
	["yw"] = {
		["types"] = {1,12},
		["none"] = L["yw"],
		["target"] = L["yw_target"],
		["react"] = 3,
		["custom"] = {0},
	},
}


