--Don't worry about this
local addon, ns = ...
local Version = GetAddOnMetadata(addon, "Version")

--Cache Lua / WoW API
local format = string.format
local GetCVarBool = GetCVarBool
local ReloadUI = ReloadUI
local StopMusic = StopMusic

-- These are things we do not cache
-- GLOBALS: PluginInstallStepComplete, PluginInstallFrame

--Change this line and use a unique name for your plugin.
local MyPluginName = "Serenity Gaming 2.0 ElvUI Layout"

--Create references to ElvUI internals
local E, L, V, P, G = unpack(ElvUI)

--Create reference to LibElvUIPlugin
local EP = LibStub("LibElvUIPlugin-1.0")

--Create a new ElvUI module so ElvUI can handle initialization when ready
local mod = E:NewModule(MyPluginName, "AceHook-3.0", "AceEvent-3.0", "AceTimer-3.0");

--This function will hold your layout settings
local function SetupLayout(layout)
	--[[
	--	PUT YOUR EXPORTED PROFILE/SETTINGS BELOW HERE
	--]]
E.db["databars"]["reputation"]["enable"] = true
E.db["currentTutorial"] = 13
E.db["general"]["backdropfadecolor"]["a"] = 0.75452540814877
E.db["general"]["backdropfadecolor"]["b"] = 0.043137254901961
E.db["general"]["backdropfadecolor"]["g"] = 0.070588235294118
E.db["general"]["backdropfadecolor"]["r"] = 0
E.db["general"]["valuecolor"]["b"] = 0.59
E.db["general"]["valuecolor"]["g"] = 1
E.db["general"]["valuecolor"]["r"] = 0
E.db["general"]["bordercolor"]["b"] = 0
E.db["general"]["bordercolor"]["g"] = 0
E.db["general"]["bordercolor"]["r"] = 0
E.db["general"]["backdropcolor"]["b"] = 0.058823529411765
E.db["general"]["backdropcolor"]["g"] = 0.10196078431373
E.db["general"]["backdropcolor"]["r"] = 0
E.db["general"]["minimap"]["icons"]["difficulty"]["position"] = "TOPRIGHT"
E.db["bags"]["itemLevel"] = false
E.db["hideTutorial"] = true
E.db["layoutSet"] = "healer"
E.db["movers"]["RaidMarkerBarAnchor"] = "BOTTOM,ElvUIParent,BOTTOM,0,100"
E.db["movers"]["ElvUF_PlayerCastbarMover"] = "BOTTOM,ElvUIParent,BOTTOM,0,401"
E.db["movers"]["ElvUF_RaidMover"] = "BOTTOMRIGHT,ElvUIParent,BOTTOMLEFT,400,448"
E.db["movers"]["ElvUF_FocusTargetMover"] = "BOTTOM,ElvUIParent,BOTTOM,309,475"
E.db["movers"]["GMMover"] = "TOPLEFT,ElvUIParent,TOPLEFT,256,-4"
E.db["movers"]["BuffsMover"] = "TOPRIGHT,ElvUIParent,TOPRIGHT,-228,-25"
E.db["movers"]["LocationMover"] = "TOP,ElvUIParent,TOP,0,0"
E.db["movers"]["BossButton"] = "BOTTOM,ElvUIParent,BOTTOM,0,133"
E.db["movers"]["LootFrameMover"] = "TOPLEFT,ElvUIParent,TOPLEFT,347,-121"
E.db["movers"]["ZoneAbility"] = "BOTTOM,ElvUIParent,BOTTOM,0,132"
E.db["movers"]["ElvUF_RaidpetMover"] = "TOPLEFT,ElvUIParent,BOTTOMLEFT,4,736"
E.db["movers"]["ElvUF_FocusMover"] = "BOTTOM,ElvUIParent,BOTTOM,310,432"
E.db["movers"]["MicrobarMover"] = "BOTTOMLEFT,ElvUIParent,BOTTOMLEFT,481,100"
E.db["movers"]["VehicleSeatMover"] = "TOPRIGHT,ElvUIParent,TOPRIGHT,-4,-257"
E.db["movers"]["ExperienceBarMover"] = "BOTTOMLEFT,ElvUIParent,BOTTOMLEFT,424,4"
E.db["movers"]["ElvUF_TargetMover"] = "BOTTOM,ElvUIParent,BOTTOM,304,147"
E.db["movers"]["ElvUF_Raid40Mover"] = "BOTTOMRIGHT,ElvUIParent,BOTTOMLEFT,400,447"
E.db["movers"]["ElvAB_1"] = "BOTTOMLEFT,ElvUIParent,BOTTOMLEFT,488,27"
E.db["movers"]["ElvAB_2"] = "BOTTOM,ElvUIParent,BOTTOM,163,25"
E.db["movers"]["ElvAB_4"] = "BOTTOMRIGHT,ElvUIParent,BOTTOMRIGHT,-4,183"
E.db["movers"]["ElvUF_TargetTargetMover"] = "BOTTOMRIGHT,ElvUIParent,BOTTOMRIGHT,-369,261"
E.db["movers"]["ElvAB_3"] = "BOTTOMRIGHT,ElvUIParent,BOTTOMRIGHT,-486,25"
E.db["movers"]["ReputationBarMover"] = "BOTTOMLEFT,ElvUIParent,BOTTOMLEFT,415,4"
E.db["movers"]["ElvUF_PlayerMover"] = "BOTTOM,ElvUIParent,BOTTOM,-262,148"
E.db["movers"]["TalkingHeadFrameMover"] = "BOTTOM,ElvUIParent,BOTTOM,1,265"
E.db["movers"]["RightChatMover"] = "BOTTOMRIGHT,ElvUIParent,BOTTOMRIGHT,-4,4"
E.db["movers"]["PetAB"] = "BOTTOMRIGHT,ElvUIParent,BOTTOMRIGHT,-4,223"
E.db["movers"]["BNETMover"] = "TOPLEFT,ElvUIParent,TOPLEFT,4,-2"
E.db["movers"]["ShiftAB"] = "TOPLEFT,ElvUIParent,BOTTOMLEFT,1104,128"
E.db["movers"]["ElvUF_PetMover"] = "BOTTOMLEFT,ElvUIParent,BOTTOMLEFT,428,249"
E.db["movers"]["ElvAB_6"] = "TOPLEFT,ElvUIParent,TOPLEFT,468,-392"
E.db["movers"]["ArenaHeaderMover"] = "TOPLEFT,ElvUIParent,TOPLEFT,4,-64"
E.db["movers"]["TooltipMover"] = "BOTTOMRIGHT,ElvUIParent,BOTTOMRIGHT,-4,261"
E.db["movers"]["ElvUF_TankMover"] = "TOPLEFT,ElvUIParent,BOTTOMLEFT,407,683"
E.db["movers"]["BossHeaderMover"] = "TOPLEFT,ElvUIParent,TOPLEFT,4,-69"
E.db["movers"]["TotemBarMover"] = "BOTTOMLEFT,ElvUIParent,BOTTOMLEFT,434,4"
E.db["movers"]["ElvAB_5"] = "BOTTOM,ElvUIParent,BOTTOM,-161,27"
E.db["movers"]["ElvUF_PartyMover"] = "BOTTOMRIGHT,ElvUIParent,BOTTOMLEFT,404,447"
E.db["movers"]["AlertFrameMover"] = "TOP,ElvUIParent,TOP,0,-30"
E.db["movers"]["DebuffsMover"] = "TOPRIGHT,ElvUIParent,TOPRIGHT,-228,-171"
E.db["movers"]["ElvUF_AssistMover"] = "TOPLEFT,ElvUIParent,BOTTOMLEFT,407,618"
E.db["unitframe"]["statusbar"] = "ElvUI Gloss"
E.db["unitframe"]["colors"]["auraBarBuff"]["b"] = 0.04
E.db["unitframe"]["colors"]["auraBarBuff"]["g"] = 0.49
E.db["unitframe"]["colors"]["auraBarBuff"]["r"] = 1
E.db["unitframe"]["colors"]["healthclass"] = true
E.db["unitframe"]["colors"]["castClassColor"] = true
E.db["unitframe"]["units"]["focustarget"]["enable"] = true
E.db["unitframe"]["units"]["party"]["debuffs"]["xOffset"] = -4
E.db["unitframe"]["units"]["party"]["debuffs"]["sizeOverride"] = 16
E.db["unitframe"]["units"]["party"]["debuffs"]["anchorPoint"] = "TOPRIGHT"
E.db["unitframe"]["units"]["party"]["debuffs"]["yOffset"] = -7
E.db["unitframe"]["units"]["party"]["growthDirection"] = "LEFT_UP"
E.db["unitframe"]["units"]["party"]["groupBy"] = "ROLE"
E.db["unitframe"]["units"]["party"]["raidWideSorting"] = true
E.db["unitframe"]["units"]["party"]["roleIcon"]["position"] = "BOTTOMRIGHT"
E.db["unitframe"]["units"]["party"]["power"]["text_format"] = ""
E.db["unitframe"]["units"]["party"]["healPrediction"] = true
E.db["unitframe"]["units"]["party"]["health"]["text_format"] = "[healthcolor][health:deficit]"
E.db["unitframe"]["units"]["party"]["health"]["frequentUpdates"] = true
E.db["unitframe"]["units"]["party"]["health"]["position"] = "BOTTOM"
E.db["unitframe"]["units"]["party"]["width"] = 80
E.db["unitframe"]["units"]["party"]["sortDir"] = "DESC"
E.db["unitframe"]["units"]["party"]["name"]["text_format"] = "[namecolor][name:short]"
E.db["unitframe"]["units"]["party"]["name"]["position"] = "TOP"
E.db["unitframe"]["units"]["party"]["verticalSpacing"] = 0
E.db["unitframe"]["units"]["party"]["height"] = 45
E.db["unitframe"]["units"]["party"]["buffs"]["sizeOverride"] = 22
E.db["unitframe"]["units"]["party"]["buffs"]["clickThrough"] = true
E.db["unitframe"]["units"]["party"]["buffs"]["xOffset"] = 50
E.db["unitframe"]["units"]["party"]["buffs"]["perrow"] = 1
E.db["unitframe"]["units"]["party"]["buffs"]["enable"] = true
E.db["unitframe"]["units"]["party"]["buffs"]["yOffset"] = -6
E.db["unitframe"]["units"]["raid40"]["horizontalSpacing"] = -1
E.db["unitframe"]["units"]["raid40"]["growthDirection"] = "LEFT_UP"
E.db["unitframe"]["units"]["raid40"]["healPrediction"] = true
E.db["unitframe"]["units"]["raid40"]["health"]["frequentUpdates"] = true
E.db["unitframe"]["units"]["raid40"]["height"] = 30
E.db["unitframe"]["units"]["raid40"]["verticalSpacing"] = -1
E.db["unitframe"]["units"]["raid"]["horizontalSpacing"] = -1
E.db["unitframe"]["units"]["raid"]["debuffs"]["anchorPoint"] = "TOPRIGHT"
E.db["unitframe"]["units"]["raid"]["debuffs"]["sizeOverride"] = 16
E.db["unitframe"]["units"]["raid"]["debuffs"]["xOffset"] = -4
E.db["unitframe"]["units"]["raid"]["debuffs"]["enable"] = true
E.db["unitframe"]["units"]["raid"]["debuffs"]["yOffset"] = -7
E.db["unitframe"]["units"]["raid"]["rdebuffs"]["enable"] = false
E.db["unitframe"]["units"]["raid"]["growthDirection"] = "LEFT_UP"
E.db["unitframe"]["units"]["raid"]["raidWideSorting"] = true
E.db["unitframe"]["units"]["raid"]["health"]["frequentUpdates"] = true
E.db["unitframe"]["units"]["raid"]["healPrediction"] = true
E.db["unitframe"]["units"]["raid"]["groupBy"] = "ROLE"
E.db["unitframe"]["units"]["raid"]["sortDir"] = "DESC"
E.db["unitframe"]["units"]["raid"]["buffs"]["sizeOverride"] = 22
E.db["unitframe"]["units"]["raid"]["buffs"]["clickThrough"] = true
E.db["unitframe"]["units"]["raid"]["buffs"]["xOffset"] = 50
E.db["unitframe"]["units"]["raid"]["buffs"]["perrow"] = 1
E.db["unitframe"]["units"]["raid"]["buffs"]["enable"] = true
E.db["unitframe"]["units"]["raid"]["buffs"]["yOffset"] = -6
E.db["unitframe"]["units"]["raid"]["startFromCenter"] = false
E.db["unitframe"]["units"]["raid"]["height"] = 45
E.db["unitframe"]["units"]["raid"]["verticalSpacing"] = -1
E.db["unitframe"]["units"]["raid"]["invertGroupingOrder"] = true
E.db["unitframe"]["units"]["player"]["castbar"]["height"] = 28
E.db["unitframe"]["units"]["player"]["castbar"]["width"] = 406
E.db["unitframe"]["units"]["player"]["castbar"]["insideInfoPanel"] = false
E.db["datatexts"]["friends"]["hideWTCG"] = true
E.db["datatexts"]["friends"]["hideApp"] = true
E.db["datatexts"]["friends"]["hideS1"] = true
E.db["datatexts"]["friends"]["hideHero"] = true
E.db["datatexts"]["friends"]["hideD3"] = true
E.db["datatexts"]["friends"]["hideBSAp"] = true
E.db["datatexts"]["friends"]["hidePro"] = true
E.db["datatexts"]["friends"]["hideS2"] = true
E.db["datatexts"]["friends"]["hideDST2"] = true
E.db["actionbar"]["bar3"]["backdrop"] = true
E.db["actionbar"]["bar3"]["buttons"] = 12
E.db["actionbar"]["bar2"]["buttonsPerRow"] = 6
E.db["actionbar"]["bar2"]["backdrop"] = true
E.db["actionbar"]["bar2"]["enabled"] = true
E.db["actionbar"]["bar1"]["buttonsPerRow"] = 6
E.db["actionbar"]["bar1"]["backdrop"] = true
E.db["actionbar"]["bar5"]["backdrop"] = true
E.db["actionbar"]["bar5"]["buttons"] = 12
E.db["actionbar"]["barPet"]["point"] = "BOTTOMLEFT"
E.db["actionbar"]["barPet"]["buttonsPerRow"] = 10
E.db["actionbar"]["bar6"]["buttonsPerRow"] = 4
E.db["actionbar"]["bar6"]["backdrop"] = true
E.db["actionbar"]["microbar"]["enabled"] = true
E.db["actionbar"]["bar4"]["buttonsPerRow"] = 12
E.db["watchframe"]["city"] = "NONE"
E.db["watchframe"]["party"] = "NONE"




	--[[
		--If you want to modify the base layout according to
		-- certain conditions then this is how you could do it
		if layout == "tank" then
			--Make some changes to the layout posted above
		elseif layout == "dps" then
			--Make some other changes
		elseif layout == "healer" then
			--Make some different changes
		end
	--]]


	--[[
	--	This section at the bottom is just to update ElvUI and display a message
	--]]
	--Update ElvUI
	E:UpdateAll(true)
	--Show message about layout being set
	PluginInstallStepComplete.message = "Layout Set"
	PluginInstallStepComplete:Show()
end

--This function is executed when you press "Skip Process" or "Finished" in the installer.
local function InstallComplete()
	if GetCVarBool("Sound_EnableMusic") then
		StopMusic()
	end

	--Set a variable tracking the version of the addon when layout was installed
	E.db[MyPluginName].install_version = Version

	ReloadUI()
end

--This is the data we pass on to the ElvUI Plugin Installer.
--The Plugin Installer is reponsible for displaying the install guide for this layout.
local InstallerData = {
	Title = format("|cff4beb2c%s %s|r", MyPluginName, "Installation"),
	Name = MyPluginName,
	tutorialImage = "Interface\\AddOns\\ElvUI_SG20\\logo.tga", --If you have a logo you want to use, otherwise it uses the one from ElvUI
	Pages = {
		[1] = function()
			PluginInstallFrame.SubTitle:SetFormattedText("Welcome to the installation for %s.", MyPluginName)
			PluginInstallFrame.Desc1:SetText("This installation process will guide you through a few steps and apply settings to your current ElvUI profile. If you want to be able to go back to your original settings then create a new profile before going through this installation process.")
			PluginInstallFrame.Desc2:SetText("Please press the continue button if you wish to go through the installation process, otherwise click the 'Skip Process' button.")
			PluginInstallFrame.Option1:Show()
			PluginInstallFrame.Option1:SetScript("OnClick", InstallComplete)
			PluginInstallFrame.Option1:SetText("Skip Process")
		end,
		[2] = function()
			PluginInstallFrame.SubTitle:SetText("Layouts")
			PluginInstallFrame.Desc1:SetText("These are the layouts that are available. Please click a button below to apply the layout of your choosing.")
			PluginInstallFrame.Desc2:SetText("Importance: |cff07D400High|r")
			PluginInstallFrame.Option1:Show()
			PluginInstallFrame.Option1:SetScript("OnClick", function() SetupLayout("SG 2.0") end)
			PluginInstallFrame.Option1:SetText("SG 2.0")
		end,
		[3] = function()
			PluginInstallFrame.SubTitle:SetText("Installation Complete")
			PluginInstallFrame.Desc1:SetText("You have completed the installation process.")
			PluginInstallFrame.Desc2:SetText("Please click the button below in order to finalize the process and automatically reload your UI.")
			PluginInstallFrame.Option1:Show()
			PluginInstallFrame.Option1:SetScript("OnClick", InstallComplete)
			PluginInstallFrame.Option1:SetText("Finished")
		end,
	},
	StepTitles = {
		[1] = "Welcome",
		[2] = "Layouts",
		[3] = "Installation Complete",
	},
	StepTitlesColor = {1, 1, 1},
	StepTitlesColorSelected = {0, 179/255, 1},
	StepTitleWidth = 200,
	StepTitleButtonWidth = 180,
	StepTitleTextJustification = "RIGHT",
}

--This function holds the options table which will be inserted into the ElvUI config
local function InsertOptions()
	E.Options.args.MyPluginName = {
		order = 100,
		type = "group",
		name = format("|cff4beb2c%s|r", MyPluginName),
		args = {
			header1 = {
				order = 1,
				type = "header",
				name = MyPluginName,
			},
			description1 = {
				order = 2,
				type = "description",
				name = format("%s is a layout for ElvUI.", MyPluginName),
			},
			spacer1 = {
				order = 3,
				type = "description",
				name = "\n\n\n",
			},
			header2 = {
				order = 4,
				type = "header",
				name = "Installation",
			},
			description2 = {
				order = 5,
				type = "description",
				name = "The installation guide should pop up automatically after you have completed the ElvUI installation. If you wish to re-run the installation process for this layout then please click the button below.",
			},
			spacer2 = {
				order = 6,
				type = "description",
				name = "",
			},
			install = {
				order = 7,
				type = "execute",
				name = "Install",
				desc = "Run the installation process.",
				func = function() E:GetModule("PluginInstaller"):Queue(InstallerData); E:ToggleConfig(); end,
			},
		},
	}
end

--Create a unique table for our plugin
P[MyPluginName] = {}

--This function will handle initialization of the addon
function mod:Initialize()
	--Initiate installation process if ElvUI install is complete and our plugin install has not yet been run
	if E.private.install_complete and E.db[MyPluginName].install_version == nil then
		E:GetModule("PluginInstaller"):Queue(InstallerData)
	end
	
	--Insert our options table when ElvUI config is loaded
	EP:RegisterPlugin(addon, InsertOptions)
end

--This function will get called by ElvUI automatically when it is ready to initialize modules
local function CallbackInitialize()
	mod:Initialize()
end

--Register module with callback so it gets initialized when ready
E:RegisterModule(MyPluginName, CallbackInitialize)