----Broker Manager for Farmed
local menuIcon={}
local menuRow1={}
local menuRow2={}
local menuColor={}


if not LibStub then return end

local LDB = LibStub("LibDataBroker-1.1")
local tip = LibStub('LibQTip-1.0')
local qcnt=0


dungstat_Broker = LibStub("AceAddon-3.0"):NewAddon("Broker_dungstat", "AceConsole-3.0", "AceTimer-3.0", "AceEvent-3.0")

local DB_NeedsBreak=true; --Hold the next line for ading to the menu

local function DungStatDBTooltip_ClickLine(line, setName, button)
	if (setName=="Show") then dungstat_show_set(true) end
	if (setName=="Hide") then dungstat_show_set(false) end

	
	dungstat_Broker.tooltip:Hide();
	
end


local function DungStatDBTooltip_Show(frame)
	DungStatDBTooltip_Init();
	dungstat_Broker.tooltip:SmartAnchorTo(frame)
	dungstat_Broker.tooltip:SetAutoHideDelay(1, frame)
	dungstat_Broker.tooltip:Show()
end

function DungStatDBTooltip_Init()
	if (dungstat_Broker==nil) then 
			return;
	end
	
	DB_NeedsBreak=true

	if tip:IsAcquired("Broker_dungstat") then tip:Release(dungstat_Broker.tooltip) end
	dungstat_Broker.tooltip = tip:Acquire("Broker_dungstat", 2, "LEFT", "RIGHT")
	
	--write Menu Items
		--dungstat_Broker.tooltip:AddLine("|TInterface\\Icons\\INV_Misc_Bag_11.blp:16|t"..farmed_lang_bkr_open, "","10")
		--dungstat_Broker.tooltip:SetLineScript(1, "OnMouseDown", DungStatDBTooltip_ClickLine, "Open")
		if (dungstats_options.hideWindow==false) then
			dungstat_Broker.tooltip:AddLine("|TInterface\\Icons\\INV_Misc_Wrench_02.blp:16|t Hide Status Window", "")
			dungstat_Broker.tooltip:SetLineScript(1, "OnMouseDown", DungStatDBTooltip_ClickLine, "Hide")
		else
			dungstat_Broker.tooltip:AddLine("|TInterface\\Icons\\INV_Misc_Wrench_02.blp:16|t Show Status Window", "")
			dungstat_Broker.tooltip:SetLineScript(1, "OnMouseDown", DungStatDBTooltip_ClickLine, "Show")
		end

		--dungstat_Broker.tooltip:AddSeparator(1, .5, .5, .5, 1)
		
		maxr=#menuRow1;
		
			local row =0
		local col =0
		
		 for n = 1,maxr do 
			if menuRow1[n]=="<br/>" then --- line/section break
				dungstat_Broker.tooltip:AddSeparator(1, .5, .5, .5, 1)
			elseif menuIcon[n]=="header" then
				row, col= dungstat_Broker.tooltip:AddHeader(menuRow1[n], menuRow2[n]);
			elseif menuIcon[n]=="" then
				row, col= dungstat_Broker.tooltip:AddLine(menuRow1[n], menuRow2[n]);
			else
				row, col= dungstat_Broker.tooltip:AddLine("|TInterface\\Icons\\"..menuIcon[n]..".blp:16|t "..menuRow1[n], menuRow2[n]);
			end
			
			if menuRow1[n]~="<br/>" then 
				 local r,g,b=DungStatsDBGetBackCol(menuColor[n]);
				 dungstat_Broker.tooltip:SetLineColor(row,r,g,b,1)
			end
		 end
		 
	
		

end

function DungStatsDBGetBackCol(colorName)
	
	
	--- misc menu items
	if colorName=="miscTitle" then
			return 32/255,128/255,208/255
	elseif colorName=="misc" then
		return 192/255,224/255,255/255
	
	--- Raid menu items
	elseif colorName=="raidTitle" then
			return 255/255,128/255,0
	elseif colorName=="raid" then
		return 255/255,192/255,128/255
	
	--- PVP menu items
	elseif colorName=="pvpTitle" then
			return 191/255,0,0
	elseif colorName=="pvp" then
		return 255/255,128/255,128/255
	
	--- Dungeon menu items
	elseif colorName=="dungeonTitle" then
			return 64/255,160/255,64/255
	elseif colorName=="dungeon" then
		return 128/255,176/255,128/255
	
	-- Others
	elseif colorName=="odd" then
		return 0.047,0.188,.266
	elseif colorName=="time" then
		return 112/266,96/266,112/255
	
	end
	
	return 0,0,0
end

function DungStatDBTooltip_Clear()
	menuIcon={}
	menuRow1={}
	menuRow2={}
	menuColor={}
	qcnt=0

	DungStatDBUpdateDBlabel("["..qcnt.."]")
end

function DungStatDBTooltip_Reset()
	menuIcon={"","INV_Misc_ClothScrap_02"}
	menuRow1={"<br/>","|cff606060Not in Queue."}
	menuRow2={"",""}
	menuColor={"CF4040","CF4040"}
	qcnt=0

	DungStatDBUpdateDBlabel("["..qcnt.."]")
end


function DungStatDBTooltip_UpdateInstance(instType, InstName)
	iType=instType
	iName=InstName
	DungStatDBTooltip_Update(0,0,0)
end


function DungStatDBTooltip_Add(tankNeeds, healerNeeds, dpsNeeds, tankTotal, healerTotal, dpsTotal, iType, instanceName,leaderNeeds, timestring)

	if (iType==0) then -- None
		DungStatDBTooltip_Reset();
		
	elseif (iType=="pvp") then -- Instance
	
		DungStatDBTooltip_AddRow("","<br/>","","")
		DungStatDBTooltip_AddRow("header","|cffffffff"..instanceName.."|r(PVP)","","pvp")
		--DungStatDBTooltip_AddRow("Spell_Holy_AvengersShield","Tanks",GetQueueStateText(tankTotal,tankNeeds))
		--DungStatDBTooltip_AddRow("Spell_Holy_BlessingOfStrength","DPS",GetQueueStateText(dpsTotal,dpsNeeds))
		--DungStatDBTooltip_AddRow("Spell_Holy_HolyGuidance","Healz",GetQueueStateText(healerTotal,healerNeeds))
		DungStatDBTooltip_AddRow("INV_Misc_PocketWatch_02","Waiting","|cff00FFFF"..timestring,"")
	
	elseif (iType=="pet") then -- Instance
	
		DungStatDBTooltip_AddRow("","<br/>","","")
		DungStatDBTooltip_AddRow("header","|cffffffff"..instanceName.."|r","","miscTitle")
		--DungStatDBTooltip_AddRow("Spell_Holy_AvengersShield","Tanks",GetQueueStateText(tankTotal,tankNeeds))
		--DungStatDBTooltip_AddRow("Spell_Holy_BlessingOfStrength","DPS",GetQueueStateText(dpsTotal,dpsNeeds))
		--DungStatDBTooltip_AddRow("Spell_Holy_HolyGuidance","Healz",GetQueueStateText(healerTotal,healerNeeds))
		DungStatDBTooltip_AddRow("INV_Misc_PocketWatch_02","Waiting","|cff00FFFF"..timestring,"")

	elseif (iType==LE_LFG_CATEGORY_LFD) then -- Instance
	
		
		DungStatDBTooltip_AddRow("","<br/>","","")
		DungStatDBTooltip_AddRow("header","|cffffffff"..instanceName.."|r(LFD)","","dungeonTitle")
		DungStatDBTooltip_AddRow("Spell_Holy_AvengersShield","Tanks",GetQueueStateText(tankTotal,tankNeeds),"")
		DungStatDBTooltip_AddRow("Spell_Holy_BlessingOfStrength","DPS",GetQueueStateText(dpsTotal,dpsNeeds),"odd")
		DungStatDBTooltip_AddRow("Spell_Holy_HolyGuidance","Healz",GetQueueStateText(healerTotal,healerNeeds),"")
		DungStatDBTooltip_AddRow("INV_Misc_PocketWatch_02","Waiting","|cff00FFFF"..timestring,"odd")


	elseif (iType==LE_LFG_CATEGORY_LFR) then -- 
	
		DungStatDBTooltip_AddRow("","<br/>","","")
		DungStatDBTooltip_AddRow("header","|cffffffff"..instanceName.."|r(LFR)","","raidTitle")
		DungStatDBTooltip_AddRow("Spell_Holy_AvengersShield","Tanks",GetQueueStateText(tankTotal,tankNeeds),"")
		DungStatDBTooltip_AddRow("Spell_Holy_BlessingOfStrength","DPS",GetQueueStateText(dpsTotal,dpsNeeds),"odd")
		DungStatDBTooltip_AddRow("Spell_Holy_HolyGuidance","Healz",GetQueueStateText(healerTotal,healerNeeds),"")
		DungStatDBTooltip_AddRow("INV_Misc_PocketWatch_02","Waiting","|cff00FFFF"..timestring,"odd")
	
	elseif (iType==LE_LFG_CATEGORY_RF) then -- 
	
			DungStatDBTooltip_AddRow("","<br/>","","")
		DungStatDBTooltip_AddRow("header","|cffffffff"..instanceName.."|r(RF)","","raidTitle")
		DungStatDBTooltip_AddRow("Spell_Holy_AvengersShield","Tanks",GetQueueStateText(tankTotal,tankNeeds),"")
		DungStatDBTooltip_AddRow("Spell_Holy_BlessingOfStrength","DPS",GetQueueStateText(dpsTotal,dpsNeeds),"odd")
		DungStatDBTooltip_AddRow("Spell_Holy_HolyGuidance","Healz",GetQueueStateText(healerTotal,healerNeeds),"")
		DungStatDBTooltip_AddRow("INV_Misc_PocketWatch_02","Waiting","|cff00FFFF"..timestring,"odd")
	
	elseif (iType==LE_LFG_CATEGORY_SCENARIO) then -- 
	
		DungStatDBTooltip_AddRow("","<br/>","","")
		DungStatDBTooltip_AddRow("header","|cffffffff"..instanceName.."|r(Scenario)","","miscTitle")
		DungStatDBTooltip_AddRow("Spell_Holy_BlessingOfStrength","Players",GetQueueStateText(dpsTotal,dpsNeeds),"")
		DungStatDBTooltip_AddRow("INV_Misc_PocketWatch_02","Waiting","|cff00FFFF"..timestring,"odd")
	
	elseif (iType==LE_LFG_CATEGORY_FLEXRAID) then -- 
	
		DungStatDBTooltip_AddRow("","<br/>","","")
		DungStatDBTooltip_AddRow("header","|cffffffff"..instanceName.."|r(RF)","","raidTitle")
		DungStatDBTooltip_AddRow("Spell_Holy_AvengersShield","Tanks",GetQueueStateText(tankTotal,tankNeeds),"")
		DungStatDBTooltip_AddRow("Spell_Holy_BlessingOfStrength","DPS",GetQueueStateText(dpsTotal,dpsNeeds),"odd")
		DungStatDBTooltip_AddRow("Spell_Holy_HolyGuidance","Healz",GetQueueStateText(healerTotal,healerNeeds),"")
		DungStatDBTooltip_AddRow("INV_Misc_PocketWatch_02","Waiting","|cff00FFFF"..timestring,"odd")
	
	end
	
	qcnt=qcnt+1
	DungStatDBUpdateDBlabel("["..qcnt.."]")
end

function GetQueueStateText(max,need)
	
	if max==0 then return "|cff606060N/A" end
	
	return GetQueueStateColor(max,need)..(max-need).."/"..max;

end


function GetQueueStateColor(max,need)
	col = "|cffff0000"
	
	if max==0 then 
		return col
	end
	
	
	if (need/max)<0.5 then
		col = "|cffFF8000"	
	elseif (need==0) then
		col = "|cff00ff00"
	end

	return col
end

function DungStatDBTooltip_AddRow(Icon, LineText, LineCount,LineColor)
	table.insert(menuIcon,""..Icon)
	 table.insert(menuRow1,""..LineText)
	 table.insert(menuRow2,""..LineCount)
	 table.insert(menuColor,""..LineColor)
end


function DungStatDBUpdateDBlabel(txt)
	if dungstat_Broker~=nil then
		dungstat_Broker.lDBObject.text="Instance Queues " .. txt;
	end
end

function dungstat_Broker:OnInitialize()
    -- Called when the addon is loaded
    self.lDBObject = {
		type = 'data source',
		text = 'Instance Queues [0]',
		icon = 'Interface\\Icons\\ACHIEVEMENT_GUILDPERK_LADYLUCK.blp',
		OnEnter = DungStatDBTooltip_Show,
	}
	
	LDB:NewDataObject("DungeonStatus", self.lDBObject)
	
	DungStatDBTooltip_Reset();
	DungStatDBTooltip_Init();
end


--	if dungstat.broker.tip:IsAcquired("Broker_dungstat") then dungstat.broker.tip:Release(dungstat.broker.menu.tooltip) end
--	dungstat.broker.menu.tooltip = dungstat.broker.tip:Acquire("Broker_dungstat", 2, "LEFT", "RIGHT")
	
	--write Menu Items
		
--		dungstat.broker.menu.tooltip:AddLine("|TInterface\\Icons\\INV_Holiday_Christmas_Present_01.blp:16|tConfigure", "")
--		dungstat.broker.menu.tooltip:SetLineScript(1, "OnMouseDown", dungstat.broker.click, "Configure")
		
		
--		dungstat.broker.menu.tooltip:AddLine("|cff00ff00-------------------|r", "");
