﻿-- Author      : Linty


dungstat={frame=CreateFrame("Frame"), core={}, utils={}, event={},vars={},broker={}};




dungstat.frame:SetScript("OnEvent", function(self, event, ...)
 dungstat.event:handler(self,event, ...); -- call event handler
end);

dungstat.vars.debug=1; -- set debug level to critical only
dungstat.vars.tankWait=0;
dungstat.vars.healWait=0;
dungstat.vars.dpsWait=0;
dungstat.vars.avgWait=0;
dungstat.vars.myWait=0;

dungstats_options= {hideWindow=false, version=0.1};

dungstat.vars.html="";

---------------------------Refresh Set-up setup--------
dungstat.vars.updatetime=2; --- Update Every x aseconds.
dungstat.vars.starttime={}

dungstat.vars.starttime[LE_LFG_CATEGORY_LFD]=0
dungstat.vars.starttime[LE_LFG_CATEGORY_LFR]=0
dungstat.vars.starttime[LE_LFG_CATEGORY_RF]=0
dungstat.vars.starttime[LE_LFG_CATEGORY_SCENARIO]=0
dungstat.vars.starttime[LE_LFG_CATEGORY_FLEXRAID]=0

 --when did last search start?


---------------------------Register Events--------
-- dungstat.frame:RegisterEvent("VARIABLES_LOADED");
-- dungstat.frame:RegisterEvent("ADDON_LOADED");


-- dungstat.frame:RegisterEvent("LFG_PROPOSAL_UPDATE");
-- dungstat.frame:RegisterEvent("LFG_PROPOSAL_SHOW");
-- dungstat.frame:RegisterEvent("LFG_PROPOSAL_FAILED");
-- dungstat.frame:RegisterEvent("LFG_PROPOSAL_SUCCEEDED");
-- dungstat.frame:RegisterEvent("LFG_UPDATE");
-- dungstat.frame:RegisterEvent("PLAYER_ENTERING_WORLD");
-- dungstat.frame:RegisterEvent("LFG_ROLE_CHECK_SHOW");
-- dungstat.frame:RegisterEvent("LFG_ROLE_CHECK_HIDE");
-- dungstat.frame:RegisterEvent("LFG_BOOT_PROPOSAL_UPDATE");
-- dungstat.frame:RegisterEvent("LFG_ROLE_UPDATE");
-- dungstat.frame:RegisterEvent("LFG_UPDATE_RANDOM_INFO");
-- dungstat.frame:RegisterEvent("LFG_QUEUE_STATUS_UPDATE");

-- dungstat.frame:RegisterEvent("BATTLEFIELD_MGR_EJECTED");
-- dungstat.frame:RegisterEvent("BATTLEFIELD_MGR_ENTERED");
-- dungstat.frame:RegisterEvent("BATTLEFIELD_MGR_ENTRY_INVITE");
-- dungstat.frame:RegisterEvent("BATTLEFIELD_MGR_QUEUE_INVITE");
-- dungstat.frame:RegisterEvent("BATTLEFIELD_MGR_QUEUE_REQUEST_RESPONSE");
-- dungstat.frame:RegisterEvent("BATTLEFIELD_MGR_STATE_CHANGE");
-- dungstat.frame:RegisterEvent("BATTLEFIELD_QUEUE_TIMEOUT");
-- dungstat.frame:RegisterEvent("PVPQUEUE_ANYWHERE_UPDATE_AVAILABLE");
-- dungstat.frame:RegisterEvent("PVPQUEUE_ANYWHERE_SHOW");
-- dungstat.frame:RegisterEvent("UPDATE_BATTLEFIELD_STATUS");
-- dungstat.frame:RegisterEvent("NPC_PVPQUEUE_ANYWHERE");
-- dungstat.frame:RegisterEvent("PVPQUEUE_ANYWHERE_SHOW");

dungstat.frame:RegisterEvent("ADDON_LOADED");
dungstat.frame:RegisterEvent("VARIABLES_LOADED");



C_Timer.After(2, function ()  dungstat:update() end)




------------------------Send Mesage to chat---------------------
function dungstat.utils:Chat(chatmsg)

	if (chatmsg==nil) then 
		chatmsg="";
	end
	
	DEFAULT_CHAT_FRAME:AddMessage("|cFFFFF000Dungeon Status: |r"..chatmsg);
end

------------------------Send Debug to chat---------------------
function dungstat.utils:Debug(level, debugStr) --- level == 0-Critical, 1- Important, 2-Information, 3-trace only
		
		if (debugStr==nil or level == nil) then 
			return;
		end
		if (dungstat.vars.debug+1<level) then 
				return;
		end
		
		DEFAULT_CHAT_FRAME:AddMessage("|cFFFFF000Dungeon Status: |cffff0000[Debug] |r"..debugStr);
end

---------------------------------Helper Functions---------------------------------
function dungstat.utils:SafeNil(StringVar)
		if (StringVar== nil) then
			return "";
		end

		return StringVar;
end 

function dungstat.utils:TimeString(secs)

	if (secs==nil) then
		return "-";
	end
	
	if (secs<60) then
		return "< 1m";
	end
		
	
	
	local mins=math.floor(secs/60);
	local hours=0;
	local days=0;

	hours,mins=math.modf(mins/60);
	mins=math.floor(mins*60);

	days,hours=math.modf(hours/24);

	hours=math.floor(hours*24);

	sret=""
	if (days>0) then
		sret=days.."d ";
	end

	if (hours>0 or days>0) then
		sret=sret..hours.."h ";
	end

	sret=sret..mins.."m ";

return sret;
end

-------------------------LOad Proc--------------



--------------------------Event Handler---------------------------------
function dungstat.event:handler(self, event, ...)

	if (event=="ADDON_LOADED") then
         
       
        
    elseif (event=="VARIABLES_LOADED") then
			
           
           dungstat_CreateConfig();
    end

end

function dungstat:update()

	DungStatDBTooltip_Clear();
	DungStatusFrame_text:SetText("");
	dungstat.vars.html="";
	 
	local cnt=0
	
	cnt=cnt+dungstat.utils:updateQueue(LE_LFG_CATEGORY_LFD);
	cnt=cnt+dungstat.utils:updateQueue(LE_LFG_CATEGORY_LFR);
	cnt=cnt+dungstat.utils:updateQueue(LE_LFG_CATEGORY_RF);
	cnt=cnt+dungstat.utils:updateQueue(LE_LFG_CATEGORY_SCENARIO);
	cnt=cnt+dungstat.utils:updateQueue(LE_LFG_CATEGORY_FLEXRAID);
	
	for n=1, MAX_WORLD_PVP_QUEUES do
	
		cnt=cnt+dungstat.utils:updatePVP(n)
	end
	
	for n=1, GetMaxBattlefieldID() do
	
		cnt=cnt+dungstat.utils:updateBF(n)
	end
	
	cnt=cnt+dungstat.utils:updatePet()
	
	
	
	DungStatusFrame_text:SetHeight((cnt*12));
    DungStatusFrame:SetHeight((cnt*12)+40);
	
	--Chronos.unscheduleByName("DungStatus_Update")
	if cnt==0 then
			
			DungStatDBTooltip_Reset()
			dungstat.utils:showWin(false)
	end	
	
	C_Timer.After(2, function ()  dungstat:update() end)
end

function dungstat.utils:updateBF(qId)
	

	local status, mapName, instanceID, bracketMin, bracketMax, teamSize, registeredMatch = GetBattlefieldStatus(qId)
	
	--dungstat.utils:Chat(qId.." :BF: "..status)
		if (status=="queued") then
			
			
			
			local timeInQueue = math.floor(GetBattlefieldTimeWaited(qId)/1000)
			local waitTime = math.floor(GetBattlefieldEstimatedWaitTime(qId)/1000)
			
						
			
			if (timeInQueue==0 or timeInQueue==nil) then
				timeInQueue=1
			end
			
			if (waitTime==nil) then
				waitTime=600
			end
			

			--	dungstat.utils:Chat(qId.." :BFm: "..status)
				
				DungStatDBTooltip_Add(0, 0, 0, 0, 0, 0 ,"pvp", mapName,false,dungstat.utils:TimeString(timeInQueue).." |cffFFFF00("..dungstat.utils:TimeString(waitTime).." wait)")
				dungstat.utils:Win_Add(0, 0, 0, 0, 0, 0 ,"pvp", mapName,false,dungstat.utils:TimeString(timeInQueue).." |cffFFFF00("..dungstat.utils:TimeString(waitTime).." wait)")
		

			 dungstat.utils:showWin(true)
			
			return 1;
		else
			
			return 0;
			
			
		
		end

	
end

function dungstat.utils:updatePVP(qId)
	

	local status, mapName, queueID = GetWorldPVPQueueStatus(qId)
	--dungstat.utils:Chat(qId.." :PVP: "..status)
		if (status=="queued") then
			
			if (dungstat.vars.starttime["pvp"..qId]==0 or dungstat.vars.starttime["pvp"..qId]==nil ) then 
	
				dungstat.vars.starttime["pvp"..qId]=time(); --- Start time
				
			end
			
			
			

			
			--local hasData, leaderNeeds, tankNeeds, healerNeeds, dpsNeeds, tankTotal, healerTotal, dpsTotal, instanceType, instanceSubType, instanceName, averageWait, tankWait, healerWait, damageWait, myWait = GetLFGQueueStats(qID);
						
			--if (not hasData) then
			--	return 0;
			--end
			

			
			
			
			
			
				if (dungstat.vars.starttime["pvp"..qId]==0) then return  end; --- LFG Not Active


				
				DungStatDBTooltip_Add(0, 0, 0, 0, 0, 0 ,"pvp", mapName,false,dungstat.utils:TimeString(time()-dungstat.vars.starttime["pvp"..qId]))
				dungstat.utils:Win_Add(0, 0, 0, 0, 0, 0 ,"pvp", mapName,false,dungstat.utils:TimeString(time()-dungstat.vars.starttime["pvp"..qId]))
		

			 dungstat.utils:showWin(true)
			
			return 1;
		else
			dungstat.vars.starttime["pvp"..qId]=0; -- Reset start Time
			return 0;
			
			
		
		end

	
end

function dungstat.utils:updatePet()
	
	local status, value, waittime= C_PetBattles.GetPVPMatchmakingInfo()
	
	
	myWait=math.floor(waittime/1000)
	
	local waiting = C_PetBattles.IsWaitingOnOpponent()
	--dungstat.utils:Chat(qId.." :PVP: "..status)
		if (status=="queued")  then
			
			if (dungstat.vars.starttime["pet"]==0 or dungstat.vars.starttime["pet"]==nil ) then 
	
				dungstat.vars.starttime["pet"]=time(); --- Start time
				
			end
			
			
			

			
			--local hasData, leaderNeeds, tankNeeds, healerNeeds, dpsNeeds, tankTotal, healerTotal, dpsTotal, instanceType, instanceSubType, instanceName, averageWait, tankWait, healerWait, damageWait, myWait = GetLFGQueueStats(qID);
						
			--if (not hasData) then
			--	return 0;
			--end
			

			
			
			
			
			
				if (dungstat.vars.starttime["pet"]==0) then return  end; --- LFG Not Active


				
				DungStatDBTooltip_Add(0, 0, 0, 0, 0, 0 ,"pet", "Pet Battle",false,dungstat.utils:TimeString(time()-dungstat.vars.starttime["pet"]).." |cffFFFF00("..dungstat.utils:TimeString(myWait).." wait)")
				dungstat.utils:Win_Add(0, 0, 0, 0, 0, 0 ,"pet", "Pet Battle",false,dungstat.utils:TimeString(time()-dungstat.vars.starttime["pet"]).." |cffFFFF00("..dungstat.utils:TimeString(myWait).." wait)")
		

			 dungstat.utils:showWin(true)
			
			return 1;
		else
			dungstat.vars.starttime["pet"]=0; -- Reset start Time
			return 0;
			
			
		
		end

	
end


function dungstat.utils:updateQueue(qID)

	local lfdmode, lfdsubmode=GetLFGMode(qID);

		if (lfdmode=="queued") then
			
			if (dungstat.vars.starttime[qID]==0) then 

				dungstat.vars.starttime[qID]=time(); --- Start time

			end
			

			local hasData, leaderNeeds, tankNeeds, healerNeeds, dpsNeeds, tankTotal, healerTotal, dpsTotal, instanceType, instanceSubType, instanceName, averageWait, tankWait, healerWait, damageWait, myWait = GetLFGQueueStats(qID);
						
			if (not hasData) then
				return 0;
			end
			

			
			------ Store Times for Tooltip
			dungstat.vars.tankWait=tankWait;
			dungstat.vars.healWait=healerWait;
			dungstat.vars.dpsWait=damageWait;
			dungstat.vars.avgWait=averageWait;
			dungstat.vars.myWait=myWait;
			
			
			
			
			if (myWait<0) then

				------ Update Tooltip
				if (dungstat.vars.starttime[qID]==0) then return  end; --- LFG Not Active


				
				DungStatDBTooltip_Add(tankNeeds, healerNeeds, dpsNeeds, tankTotal, healerTotal, dpsTotal ,qID, instanceName,leaderNeeds,
						dungstat.utils:TimeString(time()-dungstat.vars.starttime[qID]))
				dungstat.utils:Win_Add(tankNeeds, healerNeeds, dpsNeeds, tankTotal, healerTotal, dpsTotal ,qID, instanceName,leaderNeeds,
						dungstat.utils:TimeString(time()-dungstat.vars.starttime[qID]))
				
			else

				------ Update Tooltip
				
				DungStatDBTooltip_Add(tankNeeds, healerNeeds, dpsNeeds, tankTotal, healerTotal, dpsTotal ,qID, instanceName,leaderNeeds,
						dungstat.utils:TimeString(time()-dungstat.vars.starttime[qID]).." |cffFFFF00("..dungstat.utils:TimeString(myWait).." wait)")
				dungstat.utils:Win_Add(tankNeeds, healerNeeds, dpsNeeds, tankTotal, healerTotal, dpsTotal ,qID, instanceName,leaderNeeds,
						dungstat.utils:TimeString(time()-dungstat.vars.starttime[qID]).." |cffFFFF00("..dungstat.utils:TimeString(myWait).." wait)")
			end
			
		

				
			 dungstat.utils:showWin(true)
			
			return 1;
		else
			dungstat.vars.starttime[qID]=0; -- Reset start Time
			return 0;
			
			
		
		end

	
end

function  dungstat_show_set(show)
	if show then 
		dungstats_options.hideWindow=false
	else
		dungstats_options.hideWindow=true
		dungstat.utils:showWin(false)
	end
	

end

function dungstat.utils:showWin(show)
	if (dungstats_options.hideWindow==true or show==false) then
		if (DungStatusFrame.IsVisible) then DungStatusFrame:Hide(); end
	else
		DungStatusFrame:Show();
	end

end

function  dungstat.utils:Win_Add(tankNeeds, healerNeeds, dpsNeeds, tankTotal, healerTotal, dpsTotal, iType, instanceName,leaderNeeds, timestring)

	html=""
	
	if (iType=="pvp") then -- 
	
		html=html.."|TInterface\\Icons\\Achievement_PVP_P_04.blp:16|t |cff00FFFFPVP  |TInterface\\Icons\\INV_Misc_PocketWatch_02.blp:16|t"
		html=""..html.."|cff00ff00"..timestring
	elseif (iType=="pet") then -- 
	
		html=html.."|TInterface\\Icons\\INV_Misc_Rabbit.blp:16|t |cff00FFFFPet |TInterface\\Icons\\INV_Misc_PocketWatch_02.blp:16|t"
		html=""..html.."|cff00ff00"..timestring

	else
	

		if (tankNeeds==0 and tankTotal>0) then  html=html.."|TInterface\\Icons\\Achievement_PVP_G_09.blp:16|t"  else html=html.."|TInterface\\Icons\\Achievement_PVP_H_09.blp:16|t" end 
		if (dpsNeeds==0 and dpsTotal>0) then  html=html.."|TInterface\\Icons\\Achievement_PVP_G_06.blp:16|t"  else html=html.."|TInterface\\Icons\\Achievement_PVP_H_06.blp:16|t" end 
		if (healerNeeds==0 and healerTotal>0) then  html=html.."|TInterface\\Icons\\Achievement_PVP_G_10.blp:16|t"  else html=html.."|TInterface\\Icons\\Achievement_PVP_H_10.blp:16|t" end 
		
		
		if (iType==LE_LFG_CATEGORY_LFD) then -- Instance
		
			html=html.." |cff00FFFFLFD "

		elseif (iType==LE_LFG_CATEGORY_LFR) then -- 
		
			html=html.." |cff00FFFFLFR "
		elseif (iType==LE_LFG_CATEGORY_RF) then -- 
		
			html=html.." |cff00FFFFRF "
		
		elseif (iType==LE_LFG_CATEGORY_SCENARIO) then -- 
		
			html=html.." |cff00FFFFScenario "
		
		elseif (iType==LE_LFG_CATEGORY_FLEXRAID) then -- 
		
			html=html.." |cff00FFFFFR "
		
		end
		
		TOTAL = (tankTotal+dpsTotal+healerTotal)
		html=""..html..": |cffFFFF00"..(TOTAL-(tankNeeds+dpsNeeds+healerNeeds)).."|cffffffff/|cffFFFF00"..TOTAL.."  |TInterface\\Icons\\INV_Misc_PocketWatch_02.blp:16|t|cff00ff00"..timestring ..""
		
	end
	
	if dungstat.vars.html~="" then
		dungstat.vars.html=dungstat.vars.html.."\n"
	end
	
	dungstat.vars.html=dungstat.vars.html..html
	--DungStatusFrame_html:SetText("<html><body>"..dungstat.vars.html.."</html></body>")
	DungStatusFrame_text:SetText(dungstat.vars.html)
end
