local DGV = DugisGuideViewer
if not DGV then return end

local TaxiData = DGV:RegisterModule("TaxiData")
TaxiData.essential = true

--Possible modes: "veiled-den", "lights-purchase"
TaxiData.currentBeaconMode = "unknown"

function TaxiData:Initialize()

	local fullData
	function TaxiData:GetFullData()
		--107457 Druid
		--98968 Hunter 
		--93465 Death Knight 
		--98114 Alliance Skyfire Triage Camp Stormheim
		--98113 Alliance Lorna's Watch Stormheim
		--98108 Alliance Greywatch Stormheim
		--92560 Horde Cullen's Post Stormheim
		if not fullData then
			fullData = {
	["Neutral"] = {},
	["Horde"] = {
	{
		[11798] = {
			direct = "2995",
			m = 241,
			f = 0,
			coord = 1902015812,
			requirements = "cls:DRUID",
			overridePlayerData = true
		},
		[52060] = {
			"3615:3310", -- [1]
			"3615:4312", -- [2]
			"2995:6726", -- [3]
			"39330:40358:40769:7824", -- [4]
			"39330:39898", -- [5]
			"3615:8610", -- [6]
			"3615:3310:11139", -- [7]
			"3615:34927:34429:11901", -- [8]
			"3615:34927:12616", -- [9]
			"3615:34927:12616:22931:43073:43085:12740", -- [10]
			"39330:39898:15178", -- [11]
			"39330:40358:40769:7824:10583", -- [12]
			"3615:16227", -- [13]
			"3615:34927:12616:22931", -- [14]
			"39330:40358", -- [15]
			"3615:34927:34429", -- [16]
			"3615:34927", -- [17]
			"3615:34927:34943", -- [18]
			"3615:4312:35141", -- [19]
			"2995:35139:35140", -- [20]
			"2995:35139", -- [21]
			"2995:35556:35562:35315", -- [22]
			"2995:35556:35478", -- [23]
			"2995:35556", -- [24]
			"2995:35556:35562", -- [25]
			"39330:40358:40769:7824:39175", -- [26]
			"2995:40809", -- [27]
			"3615:40558", -- [28]
			"39330:40358:40769", -- [29]
			"39330:40358:40769:7824:41215", -- [30]
			"3615:3310:41140:41142", -- [31]
			"3615:3310:41140", -- [32]
			"39330:40358:40769:7824:41214", -- [33]
			"3615:4312:41246", -- [34]
			"39330:39898:41605:40473", -- [35]
			"39330:39898:41605", -- [36]
			"3615:34927:12616:22931:43073", -- [37]
			"3615:34927:12616:22931:43079", -- [38]
			"3615:34927:12616:22931:43073:43085", -- [39]
			"3615:3310:37005", -- [40]
			"3615:8610:43328", -- [41]
			"3615:34927:12616:36728", -- [42]
			["direct"] = "2995:3615:44399:11899:39340:39330",
			["coord"] = 1784969747,
			["m"] = 607,
			["f"] = 0,
		},
		[35556] = {
			"2995:3310", -- [1]
			"2995:3615", -- [2]
			"35478:4312", -- [3]
			"2995:44399", -- [4]
			"35478:6726", -- [5]
			"2995:7824", -- [6]
			"2995:52060:39330:39898", -- [7]
			"2995:8610", -- [8]
			"2995:3310:11139", -- [9]
			"2995:52060:11899", -- [10]
			"35478:4312:11901", -- [11]
			"2995:3615:34927:12616", -- [12]
			"35478:4312:34429:22931:43073:43085:12740", -- [13]
			"35478:6726:40473:41605:15178", -- [14]
			"2995:52060", -- [15]
			"2995:7824:10583", -- [16]
			"2995:3615:16227", -- [17]
			"35478:4312:34429:22931", -- [18]
			"2995:52060:39330:40358", -- [19]
			"35478:4312:34429", -- [20]
			"2995:3615:34927", -- [21]
			"2995:35139:35140:34943", -- [22]
			"35478:4312:35141", -- [23]
			"2995:35139:35140", -- [24]
			"2995:35139", -- [25]
			"35562:35315", -- [26]
			"2995:7824:39175", -- [27]
			"2995:39340", -- [28]
			"2995:52060:39330", -- [29]
			"2995:40809", -- [30]
			"2995:3615:40558", -- [31]
			"2995:52060:39330:40358:40769", -- [32]
			"2995:7824:41215", -- [33]
			"2995:3310:41140:41142", -- [34]
			"2995:3310:41140", -- [35]
			"2995:7824:41214", -- [36]
			"35478:4312:41246", -- [37]
			"35478:6726:40473", -- [38]
			"35478:6726:40473:41605", -- [39]
			"35478:4312:34429:22931:43073", -- [40]
			"35478:4312:34429:22931:43079", -- [41]
			"35478:4312:34429:22931:43073:43085", -- [42]
			"2995:3310:37005", -- [43]
			"2995:8610:43328", -- [44]
			"2995:3615:34927:12616:36728", -- [45]
			["direct"] = "2995:35478:35562",
			["coord"] = 3034731573,
			["m"] = 101,
			["f"] = 0,
		},
		[8610] = {
			"12616:34943:35140:4312", -- [1]
			"3310:3615:44399", -- [2]
			"2995:6726", -- [3]
			"3310:7824", -- [4]
			"3310:3615:52060:39330:39898", -- [5]
			"3310:16227:11899", -- [6]
			"12616:34429:11901", -- [7]
			"11139:12740", -- [8]
			"3310:3615:52060:39330:39898:15178", -- [9]
			"3310:3615:52060", -- [10]
			"3310:7824:10583", -- [11]
			"3310:16227", -- [12]
			"12616:22931", -- [13]
			"3310:16227:11899:40358", -- [14]
			"12616:34429", -- [15]
			"3310:34927", -- [16]
			"12616:34943", -- [17]
			"12616:34429:35141", -- [18]
			"12616:34943:35140", -- [19]
			"3310:3615:35139", -- [20]
			"12616:34943:35140:4312:35315", -- [21]
			"2995:35556:35478", -- [22]
			"2995:35556", -- [23]
			"2995:35556:35562", -- [24]
			"3310:7824:39175", -- [25]
			"3310:3615:39340", -- [26]
			"3310:3615:52060:39330", -- [27]
			"2995:40809", -- [28]
			"3310:40558", -- [29]
			"3310:16227:11899:40358:40769", -- [30]
			"3310:7824:41215", -- [31]
			"3310:41140:41142", -- [32]
			"3310:41140", -- [33]
			"3310:7824:41214", -- [34]
			"12616:34943:35140:41246", -- [35]
			"2995:6726:40473", -- [36]
			"3310:3615:52060:39330:39898:41605", -- [37]
			"11139:43085:43073", -- [38]
			"12616:22931:43079", -- [39]
			"11139:43085", -- [40]
			["direct"] = "2995:3310:3615:11139:12616:37005:43328:36728",
			["coord"] = 2275573679,
			["m"] = 181,
			["f"] = 0,
		},
		[39340] = {
			"3615:3310", -- [1]
			"2995:35139:4312", -- [2]
			"52060:44399", -- [3]
			"2995:6726", -- [4]
			"52060:39330:40358:40769:7824", -- [5]
			"52060:39330:39898", -- [6]
			"3615:8610", -- [7]
			"3615:3310:11139", -- [8]
			"52060:11899", -- [9]
			"3615:34927:34429:11901", -- [10]
			"3615:34927:12616", -- [11]
			"3615:34927:12616:22931:43073:43085:12740", -- [12]
			"52060:39330:39898:15178", -- [13]
			"52060:39330:40358:40769:7824:10583", -- [14]
			"3615:16227", -- [15]
			"3615:34927:12616:22931", -- [16]
			"52060:39330:40358", -- [17]
			"3615:34927:34429", -- [18]
			"3615:34927", -- [19]
			"3615:34927:34943", -- [20]
			"2995:35139:35141", -- [21]
			"2995:35139:35140", -- [22]
			"2995:35139", -- [23]
			"2995:35556:35562:35315", -- [24]
			"2995:35556:35478", -- [25]
			"2995:35556", -- [26]
			"2995:35556:35562", -- [27]
			"52060:39330:40358:40769:7824:39175", -- [28]
			"2995:40809", -- [29]
			"3615:40558", -- [30]
			"52060:39330:40358:40769", -- [31]
			"52060:39330:40358:40769:7824:41215", -- [32]
			"3615:3310:41140:41142", -- [33]
			"3615:3310:41140", -- [34]
			"52060:39330:40358:40769:7824:41214", -- [35]
			"2995:35139:4312:41246", -- [36]
			"2995:6726:40473", -- [37]
			"52060:39330:39898:41605", -- [38]
			"3615:34927:12616:22931:43073", -- [39]
			"3615:34927:12616:22931:43079", -- [40]
			"3615:34927:12616:22931:43073:43085", -- [41]
			"3615:3310:37005", -- [42]
			"3615:8610:43328", -- [43]
			"3615:34927:12616:36728", -- [44]
			["direct"] = "2995:3615:52060:39330",
			["coord"] = 1707619316,
			["m"] = 607,
			["f"] = 0,
		},
		[35562] = {
			"35556:2995", -- [1]
			"35556:2995:3310", -- [2]
			"35556:2995:3615", -- [3]
			"35315:4312", -- [4]
			"35556:2995:44399", -- [5]
			"35556:2995:7824", -- [6]
			"35315:39898", -- [7]
			"35556:2995:8610", -- [8]
			"35556:2995:3310:11139", -- [9]
			"35556:2995:52060:11899", -- [10]
			"35315:4312:11901", -- [11]
			"35315:4312:35140:34943:12616", -- [12]
			"35315:4312:34429:22931:43073:43085:12740", -- [13]
			"6726:40473:41605:15178", -- [14]
			"35556:2995:52060", -- [15]
			"6726:40473:41605:15178:39175:10583", -- [16]
			"35556:2995:3615:16227", -- [17]
			"35315:4312:34429:22931", -- [18]
			"35556:2995:52060:39330:40358", -- [19]
			"35315:4312:34429", -- [20]
			"35556:2995:3615:34927", -- [21]
			"35315:4312:35140:34943", -- [22]
			"35315:4312:35141", -- [23]
			"35315:4312:35140", -- [24]
			"35556:2995:35139", -- [25]
			"6726:40473:41605:15178:39175", -- [26]
			"35556:2995:39340", -- [27]
			"35556:2995:52060:39330", -- [28]
			"35556:2995:40809", -- [29]
			"35556:2995:3615:40558", -- [30]
			"35556:2995:52060:39330:40358:40769", -- [31]
			"35556:2995:7824:41215", -- [32]
			"35556:2995:3310:41140:41142", -- [33]
			"35556:2995:3310:41140", -- [34]
			"35556:2995:7824:41214", -- [35]
			"35315:4312:41246", -- [36]
			"6726:40473", -- [37]
			"6726:40473:41605", -- [38]
			"35315:4312:34429:22931:43073", -- [39]
			"35315:4312:34429:22931:43079", -- [40]
			"35315:4312:34429:22931:43073:43085", -- [41]
			"35556:2995:3310:37005", -- [42]
			"35556:2995:8610:43328", -- [43]
			"35315:4312:35140:34943:12616:36728", -- [44]
			["direct"] = "6726:35315:35478:35556",
			["coord"] = 1676035339,
			["m"] = 101,
			["f"] = 0,
		},
		[40358] = {
			"11899:52060:2995", -- [1]
			"11899:16227:3310", -- [2]
			"11899:52060:3615", -- [3]
			"11899:52060:3615:4312", -- [4]
			"44399:39898:41605:40473:6726", -- [5]
			"40769:7824", -- [6]
			"44399:39898", -- [7]
			"11899:16227:3310:8610", -- [8]
			"11899:16227:3310:11139", -- [9]
			"11899:52060:3615:34927:34429:11901", -- [10]
			"11899:52060:3615:34927:12616", -- [11]
			"11899:52060:3615:34927:12616:22931:43073:43085:12740", -- [12]
			"44399:39898:15178", -- [13]
			"11899:52060", -- [14]
			"40769:7824:10583", -- [15]
			"11899:16227", -- [16]
			"11899:52060:3615:34927:12616:22931", -- [17]
			"11899:52060:3615:34927:34429", -- [18]
			"11899:52060:3615:34927", -- [19]
			"11899:52060:3615:34927:34943", -- [20]
			"11899:52060:3615:4312:35141", -- [21]
			"11899:52060:2995:35139:35140", -- [22]
			"11899:52060:2995:35139", -- [23]
			"11899:52060:2995:35556:35562:35315", -- [24]
			"11899:52060:2995:35556:35478", -- [25]
			"11899:52060:2995:35556", -- [26]
			"11899:52060:2995:35556:35562", -- [27]
			"40769:7824:39175", -- [28]
			"11899:52060:39340", -- [29]
			"11899:52060:2995:40809", -- [30]
			"11899:52060:3615:40558", -- [31]
			"40769:7824:41215", -- [32]
			"11899:16227:3310:41140:41142", -- [33]
			"11899:16227:3310:41140", -- [34]
			"40769:7824:41214", -- [35]
			"11899:52060:3615:4312:41246", -- [36]
			"44399:39898:41605:40473", -- [37]
			"44399:39898:41605", -- [38]
			"11899:52060:3615:34927:12616:22931:43073", -- [39]
			"11899:52060:3615:34927:12616:22931:43079", -- [40]
			"11899:52060:3615:34927:12616:22931:43073:43085", -- [41]
			"11899:16227:3310:37005", -- [42]
			"11899:16227:3310:8610:43328", -- [43]
			"11899:16227:3310:36728", -- [44]
			["direct"] = "44399:11899:39330:40769",
			["coord"] = 1841543491,
			["m"] = 141,
			["f"] = 0,
		},
		[12740] = {
			"43085:43073:22931:34429:4312:35139:2995", -- [1]
			"43085:43073:22931:12616:3310", -- [2]
			"43085:43073:22931:12616:34927:3615", -- [3]
			"43085:43073:22931:34429:4312", -- [4]
			"43085:43073:22931:12616:34927:3615:44399", -- [5]
			"43085:43073:22931:34429:4312:6726", -- [6]
			"43085:43073:22931:12616:34927:3615:7824", -- [7]
			"43085:43073:22931:12616:34927:3615:52060:39330:39898", -- [8]
			"11139:8610", -- [9]
			"43085:43073:22931:12616:34927:3615:52060:11899", -- [10]
			"43085:43073:22931:34429:11901", -- [11]
			"43085:43073:22931:12616", -- [12]
			"43085:43073:22931:12616:34927:3615:52060:39330:39898:15178", -- [13]
			"43085:43073:22931:12616:34927:3615:52060", -- [14]
			"43085:43073:22931:12616:34927:3615:7824:10583", -- [15]
			"43085:43073:22931:12616:34927:3615:16227", -- [16]
			"43085:43073:22931", -- [17]
			"43085:43073:22931:12616:34927:3615:52060:39330:40358", -- [18]
			"43085:43073:22931:34429", -- [19]
			"43085:43073:22931:12616:34927", -- [20]
			"43085:43073:22931:34429:34943", -- [21]
			"43085:43073:22931:34429:35141", -- [22]
			"43085:43073:22931:34429:34943:35140", -- [23]
			"43085:43073:22931:34429:4312:35139", -- [24]
			"43085:43073:22931:34429:4312:35315", -- [25]
			"43085:43073:22931:34429:4312:35478", -- [26]
			"43085:43073:22931:34429:4312:35478:35556", -- [27]
			"43085:43073:22931:34429:4312:35315:35562", -- [28]
			"43085:43073:22931:12616:34927:3615:7824:39175", -- [29]
			"43085:43073:22931:12616:34927:3615:39340", -- [30]
			"43085:43073:22931:12616:34927:3615:52060:39330", -- [31]
			"43085:43073:22931:34429:4312:35139:2995:40809", -- [32]
			"43085:43073:22931:12616:34927:40558", -- [33]
			"43085:43073:22931:12616:34927:3615:52060:39330:40358:40769", -- [34]
			"43085:43073:22931:12616:34927:3615:7824:41215", -- [35]
			"43085:43073:22931:12616:3310:41140:41142", -- [36]
			"43085:43073:22931:12616:3310:41140", -- [37]
			"43085:43073:22931:12616:34927:3615:7824:41214", -- [38]
			"43085:43073:22931:34429:35141:41246", -- [39]
			"43085:43073:22931:34429:4312:6726:40473", -- [40]
			"43085:43073:22931:12616:34927:3615:52060:39330:39898:41605", -- [41]
			"43085:43073", -- [42]
			"43085:43073:43079", -- [43]
			"11139:8610:37005", -- [44]
			"11139:8610:43328", -- [45]
			"43085:43073:22931:12616:36728", -- [46]
			["direct"] = "11139:43085",
			["coord"] = 1380821457,
			["m"] = 241,
			["f"] = 0,
		},
		[41246] = {
			"4312:35139:2995", -- [1]
			"35140:34927:3310", -- [2]
			"4312:3615", -- [3]
			"4312:35139:2995:44399", -- [4]
			"4312:6726", -- [5]
			"4312:35139:2995:7824", -- [6]
			"4312:35139:2995:52060:39330:39898", -- [7]
			"35140:34943:12616:36728:8610", -- [8]
			"35141:34429:22931:43073:43085:11139", -- [9]
			"4312:35139:2995:52060:11899", -- [10]
			"35141:11901", -- [11]
			"35140:34943:12616", -- [12]
			"35141:34429:22931:43073:43085:12740", -- [13]
			"4312:6726:40473:41605:15178", -- [14]
			"4312:35139:2995:52060", -- [15]
			"4312:6726:40473:41605:15178:39175:10583", -- [16]
			"4312:3615:16227", -- [17]
			"35141:34429:22931", -- [18]
			"4312:35139:2995:52060:39330:40358", -- [19]
			"35141:34429", -- [20]
			"35140:34927", -- [21]
			"35140:34943", -- [22]
			"4312:35139", -- [23]
			"4312:35315", -- [24]
			"4312:35478", -- [25]
			"4312:35478:35556", -- [26]
			"4312:35315:35562", -- [27]
			"4312:6726:40473:41605:15178:39175", -- [28]
			"4312:35139:2995:39340", -- [29]
			"4312:35139:2995:52060:39330", -- [30]
			"4312:35139:2995:40809", -- [31]
			"35140:34927:40558", -- [32]
			"4312:35139:2995:52060:39330:40358:40769", -- [33]
			"4312:35139:2995:7824:41215", -- [34]
			"35140:34927:3310:41140:41142", -- [35]
			"35140:34927:3310:41140", -- [36]
			"4312:35139:2995:7824:41214", -- [37]
			"4312:6726:40473", -- [38]
			"4312:6726:40473:41605", -- [39]
			"35141:34429:22931:43073", -- [40]
			"35141:34429:22931:43079", -- [41]
			"35141:34429:22931:43073:43085", -- [42]
			"35140:34927:3310:37005", -- [43]
			"35140:34943:12616:36728:8610:43328", -- [44]
			"35140:34943:12616:36728", -- [45]
			["direct"] = "4312:35141:35140",
			["coord"] = 2311153335,
			["m"] = 81,
			["f"] = 0,
		},
		[12616] = {
			"34927:3615:2995", -- [1]
			"34943:35140:4312", -- [2]
			"34927:3615:44399", -- [3]
			"34943:35140:4312:6726", -- [4]
			"34927:3615:7824", -- [5]
			"34927:3615:52060:39330:39898", -- [6]
			"36728:8610:11139", -- [7]
			"34927:3615:52060:11899", -- [8]
			"22931:43073:43085:12740", -- [9]
			"34927:3615:52060:39330:39898:15178", -- [10]
			"34927:3615:52060", -- [11]
			"34927:3615:7824:10583", -- [12]
			"34927:3615:16227", -- [13]
			"34927:3615:52060:39330:40358", -- [14]
			"34429:35141", -- [15]
			"34943:35140", -- [16]
			"34943:35140:35139", -- [17]
			"34943:35140:4312:35315", -- [18]
			"34943:35140:4312:35478", -- [19]
			"34927:3615:2995:35556", -- [20]
			"34943:35140:4312:35315:35562", -- [21]
			"34927:3615:7824:39175", -- [22]
			"34927:3615:39340", -- [23]
			"34927:3615:52060:39330", -- [24]
			"34927:3615:2995:40809", -- [25]
			"34927:40558", -- [26]
			"34927:3615:52060:39330:40358:40769", -- [27]
			"34927:3615:7824:41215", -- [28]
			"3310:41140:41142", -- [29]
			"3310:41140", -- [30]
			"34927:3615:7824:41214", -- [31]
			"34943:35140:41246", -- [32]
			"34943:35140:4312:6726:40473", -- [33]
			"34927:3615:52060:39330:39898:41605", -- [34]
			"22931:43073", -- [35]
			"22931:43079", -- [36]
			"22931:43073:43085", -- [37]
			"36728:8610:37005", -- [38]
			"36728:8610:43328", -- [39]
			["direct"] = "3310:3615:8610:11901:22931:34429:34927:34943:36728",
			["coord"] = 3145178564,
			["m"] = 43,
			["f"] = 0,
		},
		[43079] = {
			"22931:34429:4312:35139:2995", -- [1]
			"22931:12616:3310", -- [2]
			"22931:12616:34927:3615", -- [3]
			"22931:34429:4312", -- [4]
			"22931:12616:34927:3615:44399", -- [5]
			"22931:34429:4312:6726", -- [6]
			"22931:12616:34927:3615:7824", -- [7]
			"22931:12616:34927:3615:52060:39330:39898", -- [8]
			"22931:12616:36728:8610", -- [9]
			"43073:43085:11139", -- [10]
			"22931:12616:34927:3615:52060:11899", -- [11]
			"22931:34429:11901", -- [12]
			"22931:12616", -- [13]
			"43073:43085:12740", -- [14]
			"22931:12616:34927:3615:52060:39330:39898:15178", -- [15]
			"22931:12616:34927:3615:52060", -- [16]
			"22931:12616:34927:3615:7824:10583", -- [17]
			"22931:12616:34927:3615:16227", -- [18]
			"22931:12616:34927:3615:52060:39330:40358", -- [19]
			"22931:34429", -- [20]
			"22931:12616:34927", -- [21]
			"22931:34429:34943", -- [22]
			"22931:34429:35141", -- [23]
			"22931:34429:34943:35140", -- [24]
			"22931:34429:4312:35139", -- [25]
			"22931:34429:4312:35315", -- [26]
			"22931:34429:4312:35478", -- [27]
			"22931:34429:4312:35478:35556", -- [28]
			"22931:34429:4312:35315:35562", -- [29]
			"22931:12616:34927:3615:7824:39175", -- [30]
			"22931:12616:34927:3615:39340", -- [31]
			"22931:12616:34927:3615:52060:39330", -- [32]
			"22931:34429:4312:35139:2995:40809", -- [33]
			"22931:12616:34927:40558", -- [34]
			"22931:12616:34927:3615:52060:39330:40358:40769", -- [35]
			"22931:12616:34927:3615:7824:41215", -- [36]
			"22931:12616:3310:41140:41142", -- [37]
			"22931:12616:3310:41140", -- [38]
			"22931:12616:34927:3615:7824:41214", -- [39]
			"22931:34429:35141:41246", -- [40]
			"22931:34429:4312:6726:40473", -- [41]
			"22931:12616:34927:3615:52060:39330:39898:41605", -- [42]
			"43073:43085", -- [43]
			"22931:12616:36728:8610:37005", -- [44]
			"22931:12616:36728:8610:43328", -- [45]
			"22931:12616:36728", -- [46]
			["direct"] = "22931:43073",
			["coord"] = 1899863695,
			["m"] = 182,
			["f"] = 0,
		},
		[39175] = {
			"7824:2995", -- [1]
			"7824:16227:3310", -- [2]
			"7824:3615", -- [3]
			"15178:41605:40473:6726:35478:4312", -- [4]
			"15178:39898:44399", -- [5]
			"15178:41605:40473:6726", -- [6]
			"15178:39898", -- [7]
			"7824:16227:3310:8610", -- [8]
			"7824:16227:3310:11139", -- [9]
			"7824:40769:40358:11899", -- [10]
			"7824:3615:34927:34429:11901", -- [11]
			"7824:3615:34927:12616", -- [12]
			"7824:3615:34927:12616:22931:43073:43085:12740", -- [13]
			"7824:40769:40358:11899:52060", -- [14]
			"7824:16227", -- [15]
			"7824:3615:34927:12616:22931", -- [16]
			"7824:40769:40358", -- [17]
			"7824:3615:34927:34429", -- [18]
			"7824:3615:34927", -- [19]
			"7824:3615:34927:34943", -- [20]
			"15178:41605:40473:6726:35478:4312:35141", -- [21]
			"7824:2995:35139:35140", -- [22]
			"7824:2995:35139", -- [23]
			"15178:41605:40473:6726:35315", -- [24]
			"15178:41605:40473:6726:35478", -- [25]
			"15178:41605:40473:6726:35478:35556", -- [26]
			"15178:41605:40473:6726:35315:35562", -- [27]
			"7824:40769:40358:11899:52060:39340", -- [28]
			"7824:40769:40358:39330", -- [29]
			"7824:2995:40809", -- [30]
			"7824:3615:40558", -- [31]
			"7824:40769", -- [32]
			"7824:41215", -- [33]
			"7824:16227:3310:41140:41142", -- [34]
			"7824:16227:3310:41140", -- [35]
			"7824:41214", -- [36]
			"15178:41605:40473:6726:35478:4312:41246", -- [37]
			"15178:41605:40473", -- [38]
			"15178:41605", -- [39]
			"7824:3615:34927:12616:22931:43073", -- [40]
			"7824:3615:34927:12616:22931:43079", -- [41]
			"7824:3615:34927:12616:22931:43073:43085", -- [42]
			"7824:16227:3310:37005", -- [43]
			"7824:16227:3310:8610:43328", -- [44]
			"7824:16227:3310:36728", -- [45]
			["direct"] = "7824:15178:10583",
			["coord"] = 1890412270,
			["m"] = 201,
			["f"] = 0,
		},
		[43085] = {
			"43073:22931:34429:4312:35139:2995", -- [1]
			"43073:22931:12616:3310", -- [2]
			"43073:22931:12616:34927:3615", -- [3]
			"43073:22931:34429:4312", -- [4]
			"43073:22931:12616:34927:3615:44399", -- [5]
			"43073:22931:34429:4312:6726", -- [6]
			"43073:22931:12616:34927:3615:7824", -- [7]
			"43073:22931:12616:34927:3615:52060:39330:39898", -- [8]
			"11139:8610", -- [9]
			"43073:22931:12616:34927:3615:52060:11899", -- [10]
			"43073:22931:34429:11901", -- [11]
			"43073:22931:12616", -- [12]
			"43073:22931:12616:34927:3615:52060:39330:39898:15178", -- [13]
			"43073:22931:12616:34927:3615:52060", -- [14]
			"43073:22931:12616:34927:3615:7824:10583", -- [15]
			"43073:22931:12616:34927:3615:16227", -- [16]
			"43073:22931", -- [17]
			"43073:22931:12616:34927:3615:52060:39330:40358", -- [18]
			"43073:22931:34429", -- [19]
			"43073:22931:12616:34927", -- [20]
			"43073:22931:34429:34943", -- [21]
			"43073:22931:34429:35141", -- [22]
			"43073:22931:34429:34943:35140", -- [23]
			"43073:22931:34429:4312:35139", -- [24]
			"43073:22931:34429:4312:35315", -- [25]
			"43073:22931:34429:4312:35478", -- [26]
			"43073:22931:34429:4312:35478:35556", -- [27]
			"43073:22931:34429:4312:35315:35562", -- [28]
			"43073:22931:12616:34927:3615:7824:39175", -- [29]
			"43073:22931:12616:34927:3615:39340", -- [30]
			"43073:22931:12616:34927:3615:52060:39330", -- [31]
			"43073:22931:34429:4312:35139:2995:40809", -- [32]
			"43073:22931:12616:34927:40558", -- [33]
			"43073:22931:12616:34927:3615:52060:39330:40358:40769", -- [34]
			"43073:22931:12616:34927:3615:7824:41215", -- [35]
			"43073:22931:12616:3310:41140:41142", -- [36]
			"43073:22931:12616:3310:41140", -- [37]
			"43073:22931:12616:34927:3615:7824:41214", -- [38]
			"43073:22931:34429:35141:41246", -- [39]
			"43073:22931:34429:4312:6726:40473", -- [40]
			"43073:22931:12616:34927:3615:52060:39330:39898:41605", -- [41]
			"43073:43079", -- [42]
			"11139:8610:37005", -- [43]
			"11139:8610:43328", -- [44]
			"43073:22931:12616:36728", -- [45]
			["direct"] = "11139:12740:43073",
			["coord"] = 2422609382,
			["m"] = 182,
			["f"] = 0,
		},
		[11139] = {
			"8610:2995", -- [1]
			"8610:3310:3615", -- [2]
			"43085:43073:22931:34429:4312", -- [3]
			"8610:3310:3615:44399", -- [4]
			"43085:43073:22931:34429:4312:6726", -- [5]
			"8610:3310:7824", -- [6]
			"8610:3310:3615:52060:39330:39898", -- [7]
			"8610:3310:16227:11899", -- [8]
			"43085:43073:22931:34429:11901", -- [9]
			"8610:12616", -- [10]
			"8610:3310:3615:52060:39330:39898:15178", -- [11]
			"8610:3310:3615:52060", -- [12]
			"8610:3310:7824:10583", -- [13]
			"8610:3310:16227", -- [14]
			"43085:43073:22931", -- [15]
			"8610:3310:16227:11899:40358", -- [16]
			"43085:43073:22931:34429", -- [17]
			"8610:3310:34927", -- [18]
			"8610:12616:34943", -- [19]
			"43085:43073:22931:34429:35141", -- [20]
			"8610:12616:34943:35140", -- [21]
			"8610:3310:3615:35139", -- [22]
			"43085:43073:22931:34429:4312:35315", -- [23]
			"43085:43073:22931:34429:4312:35478", -- [24]
			"8610:2995:35556", -- [25]
			"43085:43073:22931:34429:4312:35315:35562", -- [26]
			"8610:3310:7824:39175", -- [27]
			"8610:3310:3615:39340", -- [28]
			"8610:3310:3615:52060:39330", -- [29]
			"8610:2995:40809", -- [30]
			"8610:3310:40558", -- [31]
			"8610:3310:16227:11899:40358:40769", -- [32]
			"8610:3310:7824:41215", -- [33]
			"8610:3310:41140:41142", -- [34]
			"8610:3310:41140", -- [35]
			"8610:3310:7824:41214", -- [36]
			"43085:43073:22931:34429:35141:41246", -- [37]
			"43085:43073:22931:34429:4312:6726:40473", -- [38]
			"8610:3310:3615:52060:39330:39898:41605", -- [39]
			"43085:43073", -- [40]
			"43085:43073:43079", -- [41]
			"8610:37005", -- [42]
			"8610:43328", -- [43]
			"8610:36728", -- [44]
			"41861:43481",
			"8610:3310:7824:41215:48275",
			"8610:3310:3615:52060:39330:39898:15178:48274",
			"8610:3310:7824:41215:48275:48273",
			["direct"] = "3310:8610:12740:41861:43085",
			["coord"] = 2527689644,
			["m"] = 281,
			["f"] = 0,
		},
		[41140] = {
			"3310:3615:2995", -- [1]
			"3310:3615", -- [2]
			"3310:3615:4312", -- [3]
			"3310:3615:44399", -- [4]
			"3310:3615:2995:6726", -- [5]
			"3310:7824", -- [6]
			"3310:3615:52060:39330:39898", -- [7]
			"3310:8610", -- [8]
			"3310:11139", -- [9]
			"3310:16227:11899", -- [10]
			"3310:12616:34429:11901", -- [11]
			"3310:12616", -- [12]
			"3310:11139:12740", -- [13]
			"3310:3615:52060:39330:39898:15178", -- [14]
			"3310:3615:52060", -- [15]
			"3310:7824:10583", -- [16]
			"3310:16227", -- [17]
			"3310:12616:22931", -- [18]
			"3310:16227:11899:40358", -- [19]
			"3310:12616:34429", -- [20]
			"3310:34927", -- [21]
			"3310:12616:34943", -- [22]
			"3310:12616:34429:35141", -- [23]
			"3310:12616:34943:35140", -- [24]
			"3310:3615:35139", -- [25]
			"3310:3615:2995:35556:35562:35315", -- [26]
			"3310:3615:2995:35556:35478", -- [27]
			"3310:3615:2995:35556", -- [28]
			"3310:3615:2995:35556:35562", -- [29]
			"3310:7824:39175", -- [30]
			"3310:3615:39340", -- [31]
			"3310:3615:52060:39330", -- [32]
			"3310:3615:2995:40809", -- [33]
			"3310:40558", -- [34]
			"3310:16227:11899:40358:40769", -- [35]
			"3310:7824:41215", -- [36]
			"3310:7824:41214", -- [37]
			"3310:12616:34943:35140:41246", -- [38]
			"3310:3615:2995:6726:40473", -- [39]
			"3310:3615:52060:39330:39898:41605", -- [40]
			"3310:12616:22931:43073", -- [41]
			"3310:12616:22931:43079", -- [42]
			"3310:12616:22931:43073:43085", -- [43]
			"3310:37005", -- [44]
			"3310:8610:43328", -- [45]
			"3310:36728", -- [46]
			["direct"] = "3310:41142",
			["coord"] = 2277863353,
			["m"] = 4,
			["f"] = 0,
		},
		[41142] = {
			"41140:3310:3615:2995", -- [1]
			"41140:3310", -- [2]
			"41140:3310:3615", -- [3]
			"41140:3310:3615:4312", -- [4]
			"41140:3310:3615:44399", -- [5]
			"41140:3310:3615:2995:6726", -- [6]
			"41140:3310:7824", -- [7]
			"41140:3310:3615:52060:39330:39898", -- [8]
			"41140:3310:8610", -- [9]
			"41140:3310:11139", -- [10]
			"41140:3310:16227:11899", -- [11]
			"41140:3310:12616:34429:11901", -- [12]
			"41140:3310:12616", -- [13]
			"41140:3310:11139:12740", -- [14]
			"41140:3310:3615:52060:39330:39898:15178", -- [15]
			"41140:3310:3615:52060", -- [16]
			"41140:3310:7824:10583", -- [17]
			"41140:3310:16227", -- [18]
			"41140:3310:12616:22931", -- [19]
			"41140:3310:16227:11899:40358", -- [20]
			"41140:3310:12616:34429", -- [21]
			"41140:3310:34927", -- [22]
			"41140:3310:12616:34943", -- [23]
			"41140:3310:12616:34429:35141", -- [24]
			"41140:3310:12616:34943:35140", -- [25]
			"41140:3310:3615:35139", -- [26]
			"41140:3310:3615:2995:35556:35562:35315", -- [27]
			"41140:3310:3615:2995:35556:35478", -- [28]
			"41140:3310:3615:2995:35556", -- [29]
			"41140:3310:3615:2995:35556:35562", -- [30]
			"41140:3310:7824:39175", -- [31]
			"41140:3310:3615:39340", -- [32]
			"41140:3310:3615:52060:39330", -- [33]
			"41140:3310:3615:2995:40809", -- [34]
			"41140:3310:40558", -- [35]
			"41140:3310:16227:11899:40358:40769", -- [36]
			"41140:3310:7824:41215", -- [37]
			"41140:3310:7824:41214", -- [38]
			"41140:3310:12616:34943:35140:41246", -- [39]
			"41140:3310:3615:2995:6726:40473", -- [40]
			"41140:3310:3615:52060:39330:39898:41605", -- [41]
			"41140:3310:12616:22931:43073", -- [42]
			"41140:3310:12616:22931:43079", -- [43]
			"41140:3310:12616:22931:43073:43085", -- [44]
			"41140:3310:37005", -- [45]
			"41140:3310:8610:43328", -- [46]
			"41140:3310:36728", -- [47]
			["direct"] = "41140",
			["coord"] = 2378218494,
			["m"] = 4,
			["f"] = 0,
		},
		[35478] = {
			"35556:2995", -- [1]
			"35556:2995:3310", -- [2]
			"35556:2995:3615", -- [3]
			"35556:2995:44399", -- [4]
			"35556:2995:7824", -- [5]
			"6726:39898", -- [6]
			"35556:2995:8610", -- [7]
			"35556:2995:3310:11139", -- [8]
			"35556:2995:52060:11899", -- [9]
			"4312:11901", -- [10]
			"4312:35140:34943:12616", -- [11]
			"4312:34429:22931:43073:43085:12740", -- [12]
			"6726:40473:41605:15178", -- [13]
			"35556:2995:52060", -- [14]
			"6726:40473:41605:15178:39175:10583", -- [15]
			"35556:2995:3615:16227", -- [16]
			"4312:34429:22931", -- [17]
			"35556:2995:52060:39330:40358", -- [18]
			"4312:34429", -- [19]
			"35556:2995:3615:34927", -- [20]
			"4312:35140:34943", -- [21]
			"4312:35141", -- [22]
			"4312:35140", -- [23]
			"35556:2995:35139", -- [24]
			"6726:40473:41605:15178:39175", -- [25]
			"35556:2995:39340", -- [26]
			"35556:2995:52060:39330", -- [27]
			"35556:2995:40809", -- [28]
			"35556:2995:3615:40558", -- [29]
			"35556:2995:52060:39330:40358:40769", -- [30]
			"35556:2995:7824:41215", -- [31]
			"35556:2995:3310:41140:41142", -- [32]
			"35556:2995:3310:41140", -- [33]
			"35556:2995:7824:41214", -- [34]
			"4312:41246", -- [35]
			"6726:40473", -- [36]
			"6726:40473:41605", -- [37]
			"4312:34429:22931:43073", -- [38]
			"4312:34429:22931:43079", -- [39]
			"4312:34429:22931:43073:43085", -- [40]
			"35556:2995:3310:37005", -- [41]
			"35556:2995:8610:43328", -- [42]
			"4312:35140:34943:12616:36728", -- [43]
			["direct"] = "4312:6726:35315:35556:35562",
			["coord"] = 2479390535,
			["m"] = 101,
			["f"] = 0,
		},
		[4312] = {
			"3615:3310", -- [1]
			"35139:2995:44399", -- [2]
			"35139:2995:7824", -- [3]
			"35139:2995:52060:39330:39898", -- [4]
			"35140:34943:12616:36728:8610", -- [5]
			"34429:22931:43073:43085:11139", -- [6]
			"35139:2995:52060:11899", -- [7]
			"35140:34943:12616", -- [8]
			"34429:22931:43073:43085:12740", -- [9]
			"6726:40473:41605:15178", -- [10]
			"35139:2995:52060", -- [11]
			"6726:40473:41605:15178:39175:10583", -- [12]
			"3615:16227", -- [13]
			"34429:22931", -- [14]
			"35139:2995:52060:39330:40358", -- [15]
			"35140:34927", -- [16]
			"35140:34943", -- [17]
			"35478:35556", -- [18]
			"35315:35562", -- [19]
			"6726:40473:41605:15178:39175", -- [20]
			"35139:2995:39340", -- [21]
			"35139:2995:52060:39330", -- [22]
			"35139:2995:40809", -- [23]
			"3615:40558", -- [24]
			"35139:2995:52060:39330:40358:40769", -- [25]
			"35139:2995:7824:41215", -- [26]
			"3615:3310:41140:41142", -- [27]
			"3615:3310:41140", -- [28]
			"35139:2995:7824:41214", -- [29]
			"6726:40473", -- [30]
			"6726:40473:41605", -- [31]
			"34429:22931:43073", -- [32]
			"34429:22931:43079", -- [33]
			"34429:22931:43073:43085", -- [34]
			"3615:3310:37005", -- [35]
			"35140:34943:12616:36728:8610:43328", -- [36]
			"35140:34943:12616:36728", -- [37]
			["direct"] = "2995:3615:6726:11901:34429:35141:35140:35139:35315:35478:41246",
			["coord"] = 2083233446,
			["m"] = 81,
			["f"] = 0,
		},
		[41215] = {
			"7824:2995", -- [1]
			"7824:16227:3310", -- [2]
			"7824:3615", -- [3]
			"7824:2995:35139:4312", -- [4]
			"7824:44399", -- [5]
			"7824:39898:41605:40473:6726", -- [6]
			"7824:39898", -- [7]
			"7824:16227:3310:8610", -- [8]
			"7824:16227:3310:11139", -- [9]
			"7824:40769:40358:11899", -- [10]
			"7824:3615:34927:34429:11901", -- [11]
			"7824:3615:34927:12616", -- [12]
			"7824:3615:34927:12616:22931:43073:43085:12740", -- [13]
			"7824:39175:15178", -- [14]
			"7824:40769:40358:11899:52060", -- [15]
			"7824:10583", -- [16]
			"7824:16227", -- [17]
			"7824:3615:34927:12616:22931", -- [18]
			"7824:40769:40358", -- [19]
			"7824:3615:34927:34429", -- [20]
			"7824:3615:34927", -- [21]
			"7824:3615:34927:34943", -- [22]
			"7824:2995:35139:35141", -- [23]
			"7824:2995:35139:35140", -- [24]
			"7824:2995:35139", -- [25]
			"7824:2995:35556:35562:35315", -- [26]
			"7824:2995:35556:35478", -- [27]
			"7824:2995:35556", -- [28]
			"7824:2995:35556:35562", -- [29]
			"7824:39175", -- [30]
			"7824:40769:40358:11899:52060:39340", -- [31]
			"7824:40769:40358:39330", -- [32]
			"7824:2995:40809", -- [33]
			"7824:3615:40558", -- [34]
			"7824:40769", -- [35]
			"7824:16227:3310:41140:41142", -- [36]
			"7824:16227:3310:41140", -- [37]
			"7824:2995:35139:4312:41246", -- [38]
			"7824:39898:41605:40473", -- [39]
			"7824:39898:41605", -- [40]
			"7824:3615:34927:12616:22931:43073", -- [41]
			"7824:3615:34927:12616:22931:43079", -- [42]
			"7824:3615:34927:12616:22931:43073:43085", -- [43]
			"7824:16227:3310:37005", -- [44]
			"7824:16227:3310:8610:43328", -- [45]
			"7824:16227:3310:36728", -- [46]
			["direct"] = "7824:41214",
			["coord"] = 1431946726,
			["m"] = 161,
			["f"] = 0,
		},
		[11899] = {
			"52060:3615:4312", -- [1]
			"52060:2995:6726", -- [2]
			"39330:39898", -- [3]
			"16227:3310:8610", -- [4]
			"16227:3310:11139", -- [5]
			"52060:3615:34927:34429:11901", -- [6]
			"52060:3615:34927:12616", -- [7]
			"52060:3615:34927:12616:22931:43073:43085:12740", -- [8]
			"39330:39898:15178", -- [9]
			"40358:40769:7824:10583", -- [10]
			"52060:3615:34927:12616:22931", -- [11]
			"52060:3615:34927:34429", -- [12]
			"52060:3615:34927", -- [13]
			"52060:3615:34927:34943", -- [14]
			"52060:3615:4312:35141", -- [15]
			"52060:2995:35139:35140", -- [16]
			"52060:2995:35139", -- [17]
			"52060:2995:35556:35562:35315", -- [18]
			"52060:2995:35556:35478", -- [19]
			"52060:2995:35556", -- [20]
			"52060:2995:35556:35562", -- [21]
			"40358:40769:7824:39175", -- [22]
			"52060:39340", -- [23]
			"52060:2995:40809", -- [24]
			"52060:3615:40558", -- [25]
			"40358:40769", -- [26]
			"40358:40769:7824:41215", -- [27]
			"16227:3310:41140:41142", -- [28]
			"16227:3310:41140", -- [29]
			"40358:40769:7824:41214", -- [30]
			"52060:3615:4312:41246", -- [31]
			"39330:39898:41605:40473", -- [32]
			"39330:39898:41605", -- [33]
			"52060:3615:34927:12616:22931:43073", -- [34]
			"52060:3615:34927:12616:22931:43079", -- [35]
			"52060:3615:34927:12616:22931:43073:43085", -- [36]
			"16227:3310:37005", -- [37]
			"16227:3310:8610:43328", -- [38]
			"16227:3310:36728", -- [39]
			["direct"] = "2995:3310:3615:44399:7824:52060:16227:40358:39330",
			["coord"] = 1527533948,
			["m"] = 141,
			["f"] = 0,
		},
		[39898] = {
			"44399:11899:16227:3310", -- [1]
			"35315:4312", -- [2]
			"44399:11899:16227:3310:8610", -- [3]
			"44399:11899:16227:3310:11139", -- [4]
			"44399:11899", -- [5]
			"39330:52060:3615:34927:34429:11901", -- [6]
			"39330:52060:3615:34927:12616", -- [7]
			"39330:52060:3615:34927:12616:22931:43073:43085:12740", -- [8]
			"39330:52060", -- [9]
			"15178:39175:10583", -- [10]
			"44399:11899:16227", -- [11]
			"39330:52060:3615:34927:12616:22931", -- [12]
			"44399:40358", -- [13]
			"39330:52060:3615:34927:34429", -- [14]
			"39330:52060:3615:34927", -- [15]
			"39330:52060:3615:34927:34943", -- [16]
			"35315:4312:35141", -- [17]
			"44399:2995:35139:35140", -- [18]
			"44399:2995:35139", -- [19]
			"41605:40473:6726:35478", -- [20]
			"41605:40473:6726:35478:35556", -- [21]
			"35315:35562", -- [22]
			"15178:39175", -- [23]
			"39330:39340", -- [24]
			"44399:2995:40809", -- [25]
			"39330:52060:3615:40558", -- [26]
			"44399:40769", -- [27]
			"44399:7824:41215", -- [28]
			"44399:11899:16227:3310:41140:41142", -- [29]
			"44399:11899:16227:3310:41140", -- [30]
			"44399:7824:41214", -- [31]
			"35315:4312:41246", -- [32]
			"41605:40473", -- [33]
			"39330:52060:3615:34927:12616:22931:43073", -- [34]
			"39330:52060:3615:34927:12616:22931:43079", -- [35]
			"39330:52060:3615:34927:12616:22931:43073:43085", -- [36]
			"44399:11899:16227:3310:37005", -- [37]
			"44399:11899:16227:3310:8610:43328", -- [38]
			"39330:52060:3615:34927:12616:36728", -- [39]
			["direct"] = "2995:3615:44399:6726:7824:15178:35315:39330:41605",
			["coord"] = 3239670129,
			["m"] = 121,
			["f"] = 0,
		},
		[11901] = {
			"12616:3310", -- [1]
			"3615:44399", -- [2]
			"4312:6726", -- [3]
			"35141:35139:2995:7824", -- [4]
			"3615:52060:39330:39898", -- [5]
			"12616:36728:8610", -- [6]
			"22931:43073:43085:11139", -- [7]
			"3615:52060:11899", -- [8]
			"22931:43073:43085:12740", -- [9]
			"4312:6726:40473:41605:15178", -- [10]
			"3615:52060", -- [11]
			"35141:35139:2995:7824:10583", -- [12]
			"3615:16227", -- [13]
			"3615:52060:39330:40358", -- [14]
			"34429:34943:34927", -- [15]
			"34429:34943", -- [16]
			"35141:35140", -- [17]
			"35141:35139", -- [18]
			"4312:35315", -- [19]
			"4312:35478", -- [20]
			"4312:35478:35556", -- [21]
			"4312:35315:35562", -- [22]
			"4312:6726:40473:41605:15178:39175", -- [23]
			"3615:39340", -- [24]
			"3615:52060:39330", -- [25]
			"35141:35139:2995:40809", -- [26]
			"34429:34943:34927:40558", -- [27]
			"3615:52060:39330:40358:40769", -- [28]
			"35141:35139:2995:7824:41215", -- [29]
			"12616:3310:41140:41142", -- [30]
			"12616:3310:41140", -- [31]
			"35141:35139:2995:7824:41214", -- [32]
			"35141:41246", -- [33]
			"4312:6726:40473", -- [34]
			"4312:6726:40473:41605", -- [35]
			"22931:43073", -- [36]
			"22931:43079", -- [37]
			"22931:43073:43085", -- [38]
			"12616:36728:8610:37005", -- [39]
			"12616:36728:8610:43328", -- [40]
			"12616:36728", -- [41]
			["direct"] = "2995:3615:4312:12616:22931:34429:35141",
			["coord"] = 482367484,
			["m"] = 43,
			["f"] = 0,
		},
		[34927] = {
			"3615:2995", -- [1]
			"35140:4312", -- [2]
			"3615:44399", -- [3]
			"3615:2995:6726", -- [4]
			"3615:7824", -- [5]
			"3615:52060:39330:39898", -- [6]
			"12616:36728:8610", -- [7]
			"3310:11139", -- [8]
			"3615:52060:11899", -- [9]
			"34429:11901", -- [10]
			"12616:22931:43073:43085:12740", -- [11]
			"3615:52060:39330:39898:15178", -- [12]
			"3615:52060", -- [13]
			"3615:7824:10583", -- [14]
			"3615:16227", -- [15]
			"12616:22931", -- [16]
			"3615:52060:39330:40358", -- [17]
			"34429:35141", -- [18]
			"3615:35139", -- [19]
			"35140:4312:35315", -- [20]
			"3615:2995:35556:35478", -- [21]
			"3615:2995:35556", -- [22]
			"3615:2995:35556:35562", -- [23]
			"3615:7824:39175", -- [24]
			"3615:39340", -- [25]
			"3615:52060:39330", -- [26]
			"3615:2995:40809", -- [27]
			"3615:52060:39330:40358:40769", -- [28]
			"3615:7824:41215", -- [29]
			"3310:41140:41142", -- [30]
			"3310:41140", -- [31]
			"3615:7824:41214", -- [32]
			"35140:41246", -- [33]
			"3615:2995:6726:40473", -- [34]
			"3615:52060:39330:39898:41605", -- [35]
			"12616:22931:43073", -- [36]
			"12616:22931:43079", -- [37]
			"12616:22931:43073:43085", -- [38]
			"3310:37005", -- [39]
			"12616:36728:8610:43328", -- [40]
			"12616:36728", -- [41]
			["direct"] = "3310:3615:12616:34429:34943:35140:40558",
			["coord"] = 1802381410,
			["m"] = 11,
			["f"] = 0,
		},
		[40473] = {
			"6726:35478:35556:2995", -- [1]
			"6726:35478:35556:2995:3310", -- [2]
			"6726:35139:3615", -- [3]
			"6726:35478:4312", -- [4]
			"41605:39898:44399", -- [5]
			"41605:39898:44399:7824", -- [6]
			"41605:39898", -- [7]
			"6726:35478:35556:2995:8610", -- [8]
			"6726:35478:35556:2995:3310:11139", -- [9]
			"41605:39898:44399:11899", -- [10]
			"6726:35478:4312:11901", -- [11]
			"6726:35478:4312:35140:34943:12616", -- [12]
			"6726:35478:4312:34429:22931:43073:43085:12740", -- [13]
			"41605:15178", -- [14]
			"41605:39898:39330:52060", -- [15]
			"41605:15178:39175:10583", -- [16]
			"41605:39898:44399:11899:16227", -- [17]
			"6726:35478:4312:34429:22931", -- [18]
			"41605:39898:44399:40358", -- [19]
			"6726:35478:4312:34429", -- [20]
			"6726:35139:3615:34927", -- [21]
			"6726:35478:4312:35140:34943", -- [22]
			"6726:35478:4312:35141", -- [23]
			"6726:35478:4312:35140", -- [24]
			"6726:35139", -- [25]
			"6726:35315", -- [26]
			"6726:35478", -- [27]
			"6726:35478:35556", -- [28]
			"6726:35315:35562", -- [29]
			"41605:15178:39175", -- [30]
			"6726:35478:35556:2995:39340", -- [31]
			"41605:39898:39330", -- [32]
			"6726:35478:35556:2995:40809", -- [33]
			"6726:35139:3615:40558", -- [34]
			"41605:39898:44399:40769", -- [35]
			"41605:39898:44399:7824:41215", -- [36]
			"6726:35478:35556:2995:3310:41140:41142", -- [37]
			"6726:35478:35556:2995:3310:41140", -- [38]
			"41605:39898:44399:7824:41214", -- [39]
			"6726:35478:4312:41246", -- [40]
			"6726:35478:4312:34429:22931:43073", -- [41]
			"6726:35478:4312:34429:22931:43079", -- [42]
			"6726:35478:4312:34429:22931:43073:43085", -- [43]
			"6726:35478:35556:2995:3310:37005", -- [44]
			"6726:35478:35556:2995:8610:43328", -- [45]
			"6726:35478:4312:35140:34943:12616:36728", -- [46]
			["direct"] = "6726:41605",
			["coord"] = 1780754305,
			["m"] = 121,
			["f"] = 0,
		},
		[34429] = {
			"4312:35139:2995", -- [1]
			"12616:3310", -- [2]
			"34943:34927:3615", -- [3]
			"34943:34927:3615:44399", -- [4]
			"4312:6726", -- [5]
			"34943:34927:3615:7824", -- [6]
			"34943:34927:3615:52060:39330:39898", -- [7]
			"12616:36728:8610", -- [8]
			"22931:43073:43085:11139", -- [9]
			"34943:34927:3615:52060:11899", -- [10]
			"22931:43073:43085:12740", -- [11]
			"4312:6726:40473:41605:15178", -- [12]
			"34943:34927:3615:52060", -- [13]
			"34943:34927:3615:7824:10583", -- [14]
			"34943:34927:3615:16227", -- [15]
			"34943:34927:3615:52060:39330:40358", -- [16]
			"34943:35140", -- [17]
			"4312:35139", -- [18]
			"4312:35315", -- [19]
			"4312:35478", -- [20]
			"4312:35478:35556", -- [21]
			"4312:35315:35562", -- [22]
			"34943:34927:3615:7824:39175", -- [23]
			"34943:34927:3615:39340", -- [24]
			"34943:34927:3615:52060:39330", -- [25]
			"4312:35139:2995:40809", -- [26]
			"34943:34927:40558", -- [27]
			"34943:34927:3615:52060:39330:40358:40769", -- [28]
			"34943:34927:3615:7824:41215", -- [29]
			"12616:3310:41140:41142", -- [30]
			"12616:3310:41140", -- [31]
			"34943:34927:3615:7824:41214", -- [32]
			"35141:41246", -- [33]
			"4312:6726:40473", -- [34]
			"4312:6726:40473:41605", -- [35]
			"22931:43073", -- [36]
			"22931:43079", -- [37]
			"22931:43073:43085", -- [38]
			"12616:36728:8610:37005", -- [39]
			"12616:36728:8610:43328", -- [40]
			"12616:36728", -- [41]
			["direct"] = "4312:11901:12616:22931:34927:34943:35141",
			["coord"] = 1637772326,
			["m"] = 43,
			["f"] = 0,
		},
		[35315] = {
			"35562:35556:2995", -- [1]
			"35562:35556:2995:3310", -- [2]
			"35562:35556:2995:3615", -- [3]
			"39898:44399", -- [4]
			"35562:35556:2995:7824", -- [5]
			"35562:35556:2995:8610", -- [6]
			"4312:34429:22931:43073:43085:11139", -- [7]
			"35562:35556:2995:52060:11899", -- [8]
			"4312:11901", -- [9]
			"4312:35140:34943:12616", -- [10]
			"4312:34429:22931:43073:43085:12740", -- [11]
			"6726:40473:41605:15178", -- [12]
			"35562:35556:2995:52060", -- [13]
			"6726:40473:41605:15178:39175:10583", -- [14]
			"35562:35556:2995:3615:16227", -- [15]
			"4312:34429:22931", -- [16]
			"35562:35556:2995:52060:39330:40358", -- [17]
			"4312:34429", -- [18]
			"35562:35556:2995:3615:34927", -- [19]
			"4312:35140:34943", -- [20]
			"4312:35141", -- [21]
			"4312:35140", -- [22]
			"35562:35556:2995:35139", -- [23]
			"35562:35556", -- [24]
			"6726:40473:41605:15178:39175", -- [25]
			"35562:35556:2995:39340", -- [26]
			"35562:35556:2995:52060:39330", -- [27]
			"35562:35556:2995:40809", -- [28]
			"35562:35556:2995:3615:40558", -- [29]
			"35562:35556:2995:52060:39330:40358:40769", -- [30]
			"35562:35556:2995:7824:41215", -- [31]
			"35562:35556:2995:3310:41140:41142", -- [32]
			"35562:35556:2995:3310:41140", -- [33]
			"35562:35556:2995:7824:41214", -- [34]
			"4312:41246", -- [35]
			"6726:40473", -- [36]
			"6726:40473:41605", -- [37]
			"4312:34429:22931:43073", -- [38]
			"4312:34429:22931:43079", -- [39]
			"4312:34429:22931:43073:43085", -- [40]
			"35562:35556:2995:3310:37005", -- [41]
			"35562:35556:2995:8610:43328", -- [42]
			"4312:35140:34943:12616:36728", -- [43]
			["direct"] = "4312:6726:39898:35478:35562",
			["coord"] = 1901743130,
			["m"] = 101,
			["f"] = 0,
		},
		[3615] = {
			"2995:6726", -- [1]
			"3310:11139", -- [2]
			"34927:12616:22931:43073:43085:12740", -- [3]
			"52060:39330:39898:15178", -- [4]
			"7824:10583", -- [5]
			"34927:12616:22931", -- [6]
			"52060:39330:40358", -- [7]
			"34927:34429", -- [8]
			"34927:34943", -- [9]
			"4312:35141", -- [10]
			"35139:35140", -- [11]
			"2995:35556:35562:35315", -- [12]
			"2995:35556:35478", -- [13]
			"2995:35556", -- [14]
			"2995:35556:35562", -- [15]
			"7824:39175", -- [16]
			"52060:39330", -- [17]
			"2995:40809", -- [18]
			"52060:39330:40358:40769", -- [19]
			"7824:41215", -- [20]
			"3310:41140:41142", -- [21]
			"3310:41140", -- [22]
			"7824:41214", -- [23]
			"4312:41246", -- [24]
			"2995:6726:40473", -- [25]
			"52060:39330:39898:41605", -- [26]
			"34927:12616:22931:43073", -- [27]
			"34927:12616:22931:43079", -- [28]
			"34927:12616:22931:43073:43085", -- [29]
			"3310:37005", -- [30]
			"8610:43328", -- [31]
			"34927:12616:36728", -- [32]
			["m"] = 11,
			["coord"] = 2091619965,
			["direct"] = "2995:3310:4312:44399:7824:39898:8610:11899:11901:12616:52060:16227:34927:35139:39340:40558",
			["f"] = 0,
		},
		[40558] = {
			"3615:2995", -- [1]
			"3615:4312", -- [2]
			"3615:44399", -- [3]
			"3615:2995:6726", -- [4]
			"3615:7824", -- [5]
			"3615:52060:39330:39898", -- [6]
			"3310:8610", -- [7]
			"3310:11139", -- [8]
			"3615:52060:11899", -- [9]
			"34927:34429:11901", -- [10]
			"34927:12616", -- [11]
			"34927:12616:22931:43073:43085:12740", -- [12]
			"3615:52060:39330:39898:15178", -- [13]
			"3615:52060", -- [14]
			"3615:7824:10583", -- [15]
			"3615:16227", -- [16]
			"34927:12616:22931", -- [17]
			"3615:52060:39330:40358", -- [18]
			"34927:34429", -- [19]
			"34927:34943", -- [20]
			"34927:34429:35141", -- [21]
			"34927:35140", -- [22]
			"3615:35139", -- [23]
			"3615:2995:35556:35562:35315", -- [24]
			"3615:2995:35556:35478", -- [25]
			"3615:2995:35556", -- [26]
			"3615:2995:35556:35562", -- [27]
			"3615:7824:39175", -- [28]
			"3615:39340", -- [29]
			"3615:52060:39330", -- [30]
			"3615:2995:40809", -- [31]
			"3615:52060:39330:40358:40769", -- [32]
			"3615:7824:41215", -- [33]
			"3310:41140:41142", -- [34]
			"3310:41140", -- [35]
			"3615:7824:41214", -- [36]
			"34927:35140:41246", -- [37]
			"3615:2995:6726:40473", -- [38]
			"3615:52060:39330:39898:41605", -- [39]
			"34927:12616:22931:43073", -- [40]
			"34927:12616:22931:43079", -- [41]
			"34927:12616:22931:43073:43085", -- [42]
			"3310:37005", -- [43]
			"3310:8610:43328", -- [44]
			"3310:36728", -- [45]
			["direct"] = "3310:3615:34927",
			["coord"] = 2678860788,
			["m"] = 11,
			["f"] = 0,
		},
		[34943] = {
			"35140:35139:2995", -- [1]
			"12616:3310", -- [2]
			"34927:3615", -- [3]
			"35140:4312", -- [4]
			"34927:3615:44399", -- [5]
			"35140:4312:6726", -- [6]
			"34927:3615:7824", -- [7]
			"34927:3615:52060:39330:39898", -- [8]
			"12616:36728:8610", -- [9]
			"12616:36728:8610:11139", -- [10]
			"34927:3615:52060:11899", -- [11]
			"34429:11901", -- [12]
			"34429:22931:43073:43085:12740", -- [13]
			"34927:3615:52060:39330:39898:15178", -- [14]
			"34927:3615:52060", -- [15]
			"34927:3615:7824:10583", -- [16]
			"34927:3615:16227", -- [17]
			"34429:22931", -- [18]
			"34927:3615:52060:39330:40358", -- [19]
			"34429:35141", -- [20]
			"35140:35139", -- [21]
			"35140:4312:35315", -- [22]
			"35140:4312:35478", -- [23]
			"35140:35139:2995:35556", -- [24]
			"35140:4312:35315:35562", -- [25]
			"34927:3615:7824:39175", -- [26]
			"34927:3615:39340", -- [27]
			"34927:3615:52060:39330", -- [28]
			"35140:35139:2995:40809", -- [29]
			"34927:40558", -- [30]
			"34927:3615:52060:39330:40358:40769", -- [31]
			"34927:3615:7824:41215", -- [32]
			"12616:3310:41140:41142", -- [33]
			"12616:3310:41140", -- [34]
			"34927:3615:7824:41214", -- [35]
			"35140:41246", -- [36]
			"35140:4312:6726:40473", -- [37]
			"34927:3615:52060:39330:39898:41605", -- [38]
			"34429:22931:43073", -- [39]
			"34429:22931:43079", -- [40]
			"34429:22931:43073:43085", -- [41]
			"12616:36728:8610:37005", -- [42]
			"12616:36728:8610:43328", -- [43]
			"12616:36728", -- [44]
			["direct"] = "12616:34429:34927:35140",
			["coord"] = 2118231907,
			["m"] = 43,
			["f"] = 0,
		},
		[10583] = {
			"7824:2995", -- [1]
			"7824:16227:3310", -- [2]
			"7824:3615", -- [3]
			"7824:2995:35139:4312", -- [4]
			"7824:44399", -- [5]
			"39175:15178:41605:40473:6726", -- [6]
			"39175:15178:39898", -- [7]
			"7824:16227:3310:8610", -- [8]
			"7824:16227:3310:11139", -- [9]
			"7824:40769:40358:11899", -- [10]
			"7824:3615:34927:34429:11901", -- [11]
			"7824:3615:34927:12616", -- [12]
			"7824:3615:34927:12616:22931:43073:43085:12740", -- [13]
			"7824:40769:40358:11899:52060", -- [14]
			"7824:16227", -- [15]
			"7824:3615:34927:12616:22931", -- [16]
			"7824:40769:40358", -- [17]
			"7824:3615:34927:34429", -- [18]
			"7824:3615:34927", -- [19]
			"7824:3615:34927:34943", -- [20]
			"7824:2995:35139:35141", -- [21]
			"7824:2995:35139:35140", -- [22]
			"7824:2995:35139", -- [23]
			"39175:15178:41605:40473:6726:35315", -- [24]
			"39175:15178:41605:40473:6726:35478", -- [25]
			"7824:2995:35556", -- [26]
			"39175:15178:41605:40473:6726:35315:35562", -- [27]
			"7824:40769:40358:11899:52060:39340", -- [28]
			"7824:40769:40358:39330", -- [29]
			"7824:2995:40809", -- [30]
			"7824:3615:40558", -- [31]
			"7824:40769", -- [32]
			"7824:41215", -- [33]
			"7824:16227:3310:41140:41142", -- [34]
			"7824:16227:3310:41140", -- [35]
			"7824:41214", -- [36]
			"7824:2995:35139:4312:41246", -- [37]
			"39175:15178:41605:40473", -- [38]
			"39175:15178:41605", -- [39]
			"7824:3615:34927:12616:22931:43073", -- [40]
			"7824:3615:34927:12616:22931:43079", -- [41]
			"7824:3615:34927:12616:22931:43073:43085", -- [42]
			"7824:16227:3310:37005", -- [43]
			"7824:16227:3310:8610:43328", -- [44]
			"7824:16227:3310:36728", -- [45]
			["direct"] = "7824:15178:39175",
			["coord"] = 2408031263,
			["m"] = 201,
			["f"] = 0,
		},
		[6726] = {
			"35478:35556:2995:3310", -- [1]
			"35139:3615", -- [2]
			"39898:44399", -- [3]
			"39898:44399:7824", -- [4]
			"35478:35556:2995:8610", -- [5]
			"35478:35556:2995:3310:11139", -- [6]
			"35478:35556:2995:52060:11899", -- [7]
			"35478:4312:11901", -- [8]
			"35478:4312:35140:34943:12616", -- [9]
			"35478:4312:34429:22931:43073:43085:12740", -- [10]
			"40473:41605:15178", -- [11]
			"35478:35556:2995:52060", -- [12]
			"40473:41605:15178:39175:10583", -- [13]
			"35139:3615:16227", -- [14]
			"35478:4312:34429:22931", -- [15]
			"39898:44399:40358", -- [16]
			"35478:4312:34429", -- [17]
			"35139:3615:34927", -- [18]
			"35478:4312:35140:34943", -- [19]
			"35478:4312:35141", -- [20]
			"35478:4312:35140", -- [21]
			"35478:35556", -- [22]
			"40473:41605:15178:39175", -- [23]
			"35478:35556:2995:39340", -- [24]
			"35478:35556:2995:52060:39330", -- [25]
			"35478:35556:2995:40809", -- [26]
			"35139:3615:40558", -- [27]
			"39898:44399:40769", -- [28]
			"39898:44399:7824:41215", -- [29]
			"35478:35556:2995:3310:41140:41142", -- [30]
			"35478:35556:2995:3310:41140", -- [31]
			"39898:44399:7824:41214", -- [32]
			"35478:4312:41246", -- [33]
			"40473:41605", -- [34]
			"35478:4312:34429:22931:43073", -- [35]
			"35478:4312:34429:22931:43079", -- [36]
			"35478:4312:34429:22931:43073:43085", -- [37]
			"35478:35556:2995:3310:37005", -- [38]
			"35478:35556:2995:8610:43328", -- [39]
			"35478:4312:35140:34943:12616:36728", -- [40]
			["direct"] = "2995:4312:39898:35139:35315:35478:35562:40473",
			["coord"] = 926137740,
			["m"] = 101,
			["f"] = 0,
		},
		[43328] = {
			"8610:2995", -- [1]
			"8610:3310", -- [2]
			"8610:3310:3615", -- [3]
			"8610:12616:34943:35140:4312", -- [4]
			"8610:3310:3615:44399", -- [5]
			"8610:2995:6726", -- [6]
			"8610:3310:7824", -- [7]
			"8610:3310:3615:52060:39330:39898", -- [8]
			"8610:11139", -- [9]
			"8610:3310:16227:11899", -- [10]
			"8610:12616:34429:11901", -- [11]
			"8610:12616", -- [12]
			"8610:11139:12740", -- [13]
			"8610:3310:3615:52060:39330:39898:15178", -- [14]
			"8610:3310:3615:52060", -- [15]
			"8610:3310:7824:10583", -- [16]
			"8610:3310:16227", -- [17]
			"8610:12616:22931", -- [18]
			"8610:3310:16227:11899:40358", -- [19]
			"8610:12616:34429", -- [20]
			"8610:3310:34927", -- [21]
			"8610:12616:34943", -- [22]
			"8610:12616:34429:35141", -- [23]
			"8610:12616:34943:35140", -- [24]
			"8610:3310:3615:35139", -- [25]
			"8610:12616:34943:35140:4312:35315", -- [26]
			"8610:2995:35556:35478", -- [27]
			"8610:2995:35556", -- [28]
			"8610:2995:35556:35562", -- [29]
			"8610:3310:7824:39175", -- [30]
			"8610:3310:3615:39340", -- [31]
			"8610:3310:3615:52060:39330", -- [32]
			"8610:2995:40809", -- [33]
			"8610:3310:40558", -- [34]
			"8610:3310:16227:11899:40358:40769", -- [35]
			"8610:3310:7824:41215", -- [36]
			"8610:3310:41140:41142", -- [37]
			"8610:3310:41140", -- [38]
			"8610:3310:7824:41214", -- [39]
			"8610:12616:34943:35140:41246", -- [40]
			"8610:2995:6726:40473", -- [41]
			"8610:3310:3615:52060:39330:39898:41605", -- [42]
			"8610:11139:43085:43073", -- [43]
			"8610:12616:22931:43079", -- [44]
			"8610:11139:43085", -- [45]
			"8610:37005", -- [46]
			"8610:36728", -- [47]
			["direct"] = "8610",
			["coord"] = 2857448857,
			["m"] = 181,
			["f"] = 0,
		},
		[35140] = {
			"35139:2995", -- [1]
			"34927:3310", -- [2]
			"35139:3615", -- [3]
			"35139:2995:44399", -- [4]
			"4312:6726", -- [5]
			"35139:2995:7824", -- [6]
			"35139:2995:52060:39330:39898", -- [7]
			"34943:12616:36728:8610", -- [8]
			"34943:12616:36728:8610:11139", -- [9]
			"35139:2995:52060:11899", -- [10]
			"35141:11901", -- [11]
			"34943:12616", -- [12]
			"34943:34429:22931:43073:43085:12740", -- [13]
			"4312:6726:40473:41605:15178", -- [14]
			"35139:2995:52060", -- [15]
			"35139:2995:7824:10583", -- [16]
			"35139:3615:16227", -- [17]
			"34943:34429:22931", -- [18]
			"35139:2995:52060:39330:40358", -- [19]
			"34943:34429", -- [20]
			"4312:35315", -- [21]
			"4312:35478", -- [22]
			"35139:2995:35556", -- [23]
			"4312:35315:35562", -- [24]
			"35139:2995:7824:39175", -- [25]
			"35139:2995:39340", -- [26]
			"35139:2995:52060:39330", -- [27]
			"35139:2995:40809", -- [28]
			"34927:40558", -- [29]
			"35139:2995:52060:39330:40358:40769", -- [30]
			"35139:2995:7824:41215", -- [31]
			"34927:3310:41140:41142", -- [32]
			"34927:3310:41140", -- [33]
			"35139:2995:7824:41214", -- [34]
			"4312:6726:40473", -- [35]
			"4312:6726:40473:41605", -- [36]
			"34943:34429:22931:43073", -- [37]
			"34943:34429:22931:43079", -- [38]
			"34943:34429:22931:43073:43085", -- [39]
			"34927:3310:37005", -- [40]
			"34943:12616:36728:8610:43328", -- [41]
			"34943:12616:36728", -- [42]
			["direct"] = "4312:34927:34943:35141:35139:41246",
			["coord"] = 2856034532,
			["m"] = 81,
			["f"] = 0,
		},
		[44399] = {
			"11899:16227:3310", -- [1]
			"3615:4312", -- [2]
			"39898:41605:40473:6726", -- [3]
			"11899:16227:3310:8610", -- [4]
			"11899:16227:3310:11139", -- [5]
			"3615:34927:34429:11901", -- [6]
			"3615:34927:12616", -- [7]
			"3615:34927:12616:22931:43073:43085:12740", -- [8]
			"39898:15178", -- [9]
			"7824:10583", -- [10]
			"11899:16227", -- [11]
			"3615:34927:12616:22931", -- [12]
			"3615:34927:34429", -- [13]
			"3615:34927", -- [14]
			"3615:34927:34943", -- [15]
			"2995:35139:35141", -- [16]
			"2995:35139:35140", -- [17]
			"2995:35139", -- [18]
			"39898:35315", -- [19]
			"39898:41605:40473:6726:35478", -- [20]
			"2995:35556", -- [21]
			"39898:35315:35562", -- [22]
			"7824:39175", -- [23]
			"52060:39340", -- [24]
			"2995:40809", -- [25]
			"3615:40558", -- [26]
			"7824:41215", -- [27]
			"11899:16227:3310:41140:41142", -- [28]
			"11899:16227:3310:41140", -- [29]
			"7824:41214", -- [30]
			"3615:4312:41246", -- [31]
			"39898:41605:40473", -- [32]
			"39898:41605", -- [33]
			"3615:34927:12616:22931:43073", -- [34]
			"3615:34927:12616:22931:43079", -- [35]
			"3615:34927:12616:22931:43073:43085", -- [36]
			"11899:16227:3310:37005", -- [37]
			"11899:16227:3310:8610:43328", -- [38]
			"3615:34927:12616:36728", -- [39]
			["direct"] = "2995:3615:7824:39898:11899:52060:40358:39330:40769",
			["coord"] = 481893892,
			["m"] = 61,
			["f"] = 0,
		},
		[22931] = {
			"34429:4312:35139:2995", -- [1]
			"12616:3310", -- [2]
			"12616:34927:3615", -- [3]
			"34429:4312", -- [4]
			"12616:34927:3615:44399", -- [5]
			"34429:4312:6726", -- [6]
			"12616:34927:3615:7824", -- [7]
			"12616:34927:3615:52060:39330:39898", -- [8]
			"12616:36728:8610", -- [9]
			"43073:43085:11139", -- [10]
			"12616:34927:3615:52060:11899", -- [11]
			"43073:43085:12740", -- [12]
			"12616:34927:3615:52060:39330:39898:15178", -- [13]
			"12616:34927:3615:52060", -- [14]
			"12616:34927:3615:7824:10583", -- [15]
			"12616:34927:3615:16227", -- [16]
			"12616:34927:3615:52060:39330:40358", -- [17]
			"12616:34927", -- [18]
			"34429:34943", -- [19]
			"34429:35141", -- [20]
			"34429:34943:35140", -- [21]
			"34429:4312:35139", -- [22]
			"34429:4312:35315", -- [23]
			"34429:4312:35478", -- [24]
			"34429:4312:35478:35556", -- [25]
			"34429:4312:35315:35562", -- [26]
			"12616:34927:3615:7824:39175", -- [27]
			"12616:34927:3615:39340", -- [28]
			"12616:34927:3615:52060:39330", -- [29]
			"34429:4312:35139:2995:40809", -- [30]
			"12616:34927:40558", -- [31]
			"12616:34927:3615:52060:39330:40358:40769", -- [32]
			"12616:34927:3615:7824:41215", -- [33]
			"12616:3310:41140:41142", -- [34]
			"12616:3310:41140", -- [35]
			"12616:34927:3615:7824:41214", -- [36]
			"34429:35141:41246", -- [37]
			"34429:4312:6726:40473", -- [38]
			"12616:34927:3615:52060:39330:39898:41605", -- [39]
			"43073:43085", -- [40]
			"12616:36728:8610:37005", -- [41]
			"12616:36728:8610:43328", -- [42]
			"12616:36728", -- [43]
			["direct"] = "11901:12616:34429:43073:43079",
			["coord"] = 2212089544,
			["m"] = 182,
			["f"] = 0,
		},
		[40809] = {
			"2995:3310", -- [1]
			"2995:3615", -- [2]
			"2995:35139:4312", -- [3]
			"2995:44399", -- [4]
			"2995:6726", -- [5]
			"2995:7824", -- [6]
			"2995:52060:39330:39898", -- [7]
			"2995:8610", -- [8]
			"2995:3310:11139", -- [9]
			"2995:52060:11899", -- [10]
			"2995:35139:35141:11901", -- [11]
			"2995:3615:34927:12616", -- [12]
			"2995:3615:34927:12616:22931:43073:43085:12740", -- [13]
			"2995:52060:39330:39898:15178", -- [14]
			"2995:52060", -- [15]
			"2995:7824:10583", -- [16]
			"2995:3615:16227", -- [17]
			"2995:3615:34927:12616:22931", -- [18]
			"2995:52060:39330:40358", -- [19]
			"2995:35139:4312:34429", -- [20]
			"2995:3615:34927", -- [21]
			"2995:35139:35140:34943", -- [22]
			"2995:35139:35141", -- [23]
			"2995:35139:35140", -- [24]
			"2995:35139", -- [25]
			"2995:35556:35562:35315", -- [26]
			"2995:35556:35478", -- [27]
			"2995:35556", -- [28]
			"2995:35556:35562", -- [29]
			"2995:7824:39175", -- [30]
			"2995:39340", -- [31]
			"2995:52060:39330", -- [32]
			"2995:3615:40558", -- [33]
			"2995:52060:39330:40358:40769", -- [34]
			"2995:7824:41215", -- [35]
			"2995:3310:41140:41142", -- [36]
			"2995:3310:41140", -- [37]
			"2995:7824:41214", -- [38]
			"2995:35139:4312:41246", -- [39]
			"2995:6726:40473", -- [40]
			"2995:52060:39330:39898:41605", -- [41]
			"2995:3615:34927:12616:22931:43073", -- [42]
			"2995:3615:34927:12616:22931:43079", -- [43]
			"2995:3615:34927:12616:22931:43073:43085", -- [44]
			"2995:3310:37005", -- [45]
			"2995:8610:43328", -- [46]
			"2995:3615:34927:12616:36728", -- [47]
			["direct"] = "2995",
			["coord"] = 2035783201,
			["m"] = 9,
			["f"] = 0,
		},
		[37005] = {
			"3310:3615:2995", -- [1]
			"3310:3615", -- [2]
			"3310:3615:4312", -- [3]
			"3310:3615:44399", -- [4]
			"3310:3615:2995:6726", -- [5]
			"3310:7824", -- [6]
			"3310:3615:52060:39330:39898", -- [7]
			"8610:11139", -- [8]
			"3310:16227:11899", -- [9]
			"3310:12616:34429:11901", -- [10]
			"3310:12616", -- [11]
			"8610:11139:12740", -- [12]
			"3310:3615:52060:39330:39898:15178", -- [13]
			"3310:3615:52060", -- [14]
			"3310:7824:10583", -- [15]
			"3310:16227", -- [16]
			"3310:12616:22931", -- [17]
			"3310:16227:11899:40358", -- [18]
			"3310:12616:34429", -- [19]
			"3310:34927", -- [20]
			"3310:12616:34943", -- [21]
			"3310:12616:34429:35141", -- [22]
			"3310:12616:34943:35140", -- [23]
			"3310:3615:35139", -- [24]
			"3310:3615:2995:35556:35562:35315", -- [25]
			"3310:3615:2995:35556:35478", -- [26]
			"3310:3615:2995:35556", -- [27]
			"3310:3615:2995:35556:35562", -- [28]
			"3310:7824:39175", -- [29]
			"3310:3615:39340", -- [30]
			"3310:3615:52060:39330", -- [31]
			"3310:3615:2995:40809", -- [32]
			"3310:40558", -- [33]
			"3310:16227:11899:40358:40769", -- [34]
			"3310:7824:41215", -- [35]
			"3310:41140:41142", -- [36]
			"3310:41140", -- [37]
			"3310:7824:41214", -- [38]
			"3310:12616:34943:35140:41246", -- [39]
			"3310:3615:2995:6726:40473", -- [40]
			"3310:3615:52060:39330:39898:41605", -- [41]
			"8610:11139:43085:43073", -- [42]
			"3310:12616:22931:43079", -- [43]
			"8610:11139:43085", -- [44]
			"8610:43328", -- [45]
			"8610:36728", -- [46]
			["direct"] = "3310:8610",
			["coord"] = 2213068365,
			["m"] = 181,
			["f"] = 0,
		},
		[7824] = {
			"2995:35139:4312", -- [1]
			"39898:41605:40473:6726", -- [2]
			"16227:3310:8610", -- [3]
			"16227:3310:11139", -- [4]
			"3615:34927:34429:11901", -- [5]
			"3615:34927:12616", -- [6]
			"3615:34927:12616:22931:43073:43085:12740", -- [7]
			"40769:40358:11899:52060", -- [8]
			"3615:34927:12616:22931", -- [9]
			"40769:40358", -- [10]
			"3615:34927:34429", -- [11]
			"3615:34927", -- [12]
			"3615:34927:34943", -- [13]
			"2995:35139:35141", -- [14]
			"2995:35139:35140", -- [15]
			"2995:35139", -- [16]
			"2995:35556:35562:35315", -- [17]
			"2995:35556:35478", -- [18]
			"2995:35556", -- [19]
			"2995:35556:35562", -- [20]
			"40769:40358:11899:52060:39340", -- [21]
			"40769:40358:39330", -- [22]
			"2995:40809", -- [23]
			"3615:40558", -- [24]
			"16227:3310:41140:41142", -- [25]
			"16227:3310:41140", -- [26]
			"2995:35139:4312:41246", -- [27]
			"39898:41605:40473", -- [28]
			"39898:41605", -- [29]
			"3615:34927:12616:22931:43073", -- [30]
			"3615:34927:12616:22931:43079", -- [31]
			"3615:34927:12616:22931:43073:43085", -- [32]
			"16227:3310:37005", -- [33]
			"16227:3310:8610:43328", -- [34]
			"16227:3310:36728", -- [35]
			["direct"] = "2995:3310:3615:44399:39898:11899:15178:10583:16227:39175:40769:41215:41214",
			["coord"] = 2233747058,
			["m"] = 161,
			["f"] = 0,
		},
		[2995] = {
			"3310:11139", -- [1]
			"3615:34927:12616", -- [2]
			"3615:34927:12616:22931:43073:43085:12740", -- [3]
			"52060:39330:39898:15178", -- [4]
			"7824:10583", -- [5]
			"3615:16227", -- [6]
			"3615:34927:12616:22931", -- [7]
			"52060:39330:40358", -- [8]
			"35139:4312:34429", -- [9]
			"3615:34927", -- [10]
			"35139:35140:34943", -- [11]
			"35139:35141", -- [12]
			"35139:35140", -- [13]
			"35556:35562:35315", -- [14]
			"35556:35478", -- [15]
			"35556:35562", -- [16]
			"7824:39175", -- [17]
			"52060:39330", -- [18]
			"3615:40558", -- [19]
			"52060:39330:40358:40769", -- [20]
			"7824:41215", -- [21]
			"3310:41140:41142", -- [22]
			"3310:41140", -- [23]
			"7824:41214", -- [24]
			"35139:4312:41246", -- [25]
			"6726:40473", -- [26]
			"52060:39330:39898:41605", -- [27]
			"3615:34927:12616:22931:43073", -- [28]
			"3615:34927:12616:22931:43079", -- [29]
			"3615:34927:12616:22931:43073:43085", -- [30]
			"3310:37005", -- [31]
			"8610:43328", -- [32]
			"3615:34927:12616:36728", -- [33]
			["direct"] = "3310:3615:4312:44399:6726:7824:39898:8610:11899:11901:52060:35139:35556:39340:40809",
			["coord"] = 2003795901,
			["m"] = 362,
			["f"] = 0,
		},
		[40769] = {
			"40358:11899:52060:2995", -- [1]
			"40358:11899:16227:3310", -- [2]
			"40358:11899:52060:3615", -- [3]
			"40358:11899:52060:3615:4312", -- [4]
			"44399:39898:41605:40473:6726", -- [5]
			"44399:39898", -- [6]
			"40358:11899:16227:3310:8610", -- [7]
			"40358:11899:16227:3310:11139", -- [8]
			"40358:11899", -- [9]
			"40358:11899:52060:3615:34927:34429:11901", -- [10]
			"40358:11899:52060:3615:34927:12616", -- [11]
			"40358:11899:52060:3615:34927:12616:22931:43073:43085:12740", -- [12]
			"7824:39175:15178", -- [13]
			"40358:11899:52060", -- [14]
			"7824:10583", -- [15]
			"40358:11899:16227", -- [16]
			"40358:11899:52060:3615:34927:12616:22931", -- [17]
			"40358:11899:52060:3615:34927:34429", -- [18]
			"40358:11899:52060:3615:34927", -- [19]
			"40358:11899:52060:3615:34927:34943", -- [20]
			"40358:11899:52060:3615:4312:35141", -- [21]
			"40358:11899:52060:2995:35139:35140", -- [22]
			"40358:11899:52060:2995:35139", -- [23]
			"44399:39898:35315", -- [24]
			"40358:11899:52060:2995:35556:35478", -- [25]
			"40358:11899:52060:2995:35556", -- [26]
			"40358:11899:52060:2995:35556:35562", -- [27]
			"7824:39175", -- [28]
			"40358:11899:52060:39340", -- [29]
			"40358:39330", -- [30]
			"40358:11899:52060:2995:40809", -- [31]
			"40358:11899:52060:3615:40558", -- [32]
			"7824:41215", -- [33]
			"40358:11899:16227:3310:41140:41142", -- [34]
			"40358:11899:16227:3310:41140", -- [35]
			"7824:41214", -- [36]
			"40358:11899:52060:3615:4312:41246", -- [37]
			"44399:39898:41605:40473", -- [38]
			"44399:39898:41605", -- [39]
			"40358:11899:52060:3615:34927:12616:22931:43073", -- [40]
			"40358:11899:52060:3615:34927:12616:22931:43079", -- [41]
			"40358:11899:52060:3615:34927:12616:22931:43073:43085", -- [42]
			"40358:11899:16227:3310:37005", -- [43]
			"40358:11899:16227:3310:8610:43328", -- [44]
			"40358:11899:16227:3310:36728", -- [45]
			["direct"] = "44399:7824:40358",
			["coord"] = 3397040136,
			["m"] = 61,
			["f"] = 0,
		},
		[16227] = {
			"3615:2995", -- [1]
			"3615:4312", -- [2]
			"11899:44399", -- [3]
			"3615:2995:6726", -- [4]
			"11899:39330:39898", -- [5]
			"3310:8610", -- [6]
			"3310:11139", -- [7]
			"3615:34927:34429:11901", -- [8]
			"3615:34927:12616", -- [9]
			"3615:34927:12616:22931:43073:43085:12740", -- [10]
			"11899:39330:39898:15178", -- [11]
			"3615:52060", -- [12]
			"7824:10583", -- [13]
			"3615:34927:12616:22931", -- [14]
			"11899:40358", -- [15]
			"3615:34927:34429", -- [16]
			"3615:34927", -- [17]
			"3615:34927:34943", -- [18]
			"3615:4312:35141", -- [19]
			"3615:35139:35140", -- [20]
			"3615:35139", -- [21]
			"3615:2995:35556:35562:35315", -- [22]
			"3615:2995:35556:35478", -- [23]
			"3615:2995:35556", -- [24]
			"3615:2995:35556:35562", -- [25]
			"7824:39175", -- [26]
			"3615:39340", -- [27]
			"11899:39330", -- [28]
			"3615:2995:40809", -- [29]
			"3615:40558", -- [30]
			"11899:40358:40769", -- [31]
			"7824:41215", -- [32]
			"3310:41140:41142", -- [33]
			"3310:41140", -- [34]
			"7824:41214", -- [35]
			"3615:4312:41246", -- [36]
			"11899:39330:39898:41605:40473", -- [37]
			"11899:39330:39898:41605", -- [38]
			"3615:34927:12616:22931:43073", -- [39]
			"3615:34927:12616:22931:43079", -- [40]
			"3615:34927:12616:22931:43073:43085", -- [41]
			"3310:37005", -- [42]
			"3310:8610:43328", -- [43]
			"3310:36728", -- [44]
			["direct"] = "3310:3615:7824:11899",
			["coord"] = 2971382974,
			["m"] = 11,
			["f"] = 0,
		},
		[15178] = {
			"39898:44399:2995", -- [1]
			"39898:44399:11899:16227:3310", -- [2]
			"39898:39330:52060:3615", -- [3]
			"41605:40473:6726:35478:4312", -- [4]
			"39898:44399", -- [5]
			"41605:40473:6726", -- [6]
			"39898:44399:11899:16227:3310:8610", -- [7]
			"39898:44399:11899:16227:3310:11139", -- [8]
			"39898:44399:11899", -- [9]
			"41605:40473:6726:35478:4312:11901", -- [10]
			"39898:39330:52060:3615:34927:12616", -- [11]
			"39898:39330:52060:3615:34927:12616:22931:43073:43085:12740", -- [12]
			"39898:39330:52060", -- [13]
			"39898:44399:11899:16227", -- [14]
			"39898:39330:52060:3615:34927:12616:22931", -- [15]
			"39898:44399:40358", -- [16]
			"39898:39330:52060:3615:34927:34429", -- [17]
			"39898:39330:52060:3615:34927", -- [18]
			"39898:39330:52060:3615:34927:34943", -- [19]
			"41605:40473:6726:35478:4312:35141", -- [20]
			"41605:40473:6726:35478:4312:35140", -- [21]
			"41605:40473:6726:35139", -- [22]
			"41605:40473:6726:35315", -- [23]
			"41605:40473:6726:35478", -- [24]
			"41605:40473:6726:35478:35556", -- [25]
			"41605:40473:6726:35315:35562", -- [26]
			"39898:39330:39340", -- [27]
			"39898:39330", -- [28]
			"39898:44399:2995:40809", -- [29]
			"39898:39330:52060:3615:40558", -- [30]
			"39175:7824:40769", -- [31]
			"39175:7824:41215", -- [32]
			"39898:44399:11899:16227:3310:41140:41142", -- [33]
			"39898:44399:11899:16227:3310:41140", -- [34]
			"39175:7824:41214", -- [35]
			"41605:40473:6726:35478:4312:41246", -- [36]
			"41605:40473", -- [37]
			"39898:39330:52060:3615:34927:12616:22931:43073", -- [38]
			"39898:39330:52060:3615:34927:12616:22931:43079", -- [39]
			"39898:39330:52060:3615:34927:12616:22931:43073:43085", -- [40]
			"39898:44399:11899:16227:3310:37005", -- [41]
			"39898:44399:11899:16227:3310:8610:43328", -- [42]
			"39898:39330:52060:3615:34927:12616:36728", -- [43]
			["direct"] = "7824:39898:10583:39175:41605",
			["coord"] = 2271762630,
			["m"] = 261,
			["f"] = 0,
		},
		[41605] = {
			"40473:6726:35478:35556:2995", -- [1]
			"39898:44399:11899:16227:3310", -- [2]
			"39898:39330:52060:3615", -- [3]
			"40473:6726:35478:4312", -- [4]
			"39898:44399", -- [5]
			"40473:6726", -- [6]
			"39898:44399:7824", -- [7]
			"39898:44399:11899:16227:3310:8610", -- [8]
			"39898:44399:11899:16227:3310:11139", -- [9]
			"39898:44399:11899", -- [10]
			"40473:6726:35478:4312:11901", -- [11]
			"39898:39330:52060:3615:34927:12616", -- [12]
			"39898:39330:52060:3615:34927:12616:22931:43073:43085:12740", -- [13]
			"39898:39330:52060", -- [14]
			"15178:39175:10583", -- [15]
			"39898:44399:11899:16227", -- [16]
			"39898:39330:52060:3615:34927:12616:22931", -- [17]
			"39898:44399:40358", -- [18]
			"40473:6726:35478:4312:34429", -- [19]
			"39898:39330:52060:3615:34927", -- [20]
			"40473:6726:35478:4312:35140:34943", -- [21]
			"40473:6726:35478:4312:35141", -- [22]
			"40473:6726:35478:4312:35140", -- [23]
			"40473:6726:35139", -- [24]
			"40473:6726:35315", -- [25]
			"40473:6726:35478", -- [26]
			"40473:6726:35478:35556", -- [27]
			"40473:6726:35315:35562", -- [28]
			"15178:39175", -- [29]
			"39898:39330:39340", -- [30]
			"39898:39330", -- [31]
			"40473:6726:35478:35556:2995:40809", -- [32]
			"39898:39330:52060:3615:40558", -- [33]
			"39898:44399:40769", -- [34]
			"39898:44399:7824:41215", -- [35]
			"39898:44399:11899:16227:3310:41140:41142", -- [36]
			"39898:44399:11899:16227:3310:41140", -- [37]
			"39898:44399:7824:41214", -- [38]
			"40473:6726:35478:4312:41246", -- [39]
			"39898:39330:52060:3615:34927:12616:22931:43073", -- [40]
			"39898:39330:52060:3615:34927:12616:22931:43079", -- [41]
			"39898:39330:52060:3615:34927:12616:22931:43073:43085", -- [42]
			"39898:44399:11899:16227:3310:37005", -- [43]
			"39898:44399:11899:16227:3310:8610:43328", -- [44]
			"39898:39330:52060:3615:34927:12616:36728", -- [45]
			["direct"] = "39898:15178:40473",
			["coord"] = 2189786049,
			["m"] = 121,
			["f"] = 0,
		},
		[3310] = {
			"3615:4312", -- [1]
			"3615:44399", -- [2]
			"3615:2995:6726", -- [3]
			"3615:52060:39330:39898", -- [4]
			"12616:34429:11901", -- [5]
			"11139:12740", -- [6]
			"3615:52060:39330:39898:15178", -- [7]
			"3615:52060", -- [8]
			"7824:10583", -- [9]
			"12616:22931", -- [10]
			"16227:11899:40358", -- [11]
			"12616:34429", -- [12]
			"12616:34943", -- [13]
			"12616:34429:35141", -- [14]
			"12616:34943:35140", -- [15]
			"3615:35139", -- [16]
			"3615:2995:35556:35562:35315", -- [17]
			"3615:2995:35556:35478", -- [18]
			"3615:2995:35556", -- [19]
			"3615:2995:35556:35562", -- [20]
			"7824:39175", -- [21]
			"3615:39340", -- [22]
			"3615:52060:39330", -- [23]
			"3615:2995:40809", -- [24]
			"16227:11899:40358:40769", -- [25]
			"7824:41215", -- [26]
			"41140:41142", -- [27]
			"7824:41214", -- [28]
			"12616:34943:35140:41246", -- [29]
			"3615:2995:6726:40473", -- [30]
			"3615:52060:39330:39898:41605", -- [31]
			"12616:22931:43073", -- [32]
			"12616:22931:43079", -- [33]
			"12616:22931:43073:43085", -- [34]
			"8610:43328", -- [35]
			["direct"] = "2995:3615:7824:8610:11139:11899:12616:16227:34927:40558:41140:37005:36728",
			["coord"] = 2125043581,
			["m"] = 321,
			["f"] = 1,
		},
		[35141] = {
			"35139:2995", -- [1]
			"34429:12616:3310", -- [2]
			"35139:3615", -- [3]
			"35139:2995:44399", -- [4]
			"41246:4312:6726", -- [5]
			"35139:2995:7824", -- [6]
			"35139:2995:52060:39330:39898", -- [7]
			"34429:12616:36728:8610", -- [8]
			"34429:22931:43073:43085:11139", -- [9]
			"35139:2995:52060:11899", -- [10]
			"34429:12616", -- [11]
			"34429:22931:43073:43085:12740", -- [12]
			"41246:4312:6726:40473:41605:15178", -- [13]
			"35139:2995:52060", -- [14]
			"35139:2995:7824:10583", -- [15]
			"35139:3615:16227", -- [16]
			"34429:22931", -- [17]
			"35139:2995:52060:39330:40358", -- [18]
			"35140:34927", -- [19]
			"35140:34943", -- [20]
			"41246:4312:35315", -- [21]
			"41246:4312:35478", -- [22]
			"41246:4312:35478:35556", -- [23]
			"41246:4312:35315:35562", -- [24]
			"41246:4312:6726:40473:41605:15178:39175", -- [25]
			"35139:2995:39340", -- [26]
			"35139:2995:52060:39330", -- [27]
			"35139:2995:40809", -- [28]
			"35139:3615:40558", -- [29]
			"35139:2995:52060:39330:40358:40769", -- [30]
			"35139:2995:7824:41215", -- [31]
			"34429:12616:3310:41140:41142", -- [32]
			"34429:12616:3310:41140", -- [33]
			"35139:2995:7824:41214", -- [34]
			"41246:4312:6726:40473", -- [35]
			"41246:4312:6726:40473:41605", -- [36]
			"34429:22931:43073", -- [37]
			"34429:22931:43079", -- [38]
			"34429:22931:43073:43085", -- [39]
			"34429:12616:36728:8610:37005", -- [40]
			"34429:12616:36728:8610:43328", -- [41]
			"34429:12616:36728", -- [42]
			["direct"] = "4312:11901:34429:35140:35139:41246",
			["coord"] = 1936477991,
			["m"] = 81,
			["f"] = 0,
		},
		[41214] = {
			"7824:2995", -- [1]
			"7824:16227:3310", -- [2]
			"7824:3615", -- [3]
			"7824:2995:35139:4312", -- [4]
			"7824:44399", -- [5]
			"7824:39898:41605:40473:6726", -- [6]
			"7824:39898", -- [7]
			"7824:16227:3310:8610", -- [8]
			"7824:16227:3310:11139", -- [9]
			"7824:40769:40358:11899", -- [10]
			"7824:3615:34927:34429:11901", -- [11]
			"7824:3615:34927:12616", -- [12]
			"7824:3615:34927:12616:22931:43073:43085:12740", -- [13]
			"7824:39175:15178", -- [14]
			"7824:40769:40358:11899:52060", -- [15]
			"7824:10583", -- [16]
			"7824:16227", -- [17]
			"7824:3615:34927:12616:22931", -- [18]
			"7824:40769:40358", -- [19]
			"7824:3615:34927:34429", -- [20]
			"7824:3615:34927", -- [21]
			"7824:3615:34927:34943", -- [22]
			"7824:2995:35139:35141", -- [23]
			"7824:2995:35139:35140", -- [24]
			"7824:2995:35139", -- [25]
			"7824:2995:35556:35562:35315", -- [26]
			"7824:2995:35556:35478", -- [27]
			"7824:2995:35556", -- [28]
			"7824:2995:35556:35562", -- [29]
			"7824:39175", -- [30]
			"7824:40769:40358:11899:52060:39340", -- [31]
			"7824:40769:40358:39330", -- [32]
			"7824:2995:40809", -- [33]
			"7824:3615:40558", -- [34]
			"7824:40769", -- [35]
			"7824:16227:3310:41140:41142", -- [36]
			"7824:16227:3310:41140", -- [37]
			"7824:2995:35139:4312:41246", -- [38]
			"7824:39898:41605:40473", -- [39]
			"7824:39898:41605", -- [40]
			"7824:3615:34927:12616:22931:43073", -- [41]
			"7824:3615:34927:12616:22931:43079", -- [42]
			"7824:3615:34927:12616:22931:43073:43085", -- [43]
			"7824:16227:3310:37005", -- [44]
			"7824:16227:3310:8610:43328", -- [45]
			"7824:16227:3310:36728", -- [46]
			["direct"] = "7824:41215",
			["coord"] = 2398460708,
			["m"] = 161,
			["f"] = 0,
		},
		[36728] = {
			"3310:3615:2995", -- [1]
			"3310:3615", -- [2]
			"12616:34943:35140:4312", -- [3]
			"3310:3615:44399", -- [4]
			"12616:34943:35140:4312:6726", -- [5]
			"3310:7824", -- [6]
			"3310:3615:52060:39330:39898", -- [7]
			"8610:11139", -- [8]
			"3310:16227:11899", -- [9]
			"12616:34429:11901", -- [10]
			"8610:11139:12740", -- [11]
			"3310:3615:52060:39330:39898:15178", -- [12]
			"3310:3615:52060", -- [13]
			"3310:7824:10583", -- [14]
			"3310:16227", -- [15]
			"12616:22931", -- [16]
			"3310:16227:11899:40358", -- [17]
			"12616:34429", -- [18]
			"12616:34927", -- [19]
			"12616:34943", -- [20]
			"12616:34429:35141", -- [21]
			"12616:34943:35140", -- [22]
			"12616:34943:35140:35139", -- [23]
			"12616:34943:35140:4312:35315", -- [24]
			"12616:34943:35140:4312:35478", -- [25]
			"3310:3615:2995:35556", -- [26]
			"12616:34943:35140:4312:35315:35562", -- [27]
			"3310:7824:39175", -- [28]
			"3310:3615:39340", -- [29]
			"3310:3615:52060:39330", -- [30]
			"3310:3615:2995:40809", -- [31]
			"3310:40558", -- [32]
			"3310:16227:11899:40358:40769", -- [33]
			"3310:7824:41215", -- [34]
			"3310:41140:41142", -- [35]
			"3310:41140", -- [36]
			"3310:7824:41214", -- [37]
			"12616:34943:35140:41246", -- [38]
			"12616:34943:35140:4312:6726:40473", -- [39]
			"3310:3615:52060:39330:39898:41605", -- [40]
			"12616:22931:43073", -- [41]
			"12616:22931:43079", -- [42]
			"12616:22931:43073:43085", -- [43]
			"8610:37005", -- [44]
			"8610:43328", -- [45]
			["direct"] = "3310:8610:12616",
			["coord"] = 614049436,
			["m"] = 181,
			["f"] = 0,
		},
		[35139] = {
			"3615:3310", -- [1]
			"2995:44399", -- [2]
			"2995:7824", -- [3]
			"2995:52060:39330:39898", -- [4]
			"3615:8610", -- [5]
			"3615:3310:11139", -- [6]
			"2995:52060:11899", -- [7]
			"35141:11901", -- [8]
			"3615:34927:12616", -- [9]
			"4312:34429:22931:43073:43085:12740", -- [10]
			"2995:52060:39330:39898:15178", -- [11]
			"2995:52060", -- [12]
			"2995:7824:10583", -- [13]
			"3615:16227", -- [14]
			"4312:34429:22931", -- [15]
			"2995:52060:39330:40358", -- [16]
			"4312:34429", -- [17]
			"3615:34927", -- [18]
			"35140:34943", -- [19]
			"4312:35315", -- [20]
			"2995:35556:35478", -- [21]
			"2995:35556", -- [22]
			"2995:35556:35562", -- [23]
			"2995:7824:39175", -- [24]
			"2995:39340", -- [25]
			"2995:52060:39330", -- [26]
			"2995:40809", -- [27]
			"3615:40558", -- [28]
			"2995:52060:39330:40358:40769", -- [29]
			"2995:7824:41215", -- [30]
			"3615:3310:41140:41142", -- [31]
			"3615:3310:41140", -- [32]
			"2995:7824:41214", -- [33]
			"4312:41246", -- [34]
			"6726:40473", -- [35]
			"6726:40473:41605", -- [36]
			"4312:34429:22931:43073", -- [37]
			"4312:34429:22931:43079", -- [38]
			"4312:34429:22931:43073:43085", -- [39]
			"3615:3310:37005", -- [40]
			"3615:8610:43328", -- [41]
			"3615:34927:12616:36728", -- [42]
			["direct"] = "2995:3615:4312:6726:35141:35140",
			["coord"] = 3030181080,
			["m"] = 81,
			["f"] = 0,
		},
		[39330] = {
			"39340:2995", -- [1]
			"11899:16227:3310", -- [2]
			"52060:3615", -- [3]
			"52060:3615:4312", -- [4]
			"39898:41605:40473:6726", -- [5]
			"40358:40769:7824", -- [6]
			"52060:3615:8610", -- [7]
			"11899:16227:3310:11139", -- [8]
			"52060:3615:34927:34429:11901", -- [9]
			"52060:3615:34927:12616", -- [10]
			"52060:3615:34927:12616:22931:43073:43085:12740", -- [11]
			"39898:15178", -- [12]
			"40358:40769:7824:10583", -- [13]
			"11899:16227", -- [14]
			"52060:3615:34927:12616:22931", -- [15]
			"52060:3615:34927:34429", -- [16]
			"52060:3615:34927", -- [17]
			"52060:3615:34927:34943", -- [18]
			"52060:3615:4312:35141", -- [19]
			"39340:2995:35139:35140", -- [20]
			"39340:2995:35139", -- [21]
			"39340:2995:35556:35562:35315", -- [22]
			"39340:2995:35556:35478", -- [23]
			"39340:2995:35556", -- [24]
			"39340:2995:35556:35562", -- [25]
			"40358:40769:7824:39175", -- [26]
			"39340:2995:40809", -- [27]
			"52060:3615:40558", -- [28]
			"40358:40769", -- [29]
			"40358:40769:7824:41215", -- [30]
			"11899:16227:3310:41140:41142", -- [31]
			"11899:16227:3310:41140", -- [32]
			"40358:40769:7824:41214", -- [33]
			"52060:3615:4312:41246", -- [34]
			"39898:41605:40473", -- [35]
			"39898:41605", -- [36]
			"52060:3615:34927:12616:22931:43073", -- [37]
			"52060:3615:34927:12616:22931:43079", -- [38]
			"52060:3615:34927:12616:22931:43073:43085", -- [39]
			"11899:16227:3310:37005", -- [40]
			"52060:3615:8610:43328", -- [41]
			"52060:3615:34927:12616:36728", -- [42]
			["direct"] = "44399:39898:11899:52060:40358:39340",
			["coord"] = 1769714932,
			["m"] = 607,
			["f"] = 0,
		},
		[43073] = {
			"22931:34429:4312:35139:2995", -- [1]
			"22931:12616:3310", -- [2]
			"22931:12616:34927:3615", -- [3]
			"22931:34429:4312", -- [4]
			"22931:12616:34927:3615:44399", -- [5]
			"22931:34429:4312:6726", -- [6]
			"22931:12616:34927:3615:7824", -- [7]
			"22931:12616:34927:3615:52060:39330:39898", -- [8]
			"43085:11139:8610", -- [9]
			"43085:11139", -- [10]
			"22931:12616:34927:3615:52060:11899", -- [11]
			"22931:34429:11901", -- [12]
			"22931:12616", -- [13]
			"43085:12740", -- [14]
			"22931:12616:34927:3615:52060:39330:39898:15178", -- [15]
			"22931:12616:34927:3615:52060", -- [16]
			"22931:12616:34927:3615:7824:10583", -- [17]
			"22931:12616:34927:3615:16227", -- [18]
			"22931:12616:34927:3615:52060:39330:40358", -- [19]
			"22931:34429", -- [20]
			"22931:12616:34927", -- [21]
			"22931:34429:34943", -- [22]
			"22931:34429:35141", -- [23]
			"22931:34429:34943:35140", -- [24]
			"22931:34429:4312:35139", -- [25]
			"22931:34429:4312:35315", -- [26]
			"22931:34429:4312:35478", -- [27]
			"22931:34429:4312:35478:35556", -- [28]
			"22931:34429:4312:35315:35562", -- [29]
			"22931:12616:34927:3615:7824:39175", -- [30]
			"22931:12616:34927:3615:39340", -- [31]
			"22931:12616:34927:3615:52060:39330", -- [32]
			"22931:34429:4312:35139:2995:40809", -- [33]
			"22931:12616:34927:40558", -- [34]
			"22931:12616:34927:3615:52060:39330:40358:40769", -- [35]
			"22931:12616:34927:3615:7824:41215", -- [36]
			"22931:12616:3310:41140:41142", -- [37]
			"22931:12616:3310:41140", -- [38]
			"22931:12616:34927:3615:7824:41214", -- [39]
			"22931:34429:35141:41246", -- [40]
			"22931:34429:4312:6726:40473", -- [41]
			"22931:12616:34927:3615:52060:39330:39898:41605", -- [42]
			"43085:11139:8610:37005", -- [43]
			"43085:11139:8610:43328", -- [44]
			"22931:12616:36728", -- [45]
			["direct"] = "22931:43079:43085",
			["coord"] = 1872382313,
			["m"] = 182,
			["f"] = 0,
		},
		[48273] = {
			"48274:15178:39898:44399:2995", -- [1]
			"48275:41215:7824:16227:3310", -- [2]
			"48274:15178:39898:39330:52060:3615", -- [3]
			"48274:15178:41605:40473:6726:35478:4312", -- [4]
			"48274:15178:39898:44399", -- [5]
			"48274:15178:41605:40473:6726", -- [6]
			"48275:41215:7824", -- [7]
			"48274:15178:39898", -- [8]
			"48275:41215:7824:16227:3310:8610", -- [9]
			"48275:41215:7824:16227:3310:11139", -- [10]
			"48274:15178:39898:44399:11899", -- [11]
			"48274:15178:41605:40473:6726:35478:4312:11901", -- [12]
			"48274:15178:39898:39330:52060:3615:34927:12616", -- [13]
			"48274:15178:39898:39330:52060:3615:34927:12616:22931:43073:43085:12740", -- [14]
			"48274:15178", -- [15]
			"48274:15178:39898:39330:52060", -- [16]
			"48274:15178:39175:10583", -- [17]
			"48275:41215:7824:16227", -- [18]
			"48274:15178:39898:39330:52060:3615:34927:12616:22931", -- [19]
			"48275:41215:7824:40769:40358", -- [20]
			"48274:15178:39898:39330:52060:3615:34927:34429", -- [21]
			"48274:15178:39898:39330:52060:3615:34927", -- [22]
			"48274:15178:39898:39330:52060:3615:34927:34943", -- [23]
			"48274:15178:41605:40473:6726:35478:4312:35141", -- [24]
			"48274:15178:41605:40473:6726:35478:4312:35140", -- [25]
			"48274:15178:41605:40473:6726:35139", -- [26]
			"48274:15178:41605:40473:6726:35315", -- [27]
			"48274:15178:41605:40473:6726:35478", -- [28]
			"48274:15178:41605:40473:6726:35478:35556", -- [29]
			"48274:15178:41605:40473:6726:35315:35562", -- [30]
			"48274:15178:39175", -- [31]
			"48274:15178:39898:39330:39340", -- [32]
			"48274:15178:39898:39330", -- [33]
			"48274:15178:39898:44399:2995:40809", -- [34]
			"48274:15178:39898:39330:52060:3615:40558", -- [35]
			"48275:41215:7824:40769", -- [36]
			"48275:41215", -- [37]
			"48275:41215:7824:16227:3310:41140:41142", -- [38]
			"48275:41215:7824:16227:3310:41140", -- [39]
			"48275:41215:41214", -- [40]
			"48274:15178:41605:40473:6726:35478:4312:41246", -- [41]
			"48275:41215:7824:16227:3310:11139:41861:43481", -- [42]
			"48275:41215:7824:16227:3310:11139:41861", -- [43]
			"48274:15178:41605:40473", -- [44]
			"48274:15178:41605", -- [45]
			"48274:15178:39898:39330:52060:3615:34927:12616:22931:43073", -- [46]
			"48274:15178:39898:39330:52060:3615:34927:12616:22931:43079", -- [47]
			"48274:15178:39898:39330:52060:3615:34927:12616:22931:43073:43085", -- [48]
			"48275:41215:7824:16227:3310:37005", -- [49]
			"48275:41215:7824:16227:3310:8610:43328", -- [50]
			"48275:41215:7824:16227:3310:36728", -- [51]
			["direct"] = "48275:48274",
			["f"] = 0,
			["m"] = 720,
			["coord"] = 958375506,
		},
		[48275] = {
			"41215:7824:2995", -- [1]
			"41215:7824:16227:3310", -- [2]
			"41215:7824:3615", -- [3]
			"48274:15178:41605:40473:6726:35478:4312", -- [4]
			"48274:15178:39898:44399", -- [5]
			"48274:15178:41605:40473:6726", -- [6]
			"41215:7824", -- [7]
			"48274:15178:39898", -- [8]
			"41215:7824:16227:3310:8610", -- [9]
			"41215:7824:16227:3310:11139", -- [10]
			"41215:7824:40769:40358:11899", -- [11]
			"41215:7824:3615:34927:34429:11901", -- [12]
			"41215:7824:3615:34927:12616", -- [13]
			"41215:7824:3615:34927:12616:22931:43073:43085:12740", -- [14]
			"48274:15178", -- [15]
			"41215:7824:40769:40358:11899:52060", -- [16]
			"48274:15178:39175:10583", -- [17]
			"41215:7824:16227", -- [18]
			"41215:7824:3615:34927:12616:22931", -- [19]
			"41215:7824:40769:40358", -- [20]
			"41215:7824:3615:34927:34429", -- [21]
			"41215:7824:3615:34927", -- [22]
			"41215:7824:3615:34927:34943", -- [23]
			"48274:15178:41605:40473:6726:35478:4312:35141", -- [24]
			"41215:7824:2995:35139:35140", -- [25]
			"41215:7824:2995:35139", -- [26]
			"48274:15178:41605:40473:6726:35315", -- [27]
			"48274:15178:41605:40473:6726:35478", -- [28]
			"48274:15178:41605:40473:6726:35478:35556", -- [29]
			"48274:15178:41605:40473:6726:35315:35562", -- [30]
			"48274:15178:39175", -- [31]
			"41215:7824:40769:40358:11899:52060:39340", -- [32]
			"41215:7824:40769:40358:39330", -- [33]
			"41215:7824:2995:40809", -- [34]
			"41215:7824:3615:40558", -- [35]
			"41215:7824:40769", -- [36]
			"41215:7824:16227:3310:41140:41142", -- [37]
			"41215:7824:16227:3310:41140", -- [38]
			"41215:41214", -- [39]
			"48274:15178:41605:40473:6726:35478:4312:41246", -- [40]
			"41215:7824:16227:3310:11139:41861:43481", -- [41]
			"41215:7824:16227:3310:11139:41861", -- [42]
			"48274:15178:41605:40473", -- [43]
			"48274:15178:41605", -- [44]
			"41215:7824:3615:34927:12616:22931:43073", -- [45]
			"41215:7824:3615:34927:12616:22931:43079", -- [46]
			"41215:7824:3615:34927:12616:22931:43073:43085", -- [47]
			"41215:7824:16227:3310:37005", -- [48]
			"41215:7824:16227:3310:8610:43328", -- [49]
			"41215:7824:16227:3310:36728", -- [50]
			["direct"] = "41215:48274:48273",
			["coord"] = 2414826981,
			["m"] = 720,
			["f"] = 0,
		},
		[41861] = {
			"11139:8610:2995", -- [1]
			"11139:8610:3310", -- [2]
			"11139:8610:3310:3615", -- [3]
			"12740:43085:43073:22931:34429:4312", -- [4]
			"11139:8610:3310:3615:44399", -- [5]
			"12740:43085:43073:22931:34429:4312:6726", -- [6]
			"11139:8610:3310:7824", -- [7]
			"11139:8610:3310:3615:52060:39330:39898", -- [8]
			"11139:8610", -- [9]
			"11139:8610:3310:16227:11899", -- [10]
			"12740:43085:43073:22931:34429:11901", -- [11]
			"12740:43085:43073:22931:12616", -- [12]
			"11139:8610:3310:3615:52060:39330:39898:15178", -- [13]
			"11139:8610:3310:3615:52060", -- [14]
			"11139:8610:3310:7824:10583", -- [15]
			"11139:8610:3310:16227", -- [16]
			"12740:43085:43073:22931", -- [17]
			"11139:8610:3310:16227:11899:40358", -- [18]
			"12740:43085:43073:22931:34429", -- [19]
			"12740:43085:43073:22931:12616:34927", -- [20]
			"12740:43085:43073:22931:34429:34943", -- [21]
			"12740:43085:43073:22931:34429:35141", -- [22]
			"12740:43085:43073:22931:34429:34943:35140", -- [23]
			"12740:43085:43073:22931:34429:4312:35139", -- [24]
			"12740:43085:43073:22931:34429:4312:35315", -- [25]
			"12740:43085:43073:22931:34429:4312:35478", -- [26]
			"11139:8610:2995:35556", -- [27]
			"12740:43085:43073:22931:34429:4312:35315:35562", -- [28]
			"11139:8610:3310:7824:39175", -- [29]
			"11139:8610:3310:3615:39340", -- [30]
			"11139:8610:3310:3615:52060:39330", -- [31]
			"11139:8610:2995:40809", -- [32]
			"11139:8610:3310:40558", -- [33]
			"11139:8610:3310:16227:11899:40358:40769", -- [34]
			"11139:8610:3310:7824:41215", -- [35]
			"11139:8610:3310:41140:41142", -- [36]
			"11139:8610:3310:41140", -- [37]
			"11139:8610:3310:7824:41214", -- [38]
			"12740:43085:43073:22931:34429:35141:41246", -- [39]
			"12740:43085:43073:22931:34429:4312:6726:40473", -- [40]
			"11139:8610:3310:3615:52060:39330:39898:41605", -- [41]
			"12740:43085:43073", -- [42]
			"12740:43085:43073:43079", -- [43]
			"12740:43085", -- [44]
			"11139:8610:37005", -- [45]
			"11139:8610:43328", -- [46]
			"11139:8610:3310:7824:41215:48275", -- [47]
			"11139:8610:3310:3615:52060:39330:39898:15178:48274", -- [48]
			"11139:8610:3310:7824:41215:48275:48273", -- [49]
			"11139:8610:36728", -- [50]
			["direct"] = "11139:12740:43481",
			["coord"] = 2671195984,
			["m"] = 606,
			["f"] = 0,
		},
		[43481] = {
			"41861:11139:8610:2995", -- [1]
			"41861:11139:8610:3310", -- [2]
			"41861:11139:8610:3310:3615", -- [3]
			"41861:12740:43085:43073:22931:34429:4312", -- [4]
			"41861:11139:8610:3310:3615:44399", -- [5]
			"41861:12740:43085:43073:22931:34429:4312:6726", -- [6]
			"41861:11139:8610:3310:7824", -- [7]
			"41861:11139:8610:3310:3615:52060:39330:39898", -- [8]
			"41861:11139:8610", -- [9]
			"41861:11139", -- [10]
			"41861:11139:8610:3310:16227:11899", -- [11]
			"41861:12740:43085:43073:22931:34429:11901", -- [12]
			"41861:12740:43085:43073:22931:12616", -- [13]
			"41861:12740", -- [14]
			"41861:11139:8610:3310:3615:52060:39330:39898:15178", -- [15]
			"41861:11139:8610:3310:3615:52060", -- [16]
			"41861:11139:8610:3310:7824:10583", -- [17]
			"41861:11139:8610:3310:16227", -- [18]
			"41861:12740:43085:43073:22931", -- [19]
			"41861:11139:8610:3310:16227:11899:40358", -- [20]
			"41861:12740:43085:43073:22931:34429", -- [21]
			"41861:12740:43085:43073:22931:12616:34927", -- [22]
			"41861:12740:43085:43073:22931:34429:34943", -- [23]
			"41861:12740:43085:43073:22931:34429:35141", -- [24]
			"41861:12740:43085:43073:22931:34429:34943:35140", -- [25]
			"41861:12740:43085:43073:22931:34429:4312:35139", -- [26]
			"41861:12740:43085:43073:22931:34429:4312:35315", -- [27]
			"41861:12740:43085:43073:22931:34429:4312:35478", -- [28]
			"41861:11139:8610:2995:35556", -- [29]
			"41861:12740:43085:43073:22931:34429:4312:35315:35562", -- [30]
			"41861:11139:8610:3310:7824:39175", -- [31]
			"41861:11139:8610:3310:3615:39340", -- [32]
			"41861:11139:8610:3310:3615:52060:39330", -- [33]
			"41861:11139:8610:2995:40809", -- [34]
			"41861:11139:8610:3310:40558", -- [35]
			"41861:11139:8610:3310:16227:11899:40358:40769", -- [36]
			"41861:11139:8610:3310:7824:41215", -- [37]
			"41861:11139:8610:3310:41140:41142", -- [38]
			"41861:11139:8610:3310:41140", -- [39]
			"41861:11139:8610:3310:7824:41214", -- [40]
			"41861:12740:43085:43073:22931:34429:35141:41246", -- [41]
			"41861:12740:43085:43073:22931:34429:4312:6726:40473", -- [42]
			"41861:11139:8610:3310:3615:52060:39330:39898:41605", -- [43]
			"41861:12740:43085:43073", -- [44]
			"41861:12740:43085:43073:43079", -- [45]
			"41861:12740:43085", -- [46]
			"41861:11139:8610:37005", -- [47]
			"41861:11139:8610:43328", -- [48]
			"41861:11139:8610:3310:7824:41215:48275", -- [49]
			"41861:11139:8610:3310:3615:52060:39330:39898:15178:48274", -- [50]
			"41861:11139:8610:3310:7824:41215:48275:48273", -- [51]
			"41861:11139:8610:36728", -- [52]
			["direct"] = "41861",
			["coord"] = 1767206201,
			["m"] = 606,
			["f"] = 0,
		},
		[48274] = {
			"15178:39898:44399:2995", -- [1]
			"15178:39898:44399:11899:16227:3310", -- [2]
			"15178:39898:39330:52060:3615", -- [3]
			"15178:41605:40473:6726:35478:4312", -- [4]
			"15178:39898:44399", -- [5]
			"15178:41605:40473:6726", -- [6]
			"48275:41215:7824", -- [7]
			"15178:39898", -- [8]
			"15178:39898:44399:11899:16227:3310:8610", -- [9]
			"15178:39898:44399:11899:16227:3310:11139", -- [10]
			"15178:39898:44399:11899", -- [11]
			"15178:41605:40473:6726:35478:4312:11901", -- [12]
			"15178:39898:39330:52060:3615:34927:12616", -- [13]
			"15178:39898:39330:52060:3615:34927:12616:22931:43073:43085:12740", -- [14]
			"15178:39898:39330:52060", -- [15]
			"15178:39175:10583", -- [16]
			"15178:39898:44399:11899:16227", -- [17]
			"15178:39898:39330:52060:3615:34927:12616:22931", -- [18]
			"15178:39898:44399:40358", -- [19]
			"15178:39898:39330:52060:3615:34927:34429", -- [20]
			"15178:39898:39330:52060:3615:34927", -- [21]
			"15178:39898:39330:52060:3615:34927:34943", -- [22]
			"15178:41605:40473:6726:35478:4312:35141", -- [23]
			"15178:41605:40473:6726:35478:4312:35140", -- [24]
			"15178:41605:40473:6726:35139", -- [25]
			"15178:41605:40473:6726:35315", -- [26]
			"15178:41605:40473:6726:35478", -- [27]
			"15178:41605:40473:6726:35478:35556", -- [28]
			"15178:41605:40473:6726:35315:35562", -- [29]
			"15178:39175", -- [30]
			"15178:39898:39330:39340", -- [31]
			"15178:39898:39330", -- [32]
			"15178:39898:44399:2995:40809", -- [33]
			"15178:39898:39330:52060:3615:40558", -- [34]
			"48275:41215:7824:40769", -- [35]
			"48275:41215", -- [36]
			"15178:39898:44399:11899:16227:3310:41140:41142", -- [37]
			"15178:39898:44399:11899:16227:3310:41140", -- [38]
			"48275:41215:41214", -- [39]
			"15178:41605:40473:6726:35478:4312:41246", -- [40]
			"15178:39898:44399:11899:16227:3310:11139:41861:43481", -- [41]
			"15178:39898:44399:11899:16227:3310:11139:41861", -- [42]
			"15178:41605:40473", -- [43]
			"15178:41605", -- [44]
			"15178:39898:39330:52060:3615:34927:12616:22931:43073", -- [45]
			"15178:39898:39330:52060:3615:34927:12616:22931:43079", -- [46]
			"15178:39898:39330:52060:3615:34927:12616:22931:43073:43085", -- [47]
			"15178:39898:44399:11899:16227:3310:37005", -- [48]
			"15178:39898:44399:11899:16227:3310:8610:43328", -- [49]
			"15178:39898:39330:52060:3615:34927:12616:36728", -- [50]
			["direct"] = "15178:48275:48273",
			["coord"] = 1144395128,
			["m"] = 720,
			["f"] = 0,
		},
	}, -- [1]
	{
		[29480] = {
			"12636:37888:2389:2226", -- [1]
			"12636:37888:4551", -- [2]
			"12636:37888:2389", -- [3]
			"12636:4314:2851", -- [4]
			"12636:44407:2861:2858", -- [5]
			"12636:44407:2861:1387", -- [6]
			"12636:44407:2861", -- [7]
			"12636:44407:2861:13177:43086:6026", -- [8]
			"12636:44407:2861:13177", -- [9]
			"12636:44407:2861:3305", -- [10]
			"12636:4314", -- [11]
			"12636:16189:16192", -- [12]
			"12636:16189", -- [13]
			"12636:44230:44233", -- [14]
			"12636:44230:28621", -- [15]
			"12636:44230", -- [16]
			"12636:44231:44232", -- [17]
			"12636:24851", -- [18]
			"12636:24851:26560", -- [19]
			"12636:37888", -- [20]
			"12636:37888:37915", -- [21]
			"12636:37888:37915:43124", -- [22]
			"12636:44407:2861:1387:43053", -- [23]
			"12636:44407:2861:1387:43052", -- [24]
			"12636:44407:2861:13177:43086", -- [25]
			"12636:37888:2389:43104", -- [26]
			"12636:44407:2861:13177:43086:6026:43121:43114", -- [27]
			"12636:44407:2861:13177:43086:6026:43121", -- [28]
			"12636:37888:43573", -- [29]
			"12636:16189:44036", -- [30]
			"12636:44231", -- [31]
			"12636:16189:16192:44244", -- [32]
			"12636:44407:44408", -- [33]
			"12636:44407", -- [34]
			"12636:37888:37915:43124:44825", -- [35]
			"12636:37888:2389:47644:47655:46552:45479", -- [36]
			"12636:37888:46011:46004", -- [37]
			"12636:37888:46011", -- [38]
			"12636:37888:2389:47644:47655:46552", -- [39]
			"12636:4314:2851:47174:47116", -- [40]
			"12636:4314:2851:47174:47156:47133", -- [41]
			"12636:4314:2851:47174:47156", -- [42]
			"12636:4314:2851:47174:47061", -- [43]
			"12636:4314:2851:47174", -- [44]
			"12636:37888:2389:47644", -- [45]
			"12636:37888:2389:47644:47655", -- [46]
			"12636:37888:2389:47661", -- [47]
			"12636:37888:37915:47665", -- [48]

			"12636:44230:44233:47875", -- [49]
			"12636:44407:2861:3305:47927", -- [50]
			"12636:44407:2861:13177:48321:48318", -- [51]
			"12636:44407:2861:13177:48321", -- [52]
			"12636:37888:37915:43124:44825:50463", -- [53]
			["direct"] = "12636",
			["m"] = 23,
			["coord"] = 3600908479,
			["f"] = 0,
			requirements = "cls:DEATHKNIGHT",
		},
		[43114] = {
			"43121:6026:2861:2851:2389:2226", -- [1]
			"43121:6026:2861:4551", -- [2]
			"43121:6026:2861:2851:2389", -- [3]
			"43121:6026:2861:2851", -- [4]
			"2858:1387", -- [5]
			"43121:6026:2861", -- [6]
			"43121:6026", -- [7]
			"43121:6026:2861:44407:12636", -- [8]
			"43121:6026:43086:13177", -- [9]
			"43121:6026:43086:13177:3305", -- [10]
			"43121:6026:2861:2851:4314", -- [11]
			"43121:6026:2861:44407:12636:16189:16192", -- [12]
			"43121:6026:2861:44407:12636:16189", -- [13]
			"43121:6026:2861:2851:43573:37888:44232:44233", -- [14]
			"43121:6026:2861:44407:12636:44230:28621", -- [15]
			"43121:6026:2861:44407:12636:44230", -- [16]
			"43121:6026:2861:2851:43573:37888:44232", -- [17]
			"43121:6026:2861:44407:12636:24851", -- [18]
			"43121:6026:2861:44407:12636:24851:26560", -- [19]
			"43121:6026:2861:2851:43573:37888", -- [20]
			"43121:6026:2861:2851:43573:46004:37915", -- [21]
			"43121:6026:2861:2851:43573:46004:37915:43124", -- [22]
			"2858:43053", -- [23]
			"2858:43053:43052", -- [24]
			"43121:6026:43086", -- [25]
			"43121:6026:2861:2851:43104", -- [26]
			"43121:6026:2861:2851:43573", -- [27]
			"43121:6026:2861:44407:12636:16189:44036", -- [28]
			"43121:6026:2861:44407:12636:44231", -- [29]
			"43121:6026:2861:44407:12636:16189:16192:44244", -- [30]
			"43121:6026:2861:44408", -- [31]
			"43121:6026:2861:44407", -- [32]
			"43121:6026:2861:2851:43573:46004:37915:43124:44825", -- [33]
			"43121:6026:2861:2851:43104:47661:47644:47655:46552:45479", -- [34]
			"43121:6026:2861:2851:43573:46004", -- [35]
			"43121:6026:2861:2851:43573:46004:46011", -- [36]
			"43121:6026:2861:2851:43104:47661:47644:47655:46552", -- [37]
			"43121:6026:2861:2851:43104:47661:47644", -- [38]
			"43121:6026:2861:2851:43104:47661:47644:47655", -- [39]
			"43121:6026:2861:2851:43104:47661", -- [40]
			"43121:6026:2861:2851:2389:47665", -- [41]
			"43121:6026:2861:2851:43573:46004:46011:47875", -- [42]
			"43121:6026:43086:13177:3305:47927", -- [43]
			"43121:6026:43086:13177:48321:48318", -- [44]
			"43121:6026:43086:13177:48321", -- [45]
			"43121:6026:2861:2851:2389:2226:50463", -- [46]
			["direct"] = "2858:43121",
			["coord"] = 2186459736,
			["m"] = 19,
			["f"] = 0,
		},
		[13177] = {
			"2861:2851:2389:2226", -- [1]
			"2861:4551", -- [2]
			"2861:2851:2389", -- [3]
			"2861:2851", -- [4]
			"1387:2858", -- [5]
			"2861:44407:12636", -- [6]
			"2861:2851:4314", -- [7]
			"2861:44407:12636:16189:16192", -- [8]
			"2861:44407:12636:16189", -- [9]
			"2861:2851:43573:37888:44232:44233", -- [10]
			"2861:44407:12636:44230:28621", -- [11]
			"2861:44407:12636:44230", -- [12]
			"2861:2851:43573:37888:44232", -- [13]
			"2861:44407:12636:24851", -- [14]
			"2861:44407:12636:24851:26560", -- [15]
			"2861:2851:43573:37888", -- [16]
			"2861:2851:43573:46004:37915", -- [17]
			"2861:2851:43573:46004:37915:43124", -- [18]
			"1387:43053", -- [19]
			"1387:43052", -- [20]
			"2861:2851:43104", -- [21]
			"43086:6026:43121:43114", -- [22]
			"43086:6026:43121", -- [23]
			"2861:2851:43573", -- [24]
			"2861:44407:12636:16189:44036", -- [25]
			"2861:44407:12636:44231", -- [26]
			"2861:44407:12636:16189:16192:44244", -- [27]
			"2861:44408", -- [28]
			"2861:44407", -- [29]
			"2861:2851:43573:46004:37915:43124:44825", -- [30]
			"2861:2851:43104:47661:47644:47655:46552:45479", -- [31]
			"2861:2851:43573:46004", -- [32]
			"2861:2851:43573:46004:46011", -- [33]
			"2861:2851:43104:47661:47644:47655:46552", -- [34]
			"2861:2851:43104:47661:47644", -- [35]
			"2861:2851:43104:47661:47644:47655", -- [36]
			"2861:2851:43104:47661", -- [37]
			"2861:2851:2389:47665", -- [38]
			"2861:2851:43573:46004:46011:47875", -- [39]
			"3305:47927", -- [40]
			"48321:48318", -- [41]
			"2861:2851:2389:2226:50463", -- [42]
			["direct"] = "1387:2861:6026:3305:43086:48321",
			["coord"] = 2332376532,
			["m"] = 29,
			["f"] = 0,
		},
		[28621] = {
			"44232:37888:2389:2226", -- [1]
			"44232:37888:4551", -- [2]
			"44232:37888:2389", -- [3]
			"44232:37888:43573:2851", -- [4]
			"44230:12636:44407:2861:2858", -- [5]
			"44230:12636:44407:2861:1387", -- [6]
			"44230:12636:44407:2861", -- [7]
			"44230:12636:44407:2861:13177:43086:6026", -- [8]
			"44230:12636", -- [9]
			"44230:12636:44407:2861:13177", -- [10]
			"44230:12636:44407:2861:3305", -- [11]
			"44230:12636:4314", -- [12]
			"44230:12636:16189:16192", -- [13]
			"44230:12636:16189", -- [14]
			"44230:12636:24851", -- [15]
			"44230:12636:24851:26560", -- [16]
			"44232:37888", -- [17]
			"44232:37888:37915", -- [18]
			"44232:37888:37915:43124", -- [19]
			"44230:12636:44407:2861:1387:43053", -- [20]
			"44230:12636:44407:2861:1387:43052", -- [21]
			"44230:12636:44407:2861:13177:43086", -- [22]
			"44232:37888:2389:43104", -- [23]
			"44230:12636:44407:2861:13177:43086:6026:43121:43114", -- [24]
			"44230:12636:44407:2861:13177:43086:6026:43121", -- [25]
			"44232:37888:43573", -- [26]
			"44230:12636:16189:44036", -- [27]
			"44230:44231", -- [28]
			"44230:12636:16189:16192:44244", -- [29]
			"44230:12636:44407:44408", -- [30]
			"44230:12636:44407", -- [31]
			"44232:37888:37915:43124:44825", -- [32]
			"44232:37888:2389:47644:47655:46552:45479", -- [33]
			"44232:37888:46011:46004", -- [34]
			"44232:37888:46011", -- [35]
			"44232:37888:2389:47644:47655:46552", -- [36]
			"44232:37888:2389:47644", -- [37]
			"44232:37888:2389:47644:47655", -- [38]
			"44232:37888:2389:47661", -- [39]
			"44232:37888:37915:47665", -- [40]
			"44233:47875", -- [41]
			"44230:12636:44407:2861:3305:47927", -- [42]
			"44230:12636:44407:2861:13177:48321:48318", -- [43]
			"44230:12636:44407:2861:13177:48321", -- [44]
			"44232:37888:37915:43124:44825:50463", -- [45]
			["direct"] = "44233:44230:44232",
			["coord"] = 2202482249,
			["m"] = 23,
			["f"] = 0,
		},
		[43124] = {
			"44825:2226", -- [1]
			"37915:2389", -- [2]
			"37915:2389:2851", -- [3]
			"37915:2389:2851:2861:2858", -- [4]
			"37915:2389:2851:2861:1387", -- [5]
			"37915:2389:2851:2861", -- [6]
			"37915:2389:2851:2861:13177:43086:6026", -- [7]
			"37915:37888:12636", -- [8]
			"37915:2389:2851:2861:13177", -- [9]
			"37915:2389:2851:2861:3305", -- [10]
			"37915:46004:43573:4314", -- [11]
			"37915:37888:12636:16189:16192", -- [12]
			"37915:37888:12636:16189", -- [13]
			"37915:46004:46011:47875:44233", -- [14]
			"37915:37888:44232:28621", -- [15]
			"37915:37888:44232:44231:44230", -- [16]
			"37915:37888:44232", -- [17]
			"37915:37888:12636:24851", -- [18]
			"37915:37888:12636:24851:26560", -- [19]
			"37915:37888", -- [20]
			"37915:2389:2851:2861:1387:43053", -- [21]
			"37915:2389:2851:2861:1387:43052", -- [22]
			"37915:2389:2851:2861:13177:43086", -- [23]
			"37915:2389:43104", -- [24]
			"37915:2389:2851:2861:13177:43086:6026:43121:43114", -- [25]
			"37915:2389:2851:2861:13177:43086:6026:43121", -- [26]
			"37915:46004:43573", -- [27]
			"37915:37888:12636:16189:44036", -- [28]
			"37915:37888:44232:44231", -- [29]
			"37915:37888:12636:16189:16192:44244", -- [30]
			"37915:2389:2851:2861:44408", -- [31]
			"37915:37888:12636:44407", -- [32]
			"44825:2226:45479", -- [33]
			"37915:46004", -- [34]
			"37915:46004:46011", -- [35]
			"44825:2226:46552", -- [36]
			"37915:2389:47644", -- [37]
			"44825:2226:46552:47655", -- [38]
			"37915:2389:47661", -- [39]
			"37915:47665", -- [40]
			"37915:46004:46011:47875", -- [41]
			"37915:2389:2851:2861:3305:47927", -- [42]
			"37915:2389:2851:2861:13177:48321:48318", -- [43]
			"37915:2389:2851:2861:13177:48321", -- [44]
			"44825:50463", -- [45]
			["direct"] = "4551:37915:44825",
			["coord"] = 2529461498,
			["m"] = 20,
			["f"] = 0,
		},
		[43573] = {
			"2389:2226", -- [1]
			"46004:37915:4551", -- [2]
			"2851:2861:2858", -- [3]
			"2851:2861:1387", -- [4]
			"2851:2861", -- [5]
			"2851:2861:13177:43086:6026", -- [6]
			"37888:12636", -- [7]
			"2851:2861:13177", -- [8]
			"2851:2861:3305", -- [9]
			"37888:12636:16189:16192", -- [10]
			"37888:12636:16189", -- [11]
			"37888:44232:44233", -- [12]
			"37888:44232:28621", -- [13]
			"37888:44232:44231:44230", -- [14]
			"37888:44232", -- [15]
			"37888:12636:24851", -- [16]
			"37888:12636:24851:26560", -- [17]
			"46004:37915", -- [18]
			"46004:37915:43124", -- [19]
			"2851:2861:1387:43053", -- [20]
			"2851:2861:1387:43052", -- [21]
			"2851:2861:13177:43086", -- [22]
			"2389:43104", -- [23]
			"2851:2861:13177:43086:6026:43121:43114", -- [24]
			"2851:2861:13177:43086:6026:43121", -- [25]
			"37888:12636:16189:44036", -- [26]
			"37888:44232:44231", -- [27]
			"37888:12636:16189:16192:44244", -- [28]
			"2851:2861:44408", -- [29]
			"2851:2861:44407", -- [30]
			"46004:37915:43124:44825", -- [31]
			"2389:47644:47655:46552:45479", -- [32]
			"46004:46011", -- [33]
			"2389:47644:47655:46552", -- [34]
			"2389:47644", -- [35]
			"2389:47644:47655", -- [36]
			"2389:47661", -- [37]
			"2389:47665", -- [38]
			"46004:46011:47875", -- [39]
			"2851:2861:3305:47927", -- [40]
			"2851:2861:13177:48321:48318", -- [41]
			"2851:2861:13177:48321", -- [42]
			"46004:37915:43124:44825:50463", -- [43]
			["direct"] = "2389:2851:4314:37888:46004",
			["coord"] = 1390908635,
			["m"] = 26,
			["f"] = 0,
		},
		[24851] = {
			"12636:37888:2389:2226", -- [1]
			"12636:37888:4551", -- [2]
			"12636:37888:2389", -- [3]
			"12636:4314:2851", -- [4]
			"12636:44407:2861:2858", -- [5]
			"12636:44407:2861:1387", -- [6]
			"12636:44407:2861", -- [7]
			"12636:44407:2861:13177:43086:6026", -- [8]
			"12636:44407:2861:13177", -- [9]
			"12636:44407:2861:3305", -- [10]
			"12636:4314", -- [11]
			"16189:16192", -- [12]
			"12636:44230:44233", -- [13]
			"12636:44230:28621", -- [14]
			"12636:44230", -- [15]
			"12636:44231:44232", -- [16]
			"12636:37888", -- [17]
			"12636:37888:37915", -- [18]
			"12636:37888:37915:43124", -- [19]
			"12636:44407:2861:1387:43053", -- [20]
			"12636:44407:2861:1387:43052", -- [21]
			"12636:44407:2861:13177:43086", -- [22]
			"12636:37888:2389:43104", -- [23]
			"12636:44407:2861:13177:43086:6026:43121:43114", -- [24]
			"12636:44407:2861:13177:43086:6026:43121", -- [25]
			"12636:37888:43573", -- [26]
			"16189:44036", -- [27]
			"12636:44231", -- [28]
			"16189:16192:44244", -- [29]
			"12636:44407:44408", -- [30]
			"12636:44407", -- [31]
			"12636:37888:37915:43124:44825", -- [32]
			"12636:37888:2389:47644:47655:46552:45479", -- [33]
			"12636:37888:46011:46004", -- [34]
			"12636:37888:46011", -- [35]
			"12636:37888:2389:47644:47655:46552", -- [36]
			"12636:37888:2389:47644", -- [37]
			"12636:37888:2389:47644:47655", -- [38]
			"12636:37888:2389:47661", -- [39]
			"12636:37888:37915:47665", -- [40]
			"12636:44230:44233:47875", -- [41]
			"12636:44407:2861:3305:47927", -- [42]
			"12636:44407:2861:13177:48321:48318", -- [43]
			"12636:44407:2861:13177:48321", -- [44]
			"12636:37888:37915:43124:44825:50463", -- [45]
			["direct"] = "12636:16189:26560",
			["f"] = 0,
			["m"] = 463,
			["coord"] = 3207244762,
		},
		[37915] = {
			"43124:44825:2226", -- [1]
			"2389:2851", -- [2]
			"2389:2851:2861:2858", -- [3]
			"2389:2851:2861:1387", -- [4]
			"2389:2851:2861", -- [5]
			"2389:2851:2861:13177:43086:6026", -- [6]
			"37888:12636", -- [7]
			"2389:2851:2861:13177", -- [8]
			"2389:2851:2861:3305", -- [9]
			"46004:43573:4314", -- [10]
			"37888:12636:16189:16192", -- [11]
			"37888:12636:16189", -- [12]
			"46004:46011:47875:44233", -- [13]
			"37888:44232:28621", -- [14]
			"37888:44232:44231:44230", -- [15]
			"37888:44232", -- [16]
			"37888:12636:24851", -- [17]
			"37888:12636:24851:26560", -- [18]
			"2389:2851:2861:1387:43053", -- [19]
			"2389:2851:2861:1387:43052", -- [20]
			"2389:2851:2861:13177:43086", -- [21]
			"2389:43104", -- [22]
			"2389:2851:2861:13177:43086:6026:43121:43114", -- [23]
			"2389:2851:2861:13177:43086:6026:43121", -- [24]
			"46004:43573", -- [25]
			"37888:12636:16189:44036", -- [26]
			"37888:44232:44231", -- [27]
			"37888:12636:16189:16192:44244", -- [28]
			"2389:2851:2861:44408", -- [29]
			"37888:12636:44407", -- [30]
			"43124:44825", -- [31]
			"43124:44825:2226:45479", -- [32]
			"46004:46011", -- [33]
			"43124:44825:2226:46552", -- [34]
			"2389:47644", -- [35]
			"2389:47644:47655", -- [36]
			"2389:47661", -- [37]
			"46004:46011:47875", -- [38]
			"2389:2851:2861:3305:47927", -- [39]
			"2389:2851:2861:13177:48321:48318", -- [40]
			"2389:2851:2861:13177:48321", -- [41]
			"43124:44825:50463", -- [42]
			["direct"] = "4551:2389:37888:43124:46004:47665",
			["coord"] = 3587421025,
			["m"] = 20,
			["f"] = 0,
		},
		[3305] = {
			"2861:2851:2389:2226", -- [1]
			"2861:4551", -- [2]
			"2861:2851:2389", -- [3]
			"2861:2851", -- [4]
			"13177:1387:2858", -- [5]
			"13177:1387", -- [6]
			"13177:43086:6026", -- [7]
			"2861:44407:12636", -- [8]
			"2861:2851:4314", -- [9]
			"2861:44407:12636:16189:16192", -- [10]
			"2861:44407:12636:16189", -- [11]
			"2861:2851:43573:37888:44232:44233", -- [12]
			"2861:44407:12636:44230:28621", -- [13]
			"2861:44407:12636:44230", -- [14]
			"2861:2851:43573:37888:44232", -- [15]
			"2861:44407:12636:24851", -- [16]
			"2861:44407:12636:24851:26560", -- [17]
			"2861:2851:43573:37888", -- [18]
			"2861:2851:43573:46004:37915", -- [19]
			"2861:2851:43573:46004:37915:43124", -- [20]
			"13177:1387:43053", -- [21]
			"13177:1387:43052", -- [22]
			"13177:43086", -- [23]
			"2861:2851:43104", -- [24]
			"13177:43086:6026:43121:43114", -- [25]
			"13177:43086:6026:43121", -- [26]
			"2861:2851:43573", -- [27]
			"2861:44407:12636:16189:44036", -- [28]
			"2861:44407:12636:44231", -- [29]
			"2861:44407:12636:16189:16192:44244", -- [30]
			"2861:44408", -- [31]
			"2861:44407", -- [32]
			"2861:2851:43573:46004:37915:43124:44825", -- [33]
			"2861:2851:43104:47661:47644:47655:46552:45479", -- [34]
			"2861:2851:43573:46004", -- [35]
			"2861:2851:43573:46004:46011", -- [36]
			"2861:2851:43104:47661:47644:47655:46552", -- [37]
			"2861:2851:43104:47661:47644", -- [38]
			"2861:2851:43104:47661:47644:47655", -- [39]
			"2861:2851:43104:47661", -- [40]
			"2861:2851:2389:47665", -- [41]
			"2861:2851:43573:46004:46011:47875", -- [42]
			"47927:48318", -- [43]
			"13177:48321", -- [44]
			"2861:2851:2389:2226:50463", -- [45]
			["direct"] = "2861:13177:47927",
			["coord"] = 1495879243,
			["m"] = 28,
			["f"] = 0,
		},
		[45479] = {
			"2226:4551", -- [1]
			"46552:47655:47644:2389", -- [2]
			"46552:47655:47644:47661:43104:2851", -- [3]
			"46552:47655:47644:47661:43104:2851:2861:2858", -- [4]
			"46552:47655:47644:47661:43104:2851:2861:1387", -- [5]
			"46552:47655:47644:47661:43104:2851:2861", -- [6]
			"46552:47655:47644:47661:43104:2851:2861:13177:43086:6026", -- [7]
			"46552:47655:47644:2389:37888:12636", -- [8]
			"46552:47655:47644:47661:43104:2851:2861:13177", -- [9]
			"46552:47655:47644:47661:43104:2851:2861:3305", -- [10]
			"46552:47655:47644:2389:4314", -- [11]
			"46552:47655:47644:2389:37888:12636:16189:16192", -- [12]
			"46552:47655:47644:2389:37888:12636:16189", -- [13]
			"46552:47655:47644:2389:37888:44232:44233", -- [14]
			"46552:47655:47644:2389:37888:44232:28621", -- [15]
			"46552:47655:47644:2389:37888:44232:44231:44230", -- [16]
			"46552:47655:47644:2389:37888:44232", -- [17]
			"46552:47655:47644:2389:37888:12636:24851", -- [18]
			"46552:47655:47644:2389:37888:12636:24851:26560", -- [19]
			"46552:47655:47644:2389:37888", -- [20]
			"46552:47655:47644:2389:37915", -- [21]
			"2226:44825:43124", -- [22]
			"46552:47655:47644:47661:43104:2851:2861:1387:43053", -- [23]
			"46552:47655:47644:47661:43104:2851:2861:1387:43052", -- [24]
			"46552:47655:47644:47661:43104:2851:2861:13177:43086", -- [25]
			"46552:47655:47644:47661:43104", -- [26]
			"46552:47655:47644:47661:43104:2851:2861:13177:43086:6026:43121:43114", -- [27]
			"46552:47655:47644:47661:43104:2851:2861:13177:43086:6026:43121", -- [28]
			"46552:47655:47644:2389:43573", -- [29]
			"46552:47655:47644:2389:37888:12636:16189:44036", -- [30]
			"46552:47655:47644:2389:37888:44232:44231", -- [31]
			"46552:47655:47644:2389:37888:12636:16189:16192:44244", -- [32]
			"46552:47655:47644:47661:43104:2851:2861:44408", -- [33]
			"46552:47655:47644:47661:43104:2851:2861:44407", -- [34]
			"2226:44825", -- [35]
			"46552:47655:47644:2389:37915:46004", -- [36]
			"46552:47655:47644:2389:37915:46004:46011", -- [37]
			"46552:47655:47644", -- [38]
			"46552:47655", -- [39]
			"46552:47655:47644:47661", -- [40]
			"46552:47655:47644:2389:47665", -- [41]
			"46552:47655:47644:2389:37915:46004:46011:47875", -- [42]
			"46552:47655:47644:47661:43104:2851:2861:3305:47927", -- [43]
			"46552:47655:47644:47661:43104:2851:2861:13177:48321:48318", -- [44]
			"46552:47655:47644:47661:43104:2851:2861:13177:48321", -- [45]
			"2226:50463", -- [46]
			["direct"] = "2226:46552",
			["f"] = 0,
			["m"] = 684,
			["coord"] = 2462526887,
		},
		[47875] = {
			"46011:46004:37915:43124:44825:2226", -- [1]
			"46011:46004:37915:4551", -- [2]
			"46011:46004:37915:2389", -- [3]
			"46011:46004:43573:2851", -- [4]
			"46011:46004:43573:2851:2861:2858", -- [5]
			"46011:46004:43573:2851:2861:1387", -- [6]
			"46011:46004:43573:2851:2861", -- [7]
			"46011:46004:43573:2851:2861:13177:43086:6026", -- [8]
			"44233:44230:12636", -- [9]
			"46011:46004:43573:2851:2861:13177", -- [10]
			"46011:46004:43573:2851:2861:3305", -- [11]
			"46011:46004:43573:4314", -- [12]
			"44233:44230:12636:16189:16192", -- [13]
			"44233:44230:12636:16189", -- [14]
			"44233:28621", -- [15]
			"44233:44230", -- [16]
			"44233:44232", -- [17]
			"44233:44230:12636:24851", -- [18]
			"44233:44230:12636:24851:26560", -- [19]
			"46011:37888", -- [20]
			"46011:46004:37915", -- [21]
			"46011:46004:37915:43124", -- [22]
			"46011:46004:43573:2851:2861:1387:43053", -- [23]
			"46011:46004:43573:2851:2861:1387:43052", -- [24]
			"46011:46004:43573:2851:2861:13177:43086", -- [25]
			"46011:46004:37915:2389:43104", -- [26]
			"46011:46004:43573:2851:2861:13177:43086:6026:43121:43114", -- [27]
			"46011:46004:43573:2851:2861:13177:43086:6026:43121", -- [28]
			"46011:46004:43573", -- [29]
			"44233:44230:12636:16189:44036", -- [30]
			"44233:44231", -- [31]
			"44233:44230:12636:16189:16192:44244", -- [32]
			"44233:44230:12636:44407:44408", -- [33]
			"44233:44230:12636:44407", -- [34]
			"46011:46004:37915:43124:44825", -- [35]
			"46011:46004:37915:43124:44825:2226:45479", -- [36]
			"46011:46004", -- [37]
			"46011:46004:37915:43124:44825:2226:46552", -- [38]
			"46011:46004:37915:2389:47644", -- [39]
			"46011:46004:37915:2389:47644:47655", -- [40]
			"46011:46004:37915:2389:47661", -- [41]
			"46011:46004:37915:47665", -- [42]
			"46011:46004:43573:2851:2861:3305:47927", -- [43]
			"46011:46004:43573:2851:2861:13177:48321:48318", -- [44]
			"46011:46004:43573:2851:2861:13177:48321", -- [45]
			"46011:46004:37915:43124:44825:50463", -- [46]
			["direct"] = "44233:46011",
			["coord"] = 1914908429,
			["m"] = 22,
			["f"] = 0,
		},
		[48318] = {
			"48321:13177:2861:2851:2389:2226", -- [1]
			"48321:13177:2861:4551", -- [2]
			"48321:13177:2861:2851:2389", -- [3]
			"48321:13177:2861:2851", -- [4]
			"48321:13177:1387:2858", -- [5]
			"48321:13177:1387", -- [6]
			"48321:13177:2861", -- [7]
			"48321:13177:43086:6026", -- [8]
			"48321:13177:2861:44407:12636", -- [9]
			"48321:13177", -- [10]
			"47927:3305", -- [11]
			"48321:13177:2861:2851:4314", -- [12]
			"48321:13177:2861:44407:12636:16189:16192", -- [13]
			"48321:13177:2861:44407:12636:16189", -- [14]
			"48321:13177:2861:2851:43573:37888:44232:44233", -- [15]
			"48321:13177:2861:44407:12636:44230:28621", -- [16]
			"48321:13177:2861:44407:12636:44230", -- [17]
			"48321:13177:2861:2851:43573:37888:44232", -- [18]
			"48321:13177:2861:44407:12636:24851", -- [19]
			"48321:13177:2861:44407:12636:24851:26560", -- [20]
			"48321:13177:2861:2851:43573:37888", -- [21]
			"48321:13177:2861:2851:43573:46004:37915", -- [22]
			"48321:13177:2861:2851:43573:46004:37915:43124", -- [23]
			"48321:13177:1387:43053", -- [24]
			"48321:13177:1387:43052", -- [25]
			"48321:13177:43086", -- [26]
			"48321:13177:2861:2851:43104", -- [27]
			"48321:13177:43086:6026:43121:43114", -- [28]
			"48321:13177:43086:6026:43121", -- [29]
			"48321:13177:2861:2851:43573", -- [30]
			"48321:13177:2861:44407:12636:16189:44036", -- [31]
			"48321:13177:2861:44407:12636:44231", -- [32]
			"48321:13177:2861:44407:12636:16189:16192:44244", -- [33]
			"48321:13177:2861:44408", -- [34]
			"48321:13177:2861:44407", -- [35]
			"48321:13177:2861:2851:43573:46004:37915:43124:44825", -- [36]
			"48321:13177:2861:2851:43104:47661:47644:47655:46552:45479", -- [37]
			"48321:13177:2861:2851:43573:46004", -- [38]
			"48321:13177:2861:2851:43573:46004:46011", -- [39]
			"48321:13177:2861:2851:43104:47661:47644:47655:46552", -- [40]
			"48321:13177:2861:2851:43104:47661:47644", -- [41]
			"48321:13177:2861:2851:43104:47661:47644:47655", -- [42]
			"48321:13177:2861:2851:43104:47661", -- [43]
			"48321:13177:2861:2851:2389:47665", -- [44]
			"48321:13177:2861:2851:43573:46004:46011:47875", -- [45]
			"48321:13177:2861:2851:2389:2226:50463", -- [46]
			["direct"] = "47927:48321",
			["coord"] = 764708589,
			["m"] = 29,
			["f"] = 0,
		},
		[44036] = {
			"16189:12636:37888:2389:2226", -- [1]
			"16189:12636:37888:4551", -- [2]
			"16189:12636:37888:2389", -- [3]
			"16189:12636:4314:2851", -- [4]
			"16189:12636:44407:2861:2858", -- [5]
			"16189:12636:44407:2861:1387", -- [6]
			"16189:12636:44407:2861", -- [7]
			"16189:12636:44407:2861:13177:43086:6026", -- [8]
			"16189:12636", -- [9]
			"16189:12636:44407:2861:13177", -- [10]
			"16189:12636:44407:2861:3305", -- [11]
			"16189:12636:4314", -- [12]
			"16189:12636:44230:44233", -- [13]
			"16189:12636:44230:28621", -- [14]
			"16189:12636:44230", -- [15]
			"16189:12636:44231:44232", -- [16]
			"16189:24851", -- [17]
			"16192:26560", -- [18]
			"16189:12636:37888", -- [19]
			"16189:12636:37888:37915", -- [20]
			"16189:12636:37888:37915:43124", -- [21]
			"16189:12636:44407:2861:1387:43053", -- [22]
			"16189:12636:44407:2861:1387:43052", -- [23]
			"16189:12636:44407:2861:13177:43086", -- [24]
			"16189:12636:37888:2389:43104", -- [25]
			"16189:12636:44407:2861:13177:43086:6026:43121:43114", -- [26]
			"16189:12636:44407:2861:13177:43086:6026:43121", -- [27]
			"16189:12636:37888:43573", -- [28]
			"16189:12636:44231", -- [29]
			"16192:44244", -- [30]
			"16189:12636:44407:44408", -- [31]
			"16189:12636:44407", -- [32]
			"16189:12636:37888:37915:43124:44825", -- [33]
			"16189:12636:37888:2389:47644:47655:46552:45479", -- [34]
			"16189:12636:37888:46011:46004", -- [35]
			"16189:12636:37888:46011", -- [36]
			"16189:12636:37888:2389:47644:47655:46552", -- [37]
			"16189:12636:37888:2389:47644", -- [38]
			"16189:12636:37888:2389:47644:47655", -- [39]
			"16189:12636:37888:2389:47661", -- [40]
			"16189:12636:37888:37915:47665", -- [41]
			"16189:12636:44230:44233:47875", -- [42]
			"16189:12636:44407:2861:3305:47927", -- [43]
			"16189:12636:44407:2861:13177:48321:48318", -- [44]
			"16189:12636:44407:2861:13177:48321", -- [45]
			"16189:12636:37888:37915:43124:44825:50463", -- [46]
			["direct"] = "16192:16189",
			["coord"] = 1889448706,
			["m"] = 462,
			["f"] = 0,
		},
		[26560] = {
			"24851:12636:37888:2389:2226", -- [1]
			"24851:12636:37888:4551", -- [2]
			"24851:12636:37888:2389", -- [3]
			"24851:12636:4314:2851", -- [4]
			"24851:12636:44407:2861:2858", -- [5]
			"24851:12636:44407:2861:1387", -- [6]
			"24851:12636:44407:2861", -- [7]
			"24851:12636:44407:2861:13177:43086:6026", -- [8]
			"24851:12636", -- [9]
			"24851:12636:44407:2861:13177", -- [10]
			"24851:12636:44407:2861:3305", -- [11]
			"24851:12636:4314", -- [12]
			"16192:16189", -- [13]
			"24851:12636:44230:44233", -- [14]
			"24851:12636:44230:28621", -- [15]
			"24851:12636:44230", -- [16]
			"24851:12636:44231:44232", -- [17]
			"24851:12636:37888", -- [18]
			"24851:12636:37888:37915", -- [19]
			"24851:12636:37888:37915:43124", -- [20]
			"24851:12636:44407:2861:1387:43053", -- [21]
			"24851:12636:44407:2861:1387:43052", -- [22]
			"24851:12636:44407:2861:13177:43086", -- [23]
			"24851:12636:37888:2389:43104", -- [24]
			"24851:12636:44407:2861:13177:43086:6026:43121:43114", -- [25]
			"24851:12636:44407:2861:13177:43086:6026:43121", -- [26]
			"24851:12636:37888:43573", -- [27]
			"16192:44036", -- [28]
			"24851:12636:44231", -- [29]
			"16192:44244", -- [30]
			"24851:12636:44407:44408", -- [31]
			"24851:12636:44407", -- [32]
			"24851:12636:37888:37915:43124:44825", -- [33]
			"24851:12636:37888:2389:47644:47655:46552:45479", -- [34]
			"24851:12636:37888:46011:46004", -- [35]
			"24851:12636:37888:46011", -- [36]
			"24851:12636:37888:2389:47644:47655:46552", -- [37]
			"24851:12636:37888:2389:47644", -- [38]
			"24851:12636:37888:2389:47644:47655", -- [39]
			"24851:12636:37888:2389:47661", -- [40]
			"24851:12636:37888:37915:47665", -- [41]
			"24851:12636:44230:44233:47875", -- [42]
			"24851:12636:44407:2861:3305:47927", -- [43]
			"24851:12636:44407:2861:13177:48321:48318", -- [44]
			"24851:12636:44407:2861:13177:48321", -- [45]
			"24851:12636:37888:37915:43124:44825:50463", -- [46]
			["direct"] = "16192:24851",
			["coord"] = 2073575464,
			["m"] = 499,
			["f"] = 0,
		},
		[44231] = {
			"44232:37888:2389:2226", -- [1]
			"44232:37888:4551", -- [2]
			"44232:37888:2389", -- [3]
			"44232:37888:43573:2851", -- [4]
			"12636:44407:2861:2858", -- [5]
			"12636:44407:2861:1387", -- [6]
			"12636:44407:2861", -- [7]
			"12636:44407:2861:13177:43086:6026", -- [8]
			"12636:44407:2861:13177", -- [9]
			"12636:44407:2861:3305", -- [10]
			"12636:4314", -- [11]
			"12636:16189:16192", -- [12]
			"12636:16189", -- [13]
			"44230:28621", -- [14]
			"12636:24851", -- [15]
			"12636:24851:26560", -- [16]
			"44232:37888", -- [17]
			"44232:37888:37915", -- [18]
			"44232:37888:37915:43124", -- [19]
			"12636:44407:2861:1387:43053", -- [20]
			"12636:44407:2861:1387:43052", -- [21]
			"12636:44407:2861:13177:43086", -- [22]
			"44232:37888:2389:43104", -- [23]
			"12636:44407:2861:13177:43086:6026:43121:43114", -- [24]
			"12636:44407:2861:13177:43086:6026:43121", -- [25]
			"44232:37888:43573", -- [26]
			"12636:16189:44036", -- [27]
			"12636:16189:16192:44244", -- [28]
			"12636:44407:44408", -- [29]
			"12636:44407", -- [30]
			"44232:37888:37915:43124:44825", -- [31]
			"44232:37888:2389:47644:47655:46552:45479", -- [32]
			"44232:37888:46011:46004", -- [33]
			"44232:37888:46011", -- [34]
			"44232:37888:2389:47644:47655:46552", -- [35]
			"44232:37888:2389:47644", -- [36]
			"44232:37888:2389:47644:47655", -- [37]
			"44232:37888:2389:47661", -- [38]
			"44232:37888:37915:47665", -- [39]
			"44233:47875", -- [40]
			"12636:44407:2861:3305:47927", -- [41]
			"12636:44407:2861:13177:48321:48318", -- [42]
			"12636:44407:2861:13177:48321", -- [43]
			"44232:37888:37915:43124:44825:50463", -- [44]
			["direct"] = "12636:44233:44230:44232",
			["coord"] = 2262993245,
			["m"] = 23,
			["f"] = 0,
		},
		[44233] = {
			"44232:37888:2389:2226", -- [1]
			"44232:37888:4551", -- [2]
			"44232:37888:2389", -- [3]
			"44232:37888:43573:2851", -- [4]
			"44230:12636:44407:2861:2858", -- [5]
			"44230:12636:44407:2861:1387", -- [6]
			"44230:12636:44407:2861", -- [7]
			"44230:12636:44407:2861:13177:43086:6026", -- [8]
			"44230:12636", -- [9]
			"44230:12636:44407:2861:13177", -- [10]
			"44230:12636:44407:2861:3305", -- [11]
			"44230:12636:4314", -- [12]
			"44230:12636:16189:16192", -- [13]
			"44230:12636:16189", -- [14]
			"44230:12636:24851", -- [15]
			"44230:12636:24851:26560", -- [16]
			"44232:37888", -- [17]
			"44232:37888:37915", -- [18]
			"44232:37888:37915:43124", -- [19]
			"44230:12636:44407:2861:1387:43053", -- [20]
			"44230:12636:44407:2861:1387:43052", -- [21]
			"44230:12636:44407:2861:13177:43086", -- [22]
			"44232:37888:2389:43104", -- [23]
			"44230:12636:44407:2861:13177:43086:6026:43121:43114", -- [24]
			"44230:12636:44407:2861:13177:43086:6026:43121", -- [25]
			"44232:37888:43573", -- [26]
			"44230:12636:16189:44036", -- [27]
			"44230:12636:16189:16192:44244", -- [28]
			"44230:12636:44407:44408", -- [29]
			"44230:12636:44407", -- [30]
			"44232:37888:37915:43124:44825", -- [31]
			"44232:37888:2389:47644:47655:46552:45479", -- [32]
			"47875:46011:46004", -- [33]
			"47875:46011", -- [34]
			"44232:37888:2389:47644:47655:46552", -- [35]
			"44232:37888:2389:47644", -- [36]
			"44232:37888:2389:47644:47655", -- [37]
			"44232:37888:2389:47661", -- [38]
			"44232:37888:37915:47665", -- [39]
			"44230:12636:44407:2861:3305:47927", -- [40]
			"44230:12636:44407:2861:13177:48321:48318", -- [41]
			"44230:12636:44407:2861:13177:48321", -- [42]
			"44232:37888:37915:43124:44825:50463", -- [43]
			["direct"] = "28621:44230:44232:44231:47875",
			["coord"] = 794904155,
			["m"] = 23,
			["f"] = 0,
		},
		[43053] = {
			"1387:2861:2851:2389:2226", -- [1]
			"1387:2861:4551", -- [2]
			"1387:2861:2851:2389", -- [3]
			"1387:2861:2851", -- [4]
			"1387:2861", -- [5]
			"1387:6026", -- [6]
			"1387:2861:44407:12636", -- [7]
			"1387:13177", -- [8]
			"1387:13177:3305", -- [9]
			"1387:2861:2851:4314", -- [10]
			"1387:2861:44407:12636:16189:16192", -- [11]
			"1387:2861:44407:12636:16189", -- [12]
			"1387:2861:2851:43573:37888:44232:44233", -- [13]
			"1387:2861:44407:12636:44230:28621", -- [14]
			"1387:2861:44407:12636:44230", -- [15]
			"1387:2861:2851:43573:37888:44232", -- [16]
			"1387:2861:44407:12636:24851", -- [17]
			"1387:2861:44407:12636:24851:26560", -- [18]
			"1387:2861:2851:43573:37888", -- [19]
			"1387:2861:2851:43573:46004:37915", -- [20]
			"1387:2861:2851:43573:46004:37915:43124", -- [21]
			"1387:6026:43086", -- [22]
			"1387:2861:2851:43104", -- [23]
			"2858:43114", -- [24]
			"1387:6026:43121", -- [25]
			"1387:2861:2851:43573", -- [26]
			"1387:2861:44407:12636:16189:44036", -- [27]
			"1387:2861:44407:12636:44231", -- [28]
			"1387:2861:44407:12636:16189:16192:44244", -- [29]
			"1387:2861:44408", -- [30]
			"1387:2861:44407", -- [31]
			"1387:2861:2851:43573:46004:37915:43124:44825", -- [32]
			"1387:2861:2851:43104:47661:47644:47655:46552:45479", -- [33]
			"1387:2861:2851:43573:46004", -- [34]
			"1387:2861:2851:43573:46004:46011", -- [35]
			"1387:2861:2851:43104:47661:47644:47655:46552", -- [36]
			"1387:2861:2851:43104:47661:47644", -- [37]
			"1387:2861:2851:43104:47661:47644:47655", -- [38]
			"1387:2861:2851:43104:47661", -- [39]
			"1387:2861:2851:2389:47665", -- [40]
			"1387:2861:2851:43573:46004:46011:47875", -- [41]
			"1387:13177:3305:47927", -- [42]
			"1387:13177:48321:48318", -- [43]
			"1387:13177:48321", -- [44]
			"1387:2861:2851:2389:2226:50463", -- [45]
			["direct"] = "2858:1387:43052",
			["coord"] = 1508985618,
			["m"] = 673,
			["f"] = 0,
		},
		[2858] = {
			"2861:2851:2389:2226", -- [1]
			"2861:4551", -- [2]
			"2861:2851:2389", -- [3]
			"2861:2851", -- [4]
			"2861:44407:12636", -- [5]
			"1387:13177", -- [6]
			"1387:13177:3305", -- [7]
			"2861:2851:4314", -- [8]
			"2861:44407:12636:16189:16192", -- [9]
			"2861:44407:12636:16189", -- [10]
			"2861:2851:43573:37888:44232:44233", -- [11]
			"2861:44407:12636:44230:28621", -- [12]
			"2861:44407:12636:44230", -- [13]
			"2861:2851:43573:37888:44232", -- [14]
			"2861:44407:12636:24851", -- [15]
			"2861:44407:12636:24851:26560", -- [16]
			"2861:2851:43573:37888", -- [17]
			"2861:2851:43573:46004:37915", -- [18]
			"2861:2851:43573:46004:37915:43124", -- [19]
			"43053:43052", -- [20]
			"6026:43086", -- [21]
			"2861:2851:43104", -- [22]
			"43114:43121", -- [23]
			"2861:2851:43573", -- [24]
			"2861:44407:12636:16189:44036", -- [25]
			"2861:44407:12636:44231", -- [26]
			"2861:44407:12636:16189:16192:44244", -- [27]
			"2861:44408", -- [28]
			"2861:44407", -- [29]
			"2861:2851:43573:46004:37915:43124:44825", -- [30]
			"2861:2851:43104:47661:47644:47655:46552:45479", -- [31]
			"2861:2851:43573:46004", -- [32]
			"2861:2851:43573:46004:46011", -- [33]
			"2861:2851:43104:47661:47644:47655:46552", -- [34]
			"2861:2851:43104:47661:47644", -- [35]
			"2861:2851:43104:47661:47644:47655", -- [36]
			"2861:2851:43104:47661", -- [37]
			"2861:2851:2389:47665", -- [38]
			"2861:2851:43573:46004:46011:47875", -- [39]
			"1387:13177:3305:47927", -- [40]
			"1387:13177:48321:48318", -- [41]
			"1387:13177:48321", -- [42]
			"2861:2851:2389:2226:50463", -- [43]
			["direct"] = "1387:2861:6026:43053:43114",
			["coord"] = 1741994930,
			["m"] = 673,
			["f"] = 0,
		},
		[46011] = {
			"46004:37915:43124:44825:2226", -- [1]
			"46004:37915:4551", -- [2]
			"46004:37915:2389", -- [3]
			"46004:43573:2851", -- [4]
			"46004:43573:2851:2861:2858", -- [5]
			"46004:43573:2851:2861:1387", -- [6]
			"46004:43573:2851:2861", -- [7]
			"46004:43573:2851:2861:13177:43086:6026", -- [8]
			"37888:12636", -- [9]
			"46004:43573:2851:2861:13177", -- [10]
			"46004:43573:2851:2861:3305", -- [11]
			"46004:43573:4314", -- [12]
			"37888:12636:16189:16192", -- [13]
			"37888:12636:16189", -- [14]
			"47875:44233", -- [15]
			"37888:44232:28621", -- [16]
			"37888:44232:44231:44230", -- [17]
			"37888:44232", -- [18]
			"37888:12636:24851", -- [19]
			"37888:12636:24851:26560", -- [20]
			"46004:37915", -- [21]
			"46004:37915:43124", -- [22]
			"46004:43573:2851:2861:1387:43053", -- [23]
			"46004:43573:2851:2861:1387:43052", -- [24]
			"46004:43573:2851:2861:13177:43086", -- [25]
			"46004:37915:2389:43104", -- [26]
			"46004:43573:2851:2861:13177:43086:6026:43121:43114", -- [27]
			"46004:43573:2851:2861:13177:43086:6026:43121", -- [28]
			"46004:43573", -- [29]
			"37888:12636:16189:44036", -- [30]
			"37888:44232:44231", -- [31]
			"37888:12636:16189:16192:44244", -- [32]
			"37888:12636:44407:44408", -- [33]
			"37888:12636:44407", -- [34]
			"46004:37915:43124:44825", -- [35]
			"46004:37915:43124:44825:2226:45479", -- [36]
			"46004:37915:43124:44825:2226:46552", -- [37]
			"46004:37915:2389:47644", -- [38]
			"46004:37915:2389:47644:47655", -- [39]
			"46004:37915:2389:47661", -- [40]
			"46004:37915:47665", -- [41]
			"46004:43573:2851:2861:3305:47927", -- [42]
			"46004:43573:2851:2861:13177:48321:48318", -- [43]
			"46004:43573:2851:2861:13177:48321", -- [44]
			"46004:37915:43124:44825:50463", -- [45]
			["direct"] = "37888:46004:47875",
			["coord"] = 2169931305,
			["m"] = 22,
			["f"] = 0,
		},
		[43052] = {
			"1387:2861:2851:2389:2226", -- [1]
			"1387:2861:4551", -- [2]
			"1387:2861:2851:2389", -- [3]
			"1387:2861:2851", -- [4]
			"43053:2858", -- [5]
			"1387:2861", -- [6]
			"1387:6026", -- [7]
			"1387:2861:44407:12636", -- [8]
			"1387:13177", -- [9]
			"1387:13177:3305", -- [10]
			"1387:2861:2851:4314", -- [11]
			"1387:2861:44407:12636:16189:16192", -- [12]
			"1387:2861:44407:12636:16189", -- [13]
			"1387:2861:2851:43573:37888:44232:44233", -- [14]
			"1387:2861:44407:12636:44230:28621", -- [15]
			"1387:2861:44407:12636:44230", -- [16]
			"1387:2861:2851:43573:37888:44232", -- [17]
			"1387:2861:44407:12636:24851", -- [18]
			"1387:2861:44407:12636:24851:26560", -- [19]
			"1387:2861:2851:43573:37888", -- [20]
			"1387:2861:2851:43573:46004:37915", -- [21]
			"1387:2861:2851:43573:46004:37915:43124", -- [22]
			"1387:6026:43086", -- [23]
			"1387:2861:2851:43104", -- [24]
			"43053:2858:43114", -- [25]
			"1387:6026:43121", -- [26]
			"1387:2861:2851:43573", -- [27]
			"1387:2861:44407:12636:16189:44036", -- [28]
			"1387:2861:44407:12636:44231", -- [29]
			"1387:2861:44407:12636:16189:16192:44244", -- [30]
			"1387:2861:44408", -- [31]
			"1387:2861:44407", -- [32]
			"1387:2861:2851:43573:46004:37915:43124:44825", -- [33]
			"1387:2861:2851:43104:47661:47644:47655:46552:45479", -- [34]
			"1387:2861:2851:43573:46004", -- [35]
			"1387:2861:2851:43573:46004:46011", -- [36]
			"1387:2861:2851:43104:47661:47644:47655:46552", -- [37]
			"1387:2861:2851:43104:47661:47644", -- [38]
			"1387:2861:2851:43104:47661:47644:47655", -- [39]
			"1387:2861:2851:43104:47661", -- [40]
			"1387:2861:2851:2389:47665", -- [41]
			"1387:2861:2851:43573:46004:46011:47875", -- [42]
			"1387:13177:3305:47927", -- [43]
			"1387:13177:48321:48318", -- [44]
			"1387:13177:48321", -- [45]
			"1387:2861:2851:2389:2226:50463", -- [46]
			["direct"] = "1387:43053",
			["coord"] = 2679465147,
			["m"] = 37,
			["f"] = 0,
		},
		[37888] = {
			"2389:2226", -- [1]
			"43573:2851", -- [2]
			"43573:2851:2861:2858", -- [3]
			"43573:2851:2861:1387", -- [4]
			"43573:2851:2861", -- [5]
			"43573:2851:2861:13177:43086:6026", -- [6]
			"43573:2851:2861:13177", -- [7]
			"43573:2851:2861:3305", -- [8]
			"43573:4314", -- [9]
			"12636:16189:16192", -- [10]
			"12636:16189", -- [11]
			"44232:44233", -- [12]
			"44232:28621", -- [13]
			"44232:44231:44230", -- [14]
			"12636:24851", -- [15]
			"12636:24851:26560", -- [16]
			"37915:43124", -- [17]
			"43573:2851:2861:1387:43053", -- [18]
			"43573:2851:2861:1387:43052", -- [19]
			"43573:2851:2861:13177:43086", -- [20]
			"2389:43104", -- [21]
			"43573:2851:2861:13177:43086:6026:43121:43114", -- [22]
			"43573:2851:2861:13177:43086:6026:43121", -- [23]
			"12636:16189:44036", -- [24]
			"44232:44231", -- [25]
			"12636:16189:16192:44244", -- [26]
			"12636:44407:44408", -- [27]
			"12636:44407", -- [28]
			"37915:43124:44825", -- [29]
			"2389:47644:47655:46552:45479", -- [30]
			"46011:46004", -- [31]
			"2389:47644:47655:46552", -- [32]
			"2389:47644", -- [33]
			"2389:47644:47655", -- [34]
			"2389:47661", -- [35]
			"37915:47665", -- [36]
			"46011:47875", -- [37]
			"43573:2851:2861:3305:47927", -- [38]
			"43573:2851:2861:13177:48321:48318", -- [39]
			"43573:2851:2861:13177:48321", -- [40]
			"37915:43124:44825:50463", -- [41]
			["direct"] = "4551:2389:12636:44232:37915:43573:46011",
			["coord"] = 433629294,
			["m"] = 23,
			["f"] = 0,
		},
		[47655] = {
			"46552:2226", -- [1]
			"46552:2226:4551", -- [2]
			"47644:2389", -- [3]
			"47644:47661:43104:2851", -- [4]
			"47644:47661:43104:2851:2861:2858", -- [5]
			"47644:47661:43104:2851:2861:1387", -- [6]
			"47644:47661:43104:2851:2861", -- [7]
			"47644:47661:43104:2851:2861:13177:43086:6026", -- [8]
			"47644:2389:37888:12636", -- [9]
			"47644:47661:43104:2851:2861:13177", -- [10]
			"47644:47661:43104:2851:2861:3305", -- [11]
			"47644:2389:4314", -- [12]
			"47644:2389:37888:12636:16189:16192", -- [13]
			"47644:2389:37888:12636:16189", -- [14]
			"47644:2389:37888:44232:44233", -- [15]
			"47644:2389:37888:44232:28621", -- [16]
			"47644:2389:37888:44232:44231:44230", -- [17]
			"47644:2389:37888:44232", -- [18]
			"47644:2389:37888:12636:24851", -- [19]
			"47644:2389:37888:12636:24851:26560", -- [20]
			"47644:2389:37888", -- [21]
			"47644:2389:37915", -- [22]
			"46552:2226:44825:43124", -- [23]
			"47644:47661:43104:2851:2861:1387:43053", -- [24]
			"47644:47661:43104:2851:2861:1387:43052", -- [25]
			"47644:47661:43104:2851:2861:13177:43086", -- [26]
			"47644:47661:43104", -- [27]
			"47644:47661:43104:2851:2861:13177:43086:6026:43121:43114", -- [28]
			"47644:47661:43104:2851:2861:13177:43086:6026:43121", -- [29]
			"47644:2389:43573", -- [30]
			"47644:2389:37888:12636:16189:44036", -- [31]
			"47644:2389:37888:44232:44231", -- [32]
			"47644:2389:37888:12636:16189:16192:44244", -- [33]
			"47644:47661:43104:2851:2861:44408", -- [34]
			"47644:47661:43104:2851:2861:44407", -- [35]
			"46552:2226:44825", -- [36]
			"46552:45479", -- [37]
			"47644:2389:37915:46004", -- [38]
			"47644:2389:37915:46004:46011", -- [39]
			"47644:47661", -- [40]
			"47644:2389:47665", -- [41]
			"47644:2389:37915:46004:46011:47875", -- [42]
			"47644:47661:43104:2851:2861:3305:47927", -- [43]
			"47644:47661:43104:2851:2861:13177:48321:48318", -- [44]
			"47644:47661:43104:2851:2861:13177:48321", -- [45]
			"46552:2226:50463", -- [46]
			["direct"] = "46552:47644",
			["coord"] = 1249420484,
			["m"] = 24,
			["f"] = 0,
		},
		[43121] = {
			"6026:2861:2851:2389:2226", -- [1]
			"6026:2861:4551", -- [2]
			"6026:2861:2851:2389", -- [3]
			"6026:2861:2851", -- [4]
			"43114:2858", -- [5]
			"6026:1387", -- [6]
			"6026:2861", -- [7]
			"6026:2861:44407:12636", -- [8]
			"6026:43086:13177", -- [9]
			"6026:43086:13177:3305", -- [10]
			"6026:2861:2851:4314", -- [11]
			"6026:2861:44407:12636:16189:16192", -- [12]
			"6026:2861:44407:12636:16189", -- [13]
			"6026:2861:2851:43573:37888:44232:44233", -- [14]
			"6026:2861:44407:12636:44230:28621", -- [15]
			"6026:2861:44407:12636:44230", -- [16]
			"6026:2861:2851:43573:37888:44232", -- [17]
			"6026:2861:44407:12636:24851", -- [18]
			"6026:2861:44407:12636:24851:26560", -- [19]
			"6026:2861:2851:43573:37888", -- [20]
			"6026:2861:2851:43573:46004:37915", -- [21]
			"6026:2861:2851:43573:46004:37915:43124", -- [22]
			"6026:1387:43053", -- [23]
			"6026:1387:43052", -- [24]
			"6026:43086", -- [25]
			"6026:2861:2851:43104", -- [26]
			"6026:2861:2851:43573", -- [27]
			"6026:2861:44407:12636:16189:44036", -- [28]
			"6026:2861:44407:12636:44231", -- [29]
			"6026:2861:44407:12636:16189:16192:44244", -- [30]
			"6026:2861:44408", -- [31]
			"6026:2861:44407", -- [32]
			"6026:2861:2851:43573:46004:37915:43124:44825", -- [33]
			"6026:2861:2851:43104:47661:47644:47655:46552:45479", -- [34]
			"6026:2861:2851:43573:46004", -- [35]
			"6026:2861:2851:43573:46004:46011", -- [36]
			"6026:2861:2851:43104:47661:47644:47655:46552", -- [37]
			"6026:2861:2851:43104:47661:47644", -- [38]
			"6026:2861:2851:43104:47661:47644:47655", -- [39]
			"6026:2861:2851:43104:47661", -- [40]
			"6026:2861:2851:2389:47665", -- [41]
			"6026:2861:2851:43573:46004:46011:47875", -- [42]
			"6026:43086:13177:3305:47927", -- [43]
			"6026:43086:13177:48321:48318", -- [44]
			"6026:43086:13177:48321", -- [45]
			"6026:2861:2851:2389:2226:50463", -- [46]
			["direct"] = "6026:43114",
			["coord"] = 1873028273,
			["m"] = 19,
			["f"] = 0,
		},
		[47661] = {
			"2389:2226", -- [1]
			"2389:4551", -- [2]
			"43104:2851", -- [3]
			"43104:2851:2861:2858", -- [4]
			"43104:2851:2861:1387", -- [5]
			"43104:2851:2861", -- [6]
			"43104:2851:2861:13177:43086:6026", -- [7]
			"2389:37888:12636", -- [8]
			"43104:2851:2861:13177", -- [9]
			"43104:2851:2861:3305", -- [10]
			"2389:4314", -- [11]
			"2389:37888:12636:16189:16192", -- [12]
			"2389:37888:12636:16189", -- [13]
			"2389:37888:44232:44233", -- [14]
			"2389:37888:44232:28621", -- [15]
			"2389:37888:44232:44231:44230", -- [16]
			"2389:37888:44232", -- [17]
			"2389:37888:12636:24851", -- [18]
			"2389:37888:12636:24851:26560", -- [19]
			"2389:37888", -- [20]
			"2389:37915", -- [21]
			"2389:37915:43124", -- [22]
			"43104:2851:2861:1387:43053", -- [23]
			"43104:2851:2861:1387:43052", -- [24]
			"43104:2851:2861:13177:43086", -- [25]
			"43104:2851:2861:13177:43086:6026:43121:43114", -- [26]
			"43104:2851:2861:13177:43086:6026:43121", -- [27]
			"2389:43573", -- [28]
			"2389:37888:12636:16189:44036", -- [29]
			"2389:37888:44232:44231", -- [30]
			"2389:37888:12636:16189:16192:44244", -- [31]
			"43104:2851:2861:44408", -- [32]
			"43104:2851:2861:44407", -- [33]
			"2389:2226:44825", -- [34]
			"47644:47655:46552:45479", -- [35]
			"2389:37915:46004", -- [36]
			"2389:37915:46004:46011", -- [37]
			"47644:47655:46552", -- [38]
			"47644:47655", -- [39]
			"2389:47665", -- [40]
			"2389:37915:46004:46011:47875", -- [41]
			"43104:2851:2861:3305:47927", -- [42]
			"43104:2851:2861:13177:48321:48318", -- [43]
			"43104:2851:2861:13177:48321", -- [44]
			"2389:2226:50463", -- [45]
			["direct"] = "2389:43104:47644",
			["coord"] = 2562564542,
			["m"] = 24,
			["f"] = 0,
		},
		[4551] = {
			"2861:2858", -- [1]
			"2861:1387", -- [2]
			"2861:13177:43086:6026", -- [3]
			"2861:13177", -- [4]
			"2861:3305", -- [5]
			"12636:16189:16192", -- [6]
			"12636:16189", -- [7]
			"37915:46004:46011:47875:44233", -- [8]
			"37888:44232:28621", -- [9]
			"37888:44232:44231:44230", -- [10]
			"37888:44232", -- [11]
			"12636:24851", -- [12]
			"12636:24851:26560", -- [13]
			"2861:1387:43053", -- [14]
			"2861:1387:43052", -- [15]
			"2861:13177:43086", -- [16]
			"2861:13177:43086:6026:43121:43114", -- [17]
			"2861:13177:43086:6026:43121", -- [18]
			"37915:46004:43573", -- [19]
			"12636:16189:44036", -- [20]
			"37888:44232:44231", -- [21]
			"12636:16189:16192:44244", -- [22]
			"2861:44408", -- [23]
			"2861:44407", -- [24]
			"2226:45479", -- [25]
			"37915:46004", -- [26]
			"37915:46004:46011", -- [27]
			"2226:46552", -- [28]
			"2389:47644", -- [29]
			"2226:46552:47655", -- [30]
			"2389:47661", -- [31]
			"37915:47665", -- [32]
			"37915:46004:46011:47875", -- [33]
			"2861:3305:47927", -- [34]
			"2861:13177:48321:48318", -- [35]
			"2861:13177:48321", -- [36]
			"44825:50463", -- [37]
			["direct"] = "2226:2389:2851:2861:12636:4314:37888:37915:43124:43104:44825",
			["coord"] = 2709486517,
			["m"] = 382,
			["f"] = 0,
		},
		[2851] = {
			"2389:2226", -- [1]
			"2861:2858", -- [2]
			"2861:1387", -- [3]
			"2861:13177:43086:6026", -- [4]
			"4314:12636", -- [5]
			"2861:13177", -- [6]
			"2861:3305", -- [7]
			"4314:12636:16189:16192", -- [8]
			"4314:12636:16189", -- [9]
			"43573:37888:44232:44233", -- [10]
			"43573:37888:44232:28621", -- [11]
			"43573:37888:44232:44231:44230", -- [12]
			"43573:37888:44232", -- [13]
			"4314:12636:24851", -- [14]
			"4314:12636:24851:26560", -- [15]
			"43573:37888", -- [16]
			"43573:46004:37915", -- [17]
			"43573:46004:37915:43124", -- [18]
			"2861:1387:43053", -- [19]
			"2861:1387:43052", -- [20]
			"2861:13177:43086", -- [21]
			"2861:13177:43086:6026:43121:43114", -- [22]
			"2861:13177:43086:6026:43121", -- [23]
			"4314:12636:16189:44036", -- [24]
			"43573:37888:44232:44231", -- [25]
			"4314:12636:16189:16192:44244", -- [26]
			"2861:44408", -- [27]
			"2861:44407", -- [28]
			"43573:46004:37915:43124:44825", -- [29]
			"43104:47661:47644:47655:46552:45479", -- [30]
			"43573:46004", -- [31]
			"43573:46004:46011", -- [32]
			"43104:47661:47644:47655:46552", -- [33]
			"43104:47661:47644", -- [34]
			"43104:47661:47644:47655", -- [35]
			"43104:47661", -- [36]
			"2389:47665", -- [37]
			"43573:46004:46011:47875", -- [38]
			"2861:3305:47927", -- [39]
			"2861:13177:48321:48318", -- [40]
			"2861:13177:48321", -- [41]
			"2389:2226:50463", -- [42]
			["direct"] = "4551:2389:2861:4314:43104:43573",
			["coord"] = 2927252869,
			["m"] = 16,
			["f"] = 0,
		},
		[47665] = {
			"2389:2226", -- [1]
			"37915:4551", -- [2]
			"2389:2851", -- [3]
			"2389:2851:2861:2858", -- [4]
			"2389:2851:2861:1387", -- [5]
			"2389:2851:2861", -- [6]
			"2389:2851:2861:13177:43086:6026", -- [7]
			"37915:37888:12636", -- [8]
			"2389:2851:2861:13177", -- [9]
			"2389:2851:2861:3305", -- [10]
			"2389:4314", -- [11]
			"37915:37888:12636:16189:16192", -- [12]
			"37915:37888:12636:16189", -- [13]
			"37915:46004:46011:47875:44233", -- [14]
			"37915:37888:44232:28621", -- [15]
			"37915:37888:44232:44231:44230", -- [16]
			"37915:37888:44232", -- [17]
			"37915:37888:12636:24851", -- [18]
			"37915:37888:12636:24851:26560", -- [19]
			"37915:37888", -- [20]
			"37915:43124", -- [21]
			"2389:2851:2861:1387:43053", -- [22]
			"2389:2851:2861:1387:43052", -- [23]
			"2389:2851:2861:13177:43086", -- [24]
			"2389:43104", -- [25]
			"2389:2851:2861:13177:43086:6026:43121:43114", -- [26]
			"2389:2851:2861:13177:43086:6026:43121", -- [27]
			"2389:43573", -- [28]
			"37915:37888:12636:16189:44036", -- [29]
			"37915:37888:44232:44231", -- [30]
			"37915:37888:12636:16189:16192:44244", -- [31]
			"2389:2851:2861:44408", -- [32]
			"2389:2851:2861:44407", -- [33]
			"37915:43124:44825", -- [34]
			"2389:47644:47655:46552:45479", -- [35]
			"37915:46004", -- [36]
			"37915:46004:46011", -- [37]
			"2389:47644:47655:46552", -- [38]
			"2389:47644", -- [39]
			"2389:47644:47655", -- [40]
			"2389:47661", -- [41]
			"37915:46004:46011:47875", -- [42]
			"2389:2851:2861:3305:47927", -- [43]
			"2389:2851:2861:13177:48321:48318", -- [44]
			"2389:2851:2861:13177:48321", -- [45]
			"37915:43124:44825:50463", -- [46]
			["direct"] = "2389:37915",
			["coord"] = 2499298250,
			["m"] = 24,
			["f"] = 0,
		},
		[16189] = {
			"12636:37888:2389:2226", -- [1]
			"12636:37888:4551", -- [2]
			"12636:37888:2389", -- [3]
			"12636:4314:2851", -- [4]
			"12636:44407:2861:2858", -- [5]
			"12636:44407:2861:1387", -- [6]
			"12636:44407:2861", -- [7]
			"12636:44407:2861:13177:43086:6026", -- [8]
			"12636:44407:2861:13177", -- [9]
			"12636:44407:2861:3305", -- [10]
			"12636:4314", -- [11]
			"12636:44230:44233", -- [12]
			"12636:44230:28621", -- [13]
			"12636:44230", -- [14]
			"12636:44231:44232", -- [15]
			"16192:26560", -- [16]
			"12636:37888", -- [17]
			"12636:37888:37915", -- [18]
			"12636:37888:37915:43124", -- [19]
			"12636:44407:2861:1387:43053", -- [20]
			"12636:44407:2861:1387:43052", -- [21]
			"12636:44407:2861:13177:43086", -- [22]
			"12636:37888:2389:43104", -- [23]
			"12636:44407:2861:13177:43086:6026:43121:43114", -- [24]
			"12636:44407:2861:13177:43086:6026:43121", -- [25]
			"12636:37888:43573", -- [26]
			"12636:44231", -- [27]
			"16192:44244", -- [28]
			"12636:44407:44408", -- [29]
			"12636:44407", -- [30]
			"12636:37888:37915:43124:44825", -- [31]
			"12636:37888:2389:47644:47655:46552:45479", -- [32]
			"12636:37888:46011:46004", -- [33]
			"12636:37888:46011", -- [34]
			"12636:37888:2389:47644:47655:46552", -- [35]
			"12636:37888:2389:47644", -- [36]
			"12636:37888:2389:47644:47655", -- [37]
			"12636:37888:2389:47661", -- [38]
			"12636:37888:37915:47665", -- [39]
			"12636:44230:44233:47875", -- [40]
			"12636:44407:2861:3305:47927", -- [41]
			"12636:44407:2861:13177:48321:48318", -- [42]
			"12636:44407:2861:13177:48321", -- [43]
			"12636:37888:37915:43124:44825:50463", -- [44]
			["direct"] = "12636:16192:24851:44036",
			["coord"] = 1953517112,
			["m"] = 463,
			["f"] = 0,
		},
		[2389] = {
			"2851:2861:2858", -- [1]
			"2851:2861:1387", -- [2]
			"2851:2861", -- [3]
			"2851:2861:13177:43086:6026", -- [4]
			"37888:12636", -- [5]
			"2851:2861:13177", -- [6]
			"2851:2861:3305", -- [7]
			"37888:12636:16189:16192", -- [8]
			"37888:12636:16189", -- [9]
			"37888:44232:44233", -- [10]
			"37888:44232:28621", -- [11]
			"37888:44232:44231:44230", -- [12]
			"37888:44232", -- [13]
			"37888:12636:24851", -- [14]
			"37888:12636:24851:26560", -- [15]
			"37915:43124", -- [16]
			"2851:2861:1387:43053", -- [17]
			"2851:2861:1387:43052", -- [18]
			"2851:2861:13177:43086", -- [19]
			"2851:2861:13177:43086:6026:43121:43114", -- [20]
			"2851:2861:13177:43086:6026:43121", -- [21]
			"37888:12636:16189:44036", -- [22]
			"37888:44232:44231", -- [23]
			"37888:12636:16189:16192:44244", -- [24]
			"2851:2861:44408", -- [25]
			"2851:2861:44407", -- [26]
			"2226:44825", -- [27]
			"47644:47655:46552:45479", -- [28]
			"37915:46004", -- [29]
			"37915:46004:46011", -- [30]
			"47644:47655:46552", -- [31]
			"47644:47655", -- [32]
			"37915:46004:46011:47875", -- [33]
			"2851:2861:3305:47927", -- [34]
			"2851:2861:13177:48321:48318", -- [35]
			"2851:2861:13177:48321", -- [36]
			"2226:50463", -- [37]
			["direct"] = "2226:4551:2851:4314:37888:37915:43104:43573:47644:47661:47665",
			["coord"] = 2406577710,
			["m"] = 24,
			["f"] = 0,
		},
		[44408] = {
			"2861:2851:2389:2226", -- [1]
			"2861:4551", -- [2]
			"2861:2851:2389", -- [3]
			"2861:2851", -- [4]
			"2861:2858", -- [5]
			"2861:1387", -- [6]
			"2861:13177:43086:6026", -- [7]
			"44407:12636", -- [8]
			"2861:13177", -- [9]
			"2861:3305", -- [10]
			"2861:2851:4314", -- [11]
			"44407:12636:16189:16192", -- [12]
			"44407:12636:16189", -- [13]
			"44407:12636:44230:44233", -- [14]
			"44407:12636:44230:28621", -- [15]
			"44407:12636:44230", -- [16]
			"44407:12636:44231:44232", -- [17]
			"44407:12636:24851", -- [18]
			"44407:12636:24851:26560", -- [19]
			"2861:2851:43573:37888", -- [20]
			"2861:2851:43573:46004:37915", -- [21]
			"2861:2851:43573:46004:37915:43124", -- [22]
			"2861:1387:43053", -- [23]
			"2861:1387:43052", -- [24]
			"2861:13177:43086", -- [25]
			"2861:2851:43104", -- [26]
			"2861:13177:43086:6026:43121:43114", -- [27]
			"2861:13177:43086:6026:43121", -- [28]
			"2861:2851:43573", -- [29]
			"44407:12636:16189:44036", -- [30]
			"44407:12636:44231", -- [31]
			"44407:12636:16189:16192:44244", -- [32]
			"2861:2851:43573:46004:37915:43124:44825", -- [33]
			"2861:2851:43104:47661:47644:47655:46552:45479", -- [34]
			"2861:2851:43573:46004", -- [35]
			"2861:2851:43573:46004:46011", -- [36]
			"2861:2851:43104:47661:47644:47655:46552", -- [37]
			"2861:2851:43104:47661:47644", -- [38]
			"2861:2851:43104:47661:47644:47655", -- [39]
			"2861:2851:43104:47661", -- [40]
			"2861:2851:2389:47665", -- [41]
			"2861:2851:43573:46004:46011:47875", -- [42]
			"2861:3305:47927", -- [43]
			"2861:13177:48321:48318", -- [44]
			"2861:13177:48321", -- [45]
			"2861:2851:2389:2226:50463", -- [46]
			["direct"] = "2861:44407",
			["coord"] = 2250932811,
			["m"] = 17,
			["f"] = 0,
		},
		[44825] = {
			"2226:2389", -- [1]
			"2226:2389:2851", -- [2]
			"2226:2389:2851:2861:2858", -- [3]
			"2226:2389:2851:2861:1387", -- [4]
			"2226:2389:2851:2861", -- [5]
			"2226:2389:2851:2861:13177:43086:6026", -- [6]
			"43124:37915:37888:12636", -- [7]
			"2226:2389:2851:2861:13177", -- [8]
			"2226:2389:2851:2861:3305", -- [9]
			"2226:2389:4314", -- [10]
			"43124:37915:37888:12636:16189:16192", -- [11]
			"43124:37915:37888:12636:16189", -- [12]
			"43124:37915:46004:46011:47875:44233", -- [13]
			"43124:37915:37888:44232:28621", -- [14]
			"43124:37915:37888:44232:44231:44230", -- [15]
			"43124:37915:37888:44232", -- [16]
			"43124:37915:37888:12636:24851", -- [17]
			"43124:37915:37888:12636:24851:26560", -- [18]
			"43124:37915:37888", -- [19]
			"43124:37915", -- [20]
			"2226:2389:2851:2861:1387:43053", -- [21]
			"2226:2389:2851:2861:1387:43052", -- [22]
			"2226:2389:2851:2861:13177:43086", -- [23]
			"2226:2389:43104", -- [24]
			"2226:2389:2851:2861:13177:43086:6026:43121:43114", -- [25]
			"2226:2389:2851:2861:13177:43086:6026:43121", -- [26]
			"43124:37915:46004:43573", -- [27]
			"43124:37915:37888:12636:16189:44036", -- [28]
			"43124:37915:37888:44232:44231", -- [29]
			"43124:37915:37888:12636:16189:16192:44244", -- [30]
			"2226:2389:2851:2861:44408", -- [31]
			"2226:2389:2851:2861:44407", -- [32]
			"2226:45479", -- [33]
			"43124:37915:46004", -- [34]
			"43124:37915:46004:46011", -- [35]
			"2226:46552", -- [36]
			"2226:46552:47655:47644", -- [37]
			"2226:46552:47655", -- [38]
			"2226:46552:47655:47644:47661", -- [39]
			"43124:37915:47665", -- [40]
			"43124:37915:46004:46011:47875", -- [41]
			"2226:2389:2851:2861:3305:47927", -- [42]
			"2226:2389:2851:2861:13177:48321:48318", -- [43]
			"2226:2389:2851:2861:13177:48321", -- [44]
			["m"] = 21,
			["coord"] = 2486703733,
			["direct"] = "2226:4551:43124:50463",
			["f"] = 0,
		},
		[47927] = {
			"3305:2861:2851:2389:2226", -- [1]
			"3305:2861:4551", -- [2]
			"3305:2861:2851:2389", -- [3]
			"3305:2861:2851", -- [4]
			"3305:13177:1387:2858", -- [5]
			"3305:13177:1387", -- [6]
			"3305:2861", -- [7]
			"3305:13177:43086:6026", -- [8]
			"3305:2861:44407:12636", -- [9]
			"3305:13177", -- [10]
			"3305:2861:2851:4314", -- [11]
			"3305:2861:44407:12636:16189:16192", -- [12]
			"3305:2861:44407:12636:16189", -- [13]
			"3305:2861:2851:43573:37888:44232:44233", -- [14]
			"3305:2861:44407:12636:44230:28621", -- [15]
			"3305:2861:44407:12636:44230", -- [16]
			"3305:2861:2851:43573:37888:44232", -- [17]
			"3305:2861:44407:12636:24851", -- [18]
			"3305:2861:44407:12636:24851:26560", -- [19]
			"3305:2861:2851:43573:37888", -- [20]
			"3305:2861:2851:43573:46004:37915", -- [21]
			"3305:2861:2851:43573:46004:37915:43124", -- [22]
			"3305:13177:1387:43053", -- [23]
			"3305:13177:1387:43052", -- [24]
			"3305:13177:43086", -- [25]
			"3305:2861:2851:43104", -- [26]
			"3305:13177:43086:6026:43121:43114", -- [27]
			"3305:13177:43086:6026:43121", -- [28]
			"3305:2861:2851:43573", -- [29]
			"3305:2861:44407:12636:16189:44036", -- [30]
			"3305:2861:44407:12636:44231", -- [31]
			"3305:2861:44407:12636:16189:16192:44244", -- [32]
			"3305:2861:44408", -- [33]
			"3305:2861:44407", -- [34]
			"3305:2861:2851:43573:46004:37915:43124:44825", -- [35]
			"3305:2861:2851:43104:47661:47644:47655:46552:45479", -- [36]
			"3305:2861:2851:43573:46004", -- [37]
			"3305:2861:2851:43573:46004:46011", -- [38]
			"3305:2861:2851:43104:47661:47644:47655:46552", -- [39]
			"3305:2861:2851:43104:47661:47644", -- [40]
			"3305:2861:2851:43104:47661:47644:47655", -- [41]
			"3305:2861:2851:43104:47661", -- [42]
			"3305:2861:2851:2389:47665", -- [43]
			"3305:2861:2851:43573:46004:46011:47875", -- [44]
			"48318:48321", -- [45]
			"3305:2861:2851:2389:2226:50463", -- [46]
			["direct"] = "3305:48318",
			["coord"] = 1758834705,
			["m"] = 28,
			["f"] = 0,
		},
		[44407] = {
			"2861:2851:2389:2226", -- [1]
			"2861:4551", -- [2]
			"2861:2851:2389", -- [3]
			"2861:2851", -- [4]
			"2861:2858", -- [5]
			"2861:1387", -- [6]
			"2861:13177:43086:6026", -- [7]
			"2861:13177", -- [8]
			"2861:3305", -- [9]
			"2861:2851:4314", -- [10]
			"12636:16189:16192", -- [11]
			"12636:16189", -- [12]
			"12636:44230:44233", -- [13]
			"12636:44230:28621", -- [14]
			"12636:44230", -- [15]
			"12636:44231:44232", -- [16]
			"12636:24851", -- [17]
			"12636:24851:26560", -- [18]
			"2861:2851:43573:37888", -- [19]
			"2861:2851:43573:46004:37915", -- [20]
			"2861:2851:43573:46004:37915:43124", -- [21]
			"2861:1387:43053", -- [22]
			"2861:1387:43052", -- [23]
			"2861:13177:43086", -- [24]
			"2861:2851:43104", -- [25]
			"2861:13177:43086:6026:43121:43114", -- [26]
			"2861:13177:43086:6026:43121", -- [27]
			"2861:2851:43573", -- [28]
			"12636:16189:44036", -- [29]
			"12636:44231", -- [30]
			"12636:16189:16192:44244", -- [31]
			"2861:2851:43573:46004:37915:43124:44825", -- [32]
			"2861:2851:43104:47661:47644:47655:46552:45479", -- [33]
			"2861:2851:43573:46004", -- [34]
			"2861:2851:43573:46004:46011", -- [35]
			"2861:2851:43104:47661:47644:47655:46552", -- [36]
			"2861:2851:43104:47661:47644", -- [37]
			"2861:2851:43104:47661:47644:47655", -- [38]
			"2861:2851:43104:47661", -- [39]
			"2861:2851:2389:47665", -- [40]
			"2861:2851:43573:46004:46011:47875", -- [41]
			"2861:3305:47927", -- [42]
			"2861:13177:48321:48318", -- [43]
			"2861:13177:48321", -- [44]
			"2861:2851:2389:2226:50463", -- [45]
			["direct"] = "2861:12636:44408",
			["coord"] = 2759547441,
			["m"] = 17,
			["f"] = 0,
		},
		[16192] = {
			"16189:12636:37888:2389:2226", -- [1]
			"16189:12636:37888:4551", -- [2]
			"16189:12636:37888:2389", -- [3]
			"16189:12636:4314:2851", -- [4]
			"16189:12636:44407:2861:2858", -- [5]
			"16189:12636:44407:2861:1387", -- [6]
			"16189:12636:44407:2861", -- [7]
			"16189:12636:44407:2861:13177:43086:6026", -- [8]
			"16189:12636", -- [9]
			"16189:12636:44407:2861:13177", -- [10]
			"16189:12636:44407:2861:3305", -- [11]
			"16189:12636:4314", -- [12]
			"16189:12636:44230:44233", -- [13]
			"16189:12636:44230:28621", -- [14]
			"16189:12636:44230", -- [15]
			"16189:12636:44231:44232", -- [16]
			"16189:24851", -- [17]
			"16189:12636:37888", -- [18]
			"16189:12636:37888:37915", -- [19]
			"16189:12636:37888:37915:43124", -- [20]
			"16189:12636:44407:2861:1387:43053", -- [21]
			"16189:12636:44407:2861:1387:43052", -- [22]
			"16189:12636:44407:2861:13177:43086", -- [23]
			"16189:12636:37888:2389:43104", -- [24]
			"16189:12636:44407:2861:13177:43086:6026:43121:43114", -- [25]
			"16189:12636:44407:2861:13177:43086:6026:43121", -- [26]
			"16189:12636:37888:43573", -- [27]
			"16189:12636:44231", -- [28]
			"16189:12636:44407:44408", -- [29]
			"16189:12636:44407", -- [30]
			"16189:12636:37888:37915:43124:44825", -- [31]
			"16189:12636:37888:2389:47644:47655:46552:45479", -- [32]
			"16189:12636:37888:46011:46004", -- [33]
			"16189:12636:37888:46011", -- [34]
			"16189:12636:37888:2389:47644:47655:46552", -- [35]
			"16189:12636:37888:2389:47644", -- [36]
			"16189:12636:37888:2389:47644:47655", -- [37]
			"16189:12636:37888:2389:47661", -- [38]
			"16189:12636:37888:37915:47665", -- [39]
			"16189:12636:44230:44233:47875", -- [40]
			"16189:12636:44407:2861:3305:47927", -- [41]
			"16189:12636:44407:2861:13177:48321:48318", -- [42]
			"16189:12636:44407:2861:13177:48321", -- [43]
			"16189:12636:37888:37915:43124:44825:50463", -- [44]
			["direct"] = "16189:26560:44036:44244",
			["coord"] = 2335736302,
			["m"] = 462,
			["f"] = 0,
		},
		[2861] = {
			"2851:2389:2226", -- [1]
			"2851:2389", -- [2]
			"44407:12636", -- [3]
			"2851:4314", -- [4]
			"44407:12636:16189:16192", -- [5]
			"44407:12636:16189", -- [6]
			"2851:43573:37888:44232:44233", -- [7]
			"44407:12636:44230:28621", -- [8]
			"44407:12636:44230", -- [9]
			"2851:43573:37888:44232", -- [10]
			"44407:12636:24851", -- [11]
			"44407:12636:24851:26560", -- [12]
			"2851:43573:37888", -- [13]
			"2851:43573:46004:37915", -- [14]
			"2851:43573:46004:37915:43124", -- [15]
			"1387:43053", -- [16]
			"1387:43052", -- [17]
			"13177:43086", -- [18]
			"2851:43104", -- [19]
			"13177:43086:6026:43121:43114", -- [20]
			"13177:43086:6026:43121", -- [21]
			"2851:43573", -- [22]
			"44407:12636:16189:44036", -- [23]
			"44407:12636:44231", -- [24]
			"44407:12636:16189:16192:44244", -- [25]
			"2851:43573:46004:37915:43124:44825", -- [26]
			"2851:43104:47661:47644:47655:46552:45479", -- [27]
			"2851:43573:46004", -- [28]
			"2851:43573:46004:46011", -- [29]
			"2851:43104:47661:47644:47655:46552", -- [30]
			"2851:43104:47661:47644", -- [31]
			"2851:43104:47661:47644:47655", -- [32]
			"2851:43104:47661", -- [33]
			"2851:2389:47665", -- [34]
			"2851:43573:46004:46011:47875", -- [35]
			"3305:47927", -- [36]
			"13177:48321:48318", -- [37]
			"13177:48321", -- [38]
			"2851:2389:2226:50463", -- [39]
			["direct"] = "4551:2851:2858:1387:6026:13177:3305:44408:44407",
			["coord"] = 740189903,
			["m"] = 17,
			["f"] = 0,
		},
		[1387] = {
			"2861:2851:2389:2226", -- [1]
			"2861:4551", -- [2]
			"2861:2851:2389", -- [3]
			"2861:2851", -- [4]
			"2861:44407:12636", -- [5]
			"13177:3305", -- [6]
			"2861:2851:4314", -- [7]
			"2861:44407:12636:16189:16192", -- [8]
			"2861:44407:12636:16189", -- [9]
			"2861:2851:43573:37888:44232:44233", -- [10]
			"2861:44407:12636:44230:28621", -- [11]
			"2861:44407:12636:44230", -- [12]
			"2861:2851:43573:37888:44232", -- [13]
			"2861:44407:12636:24851", -- [14]
			"2861:44407:12636:24851:26560", -- [15]
			"2861:2851:43573:37888", -- [16]
			"2861:2851:43573:46004:37915", -- [17]
			"2861:2851:43573:46004:37915:43124", -- [18]
			"6026:43086", -- [19]
			"2861:2851:43104", -- [20]
			"2858:43114", -- [21]
			"6026:43121", -- [22]
			"2861:2851:43573", -- [23]
			"2861:44407:12636:16189:44036", -- [24]
			"2861:44407:12636:44231", -- [25]
			"2861:44407:12636:16189:16192:44244", -- [26]
			"2861:44408", -- [27]
			"2861:44407", -- [28]
			"2861:2851:43573:46004:37915:43124:44825", -- [29]
			"2861:2851:43104:47661:47644:47655:46552:45479", -- [30]
			"2861:2851:43573:46004", -- [31]
			"2861:2851:43573:46004:46011", -- [32]
			"2861:2851:43104:47661:47644:47655:46552", -- [33]
			"2861:2851:43104:47661:47644", -- [34]
			"2861:2851:43104:47661:47644:47655", -- [35]
			"2861:2851:43104:47661", -- [36]
			"2861:2851:2389:47665", -- [37]
			"2861:2851:43573:46004:46011:47875", -- [38]
			"13177:3305:47927", -- [39]
			"13177:48321:48318", -- [40]
			"13177:48321", -- [41]
			"2861:2851:2389:2226:50463", -- [42]
			["direct"] = "2858:2861:6026:13177:43053:43052",
			["coord"] = 1673429732,
			["m"] = 37,
			["f"] = 0,
		},
		[43086] = {
			"13177:2861:2851:2389:2226", -- [1]
			"13177:2861:4551", -- [2]
			"13177:2861:2851:2389", -- [3]
			"13177:2861:2851", -- [4]
			"6026:2858", -- [5]
			"6026:1387", -- [6]
			"13177:2861", -- [7]
			"13177:2861:44407:12636", -- [8]
			"13177:3305", -- [9]
			"13177:2861:2851:4314", -- [10]
			"13177:2861:44407:12636:16189:16192", -- [11]
			"13177:2861:44407:12636:16189", -- [12]
			"13177:2861:2851:43573:37888:44232:44233", -- [13]
			"13177:2861:44407:12636:44230:28621", -- [14]
			"13177:2861:44407:12636:44230", -- [15]
			"13177:2861:2851:43573:37888:44232", -- [16]
			"13177:2861:44407:12636:24851", -- [17]
			"13177:2861:44407:12636:24851:26560", -- [18]
			"13177:2861:2851:43573:37888", -- [19]
			"13177:2861:2851:43573:46004:37915", -- [20]
			"13177:2861:2851:43573:46004:37915:43124", -- [21]
			"6026:1387:43053", -- [22]
			"6026:1387:43052", -- [23]
			"13177:2861:2851:43104", -- [24]
			"6026:43121:43114", -- [25]
			"6026:43121", -- [26]
			"13177:2861:2851:43573", -- [27]
			"13177:2861:44407:12636:16189:44036", -- [28]
			"13177:2861:44407:12636:44231", -- [29]
			"13177:2861:44407:12636:16189:16192:44244", -- [30]
			"13177:2861:44408", -- [31]
			"13177:2861:44407", -- [32]
			"13177:2861:2851:43573:46004:37915:43124:44825", -- [33]
			"13177:2861:2851:43104:47661:47644:47655:46552:45479", -- [34]
			"13177:2861:2851:43573:46004", -- [35]
			"13177:2861:2851:43573:46004:46011", -- [36]
			"13177:2861:2851:43104:47661:47644:47655:46552", -- [37]
			"13177:2861:2851:43104:47661:47644", -- [38]
			"13177:2861:2851:43104:47661:47644:47655", -- [39]
			"13177:2861:2851:43104:47661", -- [40]
			"13177:2861:2851:2389:47665", -- [41]
			"13177:2861:2851:43573:46004:46011:47875", -- [42]
			"13177:3305:47927", -- [43]
			"13177:48321:48318", -- [44]
			"13177:48321", -- [45]
			"13177:2861:2851:2389:2226:50463", -- [46]
			["direct"] = "6026:13177",
			["coord"] = 3098287836,
			["m"] = 38,
			["f"] = 0,
		},
		[46552] = {
			"2226:4551", -- [1]
			"47655:47644:2389", -- [2]
			"47655:47644:47661:43104:2851", -- [3]
			"47655:47644:47661:43104:2851:2861:2858", -- [4]
			"47655:47644:47661:43104:2851:2861:1387", -- [5]
			"47655:47644:47661:43104:2851:2861", -- [6]
			"47655:47644:47661:43104:2851:2861:13177:43086:6026", -- [7]
			"47655:47644:2389:37888:12636", -- [8]
			"47655:47644:47661:43104:2851:2861:13177", -- [9]
			"47655:47644:47661:43104:2851:2861:3305", -- [10]
			"47655:47644:2389:4314", -- [11]
			"47655:47644:2389:37888:12636:16189:16192", -- [12]
			"47655:47644:2389:37888:12636:16189", -- [13]
			"47655:47644:2389:37888:44232:44233", -- [14]
			"47655:47644:2389:37888:44232:28621", -- [15]
			"47655:47644:2389:37888:44232:44231:44230", -- [16]
			"47655:47644:2389:37888:44232", -- [17]
			"47655:47644:2389:37888:12636:24851", -- [18]
			"47655:47644:2389:37888:12636:24851:26560", -- [19]
			"47655:47644:2389:37888", -- [20]
			"47655:47644:2389:37915", -- [21]
			"2226:44825:43124", -- [22]
			"47655:47644:47661:43104:2851:2861:1387:43053", -- [23]
			"47655:47644:47661:43104:2851:2861:1387:43052", -- [24]
			"47655:47644:47661:43104:2851:2861:13177:43086", -- [25]
			"47655:47644:47661:43104", -- [26]
			"47655:47644:47661:43104:2851:2861:13177:43086:6026:43121:43114", -- [27]
			"47655:47644:47661:43104:2851:2861:13177:43086:6026:43121", -- [28]
			"47655:47644:2389:43573", -- [29]
			"47655:47644:2389:37888:12636:16189:44036", -- [30]
			"47655:47644:2389:37888:44232:44231", -- [31]
			"47655:47644:2389:37888:12636:16189:16192:44244", -- [32]
			"47655:47644:47661:43104:2851:2861:44408", -- [33]
			"47655:47644:47661:43104:2851:2861:44407", -- [34]
			"2226:44825", -- [35]
			"47655:47644:2389:37915:46004", -- [36]
			"47655:47644:2389:37915:46004:46011", -- [37]
			"47655:47644", -- [38]
			"47655:47644:47661", -- [39]
			"47655:47644:2389:47665", -- [40]
			"47655:47644:2389:37915:46004:46011:47875", -- [41]
			"47655:47644:47661:43104:2851:2861:3305:47927", -- [42]
			"47655:47644:47661:43104:2851:2861:13177:48321:48318", -- [43]
			"47655:47644:47661:43104:2851:2861:13177:48321", -- [44]
			"2226:50463", -- [45]
			["direct"] = "2226:45479:47655",
			["coord"] = 2185339687,
			["m"] = 21,
			["f"] = 0,
		},
		[48321] = {
			"13177:2861:2851:2389:2226", -- [1]
			"13177:2861:4551", -- [2]
			"13177:2861:2851:2389", -- [3]
			"13177:2861:2851", -- [4]
			"13177:1387:2858", -- [5]
			"13177:1387", -- [6]
			"13177:2861", -- [7]
			"13177:43086:6026", -- [8]
			"13177:2861:44407:12636", -- [9]
			"13177:3305", -- [10]
			"13177:2861:2851:4314", -- [11]
			"13177:2861:44407:12636:16189:16192", -- [12]
			"13177:2861:44407:12636:16189", -- [13]
			"13177:2861:2851:43573:37888:44232:44233", -- [14]
			"13177:2861:44407:12636:44230:28621", -- [15]
			"13177:2861:44407:12636:44230", -- [16]
			"13177:2861:2851:43573:37888:44232", -- [17]
			"13177:2861:44407:12636:24851", -- [18]
			"13177:2861:44407:12636:24851:26560", -- [19]
			"13177:2861:2851:43573:37888", -- [20]
			"13177:2861:2851:43573:46004:37915", -- [21]
			"13177:2861:2851:43573:46004:37915:43124", -- [22]
			"13177:1387:43053", -- [23]
			"13177:1387:43052", -- [24]
			"13177:43086", -- [25]
			"13177:2861:2851:43104", -- [26]
			"13177:43086:6026:43121:43114", -- [27]
			"13177:43086:6026:43121", -- [28]
			"13177:2861:2851:43573", -- [29]
			"13177:2861:44407:12636:16189:44036", -- [30]
			"13177:2861:44407:12636:44231", -- [31]
			"13177:2861:44407:12636:16189:16192:44244", -- [32]
			"13177:2861:44408", -- [33]
			"13177:2861:44407", -- [34]
			"13177:2861:2851:43573:46004:37915:43124:44825", -- [35]
			"13177:2861:2851:43104:47661:47644:47655:46552:45479", -- [36]
			"13177:2861:2851:43573:46004", -- [37]
			"13177:2861:2851:43573:46004:46011", -- [38]
			"13177:2861:2851:43104:47661:47644:47655:46552", -- [39]
			"13177:2861:2851:43104:47661:47644", -- [40]
			"13177:2861:2851:43104:47661:47644:47655", -- [41]
			"13177:2861:2851:43104:47661", -- [42]
			"13177:2861:2851:2389:47665", -- [43]
			"13177:2861:2851:43573:46004:46011:47875", -- [44]
			"48318:47927", -- [45]
			"13177:2861:2851:2389:2226:50463", -- [46]
			["direct"] = "13177:48318",
			["coord"] = 1982491478,
			["m"] = 29,
			["f"] = 0,
		},
		[50463] = {
			"44825:4551", -- [1]
			"2226:2389", -- [2]
			"2226:2389:2851", -- [3]
			"2226:2389:2851:2861:2858", -- [4]
			"2226:2389:2851:2861:1387", -- [5]
			"2226:2389:2851:2861", -- [6]
			"2226:2389:2851:2861:13177:43086:6026", -- [7]
			"44825:43124:37915:37888:12636", -- [8]
			"2226:2389:2851:2861:13177", -- [9]
			"2226:2389:2851:2861:3305", -- [10]
			"2226:2389:4314", -- [11]
			"44825:43124:37915:37888:12636:16189:16192", -- [12]
			"44825:43124:37915:37888:12636:16189", -- [13]
			"44825:43124:37915:46004:46011:47875:44233", -- [14]
			"44825:43124:37915:37888:44232:28621", -- [15]
			"44825:43124:37915:37888:44232:44231:44230", -- [16]
			"44825:43124:37915:37888:44232", -- [17]
			"44825:43124:37915:37888:12636:24851", -- [18]
			"44825:43124:37915:37888:12636:24851:26560", -- [19]
			"44825:43124:37915:37888", -- [20]
			"44825:43124:37915", -- [21]
			"44825:43124", -- [22]
			"2226:2389:2851:2861:1387:43053", -- [23]
			"2226:2389:2851:2861:1387:43052", -- [24]
			"2226:2389:2851:2861:13177:43086", -- [25]
			"2226:2389:43104", -- [26]
			"2226:2389:2851:2861:13177:43086:6026:43121:43114", -- [27]
			"2226:2389:2851:2861:13177:43086:6026:43121", -- [28]
			"2226:2389:43573", -- [29]
			"44825:43124:37915:37888:12636:16189:44036", -- [30]
			"44825:43124:37915:37888:44232:44231", -- [31]
			"44825:43124:37915:37888:12636:16189:16192:44244", -- [32]
			"2226:2389:2851:2861:44408", -- [33]
			"2226:2389:2851:2861:44407", -- [34]
			"2226:45479", -- [35]
			"44825:43124:37915:46004", -- [36]
			"44825:43124:37915:46004:46011", -- [37]
			"2226:46552", -- [38]
			"2226:46552:47655:47644", -- [39]
			"2226:46552:47655", -- [40]
			"2226:46552:47655:47644:47661", -- [41]
			"2226:2389:47665", -- [42]
			"44825:43124:37915:46004:46011:47875", -- [43]
			"2226:2389:2851:2861:3305:47927", -- [44]
			"2226:2389:2851:2861:13177:48321:48318", -- [45]
			"2226:2389:2851:2861:13177:48321", -- [46]
			["direct"] = "2226:44825",
			["coord"] = 1974745043,
			["m"] = 21,
			["f"] = 0,
		},
		[12636] = {
			"37888:2389:2226", -- [1]
			"37888:2389", -- [2]
			"4314:2851", -- [3]
			"44407:2861:2858", -- [4]
			"44407:2861:1387", -- [5]
			"44407:2861", -- [6]
			"44407:2861:13177:43086:6026", -- [7]
			"44407:2861:13177", -- [8]
			"44407:2861:3305", -- [9]
			"16189:16192", -- [10]
			"44230:44233", -- [11]
			"44230:28621", -- [12]
			"44231:44232", -- [13]
			"24851:26560", -- [14]
			"37888:37915", -- [15]
			"37888:37915:43124", -- [16]
			"44407:2861:1387:43053", -- [17]
			"44407:2861:1387:43052", -- [18]
			"44407:2861:13177:43086", -- [19]
			"37888:2389:43104", -- [20]
			"44407:2861:13177:43086:6026:43121:43114", -- [21]
			"44407:2861:13177:43086:6026:43121", -- [22]
			"37888:43573", -- [23]
			"16189:44036", -- [24]
			"16189:16192:44244", -- [25]
			"44407:44408", -- [26]
			"37888:37915:43124:44825", -- [27]
			"37888:2389:47644:47655:46552:45479", -- [28]
			"37888:46011:46004", -- [29]
			"37888:46011", -- [30]
			"37888:2389:47644:47655:46552", -- [31]
			"37888:2389:47644", -- [32]
			"37888:2389:47644:47655", -- [33]
			"37888:2389:47661", -- [34]
			"37888:37915:47665", -- [35]
			"44230:44233:47875", -- [36]
			"44407:2861:3305:47927", -- [37]
			"44407:2861:13177:48321:48318", -- [38]
			"44407:2861:13177:48321", -- [39]
			"37888:37915:43124:44825:50463", -- [40]
			["m"] = 23,
			["f"] = 0,
			["direct"] = "4551:4314:16189:44230:24851:37888:44231:44407",
			["coord"] = 3253569603,
		},
		[44230] = {
			"44231:44232:37888:2389:2226", -- [1]
			"44231:44232:37888:4551", -- [2]
			"44231:44232:37888:2389", -- [3]
			"44231:44232:37888:43573:2851", -- [4]
			"12636:44407:2861:2858", -- [5]
			"12636:44407:2861:1387", -- [6]
			"12636:44407:2861", -- [7]
			"12636:44407:2861:13177:43086:6026", -- [8]
			"12636:44407:2861:13177", -- [9]
			"12636:44407:2861:3305", -- [10]
			"12636:4314", -- [11]
			"12636:16189:16192", -- [12]
			"12636:16189", -- [13]
			"44231:44232", -- [14]
			"12636:24851", -- [15]
			"12636:24851:26560", -- [16]
			"44231:44232:37888", -- [17]
			"44231:44232:37888:37915", -- [18]
			"44231:44232:37888:37915:43124", -- [19]
			"12636:44407:2861:1387:43053", -- [20]
			"12636:44407:2861:1387:43052", -- [21]
			"12636:44407:2861:13177:43086", -- [22]
			"44231:44232:37888:2389:43104", -- [23]
			"12636:44407:2861:13177:43086:6026:43121:43114", -- [24]
			"12636:44407:2861:13177:43086:6026:43121", -- [25]
			"44231:44232:37888:43573", -- [26]
			"12636:16189:44036", -- [27]
			"12636:16189:16192:44244", -- [28]
			"12636:44407:44408", -- [29]
			"12636:44407", -- [30]
			"44231:44232:37888:37915:43124:44825", -- [31]
			"44231:44232:37888:2389:47644:47655:46552:45479", -- [32]
			"44231:44232:37888:46011:46004", -- [33]
			"44231:44232:37888:46011", -- [34]
			"44231:44232:37888:2389:47644:47655:46552", -- [35]
			"44231:44232:37888:2389:47644", -- [36]
			"44231:44232:37888:2389:47644:47655", -- [37]
			"44231:44232:37888:2389:47661", -- [38]
			"44231:44232:37888:37915:47665", -- [39]
			"44233:47875", -- [40]
			"12636:44407:2861:3305:47927", -- [41]
			"12636:44407:2861:13177:48321:48318", -- [42]
			"12636:44407:2861:13177:48321", -- [43]
			"44231:44232:37888:37915:43124:44825:50463", -- [44]
			["direct"] = "12636:44233:28621:44231",
			["coord"] = 2644406368,
			["m"] = 23,
			["f"] = 0,
		},
		[44232] = {
			"37888:2389:2226", -- [1]
			"37888:4551", -- [2]
			"37888:2389", -- [3]
			"37888:43573:2851", -- [4]
			"37888:43573:2851:2861:2858", -- [5]
			"37888:43573:2851:2861:1387", -- [6]
			"37888:43573:2851:2861", -- [7]
			"37888:43573:2851:2861:13177:43086:6026", -- [8]
			"44231:12636", -- [9]
			"37888:43573:2851:2861:13177", -- [10]
			"37888:43573:2851:2861:3305", -- [11]
			"37888:43573:4314", -- [12]
			"44231:12636:16189:16192", -- [13]
			"44231:12636:16189", -- [14]
			"44231:44230", -- [15]
			"44231:12636:24851", -- [16]
			"44231:12636:24851:26560", -- [17]
			"37888:37915", -- [18]
			"37888:37915:43124", -- [19]
			"37888:43573:2851:2861:1387:43053", -- [20]
			"37888:43573:2851:2861:1387:43052", -- [21]
			"37888:43573:2851:2861:13177:43086", -- [22]
			"37888:2389:43104", -- [23]
			"37888:43573:2851:2861:13177:43086:6026:43121:43114", -- [24]
			"37888:43573:2851:2861:13177:43086:6026:43121", -- [25]
			"37888:43573", -- [26]
			"44231:12636:16189:44036", -- [27]
			"44231:12636:16189:16192:44244", -- [28]
			"44231:12636:44407:44408", -- [29]
			"44231:12636:44407", -- [30]
			"37888:37915:43124:44825", -- [31]
			"37888:2389:47644:47655:46552:45479", -- [32]
			"37888:46011:46004", -- [33]
			"37888:46011", -- [34]
			"37888:2389:47644:47655:46552", -- [35]
			"37888:2389:47644", -- [36]
			"37888:2389:47644:47655", -- [37]
			"37888:2389:47661", -- [38]
			"37888:37915:47665", -- [39]
			"44233:47875", -- [40]
			"37888:43573:2851:2861:3305:47927", -- [41]
			"37888:43573:2851:2861:13177:48321:48318", -- [42]
			"37888:43573:2851:2861:13177:48321", -- [43]
			"37888:37915:43124:44825:50463", -- [44]
			["direct"] = "44233:28621:37888:44231",
			["coord"] = 1497804314,
			["m"] = 23,
			["f"] = 0,
		},
		[4314] = {
			"2389:2226", -- [1]
			"2851:2861:2858", -- [2]
			"2851:2861:1387", -- [3]
			"2851:2861", -- [4]
			"2851:2861:13177:43086:6026", -- [5]
			"2851:2861:13177", -- [6]
			"2851:2861:3305", -- [7]
			"12636:16189:16192", -- [8]
			"12636:16189", -- [9]
			"12636:44230:44233", -- [10]
			"12636:44230:28621", -- [11]
			"12636:44230", -- [12]
			"12636:44231:44232", -- [13]
			"12636:24851", -- [14]
			"12636:24851:26560", -- [15]
			"43573:37888", -- [16]
			"43573:46004:37915", -- [17]
			"43573:46004:37915:43124", -- [18]
			"2851:2861:1387:43053", -- [19]
			"2851:2861:1387:43052", -- [20]
			"2851:2861:13177:43086", -- [21]
			"2851:43104", -- [22]
			"2851:2861:13177:43086:6026:43121:43114", -- [23]
			"2851:2861:13177:43086:6026:43121", -- [24]
			"12636:16189:44036", -- [25]
			"12636:44231", -- [26]
			"12636:16189:16192:44244", -- [27]
			"2851:2861:44408", -- [28]
			"2851:2861:44407", -- [29]
			"43573:46004:37915:43124:44825", -- [30]
			"2389:47644:47655:46552:45479", -- [31]
			"43573:46004", -- [32]
			"43573:46004:46011", -- [33]
			"2389:47644:47655:46552", -- [34]
			"2389:47644", -- [35]
			"2389:47644:47655", -- [36]
			"2389:47661", -- [37]
			"2389:47665", -- [38]
			"43573:46004:46011:47875", -- [39]
			"2851:2861:3305:47927", -- [40]
			"2851:2861:13177:48321:48318", -- [41]
			"2851:2861:13177:48321", -- [42]
			"43573:46004:37915:43124:44825:50463", -- [43]
			["direct"] = "4551:2389:2851:12636:43573",
			["coord"] = 3509047717,
			["m"] = 26,
			["f"] = 0,
		},
		[2226] = {
			"2389:2851", -- [1]
			"2389:2851:2861:2858", -- [2]
			"2389:2851:2861:1387", -- [3]
			"2389:2851:2861", -- [4]
			"2389:2851:2861:13177:43086:6026", -- [5]
			"2389:37888:12636", -- [6]
			"2389:2851:2861:13177", -- [7]
			"2389:2851:2861:3305", -- [8]
			"2389:4314", -- [9]
			"2389:37888:12636:16189:16192", -- [10]
			"2389:37888:12636:16189", -- [11]
			"2389:37888:44232:44233", -- [12]
			"2389:37888:44232:28621", -- [13]
			"2389:37888:44232:44231:44230", -- [14]
			"2389:37888:44232", -- [15]
			"2389:37888:12636:24851", -- [16]
			"2389:37888:12636:24851:26560", -- [17]
			"2389:37888", -- [18]
			"44825:43124:37915", -- [19]
			"44825:43124", -- [20]
			"2389:2851:2861:1387:43053", -- [21]
			"2389:2851:2861:1387:43052", -- [22]
			"2389:2851:2861:13177:43086", -- [23]
			"2389:43104", -- [24]
			"2389:2851:2861:13177:43086:6026:43121:43114", -- [25]
			"2389:2851:2861:13177:43086:6026:43121", -- [26]
			"2389:43573", -- [27]
			"2389:37888:12636:16189:44036", -- [28]
			"2389:37888:44232:44231", -- [29]
			"2389:37888:12636:16189:16192:44244", -- [30]
			"2389:2851:2861:44408", -- [31]
			"2389:2851:2861:44407", -- [32]
			"44825:43124:37915:46004", -- [33]
			"44825:43124:37915:46004:46011", -- [34]
			"46552:47655:47644", -- [35]
			"46552:47655", -- [36]
			"46552:47655:47644:47661", -- [37]
			"2389:47665", -- [38]
			"44825:43124:37915:46004:46011:47875", -- [39]
			"2389:2851:2861:3305:47927", -- [40]
			"2389:2851:2861:13177:48321:48318", -- [41]
			"2389:2851:2861:13177:48321", -- [42]
			["direct"] = "4551:2389:44825:45479:46552:50463",
			["coord"] = 1955163325,
			["m"] = 21,
			["f"] = 0,
		},
		[43104] = {
			"2389:2226", -- [1]
			"2851:2861:2858", -- [2]
			"2851:2861:1387", -- [3]
			"2851:2861", -- [4]
			"2851:2861:13177:43086:6026", -- [5]
			"2389:37888:12636", -- [6]
			"2851:2861:13177", -- [7]
			"2851:2861:3305", -- [8]
			"2851:4314", -- [9]
			"2389:37888:12636:16189:16192", -- [10]
			"2389:37888:12636:16189", -- [11]
			"2389:37888:44232:44233", -- [12]
			"2389:37888:44232:28621", -- [13]
			"2389:37888:44232:44231:44230", -- [14]
			"2389:37888:44232", -- [15]
			"2389:37888:12636:24851", -- [16]
			"2389:37888:12636:24851:26560", -- [17]
			"2389:37888", -- [18]
			"2389:37915", -- [19]
			"2389:37915:43124", -- [20]
			"2851:2861:1387:43053", -- [21]
			"2851:2861:1387:43052", -- [22]
			"2851:2861:13177:43086", -- [23]
			"2851:2861:13177:43086:6026:43121:43114", -- [24]
			"2851:2861:13177:43086:6026:43121", -- [25]
			"2851:43573", -- [26]
			"2389:37888:12636:16189:44036", -- [27]
			"2389:37888:44232:44231", -- [28]
			"2389:37888:12636:16189:16192:44244", -- [29]
			"2851:2861:44408", -- [30]
			"2851:2861:44407", -- [31]
			"2389:2226:44825", -- [32]
			"47661:47644:47655:46552:45479", -- [33]
			"2389:37915:46004", -- [34]
			"2389:37915:46004:46011", -- [35]
			"47661:47644:47655:46552", -- [36]
			"47661:47644", -- [37]
			"47661:47644:47655", -- [38]
			"2389:47665", -- [39]
			"2389:37915:46004:46011:47875", -- [40]
			"2851:2861:3305:47927", -- [41]
			"2851:2861:13177:48321:48318", -- [42]
			"2851:2861:13177:48321", -- [43]
			"2389:2226:50463", -- [44]
			["direct"] = "4551:2389:2851:47661",
			["coord"] = 566516097,
			["m"] = 16,
			["f"] = 0,
		},
		[46004] = {
			"37915:43124:44825:2226", -- [1]
			"37915:4551", -- [2]
			"37915:2389", -- [3]
			"43573:2851", -- [4]
			"43573:2851:2861:2858", -- [5]
			"43573:2851:2861:1387", -- [6]
			"43573:2851:2861", -- [7]
			"43573:2851:2861:13177:43086:6026", -- [8]
			"46011:37888:12636", -- [9]
			"43573:2851:2861:13177", -- [10]
			"43573:2851:2861:3305", -- [11]
			"43573:4314", -- [12]
			"46011:37888:12636:16189:16192", -- [13]
			"46011:37888:12636:16189", -- [14]
			"46011:47875:44233", -- [15]
			"46011:37888:44232:28621", -- [16]
			"46011:37888:44232:44231:44230", -- [17]
			"46011:37888:44232", -- [18]
			"46011:37888:12636:24851", -- [19]
			"46011:37888:12636:24851:26560", -- [20]
			"46011:37888", -- [21]
			"37915:43124", -- [22]
			"43573:2851:2861:1387:43053", -- [23]
			"43573:2851:2861:1387:43052", -- [24]
			"43573:2851:2861:13177:43086", -- [25]
			"37915:2389:43104", -- [26]
			"43573:2851:2861:13177:43086:6026:43121:43114", -- [27]
			"43573:2851:2861:13177:43086:6026:43121", -- [28]
			"46011:37888:12636:16189:44036", -- [29]
			"46011:37888:44232:44231", -- [30]
			"46011:37888:12636:16189:16192:44244", -- [31]
			"43573:2851:2861:44408", -- [32]
			"43573:2851:2861:44407", -- [33]
			"37915:43124:44825", -- [34]
			"37915:43124:44825:2226:45479", -- [35]
			"37915:43124:44825:2226:46552", -- [36]
			"37915:2389:47644", -- [37]
			"37915:2389:47644:47655", -- [38]
			"37915:2389:47661", -- [39]
			"37915:47665", -- [40]
			"46011:47875", -- [41]
			"43573:2851:2861:3305:47927", -- [42]
			"43573:2851:2861:13177:48321:48318", -- [43]
			"43573:2851:2861:13177:48321", -- [44]
			"37915:43124:44825:50463", -- [45]
			["direct"] = "37915:43573:46011",
			["coord"] = 2001249700,
			["m"] = 22,
			["f"] = 0,
		},
		[47644] = {
			"47655:46552:2226", -- [1]
			"2389:4551", -- [2]
			"47661:43104:2851", -- [3]
			"47661:43104:2851:2861:2858", -- [4]
			"47661:43104:2851:2861:1387", -- [5]
			"47661:43104:2851:2861", -- [6]
			"47661:43104:2851:2861:13177:43086:6026", -- [7]
			"2389:37888:12636", -- [8]
			"47661:43104:2851:2861:13177", -- [9]
			"47661:43104:2851:2861:3305", -- [10]
			"2389:4314", -- [11]
			"2389:37888:12636:16189:16192", -- [12]
			"2389:37888:12636:16189", -- [13]
			"2389:37888:44232:44233", -- [14]
			"2389:37888:44232:28621", -- [15]
			"2389:37888:44232:44231:44230", -- [16]
			"2389:37888:44232", -- [17]
			"2389:37888:12636:24851", -- [18]
			"2389:37888:12636:24851:26560", -- [19]
			"2389:37888", -- [20]
			"2389:37915", -- [21]
			"2389:37915:43124", -- [22]
			"47661:43104:2851:2861:1387:43053", -- [23]
			"47661:43104:2851:2861:1387:43052", -- [24]
			"47661:43104:2851:2861:13177:43086", -- [25]
			"47661:43104", -- [26]
			"47661:43104:2851:2861:13177:43086:6026:43121:43114", -- [27]
			"47661:43104:2851:2861:13177:43086:6026:43121", -- [28]
			"2389:43573", -- [29]
			"2389:37888:12636:16189:44036", -- [30]
			"2389:37888:44232:44231", -- [31]
			"2389:37888:12636:16189:16192:44244", -- [32]
			"47661:43104:2851:2861:44408", -- [33]
			"47661:43104:2851:2861:44407", -- [34]
			"47655:46552:2226:44825", -- [35]
			"47655:46552:45479", -- [36]
			"2389:37915:46004", -- [37]
			"2389:37915:46004:46011", -- [38]
			"47655:46552", -- [39]
			"2389:47665", -- [40]
			"2389:37915:46004:46011:47875", -- [41]
			"47661:43104:2851:2861:3305:47927", -- [42]
			"47661:43104:2851:2861:13177:48321:48318", -- [43]
			"47661:43104:2851:2861:13177:48321", -- [44]
			"47655:46552:2226:50463", -- [45]
			["direct"] = "2389:47655:47661",
			["coord"] = 2107943230,
			["m"] = 24,
			["f"] = 0,
		},
		[44244] = {
			"16192:16189:12636:37888:2389:2226", -- [1]
			"16192:16189:12636:37888:4551", -- [2]
			"16192:16189:12636:37888:2389", -- [3]
			"16192:16189:12636:4314:2851", -- [4]
			"16192:16189:12636:44407:2861:2858", -- [5]
			"16192:16189:12636:44407:2861:1387", -- [6]
			"16192:16189:12636:44407:2861", -- [7]
			"16192:16189:12636:44407:2861:13177:43086:6026", -- [8]
			"16192:16189:12636", -- [9]
			"16192:16189:12636:44407:2861:13177", -- [10]
			"16192:16189:12636:44407:2861:3305", -- [11]
			"16192:16189:12636:4314", -- [12]
			"16192:16189", -- [13]
			"16192:16189:12636:44230:44233", -- [14]
			"16192:16189:12636:44230:28621", -- [15]
			"16192:16189:12636:44230", -- [16]
			"16192:16189:12636:44231:44232", -- [17]
			"16192:16189:24851", -- [18]
			"16192:26560", -- [19]
			"16192:16189:12636:37888", -- [20]
			"16192:16189:12636:37888:37915", -- [21]
			"16192:16189:12636:37888:37915:43124", -- [22]
			"16192:16189:12636:44407:2861:1387:43053", -- [23]
			"16192:16189:12636:44407:2861:1387:43052", -- [24]
			"16192:16189:12636:44407:2861:13177:43086", -- [25]
			"16192:16189:12636:37888:2389:43104", -- [26]
			"16192:16189:12636:44407:2861:13177:43086:6026:43121:43114", -- [27]
			"16192:16189:12636:44407:2861:13177:43086:6026:43121", -- [28]
			"16192:16189:12636:37888:43573", -- [29]
			"16192:44036", -- [30]
			"16192:16189:12636:44231", -- [31]
			"16192:16189:12636:44407:44408", -- [32]
			"16192:16189:12636:44407", -- [33]
			"16192:16189:12636:37888:37915:43124:44825", -- [34]
			"16192:16189:12636:37888:2389:47644:47655:46552:45479", -- [35]
			"16192:16189:12636:37888:46011:46004", -- [36]
			"16192:16189:12636:37888:46011", -- [37]
			"16192:16189:12636:37888:2389:47644:47655:46552", -- [38]
			"16192:16189:12636:37888:2389:47644", -- [39]
			"16192:16189:12636:37888:2389:47644:47655", -- [40]
			"16192:16189:12636:37888:2389:47661", -- [41]
			"16192:16189:12636:37888:37915:47665", -- [42]
			"16192:16189:12636:44230:44233:47875", -- [43]
			"16192:16189:12636:44407:2861:3305:47927", -- [44]
			"16192:16189:12636:44407:2861:13177:48321:48318", -- [45]
			"16192:16189:12636:44407:2861:13177:48321", -- [46]
			"16192:16189:12636:37888:37915:43124:44825:50463", -- [47]
			["direct"] = "16192",
			["coord"] = 1987999757,
			["m"] = 462,
			["f"] = 0,
		},
		[6026] = {
			"2861:2851:2389:2226", -- [1]
			"2861:4551", -- [2]
			"2861:2851:2389", -- [3]
			"2861:2851", -- [4]
			"2861:44407:12636", -- [5]
			"43086:13177:3305", -- [6]
			"2861:2851:4314", -- [7]
			"2861:44407:12636:16189:16192", -- [8]
			"2861:44407:12636:16189", -- [9]
			"2861:2851:43573:37888:44232:44233", -- [10]
			"2861:44407:12636:44230:28621", -- [11]
			"2861:44407:12636:44230", -- [12]
			"2861:2851:43573:37888:44232", -- [13]
			"2861:44407:12636:24851", -- [14]
			"2861:44407:12636:24851:26560", -- [15]
			"2861:2851:43573:37888", -- [16]
			"2861:2851:43573:46004:37915", -- [17]
			"2861:2851:43573:46004:37915:43124", -- [18]
			"1387:43053", -- [19]
			"1387:43052", -- [20]
			"2861:2851:43104", -- [21]
			"43121:43114", -- [22]
			"2861:2851:43573", -- [23]
			"2861:44407:12636:16189:44036", -- [24]
			"2861:44407:12636:44231", -- [25]
			"2861:44407:12636:16189:16192:44244", -- [26]
			"2861:44408", -- [27]
			"2861:44407", -- [28]
			"2861:2851:43573:46004:37915:43124:44825", -- [29]
			"2861:2851:43104:47661:47644:47655:46552:45479", -- [30]
			"2861:2851:43573:46004", -- [31]
			"2861:2851:43573:46004:46011", -- [32]
			"2861:2851:43104:47661:47644:47655:46552", -- [33]
			"2861:2851:43104:47661:47644", -- [34]
			"2861:2851:43104:47661:47644:47655", -- [35]
			"2861:2851:43104:47661", -- [36]
			"2861:2851:2389:47665", -- [37]
			"2861:2851:43573:46004:46011:47875", -- [38]
			"43086:13177:3305:47927", -- [39]
			"43086:13177:48321:48318", -- [40]
			"43086:13177:48321", -- [41]
			"2861:2851:2389:2226:50463", -- [42]
			["direct"] = "2858:1387:2861:13177:43086:43121",
			["coord"] = 2051312902,
			["m"] = 38,
			["f"] = 0,
		},
		[47156] = {
			"47133:47121:2851:2389:2226", -- [1]
			"47133:47121:2851:43573:46004:37915:4551", -- [2]
			"47133:47121:2851:2389", -- [3]
			"47133:47121:2851", -- [4]
			"47133:47121:2861:2858", -- [5]
			"47133:47121:2861:1387", -- [6]
			"47133:47121:2861", -- [7]
			"47133:47121:2861:13177:43086:6026", -- [8]
			"47133:47121:2851:4314:12636", -- [9]
			"47133:47121:2861:13177", -- [10]
			"47133:47121:2861:3305", -- [11]
			"47133:47121:2851:4314", -- [12]
			"47133:47121:2851:4314:12636:16189:16192", -- [13]
			"47133:47121:2851:4314:12636:16189", -- [14]
			"47133:47121:2851:43573:37888:44232:44233", -- [15]
			"47133:47121:2851:43573:37888:44232:28621", -- [16]
			"47133:47121:2851:43573:37888:44232:44231:44230", -- [17]
			"47133:47121:2851:43573:37888:44232", -- [18]
			"47133:47121:2851:4314:12636:24851", -- [19]
			"47133:47121:2851:4314:12636:24851:26560", -- [20]
			"47133:47121:2851:43573:37888", -- [21]
			"47133:47121:2851:43573:46004:37915", -- [22]
			"47133:47121:2851:43573:46004:37915:43124", -- [23]
			"47133:47121:2861:1387:43053", -- [24]
			"47133:47121:2861:1387:43052", -- [25]
			"47133:47121:2861:13177:43086", -- [26]
			"47133:47121:2851:43104", -- [27]
			"47133:47121:2861:13177:43086:6026:43121:43114", -- [28]
			"47133:47121:2861:13177:43086:6026:43121", -- [29]
			"47133:47121:2851:43573", -- [30]
			"47133:47121:2851:4314:12636:16189:44036", -- [31]
			"47133:47121:2851:43573:37888:44232:44231", -- [32]
			"47133:47121:2851:4314:12636:16189:16192:44244", -- [33]
			"47133:47121:2861:44408", -- [34]
			"47133:47121:2861:44407", -- [35]
			"47133:47121:2851:43573:46004:37915:43124:44825", -- [36]
			"47133:47121:2851:43104:47661:47644:47655:46552:45479", -- [37]
			"47133:47121:2851:43573:46004", -- [38]
			"47133:47121:2851:43573:46004:46011", -- [39]
			"47133:47121:2851:43104:47661:47644:47655:46552", -- [40]
			"47133:47121", -- [41]
			"47133:47121:2851:43104:47661:47644", -- [42]
			"47133:47121:2851:43104:47661:47644:47655", -- [43]
			"47133:47121:2851:43104:47661", -- [44]
			"47133:47121:2851:2389:47665", -- [45]
			"47133:47121:2851:43573:46004:46011:47875", -- [46]
			"47133:47121:2861:3305:47927", -- [47]
			"47133:47121:2861:13177:48321:48318", -- [48]
			"47133:47121:2861:13177:48321", -- [49]
			"47133:47121:2851:2389:2226:50463", -- [50]
			["direct"] = "47116:47133:47061:47174",
			["f"] = 0,
			["m"] = 700,
			["coord"] = 2322885605,
		},
		[47121] = {
			"2851:2389:2226", -- [1]
			"2851:43573:46004:37915:4551", -- [2]
			"2851:2389", -- [3]
			"2861:2858", -- [4]
			"2861:1387", -- [5]
			"2861:13177:43086:6026", -- [6]
			"2851:4314:12636", -- [7]
			"2861:13177", -- [8]
			"2861:3305", -- [9]
			"2851:4314", -- [10]
			"2851:4314:12636:16189:16192", -- [11]
			"2851:4314:12636:16189", -- [12]
			"2851:43573:37888:44232:44233", -- [13]
			"2851:43573:37888:44232:28621", -- [14]
			"2851:43573:37888:44232:44231:44230", -- [15]
			"2851:43573:37888:44232", -- [16]
			"2851:4314:12636:24851", -- [17]
			"2851:4314:12636:24851:26560", -- [18]
			"2851:43573:37888", -- [19]
			"2851:43573:46004:37915", -- [20]
			"2851:43573:46004:37915:43124", -- [21]
			"2861:1387:43053", -- [22]
			"2861:1387:43052", -- [23]
			"2861:13177:43086", -- [24]
			"2851:43104", -- [25]
			"2861:13177:43086:6026:43121:43114", -- [26]
			"2861:13177:43086:6026:43121", -- [27]
			"2851:43573", -- [28]
			"2851:4314:12636:16189:44036", -- [29]
			"2851:43573:37888:44232:44231", -- [30]
			"2851:4314:12636:16189:16192:44244", -- [31]
			"2861:44408", -- [32]
			"2861:44407", -- [33]
			"2851:43573:46004:37915:43124:44825", -- [34]
			"2851:43104:47661:47644:47655:46552:45479", -- [35]
			"2851:43573:46004", -- [36]
			"2851:43573:46004:46011", -- [37]
			"2851:43104:47661:47644:47655:46552", -- [38]
			"47133:47116", -- [39]
			"47133:47156", -- [40]
			"47133:47156:47061", -- [41]
			"47133:47156:47174", -- [42]
			"2851:43104:47661:47644", -- [43]
			"2851:43104:47661:47644:47655", -- [44]
			"2851:43104:47661", -- [45]
			"2851:2389:47665", -- [46]
			"2851:43573:46004:46011:47875", -- [47]
			"2861:3305:47927", -- [48]
			"2861:13177:48321:48318", -- [49]
			"2861:13177:48321", -- [50]
			"2851:2389:2226:50463", -- [51]
			["direct"] = "2851:2861:47133",
			["f"] = 0,
			["m"] = 700,
			["coord"] = 1225080792,
		},
		[47174] = {
			"2851:2389:2226", -- [1]
			"2851:43573:46004:37915:4551", -- [2]
			"2851:2389", -- [3]
			"2861:2858", -- [4]
			"2861:1387", -- [5]
			"2861:13177:43086:6026", -- [6]
			"2851:4314:12636", -- [7]
			"2861:13177", -- [8]
			"2861:3305", -- [9]
			"2851:4314", -- [10]
			"2851:4314:12636:16189:16192", -- [11]
			"2851:4314:12636:16189", -- [12]
			"2851:43573:37888:44232:44233", -- [13]
			"2851:43573:37888:44232:28621", -- [14]
			"2851:43573:37888:44232:44231:44230", -- [15]
			"2851:43573:37888:44232", -- [16]
			"2851:4314:12636:24851", -- [17]
			"2851:4314:12636:24851:26560", -- [18]
			"2851:43573:37888", -- [19]
			"2851:43573:46004:37915", -- [20]
			"2851:43573:46004:37915:43124", -- [21]
			"2861:1387:43053", -- [22]
			"2861:1387:43052", -- [23]
			"2861:13177:43086", -- [24]
			"2851:43104", -- [25]
			"2861:13177:43086:6026:43121:43114", -- [26]
			"2861:13177:43086:6026:43121", -- [27]
			"2851:43573", -- [28]
			"2851:4314:12636:16189:44036", -- [29]
			"2851:43573:37888:44232:44231", -- [30]
			"2851:4314:12636:16189:16192:44244", -- [31]
			"2861:44408", -- [32]
			"2861:44407", -- [33]
			"2851:43573:46004:37915:43124:44825", -- [34]
			"2851:43104:47661:47644:47655:46552:45479", -- [35]
			"2851:43573:46004", -- [36]
			"2851:43573:46004:46011", -- [37]
			"2851:43104:47661:47644:47655:46552", -- [38]
			"47156:47133", -- [39]
			"47156:47133:47121", -- [40]
			"2851:43104:47661:47644", -- [41]
			"2851:43104:47661:47644:47655", -- [42]
			"2851:43104:47661", -- [43]
			"2851:2389:47665", -- [44]
			"2851:43573:46004:46011:47875", -- [45]
			"2861:3305:47927", -- [46]
			"2861:13177:48321:48318", -- [47]
			"2861:13177:48321", -- [48]
			"2851:2389:2226:50463", -- [49]
			["direct"] = "2851:2861:47116:47156:47061",
			["f"] = 0,
			["m"] = 700,
			["coord"] = 3171714868,
		},
		[47133] = {
			"47121:2851:2389:2226", -- [1]
			"47121:2851:43573:46004:37915:4551", -- [2]
			"47121:2851:2389", -- [3]
			"47121:2851", -- [4]
			"47121:2861:2858", -- [5]
			"47121:2861:1387", -- [6]
			"47121:2861", -- [7]
			"47121:2861:13177:43086:6026", -- [8]
			"47121:2851:4314:12636", -- [9]
			"47121:2861:13177", -- [10]
			"47121:2861:3305", -- [11]
			"47121:2851:4314", -- [12]
			"47121:2851:4314:12636:16189:16192", -- [13]
			"47121:2851:4314:12636:16189", -- [14]
			"47121:2851:43573:37888:44232:44233", -- [15]
			"47121:2851:43573:37888:44232:28621", -- [16]
			"47121:2851:43573:37888:44232:44231:44230", -- [17]
			"47121:2851:43573:37888:44232", -- [18]
			"47121:2851:4314:12636:24851", -- [19]
			"47121:2851:4314:12636:24851:26560", -- [20]
			"47121:2851:43573:37888", -- [21]
			"47121:2851:43573:46004:37915", -- [22]
			"47121:2851:43573:46004:37915:43124", -- [23]
			"47121:2861:1387:43053", -- [24]
			"47121:2861:1387:43052", -- [25]
			"47121:2861:13177:43086", -- [26]
			"47121:2851:43104", -- [27]
			"47121:2861:13177:43086:6026:43121:43114", -- [28]
			"47121:2861:13177:43086:6026:43121", -- [29]
			"47121:2851:43573", -- [30]
			"47121:2851:4314:12636:16189:44036", -- [31]
			"47121:2851:43573:37888:44232:44231", -- [32]
			"47121:2851:4314:12636:16189:16192:44244", -- [33]
			"47121:2861:44408", -- [34]
			"47121:2861:44407", -- [35]
			"47121:2851:43573:46004:37915:43124:44825", -- [36]
			"47121:2851:43104:47661:47644:47655:46552:45479", -- [37]
			"47121:2851:43573:46004", -- [38]
			"47121:2851:43573:46004:46011", -- [39]
			"47121:2851:43104:47661:47644:47655:46552", -- [40]
			"47156:47061", -- [41]
			"47156:47174", -- [42]
			"47121:2851:43104:47661:47644", -- [43]
			"47121:2851:43104:47661:47644:47655", -- [44]
			"47121:2851:43104:47661", -- [45]
			"47121:2851:2389:47665", -- [46]
			"47121:2851:43573:46004:46011:47875", -- [47]
			"47121:2861:3305:47927", -- [48]
			"47121:2861:13177:48321:48318", -- [49]
			"47121:2861:13177:48321", -- [50]
			"47121:2851:2389:2226:50463", -- [51]
			["direct"] = "47116:47121:47156",
			["f"] = 0,
			["m"] = 700,
			["coord"] = 1582457212,
		},
		[47061] = {
			"47174:2851:2389:2226", -- [1]
			"47174:2851:43573:46004:37915:4551", -- [2]
			"47174:2851:2389", -- [3]
			"47174:2851", -- [4]
			"47174:2861:2858", -- [5]
			"47174:2861:1387", -- [6]
			"47174:2861", -- [7]
			"47174:2861:13177:43086:6026", -- [8]
			"47174:2851:4314:12636", -- [9]
			"47174:2861:13177", -- [10]
			"47174:2861:3305", -- [11]
			"47174:2851:4314", -- [12]
			"47174:2851:4314:12636:16189:16192", -- [13]
			"47174:2851:4314:12636:16189", -- [14]
			"47174:2851:43573:37888:44232:44233", -- [15]
			"47174:2851:43573:37888:44232:28621", -- [16]
			"47174:2851:43573:37888:44232:44231:44230", -- [17]
			"47174:2851:43573:37888:44232", -- [18]
			"47174:2851:4314:12636:24851", -- [19]
			"47174:2851:4314:12636:24851:26560", -- [20]
			"47174:2851:43573:37888", -- [21]
			"47174:2851:43573:46004:37915", -- [22]
			"47174:2851:43573:46004:37915:43124", -- [23]
			"47174:2861:1387:43053", -- [24]
			"47174:2861:1387:43052", -- [25]
			"47174:2861:13177:43086", -- [26]
			"47174:2851:43104", -- [27]
			"47174:2861:13177:43086:6026:43121:43114", -- [28]
			"47174:2861:13177:43086:6026:43121", -- [29]
			"47174:2851:43573", -- [30]
			"47174:2851:4314:12636:16189:44036", -- [31]
			"47174:2851:43573:37888:44232:44231", -- [32]
			"47174:2851:4314:12636:16189:16192:44244", -- [33]
			"47174:2861:44408", -- [34]
			"47174:2861:44407", -- [35]
			"47174:2851:43573:46004:37915:43124:44825", -- [36]
			"47174:2851:43104:47661:47644:47655:46552:45479", -- [37]
			"47174:2851:43573:46004", -- [38]
			"47174:2851:43573:46004:46011", -- [39]
			"47174:2851:43104:47661:47644:47655:46552", -- [40]
			"47156:47116", -- [41]
			"47156:47133", -- [42]
			"47156:47133:47121", -- [43]
			"47174:2851:43104:47661:47644", -- [44]
			"47174:2851:43104:47661:47644:47655", -- [45]
			"47174:2851:43104:47661", -- [46]
			"47174:2851:2389:47665", -- [47]
			"47174:2851:43573:46004:46011:47875", -- [48]
			"47174:2861:3305:47927", -- [49]
			"47174:2861:13177:48321:48318", -- [50]
			"47174:2861:13177:48321", -- [51]
			"47174:2851:2389:2226:50463", -- [52]
			["direct"] = "47156:47174",
			["f"] = 0,
			["m"] = 700,
			["coord"] = 3236375922,
		},
		[47116] = {
			"47133:47121:2851:2389:2226", -- [1]
			"47133:47121:2851:43573:46004:37915:4551", -- [2]
			"47133:47121:2851:2389", -- [3]
			"47133:47121:2851", -- [4]
			"47133:47121:2861:2858", -- [5]
			"47133:47121:2861:1387", -- [6]
			"47133:47121:2861", -- [7]
			"47133:47121:2861:13177:43086:6026", -- [8]
			"47133:47121:2851:4314:12636", -- [9]
			"47133:47121:2861:13177", -- [10]
			"47133:47121:2861:3305", -- [11]
			"47133:47121:2851:4314", -- [12]
			"47133:47121:2851:4314:12636:16189:16192", -- [13]
			"47133:47121:2851:4314:12636:16189", -- [14]
			"47133:47121:2851:43573:37888:44232:44233", -- [15]
			"47133:47121:2851:43573:37888:44232:28621", -- [16]
			"47133:47121:2851:43573:37888:44232:44231:44230", -- [17]
			"47133:47121:2851:43573:37888:44232", -- [18]
			"47133:47121:2851:4314:12636:24851", -- [19]
			"47133:47121:2851:4314:12636:24851:26560", -- [20]
			"47133:47121:2851:43573:37888", -- [21]
			"47133:47121:2851:43573:46004:37915", -- [22]
			"47133:47121:2851:43573:46004:37915:43124", -- [23]
			"47133:47121:2861:1387:43053", -- [24]
			"47133:47121:2861:1387:43052", -- [25]
			"47133:47121:2861:13177:43086", -- [26]
			"47133:47121:2851:43104", -- [27]
			"47133:47121:2861:13177:43086:6026:43121:43114", -- [28]
			"47133:47121:2861:13177:43086:6026:43121", -- [29]
			"47133:47121:2851:43573", -- [30]
			"47133:47121:2851:4314:12636:16189:44036", -- [31]
			"47133:47121:2851:43573:37888:44232:44231", -- [32]
			"47133:47121:2851:4314:12636:16189:16192:44244", -- [33]
			"47133:47121:2861:44408", -- [34]
			"47133:47121:2861:44407", -- [35]
			"47133:47121:2851:43573:46004:37915:43124:44825", -- [36]
			"47133:47121:2851:43104:47661:47644:47655:46552:45479", -- [37]
			"47133:47121:2851:43573:46004", -- [38]
			"47133:47121:2851:43573:46004:46011", -- [39]
			"47133:47121:2851:43104:47661:47644:47655:46552", -- [40]
			"47133:47121", -- [41]
			"47156:47061", -- [42]
			"47133:47121:2851:43104:47661:47644", -- [43]
			"47133:47121:2851:43104:47661:47644:47655", -- [44]
			"47133:47121:2851:43104:47661", -- [45]
			"47133:47121:2851:2389:47665", -- [46]
			"47133:47121:2851:43573:46004:46011:47875", -- [47]
			"47133:47121:2861:3305:47927", -- [48]
			"47133:47121:2861:13177:48321:48318", -- [49]
			"47133:47121:2861:13177:48321", -- [50]
			"47133:47121:2851:2389:2226:50463", -- [51]
			["direct"] = "47133:47156:47174",
			["f"] = 0,
			["m"] = 700,
			["coord"] = 1965015777,
		},
	}, -- [2]
	{
		[22455] = {
			"20762:18942:16587", -- [1]
			"20762:18942", -- [2]
			"20762:18791", -- [3]
			"20762:18940:18808", -- [4]
			"20762:18940:18807:19317", -- [5]
			"20762:18940:18807", -- [6]
			"20762:18940", -- [7]
			"20762:18942:16587:18930", -- [8]
			"18938:19583", -- [9]
			"20762:18940:18807:19317:19581", -- [10]
			"20762:18942:16587:19558", -- [11]
			"18938:20515", -- [12]
			"18953:22216", -- [13]
			["direct"] = "18938:18953:20762",
			["f"] = 0,
			["m"] = 475,
			["coord"] = 3279595658,
		},
		[18953] = {
			"20762:18942:16587", -- [1]
			"20762:18942", -- [2]
			"18791:18808", -- [3]
			"20762:18940:18807:19317", -- [4]
			"20762:18940:18807", -- [5]
			"20762:18940", -- [6]
			"20762:18942:16587:18930", -- [7]
			"20762:18940:18807:19317:19581", -- [8]
			"20762:18942:16587:19558", -- [9]
			"18938:20515", -- [10]
			["direct"] = "18791:18938:19583:20762:22216:22455",
			["coord"] = 2236451551,
			["m"] = 475,
			["f"] = 0,
		},
		[19558] = {
			"16587:18942", -- [1]
			"16587:18942:18791", -- [2]
			"16587:18942:18808", -- [3]
			"16587:18942:20762:22455:18938", -- [4]
			"16587:18807:19317", -- [5]
			"16587:18942:20762:18953", -- [6]
			"16587:18807", -- [7]
			"16587:18940", -- [8]
			"16587:18930", -- [9]
			"16587:18942:20762:22455:18938:19583", -- [10]
			"16587:18807:19317:19581", -- [11]
			"16587:18942:20762:22455:18938:20515", -- [12]
			"16587:18942:20762", -- [13]
			"16587:18942:20762:18953:22216", -- [14]
			"16587:18942:20762:22455", -- [15]
			["direct"] = "16587",
			["f"] = 0,
			["m"] = 465,
			["coord"] = 2645348352,
		},
		[18940] = {
			"20762:22455:18938", -- [1]
			"18807:19317", -- [2]
			"20762:18953", -- [3]
			"16587:18930", -- [4]
			"20762:22455:18938:19583", -- [5]
			"18807:19317:19581", -- [6]
			"16587:19558", -- [7]
			"20762:22455:18938:20515", -- [8]
			"20762:18953:22216", -- [9]
			"20762:22455", -- [10]
			["direct"] = "16587:18942:18791:18808:18807:20762",
			["f"] = 0,
			["m"] = 481,
			["coord"] = 2745330149,
		},
		[18942] = {
			"20762:22455:18938", -- [1]
			"18940:18807:19317", -- [2]
			"20762:18953", -- [3]
			"18940:18807", -- [4]
			"16587:18930", -- [5]
			"20762:22455:18938:19583", -- [6]
			"18940:18807:19317:19581", -- [7]
			"16587:19558", -- [8]
			"20762:22455:18938:20515", -- [9]
			"20762:18953:22216", -- [10]
			"20762:22455", -- [11]
			["direct"] = "16587:18791:18808:18940:20762",
			["f"] = 0,
			["m"] = 465,
			["coord"] = 1196333511,
		},
		[16587] = {
			"18942:18791", -- [1]
			"18942:18808", -- [2]
			"18942:20762:22455:18938", -- [3]
			"18807:19317", -- [4]
			"18942:20762:18953", -- [5]
			"18942:20762:22455:18938:19583", -- [6]
			"18807:19317:19581", -- [7]
			"18942:20762:22455:18938:20515", -- [8]
			"18942:20762", -- [9]
			"18942:20762:18953:22216", -- [10]
			"18942:20762:22455", -- [11]
			["direct"] = "18942:18807:18940:18930:19558",
			["f"] = 0,
			["m"] = 465,
			["coord"] = 2416663840,
		},
		[19317] = {
			"18807:16587", -- [1]
			"18807:18940:18942", -- [2]
			"18807:18940:18791", -- [3]
			"18807:18940:18808", -- [4]
			"18807:18940:20762:22455:18938", -- [5]
			"18807:18940:20762:18953", -- [6]
			"18807:18940", -- [7]
			"18807:16587:18930", -- [8]
			"18807:18940:20762:22455:18938:19583", -- [9]
			"18807:16587:19558", -- [10]
			"18807:18940:20762:22455:18938:20515", -- [11]
			"18807:18940:20762", -- [12]
			"18807:18940:20762:18953:22216", -- [13]
			"18807:18940:20762:22455", -- [14]
			["direct"] = "18807:19581",
			["f"] = 0,
			["m"] = 473,
			["coord"] = 1302481601,
		},
		[19581] = {
			"19317:18807:16587", -- [1]
			"19317:18807:18940:18942", -- [2]
			"19317:18807:18940:18791", -- [3]
			"19317:18807:18940:18808", -- [4]
			"19317:18807:18940:20762:22455:18938", -- [5]
			"19317:18807:18940:20762:18953", -- [6]
			"19317:18807", -- [7]
			"19317:18807:18940", -- [8]
			"19317:18807:16587:18930", -- [9]
			"19317:18807:18940:20762:22455:18938:19583", -- [10]
			"19317:18807:16587:19558", -- [11]
			"19317:18807:18940:20762:22455:18938:20515", -- [12]
			"19317:18807:18940:20762", -- [13]
			"19317:18807:18940:20762:18953:22216", -- [14]
			"19317:18807:18940:20762:22455", -- [15]
			["direct"] = "19317",
			["f"] = 0,
			["m"] = 473,
			["coord"] = 2717011449,
		},
		[18791] = {
			"18942:16587", -- [1]
			"18953:18938", -- [2]
			"18940:18807:19317", -- [3]
			"18940:18807", -- [4]
			"18942:16587:18930", -- [5]
			"18953:18938:19583", -- [6]
			"18940:18807:19317:19581", -- [7]
			"18942:16587:19558", -- [8]
			"18953:18938:20515", -- [9]
			"18953:22216", -- [10]
			"18953:22455", -- [11]
			["direct"] = "18942:18808:18953:18940:20762",
			["f"] = 0,
			["m"] = 467,
			["coord"] = 1417380620,
		},
		[18807] = {
			"18940:18942", -- [1]
			"18940:18791", -- [2]
			"18940:18808", -- [3]
			"18940:20762:22455:18938", -- [4]
			"18940:20762:18953", -- [5]
			"16587:18930", -- [6]
			"18940:20762:22455:18938:19583", -- [7]
			"19317:19581", -- [8]
			"16587:19558", -- [9]
			"18940:20762:22455:18938:20515", -- [10]
			"18940:20762", -- [11]
			"18940:20762:18953:22216", -- [12]
			"18940:20762:22455", -- [13]
			["direct"] = "16587:19317:18940",
			["f"] = 0,
			["m"] = 478,
			["coord"] = 2115268468,
		},
		[18938] = {
			"22455:20762:18942:16587", -- [1]
			"22455:20762:18942", -- [2]
			"22455:20762:18791", -- [3]
			"22455:20762:18940:18808", -- [4]
			"22455:20762:18940:18807:19317", -- [5]
			"22455:20762:18940:18807", -- [6]
			"22455:20762:18940", -- [7]
			"22455:20762:18942:16587:18930", -- [8]
			"22455:20762:18940:18807:19317:19581", -- [9]
			"22455:20762:18942:16587:19558", -- [10]
			"22455:20762", -- [11]
			["direct"] = "18953:19583:20515:22216:22455",
			["f"] = 0,
			["m"] = 479,
			["coord"] = 1451533221,
		},
		[18808] = {
			"18942:16587", -- [1]
			"18791:18953:18938", -- [2]
			"18940:18807:19317", -- [3]
			"18791:18953", -- [4]
			"18940:18807", -- [5]
			"18942:16587:18930", -- [6]
			"18791:18953:18938:19583", -- [7]
			"18940:18807:19317:19581", -- [8]
			"18942:16587:19558", -- [9]
			"18791:18953:18938:20515", -- [10]
			"18940:20762", -- [11]
			"18791:18953:22216", -- [12]
			"18940:20762:22455", -- [13]
			["direct"] = "18942:18791:18940",
			["f"] = 0,
			["m"] = 477,
			["coord"] = 2458409611,
		},
		[18930] = {
			"18942:18791", -- [1]
			"18942:18808", -- [2]
			"18942:20762:22455:18938", -- [3]
			"16587:18807:19317", -- [4]
			"18942:20762:18953", -- [5]
			"16587:18807", -- [6]
			"16587:18940", -- [7]
			"18942:20762:22455:18938:19583", -- [8]
			"16587:18807:19317:19581", -- [9]
			"16587:19558", -- [10]
			"18942:20762:22455:18938:20515", -- [11]
			"18942:20762", -- [12]
			"18942:20762:18953:22216", -- [13]
			"18942:20762:22455", -- [14]
			["direct"] = "16587:18942",
			["f"] = 0,
			["m"] = 465,
			["coord"] = 3752950617,
		},
		[20762] = {
			"18942:16587", -- [1]
			"18940:18808", -- [2]
			"22455:18938", -- [3]
			"18940:18807:19317", -- [4]
			"18940:18807", -- [5]
			"18942:16587:18930", -- [6]
			"22455:18938:19583", -- [7]
			"18940:18807:19317:19581", -- [8]
			"18942:16587:19558", -- [9]
			"22455:18938:20515", -- [10]
			"18953:22216", -- [11]
			["direct"] = "18942:18791:18953:18940:22455",
			["f"] = 0,
			["m"] = 467,
			["coord"] = 3639643342,
		},
		[19583] = {
			"18938:22455:20762:18942:16587", -- [1]
			"18938:22455:20762:18942", -- [2]
			"18953:18791", -- [3]
			"18938:22455:20762:18940:18808", -- [4]
			"18938:22455:20762:18940:18807:19317", -- [5]
			"18938:22455:20762:18940:18807", -- [6]
			"18938:22455:20762:18940", -- [7]
			"18938:22455:20762:18942:16587:18930", -- [8]
			"18938:22455:20762:18940:18807:19317:19581", -- [9]
			"18938:22455:20762:18942:16587:19558", -- [10]
			"18938:22455:20762", -- [11]
			"18938:22216", -- [12]
			"18938:22455", -- [13]
			["direct"] = "18938:18953:20515",
			["f"] = 0,
			["m"] = 479,
			["coord"] = 1944213875,
		},
		[20515] = {
			"18938:22455:20762:18942:16587", -- [1]
			"18938:22455:20762:18942", -- [2]
			"18938:22455:20762:18791", -- [3]
			"18938:22455:20762:18940:18808", -- [4]
			"18938:22455:20762:18940:18807:19317", -- [5]
			"18938:18953", -- [6]
			"18938:22455:20762:18940:18807", -- [7]
			"18938:22455:20762:18940", -- [8]
			"18938:22455:20762:18942:16587:18930", -- [9]
			"18938:22455:20762:18940:18807:19317:19581", -- [10]
			"18938:22455:20762:18942:16587:19558", -- [11]
			"18938:22455:20762", -- [12]
			"18938:22216", -- [13]
			"18938:22455", -- [14]
			["direct"] = "18938:19583",
			["f"] = 0,
			["m"] = 479,
			["coord"] = 2800462568,
		},
		[22216] = {
			"18953:20762:18942:16587", -- [1]
			"18953:20762:18942", -- [2]
			"18953:18791", -- [3]
			"18953:18791:18808", -- [4]
			"18953:20762:18940:18807:19317", -- [5]
			"18953:20762:18940:18807", -- [6]
			"18953:20762:18940", -- [7]
			"18953:20762:18942:16587:18930", -- [8]
			"18938:19583", -- [9]
			"18953:20762:18940:18807:19317:19581", -- [10]
			"18953:20762:18942:16587:19558", -- [11]
			"18938:20515", -- [12]
			"18953:20762", -- [13]
			"18953:22455", -- [14]
			["direct"] = "18938:18953",
			["coord"] = 2648008034,
			["m"] = 475,
			["f"] = 0,
		},
	}, -- [3]
	{
		[26852] = {
			"26844:24155", -- [1]
			"24032:27344", -- [2]
			"26845:26851:26566:26847:24795:27046", -- [3]
			"26845:26851", -- [4]
			"26845:26851:26566", -- [5]
			"26845:28196:28195:25288", -- [6]
			"26845:26851:26566:26847", -- [7]
			"26845:26851:26566:26847:26848", -- [8]
			"26845:26851:26850", -- [9]
			"26845:26851:26566:26847:24795", -- [10]
			"26845:28196", -- [11]
			"26844:28197", -- [12]
			"26845:28196:28195", -- [13]
			"28618:28623", -- [14]
			"28618:28615", -- [15]
			"28618:28623:28624", -- [16]
			"28618:28615:28674:28574", -- [17]
			"28618:28615:28674", -- [18]
			"28618:28615:29721", -- [19]
			"28618:28623:28624:32571", -- [20]
			"28618:28615:29721:29757", -- [21]
			"28618:28615:29721:29762", -- [22]
			"28618:28615:28674:31069:31078", -- [23]
			"28618:28615:29721:29757:29951", -- [24]
			"28618:28615:29721:29757:29950", -- [25]
			"28618:28623:28624:30569", -- [26]
			"26845:26851:26566:30870", -- [27]
			"28618:28615:28674:31069:30314", -- [28]
			"28618:28615:28674:30433", -- [29]
			"28618:28615:28674:31069", -- [30]
			"28618:28615:30269", -- [31]
			"28618:28615:28674:33849", -- [32]
			"28618:28615:28674:28574:28037", -- [33]
			["m"] = 490,
			["coord"] = 942974243,
			["direct"] = "24032:26844:26853:26845:28618",
			["f"] = 0,
		},
		[26853] = {
			"24032:24155", -- [1]
			"28618:28615:26850:26566:26847:24795:27046", -- [2]
			"24032:26844", -- [3]
			"28618:28615:26851", -- [4]
			"26852:26845", -- [5]
			"28618:28615:26850:26566", -- [6]
			"28618:28615:28674:25288", -- [7]
			"28618:28615:26850:26566:26847", -- [8]
			"28618:28615:28674:28574:26848", -- [9]
			"28618:28615:26850", -- [10]
			"28618:28615:26850:26566:26847:24795", -- [11]
			"26852:26845:28196", -- [12]
			"24032:26844:28197", -- [13]
			"26852:26845:28196:28195", -- [14]
			"28618:28615", -- [15]
			"28618:28615:28674:28574", -- [16]
			"28618:28615:28674", -- [17]
			"28618:28615:29721", -- [18]
			"28624:32571", -- [19]
			"28618:28615:29721:29757", -- [20]
			"28624:29762", -- [21]
			"28618:28615:28674:31069:31078", -- [22]
			"28624:29951", -- [23]
			"28618:28615:29721:29757:29950", -- [24]
			"28624:30569", -- [25]
			"28618:28615:28674:30870", -- [26]
			"28618:28615:28674:31069:30314", -- [27]
			"28618:28615:28674:30433", -- [28]
			"28618:28615:28674:31069", -- [29]
			"28618:28615:30269", -- [30]
			"28618:28615:28674:33849", -- [31]
			"28618:28615:28674:28574:28037", -- [32]
			["m"] = 490,
			["coord"] = 2789373946,
			["direct"] = "27344:24032:26852:28623:28618:28624",
			["f"] = 0,
		},
		[28618] = {
			"26852:26844:24155", -- [1]
			"26853:27344", -- [2]
			"26853:24032", -- [3]
			"28615:26850:26566:26847:24795:27046", -- [4]
			"26852:26844", -- [5]
			"28615:26851", -- [6]
			"28615:26850:26566", -- [7]
			"28615:28674:25288", -- [8]
			"28615:26850:26566:26847", -- [9]
			"28615:28674:28574:26848", -- [10]
			"28615:26850", -- [11]
			"28615:26850:26566:26847:24795", -- [12]
			"28615:26851:28196", -- [13]
			"26852:26844:28197", -- [14]
			"28615:26851:28196:28195", -- [15]
			"28623:28624", -- [16]
			"28615:28674:28574", -- [17]
			"28615:28674", -- [18]
			"28615:29721", -- [19]
			"28623:28624:32571", -- [20]
			"28615:29721:29757", -- [21]
			"28615:29721:29762", -- [22]
			"28615:28674:31069:31078", -- [23]
			"28615:29721:29757:29951", -- [24]
			"28615:29721:29757:29950", -- [25]
			"28623:28624:30569", -- [26]
			"28615:28674:30870", -- [27]
			"28615:28674:31069:30314", -- [28]
			"28615:28674:30433", -- [29]
			"28615:28674:31069", -- [30]
			"28615:30269", -- [31]
			"28615:28674:33849", -- [32]
			"28615:28674:28574:28037", -- [33]
			["m"] = 496,
			["f"] = 0,
			["direct"] = "26853:26852:26845:28623:28615",
			["coord"] = 1381678745,
		},
		[31078] = {
			"30870:26566:26845:24155", -- [1]
			"30870:26566:26845:26852:24032:27344", -- [2]
			"30870:26566:26845:26852:24032", -- [3]
			"28574:26848:24795:27046", -- [4]
			"30870:26566:26845:26844", -- [5]
			"30870:26566:26845:26852:26853", -- [6]
			"30870:26566:26845:26852", -- [7]
			"30870:26566:26851", -- [8]
			"30870:26566:26845", -- [9]
			"30870:26566", -- [10]
			"28574:26848:25288", -- [11]
			"30870:26847", -- [12]
			"28574:26848", -- [13]
			"30870:26566:26850", -- [14]
			"28574:26848:24795", -- [15]
			"30870:26566:28196", -- [16]
			"30870:26566:26845:26844:28197", -- [17]
			"30870:26847:28195", -- [18]
			"31069:30433:28674:28615:28623", -- [19]
			"31069:30433:28674:28615", -- [20]
			"31069:30433:28674:28615:28618", -- [21]
			"30314:29950:29951:28624", -- [22]
			"31069:30433:28674", -- [23]
			"31069:30433:28674:29721", -- [24]
			"30314:29950:29951:32571", -- [25]
			"30314:29950:29757", -- [26]
			"30314:29950:29951:29762", -- [27]
			"30314:29950:29951", -- [28]
			"30314:29950", -- [29]
			"30314:29950:29951:28624:30569", -- [30]
			"31069:30433", -- [31]
			"31069:30433:28674:30269", -- [32]
			"30314:33849", -- [33]
			"28037:26848:24795:27046", -- [34]
			"28037:26848:25288", -- [35]
			"28037:26848", -- [36]
			"28037:26848:24795", -- [37]
			["direct"] = "28574:28037:30870:30314:31069",
			["f"] = 0,
			["m"] = 492,
			["coord"] = 831814222,
		},
		[28623] = {
			"26853:24032:24155", -- [1]
			"26853:27344", -- [2]
			"26853:24032", -- [3]
			"28615:26850:26566:26847:24795:27046", -- [4]
			"28618:26852:26844", -- [5]
			"28618:26852", -- [6]
			"28615:26851", -- [7]
			"28618:26845", -- [8]
			"28615:26850:26566", -- [9]
			"28615:28674:25288", -- [10]
			"28615:26850:26566:26847", -- [11]
			"28615:28674:28574:26848", -- [12]
			"28615:26850", -- [13]
			"28615:26850:26566:26847:24795", -- [14]
			"28615:26851:28196", -- [15]
			"28618:26852:26844:28197", -- [16]
			"28615:26851:28196:28195", -- [17]
			"28615:28674:28574", -- [18]
			"28615:28674", -- [19]
			"28615:29721", -- [20]
			"28624:32571", -- [21]
			"28615:29721:29757", -- [22]
			"28624:29762", -- [23]
			"28615:28674:31069:31078", -- [24]
			"28624:29951", -- [25]
			"28615:29721:29757:29950", -- [26]
			"28624:30569", -- [27]
			"28615:28674:30870", -- [28]
			"28615:28674:31069:30314", -- [29]
			"28615:28674:30433", -- [30]
			"28615:28674:31069", -- [31]
			"28615:30269", -- [32]
			"28615:28674:33849", -- [33]
			"28615:28674:28574:28037", -- [34]
			["direct"] = "26853:28615:28618:28624",
			["f"] = 0,
			["m"] = 496,
			["coord"] = 1782293786,
		},
		[28624] = {
			"26853:24032:24155", -- [1]
			"26853:27344", -- [2]
			"26853:24032", -- [3]
			"28623:28615:26850:26566:26847:24795:27046", -- [4]
			"26853:24032:26844", -- [5]
			"28623:28618:26852", -- [6]
			"28623:28615:26851", -- [7]
			"28623:28618:26845", -- [8]
			"28623:28615:26850:26566", -- [9]
			"28623:28615:28674:25288", -- [10]
			"28623:28615:26850:26566:26847", -- [11]
			"28623:28615:28674:28574:26848", -- [12]
			"28623:28615:26850", -- [13]
			"28623:28615:26850:26566:26847:24795", -- [14]
			"28623:28615:26851:28196", -- [15]
			"26853:24032:26844:28197", -- [16]
			"28623:28615:26851:28196:28195", -- [17]
			"28623:28615", -- [18]
			"28623:28618", -- [19]
			"28623:28615:28674:28574", -- [20]
			"28623:28615:28674", -- [21]
			"28623:28615:29721", -- [22]
			"29762:29757", -- [23]
			"28623:28615:28674:31069:31078", -- [24]
			"29951:29950", -- [25]
			"28623:28615:28674:30870", -- [26]
			"29951:29950:30314", -- [27]
			"28623:28615:28674:30433", -- [28]
			"28623:28615:28674:31069", -- [29]
			"28623:28615:30269", -- [30]
			"29951:29950:33849", -- [31]
			"28623:28615:28674:28574:28037", -- [32]
			["m"] = 496,

			["f"] = 0,
			["direct"] = "26853:28623:32571:29762:29951:30569",
			["coord"] = 2575864175,
		},
		[25288] = {
			"26847:26566:26845:24155", -- [1]
			"26847:26566:26845:26852:24032:27344", -- [2]
			"26847:26566:26845:26852:24032", -- [3]
			"24795:27046", -- [4]
			"26847:26566:26845:26844", -- [5]
			"26847:26566:26845:26852:26853", -- [6]
			"26847:26566:26845:26852", -- [7]
			"26847:26566:26851", -- [8]
			"26847:26566:26845", -- [9]
			"26847:26566", -- [10]
			"26847:26566:26850", -- [11]
			"28195:28196", -- [12]
			"28195:28196:28197", -- [13]
			"26847:26566:26851:28615:28623", -- [14]
			"26847:26566:26851:28615", -- [15]
			"26847:26566:26845:28618", -- [16]
			"26847:26566:26851:28615:28623:28624", -- [17]
			"26848:28574", -- [18]
			"28674:29721", -- [19]
			"28674:29721:32571", -- [20]
			"28674:29721:29757", -- [21]
			"28674:29721:29762", -- [22]
			"26848:28574:31078", -- [23]
			"28674:29721:29757:29951", -- [24]
			"26848:28574:31078:30314:29950", -- [25]
			"26847:26566:26851:28615:28623:28624:30569", -- [26]
			"26847:30870", -- [27]
			"26848:28574:31078:30314", -- [28]
			"28674:30433", -- [29]
			"28674:31069", -- [30]
			"28674:30269", -- [31]
			"26848:28574:31078:30314:33849", -- [32]
			"26848:28037", -- [33]
			"26848:28037:31078", -- [34]
			"26848:28037:31078:30314:29950", -- [35]
			"26848:28037:31078:30314", -- [36]
			"26848:28037:31078:30314:33849", -- [37]
			["m"] = 486,
			["f"] = 0,
			["direct"] = "26847:26848:24795:28195:28674",
			["coord"] = 1731232670,
		},
		[24155] = {
			"28197:28196:28195:26847:24795:27046", -- [1]
			"24032:26853", -- [2]
			"26844:26852", -- [3]
			"26845:26851", -- [4]
			"26845:26851:26566", -- [5]
			"28197:28196:28195:25288", -- [6]
			"28197:28196:28195:26847", -- [7]
			"28197:28196:28195:26847:26848", -- [8]
			"26845:26851:26850", -- [9]
			"28197:28196:28195:26847:24795", -- [10]
			"28197:28196", -- [11]
			"28197:28196:28195", -- [12]
			"24032:26853:28623", -- [13]
			"26844:26852:28618:28615", -- [14]
			"26844:26852:28618", -- [15]
			"24032:26853:28624", -- [16]
			"26845:26851:26566:30870:28574", -- [17]
			"26844:26852:28618:28615:28674", -- [18]
			"26844:26852:28618:28615:29721", -- [19]
			"24032:26853:28624:32571", -- [20]
			"26844:26852:28618:28615:29721:29757", -- [21]
			"24032:26853:28624:29762", -- [22]
			"26844:26852:28618:28615:28674:31069:31078", -- [23]
			"24032:26853:28624:29951", -- [24]
			"26844:26852:28618:28615:29721:29757:29950", -- [25]
			"24032:26853:28624:30569", -- [26]
			"26845:26851:26566:30870", -- [27]
			"26844:26852:28618:28615:28674:31069:30314", -- [28]
			"26844:26852:28618:28615:28674:30433", -- [29]
			"26844:26852:28618:28615:28674:31069", -- [30]
			"26844:26852:28618:28615:30269", -- [31]
			"26844:26852:28618:28615:28674:33849", -- [32]
			"28197:28196:28195:26847:26848:28037", -- [33]
			["m"] = 491,
			["coord"] = 2235214962,
			["direct"] = "27344:24032:26844:26845:28197",
			["f"] = 0,
		},
		[24032] = {
			"26844:26845:26851:26566:26847:24795:27046", -- [1]
			"26844:26845:26851", -- [2]
			"26844:26845", -- [3]
			"26844:26845:26851:26566", -- [4]
			"26844:26845:28196:28195:25288", -- [5]
			"26844:26845:26851:26566:26847", -- [6]
			"26844:26845:26851:26566:26847:26848", -- [7]
			"26844:26845:26851:26850", -- [8]
			"26844:26845:26851:26566:26847:24795", -- [9]
			"26844:26845:28196", -- [10]
			"26844:28197", -- [11]
			"26844:26845:28196:28195", -- [12]
			"26853:28623", -- [13]
			"26853:28618:28615", -- [14]
			"26853:28618", -- [15]
			"26853:28624", -- [16]
			"26853:28618:28615:28674:28574", -- [17]
			"26853:28618:28615:28674", -- [18]
			"26853:28618:28615:29721", -- [19]
			"26853:28624:32571", -- [20]
			"26853:28618:28615:29721:29757", -- [21]
			"26853:28624:29762", -- [22]
			"26853:28618:28615:28674:31069:31078", -- [23]
			"26853:28624:29951", -- [24]
			"26853:28618:28615:29721:29757:29950", -- [25]
			"26853:28624:30569", -- [26]
			"26844:26845:26851:26566:30870", -- [27]
			"26853:28618:28615:28674:31069:30314", -- [28]
			"26853:28618:28615:28674:30433", -- [29]
			"26853:28618:28615:28674:31069", -- [30]
			"26853:28618:28615:30269", -- [31]
			"26853:28618:28615:28674:33849", -- [32]
			"26853:28618:28615:28674:28574:28037", -- [33]
			["m"] = 491,
			["coord"] = 2127502707,
			["direct"] = "24155:27344:26844:26853:26852",
			["f"] = 0,
		},
		[28195] = {
			"28196:28197:24155", -- [1]
			"28196:26845:26852:24032:27344", -- [2]
			"28196:26845:26852:24032", -- [3]
			"26847:24795:27046", -- [4]
			"28196:26845:26844", -- [5]
			"28196:26845:26852:26853", -- [6]
			"28196:26845:26852", -- [7]
			"26847:26566:26851", -- [8]
			"28196:26845", -- [9]
			"26847:26566", -- [10]
			"26847:26848", -- [11]
			"26847:26566:26850", -- [12]
			"26847:24795", -- [13]
			"28196:28197", -- [14]
			"28196:26845:28615:28623", -- [15]
			"28196:26845:28615", -- [16]
			"28196:26845:28618", -- [17]
			"28196:26845:28615:28623:28624", -- [18]
			"26847:26848:28574", -- [19]
			"26847:26566:26850:28674", -- [20]
			"26847:26566:26850:28674:29721", -- [21]
			"26847:26566:26850:28674:29721:32571", -- [22]
			"26847:26566:26850:28674:29721:29757", -- [23]
			"26847:26566:26850:28674:29721:29762", -- [24]
			"26847:30870:31078", -- [25]
			"26847:26566:26850:28674:29721:29757:29951", -- [26]
			"26847:30870:30314:29950", -- [27]
			"28196:26845:28615:28623:28624:30569", -- [28]
			"26847:30870", -- [29]
			"26847:30870:30314", -- [30]
			"26847:26566:26850:28674:30433", -- [31]
			"26847:30870:31069", -- [32]
			"28196:26845:28615:30269", -- [33]
			"26847:30870:30314:33849", -- [34]
			"26847:26848:28037", -- [35]
			["direct"] = "25288:26847:28196",
			["coord"] = 3371205577,
			["m"] = 486,
			["f"] = 0,
		},
		[28196] = {
			"28197:24155", -- [1]
			"26845:26852:24032:27344", -- [2]
			"26845:26852:24032", -- [3]
			"28195:26847:24795:27046", -- [4]
			"26845:26844", -- [5]
			"26845:26852:26853", -- [6]
			"26845:26852", -- [7]
			"28195:25288", -- [8]
			"28195:26847", -- [9]
			"28195:26847:26848", -- [10]
			"26851:26850", -- [11]
			"28195:26847:24795", -- [12]
			"26845:28615:28623", -- [13]
			"26845:28615", -- [14]
			"26845:28618", -- [15]
			"26845:28615:28623:28624", -- [16]
			"26566:30870:28574", -- [17]
			"28674:29721", -- [18]
			"28674:29721:32571", -- [19]
			"28674:29721:29757", -- [20]
			"28674:29721:29762", -- [21]
			"26566:30870:31078", -- [22]
			"28674:29721:29757:29951", -- [23]
			"28674:29721:29757:29950", -- [24]
			"26845:28615:28623:28624:30569", -- [25]
			"26566:30870", -- [26]
			"28674:31069:30314", -- [27]
			"28674:30433", -- [28]
			"28674:31069", -- [29]
			"26845:28615:30269", -- [30]
			"28674:33849", -- [31]
			"28195:26847:26848:28037", -- [32]
			["m"] = 488,
			["f"] = 0,
			["direct"] = "26851:26845:26566:28197:28195:28674",
			["coord"] = 2081603196,
		},
		[28197] = {
			"24155:27344", -- [1]
			"26844:24032", -- [2]
			"28196:28195:26847:24795:27046", -- [3]
			"26844:24032:26853", -- [4]
			"26844:26852", -- [5]
			"26844:26845:26851", -- [6]
			"26844:26845", -- [7]
			"28196:26566", -- [8]
			"28196:28195:25288", -- [9]
			"28196:28195:26847", -- [10]
			"28196:28195:26847:26848", -- [11]
			"26844:26845:26851:26850", -- [12]
			"28196:28195:26847:24795", -- [13]
			"28196:28195", -- [14]
			"26844:26852:28618:28623", -- [15]
			"26844:26852:28618:28615", -- [16]
			"26844:26852:28618", -- [17]
			"26844:24032:26853:28624", -- [18]
			"28196:26566:30870:28574", -- [19]
			"26844:26852:28618:28615:28674", -- [20]
			"26844:26852:28618:28615:29721", -- [21]
			"26844:24032:26853:28624:32571", -- [22]
			"26844:26852:28618:28615:29721:29757", -- [23]
			"26844:24032:26853:28624:29762", -- [24]
			"28196:26566:30870:31078", -- [25]
			"26844:26852:28618:28615:29721:29757:29951", -- [26]
			"26844:26852:28618:28615:29721:29757:29950", -- [27]
			"26844:24032:26853:28624:30569", -- [28]
			"28196:26566:30870", -- [29]
			"26844:26852:28618:28615:28674:31069:30314", -- [30]
			"26844:26852:28618:28615:28674:30433", -- [31]
			"26844:26852:28618:28615:28674:31069", -- [32]
			"26844:26852:28618:28615:30269", -- [33]
			"26844:26852:28618:28615:28674:33849", -- [34]
			"28196:28195:26847:26848:28037", -- [35]
			["direct"] = "24155:26844:28196",
			["f"] = 0,
			["m"] = 491,
			["coord"] = 1058378765,
		},
		[26566] = {
			"26845:24155", -- [1]
			"26845:26852:24032:27344", -- [2]
			"26845:26852:24032", -- [3]
			"26847:24795:27046", -- [4]
			"26845:26844", -- [5]
			"26845:26852:26853", -- [6]
			"26845:26852", -- [7]
			"26847:25288", -- [8]
			"26847:26848", -- [9]
			"26847:24795", -- [10]
			"26845:26844:28197", -- [11]
			"26847:28195", -- [12]
			"26851:28615:28623", -- [13]
			"26851:28615", -- [14]
			"26845:28618", -- [15]
			"26851:28615:28623:28624", -- [16]
			"30870:28574", -- [17]
			"26850:28674", -- [18]
			"26850:28674:29721", -- [19]
			"26850:28674:29721:32571", -- [20]
			"26850:28674:29721:29757", -- [21]
			"26850:28674:29721:29762", -- [22]
			"30870:31078", -- [23]
			"26850:28674:29721:29757:29951", -- [24]
			"26850:28674:29721:29757:29950", -- [25]
			"26851:28615:28623:28624:30569", -- [26]
			"30870:30314", -- [27]
			"26850:28674:30433", -- [28]
			"26850:28674:31069", -- [29]
			"26850:28674:30269", -- [30]
			"26850:28674:33849", -- [31]
			"26847:26848:28037", -- [32]
			["m"] = 488,
			["coord"] = 1609331968,
			["direct"] = "26851:26845:26847:26850:28196:30870",
			["f"] = 0,
		},
		[29721] = {
			"28615:28618:26852:26844:24155", -- [1]
			"28615:28618:26853:27344", -- [2]
			"28615:28618:26853:24032", -- [3]
			"28674:25288:24795:27046", -- [4]
			"28615:28618:26852:26844", -- [5]
			"28615:28618:26853", -- [6]
			"28615:28618:26852", -- [7]
			"28615:26851", -- [8]
			"28615:26845", -- [9]
			"28674:26850:26566", -- [10]
			"28674:25288", -- [11]
			"28674:26850:26566:26847", -- [12]
			"28674:28574:26848", -- [13]
			"28674:26850", -- [14]
			"28674:25288:24795", -- [15]
			"28615:26851:28196", -- [16]
			"28615:28618:26852:26844:28197", -- [17]
			"28615:26851:28196:28195", -- [18]
			"28615:28623", -- [19]
			"28615:28618", -- [20]
			"28615:28623:28624", -- [21]
			"28674:28574", -- [22]
			"28674:31069:31078", -- [23]
			"29757:29951", -- [24]
			"29757:29950", -- [25]
			"28615:28623:28624:30569", -- [26]
			"28674:30870", -- [27]
			"29757:29950:30314", -- [28]
			"28674:30433", -- [29]
			"28674:31069", -- [30]
			"29757:29950:33849", -- [31]
			"28674:28574:28037", -- [32]
			["m"] = 495,
			["coord"] = 1750521958,
			["direct"] = "28615:28674:32571:29757:29762:30269",
			["f"] = 0,
		},
		[30569] = {
			"28624:26853:24032:24155", -- [1]
			"28624:26853:27344", -- [2]
			"28624:26853:24032", -- [3]
			"28624:28623:28615:26850:26566:26847:24795:27046", -- [4]
			"28624:26853:24032:26844", -- [5]
			"28624:26853", -- [6]
			"28624:28623:28618:26852", -- [7]
			"28624:28623:28615:26851", -- [8]
			"28624:28623:28618:26845", -- [9]
			"28624:28623:28615:26850:26566", -- [10]
			"28624:28623:28615:28674:25288", -- [11]
			"28624:28623:28615:26850:26566:26847", -- [12]
			"28624:28623:28615:28674:28574:26848", -- [13]
			"28624:28623:28615:26850", -- [14]
			"28624:28623:28615:26850:26566:26847:24795", -- [15]
			"28624:28623:28615:26851:28196", -- [16]
			"28624:26853:24032:26844:28197", -- [17]
			"28624:28623:28615:26851:28196:28195", -- [18]
			"28624:28623", -- [19]
			"28624:28623:28615", -- [20]
			"28624:28623:28618", -- [21]
			"28624:28623:28615:28674:28574", -- [22]
			"28624:28623:28615:28674", -- [23]
			"28624:28623:28615:29721", -- [24]
			"28624:32571", -- [25]
			"28624:29762:29757", -- [26]
			"28624:29762", -- [27]
			"28624:28623:28615:28674:31069:31078", -- [28]
			"28624:29951", -- [29]
			"28624:29951:29950", -- [30]
			"28624:28623:28615:28674:30870", -- [31]
			"28624:29951:29950:30314", -- [32]
			"28624:28623:28615:28674:30433", -- [33]
			"28624:28623:28615:28674:31069", -- [34]
			"28624:28623:28615:30269", -- [35]
			"28624:29951:29950:33849", -- [36]
			"28624:28623:28615:28674:28574:28037", -- [37]
			["direct"] = "28624",
			["coord"] = 3025877835,
			["m"] = 496,
			["f"] = 0,
		},
		[33849] = {
			"29950:29951:28624:26853:24032:24155", -- [1]
			"31069:30433:28674:27344", -- [2]
			"29950:29951:28624:26853:24032", -- [3]
			"30314:30870:26847:24795:27046", -- [4]
			"31069:30433:28674:28615:28618:26852:26844", -- [5]
			"29950:29951:28624:26853", -- [6]
			"31069:30433:28674:28615:28618:26852", -- [7]
			"31069:30433:28674:26851", -- [8]
			"31069:30433:28674:26850:26845", -- [9]
			"31069:30433:28674:26850:26566", -- [10]
			"30314:30870:26847:25288", -- [11]
			"30314:30870:26847", -- [12]
			"30314:31078:28574:26848", -- [13]
			"31069:30433:28674:26850", -- [14]
			"30314:30870:26847:24795", -- [15]
			"31069:30433:28674:28196", -- [16]
			"31069:30433:28674:28615:28618:26852:26844:28197", -- [17]
			"30314:30870:26847:28195", -- [18]
			"31069:30433:28674:28615:28623", -- [19]
			"31069:30433:28674:28615", -- [20]
			"31069:30433:28674:28615:28618", -- [21]
			"29950:29951:28624", -- [22]
			"30314:31078:28574", -- [23]
			"29950:29757:29721", -- [24]
			"29950:29951:32571", -- [25]
			"29950:29757", -- [26]
			"29950:29951:29762", -- [27]
			"30314:31078", -- [28]
			"29950:29951", -- [29]
			"29950:29951:28624:30569", -- [30]
			"30314:30870", -- [31]
			"31069:30433", -- [32]
			"31069:30433:28674:30269", -- [33]
			"30314:31078:28037:26848", -- [34]
			"30314:31078:28037", -- [35]			
			["direct"] = "28674:29950:30314:31069",
			["coord"] = 3118086692,
			["m"] = 492,
			["f"] = 0,
		},
		[29951] = {
			"28624:26853:24032:24155", -- [1]
			"28624:26853:27344", -- [2]
			"28624:26853:24032", -- [3]
			"29950:30314:30870:26847:24795:27046", -- [4]
			"28624:26853:24032:26844", -- [5]
			"28624:26853", -- [6]
			"29757:29721:28615:28618:26852", -- [7]
			"29757:29721:28615:26851", -- [8]
			"29757:29721:28615:26845", -- [9]
			"29757:30433:28674:26850:26566", -- [10]
			"29757:30433:28674:25288", -- [11]
			"29950:30314:30870:26847", -- [12]
			"29950:30314:31078:28574:26848", -- [13]
			"29757:30433:28674:26850", -- [14]
			"29950:30314:30870:26847:24795", -- [15]
			"29757:30433:28674:28196", -- [16]
			"28624:26853:24032:26844:28197", -- [17]
			"29950:30314:30870:26847:28195", -- [18]
			"28624:28623", -- [19]
			"29757:29721:28615", -- [20]
			"29757:29721:28615:28618", -- [21]
			"29950:30314:31078:28574", -- [22]
			"29757:30433:28674", -- [23]
			"29757:29721", -- [24]
			"29950:30314:31078", -- [25]
			"28624:30569", -- [26]
			"29950:30314:30870", -- [27]
			"29950:30314", -- [28]
			"29757:30433", -- [29]
			"29757:30433:31069", -- [30]
			"29757:29721:30269", -- [31]
			"29950:33849", -- [32]
			"29950:30314:31078:28037:26848", -- [33]
			"29950:30314:31078:28037", -- [34]			
			["m"] = 495,
			["coord"] = 1911834618,
			["direct"] = "28624:32571:29757:29762:29950",
			["f"] = 0,
		},
		[29757] = {
			"29721:28615:28618:26852:26844:24155", -- [1]
			"29762:28624:26853:27344", -- [2]
			"29762:28624:26853:24032", -- [3]
			"30433:28674:25288:24795:27046", -- [4]
			"29721:28615:28618:26852:26844", -- [5]
			"29762:28624:26853", -- [6]
			"29721:28615:28618:26852", -- [7]
			"29721:28615:26851", -- [8]
			"29721:28615:26845", -- [9]
			"30433:28674:26850:26566", -- [10]
			"30433:28674:25288", -- [11]
			"30433:31069:30870:26847", -- [12]
			"30433:28674:28574:26848", -- [13]
			"30433:28674:26850", -- [14]
			"30433:28674:25288:24795", -- [15]
			"30433:28674:28196", -- [16]
			"29721:28615:28618:26852:26844:28197", -- [17]
			"30433:31069:30870:26847:28195", -- [18]
			"29721:28615:28623", -- [19]
			"29721:28615", -- [20]
			"29721:28615:28618", -- [21]
			"29762:28624", -- [22]
			"30433:28674:28574", -- [23]
			"30433:28674", -- [24]
			"29762:32571", -- [25]
			"29950:30314:31078", -- [26]
			"29762:28624:30569", -- [27]
			"30433:31069:30870", -- [28]
			"29950:30314", -- [29]
			"30433:31069", -- [30]
			"29721:30269", -- [31]
			"29950:33849", -- [32]
			"29950:30314:31078:28037", -- [33]			
			["m"] = 495,
			["coord"] = 1555988062,
			["direct"] = "29721:29762:29951:29950:30433",
			["f"] = 0,
		},
		[31069] = {
			"30433:28674:26850:26845:24155", -- [1]
			"30433:28674:27344", -- [2]
			"30433:28674:28615:28618:26853:24032", -- [3]
			"30870:26847:24795:27046", -- [4]
			"30433:28674:28615:28618:26852:26844", -- [5]
			"30433:28674:28615:28618:26853", -- [6]
			"30433:28674:28615:28618:26852", -- [7]
			"30433:28674:26851", -- [8]
			"30433:28674:26850:26845", -- [9]
			"30433:28674:26850:26566", -- [10]
			"30870:26847:25288", -- [11]
			"30870:26847", -- [12]
			"30870:28574:26848", -- [13]
			"30433:28674:26850", -- [14]
			"30870:26847:24795", -- [15]
			"30433:28674:28196", -- [16]
			"30433:28674:28615:28618:26852:26844:28197", -- [17]
			"30870:26847:28195", -- [18]
			"30433:28674:28615:28623", -- [19]
			"30433:28674:28615", -- [20]
			"30433:28674:28615:28618", -- [21]
			"30433:28674:28615:28623:28624", -- [22]
			"30870:28574", -- [23]
			"30433:28674:29721", -- [24]
			"30433:28674:29721:32571", -- [25]
			"30433:29757", -- [26]
			"30433:28674:29721:29762", -- [27]
			"30433:29757:29951", -- [28]
			"33849:29950", -- [29]
			"30433:28674:28615:28623:28624:30569", -- [30]
			"30433:28674:30269", -- [31]
			"30870:28574:28037", -- [1]			
			["m"] = 492,
			["coord"] = 3408050485,
			["direct"] = "28674:31078:30870:30314:30433:33849",
			["f"] = 0,
		},
		[28674] = {
			"26850:26845:24155", -- [1]
			"28615:28618:26853:24032", -- [2]
			"25288:24795:27046", -- [3]
			"28615:28618:26852:26844", -- [4]
			"28615:28618:26853", -- [5]
			"28615:28618:26852", -- [6]
			"26850:26845", -- [7]
			"26850:26566", -- [8]
			"26850:26566:26847", -- [9]
			"28574:26848", -- [10]
			"25288:24795", -- [11]
			"28615:28618:26852:26844:28197", -- [12]
			"26850:26566:26847:28195", -- [13]
			"28615:28623", -- [14]
			"28615:28618", -- [15]
			"28615:28623:28624", -- [16]
			"29721:32571", -- [17]
			"29721:29757", -- [18]
			"29721:29762", -- [19]
			"31069:31078", -- [20]
			"29721:29757:29951", -- [21]
			"29721:29757:29950", -- [22]
			"28615:28623:28624:30569", -- [23]
			"31069:30314", -- [24]
			"28574:28037", -- [25]
			"28574:28037", -- [26]			
			["m"] = 504,
			["coord"] = 3111024148,
			["direct"] = "27344:26851:25288:26850:28196:28615:28574:29721:30870:30433:31069:30269:33849",
			["f"] = 1,
		},
		[29950] = {
			"29951:28624:26853:24032:24155", -- [1]
			"29951:28624:26853:27344", -- [2]
			"29951:28624:26853:24032", -- [3]
			"30314:30870:26847:24795:27046", -- [4]
			"29757:29721:28615:28618:26852:26844", -- [5]
			"29951:28624:26853", -- [6]
			"29757:29721:28615:28618:26852", -- [7]
			"29757:29721:28615:26851", -- [8]
			"29757:29721:28615:26845", -- [9]
			"29757:30433:28674:26850:26566", -- [10]
			"30314:30870:26847:25288", -- [11]
			"30314:30870:26847", -- [12]
			"30314:31078:28574:26848", -- [13]
			"29757:30433:28674:26850", -- [14]
			"30314:30870:26847:24795", -- [15]
			"29757:30433:28674:28196", -- [16]
			"29757:29721:28615:28618:26852:26844:28197", -- [17]
			"30314:30870:26847:28195", -- [18]
			"29757:29721:28615:28623", -- [19]
			"29757:29721:28615", -- [20]
			"29757:29721:28615:28618", -- [21]
			"29951:28624", -- [22]
			"30314:31078:28574", -- [23]
			"29757:30433:28674", -- [24]
			"29757:29721", -- [25]
			"29951:32571", -- [26]
			"29951:29762", -- [27]
			"30314:31078", -- [28]
			"29951:28624:30569", -- [29]
			"30314:30870", -- [30]
			"29757:30433", -- [31]
			"33849:31069", -- [32]
			"29757:29721:30269", -- [33]
			"30314:31078:28037:26848", -- [34]
			"30314:31078:28037", -- [35]			
			["direct"] = "29757:29951:30314:33849",
			["coord"] = 1315200266,
			["m"] = 495,
			["f"] = 0,
		},
		[24795] = {
			"26847:26566:26845:24155", -- [1]
			"26847:26566:26845:26852:24032:27344", -- [2]
			"26847:26566:26845:26852:24032", -- [3]
			"26847:26566:26845:26844", -- [4]
			"26847:26566:26845:26852:26853", -- [5]
			"26847:26566:26845:26852", -- [6]
			"26847:26566:26851", -- [7]
			"26847:26566:26845", -- [8]
			"26847:26566", -- [9]
			"26847:26566:26850", -- [10]
			"26847:28195:28196", -- [11]
			"26847:26566:26845:26844:28197", -- [12]
			"26847:28195", -- [13]
			"26847:26566:26851:28615:28623", -- [14]
			"26847:26566:26851:28615", -- [15]
			"26847:26566:26845:28618", -- [16]
			"26847:26566:26851:28615:28623:28624", -- [17]
			"26848:28574", -- [18]
			"26847:26566:26850:28674", -- [19]
			"26847:26566:26850:28674:29721", -- [20]
			"26847:26566:26850:28674:29721:32571", -- [21]
			"26847:26566:26850:28674:29721:29757", -- [22]
			"26847:26566:26850:28674:29721:29762", -- [23]
			"26848:28574:31078", -- [24]
			"26848:28574:31078:30314:29950:29951", -- [25]
			"26848:28574:31078:30314:29950", -- [26]
			"26847:26566:26851:28615:28623:28624:30569", -- [27]
			"26847:30870", -- [28]
			"26848:28574:31078:30314", -- [29]
			"26847:26566:26850:28674:30433", -- [30]
			"26847:30870:31069", -- [31]
			"26847:26566:26850:28674:30269", -- [32]
			"26848:28574:31078:30314:33849", -- [33]
			"26848:28037", -- [34]
			"26848:28037:31078", -- [35]
			"26848:28037:31078:30314:29950:29951", -- [36]
			"26848:28037:31078:30314:29950", -- [37]
			"26848:28037:31078:30314", -- [38]
			"26848:28037:31078:30314:33849", -- [39]			
			["direct"] = "27046:25288:26847:26848",
			["f"] = 0,
			["m"] = 486,
			["coord"] = 1939560416,
		},
		[32571] = {
			"28624:26853:24032:24155", -- [1]
			"28624:26853:27344", -- [2]
			"28624:26853:24032", -- [3]
			"29721:28674:25288:24795:27046", -- [4]
			"28624:26853:24032:26844", -- [5]
			"28624:26853", -- [6]
			"28624:28623:28618:26852", -- [7]
			"29721:28615:26851", -- [8]
			"29721:28615:26845", -- [9]
			"29721:28674:26850:26566", -- [10]
			"29721:28674:25288", -- [11]
			"29721:28674:26850:26566:26847", -- [12]
			"29721:28674:28574:26848", -- [13]
			"29721:28674:26850", -- [14]
			"29721:28674:25288:24795", -- [15]
			"29721:28615:26851:28196", -- [16]
			"28624:26853:24032:26844:28197", -- [17]
			"29721:28615:26851:28196:28195", -- [18]
			"28624:28623", -- [19]
			"29721:28615", -- [20]
			"28624:28623:28618", -- [21]
			"29721:28674:28574", -- [22]
			"29721:28674", -- [23]
			"29951:29757", -- [24]
			"29951:29950:30314:31078", -- [25]
			"29951:29950", -- [26]
			"28624:30569", -- [27]
			"29721:28674:30870", -- [28]
			"29951:29950:30314", -- [29]
			"29721:28674:30433", -- [30]
			"29721:28674:31069", -- [31]
			"29721:30269", -- [32]
			"29951:29950:33849", -- [33]
			"29721:28674:28574:28037", -- [34]
			"29762:29757", -- [35]
			["direct"] = "28624:29721:29762:29951",
			["coord"] = 2686753797,
			["m"] = 495,
			["f"] = 0,
		},
		[30870] = {
			"26566:26845:24155", -- [1]
			"26566:26845:26852:24032:27344", -- [2]
			"26566:26845:26852:24032", -- [3]
			"26847:24795:27046", -- [4]
			"26566:26845:26844", -- [5]
			"26566:26845:26852:26853", -- [6]
			"26566:26845:26852", -- [7]
			"26566:26851", -- [8]
			"26566:26845", -- [9]
			"26847:25288", -- [10]
			"28574:26848", -- [11]
			"26566:26850", -- [12]
			"26847:24795", -- [13]
			"26566:28196", -- [14]
			"26566:26845:26844:28197", -- [15]
			"26847:28195", -- [16]
			"28674:28615:28623", -- [17]
			"28674:28615", -- [18]
			"28674:28615:28618", -- [19]
			"28674:28615:28623:28624", -- [20]
			"28674:29721", -- [21]
			"28674:29721:32571", -- [22]
			"28674:29721:29757", -- [23]
			"28674:29721:29762", -- [24]
			"28674:29721:29757:29951", -- [25]
			"30314:29950", -- [26]
			"28674:28615:28623:28624:30569", -- [27]
			"28674:30433", -- [28]
			"28674:30269", -- [29]
			"30314:33849", -- [30]
			"28574:28037", -- [31]
			["m"] = 501,
			["coord"] = 929192263,
			["direct"] = "26566:26847:28574:28674:31078:30314:31069",
			["f"] = 0,
		},
		[28037] = {
			"26848:26847:26566:26845:24155", -- [1]
			"26848:26847:26566:26845:26852:24032:27344", -- [2]
			"26848:26847:26566:26845:26852:24032", -- [3]
			"26848:24795:27046", -- [4]
			"26848:26847:26566:26845:26844", -- [5]
			"26848:26847:26566:26845:26852:26853", -- [6]
			"26848:26847:26566:26845:26852", -- [7]
			"26848:26847:26566:26851", -- [8]
			"26848:26847:26566:26845", -- [9]
			"26848:26847:26566", -- [10]
			"26848:25288", -- [11]
			"26848:26847", -- [12]
			"26848:26847:26566:26850", -- [13]
			"26848:24795", -- [14]
			"26848:26847:28195:28196", -- [15]
			"26848:26847:26566:26845:26844:28197", -- [16]
			"26848:26847:28195", -- [17]
			"28574:28674:28615:28623", -- [18]
			"28574:28674:28615", -- [19]
			"28574:28674:28615:28618", -- [20]
			"28574:28674:28615:28623:28624", -- [21]
			"28574:28674", -- [22]
			"28574:28674:29721", -- [23]
			"28574:28674:29721:32571", -- [24]
			"31078:30314:29950:29757", -- [25]
			"28574:28674:29721:29762", -- [26]
			"31078:30314:29950:29951", -- [27]
			"31078:30314:29950", -- [28]
			"28574:28674:28615:28623:28624:30569", -- [29]
			"28574:30870", -- [30]
			"31078:30314", -- [31]
			"28574:28674:30433", -- [32]
			"31078:31069", -- [33]
			"28574:28674:30269", -- [34]
			"31078:30314:33849", -- [35]
			["direct"] = "26848:28574:31078",
			["coord"] = 1083348327,
			["m"] = 493,
			["f"] = 0,
			["requirements"] = "qid:12523"
		},		
		[29762] = {
			"28624:26853:24032:24155", -- [1]
			"28624:26853:27344", -- [2]
			"28624:26853:24032", -- [3]
			"29721:28674:25288:24795:27046", -- [4]
			"28624:26853:24032:26844", -- [5]
			"28624:26853", -- [6]
			"28624:28623:28618:26852", -- [7]
			"29721:28615:26851", -- [8]
			"29721:28615:26845", -- [9]
			"29721:28674:26850:26566", -- [10]
			"29721:28674:25288", -- [11]
			"29721:28674:26850:26566:26847", -- [12]
			"29721:28674:28574:26848", -- [13]
			"29721:28674:26850", -- [14]
			"29721:28674:25288:24795", -- [15]
			"29721:28615:26851:28196", -- [16]
			"28624:26853:24032:26844:28197", -- [17]
			"29721:28615:26851:28196:28195", -- [18]
			"28624:28623", -- [19]
			"29721:28615", -- [20]
			"28624:28623:28618", -- [21]
			"29721:28674:28574", -- [22]
			"29721:28674", -- [23]
			"29951:29950:30314:31078", -- [24]
			"29951:29950", -- [25]
			"28624:30569", -- [26]
			"29721:28674:30870", -- [27]
			"29951:29950:30314", -- [28]
			"29757:30433", -- [29]
			"29757:30433:31069", -- [30]
			"29721:30269", -- [31]
			"29951:29950:33849", -- [32]
			"29951:29950:30314:31078:28037", -- [33]
			["m"] = 495,
			["coord"] = 2809037259,
			["direct"] = "28624:29721:32571:29757:29951",
			["f"] = 0,
		},
		[27344] = {
			"24032:26844:26845:26851:26566:26847:24795:27046", -- [1]
			"24032:26844", -- [2]
			"24032:26852", -- [3]
			"24032:26844:26845:26851", -- [4]
			"24032:26844:26845", -- [5]
			"24032:26844:26845:26851:26566", -- [6]
			"24032:26844:26845:28196:28195:25288", -- [7]
			"24032:26844:26845:26851:26566:26847", -- [8]
			"24032:26844:26845:26851:26566:26847:26848", -- [9]
			"26853:28618:28615:26850", -- [10]
			"24032:26844:26845:26851:26566:26847:24795", -- [11]
			"24032:26844:26845:28196", -- [12]
			"24155:28197", -- [13]
			"24032:26844:26845:28196:28195", -- [14]
			"26853:28623", -- [15]
			"26853:28618:28615", -- [16]
			"26853:28618", -- [17]
			"26853:28624", -- [18]
			"28674:28574", -- [19]
			"26853:28618:28615:29721", -- [20]
			"26853:28624:32571", -- [21]
			"26853:28618:28615:29721:29757", -- [22]
			"26853:28624:29762", -- [23]
			"28674:31069:31078", -- [24]
			"26853:28624:29951", -- [25]
			"26853:28618:28615:29721:29757:29950", -- [26]
			"26853:28624:30569", -- [27]
			"28674:30870", -- [28]
			"28674:31069:30314", -- [29]
			"28674:30433", -- [30]
			"28674:31069", -- [31]
			"26853:28618:28615:30269", -- [32]
			"28674:33849", -- [33]
			"28674:28574:28037", -- [34]
			["direct"] = "24155:24032:26853:28674",
			["coord"] = 3394259988,
			["m"] = 491,
			["f"] = 0,
		},
		[30269] = {
			"28615:28618:26852:26844:24155", -- [1]
			"28615:28618:26853:27344", -- [2]
			"28615:28618:26853:24032", -- [3]
			"28674:25288:24795:27046", -- [4]
			"28615:28618:26852:26844", -- [5]
			"28615:28618:26853", -- [6]
			"28615:28618:26852", -- [7]
			"28615:26851", -- [8]
			"28615:26845", -- [9]
			"28674:26850:26566", -- [10]
			"28674:25288", -- [11]
			"28674:26850:26566:26847", -- [12]
			"28674:28574:26848", -- [13]
			"28674:26850", -- [14]
			"28674:25288:24795", -- [15]
			"28615:26851:28196", -- [16]
			"28615:28618:26852:26844:28197", -- [17]
			"28615:26851:28196:28195", -- [18]
			"28615:28623", -- [19]
			"28615:28618", -- [20]
			"28615:28623:28624", -- [21]
			"28674:28574", -- [22]
			"29721:32571", -- [23]
			"29721:29757", -- [24]
			"29721:29762", -- [25]
			"28674:31069:31078", -- [26]
			"29721:29757:29951", -- [27]
			"29721:29757:29950", -- [28]
			"28615:28623:28624:30569", -- [29]
			"28674:30870", -- [30]
			"28674:31069:30314", -- [31]
			"28674:30433", -- [32]
			"28674:31069", -- [33]
			"28674:33849", -- [34]
			"28674:28574:28037", -- [269]			
			["direct"] = "28615:28674:29721",
			["f"] = 0,
			["m"] = 510,
			["coord"] = 3370746011,
		},
		[30433] = {
			"28674:26850:26845:24155", -- [1]
			"28674:27344", -- [2]
			"28674:28615:28618:26853:24032", -- [3]
			"28674:25288:24795:27046", -- [4]
			"28674:28615:28618:26852:26844", -- [5]
			"28674:28615:28618:26853", -- [6]
			"28674:28615:28618:26852", -- [7]
			"28674:26851", -- [8]
			"28674:26850:26845", -- [9]
			"28674:26850:26566", -- [10]
			"28674:25288", -- [11]
			"31069:30870:26847", -- [12]
			"28674:28574:26848", -- [13]
			"28674:26850", -- [14]
			"28674:25288:24795", -- [15]
			"28674:28196", -- [16]
			"28674:28615:28618:26852:26844:28197", -- [17]
			"31069:30870:26847:28195", -- [18]
			"28674:28615:28623", -- [19]
			"28674:28615", -- [20]
			"28674:28615:28618", -- [21]
			"28674:28615:28623:28624", -- [22]
			"28674:28574", -- [23]
			"28674:29721", -- [24]
			"28674:29721:32571", -- [25]
			"28674:29721:29762", -- [26]
			"31069:31078", -- [27]
			"29757:29951", -- [28]
			"29757:29950", -- [29]
			"28674:28615:28623:28624:30569", -- [30]
			"31069:30870", -- [31]
			"28674:30269", -- [32]
			"31069:33849", -- [33]
			"28674:28574:28037", -- [34]
			["direct"] = "28674:29757:30314:31069",
			["f"] = 0,
			["m"] = 492,
			["coord"] = 3770468289,
		},
		[27046] = {
			"24795:26847:26566:26845:24155", -- [1]
			"24795:26847:26566:26845:26852:24032:27344", -- [2]
			"24795:26847:26566:26845:26852:24032", -- [3]
			"24795:26847:26566:26845:26844", -- [4]
			"24795:26847:26566:26845:26852:26853", -- [5]
			"24795:26847:26566:26845:26852", -- [6]
			"24795:26847:26566:26851", -- [7]
			"24795:26847:26566:26845", -- [8]
			"24795:26847:26566", -- [9]
			"24795:25288", -- [10]
			"24795:26847", -- [11]
			"24795:26848", -- [12]
			"24795:26847:26566:26850", -- [13]
			"24795:26847:28195:28196", -- [14]
			"24795:26847:26566:26845:26844:28197", -- [15]
			"24795:26847:28195", -- [16]
			"24795:26847:26566:26851:28615:28623", -- [17]
			"24795:26847:26566:26851:28615", -- [18]
			"24795:26847:26566:26845:28618", -- [19]
			"24795:26847:26566:26851:28615:28623:28624", -- [20]
			"24795:26848:28574", -- [21]
			"24795:26847:26566:26850:28674", -- [22]
			"24795:26847:26566:26850:28674:29721", -- [23]
			"24795:26847:26566:26850:28674:29721:32571", -- [24]
			"24795:26847:26566:26850:28674:29721:29757", -- [25]
			"24795:26847:26566:26850:28674:29721:29762", -- [26]
			"24795:26848:28574:31078", -- [27]
			"24795:26848:28574:31078:30314:29950:29951", -- [28]
			"24795:26848:28574:31078:30314:29950", -- [29]
			"24795:26847:26566:26851:28615:28623:28624:30569", -- [30]
			"24795:26847:30870", -- [31]
			"24795:26848:28574:31078:30314", -- [32]
			"24795:26847:26566:26850:28674:30433", -- [33]
			"24795:26847:30870:31069", -- [34]
			"24795:26847:26566:26850:28674:30269", -- [35]
			"24795:26848:28574:31078:30314:33849", -- [36]
			"24795:26848:28037", -- [37]
			"24795:26848:28037:31078", -- [38]
			"24795:26848:28037:31078:30314:29950:29951", -- [39]
			"24795:26848:28037:31078:30314:29950", -- [40]
			"24795:26848:28037:31078:30314", -- [41]
			"24795:26848:28037:31078:30314:33849", -- [43]			
			["direct"] = "24795",
			["f"] = 0,
			["m"] = 486,
			["coord"] = 1422481428,
		},
		[26844] = {
			"24032:27344", -- [1]
			"26845:26851:26566:26847:24795:27046", -- [2]
			"24032:26853", -- [3]
			"26845:26851", -- [4]
			"26845:26851:26566", -- [5]
			"26845:28196:28195:25288", -- [6]
			"26845:26851:26566:26847", -- [7]
			"26845:26851:26566:26847:26848", -- [8]
			"26845:26851:26850", -- [9]
			"26845:26851:26566:26847:24795", -- [10]
			"26845:28196", -- [11]
			"26845:28196:28195", -- [12]
			"26852:28618:28623", -- [13]
			"26852:28618:28615", -- [14]
			"26852:28618", -- [15]
			"24032:26853:28624", -- [16]
			"26845:26851:26566:30870:28574", -- [17]
			"26852:28618:28615:28674", -- [18]
			"26852:28618:28615:29721", -- [19]
			"24032:26853:28624:32571", -- [20]
			"26852:28618:28615:29721:29757", -- [21]
			"24032:26853:28624:29762", -- [22]
			"26852:28618:28615:28674:31069:31078", -- [23]
			"26852:28618:28615:29721:29757:29951", -- [24]
			"26852:28618:28615:29721:29757:29950", -- [25]
			"24032:26853:28624:30569", -- [26]
			"26845:26851:26566:30870", -- [27]
			"26852:28618:28615:28674:31069:30314", -- [28]
			"26852:28618:28615:28674:30433", -- [29]
			"26852:28618:28615:28674:31069", -- [30]
			"26852:28618:28615:30269", -- [31]
			"26852:28618:28615:28674:33849", -- [32]
			"26845:26851:26566:26847:26848:28037", -- [33]
			["m"] = 491,
			["coord"] = 1115308011,
			["direct"] = "24155:24032:26852:26845:28197",
			["f"] = 0,
		},
		[26845] = {
			"26852:24032:27344", -- [1]
			"26852:24032", -- [2]
			"26851:26566:26847:24795:27046", -- [3]
			"26852:26853", -- [4]
			"28196:28195:25288", -- [5]
			"26851:26566:26847", -- [6]
			"26851:26566:26847:26848", -- [7]
			"26851:26566:26847:24795", -- [8]
			"26844:28197", -- [9]
			"28196:28195", -- [10]
			"28615:28623", -- [11]
			"28615:28623:28624", -- [12]
			"26851:26566:30870:28574", -- [13]
			"26851:28674", -- [14]
			"28615:29721", -- [15]
			"28615:29721:32571", -- [16]
			"28615:29721:29757", -- [17]
			"28615:29721:29762", -- [18]
			"26851:26566:30870:31078", -- [19]
			"28615:29721:29757:29951", -- [20]
			"28615:29721:29757:29950", -- [21]
			"28615:28623:28624:30569", -- [22]
			"26851:26566:30870", -- [23]
			"26851:28674:31069:30314", -- [24]
			"26851:28674:30433", -- [25]
			"26851:28674:31069", -- [26]
			"28615:30269", -- [27]
			"26851:28674:33849", -- [28]
			"26851:26566:26847:26848:28037", -- [29]
			["m"] = 488,
			["f"] = 0,
			["direct"] = "24155:26844:26852:26851:26566:26850:28196:28615:28618",
			["coord"] = 3285163912,
		},
		[28574] = {
			"30870:26566:26845:24155", -- [1]
			"30870:26566:26845:26852:24032:27344", -- [2]
			"30870:26566:26845:26852:24032", -- [3]
			"26848:24795:27046", -- [4]
			"30870:26566:26845:26844", -- [5]
			"28674:28615:28618:26853", -- [6]
			"30870:26566:26845:26852", -- [7]
			"30870:26566:26851", -- [8]
			"30870:26566:26845", -- [9]
			"30870:26566", -- [10]
			"26848:25288", -- [11]
			"26848:26847", -- [12]
			"30870:26566:26850", -- [13]
			"26848:24795", -- [14]
			"30870:26566:28196", -- [15]
			"30870:26566:26845:26844:28197", -- [16]
			"26848:26847:28195", -- [17]
			"28674:28615:28623", -- [18]
			"28674:28615", -- [19]
			"28674:28615:28618", -- [20]
			"28674:28615:28623:28624", -- [21]
			"28674:29721", -- [22]
			"28674:29721:32571", -- [23]
			"28674:29721:29757", -- [24]
			"28674:29721:29762", -- [25]
			"31078:30314:29950:29951", -- [26]
			"31078:30314:29950", -- [27]
			"28674:28615:28623:28624:30569", -- [28]
			"31078:30314", -- [29]
			"28674:30433", -- [30]
			"28674:31069", -- [31]
			"28674:30269", -- [32]
			"31078:30314:33849", -- [33]
			["direct"] = "26848:28037:28674:31078:30870",
			["coord"] = 2150407428,
			["m"] = 493,
			["f"] = 0,
		},
		[26847] = {
			"26566:26845:24155", -- [1]
			"26566:26845:26852:24032:27344", -- [2]
			"26566:26845:26852:24032", -- [3]
			"24795:27046", -- [4]
			"26566:26845:26844", -- [5]
			"26566:26845:26852:26853", -- [6]
			"26566:26845:26852", -- [7]
			"26566:26851", -- [8]
			"26566:26845", -- [9]
			"26566:26850", -- [10]
			"28195:28196", -- [11]
			"26566:26845:26844:28197", -- [12]
			"26566:26851:28615:28623", -- [13]
			"26566:26851:28615", -- [14]
			"26566:26845:28618", -- [15]
			"26566:26851:28615:28623:28624", -- [16]
			"26848:28574", -- [17]
			"26566:26850:28674", -- [18]
			"26566:26850:28674:29721", -- [19]
			"26566:26850:28674:29721:32571", -- [20]
			"26566:26850:28674:29721:29757", -- [21]
			"26566:26850:28674:29721:29762", -- [22]
			"30870:31078", -- [23]
			"26566:26850:28674:29721:29757:29951", -- [24]
			"30870:30314:29950", -- [25]
			"26566:26851:28615:28623:28624:30569", -- [26]
			"30870:30314", -- [27]
			"26566:26850:28674:30433", -- [28]
			"30870:31069", -- [29]
			"26566:26850:28674:30269", -- [30]
			"30870:30314:33849", -- [31]
			"26848:28037", -- [32]
			["m"] = 486,
			["coord"] = 3338821751,
			["direct"] = "26566:25288:26848:24795:28195:30870",
			["f"] = 0,
		},
		[26848] = {
			"26847:26566:26845:24155", -- [1]
			"26847:26566:26845:26852:24032:27344", -- [2]
			"26847:26566:26845:26852:24032", -- [3]
			"24795:27046", -- [4]
			"26847:26566:26845:26844", -- [5]
			"26847:26566:26845:26852:26853", -- [6]
			"26847:26566:26845:26852", -- [7]
			"26847:26566:26851", -- [8]
			"26847:26566:26845", -- [9]
			"26847:26566", -- [10]
			"26847:26566:26850", -- [11]
			"26847:28195:28196", -- [12]
			"26847:26566:26845:26844:28197", -- [13]
			"26847:28195", -- [14]
			"26847:26566:26851:28615:28623", -- [15]
			"26847:26566:26851:28615", -- [16]
			"26847:26566:26845:28618", -- [17]
			"26847:26566:26851:28615:28623:28624", -- [18]
			"28574:28674", -- [19]
			"28574:28674:29721", -- [20]
			"28574:28674:29721:32571", -- [21]
			"28574:28674:29721:29757", -- [22]
			"28574:28674:29721:29762", -- [23]
			"28574:31078", -- [24]
			"28574:31078:30314:29950:29951", -- [25]
			"28574:31078:30314:29950", -- [26]
			"26847:26566:26851:28615:28623:28624:30569", -- [27]
			"28574:30870", -- [28]
			"28574:31078:30314", -- [29]
			"28574:28674:30433", -- [30]
			"28574:28674:31069", -- [31]
			"28574:28674:30269", -- [32]
			"28574:31078:30314:33849", -- [33]
			"28037:31078", -- [34]
			"28037:31078:30314:29950:29951", -- [35]
			"28037:31078:30314:29950", -- [36]
			"28037:31078:30314", -- [37]
			"28037:31078:30314:33849", -- [38]			
			["direct"] = "25288:26847:24795:28574:28037",
			["f"] = 0,
			["m"] = 486,
			["coord"] = 2129861678,
		},
		[30314] = {
			"30870:26566:26845:24155", -- [1]
			"30433:28674:27344", -- [2]
			"30433:28674:28615:28618:26853:24032", -- [3]
			"30870:26847:24795:27046", -- [4]
			"30870:26566:26845:26844", -- [5]
			"30433:28674:28615:28618:26853", -- [6]
			"30433:28674:28615:28618:26852", -- [7]
			"30433:28674:26851", -- [8]
			"30870:26566:26845", -- [9]
			"30870:26566", -- [10]
			"30870:26847:25288", -- [11]
			"30870:26847", -- [12]
			"31078:28574:26848", -- [13]
			"30433:28674:26850", -- [14]
			"30870:26847:24795", -- [15]
			"30870:26566:28196", -- [16]
			"30870:26566:26845:26844:28197", -- [17]
			"30870:26847:28195", -- [18]
			"30433:28674:28615:28623", -- [19]
			"30433:28674:28615", -- [20]
			"30433:28674:28615:28618", -- [21]
			"29950:29951:28624", -- [22]
			"31078:28574", -- [23]
			"30433:28674", -- [24]
			"30433:28674:29721", -- [25]
			"29950:29951:32571", -- [26]
			"29950:29757", -- [27]
			"29950:29951:29762", -- [28]
			"29950:29951", -- [29]
			"29950:29951:28624:30569", -- [30]
			"30433:28674:30269", -- [31]
			"31078:28037:26848", -- [32]
			"31078:28037", -- [33]			
			["m"] = 492,
			["coord"] = 1878408808,
			["direct"] = "31078:29950:30870:30433:31069:33849",
			["f"] = 0,
		},
		[26850] = {
			"26845:24155", -- [1]
			"26845:26852:24032:27344", -- [2]
			"26845:26852:24032", -- [3]
			"26566:26847:24795:27046", -- [4]
			"26845:26844", -- [5]
			"26845:26852:26853", -- [6]
			"26845:26852", -- [7]
			"26566:26847:25288", -- [8]
			"26566:26847", -- [9]
			"26566:26847:26848", -- [10]
			"26566:26847:24795", -- [11]
			"26566:28196", -- [12]
			"26845:26844:28197", -- [13]
			"26566:26847:28195", -- [14]
			"28615:28623", -- [15]
			"28615:28618", -- [16]
			"28615:28623:28624", -- [17]
			"26566:30870:28574", -- [18]
			"28674:29721", -- [19]
			"28674:29721:32571", -- [20]
			"28674:29721:29757", -- [21]
			"28674:29721:29762", -- [22]
			"28674:31069:31078", -- [23]
			"28674:29721:29757:29951", -- [24]
			"28674:29721:29757:29950", -- [25]
			"28615:28623:28624:30569", -- [26]
			"26566:30870", -- [27]
			"28674:31069:30314", -- [28]
			"28674:30433", -- [29]
			"28674:31069", -- [30]
			"28674:30269", -- [31]
			"28674:33849", -- [32]
			"26566:26847:26848:28037", -- [33]
			["m"] = 488,
			["coord"] = 1884760835,
			["direct"] = "26851:26845:26566:28615:28674",
			["f"] = 0,
		},
		[26851] = {
			"26845:24155", -- [1]
			"26845:26852:24032:27344", -- [2]
			"26845:26852:24032", -- [3]
			"26566:26847:24795:27046", -- [4]
			"26845:26844", -- [5]
			"26845:26852:26853", -- [6]
			"26845:26852", -- [7]
			"26566:26847:25288", -- [8]
			"26566:26847", -- [9]
			"26566:26847:26848", -- [10]
			"26566:26847:24795", -- [11]
			"26845:26844:28197", -- [12]
			"28196:28195", -- [13]
			"28615:28623", -- [14]
			"28615:28618", -- [15]
			"28615:28623:28624", -- [16]
			"26566:30870:28574", -- [17]
			"28615:29721", -- [18]
			"28615:29721:32571", -- [19]
			"28615:29721:29757", -- [20]
			"28615:29721:29762", -- [21]
			"26566:30870:31078", -- [22]
			"28615:29721:29757:29951", -- [23]
			"28615:29721:29757:29950", -- [24]
			"28615:28623:28624:30569", -- [25]
			"26566:30870", -- [26]
			"28674:31069:30314", -- [27]
			"28674:30433", -- [28]
			"28674:31069", -- [29]
			"28615:30269", -- [30]
			"28674:33849", -- [31]
			"26566:26847:26848:28037", -- [32]
			["m"] = 488,
			["f"] = 0,
			["direct"] = "26845:26566:26850:28196:28615:28674",
			["coord"] = 2588115855,
		},
		[28615] = {
			"28618:26852:26844:24155", -- [1]
			"28618:26853:27344", -- [2]
			"28618:26853:24032", -- [3]
			"26850:26566:26847:24795:27046", -- [4]
			"28618:26852:26844", -- [5]
			"28618:26853", -- [6]
			"28618:26852", -- [7]
			"26850:26566", -- [8]
			"28674:25288", -- [9]
			"26850:26566:26847", -- [10]
			"28674:28574:26848", -- [11]
			"26850:26566:26847:24795", -- [12]
			"26851:28196", -- [13]
			"28618:26852:26844:28197", -- [14]
			"26851:28196:28195", -- [15]
			"28623:28624", -- [16]
			"28674:28574", -- [17]
			"29721:32571", -- [18]
			"29721:29757", -- [19]
			"29721:29762", -- [20]
			"28674:31069:31078", -- [21]
			"29721:29757:29951", -- [22]
			"29721:29757:29950", -- [23]
			"28623:28624:30569", -- [24]
			"28674:30870", -- [25]
			"28674:31069:30314", -- [26]
			"28674:30433", -- [27]
			"28674:31069", -- [28]
			"28674:33849", -- [29]
			"28674:28574:28037", -- [30]
			["m"] = 496,
			["f"] = 0,
			["direct"] = "26851:26845:26850:28623:28618:28674:29721:30269",
			["coord"] = 603962466,
		},
	}, -- [4]
	[6] = {
		[65863] = {
			"61122:60230:60952", -- [1]
			"61122:60230:59186", -- [2]
			"61122:60230:59186:59732", -- [3]
			"61122:60230:59186:59727", -- [4]
			"62901:61473:61745:61474:66227:59736:59735:59733", -- [5]
			"62901:61473:61745:61474:66227:59736:59735", -- [6]
			"62901:61473:61745:61474:66227:59736", -- [7]
			"62901:61473:61745:61474:66227", -- [8]
			"61122:60230", -- [9]
			"61122:60231", -- [10]
			"61122:60231:60232", -- [11]
			"61122:60231:59046", -- [12]
			"62903:63500:63501:58843", -- [13]
			"62903:63500:63501:58843:59047", -- [14]
			"62903:63500:63501:58843:65189", -- [15]
			"62903:63500:63501:58843:59047:60441", -- [16]
			"62901:61473:61745:61474", -- [17]
			"62901:61512:60416:61504:61118", -- [18]
			"62901:61473:61745", -- [19]
			"62901:61512:60416:61504:61511", -- [20]
			"62901:61512:60416:61504", -- [21]
			"62901:61512:60416", -- [22]
			"62901:61473", -- [23]
			"62901:61512", -- [24]
			"61122:62658:61759", -- [25]
			"61122:62658", -- [26]
			"62901:62898", -- [27]
			"62901:62898:62909", -- [28]
			"62903:63500:63501", -- [29]
			"62903:63500:63501:63498", -- [30]
			"62903:63500", -- [31]
			"62903:63500:63497", -- [32]
			"61122:60230:59186:64310", -- [33]
			"62903:63500:63501:65511", -- [34]
			"62903:63500:63501:58843:67785", -- [35]
			"61122:60230:59186:71939", -- [36]
			["direct"] = "62901:62903:61122",
			["f"] = 0,
			["m"] = 809,
			["coord"] = 1546901103,
		},
		[61512] = {
			"60416:61745:61474:61759:60230:60952", -- [1]
			"60416:61745:61474:61759:60230:59186", -- [2]
			"60416:61745:61474:61759:60230:59186:59732", -- [3]
			"60416:61745:61474:61759:60230:59186:59727", -- [4]
			"60416:61745:61474:66227:59736:59735:59733", -- [5]
			"60416:61745:61474:66227:59736:59735", -- [6]
			"60416:61745:61474:66227:59736", -- [7]
			"60416:61745:61474:66227", -- [8]
			"60416:61745:61474:61759:60230", -- [9]
			"60416:61745:61474:61759:62658:60231", -- [10]
			"60416:61745:61474:60232", -- [11]
			"60416:61745:61474:61759:62658:60231:59046", -- [12]
			"62901:62903:63500:63501:58843", -- [13]
			"62901:62903:63500:63501:58843:59047", -- [14]
			"62901:62903:63500:63501:58843:65189", -- [15]
			"62901:62903:63500:63501:58843:59047:60441", -- [16]
			"60416:61745:61474", -- [17]
			"60416:61504:61118", -- [18]
			"60416:61745", -- [19]
			"60416:61504:61511", -- [20]
			"60416:61504", -- [21]
			"60416:61473", -- [22]
			"60416:61745:61474:61759", -- [23]
			"60416:61745:61474:61759:62658", -- [24]
			"62901:62903", -- [25]
			"62901:62898", -- [26]
			"62901:62898:62909", -- [27]
			"62901:65863:61122", -- [28]
			"62901:62903:63500:63501", -- [29]
			"63497:63498", -- [30]
			"62901:62903:63500", -- [31]
			"60416:61745:61474:61759:60230:59186:64310", -- [32]
			"62901:62903:63500:63501:65511", -- [33]
			"62901:65863", -- [34]
			"62901:62903:63500:63501:58843:67785", -- [35]
			"60416:61745:61474:61759:60230:59186:71939", -- [36]
			["direct"] = "60416:62901:63497",
			["f"] = 0,
			["m"] = 809,
			["coord"] = 1483642710,
		},
		[62658] = {
			"60230:60952", -- [1]
			"60230:59186", -- [2]
			"60230:59186:59732", -- [3]
			"60230:59186:59727", -- [4]
			"60230:59186:59735:59733", -- [5]
			"60230:59186:59735", -- [6]
			"60230:60952:59736", -- [7]
			"61759:61474:66227", -- [8]
			"60230:60232", -- [9]
			"60231:59046", -- [10]
			"60231:58843", -- [11]
			"60231:65189:59047", -- [12]
			"60231:65189", -- [13]
			"60231:59046:60441", -- [14]
			"61759:61474", -- [15]
			"61759:61474:61118", -- [16]
			"61759:61474:61745", -- [17]
			"61759:61474:61118:61511", -- [18]
			"61759:61474:61504", -- [19]
			"61759:61474:61745:60416", -- [20]
			"61759:61474:61745:61473", -- [21]
			"61759:61474:61745:60416:61512", -- [22]
			"61122:65863:62901", -- [23]
			"61759:61474:61745:61473:62903", -- [24]
			"61122:65863:62901:62898", -- [25]
			"61122:65863:62901:62898:62909", -- [26]
			"60231:58843:63501", -- [27]
			"60231:58843:63501:63498", -- [28]
			"61122:63500", -- [29]
			"61122:63497", -- [30]
			"60230:59186:64310", -- [31]
			"60231:58843:63501:65511", -- [32]
			"61122:65863", -- [33]
			"60231:58843:67785", -- [34]
			"60230:59186:71939", -- [35]
			["direct"] = "60230:60231:61759:61122",
			["f"] = 0,
			["m"] = 807,
			["coord"] = 3041607207,
		},
		[67785] = {
			"58843:60231:60230:60952", -- [1]
			"58843:60231:60230:59186", -- [2]
			"58843:60231:60230:59186:59732", -- [3]
			"58843:60231:60230:59186:59727", -- [4]
			"58843:60231:60230:59186:59735:59733", -- [5]
			"58843:60231:60230:59186:59735", -- [6]
			"58843:60231:60230:60952:59736", -- [7]
			"58843:60231:62658:61759:61474:66227", -- [8]
			"58843:60231:60230", -- [9]
			"58843:60231", -- [10]
			"58843:60231:60232", -- [11]
			"59047:59046", -- [12]
			"59047:65189", -- [13]
			"59047:60441", -- [14]
			"58843:60231:62658:61759:61474", -- [15]
			"58843:60231:62658:61759:61474:61118", -- [16]
			"58843:60231:62658:61759:61474:61745", -- [17]
			"58843:60231:62658:61759:61474:61118:61511", -- [18]
			"58843:60231:62658:61759:61474:61504", -- [19]
			"58843:63501:63500:62903:61473:60416", -- [20]
			"58843:63501:63500:62903:61473", -- [21]
			"58843:63501:63497:61512", -- [22]
			"58843:60231:62658:61759", -- [23]
			"58843:60231:62658", -- [24]
			"58843:63501:63500:62903:62901", -- [25]
			"58843:63501:63500:62903", -- [26]
			"58843:63501:63500:62903:62898", -- [27]
			"58843:63501:63500:62903:62898:62909", -- [28]
			"58843:60231:61122", -- [29]
			"58843:63501", -- [30]
			"58843:63501:63498", -- [31]
			"58843:63501:63500", -- [32]
			"58843:63501:63497", -- [33]
			"58843:60231:60230:59186:64310", -- [34]
			"58843:63501:65511", -- [35]
			"58843:63501:63500:62903:65863", -- [36]
			"58843:60231:60230:59186:71939", -- [37]
			["direct"] = "58843:59047",
			["f"] = 0,
			["m"] = 857,
			["coord"] = 417695358,
		},
		[61473] = {
			"61745:61474:61759:60230:60952", -- [1]
			"61745:61474:61759:60230:59186", -- [2]
			"61745:61474:61759:60230:59186:59732", -- [3]
			"61745:61474:61759:60230:59186:59727", -- [4]
			"61745:61474:66227:59736:59735:59733", -- [5]
			"61745:61474:66227:59736:59735", -- [6]
			"61745:61474:66227:59736", -- [7]
			"61745:61474:66227", -- [8]
			"61745:61474:61759:60230", -- [9]
			"61745:61474:61759:62658:60231", -- [10]
			"61745:61474:60232", -- [11]
			"61745:61474:61759:62658:60231:59046", -- [12]
			"62903:63500:63501:58843", -- [13]
			"62903:63500:63501:58843:59047", -- [14]
			"62903:63500:63501:58843:65189", -- [15]
			"62903:63500:63501:58843:59047:60441", -- [16]
			"61745:61474", -- [17]
			"60416:61504:61118", -- [18]
			"60416:61504:61511", -- [19]
			"60416:61504", -- [20]
			"60416:61512", -- [21]
			"61745:61474:61759", -- [22]
			"61745:61474:61759:62658", -- [23]
			"62903:62898", -- [24]
			"62903:62898:62909", -- [25]
			"61745:61122", -- [26]
			"62903:63500:63501", -- [27]
			"62903:63500:63501:63498", -- [28]
			"62903:63500", -- [29]
			"62903:63500:63497", -- [30]
			"61745:61474:61759:60230:59186:64310", -- [31]
			"62903:63500:63501:65511", -- [32]
			"62903:65863", -- [33]
			"62903:63500:63501:58843:67785", -- [34]
			"61745:61474:61759:60230:59186:71939", -- [35]
			["direct"] = "61745:60416:62901:62903",
			["f"] = 0,
			["m"] = 809,
			["coord"] = 1887954260,
		},
		[64310] = {
			"59186:59732", -- [1]
			"59186:59727", -- [2]
			"59186:59735:59733", -- [3]
			"59186:59735", -- [4]
			"59186:59736", -- [5]
			"60952:66227", -- [6]
			"60952:60230", -- [7]
			"60952:60230:60231", -- [8]
			"60952:60230:60232", -- [9]
			"60952:60230:59046", -- [10]
			"60952:60230:60231:58843", -- [11]
			"60952:60230:59046:59047", -- [12]
			"60952:60230:60231:65189", -- [13]
			"60952:60230:59046:60441", -- [14]
			"60952:60230:61759:61474", -- [15]
			"60952:60230:61759:61474:61118", -- [16]
			"60952:60230:61759:61474:61745", -- [17]
			"60952:60230:61759:61474:61118:61511", -- [18]
			"60952:60230:61759:61474:61504", -- [19]
			"60952:60230:61759:61474:61745:60416", -- [20]
			"60952:60230:61759:61474:61745:61473", -- [21]
			"60952:60230:61759:61474:61745:60416:61512", -- [22]
			"60952:60230:61759", -- [23]
			"60952:60230:62658", -- [24]
			"60952:60230:62658:61122:65863:62901", -- [25]
			"60952:60230:61759:61474:61745:61473:62903", -- [26]
			"60952:60230:61759:61474:61745:61473:62903:62898", -- [27]
			"60952:60230:61759:61474:61745:61473:62903:62898:62909", -- [28]
			"60952:60230:62658:61122", -- [29]
			"60952:60230:60231:58843:63501", -- [30]
			"60952:60230:60231:58843:63501:63498", -- [31]
			"60952:60230:62658:61122:63500", -- [32]
			"60952:60230:62658:61122:63497", -- [33]
			"60952:60230:60231:58843:63501:65511", -- [34]
			"60952:60230:62658:61122:65863", -- [35]
			"60952:60230:60231:58843:67785", -- [36]
			"59186:71939", -- [37]
			["direct"] = "60952:59186",
			["f"] = 0,
			["m"] = 806,
			["coord"] = 1851633473,
		},
		[65511] = {
			"63501:58843:60231:60230:60952", -- [1]
			"63501:58843:60231:60230:59186", -- [2]
			"63501:58843:60231:60230:59186:59732", -- [3]
			"63501:58843:60231:60230:59186:59727", -- [4]
			"63501:58843:60231:60230:59186:59735:59733", -- [5]
			"63501:58843:60231:60230:59186:59735", -- [6]
			"63501:58843:60231:60230:60952:59736", -- [7]
			"63501:61122:66227", -- [8]
			"63501:58843:60231:60230", -- [9]
			"63501:58843:60231", -- [10]
			"63501:58843:60231:60232", -- [11]
			"63501:58843:60231:59046", -- [12]
			"63501:58843", -- [13]
			"63501:58843:59047", -- [14]
			"63501:58843:65189", -- [15]
			"63501:58843:59047:60441", -- [16]
			"63501:61122:61474", -- [17]
			"63501:63500:62903:61473:60416:61504:61118", -- [18]
			"63501:63500:62903:61473:61745", -- [19]
			"63501:63500:62903:61473:60416:61504:61511", -- [20]
			"63501:63500:62903:61473:60416:61504", -- [21]
			"63501:63500:62903:61473:60416", -- [22]
			"63501:63500:62903:61473", -- [23]
			"63501:63497:61512", -- [24]
			"63501:58843:60231:62658:61759", -- [25]
			"63501:58843:60231:62658", -- [26]
			"63501:63500:62903:62901", -- [27]
			"63501:63500:62903", -- [28]
			"63501:63500:62903:62898", -- [29]
			"63501:63500:62903:62898:62909", -- [30]
			"63501:61122", -- [31]
			"63501:63500", -- [32]
			"63501:63497", -- [33]
			"63501:58843:60231:60230:59186:64310", -- [34]
			"63501:63500:62903:65863", -- [35]
			"63501:58843:67785", -- [36]
			"63501:58843:60231:60230:59186:71939", -- [37]
			["direct"] = "63501:63498",
			["f"] = 0,
			["m"] = 858,
			["coord"] = 1829473930,
		},
		[63497] = {
			"61122:60230:60952", -- [1]
			"61122:60230:59186", -- [2]
			"61122:60230:59186:59732", -- [3]
			"61122:60230:59186:59727", -- [4]
			"61122:60230:59186:59735:59733", -- [5]
			"61122:60230:59186:59735", -- [6]
			"61122:66227:59736", -- [7]
			"61122:66227", -- [8]
			"61122:60230", -- [9]
			"61122:60231", -- [10]
			"61122:60231:60232", -- [11]
			"61122:60231:59046", -- [12]
			"63501:58843", -- [13]
			"63501:58843:59047", -- [14]
			"63501:58843:65189", -- [15]
			"63501:58843:59047:60441", -- [16]
			"61122:61474", -- [17]
			"61122:61745:61118", -- [18]
			"61122:61745", -- [19]
			"61122:61745:61511", -- [20]
			"61512:60416:61504", -- [21]
			"61512:60416", -- [22]
			"63500:62903:61473", -- [23]
			"61122:62658:61759", -- [24]
			"61122:62658", -- [25]
			"63500:62903:62901", -- [26]
			"63500:62903", -- [27]
			"63500:62903:62898", -- [28]
			"63500:62903:62898:62909", -- [29]
			"61122:60230:59186:64310", -- [30]
			"63501:65511", -- [31]
			"63500:62903:65863", -- [32]
			"63501:58843:67785", -- [33]
			"61122:60230:59186:71939", -- [34]
			["direct"] = "61512:61122:63501:63498:63500",
			["f"] = 0,
			["m"] = 811,
			["coord"] = 603966146,
		},
		[63501] = {
			"58843:60231:60230:60952", -- [1]
			"58843:60231:60230:59186", -- [2]
			"58843:60231:60230:59186:59732", -- [3]
			"58843:60231:60230:59186:59727", -- [4]
			"58843:60231:60230:59186:59735:59733", -- [5]
			"58843:60231:60230:59186:59735", -- [6]
			"58843:60231:60230:60952:59736", -- [7]
			"61122:66227", -- [8]
			"58843:60231:60230", -- [9]
			"58843:60231", -- [10]
			"58843:60231:60232", -- [11]
			"58843:60231:59046", -- [12]
			"58843:65189", -- [13]
			"58843:59047:60441", -- [14]
			"61122:61474", -- [15]
			"63500:62903:61473:60416:61504:61118", -- [16]
			"63500:62903:61473:61745", -- [17]
			"63500:62903:61473:60416:61504:61511", -- [18]
			"63500:62903:61473:60416:61504", -- [19]
			"63500:62903:61473:60416", -- [20]
			"63500:62903:61473", -- [21]
			"63497:61512", -- [22]
			"58843:60231:62658:61759", -- [23]
			"58843:60231:62658", -- [24]
			"63500:62903:62901", -- [25]
			"63500:62903", -- [26]
			"63500:62903:62898", -- [27]
			"63500:62903:62898:62909", -- [28]
			"58843:60231:60230:59186:64310", -- [29]
			"63500:62903:65863", -- [30]
			"58843:67785", -- [31]
			"58843:60231:60230:59186:71939", -- [32]
			["m"] = 858,
			["f"] = 0,
			["direct"] = "58843:59047:61122:63498:63500:63497:65511",
			["coord"] = 2397264188,
		},
		[60416] = {
			"61745:61474:61759:60230:60952", -- [1]
			"61745:61474:61759:60230:59186", -- [2]
			"61745:61474:61759:60230:59186:59732", -- [3]
			"61745:61474:61759:60230:59186:59727", -- [4]
			"61745:61474:66227:59736:59735:59733", -- [5]
			"61745:61474:66227:59736:59735", -- [6]
			"61745:61474:66227:59736", -- [7]
			"61745:61474:66227", -- [8]
			"61745:61474:61759:60230", -- [9]
			"61745:61474:61759:62658:60231", -- [10]
			"61745:61474:60232", -- [11]
			"61745:61474:61759:62658:60231:59046", -- [12]
			"61473:62903:63500:63501:58843", -- [13]
			"61473:62903:63500:63501:58843:59047", -- [14]
			"61473:62903:63500:63501:58843:65189", -- [15]
			"61473:62903:63500:63501:58843:59047:60441", -- [16]
			"61745:61474", -- [17]
			"61504:61118", -- [18]
			"61504:61511", -- [19]
			"61745:61474:61759", -- [20]
			"61745:61474:61759:62658", -- [21]
			"61512:62901", -- [22]
			"61473:62903", -- [23]
			"61512:62901:62898", -- [24]
			"61512:62901:62898:62909", -- [25]
			"61745:61122", -- [26]
			"61473:62903:63500:63501", -- [27]
			"61473:62903:63500:63501:63498", -- [28]
			"61473:62903:63500", -- [29]
			"61512:63497", -- [30]
			"61745:61474:61759:60230:59186:64310", -- [31]
			"61473:62903:63500:63501:65511", -- [32]
			"61512:62901:65863", -- [33]
			"61473:62903:63500:63501:58843:67785", -- [34]
			"61745:61474:61759:60230:59186:71939", -- [35]
			["direct"] = "61745:61504:61473:61512",
			["f"] = 0,
			["m"] = 809,
			["coord"] = 1836691981,
		},
		[58843] = {
			"60231:60230:60952", -- [1]
			"60231:60230:59186", -- [2]
			"60231:60230:59186:59732", -- [3]
			"60231:60230:59186:59727", -- [4]
			"60231:60230:59186:59735:59733", -- [5]
			"60231:60230:59186:59735", -- [6]
			"60231:60230:60952:59736", -- [7]
			"60231:62658:61759:61474:66227", -- [8]
			"60231:60230", -- [9]
			"60231:60232", -- [10]
			"60231:59046", -- [11]
			"59047:60441", -- [12]
			"60231:62658:61759:61474", -- [13]
			"60231:62658:61759:61474:61118", -- [14]
			"60231:62658:61759:61474:61745", -- [15]
			"60231:62658:61759:61474:61118:61511", -- [16]
			"60231:62658:61759:61474:61504", -- [17]
			"63501:63500:62903:61473:60416", -- [18]
			"63501:63500:62903:61473", -- [19]
			"63501:63497:61512", -- [20]
			"60231:62658:61759", -- [21]
			"60231:62658", -- [22]
			"63501:63500:62903:62901", -- [23]
			"63501:63500:62903", -- [24]
			"63501:63500:62903:62898", -- [25]
			"63501:63500:62903:62898:62909", -- [26]
			"60231:61122", -- [27]
			"63501:63498", -- [28]
			"63501:63500", -- [29]
			"63501:63497", -- [30]
			"60231:60230:59186:64310", -- [31]
			"63501:65511", -- [32]
			"63501:63500:62903:65863", -- [33]
			"60231:60230:59186:71939", -- [34]
			["direct"] = "60231:59047:65189:63501:67785",
			["f"] = 0,
			["m"] = 807,
			["coord"] = 867145195,
		},
		[60231] = {
			"60230:60952", -- [1]
			"60230:59186", -- [2]
			"60230:59186:59732", -- [3]
			"60230:59186:59727", -- [4]
			"60230:59186:59735:59733", -- [5]
			"60230:59186:59735", -- [6]
			"60230:60952:59736", -- [7]
			"62658:61759:61474:66227", -- [8]
			"65189:59047", -- [9]
			"59046:60441", -- [10]
			"62658:61759:61474", -- [11]
			"62658:61759:61474:61118", -- [12]
			"62658:61759:61474:61745", -- [13]
			"62658:61759:61474:61118:61511", -- [14]
			"62658:61759:61474:61504", -- [15]
			"62658:61759:61474:61745:60416", -- [16]
			"62658:61759:61474:61745:61473", -- [17]
			"62658:61759:61474:61745:60416:61512", -- [18]
			"62658:61759", -- [19]
			"61122:65863:62901", -- [20]
			"61122:65863:62903", -- [21]
			"61122:65863:62901:62898", -- [22]
			"61122:65863:62901:62898:62909", -- [23]
			"58843:63501", -- [24]
			"58843:63501:63498", -- [25]
			"58843:63501:63500", -- [26]
			"61122:63497", -- [27]
			"60230:59186:64310", -- [28]
			"58843:63501:65511", -- [29]
			"61122:65863", -- [30]
			"58843:67785", -- [31]
			"60230:59186:71939", -- [32]
			["m"] = 807,
			["f"] = 0,
			["direct"] = "60230:60232:59046:58843:65189:62658:61122",
			["coord"] = 2423357661,
		},
		[61745] = {
			"61474:61759:60230:60952", -- [1]
			"61474:61759:60230:59186", -- [2]
			"61474:61759:60230:59186:59732", -- [3]
			"61474:61759:60230:59186:59727", -- [4]
			"61474:66227:59736:59735:59733", -- [5]
			"61474:66227:59736:59735", -- [6]
			"61474:66227:59736", -- [7]
			"61474:66227", -- [8]
			"61474:61759:60230", -- [9]
			"61474:61759:62658:60231", -- [10]
			"61474:60232", -- [11]
			"61474:61759:62658:60231:59046", -- [12]
			"61474:61759:62658:60231:58843", -- [13]
			"61474:61759:62658:60231:65189:59047", -- [14]
			"61474:61759:62658:60231:65189", -- [15]
			"61474:61759:62658:60231:59046:60441", -- [16]
			"60416:61512", -- [17]
			"61474:61759", -- [18]
			"61474:61759:62658", -- [19]
			"61473:62901", -- [20]
			"61473:62903", -- [21]
			"61473:62903:62898", -- [22]
			"61473:62903:62898:62909", -- [23]
			"61473:62903:63500:63501", -- [24]
			"61122:63497:63498", -- [25]
			"61473:62903:63500", -- [26]
			"61122:63497", -- [27]
			"61474:61759:60230:59186:64310", -- [28]
			"61473:62903:63500:63501:65511", -- [29]
			"61473:62903:65863", -- [30]
			"61474:61759:62658:60231:58843:67785", -- [31]
			"61474:61759:60230:59186:71939", -- [32]
			["m"] = 809,
			["f"] = 0,
			["direct"] = "61474:61118:61511:61504:60416:61473:61122",
			["coord"] = 2681982625,
			["requirements"] = "qid:30515"
		},
		[59733] = {
			"59735:59736:60952", -- [1]
			"59735:59186", -- [2]
			"59732:59727", -- [3]
			"59735:59736", -- [4]
			"59735:59736:66227", -- [5]
			"59735:59186:60230", -- [6]
			"59735:59186:60230:60231", -- [7]
			"59735:59186:60230:60232", -- [8]
			"59735:59186:60230:59046", -- [9]
			"59735:59186:60230:60231:58843", -- [10]
			"59735:59186:60230:59046:59047", -- [11]
			"59735:59186:60230:60231:65189", -- [12]
			"59735:59186:60230:59046:60441", -- [13]
			"59735:59736:66227:61474", -- [14]
			"59735:59736:66227:61474:61118", -- [15]
			"59735:59736:66227:61474:61745", -- [16]
			"59735:59736:66227:61474:61118:61511", -- [17]
			"59735:59736:66227:61474:61504", -- [18]
			"59735:59736:66227:61474:61745:60416", -- [19]
			"59735:59736:66227:61474:61745:61473", -- [20]
			"59735:59736:66227:61474:61745:60416:61512", -- [21]
			"59735:59186:60230:61759", -- [22]
			"59735:59186:60230:62658", -- [23]
			"59735:59736:66227:61474:61745:61473:62901", -- [24]
			"59735:59736:66227:61474:61745:61473:62903", -- [25]
			"59735:59736:66227:61474:61745:61473:62903:62898", -- [26]
			"59735:59736:66227:61474:61745:61473:62903:62898:62909", -- [27]
			"59735:59736:66227:61122", -- [28]
			"59735:59186:60230:60231:58843:63501", -- [29]
			"59735:59186:60230:60231:58843:63501:63498", -- [30]
			"59735:59736:66227:61474:61745:61473:62903:63500", -- [31]
			"59735:59736:66227:61122:63497", -- [32]
			"59735:59186:64310", -- [33]
			"59735:59186:60230:60231:58843:63501:65511", -- [34]
			"59735:59736:66227:61122:65863", -- [35]
			"59735:59186:60230:60231:58843:67785", -- [36]
			"59735:59186:71939", -- [37]
			["direct"] = "59732:59735",
			["f"] = 0,
			["m"] = 806,
			["coord"] = 2380414099,
		},
		[59735] = {
			"59736:60952", -- [1]
			"59186:59732", -- [2]
			"59186:59727", -- [3]
			"59736:66227", -- [4]
			"59186:60230", -- [5]
			"59186:60230:60231", -- [6]
			"59186:60230:60232", -- [7]
			"59186:60230:59046", -- [8]
			"59186:60230:60231:58843", -- [9]
			"59186:60230:59046:59047", -- [10]
			"59186:60230:60231:65189", -- [11]
			"59186:60230:59046:60441", -- [12]
			"59736:66227:61474", -- [13]
			"59736:66227:61474:61118", -- [14]
			"59736:66227:61474:61745", -- [15]
			"59736:66227:61474:61118:61511", -- [16]
			"59736:66227:61474:61504", -- [17]
			"59736:66227:61474:61745:60416", -- [18]
			"59736:66227:61474:61745:61473", -- [19]
			"59736:66227:61474:61745:60416:61512", -- [20]
			"59186:60230:61759", -- [21]
			"59186:60230:62658", -- [22]
			"59736:66227:61474:61745:61473:62901", -- [23]
			"59736:66227:61474:61745:61473:62903", -- [24]
			"59736:66227:61474:61745:61473:62903:62898", -- [25]
			"59736:66227:61474:61745:61473:62903:62898:62909", -- [26]
			"59736:66227:61122", -- [27]
			"59186:60230:60231:58843:63501", -- [28]
			"59186:60230:60231:58843:63501:63498", -- [29]
			"59736:66227:61474:61745:61473:62903:63500", -- [30]
			"59736:66227:61122:63497", -- [31]
			"59186:64310", -- [32]
			"59186:60230:60231:58843:63501:65511", -- [33]
			"59736:66227:61122:65863", -- [34]
			"59186:60230:60231:58843:67785", -- [35]
			"59186:71939", -- [36]
			["direct"] = "59186:59733:59736",
			["f"] = 0,
			["m"] = 806,
			["coord"] = 2184266964,
		},
		[59046] = {
			"60230:60952", -- [1]
			"60230:59186", -- [2]
			"60230:59186:59732", -- [3]
			"60230:59186:59727", -- [4]
			"60230:59186:59735:59733", -- [5]
			"60230:59186:59735", -- [6]
			"60230:60952:59736", -- [7]
			"60230:60952:66227", -- [8]
			"60231:58843", -- [9]
			"59047:65189", -- [10]
			"60231:62658:61759:61474", -- [11]
			"60231:62658:61759:61474:61118", -- [12]
			"60231:62658:61759:61474:61745", -- [13]
			"60231:62658:61759:61474:61118:61511", -- [14]
			"60231:62658:61759:61474:61504", -- [15]
			"60231:62658:61759:61474:61745:60416", -- [16]
			"60231:62658:61759:61474:61745:61473", -- [17]
			"60231:62658:61759:61474:61745:60416:61512", -- [18]
			"60231:62658:61759", -- [19]
			"60231:62658", -- [20]
			"60231:61122:65863:62901", -- [21]
			"60231:61122:65863:62903", -- [22]
			"60231:61122:65863:62901:62898", -- [23]
			"60231:61122:65863:62901:62898:62909", -- [24]
			"60231:61122", -- [25]
			"60231:58843:63501", -- [26]
			"60231:58843:63501:63498", -- [27]
			"60231:58843:63501:63500", -- [28]
			"60231:61122:63497", -- [29]
			"60230:59186:64310", -- [30]
			"60231:58843:63501:65511", -- [31]
			"60231:61122:65863", -- [32]
			"60231:58843:67785", -- [33]
			"60230:59186:71939", -- [34]
			["direct"] = "60230:60231:60232:59047:60441",
			["f"] = 0,
			["m"] = 857,
			["coord"] = 2543992551,
		},
		[61759] = {
			"60230:60952", -- [1]
			"60230:59186", -- [2]
			"60230:59186:59732", -- [3]
			"60230:59186:59727", -- [4]
			"60230:59186:59735:59733", -- [5]
			"60230:59186:59735", -- [6]
			"60230:60952:59736", -- [7]
			"61474:66227", -- [8]
			"62658:60231", -- [9]
			"60230:60232", -- [10]
			"62658:60231:59046", -- [11]
			"62658:60231:58843", -- [12]
			"62658:60231:65189:59047", -- [13]
			"62658:60231:65189", -- [14]
			"62658:60231:59046:60441", -- [15]
			"61474:61118", -- [16]
			"61474:61745", -- [17]
			"61474:61118:61511", -- [18]
			"61474:61504", -- [19]
			"61474:61745:60416", -- [20]
			"61474:61745:61473", -- [21]
			"61474:61745:60416:61512", -- [22]
			"61474:61745:61473:62901", -- [23]
			"61474:61745:61473:62903", -- [24]
			"61474:61745:61473:62903:62898", -- [25]
			"61474:61745:61473:62903:62898:62909", -- [26]
			"62658:61122", -- [27]
			"62658:60231:58843:63501", -- [28]
			"62658:60231:58843:63501:63498", -- [29]
			"61474:61745:61473:62903:63500", -- [30]
			"62658:61122:63497", -- [31]
			"60230:59186:64310", -- [32]
			"62658:60231:58843:63501:65511", -- [33]
			"62658:61122:65863", -- [34]
			"62658:60231:58843:67785", -- [35]
			"60230:59186:71939", -- [36]
			["direct"] = "60230:61474:62658",
			["f"] = 0,
			["m"] = 873,
			["coord"] = 2433139115,
		},
		[61511] = {
			"61745:61474:61759:60230:60952", -- [1]
			"61745:61474:61759:60230:59186", -- [2]
			"61745:61474:61759:60230:59186:59732", -- [3]
			"61745:61474:61759:60230:59186:59727", -- [4]
			"61745:61474:66227:59736:59735:59733", -- [5]
			"61745:61474:66227:59736:59735", -- [6]
			"61745:61474:66227:59736", -- [7]
			"61745:61474:66227", -- [8]
			"61745:61474:61759:60230", -- [9]
			"61745:61474:61759:62658:60231", -- [10]
			"61745:61474:60232", -- [11]
			"61745:61474:61759:62658:60231:59046", -- [12]
			"61745:61474:61759:62658:60231:58843", -- [13]
			"61745:61474:61759:62658:60231:65189:59047", -- [14]
			"61745:61474:61759:62658:60231:65189", -- [15]
			"61745:61474:61759:62658:60231:59046:60441", -- [16]
			"61745:61474", -- [17]
			"61504:60416", -- [18]
			"61745:61473", -- [19]
			"61504:60416:61512", -- [20]
			"61745:61474:61759", -- [21]
			"61745:61474:61759:62658", -- [22]
			"61504:60416:61512:62901", -- [23]
			"61745:61473:62903", -- [24]
			"61745:61473:62903:62898", -- [25]
			"61745:61473:62903:62898:62909", -- [26]
			"61745:61122", -- [27]
			"61745:61473:62903:63500:63501", -- [28]
			"61745:61122:63497:63498", -- [29]
			"61745:61473:62903:63500", -- [30]
			"61745:61122:63497", -- [31]
			"61745:61474:61759:60230:59186:64310", -- [32]
			"61745:61473:62903:63500:63501:65511", -- [33]
			"61745:61473:62903:65863", -- [34]
			"61745:61474:61759:62658:60231:58843:67785", -- [35]
			"61745:61474:61759:60230:59186:71939", -- [36]
			["direct"] = "61118:61745:61504",
			["f"] = 0,
			["m"] = 809,
			["coord"] = 2681621770,
		},
		[62901] = {
			"61473:61745:61474:61759:60230:60952", -- [1]
			"61473:61745:61474:61759:60230:59186", -- [2]
			"61473:61745:61474:61759:60230:59186:59732", -- [3]
			"61473:61745:61474:61759:60230:59186:59727", -- [4]
			"61473:61745:61474:66227:59736:59735:59733", -- [5]
			"61473:61745:61474:66227:59736:59735", -- [6]
			"61473:61745:61474:66227:59736", -- [7]
			"61473:61745:61474:66227", -- [8]
			"61473:61745:61474:61759:60230", -- [9]
			"65863:61122:60231", -- [10]
			"61473:61745:61474:60232", -- [11]
			"65863:61122:60231:59046", -- [12]
			"62903:63500:63501:58843", -- [13]
			"62903:63500:63501:58843:59047", -- [14]
			"62903:63500:63501:58843:65189", -- [15]
			"62903:63500:63501:58843:59047:60441", -- [16]
			"61473:61745:61474", -- [17]
			"61512:60416:61504:61118", -- [18]
			"61473:61745", -- [19]
			"61512:60416:61504:61511", -- [20]
			"61512:60416:61504", -- [21]
			"61512:60416", -- [22]
			"61473:61745:61474:61759", -- [23]
			"61473:61745:61474:61759:62658", -- [24]
			"62898:62909", -- [25]
			"65863:61122", -- [26]
			"62903:63500:63501", -- [27]
			"62903:63500:63501:63498", -- [28]
			"62903:63500", -- [29]
			"62903:63500:63497", -- [30]
			"61473:61745:61474:61759:60230:59186:64310", -- [31]
			"62903:63500:63501:65511", -- [32]
			"62903:63500:63501:58843:67785", -- [33]
			"61473:61745:61474:61759:60230:59186:71939", -- [34]
			["direct"] = "61473:61512:62903:62898:65863",
			["f"] = 0,
			["m"] = 810,
			["coord"] = 3054277351,
		},
		[62903] = {
			"61473:61745:61474:61759:60230:60952", -- [1]
			"61473:61745:61474:61759:60230:59186", -- [2]
			"61473:61745:61474:61759:60230:59186:59732", -- [3]
			"61473:61745:61474:61759:60230:59186:59727", -- [4]
			"61473:61745:61474:66227:59736:59735:59733", -- [5]
			"61473:61745:61474:66227:59736:59735", -- [6]
			"61473:61745:61474:66227:59736", -- [7]
			"61473:61745:61474:66227", -- [8]
			"61473:61745:61474:61759:60230", -- [9]
			"63500:63501:58843:60231", -- [10]
			"61473:61745:61474:60232", -- [11]
			"63500:63501:58843:60231:59046", -- [12]
			"63500:63501:58843", -- [13]
			"63500:63501:58843:59047", -- [14]
			"63500:63501:58843:65189", -- [15]
			"63500:63501:58843:59047:60441", -- [16]
			"61473:61745:61474", -- [17]
			"61473:60416:61504:61118", -- [18]
			"61473:61745", -- [19]
			"61473:60416:61504:61511", -- [20]
			"61473:60416:61504", -- [21]
			"61473:60416", -- [22]
			"62901:61512", -- [23]
			"61473:61745:61474:61759", -- [24]
			"61473:61745:61474:61759:62658", -- [25]
			"62898:62909", -- [26]
			"65863:61122", -- [27]
			"63500:63501", -- [28]
			"63500:63501:63498", -- [29]
			"63500:63497", -- [30]
			"61473:61745:61474:61759:60230:59186:64310", -- [31]
			"63500:63501:65511", -- [32]
			"63500:63501:58843:67785", -- [33]
			"61473:61745:61474:61759:60230:59186:71939", -- [34]
			["direct"] = "61473:62901:62898:63500:65863",
			["f"] = 0,
			["m"] = 810,
			["coord"] = 3196440685,
		},
		[60952] = {
			"59186:59732", -- [1]
			"59186:59727", -- [2]
			"59736:59735:59733", -- [3]
			"59736:59735", -- [4]
			"60230:60231", -- [5]
			"60230:60232", -- [6]
			"60230:59046", -- [7]
			"60230:60231:58843", -- [8]
			"60230:59046:59047", -- [9]
			"60230:60231:65189", -- [10]
			"60230:59046:60441", -- [11]
			"60230:61759:61474", -- [12]
			"60230:61759:61474:61118", -- [13]
			"60230:61759:61474:61745", -- [14]
			"60230:61759:61474:61118:61511", -- [15]
			"60230:61759:61474:61504", -- [16]
			"60230:61759:61474:61745:60416", -- [17]
			"60230:61759:61474:61745:61473", -- [18]
			"60230:61759:61474:61745:60416:61512", -- [19]
			"60230:61759", -- [20]
			"60230:62658", -- [21]
			"60230:62658:61122:65863:62901", -- [22]
			"60230:61759:61474:61745:61473:62903", -- [23]
			"60230:61759:61474:61745:61473:62903:62898", -- [24]
			"60230:61759:61474:61745:61473:62903:62898:62909", -- [25]
			"60230:62658:61122", -- [26]
			"60230:60231:58843:63501", -- [27]
			"60230:60231:58843:63501:63498", -- [28]
			"60230:62658:61122:63500", -- [29]
			"60230:62658:61122:63497", -- [30]
			"60230:60231:58843:63501:65511", -- [31]
			"60230:62658:61122:65863", -- [32]
			"60230:60231:58843:67785", -- [33]
			"59186:71939", -- [34]
			["direct"] = "59186:59736:66227:60230:64310",
			["f"] = 0,
			["m"] = 806,
			["coord"] = 1193048794,
			["requirements"] = "qid:29935"
		},
		[62909] = {
			"62898:62903:61473:61745:61474:61759:60230:60952", -- [1]
			"62898:62903:61473:61745:61474:61759:60230:59186", -- [2]
			"62898:62903:61473:61745:61474:61759:60230:59186:59732", -- [3]
			"62898:62903:61473:61745:61474:61759:60230:59186:59727", -- [4]
			"62898:62903:61473:61745:61474:66227:59736:59735:59733", -- [5]
			"62898:62903:61473:61745:61474:66227:59736:59735", -- [6]
			"62898:62903:61473:61745:61474:66227:59736", -- [7]
			"62898:62903:61473:61745:61474:66227", -- [8]
			"62898:62903:61473:61745:61474:61759:60230", -- [9]
			"62898:62903:63500:63501:58843:60231", -- [10]
			"62898:62903:61473:61745:61474:60232", -- [11]
			"62898:62903:63500:63501:58843:60231:59046", -- [12]
			"62898:62903:63500:63501:58843", -- [13]
			"62898:62903:63500:63501:58843:59047", -- [14]
			"62898:62903:63500:63501:58843:65189", -- [15]
			"62898:62903:63500:63501:58843:59047:60441", -- [16]
			"62898:62903:61473:61745:61474", -- [17]
			"62898:62901:61512:60416:61504:61118", -- [18]
			"62898:62903:61473:61745", -- [19]
			"62898:62901:61512:60416:61504:61511", -- [20]
			"62898:62901:61512:60416:61504", -- [21]
			"62898:62901:61512:60416", -- [22]
			"62898:62903:61473", -- [23]
			"62898:62901:61512", -- [24]
			"62898:62903:61473:61745:61474:61759", -- [25]
			"62898:62903:61473:61745:61474:61759:62658", -- [26]
			"62898:62901", -- [27]
			"62898:62903", -- [28]
			"62898:62903:65863:61122", -- [29]
			"62898:62903:63500:63501", -- [30]
			"62898:62903:63500:63501:63498", -- [31]
			"62898:62903:63500", -- [32]
			"62898:62903:63500:63497", -- [33]
			"62898:62903:61473:61745:61474:61759:60230:59186:64310", -- [34]
			"62898:62903:63500:63501:65511", -- [35]
			"62898:62903:65863", -- [36]
			"62898:62903:63500:63501:58843:67785", -- [37]
			"62898:62903:61473:61745:61474:61759:60230:59186:71939", -- [38]
			["direct"] = "62898",
			["f"] = 0,
			["m"] = 810,
			["coord"] = 2149759023,
		},
		[65189] = {
			"60231:60230:60952", -- [1]
			"60231:60230:59186", -- [2]
			"60231:60230:59186:59732", -- [3]
			"60231:60230:59186:59727", -- [4]
			"60231:60230:59186:59735:59733", -- [5]
			"60231:60230:59186:59735", -- [6]
			"60231:60230:60952:59736", -- [7]
			"60231:62658:61759:61474:66227", -- [8]
			"60231:60230", -- [9]
			"59047:59046:60232", -- [10]
			"59047:59046", -- [11]
			"60231:62658:61759:61474", -- [12]
			"60231:62658:61759:61474:61118", -- [13]
			"60231:62658:61759:61474:61745", -- [14]
			"60231:62658:61759:61474:61118:61511", -- [15]
			"60231:62658:61759:61474:61504", -- [16]
			"59047:63501:63500:62903:61473:60416", -- [17]
			"59047:63501:63500:62903:61473", -- [18]
			"59047:63501:63497:61512", -- [19]
			"60231:62658:61759", -- [20]
			"60231:62658", -- [21]
			"59047:63501:63500:62903:62901", -- [22]
			"59047:63501:63500:62903", -- [23]
			"59047:63501:63500:62903:62898", -- [24]
			"59047:63501:63500:62903:62898:62909", -- [25]
			"60231:61122", -- [26]
			"59047:63501", -- [27]
			"59047:63501:63498", -- [28]
			"59047:63501:63500", -- [29]
			"59047:63501:63497", -- [30]
			"60231:60230:59186:64310", -- [31]
			"59047:63501:65511", -- [32]
			"59047:63501:63500:62903:65863", -- [33]
			"59047:67785", -- [34]
			"60231:60230:59186:71939", -- [35]
			["direct"] = "60231:58843:59047:60441",
			["f"] = 0,
			["m"] = 857,
			["coord"] = 1341694345,
		},
		[61474] = {
			"61759:60230:60952", -- [1]
			"61759:60230:59186", -- [2]
			"61759:60230:59186:59732", -- [3]
			"61759:60230:59186:59727", -- [4]
			"66227:59736:59735:59733", -- [5]
			"66227:59736:59735", -- [6]
			"66227:59736", -- [7]
			"61759:60230", -- [8]
			"61759:62658:60231", -- [9]
			"61759:62658:60231:59046", -- [10]
			"61759:62658:60231:58843", -- [11]
			"61759:62658:60231:65189:59047", -- [12]
			"61759:62658:60231:65189", -- [13]
			"61759:62658:60231:59046:60441", -- [14]
			"61118:61511", -- [15]
			"61745:60416", -- [16]
			"61745:61473", -- [17]
			"61745:60416:61512", -- [18]
			"61759:62658", -- [19]
			"61745:61473:62901", -- [20]
			"61745:61473:62903", -- [21]
			"61745:61473:62903:62898", -- [22]
			"61745:61473:62903:62898:62909", -- [23]
			"61745:61473:62903:63500:63501", -- [24]
			"61122:63497:63498", -- [25]
			"61745:61473:62903:63500", -- [26]
			"61122:63497", -- [27]
			"61759:60230:59186:64310", -- [28]
			"61745:61473:62903:63500:63501:65511", -- [29]
			"61745:61473:62903:65863", -- [30]
			"61759:62658:60231:58843:67785", -- [31]
			"61759:60230:59186:71939", -- [32]
			["m"] = 809,
			["f"] = 0,
			["direct"] = "66227:60232:61118:61745:61504:61759:61122",
			["coord"] = 3112759555,
		},
		[62898] = {
			"62903:61473:61745:61474:61759:60230:60952", -- [1]
			"62903:61473:61745:61474:61759:60230:59186", -- [2]
			"62903:61473:61745:61474:61759:60230:59186:59732", -- [3]
			"62903:61473:61745:61474:61759:60230:59186:59727", -- [4]
			"62903:61473:61745:61474:66227:59736:59735:59733", -- [5]
			"62903:61473:61745:61474:66227:59736:59735", -- [6]
			"62903:61473:61745:61474:66227:59736", -- [7]
			"62903:61473:61745:61474:66227", -- [8]
			"62903:61473:61745:61474:61759:60230", -- [9]
			"62903:63500:63501:58843:60231", -- [10]
			"62903:61473:61745:61474:60232", -- [11]
			"62903:63500:63501:58843:60231:59046", -- [12]
			"62903:63500:63501:58843", -- [13]
			"62903:63500:63501:58843:59047", -- [14]
			"62903:63500:63501:58843:65189", -- [15]
			"62903:63500:63501:58843:59047:60441", -- [16]
			"62903:61473:61745:61474", -- [17]
			"62901:61512:60416:61504:61118", -- [18]
			"62903:61473:61745", -- [19]
			"62901:61512:60416:61504:61511", -- [20]
			"62901:61512:60416:61504", -- [21]
			"62901:61512:60416", -- [22]
			"62903:61473", -- [23]
			"62901:61512", -- [24]
			"62903:61473:61745:61474:61759", -- [25]
			"62903:61473:61745:61474:61759:62658", -- [26]
			"62903:65863:61122", -- [27]
			"62903:63500:63501", -- [28]
			"62903:63500:63501:63498", -- [29]
			"62903:63500", -- [30]
			"62903:63500:63497", -- [31]
			"62903:61473:61745:61474:61759:60230:59186:64310", -- [32]
			"62903:63500:63501:65511", -- [33]
			"62903:65863", -- [34]
			"62903:63500:63501:58843:67785", -- [35]
			"62903:61473:61745:61474:61759:60230:59186:71939", -- [36]
			["direct"] = "62901:62903:62909",
			["f"] = 0,
			["m"] = 810,
			["coord"] = 2329659992,
		},
		[59047] = {
			"59046:60230:60952", -- [1]
			"59046:60230:59186", -- [2]
			"59046:60230:59186:59732", -- [3]
			"59046:60230:59186:59727", -- [4]
			"59046:60230:59186:59735:59733", -- [5]
			"59046:60230:59186:59735", -- [6]
			"59046:60230:60952:59736", -- [7]
			"59046:60230:60952:66227", -- [8]
			"59046:60230", -- [9]
			"59046:60231", -- [10]
			"59046:60232", -- [11]
			"59046:60231:62658:61759:61474", -- [12]
			"59046:60231:62658:61759:61474:61118", -- [13]
			"59046:60231:62658:61759:61474:61745", -- [14]
			"59046:60231:62658:61759:61474:61118:61511", -- [15]
			"59046:60231:62658:61759:61474:61504", -- [16]
			"63501:63500:62903:61473:60416", -- [17]
			"63501:63500:62903:61473", -- [18]
			"63501:63497:61512", -- [19]
			"59046:60231:62658:61759", -- [20]
			"59046:60231:62658", -- [21]
			"63501:63500:62903:62901", -- [22]
			"63501:63500:62903", -- [23]
			"63501:63500:62903:62898", -- [24]
			"63501:63500:62903:62898:62909", -- [25]
			"59046:60231:61122", -- [26]
			"63501:63498", -- [27]
			"63501:63500", -- [28]
			"63501:63497", -- [29]
			"59046:60230:59186:64310", -- [30]
			"63501:65511", -- [31]
			"63501:63500:62903:65863", -- [32]
			"59046:60230:59186:71939", -- [33]
			["direct"] = "59046:58843:65189:60441:63501:67785",
			["f"] = 0,
			["m"] = 857,
			["coord"] = 1243906315,
		},
		[63498] = {
			"63501:58843:60231:60230:60952", -- [1]
			"63501:58843:60231:60230:59186", -- [2]
			"63501:58843:60231:60230:59186:59732", -- [3]
			"63501:58843:60231:60230:59186:59727", -- [4]
			"63501:58843:60231:60230:59186:59735:59733", -- [5]
			"63501:58843:60231:60230:59186:59735", -- [6]
			"63501:58843:60231:60230:60952:59736", -- [7]
			"63497:61122:66227", -- [8]
			"63501:58843:60231:60230", -- [9]
			"63501:58843:60231", -- [10]
			"63501:58843:60231:60232", -- [11]
			"63501:58843:60231:59046", -- [12]
			"63501:58843", -- [13]
			"63501:58843:59047", -- [14]
			"63501:58843:65189", -- [15]
			"63501:58843:59047:60441", -- [16]
			"63497:61122:61474", -- [17]
			"63497:61122:61745:61118", -- [18]
			"63497:61122:61745", -- [19]
			"63497:61122:61745:61511", -- [20]
			"63501:63500:62903:61473:60416:61504", -- [21]
			"63501:63500:62903:61473:60416", -- [22]
			"63501:63500:62903:61473", -- [23]
			"63497:61512", -- [24]
			"63501:58843:60231:62658:61759", -- [25]
			"63501:58843:60231:62658", -- [26]
			"63501:63500:62903:62901", -- [27]
			"63501:63500:62903", -- [28]
			"63501:63500:62903:62898", -- [29]
			"63501:63500:62903:62898:62909", -- [30]
			"63497:61122", -- [31]
			"63501:63500", -- [32]
			"63501:58843:60231:60230:59186:64310", -- [33]
			"63501:63500:62903:65863", -- [34]
			"63501:58843:67785", -- [35]
			"63501:58843:60231:60230:59186:71939", -- [36]
			["direct"] = "63501:63497:65511",
			["f"] = 0,
			["m"] = 858,
			["coord"] = 2410197898,
		},
		[63500] = {
			"63501:58843:60231:60230:60952", -- [1]
			"63501:58843:60231:60230:59186", -- [2]
			"63501:58843:60231:60230:59186:59732", -- [3]
			"63501:58843:60231:60230:59186:59727", -- [4]
			"62903:61473:61745:61474:66227:59736:59735:59733", -- [5]
			"62903:61473:61745:61474:66227:59736:59735", -- [6]
			"62903:61473:61745:61474:66227:59736", -- [7]
			"62903:61473:61745:61474:66227", -- [8]
			"63501:58843:60231:60230", -- [9]
			"63501:58843:60231", -- [10]
			"63501:58843:60231:60232", -- [11]
			"63501:58843:60231:59046", -- [12]
			"63501:58843", -- [13]
			"63501:58843:59047", -- [14]
			"63501:58843:65189", -- [15]
			"63501:58843:59047:60441", -- [16]
			"62903:61473:61745:61474", -- [17]
			"62903:61473:60416:61504:61118", -- [18]
			"62903:61473:61745", -- [19]
			"62903:61473:60416:61504:61511", -- [20]
			"62903:61473:60416:61504", -- [21]
			"62903:61473:60416", -- [22]
			"62903:61473", -- [23]
			"62903:62901:61512", -- [24]
			"63501:58843:60231:62658:61759", -- [25]
			"63501:58843:60231:62658", -- [26]
			"62903:62901", -- [27]
			"62903:62898", -- [28]
			"62903:62898:62909", -- [29]
			"63501:63498", -- [30]
			"63501:58843:60231:60230:59186:64310", -- [31]
			"63501:65511", -- [32]
			"62903:65863", -- [33]
			"63501:58843:67785", -- [34]
			"63501:58843:60231:60230:59186:71939", -- [35]
			["direct"] = "62903:61122:63501:63497",
			["f"] = 0,
			["m"] = 858,
			["coord"] = 2156863265,
		},
		[59727] = {
			"59186:60952", -- [1]
			"59732:59733", -- [2]
			"59186:59735", -- [3]
			"59186:59736", -- [4]
			"59186:66227", -- [5]
			"59186:60230", -- [6]
			"59186:60230:60231", -- [7]
			"59186:60230:60232", -- [8]
			"59186:60230:59046", -- [9]
			"59186:60230:60231:58843", -- [10]
			"59186:60230:59046:59047", -- [11]
			"59186:60230:60231:65189", -- [12]
			"59186:60230:59046:60441", -- [13]
			"59186:60230:61759:61474", -- [14]
			"59186:60230:61759:61474:61118", -- [15]
			"59186:60230:61759:61474:61745", -- [16]
			"59186:60230:61759:61474:61118:61511", -- [17]
			"59186:60230:61759:61474:61504", -- [18]
			"59186:60230:61759:61474:61745:60416", -- [19]
			"59186:60230:61759:61474:61745:61473", -- [20]
			"59186:60230:61759:61474:61745:60416:61512", -- [21]
			"59186:60230:61759", -- [22]
			"59186:60230:62658", -- [23]
			"59186:61122:65863:62901", -- [24]
			"59186:60230:61759:61474:61745:61473:62903", -- [25]
			"59186:60230:61759:61474:61745:61473:62903:62898", -- [26]
			"59186:60230:61759:61474:61745:61473:62903:62898:62909", -- [27]
			"59186:61122", -- [28]
			"59186:60230:60231:58843:63501", -- [29]
			"59186:60230:60231:58843:63501:63498", -- [30]
			"59186:61122:63500", -- [31]
			"59186:61122:63497", -- [32]
			"59186:64310", -- [33]
			"59186:60230:60231:58843:63501:65511", -- [34]
			"59186:61122:65863", -- [35]
			"59186:60230:60231:58843:67785", -- [36]
			"59186:71939", -- [37]
			["direct"] = "59186:59732",
			["f"] = 0,
			["m"] = 806,
			["coord"] = 2343935577,
		},
		[60441] = {
			"59046:60230:60952", -- [1]
			"59046:60230:59186", -- [2]
			"59046:60230:59186:59732", -- [3]
			"59046:60230:59186:59727", -- [4]
			"59046:60230:59186:59735:59733", -- [5]
			"59046:60230:59186:59735", -- [6]
			"59046:60230:60952:59736", -- [7]
			"59046:60230:60952:66227", -- [8]
			"59046:60230", -- [9]
			"59046:60231", -- [10]
			"59046:60232", -- [11]
			"65189:58843", -- [12]
			"59046:60231:62658:61759:61474", -- [13]
			"59046:60231:62658:61759:61474:61118", -- [14]
			"59046:60231:62658:61759:61474:61745", -- [15]
			"59046:60231:62658:61759:61474:61118:61511", -- [16]
			"59046:60231:62658:61759:61474:61504", -- [17]
			"59046:60231:62658:61759:61474:61745:60416", -- [18]
			"59046:60231:62658:61759:61474:61745:61473", -- [19]
			"59046:60231:62658:61759:61474:61745:60416:61512", -- [20]
			"59046:60231:62658:61759", -- [21]
			"59046:60231:62658", -- [22]
			"59046:60231:61122:65863:62901", -- [23]
			"59047:63501:63500:62903", -- [24]
			"59047:63501:63500:62903:62898", -- [25]
			"59047:63501:63500:62903:62898:62909", -- [26]
			"59046:60231:61122", -- [27]
			"59047:63501", -- [28]
			"59047:63501:63498", -- [29]
			"59047:63501:63500", -- [30]
			"59047:63501:63497", -- [31]
			"59046:60230:59186:64310", -- [32]
			"59047:63501:65511", -- [33]
			"59046:60231:61122:65863", -- [34]
			"59047:67785", -- [35]
			"59046:60230:59186:71939", -- [36]
			["direct"] = "59046:59047:65189",
			["f"] = 0,
			["m"] = 857,
			["coord"] = 2250687510,
		},
		[60230] = {
			"59186:59732", -- [1]
			"59186:59727", -- [2]
			"59186:59735:59733", -- [3]
			"59186:59735", -- [4]
			"60952:59736", -- [5]
			"60952:66227", -- [6]
			"60231:58843", -- [7]
			"59046:59047", -- [8]
			"60231:65189", -- [9]
			"59046:60441", -- [10]
			"61759:61474", -- [11]
			"61759:61474:61118", -- [12]
			"61759:61474:61745", -- [13]
			"61759:61474:61118:61511", -- [14]
			"61759:61474:61504", -- [15]
			"61759:61474:61745:60416", -- [16]
			"61759:61474:61745:61473", -- [17]
			"61759:61474:61745:60416:61512", -- [18]
			"62658:61122:65863:62901", -- [19]
			"61759:61474:61745:61473:62903", -- [20]
			"61759:61474:61745:61473:62903:62898", -- [21]
			"61759:61474:61745:61473:62903:62898:62909", -- [22]
			"60231:58843:63501", -- [23]
			"60231:58843:63501:63498", -- [24]
			"62658:61122:63500", -- [25]
			"62658:61122:63497", -- [26]
			"59186:64310", -- [27]
			"60231:58843:63501:65511", -- [28]
			"62658:61122:65863", -- [29]
			"60231:58843:67785", -- [30]
			"59186:71939", -- [31]
			["m"] = 807,
			["f"] = 0,
			["direct"] = "60952:59186:60231:60232:59046:61759:62658:61122",
			["coord"] = 3629594111,
		},
		[60232] = {
			"60230:60952", -- [1]
			"60230:59186", -- [2]
			"60230:59186:59732", -- [3]
			"60230:59186:59727", -- [4]
			"60230:59186:59735:59733", -- [5]
			"60230:59186:59735", -- [6]
			"60230:60952:59736", -- [7]
			"60230:60952:66227", -- [8]
			"60231:58843", -- [9]
			"59046:59047", -- [10]
			"60231:65189", -- [11]
			"59046:60441", -- [12]
			"61474:61118", -- [13]
			"61474:61745", -- [14]
			"61474:61118:61511", -- [15]
			"61474:61504", -- [16]
			"61474:61745:60416", -- [17]
			"61474:61745:61473", -- [18]
			"61474:61745:60416:61512", -- [19]
			"60230:61759", -- [20]
			"60230:62658", -- [21]
			"61474:61745:61473:62901", -- [22]
			"61474:61745:61473:62903", -- [23]
			"61474:61745:61473:62903:62898", -- [24]
			"61474:61745:61473:62903:62898:62909", -- [25]
			"60231:61122", -- [26]
			"60231:58843:63501", -- [27]
			"60231:58843:63501:63498", -- [28]
			"60231:58843:63501:63500", -- [29]
			"60231:61122:63497", -- [30]
			"60230:59186:64310", -- [31]
			"60231:58843:63501:65511", -- [32]
			"60231:61122:65863", -- [33]
			"60231:58843:67785", -- [34]
			"60230:59186:71939", -- [35]
			["direct"] = "60230:60231:59046:61474",
			["f"] = 0,
			["m"] = 857,
			["coord"] = 3294762427,
		},
		[61122] = {
			"60230:60952", -- [1]
			"60230:59186:59732", -- [2]
			"60230:59186:59727", -- [3]
			"60230:59186:59735:59733", -- [4]
			"60230:59186:59735", -- [5]
			"66227:59736", -- [6]
			"60231:60232", -- [7]
			"60231:59046", -- [8]
			"60231:58843", -- [9]
			"60231:65189:59047", -- [10]
			"60231:65189", -- [11]
			"60231:59046:60441", -- [12]
			"61745:61118", -- [13]
			"61745:61511", -- [14]
			"61745:61504", -- [15]
			"61745:60416", -- [16]
			"61745:61473", -- [17]
			"65863:62901:61512", -- [18]
			"62658:61759", -- [19]
			"65863:62901", -- [20]
			"65863:62903", -- [21]
			"65863:62901:62898", -- [22]
			"65863:62901:62898:62909", -- [23]
			"63497:63498", -- [24]
			"60230:59186:64310", -- [25]
			"63501:65511", -- [26]
			"60231:58843:67785", -- [27]
			"60230:59186:71939", -- [28]
			["m"] = 811,
			["coord"] = 2696492934,
			["direct"] = "59186:66227:60230:60231:61474:61745:62658:63501:63500:63497:65863",
			["f"] = 0,
		},
		[59732] = {
			"59186:60952", -- [1]
			"59186:59735", -- [2]
			"59186:59736", -- [3]
			"59186:66227", -- [4]
			"59186:60230", -- [5]
			"59186:60230:60231", -- [6]
			"59186:60230:60232", -- [7]
			"59186:60230:59046", -- [8]
			"59186:60230:60231:58843", -- [9]
			"59186:60230:59046:59047", -- [10]
			"59186:60230:60231:65189", -- [11]
			"59186:60230:59046:60441", -- [12]
			"59186:60230:61759:61474", -- [13]
			"59186:60230:61759:61474:61118", -- [14]
			"59186:60230:61759:61474:61745", -- [15]
			"59186:60230:61759:61474:61118:61511", -- [16]
			"59186:60230:61759:61474:61504", -- [17]
			"59186:60230:61759:61474:61745:60416", -- [18]
			"59186:60230:61759:61474:61745:61473", -- [19]
			"59186:60230:61759:61474:61745:60416:61512", -- [20]
			"59186:60230:61759", -- [21]
			"59186:60230:62658", -- [22]
			"59186:61122:65863:62901", -- [23]
			"59186:60230:61759:61474:61745:61473:62903", -- [24]
			"59186:60230:61759:61474:61745:61473:62903:62898", -- [25]
			"59186:60230:61759:61474:61745:61473:62903:62898:62909", -- [26]
			"59186:61122", -- [27]
			"59186:60230:60231:58843:63501", -- [28]
			"59186:60230:60231:58843:63501:63498", -- [29]
			"59186:61122:63500", -- [30]
			"59186:61122:63497", -- [31]
			"59186:64310", -- [32]
			"59186:60230:60231:58843:63501:65511", -- [33]
			"59186:61122:65863", -- [34]
			"59186:60230:60231:58843:67785", -- [35]
			"59186:71939", -- [36]
			["direct"] = "59186:59727:59733",
			["f"] = 0,
			["m"] = 806,
			["coord"] = 2449240278,
		},
		[66227] = {
			"59186:59732", -- [1]
			"59186:59727", -- [2]
			"59736:59735:59733", -- [3]
			"59736:59735", -- [4]
			"60952:60230", -- [5]
			"61474:61759:62658:60231", -- [6]
			"60952:60230:60232", -- [7]
			"60952:60230:59046", -- [8]
			"61474:61759:62658:60231:58843", -- [9]
			"61474:61759:62658:60231:65189:59047", -- [10]
			"61474:61759:62658:60231:65189", -- [11]
			"60952:60230:59046:60441", -- [12]
			"61474:61118", -- [13]
			"61474:61745", -- [14]
			"61474:61118:61511", -- [15]
			"61474:61504", -- [16]
			"61474:61745:60416", -- [17]
			"61474:61745:61473", -- [18]
			"61474:61745:60416:61512", -- [19]
			"61474:61759", -- [20]
			"61474:61759:62658", -- [21]
			"61474:61745:61473:62901", -- [22]
			"61474:61745:61473:62903", -- [23]
			"61474:61745:61473:62903:62898", -- [24]
			"61474:61745:61473:62903:62898:62909", -- [25]
			"61122:63501", -- [26]
			"61122:63497:63498", -- [27]
			"61474:61745:61473:62903:63500", -- [28]
			"61122:63497", -- [29]
			"59186:64310", -- [30]
			"61122:63501:65511", -- [31]
			"61122:65863", -- [32]
			"61474:61759:62658:60231:58843:67785", -- [33]
			"59186:71939", -- [34]
			["direct"] = "60952:59186:59736:61474:61122",
			["f"] = 0,
			["m"] = 806,
			["coord"] = 1206200287,
		},
		[59736] = {
			"59186:59732", -- [1]
			"59186:59727", -- [2]
			"59735:59733", -- [3]
			"60952:60230", -- [4]
			"60952:60230:60231", -- [5]
			"60952:60230:60232", -- [6]
			"60952:60230:59046", -- [7]
			"60952:60230:60231:58843", -- [8]
			"60952:60230:59046:59047", -- [9]
			"60952:60230:60231:65189", -- [10]
			"60952:60230:59046:60441", -- [11]
			"66227:61474", -- [12]
			"66227:61474:61118", -- [13]
			"66227:61474:61745", -- [14]
			"66227:61474:61118:61511", -- [15]
			"66227:61474:61504", -- [16]
			"66227:61474:61745:60416", -- [17]
			"66227:61474:61745:61473", -- [18]
			"66227:61474:61745:60416:61512", -- [19]
			"60952:60230:61759", -- [20]
			"60952:60230:62658", -- [21]
			"66227:61474:61745:61473:62901", -- [22]
			"66227:61474:61745:61473:62903", -- [23]
			"66227:61474:61745:61473:62903:62898", -- [24]
			"66227:61474:61745:61473:62903:62898:62909", -- [25]
			"66227:61122", -- [26]
			"60952:60230:60231:58843:63501", -- [27]
			"66227:61122:63497:63498", -- [28]
			"66227:61474:61745:61473:62903:63500", -- [29]
			"66227:61122:63497", -- [30]
			"59186:64310", -- [31]
			"60952:60230:60231:58843:63501:65511", -- [32]
			"66227:61122:65863", -- [33]
			"60952:60230:60231:58843:67785", -- [34]
			"59186:71939", -- [35]
			["direct"] = "60952:59186:59735:66227",
			["f"] = 0,
			["m"] = 806,
			["coord"] = 1871527691,
		},
		[61118] = {
			"61474:61759:60230:60952", -- [1]
			"61474:61759:60230:59186", -- [2]
			"61474:61759:60230:59186:59732", -- [3]
			"61474:61759:60230:59186:59727", -- [4]
			"61474:66227:59736:59735:59733", -- [5]
			"61474:66227:59736:59735", -- [6]
			"61474:66227:59736", -- [7]
			"61474:66227", -- [8]
			"61474:61759:60230", -- [9]
			"61474:61759:62658:60231", -- [10]
			"61474:60232", -- [11]
			"61474:61759:62658:60231:59046", -- [12]
			"61474:61759:62658:60231:58843", -- [13]
			"61474:61759:62658:60231:65189:59047", -- [14]
			"61474:61759:62658:60231:65189", -- [15]
			"61474:61759:62658:60231:59046:60441", -- [16]
			"61504:60416", -- [17]
			"61745:61473", -- [18]
			"61504:60416:61512", -- [19]
			"61474:61759", -- [20]
			"61474:61759:62658", -- [21]
			"61504:60416:61512:62901", -- [22]
			"61745:61473:62903", -- [23]
			"61745:61473:62903:62898", -- [24]
			"61745:61473:62903:62898:62909", -- [25]
			"61745:61122", -- [26]
			"61745:61473:62903:63500:63501", -- [27]
			"61745:61122:63497:63498", -- [28]
			"61745:61473:62903:63500", -- [29]
			"61745:61122:63497", -- [30]
			"61474:61759:60230:59186:64310", -- [31]
			"61745:61473:62903:63500:63501:65511", -- [32]
			"61745:61473:62903:65863", -- [33]
			"61474:61759:62658:60231:58843:67785", -- [34]
			"61474:61759:60230:59186:71939", -- [35]
			["direct"] = "61474:61745:61511:61504",
			["f"] = 0,
			["m"] = 809,
			["coord"] = 2847310267,
		},
		[61504] = {
			"61474:61759:60230:60952", -- [1]
			"61474:61759:60230:59186", -- [2]
			"61474:61759:60230:59186:59732", -- [3]
			"61474:61759:60230:59186:59727", -- [4]
			"61474:66227:59736:59735:59733", -- [5]
			"61474:66227:59736:59735", -- [6]
			"61474:66227:59736", -- [7]
			"61474:66227", -- [8]
			"61474:61759:60230", -- [9]
			"61474:61759:62658:60231", -- [10]
			"61474:60232", -- [11]
			"61474:61759:62658:60231:59046", -- [12]
			"61474:61759:62658:60231:58843", -- [13]
			"61474:61759:62658:60231:65189:59047", -- [14]
			"61474:61759:62658:60231:65189", -- [15]
			"61474:61759:62658:60231:59046:60441", -- [16]
			"60416:61473", -- [17]
			"60416:61512", -- [18]
			"61474:61759", -- [19]
			"61474:61759:62658", -- [20]
			"60416:61512:62901", -- [21]
			"60416:61473:62903", -- [22]
			"60416:61512:62901:62898", -- [23]
			"60416:61512:62901:62898:62909", -- [24]
			"61745:61122", -- [25]
			"60416:61473:62903:63500:63501", -- [26]
			"60416:61473:62903:63500:63501:63498", -- [27]
			"60416:61473:62903:63500", -- [28]
			"61745:61122:63497", -- [29]
			"61474:61759:60230:59186:64310", -- [30]
			"60416:61473:62903:63500:63501:65511", -- [31]
			"60416:61512:62901:65863", -- [32]
			"61474:61759:62658:60231:58843:67785", -- [33]
			"61474:61759:60230:59186:71939", -- [34]
			["direct"] = "61474:61118:61745:61511:60416",
			["f"] = 0,
			["m"] = 809,
			["coord"] = 2481101060,
		},
		[59186] = {
			"59735:59733", -- [1]
			"60230:60231", -- [2]
			"60230:60232", -- [3]
			"60230:59046", -- [4]
			"60230:60231:58843", -- [5]
			"60230:59046:59047", -- [6]
			"60230:60231:65189", -- [7]
			"60230:59046:60441", -- [8]
			"60230:61759:61474", -- [9]
			"60230:61759:61474:61118", -- [10]
			"60230:61759:61474:61745", -- [11]
			"60230:61759:61474:61118:61511", -- [12]
			"60230:61759:61474:61504", -- [13]
			"60230:61759:61474:61745:60416", -- [14]
			"60230:61759:61474:61745:61473", -- [15]
			"60230:61759:61474:61745:60416:61512", -- [16]
			"60230:61759", -- [17]
			"60230:62658", -- [18]
			"61122:65863:62901", -- [19]
			"60230:61759:61474:61745:61473:62903", -- [20]
			"60230:61759:61474:61745:61473:62903:62898", -- [21]
			"60230:61759:61474:61745:61473:62903:62898:62909", -- [22]
			"60230:60231:58843:63501", -- [23]
			"60230:60231:58843:63501:63498", -- [24]
			"61122:63500", -- [25]
			"61122:63497", -- [26]
			"60230:60231:58843:63501:65511", -- [27]
			"61122:65863", -- [28]
			"60230:60231:58843:67785", -- [29]
			["m"] = 806,
			["f"] = 0,
			["direct"] = "60952:59732:59727:59735:59736:66227:60230:61122:64310:71939",
			["coord"] = 2019915307,
		},
		[71939] = {
			"59186:60952", -- [1]
			"59186:59732", -- [2]
			"59186:59727", -- [3]
			"59186:59735:59733", -- [4]
			"59186:59735", -- [5]
			"59186:59736", -- [6]
			"59186:66227", -- [7]
			"59186:60230", -- [8]
			"59186:60230:60231", -- [9]
			"59186:60230:60232", -- [10]
			"59186:60230:59046", -- [11]
			"59186:60230:60231:58843", -- [12]
			"59186:60230:59046:59047", -- [13]
			"59186:60230:60231:65189", -- [14]
			"59186:60230:59046:60441", -- [15]
			"59186:60230:61759:61474", -- [16]
			"59186:60230:61759:61474:61118", -- [17]
			"59186:60230:61759:61474:61745", -- [18]
			"59186:60230:61759:61474:61118:61511", -- [19]
			"59186:60230:61759:61474:61504", -- [20]
			"59186:60230:61759:61474:61745:60416", -- [21]
			"59186:60230:61759:61474:61745:61473", -- [22]
			"59186:60230:61759:61474:61745:60416:61512", -- [23]
			"59186:60230:61759", -- [24]
			"59186:60230:62658", -- [25]
			"59186:61122:65863:62901", -- [26]
			"59186:60230:61759:61474:61745:61473:62903", -- [27]
			"59186:60230:61759:61474:61745:61473:62903:62898", -- [28]
			"59186:60230:61759:61474:61745:61473:62903:62898:62909", -- [29]
			"59186:61122", -- [30]
			"59186:60230:60231:58843:63501", -- [31]
			"59186:60230:60231:58843:63501:63498", -- [32]
			"59186:61122:63500", -- [33]
			"59186:61122:63497", -- [34]
			"59186:64310", -- [35]
			"59186:60230:60231:58843:63501:65511", -- [36]
			"59186:61122:65863", -- [37]
			"59186:60230:60231:58843:67785", -- [38]
			["direct"] = "59186",
			["f"] = 0,
			["m"] = 951,
			["coord"] = 938960321,
		},
	},
	[7] = {
		[84700] = {
			"84714:92808:90562:76850", -- [1]
			"85829:76787:76781:76782", -- [2]
			"85829:76787:76781", -- [3]
			"85829:76787:76783", -- [4]
			"85829:76787", -- [5]
			"85829:76787:78699:76879", -- [6]
			"85829:76784", -- [7]
			"85829:76787:78699", -- [8]
			"85829:86049", -- [9]
			"85829:76784:79407", -- [10]
			"85829:81055:84508:90552:80932", -- [11]
			"85829:81055:84508:81053", -- [12]
			"85829:76784:81057", -- [13]
			"85829:76784:81064:81058", -- [14]
			"85829:76784:81064", -- [15]
			"85829:76784:81064:81068", -- [16]
			"85829:76784:81064:81078", -- [17]
			"85829:76784:81057:81354", -- [18]
			"84714:92808:90562:76850:81285", -- [19]
			"85829:76784:81064:81078:84509:82612", -- [20]
			"85829:76784:79407:82346:83924", -- [21]
			"85829:76784:79407:82844", -- [22]
			"85829:76784:79407:82346", -- [23]
			"85829:76784:79407:82340", -- [24]
			"85829:76784:81064:81078:84509:84498", -- [25]
			"85829:76784:81057:84515:84504", -- [26]
			"85829:76784:81057:84515:82511", -- [27]
			"85829:81055:84508", -- [28]
			"85829:76784:81064:81078:84509", -- [29]
			"85829:84495", -- [30]
			"85829:76784:81057:84515", -- [31]
			"84714:92808:90562:76850:83427", -- [32]
			"85829:76784:87707", -- [33]
			"85829:76784:81057:88584", -- [34]
			"85829:76784:79407:88668:88653", -- [35]
			"85829:76784:79407:88668", -- [36]
			"84714:88757", -- [37]
			"84714:92808:90550", -- [38]
			"85829:81055:84508:90560", -- [39]
			"85829:81055:84508:90552", -- [40]
			"84714:92808:90562", -- [41]
			"84714:92808", -- [42]
			"84714:92808:92809", -- [43]
			["direct"] = "81055:86492:85829:84714",
			["m"] = 949,
			["coord"] = 1850094548,
			["f"] = 0,
		},
		[84515] = {
			"84504:76850", -- [1]
			"81354:81064:79407:76782", -- [2]
			"81354:81064:79407:76879:76781", -- [3]
			"81354:81064:76787:76783", -- [4]
			"81354:81064:76787", -- [5]
			"81354:81064:79407:76879", -- [6]
			"81057:76784", -- [7]
			"81354:81064:79407:78699", -- [8]
			"84504:76850:86049", -- [9]
			"81354:81064:79407", -- [10]
			"81354:80932", -- [11]
			"81057:81053", -- [12]
			"81057:81055", -- [13]
			"81354:81058", -- [14]
			"81354:81064", -- [15]
			"84509:81068", -- [16]
			"84509:81078", -- [17]
			"84504:81285", -- [18]
			"81354:81064:82346:83924", -- [19]
			"81354:81064:82346:82844", -- [20]
			"81354:81064:82346", -- [21]
			"84498:82612:82340", -- [22]
			"81057:84508", -- [23]
			"81057:84495", -- [24]
			"81057:81055:86492", -- [25]
			"81057:81055:84700", -- [26]
			"84504:81285:83427", -- [27]
			"81057:76784:87707", -- [28]
			"81057:81055:84714", -- [29]
			"84498:82612:88653", -- [30]
			"81354:81064:82346:82844:88668", -- [31]
			"81057:81055:84714:88757", -- [32]
			"81354:80932:90562:90550", -- [33]
			"81354:80932:90560", -- [34]
			"81057:90552", -- [35]
			"81354:80932:90562", -- [36]
			"81354:80932:92809:92808", -- [37]
			"81354:80932:92809", -- [38]
			["direct"] = "81057:81354:82612:84498:84504:82511:84509:88584",
			["f"] = 0,
			["m"] = 948,
			["coord"] = 2222870403,
		},
		[81058] = {
			"81354:76850", -- [1]
			"81064:79407:76782", -- [2]
			"81064:79407:76879:76781", -- [3]
			"81064:76787:76783", -- [4]
			"81064:76787", -- [5]
			"81064:79407:76879", -- [6]
			"81064:76784", -- [7]
			"81064:79407:78699", -- [8]
			"81053:90552:90550:86049", -- [9]
			"81064:79407", -- [10]
			"81057:80932", -- [11]
			"81053:84495:81055", -- [12]
			"81064:81068", -- [13]
			"81064:88584:81285", -- [14]
			"81078:84509:82612", -- [15]
			"81064:82346:83924", -- [16]
			"81064:82346:82844", -- [17]
			"81064:82346:82340", -- [18]
			"81078:84509:84498", -- [19]
			"81078:84509:84515:84504", -- [20]
			"81078:84509:84498:82511", -- [21]
			"81053:84508", -- [22]
			"81078:84509", -- [23]
			"81053:84495", -- [24]
			"81078:84509:84515", -- [25]
			"81064:76784:86492", -- [26]
			"81064:76784:85829:84700", -- [27]
			"81064:88584:81285:83427", -- [28]
			"81064:76784:87707", -- [29]
			"81053:84495:81055:84714", -- [30]
			"81064:88584", -- [31]
			"81064:82346:83924:88653", -- [32]
			"81064:82346:82844:88668", -- [33]
			"81053:84495:81055:84714:88757", -- [34]
			"81053:90552:90550", -- [35]
			"81053:90552:90560", -- [36]
			"81053:90552", -- [37]
			"81053:90552:90562", -- [38]
			"81053:90552:92809:92808", -- [39]
			"81053:90552:92809", -- [40]
			["direct"] = "81053:81057:81064:81078:81354:82346",
			["f"] = 0,
			["m"] = 946,
			["coord"] = 2382522459,
		},
		[82511] = {
			"84504:76850", -- [1]
			"79407:76782", -- [2]
			"79407:76879:76781", -- [3]
			"84504:88584:81064:76787:76783", -- [4]
			"84504:88584:81064:76787", -- [5]
			"79407:76879", -- [6]
			"84504:88584:81057:76784", -- [7]
			"79407:78699", -- [8]
			"84504:76850:86049", -- [9]
			"84504:88584:81354:80932", -- [10]
			"84504:88584:81057:81053", -- [11]
			"84504:88584:81057:81055", -- [12]
			"84504:88584:81057", -- [13]
			"84504:88584:81354:81058", -- [14]
			"84504:88584:81064", -- [15]
			"84498:84509:81068", -- [16]
			"84504:88584:81078", -- [17]
			"84504:88584:81354", -- [18]
			"84504:81285", -- [19]
			"84498:82612", -- [20]
			"84498:82612:82346:83924", -- [21]
			"84498:82612:82346:82844", -- [22]
			"84498:82612:82346", -- [23]
			"84498:82612:82340", -- [24]
			"84504:88584:81057:84508", -- [25]
			"84498:84509", -- [26]
			"84504:88584:81057:84495", -- [27]
			"84504:88584:81057:81055:86492", -- [28]
			"84504:88584:81057:81055:84700", -- [29]
			"84504:81285:83427", -- [30]
			"84504:88584:81057:76784:87707", -- [31]
			"84504:88584:81057:81055:84714", -- [32]
			"84498:82612:88653", -- [33]
			"84498:82612:82346:82844:88668", -- [34]
			"84504:88584:81057:81055:84714:88757", -- [35]
			"84504:76850:90562:90550", -- [36]
			"84504:88584:81354:80932:90560", -- [37]
			"84504:88584:81057:90552", -- [38]
			"84504:76850:90562", -- [39]
			"84504:76850:90562:92808", -- [40]
			"84504:88584:81354:80932:92809", -- [41]
			["direct"] = "79407:84498:84504:84515:88584",
			["f"] = 0,
			["m"] = 948,
			["coord"] = 2613754813,
		},
		[76782] = {
			"79407:81064:81078:76850", -- [1]
			"76781:76783", -- [2]
			"76879:78699:76787", -- [3]
			"79407:76784", -- [4]
			"76879:78699", -- [5]
			"79407:86049", -- [6]
			"79407:81057:80932", -- [7]
			"79407:81053", -- [8]
			"79407:81055", -- [9]
			"79407:81057", -- [10]
			"79407:81064:81058", -- [11]
			"79407:81064", -- [12]
			"79407:81064:81068", -- [13]
			"79407:81064:81078", -- [14]
			"79407:81057:81354", -- [15]
			"79407:81064:88584:81285", -- [16]
			"79407:82612", -- [17]
			"79407:82346:83924", -- [18]
			"79407:82844", -- [19]
			"79407:82346", -- [20]
			"79407:82340", -- [21]
			"79407:84509:84498", -- [22]
			"79407:84509:84515:84504", -- [23]
			"79407:82511", -- [24]
			"79407:81053:84508", -- [25]
			"79407:84509", -- [26]
			"79407:81053:84495", -- [27]
			"79407:84509:84515", -- [28]
			"79407:76784:86492", -- [29]
			"76879:78699:76787:85829:84700", -- [30]
			"79407:81057:83427", -- [31]
			"79407:87707", -- [32]
			"79407:76784:86492:84714", -- [33]
			"79407:81064:88584", -- [34]
			"79407:88668:88653", -- [35]
			"79407:88668", -- [36]
			"79407:76784:86492:84714:88757", -- [37]
			"79407:81053:90552:90550", -- [38]
			"79407:81053:90552:90560", -- [39]
			"79407:81053:90552", -- [40]
			"79407:81053:90552:90562", -- [41]
			"79407:81053:90552:92809:92808", -- [42]
			"79407:81053:90552:92809", -- [43]
			["direct"] = "76781:76879:79407",
			["f"] = 0,
			["m"] = 941,
			["coord"] = 925929393,
		},
		[86492] = {
			"84714:92808:90562:76850", -- [1]
			"76784:79407:76782", -- [2]
			"76784:76879:76781", -- [3]
			"85829:76787:76783", -- [4]
			"85829:76787", -- [5]
			"76784:76879", -- [6]
			"76784:87707:78699", -- [7]
			"84714:86049", -- [8]
			"76784:79407", -- [9]
			"81055:84508:90552:80932", -- [10]
			"81055:84508:81053", -- [11]
			"81055:81057", -- [12]
			"76784:81064:81058", -- [13]
			"76784:81064", -- [14]
			"76784:81064:81068", -- [15]
			"76784:81064:81078", -- [16]
			"81055:81057:81354", -- [17]
			"81055:81057:81285", -- [18]
			"81055:81057:82612", -- [19]
			"81055:82346:83924", -- [20]
			"76784:79407:82844", -- [21]
			"81055:82346", -- [22]
			"76784:79407:82340", -- [23]
			"81055:81057:84515:84498", -- [24]
			"81055:81057:84515:84504", -- [25]
			"81055:81057:84515:82511", -- [26]
			"81055:84508", -- [27]
			"76784:81064:81078:84509", -- [28]
			"81055:84495", -- [29]
			"81055:81057:84515", -- [30]
			"81055:81057:83427", -- [31]
			"76784:87707", -- [32]
			"81055:81057:88584", -- [33]
			"76784:79407:88668:88653", -- [34]
			"76784:79407:88668", -- [35]
			"84714:88757", -- [36]
			"84714:92808:90550", -- [37]
			"81055:84508:90560", -- [38]
			"81055:84508:90552", -- [39]
			"84714:92808:90562", -- [40]
			"84714:92808", -- [41]
			"81055:84508:90552:92809", -- [42]
			["direct"] = "76784:81055:84700:84714",
			["f"] = 0,
			["m"] = 949,
			["coord"] = 1969982652,
		},
		[81078] = {
			"81064:79407:76782", -- [1]
			"81064:79407:76879:76781", -- [2]
			"81064:76787:76783", -- [3]
			"81064:76787", -- [4]
			"81064:79407:76879", -- [5]
			"81064:76784", -- [6]
			"81064:79407:78699", -- [7]
			"81354:80932:90562:90550:86049", -- [8]
			"81064:79407", -- [9]
			"81354:80932", -- [10]
			"81064:81058:81053", -- [11]
			"81354:81057:81055", -- [12]
			"81354:81057", -- [13]
			"84509:82612", -- [14]
			"81064:82346:83924", -- [15]
			"81064:82346:82844", -- [16]
			"81064:82346", -- [17]
			"81064:82346:82340", -- [18]
			"84509:84498", -- [19]
			"84509:84515:84504", -- [20]
			"84509:84498:82511", -- [21]
			"81354:81057:84508", -- [22]
			"81354:81057:84495", -- [23]
			"84509:84515", -- [24]
			"81064:76784:86492", -- [25]
			"81064:76784:85829:84700", -- [26]
			"81285:83427", -- [27]
			"81064:76784:87707", -- [28]
			"81064:76784:86492:84714", -- [29]
			"81064:82346:83924:88653", -- [30]
			"81064:82346:82844:88668", -- [31]
			"81064:76784:86492:84714:88757", -- [32]
			"81354:80932:90562:90550", -- [33]
			"81354:80932:90560", -- [34]
			"81354:81057:90552", -- [35]
			"81354:80932:90562", -- [36]
			"81354:80932:92809:92808", -- [37]
			"81354:80932:92809", -- [38]
			["direct"] = "76850:81058:81064:81068:81354:81285:84509:88584",
			["f"] = 0,
			["m"] = 946,
			["coord"] = 2342366659,
		},
		[82346] = {
			"81064:81078:76850", -- [1]
			"79407:76782", -- [2]
			"79407:76879:76781", -- [3]
			"79407:78699:76783", -- [4]
			"79407:76787", -- [5]
			"79407:76879", -- [6]
			"79407:76784", -- [7]
			"79407:78699", -- [8]
			"81053:90552:90550:86049", -- [9]
			"81057:80932", -- [10]
			"83924:81068", -- [11]
			"81064:81078", -- [12]
			"81058:81354", -- [13]
			"83924:81068:84509:84515:84504:81285", -- [14]
			"83924:81068:84509:84498", -- [15]
			"83924:81068:84509:84515:84504", -- [16]
			"83924:81068:84509:84498:82511", -- [17]
			"81053:84508", -- [18]
			"83924:81068:84509", -- [19]
			"81053:84495", -- [20]
			"83924:81068:84509:84515", -- [21]
			"81055:86492", -- [22]
			"81055:84700", -- [23]
			"81057:83427", -- [24]
			"79407:87707", -- [25]
			"81055:84714", -- [26]
			"81064:88584", -- [27]
			"83924:88653", -- [28]
			"82844:88668", -- [29]
			"81055:84714:88757", -- [30]
			"81053:90552:90550", -- [31]
			"81053:90552:90560", -- [32]
			"81053:90552", -- [33]
			"81053:90552:90562", -- [34]
			"81053:90552:92809:92808", -- [35]
			"81053:90552:92809", -- [36]
			["direct"] = "79407:81053:81055:81057:81058:81064:82612:83924:82844:82340",
			["f"] = 0,
			["m"] = 950,
			["coord"] = 3575083561,
		},
		[92808] = {
			"90562:76850", -- [1]
			"90560:84508:84495:76784:79407:76782", -- [2]
			"90560:84508:84495:76784:76879:76781", -- [3]
			"90560:84508:84495:76784:76787:76783", -- [4]
			"90560:84508:84495:76784:76787", -- [5]
			"90560:84508:84495:76784:76879", -- [6]
			"90560:84508:84495:76784", -- [7]
			"90560:84508:84495:76784:87707:78699", -- [8]
			"90550:86049", -- [9]
			"90560:84508:84495:76784:79407", -- [10]
			"92809:80932", -- [11]
			"90560:84508:81053", -- [12]
			"90560:84508:81055", -- [13]
			"90560:90552:81057", -- [14]
			"90560:84508:81053:81058", -- [15]
			"90560:84508:81053:81058:81064", -- [16]
			"90560:84508:81053:81058:81064:81068", -- [17]
			"92809:80932:81354:81078", -- [18]
			"92809:80932:81354", -- [19]
			"90562:76850:81285", -- [20]
			"90562:76850:88584:82612", -- [21]
			"90560:84508:81053:82346:83924", -- [22]
			"90560:84508:81053:82346:82844", -- [23]
			"90560:84508:81053:82346", -- [24]
			"90560:84508:81053:82346:82340", -- [25]
			"92809:80932:81354:84515:84498", -- [26]
			"90562:76850:84504", -- [27]
			"90562:76850:84504:82511", -- [28]
			"90560:84508", -- [29]
			"92809:80932:81354:81078:84509", -- [30]
			"90560:84508:84495", -- [31]
			"92809:80932:81354:84515", -- [32]
			"84714:86492", -- [33]
			"84714:84700", -- [34]
			"90562:76850:83427", -- [35]
			"90560:84508:84495:76784:87707", -- [36]
			"90562:76850:88584", -- [37]
			"90560:84508:81053:82346:83924:88653", -- [38]
			"90560:84508:81053:82346:82844:88668", -- [39]
			"84714:88757", -- [40]
			"90560:90552", -- [41]
			["direct"] = "84714:90550:90560:90562:92809",
			["f"] = 0,
			["m"] = 945,
			["coord"] = 1863937090,
		},
		[81354] = {
			"81064:79407:76782", -- [1]
			"81064:79407:76879:76781", -- [2]
			"81064:76787:76783", -- [3]
			"81064:76787", -- [4]
			"81064:79407:76879", -- [5]
			"81057:76784", -- [6]
			"81064:79407:78699", -- [7]
			"80932:90562:90550:86049", -- [8]
			"81064:79407", -- [9]
			"81057:81053", -- [10]
			"81057:81055", -- [11]
			"81078:81068", -- [12]
			"88584:81285", -- [13]
			"84515:84498:82612", -- [14]
			"81064:82346:83924", -- [15]
			"81064:82346:82844", -- [16]
			"81064:82346", -- [17]
			"81064:82346:82340", -- [18]
			"84515:84498", -- [19]
			"84515:84504", -- [20]
			"84515:82511", -- [21]
			"81057:84508", -- [22]
			"81078:84509", -- [23]
			"81057:84495", -- [24]
			"81057:81055:86492", -- [25]
			"81057:81055:84700", -- [26]
			"76850:83427", -- [27]
			"81057:76784:87707", -- [28]
			"81057:81055:84714", -- [29]
			"81064:82346:83924:88653", -- [30]
			"81064:82346:82844:88668", -- [31]
			"81057:81055:84714:88757", -- [32]
			"80932:90562:90550", -- [33]
			"80932:90560", -- [34]
			"81057:90552", -- [35]
			"80932:90562", -- [36]
			"80932:92809:92808", -- [37]
			"80932:92809", -- [38]
			["direct"] = "76850:80932:81057:81058:81064:81078:84515:88584",
			["f"] = 0,
			["m"] = 946,
			["coord"] = 3022098990,
		},
		[84508] = {
			"90552:90562:76850", -- [1]
			"84495:76784:79407:76782", -- [2]
			"84495:76784:76879:76781", -- [3]
			"84495:76784:76787:76783", -- [4]
			"84495:76784:76787", -- [5]
			"84495:76784:76879", -- [6]
			"84495:76784", -- [7]
			"84495:76784:87707:78699", -- [8]
			"84495:76784:79407", -- [9]
			"90552:80932", -- [10]
			"81053:81058", -- [11]
			"81053:81058:81064", -- [12]
			"81053:81058:81064:81068", -- [13]
			"81053:81058:81078", -- [14]
			"81057:81354", -- [15]
			"81057:81285", -- [16]
			"81057:82612", -- [17]
			"81053:82346:83924", -- [18]
			"81053:82346:82844", -- [19]
			"81053:82346", -- [20]
			"81053:82346:82340", -- [21]
			"81057:84515:84498", -- [22]
			"81057:84515:84504", -- [23]
			"81057:84515:82511", -- [24]
			"81053:81058:81078:84509", -- [25]
			"81057:84515", -- [26]
			"81055:86492", -- [27]
			"81055:84700", -- [28]
			"81057:83427", -- [29]
			"84495:76784:87707", -- [30]
			"81055:84714", -- [31]
			"81057:88584", -- [32]
			"81053:82346:83924:88653", -- [33]
			"81053:82346:82844:88668", -- [34]
			"81055:84714:88757", -- [35]
			"90560:90550", -- [36]
			"90552:90562", -- [37]
			"90560:92808", -- [38]
			"90552:92809", -- [39]
			["direct"] = "86049:81053:81055:81057:84495:90560:90552",
			["f"] = 0,
			["m"] = 949,
			["coord"] = 2037246058,
		},
		[90560] = {
			"90562:76850", -- [1]
			"84508:84495:76784:79407:76782", -- [2]
			"84508:84495:76784:76879:76781", -- [3]
			"84508:84495:76784:76787:76783", -- [4]
			"84508:84495:76784:76787", -- [5]
			"84508:84495:76784:76879", -- [6]
			"84508:84495:76784", -- [7]
			"84508:84495:76784:87707:78699", -- [8]
			"90550:86049", -- [9]
			"84508:84495:76784:79407", -- [10]
			"84508:81053", -- [11]
			"84508:81055", -- [12]
			"90552:81057", -- [13]
			"84508:81053:81058", -- [14]
			"84508:81053:81058:81064", -- [15]
			"84508:81053:81058:81064:81068", -- [16]
			"80932:81354:81078", -- [17]
			"80932:81354", -- [18]
			"90562:76850:81285", -- [19]
			"90552:81057:82612", -- [20]
			"84508:81053:82346:83924", -- [21]
			"84508:81053:82346:82844", -- [22]
			"84508:81053:82346", -- [23]
			"84508:81053:82346:82340", -- [24]
			"80932:81354:84515:84498", -- [25]
			"80932:81354:84515:84504", -- [26]
			"80932:81354:84515:82511", -- [27]
			"80932:81354:81078:84509", -- [28]
			"84508:84495", -- [29]
			"80932:81354:84515", -- [30]
			"84508:81055:86492", -- [31]
			"84508:81055:84700", -- [32]
			"90562:76850:83427", -- [33]
			"84508:84495:76784:87707", -- [34]
			"92808:84714", -- [35]
			"80932:81354:88584", -- [36]
			"84508:81053:82346:83924:88653", -- [37]
			"84508:81053:82346:82844:88668", -- [38]
			"92808:84714:88757", -- [39]
			["direct"] = "80932:84508:90550:90552:90562:92808:92809",
			["f"] = 0,
			["m"] = 945,
			["coord"] = 1123443650,
		},
		[81055] = {
			"84508:90552:90562:76850", -- [1]
			"79407:76782", -- [2]
			"76784:76879:76781", -- [3]
			"76784:76787:76783", -- [4]
			"76784:76787", -- [5]
			"76784:76879", -- [6]
			"76784:87707:78699", -- [7]
			"84508:90552:80932", -- [8]
			"84508:81053", -- [9]
			"84508:81053:81058", -- [10]
			"84508:81053:81058:81064", -- [11]
			"84508:81053:81058:81064:81068", -- [12]
			"84508:81053:81058:81078", -- [13]
			"81057:81354", -- [14]
			"81057:81285", -- [15]
			"81057:82612", -- [16]
			"82346:83924", -- [17]
			"79407:82844", -- [18]
			"82346:82340", -- [19]
			"81057:84515:84498", -- [20]
			"81057:84515:84504", -- [21]
			"81057:84515:82511", -- [22]
			"84508:81053:81058:81078:84509", -- [23]
			"81057:84515", -- [24]
			"81057:83427", -- [25]
			"76784:87707", -- [26]
			"81057:88584", -- [27]
			"82346:83924:88653", -- [28]
			"79407:88668", -- [29]
			"84714:88757", -- [30]
			"84508:90560:90550", -- [31]
			"84508:90560", -- [32]
			"84508:90552", -- [33]
			"84508:90552:90562", -- [34]
			"84508:90560:92808", -- [35]
			"84508:90552:92809", -- [36]
			["direct"] = "76784:86049:79407:81057:82346:84508:84495:86492:84700:84714",
			["f"] = 0,
			["m"] = 949,
			["coord"] = 1976152391,
		},
		[76783] = {
			"78699:79407:81064:81078:76850", -- [1]
			"76781:76782", -- [2]
			"76781:76879", -- [3]
			"76787:76784", -- [4]
			"76787:85829:86049", -- [5]
			"78699:79407", -- [6]
			"78699:79407:81057:80932", -- [7]
			"78699:79407:81053", -- [8]
			"76787:76784:81055", -- [9]
			"78699:79407:81057", -- [10]
			"78699:79407:81064:81058", -- [11]
			"78699:79407:81064", -- [12]
			"78699:79407:81064:81068", -- [13]
			"78699:79407:81064:81078", -- [14]
			"78699:79407:81057:81354", -- [15]
			"78699:79407:81064:88584:81285", -- [16]
			"78699:79407:82612", -- [17]
			"78699:79407:82346:83924", -- [18]
			"78699:79407:82844", -- [19]
			"78699:79407:82346", -- [20]
			"78699:79407:82340", -- [21]
			"78699:79407:84509:84498", -- [22]
			"78699:79407:84509:84515:84504", -- [23]
			"78699:79407:82511", -- [24]
			"76787:76784:84495:84508", -- [25]
			"78699:79407:84509", -- [26]
			"76787:76784:84495", -- [27]
			"78699:79407:84509:84515", -- [28]
			"76787:76784:86492", -- [29]
			"76787:85829:84700", -- [30]
			"78699:79407:81057:83427", -- [31]
			"78699:87707", -- [32]
			"76787:85829:84714", -- [33]
			"78699:79407:81064:88584", -- [34]
			"78699:79407:88668:88653", -- [35]
			"78699:79407:88668", -- [36]
			"76787:85829:84714:88757", -- [37]
			"78699:79407:81053:90552:90550", -- [38]
			"76787:76784:84495:84508:90560", -- [39]
			"78699:79407:81053:90552", -- [40]
			"78699:79407:81053:90552:90562", -- [41]
			"76787:85829:84714:92808", -- [42]
			"78699:79407:81053:90552:92809", -- [43]
			["direct"] = "76781:76787:78699",
			["f"] = 0,
			["m"] = 941,
			["coord"] = 1365973129,
		},
		[76850] = {
			"81354:81064:79407:76782", -- [1]
			"81354:81064:79407:76879:76781", -- [2]
			"81354:81064:76787:76783", -- [3]
			"81354:81064:76787", -- [4]
			"81354:81064:79407:76879", -- [5]
			"81354:81057:76784", -- [6]
			"81354:81064:79407:78699", -- [7]
			"81354:81064:79407", -- [8]
			"81354:80932", -- [9]
			"81354:81057:81053", -- [10]
			"90562:90560:84508:81055", -- [11]
			"81354:81057", -- [12]
			"81354:81058", -- [13]
			"81354:81064", -- [14]
			"81354:81078:81068", -- [15]
			"88584:82612", -- [16]
			"81354:81064:82346:83924", -- [17]
			"81354:81064:82346:82844", -- [18]
			"81354:81064:82346", -- [19]
			"81354:81064:82346:82340", -- [20]
			"88584:84515:84498", -- [21]
			"84504:82511", -- [22]
			"90562:90560:84508", -- [23]
			"88584:82612:84509", -- [24]
			"81354:81057:84495", -- [25]
			"88584:84515", -- [26]
			"90562:90560:84508:81055:86492", -- [27]
			"90562:92808:84714:84700", -- [28]
			"81354:81057:76784:87707", -- [29]
			"90562:92808:84714", -- [30]
			"81354:81064:82346:83924:88653", -- [31]
			"81354:81064:82346:82844:88668", -- [32]
			"90562:92808:84714:88757", -- [33]
			"90562:90550", -- [34]
			"90562:90560", -- [35]
			"90562:90552", -- [36]
			"90562:92808", -- [37]
			"90562:92809", -- [38]
			["direct"] = "86049:81078:81354:81285:84504:83427:88584:90562",
			["f"] = 0,
			["m"] = 947,
			["coord"] = 1958101242,
		},
		[88584] = {
			"81064:79407:76782", -- [1]
			"81064:79407:76879:76781", -- [2]
			"81064:76787:76783", -- [3]
			"81064:76787", -- [4]
			"81064:79407:76879", -- [5]
			"81057:76784", -- [6]
			"81064:79407:78699", -- [7]
			"81064:79407", -- [8]
			"81354:80932", -- [9]
			"81057:81053", -- [10]
			"81057:81055", -- [11]
			"81354:81058", -- [12]
			"81078:81068", -- [13]
			"81064:82346:83924", -- [14]
			"81064:82346:82844", -- [15]
			"81064:82346", -- [16]
			"81064:82346:82340", -- [17]
			"84515:84498", -- [18]
			"81057:84508", -- [19]
			"82612:84509", -- [20]
			"81057:84495", -- [21]
			"81057:81055:86492", -- [22]
			"81057:81055:84700", -- [23]
			"81285:83427", -- [24]
			"81057:76784:87707", -- [25]
			"81057:81055:84714", -- [26]
			"82612:88653", -- [27]
			"81064:82346:82844:88668", -- [28]
			"81057:81055:84714:88757", -- [29]
			"76850:90562:90550", -- [30]
			"81354:80932:90560", -- [31]
			"81057:90552", -- [32]
			"76850:90562", -- [33]
			"81354:80932:92809:92808", -- [34]
			"81354:80932:92809", -- [35]
			["direct"] = "76850:86049:81057:81064:81078:81354:81285:82612:84504:82511:84515",
			["f"] = 0,
			["m"] = 948,
			["coord"] = 2820418764,
		},
		[92809] = {
			"90562:76850", -- [1]
			"90552:81053:79407:76782", -- [2]
			"90560:84508:84495:76784:76879:76781", -- [3]
			"90560:84508:84495:76784:76787:76783", -- [4]
			"90560:84508:84495:76784:76787", -- [5]
			"90560:84508:84495:76784:76879", -- [6]
			"90560:84508:84495:76784", -- [7]
			"90560:84508:84495:76784:87707:78699", -- [8]
			"92808:90550:86049", -- [9]
			"90552:81053:79407", -- [10]
			"90552:81053", -- [11]
			"90560:84508:81055", -- [12]
			"80932:81057", -- [13]
			"80932:81057:81058", -- [14]
			"80932:81057:81058:81064", -- [15]
			"80932:81354:81078:81068", -- [16]
			"80932:81354:81078", -- [17]
			"80932:81354", -- [18]
			"90562:76850:81285", -- [19]
			"80932:81057:82612", -- [20]
			"90552:81053:82346:83924", -- [21]
			"90552:81053:82346:82844", -- [22]
			"90552:81053:82346", -- [23]
			"90552:81053:82346:82340", -- [24]
			"80932:81354:84515:84498", -- [25]
			"80932:81354:84515:84504", -- [26]
			"80932:81354:84515:82511", -- [27]
			"90560:84508", -- [28]
			"80932:81354:81078:84509", -- [29]
			"90560:84508:84495", -- [30]
			"80932:81354:84515", -- [31]
			"90560:84508:81055:86492", -- [32]
			"92808:84714:84700", -- [33]
			"90562:76850:83427", -- [34]
			"90560:84508:84495:76784:87707", -- [35]
			"92808:84714", -- [36]
			"80932:81354:88584", -- [37]
			"90552:81053:82346:83924:88653", -- [38]
			"90552:81053:82346:82844:88668", -- [39]
			"92808:84714:88757", -- [40]
			"92808:90550", -- [41]
			["direct"] = "80932:90560:90552:90562:92808",
			["f"] = 0,
			["m"] = 945,
			["coord"] = 1268359494,
		},
		[84509] = {
			"84515:84504:76850", -- [1]
			"81064:79407:76782", -- [2]
			"81064:79407:76879:76781", -- [3]
			"81064:76787:76783", -- [4]
			"81064:76787", -- [5]
			"81064:79407:76879", -- [6]
			"81064:76784", -- [7]
			"81064:79407:78699", -- [8]
			"84515:84504:76850:86049", -- [9]
			"81078:81354:80932", -- [10]
			"81064:81058:81053", -- [11]
			"81078:81354:81057:81055", -- [12]
			"81078:81354:81057", -- [13]
			"81064:81058", -- [14]
			"81078:81354", -- [15]
			"84515:84504:81285", -- [16]
			"81068:83924", -- [17]
			"81068:83924:82844", -- [18]
			"81064:82346", -- [19]
			"81068:83924:82340", -- [20]
			"84515:84504", -- [21]
			"84498:82511", -- [22]
			"81078:81354:81057:84508", -- [23]
			"81078:81354:81057:84495", -- [24]
			"81064:76784:86492", -- [25]
			"81064:76784:85829:84700", -- [26]
			"84515:84504:81285:83427", -- [27]
			"81064:76784:87707", -- [28]
			"81064:76784:86492:84714", -- [29]
			"84515:88584", -- [30]
			"82612:88653", -- [31]
			"81068:83924:82844:88668", -- [32]
			"81064:76784:86492:84714:88757", -- [33]
			"81078:81354:80932:90562:90550", -- [34]
			"81078:81354:80932:90560", -- [35]
			"81078:81354:81057:90552", -- [36]
			"81078:81354:80932:90562", -- [37]
			"81078:81354:80932:92809:92808", -- [38]
			"81078:81354:80932:92809", -- [39]
			["direct"] = "79407:81064:81068:81078:82612:84498:84515",
			["f"] = 0,
			["m"] = 948,
			["coord"] = 1586380571,
		},
		[80932] = {
			"90562:76850", -- [1]
			"81057:79407:76782", -- [2]
			"81057:79407:76879:76781", -- [3]
			"81057:76784:76787:76783", -- [4]
			"81057:76784:76787", -- [5]
			"81057:79407:76879", -- [6]
			"81057:76784", -- [7]
			"81057:76784:87707:78699", -- [8]
			"90562:90550:86049", -- [9]
			"81057:79407", -- [10]
			"81057:81053", -- [11]
			"90552:84508:81055", -- [12]
			"81057:81058", -- [13]
			"81057:81058:81064", -- [14]
			"81354:81078:81068", -- [15]
			"81354:81078", -- [16]
			"81354:88584:81285", -- [17]
			"81057:82612", -- [18]
			"81057:82346:83924", -- [19]
			"81057:82346:82844", -- [20]
			"81057:82346", -- [21]
			"81057:82346:82340", -- [22]
			"81354:84515:84498", -- [23]
			"81354:84515:84504", -- [24]
			"81354:84515:82511", -- [25]
			"90552:84508", -- [26]
			"81354:81078:84509", -- [27]
			"81057:84495", -- [28]
			"81354:84515", -- [29]
			"90552:84508:81055:86492", -- [30]
			"90552:84508:81055:84700", -- [31]
			"81057:83427", -- [32]
			"81057:76784:87707", -- [33]
			"92809:92808:84714", -- [34]
			"81354:88584", -- [35]
			"81057:82346:83924:88653", -- [36]
			"81057:82346:82844:88668", -- [37]
			"92809:92808:84714:88757", -- [38]
			"90562:90550", -- [39]
			"92809:92808", -- [40]
			["direct"] = "81057:81354:90560:90552:90562:92809",
			["f"] = 0,
			["m"] = 946,
			["coord"] = 3452649746,
		},
		[82340] = {
			"83924:81064:81078:76850", -- [1]
			"88668:79407:76782", -- [2]
			"88668:79407:76879:76781", -- [3]
			"88668:79407:78699:76783", -- [4]
			"88668:79407:76787", -- [5]
			"88668:79407:76879", -- [6]
			"88668:79407:76784", -- [7]
			"88668:79407:78699", -- [8]
			"88668:79407:86049", -- [9]
			"82346:81057:80932", -- [10]
			"82346:81053", -- [11]
			"88668:79407:81055", -- [12]
			"82346:81057", -- [13]
			"82346:81058", -- [14]
			"83924:81064", -- [15]
			"83924:81068", -- [16]
			"83924:81064:81078", -- [17]
			"83924:81064:81354", -- [18]
			"88653:82612:81285", -- [19]
			"88653:82612:84498", -- [20]
			"83924:81068:84509:84515:84504", -- [21]
			"88653:82612:84498:82511", -- [22]
			"82346:81053:84508", -- [23]
			"83924:81068:84509", -- [24]
			"82346:81053:84495", -- [25]
			"83924:81068:84509:84515", -- [26]
			"88668:79407:76784:86492", -- [27]
			"88668:79407:76784:85829:84700", -- [28]
			"88653:82612:81285:83427", -- [29]
			"88668:79407:87707", -- [30]
			"88668:79407:76784:86492:84714", -- [31]
			"83924:81064:88584", -- [32]
			"88668:79407:76784:86492:84714:88757", -- [33]
			"82346:81053:90552:90550", -- [34]
			"82346:81053:90552:90560", -- [35]
			"82346:81053:90552", -- [36]
			"82346:81053:90552:90562", -- [37]
			"82346:81053:90552:92809:92808", -- [38]
			"82346:81053:90552:92809", -- [39]
			["direct"] = "79407:82612:83924:82844:82346:88653:88668",
			["f"] = 0,
			["m"] = 950,
			["coord"] = 2125757186,
		},
		[84714] = {
			"92808:90562:76850", -- [1]
			"86492:76784:79407:76782", -- [2]
			"85829:76787:76781", -- [3]
			"85829:76787:76783", -- [4]
			"85829:76787", -- [5]
			"86492:76784:76879", -- [6]
			"86492:76784", -- [7]
			"86492:76784:87707:78699", -- [8]
			"86492:76784:79407", -- [9]
			"92808:92809:80932", -- [10]
			"81055:84508:81053", -- [11]
			"81055:81057", -- [12]
			"81055:84508:81053:81058", -- [13]
			"86492:76784:81064", -- [14]
			"86492:76784:81064:81068", -- [15]
			"86492:76784:81064:81078", -- [16]
			"81055:81057:81354", -- [17]
			"92808:90562:76850:81285", -- [18]
			"81055:81057:82612", -- [19]
			"81055:82346:83924", -- [20]
			"86492:76784:79407:82844", -- [21]
			"81055:82346", -- [22]
			"86492:76784:79407:82340", -- [23]
			"81055:81057:84515:84498", -- [24]
			"81055:81057:84515:84504", -- [25]
			"81055:81057:84515:82511", -- [26]
			"81055:84508", -- [27]
			"86492:76784:81064:81078:84509", -- [28]
			"81055:84495", -- [29]
			"81055:81057:84515", -- [30]
			"92808:90562:76850:83427", -- [31]
			"86492:76784:87707", -- [32]
			"81055:81057:88584", -- [33]
			"81055:82346:83924:88653", -- [34]
			"86492:76784:79407:88668", -- [35]
			"92808:90550", -- [36]
			"92808:90560", -- [37]
			"81055:84508:90552", -- [38]
			"92808:90562", -- [39]
			"92808:92809", -- [40]
			["direct"] = "86049:81055:86492:84700:88757:92808",
			["f"] = 0,
			["m"] = 949,
			["coord"] = 2448651582,
		},
		[81064] = {
			"81078:76850", -- [1]
			"79407:76782", -- [2]
			"79407:76879:76781", -- [3]
			"76787:76783", -- [4]
			"79407:76879", -- [5]
			"79407:78699", -- [6]
			"81057:80932", -- [7]
			"81058:81053", -- [8]
			"81058:81053:84495:81055", -- [9]
			"88584:81285", -- [10]
			"82346:82844", -- [11]
			"82346:82340", -- [12]
			"81078:84509:84498", -- [13]
			"81078:84509:84515:84504", -- [14]
			"81078:84509:84498:82511", -- [15]
			"81058:81053:84508", -- [16]
			"81058:81053:84495", -- [17]
			"81078:84509:84515", -- [18]
			"76784:86492", -- [19]
			"76784:85829:84700", -- [20]
			"88584:81285:83427", -- [21]
			"76784:87707", -- [22]
			"76784:86492:84714", -- [23]
			"82346:83924:88653", -- [24]
			"82346:82844:88668", -- [25]
			"76784:86492:84714:88757", -- [26]
			"81057:90552:90550", -- [27]
			"81057:90552:90560", -- [28]
			"81057:90552", -- [29]
			"81057:80932:90562", -- [30]
			"81057:80932:92809:92808", -- [31]
			"81057:80932:92809", -- [32]
			["m"] = 946,
			["f"] = 0,
			["direct"] = "76787:76784:86049:79407:81057:81058:81068:81078:81354:82612:83924:82346:84509:88584",
			["coord"] = 2201644386,
		},
		[81068] = {
			"81078:76850", -- [1]
			"83924:82346:79407:76782", -- [2]
			"83924:82346:79407:76879:76781", -- [3]
			"81078:81064:76787:76783", -- [4]
			"81078:81064:76787", -- [5]
			"83924:82346:79407:76879", -- [6]
			"81078:81064:76784", -- [7]
			"83924:82346:79407:78699", -- [8]
			"81078:81354:80932:90562:90550:86049", -- [9]
			"83924:82346:79407", -- [10]
			"81078:81354:80932", -- [11]
			"81078:81064:81058:81053", -- [12]
			"81078:81354:81057:81055", -- [13]
			"81078:81354:81057", -- [14]
			"81078:81064:81058", -- [15]
			"81078:81354", -- [16]
			"84509:84515:84504:81285", -- [17]
			"84509:82612", -- [18]
			"83924:82844", -- [19]
			"83924:82346", -- [20]
			"83924:82340", -- [21]
			"84509:84498", -- [22]
			"84509:84515:84504", -- [23]
			"84509:84498:82511", -- [24]
			"81078:81354:81057:84508", -- [25]
			"81078:81354:81057:84495", -- [26]
			"84509:84515", -- [27]
			"81078:81064:76784:86492", -- [28]
			"81078:81064:76784:85829:84700", -- [29]
			"84509:84515:84504:81285:83427", -- [30]
			"81078:81064:76784:87707", -- [31]
			"81078:81064:76784:86492:84714", -- [32]
			"81078:88584", -- [33]
			"83924:88653", -- [34]
			"83924:82844:88668", -- [35]
			"81078:81064:76784:86492:84714:88757", -- [36]
			"81078:81354:80932:90562:90550", -- [37]
			"81078:81354:80932:90560", -- [38]
			"81078:81354:81057:90552", -- [39]
			"81078:81354:80932:90562", -- [40]
			"81078:81354:80932:92809:92808", -- [41]
			"81078:81354:80932:92809", -- [42]
			["direct"] = "81064:81078:83924:84509",
			["f"] = 0,
			["m"] = 946,
			["coord"] = 1810351311,
		},
		[86049] = {
			"79407:76782", -- [1]
			"85829:76787:76781", -- [2]
			"85829:76787:76783", -- [3]
			"85829:76787", -- [4]
			"79407:76879", -- [5]
			"84495:76784", -- [6]
			"84495:76784:87707:78699", -- [7]
			"90550:90562:80932", -- [8]
			"84508:81053", -- [9]
			"84508:81053:81058", -- [10]
			"81064:81068", -- [11]
			"81064:81078", -- [12]
			"90550:90562:80932:81354", -- [13]
			"88584:82612", -- [14]
			"84508:81053:82346:83924", -- [15]
			"84508:81053:82346:82844", -- [16]
			"84508:81053:82346", -- [17]
			"84508:81053:82346:82340", -- [18]
			"88584:84515:84498", -- [19]
			"76850:84504", -- [20]
			"88584:82511", -- [21]
			"88584:82612:84509", -- [22]
			"88584:84515", -- [23]
			"84714:86492", -- [24]
			"84714:84700", -- [25]
			"84495:76784:87707", -- [26]
			"84508:81053:82346:83924:88653", -- [27]
			"84508:81053:82346:82844:88668", -- [28]
			"84714:88757", -- [29]
			"90550:90560", -- [30]
			"90550:90552", -- [31]
			"90550:90562", -- [32]
			"90550:92808", -- [33]
			"90550:92808:92809", -- [34]
			["direct"] = "76850:79407:81055:81057:81064:81285:84508:84495:83427:84714:88584:90550",
			["f"] = 0,
			["m"] = 1011,
			["coord"] = 1893292290,
		},
		[81285] = {
			"88584:81064:79407:76782", -- [1]
			"88584:81064:79407:76879:76781", -- [2]
			"88584:81064:76787:76783", -- [3]
			"88584:81064:76787", -- [4]
			"88584:81064:79407:76879", -- [5]
			"81057:76784", -- [6]
			"88584:81064:79407:78699", -- [7]
			"88584:81064:79407", -- [8]
			"88584:81354:80932", -- [9]
			"81057:81053", -- [10]
			"81057:81055", -- [11]
			"88584:81354:81058", -- [12]
			"88584:81064", -- [13]
			"81078:81068", -- [14]
			"88584:81354", -- [15]
			"88584:81064:82346:83924", -- [16]
			"88584:81064:82346:82844", -- [17]
			"88584:81064:82346", -- [18]
			"88584:81064:82346:82340", -- [19]
			"84504:84498", -- [20]
			"84504:82511", -- [21]
			"81057:84508", -- [22]
			"82612:84509", -- [23]
			"81057:84495", -- [24]
			"84504:84515", -- [25]
			"81057:81055:86492", -- [26]
			"81057:81055:84700", -- [27]
			"81057:76784:87707", -- [28]
			"76850:90562:92808:84714", -- [29]
			"82612:88653", -- [30]
			"88584:81064:82346:82844:88668", -- [31]
			"76850:90562:92808:84714:88757", -- [32]
			"76850:90562:90550", -- [33]
			"88584:81354:80932:90560", -- [34]
			"81057:90552", -- [35]
			"76850:90562", -- [36]
			"76850:90562:92808", -- [37]
			"76850:90562:92809", -- [38]
			["direct"] = "76850:86049:81057:81078:82612:84504:83427:88584",
			["f"] = 0,
			["m"] = 947,
			["coord"] = 1885324908,
		},
		[82844] = {
			"83924:81064:81078:76850", -- [1]
			"79407:76782", -- [2]
			"79407:76879:76781", -- [3]
			"79407:78699:76783", -- [4]
			"79407:76879", -- [5]
			"79407:76784", -- [6]
			"79407:78699", -- [7]
			"79407:86049", -- [8]
			"82346:81057:80932", -- [9]
			"82346:81053", -- [10]
			"79407:81055", -- [11]
			"82346:81057", -- [12]
			"82346:81058", -- [13]
			"83924:81064", -- [14]
			"83924:81068", -- [15]
			"83924:81064:81078", -- [16]
			"83924:81064:81354", -- [17]
			"83924:81068:84509:84515:84504:81285", -- [18]
			"83924:81068:84509:82612", -- [19]
			"83924:81068:84509:84498", -- [20]
			"83924:81068:84509:84515:84504", -- [21]
			"83924:81068:84509:84498:82511", -- [22]
			"82346:81053:84508", -- [23]
			"83924:81068:84509", -- [24]
			"82346:81053:84495", -- [25]
			"83924:81068:84509:84515", -- [26]
			"79407:76784:86492", -- [27]
			"79407:76784:85829:84700", -- [28]
			"83924:81068:84509:84515:84504:81285:83427", -- [29]
			"79407:87707", -- [30]
			"79407:76784:86492:84714", -- [31]
			"83924:81064:88584", -- [32]
			"88668:88653", -- [33]
			"79407:76784:86492:84714:88757", -- [34]
			"82346:81053:90552:90550", -- [35]
			"82346:81053:90552:90560", -- [36]
			"82346:81053:90552", -- [37]
			"82346:81053:90552:90562", -- [38]
			"82346:81053:90552:92809:92808", -- [39]
			"82346:81053:90552:92809", -- [40]
			["direct"] = "76787:79407:83924:82346:82340:88668",
			["f"] = 0,
			["m"] = 950,
			["coord"] = 3164816434,
		},
		[88653] = {
			"83924:81064:81078:76850", -- [1]
			"88668:79407:76782", -- [2]
			"88668:79407:76879:76781", -- [3]
			"88668:79407:78699:76783", -- [4]
			"88668:79407:76787", -- [5]
			"88668:79407:76879", -- [6]
			"88668:79407:76784", -- [7]
			"88668:79407:78699", -- [8]
			"83924:82346:81053:90552:90550:86049", -- [9]
			"88668:79407", -- [10]
			"83924:82346:81057:80932", -- [11]
			"83924:82346:81053", -- [12]
			"83924:82346:81055", -- [13]
			"83924:82346:81057", -- [14]
			"83924:81064:81058", -- [15]
			"83924:81064", -- [16]
			"83924:81068", -- [17]
			"83924:81064:81078", -- [18]
			"83924:81064:81354", -- [19]
			"82612:81285", -- [20]
			"88668:82844", -- [21]
			"83924:82346", -- [22]
			"82612:84498", -- [23]
			"82612:84515:84504", -- [24]
			"82612:84498:82511", -- [25]
			"83924:82346:81053:84508", -- [26]
			"83924:81068:84509", -- [27]
			"83924:82346:81053:84495", -- [28]
			"82612:84515", -- [29]
			"88668:79407:76784:86492", -- [30]
			"88668:79407:76784:85829:84700", -- [31]
			"82612:81285:83427", -- [32]
			"88668:79407:87707", -- [33]
			"88668:79407:76784:86492:84714", -- [34]
			"82612:88584", -- [35]
			"88668:79407:76784:86492:84714:88757", -- [36]
			"83924:82346:81053:90552:90550", -- [37]
			"83924:82346:81053:90552:90560", -- [38]
			"83924:82346:81053:90552", -- [39]
			"83924:82346:81053:90552:90562", -- [40]
			"83924:82346:81053:90552:92809:92808", -- [41]
			"83924:82346:81053:90552:92809", -- [42]
			["direct"] = "82612:83924:82340:88668",
			["f"] = 0,
			["m"] = 950,
			["coord"] = 2119811622,
		},
		[88668] = {
			"83924:81064:81078:76850", -- [1]
			"79407:76782", -- [2]
			"79407:76879:76781", -- [3]
			"79407:78699:76783", -- [4]
			"79407:76787", -- [5]
			"79407:76879", -- [6]
			"79407:76784", -- [7]
			"79407:78699", -- [8]
			"79407:86049", -- [9]
			"82844:82346:81057:80932", -- [10]
			"82844:82346:81053", -- [11]
			"79407:81055", -- [12]
			"82844:82346:81057", -- [13]
			"82844:82346:81058", -- [14]
			"83924:81064", -- [15]
			"83924:81068", -- [16]
			"83924:81064:81078", -- [17]
			"83924:81064:81354", -- [18]
			"83924:81068:84509:84515:84504:81285", -- [19]
			"83924:81068:84509:82612", -- [20]
			"82844:82346", -- [21]
			"83924:81068:84509:84498", -- [22]
			"83924:81068:84509:84515:84504", -- [23]
			"83924:81068:84509:84498:82511", -- [24]
			"82844:82346:81053:84508", -- [25]
			"83924:81068:84509", -- [26]
			"82844:82346:81053:84495", -- [27]
			"83924:81068:84509:84515", -- [28]
			"79407:76784:86492", -- [29]
			"79407:76784:85829:84700", -- [30]
			"83924:81068:84509:84515:84504:81285:83427", -- [31]
			"79407:87707", -- [32]
			"79407:76784:86492:84714", -- [33]
			"83924:81064:88584", -- [34]
			"79407:76784:86492:84714:88757", -- [35]
			"82844:82346:81053:90552:90550", -- [36]
			"82844:82346:81053:90552:90560", -- [37]
			"82844:82346:81053:90552", -- [38]
			"82844:82346:81053:90552:90562", -- [39]
			"82844:82346:81053:90552:92809:92808", -- [40]
			"82844:82346:81053:90552:92809", -- [41]
			["direct"] = "79407:83924:82844:82340:88653",
			["f"] = 0,
			["m"] = 950,
			["coord"] = 2673169502,
		},
		[87707] = {
			"76784:81057:81354:76850", -- [1]
			"79407:76782", -- [2]
			"78699:76879:76781", -- [3]
			"78699:76783", -- [4]
			"78699:76787", -- [5]
			"78699:76879", -- [6]
			"76784:81055:86049", -- [7]
			"76784:81057:80932", -- [8]
			"76784:84495:81053", -- [9]
			"76784:81055", -- [10]
			"76784:81057", -- [11]
			"76784:81064:81058", -- [12]
			"76784:81064", -- [13]
			"76784:81064:81068", -- [14]
			"76784:81064:81078", -- [15]
			"76784:81057:81354", -- [16]
			"76784:81057:81285", -- [17]
			"76784:81064:81078:84509:82612", -- [18]
			"79407:82346:83924", -- [19]
			"79407:82844", -- [20]
			"79407:82346", -- [21]
			"79407:82340", -- [22]
			"76784:81064:81078:84509:84498", -- [23]
			"76784:81057:84515:84504", -- [24]
			"76784:81057:84515:82511", -- [25]
			"76784:84495:84508", -- [26]
			"76784:81064:81078:84509", -- [27]
			"76784:84495", -- [28]
			"76784:81057:84515", -- [29]
			"76784:86492", -- [30]
			"76784:85829:84700", -- [31]
			"76784:81057:83427", -- [32]
			"76784:86492:84714", -- [33]
			"76784:81057:88584", -- [34]
			"79407:88668:88653", -- [35]
			"79407:88668", -- [36]
			"76784:86492:84714:88757", -- [37]
			"76784:84495:84508:90560:90550", -- [38]
			"76784:84495:84508:90560", -- [39]
			"76784:84495:84508:90552", -- [40]
			"76784:84495:84508:90552:90562", -- [41]
			"76784:84495:84508:90560:92808", -- [42]
			"76784:84495:84508:90552:92809", -- [43]
			["direct"] = "76784:78699:79407",
			["f"] = 0,
			["m"] = 941,
			["coord"] = 3162413431,
		},
		[83427] = {
			"81057:79407:76782", -- [1]
			"81057:79407:76879:76781", -- [2]
			"81057:76784:76787:76783", -- [3]
			"81057:76784:76787", -- [4]
			"81057:79407:76879", -- [5]
			"81057:76784", -- [6]
			"81057:76784:87707:78699", -- [7]
			"81057:79407", -- [8]
			"81057:80932", -- [9]
			"81057:81053", -- [10]
			"81057:81055", -- [11]
			"81285:88584:81354:81058", -- [12]
			"81285:88584:81064", -- [13]
			"81285:81078:81068", -- [14]
			"81285:81078", -- [15]
			"81285:88584:81354", -- [16]
			"81285:82612", -- [17]
			"81285:88584:81064:82346:83924", -- [18]
			"81285:88584:81064:82346:82844", -- [19]
			"81285:88584:81064:82346", -- [20]
			"81285:88584:81064:82346:82340", -- [21]
			"81285:84504:84498", -- [22]
			"81285:84504", -- [23]
			"81285:84504:82511", -- [24]
			"81057:84508", -- [25]
			"81285:82612:84509", -- [26]
			"81057:84495", -- [27]
			"81285:84504:84515", -- [28]
			"81057:81055:86492", -- [29]
			"76850:90562:92808:84714:84700", -- [30]
			"81057:76784:87707", -- [31]
			"76850:90562:92808:84714", -- [32]
			"81285:88584", -- [33]
			"81285:82612:88653", -- [34]
			"81285:88584:81064:82346:82844:88668", -- [35]
			"76850:90562:92808:84714:88757", -- [36]
			"76850:90562:90550", -- [37]
			"76850:90562:90560", -- [38]
			"81057:90552", -- [39]
			"76850:90562", -- [40]
			"76850:90562:92808", -- [41]
			"76850:90562:92809", -- [42]
			["direct"] = "76850:86049:81057:81285",
			["f"] = 0,
			["m"] = 947,
			["coord"] = 2569326670,
		},
		[76879] = {
			"79407:81064:81078:76850", -- [1]
			"76781:76783", -- [2]
			"78699:76787", -- [3]
			"79407:86049", -- [4]
			"79407:81057:80932", -- [5]
			"79407:81053", -- [6]
			"76784:81055", -- [7]
			"79407:81057", -- [8]
			"79407:81064:81058", -- [9]
			"79407:81064", -- [10]
			"79407:81064:81068", -- [11]
			"79407:81064:81078", -- [12]
			"79407:81057:81354", -- [13]
			"79407:81064:88584:81285", -- [14]
			"79407:82612", -- [15]
			"79407:82346:83924", -- [16]
			"79407:82844", -- [17]
			"79407:82346", -- [18]
			"79407:82340", -- [19]
			"79407:84509:84498", -- [20]
			"79407:84509:84515:84504", -- [21]
			"79407:82511", -- [22]
			"79407:81053:84508", -- [23]
			"79407:84509", -- [24]
			"76784:84495", -- [25]
			"79407:84509:84515", -- [26]
			"76784:86492", -- [27]
			"78699:76787:85829:84700", -- [28]
			"79407:81057:83427", -- [29]
			"78699:87707", -- [30]
			"76784:86492:84714", -- [31]
			"79407:81064:88584", -- [32]
			"79407:88668:88653", -- [33]
			"79407:88668", -- [34]
			"76784:86492:84714:88757", -- [35]
			"79407:81053:90552:90550", -- [36]
			"79407:81053:90552:90560", -- [37]
			"79407:81053:90552", -- [38]
			"79407:81053:90552:90562", -- [39]
			"79407:81053:90552:92809:92808", -- [40]
			"79407:81053:90552:92809", -- [41]
			["direct"] = "76782:76781:76784:78699:79407",
			["f"] = 0,
			["m"] = 941,
			["coord"] = 1723565300,
		},
		[85829] = {
			"84714:92808:90562:76850", -- [1]
			"76787:76781:76782", -- [2]
			"76787:76781", -- [3]
			"76787:76783", -- [4]
			"76787:78699:76879", -- [5]
			"76787:78699", -- [6]
			"76784:79407", -- [7]
			"81055:84508:90552:80932", -- [8]
			"81055:84508:81053", -- [9]
			"76784:81057", -- [10]
			"76784:81064:81058", -- [11]
			"76784:81064", -- [12]
			"76784:81064:81068", -- [13]
			"76784:81064:81078", -- [14]
			"76784:81057:81354", -- [15]
			"76784:81057:81285", -- [16]
			"76784:81064:81078:84509:82612", -- [17]
			"76784:79407:82346:83924", -- [18]
			"76784:79407:82844", -- [19]
			"76784:79407:82346", -- [20]
			"76784:79407:82340", -- [21]
			"76784:81064:81078:84509:84498", -- [22]
			"76784:81057:84515:84504", -- [23]
			"76784:81057:84515:82511", -- [24]
			"81055:84508", -- [25]
			"76784:81064:81078:84509", -- [26]
			"76784:81057:84515", -- [27]
			"76784:81057:83427", -- [28]
			"76784:87707", -- [29]
			"76784:81057:88584", -- [30]
			"76784:79407:88668:88653", -- [31]
			"76784:79407:88668", -- [32]
			"84714:88757", -- [33]
			"84714:92808:90550", -- [34]
			"81055:84508:90560", -- [35]
			"81055:84508:90552", -- [36]
			"84714:92808:90562", -- [37]
			"84714:92808", -- [38]
			"81055:84508:90552:92809", -- [39]
			["direct"] = "76787:76784:86049:81055:84495:86492:84700:84714",
			["f"] = 0,
			["m"] = 949,
			["coord"] = 1698586013,
		},
		[79407] = {
			"81064:81078:76850", -- [1]
			"78699:76783", -- [2]
			"81057:80932", -- [3]
			"81064:81058", -- [4]
			"81064:81068", -- [5]
			"81064:81078", -- [6]
			"81057:81354", -- [7]
			"81064:88584:81285", -- [8]
			"82346:83924", -- [9]
			"84509:84498", -- [10]
			"84509:84515:84504", -- [11]
			"81053:84508", -- [12]
			"81053:84495", -- [13]
			"84509:84515", -- [14]
			"76784:86492", -- [15]
			"76784:85829:84700", -- [16]
			"81057:83427", -- [17]
			"76784:86492:84714", -- [18]
			"81064:88584", -- [19]
			"88668:88653", -- [20]
			"76784:86492:84714:88757", -- [21]
			"81053:90552:90550", -- [22]
			"81053:90552:90560", -- [23]
			"81053:90552", -- [24]
			"81053:90552:90562", -- [25]
			"81053:90552:92809:92808", -- [26]
			"81053:90552:92809", -- [27]
			["m"] = 976,
			["f"] = 0,
			["direct"] = "76782:76781:76787:76879:76784:78699:86049:81053:81055:81057:81064:82612:82844:82346:82340:82511:84509:87707:88668",
			["coord"] = 1955824127,
		},
		[90562] = {
			"90552:81053:79407:76782", -- [1]
			"90560:84508:84495:76784:76879:76781", -- [2]
			"90560:84508:84495:76784:76787:76783", -- [3]
			"90560:84508:84495:76784:76787", -- [4]
			"90560:84508:84495:76784:76879", -- [5]
			"90560:84508:84495:76784", -- [6]
			"90560:84508:84495:76784:87707:78699", -- [7]
			"90550:86049", -- [8]
			"90552:81053:79407", -- [9]
			"90552:81053", -- [10]
			"90560:84508:81055", -- [11]
			"80932:81057", -- [12]
			"80932:81057:81058", -- [13]
			"80932:81057:81058:81064", -- [14]
			"80932:81354:81078:81068", -- [15]
			"80932:81354:81078", -- [16]
			"80932:81354", -- [17]
			"76850:81285", -- [18]
			"76850:88584:82612", -- [19]
			"90552:81053:82346:83924", -- [20]
			"90552:81053:82346:82844", -- [21]
			"90552:81053:82346", -- [22]
			"90552:81053:82346:82340", -- [23]
			"76850:88584:84515:84498", -- [24]
			"76850:84504", -- [25]
			"76850:84504:82511", -- [26]
			"90560:84508", -- [27]
			"80932:81354:81078:84509", -- [28]
			"90560:84508:84495", -- [29]
			"76850:88584:84515", -- [30]
			"90560:84508:81055:86492", -- [31]
			"92808:84714:84700", -- [32]
			"76850:83427", -- [33]
			"90560:84508:84495:76784:87707", -- [34]
			"92808:84714", -- [35]
			"76850:88584", -- [36]
			"90552:81053:82346:83924:88653", -- [37]
			"90552:81053:82346:82844:88668", -- [38]
			"92808:84714:88757", -- [39]
			["direct"] = "76850:80932:90550:90560:90552:92808:92809",
			["f"] = 0,
			["m"] = 945,
			["coord"] = 2021438409,
		},
		[81053] = {
			"90552:90562:76850", -- [1]
			"79407:76782", -- [2]
			"79407:76879:76781", -- [3]
			"79407:78699:76783", -- [4]
			"84495:76784:76787", -- [5]
			"79407:76879", -- [6]
			"84495:76784", -- [7]
			"79407:78699", -- [8]
			"90552:90550:86049", -- [9]
			"90552:80932", -- [10]
			"84495:81055", -- [11]
			"81058:81064", -- [12]
			"81058:81064:81068", -- [13]
			"81058:81078", -- [14]
			"81057:81354", -- [15]
			"81057:81285", -- [16]
			"81058:81078:84509:82612", -- [17]
			"82346:83924", -- [18]
			"82346:82844", -- [19]
			"82346:82340", -- [20]
			"81058:81078:84509:84498", -- [21]
			"81058:81078:84509:84515:84504", -- [22]
			"81058:81078:84509:84498:82511", -- [23]
			"81058:81078:84509", -- [24]
			"81058:81078:84509:84515", -- [25]
			"84495:81055:86492", -- [26]
			"84495:81055:84700", -- [27]
			"81057:83427", -- [28]
			"84495:76784:87707", -- [29]
			"84495:81055:84714", -- [30]
			"81058:81064:88584", -- [31]
			"82346:83924:88653", -- [32]
			"82346:82844:88668", -- [33]
			"84495:81055:84714:88757", -- [34]
			"90552:90550", -- [35]
			"90552:90560", -- [36]
			"90552:90562", -- [37]
			"90552:92809:92808", -- [38]
			"90552:92809", -- [39]
			["direct"] = "79407:81057:81058:82346:84508:84495:90552",
			["f"] = 0,
			["m"] = 946,
			["coord"] = 2641042193,
		},
		[81057] = {
			"81354:76850", -- [1]
			"79407:76782", -- [2]
			"79407:76879:76781", -- [3]
			"76784:76787:76783", -- [4]
			"76784:76787", -- [5]
			"79407:76879", -- [6]
			"76784:87707:78699", -- [7]
			"81058:81064:81068", -- [8]
			"81058:81078", -- [9]
			"82346:83924", -- [10]
			"82346:82844", -- [11]
			"82346:82340", -- [12]
			"84515:84498", -- [13]
			"84515:84504", -- [14]
			"84515:82511", -- [15]
			"81058:81078:84509", -- [16]
			"81055:86492", -- [17]
			"81055:84700", -- [18]
			"76784:87707", -- [19]
			"81055:84714", -- [20]
			"82346:83924:88653", -- [21]
			"82346:82844:88668", -- [22]
			"81055:84714:88757", -- [23]
			"90552:90550", -- [24]
			"90552:90560", -- [25]
			"80932:90562", -- [26]
			"80932:92809:92808", -- [27]
			"80932:92809", -- [28]
			["m"] = 946,
			["f"] = 0,
			["direct"] = "76784:86049:79407:80932:81053:81055:81058:81064:81354:81285:82612:82346:84508:84495:84515:83427:88584:90552",
			["coord"] = 3040299854,
		},
		[90550] = {
			"90562:76850", -- [1]
			"90560:84508:84495:76784:79407:76782", -- [2]
			"90560:84508:84495:76784:76879:76781", -- [3]
			"90560:84508:84495:76784:76787:76783", -- [4]
			"90560:84508:84495:76784:76787", -- [5]
			"90560:84508:84495:76784:76879", -- [6]
			"90560:84508:84495:76784", -- [7]
			"90560:84508:84495:76784:87707:78699", -- [8]
			"90560:84508:84495:76784:79407", -- [9]
			"90562:80932", -- [10]
			"90560:84508:81053", -- [11]
			"90560:84508:81055", -- [12]
			"90552:81057", -- [13]
			"90560:84508:81053:81058", -- [14]
			"90560:84508:81053:81058:81064", -- [15]
			"90560:84508:81053:81058:81064:81068", -- [16]
			"90562:80932:81354:81078", -- [17]
			"90562:80932:81354", -- [18]
			"90562:76850:81285", -- [19]
			"90562:76850:88584:82612", -- [20]
			"90560:84508:81053:82346:83924", -- [21]
			"90560:84508:81053:82346:82844", -- [22]
			"90560:84508:81053:82346", -- [23]
			"90560:84508:81053:82346:82340", -- [24]
			"90562:76850:88584:84515:84498", -- [25]
			"90562:76850:84504", -- [26]
			"90562:76850:84504:82511", -- [27]
			"90560:84508", -- [28]
			"90562:80932:81354:81078:84509", -- [29]
			"90560:84508:84495", -- [30]
			"90562:76850:88584:84515", -- [31]
			"90560:84508:81055:86492", -- [32]
			"92808:84714:84700", -- [33]
			"90562:76850:83427", -- [34]
			"90560:84508:84495:76784:87707", -- [35]
			"92808:84714", -- [36]
			"90562:76850:88584", -- [37]
			"90560:84508:81053:82346:83924:88653", -- [38]
			"90560:84508:81053:82346:82844:88668", -- [39]
			"92808:84714:88757", -- [40]
			"92808:92809", -- [41]
			["direct"] = "86049:90560:90552:90562:92808",
			["f"] = 0,
			["m"] = 945,
			["coord"] = 2596304611,
		},
		[76781] = {
			"79407:81064:81078:76850", -- [1]
			"76879:76784", -- [2]
			"76879:78699", -- [3]
			"79407:86049", -- [4]
			"79407:81057:80932", -- [5]
			"79407:81053", -- [6]
			"79407:81055", -- [7]
			"79407:81057", -- [8]
			"79407:81064:81058", -- [9]
			"79407:81064", -- [10]
			"79407:81064:81068", -- [11]
			"79407:81064:81078", -- [12]
			"79407:81057:81354", -- [13]
			"79407:81064:88584:81285", -- [14]
			"79407:82612", -- [15]
			"79407:82346:83924", -- [16]
			"79407:82844", -- [17]
			"79407:82346", -- [18]
			"79407:82340", -- [19]
			"79407:84509:84498", -- [20]
			"79407:84509:84515:84504", -- [21]
			"79407:82511", -- [22]
			"79407:81053:84508", -- [23]
			"79407:84509", -- [24]
			"79407:81053:84495", -- [25]
			"79407:84509:84515", -- [26]
			"76879:76784:86492", -- [27]
			"76787:85829:84700", -- [28]
			"79407:81057:83427", -- [29]
			"79407:87707", -- [30]
			"76879:76784:86492:84714", -- [31]
			"79407:81064:88584", -- [32]
			"79407:88668:88653", -- [33]
			"79407:88668", -- [34]
			"76879:76784:86492:84714:88757", -- [35]
			"79407:81053:90552:90550", -- [36]
			"79407:81053:90552:90560", -- [37]
			"79407:81053:90552", -- [38]
			"79407:81053:90552:90562", -- [39]
			"79407:81053:90552:92809:92808", -- [40]
			"79407:81053:90552:92809", -- [41]
			["direct"] = "76782:76783:76787:76879:79407",
			["f"] = 1,
			["m"] = 941,
			["coord"] = 865371460,
		},
		[84498] = {
			"84504:76850", -- [1]
			"82612:79407:76782", -- [2]
			"82612:79407:76879:76781", -- [3]
			"82612:79407:78699:76783", -- [4]
			"82612:81064:76787", -- [5]
			"82612:79407:76879", -- [6]
			"82612:81064:76784", -- [7]
			"82612:79407:78699", -- [8]
			"84504:76850:86049", -- [9]
			"82612:79407", -- [10]
			"84515:81354:80932", -- [11]
			"82612:81057:81053", -- [12]
			"82612:81057:81055", -- [13]
			"82612:81057", -- [14]
			"82612:81064:81058", -- [15]
			"82612:81064", -- [16]
			"84509:81068", -- [17]
			"84509:81078", -- [18]
			"84515:81354", -- [19]
			"84504:81285", -- [20]
			"82612:82346:83924", -- [21]
			"82612:82346:82844", -- [22]
			"82612:82346", -- [23]
			"82612:82340", -- [24]
			"82612:81057:84508", -- [25]
			"82612:81057:84495", -- [26]
			"82612:81064:76784:86492", -- [27]
			"82612:81064:76784:85829:84700", -- [28]
			"84504:81285:83427", -- [29]
			"82612:81064:76784:87707", -- [30]
			"82612:81057:81055:84714", -- [31]
			"84504:88584", -- [32]
			"82612:88653", -- [33]
			"82612:82346:82844:88668", -- [34]
			"82612:81057:81055:84714:88757", -- [35]
			"84504:76850:90562:90550", -- [36]
			"84515:81354:80932:90560", -- [37]
			"82612:81057:90552", -- [38]
			"84504:76850:90562", -- [39]
			"84504:76850:90562:92808", -- [40]
			"84515:81354:80932:92809", -- [41]
			["direct"] = "82612:84504:82511:84509:84515",
			["f"] = 0,
			["m"] = 948,
			["coord"] = 1983803631,
		},
		[84504] = {
			"88584:81064:79407:76782", -- [1]
			"88584:81064:79407:76879:76781", -- [2]
			"88584:81064:76787:76783", -- [3]
			"88584:81064:76787", -- [4]
			"88584:81064:79407:76879", -- [5]
			"88584:81057:76784", -- [6]
			"88584:81064:79407:78699", -- [7]
			"76850:86049", -- [8]
			"88584:81064:79407", -- [9]
			"88584:81354:80932", -- [10]
			"88584:81057:81053", -- [11]
			"88584:81057:81055", -- [12]
			"88584:81057", -- [13]
			"88584:81354:81058", -- [14]
			"88584:81064", -- [15]
			"84498:84509:81068", -- [16]
			"88584:81078", -- [17]
			"88584:81354", -- [18]
			"84498:82612", -- [19]
			"88584:81064:82346:83924", -- [20]
			"88584:81064:82346:82844", -- [21]
			"88584:81064:82346", -- [22]
			"84498:82612:82340", -- [23]
			"88584:81057:84508", -- [24]
			"84498:84509", -- [25]
			"88584:81057:84495", -- [26]
			"88584:81057:81055:86492", -- [27]
			"88584:81057:81055:84700", -- [28]
			"81285:83427", -- [29]
			"88584:81057:76784:87707", -- [30]
			"88584:81057:81055:84714", -- [31]
			"84498:82612:88653", -- [32]
			"88584:81064:82346:82844:88668", -- [33]
			"88584:81057:81055:84714:88757", -- [34]
			"76850:90562:90550", -- [35]
			"88584:81354:80932:90560", -- [36]
			"88584:81057:90552", -- [37]
			"76850:90562", -- [38]
			"76850:90562:92808", -- [39]
			"88584:81354:80932:92809", -- [40]
			["direct"] = "76850:81285:84498:82511:84515:88584",
			["f"] = 0,
			["m"] = 948,
			["coord"] = 2659216644,
		},
		[90552] = {
			"90562:76850", -- [1]
			"81053:79407:76782", -- [2]
			"81053:79407:76879:76781", -- [3]
			"84508:84495:76784:76787:76783", -- [4]
			"84508:84495:76784:76787", -- [5]
			"81053:79407:76879", -- [6]
			"84508:84495:76784", -- [7]
			"84508:84495:76784:87707:78699", -- [8]
			"90550:86049", -- [9]
			"81053:79407", -- [10]
			"84508:81055", -- [11]
			"81053:81058", -- [12]
			"81053:81058:81064", -- [13]
			"81053:81058:81064:81068", -- [14]
			"81053:81058:81078", -- [15]
			"81057:81354", -- [16]
			"81057:81285", -- [17]
			"81057:82612", -- [18]
			"81053:82346:83924", -- [19]
			"81053:82346:82844", -- [20]
			"81053:82346", -- [21]
			"81053:82346:82340", -- [22]
			"81057:84515:84498", -- [23]
			"81057:84515:84504", -- [24]
			"81057:84515:82511", -- [25]
			"81053:81058:81078:84509", -- [26]
			"84508:84495", -- [27]
			"81057:84515", -- [28]
			"84508:81055:86492", -- [29]
			"84508:81055:84700", -- [30]
			"81057:83427", -- [31]
			"84508:84495:76784:87707", -- [32]
			"84508:81055:84714", -- [33]
			"81057:88584", -- [34]
			"81053:82346:83924:88653", -- [35]
			"81053:82346:82844:88668", -- [36]
			"84508:81055:84714:88757", -- [37]
			"92809:92808", -- [38]
			["direct"] = "80932:81053:81057:84508:90550:90560:90562:92809",
			["f"] = 0,
			["m"] = 945,
			["coord"] = 402296556,
		},
		[84495] = {
			"84508:90552:90562:76850", -- [1]
			"76784:79407:76782", -- [2]
			"76784:76879:76781", -- [3]
			"76784:76787:76783", -- [4]
			"76784:76787", -- [5]
			"76784:76879", -- [6]
			"76784:87707:78699", -- [7]
			"76784:79407", -- [8]
			"84508:90552:80932", -- [9]
			"81053:81058", -- [10]
			"81053:81058:81064", -- [11]
			"81053:81058:81064:81068", -- [12]
			"81053:81058:81078", -- [13]
			"81057:81354", -- [14]
			"81057:81285", -- [15]
			"81057:82612", -- [16]
			"81053:82346:83924", -- [17]
			"81053:82346:82844", -- [18]
			"81053:82346", -- [19]
			"81053:82346:82340", -- [20]
			"81057:84515:84498", -- [21]
			"81057:84515:84504", -- [22]
			"81057:84515:82511", -- [23]
			"81053:81058:81078:84509", -- [24]
			"81057:84515", -- [25]
			"81055:86492", -- [26]
			"81055:84700", -- [27]
			"81057:83427", -- [28]
			"76784:87707", -- [29]
			"81055:84714", -- [30]
			"81057:88584", -- [31]
			"81053:82346:83924:88653", -- [32]
			"81053:82346:82844:88668", -- [33]
			"81055:84714:88757", -- [34]
			"84508:90560:90550", -- [35]
			"84508:90560", -- [36]
			"84508:90552", -- [37]
			"84508:90552:90562", -- [38]
			"84508:90560:92808", -- [39]
			"84508:90552:92809", -- [40]
			["direct"] = "76784:86049:81053:81055:81057:84508",
			["f"] = 0,
			["m"] = 949,
			["coord"] = 1774903093,
		},
		[76784] = {
			"81057:81354:76850", -- [1]
			"79407:76782", -- [2]
			"76879:76781", -- [3]
			"76787:76783", -- [4]
			"87707:78699", -- [5]
			"81055:86049", -- [6]
			"81057:80932", -- [7]
			"84495:81053", -- [8]
			"81064:81058", -- [9]
			"81064:81068", -- [10]
			"81064:81078", -- [11]
			"81057:81354", -- [12]
			"81057:81285", -- [13]
			"81064:81078:84509:82612", -- [14]
			"79407:82346:83924", -- [15]
			"79407:82844", -- [16]
			"79407:82346", -- [17]
			"79407:82340", -- [18]
			"81064:81078:84509:84498", -- [19]
			"81057:84515:84504", -- [20]
			"81057:84515:82511", -- [21]
			"84495:84508", -- [22]
			"81064:81078:84509", -- [23]
			"81057:84515", -- [24]
			"85829:84700", -- [25]
			"81057:83427", -- [26]
			"86492:84714", -- [27]
			"81057:88584", -- [28]
			"79407:88668:88653", -- [29]
			"79407:88668", -- [30]
			"86492:84714:88757", -- [31]
			"84495:84508:90560:90550", -- [32]
			"84495:84508:90560", -- [33]
			"84495:84508:90552", -- [34]
			"84495:84508:90552:90562", -- [35]
			"84495:84508:90560:92808", -- [36]
			"84495:84508:90552:92809", -- [37]
			["direct"] = "76787:76879:79407:81055:81057:81064:84495:86492:87707",
			["f"] = 0,
			["m"] = 941,
			["coord"] = 3590298639,
		},
		[83924] = {
			"81064:81078:76850", -- [1]
			"82346:79407:76782", -- [2]
			"82346:79407:76879:76781", -- [3]
			"82346:79407:78699:76783", -- [4]
			"82346:79407:76787", -- [5]
			"82346:79407:76879", -- [6]
			"82346:79407:76784", -- [7]
			"82346:79407:78699", -- [8]
			"82346:81053:90552:90550:86049", -- [9]
			"82346:79407", -- [10]
			"82346:81057:80932", -- [11]
			"82346:81053", -- [12]
			"82346:81055", -- [13]
			"82346:81057", -- [14]
			"81064:81058", -- [15]
			"81064:81078", -- [16]
			"81064:81354", -- [17]
			"81068:84509:84515:84504:81285", -- [18]
			"81068:84509:82612", -- [19]
			"81068:84509:84498", -- [20]
			"81068:84509:84515:84504", -- [21]
			"81068:84509:84498:82511", -- [22]
			"82346:81053:84508", -- [23]
			"81068:84509", -- [24]
			"82346:81053:84495", -- [25]
			"81068:84509:84515", -- [26]
			"82346:81055:86492", -- [27]
			"82346:81055:84700", -- [28]
			"81068:84509:84515:84504:81285:83427", -- [29]
			"82346:79407:87707", -- [30]
			"82346:81055:84714", -- [31]
			"81064:88584", -- [32]
			"82844:88668", -- [33]
			"82346:81055:84714:88757", -- [34]
			"82346:81053:90552:90550", -- [35]
			"82346:81053:90552:90560", -- [36]
			"82346:81053:90552", -- [37]
			"82346:81053:90552:90562", -- [38]
			"82346:81053:90552:92809:92808", -- [39]
			"82346:81053:90552:92809", -- [40]
			["direct"] = "81064:81068:82844:82346:82340:88653",
			["f"] = 0,
			["m"] = 950,
			["coord"] = 3426975588,
		},
		[78699] = {
			"79407:81064:81078:76850", -- [1]
			"76879:76782", -- [2]
			"76879:76781", -- [3]
			"87707:76784", -- [4]
			"79407:86049", -- [5]
			"79407:81057:80932", -- [6]
			"79407:81053", -- [7]
			"87707:76784:81055", -- [8]
			"79407:81057", -- [9]
			"79407:81064:81058", -- [10]
			"79407:81064", -- [11]
			"79407:81064:81068", -- [12]
			"79407:81064:81078", -- [13]
			"79407:81057:81354", -- [14]
			"79407:81064:88584:81285", -- [15]
			"79407:82612", -- [16]
			"79407:82346:83924", -- [17]
			"79407:82844", -- [18]
			"79407:82346", -- [19]
			"79407:82340", -- [20]
			"79407:84509:84498", -- [21]
			"79407:84509:84515:84504", -- [22]
			"79407:82511", -- [23]
			"79407:81053:84508", -- [24]
			"79407:84509", -- [25]
			"87707:76784:84495", -- [26]
			"79407:84509:84515", -- [27]
			"87707:76784:86492", -- [28]
			"76787:85829:84700", -- [29]
			"79407:81057:83427", -- [30]
			"87707:76784:86492:84714", -- [31]
			"79407:81064:88584", -- [32]
			"79407:88668:88653", -- [33]
			"79407:88668", -- [34]
			"87707:76784:86492:84714:88757", -- [35]
			"79407:81053:90552:90550", -- [36]
			"79407:81053:90552:90560", -- [37]
			"79407:81053:90552", -- [38]
			"79407:81053:90552:90562", -- [39]
			"79407:81053:90552:92809:92808", -- [40]
			"79407:81053:90552:92809", -- [41]
			["direct"] = "76783:76787:76879:79407:87707",
			["f"] = 0,
			["m"] = 941,
			["coord"] = 2222221612,
		},
		[82612] = {
			"88584:76850", -- [1]
			"79407:76782", -- [2]
			"79407:76879:76781", -- [3]
			"79407:78699:76783", -- [4]
			"81064:76787", -- [5]
			"79407:76879", -- [6]
			"81064:76784", -- [7]
			"79407:78699", -- [8]
			"88584:86049", -- [9]
			"84515:81354:80932", -- [10]
			"81057:81053", -- [11]
			"81057:81055", -- [12]
			"81064:81058", -- [13]
			"84509:81068", -- [14]
			"84509:81078", -- [15]
			"84515:81354", -- [16]
			"82346:83924", -- [17]
			"82346:82844", -- [18]
			"84515:84504", -- [19]
			"84498:82511", -- [20]
			"81057:84508", -- [21]
			"81057:84495", -- [22]
			"81064:76784:86492", -- [23]
			"81064:76784:85829:84700", -- [24]
			"81285:83427", -- [25]
			"81064:76784:87707", -- [26]
			"81057:81055:84714", -- [27]
			"82346:82844:88668", -- [28]
			"81057:81055:84714:88757", -- [29]
			"88584:76850:90562:90550", -- [30]
			"84515:81354:80932:90560", -- [31]
			"81057:90552", -- [32]
			"88584:76850:90562", -- [33]
			"84515:81354:80932:92809:92808", -- [34]
			"84515:81354:80932:92809", -- [35]
			["direct"] = "79407:81057:81064:81285:82346:82340:84498:84509:84515:88584:88653",
			["f"] = 0,
			["m"] = 948,
			["coord"] = 1697804031,
		},
		[88757] = {
			"84714:92808:90562:76850", -- [1]
			"84714:86492:76784:79407:76782", -- [2]
			"84714:85829:76787:76781", -- [3]
			"84714:85829:76787:76783", -- [4]
			"84714:85829:76787", -- [5]
			"84714:86492:76784:76879", -- [6]
			"84714:86492:76784", -- [7]
			"84714:86492:76784:87707:78699", -- [8]
			"84714:86049", -- [9]
			"84714:86492:76784:79407", -- [10]
			"84714:92808:92809:80932", -- [11]
			"84714:81055:84508:81053", -- [12]
			"84714:81055", -- [13]
			"84714:81055:81057", -- [14]
			"84714:81055:84508:81053:81058", -- [15]
			"84714:86492:76784:81064", -- [16]
			"84714:86492:76784:81064:81068", -- [17]
			"84714:86492:76784:81064:81078", -- [18]
			"84714:81055:81057:81354", -- [19]
			"84714:92808:90562:76850:81285", -- [20]
			"84714:81055:81057:82612", -- [21]
			"84714:81055:82346:83924", -- [22]
			"84714:86492:76784:79407:82844", -- [23]
			"84714:81055:82346", -- [24]
			"84714:86492:76784:79407:82340", -- [25]
			"84714:81055:81057:84515:84498", -- [26]
			"84714:81055:81057:84515:84504", -- [27]
			"84714:81055:81057:84515:82511", -- [28]
			"84714:81055:84508", -- [29]
			"84714:86492:76784:81064:81078:84509", -- [30]
			"84714:81055:84495", -- [31]
			"84714:81055:81057:84515", -- [32]
			"84714:86492", -- [33]
			"84714:84700", -- [34]
			"84714:92808:90562:76850:83427", -- [35]
			"84714:86492:76784:87707", -- [36]
			"84714:81055:81057:88584", -- [37]
			"84714:81055:82346:83924:88653", -- [38]
			"84714:86492:76784:79407:88668", -- [39]
			"84714:92808:90550", -- [40]
			"84714:92808:90560", -- [41]
			"84714:81055:84508:90552", -- [42]
			"84714:92808:90562", -- [43]
			"84714:92808", -- [44]
			"84714:92808:92809", -- [45]
			["direct"] = "84714",
			["f"] = 0,
			["m"] = 949,
			["coord"] = 2952612255,
		},
		[76787] = {
			"81064:81078:76850", -- [1]
			"76781:76782", -- [2]
			"78699:76879", -- [3]
			"85829:86049", -- [4]
			"76784:81057:80932", -- [5]
			"78699:79407:81053", -- [6]
			"76784:81055", -- [7]
			"76784:81057", -- [8]
			"81064:81058", -- [9]
			"81064:81068", -- [10]
			"81064:81078", -- [11]
			"76784:81057:81354", -- [12]
			"81064:88584:81285", -- [13]
			"78699:79407:82612", -- [14]
			"78699:79407:82346:83924", -- [15]
			"78699:79407:82346", -- [16]
			"XY-966296888:82340", -- [17]
			"81064:81078:84509:84498", -- [18]
			"81064:81078:84509:84515:84504", -- [19]
			"78699:79407:82511", -- [20]
			"76784:84495:84508", -- [21]
			"81064:81078:84509", -- [22]
			"76784:84495", -- [23]
			"81064:81078:84509:84515", -- [24]
			"76784:86492", -- [25]
			"85829:84700", -- [26]
			"76784:81057:83427", -- [27]
			"78699:87707", -- [28]
			"85829:84714", -- [29]
			"81064:88584", -- [30]
			"XY-966296888:88653", -- [31]
			"82844:88668", -- [32]
			"85829:84714:88757", -- [33]
			"85829:84714:92808:90550", -- [34]
			"76784:84495:84508:90560", -- [35]
			"78699:79407:81053:90552", -- [36]
			"78699:79407:81053:90552:90562", -- [37]
			"85829:84714:92808", -- [38]
			"78699:79407:81053:90552:92809", -- [39]
			["direct"] = "76781:76783:76784:78699:79407:81064:82844",
			["f"] = 0,
			["m"] = 941,
			["coord"] = 2211067641,
		},
	},
	[8] = {
		[108888] = {
			"88110:90556", -- [1]
			"110971:90639", -- [2]
			"88110:90556:93447", -- [3]
			"88110:90556:93447:93940", -- [4]
			"112866:111624:114666:100550:95688", -- [5]
			"112866:111624:111675:114718:92560", -- [6]
			"112866:111624:111675:114718:111420:98105", -- [7]
			"112866:111624:111675:98966:98124", -- [8]
			"112866:111624:111675:114718:92560:98161", -- [9]
			"112866:111624:114666:100550:94973:97860", -- [10]
			"112866:111624:114666:100550:94973:97868", -- [11]
			"112866:111624:114666:100550:97870", -- [12]
			"112866:111624:114666:100550:94973:97868:98066", -- [13]
			"112866:111624:114666:96565", -- [14]
			"112866:111624:111675:98966", -- [15]
			"112866:111624:114666:100550:94973:97860:98972", -- [16]
			"112866:111624:114666:100468", -- [17]
			"88110:90556:93447:100459", -- [18]
			"112866:111624:114666:100550:94973", -- [19]
			"112866:96813", -- [20]
			"112866:111624:114666:100550", -- [21]
			"112866:111624:111675:98966:100559", -- [22]
			"112866:111624:111675:114718:92560:98161:111314", -- [23]
			"112866:96813:111323", -- [24]
			"112866:111624:111675:98966:111327", -- [25]
			"112866:111624:111675", -- [26]
			"112866:111624", -- [27]
			"112866:111624:111675:114718:111420", -- [28]
			"111418:112926", -- [29]
			"112866:111624:111675:114718", -- [30]
			"112866:111624:114666", -- [31]
			"110971:90639:114837", -- [32]
			"112866:96813:111323:93465", -- [33]
			"112866:96813:120272", -- [1]
			"112866:96813:111323:120118", -- [2]			
			["m"] = 1015,
			["coord"] = 2070330066,
			["direct"] = "88110:112866:111418:110971",
			["f"] = 0,
		},
		[110971] = {
			"88110:90556", -- [1]
			"88110:112866", -- [2]
			"90639:93447", -- [3]
			"90639:93940", -- [4]
			"90639:93447:100459:100468:100550:95688", -- [5]
			"88110:90556:111675:114718:92560", -- [6]
			"88110:90556:111675:114718:111420:98105", -- [7]
			"88110:90556:111675:98966:98124", -- [8]
			"88110:90556:111675:114718:92560:98161", -- [9]
			"90639:93447:100459:100468:100550:94973:97860", -- [10]
			"90639:93447:100459:100468:100550:94973:97868", -- [11]
			"90639:93447:100459:100468:100550:97870", -- [12]
			"90639:93447:100459:100468:100550:94973:97868:98066", -- [13]
			"90639:114666:96565", -- [14]
			"88110:90556:111675:98966", -- [15]
			"90639:93447:100459:100468:100550:94973:97860:98972", -- [16]
			"90639:93447:100459:100468", -- [17]
			"90639:93447:100459", -- [18]
			"90639:93447:100459:100468:100550:94973", -- [19]
			"88110:112866:96813", -- [20]
			"90639:93447:100459:100468:100550", -- [21]
			"88110:90556:111675:98966:100559", -- [22]
			"88110:90556:111675:114718:92560:98161:111314", -- [23]
			"88110:112866:96813:111323", -- [24]
			"88110:90556:111675:98966:111327", -- [25]
			"88110:90556:111675", -- [26]
			"88110:90556:111624", -- [27]
			"108888:111418", -- [28]
			"88110:90556:111675:114718:111420", -- [29]
			"108888:111418:112926", -- [30]
			"88110:90556:111675:114718", -- [31]
			"90639:114666", -- [32]
			"90639:114837", -- [33]
			"88110:112866:96813:111323:93465", -- [34]
			"90639:93447:100459:100468:100550:98968:97868", -- [7]
			"90639:93447:100459:100468:100550:98968:97868:98066", -- [8]
			"90639:93447:100459:100468:100550:98968", -- [11]
			"90639:93940:107457", -- [20]
			"88110:112866:96813:120272", -- [1]
			"88110:112866:96813:111323:120118", -- [2]			
			["direct"] = "90639:88110:108888",
			["coord"] = 1367111308,
			["m"] = 1015,
			["f"] = 0,
		},
		[94973] = {
			"100550:114666:90556", -- [1]
			"100550:114666:90639", -- [2]

			"100550:114666:90556:88110", -- [3]
			"100550:114666:111624:112866", -- [4]
			"100550:100468:100459:93447", -- [5]
			"100550:100468:100459:93940", -- [6]
			"95688:100559:92560", -- [7]
			"95688:100559:92560:98105", -- [8]
			"95688:100559:98124", -- [9]
			"95688:100559:92560:98161", -- [10]
			"97868:98066", -- [11]
			"100550:96565", -- [12]
			"95688:98966", -- [13]
			"97860:98972", -- [14]
			"100550:100468", -- [15]
			"100550:100468:100459", -- [16]
			"100550:114666:111675:96813", -- [17]
			"95688:100559", -- [18]
			"100550:114666:111624:112866:108888", -- [19]
			"97860:111314", -- [20]
			"100550:114666:111675:111323", -- [21]
			"95688:100559:98124:111327", -- [22]
			"100550:114666:111675", -- [23]
			"100550:114666:111624", -- [24]
			"100550:114666:111624:112866:108888:111418", -- [25]
			"100550:114666:90639:110971", -- [26]
			"95688:100559:92560:98105:111420", -- [27]
			"100550:114666:111624:112866:112926", -- [28]
			"100550:96565:114718", -- [29]
			"100550:114666", -- [30]
			"100550:100468:100459:93940:114837", -- [31]
			"100550:96565:114718:93465", -- [32]
			"97870:107457", -- [9]
			"100550:114666:111675:111323:120272", -- [1]
			"100550:114666:111675:111323:120118", -- [2]			
			["m"] = 1024,
			["f"] = 0,
			["direct"] = "95688:97860:97868:97870:100550:98968",
			["coord"] = 1728546507,
		},
		[88110] = {
			"90556:90639", -- [1]
			"90556:93447", -- [2]
			"90556:93447:93940", -- [3]
			"90556:114666:100550:95688", -- [4]
			"90556:111675:114718:92560", -- [5]
			"90556:111675:114718:111420:98105", -- [6]
			"90556:111675:98966:98124", -- [7]
			"90556:111675:114718:92560:98161", -- [8]
			"90556:114666:100550:94973:97860", -- [9]
			"90556:114666:100550:94973:97868", -- [10]
			"90556:114666:100550:97870", -- [11]
			"90556:114666:100550:94973:97868:98066", -- [12]
			"90556:114666:96565", -- [13]
			"90556:111675:98966", -- [14]
			"90556:114666:100550:94973:97860:98972", -- [15]
			"90556:93447:100459:100468", -- [16]
			"90556:93447:100459", -- [17]
			"90556:114666:100550:94973", -- [18]
			"112866:96813", -- [19]
			"90556:114666:100550", -- [20]
			"90556:111675:98966:100559", -- [21]
			"90556:111675:114718:92560:98161:111314", -- [22]
			"112866:96813:111323", -- [23]
			"90556:111675:98966:111327", -- [24]
			"90556:111675", -- [25]
			"90556:111624", -- [26]
			"108888:111418", -- [27]
			"90556:111675:114718:111420", -- [28]
			"108888:111418:112926", -- [29]
			"90556:111675:114718", -- [30]
			"90556:114666", -- [31]
			"90556:90639:114837", -- [32]
			"112866:96813:111323:93465", -- [33]
			"90556:93447:100459:107457", -- [22]
			"112866:96813:120272", -- [1]
			"112866:96813:111323:120118", -- [2]			
			["m"] = 1015,
			["coord"] = 1916301339,
			["direct"] = "90556:112866:108888:110971",
			["f"] = 0,
		},
		[120118] = {
			"120272:96813:111624:90556", -- [1]
			"120272:96813:111624:90639", -- [2]
			"120272:96813:112866:88110", -- [3]
			"120272:96813:112866", -- [4]
			"111323:111675:114666:93447", -- [5]
			"111323:111675:114666:100459:93940", -- [6]
			"111323:111675:114666:100550:95688", -- [7]
			"111323:111420:98105:92560", -- [8]
			"111323:111420:98105", -- [9]
			"111323:111420:98105:92560:98124", -- [10]
			"111323:111420:98161", -- [11]
			"111323:111420:98105:92560:100559:97860", -- [12]
			"111323:111675:114666:100550:94973:97868", -- [13]
			"111323:111675:114666:100550:97870", -- [14]
			"111323:111675:114666:100550:94973:97868:98066", -- [15]
			"111323:111675:96565", -- [16]
			"111323:111675:98966", -- [17]
			"111323:111420:98105:92560:98124:98972", -- [18]
			"111323:111675:114666:100468", -- [19]
			"111323:111675:114666:100459", -- [20]
			"111323:111675:114666:100550:94973", -- [21]
			"120272:96813", -- [22]
			"111323:111675:114666:100550", -- [23]
			"111323:111420:98105:92560:100559", -- [24]
			"120272:96813:112866:108888", -- [25]
			"111323:111420:98161:111314", -- [26]
			"111323:111420:98161:111327", -- [27]
			"111323:111675", -- [28]
			"120272:96813:111624", -- [29]
			"120272:96813:111418", -- [30]
			"120272:96813:112866:88110:110971", -- [31]
			"111323:111420", -- [32]
			"111323:112926", -- [33]
			"111323:114718", -- [34]
			"111323:111675:114666", -- [35]
			"120272:96813:111624:90639:114837", -- [36]
			["m"] = 1021,
			["direct"] = "111323:120272",
			["coord"] = 3035986385,
			["f"] = 0,
		},		
		[98966] = {
			"96565:114666:90556", -- [1]
			"96565:114666:90639", -- [2]
			"96565:114666:90556:88110", -- [3]
			"111675:111624:112866", -- [4]
			"96565:114666:93447", -- [5]
			"96565:114666:100459:93940", -- [6]
			"92560:98105", -- [7]
			"92560:98161", -- [8]
			"95688:94973:97868", -- [9]
			"95688:94973:97870", -- [10]
			"95688:94973:97868:98066", -- [11]
			"97860:98972", -- [12]
			"96565:100468", -- [13]
			"96565:114666:100459", -- [14]
			"95688:94973", -- [15]
			"111675:96813", -- [16]
			"95688:100550", -- [17]
			"111675:111624:112866:108888", -- [18]
			"111327:111314", -- [19]
			"114718:111323", -- [20]
			"111675:111624", -- [21]
			"111675:111624:112866:108888:111418", -- [22]
			"96565:114666:90639:110971", -- [23]
			"92560:98105:111420", -- [24]
			"111675:96813:112926", -- [25]
			"96565:114666", -- [26]
			"96565:114666:100459:93940:114837", -- [27]
			"114718:93465", -- [28]
			"114718:111323:120272", -- [1]
			"114718:111323:120118", -- [2]			
			["m"] = 1024,
			["coord"] = 2441074353,
			["direct"] = "95688:92560:98124:97860:96565:100559:111327:111675:114718",
			["f"] = 0,
		},
		[120272] = {
			"96813:111624:90556", -- [1]
			"96813:111624:90639", -- [2]
			"96813:112866:88110", -- [3]
			"96813:112866", -- [4]
			"96813:111624:93447", -- [5]
			"96813:111624:93447:93940", -- [6]
			"111323:111675:114666:100550:95688", -- [7]
			"111323:111420:98105:92560", -- [8]
			"111323:111420:98105", -- [9]
			"111323:111420:98105:92560:98124", -- [10]
			"111323:111420:98161", -- [11]
			"111323:111420:98105:92560:100559:97860", -- [12]
			"111323:111675:114666:100550:94973:97868", -- [13]
			"111323:111675:114666:100550:97870", -- [14]
			"111323:111675:114666:100550:94973:97868:98066", -- [15]
			"111323:111675:96565", -- [16]
			"111323:111675:98966", -- [17]
			"111323:111420:98105:92560:98124:98972", -- [18]
			"111323:111675:114666:100468", -- [19]
			"96813:111624:93447:100459", -- [20]
			"111323:111675:114666:100550:94973", -- [21]
			"111323:111675:114666:100550", -- [22]
			"111323:111420:98105:92560:100559", -- [23]
			"96813:112866:108888", -- [24]
			"111323:111420:98161:111314", -- [25]
			"111323:111420:98161:111327", -- [26]
			"111323:111675", -- [27]
			"96813:111624", -- [28]
			"96813:111418", -- [29]
			"96813:112866:88110:110971", -- [30]
			"111323:111420", -- [31]
			"96813:112926", -- [32]
			"111323:114718", -- [33]
			"111323:111675:114666", -- [34]
			"96813:111624:90639:114837", -- [35]
			["m"] = 1021,
			["direct"] = "96813:111323:120118",
			["coord"] = 1938924524,
			["f"] = 0,
		},		
		[92560] = {
			"114718:111675:90556", -- [1]
			"114718:111675:90639", -- [2]
			"114718:111675:90556:88110", -- [3]
			"114718:111675:111624:112866", -- [4]
			"114718:111675:114666:93447", -- [5]
			"114718:111675:114666:100459:93940", -- [6]
			"100559:95688", -- [7]
			"100559:97860", -- [8]
			"100559:95688:94973:97868", -- [9]
			"100559:95688:94973:97870", -- [10]
			"98124:98972:98066", -- [11]
			"98966:96565", -- [12]
			"98124:98972", -- [13]
			"100559:95688:100550:100468", -- [14]
			"114718:111675:114666:100459", -- [15]
			"100559:95688:94973", -- [16]
			"114718:96813", -- [17]
			"100559:95688:100550", -- [18]
			"114718:111675:111624:112866:108888", -- [19]
			"98161:111314", -- [20]
			"114718:111323", -- [21]
			"114718:111675", -- [22]
			"114718:111675:111624", -- [23]
			"114718:96813:111418", -- [24]
			"114718:111675:90556:88110:110971", -- [25]
			"98105:111420", -- [26]
			"114718:96813:112926", -- [27]
			"114718:111675:114666", -- [28]
			"114718:111675:90639:114837", -- [29]
			"100559:95688:94973:98968", -- [8]		
			"114718:111675:114666:100459:107457", -- [10]	
			"114718:111323:120272", -- [1]
			"114718:111323:120118", -- [2]		
			["m"] = 1017,
			["f"] = 0,
			["direct"] = "98105:98124:98161:98966:100559:111327:114718",
			["coord"] = 1930074009,
		},
		[97860] = {
			"95688:100550:114666:90556", -- [1]
			"95688:100550:114666:90639", -- [2]
			"95688:100550:114666:90556:88110", -- [3]
			"95688:100550:114666:111624:112866", -- [4]
			"95688:100550:100468:100459:93447", -- [5]
			"95688:100550:100468:100459:93940", -- [6]
			"100559:92560", -- [7]
			"100559:92560:98105", -- [8]
			"98124:111327:98161", -- [9]
			"94973:97870", -- [10]
			"95688:96565", -- [11]
			"95688:100550:100468", -- [12]
			"95688:100550:100468:100459", -- [13]
			"95688:96565:111675:96813", -- [14]
			"95688:100550", -- [15]
			"95688:100550:114666:111624:112866:108888", -- [16]
			"100559:92560:114718:111323", -- [17]
			"98124:111327", -- [18]
			"95688:96565:111675", -- [19]
			"95688:100550:114666:111624", -- [20]
			"95688:100550:114666:111624:112866:108888:111418", -- [21]
			"95688:100550:114666:90639:110971", -- [22]
			"100559:92560:98105:111420", -- [23]
			"95688:96565:111675:96813:112926", -- [24]
			"100559:92560:114718", -- [25]
			"95688:100550:114666", -- [26]
			"95688:100550:100468:100459:93940:114837", -- [27]
			"98968:97870", -- [10]
			"94973:97870:107457", -- [16]
			"100559:92560:114718:111323:120272", -- [1]
			"100559:92560:114718:111323:120118", -- [2]			
			["m"] = 1024,
			["f"] = 0,
			["direct"] = "95688:98124:97868:98066:98966:98972:94973:100559:111314:98968",
			["coord"] = 2258727865,
		},
		[90556] = {
			"93447:93940", -- [1]
			"114666:100550:95688", -- [2]
			"111675:114718:92560", -- [3]
			"111675:114718:111420:98105", -- [4]
			"111675:98966:98124", -- [5]
			"111675:114718:92560:98161", -- [6]
			"114666:100550:94973:97860", -- [7]
			"114666:100550:94973:97868", -- [8]
			"114666:100550:97870", -- [9]
			"114666:100550:94973:97868:98066", -- [10]
			"114666:96565", -- [11]
			"111675:98966", -- [12]
			"114666:100550:94973:97860:98972", -- [13]
			"93447:100459:100468", -- [14]
			"93447:100459", -- [15]
			"114666:100550:94973", -- [16]
			"111624:96813", -- [17]
			"114666:100550", -- [18]
			"111675:98966:100559", -- [19]
			"88110:108888", -- [20]
			"111675:114718:92560:98161:111314", -- [21]
			"111624:96813:111323", -- [22]
			"111675:98966:111327", -- [23]
			"88110:108888:111418", -- [24]
			"88110:110971", -- [25]
			"111675:114718:111420", -- [26]
			"112866:112926", -- [27]
			"111675:114718", -- [28]
			"90639:114837", -- [29]
			"114666:100550:98968:97868", -- [7]
			"114666:100550:98968:97868:98066", -- [9]
			"114666:100550:98968", -- [12]
			"93447:100459:107457", -- [18]
			"111624:96813:120272", -- [1]
			"111624:96813:111323:120118", -- [2]			
			["m"] = 1015,
			["coord"] = 2077378472,
			["direct"] = "90639:88110:112866:93447:111675:111624:114666",
			["f"] = 0,
		},
		[97868] = {
			"94973:100550:114666:90556", -- [1]
			"94973:100550:114666:90639", -- [2]
			"94973:100550:114666:90556:88110", -- [3]
			"94973:100550:114666:111624:112866", -- [4]
			"94973:100550:100468:100459:93447", -- [5]
			"94973:100550:100468:100459:93940", -- [6]
			"95688:100559:92560", -- [7]
			"95688:100559:92560:98105", -- [8]
			"97860:98124", -- [9]
			"97860:98124:111327:98161", -- [10]
			"95688:96565", -- [11]
			"95688:98966", -- [12]
			"94973:100550:100468", -- [13]
			"94973:100550:100468:100459", -- [14]
			"95688:96565:111675:96813", -- [15]
			"94973:100550", -- [16]
			"95688:100559", -- [17]
			"94973:100550:114666:111624:112866:108888", -- [18]
			"98972:111314", -- [19]
			"95688:96565:111675:111323", -- [20]
			"97860:98124:111327", -- [21]
			"95688:96565:111675", -- [22]
			"94973:100550:114666:111624", -- [23]
			"94973:100550:114666:111624:112866:108888:111418", -- [24]
			"94973:100550:114666:90639:110971", -- [25]
			"95688:100559:92560:98105:111420", -- [26]
			"95688:96565:111675:96813:112926", -- [27]
			"95688:96565:114718", -- [28]
			"94973:100550:114666", -- [29]
			"94973:100550:100468:100459:93940:114837", -- [30]
			"98968:100550:114666:90556", -- [1]
			"98968:100550:114666:90639", -- [2]
			"98968:100550:114666:90556:88110", -- [3]
			"98968:100550:114666:111624:112866", -- [4]
			"98968:100550:100468:100459:93447", -- [5]
			"98968:100550:100468:100459:93940", -- [6]
			"98968:100550:100468", -- [13]
			"98968:100550:100468:100459", -- [14]
			"98968:100550:114666:111675:96813", -- [15]
			"98968:100550", -- [16]
			"98968:100550:114666:111675", -- [19]
			"98968:100550:114666:111624", -- [20]
			"98968:100550:114666:90639:110971", -- [21]			
			"98968:100550:114666", -- [24]	
			"97870:107457", -- [18]			
			"95688:96565:111675:111323:120272", -- [1]
			"95688:96565:111675:111323:120118", -- [2]			
			["m"] = 1024,
			["f"] = 0,
			["direct"] = "95688:97860:97870:98066:98972:94973:98968",
			["coord"] = 1645634648,
		},
		[112866] = {
			"90556:90639", -- [1]
			"111624:93447", -- [2]
			"111624:93447:93940", -- [3]
			"111624:114666:100550:95688", -- [4]
			"111624:111675:114718:92560", -- [5]
			"111624:111675:114718:111420:98105", -- [6]
			"111624:111675:98966:98124", -- [7]
			"111624:111675:114718:92560:98161", -- [8]
			"111624:114666:100550:94973:97860", -- [9]
			"111624:114666:100550:94973:97868", -- [10]
			"111624:114666:100550:97870", -- [11]
			"111624:114666:100550:94973:97868:98066", -- [12]
			"111624:114666:96565", -- [13]
			"111624:111675:98966", -- [14]
			"111624:114666:100550:94973:97860:98972", -- [15]
			"111624:114666:100468", -- [16]
			"111624:93447:100459", -- [17]
			"111624:114666:100550:94973", -- [18]
			"111624:114666:100550", -- [19]
			"111624:111675:98966:100559", -- [20]
			"111624:111675:114718:92560:98161:111314", -- [21]
			"96813:111323", -- [22]
			"111624:111675:98966:111327", -- [23]
			"111624:111675", -- [24]
			"108888:111418", -- [25]
			"88110:110971", -- [26]
			"111624:111675:114718:111420", -- [27]
			"111624:111675:114718", -- [28]
			"111624:114666", -- [29]
			"90556:90639:114837", -- [30]
			"96813:111323:93465", -- [31]
			"111624:93447:100459:107457", -- [20]
			"96813:120272", -- [1]
			"96813:111323:120118", -- [2]			
			["m"] = 1015,
			["coord"] = 2412353262,
			["direct"] = "90556:88110:96813:108888:111624:112926",
			["f"] = 0,
		},
		[100459] = {
			"93447:90556", -- [1]
			"93447:90639", -- [2]
			"93447:90556:88110", -- [3]
			"93447:90556:112866", -- [4]
			"100468:100550:95688", -- [5]
			"100468:100550:95688:100559:92560", -- [6]
			"100468:100550:95688:100559:92560:98105", -- [7]
			"100468:100550:95688:100559:98124", -- [8]
			"100468:100550:95688:100559:92560:98161", -- [9]
			"100468:100550:94973:97860", -- [10]
			"100468:100550:94973:97868", -- [11]
			"100468:100550:97870", -- [12]
			"100468:100550:94973:97868:98066", -- [13]
			"100468:96565", -- [14]
			"100468:96565:98966", -- [15]
			"100468:100550:94973:97860:98972", -- [16]
			"100468:100550:94973", -- [17]
			"114666:111675:96813", -- [18]
			"100468:100550", -- [19]
			"100468:100550:95688:100559", -- [20]
			"93447:90556:88110:108888", -- [21]
			"100468:100550:95688:100559:98124:111327:111314", -- [22]
			"114666:111675:111323", -- [23]
			"100468:100550:95688:100559:98124:111327", -- [24]
			"114666:111675", -- [25]
			"93447:111624", -- [26]
			"93447:90556:88110:108888:111418", -- [27]
			"93447:90639:110971", -- [28]
			"114666:111675:114718:111420", -- [29]
			"93447:90556:112866:112926", -- [30]
			"114666:111675:114718", -- [31]
			"93940:114837", -- [32]
			"100468:100550:98968:97868", -- [5]
			"100468:100550:98968:97868:98066", -- [6]
			"100468:100550:98968", -- [7]			
			"114666:111675:111323:120272", -- [1]
			"114666:111675:111323:120118", -- [2]			
			["m"] = 1018,
			["coord"] = 2436207577,
			["direct"] = "93447:93940:100468:114666:107457",
			["f"] = 0,
		},
		[90639] = {
			"90556:88110", -- [1]
			"90556:112866", -- [2]
			"93447:100459:100468:100550:95688", -- [3]
			"111675:114718:92560", -- [4]
			"111675:114718:111420:98105", -- [5]
			"93447:100459:100468:100550:95688:100559:98124", -- [6]
			"111675:114718:92560:98161", -- [7]
			"93447:100459:100468:100550:94973:97860", -- [8]
			"93447:100459:100468:100550:94973:97868", -- [9]
			"93447:100459:100468:100550:97870", -- [10]
			"93447:100459:100468:100550:94973:97868:98066", -- [11]
			"114666:96565", -- [12]
			"114666:96565:98966", -- [13]
			"93447:100459:100468:100550:94973:97860:98972", -- [14]
			"93447:100459:100468", -- [15]
			"93447:100459", -- [16]
			"93447:100459:100468:100550:94973", -- [17]
			"111624:96813", -- [18]
			"93447:100459:100468:100550", -- [19]
			"93447:100459:100468:100550:95688:100559", -- [20]
			"110971:108888", -- [21]
			"111675:114718:92560:98161:111314", -- [22]
			"111675:111323", -- [23]
			"114666:96565:98966:111327", -- [24]
			"110971:108888:111418", -- [25]
			"111675:114718:111420", -- [26]
			"90556:112866:112926", -- [27]
			"111675:114718", -- [28]
			"111675:114718:93465", -- [29]
			"93447:100459:100468:100550:98968:97868", -- [6]
			"93447:100459:100468:100550:98968:97868:98066", -- [7]		
			"93447:100459:100468:100550:98968", -- [10]
			"93940:107457", -- [20]
			"111624:96813:120272", -- [1]
			"111675:111323:120118", -- [2]			
			["m"] = 1015,
			["coord"] = 1753618256,
			["direct"] = "90556:93447:93940:111675:111624:110971:114666:114837",
			["f"] = 0,
		},
		[96565] = {
			"114666:90556", -- [1]
			"114666:90639", -- [2]
			"114666:90556:88110", -- [3]
			"114666:111624:112866", -- [4]
			"114666:93447", -- [5]
			"114666:100459:93940", -- [6]
			"98966:92560", -- [7]
			"98966:92560:98105", -- [8]
			"98966:98124", -- [9]
			"98966:92560:98161", -- [10]
			"95688:97860", -- [11]
			"100550:94973:97868", -- [12]
			"100550:97870", -- [13]
			"100550:94973:97868:98066", -- [14]
			"95688:97860:98972", -- [15]
			"114666:100459", -- [16]
			"100550:94973", -- [17]
			"111675:96813", -- [18]
			"98966:100559", -- [19]
			"114666:111624:112866:108888", -- [20]
			"98966:111327:111314", -- [21]
			"111675:111323", -- [22]
			"98966:111327", -- [23]
			"114666:111624", -- [24]
			"114666:111624:112866:108888:111418", -- [25]
			"114666:90639:110971", -- [26]
			"114718:111420", -- [27]
			"111675:96813:112926", -- [28]
			"114666:100459:93940:114837", -- [29]
			"114718:93465", -- [30]
			"100550:98968:97868", -- [7]
			"100550:98968:97868:98066", -- [9]
			"100550:98968", -- [10]			
			"114666:100459:107457", -- [2]
			"111675:111323:120272", -- [1]
			"111675:111323:120118", -- [2]			
			["m"] = 1024,
			["coord"] = 2030950571,
			["direct"] = "95688:98966:100468:100550:111675:114718:114666",
			["f"] = 0,
		},
		[111323] = {
			"96813:111624:90556", -- [1]
			"96813:111624:90639", -- [2]
			"96813:112866:88110", -- [3]
			"96813:112866", -- [4]
			"111675:114666:93447", -- [5]
			"111675:114666:100459:93940", -- [6]
			"111675:114666:100550:95688", -- [7]
			"111420:98105:92560", -- [8]
			"111420:98105", -- [9]
			"111420:98105:92560:98124", -- [10]
			"111420:98161", -- [11]
			"111420:98105:92560:100559:97860", -- [12]
			"111675:114666:100550:94973:97868", -- [13]
			"111675:114666:100550:97870", -- [14]
			"111675:114666:100550:94973:97868:98066", -- [15]
			"111675:96565", -- [16]
			"111675:98966", -- [17]
			"111420:98105:92560:98124:98972", -- [18]
			"111675:114666:100468", -- [19]
			"111675:114666:100459", -- [20]
			"111675:114666:100550:94973", -- [21]
			"111675:114666:100550", -- [22]
			"111420:98105:92560:100559", -- [23]
			"96813:112866:108888", -- [24]
			"111420:98161:111314", -- [25]
			"111420:98161:111327", -- [26]
			"96813:111624", -- [27]
			"96813:111418", -- [28]
			"96813:112866:88110:110971", -- [29]
			"111675:114666", -- [30]
			"96813:111624:90639:114837", -- [31]
			["m"] = 1021,
			["coord"] = 2136815043,
			["direct"] = "96813:111675:111420:112926:114718:120272:120118",
			["f"] = 0,
		},
		[111327] = {
			"92560:114718:111675:90556", -- [1]
			"92560:114718:111675:90639", -- [2]
			"92560:114718:111675:90556:88110", -- [3]
			"92560:114718:111675:111624:112866", -- [4]
			"98966:96565:114666:93447", -- [5]
			"100559:95688:100550:100468:100459:93940", -- [6]
			"100559:95688", -- [7]
			"98161:98105", -- [8]
			"98124:97860", -- [9]
			"100559:95688:94973:97868", -- [10]
			"100559:95688:94973:97870", -- [11]
			"98972:98066", -- [12]
			"98966:96565", -- [13]
			"100559:95688:100550:100468", -- [14]
			"100559:95688:100550:100468:100459", -- [15]
			"100559:95688:94973", -- [16]
			"92560:114718:96813", -- [17]
			"100559:95688:100550", -- [18]
			"92560:114718:111675:111624:112866:108888", -- [19]
			"98161:111420:111323", -- [20]
			"92560:114718:111675", -- [21]
			"92560:114718:111675:111624", -- [22]
			"92560:114718:96813:111418", -- [23]
			"92560:114718:111675:90556:88110:110971", -- [24]
			"98161:111420", -- [25]
			"92560:114718:96813:112926", -- [26]
			"92560:114718", -- [27]
			"98966:96565:114666", -- [28]
			"100559:95688:100550:100468:100459:93940:114837", -- [29]
			"100559:95688:94973:97870:107457", -- [9]
			"98161:111420:111323", -- [1]
			"98161:111420:111323:120272", -- [2]
			"98161:111420:111323:120118", -- [3]		
			["m"] = 1017,
			["f"] = 0,
			["direct"] = "92560:98124:98161:98966:98972:100559:111314",
			["coord"] = 2233489604,
		},

		[98105] = {
			"92560:114718:111675:90556", -- [1]
			"92560:114718:111675:90639", -- [2]
			"92560:114718:111675:90556:88110", -- [3]
			"92560:114718:111675:111624:112866", -- [4]
			"92560:114718:111675:114666:93447", -- [5]
			"92560:114718:111675:114666:100459:93940", -- [6]
			"92560:100559:95688", -- [7]
			"92560:98124", -- [8]
			"92560:100559:97860", -- [9]
			"92560:100559:95688:94973:97868", -- [10]
			"92560:100559:95688:94973:97870", -- [11]
			"92560:98124:98972:98066", -- [12]
			"92560:98966:96565", -- [13]
			"92560:98966", -- [14]
			"92560:98124:98972", -- [15]
			"92560:100559:95688:100550:100468", -- [16]
			"92560:114718:111675:114666:100459", -- [17]
			"92560:100559:95688:94973", -- [18]
			"111420:96813", -- [19]
			"92560:100559:95688:100550", -- [20]
			"92560:100559", -- [21]
			"92560:114718:111675:111624:112866:108888", -- [22]
			"98161:111314", -- [23]
			"111420:111323", -- [24]
			"98161:111327", -- [25]
			"92560:114718:111675", -- [26]
			"92560:114718:111675:111624", -- [27]
			"111420:96813:111418", -- [28]
			"92560:114718:111675:90556:88110:110971", -- [29]
			"111420:111323:112926", -- [30]
			"92560:114718", -- [31]
			"92560:114718:111675:114666", -- [32]
			"92560:114718:111675:90639:114837", -- [33]
			"92560:100559:95688:94973:98968", -- [15]
			"92560:114718:111675:114666:100459:107457", -- [22]
			"111420:111323:120272", -- [1]
			"111420:111323:120118", -- [2]			
			["direct"] = "92560:98161:111420",
			["f"] = 0,
			["m"] = 1017,
			["coord"] = 2341583537,
		},
		[93447] = {
			"90556:88110", -- [1]
			"90556:112866", -- [2]
			"100459:100468:100550:95688", -- [3]
			"114666:111675:114718:92560", -- [4]
			"114666:111675:114718:111420:98105", -- [5]
			"100459:100468:100550:95688:100559:98124", -- [6]
			"114666:111675:114718:92560:98161", -- [7]
			"100459:100468:100550:94973:97860", -- [8]
			"100459:100468:100550:94973:97868", -- [9]
			"100459:100468:100550:97870", -- [10]
			"100459:100468:100550:94973:97868:98066", -- [11]
			"114666:96565", -- [12]
			"114666:96565:98966", -- [13]
			"100459:100468:100550:94973:97860:98972", -- [14]
			"100459:100468", -- [15]
			"100459:100468:100550:94973", -- [16]
			"111624:96813", -- [17]
			"100459:100468:100550", -- [18]
			"100459:100468:100550:95688:100559", -- [19]
			"90556:88110:108888", -- [20]
			"100459:100468:100550:95688:100559:98124:111327:111314", -- [21]
			"114666:111675:111323", -- [22]
			"100459:100468:100550:95688:100559:98124:111327", -- [23]
			"114666:111675", -- [24]
			"90556:88110:108888:111418", -- [25]
			"90639:110971", -- [26]
			"114666:111675:114718:111420", -- [27]
			"90556:112866:112926", -- [28]
			"114666:111675:114718", -- [29]
			"93940:114837", -- [30]
			"114666:111675:114718:93465", -- [31]
			"100459:100468:100550:98968:97868", -- [6]
			"100459:100468:100550:98968:97868:98066", -- [7]	
			"100459:100468:100550:98968", -- [10]			
			"100459:107457", -- [20]
			"111624:96813:120272", -- [8]
			"114666:111675:111323:120118", -- [9]			
			"111624:96813:120272", -- [1]
			"114666:111675:111323:120118", -- [2]			
			["m"] = 1018,
			["coord"] = 2360588730,
			["direct"] = "90556:90639:93940:100459:111624:114666",
			["f"] = 0,
		},
		[112926] = {
			"112866:90556", -- [1]
			"112866:90556:90639", -- [2]
			"112866:88110", -- [3]
			"112866:111624:93447", -- [4]
			"112866:111624:93447:93940", -- [5]
			"112866:111624:114666:100550:95688", -- [6]
			"96813:114718:92560", -- [7]
			"111323:111420:98105", -- [8]
			"96813:114718:92560:98124", -- [9]
			"111323:111420:98161", -- [10]
			"112866:111624:114666:100550:94973:97860", -- [11]
			"112866:111624:114666:100550:94973:97868", -- [12]
			"112866:111624:114666:100550:97870", -- [13]
			"112866:111624:114666:100550:94973:97868:98066", -- [14]
			"96813:111675:96565", -- [15]
			"96813:111675:98966", -- [16]
			"96813:114718:92560:98124:98972", -- [17]
			"112866:111624:114666:100468", -- [18]
			"112866:111624:93447:100459", -- [19]
			"112866:111624:114666:100550:94973", -- [20]
			"112866:111624:114666:100550", -- [21]
			"96813:111675:98966:100559", -- [22]
			"111418:108888", -- [23]
			"111323:111420:98161:111314", -- [24]
			"111323:111420:98161:111327", -- [25]
			"96813:111675", -- [26]
			"112866:111624", -- [27]
			"111418:108888:110971", -- [28]
			"111323:111420", -- [29]
			"96813:114718", -- [30]
			"112866:111624:114666", -- [31]
			"112866:90556:90639:114837", -- [32]
			["m"] = 1096,
			["coord"] = 1645180346,
			["direct"] = "112866:96813:111323:111418",
			["f"] = 0,
		},
		[111418] = {
			"108888:88110:90556", -- [1]
			"108888:110971:90639", -- [2]
			"108888:88110", -- [3]
			"108888:112866", -- [4]
			"108888:88110:90556:93447", -- [5]
			"108888:88110:90556:93447:93940", -- [6]
			"108888:112866:111624:114666:100550:95688", -- [7]
			"108888:112866:111624:111675:114718:92560", -- [8]
			"96813:111420:98105", -- [9]
			"108888:112866:111624:111675:98966:98124", -- [10]
			"96813:111420:98161", -- [11]
			"108888:112866:111624:114666:100550:94973:97860", -- [12]
			"108888:112866:111624:114666:100550:94973:97868", -- [13]
			"108888:112866:111624:114666:100550:97870", -- [14]
			"108888:112866:111624:114666:100550:94973:97868:98066", -- [15]
			"108888:112866:111624:114666:96565", -- [16]
			"108888:112866:111624:111675:98966", -- [17]
			"108888:112866:111624:114666:100550:94973:97860:98972", -- [18]
			"108888:112866:111624:114666:100468", -- [19]
			"108888:88110:90556:93447:100459", -- [20]
			"108888:112866:111624:114666:100550:94973", -- [21]
			"108888:112866:111624:114666:100550", -- [22]
			"108888:112866:111624:111675:98966:100559", -- [23]
			"96813:111420:98161:111314", -- [24]
			"96813:111323", -- [25]
			"108888:112866:111624:111675:98966:111327", -- [26]
			"108888:112866:111624:111675", -- [27]
			"108888:112866:111624", -- [28]
			"108888:110971", -- [29]
			"96813:111420", -- [30]
			"108888:112866:111624:111675:114718", -- [31]
			"108888:112866:111624:114666", -- [32]
			"108888:110971:90639:114837", -- [33]
			["direct"] = "96813:108888:112926",
			["coord"] = 2223034959,
			["m"] = 1015,
			["f"] = 0,
		},
		[98066] = {
			"97870:100550:114666:90556", -- [1]
			"97870:100550:114666:90639", -- [2]
			"97870:100550:114666:90556:88110", -- [3]
			"97870:100550:114666:111624:112866", -- [4]
			"97870:100550:100468:100459:93447", -- [5]
			"97870:100550:100468:100459:93940", -- [6]
			"97868:95688", -- [7]
			"98972:98124:92560", -- [8]

			"98972:98124:92560:98105", -- [9]
			"98972:98124", -- [10]
			"98972:111327:98161", -- [11]
			"97870:100550:96565", -- [12]
			"97860:100559:98966", -- [13]
			"97870:100550:100468", -- [14]
			"97870:100550:100468:100459", -- [15]
			"97868:94973", -- [16]
			"97870:100550:114666:111675:96813", -- [17]
			"97870:100550", -- [18]
			"97860:100559", -- [19]
			"97870:100550:114666:111624:112866:108888", -- [20]
			"98972:111314", -- [21]
			"98972:98124:92560:114718:111323", -- [22]
			"98972:111327", -- [23]
			"97870:100550:114666:111675", -- [24]
			"97870:100550:114666:111624", -- [25]
			"97870:100550:114666:111624:112866:108888:111418", -- [26]
			"97870:100550:114666:90639:110971", -- [27]
			"98972:111327:98161:111420", -- [28]
			"97870:100550:114666:111624:112866:112926", -- [29]
			"98972:98124:92560:114718", -- [30]
			"97870:100550:114666", -- [31]
			"97870:100550:100468:100459:93940:114837", -- [32]
			"97868:98968", -- [14]
			"97870:107457:93940", -- [1]
			"97870:107457", -- [12]
			"107457:97870", -- [11]
			"107457:97870:98066", -- [12]
			"98972:98124:92560:114718:111323:120272", -- [1]
			"98972:98124:92560:114718:111323:120118", -- [2]
			["m"] = 1024,
			["f"] = 0,
			["direct"] = "97860:97868:97870:98972:107457",
			["coord"] = 1799625409,
		},
		[100468] = {
			"100459:93447:90556", -- [1]
			"100459:93447:90639", -- [2]
			"100459:93447:90556:88110", -- [3]
			"114666:111624:112866", -- [4]
			"100459:93447", -- [5]
			"100459:93940", -- [6]
			"100550:95688", -- [7]
			"100550:95688:100559:92560", -- [8]
			"100550:95688:100559:92560:98105", -- [9]
			"100550:95688:100559:98124", -- [10]
			"100550:95688:100559:92560:98161", -- [11]
			"100550:94973:97860", -- [12]
			"100550:94973:97868", -- [13]
			"100550:97870", -- [14]
			"100550:94973:97868:98066", -- [15]
			"96565:98966", -- [16]
			"100550:94973:97860:98972", -- [17]
			"100550:94973", -- [18]
			"114666:111675:96813", -- [19]
			"100550:95688:100559", -- [20]
			"114666:111624:112866:108888", -- [21]
			"100550:95688:100559:98124:111327:111314", -- [22]
			"114666:111675:111323", -- [23]
			"100550:95688:100559:98124:111327", -- [24]
			"114666:111675", -- [25]
			"114666:111624", -- [26]
			"114666:111624:112866:108888:111418", -- [27]
			"100459:93447:90639:110971", -- [28]
			"96565:114718:111420", -- [29]
			"114666:111624:112866:112926", -- [30]
			"96565:114718", -- [31]
			"100459:93940:114837", -- [32]
			"100550:98968:97868", -- [7]
			"100550:98968:97868:98066", -- [8]
			"100550:98968", -- [9]			
			"100459:107457", -- [15]
			"114666:111675:111323:120272", -- [1]
			"114666:111675:111323:120118", -- [2]			
			["m"] = 1018,
			["coord"] = 2963243589,
			["direct"] = "96565:100459:100550:114666",
			["f"] = 0,
		},
		[95688] = {
			"100550:114666:90556", -- [1]
			"100550:114666:90639", -- [2]
			"100550:114666:90556:88110", -- [3]
			"100550:114666:111624:112866", -- [4]
			"100550:100468:100459:93447", -- [5]
			"100550:100468:100459:93940", -- [6]
			"100559:92560", -- [7]
			"100559:92560:98105", -- [8]
			"100559:98124", -- [9]
			"100559:92560:98161", -- [10]
			"94973:97868:98066", -- [11]
			"97860:98972", -- [12]
			"100550:100468", -- [13]
			"100550:100468:100459", -- [14]
			"96565:111675:96813", -- [15]
			"100550:114666:111624:112866:108888", -- [16]
			"100559:98124:111327:111314", -- [17]
			"96565:111675:111323", -- [18]
			"100559:98124:111327", -- [19]
			"96565:111675", -- [20]
			"100550:114666:111624", -- [21]
			"100550:114666:111624:112866:108888:111418", -- [22]
			"100550:114666:90639:110971", -- [23]
			"100559:92560:98105:111420", -- [24]
			"96565:111675:96813:112926", -- [25]
			"96565:114718", -- [26]
			"100550:114666", -- [27]
			"100550:100468:100459:93940:114837", -- [28]
			"94973:97870:107457", -- [6]
			"96565:111675:111323:120272", -- [1]
			"96565:111675:111323:120118", -- [2]			
			["m"] = 1080,
			["coord"] = 1919771391,
			["direct"] = "97860:97868:97870:96565:98966:94973:100550:100559:98968",
			["f"] = 0,
		},
		[114718] = {
			"111675:90556", -- [1]
			"111675:90639", -- [2]
			"111675:90556:88110", -- [3]
			"111675:111624:112866", -- [4]
			"111675:114666:93447", -- [5]
			"111675:114666:100459:93940", -- [6]
			"96565:95688", -- [7]
			"111420:98105", -- [8]
			"92560:98124", -- [9]
			"92560:98161", -- [10]
			"92560:100559:97860", -- [11]
			"96565:100550:94973:97868", -- [12]
			"96565:100550:97870", -- [13]
			"92560:98124:98972:98066", -- [14]
			"92560:98124:98972", -- [15]
			"96565:100468", -- [16]
			"111675:114666:100459", -- [17]
			"96565:100550:94973", -- [18]
			"96565:100550", -- [19]
			"92560:100559", -- [20]
			"111675:111624:112866:108888", -- [21]
			"92560:98161:111314", -- [22]
			"92560:111327", -- [23]
			"111675:111624", -- [24]
			"96813:111418", -- [25]
			"111675:90556:88110:110971", -- [26]
			"96813:112926", -- [27]
			"111675:114666", -- [28]
			"111675:90639:114837", -- [29]
			"96565:100550:98968:97868", -- [8]
			"96565:100550:98968", -- [10]
			"111675:114666:100459:107457", -- [7]
			"111323:120272", -- [1]
			"111323:120118", -- [2]			
			["m"] = 1033,
			["f"] = 0,
			["direct"] = "92560:96565:98966:96813:111323:111675:111420",
			["coord"] = 2758765422,
		},
		[98972] = {
			"97860:95688:100550:114666:90556", -- [1]
			"97860:95688:100550:114666:90639", -- [2]
			"97860:95688:100550:114666:90556:88110", -- [3]
			"97860:95688:100550:114666:111624:112866", -- [4]
			"97860:95688:100550:100468:100459:93447", -- [5]
			"97860:95688:100550:100468:100459:93940", -- [6]
			"97860:95688", -- [7]
			"98124:92560", -- [8]
			"98124:92560:98105", -- [9]
			"111327:98161", -- [10]
			"97868:97870", -- [11]
			"97860:95688:96565", -- [12]
			"97860:100559:98966", -- [13]
			"97860:95688:100550:100468", -- [14]
			"97860:95688:100550:100468:100459", -- [15]
			"97860:94973", -- [16]
			"98124:92560:114718:96813", -- [17]
			"97860:95688:100550", -- [18]
			"97860:100559", -- [19]
			"97860:95688:100550:114666:111624:112866:108888", -- [20]
			"98124:92560:114718:111323", -- [21]
			"97860:95688:96565:111675", -- [22]
			"97860:95688:100550:114666:111624", -- [23]
			"97860:95688:100550:114666:111624:112866:108888:111418", -- [24]
			"97860:95688:100550:114666:90639:110971", -- [25]
			"111327:98161:111420", -- [26]
			"98124:92560:114718:96813:112926", -- [27]
			"98124:92560:114718", -- [28]
			"97860:95688:100550:114666", -- [29]
			"97860:95688:100550:100468:100459:93940:114837", -- [30]
			"97868:98968", -- [14]
			"97868:97870:107457", -- [20]
			"98124:92560:114718:111323:120272", -- [1]
			"98124:92560:114718:111323:120118", -- [2]			
			["m"] = 1024,
			["f"] = 0,
			["direct"] = "98124:97860:97868:98066:111314:111327",
			["coord"] = 2493204809,
		},
		[93940] = {
			"93447:90556", -- [1]
			"93447:90556:88110", -- [2]
			"93447:90556:112866", -- [3]
			"100459:100468:100550:95688", -- [4]
			"100459:100468:100550:95688:100559:92560", -- [5]
			"100459:100468:100550:95688:100559:92560:98105", -- [6]
			"100459:100468:100550:95688:100559:98124", -- [7]
			"100459:100468:100550:95688:100559:92560:98161", -- [8]
			"100459:100468:100550:94973:97860", -- [9]
			"100459:100468:100550:94973:97868", -- [10]
			"100459:100468:100550:97870", -- [11]
			"100459:100468:100550:94973:97868:98066", -- [12]
			"100459:100468:96565", -- [13]
			"100459:100468:96565:98966", -- [14]
			"100459:100468:100550:94973:97860:98972", -- [15]
			"100459:100468", -- [16]
			"100459:100468:100550:94973", -- [17]
			"93447:111624:96813", -- [18]
			"100459:100468:100550", -- [19]
			"100459:100468:100550:95688:100559", -- [20]
			"93447:90556:88110:108888", -- [21]
			"100459:100468:100550:95688:100559:98124:111327:111314", -- [22]
			"100459:114666:111675:111323", -- [23]
			"100459:100468:100550:95688:100559:98124:111327", -- [24]
			"100459:114666:111675", -- [25]
			"93447:111624", -- [26]
			"93447:90556:88110:108888:111418", -- [27]
			"90639:110971", -- [28]
			"100459:114666:111675:114718:111420", -- [29]
			"93447:90556:112866:112926", -- [30]
			"100459:114666:111675:114718", -- [31]
			"100459:114666", -- [32]
			"93447:111624:96813:120272", -- [1]
			"100459:114666:111675:111323:120118", -- [2]			
			["m"] = 1018,
			["coord"] = 1816434143,
			["direct"] = "90639:93447:100459:114837",
			["f"] = 0,
		},
		[100559] = {
			"98966:96565:114666:90556", -- [1]
			"98966:96565:114666:90639", -- [2]
			"98966:96565:114666:90556:88110", -- [3]
			"98966:111675:111624:112866", -- [4]
			"95688:100550:100468:100459:93447", -- [5]
			"95688:100550:100468:100459:93940", -- [6]
			"92560:98105", -- [7]
			"92560:98161", -- [8]
			"95688:94973:97868", -- [9]
			"95688:94973:97870", -- [10]
			"97860:98066", -- [11]
			"98966:96565", -- [12]
			"97860:98972", -- [13]
			"95688:100550:100468", -- [14]
			"95688:100550:100468:100459", -- [15]
			"95688:94973", -- [16]
			"92560:114718:96813", -- [17]
			"95688:100550", -- [18]
			"98966:111675:111624:112866:108888", -- [19]
			"98124:111327:111314", -- [20]
			"92560:114718:111323", -- [21]
			"98966:111675", -- [22]
			"98966:111675:111624", -- [23]
			"98966:111675:111624:112866:108888:111418", -- [24]
			"98966:96565:114666:90639:110971", -- [25]
			"92560:98105:111420", -- [26]
			"92560:114718:96813:112926", -- [27]
			"92560:114718", -- [28]
			"98966:96565:114666", -- [29]
			"95688:100550:100468:100459:93940:114837", -- [30]
			"95688:94973:98968", -- [10]			
			"95688:94973:97870:107457", -- [9]
			"92560:114718:111323:120272", -- [1]
			"92560:114718:111323:120118", -- [2]			
			["m"] = 1024,
			["f"] = 0,
			["direct"] = "95688:92560:98124:97860:98966:111327",
			["coord"] = 2544608943,
		},
		[97870] = {
			"100550:114666:90556", -- [1]
			"100550:114666:90639", -- [2]
			"100550:114666:90556:88110", -- [3]
			"100550:114666:111624:112866", -- [4]
			"100550:100468:100459:93447", -- [5]
			"100550:100468:100459:93940", -- [6]
			"94973:95688:100559:92560", -- [7]
			"94973:95688:100559:92560:98105", -- [8]
			"94973:95688:100559:98124", -- [9]
			"94973:95688:100559:92560:98161", -- [10]
			"97868:97860", -- [11]
			"100550:96565", -- [12]
			"94973:95688:98966", -- [13]
			"97868:98972", -- [14]
			"100550:100468", -- [15]
			"100550:100468:100459", -- [16]
			"100550:114666:111675:96813", -- [17]
			"94973:95688:100559", -- [18]
			"100550:114666:111624:112866:108888", -- [19]
			"97868:98972:111314", -- [20]
			"100550:114666:111675:111323", -- [21]
			"94973:95688:100559:98124:111327", -- [22]
			"100550:114666:111675", -- [23]
			"100550:114666:111624", -- [24]
			"100550:114666:111624:112866:108888:111418", -- [25]
			"100550:114666:90639:110971", -- [26]
			"94973:95688:100559:92560:98105:111420", -- [27]
			"100550:114666:111624:112866:112926", -- [28]
			"100550:96565:114718", -- [29]
			"100550:114666", -- [30]
			"100550:100468:100459:93940:114837", -- [31]
			"107457:93940", -- [1]
			"100550:114666:111675:111323:120272", -- [1]
			"100550:114666:111675:111323:120118", -- [2]			
			["m"] = 1024,
			["f"] = 0,
			["direct"] = "95688:97868:98066:94973:100550:98968:107457",
			["coord"] = 1286038703,
		},
		[111675] = {
			"90556:88110", -- [1]
			"111624:112866", -- [2]
			"114666:93447", -- [3]
			"114666:100459:93940", -- [4]
			"114666:100550:95688", -- [5]
			"114718:92560", -- [6]
			"114718:111420:98105", -- [7]
			"98966:98124", -- [8]
			"114718:92560:98161", -- [9]
			"98966:97860", -- [10]
			"114666:100550:94973:97868", -- [11]
			"114666:100550:97870", -- [12]
			"114666:100550:94973:97868:98066", -- [13]
			"98966:97860:98972", -- [14]
			"114666:100468", -- [15]
			"114666:100459", -- [16]
			"114666:100550:94973", -- [17]
			"114666:100550", -- [18]
			"98966:100559", -- [19]
			"111624:112866:108888", -- [20]
			"114718:92560:98161:111314", -- [21]
			"98966:111327", -- [22]
			"111624:112866:108888:111418", -- [23]
			"90556:88110:110971", -- [24]
			"114718:111420", -- [25]
			"96813:112926", -- [26]
			"90639:114837", -- [27]
			"114666:100550:98968:97868", -- [2]
			"114666:100550:98968:97868:98066", -- [3]
			"114666:100550:98968", -- [4]
			"114666:100459:107457", -- [18]
			"111323:120272", -- [1]
			"111323:120118", -- [2]			
			["m"] = 1033,
			["coord"] = 1475313302,
			["direct"] = "90556:90639:96565:98966:96813:111323:111624:114718:114666",
			["f"] = 0,
		},
		[111624] = {
			"90556:88110", -- [1]
			"93447:93940", -- [2]
			"114666:100550:95688", -- [3]
			"111675:114718:92560", -- [4]
			"111675:114718:111420:98105", -- [5]
			"111675:98966:98124", -- [6]
			"111675:114718:92560:98161", -- [7]
			"114666:100550:94973:97860", -- [8]
			"114666:100550:94973:97868", -- [9]
			"114666:100550:97870", -- [10]
			"114666:100550:94973:97868:98066", -- [11]
			"114666:96565", -- [12]
			"111675:98966", -- [13]
			"114666:100550:94973:97860:98972", -- [14]
			"114666:100468", -- [15]
			"93447:100459", -- [16]
			"114666:100550:94973", -- [17]
			"114666:100550", -- [18]
			"111675:98966:100559", -- [19]
			"112866:108888", -- [20]
			"111675:114718:92560:98161:111314", -- [21]
			"96813:111323", -- [22]
			"111675:98966:111327", -- [23]
			"112866:108888:111418", -- [24]
			"90556:88110:110971", -- [25]
			"111675:114718:111420", -- [26]
			"112866:112926", -- [27]
			"111675:114718", -- [28]
			"90639:114837", -- [29]
			"96813:111323:93465", -- [30]
			"114666:100550:98968:97868", -- [1]
			"114666:100550:98968:97868:98066", -- [2]
			"114666:100550:98968", -- [3]			
			"93447:100459:107457", -- [17]
			"96813:120272", -- [1]
			"96813:111323:120118", -- [2]			
			["m"] = 1015,
			["coord"] = 2739030261,
			["direct"] = "90556:90639:112866:93447:96813:111675:114666",
			["f"] = 0,
		},
		[114837] = {
			"90639:90556", -- [1]
			"90639:90556:88110", -- [2]
			"90639:90556:112866", -- [3]
			"93940:93447", -- [4]
			"93940:100459:100468:100550:95688", -- [5]
			"93940:100459:100468:100550:95688:100559:92560", -- [6]
			"93940:100459:100468:100550:95688:100559:92560:98105", -- [7]
			"93940:100459:100468:100550:95688:100559:98124", -- [8]
			"93940:100459:100468:100550:95688:100559:92560:98161", -- [9]
			"93940:100459:100468:100550:94973:97860", -- [10]
			"93940:100459:100468:100550:94973:97868", -- [11]
			"93940:100459:100468:100550:97870", -- [12]
			"93940:100459:100468:100550:94973:97868:98066", -- [13]
			"93940:100459:100468:96565", -- [14]
			"93940:100459:100468:96565:98966", -- [15]
			"93940:100459:100468:100550:94973:97860:98972", -- [16]
			"93940:100459:100468", -- [17]
			"93940:100459", -- [18]
			"93940:100459:100468:100550:94973", -- [19]
			"90639:111624:96813", -- [20]
			"93940:100459:100468:100550", -- [21]
			"93940:100459:100468:100550:95688:100559", -- [22]
			"90639:110971:108888", -- [23]
			"93940:100459:100468:100550:95688:100559:98124:111327:111314", -- [24]
			"93940:100459:114666:111675:111323", -- [25]
			"93940:100459:100468:100550:95688:100559:98124:111327", -- [26]
			"93940:100459:114666:111675", -- [27]
			"90639:111624", -- [28]
			"90639:110971:108888:111418", -- [29]
			"90639:110971", -- [30]
			"93940:100459:114666:111675:114718:111420", -- [31]
			"90639:90556:112866:112926", -- [32]
			"93940:100459:114666:111675:114718", -- [33]
			"93940:100459:114666", -- [34]
			"90639:111624:96813:120272", -- [5]
			"93940:100459:114666:111675:111323:120118", -- [6]			
			["direct"] = "90639:93940",
			["coord"] = 1115662876,
			["m"] = 1018,
			["f"] = 0,
		},
		[114666] = {
			"90556:88110", -- [1]
			"111624:112866", -- [2]
			"100459:93940", -- [3]
			"100550:95688", -- [4]
			"111675:114718:92560", -- [5]
			"111675:114718:111420:98105", -- [6]
			"96565:98966:98124", -- [7]
			"111675:114718:92560:98161", -- [8]
			"100550:94973:97860", -- [9]
			"100550:94973:97868", -- [10]
			"100550:97870", -- [11]
			"100550:94973:97868:98066", -- [12]
			"96565:98966", -- [13]
			"100550:94973:97860:98972", -- [14]
			"100550:94973", -- [15]
			"111675:96813", -- [16]
			"96565:98966:100559", -- [17]
			"111624:112866:108888", -- [18]
			"96565:98966:111327:111314", -- [19]
			"111675:111323", -- [20]
			"96565:98966:111327", -- [21]
			"111624:112866:108888:111418", -- [22]
			"90639:110971", -- [23]
			"111675:114718:111420", -- [24]
			"111624:112866:112926", -- [25]
			"111675:114718", -- [26]
			"100459:93940:114837", -- [27]
			"111675:114718:93465", -- [28]
			"100550:98968:97868", -- [5]
			"100550:98968:97868:98066", -- [6]
			"100550:98968", -- [7]			
			"100459:107457", -- [15]
			"111675:111323:120272", -- [8]
			"111675:111323:120118", -- [9]		
			"111675:111323:120272", -- [1]
			"111675:111323:120118", -- [2]			
			["m"] = 1033,
			["coord"] = 1095979364,
			["direct"] = "90556:90639:93447:96565:100468:100459:100550:111675:111624",
			["f"] = 0,
		},
		[111420] = {
			"114718:111675:90556", -- [1]
			"114718:111675:90639", -- [2]
			"114718:111675:90556:88110", -- [3]
			"96813:112866", -- [4]
			"114718:111675:114666:93447", -- [5]
			"114718:111675:114666:100459:93940", -- [6]
			"98105:92560:100559:95688", -- [7]
			"98105:92560", -- [8]
			"98105:92560:98124", -- [9]
			"98105:92560:100559:97860", -- [10]
			"98105:92560:100559:95688:94973:97868", -- [11]
			"98105:92560:100559:95688:94973:97870", -- [12]
			"98105:92560:98124:98972:98066", -- [13]
			"114718:96565", -- [14]
			"98105:92560:98966", -- [15]
			"98105:92560:98124:98972", -- [16]
			"114718:96565:100468", -- [17]
			"114718:111675:114666:100459", -- [18]
			"98105:92560:100559:95688:94973", -- [19]
			"98105:92560:100559:95688:100550", -- [20]
			"98105:92560:100559", -- [21]
			"96813:112866:108888", -- [22]
			"98161:111314", -- [23]
			"98161:111327", -- [24]
			"114718:111675", -- [25]
			"114718:111675:111624", -- [26]
			"96813:111418", -- [27]
			"114718:111675:90556:88110:110971", -- [28]
			"111323:112926", -- [29]
			"114718:111675:114666", -- [30]
			"114718:111675:90639:114837", -- [31]
			"98105:92560:100559:95688:94973:98968", -- [16]
			"114718:111675:114666:100459:107457", -- [22]
			"111323:120272", -- [1]
			"111323:120118", -- [2]			
			["m"] = 1017,
			["f"] = 0,
			["direct"] = "98105:98108:98161:96813:111323:114718",
			["coord"] = 2387795914,
		},
		[98124] = {
			"98966:96565:114666:90556", -- [1]
			"98966:96565:114666:90639", -- [2]
			"98966:96565:114666:90556:88110", -- [3]
			"98966:111675:111624:112866", -- [4]
			"98966:96565:114666:93447", -- [5]
			"100559:95688:100550:100468:100459:93940", -- [6]
			"100559:95688", -- [7]
			"92560:98105", -- [8]
			"111327:98161", -- [9]
			"97860:97868", -- [10]
			"100559:95688:94973:97870", -- [11]
			"98972:98066", -- [12]
			"98966:96565", -- [13]
			"100559:95688:100550:100468", -- [14]
			"100559:95688:100550:100468:100459", -- [15]
			"100559:95688:94973", -- [16]
			"92560:114718:96813", -- [17]
			"100559:95688:100550", -- [18]
			"98966:111675:111624:112866:108888", -- [19]
			"111327:111314", -- [20]
			"92560:114718:111323", -- [21]
			"98966:111675", -- [22]
			"98966:111675:111624", -- [23]
			"92560:114718:96813:111418", -- [24]
			"98966:96565:114666:90639:110971", -- [25]
			"92560:98105:111420", -- [26]
			"92560:114718:96813:112926", -- [27]
			"92560:114718", -- [28]
			"98966:96565:114666", -- [29]
			"100559:95688:100550:100468:100459:93940:114837", -- [30]
			"97860:98968", -- [10]
			"100559:95688:94973:97870:107457", -- [10]
			"92560:114718:111323:120272", -- [1]
			"92560:114718:111323:120118", -- [2]			
			["m"] = 1017,
			["f"] = 0,
			["direct"] = "92560:97860:98966:98972:100559:111327",
			["coord"] = 1568099994,
		},
		[98161] = {
			"92560:114718:111675:90556", -- [1]
			"92560:114718:111675:90639", -- [2]
			"92560:114718:111675:90556:88110", -- [3]
			"92560:114718:111675:111624:112866", -- [4]
			"92560:114718:111675:114666:93447", -- [5]
			"92560:114718:111675:114666:100459:93940", -- [6]
			"92560:100559:95688", -- [7]
			"111327:98124", -- [8]
			"111327:98124:97860", -- [9]
			"92560:100559:95688:94973:97868", -- [10]
			"92560:100559:95688:94973:97870", -- [11]
			"111327:98972:98066", -- [12]
			"92560:98966:96565", -- [13]
			"92560:98966", -- [14]
			"111327:98972", -- [15]
			"92560:100559:95688:100550:100468", -- [16]
			"92560:114718:111675:114666:100459", -- [17]
			"92560:100559:95688:94973", -- [18]
			"92560:114718:96813", -- [19]
			"92560:100559:95688:100550", -- [20]
			"92560:100559", -- [21]
			"92560:114718:111675:111624:112866:108888", -- [22]
			"111420:111323", -- [23]
			"92560:114718:111675", -- [24]
			"92560:114718:111675:111624", -- [25]
			"92560:114718:96813:111418", -- [26]
			"92560:114718:111675:90556:88110:110971", -- [27]
			"92560:114718:96813:112926", -- [28]
			"92560:114718", -- [29]
			"92560:114718:111675:114666", -- [30]
			"92560:114718:111675:90639:114837", -- [31]
			"92560:100559:95688:94973:98968", -- [12]
			"92560:114718:111675:114666:100459:107457", -- [18]
			"111420:111323:120272", -- [1]
			"111420:111323:120118", -- [2]			
			["m"] = 1017,
			["f"] = 0,
			["direct"] = "92560:98105:111314:111327:111420",
			["coord"] = 2606596687,
		},
		[100550] = {
			"98968:97868", -- [7]
			"98968:97868:98066", -- [8]		
			"114666:90556", -- [1]
			"114666:90639", -- [2]
			"114666:90556:88110", -- [3]
			"114666:111624:112866", -- [4]
			"100468:100459:93447", -- [5]
			"100468:100459:93940", -- [6]
			"95688:100559:92560", -- [7]
			"95688:100559:92560:98105", -- [8]
			"95688:100559:98124", -- [9]
			"95688:100559:92560:98161", -- [10]
			"94973:97860", -- [11]
			"94973:97868", -- [12]
			"94973:97868:98066", -- [13]
			"96565:98966", -- [14]
			"94973:97860:98972", -- [15]
			"100468:100459", -- [16]
			"114666:111675:96813", -- [17]
			"95688:100559", -- [18]
			"114666:111624:112866:108888", -- [19]
			"95688:100559:98124:111327:111314", -- [20]
			"114666:111675:111323", -- [21]
			"95688:100559:98124:111327", -- [22]
			"114666:111675", -- [23]
			"114666:111624", -- [24]
			"114666:111624:112866:108888:111418", -- [25]
			"114666:90639:110971", -- [26]
			"96565:114718:111420", -- [27]
			"114666:111624:112866:112926", -- [28]
			"96565:114718", -- [29]
			"100468:100459:93940:114837", -- [30]
			"96565:114718:93465", -- [31]
			"100468:100459:107457", -- [12]
			["m"] = 1024,
			["f"] = 0,
			["direct"] = "95688:97870:96565:100468:94973:114666",
			["coord"] = 1540597954,
		},
		[111314] = {
			"98161:92560:114718:111675:90556", -- [1]
			"98161:92560:114718:111675:90639", -- [2]
			"98161:92560:114718:111675:90556:88110", -- [3]
			"98161:92560:114718:111675:111624:112866", -- [4]
			"97860:95688:100550:100468:100459:93447", -- [5]
			"97860:95688:100550:100468:100459:93940", -- [6]
			"97860:95688", -- [7]
			"98161:92560", -- [8]
			"98161:98105", -- [9]
			"111327:98124", -- [10]
			"97860:97868", -- [11]
			"97860:94973:97870", -- [12]
			"98972:98066", -- [13]
			"111327:98966:96565", -- [14]
			"111327:98966", -- [15]
			"97860:95688:100550:100468", -- [16]
			"97860:95688:100550:100468:100459", -- [17]
			"97860:94973", -- [18]
			"98161:92560:114718:96813", -- [19]
			"97860:95688:100550", -- [20]
			"111327:100559", -- [21]
			"98161:92560:114718:111675:111624:112866:108888", -- [22]
			"98161:111420:111323", -- [23]
			"98161:92560:114718:111675", -- [24]
			"98161:92560:114718:111675:111624", -- [25]
			"98161:92560:114718:96813:111418", -- [26]
			"98161:92560:114718:111675:90556:88110:110971", -- [27]
			"98161:111420", -- [28]
			"98161:92560:114718:96813:112926", -- [29]
			"98161:92560:114718", -- [30]
			"111327:98966:96565:114666", -- [31]
			"97860:95688:100550:100468:100459:93940:114837", -- [32]
			"98108:111420:93465", -- [33]
			"98108:111420:111323:120272", -- [2]
			"98108:111420:111323:120118", -- [3]			
			["m"] = 1017,
			["f"] = 0,
			["direct"] = "98161:97860:98972:111327",
			["coord"] = 3861650254,
		},
		[96813] = {
			"111624:90556", -- [1]
			"111624:90639", -- [2]
			"112866:88110", -- [3]
			"111624:93447", -- [4]
			"111624:93447:93940", -- [5]
			"111675:114666:100550:95688", -- [6]
			"114718:92560", -- [7]
			"111420:98105", -- [8]
			"114718:92560:98124", -- [9]
			"111420:98161", -- [10]
			"111675:98966:97860", -- [11]
			"111675:114666:100550:94973:97868", -- [12]
			"111675:114666:100550:97870", -- [13]
			"111675:114666:100550:94973:97868:98066", -- [14]
			"111675:96565", -- [15]
			"111675:98966", -- [16]
			"114718:92560:98124:98972", -- [17]
			"111675:114666:100468", -- [18]
			"111624:93447:100459", -- [19]
			"111675:114666:100550:94973", -- [20]
			"111675:114666:100550", -- [21]
			"111675:98966:100559", -- [22]
			"112866:108888", -- [23]
			"111420:98161:111314", -- [24]
			"114718:92560:111327", -- [25]
			"112866:88110:110971", -- [26]
			"111675:114666", -- [27]
			"111624:90639:114837", -- [28]
			"111323:93465", -- [29]
			"111675:114666:100550:98968:97868", -- [1]
			"111675:114666:100550:98968:97868:98066", -- [2]
			"111675:114666:100550:98968", -- [3]			
			"111624:93447:100459:107457", -- [1]
			"111323:120118", -- [1]
			["m"] = 1014,
			["coord"] = 3012264314,
			["direct"] = "112866:111323:111675:111624:111418:111420:112926:114718",
			["f"] = 10,
		},
		[109467] = {
			"109457:109451", -- [1]
			"109469:109558", -- [2]
			"109469:109558:109561", -- [3]
			"109457:109451:109789:109572:109571", -- [4]
			"109457:109451:109789:109572", -- [5]
			"109457:109451:109789", -- [6]
			["m"] = 1033,
			["f"] = 0,
			["direct"] = "109457:109469",
			["coord"] = 3014899171,
			requirements = "cls:HUNTER"
		},
		[109558] = {
			"109469:109467:109457", -- [1]
			"109469:109467:109457:109451", -- [2]
			"109469:109467", -- [3]
			"109561:109571", -- [4]
			"109561:109571:109572", -- [5]
			"109469:109467:109457:109451:109789", -- [6]
			["m"] = 1015,
			["f"] = 0,
			["direct"] = "109469:109561",
			["coord"] = 2188889228,
			requirements = "cls:HUNTER"
		},
		[109469] = {
			"109467:109457", -- [1]
			"109467:109457:109451", -- [2]
			"109558:109561", -- [3]
			"109558:109561:109571", -- [4]
			"109467:109457:109451:109789:109572", -- [5]
			"109467:109457:109451:109789", -- [6]
			["m"] = 1033,
			["f"] = 0,
			["direct"] = "109467:109558",
			["coord"] = 1775293492,
			requirements = "cls:HUNTER"
		},
		[109561] = {
			"109558:109469:109467:109457", -- [1]
			"109571:109572:109789:109451", -- [2]
			"109558:109469:109467", -- [3]
			"109558:109469", -- [4]
			"109571:109572", -- [5]
			"109571:109572:109789", -- [6]
			["m"] = 1015,
			["f"] = 0,
			["direct"] = "109558:109571",
			["coord"] = 1053912676,
			requirements = "cls:HUNTER"
		},
		[109457] = {
			"109467:109469", -- [1]
			"109467:109469:109558", -- [2]
			"109467:109469:109558:109561", -- [3]
			"109451:109789:109572:109571", -- [4]
			"109451:109789:109572", -- [5]
			"109451:109789", -- [6]
			["m"] = 1017,
			["f"] = 0,
			["direct"] = "109451:109467",
			["coord"] = 1635895994,
			requirements = "cls:HUNTER"
		},
		[109789] = {
			"109451:109457", -- [1]
			"109451:109457:109467", -- [2]
			"109451:109457:109467:109469", -- [3]
			"109451:109457:109467:109469:109558", -- [4]
			"109572:109571:109561", -- [5]
			"109572:109571", -- [6]
			["m"] = 1024,
			["f"] = 0,
			["direct"] = "109451:109572",
			["coord"] = 2433723769,
			requirements = "cls:HUNTER"
		},
		[109572] = {
			"109789:109451:109457", -- [1]
			"109789:109451", -- [2]
			"109789:109451:109457:109467", -- [3]
			"109789:109451:109457:109467:109469", -- [4]
			"109571:109561:109558", -- [5]
			"109571:109561", -- [6]
			["m"] = 1072,
			["direct"] = "109571:109789",
			["coord"] = 1708018224,
			["f"] = 0,
			requirements = "cls:HUNTER",
		},
		[109571] = {
			"109572:109789:109451:109457", -- [1]
			"109572:109789:109451", -- [2]
			"109572:109789:109451:109457:109467", -- [3]
			"109561:109558:109469", -- [4]
			"109561:109558", -- [5]
			"109572:109789", -- [6]
			["m"] = 1018,
			["f"] = 0,
			["direct"] = "109561:109572",
			["coord"] = 1894393429,
			requirements = "cls:HUNTER"
		},
		[109451] = {
			"109457:109467", -- [1]
			"109457:109467:109469", -- [2]
			"109457:109467:109469:109558", -- [3]
			"109789:109572:109571:109561", -- [4]
			"109789:109572:109571", -- [5]
			"109789:109572", -- [6]
			["m"] = 1017,
			["f"] = 0,
			["direct"] = "109457:109789",
			["coord"] = 1972394897,
			requirements = "cls:HUNTER"
		},
		[98968] = {
			"100550:114666:90556", -- [1]
			"100550:114666:90639", -- [2]
			"100550:114666:90556:88110", -- [3]
			"100550:114666:111624:112866", -- [4]
			"100550:100468:100459:93447", -- [5]
			"100550:100468:100459:93940", -- [6]
			"95688:100559:92560", -- [7]
			"95688:100559:92560:98105", -- [8]
			"97860:98124", -- [9]
			"97860:98124:111327:98161", -- [10]
			"97868:98066", -- [11]
			"100550:96565", -- [12]
			"95688:98966", -- [13]
			"97868:98972", -- [14]
			"100550:100468", -- [15]
			"100550:100468:100459", -- [16]
			"100550:114666:111675:96813", -- [17]
			"95688:100559", -- [18]
			"97860:98124:111327", -- [19]
			"100550:114666:111675", -- [20]
			"100550:114666:111624", -- [21]
			"100550:114666:90639:110971", -- [22]
			"95688:100559:92560:98105:111420", -- [23]
			"100550:96565:114718", -- [24]
			"100550:114666", -- [25]
			["m"] = 1072,
			["f"] = 0,
			["direct"] = "95688:97860:97868:97870:94973:100550",
			["coord"] = 1563641753,
			requirements = "cls:HUNTER"
		},
		[107457] = {
			"100459:93447:90556", -- [1]
			"93940:90639", -- [2]
			"100459:93447:90556:88110", -- [3]
			"100459:93447:90556:112866", -- [4]
			"100459:93447", -- [5]
			"100459:100468:100550:95688", -- [6]
			"100459:100468:100550:95688:100559:92560", -- [7]
			"100459:100468:100550:95688:100559:92560:98105", -- [8]
			"100459:100468:100550:95688:100559:98124", -- [9]
			"100459:100468:100550:95688:100559:92560:98161", -- [10]
			"97870:97868:97860", -- [11]
			"97870:97868", -- [12]
			"97870:98066", -- [13]
			"100459:100468:96565", -- [14]
			"100459:100468:96565:98966", -- [15]
			"97870:97868:98972", -- [16]
			"100459:100468", -- [17]
			"100459:100468:100550:94973", -- [18]
			"100459:114666:111675:96813", -- [19]
			"100459:100468:100550", -- [20]
			"100459:100468:100550:95688:100559", -- [21]
			"100459:100468:100550:95688:100559:98124:111327", -- [22]
			"100459:114666:111675", -- [23]
			"100459:93447:111624", -- [24]
			"93940:90639:110971", -- [25]
			"100459:114666:111675:114718:111420", -- [26]
			"100459:114666:111675:114718", -- [27]
			"100459:114666", -- [28]
			["m"] = 1077,
			["coord"] = 2676053642,
			["direct"] = "93940:97870:100459",
			["f"] = 0,
			requirements = "cls:DRUID"
		},		
	},	
	[9] = {
		[118830] = {
			["name"] = "Krokul Hovel, Krokuun",
			["direct"] = "123139:123260:124569:124313:122509:125407:125410:126951",
			["m"] = 1135,
			["coord"] = 2383064171,
			["f"] = 0,
			["isBeacon"] = true,
		},
		[125461] = {
			["name"] = "Vindicaar, Mac'Aree",
			["direct"] = "118830:123139:123260:124569:124313:122509:125407:125410:125514:126951",
			["m"] = 1170,
			["coord"] = 2091072516,
			["f"] = 3,
			["isSpaceship"] = true,
		},
		[122509] = {
			["name"] = "Triumvirate's End, Mac'Aree",
			["direct"] = "118830:123260:124569:125461:124313:125407:125410:126951",
			["m"] = 1170,
			["coord"] = 2270347563,
			["f"] = 0,
			["isBeacon"] = true,
		},
		[123260] = {
			["name"] = "Shattered Fields, Krokuun",
			["direct"] = "118830:123139:124569:124313:122509:125407:125410:126951",
			["m"] = 1135,
			["coord"] = 1731109521,
			["f"] = 0,
			["isBeacon"] = true,
		},
		[126951] = {
			["name"] = "City Center, Mac'Aree",
			["direct"] = "118830:123260:124569:125461:124313:122509:125407:125410",
			["m"] = 1170,
			["coord"] = 2020118034,
			["f"] = 0,
			["isBeacon"] = true,
		},
		[125407] = {
			["name"] = "Hope's Landing, Antoran Wastes",
			["direct"] = "118830:123260:124569:124313:122509:125410:125514:126951",
			["m"] = 1171,
			["coord"] = 3133768023,
			["f"] = 0,
			["isBeacon"] = true,
		},
		[124313] = {
			["name"] = "Conservatory of the Arcane, Mac'Aree",
			["direct"] = "118830:123260:124569:125461:122509:125407:125410:126951",
			["m"] = 1170,
			["coord"] = 2699191586,
			["f"] = 0,
			["isBeacon"] = true,
		},
		[124569] = {
			["name"] = "Destiny Point, Krokuun",
			["direct"] = "118830:123139:123260:124313:122509:125407:125410:126951",
			["m"] = 1135,
			["coord"] = 2692513213,
			["f"] = 0,
			["isBeacon"] = true,
		},
		[125410] = { --Dynamic
			["name"] = "Light's Purchase, Antoran Wastes",
			["direct"] = "118830:123260:124569:124313:122509:125407:125514:126951",
			["m"] = 1171,
			["coord"] = 3119956734,
			["f"] = 0,
			["isBeacon"] = true,
		},
		[125514] = {
			["name"] = "Vindicaar, Antoran Wastes",
			["direct"] = "118830:123139:123260:124569:125461:124313:122509:125407:125410:126951",
			["m"] = 1171,
			["coord"] = 1407291736,
			["f"] = 5,
			["isSpaceship"] = true,
		},
		[123139] = {
			["m"] = 1135,
			["direct"] = "118830:123260:124569:125461:124313:122509:125407:125410:125514:126951",
			["coord"] = 1809529829,
			["f"] = 1,
			["isSpaceship"] = true,
		},
		[125409] = { --Dynamic
            ["name"] = "The Veiled Den, Antoran Wastes",
			["m"] = 1171,
			["f"] = 0,
			["direct"] = "118830:123260:124569:124313:122509:125407:125514:126951",
			["coord"] = 3034464598,
			["isBeacon"] = true,
		}, 
	},
},
	["Alliance"] = {
		{
		[11800] = {
			direct = "3838",
			m = 241,
			f = 0,
			coord = 1897034694,
			requirements = "cls:DRUID",
			overridePlayerData = true
		},
		[4321] = {
			"16227:4267:33253:3841:3838", -- [1]
			"39212:39210:35136:4407", -- [2]
			"40367:41383", -- [3]
			"16227:4267:33253:3841:10897", -- [4]
			"16227:4267:22931:12578:11138", -- [5]
			"16227:4267:22931:12578", -- [6]
			"7823:39175:15177", -- [7]
			"7823:10583", -- [8]
			"16227:4267:33253:3841:3838:17555:17554", -- [9]
			"16227:4267:33253:3841:3838:17555", -- [10]
			"16227:4267:22931", -- [11]
			"16227:4267:22935", -- [12]
			"16227:4267:34374", -- [13]
			"16227:4267:33253", -- [14]
			"39212:39210:34378", -- [15]
			"39212:39210:35136:35137", -- [16]
			"39212:39210:35136", -- [17]
			"39212:39210:35136:6706:35138", -- [18]
			"39212:39210:35136:6706:35481", -- [19]
			"39212:39210:35136:6706:35478", -- [20]
			"39212:39210:35136:6706:35556", -- [21]
			"39212:39210:35136:6706:35562", -- [22]
			"7823:39175", -- [23]
			"39212:39210", -- [24]
			"40358:39211", -- [25]
			"16227:4267:33253:3841:3838:40552:40553", -- [26]
			"16227:4267:33253:3841:3838:40552", -- [27]
			"40358:40768", -- [28]
			"7823:40827", -- [29]
			"7823:41214", -- [30]
			"39212:39210:35136:35137:41240", -- [31]
			"16227:4267:22935:43549:50084", -- [32]
			"16227:4267:22935:43549:50084:53783", -- [33]
			"16227:4267:22935:43549:50084:41861", -- [34]
			"40367:41383:40966", -- [35]
			"40367:41580", -- [36]
			"16227:4267:22931:43073", -- [37]
			"16227:4267:22931:43079", -- [38]
			"16227:4267:22935:43549", -- [39]
			"16227:4267:33253:3841:3838:17555:43991", -- [40]
			"7823:40827:48275", -- [41]
			"7823:39175:15177:48274", -- [42]
			"7823:40827:48275:48273", -- [43]
			"16227:4267:22935:43549:50084:54393", -- [44]
			["direct"] = "3841:4267:40367:6706:7823:16227:40358:39212",
			["f"] = 0,
			["m"] = 141,
			["coord"] = 2897314579,
		},
		[12578] = {
			"3841:3838", -- [1]
			"33253:4267", -- [2]
			"33253:4267:34378:6706:35481:40966:41383:41580:40367", -- [3]
			"33253:4267:16227:4321", -- [4]
			"33253:4407", -- [5]
			"33253:4267:34378:6706", -- [6]
			"33253:4267:34378:39210:39211:40358:40768:7823", -- [7]
			"33253:4267:34378:6706:35481:40966:41383", -- [8]
			"33253:4267:34378:6706:35481:40966:41383:15177", -- [9]
			"33253:4267:34378:39210:39211:40358:40768:7823:10583", -- [10]
			"33253:4267:16227", -- [11]
			"3841:3838:17555:17554", -- [12]
			"3841:3838:17555", -- [13]
			"22931:22935", -- [14]
			"33253:4267:34378:39210:39211:40358", -- [15]
			"33253:34374", -- [16]
			"33253:4267:34378", -- [17]
			"33253:4267:34378:35137", -- [18]
			"33253:4267:34378:35136", -- [19]
			"33253:4407:35138", -- [20]
			"33253:4267:34378:6706:35481", -- [21]
			"33253:4267:34378:6706:35478", -- [22]
			"33253:4267:34378:6706:35556", -- [23]
			"33253:4267:34378:6706:35562", -- [24]
			"33253:4267:34378:6706:35481:40966:41383:15177:39175", -- [25]
			"33253:4267:34378:39210", -- [26]
			"33253:4267:34378:39210:39212", -- [27]
			"33253:4267:34378:39210:39211", -- [28]
			"3841:3838:40552:40553", -- [29]
			"3841:3838:40552", -- [30]
			"33253:4267:34378:39210:39211:40358:40768", -- [31]
			"33253:4267:34378:39210:39211:40358:40768:7823:40827", -- [32]
			"33253:4267:34378:39210:39211:40358:40768:7823:41214", -- [33]
			"33253:4407:41240", -- [34]
			"10897:41861:50084", -- [35]
			"10897:41861:53783", -- [36]
			"10897:41861", -- [37]
			"33253:4267:34378:6706:35481:40966", -- [38]
			"33253:4267:34378:6706:35481:40966:41383:41580", -- [39]
			"43073:43079", -- [40]
			"22931:22935:43549", -- [41]
			"3841:3838:17555:43991", -- [42]
			"33253:4267:34378:6706:35481:40966:41383:15177:48274:48275", -- [43]
			"33253:4267:34378:6706:35481:40966:41383:15177:48274", -- [44]
			"33253:4267:34378:6706:35481:40966:41383:15177:48274:48273", -- [45]
			"10897:41861:50084:54393", -- [46]
			["direct"] = "3841:10897:11138:22931:33253:43073",
			["coord"] = 2601533646,
			["m"] = 182,
			["f"] = 0,
		},
		[54393] = {
			"50084:41861:10897:3841", -- [1]
			"50084:41861:10897:3841:3838", -- [2]
			"50084:43549:22935:4267", -- [3]
			"50084:43549:22935:4267:34378:6706:35481:40966:41383:41580:40367", -- [4]
			"50084:43549:22935:4267:16227:4321", -- [5]
			"50084:43549:22935:4267:34378:4407", -- [6]
			"50084:43549:22935:4267:34378:6706", -- [7]
			"50084:43549:22935:4267:34378:39210:39211:40358:40768:7823", -- [8]
			"50084:43549:22935:4267:34378:6706:35481:40966:41383", -- [9]
			"50084:41861:10897", -- [10]
			"50084:41861:11138", -- [11]
			"50084:41861:10897:12578", -- [12]
			"50084:43549:22935:4267:34378:6706:35481:40966:41383:15177", -- [13]
			"50084:43549:22935:4267:34378:39210:39211:40358:40768:7823:10583", -- [14]
			"50084:43549:22935:4267:16227", -- [15]
			"50084:41861:10897:3841:3838:17555:17554", -- [16]
			"50084:41861:10897:3841:3838:17555", -- [17]
			"50084:43549:22935:22931", -- [18]
			"50084:43549:22935", -- [19]
			"50084:43549:22935:4267:34378:39210:39211:40358", -- [20]
			"50084:43549:22935:4267:34374", -- [21]
			"50084:43549:22935:22931:33253", -- [22]
			"50084:43549:22935:4267:34378", -- [23]
			"50084:43549:22935:4267:34378:35137", -- [24]
			"50084:43549:22935:4267:34378:35136", -- [25]
			"50084:43549:22935:4267:34378:6706:35138", -- [26]
			"50084:43549:22935:4267:34378:6706:35481", -- [27]
			"50084:43549:22935:4267:34378:6706:35478", -- [28]
			"50084:43549:22935:4267:34378:6706:35556", -- [29]
			"50084:43549:22935:4267:34378:6706:35562", -- [30]
			"50084:43549:22935:4267:34378:6706:35481:40966:41383:15177:39175", -- [31]
			"50084:43549:22935:4267:34378:39210", -- [32]
			"50084:43549:22935:4267:34378:39210:39212", -- [33]
			"50084:43549:22935:4267:34378:39210:39211", -- [34]
			"50084:41861:10897:3841:3838:40552:40553", -- [35]
			"50084:41861:10897:3841:3838:40552", -- [36]
			"50084:43549:22935:4267:34378:39210:39211:40358:40768", -- [37]
			"50084:43549:22935:4267:34378:39210:39211:40358:40768:7823:40827", -- [38]
			"50084:43549:22935:4267:34378:39210:39211:40358:40768:7823:41214", -- [39]
			"50084:43549:22935:4267:34378:35137:41240", -- [40]
			"50084:53783", -- [41]
			"50084:41861", -- [42]
			"50084:43549:22935:4267:34378:6706:35481:40966", -- [43]
			"50084:43549:22935:4267:34378:6706:35481:40966:41383:41580", -- [44]
			"50084:41861:10897:12578:43073", -- [45]
			"50084:43549:22935:22931:43079", -- [46]
			"50084:43549", -- [47]
			"50084:41861:10897:3841:3838:17555:43991", -- [48]
			"50084:43549:22935:4267:34378:6706:35481:40966:41383:15177:48274:48275", -- [49]
			"50084:43549:22935:4267:34378:6706:35481:40966:41383:15177:48274", -- [50]
			"50084:43549:22935:4267:34378:6706:35481:40966:41383:15177:48274:48273", -- [51]
			["direct"] = "50084",
			["coord"] = 1192010387,
			["m"] = 606,
			["f"] = 0,
		},
		[39212] = {
			"16227:4267:33253:3841", -- [1]
			"16227:4267:33253:3841:3838", -- [2]
			"16227:4267", -- [3]
			"4321:40367", -- [4]
			"39210:35136:4407", -- [5]
			"39210:35136:6706", -- [6]
			"4321:7823", -- [7]
			"4321:40367:41383", -- [8]
			"16227:4267:33253:3841:10897", -- [9]
			"16227:4267:22931:12578:11138", -- [10]
			"16227:4267:22931:12578", -- [11]
			"4321:7823:39175:15177", -- [12]
			"4321:7823:10583", -- [13]
			"16227:4267:33253:3841:3838:17555:17554", -- [14]
			"16227:4267:33253:3841:3838:17555", -- [15]
			"16227:4267:22931", -- [16]
			"16227:4267:22935", -- [17]
			"4321:40358", -- [18]
			"16227:4267:34374", -- [19]
			"16227:4267:33253", -- [20]
			"39210:34378", -- [21]
			"39210:35136:35137", -- [22]
			"39210:35136", -- [23]
			"39210:35136:6706:35138", -- [24]
			"39210:35136:6706:35481", -- [25]
			"39210:35136:6706:35478", -- [26]
			"39210:35136:6706:35556", -- [27]
			"39210:35136:6706:35562", -- [28]
			"4321:7823:39175", -- [29]
			"16227:4267:33253:3841:3838:40552:40553", -- [30]
			"16227:4267:33253:3841:3838:40552", -- [31]
			"4321:40358:40768", -- [32]
			"4321:7823:40827", -- [33]
			"4321:7823:41214", -- [34]
			"39210:35136:35137:41240", -- [35]
			"16227:4267:22935:43549:50084", -- [36]
			"16227:4267:22935:43549:50084:53783", -- [37]
			"16227:4267:22935:43549:50084:41861", -- [38]
			"39210:35136:6706:35481:40966", -- [39]
			"4321:40367:41580", -- [40]
			"16227:4267:22931:43073", -- [41]
			"16227:4267:22931:43079", -- [42]
			"16227:4267:22935:43549", -- [43]
			"16227:4267:33253:3841:3838:17555:43991", -- [44]
			"4321:7823:40827:48275", -- [45]
			"4321:7823:39175:15177:48274", -- [46]
			"4321:7823:40827:48275:48273", -- [47]
			"16227:4267:22935:43549:50084:54393", -- [48]
			["direct"] = "4321:16227:39210:39211",
			["f"] = 0,
			["m"] = 607,
			["coord"] = 2849601694,
		},
		[35562] = {
			"6706:34378:4267:33253:3841", -- [1]
			"6706:34378:4267:33253:3841:3838", -- [2]
			"6706:34378:4267", -- [3]
			"35481:40966:41383:41580:40367", -- [4]
			"6706:35136:39210:39212:4321", -- [5]
			"35478:4407", -- [6]
			"35481:40966:41383:15177:39175:7823", -- [7]
			"35481:40966:41383", -- [8]
			"6706:34378:4267:33253:3841:10897", -- [9]
			"6706:34378:4267:22931:12578:11138", -- [10]
			"6706:34378:4267:22931:12578", -- [11]
			"35481:40966:41383:15177", -- [12]
			"35481:40966:41383:15177:39175:10583", -- [13]
			"6706:35136:39210:16227", -- [14]
			"6706:34378:4267:33253:3841:3838:17555:17554", -- [15]
			"6706:34378:4267:33253:3841:3838:17555", -- [16]
			"6706:34378:4267:22931", -- [17]
			"6706:34378:4267:22935", -- [18]
			"6706:35136:39210:39211:40358", -- [19]
			"6706:34378:4267:34374", -- [20]
			"6706:34378:4267:33253", -- [21]
			"6706:34378", -- [22]
			"6706:35137", -- [23]
			"6706:35136", -- [24]
			"6706:35138", -- [25]
			"35481:40966:41383:15177:39175", -- [26]
			"6706:35136:39210", -- [27]
			"6706:35136:39210:39212", -- [28]
			"6706:35136:39210:39211", -- [29]
			"6706:34378:4267:33253:3841:3838:40552:40553", -- [30]
			"6706:34378:4267:33253:3841:3838:40552", -- [31]
			"6706:35136:39210:39211:40358:40768", -- [32]
			"35481:40966:41383:15177:48274:48275:40827", -- [33]
			"35481:40966:41383:15177:39175:7823:41214", -- [34]
			"6706:35138:41240", -- [35]
			"6706:34378:4267:22935:43549:50084", -- [36]
			"6706:34378:4267:22935:43549:50084:53783", -- [37]
			"6706:34378:4267:22935:43549:50084:41861", -- [38]
			"35481:40966", -- [39]
			"35481:40966:41383:41580", -- [40]
			"6706:34378:4267:22931:43073", -- [41]
			"6706:34378:4267:22931:43079", -- [42]
			"6706:34378:4267:22935:43549", -- [43]
			"6706:34378:4267:33253:3841:3838:17555:43991", -- [44]
			"35481:40966:41383:15177:48274:48275", -- [45]
			"35481:40966:41383:15177:48274", -- [46]
			"35481:40966:41383:15177:48274:48273", -- [47]
			"6706:34378:4267:22935:43549:50084:54393", -- [48]
			["direct"] = "6706:35481:35478:35556",
			["f"] = 0,
			["m"] = 101,
			["coord"] = 1676035339,
		},
		[41240] = {
			"4407:3841", -- [1]
			"4407:3841:3838", -- [2]
			"35137:34378:4267", -- [3]
			"35138:41383:41580:40367", -- [4]
			"35137:35136:39210:39212:4321", -- [5]
			"35137:6706", -- [6]
			"35137:35136:39210:39211:40358:40768:7823", -- [7]
			"35138:41383", -- [8]
			"4407:3841:10897", -- [9]
			"35137:34378:4267:22931:12578:11138", -- [10]
			"35137:34378:4267:22931:12578", -- [11]
			"35138:41383:15177", -- [12]
			"35138:41383:15177:39175:10583", -- [13]
			"35137:35136:39210:16227", -- [14]
			"4407:3841:3838:17555:17554", -- [15]
			"4407:3841:3838:17555", -- [16]
			"35137:34378:4267:22931", -- [17]
			"35137:34378:4267:22935", -- [18]
			"35137:35136:39210:39211:40358", -- [19]
			"4407:34374", -- [20]
			"35137:34378:4267:33253", -- [21]
			"35137:34378", -- [22]
			"35137:35136", -- [23]
			"35137:6706:35481", -- [24]
			"35137:6706:35478", -- [25]
			"35137:6706:35556", -- [26]
			"35137:6706:35562", -- [27]
			"35138:41383:15177:39175", -- [28]
			"35137:35136:39210", -- [29]
			"35137:35136:39210:39212", -- [30]
			"35137:35136:39210:39211", -- [31]
			"4407:3841:3838:40552:40553", -- [32]
			"4407:3841:3838:40552", -- [33]
			"35137:35136:39210:39211:40358:40768", -- [34]
			"35137:35136:39210:39211:40358:40768:7823:40827", -- [35]
			"35137:35136:39210:39211:40358:40768:7823:41214", -- [36]
			"35137:34378:4267:22935:43549:50084", -- [37]
			"35137:34378:4267:22935:43549:50084:53783", -- [38]
			"35137:34378:4267:22935:43549:50084:41861", -- [39]
			"35137:6706:35481:40966", -- [40]
			"35138:41383:41580", -- [41]
			"35137:34378:4267:22931:43073", -- [42]
			"35137:34378:4267:22931:43079", -- [43]
			"35137:34378:4267:22935:43549", -- [44]
			"4407:3841:3838:17555:43991", -- [45]
			"35138:41383:15177:48274:48275", -- [46]
			"35138:41383:15177:48274", -- [47]
			"35138:41383:15177:48274:48273", -- [48]
			"35137:34378:4267:22935:43549:50084:54393", -- [49]
			["direct"] = "4407:35137:35138",
			["f"] = 0,
			["m"] = 81,
			["coord"] = 2087224263,
		},
		[43073] = {
			"12578:3841", -- [1]
			"12578:3841:3838", -- [2]
			"22931:4267", -- [3]
			"22931:4267:34378:6706:35481:40966:41383:41580:40367", -- [4]
			"22931:4267:16227:4321", -- [5]
			"43079:33253:4407", -- [6]
			"22931:4267:34378:6706", -- [7]
			"22931:4267:34378:39210:39211:40358:40768:7823", -- [8]
			"22931:4267:34378:6706:35481:40966:41383", -- [9]
			"12578:10897", -- [10]
			"12578:11138", -- [11]
			"22931:4267:34378:6706:35481:40966:41383:15177", -- [12]
			"22931:4267:34378:39210:39211:40358:40768:7823:10583", -- [13]
			"22931:4267:16227", -- [14]
			"12578:3841:3838:17555:17554", -- [15]
			"12578:3841:3838:17555", -- [16]
			"22931:22935", -- [17]
			"22931:4267:34378:39210:39211:40358", -- [18]
			"43079:33253:34374", -- [19]
			"43079:33253", -- [20]
			"22931:4267:34378", -- [21]
			"22931:4267:34378:35137", -- [22]
			"22931:4267:34378:35136", -- [23]
			"43079:33253:4407:35138", -- [24]
			"22931:4267:34378:6706:35481", -- [25]
			"22931:4267:34378:6706:35478", -- [26]
			"22931:4267:34378:6706:35556", -- [27]
			"22931:4267:34378:6706:35562", -- [28]
			"22931:4267:34378:6706:35481:40966:41383:15177:39175", -- [29]
			"22931:4267:34378:39210", -- [30]
			"22931:4267:34378:39210:39212", -- [31]
			"22931:4267:34378:39210:39211", -- [32]
			"12578:3841:3838:40552:40553", -- [33]
			"12578:3841:3838:40552", -- [34]
			"22931:4267:34378:39210:39211:40358:40768", -- [35]
			"22931:4267:34378:39210:39211:40358:40768:7823:40827", -- [36]
			"22931:4267:34378:39210:39211:40358:40768:7823:41214", -- [37]
			"22931:4267:34378:35137:41240", -- [38]
			"12578:10897:41861:50084", -- [39]
			"12578:10897:41861:53783", -- [40]
			"12578:10897:41861", -- [41]
			"22931:4267:34378:6706:35481:40966", -- [42]
			"22931:4267:34378:6706:35481:40966:41383:41580", -- [43]
			"22931:22935:43549", -- [44]
			"12578:3841:3838:17555:43991", -- [45]
			"22931:4267:34378:6706:35481:40966:41383:15177:48274:48275", -- [46]
			"22931:4267:34378:6706:35481:40966:41383:15177:48274", -- [47]
			"22931:4267:34378:6706:35481:40966:41383:15177:48274:48273", -- [48]
			"12578:10897:41861:50084:54393", -- [49]
			["direct"] = "12578:22931:43079",
			["f"] = 0,
			["m"] = 182,
			["coord"] = 1872382313,
		},
		[35137] = {
			"34378:4267:33253:3841", -- [1]
			"34378:4267:33253:3841:3838", -- [2]
			"34378:4267", -- [3]
			"6706:35481:40966:41383:41580:40367", -- [4]
			"35136:39210:39212:4321", -- [5]
			"35136:39210:39211:40358:40768:7823", -- [6]
			"6706:35481:40966:41383", -- [7]
			"34378:4267:33253:3841:10897", -- [8]
			"34378:4267:22931:12578:11138", -- [9]
			"34378:4267:22931:12578", -- [10]
			"6706:35481:40966:41383:15177", -- [11]
			"6706:35481:40966:41383:15177:39175:10583", -- [12]
			"35136:39210:16227", -- [13]
			"34378:4267:33253:3841:3838:17555:17554", -- [14]
			"34378:4267:33253:3841:3838:17555", -- [15]
			"34378:4267:22931", -- [16]
			"34378:4267:22935", -- [17]
			"35136:39210:39211:40358", -- [18]
			"34378:4267:34374", -- [19]
			"34378:4267:33253", -- [20]
			"6706:35481", -- [21]
			"6706:35478", -- [22]
			"6706:35556", -- [23]
			"6706:35562", -- [24]
			"6706:35481:40966:41383:15177:39175", -- [25]
			"35136:39210", -- [26]
			"35136:39210:39212", -- [27]
			"35136:39210:39211", -- [28]
			"34378:4267:33253:3841:3838:40552:40553", -- [29]
			"34378:4267:33253:3841:3838:40552", -- [30]
			"35136:39210:39211:40358:40768", -- [31]
			"35136:39210:39211:40358:40768:7823:40827", -- [32]
			"35136:39210:39211:40358:40768:7823:41214", -- [33]
			"34378:4267:22935:43549:50084", -- [34]
			"34378:4267:22935:43549:50084:53783", -- [35]
			"34378:4267:22935:43549:50084:41861", -- [36]
			"6706:35481:40966", -- [37]
			"6706:35481:40966:41383:41580", -- [38]
			"34378:4267:22931:43073", -- [39]
			"34378:4267:22931:43079", -- [40]
			"34378:4267:22935:43549", -- [41]
			"34378:4267:33253:3841:3838:17555:43991", -- [42]
			"6706:35481:40966:41383:15177:48274:48275", -- [43]
			"6706:35481:40966:41383:15177:48274", -- [44]
			"6706:35481:40966:41383:15177:48274:48273", -- [45]
			"34378:4267:22935:43549:50084:54393", -- [46]
			["direct"] = "4407:6706:34378:35136:35138:41240",
			["f"] = 0,
			["m"] = 81,
			["coord"] = 2525465343,
		},
		[43079] = {
			"33253:3841", -- [1]
			"33253:3841:3838", -- [2]
			"22931:4267", -- [3]
			"22931:4267:34378:6706:35481:40966:41383:41580:40367", -- [4]
			"22931:4267:16227:4321", -- [5]
			"33253:4407", -- [6]
			"22931:4267:34378:6706", -- [7]
			"22931:4267:34378:39210:39211:40358:40768:7823", -- [8]
			"22931:4267:34378:6706:35481:40966:41383", -- [9]
			"43073:12578:10897", -- [10]
			"43073:12578:11138", -- [11]
			"43073:12578", -- [12]
			"22931:4267:34378:6706:35481:40966:41383:15177", -- [13]
			"22931:4267:34378:39210:39211:40358:40768:7823:10583", -- [14]
			"22931:4267:16227", -- [15]
			"33253:3841:3838:17555:17554", -- [16]
			"33253:3841:3838:17555", -- [17]
			"22931:22935", -- [18]
			"22931:4267:34378:39210:39211:40358", -- [19]
			"33253:34374", -- [20]
			"22931:4267:34378", -- [21]
			"22931:4267:34378:35137", -- [22]
			"22931:4267:34378:35136", -- [23]
			"33253:4407:35138", -- [24]
			"22931:4267:34378:6706:35481", -- [25]
			"22931:4267:34378:6706:35478", -- [26]
			"22931:4267:34378:6706:35556", -- [27]
			"22931:4267:34378:6706:35562", -- [28]
			"22931:4267:34378:6706:35481:40966:41383:15177:39175", -- [29]
			"22931:4267:34378:39210", -- [30]
			"22931:4267:34378:39210:39212", -- [31]
			"22931:4267:34378:39210:39211", -- [32]
			"33253:3841:3838:40552:40553", -- [33]
			"33253:3841:3838:40552", -- [34]
			"22931:4267:34378:39210:39211:40358:40768", -- [35]
			"22931:4267:34378:39210:39211:40358:40768:7823:40827", -- [36]
			"22931:4267:34378:39210:39211:40358:40768:7823:41214", -- [37]
			"22931:4267:34378:35137:41240", -- [38]
			"22931:22935:43549:50084", -- [39]
			"22931:22935:43549:50084:53783", -- [40]
			"43073:12578:10897:41861", -- [41]
			"22931:4267:34378:6706:35481:40966", -- [42]
			"22931:4267:34378:6706:35481:40966:41383:41580", -- [43]
			"22931:22935:43549", -- [44]
			"33253:3841:3838:17555:43991", -- [45]
			"22931:4267:34378:6706:35481:40966:41383:15177:48274:48275", -- [46]
			"22931:4267:34378:6706:35481:40966:41383:15177:48274", -- [47]
			"22931:4267:34378:6706:35481:40966:41383:15177:48274:48273", -- [48]
			"22931:22935:43549:50084:54393", -- [49]
			["direct"] = "22931:33253:43073",
			["f"] = 0,
			["m"] = 182,
			["coord"] = 1899863695,
		},
		[33253] = {
			"3841:3838", -- [1]
			"4267:34378:6706:35481:40966:41383:41580:40367", -- [2]
			"4267:16227:4321", -- [3]
			"4267:34378:6706", -- [4]
			"4267:34378:39210:39211:40358:40768:7823", -- [5]
			"4267:34378:6706:35481:40966:41383", -- [6]
			"3841:10897", -- [7]
			"12578:11138", -- [8]
			"4267:34378:6706:35481:40966:41383:15177", -- [9]
			"4267:34378:39210:39211:40358:40768:7823:10583", -- [10]
			"4267:16227", -- [11]
			"3841:3838:17555:17554", -- [12]
			"3841:3838:17555", -- [13]
			"22931:22935", -- [14]
			"4267:34378:39210:39211:40358", -- [15]
			"4267:34378", -- [16]
			"4267:34378:35137", -- [17]
			"4267:34378:35136", -- [18]
			"4407:35138", -- [19]
			"4267:34378:6706:35481", -- [20]
			"4267:34378:6706:35478", -- [21]
			"4267:34378:6706:35556", -- [22]
			"4267:34378:6706:35562", -- [23]
			"4267:34378:6706:35481:40966:41383:15177:39175", -- [24]
			"4267:34378:39210", -- [25]
			"4267:34378:39210:39212", -- [26]
			"4267:34378:39210:39211", -- [27]
			"3841:3838:40552:40553", -- [28]
			"3841:3838:40552", -- [29]
			"4267:34378:39210:39211:40358:40768", -- [30]
			"4267:34378:39210:39211:40358:40768:7823:40827", -- [31]
			"4267:34378:39210:39211:40358:40768:7823:41214", -- [32]
			"4407:41240", -- [33]
			"22931:22935:43549:50084", -- [34]
			"22931:22935:43549:50084:53783", -- [35]
			"3841:10897:41861", -- [36]
			"4267:34378:6706:35481:40966", -- [37]
			"4267:34378:6706:35481:40966:41383:41580", -- [38]
			"43079:43073", -- [39]
			"22931:22935:43549", -- [40]
			"3841:3838:17555:43991", -- [41]
			"4267:34378:6706:35481:40966:41383:15177:48274:48275", -- [42]
			"4267:34378:6706:35481:40966:41383:15177:48274", -- [43]
			"4267:34378:6706:35481:40966:41383:15177:48274:48273", -- [44]
			"22931:22935:43549:50084:54393", -- [45]
			["direct"] = "3841:4267:4407:12578:22931:34374:43079",
			["coord"] = 1906164010,
			["m"] = 42,
			["f"] = 0,
		},
		[11138] = {
			"10897:3841", -- [1]
			"10897:3841:3838", -- [2]
			"12578:33253:4267", -- [3]
			"12578:33253:4267:34378:6706:35481:40966:41383:41580:40367", -- [4]
			"12578:33253:4267:16227:4321", -- [5]
			"12578:33253:4407", -- [6]
			"12578:33253:4267:34378:6706", -- [7]
			"12578:33253:4267:34378:39210:39211:40358:40768:7823", -- [8]
			"12578:33253:4267:34378:6706:35481:40966:41383", -- [9]
			"12578:33253:4267:34378:6706:35481:40966:41383:15177", -- [10]
			"12578:33253:4267:34378:39210:39211:40358:40768:7823:10583", -- [11]
			"12578:33253:4267:16227", -- [12]
			"10897:3841:3838:17555:17554", -- [13]
			"10897:3841:3838:17555", -- [14]
			"12578:22931", -- [15]
			"41861:50084:43549:22935", -- [16]
			"12578:33253:4267:34378:39210:39211:40358", -- [17]
			"12578:33253:34374", -- [18]
			"12578:33253", -- [19]
			"12578:33253:4267:34378", -- [20]
			"12578:33253:4267:34378:35137", -- [21]
			"12578:33253:4267:34378:35136", -- [22]
			"12578:33253:4407:35138", -- [23]
			"12578:33253:4267:34378:6706:35481", -- [24]
			"12578:33253:4267:34378:6706:35478", -- [25]
			"12578:33253:4267:34378:6706:35556", -- [26]
			"12578:33253:4267:34378:6706:35562", -- [27]
			"12578:33253:4267:34378:6706:35481:40966:41383:15177:39175", -- [28]
			"12578:33253:4267:34378:39210", -- [29]
			"12578:33253:4267:34378:39210:39212", -- [30]
			"12578:33253:4267:34378:39210:39211", -- [31]
			"10897:3841:3838:40552:40553", -- [32]
			"10897:3841:3838:40552", -- [33]
			"12578:33253:4267:34378:39210:39211:40358:40768", -- [34]
			"12578:33253:4267:34378:39210:39211:40358:40768:7823:40827", -- [35]
			"12578:33253:4267:34378:39210:39211:40358:40768:7823:41214", -- [36]
			"12578:33253:4407:41240", -- [37]
			"41861:50084", -- [38]
			"41861:53783", -- [39]
			"12578:33253:4267:34378:6706:35481:40966", -- [40]
			"12578:33253:4267:34378:6706:35481:40966:41383:41580", -- [41]
			"12578:43073", -- [42]
			"12578:43073:43079", -- [43]
			"41861:50084:43549", -- [44]
			"10897:3841:3838:17555:43991", -- [45]
			"12578:33253:4267:34378:6706:35481:40966:41383:15177:48274:48275", -- [46]
			"12578:33253:4267:34378:6706:35481:40966:41383:15177:48274", -- [47]
			"12578:33253:4267:34378:6706:35481:40966:41383:15177:48274:48273", -- [48]
			"41861:50084:54393", -- [49]
			["direct"] = "10897:12578:41861",
			["coord"] = 2619374768,
			["m"] = 281,
			["f"] = 0,
		},
		[3841] = {
			"41383:41580:40367", -- [1]
			"33253:4267:34378:39210:39211:40358:40768:7823", -- [2]
			"12578:11138", -- [3]
			"41383:15177", -- [4]
			"33253:4267:34378:39210:39211:40358:40768:7823:10583", -- [5]
			"33253:4267:16227", -- [6]
			"3838:17555:17554", -- [7]
			"3838:17555", -- [8]
			"33253:22931", -- [9]
			"33253:22931:22935", -- [10]
			"33253:4267:34378:39210:39211:40358", -- [11]
			"33253:34374", -- [12]
			"33253:4267:34378", -- [13]
			"33253:4267:34378:35137", -- [14]
			"33253:4267:34378:35136", -- [15]
			"33253:4407:35138", -- [16]
			"33253:4267:34378:6706:35481", -- [17]
			"33253:4267:34378:6706:35478", -- [18]
			"33253:4267:34378:6706:35556", -- [19]
			"33253:4267:34378:6706:35562", -- [20]
			"41383:15177:39175", -- [21]
			"33253:4267:34378:39210", -- [22]
			"33253:4267:34378:39210:39212", -- [23]
			"33253:4267:34378:39210:39211", -- [24]
			"3838:40552:40553", -- [25]
			"3838:40552", -- [26]
			"33253:4267:34378:39210:39211:40358:40768", -- [27]
			"33253:4267:34378:39210:39211:40358:40768:7823:40827", -- [28]
			"33253:4267:34378:39210:39211:40358:40768:7823:41214", -- [29]
			"33253:4407:41240", -- [30]
			"10897:41861:50084", -- [31]
			"10897:41861:53783", -- [32]
			"10897:41861", -- [33]
			"33253:4267:34378:6706:35481:40966", -- [34]
			"41383:41580", -- [35]
			"12578:43073", -- [36]
			"33253:43079", -- [37]
			"10897:41861:50084:43549", -- [38]
			"3838:17555:43991", -- [39]
			"41383:15177:48274:48275", -- [40]
			"41383:15177:48274", -- [41]
			"41383:15177:48274:48273", -- [42]
			"10897:41861:50084:54393", -- [43]
			["direct"] = "3838:4267:4321:4407:6706:41383:10897:12578:33253",
			["coord"] = 2221157712,
			["m"] = 42,
			["f"] = 0,
		},
		[7823] = {
			"40768:40358:39211:39210:34378:4267:33253:3841", -- [1]
			"40768:40358:39211:39210:34378:4267:33253:3841:3838", -- [2]
			"40768:40358:39211:39210:34378:4267", -- [3]
			"40768:40358:39211:39210:35136:4407", -- [4]
			"40768:40358:39211:39210:35136:6706", -- [5]
			"40367:41383", -- [6]
			"40768:40358:39211:39210:34378:4267:33253:3841:10897", -- [7]
			"40768:40358:39211:39210:34378:4267:22931:12578:11138", -- [8]
			"40768:40358:39211:39210:34378:4267:22931:12578", -- [9]
			"40768:40358:39211:39210:34378:4267:33253:3841:3838:17555:17554", -- [10]
			"40768:40358:39211:39210:34378:4267:33253:3841:3838:17555", -- [11]
			"40768:40358:39211:39210:34378:4267:22931", -- [12]
			"40768:40358:39211:39210:34378:4267:22935", -- [13]
			"40768:40358", -- [14]
			"40768:40358:39211:39210:34378:4267:34374", -- [15]
			"40768:40358:39211:39210:34378:4267:33253", -- [16]
			"40768:40358:39211:39210:34378", -- [17]
			"40768:40358:39211:39210:35136:35137", -- [18]
			"40768:40358:39211:39210:35136", -- [19]
			"40768:40358:39211:39210:35136:6706:35138", -- [20]
			"40367:41383:40966:35481", -- [21]
			"40768:40358:39211:39210:35136:6706:35478", -- [22]
			"40768:40358:39211:39210:35136:6706:35556", -- [23]
			"40768:40358:39211:39210:35136:6706:35562", -- [24]
			"40768:40358:39211:39210", -- [25]
			"4321:39212", -- [26]
			"40768:40358:39211", -- [27]
			"40768:40358:39211:39210:34378:4267:33253:3841:3838:40552:40553", -- [28]
			"40768:40358:39211:39210:34378:4267:33253:3841:3838:40552", -- [29]
			"40768:40358:39211:39210:35136:35137:41240", -- [30]
			"40768:40358:39211:39210:34378:4267:22935:43549:50084", -- [31]
			"40768:40358:39211:39210:34378:4267:22935:43549:50084:53783", -- [32]
			"40768:40358:39211:39210:34378:4267:22935:43549:50084:41861", -- [33]
			"40367:41383:40966", -- [34]
			"40367:41580", -- [35]
			"40768:40358:39211:39210:34378:4267:22931:43073", -- [36]
			"40768:40358:39211:39210:34378:4267:22931:43079", -- [37]
			"40768:40358:39211:39210:34378:4267:22935:43549", -- [38]
			"40768:40358:39211:39210:34378:4267:33253:3841:3838:17555:43991", -- [39]
			"40827:48275", -- [40]
			"39175:15177:48274", -- [41]
			"40827:48275:48273", -- [42]
			"40768:40358:39211:39210:34378:4267:22935:43549:50084:54393", -- [43]
			["direct"] = "40367:4321:15177:10583:16227:39175:40768:40827:41214",
			["f"] = 0,
			["m"] = 161,
			["coord"] = 2206747479,
		},
		[40827] = {
			"7823:40768:40358:39211:39210:34378:4267:33253:3841", -- [1]
			"7823:40768:40358:39211:39210:34378:4267:33253:3841:3838", -- [2]
			"7823:40768:40358:39211:39210:34378:4267", -- [3]
			"7823:40367", -- [4]
			"7823:4321", -- [5]
			"7823:40768:40358:39211:39210:35136:4407", -- [6]
			"7823:40768:40358:39211:39210:35136:6706", -- [7]
			"48275:48274:15177:41383", -- [8]
			"7823:40768:40358:39211:39210:34378:4267:33253:3841:10897", -- [9]
			"7823:40768:40358:39211:39210:34378:4267:22931:12578:11138", -- [10]
			"7823:40768:40358:39211:39210:34378:4267:22931:12578", -- [11]
			"48275:48274:15177", -- [12]
			"7823:10583", -- [13]
			"7823:16227", -- [14]
			"7823:40768:40358:39211:39210:34378:4267:33253:3841:3838:17555:17554", -- [15]
			"7823:40768:40358:39211:39210:34378:4267:33253:3841:3838:17555", -- [16]
			"7823:40768:40358:39211:39210:34378:4267:22931", -- [17]
			"7823:40768:40358:39211:39210:34378:4267:22935", -- [18]
			"7823:40768:40358", -- [19]
			"7823:40768:40358:39211:39210:34378:4267:34374", -- [20]
			"7823:40768:40358:39211:39210:34378:4267:33253", -- [21]
			"7823:40768:40358:39211:39210:34378", -- [22]
			"7823:40768:40358:39211:39210:35136:35137", -- [23]
			"7823:40768:40358:39211:39210:35136", -- [24]
			"7823:40768:40358:39211:39210:35136:6706:35138", -- [25]
			"48275:48274:15177:41383:40966:35481", -- [26]
			"48275:48274:15177:41383:40966:35481:35478", -- [27]
			"7823:40768:40358:39211:39210:35136:6706:35556", -- [28]
			"48275:48274:15177:41383:40966:35481:35562", -- [29]
			"7823:39175", -- [30]
			"7823:40768:40358:39211:39210", -- [31]
			"7823:4321:39212", -- [32]
			"7823:40768:40358:39211", -- [33]
			"7823:40768:40358:39211:39210:34378:4267:33253:3841:3838:40552:40553", -- [34]
			"7823:40768:40358:39211:39210:34378:4267:33253:3841:3838:40552", -- [35]
			"7823:40768", -- [36]
			"7823:40768:40358:39211:39210:35136:35137:41240", -- [37]
			"7823:40768:40358:39211:39210:34378:4267:22935:43549:50084", -- [38]
			"7823:40768:40358:39211:39210:34378:4267:22935:43549:50084:53783", -- [39]
			"7823:40768:40358:39211:39210:34378:4267:22935:43549:50084:41861", -- [40]
			"48275:48274:15177:41383:40966", -- [41]
			"7823:40367:41580", -- [42]
			"7823:40768:40358:39211:39210:34378:4267:22931:43073", -- [43]
			"7823:40768:40358:39211:39210:34378:4267:22931:43079", -- [44]
			"7823:40768:40358:39211:39210:34378:4267:22935:43549", -- [45]
			"7823:40768:40358:39211:39210:34378:4267:33253:3841:3838:17555:43991", -- [46]
			"48275:48274", -- [47]
			"48275:48273", -- [48]
			"7823:40768:40358:39211:39210:34378:4267:22935:43549:50084:54393", -- [49]
			["direct"] = "7823:41214:48275",
			["f"] = 0,
			["m"] = 161,
			["coord"] = 1720960606,
		},
		[40768] = {
			"40358:39211:39210:34378:4267:33253:3841", -- [1]
			"40358:39211:39210:34378:4267:33253:3841:3838", -- [2]
			"40358:39211:39210:34378:4267", -- [3]
			"40358:4321", -- [4]
			"40358:39211:39210:35136:4407", -- [5]
			"40358:39211:39210:35136:6706", -- [6]
			"40367:41383", -- [7]
			"40358:39211:39210:34378:4267:33253:3841:10897", -- [8]
			"40358:39211:39210:34378:4267:22931:12578:11138", -- [9]
			"40358:39211:39210:34378:4267:22931:12578", -- [10]
			"7823:39175:15177", -- [11]
			"7823:10583", -- [12]
			"40358:4321:16227", -- [13]
			"40358:39211:39210:34378:4267:33253:3841:3838:17555:17554", -- [14]
			"40358:39211:39210:34378:4267:33253:3841:3838:17555", -- [15]
			"40358:39211:39210:34378:4267:22931", -- [16]
			"40358:39211:39210:34378:4267:22935", -- [17]
			"40358:39211:39210:34378:4267:34374", -- [18]
			"40358:39211:39210:34378:4267:33253", -- [19]
			"40358:39211:39210:34378", -- [20]
			"40358:39211:39210:35136:35137", -- [21]
			"40358:39211:39210:35136", -- [22]
			"40358:39211:39210:35136:6706:35138", -- [23]
			"40367:41383:40966:35481", -- [24]
			"40358:39211:39210:35136:6706:35478", -- [25]
			"40358:39211:39210:35136:6706:35556", -- [26]
			"40358:39211:39210:35136:6706:35562", -- [27]
			"7823:39175", -- [28]
			"40358:39211:39210", -- [29]
			"40358:4321:39212", -- [30]
			"40358:39211", -- [31]
			"40358:39211:39210:34378:4267:33253:3841:3838:40552:40553", -- [32]
			"40358:39211:39210:34378:4267:33253:3841:3838:40552", -- [33]
			"7823:40827", -- [34]
			"7823:41214", -- [35]
			"40358:39211:39210:35136:35137:41240", -- [36]
			"40358:39211:39210:34378:4267:22935:43549:50084", -- [37]
			"40358:39211:39210:34378:4267:22935:43549:50084:53783", -- [38]
			"40358:39211:39210:34378:4267:22935:43549:50084:41861", -- [39]
			"40367:41383:40966", -- [40]
			"40367:41580", -- [41]
			"40358:39211:39210:34378:4267:22931:43073", -- [42]
			"40358:39211:39210:34378:4267:22931:43079", -- [43]
			"40358:39211:39210:34378:4267:22935:43549", -- [44]
			"40358:39211:39210:34378:4267:33253:3841:3838:17555:43991", -- [45]
			"7823:40827:48275", -- [46]
			"7823:39175:15177:48274", -- [47]
			"7823:40827:48275:48273", -- [48]
			"40358:39211:39210:34378:4267:22935:43549:50084:54393", -- [49]
			["direct"] = "40367:7823:40358",
			["f"] = 0,
			["m"] = 61,
			["coord"] = 3397040136,
		},
		[17554] = {
			"17555:3838:3841", -- [1]
			"17555:3838", -- [2]
			"17555:3838:3841:33253:4267", -- [3]
			"17555:3838:3841:41383:41580:40367", -- [4]
			"17555:3838:3841:33253:4267:16227:4321", -- [5]
			"17555:3838:3841:33253:4407", -- [6]
			"17555:3838:3841:33253:4267:34378:6706", -- [7]
			"17555:3838:3841:33253:4267:34378:39210:39211:40358:40768:7823", -- [8]
			"17555:3838:3841:41383", -- [9]
			"17555:3838:3841:10897", -- [10]
			"17555:3838:3841:12578:11138", -- [11]
			"17555:3838:3841:12578", -- [12]
			"17555:3838:3841:41383:15177", -- [13]
			"17555:3838:3841:33253:4267:34378:39210:39211:40358:40768:7823:10583", -- [14]
			"17555:3838:3841:33253:4267:16227", -- [15]
			"17555:3838:3841:33253:22931", -- [16]
			"17555:3838:3841:33253:22931:22935", -- [17]
			"17555:3838:3841:33253:4267:34378:39210:39211:40358", -- [18]
			"17555:3838:3841:33253:34374", -- [19]
			"17555:3838:3841:33253", -- [20]
			"17555:3838:3841:33253:4267:34378", -- [21]
			"17555:3838:3841:33253:4267:34378:35137", -- [22]
			"17555:3838:3841:33253:4267:34378:35136", -- [23]
			"17555:3838:3841:33253:4407:35138", -- [24]
			"17555:3838:3841:33253:4267:34378:6706:35481", -- [25]
			"17555:3838:3841:33253:4267:34378:6706:35478", -- [26]
			"17555:3838:3841:33253:4267:34378:6706:35556", -- [27]
			"17555:3838:3841:33253:4267:34378:6706:35562", -- [28]
			"17555:3838:3841:41383:15177:39175", -- [29]
			"17555:3838:3841:33253:4267:34378:39210", -- [30]
			"17555:3838:3841:33253:4267:34378:39210:39212", -- [31]
			"17555:3838:3841:33253:4267:34378:39210:39211", -- [32]
			"17555:3838:40552:40553", -- [33]
			"17555:3838:40552", -- [34]
			"17555:3838:3841:33253:4267:34378:39210:39211:40358:40768", -- [35]
			"17555:3838:3841:33253:4267:34378:39210:39211:40358:40768:7823:40827", -- [36]
			"17555:3838:3841:33253:4267:34378:39210:39211:40358:40768:7823:41214", -- [37]
			"17555:3838:3841:33253:4407:41240", -- [38]
			"17555:3838:3841:10897:41861:50084", -- [39]
			"17555:3838:3841:10897:41861:53783", -- [40]
			"17555:3838:3841:10897:41861", -- [41]
			"17555:3838:3841:33253:4267:34378:6706:35481:40966", -- [42]
			"17555:3838:3841:41383:41580", -- [43]
			"17555:3838:3841:12578:43073", -- [44]
			"17555:3838:3841:33253:43079", -- [45]
			"17555:3838:3841:10897:41861:50084:43549", -- [46]
			"17555:43991", -- [47]
			"17555:3838:3841:41383:15177:48274:48275", -- [48]
			"17555:3838:3841:41383:15177:48274", -- [49]
			"17555:3838:3841:41383:15177:48274:48273", -- [50]
			"17555:3838:3841:10897:41861:50084:54393", -- [51]
			["direct"] = "17555",
			["coord"] = 2474412618,
			["m"] = 476,
			["f"] = 0,
		},
		[6706] = {
			"34378:4267:33253:3841:3838", -- [1]
			"34378:4267", -- [2]
			"35481:40966:41383:41580:40367", -- [3]
			"35136:39210:39211:40358:40768:7823", -- [4]
			"34378:4267:33253:3841:10897", -- [5]
			"34378:4267:22931:12578:11138", -- [6]
			"34378:4267:22931:12578", -- [7]
			"35481:40966:41383:15177", -- [8]
			"35481:40966:41383:15177:39175:10583", -- [9]
			"35136:39210:16227", -- [10]
			"34378:4267:33253:3841:3838:17555:17554", -- [11]
			"34378:4267:33253:3841:3838:17555", -- [12]
			"34378:4267:22931", -- [13]
			"34378:4267:22935", -- [14]
			"35136:39210:39211:40358", -- [15]
			"34378:4267:34374", -- [16]
			"34378:4267:33253", -- [17]
			"35481:40966:41383:15177:39175", -- [18]
			"35136:39210", -- [19]
			"35136:39210:39212", -- [20]
			"35136:39210:39211", -- [21]
			"34378:4267:33253:3841:3838:40552:40553", -- [22]
			"34378:4267:33253:3841:3838:40552", -- [23]
			"35136:39210:39211:40358:40768", -- [24]
			"35136:39210:39211:40358:40768:7823:40827", -- [25]
			"35136:39210:39211:40358:40768:7823:41214", -- [26]
			"35138:41240", -- [27]
			"34378:4267:22935:43549:50084", -- [28]
			"34378:4267:22935:43549:50084:53783", -- [29]
			"34378:4267:22935:43549:50084:41861", -- [30]
			"35481:40966", -- [31]
			"35481:40966:41383:41580", -- [32]
			"34378:4267:22931:43073", -- [33]
			"34378:4267:22931:43079", -- [34]
			"34378:4267:22935:43549", -- [35]
			"34378:4267:33253:3841:3838:17555:43991", -- [36]
			"35481:40966:41383:15177:48274:48275", -- [37]
			"35481:40966:41383:15177:48274", -- [38]
			"35481:40966:41383:15177:48274:48273", -- [39]
			"34378:4267:22935:43549:50084:54393", -- [40]
			["direct"] = "3841:4321:4407:41383:34378:35137:35136:35138:35481:35478:35556:35562",
			["f"] = 0,
			["m"] = 101,
			["coord"] = 2777553590,
		},
		[40553] = {
			"40552:3838:3841", -- [1]
			"40552:3838", -- [2]
			"40552:3838:3841:33253:4267", -- [3]
			"40552:3838:3841:41383:41580:40367", -- [4]
			"40552:3838:3841:33253:4267:16227:4321", -- [5]
			"40552:3838:3841:33253:4407", -- [6]
			"40552:3838:3841:33253:4267:34378:6706", -- [7]
			"40552:3838:3841:33253:4267:34378:39210:39211:40358:40768:7823", -- [8]
			"40552:3838:3841:41383", -- [9]
			"40552:3838:3841:10897", -- [10]
			"40552:3838:3841:12578:11138", -- [11]
			"40552:3838:3841:12578", -- [12]
			"40552:3838:3841:41383:15177", -- [13]
			"40552:3838:3841:33253:4267:34378:39210:39211:40358:40768:7823:10583", -- [14]
			"40552:3838:3841:33253:4267:16227", -- [15]
			"40552:3838:17555:17554", -- [16]
			"40552:3838:17555", -- [17]
			"40552:3838:3841:33253:22931", -- [18]
			"40552:3838:3841:33253:22931:22935", -- [19]
			"40552:3838:3841:33253:4267:34378:39210:39211:40358", -- [20]
			"40552:3838:3841:33253:34374", -- [21]
			"40552:3838:3841:33253", -- [22]
			"40552:3838:3841:33253:4267:34378", -- [23]
			"40552:3838:3841:33253:4267:34378:35137", -- [24]
			"40552:3838:3841:33253:4267:34378:35136", -- [25]
			"40552:3838:3841:33253:4407:35138", -- [26]
			"40552:3838:3841:33253:4267:34378:6706:35481", -- [27]
			"40552:3838:3841:33253:4267:34378:6706:35478", -- [28]
			"40552:3838:3841:33253:4267:34378:6706:35556", -- [29]
			"40552:3838:3841:33253:4267:34378:6706:35562", -- [30]
			"40552:3838:3841:41383:15177:39175", -- [31]
			"40552:3838:3841:33253:4267:34378:39210", -- [32]
			"40552:3838:3841:33253:4267:34378:39210:39212", -- [33]
			"40552:3838:3841:33253:4267:34378:39210:39211", -- [34]
			"40552:3838:3841:33253:4267:34378:39210:39211:40358:40768", -- [35]
			"40552:3838:3841:33253:4267:34378:39210:39211:40358:40768:7823:40827", -- [36]
			"40552:3838:3841:33253:4267:34378:39210:39211:40358:40768:7823:41214", -- [37]
			"40552:3838:3841:33253:4407:41240", -- [38]
			"40552:3838:3841:10897:41861:50084", -- [39]
			"40552:3838:3841:10897:41861:53783", -- [40]
			"40552:3838:3841:10897:41861", -- [41]
			"40552:3838:3841:33253:4267:34378:6706:35481:40966", -- [42]
			"40552:3838:3841:41383:41580", -- [43]
			"40552:3838:3841:12578:43073", -- [44]
			"40552:3838:3841:33253:43079", -- [45]
			"40552:3838:3841:10897:41861:50084:43549", -- [46]
			"40552:3838:17555:43991", -- [47]
			"40552:3838:3841:41383:15177:48274:48275", -- [48]
			"40552:3838:3841:41383:15177:48274", -- [49]
			"40552:3838:3841:41383:15177:48274:48273", -- [50]
			"40552:3838:3841:10897:41861:50084:54393", -- [51]
			["direct"] = "40552",
			["coord"] = 2381611283,
			["m"] = 41,
			["f"] = 0,
		},
		[4407] = {
			"3841:3838", -- [1]
			"35481:40966:41383:41580:40367", -- [2]
			"35136:39210:39212:4321", -- [3]
			"35136:39210:39211:40358:40768:7823", -- [4]
			"35481:40966:41383", -- [5]
			"3841:10897", -- [6]
			"33253:12578:11138", -- [7]
			"33253:12578", -- [8]
			"35481:40966:41383:15177", -- [9]
			"35481:40966:41383:15177:39175:10583", -- [10]
			"35136:39210:16227", -- [11]
			"3841:3838:17555:17554", -- [12]
			"3841:3838:17555", -- [13]
			"34378:4267:22931", -- [14]
			"34378:4267:22935", -- [15]
			"35136:39210:39211:40358", -- [16]
			"6706:35556", -- [17]
			"6706:35562", -- [18]
			"35481:40966:41383:15177:39175", -- [19]
			"35136:39210", -- [20]
			"35136:39210:39212", -- [21]
			"35136:39210:39211", -- [22]
			"3841:3838:40552:40553", -- [23]
			"3841:3838:40552", -- [24]
			"35136:39210:39211:40358:40768", -- [25]
			"35136:39210:39211:40358:40768:7823:40827", -- [26]
			"35136:39210:39211:40358:40768:7823:41214", -- [27]
			"34378:4267:22935:43549:50084", -- [28]
			"34378:4267:22935:43549:50084:53783", -- [29]
			"34378:4267:22935:43549:50084:41861", -- [30]
			"35481:40966", -- [31]
			"35481:40966:41383:41580", -- [32]
			"33253:43079:43073", -- [33]
			"33253:43079", -- [34]
			"34378:4267:22935:43549", -- [35]
			"3841:3838:17555:43991", -- [36]
			"35481:40966:41383:15177:48274:48275", -- [37]
			"35481:40966:41383:15177:48274", -- [38]
			"35481:40966:41383:15177:48274:48273", -- [39]
			"34378:4267:22935:43549:50084:54393", -- [40]
			["direct"] = "3841:4267:6706:34374:33253:34378:35137:35136:35138:35481:35478:41240",
			["f"] = 0,
			["m"] = 81,
			["coord"] = 1721061838,
		},
		[43991] = {
			"17555:3838:3841", -- [1]
			"17555:3838", -- [2]
			"17555:3838:3841:33253:4267", -- [3]
			"17555:3838:3841:41383:41580:40367", -- [4]
			"17555:3838:3841:33253:4267:16227:4321", -- [5]
			"17555:3838:3841:33253:4407", -- [6]
			"17555:3838:3841:33253:4267:34378:6706", -- [7]
			"17555:3838:3841:33253:4267:34378:39210:39211:40358:40768:7823", -- [8]
			"17555:3838:3841:41383", -- [9]
			"17555:3838:3841:10897", -- [10]
			"17555:3838:3841:12578:11138", -- [11]
			"17555:3838:3841:12578", -- [12]
			"17555:3838:3841:41383:15177", -- [13]
			"17555:3838:3841:33253:4267:34378:39210:39211:40358:40768:7823:10583", -- [14]
			"17555:3838:3841:33253:4267:16227", -- [15]
			"17555:17554", -- [16]
			"17555:3838:3841:33253:22931", -- [17]
			"17555:3838:3841:33253:22931:22935", -- [18]
			"17555:3838:3841:33253:4267:34378:39210:39211:40358", -- [19]
			"17555:3838:3841:33253:34374", -- [20]
			"17555:3838:3841:33253", -- [21]
			"17555:3838:3841:33253:4267:34378", -- [22]
			"17555:3838:3841:33253:4267:34378:35137", -- [23]
			"17555:3838:3841:33253:4267:34378:35136", -- [24]
			"17555:3838:3841:33253:4407:35138", -- [25]
			"17555:3838:3841:33253:4267:34378:6706:35481", -- [26]
			"17555:3838:3841:33253:4267:34378:6706:35478", -- [27]
			"17555:3838:3841:33253:4267:34378:6706:35556", -- [28]
			"17555:3838:3841:33253:4267:34378:6706:35562", -- [29]
			"17555:3838:3841:41383:15177:39175", -- [30]
			"17555:3838:3841:33253:4267:34378:39210", -- [31]
			"17555:3838:3841:33253:4267:34378:39210:39212", -- [32]
			"17555:3838:3841:33253:4267:34378:39210:39211", -- [33]
			"17555:3838:40552:40553", -- [34]
			"17555:3838:40552", -- [35]
			"17555:3838:3841:33253:4267:34378:39210:39211:40358:40768", -- [36]
			"17555:3838:3841:33253:4267:34378:39210:39211:40358:40768:7823:40827", -- [37]
			"17555:3838:3841:33253:4267:34378:39210:39211:40358:40768:7823:41214", -- [38]
			"17555:3838:3841:33253:4407:41240", -- [39]
			"17555:3838:3841:10897:41861:50084", -- [40]
			"17555:3838:3841:10897:41861:53783", -- [41]
			"17555:3838:3841:10897:41861", -- [42]
			"17555:3838:3841:33253:4267:34378:6706:35481:40966", -- [43]
			"17555:3838:3841:41383:41580", -- [44]
			"17555:3838:3841:12578:43073", -- [45]
			"17555:3838:3841:33253:43079", -- [46]
			"17555:3838:3841:10897:41861:50084:43549", -- [47]
			"17555:3838:3841:41383:15177:48274:48275", -- [48]
			"17555:3838:3841:41383:15177:48274", -- [49]
			"17555:3838:3841:41383:15177:48274:48273", -- [50]
			"17555:3838:3841:10897:41861:50084:54393", -- [51]
			["direct"] = "17555",
			["f"] = 0,
			["m"] = 464,
			["coord"] = 2131721733,
		},
		[40358] = {
			"39211:39210:34378:4267:33253:3841", -- [1]
			"39211:39210:34378:4267:33253:3841:3838", -- [2]
			"39211:39210:34378:4267", -- [3]
			"39211:39210:35136:4407", -- [4]
			"39211:39210:35136:6706", -- [5]
			"40768:7823", -- [6]
			"40367:41383", -- [7]
			"39211:39210:34378:4267:33253:3841:10897", -- [8]
			"39211:39210:34378:4267:22931:12578:11138", -- [9]
			"39211:39210:34378:4267:22931:12578", -- [10]
			"40768:7823:39175:15177", -- [11]
			"40768:7823:10583", -- [12]
			"4321:16227", -- [13]
			"39211:39210:34378:4267:33253:3841:3838:17555:17554", -- [14]
			"39211:39210:34378:4267:33253:3841:3838:17555", -- [15]
			"39211:39210:34378:4267:22931", -- [16]
			"39211:39210:34378:4267:22935", -- [17]
			"39211:39210:34378:4267:34374", -- [18]
			"39211:39210:34378:4267:33253", -- [19]
			"39211:39210:34378", -- [20]
			"39211:39210:35136:35137", -- [21]
			"39211:39210:35136", -- [22]
			"39211:39210:35136:6706:35138", -- [23]
			"40367:41383:40966:35481", -- [24]
			"39211:39210:35136:6706:35478", -- [25]
			"39211:39210:35136:6706:35556", -- [26]
			"39211:39210:35136:6706:35562", -- [27]
			"40768:7823:39175", -- [28]
			"39211:39210", -- [29]
			"4321:39212", -- [30]
			"39211:39210:34378:4267:33253:3841:3838:40552:40553", -- [31]
			"39211:39210:34378:4267:33253:3841:3838:40552", -- [32]
			"40768:7823:40827", -- [33]
			"40768:7823:41214", -- [34]
			"39211:39210:35136:35137:41240", -- [35]
			"39211:39210:34378:4267:22935:43549:50084", -- [36]
			"39211:39210:34378:4267:22935:43549:50084:53783", -- [37]
			"39211:39210:34378:4267:22935:43549:50084:41861", -- [38]
			"40367:41383:40966", -- [39]
			"40367:41580", -- [40]
			"39211:39210:34378:4267:22931:43073", -- [41]
			"39211:39210:34378:4267:22931:43079", -- [42]
			"39211:39210:34378:4267:22935:43549", -- [43]
			"39211:39210:34378:4267:33253:3841:3838:17555:43991", -- [44]
			"40768:7823:40827:48275", -- [45]
			"40768:7823:39175:15177:48274", -- [46]
			"40768:7823:40827:48275:48273", -- [47]
			"39211:39210:34378:4267:22935:43549:50084:54393", -- [48]
			["direct"] = "40367:4321:39211:40768",
			["f"] = 0,
			["m"] = 141,
			["coord"] = 1841543491,
		},
		[43549] = {
			"50084:41861:10897:3841", -- [1]
			"50084:41861:10897:3841:3838", -- [2]
			"22935:4267", -- [3]
			"22935:4267:34378:6706:35481:40966:41383:41580:40367", -- [4]
			"22935:4267:16227:4321", -- [5]
			"22935:4267:34378:4407", -- [6]
			"22935:4267:34378:6706", -- [7]
			"22935:4267:34378:39210:39211:40358:40768:7823", -- [8]
			"22935:4267:34378:6706:35481:40966:41383", -- [9]
			"50084:41861:10897", -- [10]
			"50084:41861:11138", -- [11]
			"22935:22931:12578", -- [12]
			"22935:4267:34378:6706:35481:40966:41383:15177", -- [13]
			"22935:4267:34378:39210:39211:40358:40768:7823:10583", -- [14]
			"22935:4267:16227", -- [15]
			"50084:41861:10897:3841:3838:17555:17554", -- [16]
			"50084:41861:10897:3841:3838:17555", -- [17]
			"22935:22931", -- [18]
			"22935:4267:34378:39210:39211:40358", -- [19]
			"22935:4267:34374", -- [20]
			"22935:22931:33253", -- [21]
			"22935:4267:34378", -- [22]
			"22935:4267:34378:35137", -- [23]
			"22935:4267:34378:35136", -- [24]
			"22935:4267:34378:6706:35138", -- [25]
			"22935:4267:34378:6706:35481", -- [26]
			"22935:4267:34378:6706:35478", -- [27]
			"22935:4267:34378:6706:35556", -- [28]
			"22935:4267:34378:6706:35562", -- [29]
			"22935:4267:34378:6706:35481:40966:41383:15177:39175", -- [30]
			"22935:4267:34378:39210", -- [31]
			"22935:4267:34378:39210:39212", -- [32]
			"22935:4267:34378:39210:39211", -- [33]
			"50084:41861:10897:3841:3838:40552:40553", -- [34]
			"50084:41861:10897:3841:3838:40552", -- [35]
			"22935:4267:34378:39210:39211:40358:40768", -- [36]
			"22935:4267:34378:39210:39211:40358:40768:7823:40827", -- [37]
			"22935:4267:34378:39210:39211:40358:40768:7823:41214", -- [38]
			"22935:4267:34378:35137:41240", -- [39]
			"50084:53783", -- [40]
			"50084:41861", -- [41]
			"22935:4267:34378:6706:35481:40966", -- [42]
			"22935:4267:34378:6706:35481:40966:41383:41580", -- [43]
			"22935:22931:43073", -- [44]
			"22935:22931:43079", -- [45]
			"50084:41861:10897:3841:3838:17555:43991", -- [46]
			"22935:4267:34378:6706:35481:40966:41383:15177:48274:48275", -- [47]
			"22935:4267:34378:6706:35481:40966:41383:15177:48274", -- [48]
			"22935:4267:34378:6706:35481:40966:41383:15177:48274:48273", -- [49]
			"50084:54393", -- [50]
			["direct"] = "22935:50084",
			["coord"] = 3072770348,
			["m"] = 606,
			["f"] = 0,
		},
		[15177] = {
			"41383:3841", -- [1]
			"41383:3841:3838", -- [2]
			"41383:6706:34378:4267", -- [3]
			"41383:41580:40367", -- [4]
			"39175:7823:4321", -- [5]
			"41383:35138:4407", -- [6]
			"41383:6706", -- [7]
			"41383:3841:10897", -- [8]
			"41383:6706:34378:4267:22931:12578:11138", -- [9]
			"41383:6706:34378:4267:22931:12578", -- [10]
			"39175:7823:16227", -- [11]
			"41383:3841:3838:17555:17554", -- [12]
			"41383:3841:3838:17555", -- [13]
			"41383:6706:34378:4267:22931", -- [14]
			"41383:6706:34378:4267:22935", -- [15]
			"39175:7823:40768:40358", -- [16]
			"41383:35138:4407:34374", -- [17]
			"41383:6706:34378:4267:33253", -- [18]
			"41383:6706:34378", -- [19]
			"41383:6706:35137", -- [20]
			"41383:6706:35136", -- [21]
			"41383:35138", -- [22]
			"41383:40966:35481", -- [23]
			"41383:40966:35481:35478", -- [24]
			"41383:40966:35481:35478:35556", -- [25]
			"41383:40966:35481:35562", -- [26]
			"41383:6706:35136:39210", -- [27]
			"39175:7823:4321:39212", -- [28]
			"39175:7823:40768:40358:39211", -- [29]
			"41383:3841:3838:40552:40553", -- [30]
			"41383:3841:3838:40552", -- [31]
			"39175:7823:40768", -- [32]
			"48274:48275:40827", -- [33]
			"39175:7823:41214", -- [34]
			"41383:35138:41240", -- [35]
			"41383:6706:34378:4267:22935:43549:50084", -- [36]
			"41383:6706:34378:4267:22935:43549:50084:53783", -- [37]
			"41383:6706:34378:4267:22935:43549:50084:41861", -- [38]
			"41383:40966", -- [39]
			"41383:41580", -- [40]
			"41383:6706:34378:4267:22931:43073", -- [41]
			"41383:6706:34378:4267:22931:43079", -- [42]
			"41383:6706:34378:4267:22935:43549", -- [43]
			"41383:3841:3838:17555:43991", -- [44]
			"48274:48275", -- [45]
			"48274:48273", -- [46]
			"41383:6706:34378:4267:22935:43549:50084:54393", -- [47]
			["direct"] = "7823:41383:10583:39175:48274",
			["f"] = 0,
			["m"] = 261,
			["coord"] = 2340246550,
		},
		[39211] = {
			"39210:34378:4267:33253:3841", -- [1]
			"39210:34378:4267:33253:3841:3838", -- [2]
			"39210:34378:4267", -- [3]
			"40358:40367", -- [4]
			"40358:4321", -- [5]
			"39210:35136:4407", -- [6]
			"39210:35136:6706", -- [7]
			"40358:40768:7823", -- [8]
			"40358:40367:41383", -- [9]
			"39210:34378:4267:33253:3841:10897", -- [10]
			"39210:34378:4267:22931:12578:11138", -- [11]
			"39210:34378:4267:22931:12578", -- [12]
			"40358:40768:7823:39175:15177", -- [13]
			"40358:40768:7823:10583", -- [14]
			"39212:16227", -- [15]
			"39210:34378:4267:33253:3841:3838:17555:17554", -- [16]
			"39210:34378:4267:33253:3841:3838:17555", -- [17]
			"39210:34378:4267:22931", -- [18]
			"39210:34378:4267:22935", -- [19]
			"39210:34378:4267:34374", -- [20]
			"39210:34378:4267:33253", -- [21]
			"39210:34378", -- [22]
			"39210:35136:35137", -- [23]
			"39210:35136", -- [24]
			"39210:35136:6706:35138", -- [25]
			"39210:35136:6706:35481", -- [26]
			"39210:35136:6706:35478", -- [27]
			"39210:35136:6706:35556", -- [28]
			"39210:35136:6706:35562", -- [29]
			"40358:40768:7823:39175", -- [30]
			"39210:34378:4267:33253:3841:3838:40552:40553", -- [31]
			"39210:34378:4267:33253:3841:3838:40552", -- [32]
			"40358:40768", -- [33]
			"40358:40768:7823:40827", -- [34]
			"40358:40768:7823:41214", -- [35]
			"39210:35136:35137:41240", -- [36]
			"39210:34378:4267:22935:43549:50084", -- [37]
			"39210:34378:4267:22935:43549:50084:53783", -- [38]
			"39210:34378:4267:22935:43549:50084:41861", -- [39]
			"40358:40367:41383:40966", -- [40]
			"40358:40367:41580", -- [41]
			"39210:34378:4267:22931:43073", -- [42]
			"39210:34378:4267:22931:43079", -- [43]
			"39210:34378:4267:22935:43549", -- [44]
			"39210:34378:4267:33253:3841:3838:17555:43991", -- [45]
			"40358:40768:7823:40827:48275", -- [46]
			"40358:40768:7823:39175:15177:48274", -- [47]
			"40358:40768:7823:40827:48275:48273", -- [48]
			"39210:34378:4267:22935:43549:50084:54393", -- [49]
			["direct"] = "40358:39210:39212",
			["f"] = 0,
			["m"] = 607,
			["coord"] = 2111810979,
		},
		[41861] = {
			"10897:3841", -- [1]
			"10897:3841:3838", -- [2]
			"50084:43549:22935:4267", -- [3]
			"50084:43549:22935:4267:34378:6706:35481:40966:41383:41580:40367", -- [4]
			"50084:43549:22935:4267:16227:4321", -- [5]
			"50084:43549:22935:4267:34378:4407", -- [6]
			"50084:43549:22935:4267:34378:6706", -- [7]
			"50084:43549:22935:4267:34378:39210:39211:40358:40768:7823", -- [8]
			"50084:43549:22935:4267:34378:6706:35481:40966:41383", -- [9]
			"10897:12578", -- [10]
			"50084:43549:22935:4267:34378:6706:35481:40966:41383:15177", -- [11]
			"50084:43549:22935:4267:34378:39210:39211:40358:40768:7823:10583", -- [12]
			"50084:43549:22935:4267:16227", -- [13]
			"10897:3841:3838:17555:17554", -- [14]
			"10897:3841:3838:17555", -- [15]
			"50084:43549:22935:22931", -- [16]
			"50084:43549:22935", -- [17]
			"50084:43549:22935:4267:34378:39210:39211:40358", -- [18]
			"10897:3841:33253:34374", -- [19]
			"10897:3841:33253", -- [20]
			"50084:43549:22935:4267:34378", -- [21]
			"50084:43549:22935:4267:34378:35137", -- [22]
			"50084:43549:22935:4267:34378:35136", -- [23]
			"50084:43549:22935:4267:34378:6706:35138", -- [24]
			"50084:43549:22935:4267:34378:6706:35481", -- [25]
			"50084:43549:22935:4267:34378:6706:35478", -- [26]
			"50084:43549:22935:4267:34378:6706:35556", -- [27]
			"50084:43549:22935:4267:34378:6706:35562", -- [28]
			"50084:43549:22935:4267:34378:6706:35481:40966:41383:15177:39175", -- [29]
			"50084:43549:22935:4267:34378:39210", -- [30]
			"50084:43549:22935:4267:34378:39210:39212", -- [31]
			"50084:43549:22935:4267:34378:39210:39211", -- [32]
			"10897:3841:3838:40552:40553", -- [33]
			"10897:3841:3838:40552", -- [34]
			"50084:43549:22935:4267:34378:39210:39211:40358:40768", -- [35]
			"50084:43549:22935:4267:34378:39210:39211:40358:40768:7823:40827", -- [36]
			"50084:43549:22935:4267:34378:39210:39211:40358:40768:7823:41214", -- [37]
			"50084:43549:22935:4267:34378:35137:41240", -- [38]
			"50084:43549:22935:4267:34378:6706:35481:40966", -- [39]
			"50084:43549:22935:4267:34378:6706:35481:40966:41383:41580", -- [40]
			"10897:12578:43073", -- [41]
			"10897:12578:43073:43079", -- [42]
			"50084:43549", -- [43]
			"10897:3841:3838:17555:43991", -- [44]
			"50084:43549:22935:4267:34378:6706:35481:40966:41383:15177:48274:48275", -- [45]
			"50084:43549:22935:4267:34378:6706:35481:40966:41383:15177:48274", -- [46]
			"50084:43549:22935:4267:34378:6706:35481:40966:41383:15177:48274:48273", -- [47]
			"50084:54393", -- [48]
			["direct"] = "10897:11138:50084:53783",
			["coord"] = 2671195984,
			["m"] = 606,
			["f"] = 0,
		},
		[4267] = {
			"33253:3841:3838", -- [1]
			"34378:6706:35481:40966:41383:41580:40367", -- [2]
			"34378:6706", -- [3]
			"34378:39210:39211:40358:40768:7823", -- [4]
			"34378:6706:35481:40966:41383", -- [5]
			"33253:3841:10897", -- [6]
			"22931:12578:11138", -- [7]
			"22931:12578", -- [8]
			"34378:6706:35481:40966:41383:15177", -- [9]
			"34378:39210:39211:40358:40768:7823:10583", -- [10]
			"33253:3841:3838:17555:17554", -- [11]
			"33253:3841:3838:17555", -- [12]
			"34378:39210:39211:40358", -- [13]
			"34378:35137", -- [14]
			"34378:35136", -- [15]
			"34378:6706:35138", -- [16]
			"34378:6706:35481", -- [17]
			"34378:6706:35478", -- [18]
			"34378:6706:35556", -- [19]
			"34378:6706:35562", -- [20]
			"34378:6706:35481:40966:41383:15177:39175", -- [21]
			"34378:39210", -- [22]
			"34378:39210:39212", -- [23]
			"34378:39210:39211", -- [24]
			"33253:3841:3838:40552:40553", -- [25]
			"33253:3841:3838:40552", -- [26]
			"34378:39210:39211:40358:40768", -- [27]
			"34378:39210:39211:40358:40768:7823:40827", -- [28]
			"34378:39210:39211:40358:40768:7823:41214", -- [29]
			"34378:35137:41240", -- [30]
			"22935:43549:50084", -- [31]
			"22935:43549:50084:53783", -- [32]
			"22935:43549:50084:41861", -- [33]
			"34378:6706:35481:40966", -- [34]
			"34378:6706:35481:40966:41383:41580", -- [35]
			"22931:43073", -- [36]
			"22931:43079", -- [37]
			"22935:43549", -- [38]
			"33253:3841:3838:17555:43991", -- [39]
			"34378:6706:35481:40966:41383:15177:48274:48275", -- [40]
			"34378:6706:35481:40966:41383:15177:48274", -- [41]
			"34378:6706:35481:40966:41383:15177:48274:48273", -- [42]
			"22935:43549:50084:54393", -- [43]
			["direct"] = "3841:4321:4407:16227:22931:22935:34374:33253:34378",
			["f"] = 0,
			["m"] = 43,
			["coord"] = 1479899854,
		},
		[35481] = {
			"4407:3841", -- [1]
			"4407:3841:3838", -- [2]
			"6706:34378:4267", -- [3]
			"40966:41383:41580:40367", -- [4]
			"40966:41383:41580:40367:40358:4321", -- [5]
			"40966:41383:15177:39175:7823", -- [6]
			"4407:3841:10897", -- [7]
			"6706:34378:4267:22931:12578:11138", -- [8]
			"6706:34378:4267:22931:12578", -- [9]
			"40966:41383:15177", -- [10]
			"40966:41383:15177:39175:10583", -- [11]
			"6706:35136:39210:16227", -- [12]
			"4407:3841:3838:17555:17554", -- [13]
			"4407:3841:3838:17555", -- [14]
			"6706:34378:4267:22931", -- [15]
			"6706:34378:4267:22935", -- [16]
			"40966:41383:41580:40367:40358", -- [17]
			"4407:34374", -- [18]
			"4407:33253", -- [19]
			"6706:34378", -- [20]
			"6706:35137", -- [21]
			"6706:35136", -- [22]
			"6706:35138", -- [23]
			"35478:35556", -- [24]
			"40966:41383:15177:39175", -- [25]
			"6706:35136:39210", -- [26]
			"6706:35136:39210:39212", -- [27]
			"6706:35136:39210:39211", -- [28]
			"4407:3841:3838:40552:40553", -- [29]
			"4407:3841:3838:40552", -- [30]
			"40966:41383:41580:40367:40768", -- [31]
			"40966:41383:15177:48274:48275:40827", -- [32]
			"40966:41383:15177:39175:7823:41214", -- [33]
			"4407:41240", -- [34]
			"6706:34378:4267:22935:43549:50084", -- [35]
			"6706:34378:4267:22935:43549:50084:53783", -- [36]
			"6706:34378:4267:22935:43549:50084:41861", -- [37]
			"40966:41383:41580", -- [38]
			"6706:34378:4267:22931:43073", -- [39]
			"6706:34378:4267:22931:43079", -- [40]
			"6706:34378:4267:22935:43549", -- [41]
			"4407:3841:3838:17555:43991", -- [42]
			"40966:41383:15177:48274:48275", -- [43]
			"40966:41383:15177:48274", -- [44]
			"40966:41383:15177:48274:48273", -- [45]
			"6706:34378:4267:22935:43549:50084:54393", -- [46]
			["direct"] = "4407:6706:41383:35478:35562:40966",
			["f"] = 0,
			["m"] = 101,
			["coord"] = 1581823822,
		},
		[35556] = {
			"6706:34378:4267:33253:3841", -- [1]
			"6706:34378:4267:33253:3841:3838", -- [2]
			"6706:34378:4267", -- [3]
			"35478:35481:40966:41383:41580:40367", -- [4]
			"6706:35136:39210:39212:4321", -- [5]
			"6706:4407", -- [6]
			"6706:35136:39210:39211:40358:40768:7823", -- [7]
			"35478:35481:40966:41383", -- [8]
			"6706:34378:4267:33253:3841:10897", -- [9]
			"6706:34378:4267:22931:12578:11138", -- [10]
			"6706:34378:4267:22931:12578", -- [11]
			"35478:35481:40966:41383:15177", -- [12]
			"35478:35481:40966:41383:15177:39175:10583", -- [13]
			"6706:35136:39210:16227", -- [14]
			"6706:34378:4267:33253:3841:3838:17555:17554", -- [15]
			"6706:34378:4267:33253:3841:3838:17555", -- [16]
			"6706:34378:4267:22931", -- [17]
			"6706:34378:4267:22935", -- [18]
			"6706:35136:39210:39211:40358", -- [19]
			"6706:34378:4267:34374", -- [20]
			"6706:34378:4267:33253", -- [21]
			"6706:34378", -- [22]
			"6706:35137", -- [23]
			"6706:35136", -- [24]
			"6706:35138", -- [25]
			"35478:35481", -- [26]
			"35478:35481:40966:41383:15177:39175", -- [27]
			"6706:35136:39210", -- [28]
			"6706:35136:39210:39212", -- [29]
			"6706:35136:39210:39211", -- [30]
			"6706:34378:4267:33253:3841:3838:40552:40553", -- [31]
			"6706:34378:4267:33253:3841:3838:40552", -- [32]
			"6706:35136:39210:39211:40358:40768", -- [33]
			"6706:35136:39210:39211:40358:40768:7823:40827", -- [34]
			"6706:35136:39210:39211:40358:40768:7823:41214", -- [35]
			"6706:35138:41240", -- [36]
			"6706:34378:4267:22935:43549:50084", -- [37]
			"6706:34378:4267:22935:43549:50084:53783", -- [38]
			"6706:34378:4267:22935:43549:50084:41861", -- [39]
			"35478:35481:40966", -- [40]
			"35478:35481:40966:41383:41580", -- [41]
			"6706:34378:4267:22931:43073", -- [42]
			"6706:34378:4267:22931:43079", -- [43]
			"6706:34378:4267:22935:43549", -- [44]
			"6706:34378:4267:33253:3841:3838:17555:43991", -- [45]
			"35478:35481:40966:41383:15177:48274:48275", -- [46]
			"35478:35481:40966:41383:15177:48274", -- [47]
			"35478:35481:40966:41383:15177:48274:48273", -- [48]
			"6706:34378:4267:22935:43549:50084:54393", -- [49]
			["direct"] = "6706:35478:35562",
			["f"] = 0,
			["m"] = 101,
			["coord"] = 3034731573,
		},
		[53783] = {
			"41861:10897:3841", -- [1]
			"41861:10897:3841:3838", -- [2]
			"50084:43549:22935:4267", -- [3]
			"50084:43549:22935:4267:34378:6706:35481:40966:41383:41580:40367", -- [4]
			"50084:43549:22935:4267:16227:4321", -- [5]
			"50084:43549:22935:4267:34378:4407", -- [6]
			"50084:43549:22935:4267:34378:6706", -- [7]
			"50084:43549:22935:4267:34378:39210:39211:40358:40768:7823", -- [8]
			"50084:43549:22935:4267:34378:6706:35481:40966:41383", -- [9]
			"41861:10897", -- [10]
			"41861:11138", -- [11]
			"41861:10897:12578", -- [12]
			"50084:43549:22935:4267:34378:6706:35481:40966:41383:15177", -- [13]
			"50084:43549:22935:4267:34378:39210:39211:40358:40768:7823:10583", -- [14]
			"50084:43549:22935:4267:16227", -- [15]
			"41861:10897:3841:3838:17555:17554", -- [16]
			"41861:10897:3841:3838:17555", -- [17]
			"50084:43549:22935:22931", -- [18]
			"50084:43549:22935", -- [19]
			"50084:43549:22935:4267:34378:39210:39211:40358", -- [20]
			"50084:43549:22935:4267:34374", -- [21]
			"50084:43549:22935:22931:33253", -- [22]
			"50084:43549:22935:4267:34378", -- [23]
			"50084:43549:22935:4267:34378:35137", -- [24]
			"50084:43549:22935:4267:34378:35136", -- [25]
			"50084:43549:22935:4267:34378:6706:35138", -- [26]
			"50084:43549:22935:4267:34378:6706:35481", -- [27]
			"50084:43549:22935:4267:34378:6706:35478", -- [28]
			"50084:43549:22935:4267:34378:6706:35556", -- [29]
			"50084:43549:22935:4267:34378:6706:35562", -- [30]
			"50084:43549:22935:4267:34378:6706:35481:40966:41383:15177:39175", -- [31]
			"50084:43549:22935:4267:34378:39210", -- [32]
			"50084:43549:22935:4267:34378:39210:39212", -- [33]
			"50084:43549:22935:4267:34378:39210:39211", -- [34]
			"41861:10897:3841:3838:40552:40553", -- [35]
			"41861:10897:3841:3838:40552", -- [36]
			"50084:43549:22935:4267:34378:39210:39211:40358:40768", -- [37]
			"50084:43549:22935:4267:34378:39210:39211:40358:40768:7823:40827", -- [38]
			"50084:43549:22935:4267:34378:39210:39211:40358:40768:7823:41214", -- [39]
			"50084:43549:22935:4267:34378:35137:41240", -- [40]
			"50084:43549:22935:4267:34378:6706:35481:40966", -- [41]
			"50084:43549:22935:4267:34378:6706:35481:40966:41383:41580", -- [42]
			"41861:10897:12578:43073", -- [43]
			"50084:43549:22935:22931:43079", -- [44]
			"50084:43549", -- [45]
			"41861:10897:3841:3838:17555:43991", -- [46]
			"50084:43549:22935:4267:34378:6706:35481:40966:41383:15177:48274:48275", -- [47]
			"50084:43549:22935:4267:34378:6706:35481:40966:41383:15177:48274", -- [48]
			"50084:43549:22935:4267:34378:6706:35481:40966:41383:15177:48274:48273", -- [49]
			"50084:54393", -- [50]
			["direct"] = "50084:41861",
			["coord"] = 841047383,
			["m"] = 606,
			["f"] = 0,
		},
		[34374] = {
			"33253:3841", -- [1]
			"33253:3841:3838", -- [2]
			"4267:34378:6706:35481:40966:41383:41580:40367", -- [3]
			"4267:16227:4321", -- [4]
			"4267:34378:6706", -- [5]
			"4267:34378:39210:39211:40358:40768:7823", -- [6]
			"4267:34378:6706:35481:40966:41383", -- [7]
			"33253:3841:10897", -- [8]
			"33253:12578:11138", -- [9]
			"33253:12578", -- [10]
			"4267:34378:6706:35481:40966:41383:15177", -- [11]
			"4267:34378:39210:39211:40358:40768:7823:10583", -- [12]
			"4267:16227", -- [13]
			"33253:3841:3838:17555:17554", -- [14]
			"33253:3841:3838:17555", -- [15]
			"4267:22935", -- [16]
			"4267:34378:39210:39211:40358", -- [17]
			"4267:34378", -- [18]
			"4267:34378:35137", -- [19]
			"4267:34378:35136", -- [20]
			"4407:35138", -- [21]
			"4267:34378:6706:35481", -- [22]
			"4267:34378:6706:35478", -- [23]
			"4267:34378:6706:35556", -- [24]
			"4267:34378:6706:35562", -- [25]
			"4267:34378:6706:35481:40966:41383:15177:39175", -- [26]
			"4267:34378:39210", -- [27]
			"4267:34378:39210:39212", -- [28]
			"4267:34378:39210:39211", -- [29]
			"33253:3841:3838:40552:40553", -- [30]
			"33253:3841:3838:40552", -- [31]
			"4267:34378:39210:39211:40358:40768", -- [32]
			"4267:34378:39210:39211:40358:40768:7823:40827", -- [33]
			"4267:34378:39210:39211:40358:40768:7823:41214", -- [34]
			"4407:41240", -- [35]
			"4267:22935:43549:50084", -- [36]
			"4267:22935:43549:50084:53783", -- [37]
			"33253:3841:10897:41861", -- [38]
			"4267:34378:6706:35481:40966", -- [39]
			"4267:34378:6706:35481:40966:41383:41580", -- [40]
			"33253:43079:43073", -- [41]
			"33253:43079", -- [42]
			"4267:22935:43549", -- [43]
			"33253:3841:3838:17555:43991", -- [44]
			"4267:34378:6706:35481:40966:41383:15177:48274:48275", -- [45]
			"4267:34378:6706:35481:40966:41383:15177:48274", -- [46]
			"4267:34378:6706:35481:40966:41383:15177:48274:48273", -- [47]
			"4267:22935:43549:50084:54393", -- [48]
			["direct"] = "4267:4407:22931:33253",
			["f"] = 0,
			["m"] = 43,
			["coord"] = 778908870,
		},
		[10897] = {
			"3841:3838", -- [1]
			"3841:33253:4267", -- [2]
			"3841:41383:41580:40367", -- [3]
			"3841:33253:4267:16227:4321", -- [4]
			"3841:33253:4407", -- [5]
			"3841:33253:4267:34378:6706", -- [6]
			"3841:33253:4267:34378:39210:39211:40358:40768:7823", -- [7]
			"3841:41383", -- [8]
			"3841:41383:15177", -- [9]
			"3841:33253:4267:34378:39210:39211:40358:40768:7823:10583", -- [10]
			"3841:33253:4267:16227", -- [11]
			"3841:3838:17555:17554", -- [12]
			"3841:3838:17555", -- [13]
			"12578:22931", -- [14]
			"12578:22931:22935", -- [15]
			"3841:33253:4267:34378:39210:39211:40358", -- [16]
			"3841:33253:34374", -- [17]
			"3841:33253", -- [18]
			"3841:33253:4267:34378", -- [19]
			"3841:33253:4267:34378:35137", -- [20]
			"3841:33253:4267:34378:35136", -- [21]
			"3841:33253:4407:35138", -- [22]
			"3841:33253:4267:34378:6706:35481", -- [23]
			"3841:33253:4267:34378:6706:35478", -- [24]
			"3841:33253:4267:34378:6706:35556", -- [25]
			"3841:33253:4267:34378:6706:35562", -- [26]
			"3841:41383:15177:39175", -- [27]
			"3841:33253:4267:34378:39210", -- [28]
			"3841:33253:4267:34378:39210:39212", -- [29]
			"3841:33253:4267:34378:39210:39211", -- [30]
			"3841:3838:40552:40553", -- [31]
			"3841:3838:40552", -- [32]
			"3841:33253:4267:34378:39210:39211:40358:40768", -- [33]
			"3841:33253:4267:34378:39210:39211:40358:40768:7823:40827", -- [34]
			"3841:33253:4267:34378:39210:39211:40358:40768:7823:41214", -- [35]
			"3841:33253:4407:41240", -- [36]
			"41861:50084", -- [37]
			"41861:53783", -- [38]
			"3841:33253:4267:34378:6706:35481:40966", -- [39]
			"3841:41383:41580", -- [40]
			"12578:43073", -- [41]
			"12578:43073:43079", -- [42]
			"41861:50084:43549", -- [43]
			"3841:3838:17555:43991", -- [44]
			"3841:41383:15177:48274:48275", -- [45]
			"3841:41383:15177:48274", -- [46]
			"3841:41383:15177:48274:48273", -- [47]
			"41861:50084:54393", -- [48]
			["direct"] = "3841:11138:12578:41861",
			["coord"] = 2059906089,
			["m"] = 241,
			["f"] = 0,
		},
		[35478] = {
			"4407:3841", -- [1]
			"4407:3841:3838", -- [2]
			"6706:34378:4267", -- [3]
			"35481:40966:41383:41580:40367", -- [4]
			"6706:35136:39210:39212:4321", -- [5]
			"35481:40966:41383:15177:39175:7823", -- [6]
			"35481:40966:41383", -- [7]
			"4407:3841:10897", -- [8]
			"6706:34378:4267:22931:12578:11138", -- [9]
			"6706:34378:4267:22931:12578", -- [10]
			"35481:40966:41383:15177", -- [11]
			"35481:40966:41383:15177:39175:10583", -- [12]
			"6706:35136:39210:16227", -- [13]
			"4407:3841:3838:17555:17554", -- [14]
			"4407:3841:3838:17555", -- [15]
			"6706:34378:4267:22931", -- [16]
			"6706:34378:4267:22935", -- [17]
			"6706:35136:39210:39211:40358", -- [18]
			"4407:34374", -- [19]
			"6706:34378:4267:33253", -- [20]
			"6706:34378", -- [21]
			"6706:35137", -- [22]
			"6706:35136", -- [23]
			"6706:35138", -- [24]
			"35481:40966:41383:15177:39175", -- [25]
			"6706:35136:39210", -- [26]
			"6706:35136:39210:39212", -- [27]
			"6706:35136:39210:39211", -- [28]
			"4407:3841:3838:40552:40553", -- [29]
			"4407:3841:3838:40552", -- [30]
			"6706:35136:39210:39211:40358:40768", -- [31]
			"35481:40966:41383:15177:48274:48275:40827", -- [32]
			"35481:40966:41383:15177:39175:7823:41214", -- [33]
			"6706:35138:41240", -- [34]
			"6706:34378:4267:22935:43549:50084", -- [35]
			"6706:34378:4267:22935:43549:50084:53783", -- [36]
			"6706:34378:4267:22935:43549:50084:41861", -- [37]
			"35481:40966", -- [38]
			"35481:40966:41383:41580", -- [39]
			"6706:34378:4267:22931:43073", -- [40]
			"6706:34378:4267:22931:43079", -- [41]
			"6706:34378:4267:22935:43549", -- [42]
			"4407:3841:3838:17555:43991", -- [43]
			"35481:40966:41383:15177:48274:48275", -- [44]
			"35481:40966:41383:15177:48274", -- [45]
			"35481:40966:41383:15177:48274:48273", -- [46]
			"6706:34378:4267:22935:43549:50084:54393", -- [47]
			["direct"] = "4407:6706:35481:35556:35562",
			["f"] = 0,
			["m"] = 101,
			["coord"] = 2479390535,
		},
		[34378] = {
			"4267:33253:3841", -- [1]
			"4267:33253:3841:3838", -- [2]
			"6706:35481:40966:41383:41580:40367", -- [3]
			"39210:39212:4321", -- [4]
			"39210:39211:40358:40768:7823", -- [5]
			"6706:35481:40966:41383", -- [6]
			"4267:33253:3841:10897", -- [7]
			"4267:22931:12578:11138", -- [8]
			"4267:22931:12578", -- [9]
			"6706:35481:40966:41383:15177", -- [10]
			"39210:39211:40358:40768:7823:10583", -- [11]
			"39210:16227", -- [12]
			"4267:33253:3841:3838:17555:17554", -- [13]
			"4267:33253:3841:3838:17555", -- [14]
			"4267:22931", -- [15]
			"4267:22935", -- [16]
			"39210:39211:40358", -- [17]
			"4267:34374", -- [18]
			"4267:33253", -- [19]
			"6706:35138", -- [20]
			"6706:35481", -- [21]
			"6706:35478", -- [22]
			"6706:35556", -- [23]
			"6706:35562", -- [24]
			"6706:35481:40966:41383:15177:39175", -- [25]
			"39210:39212", -- [26]
			"39210:39211", -- [27]
			"4267:33253:3841:3838:40552:40553", -- [28]
			"4267:33253:3841:3838:40552", -- [29]
			"39210:39211:40358:40768", -- [30]
			"39210:39211:40358:40768:7823:40827", -- [31]
			"39210:39211:40358:40768:7823:41214", -- [32]
			"35137:41240", -- [33]
			"4267:22935:43549:50084", -- [34]
			"4267:22935:43549:50084:53783", -- [35]
			"4267:22935:43549:50084:41861", -- [36]
			"6706:35481:40966", -- [37]
			"6706:35481:40966:41383:41580", -- [38]
			"4267:22931:43073", -- [39]
			"4267:22931:43079", -- [40]
			"4267:22935:43549", -- [41]
			"4267:33253:3841:3838:17555:43991", -- [42]
			"6706:35481:40966:41383:15177:48274:48275", -- [43]
			"6706:35481:40966:41383:15177:48274", -- [44]
			"6706:35481:40966:41383:15177:48274:48273", -- [45]
			"4267:22935:43549:50084:54393", -- [46]
			["direct"] = "4267:4407:6706:35137:35136:39210",
			["f"] = 0,
			["m"] = 43,
			["coord"] = 1505998935,
		},
		[35136] = {
			"34378:4267:33253:3841", -- [1]
			"34378:4267:33253:3841:3838", -- [2]
			"34378:4267", -- [3]
			"6706:35481:40966:41383:41580:40367", -- [4]
			"39210:39212:4321", -- [5]
			"39210:39211:40358:40768:7823", -- [6]
			"6706:35481:40966:41383", -- [7]
			"34378:4267:33253:3841:10897", -- [8]
			"34378:4267:22931:12578:11138", -- [9]
			"34378:4267:22931:12578", -- [10]
			"6706:35481:40966:41383:15177", -- [11]
			"39210:39211:40358:40768:7823:10583", -- [12]
			"39210:16227", -- [13]
			"34378:4267:33253:3841:3838:17555:17554", -- [14]
			"34378:4267:33253:3841:3838:17555", -- [15]
			"34378:4267:22931", -- [16]
			"34378:4267:22935", -- [17]
			"39210:39211:40358", -- [18]
			"34378:4267:34374", -- [19]
			"34378:4267:33253", -- [20]
			"6706:35481", -- [21]
			"6706:35478", -- [22]
			"6706:35556", -- [23]
			"6706:35562", -- [24]
			"39210:39211:40358:40768:7823:39175", -- [25]
			"39210:39212", -- [26]
			"39210:39211", -- [27]
			"34378:4267:33253:3841:3838:40552:40553", -- [28]
			"34378:4267:33253:3841:3838:40552", -- [29]
			"39210:39211:40358:40768", -- [30]
			"39210:39211:40358:40768:7823:40827", -- [31]
			"39210:39211:40358:40768:7823:41214", -- [32]
			"35137:41240", -- [33]
			"34378:4267:22935:43549:50084", -- [34]
			"34378:4267:22935:43549:50084:53783", -- [35]
			"34378:4267:22935:43549:50084:41861", -- [36]
			"6706:35481:40966", -- [37]
			"6706:35481:40966:41383:41580", -- [38]
			"34378:4267:22931:43073", -- [39]
			"34378:4267:22931:43079", -- [40]
			"34378:4267:22935:43549", -- [41]
			"34378:4267:33253:3841:3838:17555:43991", -- [42]
			"39210:39211:40358:40768:7823:40827:48275", -- [43]
			"6706:35481:40966:41383:15177:48274", -- [44]
			"6706:35481:40966:41383:15177:48274:48273", -- [45]
			"34378:4267:22935:43549:50084:54393", -- [46]
			["direct"] = "4407:6706:34378:35137:35138:39210",
			["f"] = 0,
			["m"] = 81,
			["coord"] = 3045379603,
		},
		[35138] = {
			"4407:3841", -- [1]
			"4407:3841:3838", -- [2]
			"41240:35137:34378:4267", -- [3]
			"41383:41580:40367", -- [4]
			"35136:39210:39212:4321", -- [5]
			"35136:39210:39211:40358:40768:7823", -- [6]
			"4407:3841:10897", -- [7]
			"4407:33253:12578:11138", -- [8]
			"4407:33253:12578", -- [9]
			"41383:15177", -- [10]
			"41383:15177:39175:10583", -- [11]
			"35136:39210:16227", -- [12]
			"4407:3841:3838:17555:17554", -- [13]
			"4407:3841:3838:17555", -- [14]
			"41240:35137:34378:4267:22931", -- [15]
			"41240:35137:34378:4267:22935", -- [16]
			"35136:39210:39211:40358", -- [17]
			"4407:34374", -- [18]
			"4407:33253", -- [19]
			"41240:35137:34378", -- [20]
			"6706:35481", -- [21]
			"6706:35478", -- [22]
			"6706:35556", -- [23]
			"6706:35562", -- [24]
			"41383:15177:39175", -- [25]
			"35136:39210", -- [26]
			"35136:39210:39212", -- [27]
			"35136:39210:39211", -- [28]
			"4407:3841:3838:40552:40553", -- [29]
			"4407:3841:3838:40552", -- [30]
			"35136:39210:39211:40358:40768", -- [31]
			"35136:39210:39211:40358:40768:7823:40827", -- [32]
			"35136:39210:39211:40358:40768:7823:41214", -- [33]
			"41240:35137:34378:4267:22935:43549:50084", -- [34]
			"41240:35137:34378:4267:22935:43549:50084:53783", -- [35]
			"41240:35137:34378:4267:22935:43549:50084:41861", -- [36]
			"6706:35481:40966", -- [37]
			"41383:41580", -- [38]
			"41240:35137:34378:4267:22931:43073", -- [39]
			"4407:33253:43079", -- [40]
			"41240:35137:34378:4267:22935:43549", -- [41]
			"4407:3841:3838:17555:43991", -- [42]
			"41383:15177:48274:48275", -- [43]
			"41383:15177:48274", -- [44]
			"41383:15177:48274:48273", -- [45]
			"41240:35137:34378:4267:22935:43549:50084:54393", -- [46]
			["direct"] = "4407:6706:41383:35137:35136:41240",
			["f"] = 0,
			["m"] = 81,
			["coord"] = 1375116843,
		},
		[48274] = {
			"15177:41383:3841", -- [1]
			"15177:41383:3841:3838", -- [2]
			"15177:41383:6706:34378:4267", -- [3]
			"15177:41383:41580:40367", -- [4]
			"15177:39175:7823:4321", -- [5]
			"15177:41383:35138:4407", -- [6]
			"15177:41383:6706", -- [7]
			"15177:39175:7823", -- [8]
			"15177:41383", -- [9]
			"15177:41383:3841:10897", -- [10]
			"15177:41383:6706:34378:4267:22931:12578:11138", -- [11]
			"15177:41383:6706:34378:4267:22931:12578", -- [12]
			"15177:39175:10583", -- [13]
			"15177:39175:7823:16227", -- [14]
			"15177:41383:3841:3838:17555:17554", -- [15]
			"15177:41383:3841:3838:17555", -- [16]
			"15177:41383:6706:34378:4267:22931", -- [17]
			"15177:41383:6706:34378:4267:22935", -- [18]
			"15177:39175:7823:40768:40358", -- [19]
			"15177:41383:35138:4407:34374", -- [20]
			"15177:41383:6706:34378:4267:33253", -- [21]
			"15177:41383:6706:34378", -- [22]
			"15177:41383:6706:35137", -- [23]
			"15177:41383:6706:35136", -- [24]
			"15177:41383:35138", -- [25]
			"15177:41383:40966:35481", -- [26]
			"15177:41383:40966:35481:35478", -- [27]
			"15177:41383:40966:35481:35478:35556", -- [28]
			"15177:41383:40966:35481:35562", -- [29]
			"15177:39175", -- [30]
			"15177:41383:6706:35136:39210", -- [31]
			"15177:39175:7823:4321:39212", -- [32]
			"15177:39175:7823:40768:40358:39211", -- [33]
			"15177:41383:3841:3838:40552:40553", -- [34]
			"15177:41383:3841:3838:40552", -- [35]
			"15177:39175:7823:40768", -- [36]
			"48275:40827", -- [37]
			"48275:40827:41214", -- [38]
			"15177:41383:35138:41240", -- [39]
			"15177:41383:6706:34378:4267:22935:43549:50084", -- [40]
			"15177:41383:6706:34378:4267:22935:43549:50084:53783", -- [41]
			"15177:41383:6706:34378:4267:22935:43549:50084:41861", -- [42]
			"15177:41383:40966", -- [43]
			"15177:41383:41580", -- [44]
			"15177:41383:6706:34378:4267:22931:43073", -- [45]
			"15177:41383:6706:34378:4267:22931:43079", -- [46]
			"15177:41383:6706:34378:4267:22935:43549", -- [47]
			"15177:41383:3841:3838:17555:43991", -- [48]
			"15177:41383:6706:34378:4267:22935:43549:50084:54393", -- [49]
			["direct"] = "15177:48275:48273",
			["f"] = 0,
			["m"] = 720,
			["coord"] = 1144395128,
		},
		[40367] = {
			"41383:3841", -- [1]
			"41383:3841:3838", -- [2]
			"41383:6706:34378:4267", -- [3]
			"41383:35138:4407", -- [4]
			"41383:6706", -- [5]
			"41383:3841:10897", -- [6]
			"41383:6706:34378:4267:22931:12578:11138", -- [7]
			"41383:6706:34378:4267:22931:12578", -- [8]
			"41383:15177", -- [9]
			"41383:15177:39175:10583", -- [10]
			"40358:4321:16227", -- [11]
			"41383:3841:3838:17555:17554", -- [12]
			"41383:3841:3838:17555", -- [13]
			"41383:6706:34378:4267:22931", -- [14]
			"41383:6706:34378:4267:22935", -- [15]
			"41383:35138:4407:34374", -- [16]
			"41383:6706:34378:4267:33253", -- [17]
			"41383:6706:34378", -- [18]
			"41383:6706:35137", -- [19]
			"41383:6706:35136", -- [20]
			"41383:35138", -- [21]
			"41383:40966:35481", -- [22]
			"41383:40966:35481:35478", -- [23]
			"41383:40966:35481:35478:35556", -- [24]
			"41383:40966:35481:35562", -- [25]
			"41383:15177:39175", -- [26]
			"40358:39211:39210", -- [27]
			"40358:4321:39212", -- [28]
			"40358:39211", -- [29]
			"41383:3841:3838:40552:40553", -- [30]
			"41383:3841:3838:40552", -- [31]
			"7823:40827", -- [32]
			"7823:41214", -- [33]
			"41383:35138:41240", -- [34]
			"41383:6706:34378:4267:22935:43549:50084", -- [35]
			"41383:6706:34378:4267:22935:43549:50084:53783", -- [36]
			"41383:6706:34378:4267:22935:43549:50084:41861", -- [37]
			"41383:40966", -- [38]
			"41383:6706:34378:4267:22931:43073", -- [39]
			"41383:6706:34378:4267:22931:43079", -- [40]
			"41383:6706:34378:4267:22935:43549", -- [41]
			"41383:3841:3838:17555:43991", -- [42]
			"41383:15177:48274:48275", -- [43]
			"41383:15177:48274", -- [44]
			"41383:15177:48274:48273", -- [45]
			"41383:6706:34378:4267:22935:43549:50084:54393", -- [46]
			["direct"] = "4321:7823:41383:40358:40768:41580",
			["f"] = 0,
			["m"] = 121,
			["coord"] = 3317141842,
		},
		[22931] = {
			"33253:3841", -- [1]
			"33253:3841:3838", -- [2]
			"4267:34378:6706:35481:40966:41383:41580:40367", -- [3]
			"4267:16227:4321", -- [4]
			"4267:34378:4407", -- [5]
			"4267:34378:6706", -- [6]
			"4267:34378:39210:39211:40358:40768:7823", -- [7]
			"4267:34378:6706:35481:40966:41383", -- [8]
			"12578:10897", -- [9]
			"12578:11138", -- [10]
			"4267:34378:6706:35481:40966:41383:15177", -- [11]
			"4267:34378:39210:39211:40358:40768:7823:10583", -- [12]
			"4267:16227", -- [13]
			"33253:3841:3838:17555:17554", -- [14]
			"33253:3841:3838:17555", -- [15]
			"4267:34378:39210:39211:40358", -- [16]
			"4267:34378", -- [17]
			"4267:34378:35137", -- [18]
			"4267:34378:35136", -- [19]
			"4267:34378:6706:35138", -- [20]
			"4267:34378:6706:35481", -- [21]
			"4267:34378:6706:35478", -- [22]
			"4267:34378:6706:35556", -- [23]
			"4267:34378:6706:35562", -- [24]
			"4267:34378:6706:35481:40966:41383:15177:39175", -- [25]
			"4267:34378:39210", -- [26]
			"4267:34378:39210:39212", -- [27]
			"4267:34378:39210:39211", -- [28]
			"33253:3841:3838:40552:40553", -- [29]
			"33253:3841:3838:40552", -- [30]
			"4267:34378:39210:39211:40358:40768", -- [31]
			"4267:34378:39210:39211:40358:40768:7823:40827", -- [32]
			"4267:34378:39210:39211:40358:40768:7823:41214", -- [33]
			"4267:34378:35137:41240", -- [34]
			"22935:43549:50084", -- [35]
			"22935:43549:50084:53783", -- [36]
			"22935:43549:50084:41861", -- [37]
			"4267:34378:6706:35481:40966", -- [38]
			"4267:34378:6706:35481:40966:41383:41580", -- [39]
			"22935:43549", -- [40]
			"33253:3841:3838:17555:43991", -- [41]
			"4267:34378:6706:35481:40966:41383:15177:48274:48275", -- [42]
			"4267:34378:6706:35481:40966:41383:15177:48274", -- [43]
			"4267:34378:6706:35481:40966:41383:15177:48274:48273", -- [44]
			"22935:43549:50084:54393", -- [45]
			["direct"] = "4267:12578:22935:34374:33253:43073:43079",
			["coord"] = 2212089544,
			["m"] = 182,
			["f"] = 0,
		},
		[41383] = {
			"3841:3838", -- [1]
			"6706:34378:4267", -- [2]
			"41580:40367:40358:4321", -- [3]
			"35138:4407", -- [4]
			"15177:39175:7823", -- [5]
			"3841:10897", -- [6]
			"6706:34378:4267:22931:12578:11138", -- [7]
			"6706:34378:4267:22931:12578", -- [8]
			"15177:39175:10583", -- [9]
			"41580:40367:40358:4321:16227", -- [10]
			"3841:3838:17555:17554", -- [11]
			"3841:3838:17555", -- [12]
			"6706:34378:4267:22931", -- [13]
			"6706:34378:4267:22935", -- [14]
			"41580:40367:40358", -- [15]
			"35138:4407:34374", -- [16]
			"6706:34378:4267:33253", -- [17]
			"6706:34378", -- [18]
			"6706:35137", -- [19]
			"6706:35136", -- [20]
			"40966:35481:35478", -- [21]
			"40966:35481:35478:35556", -- [22]
			"40966:35481:35562", -- [23]
			"15177:39175", -- [24]
			"6706:35136:39210", -- [25]
			"41580:40367:40358:4321:39212", -- [26]
			"41580:40367:40358:39211", -- [27]
			"3841:3838:40552:40553", -- [28]
			"3841:3838:40552", -- [29]
			"41580:40367:40768", -- [30]
			"15177:48274:48275:40827", -- [31]
			"15177:39175:7823:41214", -- [32]
			"35138:41240", -- [33]
			"6706:34378:4267:22935:43549:50084", -- [34]
			"6706:34378:4267:22935:43549:50084:53783", -- [35]
			"6706:34378:4267:22935:43549:50084:41861", -- [36]
			"6706:34378:4267:22931:43073", -- [37]
			"6706:34378:4267:22931:43079", -- [38]
			"6706:34378:4267:22935:43549", -- [39]
			"3841:3838:17555:43991", -- [40]
			"15177:48274:48275", -- [41]
			"15177:48274", -- [42]
			"15177:48274:48273", -- [43]
			"6706:34378:4267:22935:43549:50084:54393", -- [44]
			["direct"] = "3841:40367:6706:15177:35138:35481:40966:41580",
			["f"] = 0,
			["m"] = 121,
			["coord"] = 2010280972,
		},
		[50084] = {
			"41861:10897:3841", -- [1]
			"41861:10897:3841:3838", -- [2]
			"43549:22935:4267", -- [3]
			"43549:22935:4267:34378:6706:35481:40966:41383:41580:40367", -- [4]
			"43549:22935:4267:16227:4321", -- [5]
			"43549:22935:4267:34378:4407", -- [6]
			"43549:22935:4267:34378:6706", -- [7]
			"43549:22935:4267:34378:39210:39211:40358:40768:7823", -- [8]
			"43549:22935:4267:34378:6706:35481:40966:41383", -- [9]
			"41861:10897", -- [10]
			"41861:11138", -- [11]
			"41861:10897:12578", -- [12]
			"43549:22935:4267:34378:6706:35481:40966:41383:15177", -- [13]
			"43549:22935:4267:34378:39210:39211:40358:40768:7823:10583", -- [14]
			"43549:22935:4267:16227", -- [15]
			"41861:10897:3841:3838:17555:17554", -- [16]
			"41861:10897:3841:3838:17555", -- [17]
			"43549:22935:22931", -- [18]
			"43549:22935", -- [19]
			"43549:22935:4267:34378:39210:39211:40358", -- [20]
			"43549:22935:4267:34374", -- [21]
			"43549:22935:22931:33253", -- [22]
			"43549:22935:4267:34378", -- [23]
			"43549:22935:4267:34378:35137", -- [24]
			"43549:22935:4267:34378:35136", -- [25]
			"43549:22935:4267:34378:6706:35138", -- [26]
			"43549:22935:4267:34378:6706:35481", -- [27]
			"43549:22935:4267:34378:6706:35478", -- [28]
			"43549:22935:4267:34378:6706:35556", -- [29]
			"43549:22935:4267:34378:6706:35562", -- [30]
			"43549:22935:4267:34378:6706:35481:40966:41383:15177:39175", -- [31]
			"43549:22935:4267:34378:39210", -- [32]
			"43549:22935:4267:34378:39210:39212", -- [33]
			"43549:22935:4267:34378:39210:39211", -- [34]
			"41861:10897:3841:3838:40552:40553", -- [35]
			"41861:10897:3841:3838:40552", -- [36]
			"43549:22935:4267:34378:39210:39211:40358:40768", -- [37]
			"43549:22935:4267:34378:39210:39211:40358:40768:7823:40827", -- [38]
			"43549:22935:4267:34378:39210:39211:40358:40768:7823:41214", -- [39]
			"43549:22935:4267:34378:35137:41240", -- [40]
			"43549:22935:4267:34378:6706:35481:40966", -- [41]
			"43549:22935:4267:34378:6706:35481:40966:41383:41580", -- [42]
			"41861:10897:12578:43073", -- [43]
			"43549:22935:22931:43079", -- [44]
			"41861:10897:3841:3838:17555:43991", -- [45]
			"43549:22935:4267:34378:6706:35481:40966:41383:15177:48274:48275", -- [46]
			"43549:22935:4267:34378:6706:35481:40966:41383:15177:48274", -- [47]
			"43549:22935:4267:34378:6706:35481:40966:41383:15177:48274:48273", -- [48]
			["direct"] = "53783:41861:43549:54393",
			["coord"] = 1767206201,
			["m"] = 606,
			["f"] = 0,
		},
		[17555] = {
			"3838:3841", -- [1]
			"3838:3841:33253:4267", -- [2]
			"3838:3841:41383:41580:40367", -- [3]
			"3838:3841:33253:4267:16227:4321", -- [4]
			"3838:3841:33253:4407", -- [5]
			"3838:3841:33253:4267:34378:6706", -- [6]
			"3838:3841:33253:4267:34378:39210:39211:40358:40768:7823", -- [7]
			"3838:3841:41383", -- [8]
			"3838:3841:10897", -- [9]
			"3838:3841:12578:11138", -- [10]
			"3838:3841:12578", -- [11]
			"3838:3841:41383:15177", -- [12]
			"3838:3841:33253:4267:34378:39210:39211:40358:40768:7823:10583", -- [13]
			"3838:3841:33253:4267:16227", -- [14]
			"3838:3841:33253:22931", -- [15]
			"3838:3841:33253:22931:22935", -- [16]
			"3838:3841:33253:4267:34378:39210:39211:40358", -- [17]
			"3838:3841:33253:34374", -- [18]
			"3838:3841:33253", -- [19]
			"3838:3841:33253:4267:34378", -- [20]
			"3838:3841:33253:4267:34378:35137", -- [21]
			"3838:3841:33253:4267:34378:35136", -- [22]
			"3838:3841:33253:4407:35138", -- [23]
			"3838:3841:33253:4267:34378:6706:35481", -- [24]
			"3838:3841:33253:4267:34378:6706:35478", -- [25]
			"3838:3841:33253:4267:34378:6706:35556", -- [26]
			"3838:3841:33253:4267:34378:6706:35562", -- [27]
			"3838:3841:41383:15177:39175", -- [28]
			"3838:3841:33253:4267:34378:39210", -- [29]
			"3838:3841:33253:4267:34378:39210:39212", -- [30]
			"3838:3841:33253:4267:34378:39210:39211", -- [31]
			"3838:40552:40553", -- [32]
			"3838:40552", -- [33]
			"3838:3841:33253:4267:34378:39210:39211:40358:40768", -- [34]
			"3838:3841:33253:4267:34378:39210:39211:40358:40768:7823:40827", -- [35]
			"3838:3841:33253:4267:34378:39210:39211:40358:40768:7823:41214", -- [36]
			"3838:3841:33253:4407:41240", -- [37]
			"3838:3841:10897:41861:50084", -- [38]
			"3838:3841:10897:41861:53783", -- [39]
			"3838:3841:10897:41861", -- [40]
			"3838:3841:33253:4267:34378:6706:35481:40966", -- [41]
			"3838:3841:41383:41580", -- [42]
			"3838:3841:12578:43073", -- [43]
			"3838:3841:33253:43079", -- [44]
			"3838:3841:10897:41861:50084:43549", -- [45]
			"3838:3841:41383:15177:48274:48275", -- [46]
			"3838:3841:41383:15177:48274", -- [47]
			"3838:3841:41383:15177:48274:48273", -- [48]
			"3838:3841:10897:41861:50084:54393", -- [49]
			["direct"] = "3838:17554:43991",
			["f"] = 0,
			["m"] = 471,
			["coord"] = 2335858094,
		},
		[22935] = {
			"22931:33253:3841", -- [1]
			"22931:33253:3841:3838", -- [2]
			"4267:34378:6706:35481:40966:41383:41580:40367", -- [3]
			"4267:16227:4321", -- [4]
			"4267:34378:4407", -- [5]
			"4267:34378:6706", -- [6]
			"4267:34378:39210:39211:40358:40768:7823", -- [7]
			"4267:34378:6706:35481:40966:41383", -- [8]
			"22931:12578:10897", -- [9]
			"43549:50084:41861:11138", -- [10]
			"22931:12578", -- [11]
			"4267:34378:6706:35481:40966:41383:15177", -- [12]
			"4267:34378:39210:39211:40358:40768:7823:10583", -- [13]
			"4267:16227", -- [14]
			"22931:33253:3841:3838:17555:17554", -- [15]
			"22931:33253:3841:3838:17555", -- [16]
			"4267:34378:39210:39211:40358", -- [17]
			"4267:34374", -- [18]
			"22931:33253", -- [19]
			"4267:34378", -- [20]
			"4267:34378:35137", -- [21]
			"4267:34378:35136", -- [22]
			"4267:34378:6706:35138", -- [23]
			"4267:34378:6706:35481", -- [24]
			"4267:34378:6706:35478", -- [25]
			"4267:34378:6706:35556", -- [26]
			"4267:34378:6706:35562", -- [27]
			"4267:34378:6706:35481:40966:41383:15177:39175", -- [28]
			"4267:34378:39210", -- [29]
			"4267:34378:39210:39212", -- [30]
			"4267:34378:39210:39211", -- [31]
			"22931:33253:3841:3838:40552:40553", -- [32]
			"22931:33253:3841:3838:40552", -- [33]
			"4267:34378:39210:39211:40358:40768", -- [34]
			"4267:34378:39210:39211:40358:40768:7823:40827", -- [35]
			"4267:34378:39210:39211:40358:40768:7823:41214", -- [36]
			"4267:34378:35137:41240", -- [37]
			"43549:50084", -- [38]
			"43549:50084:53783", -- [39]
			"43549:50084:41861", -- [40]
			"4267:34378:6706:35481:40966", -- [41]
			"4267:34378:6706:35481:40966:41383:41580", -- [42]
			"22931:43073", -- [43]
			"22931:43079", -- [44]
			"22931:33253:3841:3838:17555:43991", -- [45]
			"4267:34378:6706:35481:40966:41383:15177:48274:48275", -- [46]
			"4267:34378:6706:35481:40966:41383:15177:48274", -- [47]
			"4267:34378:6706:35481:40966:41383:15177:48274:48273", -- [48]
			"43549:50084:54393", -- [49]
			["direct"] = "4267:22931:43549",
			["coord"] = 3651301222,
			["m"] = 43,
			["f"] = 0,
		},
		[41580] = {
			"41383:3841", -- [1]
			"41383:3841:3838", -- [2]
			"41383:6706:34378:4267", -- [3]
			"40367:40358:4321", -- [4]
			"41383:35138:4407", -- [5]
			"41383:6706", -- [6]
			"40367:7823", -- [7]
			"41383:3841:10897", -- [8]
			"41383:6706:34378:4267:22931:12578:11138", -- [9]
			"41383:6706:34378:4267:22931:12578", -- [10]
			"41383:15177", -- [11]
			"41383:15177:39175:10583", -- [12]
			"40367:40358:4321:16227", -- [13]
			"41383:3841:3838:17555:17554", -- [14]
			"41383:3841:3838:17555", -- [15]
			"41383:6706:34378:4267:22931", -- [16]
			"41383:6706:34378:4267:22935", -- [17]
			"40367:40358", -- [18]
			"41383:35138:4407:34374", -- [19]
			"41383:6706:34378:4267:33253", -- [20]
			"41383:6706:34378", -- [21]
			"41383:6706:35137", -- [22]
			"41383:6706:35136", -- [23]
			"41383:35138", -- [24]
			"41383:40966:35481", -- [25]
			"41383:40966:35481:35478", -- [26]
			"41383:40966:35481:35478:35556", -- [27]
			"41383:40966:35481:35562", -- [28]
			"41383:15177:39175", -- [29]
			"41383:6706:35136:39210", -- [30]
			"40367:40358:4321:39212", -- [31]
			"40367:40358:39211", -- [32]
			"41383:3841:3838:40552:40553", -- [33]
			"41383:3841:3838:40552", -- [34]
			"40367:40768", -- [35]
			"40367:7823:40827", -- [36]
			"40367:7823:41214", -- [37]
			"41383:35138:41240", -- [38]
			"41383:6706:34378:4267:22935:43549:50084", -- [39]
			"41383:6706:34378:4267:22935:43549:50084:53783", -- [40]
			"41383:6706:34378:4267:22935:43549:50084:41861", -- [41]
			"41383:40966", -- [42]
			"41383:6706:34378:4267:22931:43073", -- [43]
			"41383:6706:34378:4267:22931:43079", -- [44]
			"41383:6706:34378:4267:22935:43549", -- [45]
			"41383:3841:3838:17555:43991", -- [46]
			"41383:15177:48274:48275", -- [47]
			"41383:15177:48274", -- [48]
			"41383:15177:48274:48273", -- [49]
			"41383:6706:34378:4267:22935:43549:50084:54393", -- [50]
			["direct"] = "40367:41383",
			["f"] = 0,
			["m"] = 121,
			["coord"] = 2449377782,
		},
		[16227] = {
			"4267:33253:3841", -- [1]
			"4267:33253:3841:3838", -- [2]
			"4321:40367", -- [3]
			"39210:35136:4407", -- [4]
			"39210:35136:6706", -- [5]
			"4321:40367:41383", -- [6]
			"4267:33253:3841:10897", -- [7]
			"4267:22931:12578:11138", -- [8]
			"4267:22931:12578", -- [9]
			"7823:39175:15177", -- [10]
			"7823:10583", -- [11]
			"4267:33253:3841:3838:17555:17554", -- [12]
			"4267:33253:3841:3838:17555", -- [13]
			"4267:22931", -- [14]
			"4267:22935", -- [15]
			"4321:40358", -- [16]
			"4267:34374", -- [17]
			"4267:33253", -- [18]
			"39210:34378", -- [19]
			"39210:35136:35137", -- [20]
			"39210:35136", -- [21]
			"39210:35136:6706:35138", -- [22]
			"39210:35136:6706:35481", -- [23]
			"39210:35136:6706:35478", -- [24]
			"39210:35136:6706:35556", -- [25]
			"39210:35136:6706:35562", -- [26]
			"7823:39175", -- [27]
			"39212:39211", -- [28]
			"4267:33253:3841:3838:40552:40553", -- [29]
			"4267:33253:3841:3838:40552", -- [30]
			"4321:40358:40768", -- [31]
			"7823:40827", -- [32]
			"7823:41214", -- [33]
			"39210:35136:35137:41240", -- [34]
			"4267:22935:43549:50084", -- [35]
			"4267:22935:43549:50084:53783", -- [36]
			"4267:22935:43549:50084:41861", -- [37]
			"39210:35136:6706:35481:40966", -- [38]
			"4321:40367:41580", -- [39]
			"4267:22931:43073", -- [40]
			"4267:22931:43079", -- [41]
			"4267:22935:43549", -- [42]
			"4267:33253:3841:3838:17555:43991", -- [43]
			"7823:40827:48275", -- [44]
			"7823:39175:15177:48274", -- [45]
			"7823:40827:48275:48273", -- [46]
			"4267:22935:43549:50084:54393", -- [47]
			["direct"] = "4267:4321:7823:39210:39212",
			["f"] = 0,
			["m"] = 11,
			["coord"] = 2971382974,
		},
		[40552] = {
			"3838:3841", -- [1]
			"3838:3841:33253:4267", -- [2]
			"3838:3841:41383:41580:40367", -- [3]
			"3838:3841:33253:4267:16227:4321", -- [4]
			"3838:3841:33253:4407", -- [5]
			"3838:3841:33253:4267:34378:6706", -- [6]
			"3838:3841:33253:4267:34378:39210:39211:40358:40768:7823", -- [7]
			"3838:3841:41383", -- [8]
			"3838:3841:10897", -- [9]
			"3838:3841:12578:11138", -- [10]
			"3838:3841:12578", -- [11]
			"3838:3841:41383:15177", -- [12]
			"3838:3841:33253:4267:34378:39210:39211:40358:40768:7823:10583", -- [13]
			"3838:3841:33253:4267:16227", -- [14]
			"3838:17555:17554", -- [15]
			"3838:17555", -- [16]
			"3838:3841:33253:22931", -- [17]
			"3838:3841:33253:22931:22935", -- [18]
			"3838:3841:33253:4267:34378:39210:39211:40358", -- [19]
			"3838:3841:33253:34374", -- [20]
			"3838:3841:33253", -- [21]
			"3838:3841:33253:4267:34378", -- [22]
			"3838:3841:33253:4267:34378:35137", -- [23]
			"3838:3841:33253:4267:34378:35136", -- [24]
			"3838:3841:33253:4407:35138", -- [25]
			"3838:3841:33253:4267:34378:6706:35481", -- [26]
			"3838:3841:33253:4267:34378:6706:35478", -- [27]
			"3838:3841:33253:4267:34378:6706:35556", -- [28]
			"3838:3841:33253:4267:34378:6706:35562", -- [29]
			"3838:3841:41383:15177:39175", -- [30]
			"3838:3841:33253:4267:34378:39210", -- [31]
			"3838:3841:33253:4267:34378:39210:39212", -- [32]
			"3838:3841:33253:4267:34378:39210:39211", -- [33]
			"3838:3841:33253:4267:34378:39210:39211:40358:40768", -- [34]
			"3838:3841:33253:4267:34378:39210:39211:40358:40768:7823:40827", -- [35]
			"3838:3841:33253:4267:34378:39210:39211:40358:40768:7823:41214", -- [36]
			"3838:3841:33253:4407:41240", -- [37]
			"3838:3841:10897:41861:50084", -- [38]
			"3838:3841:10897:41861:53783", -- [39]
			"3838:3841:10897:41861", -- [40]
			"3838:3841:33253:4267:34378:6706:35481:40966", -- [41]
			"3838:3841:41383:41580", -- [42]
			"3838:3841:12578:43073", -- [43]
			"3838:3841:33253:43079", -- [44]
			"3838:3841:10897:41861:50084:43549", -- [45]
			"3838:17555:43991", -- [46]
			"3838:3841:41383:15177:48274:48275", -- [47]
			"3838:3841:41383:15177:48274", -- [48]
			"3838:3841:41383:15177:48274:48273", -- [49]
			"3838:3841:10897:41861:50084:54393", -- [50]
			["direct"] = "3838:40553",
			["f"] = 0,
			["m"] = 381,
			["coord"] = 1577352082,
		},
		[10583] = {
			"7823:40768:40358:39211:39210:34378:4267:33253:3841", -- [1]
			"7823:40768:40358:39211:39210:34378:4267:33253:3841:3838", -- [2]
			"7823:40768:40358:39211:39210:34378:4267", -- [3]
			"7823:40367", -- [4]
			"7823:4321", -- [5]
			"39175:15177:41383:35138:4407", -- [6]
			"39175:15177:41383:6706", -- [7]
			"39175:15177:41383", -- [8]
			"7823:40768:40358:39211:39210:34378:4267:33253:3841:10897", -- [9]
			"7823:40768:40358:39211:39210:34378:4267:22931:12578:11138", -- [10]
			"7823:40768:40358:39211:39210:34378:4267:22931:12578", -- [11]
			"7823:16227", -- [12]
			"7823:40768:40358:39211:39210:34378:4267:33253:3841:3838:17555:17554", -- [13]
			"7823:40768:40358:39211:39210:34378:4267:33253:3841:3838:17555", -- [14]
			"7823:40768:40358:39211:39210:34378:4267:22931", -- [15]
			"7823:40768:40358:39211:39210:34378:4267:22935", -- [16]
			"7823:40768:40358", -- [17]
			"7823:40768:40358:39211:39210:34378:4267:34374", -- [18]
			"7823:40768:40358:39211:39210:34378:4267:33253", -- [19]
			"7823:40768:40358:39211:39210:34378", -- [20]
			"7823:40768:40358:39211:39210:35136:35137", -- [21]
			"7823:40768:40358:39211:39210:35136", -- [22]
			"39175:15177:41383:35138", -- [23]
			"39175:15177:41383:40966:35481", -- [24]
			"39175:15177:41383:40966:35481:35478", -- [25]
			"39175:15177:41383:40966:35481:35478:35556", -- [26]
			"39175:15177:41383:40966:35481:35562", -- [27]
			"7823:40768:40358:39211:39210", -- [28]
			"7823:4321:39212", -- [29]
			"7823:40768:40358:39211", -- [30]
			"7823:40768:40358:39211:39210:34378:4267:33253:3841:3838:40552:40553", -- [31]
			"7823:40768:40358:39211:39210:34378:4267:33253:3841:3838:40552", -- [32]
			"7823:40768", -- [33]
			"7823:40827", -- [34]
			"7823:41214", -- [35]
			"39175:15177:41383:35138:41240", -- [36]
			"7823:40768:40358:39211:39210:34378:4267:22935:43549:50084", -- [37]
			"7823:40768:40358:39211:39210:34378:4267:22935:43549:50084:53783", -- [38]
			"7823:40768:40358:39211:39210:34378:4267:22935:43549:50084:41861", -- [39]
			"39175:15177:41383:40966", -- [40]
			"39175:15177:41383:41580", -- [41]
			"7823:40768:40358:39211:39210:34378:4267:22931:43073", -- [42]
			"7823:40768:40358:39211:39210:34378:4267:22931:43079", -- [43]
			"7823:40768:40358:39211:39210:34378:4267:22935:43549", -- [44]
			"7823:40768:40358:39211:39210:34378:4267:33253:3841:3838:17555:43991", -- [45]
			"39175:15177:48274:48275", -- [46]
			"39175:15177:48274", -- [47]
			"39175:15177:48274:48273", -- [48]
			"7823:40768:40358:39211:39210:34378:4267:22935:43549:50084:54393", -- [49]
			["direct"] = "7823:15177:39175",
			["f"] = 0,
			["m"] = 201,
			["coord"] = 2406196287,
		},
		[48275] = {
			"48274:15177:41383:3841", -- [1]
			"48274:15177:41383:3841:3838", -- [2]
			"40827:7823:40768:40358:39211:39210:34378:4267", -- [3]
			"48274:15177:41383:41580:40367", -- [4]
			"40827:7823:4321", -- [5]
			"48274:15177:41383:35138:4407", -- [6]
			"48274:15177:41383:6706", -- [7]
			"40827:7823", -- [8]
			"48274:15177:41383", -- [9]
			"48274:15177:41383:3841:10897", -- [10]
			"40827:7823:40768:40358:39211:39210:34378:4267:22931:12578:11138", -- [11]
			"40827:7823:40768:40358:39211:39210:34378:4267:22931:12578", -- [12]
			"48274:15177", -- [13]
			"48274:15177:39175:10583", -- [14]
			"40827:7823:16227", -- [15]
			"48274:15177:41383:3841:3838:17555:17554", -- [16]
			"48274:15177:41383:3841:3838:17555", -- [17]
			"40827:7823:40768:40358:39211:39210:34378:4267:22931", -- [18]
			"40827:7823:40768:40358:39211:39210:34378:4267:22935", -- [19]
			"40827:7823:40768:40358", -- [20]
			"48274:15177:41383:35138:4407:34374", -- [21]
			"40827:7823:40768:40358:39211:39210:34378:4267:33253", -- [22]
			"40827:7823:40768:40358:39211:39210:34378", -- [23]
			"48274:15177:41383:6706:35137", -- [24]
			"40827:7823:40768:40358:39211:39210:35136", -- [25]
			"48274:15177:41383:35138", -- [26]
			"48274:15177:41383:40966:35481", -- [27]
			"48274:15177:41383:40966:35481:35478", -- [28]
			"48274:15177:41383:40966:35481:35478:35556", -- [29]
			"48274:15177:41383:40966:35481:35562", -- [30]
			"48274:15177:39175", -- [31]
			"40827:7823:40768:40358:39211:39210", -- [32]
			"40827:7823:4321:39212", -- [33]
			"40827:7823:40768:40358:39211", -- [34]
			"48274:15177:41383:3841:3838:40552:40553", -- [35]
			"48274:15177:41383:3841:3838:40552", -- [36]
			"40827:7823:40768", -- [37]
			"40827:41214", -- [38]
			"48274:15177:41383:35138:41240", -- [39]
			"40827:7823:40768:40358:39211:39210:34378:4267:22935:43549:50084", -- [40]
			"40827:7823:40768:40358:39211:39210:34378:4267:22935:43549:50084:53783", -- [41]
			"40827:7823:40768:40358:39211:39210:34378:4267:22935:43549:50084:41861", -- [42]
			"48274:15177:41383:40966", -- [43]
			"48274:15177:41383:41580", -- [44]
			"40827:7823:40768:40358:39211:39210:34378:4267:22931:43073", -- [45]
			"40827:7823:40768:40358:39211:39210:34378:4267:22931:43079", -- [46]
			"40827:7823:40768:40358:39211:39210:34378:4267:22935:43549", -- [47]
			"48274:15177:41383:3841:3838:17555:43991", -- [48]
			"40827:7823:40768:40358:39211:39210:34378:4267:22935:43549:50084:54393", -- [49]
			["direct"] = "40827:48274:48273",
			["f"] = 0,
			["m"] = 720,
			["coord"] = 2416334315,
		},
		[39175] = {
			"15177:41383:3841", -- [1]
			"15177:41383:3841:3838", -- [2]
			"7823:40768:40358:39211:39210:34378:4267", -- [3]
			"15177:41383:41580:40367", -- [4]
			"7823:4321", -- [5]
			"15177:41383:35138:4407", -- [6]
			"15177:41383:6706", -- [7]
			"15177:41383", -- [8]
			"15177:41383:3841:10897", -- [9]
			"7823:40768:40358:39211:39210:34378:4267:22931:12578:11138", -- [10]
			"7823:40768:40358:39211:39210:34378:4267:22931:12578", -- [11]
			"7823:16227", -- [12]
			"15177:41383:3841:3838:17555:17554", -- [13]
			"15177:41383:3841:3838:17555", -- [14]
			"7823:40768:40358:39211:39210:34378:4267:22931", -- [15]
			"7823:40768:40358:39211:39210:34378:4267:22935", -- [16]
			"7823:40768:40358", -- [17]
			"15177:41383:35138:4407:34374", -- [18]
			"7823:40768:40358:39211:39210:34378:4267:33253", -- [19]
			"7823:40768:40358:39211:39210:34378", -- [20]
			"15177:41383:6706:35137", -- [21]
			"7823:40768:40358:39211:39210:35136", -- [22]
			"15177:41383:35138", -- [23]
			"15177:41383:40966:35481", -- [24]
			"15177:41383:40966:35481:35478", -- [25]
			"15177:41383:40966:35481:35478:35556", -- [26]
			"15177:41383:40966:35481:35562", -- [27]
			"7823:40768:40358:39211:39210", -- [28]
			"7823:4321:39212", -- [29]
			"7823:40768:40358:39211", -- [30]
			"15177:41383:3841:3838:40552:40553", -- [31]
			"15177:41383:3841:3838:40552", -- [32]
			"7823:40768", -- [33]
			"7823:40827", -- [34]
			"7823:41214", -- [35]
			"15177:41383:35138:41240", -- [36]
			"7823:40768:40358:39211:39210:34378:4267:22935:43549:50084", -- [37]
			"7823:40768:40358:39211:39210:34378:4267:22935:43549:50084:53783", -- [38]
			"7823:40768:40358:39211:39210:34378:4267:22935:43549:50084:41861", -- [39]
			"15177:41383:40966", -- [40]
			"15177:41383:41580", -- [41]
			"7823:40768:40358:39211:39210:34378:4267:22931:43073", -- [42]
			"7823:40768:40358:39211:39210:34378:4267:22931:43079", -- [43]
			"7823:40768:40358:39211:39210:34378:4267:22935:43549", -- [44]
			"15177:41383:3841:3838:17555:43991", -- [45]
			"15177:48274:48275", -- [46]
			"15177:48274", -- [47]
			"15177:48274:48273", -- [48]
			"7823:40768:40358:39211:39210:34378:4267:22935:43549:50084:54393", -- [49]
			["direct"] = "7823:15177:10583",
			["f"] = 0,
			["m"] = 201,
			["coord"] = 1890412270,
		},
		[41214] = {
			"7823:40768:40358:39211:39210:34378:4267:33253:3841", -- [1]
			"7823:40768:40358:39211:39210:34378:4267:33253:3841:3838", -- [2]
			"7823:40768:40358:39211:39210:34378:4267", -- [3]
			"7823:40367", -- [4]
			"7823:4321", -- [5]
			"7823:40768:40358:39211:39210:35136:4407", -- [6]
			"7823:40768:40358:39211:39210:35136:6706", -- [7]
			"7823:40367:41383", -- [8]
			"7823:40768:40358:39211:39210:34378:4267:33253:3841:10897", -- [9]
			"7823:40768:40358:39211:39210:34378:4267:22931:12578:11138", -- [10]
			"7823:40768:40358:39211:39210:34378:4267:22931:12578", -- [11]
			"7823:39175:15177", -- [12]
			"7823:10583", -- [13]
			"7823:16227", -- [14]
			"7823:40768:40358:39211:39210:34378:4267:33253:3841:3838:17555:17554", -- [15]
			"7823:40768:40358:39211:39210:34378:4267:33253:3841:3838:17555", -- [16]
			"7823:40768:40358:39211:39210:34378:4267:22931", -- [17]
			"7823:40768:40358:39211:39210:34378:4267:22935", -- [18]
			"7823:40768:40358", -- [19]
			"7823:40768:40358:39211:39210:34378:4267:34374", -- [20]
			"7823:40768:40358:39211:39210:34378:4267:33253", -- [21]
			"7823:40768:40358:39211:39210:34378", -- [22]
			"7823:40768:40358:39211:39210:35136:35137", -- [23]
			"7823:40768:40358:39211:39210:35136", -- [24]
			"7823:40768:40358:39211:39210:35136:6706:35138", -- [25]
			"7823:40367:41383:40966:35481", -- [26]
			"7823:40768:40358:39211:39210:35136:6706:35478", -- [27]
			"7823:40768:40358:39211:39210:35136:6706:35556", -- [28]
			"7823:40768:40358:39211:39210:35136:6706:35562", -- [29]
			"7823:39175", -- [30]
			"7823:40768:40358:39211:39210", -- [31]
			"7823:4321:39212", -- [32]
			"7823:40768:40358:39211", -- [33]
			"7823:40768:40358:39211:39210:34378:4267:33253:3841:3838:40552:40553", -- [34]
			"7823:40768:40358:39211:39210:34378:4267:33253:3841:3838:40552", -- [35]
			"7823:40768", -- [36]
			"7823:40768:40358:39211:39210:35136:35137:41240", -- [37]
			"7823:40768:40358:39211:39210:34378:4267:22935:43549:50084", -- [38]
			"7823:40768:40358:39211:39210:34378:4267:22935:43549:50084:53783", -- [39]
			"7823:40768:40358:39211:39210:34378:4267:22935:43549:50084:41861", -- [40]
			"7823:40367:41383:40966", -- [41]
			"7823:40367:41580", -- [42]
			"7823:40768:40358:39211:39210:34378:4267:22931:43073", -- [43]
			"7823:40768:40358:39211:39210:34378:4267:22931:43079", -- [44]
			"7823:40768:40358:39211:39210:34378:4267:22935:43549", -- [45]
			"7823:40768:40358:39211:39210:34378:4267:33253:3841:3838:17555:43991", -- [46]
			"40827:48275", -- [47]
			"40827:48275:48274", -- [48]
			"40827:48275:48273", -- [49]
			"7823:40768:40358:39211:39210:34378:4267:22935:43549:50084:54393", -- [50]
			["direct"] = "7823:40827",
			["f"] = 0,
			["m"] = 161,
			["coord"] = 2397215501,
		},
		[3838] = {
			"3841:33253:4267", -- [1]
			"3841:41383:41580:40367", -- [2]
			"3841:33253:4267:16227:4321", -- [3]
			"3841:33253:4407", -- [4]
			"3841:33253:4267:34378:6706", -- [5]
			"3841:33253:4267:34378:39210:39211:40358:40768:7823", -- [6]
			"3841:41383", -- [7]
			"3841:10897", -- [8]
			"3841:12578:11138", -- [9]
			"3841:12578", -- [10]
			"3841:41383:15177", -- [11]
			"3841:33253:4267:34378:39210:39211:40358:40768:7823:10583", -- [12]
			"3841:33253:4267:16227", -- [13]
			"17555:17554", -- [14]
			"3841:33253:22931", -- [15]
			"3841:33253:22931:22935", -- [16]
			"3841:33253:4267:34378:39210:39211:40358", -- [17]
			"3841:33253:34374", -- [18]
			"3841:33253", -- [19]
			"3841:33253:4267:34378", -- [20]
			"3841:33253:4267:34378:35137", -- [21]
			"3841:33253:4267:34378:35136", -- [22]
			"3841:33253:4407:35138", -- [23]
			"3841:33253:4267:34378:6706:35481", -- [24]
			"3841:33253:4267:34378:6706:35478", -- [25]
			"3841:33253:4267:34378:6706:35556", -- [26]
			"3841:33253:4267:34378:6706:35562", -- [27]
			"3841:41383:15177:39175", -- [28]
			"3841:33253:4267:34378:39210", -- [29]
			"3841:33253:4267:34378:39210:39212", -- [30]
			"3841:33253:4267:34378:39210:39211", -- [31]
			"40552:40553", -- [32]
			"3841:33253:4267:34378:39210:39211:40358:40768", -- [33]
			"3841:33253:4267:34378:39210:39211:40358:40768:7823:40827", -- [34]
			"3841:33253:4267:34378:39210:39211:40358:40768:7823:41214", -- [35]
			"3841:33253:4407:41240", -- [36]
			"3841:10897:41861:50084", -- [37]
			"3841:10897:41861:53783", -- [38]
			"3841:10897:41861", -- [39]
			"3841:33253:4267:34378:6706:35481:40966", -- [40]
			"3841:41383:41580", -- [41]
			"3841:12578:43073", -- [42]
			"3841:33253:43079", -- [43]
			"3841:10897:41861:50084:43549", -- [44]
			"17555:43991", -- [45]
			"3841:41383:15177:48274:48275", -- [46]
			"3841:41383:15177:48274", -- [47]
			"3841:41383:15177:48274:48273", -- [48]
			"3841:10897:41861:50084:54393", -- [49]
			["direct"] = "3841:17555:40552,11800",
			["coord"] = 2377769595,
			["m"] = 41,
			["f"] = 0,
		},
		[40966] = {
			"35481:4407:3841", -- [1]
			"35481:4407:3841:3838", -- [2]
			"35481:6706:34378:4267", -- [3]
			"41383:41580:40367", -- [4]
			"41383:41580:40367:40358:4321", -- [5]
			"35481:4407", -- [6]
			"35481:6706", -- [7]
			"41383:15177:39175:7823", -- [8]
			"35481:4407:3841:10897", -- [9]
			"35481:6706:34378:4267:22931:12578:11138", -- [10]
			"35481:6706:34378:4267:22931:12578", -- [11]
			"41383:15177", -- [12]
			"41383:15177:39175:10583", -- [13]
			"35481:6706:35136:39210:16227", -- [14]
			"35481:4407:3841:3838:17555:17554", -- [15]
			"35481:4407:3841:3838:17555", -- [16]
			"35481:6706:34378:4267:22931", -- [17]
			"35481:6706:34378:4267:22935", -- [18]
			"41383:41580:40367:40358", -- [19]
			"35481:4407:34374", -- [20]
			"35481:4407:33253", -- [21]
			"35481:6706:34378", -- [22]
			"35481:6706:35137", -- [23]
			"35481:6706:35136", -- [24]
			"35481:6706:35138", -- [25]
			"35481:35478", -- [26]
			"35481:35478:35556", -- [27]
			"35481:35562", -- [28]
			"41383:15177:39175", -- [29]
			"35481:6706:35136:39210", -- [30]
			"35481:6706:35136:39210:39212", -- [31]
			"41383:41580:40367:40358:39211", -- [32]
			"35481:4407:3841:3838:40552:40553", -- [33]
			"35481:4407:3841:3838:40552", -- [34]
			"41383:41580:40367:40768", -- [35]
			"41383:15177:48274:48275:40827", -- [36]
			"41383:15177:39175:7823:41214", -- [37]
			"35481:4407:41240", -- [38]
			"35481:6706:34378:4267:22935:43549:50084", -- [39]
			"35481:6706:34378:4267:22935:43549:50084:53783", -- [40]
			"35481:6706:34378:4267:22935:43549:50084:41861", -- [41]
			"41383:41580", -- [42]
			"35481:6706:34378:4267:22931:43073", -- [43]
			"35481:6706:34378:4267:22931:43079", -- [44]
			"35481:6706:34378:4267:22935:43549", -- [45]
			"35481:4407:3841:3838:17555:43991", -- [46]
			"41383:15177:48274:48275", -- [47]
			"41383:15177:48274", -- [48]
			"41383:15177:48274:48273", -- [49]
			"35481:6706:34378:4267:22935:43549:50084:54393", -- [50]
			["direct"] = "41383:35481",
			["f"] = 0,
			["m"] = 121,
			["coord"] = 2156735114,
		},
		[39210] = {
			"34378:4267:33253:3841", -- [1]
			"34378:4267:33253:3841:3838", -- [2]
			"34378:4267", -- [3]
			"39211:40358:40367", -- [4]
			"39212:4321", -- [5]
			"35136:4407", -- [6]
			"35136:6706", -- [7]
			"39211:40358:40768:7823", -- [8]
			"35136:6706:35481:40966:41383", -- [9]
			"34378:4267:33253:3841:10897", -- [10]
			"34378:4267:22931:12578:11138", -- [11]
			"34378:4267:22931:12578", -- [12]
			"35136:6706:35481:40966:41383:15177", -- [13]
			"39211:40358:40768:7823:10583", -- [14]
			"34378:4267:33253:3841:3838:17555:17554", -- [15]
			"34378:4267:33253:3841:3838:17555", -- [16]
			"34378:4267:22931", -- [17]
			"34378:4267:22935", -- [18]
			"39211:40358", -- [19]
			"34378:4267:34374", -- [20]
			"34378:4267:33253", -- [21]
			"35136:35137", -- [22]
			"35136:6706:35138", -- [23]
			"35136:6706:35481", -- [24]
			"35136:6706:35478", -- [25]
			"35136:6706:35556", -- [26]
			"35136:6706:35562", -- [27]
			"39211:40358:40768:7823:39175", -- [28]
			"34378:4267:33253:3841:3838:40552:40553", -- [29]
			"34378:4267:33253:3841:3838:40552", -- [30]
			"39211:40358:40768", -- [31]
			"39211:40358:40768:7823:40827", -- [32]
			"39211:40358:40768:7823:41214", -- [33]
			"35136:35137:41240", -- [34]
			"34378:4267:22935:43549:50084", -- [35]
			"34378:4267:22935:43549:50084:53783", -- [36]
			"34378:4267:22935:43549:50084:41861", -- [37]
			"35136:6706:35481:40966", -- [38]
			"35136:6706:35481:40966:41383:41580", -- [39]
			"34378:4267:22931:43073", -- [40]
			"34378:4267:22931:43079", -- [41]
			"34378:4267:22935:43549", -- [42]
			"34378:4267:33253:3841:3838:17555:43991", -- [43]
			"39211:40358:40768:7823:40827:48275", -- [44]
			"35136:6706:35481:40966:41383:15177:48274", -- [45]
			"39211:40358:40768:7823:40827:48275:48273", -- [46]
			"34378:4267:22935:43549:50084:54393", -- [47]
			["direct"] = "16227:34378:35136:39212:39211",
			["f"] = 0,
			["m"] = 607,
			["coord"] = 1673731057,
		},
		[48273] = {
			"48274:15177:41383:3841", -- [1]
			"48274:15177:41383:3841:3838", -- [2]
			"48274:15177:41383:6706:34378:4267", -- [3]
			"48274:15177:41383:41580:40367", -- [4]
			"48275:40827:7823:4321", -- [5]
			"48274:15177:41383:35138:4407", -- [6]
			"48274:15177:41383:6706", -- [7]
			"48275:40827:7823", -- [8]
			"48274:15177:41383", -- [9]
			"48274:15177:41383:3841:10897", -- [10]
			"48274:15177:41383:6706:34378:4267:22931:12578:11138", -- [11]
			"48274:15177:41383:6706:34378:4267:22931:12578", -- [12]
			"48274:15177", -- [13]
			"48274:15177:39175:10583", -- [14]
			"48275:40827:7823:16227", -- [15]
			"48274:15177:41383:3841:3838:17555:17554", -- [16]
			"48274:15177:41383:3841:3838:17555", -- [17]
			"48274:15177:41383:6706:34378:4267:22931", -- [18]
			"48274:15177:41383:6706:34378:4267:22935", -- [19]
			"48275:40827:7823:40768:40358", -- [20]
			"48274:15177:41383:35138:4407:34374", -- [21]
			"48274:15177:41383:6706:34378:4267:33253", -- [22]
			"48274:15177:41383:6706:34378", -- [23]
			"48274:15177:41383:6706:35137", -- [24]
			"48274:15177:41383:6706:35136", -- [25]
			"48274:15177:41383:35138", -- [26]
			"48274:15177:41383:40966:35481", -- [27]
			"48274:15177:41383:40966:35481:35478", -- [28]
			"48274:15177:41383:40966:35481:35478:35556", -- [29]
			"48274:15177:41383:40966:35481:35562", -- [30]
			"48274:15177:39175", -- [31]
			"48275:40827:7823:40768:40358:39211:39210", -- [32]
			"48275:40827:7823:4321:39212", -- [33]
			"48275:40827:7823:40768:40358:39211", -- [34]
			"48274:15177:41383:3841:3838:40552:40553", -- [35]
			"48274:15177:41383:3841:3838:40552", -- [36]
			"48275:40827:7823:40768", -- [37]
			"48275:40827", -- [38]
			"48275:40827:41214", -- [39]
			"48274:15177:41383:35138:41240", -- [40]
			"48274:15177:41383:6706:34378:4267:22935:43549:50084", -- [41]
			"48274:15177:41383:6706:34378:4267:22935:43549:50084:53783", -- [42]
			"48274:15177:41383:6706:34378:4267:22935:43549:50084:41861", -- [43]
			"48274:15177:41383:40966", -- [44]
			"48274:15177:41383:41580", -- [45]
			"48274:15177:41383:6706:34378:4267:22931:43073", -- [46]
			"48274:15177:41383:6706:34378:4267:22931:43079", -- [47]
			"48274:15177:41383:6706:34378:4267:22935:43549", -- [48]
			"48274:15177:41383:3841:3838:17555:43991", -- [49]
			"48274:15177:41383:6706:34378:4267:22935:43549:50084:54393", -- [50]
			["direct"] = "48275:48274",
			["f"] = 0,
			["m"] = 720,
			["coord"] = 958375506,
		},
	}, -- [1]
	{
		[29480] = {
			"12617:43570:2835:1572:2941:352", -- [1]
			"12617:44407:44410:2299:931:523", -- [2]
			"12617:44407:44410:2299:931", -- [3]
			"12617:1573", -- [4]
			"12617:43570:2835:1571", -- [5]
			"12617:43570:2835:1572", -- [6]
			"12617:44407:44410:2299:931:2409", -- [7]
			"12617:43570:2835", -- [8]
			"12617:44407:44410:2299:931:2409:43045:2859", -- [9]
			"12617:8018", -- [10]
			"12617:44407:44410:2299:43086:43087:8609", -- [11]
			"12617:12596", -- [12]
			"12617:44407:44410:2299", -- [13]
			"12617:43570:2835:1572:2941", -- [14]
			"12617:44230:44233", -- [15]
			"12617:44230:28621", -- [16]
			"12617:44230", -- [17]
			"12617:44231:44232", -- [18]
			"12617:44407:44410:2299:931:2409:43045", -- [19]
			"12617:24851", -- [20]
			"12617:26560", -- [21]
			"12617:37888", -- [22]
			"12617:43570:2835:41325:41323", -- [23]
			"12617:43570:2835:41325:41322", -- [24]
			"12617:43570:2835:41325", -- [25]
			"12617:43570:2835:41325:41322:41321", -- [26]
			"12617:44407:41332", -- [27]
			"12617:44407:44410:2299:931:43000:42983", -- [28]
			"12617:44407:44410:2299:931:523:42426", -- [29]
			"12617:43570:2835:1572:2941:352:42406", -- [30]
			"12617:44407:44410:2299:931:43000", -- [31]
			"12617:44407:44410:2299:931:2409:43045:43042", -- [32]
			"12617:44407:44410:2299:931:2409:43045:43042:43043", -- [33]
			"12617:44407:44410:2299:43086:43072", -- [34]
			"12617:44407:44410:2299:43086:43087", -- [35]
			"12617:44407:44410:2299:43086", -- [36]
			"12617:44407:44410:2299:931:43088", -- [37]
			"12617:44407:44410:2299:43086:43087:8609:43107", -- [38]
			"12617:1573:43290:43295", -- [39]
			"12617:1573:43290", -- [40]
			"12617:44407:44410:2299:931:43371", -- [41]
			"12617:43570", -- [42]
			"12617:1573:43701", -- [43]
			"12617:43570:2835:1572:43702", -- [44]
			"12617:44407:44410:2299:931:2409:43697", -- [45]
			"12617:44231", -- [46]
			"12617:44407:44409", -- [47]
			"12617:44407:44410", -- [48]
			"12617:44407", -- [49]
			"12617:37888:46011:46006", -- [50]
			"12617:37888:46011", -- [51]
			"12617:43570:2835:47121", -- [52]
			"12617:43570:2835:47121:47154:47147:47119", -- [53]
			"12617:43570:2835:47121:47154:47118", -- [54]
			"12617:43570:2835:47121:47154:47147", -- [55]
			"12617:43570:2835:47121:47154", -- [56]
			"12617:43570:2835:47121:47154:47155", -- [57]
			"12617:44230:44233:47875", -- [58]
			"12617:43570:2835:1572:2941:47927", -- [59]
			"12617:44407:44410:2299:48321:48318", -- [60]
			"12617:44407:44410:2299:48321", -- [61]
			["direct"] = "12617",
			["f"] = 0,
			["m"] = 23,
			["coord"] = 3598352567,
			requirements = "cls:DEATHKNIGHT",
		},
		[8609] = {
			"2409:523", -- [1]
			"43087:43088:931", -- [2]
			"43087:43086:2299:2941:1573", -- [3]
			"43087:43086:2299:44410:44409:1572:1571", -- [4]
			"43087:43086:2299:44410:44409:1572", -- [5]
			"43087:43086:2299:44410:44409:1572:2835", -- [6]
			"43107:2859", -- [7]
			"43087:43086:2299:44410:44409:1572:2835:8018", -- [8]
			"43087:43086:2299:44410:44409:1572:2835:8018:12596", -- [9]
			"43087:43086:2299:44410:44407:12617", -- [10]
			"43087:43086:2299:2941", -- [11]
			"43087:43086:2299:44410:44407:12617:44230:44233", -- [12]
			"43087:43086:2299:44410:44407:12617:44230:28621", -- [13]
			"43087:43086:2299:44410:44407:12617:44230", -- [14]
			"43087:43086:2299:44410:44407:12617:44231:44232", -- [15]
			"2409:43045", -- [16]
			"43087:43086:2299:44410:44407:12617:24851", -- [17]
			"43087:43086:2299:2941:1573:26560", -- [18]
			"43087:43086:2299:44410:44409:1572:2835:8018:12596:37888", -- [19]
			"43087:43086:2299:44410:44409:1572:41321:41322:41323", -- [20]
			"43087:43086:2299:44410:44409:1572:41321:41322", -- [21]
			"43087:43086:2299:44410:44409:1572:41321:41322:41325", -- [22]
			"43087:43086:2299:44410:44409:1572:41321", -- [23]
			"43087:43086:2299:44410:44407:41332", -- [24]
			"2409:42983", -- [25]
			"2409:523:42426", -- [26]
			"2409:523:42406", -- [27]
			"43087:43088:931:43000", -- [28]
			"2409:43045:43042", -- [29]
			"2409:43045:43042:43043", -- [30]
			"43087:43086:43072", -- [31]
			"43087:43086", -- [32]
			"43087:43088", -- [33]
			"43087:43086:2299:2941:1573:43290:43295", -- [34]
			"43087:43086:2299:2941:1573:43290", -- [35]
			"43087:43086:43072:43371", -- [36]
			"43087:43086:2299:44410:44409:1572:2835:43570", -- [37]
			"43087:43086:2299:2941:1573:43701", -- [38]
			"43087:43086:2299:44410:44409:1572:43702", -- [39]
			"2409:43697", -- [40]
			"43087:43086:2299:44410:44407:12617:44231", -- [41]
			"43087:43086:2299:44410:44409", -- [42]
			"43087:43086:2299:44410", -- [43]
			"43087:43086:2299:44410:44407", -- [44]
			"43087:43086:2299:44410:44409:1572:2835:8018:46006", -- [45]
			"43087:43086:2299:44410:44409:1572:2835:8018:46006:46011", -- [46]
			"43087:43086:2299:44410:44409:1572:41321:41322:47121", -- [47]
			"43087:43086:2299:44410:44409:1572:47119", -- [48]
			"43087:43086:2299:44410:44409:1572:41321:41322:47121:47154:47118", -- [49]
			"43087:43086:2299:44410:44409:1572:47119:47147", -- [50]
			"43087:43086:2299:44410:44409:1572:41321:41322:47121:47154", -- [51]
			"43087:43086:2299:44410:44409:1572:41321:41322:47121:47154:47155", -- [52]
			"43087:43086:2299:44410:44409:1572:2835:8018:46006:46011:47875", -- [53]
			"43087:43086:2299:2941:47927", -- [54]
			"43087:43086:2299:48321:48318", -- [55]
			"43087:43086:2299:48321", -- [56]
			["direct"] = "352:2409:2299:43087:43107",
			["coord"] = 2629121909,
			["m"] = 19,
			["f"] = 0,
		},
		[2941] = {
			"352:523", -- [1]
			"2299:931", -- [2]
			"1573:1571", -- [3]
			"2299:931:2409", -- [4]
			"1572:2835", -- [5]
			"352:2859", -- [6]
			"1572:2835:8018", -- [7]
			"2299:43086:43087:8609", -- [8]
			"1573:12596", -- [9]
			"1572:2835:43570:12617", -- [10]
			"1573:12596:46011:47875:44233", -- [11]
			"1572:2835:43570:12617:44230:28621", -- [12]
			"1572:2835:43570:12617:44230", -- [13]
			"1573:12596:37888:44232", -- [14]
			"352:43045", -- [15]
			"1572:2835:43570:12617:24851", -- [16]
			"1573:26560", -- [17]
			"1573:12596:37888", -- [18]
			"1572:41321:41322:41323", -- [19]
			"1572:41321:41322", -- [20]
			"1572:41321:41322:41325", -- [21]
			"1572:41321", -- [22]
			"1572:41332", -- [23]
			"352:42983", -- [24]
			"352:523:42426", -- [25]
			"352:42406", -- [26]
			"2299:931:43000", -- [27]
			"352:43045:43042", -- [28]
			"352:43045:43042:43043", -- [29]
			"2299:43086:43072", -- [30]
			"2299:43086:43087", -- [31]
			"2299:43086", -- [32]
			"2299:931:43088", -- [33]
			"2299:43086:43087:8609:43107", -- [34]
			"1573:43290:43295", -- [35]
			"1573:43290", -- [36]
			"2299:931:43371", -- [37]
			"1572:2835:43570", -- [38]
			"1573:43701", -- [39]
			"1572:43702", -- [40]
			"352:523:43697", -- [41]
			"1572:2835:43570:12617:44231", -- [42]
			"1572:44409", -- [43]
			"2299:44410", -- [44]
			"1572:44409:44407", -- [45]
			"1573:12596:46006", -- [46]
			"1573:12596:46011", -- [47]
			"1572:41321:41322:47121", -- [48]
			"1572:47119", -- [49]
			"1572:41321:41322:47121:47154:47118", -- [50]
			"1572:47119:47147", -- [51]
			"1572:41321:41322:47121:47154", -- [52]
			"1572:41321:41322:47121:47154:47155", -- [53]
			"1573:12596:46011:47875", -- [54]
			"47927:48318", -- [55]
			"47927:48318:48321", -- [56]
			["direct"] = "352:1573:1572:2299:47927",
			["f"] = 0,
			["m"] = 28,
			["coord"] = 1628065415,
		},
		[1573] = {
			"2941:352:523", -- [1]
			"2941:2299:931", -- [2]
			"2941:2299:931:2409", -- [3]
			"2941:352:2859", -- [4]
			"2941:2299:43086:43087:8609", -- [5]
			"2941:2299", -- [6]
			"12596:46011:47875:44233", -- [7]
			"12617:44230:28621", -- [8]
			"12617:44230", -- [9]
			"12596:37888:44232", -- [10]
			"2941:352:43045", -- [11]
			"12617:24851", -- [12]
			"12596:37888", -- [13]
			"1571:41323", -- [14]
			"1571:41323:41322", -- [15]
			"1571:41323:41325", -- [16]
			"1572:41321", -- [17]
			"1572:41332", -- [18]
			"2941:352:42983", -- [19]
			"2941:352:523:42426", -- [20]
			"2941:352:42406", -- [21]
			"2941:2299:931:43000", -- [22]
			"2941:352:43045:43042", -- [23]
			"2941:352:43045:43042:43043", -- [24]
			"2941:2299:43086:43072", -- [25]
			"2941:2299:43086:43087", -- [26]
			"2941:2299:43086", -- [27]
			"2941:2299:931:43088", -- [28]
			"2941:2299:43086:43087:8609:43107", -- [29]
			"43290:43295", -- [30]
			"2941:2299:931:43371", -- [31]
			"2835:43570", -- [32]
			"2941:352:523:43697", -- [33]
			"12617:44231", -- [34]
			"1572:44409", -- [35]
			"1572:44409:44410", -- [36]
			"1572:44409:44407", -- [37]
			"12596:46006", -- [38]
			"12596:46011", -- [39]
			"1572:47119", -- [40]
			"47121:47154:47118", -- [41]
			"47121:47154:47147", -- [42]
			"47121:47154", -- [43]
			"47121:47154:47155", -- [44]
			"12596:46011:47875", -- [45]
			"2941:47927", -- [46]
			"2941:47927:48318", -- [47]
			"2941:47927:48318:48321", -- [48]
			["direct"] = "352:1571:1572:2835:8018:12596:12617:2941:26560:43290:43701:43702:47121",
			["coord"] = 2408610454,
			["m"] = 341,
			["f"] = 0,
		},
		[47154] = {
			"47121:41322:41321:1572:2941:352", -- [1]
			"47121:41322:41321:1572:2941:352:523", -- [2]
			"47121:41322:41321:1572:44409:44410:2299:931", -- [3]
			"47121:1573", -- [4]
			"47121:41322:41323:1571", -- [5]
			"47121:41322:41321:1572", -- [6]
			"47121:41322:41321:1572:44409:44410:2299:931:2409", -- [7]
			"47121:2835", -- [8]
			"47121:41322:41321:1572:2941:352:2859", -- [9]
			"47121:2835:8018", -- [10]
			"47121:41322:41321:1572:44409:44410:2299:43086:43087:8609", -- [11]
			"47121:2835:8018:12596", -- [12]
			"47121:2835:43570:12617", -- [13]
			"47121:41322:41321:1572:44409:44410:2299", -- [14]
			"47121:41322:41321:1572:2941", -- [15]
			"47121:2835:43570:12617:44230:44233", -- [16]
			"47121:2835:43570:12617:44230:28621", -- [17]
			"47121:2835:43570:12617:44230", -- [18]
			"47121:2835:8018:12596:37888:44232", -- [19]
			"47121:41322:41321:1572:2941:352:43045", -- [20]
			"47121:2835:43570:12617:24851", -- [21]
			"47121:2835:43570:12617:26560", -- [22]
			"47121:2835:8018:12596:37888", -- [23]
			"47121:41322:41323", -- [24]
			"47121:41322", -- [25]
			"47121:41322:41325", -- [26]
			"47121:41322:41321", -- [27]
			"47121:41322:41321:1572:41332", -- [28]
			"47121:41322:41321:1572:2941:352:42983", -- [29]
			"47121:41322:41321:1572:2941:352:523:42426", -- [30]
			"47121:41322:41321:1572:2941:352:42406", -- [31]
			"47121:41322:41321:1572:44409:44410:2299:931:43000", -- [32]
			"47121:41322:41321:1572:2941:352:43045:43042", -- [33]
			"47121:41322:41321:1572:2941:352:43045:43042:43043", -- [34]
			"47121:41322:41321:1572:44409:44410:2299:43086:43072", -- [35]
			"47121:41322:41321:1572:44409:44410:2299:43086:43087", -- [36]
			"47121:41322:41321:1572:44409:44410:2299:43086", -- [37]
			"47121:41322:41321:1572:44409:44410:2299:931:43088", -- [38]
			"47121:41322:41321:1572:44409:44410:2299:43086:43087:8609:43107", -- [39]
			"47121:1573:43290:43295", -- [40]
			"47121:1573:43290", -- [41]
			"47121:41322:41321:1572:44409:44410:2299:931:43371", -- [42]
			"47121:2835:43570", -- [43]
			"47121:41322:41321:1572:43702:43701", -- [44]
			"47121:41322:41321:1572:43702", -- [45]
			"47121:41322:41321:1572:2941:352:523:43697", -- [46]
			"47121:2835:43570:12617:44231", -- [47]
			"47121:41322:41321:1572:44409", -- [48]
			"47121:41322:41321:1572:44409:44410", -- [49]
			"47121:41322:41321:1572:44409:44407", -- [50]
			"47121:2835:8018:46006", -- [51]
			"47121:2835:8018:46006:46011", -- [52]
			"47147:47119", -- [53]
			"47121:2835:8018:46006:46011:47875", -- [54]
			"47121:41322:41321:1572:2941:47927", -- [55]
			"47121:41322:41321:1572:2941:47927:48318", -- [56]
			"47121:41322:41321:1572:44409:44410:2299:48321", -- [57]
			["direct"] = "47121:47118:47147:47155",
			["f"] = 0,
			["m"] = 700,
			["coord"] = 2083407912,
		},
		[523] = {
			"352:1573", -- [1]
			"352:1573:1571", -- [2]
			"352:2941:1572", -- [3]
			"352:2941:1572:2835", -- [4]
			"352:1573:8018", -- [5]
			"2409:8609", -- [6]
			"352:1573:12596", -- [7]
			"352:2941:1572:2835:43570:12617", -- [8]
			"931:2299", -- [9]
			"352:2941", -- [10]
			"352:1573:12596:46011:47875:44233", -- [11]
			"352:2941:1572:2835:43570:12617:44230:28621", -- [12]
			"352:2941:1572:2835:43570:12617:44230", -- [13]
			"352:1573:12596:37888:44232", -- [14]
			"352:2941:1572:2835:43570:12617:24851", -- [15]
			"352:1573:26560", -- [16]
			"352:1573:12596:37888", -- [17]
			"352:2941:1572:41321:41322:41323", -- [18]
			"352:2941:1572:41321:41322", -- [19]
			"352:2941:1572:41321:41322:41325", -- [20]
			"352:2941:1572:41321", -- [21]
			"931:2299:44410:44407:41332", -- [22]
			"352:42983", -- [23]
			"931:43000", -- [24]
			"43045:43042", -- [25]
			"43045:43042:43043", -- [26]
			"931:43371:43072", -- [27]
			"931:43088:43087", -- [28]
			"931:43371:43072:43086", -- [29]
			"931:43088", -- [30]
			"2409:8609:43107", -- [31]
			"352:1573:43290:43295", -- [32]
			"352:1573:43290", -- [33]
			"931:43371", -- [34]
			"352:2941:1572:2835:43570", -- [35]
			"352:1573:43701", -- [36]
			"352:1573:43702", -- [37]
			"352:2941:1572:2835:43570:12617:44231", -- [38]
			"931:2299:44410:44409", -- [39]
			"931:2299:44410", -- [40]
			"931:2299:44410:44407", -- [41]
			"352:1573:12596:46006", -- [42]
			"352:1573:12596:46011", -- [43]
			"352:2941:1572:41321:41322:47121", -- [44]
			"352:2941:1572:47119", -- [45]
			"352:2941:1572:41321:41322:47121:47154:47118", -- [46]
			"352:2941:1572:47119:47147", -- [47]
			"352:2941:1572:41321:41322:47121:47154", -- [48]
			"352:2941:1572:41321:41322:47121:47154:47155", -- [49]
			"352:1573:12596:46011:47875", -- [50]
			"352:2941:47927", -- [51]
			"931:2299:48321:48318", -- [52]
			"931:2299:48321", -- [53]
			["direct"] = "352:931:2409:2859:43045:42426:42406:43697",
			["f"] = 0,
			["m"] = 39,
			["coord"] = 2432532065,
		},
		[43000] = {
			"42983:352", -- [1]
			"42983:352:523", -- [2]
			"931:2299:2941:1573", -- [3]
			"931:2299:44410:44409:1572:1571", -- [4]
			"931:2299:44410:44409:1572", -- [5]
			"931:2409", -- [6]
			"931:2299:44410:44409:1572:2835", -- [7]
			"931:2409:43045:2859", -- [8]
			"931:2299:44410:44409:1572:2835:8018", -- [9]
			"931:43088:43087:8609", -- [10]
			"931:2299:44410:44409:1572:2835:8018:12596", -- [11]
			"931:2299:44410:44407:12617", -- [12]
			"931:2299", -- [13]
			"931:2299:2941", -- [14]
			"931:2299:44410:44407:12617:44230:44233", -- [15]
			"931:2299:44410:44407:12617:44230:28621", -- [16]
			"931:2299:44410:44407:12617:44230", -- [17]
			"931:2299:44410:44407:12617:44231:44232", -- [18]
			"931:2409:43045", -- [19]
			"931:2299:44410:44407:12617:24851", -- [20]
			"931:2299:2941:1573:26560", -- [21]
			"931:2299:44410:44409:1572:2835:8018:12596:37888", -- [22]
			"931:2299:44410:44409:1572:41321:41322:41323", -- [23]
			"931:2299:44410:44409:1572:41321:41322", -- [24]
			"931:2299:44410:44409:1572:41321:41322:41325", -- [25]
			"931:2299:44410:44409:1572:41321", -- [26]
			"931:2299:44410:44407:41332", -- [27]
			"42983:352:523:42426", -- [28]
			"42983:352:42406", -- [29]
			"931:2409:43045:43042", -- [30]
			"931:2409:43045:43042:43043", -- [31]
			"931:43371:43072", -- [32]
			"931:43088:43087", -- [33]
			"931:43371:43072:43086", -- [34]
			"931:43088", -- [35]
			"931:43088:43087:8609:43107", -- [36]
			"931:2299:2941:1573:43290:43295", -- [37]
			"931:2299:2941:1573:43290", -- [38]
			"931:43371", -- [39]
			"931:2299:44410:44409:1572:2835:43570", -- [40]
			"931:2299:2941:1573:43701", -- [41]
			"931:2299:44410:44409:1572:43702", -- [42]
			"931:2409:43697", -- [43]
			"931:2299:44410:44407:12617:44231", -- [44]
			"931:2299:44410:44409", -- [45]
			"931:2299:44410", -- [46]
			"931:2299:44410:44407", -- [47]
			"931:2299:44410:44409:1572:2835:8018:46006", -- [48]
			"931:2299:44410:44409:1572:2835:8018:46006:46011", -- [49]
			"931:2299:44410:44409:1572:41321:41322:47121", -- [50]
			"931:2299:44410:44409:1572:47119", -- [51]
			"931:2299:44410:44409:1572:41321:41322:47121:47154:47118", -- [52]
			"931:2299:44410:44409:1572:47119:47147", -- [53]
			"931:2299:44410:44409:1572:41321:41322:47121:47154", -- [54]
			"931:2299:44410:44409:1572:41321:41322:47121:47154:47155", -- [55]
			"931:2299:44410:44409:1572:2835:8018:46006:46011:47875", -- [56]
			"931:2299:2941:47927", -- [57]
			"931:2299:48321:48318", -- [58]
			"931:2299:48321", -- [59]
			["direct"] = "931:42983",
			["f"] = 0,
			["m"] = 30,
			["coord"] = 3517032934,
		},
		[46006] = {
			"12596:1573:2941:352", -- [1]
			"12596:1573:2941:352:523", -- [2]
			"12596:1573:2941:2299:931", -- [3]
			"12596:1573", -- [4]
			"8018:2835:1571", -- [5]
			"8018:2835:1572", -- [6]
			"12596:1573:2941:2299:931:2409", -- [7]
			"8018:2835", -- [8]
			"12596:1573:2941:352:2859", -- [9]
			"12596:1573:2941:2299:43086:43087:8609", -- [10]
			"46011:37888:12617", -- [11]
			"12596:1573:2941:2299", -- [12]
			"12596:1573:2941", -- [13]
			"46011:47875:44233", -- [14]
			"46011:37888:44232:28621", -- [15]
			"46011:37888:44232:44231:44230", -- [16]
			"46011:37888:44232", -- [17]
			"12596:1573:2941:352:43045", -- [18]
			"46011:37888:12617:24851", -- [19]
			"46011:37888:12617:26560", -- [20]
			"46011:37888", -- [21]
			"8018:2835:41325:41323", -- [22]
			"8018:2835:41325:41322", -- [23]
			"8018:2835:41325", -- [24]
			"8018:2835:41325:41322:41321", -- [25]
			"8018:2835:1572:41332", -- [26]
			"12596:1573:2941:352:42983", -- [27]
			"12596:1573:2941:352:523:42426", -- [28]
			"12596:1573:2941:352:42406", -- [29]
			"12596:1573:2941:2299:931:43000", -- [30]
			"12596:1573:2941:352:43045:43042", -- [31]
			"12596:1573:2941:352:43045:43042:43043", -- [32]
			"12596:1573:2941:2299:43086:43072", -- [33]
			"12596:1573:2941:2299:43086:43087", -- [34]
			"12596:1573:2941:2299:43086", -- [35]
			"12596:1573:2941:2299:931:43088", -- [36]
			"12596:1573:2941:2299:43086:43087:8609:43107", -- [37]
			"12596:1573:43290:43295", -- [38]
			"12596:1573:43290", -- [39]
			"12596:1573:2941:2299:931:43371", -- [40]
			"8018:43570", -- [41]
			"12596:1573:43701", -- [42]
			"12596:1573:43702", -- [43]
			"12596:1573:2941:352:523:43697", -- [44]
			"46011:37888:44232:44231", -- [45]
			"8018:2835:1572:44409", -- [46]
			"8018:2835:1572:44409:44410", -- [47]
			"8018:2835:1572:44409:44407", -- [48]
			"8018:2835:47121", -- [49]
			"8018:2835:47121:47154:47147:47119", -- [50]
			"8018:2835:47121:47154:47118", -- [51]
			"8018:2835:47121:47154:47147", -- [52]
			"8018:2835:47121:47154", -- [53]
			"8018:2835:47121:47154:47155", -- [54]
			"46011:47875", -- [55]
			"12596:1573:2941:47927", -- [56]
			"12596:1573:2941:47927:48318", -- [57]
			"12596:1573:2941:47927:48318:48321", -- [58]
			["direct"] = "8018:12596:46011",
			["f"] = 0,
			["m"] = 22,
			["coord"] = 1696641517,
		},
		[43697] = {
			"523:352", -- [1]
			"2409:931", -- [2]
			"523:352:1573", -- [3]
			"523:352:1573:1571", -- [4]
			"2409:931:2299:44410:44409:1572", -- [5]
			"2409:931:2299:44410:44409:1572:2835", -- [6]
			"43045:2859", -- [7]
			"2409:931:2299:44410:44409:1572:2835:8018", -- [8]
			"2409:8609", -- [9]
			"523:352:1573:12596", -- [10]
			"2409:931:2299:44410:44407:12617", -- [11]
			"2409:931:2299", -- [12]
			"523:352:2941", -- [13]
			"2409:931:2299:44410:44407:12617:44230:44233", -- [14]
			"2409:931:2299:44410:44407:12617:44230:28621", -- [15]
			"2409:931:2299:44410:44407:12617:44230", -- [16]
			"523:352:1573:12596:37888:44232", -- [17]
			"2409:931:2299:44410:44407:12617:24851", -- [18]
			"523:352:1573:26560", -- [19]
			"523:352:1573:12596:37888", -- [20]
			"2409:931:2299:44410:44409:1572:41321:41322:41323", -- [21]
			"2409:931:2299:44410:44409:1572:41321:41322", -- [22]
			"2409:931:2299:44410:44409:1572:41321:41322:41325", -- [23]
			"2409:931:2299:44410:44409:1572:41321", -- [24]
			"2409:931:2299:44410:44407:41332", -- [25]
			"2409:42983", -- [26]
			"523:42426", -- [27]
			"523:42406", -- [28]
			"2409:931:43000", -- [29]
			"43045:43042", -- [30]
			"43045:43042:43043", -- [31]
			"2409:931:43371:43072", -- [32]
			"2409:8609:43087", -- [33]
			"2409:931:43371:43072:43086", -- [34]
			"2409:931:43088", -- [35]
			"2409:8609:43107", -- [36]
			"523:352:1573:43290:43295", -- [37]
			"523:352:1573:43290", -- [38]
			"2409:931:43371", -- [39]
			"2409:931:2299:44410:44409:1572:2835:43570", -- [40]
			"523:352:1573:43701", -- [41]
			"2409:931:2299:44410:44409:1572:43702", -- [42]
			"2409:931:2299:44410:44407:12617:44231", -- [43]
			"2409:931:2299:44410:44409", -- [44]
			"2409:931:2299:44410", -- [45]
			"2409:931:2299:44410:44407", -- [46]
			"2409:931:2299:44410:44409:1572:2835:8018:46006", -- [47]
			"523:352:1573:12596:46011", -- [48]
			"2409:931:2299:44410:44409:1572:41321:41322:47121", -- [49]
			"2409:931:2299:44410:44409:1572:47119", -- [50]
			"2409:931:2299:44410:44409:1572:41321:41322:47121:47154:47118", -- [51]
			"2409:931:2299:44410:44409:1572:47119:47147", -- [52]
			"2409:931:2299:44410:44409:1572:41321:41322:47121:47154", -- [53]
			"2409:931:2299:44410:44409:1572:41321:41322:47121:47154:47155", -- [54]
			"523:352:1573:12596:46011:47875", -- [55]
			"523:352:2941:47927", -- [56]
			"2409:931:2299:48321:48318", -- [57]
			"2409:931:2299:48321", -- [58]
			["direct"] = "523:2409:43045",
			["coord"] = 903385328,
			["m"] = 34,
			["f"] = 0,
		},
		[43295] = {
			"43290:1573:2941:352", -- [1]
			"43290:1573:2941:352:523", -- [2]
			"43290:1573:2941:2299:931", -- [3]
			"43290:1573", -- [4]
			"43290:1573:1571", -- [5]
			"43290:1573:1572", -- [6]
			"43290:1573:2941:2299:931:2409", -- [7]
			"43290:1573:2835", -- [8]
			"43290:1573:2941:352:2859", -- [9]
			"43290:1573:8018", -- [10]
			"43290:1573:2941:2299:43086:43087:8609", -- [11]
			"43290:1573:12596", -- [12]
			"43290:1573:12617", -- [13]
			"43290:1573:2941:2299", -- [14]
			"43290:1573:2941", -- [15]
			"43290:1573:12596:46011:47875:44233", -- [16]
			"43290:1573:12617:44230:28621", -- [17]
			"43290:1573:12617:44230", -- [18]
			"43290:1573:12596:37888:44232", -- [19]
			"43290:1573:2941:352:43045", -- [20]
			"43290:1573:12617:24851", -- [21]
			"43290:1573:26560", -- [22]
			"43290:1573:12596:37888", -- [23]
			"43290:1573:1571:41323", -- [24]
			"43290:1573:1571:41323:41322", -- [25]
			"43290:1573:1571:41323:41325", -- [26]
			"43290:1573:1572:41321", -- [27]
			"43290:1573:1572:41332", -- [28]
			"43290:1573:2941:352:42983", -- [29]
			"43290:1573:2941:352:523:42426", -- [30]
			"43290:1573:2941:352:42406", -- [31]
			"43290:1573:2941:2299:931:43000", -- [32]
			"43290:1573:2941:352:43045:43042", -- [33]
			"43290:1573:2941:352:43045:43042:43043", -- [34]
			"43290:1573:2941:2299:43086:43072", -- [35]
			"43290:1573:2941:2299:43086:43087", -- [36]
			"43290:1573:2941:2299:43086", -- [37]
			"43290:1573:2941:2299:931:43088", -- [38]
			"43290:1573:2941:2299:43086:43087:8609:43107", -- [39]
			"43290:1573:2941:2299:931:43371", -- [40]
			"43290:1573:2835:43570", -- [41]
			"43290:1573:43701", -- [42]
			"43290:1573:43702", -- [43]
			"43290:1573:2941:352:523:43697", -- [44]
			"43290:1573:12617:44231", -- [45]
			"43290:1573:1572:44409", -- [46]
			"43290:1573:1572:44409:44410", -- [47]
			"43290:1573:1572:44409:44407", -- [48]
			"43290:1573:12596:46006", -- [49]
			"43290:1573:12596:46011", -- [50]
			"43290:1573:47121", -- [51]
			"43290:1573:1572:47119", -- [52]
			"43290:1573:47121:47154:47118", -- [53]
			"43290:1573:47121:47154:47147", -- [54]
			"43290:1573:47121:47154", -- [55]
			"43290:1573:47121:47154:47155", -- [56]
			"43290:1573:12596:46011:47875", -- [57]
			"43290:1573:2941:47927", -- [58]
			"43290:1573:2941:47927:48318", -- [59]
			"43290:1573:2941:47927:48318:48321", -- [60]
			["direct"] = "43290",
			["f"] = 0,
			["m"] = 613,
			["coord"] = 2985607386,
		},
		[43701] = {
			"1573:2941:352", -- [1]
			"1573:2941:352:523", -- [2]
			"1573:2941:2299:931", -- [3]
			"1573:1571", -- [4]
			"43702:1572", -- [5]
			"1573:2941:2299:931:2409", -- [6]
			"1573:2835", -- [7]
			"1573:2941:352:2859", -- [8]
			"1573:8018", -- [9]
			"1573:2941:2299:43086:43087:8609", -- [10]
			"1573:12596", -- [11]
			"1573:12617", -- [12]
			"1573:2941:2299", -- [13]
			"1573:2941", -- [14]
			"1573:12596:46011:47875:44233", -- [15]
			"1573:12617:44230:28621", -- [16]
			"1573:12617:44230", -- [17]
			"1573:12596:37888:44232", -- [18]
			"1573:2941:352:43045", -- [19]
			"1573:12617:24851", -- [20]
			"1573:26560", -- [21]
			"1573:12596:37888", -- [22]
			"1573:1571:41323", -- [23]
			"43702:1572:41321:41322", -- [24]
			"43702:1572:41321:41322:41325", -- [25]
			"43702:1572:41321", -- [26]
			"43702:1572:41332", -- [27]
			"1573:2941:352:42983", -- [28]
			"1573:2941:352:523:42426", -- [29]
			"1573:2941:352:42406", -- [30]
			"1573:2941:2299:931:43000", -- [31]
			"1573:2941:352:43045:43042", -- [32]
			"1573:2941:352:43045:43042:43043", -- [33]
			"1573:2941:2299:43086:43072", -- [34]
			"1573:2941:2299:43086:43087", -- [35]
			"1573:2941:2299:43086", -- [36]
			"1573:2941:2299:931:43088", -- [37]
			"1573:2941:2299:43086:43087:8609:43107", -- [38]
			"1573:43290:43295", -- [39]
			"1573:43290", -- [40]
			"1573:2941:2299:931:43371", -- [41]
			"1573:2835:43570", -- [42]
			"1573:2941:352:523:43697", -- [43]
			"1573:12617:44231", -- [44]
			"43702:1572:44409", -- [45]
			"43702:1572:44409:44410", -- [46]
			"43702:1572:44409:44407", -- [47]
			"1573:12596:46006", -- [48]
			"1573:12596:46011", -- [49]
			"43702:1572:41321:41322:47121", -- [50]
			"43702:1572:47119", -- [51]
			"43702:1572:41321:41322:47121:47154:47118", -- [52]
			"43702:1572:47119:47147", -- [53]
			"43702:1572:41321:41322:47121:47154", -- [54]
			"43702:1572:41321:41322:47121:47154:47155", -- [55]
			"1573:12596:46011:47875", -- [56]
			"1573:2941:47927", -- [57]
			"1573:2941:47927:48318", -- [58]
			"1573:2941:47927:48318:48321", -- [59]
			["direct"] = "1573:43702",
			["f"] = 0,
			["m"] = 27,
			["coord"] = 2308277967,
		},
		[47119] = {
			"1572:2941:352", -- [1]
			"1572:2941:352:523", -- [2]
			"1572:44409:44410:2299:931", -- [3]
			"1572:1573", -- [4]
			"47147:47154:47121:41322:41323:1571", -- [5]
			"1572:44409:44410:2299:931:2409", -- [6]
			"47147:47154:47121:2835", -- [7]
			"1572:2941:352:2859", -- [8]
			"47147:47154:47121:2835:8018", -- [9]
			"1572:44409:44410:2299:43086:43087:8609", -- [10]
			"47147:47154:47121:2835:8018:12596", -- [11]
			"47147:47154:47121:2835:43570:12617", -- [12]
			"1572:44409:44410:2299", -- [13]
			"1572:2941", -- [14]
			"47147:47154:47121:2835:43570:12617:44230:44233", -- [15]
			"47147:47154:47121:2835:43570:12617:44230:28621", -- [16]
			"47147:47154:47121:2835:43570:12617:44230", -- [17]
			"47147:47154:47121:2835:8018:12596:37888:44232", -- [18]
			"1572:2941:352:43045", -- [19]
			"47147:47154:47121:2835:43570:12617:24851", -- [20]
			"47147:47154:47121:2835:43570:12617:26560", -- [21]
			"47147:47154:47121:2835:8018:12596:37888", -- [22]
			"47147:47154:47121:41322:41323", -- [23]
			"47147:47154:47121:41322", -- [24]
			"47147:47154:47121:41322:41325", -- [25]
			"1572:41321", -- [26]
			"1572:41332", -- [27]
			"1572:2941:352:42983", -- [28]
			"1572:2941:352:523:42426", -- [29]
			"1572:2941:352:42406", -- [30]
			"1572:44409:44410:2299:931:43000", -- [31]
			"1572:2941:352:43045:43042", -- [32]
			"1572:2941:352:43045:43042:43043", -- [33]
			"1572:44409:44410:2299:43086:43072", -- [34]
			"1572:44409:44410:2299:43086:43087", -- [35]
			"1572:44409:44410:2299:43086", -- [36]
			"1572:44409:44410:2299:931:43088", -- [37]
			"1572:44409:44410:2299:43086:43087:8609:43107", -- [38]
			"1572:1573:43290:43295", -- [39]
			"1572:1573:43290", -- [40]
			"1572:44409:44410:2299:931:43371", -- [41]
			"47147:47154:47121:2835:43570", -- [42]
			"1572:43702:43701", -- [43]
			"1572:43702", -- [44]
			"1572:2941:352:523:43697", -- [45]
			"47147:47154:47121:2835:43570:12617:44231", -- [46]
			"1572:44409", -- [47]
			"1572:44409:44410", -- [48]
			"1572:44409:44407", -- [49]
			"47147:47154:47121:2835:8018:46006", -- [50]
			"47147:47154:47121:2835:8018:46006:46011", -- [51]
			"47147:47154:47121", -- [52]
			"47147:47118", -- [53]
			"47147:47154", -- [54]
			"47147:47154:47121:2835:8018:46006:46011:47875", -- [55]
			"1572:2941:47927", -- [56]
			"1572:2941:47927:48318", -- [57]
			"1572:44409:44410:2299:48321", -- [58]
			["direct"] = "1572:47147:47155",
			["coord"] = 3506423082,
			["m"] = 700,
			["f"] = 0,
		},
		[47875] = {
			"46011:12596:1573:2941:352", -- [1]
			"46011:12596:1573:2941:352:523", -- [2]
			"46011:12596:1573:2941:2299:931", -- [3]
			"46011:12596:1573", -- [4]
			"46011:46006:8018:2835:1571", -- [5]
			"46011:46006:8018:2835:1572", -- [6]
			"46011:12596:1573:2941:2299:931:2409", -- [7]
			"46011:46006:8018:2835", -- [8]
			"46011:12596:1573:2941:352:2859", -- [9]
			"46011:46006:8018", -- [10]
			"46011:12596:1573:2941:2299:43086:43087:8609", -- [11]
			"46011:12596", -- [12]
			"44233:44230:12617", -- [13]
			"46011:12596:1573:2941:2299", -- [14]
			"46011:12596:1573:2941", -- [15]
			"44233:28621", -- [16]
			"44233:44230", -- [17]
			"44233:44232", -- [18]
			"46011:12596:1573:2941:352:43045", -- [19]
			"44233:44230:12617:24851", -- [20]
			"44233:44230:12617:26560", -- [21]
			"46011:37888", -- [22]
			"46011:46006:8018:2835:41325:41323", -- [23]
			"46011:46006:8018:2835:41325:41322", -- [24]
			"46011:46006:8018:2835:41325", -- [25]
			"46011:46006:8018:2835:41325:41322:41321", -- [26]
			"46011:46006:8018:2835:1572:41332", -- [27]
			"46011:12596:1573:2941:352:42983", -- [28]
			"46011:12596:1573:2941:352:523:42426", -- [29]
			"46011:12596:1573:2941:352:42406", -- [30]
			"46011:12596:1573:2941:2299:931:43000", -- [31]
			"46011:12596:1573:2941:352:43045:43042", -- [32]
			"46011:12596:1573:2941:352:43045:43042:43043", -- [33]
			"46011:12596:1573:2941:2299:43086:43072", -- [34]
			"46011:12596:1573:2941:2299:43086:43087", -- [35]
			"46011:12596:1573:2941:2299:43086", -- [36]
			"46011:12596:1573:2941:2299:931:43088", -- [37]
			"46011:12596:1573:2941:2299:43086:43087:8609:43107", -- [38]
			"46011:12596:1573:43290:43295", -- [39]
			"46011:12596:1573:43290", -- [40]
			"46011:12596:1573:2941:2299:931:43371", -- [41]
			"46011:37888:43570", -- [42]
			"46011:12596:1573:43701", -- [43]
			"46011:12596:1573:43702", -- [44]
			"46011:12596:1573:2941:352:523:43697", -- [45]
			"44233:44231", -- [46]
			"46011:46006:8018:2835:1572:44409", -- [47]
			"46011:46006:8018:2835:1572:44409:44410", -- [48]
			"46011:46006:8018:2835:1572:44409:44407", -- [49]
			"46011:46006", -- [50]
			"46011:46006:8018:2835:47121", -- [51]
			"46011:46006:8018:2835:47121:47154:47147:47119", -- [52]
			"46011:46006:8018:2835:47121:47154:47118", -- [53]
			"46011:46006:8018:2835:47121:47154:47147", -- [54]
			"46011:46006:8018:2835:47121:47154", -- [55]
			"46011:46006:8018:2835:47121:47154:47155", -- [56]
			"46011:12596:1573:2941:47927", -- [57]
			"46011:12596:1573:2941:47927:48318", -- [58]
			"46011:12596:1573:2941:47927:48318:48321", -- [59]
			["direct"] = "44233:46011",
			["f"] = 0,
			["m"] = 22,
			["coord"] = 1914908429,
		},
		[47121] = {
			"41322:41321:1572:2941:352", -- [1]
			"41322:41321:1572:2941:352:523", -- [2]
			"41322:41321:1572:44409:44410:2299:931", -- [3]
			"41322:41323:1571", -- [4]
			"41322:41321:1572", -- [5]
			"41322:41321:1572:44409:44410:2299:931:2409", -- [6]
			"41322:41321:1572:2941:352:2859", -- [7]
			"2835:8018", -- [8]
			"41322:41321:1572:44409:44410:2299:43086:43087:8609", -- [9]
			"2835:8018:12596", -- [10]
			"2835:43570:12617", -- [11]
			"41322:41321:1572:44409:44410:2299", -- [12]
			"41322:41321:1572:2941", -- [13]
			"2835:43570:12617:44230:44233", -- [14]
			"2835:43570:12617:44230:28621", -- [15]
			"2835:43570:12617:44230", -- [16]
			"2835:8018:12596:37888:44232", -- [17]
			"41322:41321:1572:2941:352:43045", -- [18]
			"2835:43570:12617:24851", -- [19]
			"2835:43570:12617:26560", -- [20]
			"2835:8018:12596:37888", -- [21]
			"41322:41323", -- [22]
			"41322:41325", -- [23]
			"41322:41321", -- [24]
			"41322:41321:1572:41332", -- [25]
			"41322:41321:1572:2941:352:42983", -- [26]
			"41322:41321:1572:2941:352:523:42426", -- [27]
			"41322:41321:1572:2941:352:42406", -- [28]
			"41322:41321:1572:44409:44410:2299:931:43000", -- [29]
			"41322:41321:1572:2941:352:43045:43042", -- [30]
			"41322:41321:1572:2941:352:43045:43042:43043", -- [31]
			"41322:41321:1572:44409:44410:2299:43086:43072", -- [32]
			"41322:41321:1572:44409:44410:2299:43086:43087", -- [33]
			"41322:41321:1572:44409:44410:2299:43086", -- [34]
			"41322:41321:1572:44409:44410:2299:931:43088", -- [35]
			"41322:41321:1572:44409:44410:2299:43086:43087:8609:43107", -- [36]
			"1573:43290:43295", -- [37]
			"1573:43290", -- [38]
			"41322:41321:1572:44409:44410:2299:931:43371", -- [39]
			"2835:43570", -- [40]
			"41322:41321:1572:43702:43701", -- [41]
			"41322:41321:1572:43702", -- [42]
			"41322:41321:1572:2941:352:523:43697", -- [43]
			"2835:43570:12617:44231", -- [44]
			"41322:41321:1572:44409", -- [45]
			"41322:41321:1572:44409:44410", -- [46]
			"41322:41321:1572:44409:44407", -- [47]
			"2835:8018:46006", -- [48]
			"2835:8018:46006:46011", -- [49]
			"47154:47147:47119", -- [50]
			"47154:47118", -- [51]
			"47154:47147", -- [52]
			"47154:47155", -- [53]
			"2835:8018:46006:46011:47875", -- [54]
			"41322:41321:1572:2941:47927", -- [55]
			"41322:41321:1572:2941:47927:48318", -- [56]
			"41322:41321:1572:44409:44410:2299:48321", -- [57]
			["direct"] = "1573:2835:41322:47154",
			["f"] = 0,
			["m"] = 700,
			["coord"] = 1225080792,
		},
		[24851] = {
			"12617:43570:2835:1572:2941:352", -- [1]
			"12617:44407:44410:2299:931:523", -- [2]
			"12617:44407:44410:2299:931", -- [3]
			"12617:1573", -- [4]
			"12617:43570:2835:1571", -- [5]
			"12617:43570:2835:1572", -- [6]
			"12617:44407:44410:2299:931:2409", -- [7]
			"12617:43570:2835", -- [8]
			"12617:44407:44410:2299:931:2409:43045:2859", -- [9]
			"12617:8018", -- [10]
			"12617:44407:44410:2299:43086:43087:8609", -- [11]
			"12617:12596", -- [12]
			"12617:44407:44410:2299", -- [13]
			"12617:43570:2835:1572:2941", -- [14]
			"12617:44230:44233", -- [15]
			"12617:44230:28621", -- [16]
			"12617:44230", -- [17]
			"12617:44231:44232", -- [18]
			"12617:44407:44410:2299:931:2409:43045", -- [19]
			"12617:37888", -- [20]
			"12617:43570:2835:41325:41323", -- [21]
			"12617:43570:2835:41325:41322", -- [22]
			"12617:43570:2835:41325", -- [23]
			"12617:43570:2835:41325:41322:41321", -- [24]
			"12617:44407:41332", -- [25]
			"12617:44407:44410:2299:931:43000:42983", -- [26]
			"12617:44407:44410:2299:931:523:42426", -- [27]
			"12617:43570:2835:1572:2941:352:42406", -- [28]
			"12617:44407:44410:2299:931:43000", -- [29]
			"12617:44407:44410:2299:931:2409:43045:43042", -- [30]
			"12617:44407:44410:2299:931:2409:43045:43042:43043", -- [31]
			"12617:44407:44410:2299:43086:43072", -- [32]
			"12617:44407:44410:2299:43086:43087", -- [33]
			"12617:44407:44410:2299:43086", -- [34]
			"12617:44407:44410:2299:931:43088", -- [35]
			"12617:44407:44410:2299:43086:43087:8609:43107", -- [36]
			"12617:1573:43290:43295", -- [37]
			"12617:1573:43290", -- [38]
			"12617:44407:44410:2299:931:43371", -- [39]
			"12617:43570", -- [40]
			"12617:1573:43701", -- [41]
			"12617:43570:2835:1572:43702", -- [42]
			"12617:44407:44410:2299:931:2409:43697", -- [43]
			"12617:44231", -- [44]
			"12617:44407:44409", -- [45]
			"12617:44407:44410", -- [46]
			"12617:44407", -- [47]
			"12617:37888:46011:46006", -- [48]
			"12617:37888:46011", -- [49]
			"12617:43570:2835:47121", -- [50]
			"12617:43570:2835:47121:47154:47147:47119", -- [51]
			"12617:43570:2835:47121:47154:47118", -- [52]
			"12617:43570:2835:47121:47154:47147", -- [53]
			"12617:43570:2835:47121:47154", -- [54]
			"12617:43570:2835:47121:47154:47155", -- [55]
			"12617:44230:44233:47875", -- [56]
			"12617:43570:2835:1572:2941:47927", -- [57]
			"12617:44407:44410:2299:48321:48318", -- [58]
			"12617:44407:44410:2299:48321", -- [59]
			["direct"] = "12617:26560",
			["coord"] = 3207244762,
			["m"] = 463,
			["f"] = 0,
		},
		[12617] = {
			"43570:2835:1572:2941:352", -- [1]
			"44407:44410:2299:931:523", -- [2]
			"44407:44410:2299:931", -- [3]
			"43570:2835:1571", -- [4]
			"43570:2835:1572", -- [5]
			"44407:44410:2299:931:2409", -- [6]
			"43570:2835", -- [7]
			"44407:44410:2299:931:2409:43045:2859", -- [8]
			"44407:44410:2299:43086:43087:8609", -- [9]
			"44407:44410:2299", -- [10]
			"43570:2835:1572:2941", -- [11]
			"44230:44233", -- [12]
			"44230:28621", -- [13]
			"44231:44232", -- [14]
			"44407:44410:2299:931:2409:43045", -- [15]
			"43570:2835:41325:41323", -- [16]
			"43570:2835:41325:41322", -- [17]
			"43570:2835:41325", -- [18]
			"43570:2835:41325:41322:41321", -- [19]
			"44407:41332", -- [20]
			"44407:44410:2299:931:43000:42983", -- [21]
			"44407:44410:2299:931:523:42426", -- [22]
			"43570:2835:1572:2941:352:42406", -- [23]
			"44407:44410:2299:931:43000", -- [24]
			"44407:44410:2299:931:2409:43045:43042", -- [25]
			"44407:44410:2299:931:2409:43045:43042:43043", -- [26]
			"44407:44410:2299:43086:43072", -- [27]
			"44407:44410:2299:43086:43087", -- [28]
			"44407:44410:2299:43086", -- [29]
			"44407:44410:2299:931:43088", -- [30]
			"44407:44410:2299:43086:43087:8609:43107", -- [31]
			"1573:43290:43295", -- [32]
			"1573:43290", -- [33]
			"44407:44410:2299:931:43371", -- [34]
			"1573:43701", -- [35]
			"43570:2835:1572:43702", -- [36]
			"44407:44410:2299:931:2409:43697", -- [37]
			"44407:44409", -- [38]
			"44407:44410", -- [39]
			"37888:46011:46006", -- [40]
			"37888:46011", -- [41]
			"43570:2835:47121", -- [42]
			"43570:2835:47121:47154:47147:47119", -- [43]
			"43570:2835:47121:47154:47118", -- [44]
			"43570:2835:47121:47154:47147", -- [45]
			"43570:2835:47121:47154", -- [46]
			"43570:2835:47121:47154:47155", -- [47]
			"44230:44233:47875", -- [48]
			"43570:2835:1572:2941:47927", -- [49]
			"44407:44410:2299:48321:48318", -- [50]
			"44407:44410:2299:48321", -- [51]
			["direct"] = "1573:8018:12596:44230:24851:26560:37888:43570:44231:44407",
			["coord"] = 3256191130,
			["m"] = 23,
			["f"] = 0,
		},
		[1571] = {
			"1573:2941:352", -- [1]
			"1573:2941:352:523", -- [2]
			"1573:2941:2299:931", -- [3]
			"1573:2941:2299:931:2409", -- [4]
			"1573:2941:352:2859", -- [5]
			"2835:8018", -- [6]
			"1573:2941:2299:43086:43087:8609", -- [7]
			"2835:8018:12596", -- [8]
			"2835:43570:12617", -- [9]
			"1573:2941:2299", -- [10]
			"1573:2941", -- [11]
			"2835:43570:12617:44230:44233", -- [12]
			"2835:43570:12617:44230:28621", -- [13]
			"2835:43570:12617:44230", -- [14]
			"2835:8018:12596:37888:44232", -- [15]
			"1573:2941:352:43045", -- [16]
			"2835:43570:12617:24851", -- [17]
			"2835:43570:12617:26560", -- [18]
			"2835:8018:12596:37888", -- [19]
			"41323:41322", -- [20]
			"41323:41325", -- [21]
			"41323:41322:41321", -- [22]
			"1572:41332", -- [23]
			"1573:2941:352:42983", -- [24]
			"1573:2941:352:523:42426", -- [25]
			"1573:2941:352:42406", -- [26]
			"1573:2941:2299:931:43000", -- [27]
			"1573:2941:352:43045:43042", -- [28]
			"1573:2941:352:43045:43042:43043", -- [29]
			"1573:2941:2299:43086:43072", -- [30]
			"1573:2941:2299:43086:43087", -- [31]
			"1573:2941:2299:43086", -- [32]
			"1573:2941:2299:931:43088", -- [33]
			"1573:2941:2299:43086:43087:8609:43107", -- [34]
			"1573:43290:43295", -- [35]
			"1573:43290", -- [36]
			"1573:2941:2299:931:43371", -- [37]
			"2835:43570", -- [38]
			"1573:43701", -- [39]
			"1573:43702", -- [40]
			"1573:2941:352:523:43697", -- [41]
			"2835:43570:12617:44231", -- [42]
			"1572:44409", -- [43]
			"1572:44409:44410", -- [44]
			"1572:44409:44407", -- [45]
			"2835:8018:46006", -- [46]
			"2835:8018:46006:46011", -- [47]
			"41323:41322:47121", -- [48]
			"41323:41322:47121:47154:47147:47119", -- [49]
			"41323:41322:47121:47154:47118", -- [50]
			"41323:41322:47121:47154:47147", -- [51]
			"41323:41322:47121:47154", -- [52]
			"41323:41322:47121:47154:47155", -- [53]
			"2835:8018:46006:46011:47875", -- [54]
			"1573:2941:47927", -- [55]
			"1573:2941:47927:48318", -- [56]
			"1573:2941:47927:48318:48321", -- [57]
			["direct"] = "1573:1572:2835:41323",
			["f"] = 0,
			["m"] = 40,
			["coord"] = 403085392,
		},
		[41321] = {
			"1572:2941:352", -- [1]
			"1572:2941:352:523", -- [2]
			"1572:44409:44410:2299:931", -- [3]
			"1572:1573", -- [4]
			"41322:41323:1571", -- [5]
			"1572:44409:44410:2299:931:2409", -- [6]
			"41322:41325:2835", -- [7]
			"1572:2941:352:2859", -- [8]
			"41322:41325:2835:8018", -- [9]
			"1572:44409:44410:2299:43086:43087:8609", -- [10]
			"41322:41325:2835:8018:12596", -- [11]
			"41322:41325:2835:43570:12617", -- [12]
			"1572:44409:44410:2299", -- [13]
			"1572:2941", -- [14]
			"41322:41325:2835:43570:12617:44230:44233", -- [15]
			"41322:41325:2835:43570:12617:44230:28621", -- [16]
			"41322:41325:2835:43570:12617:44230", -- [17]
			"41322:41325:2835:8018:12596:37888:44232", -- [18]
			"1572:2941:352:43045", -- [19]
			"41322:41325:2835:43570:12617:24851", -- [20]
			"41322:41325:2835:43570:12617:26560", -- [21]
			"41322:41325:2835:8018:12596:37888", -- [22]
			"41322:41323", -- [23]
			"41322:41325", -- [24]
			"1572:41332", -- [25]
			"1572:2941:352:42983", -- [26]
			"1572:2941:352:523:42426", -- [27]
			"1572:2941:352:42406", -- [28]
			"1572:44409:44410:2299:931:43000", -- [29]
			"1572:2941:352:43045:43042", -- [30]
			"1572:2941:352:43045:43042:43043", -- [31]
			"1572:44409:44410:2299:43086:43072", -- [32]
			"1572:44409:44410:2299:43086:43087", -- [33]
			"1572:44409:44410:2299:43086", -- [34]
			"1572:44409:44410:2299:931:43088", -- [35]
			"1572:44409:44410:2299:43086:43087:8609:43107", -- [36]
			"1572:1573:43290:43295", -- [37]
			"1572:1573:43290", -- [38]
			"1572:44409:44410:2299:931:43371", -- [39]
			"41322:41325:2835:43570", -- [40]
			"1572:43702:43701", -- [41]
			"1572:43702", -- [42]
			"1572:2941:352:523:43697", -- [43]
			"41322:41325:2835:43570:12617:44231", -- [44]
			"1572:44409", -- [45]
			"1572:44409:44410", -- [46]
			"1572:44409:44407", -- [47]
			"41322:41325:2835:8018:46006", -- [48]
			"41322:41325:2835:8018:46006:46011", -- [49]
			"41322:47121", -- [50]
			"1572:47119", -- [51]
			"41322:47121:47154:47118", -- [52]
			"41322:47121:47154:47147", -- [53]
			"41322:47121:47154", -- [54]
			"41322:47121:47154:47155", -- [55]
			"41322:41325:2835:8018:46006:46011:47875", -- [56]
			"1572:2941:47927", -- [57]
			"1572:2941:47927:48318", -- [58]
			"1572:44409:44410:2299:48321", -- [59]
			["direct"] = "1572:41322",
			["f"] = 0,
			["m"] = 40,
			["coord"] = 2442507858,
		},
		[43087] = {
			"43088:931:352", -- [1]
			"43088:931:523", -- [2]
			"43088:931", -- [3]
			"43086:2299:2941:1573", -- [4]
			"43086:2299:44410:44409:1572:1571", -- [5]
			"43086:2299:44410:44409:1572", -- [6]
			"8609:2409", -- [7]
			"43086:2299:44410:44409:1572:2835", -- [8]
			"8609:43107:2859", -- [9]
			"43086:2299:44410:44409:1572:2835:8018", -- [10]
			"43086:2299:44410:44409:1572:2835:8018:12596", -- [11]
			"43086:2299:44410:44407:12617", -- [12]
			"43086:2299", -- [13]
			"43086:2299:2941", -- [14]
			"43086:2299:44410:44407:12617:44230:44233", -- [15]
			"43086:2299:44410:44407:12617:44230:28621", -- [16]
			"43086:2299:44410:44407:12617:44230", -- [17]
			"43086:2299:44410:44407:12617:44231:44232", -- [18]
			"8609:2409:43045", -- [19]
			"43086:2299:44410:44407:12617:24851", -- [20]
			"43086:2299:2941:1573:26560", -- [21]
			"43086:2299:44410:44409:1572:2835:8018:12596:37888", -- [22]
			"43086:2299:44410:44409:1572:41321:41322:41323", -- [23]
			"43086:2299:44410:44409:1572:41321:41322", -- [24]
			"43086:2299:44410:44409:1572:41321:41322:41325", -- [25]
			"43086:2299:44410:44409:1572:41321", -- [26]
			"43086:2299:44410:44407:41332", -- [27]
			"43088:931:43000:42983", -- [28]
			"43088:931:523:42426", -- [29]
			"43088:931:523:42406", -- [30]
			"43088:931:43000", -- [31]
			"8609:2409:43045:43042", -- [32]
			"8609:2409:43045:43042:43043", -- [33]
			"43086:43072", -- [34]
			"8609:43107", -- [35]
			"43086:2299:2941:1573:43290:43295", -- [36]
			"43086:2299:2941:1573:43290", -- [37]
			"43086:43072:43371", -- [38]
			"43086:2299:44410:44409:1572:2835:43570", -- [39]
			"43086:2299:2941:1573:43701", -- [40]
			"43086:2299:44410:44409:1572:43702", -- [41]
			"8609:2409:43697", -- [42]
			"43086:2299:44410:44407:12617:44231", -- [43]
			"43086:2299:44410:44409", -- [44]
			"43086:2299:44410", -- [45]
			"43086:2299:44410:44407", -- [46]
			"43086:2299:44410:44409:1572:2835:8018:46006", -- [47]
			"43086:2299:44410:44409:1572:2835:8018:46006:46011", -- [48]
			"43086:2299:44410:44409:1572:41321:41322:47121", -- [49]
			"43086:2299:44410:44409:1572:47119", -- [50]
			"43086:2299:44410:44409:1572:41321:41322:47121:47154:47118", -- [51]
			"43086:2299:44410:44409:1572:47119:47147", -- [52]
			"43086:2299:44410:44409:1572:41321:41322:47121:47154", -- [53]
			"43086:2299:44410:44409:1572:41321:41322:47121:47154:47155", -- [54]
			"43086:2299:44410:44409:1572:2835:8018:46006:46011:47875", -- [55]
			"43086:2299:2941:47927", -- [56]
			"43086:2299:48321:48318", -- [57]
			"43086:2299:48321", -- [58]
			["direct"] = "8609:43086:43088",
			["coord"] = 3005571614,
			["m"] = 38,
			["f"] = 0,
		},
		[41325] = {
			"41322:41321:1572:2941:352", -- [1]
			"41322:41321:1572:2941:352:523", -- [2]
			"41322:41321:1572:44409:44410:2299:931", -- [3]
			"41323:1571:1573", -- [4]
			"41323:1571", -- [5]
			"41322:41321:1572", -- [6]
			"41322:41321:1572:44409:44410:2299:931:2409", -- [7]
			"41322:41321:1572:2941:352:2859", -- [8]
			"2835:8018", -- [9]
			"41322:41321:1572:44409:44410:2299:43086:43087:8609", -- [10]
			"2835:8018:12596", -- [11]
			"2835:43570:12617", -- [12]
			"41322:41321:1572:44409:44410:2299", -- [13]
			"41322:41321:1572:2941", -- [14]
			"2835:43570:12617:44230:44233", -- [15]
			"2835:43570:12617:44230:28621", -- [16]
			"2835:43570:12617:44230", -- [17]
			"2835:8018:12596:37888:44232", -- [18]
			"41322:41321:1572:2941:352:43045", -- [19]
			"2835:43570:12617:24851", -- [20]
			"2835:43570:12617:26560", -- [21]
			"2835:8018:12596:37888", -- [22]
			"41322:41321", -- [23]
			"41322:41321:1572:41332", -- [24]
			"41322:41321:1572:2941:352:42983", -- [25]
			"41322:41321:1572:2941:352:523:42426", -- [26]
			"41322:41321:1572:2941:352:42406", -- [27]
			"41322:41321:1572:44409:44410:2299:931:43000", -- [28]
			"41322:41321:1572:2941:352:43045:43042", -- [29]
			"41322:41321:1572:2941:352:43045:43042:43043", -- [30]
			"41322:41321:1572:44409:44410:2299:43086:43072", -- [31]
			"41322:41321:1572:44409:44410:2299:43086:43087", -- [32]
			"41322:41321:1572:44409:44410:2299:43086", -- [33]
			"41322:41321:1572:44409:44410:2299:931:43088", -- [34]
			"41322:41321:1572:44409:44410:2299:43086:43087:8609:43107", -- [35]
			"41323:1571:1573:43290:43295", -- [36]
			"41323:1571:1573:43290", -- [37]
			"41322:41321:1572:44409:44410:2299:931:43371", -- [38]
			"2835:43570", -- [39]
			"41323:1571:1573:43701", -- [40]
			"41322:41321:1572:43702", -- [41]
			"41322:41321:1572:2941:352:523:43697", -- [42]
			"2835:43570:12617:44231", -- [43]
			"41322:41321:1572:44409", -- [44]
			"41322:41321:1572:44409:44410", -- [45]
			"41322:41321:1572:44409:44407", -- [46]
			"2835:8018:46006", -- [47]
			"2835:8018:46006:46011", -- [48]
			"41322:47121", -- [49]
			"41322:47121:47154:47147:47119", -- [50]
			"41322:47121:47154:47118", -- [51]
			"41322:47121:47154:47147", -- [52]
			"41322:47121:47154", -- [53]
			"41322:47121:47154:47155", -- [54]
			"2835:8018:46006:46011:47875", -- [55]
			"41322:41321:1572:2941:47927", -- [56]
			"41322:41321:1572:2941:47927:48318", -- [57]
			"41322:41321:1572:44409:44410:2299:48321", -- [58]
			["direct"] = "2835:41323:41322",
			["f"] = 0,
			["m"] = 40,
			["coord"] = 2146709339,
		},
		[44230] = {
			"12617:43570:2835:1572:2941:352", -- [1]
			"12617:44407:44410:2299:931:523", -- [2]
			"12617:44407:44410:2299:931", -- [3]
			"44231:44232:37888:12596:1573", -- [4]
			"12617:43570:2835:1571", -- [5]
			"12617:43570:2835:1572", -- [6]
			"12617:44407:44410:2299:931:2409", -- [7]
			"12617:43570:2835", -- [8]
			"12617:44407:44410:2299:931:2409:43045:2859", -- [9]
			"12617:8018", -- [10]
			"12617:44407:44410:2299:43086:43087:8609", -- [11]
			"44231:44232:37888:12596", -- [12]
			"12617:44407:44410:2299", -- [13]
			"12617:43570:2835:1572:2941", -- [14]
			"44231:44232", -- [15]
			"12617:44407:44410:2299:931:2409:43045", -- [16]
			"12617:24851", -- [17]
			"12617:26560", -- [18]
			"44231:44232:37888", -- [19]
			"12617:43570:2835:41325:41323", -- [20]
			"12617:43570:2835:41325:41322", -- [21]
			"12617:43570:2835:41325", -- [22]
			"12617:43570:2835:41325:41322:41321", -- [23]
			"12617:44407:41332", -- [24]
			"12617:44407:44410:2299:931:43000:42983", -- [25]
			"12617:44407:44410:2299:931:523:42426", -- [26]
			"12617:43570:2835:1572:2941:352:42406", -- [27]
			"12617:44407:44410:2299:931:43000", -- [28]
			"12617:44407:44410:2299:931:2409:43045:43042", -- [29]
			"12617:44407:44410:2299:931:2409:43045:43042:43043", -- [30]
			"12617:44407:44410:2299:43086:43072", -- [31]
			"12617:44407:44410:2299:43086:43087", -- [32]
			"12617:44407:44410:2299:43086", -- [33]
			"12617:44407:44410:2299:931:43088", -- [34]
			"12617:44407:44410:2299:43086:43087:8609:43107", -- [35]
			"44231:44232:37888:12596:1573:43290:43295", -- [36]
			"44231:44232:37888:12596:1573:43290", -- [37]
			"12617:44407:44410:2299:931:43371", -- [38]
			"12617:43570", -- [39]
			"44231:44232:37888:12596:1573:43701", -- [40]
			"12617:43570:2835:1572:43702", -- [41]
			"12617:44407:44410:2299:931:2409:43697", -- [42]
			"12617:44407:44409", -- [43]
			"12617:44407:44410", -- [44]
			"12617:44407", -- [45]
			"44231:44232:37888:46011:46006", -- [46]
			"44231:44232:37888:46011", -- [47]
			"12617:43570:2835:47121", -- [48]
			"12617:43570:2835:47121:47154:47147:47119", -- [49]
			"12617:43570:2835:47121:47154:47118", -- [50]
			"12617:43570:2835:47121:47154:47147", -- [51]
			"12617:43570:2835:47121:47154", -- [52]
			"12617:43570:2835:47121:47154:47155", -- [53]
			"44233:47875", -- [54]
			"12617:43570:2835:1572:2941:47927", -- [55]
			"12617:44407:44410:2299:48321:48318", -- [56]
			"12617:44407:44410:2299:48321", -- [57]
			["direct"] = "12617:44233:28621:44231",
			["coord"] = 2644406368,
			["m"] = 23,
			["f"] = 0,
		},
		[931] = {
			"2299:2941:1573", -- [1]
			"2299:44410:44409:1572:1571", -- [2]
			"2299:44410:44409:1572", -- [3]
			"2299:44410:44409:1572:2835", -- [4]
			"2409:43045:2859", -- [5]
			"2299:44410:44409:1572:2835:8018", -- [6]
			"43088:43087:8609", -- [7]
			"2299:44410:44409:1572:2835:8018:12596", -- [8]
			"2299:44410:44407:12617", -- [9]
			"2299:2941", -- [10]
			"2299:44410:44407:12617:44230:44233", -- [11]
			"2299:44410:44407:12617:44230:28621", -- [12]
			"2299:44410:44407:12617:44230", -- [13]
			"2299:44410:44407:12617:44231:44232", -- [14]
			"2409:43045", -- [15]
			"2299:44410:44407:12617:24851", -- [16]
			"2299:2941:1573:26560", -- [17]
			"2299:44410:44409:1572:2835:8018:12596:37888", -- [18]
			"2299:44410:44409:1572:41321:41322:41323", -- [19]
			"2299:44410:44409:1572:41321:41322", -- [20]
			"2299:44410:44409:1572:41321:41322:41325", -- [21]
			"2299:44410:44409:1572:41321", -- [22]
			"2299:44410:44407:41332", -- [23]
			"43000:42983", -- [24]
			"523:42426", -- [25]
			"523:42406", -- [26]
			"2409:43045:43042", -- [27]
			"2409:43045:43042:43043", -- [28]
			"43371:43072", -- [29]
			"43088:43087", -- [30]
			"43371:43072:43086", -- [31]
			"43088:43087:8609:43107", -- [32]
			"2299:2941:1573:43290:43295", -- [33]
			"2299:2941:1573:43290", -- [34]
			"2299:44410:44409:1572:2835:43570", -- [35]
			"2299:2941:1573:43701", -- [36]
			"2299:44410:44409:1572:43702", -- [37]
			"2409:43697", -- [38]
			"2299:44410:44407:12617:44231", -- [39]
			"2299:44410:44409", -- [40]
			"2299:44410", -- [41]
			"2299:44410:44407", -- [42]
			"2299:44410:44409:1572:2835:8018:46006", -- [43]
			"2299:44410:44409:1572:2835:8018:46006:46011", -- [44]
			"2299:44410:44409:1572:41321:41322:47121", -- [45]
			"2299:44410:44409:1572:47119", -- [46]
			"2299:44410:44409:1572:41321:41322:47121:47154:47118", -- [47]
			"2299:44410:44409:1572:47119:47147", -- [48]
			"2299:44410:44409:1572:41321:41322:47121:47154", -- [49]
			"2299:44410:44409:1572:41321:41322:47121:47154:47155", -- [50]
			"2299:44410:44409:1572:2835:8018:46006:46011:47875", -- [51]
			"2299:2941:47927", -- [52]
			"2299:48321:48318", -- [53]
			"2299:48321", -- [54]
			["direct"] = "352:523:2409:2299:43000:43088:43371",
			["f"] = 0,
			["m"] = 36,
			["coord"] = 1262455122,
		},
		[26560] = {
			"12617:43570:2835:1572:2941:352", -- [1]
			"12617:44407:44410:2299:931:523", -- [2]
			"12617:44407:44410:2299:931", -- [3]
			"12617:1573", -- [4]
			"12617:43570:2835:1571", -- [5]
			"12617:43570:2835:1572", -- [6]
			"12617:44407:44410:2299:931:2409", -- [7]
			"12617:43570:2835", -- [8]
			"12617:44407:44410:2299:931:2409:43045:2859", -- [9]
			"12617:8018", -- [10]
			"12617:44407:44410:2299:43086:43087:8609", -- [11]
			"12617:12596", -- [12]
			"12617:44407:44410:2299", -- [13]
			"12617:43570:2835:1572:2941", -- [14]
			"12617:44230:44233", -- [15]
			"12617:44230:28621", -- [16]
			"12617:44230", -- [17]
			"12617:44231:44232", -- [18]
			"12617:44407:44410:2299:931:2409:43045", -- [19]
			"12617:37888", -- [20]
			"12617:43570:2835:41325:41323", -- [21]
			"12617:43570:2835:41325:41322", -- [22]
			"12617:43570:2835:41325", -- [23]
			"12617:43570:2835:41325:41322:41321", -- [24]
			"12617:44407:41332", -- [25]
			"12617:44407:44410:2299:931:43000:42983", -- [26]
			"12617:44407:44410:2299:931:523:42426", -- [27]
			"12617:43570:2835:1572:2941:352:42406", -- [28]
			"12617:44407:44410:2299:931:43000", -- [29]
			"12617:44407:44410:2299:931:2409:43045:43042", -- [30]
			"12617:44407:44410:2299:931:2409:43045:43042:43043", -- [31]
			"12617:44407:44410:2299:43086:43072", -- [32]
			"12617:44407:44410:2299:43086:43087", -- [33]
			"12617:44407:44410:2299:43086", -- [34]
			"12617:44407:44410:2299:931:43088", -- [35]
			"12617:44407:44410:2299:43086:43087:8609:43107", -- [36]
			"12617:1573:43290:43295", -- [37]
			"12617:1573:43290", -- [38]
			"12617:44407:44410:2299:931:43371", -- [39]
			"12617:43570", -- [40]
			"12617:1573:43701", -- [41]
			"12617:43570:2835:1572:43702", -- [42]
			"12617:44407:44410:2299:931:2409:43697", -- [43]
			"12617:44231", -- [44]
			"12617:44407:44409", -- [45]
			"12617:44407:44410", -- [46]
			"12617:44407", -- [47]
			"12617:37888:46011:46006", -- [48]
			"12617:37888:46011", -- [49]
			"12617:43570:2835:47121", -- [50]
			"12617:43570:2835:47121:47154:47147:47119", -- [51]
			"12617:43570:2835:47121:47154:47118", -- [52]
			"12617:43570:2835:47121:47154:47147", -- [53]
			"12617:43570:2835:47121:47154", -- [54]
			"12617:43570:2835:47121:47154:47155", -- [55]
			"12617:44230:44233:47875", -- [56]
			"12617:43570:2835:1572:2941:47927", -- [57]
			"12617:44407:44410:2299:48321:48318", -- [58]
			"12617:44407:44410:2299:48321", -- [59]
			["direct"] = "12617:24851",
			["coord"] = 2074296428,
			["m"] = 499,
			["f"] = 0,
		},
		[44231] = {
			"44232:37888:12596:1573:2941:352", -- [1]
			"12617:44407:44410:2299:931:523", -- [2]
			"12617:44407:44410:2299:931", -- [3]
			"44232:37888:12596:1573", -- [4]
			"12617:43570:2835:1571", -- [5]
			"12617:43570:2835:1572", -- [6]
			"12617:44407:44410:2299:931:2409", -- [7]
			"12617:43570:2835", -- [8]
			"12617:44407:44410:2299:931:2409:43045:2859", -- [9]
			"44232:37888:12596:8018", -- [10]
			"12617:44407:44410:2299:43086:43087:8609", -- [11]
			"44232:37888:12596", -- [12]
			"12617:44407:44410:2299", -- [13]
			"44232:37888:12596:1573:2941", -- [14]
			"44230:28621", -- [15]
			"12617:44407:44410:2299:931:2409:43045", -- [16]
			"12617:24851", -- [17]
			"12617:26560", -- [18]
			"44232:37888", -- [19]
			"12617:43570:2835:41325:41323", -- [20]
			"12617:43570:2835:41325:41322", -- [21]
			"12617:43570:2835:41325", -- [22]
			"12617:43570:2835:41325:41322:41321", -- [23]
			"12617:44407:41332", -- [24]
			"44232:37888:12596:1573:2941:352:42983", -- [25]
			"12617:44407:44410:2299:931:523:42426", -- [26]
			"44232:37888:12596:1573:2941:352:42406", -- [27]
			"12617:44407:44410:2299:931:43000", -- [28]
			"12617:44407:44410:2299:931:2409:43045:43042", -- [29]
			"12617:44407:44410:2299:931:2409:43045:43042:43043", -- [30]
			"12617:44407:44410:2299:43086:43072", -- [31]
			"12617:44407:44410:2299:43086:43087", -- [32]
			"12617:44407:44410:2299:43086", -- [33]
			"12617:44407:44410:2299:931:43088", -- [34]
			"12617:44407:44410:2299:43086:43087:8609:43107", -- [35]
			"44232:37888:12596:1573:43290:43295", -- [36]
			"44232:37888:12596:1573:43290", -- [37]
			"12617:44407:44410:2299:931:43371", -- [38]
			"12617:43570", -- [39]
			"44232:37888:12596:1573:43701", -- [40]
			"44232:37888:12596:1573:43702", -- [41]
			"12617:44407:44410:2299:931:2409:43697", -- [42]
			"12617:44407:44409", -- [43]
			"12617:44407:44410", -- [44]
			"12617:44407", -- [45]
			"44232:37888:46011:46006", -- [46]
			"44232:37888:46011", -- [47]
			"12617:43570:2835:47121", -- [48]
			"12617:43570:2835:47121:47154:47147:47119", -- [49]
			"12617:43570:2835:47121:47154:47118", -- [50]
			"12617:43570:2835:47121:47154:47147", -- [51]
			"12617:43570:2835:47121:47154", -- [52]
			"12617:43570:2835:47121:47154:47155", -- [53]
			"44233:47875", -- [54]
			"44232:37888:12596:1573:2941:47927", -- [55]
			"44232:37888:12596:1573:2941:47927:48318", -- [56]
			"12617:44407:44410:2299:48321", -- [57]
			["direct"] = "12617:44233:44230:44232",
			["coord"] = 2262993245,
			["m"] = 23,
			["f"] = 0,
		},
		[44233] = {
			"44232:37888:12596:1573:2941:352", -- [1]
			"44232:37888:12596:1573:2941:352:523", -- [2]
			"44230:12617:44407:44410:2299:931", -- [3]
			"44232:37888:12596:1573", -- [4]
			"44230:12617:43570:2835:1571", -- [5]
			"44230:12617:43570:2835:1572", -- [6]
			"44230:12617:44407:44410:2299:931:2409", -- [7]
			"44230:12617:43570:2835", -- [8]
			"44232:37888:12596:1573:2941:352:2859", -- [9]
			"47875:46011:46006:8018", -- [10]
			"44230:12617:44407:44410:2299:43086:43087:8609", -- [11]
			"44232:37888:12596", -- [12]
			"44230:12617", -- [13]
			"44230:12617:44407:44410:2299", -- [14]
			"44232:37888:12596:1573:2941", -- [15]
			"44230:12617:44407:44410:2299:931:2409:43045", -- [16]
			"44230:12617:24851", -- [17]
			"44230:12617:26560", -- [18]
			"44232:37888", -- [19]
			"44230:12617:43570:2835:41325:41323", -- [20]
			"44230:12617:43570:2835:41325:41322", -- [21]
			"44230:12617:43570:2835:41325", -- [22]
			"44230:12617:43570:2835:41325:41322:41321", -- [23]
			"44230:12617:44407:41332", -- [24]
			"44232:37888:12596:1573:2941:352:42983", -- [25]
			"44232:37888:12596:1573:2941:352:523:42426", -- [26]
			"44232:37888:12596:1573:2941:352:42406", -- [27]
			"44230:12617:44407:44410:2299:931:43000", -- [28]
			"44230:12617:44407:44410:2299:931:2409:43045:43042", -- [29]
			"44230:12617:44407:44410:2299:931:2409:43045:43042:43043", -- [30]
			"44230:12617:44407:44410:2299:43086:43072", -- [31]
			"44230:12617:44407:44410:2299:43086:43087", -- [32]
			"44230:12617:44407:44410:2299:43086", -- [33]
			"44230:12617:44407:44410:2299:931:43088", -- [34]
			"44230:12617:44407:44410:2299:43086:43087:8609:43107", -- [35]
			"44232:37888:12596:1573:43290:43295", -- [36]
			"44232:37888:12596:1573:43290", -- [37]
			"44230:12617:44407:44410:2299:931:43371", -- [38]
			"44230:12617:43570", -- [39]
			"44232:37888:12596:1573:43701", -- [40]
			"44232:37888:12596:1573:43702", -- [41]
			"44230:12617:44407:44410:2299:931:2409:43697", -- [42]
			"44230:12617:44407:44409", -- [43]
			"44230:12617:44407:44410", -- [44]
			"44230:12617:44407", -- [45]
			"47875:46011:46006", -- [46]
			"47875:46011", -- [47]
			"44230:12617:43570:2835:47121", -- [48]
			"44230:12617:43570:2835:47121:47154:47147:47119", -- [49]
			"44230:12617:43570:2835:47121:47154:47118", -- [50]
			"44230:12617:43570:2835:47121:47154:47147", -- [51]
			"44230:12617:43570:2835:47121:47154", -- [52]
			"44230:12617:43570:2835:47121:47154:47155", -- [53]
			"44232:37888:12596:1573:2941:47927", -- [54]
			"44232:37888:12596:1573:2941:47927:48318", -- [55]
			"44230:12617:44407:44410:2299:48321", -- [56]
			["direct"] = "28621:44230:44232:44231:47875",
			["coord"] = 794904155,
			["m"] = 23,
			["f"] = 0,
		},
		[43290] = {
			"1573:2941:352", -- [1]
			"1573:2941:352:523", -- [2]
			"1573:2941:2299:931", -- [3]
			"1573:1571", -- [4]
			"1573:1572", -- [5]
			"1573:2941:2299:931:2409", -- [6]
			"1573:2835", -- [7]
			"1573:2941:352:2859", -- [8]
			"1573:8018", -- [9]
			"1573:2941:2299:43086:43087:8609", -- [10]
			"1573:12596", -- [11]
			"1573:12617", -- [12]
			"1573:2941:2299", -- [13]
			"1573:2941", -- [14]
			"1573:12596:46011:47875:44233", -- [15]
			"1573:12617:44230:28621", -- [16]
			"1573:12617:44230", -- [17]
			"1573:12596:37888:44232", -- [18]
			"1573:2941:352:43045", -- [19]
			"1573:12617:24851", -- [20]
			"1573:26560", -- [21]
			"1573:12596:37888", -- [22]
			"1573:1571:41323", -- [23]
			"1573:1571:41323:41322", -- [24]
			"1573:1571:41323:41325", -- [25]
			"1573:1572:41321", -- [26]
			"1573:1572:41332", -- [27]
			"1573:2941:352:42983", -- [28]
			"1573:2941:352:523:42426", -- [29]
			"1573:2941:352:42406", -- [30]
			"1573:2941:2299:931:43000", -- [31]
			"1573:2941:352:43045:43042", -- [32]
			"1573:2941:352:43045:43042:43043", -- [33]
			"1573:2941:2299:43086:43072", -- [34]
			"1573:2941:2299:43086:43087", -- [35]
			"1573:2941:2299:43086", -- [36]
			"1573:2941:2299:931:43088", -- [37]
			"1573:2941:2299:43086:43087:8609:43107", -- [38]
			"1573:2941:2299:931:43371", -- [39]
			"1573:2835:43570", -- [40]
			"1573:43701", -- [41]
			"1573:43702", -- [42]
			"1573:2941:352:523:43697", -- [43]
			"1573:12617:44231", -- [44]
			"1573:1572:44409", -- [45]
			"1573:1572:44409:44410", -- [46]
			"1573:1572:44409:44407", -- [47]
			"1573:12596:46006", -- [48]
			"1573:12596:46011", -- [49]
			"1573:47121", -- [50]
			"1573:1572:47119", -- [51]
			"1573:47121:47154:47118", -- [52]
			"1573:47121:47154:47147", -- [53]
			"1573:47121:47154", -- [54]
			"1573:47121:47154:47155", -- [55]
			"1573:12596:46011:47875", -- [56]
			"1573:2941:47927", -- [57]
			"1573:2941:47927:48318", -- [58]
			"1573:2941:47927:48318:48321", -- [59]
			["direct"] = "1573:43295",
			["coord"] = 2450533333,
			["m"] = 615,
			["f"] = 0,
		},
		[47147] = {
			"47119:1572:2941:352", -- [1]
			"47119:1572:2941:352:523", -- [2]
			"47119:1572:44409:44410:2299:931", -- [3]
			"47154:47121:1573", -- [4]
			"47154:47121:41322:41323:1571", -- [5]
			"47119:1572", -- [6]
			"47119:1572:44409:44410:2299:931:2409", -- [7]
			"47154:47121:2835", -- [8]
			"47119:1572:2941:352:2859", -- [9]
			"47154:47121:2835:8018", -- [10]
			"47119:1572:44409:44410:2299:43086:43087:8609", -- [11]
			"47154:47121:2835:8018:12596", -- [12]
			"47154:47121:2835:43570:12617", -- [13]
			"47119:1572:44409:44410:2299", -- [14]
			"47119:1572:2941", -- [15]
			"47154:47121:2835:43570:12617:44230:44233", -- [16]
			"47154:47121:2835:43570:12617:44230:28621", -- [17]
			"47154:47121:2835:43570:12617:44230", -- [18]
			"47154:47121:2835:8018:12596:37888:44232", -- [19]
			"47119:1572:2941:352:43045", -- [20]
			"47154:47121:2835:43570:12617:24851", -- [21]
			"47154:47121:2835:43570:12617:26560", -- [22]
			"47154:47121:2835:8018:12596:37888", -- [23]
			"47154:47121:41322:41323", -- [24]
			"47154:47121:41322", -- [25]
			"47154:47121:41322:41325", -- [26]
			"47154:47121:41322:41321", -- [27]
			"47119:1572:41332", -- [28]
			"47119:1572:2941:352:42983", -- [29]
			"47119:1572:2941:352:523:42426", -- [30]
			"47119:1572:2941:352:42406", -- [31]
			"47119:1572:44409:44410:2299:931:43000", -- [32]
			"47119:1572:2941:352:43045:43042", -- [33]
			"47119:1572:2941:352:43045:43042:43043", -- [34]
			"47119:1572:44409:44410:2299:43086:43072", -- [35]
			"47119:1572:44409:44410:2299:43086:43087", -- [36]
			"47119:1572:44409:44410:2299:43086", -- [37]
			"47119:1572:44409:44410:2299:931:43088", -- [38]
			"47119:1572:44409:44410:2299:43086:43087:8609:43107", -- [39]
			"47154:47121:1573:43290:43295", -- [40]
			"47154:47121:1573:43290", -- [41]
			"47119:1572:44409:44410:2299:931:43371", -- [42]
			"47154:47121:2835:43570", -- [43]
			"47119:1572:43702:43701", -- [44]
			"47119:1572:43702", -- [45]
			"47119:1572:2941:352:523:43697", -- [46]
			"47154:47121:2835:43570:12617:44231", -- [47]
			"47119:1572:44409", -- [48]
			"47119:1572:44409:44410", -- [49]
			"47119:1572:44409:44407", -- [50]
			"47154:47121:2835:8018:46006", -- [51]
			"47154:47121:2835:8018:46006:46011", -- [52]
			"47154:47121", -- [53]
			"47154:47121:2835:8018:46006:46011:47875", -- [54]
			"47119:1572:2941:47927", -- [55]
			"47119:1572:2941:47927:48318", -- [56]
			"47119:1572:44409:44410:2299:48321", -- [57]
			["direct"] = "47119:47118:47154:47155",
			["f"] = 0,
			["m"] = 700,
			["coord"] = 2593428401,
		},
		[43042] = {
			"43045:352", -- [1]
			"43045:523", -- [2]
			"43045:2409:931", -- [3]
			"43045:352:1573", -- [4]
			"43045:352:1573:1571", -- [5]
			"43045:2409:931:2299:44410:44409:1572", -- [6]
			"43045:2409", -- [7]
			"43045:2409:931:2299:44410:44409:1572:2835", -- [8]
			"43043:2859", -- [9]
			"43045:2409:931:2299:44410:44409:1572:2835:8018", -- [10]
			"43045:2409:8609", -- [11]
			"43045:352:1573:12596", -- [12]
			"43045:2409:931:2299:44410:44407:12617", -- [13]
			"43045:2409:931:2299", -- [14]
			"43045:352:2941", -- [15]
			"43045:2409:931:2299:44410:44407:12617:44230:44233", -- [16]
			"43045:2409:931:2299:44410:44407:12617:44230:28621", -- [17]
			"43045:2409:931:2299:44410:44407:12617:44230", -- [18]
			"43045:352:1573:12596:37888:44232", -- [19]
			"43045:2409:931:2299:44410:44407:12617:24851", -- [20]
			"43045:352:1573:26560", -- [21]
			"43045:352:1573:12596:37888", -- [22]
			"43045:2409:931:2299:44410:44409:1572:41321:41322:41323", -- [23]
			"43045:2409:931:2299:44410:44409:1572:41321:41322", -- [24]
			"43045:2409:931:2299:44410:44409:1572:41321:41322:41325", -- [25]
			"43045:2409:931:2299:44410:44409:1572:41321", -- [26]
			"43045:2409:931:2299:44410:44407:41332", -- [27]
			"43045:2409:42983", -- [28]
			"43045:523:42426", -- [29]
			"43045:523:42406", -- [30]
			"43045:2409:931:43000", -- [31]
			"43045:2409:931:43371:43072", -- [32]
			"43045:2409:8609:43087", -- [33]
			"43045:2409:931:43371:43072:43086", -- [34]
			"43045:2409:931:43088", -- [35]
			"43043:2859:43107", -- [36]
			"43045:352:1573:43290:43295", -- [37]
			"43045:352:1573:43290", -- [38]
			"43045:2409:931:43371", -- [39]
			"43045:2409:931:2299:44410:44409:1572:2835:43570", -- [40]
			"43045:352:1573:43701", -- [41]
			"43045:2409:931:2299:44410:44409:1572:43702", -- [42]
			"43045:43697", -- [43]
			"43045:2409:931:2299:44410:44407:12617:44231", -- [44]
			"43045:2409:931:2299:44410:44409", -- [45]
			"43045:2409:931:2299:44410", -- [46]
			"43045:2409:931:2299:44410:44407", -- [47]
			"43045:352:1573:12596:46006", -- [48]
			"43045:352:1573:12596:46011", -- [49]
			"43045:2409:931:2299:44410:44409:1572:41321:41322:47121", -- [50]
			"43045:2409:931:2299:44410:44409:1572:47119", -- [51]
			"43045:2409:931:2299:44410:44409:1572:41321:41322:47121:47154:47118", -- [52]
			"43045:2409:931:2299:44410:44409:1572:47119:47147", -- [53]
			"43045:2409:931:2299:44410:44409:1572:41321:41322:47121:47154", -- [54]
			"43045:2409:931:2299:44410:44409:1572:41321:41322:47121:47154:47155", -- [55]
			"43045:352:1573:12596:46011:47875", -- [56]
			"43045:352:2941:47927", -- [57]
			"43045:2409:931:2299:48321:48318", -- [58]
			"43045:2409:931:2299:48321", -- [59]
			["direct"] = "43045:43043",
			["coord"] = 2261166479,
			["m"] = 37,
			["f"] = 0,
		},
		[43107] = {
			"8609:2409:352", -- [1]
			"8609:2409:523", -- [2]
			"8609:43087:43088:931", -- [3]
			"8609:43087:43086:2299:2941:1573", -- [4]
			"8609:43087:43086:2299:44410:44409:1572:1571", -- [5]
			"8609:43087:43086:2299:44410:44409:1572", -- [6]
			"8609:2409", -- [7]
			"8609:43087:43086:2299:44410:44409:1572:2835", -- [8]
			"8609:43087:43086:2299:44410:44409:1572:2835:8018", -- [9]
			"8609:43087:43086:2299:44410:44409:1572:2835:8018:12596", -- [10]
			"8609:43087:43086:2299:44410:44407:12617", -- [11]
			"8609:43087:43086:2299", -- [12]
			"8609:43087:43086:2299:2941", -- [13]
			"8609:43087:43086:2299:44410:44407:12617:44230:44233", -- [14]
			"8609:43087:43086:2299:44410:44407:12617:44230:28621", -- [15]
			"8609:43087:43086:2299:44410:44407:12617:44230", -- [16]
			"8609:43087:43086:2299:44410:44407:12617:44231:44232", -- [17]
			"8609:2409:43045", -- [18]
			"8609:43087:43086:2299:44410:44407:12617:24851", -- [19]
			"8609:43087:43086:2299:2941:1573:26560", -- [20]
			"8609:43087:43086:2299:44410:44409:1572:2835:8018:12596:37888", -- [21]
			"8609:43087:43086:2299:44410:44409:1572:41321:41322:41323", -- [22]
			"8609:43087:43086:2299:44410:44409:1572:41321:41322", -- [23]
			"8609:43087:43086:2299:44410:44409:1572:41321:41322:41325", -- [24]
			"8609:43087:43086:2299:44410:44409:1572:41321", -- [25]
			"8609:43087:43086:2299:44410:44407:41332", -- [26]
			"8609:2409:42983", -- [27]
			"8609:2409:523:42426", -- [28]
			"8609:2409:523:42406", -- [29]
			"8609:43087:43088:931:43000", -- [30]
			"2859:43043:43042", -- [31]
			"2859:43043", -- [32]
			"8609:43087:43086:43072", -- [33]
			"8609:43087", -- [34]
			"8609:43087:43086", -- [35]
			"8609:43087:43088", -- [36]
			"8609:43087:43086:2299:2941:1573:43290:43295", -- [37]
			"8609:43087:43086:2299:2941:1573:43290", -- [38]
			"8609:43087:43086:43072:43371", -- [39]
			"8609:43087:43086:2299:44410:44409:1572:2835:43570", -- [40]
			"8609:43087:43086:2299:2941:1573:43701", -- [41]
			"8609:43087:43086:2299:44410:44409:1572:43702", -- [42]
			"8609:2409:43697", -- [43]
			"8609:43087:43086:2299:44410:44407:12617:44231", -- [44]
			"8609:43087:43086:2299:44410:44409", -- [45]
			"8609:43087:43086:2299:44410", -- [46]
			"8609:43087:43086:2299:44410:44407", -- [47]
			"8609:43087:43086:2299:44410:44409:1572:2835:8018:46006", -- [48]
			"8609:43087:43086:2299:44410:44409:1572:2835:8018:46006:46011", -- [49]
			"8609:43087:43086:2299:44410:44409:1572:41321:41322:47121", -- [50]
			"8609:43087:43086:2299:44410:44409:1572:47119", -- [51]
			"8609:43087:43086:2299:44410:44409:1572:41321:41322:47121:47154:47118", -- [52]
			"8609:43087:43086:2299:44410:44409:1572:47119:47147", -- [53]
			"8609:43087:43086:2299:44410:44409:1572:41321:41322:47121:47154", -- [54]
			"8609:43087:43086:2299:44410:44409:1572:41321:41322:47121:47154:47155", -- [55]
			"8609:43087:43086:2299:44410:44409:1572:2835:8018:46006:46011:47875", -- [56]
			"8609:43087:43086:2299:2941:47927", -- [57]
			"8609:43087:43086:2299:48321:48318", -- [58]
			"8609:43087:43086:2299:48321", -- [59]
			["direct"] = "2859:8609",
			["coord"] = 2023220330,
			["m"] = 19,
			["f"] = 0,
		},
		[42983] = {
			"352:523", -- [1]
			"43000:931", -- [2]
			"352:1573", -- [3]
			"352:1573:1571", -- [4]
			"352:2941:1572", -- [5]
			"352:2941:1572:2835", -- [6]
			"352:2859", -- [7]
			"352:1573:8018", -- [8]
			"2409:8609", -- [9]
			"352:1573:12596", -- [10]
			"352:2941:1572:2835:43570:12617", -- [11]
			"43000:931:2299", -- [12]
			"352:2941", -- [13]
			"352:1573:12596:46011:47875:44233", -- [14]
			"352:2941:1572:2835:43570:12617:44230:28621", -- [15]
			"352:2941:1572:2835:43570:12617:44230", -- [16]
			"352:1573:12596:37888:44232", -- [17]
			"2409:43045", -- [18]
			"352:2941:1572:2835:43570:12617:24851", -- [19]
			"352:1573:26560", -- [20]
			"352:1573:12596:37888", -- [21]
			"352:2941:1572:41321:41322:41323", -- [22]
			"352:2941:1572:41321:41322", -- [23]
			"352:2941:1572:41321:41322:41325", -- [24]
			"352:2941:1572:41321", -- [25]
			"352:2941:1572:41332", -- [26]
			"352:523:42426", -- [27]
			"352:42406", -- [28]
			"2409:43045:43042", -- [29]
			"2409:43045:43042:43043", -- [30]
			"43000:931:43371:43072", -- [31]
			"43000:931:43088:43087", -- [32]
			"43000:931:43371:43072:43086", -- [33]
			"43000:931:43088", -- [34]
			"2409:8609:43107", -- [35]
			"352:1573:43290:43295", -- [36]
			"352:1573:43290", -- [37]
			"43000:931:43371", -- [38]
			"352:2941:1572:2835:43570", -- [39]
			"352:1573:43701", -- [40]
			"352:1573:43702", -- [41]
			"352:523:43697", -- [42]
			"352:2941:1572:2835:43570:12617:44231", -- [43]
			"43000:931:2299:44410:44409", -- [44]
			"43000:931:2299:44410", -- [45]
			"43000:931:2299:44410:44407", -- [46]
			"352:1573:12596:46006", -- [47]
			"352:1573:12596:46011", -- [48]
			"352:2941:1572:41321:41322:47121", -- [49]
			"352:2941:1572:47119", -- [50]
			"352:2941:1572:41321:41322:47121:47154:47118", -- [51]
			"352:2941:1572:47119:47147", -- [52]
			"352:2941:1572:41321:41322:47121:47154", -- [53]
			"352:2941:1572:41321:41322:47121:47154:47155", -- [54]
			"352:1573:12596:46011:47875", -- [55]
			"352:2941:47927", -- [56]
			"43000:931:2299:48321:48318", -- [57]
			"43000:931:2299:48321", -- [58]
			["direct"] = "352:2409:43000",
			["f"] = 0,
			["m"] = 30,
			["coord"] = 1794614601,
		},
		[2409] = {
			"931:2299:2941:1573", -- [1]
			"931:2299:44410:44409:1572:1571", -- [2]
			"931:2299:44410:44409:1572", -- [3]
			"931:2299:44410:44409:1572:2835", -- [4]
			"931:2299:44410:44409:1572:2835:8018", -- [5]
			"931:2299:44410:44409:1572:2835:8018:12596", -- [6]
			"931:2299:44410:44407:12617", -- [7]
			"931:2299", -- [8]
			"931:2299:2941", -- [9]
			"931:2299:44410:44407:12617:44230:44233", -- [10]
			"931:2299:44410:44407:12617:44230:28621", -- [11]
			"931:2299:44410:44407:12617:44230", -- [12]
			"931:2299:44410:44407:12617:44231:44232", -- [13]
			"931:2299:44410:44407:12617:24851", -- [14]
			"931:2299:2941:1573:26560", -- [15]
			"931:2299:44410:44409:1572:2835:8018:12596:37888", -- [16]
			"931:2299:44410:44409:1572:41321:41322:41323", -- [17]
			"931:2299:44410:44409:1572:41321:41322", -- [18]
			"931:2299:44410:44409:1572:41321:41322:41325", -- [19]
			"931:2299:44410:44409:1572:41321", -- [20]
			"931:2299:44410:44407:41332", -- [21]
			"523:42426", -- [22]
			"523:42406", -- [23]
			"931:43000", -- [24]
			"43045:43042", -- [25]
			"43045:43042:43043", -- [26]
			"931:43371:43072", -- [27]
			"8609:43087", -- [28]
			"931:43371:43072:43086", -- [29]
			"931:43088", -- [30]
			"8609:43107", -- [31]
			"931:2299:2941:1573:43290:43295", -- [32]
			"931:2299:2941:1573:43290", -- [33]
			"931:43371", -- [34]
			"931:2299:44410:44409:1572:2835:43570", -- [35]
			"931:2299:2941:1573:43701", -- [36]
			"931:2299:44410:44409:1572:43702", -- [37]
			"931:2299:44410:44407:12617:44231", -- [38]
			"931:2299:44410:44409", -- [39]
			"931:2299:44410", -- [40]
			"931:2299:44410:44407", -- [41]
			"931:2299:44410:44409:1572:2835:8018:46006", -- [42]
			"931:2299:44410:44409:1572:2835:8018:46006:46011", -- [43]
			"931:2299:44410:44409:1572:41321:41322:47121", -- [44]
			"931:2299:44410:44409:1572:47119", -- [45]
			"931:2299:44410:44409:1572:41321:41322:47121:47154:47118", -- [46]
			"931:2299:44410:44409:1572:47119:47147", -- [47]
			"931:2299:44410:44409:1572:41321:41322:47121:47154", -- [48]
			"931:2299:44410:44409:1572:41321:41322:47121:47154:47155", -- [49]
			"931:2299:44410:44409:1572:2835:8018:46006:46011:47875", -- [50]
			"931:2299:2941:47927", -- [51]
			"931:2299:48321:48318", -- [52]
			"931:2299:48321", -- [53]
			["direct"] = "352:523:931:2859:8609:43045:42983:43697",
			["f"] = 0,
			["m"] = 34,
			["coord"] = 3332534684,
		},
		[46011] = {
			"12596:1573:2941:352", -- [1]
			"12596:1573:2941:352:523", -- [2]
			"12596:1573:2941:2299:931", -- [3]
			"12596:1573", -- [4]
			"46006:8018:2835:1571", -- [5]
			"46006:8018:2835:1572", -- [6]
			"12596:1573:2941:2299:931:2409", -- [7]
			"46006:8018:2835", -- [8]
			"12596:1573:2941:352:2859", -- [9]
			"46006:8018", -- [10]
			"12596:1573:2941:2299:43086:43087:8609", -- [11]
			"37888:12617", -- [12]
			"12596:1573:2941:2299", -- [13]
			"12596:1573:2941", -- [14]
			"47875:44233", -- [15]
			"37888:44232:28621", -- [16]
			"37888:44232:44231:44230", -- [17]
			"37888:44232", -- [18]
			"12596:1573:2941:352:43045", -- [19]
			"37888:12617:24851", -- [20]
			"37888:12617:26560", -- [21]
			"46006:8018:2835:41325:41323", -- [22]
			"46006:8018:2835:41325:41322", -- [23]
			"46006:8018:2835:41325", -- [24]
			"46006:8018:2835:41325:41322:41321", -- [25]
			"46006:8018:2835:1572:41332", -- [26]
			"12596:1573:2941:352:42983", -- [27]
			"12596:1573:2941:352:523:42426", -- [28]
			"12596:1573:2941:352:42406", -- [29]
			"12596:1573:2941:2299:931:43000", -- [30]
			"12596:1573:2941:352:43045:43042", -- [31]
			"12596:1573:2941:352:43045:43042:43043", -- [32]
			"12596:1573:2941:2299:43086:43072", -- [33]
			"12596:1573:2941:2299:43086:43087", -- [34]
			"12596:1573:2941:2299:43086", -- [35]
			"12596:1573:2941:2299:931:43088", -- [36]
			"12596:1573:2941:2299:43086:43087:8609:43107", -- [37]
			"12596:1573:43290:43295", -- [38]
			"12596:1573:43290", -- [39]
			"12596:1573:2941:2299:931:43371", -- [40]
			"37888:43570", -- [41]
			"12596:1573:43701", -- [42]
			"12596:1573:43702", -- [43]
			"12596:1573:2941:352:523:43697", -- [44]
			"37888:44232:44231", -- [45]
			"46006:8018:2835:1572:44409", -- [46]
			"46006:8018:2835:1572:44409:44410", -- [47]
			"46006:8018:2835:1572:44409:44407", -- [48]
			"46006:8018:2835:47121", -- [49]
			"46006:8018:2835:47121:47154:47147:47119", -- [50]
			"46006:8018:2835:47121:47154:47118", -- [51]
			"46006:8018:2835:47121:47154:47147", -- [52]
			"46006:8018:2835:47121:47154", -- [53]
			"46006:8018:2835:47121:47154:47155", -- [54]
			"12596:1573:2941:47927", -- [55]
			"12596:1573:2941:47927:48318", -- [56]
			"12596:1573:2941:47927:48318:48321", -- [57]
			["direct"] = "12596:37888:46006:47875",
			["f"] = 0,
			["m"] = 22,
			["coord"] = 2169931305,
		},
		[2299] = {
			"931:523", -- [1]
			"2941:1573", -- [2]
			"44410:44409:1572:1571", -- [3]
			"44410:44409:1572", -- [4]
			"931:2409", -- [5]
			"44410:44409:1572:2835", -- [6]
			"931:2409:43045:2859", -- [7]
			"44410:44409:1572:2835:8018", -- [8]
			"44410:44409:1572:2835:8018:12596", -- [9]
			"44410:44407:12617", -- [10]
			"44410:44407:12617:44230:44233", -- [11]
			"44410:44407:12617:44230:28621", -- [12]
			"44410:44407:12617:44230", -- [13]
			"44410:44407:12617:44231:44232", -- [14]
			"931:2409:43045", -- [15]
			"44410:44407:12617:24851", -- [16]
			"2941:1573:26560", -- [17]
			"44410:44409:1572:2835:8018:12596:37888", -- [18]
			"44410:44409:1572:41321:41322:41323", -- [19]
			"44410:44409:1572:41321:41322", -- [20]
			"44410:44409:1572:41321:41322:41325", -- [21]
			"44410:44409:1572:41321", -- [22]
			"44410:44407:41332", -- [23]
			"931:43000:42983", -- [24]
			"931:523:42426", -- [25]
			"352:42406", -- [26]
			"931:43000", -- [27]
			"931:2409:43045:43042", -- [28]
			"931:2409:43045:43042:43043", -- [29]
			"43086:43072", -- [30]
			"43086:43087", -- [31]
			"931:43088", -- [32]
			"43086:43087:8609:43107", -- [33]
			"2941:1573:43290:43295", -- [34]
			"2941:1573:43290", -- [35]
			"931:43371", -- [36]
			"44410:44409:1572:2835:43570", -- [37]
			"2941:1573:43701", -- [38]
			"44410:44409:1572:43702", -- [39]
			"931:2409:43697", -- [40]
			"44410:44407:12617:44231", -- [41]
			"44410:44409", -- [42]
			"44410:44407", -- [43]
			"44410:44409:1572:2835:8018:46006", -- [44]
			"44410:44409:1572:2835:8018:46006:46011", -- [45]
			"44410:44409:1572:41321:41322:47121", -- [46]
			"44410:44409:1572:47119", -- [47]
			"44410:44409:1572:41321:41322:47121:47154:47118", -- [48]
			"44410:44409:1572:47119:47147", -- [49]
			"44410:44409:1572:41321:41322:47121:47154", -- [50]
			"44410:44409:1572:41321:41322:47121:47154:47155", -- [51]
			"44410:44409:1572:2835:8018:46006:46011:47875", -- [52]
			"2941:47927", -- [53]
			"48321:48318", -- [54]
			["direct"] = "352:931:8609:2941:43086:44410:48321",
			["f"] = 0,
			["m"] = 29,
			["coord"] = 3098191905,
		},
		[37888] = {
			"12596:1573:2941:352", -- [1]
			"12596:1573:2941:352:523", -- [2]
			"12596:1573:2941:2299:931", -- [3]
			"12596:1573", -- [4]
			"12596:8018:2835:1571", -- [5]
			"12596:8018:2835:1572", -- [6]
			"12596:1573:2941:2299:931:2409", -- [7]
			"12596:8018:2835", -- [8]
			"12596:1573:2941:352:2859", -- [9]
			"12596:8018", -- [10]
			"12596:1573:2941:2299:43086:43087:8609", -- [11]
			"12596:1573:2941:2299", -- [12]
			"12596:1573:2941", -- [13]
			"44232:44233", -- [14]
			"44232:28621", -- [15]
			"44232:44231:44230", -- [16]
			"12596:1573:2941:352:43045", -- [17]
			"12617:24851", -- [18]
			"12617:26560", -- [19]
			"12596:8018:2835:41325:41323", -- [20]
			"12596:8018:2835:41325:41322", -- [21]
			"12596:8018:2835:41325", -- [22]
			"12596:8018:2835:41325:41322:41321", -- [23]
			"12596:8018:2835:1572:41332", -- [24]
			"12596:1573:2941:352:42983", -- [25]
			"12596:1573:2941:352:523:42426", -- [26]
			"12596:1573:2941:352:42406", -- [27]
			"12596:1573:2941:2299:931:43000", -- [28]
			"12596:1573:2941:352:43045:43042", -- [29]
			"12596:1573:2941:352:43045:43042:43043", -- [30]
			"12596:1573:2941:2299:43086:43072", -- [31]
			"12596:1573:2941:2299:43086:43087", -- [32]
			"12596:1573:2941:2299:43086", -- [33]
			"12596:1573:2941:2299:931:43088", -- [34]
			"12596:1573:2941:2299:43086:43087:8609:43107", -- [35]
			"12596:1573:43290:43295", -- [36]
			"12596:1573:43290", -- [37]
			"12596:1573:2941:2299:931:43371", -- [38]
			"12596:1573:43701", -- [39]
			"12596:1573:43702", -- [40]
			"12596:1573:2941:352:523:43697", -- [41]
			"44232:44231", -- [42]
			"12596:8018:2835:1572:44409", -- [43]
			"12596:8018:2835:1572:44409:44410", -- [44]
			"12617:44407", -- [45]
			"46011:46006", -- [46]
			"12596:8018:2835:47121", -- [47]
			"12596:8018:2835:47121:47154:47147:47119", -- [48]
			"12596:8018:2835:47121:47154:47118", -- [49]
			"12596:8018:2835:47121:47154:47147", -- [50]
			"12596:8018:2835:47121:47154", -- [51]
			"12596:8018:2835:47121:47154:47155", -- [52]
			"46011:47875", -- [53]
			"12596:1573:2941:47927", -- [54]
			"12596:1573:2941:47927:48318", -- [55]
			"12596:1573:2941:47927:48318:48321", -- [56]
			["direct"] = "12596:12617:44232:43570:46011",
			["f"] = 0,
			["m"] = 23,
			["coord"] = 433629294,
		},
		[42426] = {
			"523:352", -- [1]
			"523:931", -- [2]
			"523:352:1573", -- [3]
			"523:352:1573:1571", -- [4]
			"523:352:2941:1572", -- [5]
			"523:2409", -- [6]
			"523:352:2941:1572:2835", -- [7]
			"523:43045:2859", -- [8]
			"523:352:1573:8018", -- [9]
			"523:2409:8609", -- [10]
			"523:352:1573:12596", -- [11]
			"523:352:2941:1572:2835:43570:12617", -- [12]
			"523:931:2299", -- [13]
			"523:352:2941", -- [14]
			"523:352:1573:12596:46011:47875:44233", -- [15]
			"523:352:2941:1572:2835:43570:12617:44230:28621", -- [16]
			"523:352:2941:1572:2835:43570:12617:44230", -- [17]
			"523:352:1573:12596:37888:44232", -- [18]
			"523:43045", -- [19]
			"523:352:2941:1572:2835:43570:12617:24851", -- [20]
			"523:352:1573:26560", -- [21]
			"523:352:1573:12596:37888", -- [22]
			"523:352:2941:1572:41321:41322:41323", -- [23]
			"523:352:2941:1572:41321:41322", -- [24]
			"523:352:2941:1572:41321:41322:41325", -- [25]
			"523:352:2941:1572:41321", -- [26]
			"523:931:2299:44410:44407:41332", -- [27]
			"523:352:42983", -- [28]
			"523:42406", -- [29]
			"523:931:43000", -- [30]
			"523:43045:43042", -- [31]
			"523:43045:43042:43043", -- [32]
			"523:931:43371:43072", -- [33]
			"523:931:43088:43087", -- [34]
			"523:931:43371:43072:43086", -- [35]
			"523:931:43088", -- [36]
			"523:2409:8609:43107", -- [37]
			"523:352:1573:43290:43295", -- [38]
			"523:352:1573:43290", -- [39]
			"523:931:43371", -- [40]
			"523:352:2941:1572:2835:43570", -- [41]
			"523:352:1573:43701", -- [42]
			"523:352:1573:43702", -- [43]
			"523:43697", -- [44]
			"523:352:2941:1572:2835:43570:12617:44231", -- [45]
			"523:931:2299:44410:44409", -- [46]
			"523:931:2299:44410", -- [47]
			"523:931:2299:44410:44407", -- [48]
			"523:352:1573:12596:46006", -- [49]
			"523:352:1573:12596:46011", -- [50]
			"523:352:2941:1572:41321:41322:47121", -- [51]
			"523:352:2941:1572:47119", -- [52]
			"523:352:2941:1572:41321:41322:47121:47154:47118", -- [53]
			"523:352:2941:1572:47119:47147", -- [54]
			"523:352:2941:1572:41321:41322:47121:47154", -- [55]
			"523:352:2941:1572:41321:41322:47121:47154:47155", -- [56]
			"523:352:1573:12596:46011:47875", -- [57]
			"523:352:2941:47927", -- [58]
			"523:931:2299:48321:48318", -- [59]
			"523:931:2299:48321", -- [60]
			["direct"] = "523",
			["f"] = 0,
			["m"] = 39,
			["coord"] = 1808572937,
		},
		[47155] = {
			"47154:47121:41322:41321:1572:2941:352", -- [1]
			"47154:47121:41322:41321:1572:2941:352:523", -- [2]
			"47154:47121:41322:41321:1572:44409:44410:2299:931", -- [3]
			"47154:47121:1573", -- [4]
			"47154:47121:41322:41323:1571", -- [5]
			"47154:47121:41322:41321:1572", -- [6]
			"47154:47121:41322:41321:1572:44409:44410:2299:931:2409", -- [7]
			"47154:47121:2835", -- [8]
			"47154:47121:41322:41321:1572:2941:352:2859", -- [9]
			"47154:47121:2835:8018", -- [10]
			"47154:47121:41322:41321:1572:44409:44410:2299:43086:43087:8609", -- [11]
			"47154:47121:2835:8018:12596", -- [12]
			"47154:47121:2835:43570:12617", -- [13]
			"47154:47121:41322:41321:1572:44409:44410:2299", -- [14]
			"47154:47121:41322:41321:1572:2941", -- [15]
			"47154:47121:2835:43570:12617:44230:44233", -- [16]
			"47154:47121:2835:43570:12617:44230:28621", -- [17]
			"47154:47121:2835:43570:12617:44230", -- [18]
			"47154:47121:2835:8018:12596:37888:44232", -- [19]
			"47154:47121:41322:41321:1572:2941:352:43045", -- [20]
			"47154:47121:2835:43570:12617:24851", -- [21]
			"47154:47121:2835:43570:12617:26560", -- [22]
			"47154:47121:2835:8018:12596:37888", -- [23]
			"47154:47121:41322:41323", -- [24]
			"47154:47121:41322", -- [25]
			"47154:47121:41322:41325", -- [26]
			"47154:47121:41322:41321", -- [27]
			"47154:47121:41322:41321:1572:41332", -- [28]
			"47154:47121:41322:41321:1572:2941:352:42983", -- [29]
			"47154:47121:41322:41321:1572:2941:352:523:42426", -- [30]
			"47154:47121:41322:41321:1572:2941:352:42406", -- [31]
			"47154:47121:41322:41321:1572:44409:44410:2299:931:43000", -- [32]
			"47154:47121:41322:41321:1572:2941:352:43045:43042", -- [33]
			"47154:47121:41322:41321:1572:2941:352:43045:43042:43043", -- [34]
			"47154:47121:41322:41321:1572:44409:44410:2299:43086:43072", -- [35]
			"47154:47121:41322:41321:1572:44409:44410:2299:43086:43087", -- [36]
			"47154:47121:41322:41321:1572:44409:44410:2299:43086", -- [37]
			"47154:47121:41322:41321:1572:44409:44410:2299:931:43088", -- [38]
			"47154:47121:41322:41321:1572:44409:44410:2299:43086:43087:8609:43107", -- [39]
			"47154:47121:1573:43290:43295", -- [40]
			"47154:47121:1573:43290", -- [41]
			"47154:47121:41322:41321:1572:44409:44410:2299:931:43371", -- [42]
			"47154:47121:2835:43570", -- [43]
			"47154:47121:41322:41321:1572:43702:43701", -- [44]
			"47154:47121:41322:41321:1572:43702", -- [45]
			"47154:47121:41322:41321:1572:2941:352:523:43697", -- [46]
			"47154:47121:2835:43570:12617:44231", -- [47]
			"47154:47121:41322:41321:1572:44409", -- [48]
			"47154:47121:41322:41321:1572:44409:44410", -- [49]
			"47154:47121:41322:41321:1572:44409:44407", -- [50]
			"47154:47121:2835:8018:46006", -- [51]
			"47154:47121:2835:8018:46006:46011", -- [52]
			"47154:47121", -- [53]
			"47154:47118", -- [54]
			"47154:47121:2835:8018:46006:46011:47875", -- [55]
			"47154:47121:41322:41321:1572:2941:47927", -- [56]
			"47154:47121:41322:41321:1572:2941:47927:48318", -- [57]
			"47154:47121:41322:41321:1572:44409:44410:2299:48321", -- [58]
			["direct"] = "47119:47147:47154",
			["f"] = 0,
			["m"] = 700,
			["coord"] = 2436441814,
		},
		[2835] = {
			"1572:2941:352", -- [1]
			"1572:2941:352:523", -- [2]
			"1572:44409:44410:2299:931", -- [3]
			"1572:44409:44410:2299:931:2409", -- [4]
			"1572:2941:352:2859", -- [5]
			"1572:44409:44410:2299:43086:43087:8609", -- [6]
			"8018:12596", -- [7]
			"43570:12617", -- [8]
			"1572:44409:44410:2299", -- [9]
			"1572:2941", -- [10]
			"43570:12617:44230:44233", -- [11]
			"43570:12617:44230:28621", -- [12]
			"43570:12617:44230", -- [13]
			"8018:12596:37888:44232", -- [14]
			"1572:2941:352:43045", -- [15]
			"43570:12617:24851", -- [16]
			"43570:12617:26560", -- [17]
			"8018:12596:37888", -- [18]
			"41325:41323", -- [19]
			"41325:41322", -- [20]
			"41325:41322:41321", -- [21]
			"1572:41332", -- [22]
			"1572:2941:352:42983", -- [23]
			"1572:2941:352:523:42426", -- [24]
			"1572:2941:352:42406", -- [25]
			"1572:44409:44410:2299:931:43000", -- [26]
			"1572:2941:352:43045:43042", -- [27]
			"1572:2941:352:43045:43042:43043", -- [28]
			"1572:44409:44410:2299:43086:43072", -- [29]
			"1572:44409:44410:2299:43086:43087", -- [30]
			"1572:44409:44410:2299:43086", -- [31]
			"1572:44409:44410:2299:931:43088", -- [32]
			"1572:44409:44410:2299:43086:43087:8609:43107", -- [33]
			"1571:1573:43290:43295", -- [34]
			"1571:1573:43290", -- [35]
			"1572:44409:44410:2299:931:43371", -- [36]
			"1571:1573:43701", -- [37]
			"1572:43702", -- [38]
			"1572:2941:352:523:43697", -- [39]
			"43570:12617:44231", -- [40]
			"1572:44409", -- [41]
			"1572:44409:44410", -- [42]
			"1572:44409:44407", -- [43]
			"8018:46006", -- [44]
			"8018:46006:46011", -- [45]
			"47121:47154:47147:47119", -- [46]
			"47121:47154:47118", -- [47]
			"47121:47154:47147", -- [48]
			"47121:47154", -- [49]
			"47121:47154:47155", -- [50]
			"8018:46006:46011:47875", -- [51]
			"1572:2941:47927", -- [52]
			"1572:2941:47927:48318", -- [53]
			"1572:44409:44410:2299:48321", -- [54]
			["direct"] = "1573:1571:1572:8018:41325:43570:47121",
			["f"] = 0,
			["m"] = 16,
			["coord"] = 1714518353,
		},
		[43570] = {
			"2835:1572:2941:352", -- [1]
			"2835:1572:2941:352:523", -- [2]
			"2835:1572:44409:44410:2299:931", -- [3]
			"2835:1571:1573", -- [4]
			"2835:1571", -- [5]
			"2835:1572", -- [6]
			"2835:1572:44409:44410:2299:931:2409", -- [7]
			"2835:1572:2941:352:2859", -- [8]
			"2835:1572:44409:44410:2299:43086:43087:8609", -- [9]
			"8018:12596", -- [10]
			"2835:1572:44409:44410:2299", -- [11]
			"2835:1572:2941", -- [12]
			"12617:44230:44233", -- [13]
			"12617:44230:28621", -- [14]
			"12617:44230", -- [15]
			"12617:44231:44232", -- [16]
			"2835:1572:2941:352:43045", -- [17]
			"12617:24851", -- [18]
			"12617:26560", -- [19]
			"2835:41325:41323", -- [20]
			"2835:41325:41322", -- [21]
			"2835:41325", -- [22]
			"2835:41325:41322:41321", -- [23]
			"2835:1572:41332", -- [24]
			"2835:1572:2941:352:42983", -- [25]
			"2835:1572:2941:352:523:42426", -- [26]
			"2835:1572:2941:352:42406", -- [27]
			"2835:1572:44409:44410:2299:931:43000", -- [28]
			"2835:1572:2941:352:43045:43042", -- [29]
			"2835:1572:2941:352:43045:43042:43043", -- [30]
			"2835:1572:44409:44410:2299:43086:43072", -- [31]
			"2835:1572:44409:44410:2299:43086:43087", -- [32]
			"2835:1572:44409:44410:2299:43086", -- [33]
			"2835:1572:44409:44410:2299:931:43088", -- [34]
			"2835:1572:44409:44410:2299:43086:43087:8609:43107", -- [35]
			"2835:1571:1573:43290:43295", -- [36]
			"2835:1571:1573:43290", -- [37]
			"2835:1572:44409:44410:2299:931:43371", -- [38]
			"2835:1571:1573:43701", -- [39]
			"2835:1572:43702", -- [40]
			"2835:1572:2941:352:523:43697", -- [41]
			"12617:44231", -- [42]
			"2835:1572:44409", -- [43]
			"2835:1572:44409:44410", -- [44]
			"2835:1572:44409:44407", -- [45]
			"8018:46006", -- [46]
			"37888:46011", -- [47]
			"2835:47121", -- [48]
			"2835:47121:47154:47147:47119", -- [49]
			"2835:47121:47154:47118", -- [50]
			"2835:47121:47154:47147", -- [51]
			"2835:47121:47154", -- [52]
			"2835:47121:47154:47155", -- [53]
			"37888:46011:47875", -- [54]
			"2835:1572:2941:47927", -- [55]
			"2835:1572:2941:47927:48318", -- [56]
			"2835:1572:44409:44410:2299:48321", -- [57]
			["direct"] = "2835:8018:12617:37888",
			["f"] = 0,
			["m"] = 26,
			["coord"] = 2822796066,
		},
		[47118] = {
			"47154:47121:41322:41321:1572:2941:352", -- [1]
			"47154:47121:41322:41321:1572:2941:352:523", -- [2]
			"47154:47121:41322:41321:1572:44409:44410:2299:931", -- [3]
			"47154:47121:1573", -- [4]
			"47154:47121:41322:41323:1571", -- [5]
			"47154:47121:41322:41321:1572", -- [6]
			"47154:47121:41322:41321:1572:44409:44410:2299:931:2409", -- [7]
			"47154:47121:2835", -- [8]
			"47154:47121:41322:41321:1572:2941:352:2859", -- [9]
			"47154:47121:2835:8018", -- [10]
			"47154:47121:41322:41321:1572:44409:44410:2299:43086:43087:8609", -- [11]
			"47154:47121:2835:8018:12596", -- [12]
			"47154:47121:2835:43570:12617", -- [13]
			"47154:47121:41322:41321:1572:44409:44410:2299", -- [14]
			"47154:47121:41322:41321:1572:2941", -- [15]
			"47154:47121:2835:43570:12617:44230:44233", -- [16]
			"47154:47121:2835:43570:12617:44230:28621", -- [17]
			"47154:47121:2835:43570:12617:44230", -- [18]
			"47154:47121:2835:8018:12596:37888:44232", -- [19]
			"47154:47121:41322:41321:1572:2941:352:43045", -- [20]
			"47154:47121:2835:43570:12617:24851", -- [21]
			"47154:47121:2835:43570:12617:26560", -- [22]
			"47154:47121:2835:8018:12596:37888", -- [23]
			"47154:47121:41322:41323", -- [24]
			"47154:47121:41322", -- [25]
			"47154:47121:41322:41325", -- [26]
			"47154:47121:41322:41321", -- [27]
			"47154:47121:41322:41321:1572:41332", -- [28]
			"47154:47121:41322:41321:1572:2941:352:42983", -- [29]
			"47154:47121:41322:41321:1572:2941:352:523:42426", -- [30]
			"47154:47121:41322:41321:1572:2941:352:42406", -- [31]
			"47154:47121:41322:41321:1572:44409:44410:2299:931:43000", -- [32]
			"47154:47121:41322:41321:1572:2941:352:43045:43042", -- [33]
			"47154:47121:41322:41321:1572:2941:352:43045:43042:43043", -- [34]
			"47154:47121:41322:41321:1572:44409:44410:2299:43086:43072", -- [35]
			"47154:47121:41322:41321:1572:44409:44410:2299:43086:43087", -- [36]
			"47154:47121:41322:41321:1572:44409:44410:2299:43086", -- [37]
			"47154:47121:41322:41321:1572:44409:44410:2299:931:43088", -- [38]
			"47154:47121:41322:41321:1572:44409:44410:2299:43086:43087:8609:43107", -- [39]
			"47154:47121:1573:43290:43295", -- [40]
			"47154:47121:1573:43290", -- [41]
			"47154:47121:41322:41321:1572:44409:44410:2299:931:43371", -- [42]
			"47154:47121:2835:43570", -- [43]
			"47154:47121:41322:41321:1572:43702:43701", -- [44]
			"47154:47121:41322:41321:1572:43702", -- [45]
			"47154:47121:41322:41321:1572:2941:352:523:43697", -- [46]
			"47154:47121:2835:43570:12617:44231", -- [47]
			"47154:47121:41322:41321:1572:44409", -- [48]
			"47154:47121:41322:41321:1572:44409:44410", -- [49]
			"47154:47121:41322:41321:1572:44409:44407", -- [50]
			"47154:47121:2835:8018:46006", -- [51]
			"47154:47121:2835:8018:46006:46011", -- [52]
			"47154:47121", -- [53]
			"47147:47119", -- [54]
			"47154:47155", -- [55]
			"47154:47121:2835:8018:46006:46011:47875", -- [56]
			"47154:47121:41322:41321:1572:2941:47927", -- [57]
			"47154:47121:41322:41321:1572:2941:47927:48318", -- [58]
			"47154:47121:41322:41321:1572:44409:44410:2299:48321", -- [59]
			["direct"] = "47147:47154",
			["coord"] = 1883476664,
			["m"] = 700,
			["f"] = 0,
		},
		[2859] = {
			"43045:2409:931", -- [1]
			"352:1573", -- [2]
			"352:1573:1571", -- [3]
			"352:2941:1572", -- [4]
			"352:2941:1572:2835", -- [5]
			"352:1573:8018", -- [6]
			"43107:8609", -- [7]
			"352:1573:12596", -- [8]
			"43045:2409:931:2299:44410:44407:12617", -- [9]
			"43045:2409:931:2299", -- [10]
			"352:2941", -- [11]
			"352:1573:12596:46011:47875:44233", -- [12]
			"43045:2409:931:2299:44410:44407:12617:44230:28621", -- [13]
			"43045:2409:931:2299:44410:44407:12617:44230", -- [14]
			"352:1573:12596:37888:44232", -- [15]
			"43045:2409:931:2299:44410:44407:12617:24851", -- [16]
			"352:1573:26560", -- [17]
			"352:1573:12596:37888", -- [18]
			"352:2941:1572:41321:41322:41323", -- [19]
			"352:2941:1572:41321:41322", -- [20]
			"352:2941:1572:41321:41322:41325", -- [21]
			"352:2941:1572:41321", -- [22]
			"43045:2409:931:2299:44410:44407:41332", -- [23]
			"352:42983", -- [24]
			"523:42426", -- [25]
			"523:42406", -- [26]
			"43045:2409:931:43000", -- [27]
			"43043:43042", -- [28]
			"43045:2409:931:43371:43072", -- [29]
			"43107:8609:43087", -- [30]
			"43107:8609:43087:43086", -- [31]
			"43045:2409:931:43088", -- [32]
			"352:1573:43290:43295", -- [33]
			"352:1573:43290", -- [34]
			"43045:2409:931:43371", -- [35]
			"352:2941:1572:2835:43570", -- [36]
			"352:1573:43701", -- [37]
			"352:1573:43702", -- [38]
			"43045:43697", -- [39]
			"43045:2409:931:2299:44410:44407:12617:44231", -- [40]
			"43045:2409:931:2299:44410:44409", -- [41]
			"43045:2409:931:2299:44410", -- [42]
			"43045:2409:931:2299:44410:44407", -- [43]
			"352:1573:12596:46006", -- [44]
			"352:1573:12596:46011", -- [45]
			"352:2941:1572:41321:41322:47121", -- [46]
			"352:2941:1572:47119", -- [47]
			"352:2941:1572:41321:41322:47121:47154:47118", -- [48]
			"352:2941:1572:47119:47147", -- [49]
			"352:2941:1572:41321:41322:47121:47154", -- [50]
			"352:2941:1572:41321:41322:47121:47154:47155", -- [51]
			"352:1573:12596:46011:47875", -- [52]
			"352:2941:47927", -- [53]
			"43045:2409:931:2299:48321:48318", -- [54]
			"43045:2409:931:2299:48321", -- [55]
			["m"] = 673,
			["coord"] = 1789705814,
			["direct"] = "352:523:2409:43045:43043:43107",
			["f"] = 0,
		},
		[43086] = {
			"43072:43371:931:352", -- [1]
			"43072:43371:931:523", -- [2]
			"43072:43371:931", -- [3]
			"2299:2941:1573", -- [4]
			"2299:44410:44409:1572:1571", -- [5]
			"2299:44410:44409:1572", -- [6]
			"43072:43371:931:2409", -- [7]
			"2299:44410:44409:1572:2835", -- [8]
			"43072:43371:931:2409:43045:2859", -- [9]
			"2299:44410:44409:1572:2835:8018", -- [10]
			"43087:8609", -- [11]
			"2299:44410:44409:1572:2835:8018:12596", -- [12]
			"2299:44410:44407:12617", -- [13]
			"2299:2941", -- [14]
			"2299:44410:44407:12617:44230:44233", -- [15]
			"2299:44410:44407:12617:44230:28621", -- [16]
			"2299:44410:44407:12617:44230", -- [17]
			"2299:44410:44407:12617:44231:44232", -- [18]
			"43072:43371:931:2409:43045", -- [19]
			"2299:44410:44407:12617:24851", -- [20]
			"2299:2941:1573:26560", -- [21]
			"2299:44410:44409:1572:2835:8018:12596:37888", -- [22]
			"2299:44410:44409:1572:41321:41322:41323", -- [23]
			"2299:44410:44409:1572:41321:41322", -- [24]
			"2299:44410:44409:1572:41321:41322:41325", -- [25]
			"2299:44410:44409:1572:41321", -- [26]
			"2299:44410:44407:41332", -- [27]
			"43072:43371:931:43000:42983", -- [28]
			"43072:43371:931:523:42426", -- [29]
			"43072:43371:931:523:42406", -- [30]
			"43072:43371:931:43000", -- [31]
			"43072:43371:931:2409:43045:43042", -- [32]
			"43072:43371:931:2409:43045:43042:43043", -- [33]
			"43087:43088", -- [34]
			"43087:8609:43107", -- [35]
			"2299:2941:1573:43290:43295", -- [36]
			"2299:2941:1573:43290", -- [37]
			"43072:43371", -- [38]
			"2299:44410:44409:1572:2835:43570", -- [39]
			"2299:2941:1573:43701", -- [40]
			"2299:44410:44409:1572:43702", -- [41]
			"43072:43371:931:2409:43697", -- [42]
			"2299:44410:44407:12617:44231", -- [43]
			"2299:44410:44409", -- [44]
			"2299:44410", -- [45]
			"2299:44410:44407", -- [46]
			"2299:44410:44409:1572:2835:8018:46006", -- [47]
			"2299:44410:44409:1572:2835:8018:46006:46011", -- [48]
			"2299:44410:44409:1572:41321:41322:47121", -- [49]
			"2299:44410:44409:1572:47119", -- [50]
			"2299:44410:44409:1572:41321:41322:47121:47154:47118", -- [51]
			"2299:44410:44409:1572:47119:47147", -- [52]
			"2299:44410:44409:1572:41321:41322:47121:47154", -- [53]
			"2299:44410:44409:1572:41321:41322:47121:47154:47155", -- [54]
			"2299:44410:44409:1572:2835:8018:46006:46011:47875", -- [55]
			"2299:2941:47927", -- [56]
			"2299:48321:48318", -- [57]
			"2299:48321", -- [58]
			["direct"] = "2299:43072:43087",
			["f"] = 0,
			["m"] = 38,
			["coord"] = 3098287836,
		},
		[44409] = {
			"44410:2299:352", -- [1]
			"44410:2299:931:523", -- [2]
			"44410:2299:931", -- [3]
			"1572:1573", -- [4]
			"1572:1571", -- [5]
			"44410:2299:931:2409", -- [6]
			"1572:2835", -- [7]
			"44410:2299:931:2409:43045:2859", -- [8]
			"1572:2835:8018", -- [9]
			"44410:2299:43086:43087:8609", -- [10]
			"1572:2835:8018:12596", -- [11]
			"44407:12617", -- [12]
			"44410:2299", -- [13]
			"1572:2941", -- [14]
			"44407:12617:44230:44233", -- [15]
			"44407:12617:44230:28621", -- [16]
			"44407:12617:44230", -- [17]
			"1572:2835:8018:12596:37888:44232", -- [18]
			"44410:2299:931:2409:43045", -- [19]
			"44407:12617:24851", -- [20]
			"44407:12617:26560", -- [21]
			"1572:2835:8018:12596:37888", -- [22]
			"1572:41321:41322:41323", -- [23]
			"1572:41321:41322", -- [24]
			"1572:41321:41322:41325", -- [25]
			"1572:41321", -- [26]
			"44407:41332", -- [27]
			"44410:2299:931:43000:42983", -- [28]
			"44410:2299:931:523:42426", -- [29]
			"44410:2299:352:42406", -- [30]
			"44410:2299:931:43000", -- [31]
			"44410:2299:931:2409:43045:43042", -- [32]
			"44410:2299:931:2409:43045:43042:43043", -- [33]
			"44410:2299:43086:43072", -- [34]
			"44410:2299:43086:43087", -- [35]
			"44410:2299:43086", -- [36]
			"44410:2299:931:43088", -- [37]
			"44410:2299:43086:43087:8609:43107", -- [38]
			"1572:1573:43290:43295", -- [39]
			"1572:1573:43290", -- [40]
			"44410:2299:931:43371", -- [41]
			"1572:2835:43570", -- [42]
			"1572:43702:43701", -- [43]
			"1572:43702", -- [44]
			"44410:2299:931:2409:43697", -- [45]
			"44407:12617:44231", -- [46]
			"1572:2835:8018:46006", -- [47]
			"1572:2835:8018:46006:46011", -- [48]
			"1572:41321:41322:47121", -- [49]
			"1572:47119", -- [50]
			"1572:41321:41322:47121:47154:47118", -- [51]
			"1572:47119:47147", -- [52]
			"1572:41321:41322:47121:47154", -- [53]
			"1572:41321:41322:47121:47154:47155", -- [54]
			"1572:2835:8018:46006:46011:47875", -- [55]
			"1572:2941:47927", -- [56]
			"44410:2299:48321:48318", -- [57]
			"44410:2299:48321", -- [58]
			["direct"] = "1572:44410:44407",
			["f"] = 0,
			["m"] = 17,
			["coord"] = 2096651414,
		},
		[43072] = {
			"43371:931:352", -- [1]
			"43371:931:523", -- [2]
			"43371:931", -- [3]
			"43371:931:2299:2941:1573", -- [4]
			"43371:931:2299:44410:44409:1572:1571", -- [5]
			"43371:931:2299:44410:44409:1572", -- [6]
			"43371:931:2409", -- [7]
			"43371:931:2299:44410:44409:1572:2835", -- [8]
			"43371:931:2409:43045:2859", -- [9]
			"43371:931:2299:44410:44409:1572:2835:8018", -- [10]
			"43086:43087:8609", -- [11]
			"43371:931:2299:44410:44409:1572:2835:8018:12596", -- [12]
			"43371:931:2299:44410:44407:12617", -- [13]
			"43371:931:2299", -- [14]
			"43371:931:2299:2941", -- [15]
			"43371:931:2299:44410:44407:12617:44230:44233", -- [16]
			"43371:931:2299:44410:44407:12617:44230:28621", -- [17]
			"43371:931:2299:44410:44407:12617:44230", -- [18]
			"43371:931:2299:44410:44407:12617:44231:44232", -- [19]
			"43371:931:2409:43045", -- [20]
			"43371:931:2299:44410:44407:12617:24851", -- [21]
			"43371:931:2299:2941:1573:26560", -- [22]
			"43371:931:2299:44410:44409:1572:2835:8018:12596:37888", -- [23]
			"43371:931:2299:44410:44409:1572:41321:41322:41323", -- [24]
			"43371:931:2299:44410:44409:1572:41321:41322", -- [25]
			"43371:931:2299:44410:44409:1572:41321:41322:41325", -- [26]
			"43371:931:2299:44410:44409:1572:41321", -- [27]
			"43371:931:2299:44410:44407:41332", -- [28]
			"43371:931:43000:42983", -- [29]
			"43371:931:523:42426", -- [30]
			"43371:931:523:42406", -- [31]
			"43371:931:43000", -- [32]
			"43371:931:2409:43045:43042", -- [33]
			"43371:931:2409:43045:43042:43043", -- [34]
			"43086:43087", -- [35]
			"43371:931:43088", -- [36]
			"43086:43087:8609:43107", -- [37]
			"43371:931:2299:2941:1573:43290:43295", -- [38]
			"43371:931:2299:2941:1573:43290", -- [39]
			"43371:931:2299:44410:44409:1572:2835:43570", -- [40]
			"43371:931:2299:2941:1573:43701", -- [41]
			"43371:931:2299:44410:44409:1572:43702", -- [42]
			"43371:931:2409:43697", -- [43]
			"43371:931:2299:44410:44407:12617:44231", -- [44]
			"43371:931:2299:44410:44409", -- [45]
			"43371:931:2299:44410", -- [46]
			"43371:931:2299:44410:44407", -- [47]
			"43371:931:2299:44410:44409:1572:2835:8018:46006", -- [48]
			"43371:931:2299:44410:44409:1572:2835:8018:46006:46011", -- [49]
			"43371:931:2299:44410:44409:1572:41321:41322:47121", -- [50]
			"43371:931:2299:44410:44409:1572:47119", -- [51]
			"43371:931:2299:44410:44409:1572:41321:41322:47121:47154:47118", -- [52]
			"43371:931:2299:44410:44409:1572:47119:47147", -- [53]
			"43371:931:2299:44410:44409:1572:41321:41322:47121:47154", -- [54]
			"43371:931:2299:44410:44409:1572:41321:41322:47121:47154:47155", -- [55]
			"43371:931:2299:44410:44409:1572:2835:8018:46006:46011:47875", -- [56]
			"43371:931:2299:2941:47927", -- [57]
			"43371:931:2299:48321:48318", -- [58]
			"43371:931:2299:48321", -- [59]
			["direct"] = "43086:43371",
			["f"] = 0,
			["m"] = 36,
			["coord"] = 3344345212,

		},
		[43702] = {
			"1572:2941:352", -- [1]
			"1572:2941:352:523", -- [2]
			"1572:44409:44410:2299:931", -- [3]
			"1573:1571", -- [4]
			"1572:44409:44410:2299:931:2409", -- [5]
			"1572:2835", -- [6]
			"1572:2941:352:2859", -- [7]
			"1572:2835:8018", -- [8]
			"1572:44409:44410:2299:43086:43087:8609", -- [9]
			"1573:12596", -- [10]
			"1572:2835:43570:12617", -- [11]
			"1572:44409:44410:2299", -- [12]
			"1572:2941", -- [13]
			"1573:12596:46011:47875:44233", -- [14]
			"1572:2835:43570:12617:44230:28621", -- [15]
			"1572:2835:43570:12617:44230", -- [16]
			"1573:12596:37888:44232", -- [17]
			"1572:2941:352:43045", -- [18]
			"1572:2835:43570:12617:24851", -- [19]
			"1573:26560", -- [20]
			"1573:12596:37888", -- [21]
			"1572:41321:41322:41323", -- [22]
			"1572:41321:41322", -- [23]
			"1572:41321:41322:41325", -- [24]
			"1572:41321", -- [25]
			"1572:41332", -- [26]
			"1572:2941:352:42983", -- [27]
			"1572:2941:352:523:42426", -- [28]
			"1572:2941:352:42406", -- [29]
			"1572:44409:44410:2299:931:43000", -- [30]
			"1572:2941:352:43045:43042", -- [31]
			"1572:2941:352:43045:43042:43043", -- [32]
			"1572:44409:44410:2299:43086:43072", -- [33]
			"1572:44409:44410:2299:43086:43087", -- [34]
			"1572:44409:44410:2299:43086", -- [35]
			"1572:44409:44410:2299:931:43088", -- [36]
			"1572:44409:44410:2299:43086:43087:8609:43107", -- [37]
			"1573:43290:43295", -- [38]
			"1573:43290", -- [39]
			"1572:44409:44410:2299:931:43371", -- [40]
			"1572:2835:43570", -- [41]
			"1572:2941:352:523:43697", -- [42]
			"1572:2835:43570:12617:44231", -- [43]
			"1572:44409", -- [44]
			"1572:44409:44410", -- [45]
			"1572:44409:44407", -- [46]
			"1573:12596:46006", -- [47]
			"1573:12596:46011", -- [48]
			"1572:41321:41322:47121", -- [49]
			"1572:47119", -- [50]
			"1572:41321:41322:47121:47154:47118", -- [51]
			"1572:47119:47147", -- [52]
			"1572:41321:41322:47121:47154", -- [53]
			"1572:41321:41322:47121:47154:47155", -- [54]
			"1573:12596:46011:47875", -- [55]
			"1572:2941:47927", -- [56]
			"1572:2941:47927:48318", -- [57]
			"1572:44409:44410:2299:48321", -- [58]
			["direct"] = "1573:1572:43701",
			["f"] = 0,
			["m"] = 27,
			["coord"] = 3258354468,
		},
		[47927] = {
			"2941:352", -- [1]
			"2941:352:523", -- [2]
			"2941:2299:931", -- [3]
			"2941:1573", -- [4]
			"2941:1573:1571", -- [5]
			"2941:1572", -- [6]
			"2941:2299:931:2409", -- [7]
			"2941:1572:2835", -- [8]
			"2941:352:2859", -- [9]
			"2941:1572:2835:8018", -- [10]
			"2941:2299:43086:43087:8609", -- [11]
			"2941:1573:12596", -- [12]
			"2941:1572:2835:43570:12617", -- [13]
			"2941:2299", -- [14]
			"2941:1573:12596:46011:47875:44233", -- [15]
			"2941:1572:2835:43570:12617:44230:28621", -- [16]
			"2941:1572:2835:43570:12617:44230", -- [17]
			"2941:1573:12596:37888:44232", -- [18]
			"2941:352:43045", -- [19]
			"2941:1572:2835:43570:12617:24851", -- [20]
			"2941:1573:26560", -- [21]
			"2941:1573:12596:37888", -- [22]
			"2941:1572:41321:41322:41323", -- [23]
			"2941:1572:41321:41322", -- [24]
			"2941:1572:41321:41322:41325", -- [25]
			"2941:1572:41321", -- [26]
			"2941:1572:41332", -- [27]
			"2941:352:42983", -- [28]
			"2941:352:523:42426", -- [29]
			"2941:352:42406", -- [30]
			"2941:2299:931:43000", -- [31]
			"2941:352:43045:43042", -- [32]
			"2941:352:43045:43042:43043", -- [33]
			"2941:2299:43086:43072", -- [34]
			"2941:2299:43086:43087", -- [35]
			"2941:2299:43086", -- [36]
			"2941:2299:931:43088", -- [37]
			"2941:2299:43086:43087:8609:43107", -- [38]
			"2941:1573:43290:43295", -- [39]
			"2941:1573:43290", -- [40]
			"2941:2299:931:43371", -- [41]
			"2941:1572:2835:43570", -- [42]
			"2941:1573:43701", -- [43]
			"2941:1572:43702", -- [44]
			"2941:352:523:43697", -- [45]
			"2941:1572:2835:43570:12617:44231", -- [46]
			"2941:1572:44409", -- [47]
			"2941:2299:44410", -- [48]
			"2941:1572:44409:44407", -- [49]
			"2941:1573:12596:46006", -- [50]
			"2941:1573:12596:46011", -- [51]
			"2941:1572:41321:41322:47121", -- [52]
			"2941:1572:47119", -- [53]
			"2941:1572:41321:41322:47121:47154:47118", -- [54]
			"2941:1572:47119:47147", -- [55]
			"2941:1572:41321:41322:47121:47154", -- [56]
			"2941:1572:41321:41322:47121:47154:47155", -- [57]
			"2941:1573:12596:46011:47875", -- [58]
			"48318:48321", -- [59]
			["direct"] = "2941:48318",
			["f"] = 0,
			["m"] = 28,
			["coord"] = 1758834705,
		},
		[8018] = {
			"2835:1572:2941:352", -- [1]
			"2835:1572:2941:352:523", -- [2]
			"2835:1572:44409:44410:2299:931", -- [3]
			"2835:1571", -- [4]
			"2835:1572", -- [5]
			"2835:1572:44409:44410:2299:931:2409", -- [6]
			"2835:1572:2941:352:2859", -- [7]
			"2835:1572:44409:44410:2299:43086:43087:8609", -- [8]
			"2835:1572:44409:44410:2299", -- [9]
			"2835:1572:2941", -- [10]
			"46006:46011:47875:44233", -- [11]
			"12617:44230:28621", -- [12]
			"12617:44230", -- [13]
			"12596:37888:44232", -- [14]
			"2835:1572:2941:352:43045", -- [15]
			"12617:24851", -- [16]
			"12617:26560", -- [17]
			"12596:37888", -- [18]
			"2835:41325:41323", -- [19]
			"2835:41325:41322", -- [20]
			"2835:41325", -- [21]
			"2835:41325:41322:41321", -- [22]
			"2835:1572:41332", -- [23]
			"2835:1572:2941:352:42983", -- [24]
			"2835:1572:2941:352:523:42426", -- [25]
			"2835:1572:2941:352:42406", -- [26]
			"2835:1572:44409:44410:2299:931:43000", -- [27]
			"2835:1572:2941:352:43045:43042", -- [28]
			"2835:1572:2941:352:43045:43042:43043", -- [29]
			"2835:1572:44409:44410:2299:43086:43072", -- [30]
			"2835:1572:44409:44410:2299:43086:43087", -- [31]
			"2835:1572:44409:44410:2299:43086", -- [32]
			"2835:1572:44409:44410:2299:931:43088", -- [33]
			"2835:1572:44409:44410:2299:43086:43087:8609:43107", -- [34]
			"1573:43290:43295", -- [35]
			"1573:43290", -- [36]
			"2835:1572:44409:44410:2299:931:43371", -- [37]
			"1573:43701", -- [38]
			"2835:1572:43702", -- [39]
			"2835:1572:2941:352:523:43697", -- [40]
			"12596:37888:44232:44231", -- [41]
			"2835:1572:44409", -- [42]
			"2835:1572:44409:44410", -- [43]
			"2835:1572:44409:44407", -- [44]
			"46006:46011", -- [45]
			"2835:47121", -- [46]
			"2835:47121:47154:47147:47119", -- [47]
			"2835:47121:47154:47118", -- [48]
			"2835:47121:47154:47147", -- [49]
			"2835:47121:47154", -- [50]
			"2835:47121:47154:47155", -- [51]
			"46006:46011:47875", -- [52]
			"2835:1572:2941:47927", -- [53]
			"2835:1572:2941:47927:48318", -- [54]
			"2835:1572:44409:44410:2299:48321", -- [55]
			["direct"] = "1573:2835:12596:12617:43570:46006",
			["f"] = 0,
			["m"] = 26,
			["coord"] = 477197820,
		},
		[43371] = {
			"931:352", -- [1]
			"931:523", -- [2]
			"931:2299:2941:1573", -- [3]
			"931:2299:44410:44409:1572:1571", -- [4]
			"931:2299:44410:44409:1572", -- [5]
			"931:2409", -- [6]
			"931:2299:44410:44409:1572:2835", -- [7]
			"931:2409:43045:2859", -- [8]
			"931:2299:44410:44409:1572:2835:8018", -- [9]
			"43072:43086:43087:8609", -- [10]
			"931:2299:44410:44409:1572:2835:8018:12596", -- [11]
			"931:2299:44410:44407:12617", -- [12]
			"931:2299", -- [13]
			"931:2299:2941", -- [14]
			"931:2299:44410:44407:12617:44230:44233", -- [15]
			"931:2299:44410:44407:12617:44230:28621", -- [16]
			"931:2299:44410:44407:12617:44230", -- [17]
			"931:2299:44410:44407:12617:44231:44232", -- [18]
			"931:2409:43045", -- [19]
			"931:2299:44410:44407:12617:24851", -- [20]
			"931:2299:2941:1573:26560", -- [21]
			"931:2299:44410:44409:1572:2835:8018:12596:37888", -- [22]
			"931:2299:44410:44409:1572:41321:41322:41323", -- [23]
			"931:2299:44410:44409:1572:41321:41322", -- [24]
			"931:2299:44410:44409:1572:41321:41322:41325", -- [25]
			"931:2299:44410:44409:1572:41321", -- [26]
			"931:2299:44410:44407:41332", -- [27]
			"931:43000:42983", -- [28]
			"931:523:42426", -- [29]
			"931:523:42406", -- [30]
			"931:43000", -- [31]
			"931:2409:43045:43042", -- [32]
			"931:2409:43045:43042:43043", -- [33]
			"43072:43086:43087", -- [34]
			"43072:43086", -- [35]
			"931:43088", -- [36]
			"43072:43086:43087:8609:43107", -- [37]
			"931:2299:2941:1573:43290:43295", -- [38]
			"931:2299:2941:1573:43290", -- [39]
			"931:2299:44410:44409:1572:2835:43570", -- [40]
			"931:2299:2941:1573:43701", -- [41]
			"931:2299:44410:44409:1572:43702", -- [42]
			"931:2409:43697", -- [43]
			"931:2299:44410:44407:12617:44231", -- [44]
			"931:2299:44410:44409", -- [45]
			"931:2299:44410", -- [46]
			"931:2299:44410:44407", -- [47]
			"931:2299:44410:44409:1572:2835:8018:46006", -- [48]
			"931:2299:44410:44409:1572:2835:8018:46006:46011", -- [49]
			"931:2299:44410:44409:1572:41321:41322:47121", -- [50]
			"931:2299:44410:44409:1572:47119", -- [51]
			"931:2299:44410:44409:1572:41321:41322:47121:47154:47118", -- [52]
			"931:2299:44410:44409:1572:47119:47147", -- [53]
			"931:2299:44410:44409:1572:41321:41322:47121:47154", -- [54]
			"931:2299:44410:44409:1572:41321:41322:47121:47154:47155", -- [55]
			"931:2299:44410:44409:1572:2835:8018:46006:46011:47875", -- [56]
			"931:2299:2941:47927", -- [57]
			"931:2299:48321:48318", -- [58]
			"931:2299:48321", -- [59]
			["direct"] = "931:43072",
			["f"] = 0,
			["m"] = 36,
			["coord"] = 2270268245,
		},
		[1572] = {
			"2941:352", -- [1]
			"2941:352:523", -- [2]
			"44409:44410:2299:931", -- [3]
			"44409:44410:2299:931:2409", -- [4]
			"2941:352:2859", -- [5]
			"2835:8018", -- [6]
			"44409:44410:2299:43086:43087:8609", -- [7]
			"2835:8018:12596", -- [8]
			"2835:43570:12617", -- [9]
			"44409:44410:2299", -- [10]
			"2835:43570:12617:44230:44233", -- [11]
			"2835:43570:12617:44230:28621", -- [12]
			"2835:43570:12617:44230", -- [13]
			"2835:8018:12596:37888:44232", -- [14]
			"2941:352:43045", -- [15]
			"2835:43570:12617:24851", -- [16]
			"2835:43570:12617:26560", -- [17]
			"2835:8018:12596:37888", -- [18]
			"41321:41322:41323", -- [19]
			"41321:41322", -- [20]
			"41321:41322:41325", -- [21]
			"2941:352:42983", -- [22]
			"2941:352:523:42426", -- [23]
			"2941:352:42406", -- [24]
			"44409:44410:2299:931:43000", -- [25]
			"2941:352:43045:43042", -- [26]
			"2941:352:43045:43042:43043", -- [27]
			"44409:44410:2299:43086:43072", -- [28]
			"44409:44410:2299:43086:43087", -- [29]
			"44409:44410:2299:43086", -- [30]
			"44409:44410:2299:931:43088", -- [31]
			"44409:44410:2299:43086:43087:8609:43107", -- [32]
			"1573:43290:43295", -- [33]
			"1573:43290", -- [34]
			"44409:44410:2299:931:43371", -- [35]
			"2835:43570", -- [36]
			"43702:43701", -- [37]
			"2941:352:523:43697", -- [38]
			"2835:43570:12617:44231", -- [39]
			"44409:44410", -- [40]
			"44409:44407", -- [41]
			"2835:8018:46006", -- [42]
			"2835:8018:46006:46011", -- [43]
			"41321:41322:47121", -- [44]
			"41321:41322:47121:47154:47118", -- [45]
			"47119:47147", -- [46]
			"41321:41322:47121:47154", -- [47]
			"41321:41322:47121:47154:47155", -- [48]
			"2835:8018:46006:46011:47875", -- [49]
			"2941:47927", -- [50]
			"2941:47927:48318", -- [51]
			"44409:44410:2299:48321", -- [52]
			["direct"] = "1573:1571:2835:2941:41321:41332:43702:44409:47119",
			["coord"] = 1457816072,
			["m"] = 35,
			["f"] = 0,
		},
		[44407] = {
			"44410:2299:352", -- [1]
			"44410:2299:931:523", -- [2]
			"44410:2299:931", -- [3]
			"44409:1572:1573", -- [4]
			"44409:1572:1571", -- [5]
			"44409:1572", -- [6]
			"44410:2299:931:2409", -- [7]
			"44409:1572:2835", -- [8]
			"44410:2299:931:2409:43045:2859", -- [9]
			"44409:1572:2835:8018", -- [10]
			"44410:2299:43086:43087:8609", -- [11]
			"44409:1572:2835:8018:12596", -- [12]
			"44410:2299", -- [13]
			"44409:1572:2941", -- [14]
			"12617:44230:44233", -- [15]
			"12617:44230:28621", -- [16]
			"12617:44230", -- [17]
			"12617:44231:44232", -- [18]
			"44410:2299:931:2409:43045", -- [19]
			"12617:24851", -- [20]
			"12617:26560", -- [21]
			"44409:1572:2835:8018:12596:37888", -- [22]
			"44409:1572:41321:41322:41323", -- [23]
			"44409:1572:41321:41322", -- [24]
			"44409:1572:41321:41322:41325", -- [25]
			"44409:1572:41321", -- [26]
			"44410:2299:931:43000:42983", -- [27]
			"44410:2299:931:523:42426", -- [28]
			"44410:2299:352:42406", -- [29]
			"44410:2299:931:43000", -- [30]
			"44410:2299:931:2409:43045:43042", -- [31]
			"44410:2299:931:2409:43045:43042:43043", -- [32]
			"44410:2299:43086:43072", -- [33]
			"44410:2299:43086:43087", -- [34]
			"44410:2299:43086", -- [35]
			"44410:2299:931:43088", -- [36]
			"44410:2299:43086:43087:8609:43107", -- [37]
			"44409:1572:1573:43290:43295", -- [38]
			"44409:1572:1573:43290", -- [39]
			"44410:2299:931:43371", -- [40]
			"44409:1572:2835:43570", -- [41]
			"44409:1572:43702:43701", -- [42]
			"44409:1572:43702", -- [43]
			"44410:2299:931:2409:43697", -- [44]
			"12617:44231", -- [45]
			"44409:1572:2835:8018:46006", -- [46]
			"44409:1572:2835:8018:46006:46011", -- [47]
			"44409:1572:41321:41322:47121", -- [48]
			"44409:1572:47119", -- [49]
			"44409:1572:41321:41322:47121:47154:47118", -- [50]
			"44409:1572:47119:47147", -- [51]
			"44409:1572:41321:41322:47121:47154", -- [52]
			"44409:1572:41321:41322:47121:47154:47155", -- [53]
			"44409:1572:2835:8018:46006:46011:47875", -- [54]
			"44409:1572:2941:47927", -- [55]
			"44410:2299:48321:48318", -- [56]
			"44410:2299:48321", -- [57]
			["direct"] = "12617:41332:44409:44410",
			["f"] = 0,
			["m"] = 17,
			["coord"] = 2759547441,
		},
		[41322] = {
			"41321:1572:2941:352", -- [1]
			"41321:1572:2941:352:523", -- [2]
			"41321:1572:44409:44410:2299:931", -- [3]
			"41323:1571:1573", -- [4]
			"41323:1571", -- [5]
			"41321:1572", -- [6]
			"41321:1572:44409:44410:2299:931:2409", -- [7]
			"41325:2835", -- [8]
			"41321:1572:2941:352:2859", -- [9]
			"41325:2835:8018", -- [10]
			"41321:1572:44409:44410:2299:43086:43087:8609", -- [11]
			"41325:2835:8018:12596", -- [12]
			"41325:2835:43570:12617", -- [13]
			"41321:1572:44409:44410:2299", -- [14]
			"41321:1572:2941", -- [15]
			"41325:2835:43570:12617:44230:44233", -- [16]
			"41325:2835:43570:12617:44230:28621", -- [17]
			"41325:2835:43570:12617:44230", -- [18]
			"41325:2835:8018:12596:37888:44232", -- [19]
			"41321:1572:2941:352:43045", -- [20]
			"41325:2835:43570:12617:24851", -- [21]
			"41325:2835:43570:12617:26560", -- [22]
			"41325:2835:8018:12596:37888", -- [23]
			"41321:1572:41332", -- [24]
			"41321:1572:2941:352:42983", -- [25]
			"41321:1572:2941:352:523:42426", -- [26]
			"41321:1572:2941:352:42406", -- [27]
			"41321:1572:44409:44410:2299:931:43000", -- [28]
			"41321:1572:2941:352:43045:43042", -- [29]
			"41321:1572:2941:352:43045:43042:43043", -- [30]
			"41321:1572:44409:44410:2299:43086:43072", -- [31]
			"41321:1572:44409:44410:2299:43086:43087", -- [32]
			"41321:1572:44409:44410:2299:43086", -- [33]
			"41321:1572:44409:44410:2299:931:43088", -- [34]
			"41321:1572:44409:44410:2299:43086:43087:8609:43107", -- [35]
			"41323:1571:1573:43290:43295", -- [36]
			"41323:1571:1573:43290", -- [37]
			"41321:1572:44409:44410:2299:931:43371", -- [38]
			"41325:2835:43570", -- [39]
			"41321:1572:43702:43701", -- [40]
			"41321:1572:43702", -- [41]
			"41321:1572:2941:352:523:43697", -- [42]
			"41325:2835:43570:12617:44231", -- [43]
			"41321:1572:44409", -- [44]
			"41321:1572:44409:44410", -- [45]
			"41321:1572:44409:44407", -- [46]
			"41325:2835:8018:46006", -- [47]
			"41325:2835:8018:46006:46011", -- [48]
			"47121:47154:47147:47119", -- [49]
			"47121:47154:47118", -- [50]
			"47121:47154:47147", -- [51]
			"47121:47154", -- [52]
			"47121:47154:47155", -- [53]
			"41325:2835:8018:46006:46011:47875", -- [54]
			"41321:1572:2941:47927", -- [55]
			"41321:1572:2941:47927:48318", -- [56]
			"41321:1572:44409:44410:2299:48321", -- [57]
			["direct"] = "41323:41325:41321:47121",
			["f"] = 0,
			["m"] = 40,
			["coord"] = 2418961311,
		},
		[43088] = {
			"931:352", -- [1]
			"931:523", -- [2]
			"931:2299:2941:1573", -- [3]
			"931:2299:44410:44409:1572:1571", -- [4]
			"931:2299:44410:44409:1572", -- [5]
			"931:2409", -- [6]
			"931:2299:44410:44409:1572:2835", -- [7]
			"931:2409:43045:2859", -- [8]
			"931:2299:44410:44409:1572:2835:8018", -- [9]
			"43087:8609", -- [10]
			"931:2299:44410:44409:1572:2835:8018:12596", -- [11]
			"931:2299:44410:44407:12617", -- [12]
			"931:2299", -- [13]
			"931:2299:2941", -- [14]
			"931:2299:44410:44407:12617:44230:44233", -- [15]
			"931:2299:44410:44407:12617:44230:28621", -- [16]
			"931:2299:44410:44407:12617:44230", -- [17]
			"931:2299:44410:44407:12617:44231:44232", -- [18]
			"931:2409:43045", -- [19]
			"931:2299:44410:44407:12617:24851", -- [20]
			"931:2299:2941:1573:26560", -- [21]
			"931:2299:44410:44409:1572:2835:8018:12596:37888", -- [22]
			"931:2299:44410:44409:1572:41321:41322:41323", -- [23]
			"931:2299:44410:44409:1572:41321:41322", -- [24]
			"931:2299:44410:44409:1572:41321:41322:41325", -- [25]
			"931:2299:44410:44409:1572:41321", -- [26]
			"931:2299:44410:44407:41332", -- [27]
			"931:43000:42983", -- [28]
			"931:523:42426", -- [29]
			"931:523:42406", -- [30]
			"931:43000", -- [31]
			"931:2409:43045:43042", -- [32]
			"931:2409:43045:43042:43043", -- [33]
			"931:43371:43072", -- [34]
			"43087:43086", -- [35]
			"43087:8609:43107", -- [36]
			"931:2299:2941:1573:43290:43295", -- [37]
			"931:2299:2941:1573:43290", -- [38]
			"931:43371", -- [39]
			"931:2299:44410:44409:1572:2835:43570", -- [40]
			"931:2299:2941:1573:43701", -- [41]
			"931:2299:44410:44409:1572:43702", -- [42]
			"931:2409:43697", -- [43]
			"931:2299:44410:44407:12617:44231", -- [44]
			"931:2299:44410:44409", -- [45]
			"931:2299:44410", -- [46]
			"931:2299:44410:44407", -- [47]
			"931:2299:44410:44409:1572:2835:8018:46006", -- [48]
			"931:2299:44410:44409:1572:2835:8018:46006:46011", -- [49]
			"931:2299:44410:44409:1572:41321:41322:47121", -- [50]
			"931:2299:44410:44409:1572:47119", -- [51]
			"931:2299:44410:44409:1572:41321:41322:47121:47154:47118", -- [52]
			"931:2299:44410:44409:1572:47119:47147", -- [53]
			"931:2299:44410:44409:1572:41321:41322:47121:47154", -- [54]
			"931:2299:44410:44409:1572:41321:41322:47121:47154:47155", -- [55]
			"931:2299:44410:44409:1572:2835:8018:46006:46011:47875", -- [56]
			"931:2299:2941:47927", -- [57]
			"931:2299:48321:48318", -- [58]
			"931:2299:48321", -- [59]
			["direct"] = "931:43087",
			["f"] = 0,
			["m"] = 38,
			["coord"] = 1320573246,
		},
		[44410] = {
			"2299:352", -- [1]
			"2299:931:523", -- [2]
			"2299:931", -- [3]
			"44409:1572:1573", -- [4]
			"44409:1572:1571", -- [5]
			"44409:1572", -- [6]
			"2299:931:2409", -- [7]
			"44409:1572:2835", -- [8]
			"2299:931:2409:43045:2859", -- [9]
			"44409:1572:2835:8018", -- [10]
			"2299:43086:43087:8609", -- [11]
			"44409:1572:2835:8018:12596", -- [12]
			"44407:12617", -- [13]
			"2299:2941", -- [14]
			"44407:12617:44230:44233", -- [15]
			"44407:12617:44230:28621", -- [16]
			"44407:12617:44230", -- [17]
			"44407:12617:44231:44232", -- [18]
			"2299:931:2409:43045", -- [19]
			"44407:12617:24851", -- [20]
			"44407:12617:26560", -- [21]
			"44409:1572:2835:8018:12596:37888", -- [22]
			"44409:1572:41321:41322:41323", -- [23]
			"44409:1572:41321:41322", -- [24]
			"44409:1572:41321:41322:41325", -- [25]
			"44409:1572:41321", -- [26]
			"44407:41332", -- [27]
			"2299:931:43000:42983", -- [28]
			"2299:931:523:42426", -- [29]
			"2299:352:42406", -- [30]
			"2299:931:43000", -- [31]
			"2299:931:2409:43045:43042", -- [32]
			"2299:931:2409:43045:43042:43043", -- [33]
			"2299:43086:43072", -- [34]
			"2299:43086:43087", -- [35]
			"2299:43086", -- [36]
			"2299:931:43088", -- [37]
			"2299:43086:43087:8609:43107", -- [38]
			"44409:1572:1573:43290:43295", -- [39]
			"44409:1572:1573:43290", -- [40]
			"2299:931:43371", -- [41]
			"44409:1572:2835:43570", -- [42]
			"44409:1572:43702:43701", -- [43]
			"44409:1572:43702", -- [44]
			"2299:931:2409:43697", -- [45]
			"44407:12617:44231", -- [46]
			"44409:1572:2835:8018:46006", -- [47]
			"44409:1572:2835:8018:46006:46011", -- [48]
			"44409:1572:41321:41322:47121", -- [49]
			"44409:1572:47119", -- [50]
			"44409:1572:41321:41322:47121:47154:47118", -- [51]
			"44409:1572:47119:47147", -- [52]
			"44409:1572:41321:41322:47121:47154", -- [53]
			"44409:1572:41321:41322:47121:47154:47155", -- [54]
			"44409:1572:2835:8018:46006:46011:47875", -- [55]
			"2299:2941:47927", -- [56]
			"2299:48321:48318", -- [57]
			"2299:48321", -- [58]
			["direct"] = "2299:44409:44407",
			["f"] = 0,
			["m"] = 17,
			["coord"] = 935302067,
		},
		[48321] = {
			"2299:352", -- [1]
			"2299:931:523", -- [2]
			"2299:931", -- [3]
			"48318:47927:2941:1573", -- [4]
			"48318:47927:2941:1573:1571", -- [5]
			"2299:44410:44409:1572", -- [6]
			"2299:931:2409", -- [7]
			"2299:44410:44409:1572:2835", -- [8]
			"2299:931:2409:43045:2859", -- [9]
			"2299:44410:44409:1572:2835:8018", -- [10]
			"2299:43086:43087:8609", -- [11]
			"48318:47927:2941:1573:12596", -- [12]
			"2299:44410:44407:12617", -- [13]
			"48318:47927:2941", -- [14]
			"2299:44410:44407:12617:44230:44233", -- [15]
			"2299:44410:44407:12617:44230:28621", -- [16]
			"2299:44410:44407:12617:44230", -- [17]
			"48318:47927:2941:1573:12596:37888:44232", -- [18]
			"2299:931:2409:43045", -- [19]
			"2299:44410:44407:12617:24851", -- [20]
			"48318:47927:2941:1573:26560", -- [21]
			"48318:47927:2941:1573:12596:37888", -- [22]
			"2299:44410:44409:1572:41321:41322:41323", -- [23]
			"2299:44410:44409:1572:41321:41322", -- [24]
			"2299:44410:44409:1572:41321:41322:41325", -- [25]
			"2299:44410:44409:1572:41321", -- [26]
			"2299:44410:44407:41332", -- [27]
			"2299:931:43000:42983", -- [28]
			"2299:931:523:42426", -- [29]
			"2299:352:42406", -- [30]
			"2299:931:43000", -- [31]
			"2299:931:2409:43045:43042", -- [32]
			"2299:931:2409:43045:43042:43043", -- [33]
			"2299:43086:43072", -- [34]
			"2299:43086:43087", -- [35]
			"2299:43086", -- [36]
			"2299:931:43088", -- [37]

			"2299:43086:43087:8609:43107", -- [38]
			"48318:47927:2941:1573:43290:43295", -- [39]
			"48318:47927:2941:1573:43290", -- [40]
			"2299:931:43371", -- [41]
			"2299:44410:44409:1572:2835:43570", -- [42]
			"48318:47927:2941:1573:43701", -- [43]
			"2299:44410:44409:1572:43702", -- [44]
			"2299:931:2409:43697", -- [45]
			"2299:44410:44407:12617:44231", -- [46]
			"2299:44410:44409", -- [47]
			"2299:44410", -- [48]
			"2299:44410:44407", -- [49]
			"48318:47927:2941:1573:12596:46006", -- [50]
			"48318:47927:2941:1573:12596:46011", -- [51]
			"2299:44410:44409:1572:41321:41322:47121", -- [52]
			"2299:44410:44409:1572:47119", -- [53]
			"2299:44410:44409:1572:41321:41322:47121:47154:47118", -- [54]
			"2299:44410:44409:1572:47119:47147", -- [55]
			"2299:44410:44409:1572:41321:41322:47121:47154", -- [56]
			"2299:44410:44409:1572:41321:41322:47121:47154:47155", -- [57]
			"48318:47927:2941:1573:12596:46011:47875", -- [58]
			"48318:47927", -- [59]
			["direct"] = "2299:48318",
			["f"] = 0,
			["m"] = 29,
			["coord"] = 1982491478,
		},
		[12596] = {
			"1573:2941:352", -- [1]
			"1573:2941:352:523", -- [2]
			"1573:2941:2299:931", -- [3]
			"8018:2835:1571", -- [4]
			"8018:2835:1572", -- [5]
			"1573:2941:2299:931:2409", -- [6]
			"8018:2835", -- [7]
			"1573:2941:352:2859", -- [8]
			"1573:2941:2299:43086:43087:8609", -- [9]
			"1573:2941:2299", -- [10]
			"1573:2941", -- [11]
			"46011:47875:44233", -- [12]
			"37888:44232:28621", -- [13]
			"37888:44232:44231:44230", -- [14]
			"37888:44232", -- [15]
			"1573:2941:352:43045", -- [16]
			"12617:24851", -- [17]
			"12617:26560", -- [18]
			"8018:2835:41325:41323", -- [19]
			"8018:2835:41325:41322", -- [20]
			"8018:2835:41325", -- [21]
			"8018:2835:41325:41322:41321", -- [22]
			"8018:2835:1572:41332", -- [23]
			"1573:2941:352:42983", -- [24]
			"1573:2941:352:523:42426", -- [25]
			"1573:2941:352:42406", -- [26]
			"1573:2941:2299:931:43000", -- [27]
			"1573:2941:352:43045:43042", -- [28]
			"1573:2941:352:43045:43042:43043", -- [29]
			"1573:2941:2299:43086:43072", -- [30]
			"1573:2941:2299:43086:43087", -- [31]
			"1573:2941:2299:43086", -- [32]
			"1573:2941:2299:931:43088", -- [33]
			"1573:2941:2299:43086:43087:8609:43107", -- [34]
			"1573:43290:43295", -- [35]
			"1573:43290", -- [36]
			"1573:2941:2299:931:43371", -- [37]
			"8018:43570", -- [38]
			"1573:43701", -- [39]
			"1573:43702", -- [40]
			"1573:2941:352:523:43697", -- [41]
			"37888:44232:44231", -- [42]
			"8018:2835:1572:44409", -- [43]
			"8018:2835:1572:44409:44410", -- [44]
			"8018:2835:1572:44409:44407", -- [45]
			"8018:2835:47121", -- [46]
			"8018:2835:47121:47154:47147:47119", -- [47]
			"8018:2835:47121:47154:47118", -- [48]
			"8018:2835:47121:47154:47147", -- [49]
			"8018:2835:47121:47154", -- [50]
			"8018:2835:47121:47154:47155", -- [51]
			"46011:47875", -- [52]
			"1573:2941:47927", -- [53]
			"1573:2941:47927:48318", -- [54]
			"1573:2941:47927:48318:48321", -- [55]
			["direct"] = "1573:8018:12617:37888:46006:46011",
			["f"] = 0,
			["m"] = 22,
			["coord"] = 1844631931,
		},
		[41332] = {
			"1572:2941:352", -- [1]
			"1572:2941:352:523", -- [2]
			"44407:44410:2299:931", -- [3]
			"1572:1573", -- [4]
			"1572:1571", -- [5]
			"44407:44410:2299:931:2409", -- [6]
			"1572:2835", -- [7]
			"44407:44410:2299:931:2409:43045:2859", -- [8]
			"1572:2835:8018", -- [9]
			"44407:44410:2299:43086:43087:8609", -- [10]
			"1572:2835:8018:12596", -- [11]
			"1572:2835:43570:12617", -- [12]
			"44407:44410:2299", -- [13]
			"1572:2941", -- [14]
			"1572:2835:43570:12617:44230:44233", -- [15]
			"1572:2835:43570:12617:44230:28621", -- [16]
			"1572:2835:43570:12617:44230", -- [17]
			"1572:2835:8018:12596:37888:44232", -- [18]
			"44407:44410:2299:931:2409:43045", -- [19]
			"1572:2835:43570:12617:24851", -- [20]
			"1572:2835:43570:12617:26560", -- [21]
			"1572:2835:8018:12596:37888", -- [22]
			"1572:41321:41322:41323", -- [23]
			"1572:41321:41322", -- [24]
			"1572:41321:41322:41325", -- [25]
			"1572:41321", -- [26]
			"1572:2941:352:42983", -- [27]
			"1572:2941:352:523:42426", -- [28]
			"1572:2941:352:42406", -- [29]
			"44407:44410:2299:931:43000", -- [30]
			"44407:44410:2299:931:2409:43045:43042", -- [31]
			"44407:44410:2299:931:2409:43045:43042:43043", -- [32]
			"44407:44410:2299:43086:43072", -- [33]
			"44407:44410:2299:43086:43087", -- [34]
			"44407:44410:2299:43086", -- [35]
			"44407:44410:2299:931:43088", -- [36]
			"44407:44410:2299:43086:43087:8609:43107", -- [37]
			"1572:1573:43290:43295", -- [38]
			"1572:1573:43290", -- [39]
			"44407:44410:2299:931:43371", -- [40]
			"1572:2835:43570", -- [41]
			"1572:43702:43701", -- [42]
			"1572:43702", -- [43]
			"44407:44410:2299:931:2409:43697", -- [44]
			"1572:2835:43570:12617:44231", -- [45]
			"44407:44409", -- [46]
			"44407:44410", -- [47]
			"1572:2835:8018:46006", -- [48]
			"1572:2835:8018:46006:46011", -- [49]
			"1572:41321:41322:47121", -- [50]
			"1572:47119", -- [51]
			"1572:41321:41322:47121:47154:47118", -- [52]
			"1572:47119:47147", -- [53]
			"1572:41321:41322:47121:47154", -- [54]
			"1572:41321:41322:47121:47154:47155", -- [55]
			"1572:2835:8018:46006:46011:47875", -- [56]
			"1572:2941:47927", -- [57]
			"1572:2941:47927:48318", -- [58]
			"44407:44410:2299:48321", -- [59]
			["direct"] = "1572:44407",
			["coord"] = 3518538834,
			["m"] = 35,
			["f"] = 0,
		},
		[44232] = {
			"37888:12596:1573:2941:352", -- [1]
			"37888:12596:1573:2941:352:523", -- [2]
			"44231:12617:44407:44410:2299:931", -- [3]
			"37888:12596:1573", -- [4]
			"37888:12596:8018:2835:1571", -- [5]
			"37888:12596:8018:2835:1572", -- [6]
			"44231:12617:44407:44410:2299:931:2409", -- [7]
			"37888:12596:8018:2835", -- [8]
			"37888:12596:1573:2941:352:2859", -- [9]
			"37888:12596:8018", -- [10]
			"44231:12617:44407:44410:2299:43086:43087:8609", -- [11]
			"37888:12596", -- [12]
			"44231:12617", -- [13]
			"44231:12617:44407:44410:2299", -- [14]
			"37888:12596:1573:2941", -- [15]
			"44231:44230", -- [16]
			"37888:12596:1573:2941:352:43045", -- [17]
			"44231:12617:24851", -- [18]
			"44231:12617:26560", -- [19]
			"37888:12596:8018:2835:41325:41323", -- [20]
			"37888:12596:8018:2835:41325:41322", -- [21]
			"37888:12596:8018:2835:41325", -- [22]
			"37888:12596:8018:2835:41325:41322:41321", -- [23]
			"44231:12617:44407:41332", -- [24]
			"37888:12596:1573:2941:352:42983", -- [25]
			"37888:12596:1573:2941:352:523:42426", -- [26]
			"37888:12596:1573:2941:352:42406", -- [27]
			"44231:12617:44407:44410:2299:931:43000", -- [28]
			"37888:12596:1573:2941:352:43045:43042", -- [29]
			"37888:12596:1573:2941:352:43045:43042:43043", -- [30]
			"44231:12617:44407:44410:2299:43086:43072", -- [31]
			"44231:12617:44407:44410:2299:43086:43087", -- [32]
			"44231:12617:44407:44410:2299:43086", -- [33]
			"44231:12617:44407:44410:2299:931:43088", -- [34]
			"44231:12617:44407:44410:2299:43086:43087:8609:43107", -- [35]
			"37888:12596:1573:43290:43295", -- [36]
			"37888:12596:1573:43290", -- [37]
			"44231:12617:44407:44410:2299:931:43371", -- [38]
			"37888:43570", -- [39]
			"37888:12596:1573:43701", -- [40]
			"37888:12596:1573:43702", -- [41]
			"37888:12596:1573:2941:352:523:43697", -- [42]
			"44231:12617:44407:44409", -- [43]
			"44231:12617:44407:44410", -- [44]
			"44231:12617:44407", -- [45]
			"37888:46011:46006", -- [46]
			"37888:46011", -- [47]
			"37888:12596:8018:2835:47121", -- [48]
			"37888:12596:8018:2835:47121:47154:47147:47119", -- [49]
			"37888:12596:8018:2835:47121:47154:47118", -- [50]
			"37888:12596:8018:2835:47121:47154:47147", -- [51]
			"37888:12596:8018:2835:47121:47154", -- [52]
			"37888:12596:8018:2835:47121:47154:47155", -- [53]
			"44233:47875", -- [54]
			"37888:12596:1573:2941:47927", -- [55]
			"37888:12596:1573:2941:47927:48318", -- [56]
			"37888:12596:1573:2941:47927:48318:48321", -- [57]
			["direct"] = "44233:28621:37888:44231",
			["f"] = 0,
			["m"] = 23,
			["coord"] = 1497804314,
		},
		[42406] = {
			"523:931", -- [1]
			"352:1573", -- [2]
			"352:1573:1571", -- [3]
			"352:2941:1572", -- [4]
			"523:2409", -- [5]
			"352:2941:1572:2835", -- [6]
			"523:43045:2859", -- [7]
			"352:1573:8018", -- [8]
			"523:2409:8609", -- [9]
			"352:1573:12596", -- [10]
			"352:2941:1572:2835:43570:12617", -- [11]
			"352:2299", -- [12]
			"352:2941", -- [13]
			"352:1573:12596:46011:47875:44233", -- [14]
			"352:2941:1572:2835:43570:12617:44230:28621", -- [15]
			"352:2941:1572:2835:43570:12617:44230", -- [16]
			"352:1573:12596:37888:44232", -- [17]
			"523:43045", -- [18]
			"352:2941:1572:2835:43570:12617:24851", -- [19]
			"352:1573:26560", -- [20]
			"352:1573:12596:37888", -- [21]
			"352:2941:1572:41321:41322:41323", -- [22]
			"352:2941:1572:41321:41322", -- [23]
			"352:2941:1572:41321:41322:41325", -- [24]
			"352:2941:1572:41321", -- [25]
			"352:2941:1572:41332", -- [26]
			"352:42983", -- [27]
			"523:42426", -- [28]
			"352:42983:43000", -- [29]
			"523:43045:43042", -- [30]
			"523:43045:43042:43043", -- [31]
			"523:931:43371:43072", -- [32]
			"523:931:43088:43087", -- [33]
			"523:931:43371:43072:43086", -- [34]
			"523:931:43088", -- [35]
			"523:2409:8609:43107", -- [36]
			"352:1573:43290:43295", -- [37]
			"352:1573:43290", -- [38]
			"523:931:43371", -- [39]
			"352:2941:1572:2835:43570", -- [40]
			"352:1573:43701", -- [41]
			"352:1573:43702", -- [42]
			"523:43697", -- [43]
			"352:2941:1572:2835:43570:12617:44231", -- [44]
			"352:2299:44410:44409", -- [45]
			"352:2299:44410", -- [46]
			"352:2299:44410:44407", -- [47]
			"352:1573:12596:46006", -- [48]
			"352:1573:12596:46011", -- [49]
			"352:2941:1572:41321:41322:47121", -- [50]
			"352:2941:1572:47119", -- [51]
			"352:2941:1572:41321:41322:47121:47154:47118", -- [52]
			"352:2941:1572:47119:47147", -- [53]
			"352:2941:1572:41321:41322:47121:47154", -- [54]
			"352:2941:1572:41321:41322:47121:47154:47155", -- [55]
			"352:1573:12596:46011:47875", -- [56]
			"352:2941:47927", -- [57]
			"352:2941:47927:48318", -- [58]
			"352:2299:48321", -- [59]
			["direct"] = "352:523",
			["f"] = 0,
			["m"] = 39,
			["coord"] = 2138517532,
		},
		[48318] = {
			"47927:2941:352", -- [1]
			"48321:2299:931:523", -- [2]
			"48321:2299:931", -- [3]
			"47927:2941:1573", -- [4]
			"47927:2941:1573:1571", -- [5]
			"47927:2941:1572", -- [6]
			"48321:2299:931:2409", -- [7]
			"47927:2941:1572:2835", -- [8]
			"48321:2299:931:2409:43045:2859", -- [9]
			"47927:2941:1572:2835:8018", -- [10]
			"48321:2299:43086:43087:8609", -- [11]
			"47927:2941:1573:12596", -- [12]
			"47927:2941:1572:2835:43570:12617", -- [13]
			"48321:2299", -- [14]
			"47927:2941", -- [15]
			"47927:2941:1573:12596:46011:47875:44233", -- [16]
			"47927:2941:1572:2835:43570:12617:44230:28621", -- [17]
			"47927:2941:1572:2835:43570:12617:44230", -- [18]
			"47927:2941:1573:12596:37888:44232", -- [19]
			"48321:2299:931:2409:43045", -- [20]
			"47927:2941:1572:2835:43570:12617:24851", -- [21]
			"47927:2941:1573:26560", -- [22]
			"47927:2941:1573:12596:37888", -- [23]
			"47927:2941:1572:41321:41322:41323", -- [24]
			"47927:2941:1572:41321:41322", -- [25]
			"47927:2941:1572:41321:41322:41325", -- [26]
			"47927:2941:1572:41321", -- [27]
			"47927:2941:1572:41332", -- [28]
			"48321:2299:931:43000:42983", -- [29]
			"48321:2299:931:523:42426", -- [30]
			"47927:2941:352:42406", -- [31]
			"48321:2299:931:43000", -- [32]
			"48321:2299:931:2409:43045:43042", -- [33]
			"48321:2299:931:2409:43045:43042:43043", -- [34]
			"48321:2299:43086:43072", -- [35]
			"48321:2299:43086:43087", -- [36]
			"48321:2299:43086", -- [37]
			"48321:2299:931:43088", -- [38]
			"48321:2299:43086:43087:8609:43107", -- [39]
			"47927:2941:1573:43290:43295", -- [40]
			"47927:2941:1573:43290", -- [41]
			"48321:2299:931:43371", -- [42]
			"47927:2941:1572:2835:43570", -- [43]
			"47927:2941:1573:43701", -- [44]
			"47927:2941:1572:43702", -- [45]
			"48321:2299:931:2409:43697", -- [46]
			"47927:2941:1572:2835:43570:12617:44231", -- [47]
			"48321:2299:44410:44409", -- [48]
			"48321:2299:44410", -- [49]
			"48321:2299:44410:44407", -- [50]
			"47927:2941:1573:12596:46006", -- [51]
			"47927:2941:1573:12596:46011", -- [52]
			"47927:2941:1572:41321:41322:47121", -- [53]
			"47927:2941:1572:47119", -- [54]
			"47927:2941:1572:41321:41322:47121:47154:47118", -- [55]
			"47927:2941:1572:47119:47147", -- [56]
			"47927:2941:1572:41321:41322:47121:47154", -- [57]
			"47927:2941:1572:41321:41322:47121:47154:47155", -- [58]
			"47927:2941:1573:12596:46011:47875", -- [59]
			["direct"] = "47927:48321",
			["f"] = 0,
			["m"] = 29,
			["coord"] = 760383217,
		},
		[41323] = {
			"41322:41321:1572:2941:352", -- [1]
			"41322:41321:1572:2941:352:523", -- [2]
			"41322:41321:1572:44409:44410:2299:931", -- [3]
			"1571:1573", -- [4]
			"41322:41321:1572", -- [5]
			"41322:41321:1572:44409:44410:2299:931:2409", -- [6]
			"41325:2835", -- [7]
			"41322:41321:1572:2941:352:2859", -- [8]
			"41325:2835:8018", -- [9]
			"41322:41321:1572:44409:44410:2299:43086:43087:8609", -- [10]
			"41325:2835:8018:12596", -- [11]
			"41325:2835:43570:12617", -- [12]
			"41322:41321:1572:44409:44410:2299", -- [13]
			"41322:41321:1572:2941", -- [14]
			"41325:2835:43570:12617:44230:44233", -- [15]
			"41325:2835:43570:12617:44230:28621", -- [16]
			"41325:2835:43570:12617:44230", -- [17]
			"41325:2835:8018:12596:37888:44232", -- [18]
			"41322:41321:1572:2941:352:43045", -- [19]
			"41325:2835:43570:12617:24851", -- [20]
			"41325:2835:43570:12617:26560", -- [21]
			"41325:2835:8018:12596:37888", -- [22]
			"41322:41321", -- [23]
			"41322:41321:1572:41332", -- [24]
			"41322:41321:1572:2941:352:42983", -- [25]
			"41322:41321:1572:2941:352:523:42426", -- [26]
			"41322:41321:1572:2941:352:42406", -- [27]
			"41322:41321:1572:44409:44410:2299:931:43000", -- [28]
			"41322:41321:1572:2941:352:43045:43042", -- [29]
			"41322:41321:1572:2941:352:43045:43042:43043", -- [30]
			"41322:41321:1572:44409:44410:2299:43086:43072", -- [31]
			"41322:41321:1572:44409:44410:2299:43086:43087", -- [32]
			"41322:41321:1572:44409:44410:2299:43086", -- [33]
			"41322:41321:1572:44409:44410:2299:931:43088", -- [34]
			"41322:41321:1572:44409:44410:2299:43086:43087:8609:43107", -- [35]
			"1571:1573:43290:43295", -- [36]
			"1571:1573:43290", -- [37]
			"41322:41321:1572:44409:44410:2299:931:43371", -- [38]
			"41325:2835:43570", -- [39]
			"1571:1573:43701", -- [40]
			"41322:41321:1572:43702", -- [41]
			"41322:41321:1572:2941:352:523:43697", -- [42]
			"41325:2835:43570:12617:44231", -- [43]
			"41322:41321:1572:44409", -- [44]
			"41322:41321:1572:44409:44410", -- [45]
			"41322:41321:1572:44409:44407", -- [46]
			"41325:2835:8018:46006", -- [47]
			"41325:2835:8018:46006:46011", -- [48]
			"41322:47121", -- [49]
			"41322:47121:47154:47147:47119", -- [50]
			"41322:47121:47154:47118", -- [51]
			"41322:47121:47154:47147", -- [52]
			"41322:47121:47154", -- [53]
			"41322:47121:47154:47155", -- [54]
			"41325:2835:8018:46006:46011:47875", -- [55]
			"41322:41321:1572:2941:47927", -- [56]
			"41322:41321:1572:2941:47927:48318", -- [57]
			"41322:41321:1572:44409:44410:2299:48321", -- [58]
			["direct"] = "1571:41322:41325",
			["f"] = 0,
			["m"] = 40,
			["coord"] = 1661625304,
		},
		[43043] = {
			"43042:43045:352", -- [1]
			"43042:43045:523", -- [2]
			"43042:43045:2409:931", -- [3]
			"43042:43045:352:1573", -- [4]
			"43042:43045:352:1573:1571", -- [5]
			"43042:43045:2409:931:2299:44410:44409:1572", -- [6]
			"43042:43045:2409", -- [7]
			"43042:43045:2409:931:2299:44410:44409:1572:2835", -- [8]
			"43042:43045:2409:931:2299:44410:44409:1572:2835:8018", -- [9]
			"43042:43045:2409:8609", -- [10]
			"43042:43045:352:1573:12596", -- [11]
			"43042:43045:2409:931:2299:44410:44407:12617", -- [12]
			"43042:43045:2409:931:2299", -- [13]
			"43042:43045:352:2941", -- [14]
			"43042:43045:2409:931:2299:44410:44407:12617:44230:44233", -- [15]
			"43042:43045:2409:931:2299:44410:44407:12617:44230:28621", -- [16]
			"43042:43045:2409:931:2299:44410:44407:12617:44230", -- [17]
			"43042:43045:352:1573:12596:37888:44232", -- [18]
			"43042:43045", -- [19]
			"43042:43045:2409:931:2299:44410:44407:12617:24851", -- [20]
			"43042:43045:352:1573:26560", -- [21]
			"43042:43045:352:1573:12596:37888", -- [22]
			"43042:43045:2409:931:2299:44410:44409:1572:41321:41322:41323", -- [23]
			"43042:43045:2409:931:2299:44410:44409:1572:41321:41322", -- [24]
			"43042:43045:2409:931:2299:44410:44409:1572:41321:41322:41325", -- [25]
			"43042:43045:2409:931:2299:44410:44409:1572:41321", -- [26]
			"43042:43045:2409:931:2299:44410:44407:41332", -- [27]
			"43042:43045:2409:42983", -- [28]
			"43042:43045:523:42426", -- [29]
			"43042:43045:523:42406", -- [30]
			"43042:43045:2409:931:43000", -- [31]
			"43042:43045:2409:931:43371:43072", -- [32]
			"43042:43045:2409:8609:43087", -- [33]
			"43042:43045:2409:931:43371:43072:43086", -- [34]
			"43042:43045:2409:931:43088", -- [35]
			"2859:43107", -- [36]
			"43042:43045:352:1573:43290:43295", -- [37]
			"43042:43045:352:1573:43290", -- [38]
			"43042:43045:2409:931:43371", -- [39]
			"43042:43045:2409:931:2299:44410:44409:1572:2835:43570", -- [40]
			"43042:43045:352:1573:43701", -- [41]
			"43042:43045:2409:931:2299:44410:44409:1572:43702", -- [42]
			"43042:43045:43697", -- [43]
			"43042:43045:2409:931:2299:44410:44407:12617:44231", -- [44]
			"43042:43045:2409:931:2299:44410:44409", -- [45]
			"43042:43045:2409:931:2299:44410", -- [46]
			"43042:43045:2409:931:2299:44410:44407", -- [47]
			"43042:43045:352:1573:12596:46006", -- [48]
			"43042:43045:352:1573:12596:46011", -- [49]
			"43042:43045:2409:931:2299:44410:44409:1572:41321:41322:47121", -- [50]
			"43042:43045:2409:931:2299:44410:44409:1572:47119", -- [51]
			"43042:43045:2409:931:2299:44410:44409:1572:41321:41322:47121:47154:47118", -- [52]
			"43042:43045:2409:931:2299:44410:44409:1572:47119:47147", -- [53]
			"43042:43045:2409:931:2299:44410:44409:1572:41321:41322:47121:47154", -- [54]
			"43042:43045:2409:931:2299:44410:44409:1572:41321:41322:47121:47154:47155", -- [55]
			"43042:43045:352:1573:12596:46011:47875", -- [56]
			"43042:43045:352:2941:47927", -- [57]
			"43042:43045:2409:931:2299:48321:48318", -- [58]
			"43042:43045:2409:931:2299:48321", -- [59]
			["direct"] = "2859:43042",
			["coord"] = 2390452617,
			["m"] = 673,
			["f"] = 0,
		},
		[43045] = {
			"2409:931", -- [1]
			"352:1573", -- [2]
			"352:1573:1571", -- [3]
			"2409:931:2299:44410:44409:1572", -- [4]
			"2409:931:2299:44410:44409:1572:2835", -- [5]
			"2409:931:2299:44410:44409:1572:2835:8018", -- [6]
			"2409:8609", -- [7]
			"352:1573:12596", -- [8]
			"2409:931:2299:44410:44407:12617", -- [9]
			"2409:931:2299", -- [10]
			"352:2941", -- [11]
			"2409:931:2299:44410:44407:12617:44230:44233", -- [12]
			"2409:931:2299:44410:44407:12617:44230:28621", -- [13]
			"2409:931:2299:44410:44407:12617:44230", -- [14]
			"352:1573:12596:37888:44232", -- [15]
			"2409:931:2299:44410:44407:12617:24851", -- [16]
			"352:1573:26560", -- [17]
			"352:1573:12596:37888", -- [18]
			"2409:931:2299:44410:44409:1572:41321:41322:41323", -- [19]
			"2409:931:2299:44410:44409:1572:41321:41322", -- [20]
			"2409:931:2299:44410:44409:1572:41321:41322:41325", -- [21]
			"2409:931:2299:44410:44409:1572:41321", -- [22]
			"2409:931:2299:44410:44407:41332", -- [23]
			"2409:42983", -- [24]
			"523:42426", -- [25]
			"523:42406", -- [26]
			"2409:931:43000", -- [27]
			"43042:43043", -- [28]
			"2409:931:43371:43072", -- [29]
			"2409:8609:43087", -- [30]
			"2409:931:43371:43072:43086", -- [31]
			"2409:931:43088", -- [32]
			"2409:8609:43107", -- [33]
			"352:1573:43290:43295", -- [34]
			"352:1573:43290", -- [35]
			"2409:931:43371", -- [36]
			"2409:931:2299:44410:44409:1572:2835:43570", -- [37]
			"352:1573:43701", -- [38]
			"2409:931:2299:44410:44409:1572:43702", -- [39]
			"2409:931:2299:44410:44407:12617:44231", -- [40]
			"2409:931:2299:44410:44409", -- [41]
			"2409:931:2299:44410", -- [42]
			"2409:931:2299:44410:44407", -- [43]
			"352:1573:12596:46006", -- [44]
			"352:1573:12596:46011", -- [45]
			"2409:931:2299:44410:44409:1572:41321:41322:47121", -- [46]
			"2409:931:2299:44410:44409:1572:47119", -- [47]
			"2409:931:2299:44410:44409:1572:41321:41322:47121:47154:47118", -- [48]
			"2409:931:2299:44410:44409:1572:47119:47147", -- [49]
			"2409:931:2299:44410:44409:1572:41321:41322:47121:47154", -- [50]
			"2409:931:2299:44410:44409:1572:41321:41322:47121:47154:47155", -- [51]
			"352:1573:12596:46011:47875", -- [52]
			"352:2941:47927", -- [53]
			"2409:931:2299:48321:48318", -- [54]
			"2409:931:2299:48321", -- [55]
			["direct"] = "352:523:2409:2859:43042:43697",
			["coord"] = 2053775016,
			["m"] = 37,
			["f"] = 0,
		},
		[352] = {
			"1573:1571", -- [1]
			"2941:1572", -- [2]
			"2941:1572:2835", -- [3]
			"1573:8018", -- [4]
			"1573:12596", -- [5]
			"2941:1572:2835:43570:12617", -- [6]
			"1573:12596:46011:47875:44233", -- [7]
			"2941:1572:2835:43570:12617:44230:28621", -- [8]
			"2941:1572:2835:43570:12617:44230", -- [9]
			"1573:12596:37888:44232", -- [10]
			"2941:1572:2835:43570:12617:24851", -- [11]
			"1573:26560", -- [12]
			"1573:12596:37888", -- [13]
			"2941:1572:41321:41322:41323", -- [14]
			"2941:1572:41321:41322", -- [15]
			"2941:1572:41321:41322:41325", -- [16]
			"2941:1572:41321", -- [17]
			"2941:1572:41332", -- [18]
			"523:42426", -- [19]
			"42983:43000", -- [20]
			"43045:43042", -- [21]
			"43045:43042:43043", -- [22]
			"931:43371:43072", -- [23]
			"931:43088:43087", -- [24]
			"931:43371:43072:43086", -- [25]
			"931:43088", -- [26]
			"8609:43107", -- [27]
			"1573:43290:43295", -- [28]
			"1573:43290", -- [29]
			"931:43371", -- [30]
			"2941:1572:2835:43570", -- [31]
			"1573:43701", -- [32]
			"1573:43702", -- [33]
			"523:43697", -- [34]
			"2941:1572:2835:43570:12617:44231", -- [35]
			"2299:44410:44409", -- [36]
			"2299:44410", -- [37]
			"2299:44410:44407", -- [38]
			"1573:12596:46006", -- [39]
			"1573:12596:46011", -- [40]
			"2941:1572:41321:41322:47121", -- [41]
			"2941:1572:47119", -- [42]
			"2941:1572:41321:41322:47121:47154:47118", -- [43]
			"2941:1572:47119:47147", -- [44]
			"2941:1572:41321:41322:47121:47154", -- [45]
			"2941:1572:41321:41322:47121:47154:47155", -- [46]
			"1573:12596:46011:47875", -- [47]
			"2941:47927", -- [48]
			"2941:47927:48318", -- [49]
			"2299:48321", -- [50]
			["direct"] = "523:931:1573:2409:2859:8609:2299:2941:43045:42983:42406",
			["f"] = 0,
			["m"] = 301,
			["coord"] = 3048585708,
		},
		[28621] = {
			"44232:37888:12596:1573:2941:352", -- [1]
			"44230:12617:44407:44410:2299:931:523", -- [2]
			"44230:12617:44407:44410:2299:931", -- [3]
			"44232:37888:12596:1573", -- [4]
			"44230:12617:43570:2835:1571", -- [5]
			"44230:12617:43570:2835:1572", -- [6]
			"44230:12617:44407:44410:2299:931:2409", -- [7]
			"44230:12617:43570:2835", -- [8]
			"44230:12617:44407:44410:2299:931:2409:43045:2859", -- [9]
			"44232:37888:12596:8018", -- [10]
			"44230:12617:44407:44410:2299:43086:43087:8609", -- [11]
			"44232:37888:12596", -- [12]
			"44230:12617", -- [13]
			"44230:12617:44407:44410:2299", -- [14]
			"44232:37888:12596:1573:2941", -- [15]
			"44230:12617:44407:44410:2299:931:2409:43045", -- [16]
			"44230:12617:24851", -- [17]
			"44230:12617:26560", -- [18]
			"44232:37888", -- [19]
			"44230:12617:43570:2835:41325:41323", -- [20]
			"44230:12617:43570:2835:41325:41322", -- [21]
			"44230:12617:43570:2835:41325", -- [22]
			"44230:12617:43570:2835:41325:41322:41321", -- [23]
			"44230:12617:44407:41332", -- [24]
			"44230:12617:44407:44410:2299:931:43000:42983", -- [25]
			"44230:12617:44407:44410:2299:931:523:42426", -- [26]
			"44232:37888:12596:1573:2941:352:42406", -- [27]
			"44230:12617:44407:44410:2299:931:43000", -- [28]
			"44230:12617:44407:44410:2299:931:2409:43045:43042", -- [29]
			"44230:12617:44407:44410:2299:931:2409:43045:43042:43043", -- [30]
			"44230:12617:44407:44410:2299:43086:43072", -- [31]
			"44230:12617:44407:44410:2299:43086:43087", -- [32]
			"44230:12617:44407:44410:2299:43086", -- [33]
			"44230:12617:44407:44410:2299:931:43088", -- [34]
			"44230:12617:44407:44410:2299:43086:43087:8609:43107", -- [35]
			"44232:37888:12596:1573:43290:43295", -- [36]
			"44232:37888:12596:1573:43290", -- [37]
			"44230:12617:44407:44410:2299:931:43371", -- [38]
			"44230:12617:43570", -- [39]
			"44232:37888:12596:1573:43701", -- [40]
			"44232:37888:12596:1573:43702", -- [41]
			"44230:12617:44407:44410:2299:931:2409:43697", -- [42]
			"44230:44231", -- [43]
			"44230:12617:44407:44409", -- [44]
			"44230:12617:44407:44410", -- [45]
			"44230:12617:44407", -- [46]
			"44232:37888:46011:46006", -- [47]
			"44232:37888:46011", -- [48]
			"44230:12617:43570:2835:47121", -- [49]
			"44230:12617:43570:2835:47121:47154:47147:47119", -- [50]
			"44230:12617:43570:2835:47121:47154:47118", -- [51]
			"44230:12617:43570:2835:47121:47154:47147", -- [52]
			"44230:12617:43570:2835:47121:47154", -- [53]
			"44230:12617:43570:2835:47121:47154:47155", -- [54]
			"44233:47875", -- [55]
			"44232:37888:12596:1573:2941:47927", -- [56]
			"44232:37888:12596:1573:2941:47927:48318", -- [57]
			"44230:12617:44407:44410:2299:48321", -- [58]
			["direct"] = "44233:44230:44232",
			["coord"] = 2202482249,
			["m"] = 23,
			["f"] = 0,
		},	
	},
	{
		[22485] = {
			"18788:18785:16822", -- [1]
			"18788:18785", -- [2]
			"18788:18789", -- [3]
			"18788:18940:18809", -- [4]
			"18937:18938", -- [5]
			"18788:18940:18809:18939", -- [6]
			"18788:18940", -- [7]
			"18788:18785:16822:18931", -- [8]
			"18937:19583", -- [9]
			"18788:18940:18809:18939:19581", -- [10]
			"18788:18785:16822:20234", -- [11]
			"18937:18938:20515", -- [12]
			"18788:21107", -- [13]
			"18937:22216", -- [14]
			["direct"] = "18788:18937",
			["coord"] = 1773488635,
			["m"] = 467,
			["f"] = 0,
		},
		[21107] = {
			"18788:18785:16822", -- [1]
			"18788:18785", -- [2]
			"18788:18789", -- [3]
			"18788:18940:18809", -- [4]
			"18788:18940:18809:18939", -- [5]
			"18788:18940", -- [6]
			"18788:18785:16822:18931", -- [7]
			"18938:19583", -- [8]
			"18788:18940:18809:18939:19581", -- [9]
			"18788:18785:16822:20234", -- [10]
			"18938:20515", -- [11]
			"18788:22485", -- [12]
			["direct"] = "18788:18938:18937:22216",
			["coord"] = 2623648913,
			["m"] = 475,
			["f"] = 0,
		},
		[18938] = {
			"21107:18788:18785:16822", -- [1]
			"21107:18788:18785", -- [2]
			"21107:18788", -- [3]
			"21107:18788:18789", -- [4]
			"21107:18788:18940:18809", -- [5]
			"21107:18788:18940:18809:18939", -- [6]
			"21107:18788:18940", -- [7]
			"21107:18788:18785:16822:18931", -- [8]
			"21107:18788:18940:18809:18939:19581", -- [9]
			"21107:18788:18785:16822:20234", -- [10]
			"18937:22485", -- [11]
			["direct"] = "18937:19583:20515:21107:22216",
			["coord"] = 1451467664,
			["m"] = 479,
			["f"] = 0,
		},
		[18939] = {
			"18809:16822", -- [1]
			"18809:16822:18785", -- [2]
			"18809:18940:18788", -- [3]
			"18809:18789", -- [4]
			"18809:18940:18788:21107:18938", -- [5]
			"18809:18940:18788:18937", -- [6]
			"18809:18940", -- [7]
			"18809:16822:18931", -- [8]
			"18809:18940:18788:21107:18938:19583", -- [9]
			"18809:16822:20234", -- [10]
			"18809:18940:18788:21107:18938:20515", -- [11]
			"18809:18940:18788:21107", -- [12]
			"18809:18940:18788:21107:22216", -- [13]
			"18809:18940:18788:22485", -- [14]
			["direct"] = "18809:19581",
			["coord"] = 1615302149,
			["m"] = 473,
			["f"] = 0,
		},
		[18940] = {
			"18788:18785", -- [1]
			"18788:21107:18938", -- [2]
			"18809:18939", -- [3]
			"18788:18937", -- [4]
			"16822:18931", -- [5]
			"18788:21107:18938:19583", -- [6]
			"18809:18939:19581", -- [7]
			"16822:20234", -- [8]
			"18788:21107:18938:20515", -- [9]
			"18788:21107", -- [10]
			"18788:21107:22216", -- [11]
			"18788:22485", -- [12]
			["direct"] = "16822:18788:18789:18809",
			["coord"] = 2743757380,
			["m"] = 481,
			["f"] = 0,
		},
		[18788] = {
			"18785:16822", -- [1]
			"18940:18809", -- [2]
			"21107:18938", -- [3]
			"18940:18809:18939", -- [4]
			"18785:16822:18931", -- [5]
			"21107:18938:19583", -- [6]
			"18940:18809:18939:19581", -- [7]
			"18785:16822:20234", -- [8]
			"21107:18938:20515", -- [9]
			"21107:22216", -- [10]
			["direct"] = "18785:18789:18937:18940:21107:22485",
			["f"] = 0,
			["m"] = 467,
			["coord"] = 2914485116,
		},
		[18789] = {
			"18940:16822", -- [1]
			"18788:18785", -- [2]
			"18788:21107:18938", -- [3]
			"18809:18939", -- [4]
			"18788:18937", -- [5]
			"18940:16822:18931", -- [6]
			"18788:21107:18938:19583", -- [7]
			"18809:18939:19581", -- [8]
			"18940:16822:20234", -- [9]
			"18788:21107:18938:20515", -- [10]
			"18788:21107", -- [11]
			"18788:21107:22216", -- [12]
			"18788:22485", -- [13]
			["direct"] = "18788:18809:18940",
			["coord"] = 2325856347,
			["m"] = 477,
			["f"] = 0,
		},
		[16822] = {
			"18785:18788", -- [1]
			"18940:18789", -- [2]
			"18785:18788:21107:18938", -- [3]
			"18809:18939", -- [4]
			"18785:18788:18937", -- [5]
			"18785:18788:21107:18938:19583", -- [6]
			"18809:18939:19581", -- [7]
			"18785:18788:21107:18938:20515", -- [8]
			"18785:18788:21107", -- [9]
			"18785:18788:21107:22216", -- [10]
			"18785:18788:22485", -- [11]
			["direct"] = "18785:18809:18940:18931:20234",
			["f"] = 0,
			["m"] = 465,
			["coord"] = 2347147235,
		},
		[22216] = {
			"21107:18788:18785:16822", -- [1]
			"21107:18788:18785", -- [2]
			"21107:18788", -- [3]
			"21107:18788:18789", -- [4]
			"21107:18788:18940:18809", -- [5]
			"21107:18788:18940:18809:18939", -- [6]
			"21107:18788:18940", -- [7]
			"21107:18788:18785:16822:18931", -- [8]
			"18938:19583", -- [9]
			"21107:18788:18940:18809:18939:19581", -- [10]
			"21107:18788:18785:16822:20234", -- [11]
			"18938:20515", -- [12]
			"18937:22485", -- [13]
			["direct"] = "18938:18937:21107",
			["coord"] = 2648008034,
			["m"] = 475,
			["f"] = 0,
		},
		[18931] = {
			"18785:18788", -- [1]
			"16822:18940:18789", -- [2]
			"16822:18809", -- [3]
			"18785:18788:21107:18938", -- [4]
			"16822:18809:18939", -- [5]
			"18785:18788:18937", -- [6]
			"16822:18940", -- [7]
			"18785:18788:21107:18938:19583", -- [8]
			"16822:18809:18939:19581", -- [9]
			"18785:18788:21107:18938:20515", -- [10]
			"18785:18788:21107", -- [11]
			"18785:18788:21107:22216", -- [12]
			"18785:18788:22485", -- [13]
			["direct"] = "16822:18785:20234",
			["f"] = 0,
			["m"] = 465,
			["coord"] = 3755968055,
		},
		[19583] = {
			"18938:21107:18788:18785:16822", -- [1]
			"18938:21107:18788:18785", -- [2]
			"18938:21107:18788", -- [3]
			"18938:21107:18788:18789", -- [4]
			"18938:21107:18788:18940:18809", -- [5]
			"18938:21107:18788:18940:18809:18939", -- [6]
			"18938:21107:18788:18940", -- [7]
			"18938:21107:18788:18785:16822:18931", -- [8]
			"18938:21107:18788:18940:18809:18939:19581", -- [9]
			"18938:21107:18788:18785:16822:20234", -- [10]
			"18938:21107", -- [11]
			"18938:22216", -- [12]
			"18937:22485", -- [13]
			["direct"] = "18938:18937:20515",
			["f"] = 0,
			["m"] = 479,
			["coord"] = 1944213875,
		},
		[20234] = {
			"16822:18785", -- [1]
			"16822:18785:18788", -- [2]
			"16822:18940:18789", -- [3]
			"16822:18809", -- [4]
			"16822:18785:18788:21107:18938", -- [5]
			"16822:18809:18939", -- [6]
			"16822:18785:18788:18937", -- [7]
			"16822:18940", -- [8]
			"16822:18785:18788:21107:18938:19583", -- [9]
			"16822:18809:18939:19581", -- [10]
			"16822:18785:18788:21107:18938:20515", -- [11]
			"16822:18785:18788:21107", -- [12]
			"16822:18785:18788:21107:22216", -- [13]
			"16822:18785:18788:22485", -- [14]
			["direct"] = "16822:18931",
			["f"] = 0,
			["m"] = 465,
			["coord"] = 3370277268,
		},
		[18937] = {
			"18788:18785:16822", -- [1]
			"18788:18785", -- [2]
			"18788:18789", -- [3]
			"18788:18940:18809", -- [4]
			"18788:18940:18809:18939", -- [5]
			"18788:18940", -- [6]
			"18788:18785:16822:18931", -- [7]
			"18788:18940:18809:18939:19581", -- [8]
			"18788:18785:16822:20234", -- [9]
			"18938:20515", -- [10]
			["direct"] = "18788:18938:19583:21107:22216:22485",
			["f"] = 0,
			["m"] = 475,
			["coord"] = 1624087928,
		},
		[18809] = {
			"16822:18785", -- [1]
			"18940:18788", -- [2]
			"18940:18788:21107:18938", -- [3]
			"18940:18788:18937", -- [4]
			"16822:18931", -- [5]
			"18940:18788:21107:18938:19583", -- [6]
			"18939:19581", -- [7]
			"16822:20234", -- [8]
			"18940:18788:21107:18938:20515", -- [9]
			"18940:18788:21107", -- [10]
			"18940:18788:21107:22216", -- [11]
			"18940:18788:22485", -- [12]
			["direct"] = "16822:18789:18939:18940",
			["coord"] = 2554891688,
			["m"] = 478,
			["f"] = 0,
		},
		[18785] = {
			"18788:18789", -- [1]
			"16822:18809", -- [2]
			"18788:21107:18938", -- [3]
			"16822:18809:18939", -- [4]
			"18788:18937", -- [5]
			"18788:18940", -- [6]
			"16822:18931", -- [7]
			"18788:21107:18938:19583", -- [8]
			"16822:18809:18939:19581", -- [9]
			"16822:20234", -- [10]
			"18788:21107:18938:20515", -- [11]
			"18788:21107", -- [12]
			"18788:21107:22216", -- [13]
			"18788:22485", -- [14]
			["direct"] = "16822:18788",
			["f"] = 0,
			["m"] = 465,
			["coord"] = 1079467854,
		},
		[20515] = {
			"18938:21107:18788:18785:16822", -- [1]
			"18938:21107:18788:18785", -- [2]
			"18938:21107:18788", -- [3]
			"18938:21107:18788:18789", -- [4]
			"18938:21107:18788:18940:18809", -- [5]
			"18938:21107:18788:18940:18809:18939", -- [6]
			"18938:18937", -- [7]
			"18938:21107:18788:18940", -- [8]
			"18938:21107:18788:18785:16822:18931", -- [9]
			"18938:21107:18788:18940:18809:18939:19581", -- [10]
			"18938:21107:18788:18785:16822:20234", -- [11]
			"18938:21107", -- [12]
			"18938:22216", -- [13]
			"18938:18937:22485", -- [14]
			["m"] = 479,
			["f"] = 0,
			["direct"] = "18938:19583",
			["coord"] = 2800462568,
		},
		[19581] = {
			"18939:18809:16822", -- [1]
			"18939:18809:16822:18785", -- [2]
			"18939:18809:18940:18788", -- [3]
			"18939:18809:18789", -- [4]
			"18939:18809", -- [5]
			"18939:18809:18940:18788:21107:18938", -- [6]
			"18939:18809:18940:18788:18937", -- [7]
			"18939:18809:18940", -- [8]
			"18939:18809:16822:18931", -- [9]
			"18939:18809:18940:18788:21107:18938:19583", -- [10]
			"18939:18809:16822:20234", -- [11]
			"18939:18809:18940:18788:21107:18938:20515", -- [12]
			"18939:18809:18940:18788:21107", -- [13]
			"18939:18809:18940:18788:21107:22216", -- [14]
			"18939:18809:18940:18788:22485", -- [15]
			["direct"] = "18939",
			["coord"] = 2718322169,
			["m"] = 473,
			["f"] = 0,
		},
	}, -- [3]
	{
		[29750] = {
			"30433:28674:23736", -- [1]
			"29721:28615:28623:26876:24061", -- [2]
			"29721:28615:26878:23859", -- [3]
			"30433:28674:26879:24795:27046", -- [4]
			"29721:28615:26878", -- [5]
			"30433:28674:26879", -- [6]
			"30433:28674:28574:26602", -- [7]
			"30433:28674:26877:26881", -- [8]
			"30433:28674:26877", -- [9]
			"29721:28615:26851", -- [10]
			"29721:28615:28618:26880", -- [11]
			"29721:28615:28623:26876", -- [12]
			"30433:28674:26879:24795", -- [13]
			"30433:28674:28196", -- [14]
			"29721:28615:26878:23859:28197", -- [15]
			"30433:28674:26877:26881:28195", -- [16]
			"30433:31069:30869", -- [17]
			"29721:28615:28623", -- [18]
			"29721:28615", -- [19]
			"29721:28615:28618", -- [20]
			"29721:28615:28623:28624", -- [21]
			"30433:28674:28574", -- [22]
			"30433:28674:28574:28037", -- [23]
			"30433:28674", -- [24]

			"29721:32571", -- [25]
			"30433:31069:31078", -- [26]
			"29721:28615:28623:28624:30569", -- [27]
			"29950:30314", -- [28]
			"30433:31069", -- [29]
			"29721:30271", -- [30]
			"29950:33849", -- [31]
			["direct"] = "29721:29951:29950:30433",
			["coord"] = 1267777152,
			["m"] = 495,
			["f"] = 0,
		},
		[26602] = {
			"28195:28196:28197:23736", -- [1]
			"26881:26878:26880:24061", -- [2]
			"26881:26878:23859", -- [3]
			"24795:27046", -- [4]
			"26881:26878", -- [5]
			"26881:26877", -- [6]
			"26881:26851", -- [7]
			"26881:26878:26880", -- [8]
			"26881:26878:26880:26876", -- [9]
			"28195:28196", -- [10]
			"28195:28196:28197", -- [11]
			"26881:30869", -- [12]
			"26881:26878:28615:28623", -- [13]
			"26881:26878:28615", -- [14]
			"26881:26878:28618", -- [15]
			"26881:26878:28615:28623:28624", -- [16]
			"28574:28674", -- [17]
			"28574:28674:29721", -- [18]
			"28574:28674:30433:29750", -- [19]
			"28574:28674:29721:32571", -- [20]
			"28574:31078", -- [21]
			"28574:31078:30314:29950:29951", -- [22]
			"28574:31078:30314:29950", -- [23]
			"26881:26878:28615:28623:28624:30569", -- [24]
			"28574:31078:30314", -- [25]
			"28574:28674:30433", -- [26]
			"28574:28674:31069", -- [27]
			"28574:28674:30271", -- [28]
			"28574:31078:30314:33849", -- [29]
			["m"] = 486,
			["f"] = 0,
			["direct"] = "26879:26881:24795:28195:28574:28037",
			["coord"] = 2427204436,
		},
		[31078] = {
			"30869:26877:26878:23859:23736", -- [1]
			"30869:26877:26878:26880:24061", -- [2]
			"30869:26877:26878:23859", -- [3]
			"28574:26602:24795:27046", -- [4]
			"30869:26877:26878", -- [5]
			"28574:26602:26879", -- [6]
			"28574:26602", -- [7]
			"30869:26881", -- [8]
			"30869:26877", -- [9]
			"30869:26877:26851", -- [10]
			"30869:26877:26878:26880", -- [11]
			"31069:30433:28674:28615:28623:26876", -- [12]
			"28574:26602:24795", -- [13]
			"30869:26881:28196", -- [14]
			"30869:26877:26878:23859:28197", -- [15]
			"28574:26602:28195", -- [16]
			"31069:30433:28674:28615:28623", -- [17]
			"31069:30433:28674:28615", -- [18]
			"31069:30433:28674:28615:28618", -- [19]
			"30314:29950:29951:28624", -- [20]
			"31069:30433:28674", -- [21]
			"31069:30433:28674:29721", -- [22]
			"31069:30433:29750", -- [23]
			"30314:29950:29951:32571", -- [24]
			"30314:29950:29951", -- [25]
			"30314:29950", -- [26]
			"30314:29950:29951:28624:30569", -- [27]
			"31069:30433", -- [28]
			"31069:30433:28674:30271", -- [29]
			"30314:33849", -- [30]
			["direct"] = "30869:28574:28037:30314:31069",
			["coord"] = 832469612,
			["m"] = 492,
			["f"] = 0,
		},
		[28623] = {
			"26876:24061:23736", -- [1]
			"26876:24061", -- [2]
			"28618:26880:23859", -- [3]
			"28615:26851:26881:26602:24795:27046", -- [4]
			"28618:26878", -- [5]
			"28615:26851:26881:26879", -- [6]
			"28615:26851:26881:26602", -- [7]
			"28615:26851:26881", -- [8]
			"28615:26877", -- [9]
			"28615:26851", -- [10]
			"28618:26880", -- [11]
			"28615:26851:26881:26602:24795", -- [12]
			"28615:26851:28196", -- [13]
			"28618:26880:23859:28197", -- [14]
			"28615:26851:26881:28195", -- [15]
			"28615:26877:30869", -- [16]
			"28615:28674:28574", -- [17]
			"28615:28674:28574:28037", -- [18]
			"28615:28674", -- [19]
			"28615:29721", -- [20]
			"28615:29721:29750", -- [21]
			"28624:32571", -- [22]
			"28615:28674:31069:31078", -- [23]
			"28624:29951", -- [24]
			"28615:29721:29750:29950", -- [25]
			"28624:30569", -- [26]
			"28615:28674:31069:30314", -- [27]
			"28615:28674:30433", -- [28]
			"28615:28674:31069", -- [29]
			"28615:30271", -- [30]
			"28615:28674:33849", -- [31]
			["direct"] = "26876:28615:28618:28624",
			["coord"] = 1782293786,
			["m"] = 496,
			["f"] = 0,
		},
		[28624] = {
			"26876:24061:23736", -- [1]
			"26876:24061", -- [2]
			"26876:26880:23859", -- [3]
			"28623:28615:26851:26881:26602:24795:27046", -- [4]
			"28623:28618:26878", -- [5]
			"28623:28615:26851:26881:26879", -- [6]
			"28623:28615:26851:26881:26602", -- [7]
			"28623:28615:26851:26881", -- [8]
			"28623:28615:26877", -- [9]
			"28623:28615:26851", -- [10]
			"26876:26880", -- [11]
			"28623:28615:26851:26881:26602:24795", -- [12]
			"28623:28615:26851:28196", -- [13]
			"26876:26880:23859:28197", -- [14]
			"28623:28615:26851:26881:28195", -- [15]
			"28623:28615:26877:30869", -- [16]
			"28623:28615", -- [17]
			"28623:28618", -- [18]
			"28623:28615:28674:28574", -- [19]
			"28623:28615:28674:28574:28037", -- [20]
			"28623:28615:28674", -- [21]
			"28623:28615:29721", -- [22]
			"28623:28615:29721:29750", -- [23]
			"28623:28615:28674:31069:31078", -- [24]
			"29951:29950", -- [25]
			"29951:29950:30314", -- [26]
			"28623:28615:28674:30433", -- [27]
			"28623:28615:28674:31069", -- [28]
			"28623:28615:30271", -- [29]
			"29951:29950:33849", -- [30]
			["m"] = 496,
			["coord"] = 2575864175,
			["direct"] = "26876:28623:32571:29951:30569",
			["f"] = 0,
		},
		[29950] = {
			"29951:28624:26876:24061:23736", -- [1]
			"29951:28624:26876:24061", -- [2]
			"29750:29721:28615:26878:23859", -- [3]
			"30314:31078:28574:26602:24795:27046", -- [4]
			"29750:29721:28615:26878", -- [5]
			"29750:30433:28674:26879", -- [6]
			"30314:31078:28574:26602", -- [7]
			"29750:30433:28674:26877:26881", -- [8]
			"29750:30433:28674:26877", -- [9]
			"29750:29721:28615:26851", -- [10]
			"29750:29721:28615:28618:26880", -- [11]
			"29951:28624:26876", -- [12]
			"30314:31078:28574:26602:24795", -- [13]
			"29750:30433:28674:28196", -- [14]
			"29750:29721:28615:26878:23859:28197", -- [15]
			"29750:30433:28674:26877:26881:28195", -- [16]
			"33849:31069:30869", -- [17]
			"29750:29721:28615:28623", -- [18]
			"29750:29721:28615", -- [19]
			"29750:29721:28615:28618", -- [20]
			"29951:28624", -- [21]
			"30314:31078:28574", -- [22]
			"30314:31078:28037", -- [23]
			"29750:30433:28674", -- [24]
			"29750:29721", -- [25]
			"29951:32571", -- [26]
			"30314:31078", -- [27]
			"29951:28624:30569", -- [28]
			"29750:30433", -- [29]
			"33849:31069", -- [30]
			"29750:29721:30271", -- [31]
			["direct"] = "29750:29951:30314:33849",
			["coord"] = 1314938152,
			["m"] = 495,
			["f"] = 0,
		},
		[29951] = {
			"28624:26876:24061:23736", -- [1]
			"28624:26876:24061", -- [2]
			"28624:26876:26880:23859", -- [3]
			"29950:30314:31078:28574:26602:24795:27046", -- [4]
			"29750:29721:28615:26878", -- [5]
			"29750:30433:28674:26879", -- [6]
			"29950:30314:31078:28574:26602", -- [7]
			"29750:30433:28674:26877:26881", -- [8]
			"29750:30433:28674:26877", -- [9]
			"29750:29721:28615:26851", -- [10]
			"28624:26876:26880", -- [11]
			"28624:26876", -- [12]
			"29950:30314:31078:28574:26602:24795", -- [13]
			"29750:30433:28674:28196", -- [14]
			"28624:26876:26880:23859:28197", -- [15]
			"29750:30433:28674:26877:26881:28195", -- [16]
			"29750:30433:31069:30869", -- [17]
			"28624:28623", -- [18]
			"29750:29721:28615", -- [19]
			"28624:28623:28618", -- [20]
			"29950:30314:31078:28574", -- [21]
			"29950:30314:31078:28037", -- [22]
			"29750:30433:28674", -- [23]
			"29750:29721", -- [24]
			"29950:30314:31078", -- [25]
			"28624:30569", -- [26]
			"29950:30314", -- [27]
			"29750:30433", -- [28]
			"29750:30433:31069", -- [29]
			"29750:29721:30271", -- [30]
			"29950:33849", -- [31]
			["direct"] = "28624:29750:32571:29950",
			["coord"] = 1911834618,
			["m"] = 495,
			["f"] = 0,
		},
		[30271] = {
			"26878:23859:23736", -- [1]
			"28615:28623:26876:24061", -- [2]
			"26878:23859", -- [3]
			"26878:26881:26602:24795:27046", -- [4]
			"28674:26879", -- [5]
			"26878:26881:26602", -- [6]
			"26878:26881", -- [7]
			"28674:26877", -- [8]
			"26878:26851", -- [9]
			"26878:26880", -- [10]
			"28615:28623:26876", -- [11]
			"26878:26881:26602:24795", -- [12]
			"26878:28196", -- [13]
			"26878:23859:28197", -- [14]
			"26878:26881:28195", -- [15]
			"28674:30869", -- [16]
			"28615:28623", -- [17]
			"28615:28618", -- [18]
			"28615:28623:28624", -- [19]
			"28674:28574", -- [20]
			"28674:28574:28037", -- [21]
			"29721:29750", -- [22]
			"29721:32571", -- [23]
			"28674:31069:31078", -- [24]
			"29721:29750:29951", -- [25]
			"29721:29750:29950", -- [26]
			"28615:28623:28624:30569", -- [27]
			"28674:31069:30314", -- [28]
			"28674:30433", -- [29]
			"28674:31069", -- [30]
			"28674:33849", -- [31]
			["direct"] = "26878:28615:28674:29721",
			["coord"] = 3097480930,
			["m"] = 510,
			["f"] = 0,
		},
		[28195] = {
			"28196:28197:23736", -- [1]
			"28196:26878:26880:24061", -- [2]
			"28196:26878:23859", -- [3]
			"26879:24795:27046", -- [4]
			"28196:26878", -- [5]
			"26881:26877", -- [6]
			"28196:26851", -- [7]
			"28196:26878:26880", -- [8]
			"28196:26878:26880:26876", -- [9]
			"26879:24795", -- [10]
			"28196:28197", -- [11]
			"26881:30869", -- [12]
			"28196:26878:28615:28623", -- [13]
			"28196:26878:28615", -- [14]
			"28196:26878:28618", -- [15]
			"28196:26878:28615:28623:28624", -- [16]
			"26602:28574", -- [17]
			"26602:28037", -- [18]
			"28196:28674", -- [19]
			"28196:28674:29721", -- [20]
			"28196:28674:30433:29750", -- [21]
			"28196:28674:29721:32571", -- [22]
			"26602:28574:31078", -- [23]
			"28196:28674:30433:29750:29951", -- [24]
			"28196:28674:30433:29750:29950", -- [25]
			"28196:26878:28615:28623:28624:30569", -- [26]
			"26881:30869:30314", -- [27]
			"28196:28674:30433", -- [28]
			"26881:30869:31069", -- [29]
			"28196:26878:30271", -- [30]
			"28196:28674:33849", -- [31]
			["direct"] = "26879:26602:26881:28196",
			["coord"] = 3371205577,
			["m"] = 486,
			["f"] = 0,
		},
		[28574] = {
			"30869:26877:26878:23859:23736", -- [1]
			"30869:26877:26878:26880:24061", -- [2]
			"30869:26877:26878:23859", -- [3]
			"26602:24795:27046", -- [4]
			"30869:26877:26878", -- [5]
			"26602:26879", -- [6]
			"26602:26881", -- [7]
			"30869:26877", -- [8]
			"30869:26877:26851", -- [9]
			"30869:26877:26878:26880", -- [10]
			"28674:28615:28623:26876", -- [11]
			"26602:24795", -- [12]
			"26602:28195:28196", -- [13]
			"26602:28195:28196:28197", -- [14]
			"26602:28195", -- [15]
			"28674:28615:28623", -- [16]
			"28674:28615", -- [17]
			"28674:28615:28618", -- [18]
			"28674:28615:28623:28624", -- [19]
			"28674:29721", -- [20]
			"28674:30433:29750", -- [21]
			"28674:29721:32571", -- [22]
			"31078:30314:29950:29951", -- [23]
			"31078:30314:29950", -- [24]
			"28674:28615:28623:28624:30569", -- [25]
			"31078:30314", -- [26]
			"28674:30433", -- [27]
			"28674:31069", -- [28]
			"28674:30271", -- [29]
			"31078:30314:33849", -- [30]
			["m"] = 493,
			["f"] = 0,
			["direct"] = "26602:30869:28037:28674:31078",
			["coord"] = 2150407428,
		},
		[24795] = {
			"26602:28195:28196:28197:23736", -- [1]
			"26602:26881:26878:26880:24061", -- [2]
			"26602:26881:26878:23859", -- [3]
			"26602:26881:26878", -- [4]
			"26602:26881", -- [5]
			"26602:26881:26877", -- [6]
			"26602:26881:26851", -- [7]
			"26602:26881:26878:26880", -- [8]
			"26602:26881:26878:26880:26876", -- [9]
			"26602:28195:28196", -- [10]
			"26602:28195:28196:28197", -- [11]
			"26602:28195", -- [12]
			"26602:26881:30869", -- [13]
			"26602:26881:26878:28615:28623", -- [14]
			"26602:26881:26878:28615", -- [15]
			"26602:26881:26878:28618", -- [16]
			"26602:26881:26878:28615:28623:28624", -- [17]
			"26602:28574", -- [18]
			"26602:28037", -- [19]
			"26602:28574:28674", -- [20]
			"26602:28574:28674:29721", -- [21]
			"26602:28574:28674:30433:29750", -- [22]
			"26602:28574:28674:29721:32571", -- [23]
			"26602:28574:31078", -- [24]
			"26602:28574:31078:30314:29950:29951", -- [25]
			"26602:28574:31078:30314:29950", -- [26]
			"26602:26881:26878:28615:28623:28624:30569", -- [27]
			"26602:28574:31078:30314", -- [28]
			"26602:28574:28674:30433", -- [29]
			"26602:28574:28674:31069", -- [30]
			"26602:28574:28674:30271", -- [31]
			"26602:28574:31078:30314:33849", -- [32]
			["direct"] = "27046:26879:26602",
			["coord"] = 1939691395,
			["m"] = 486,
			["f"] = 0,
		},

		[26876] = {
			"24061:23736", -- [1]
			"26880:23859", -- [2]
			"26880:26878:26881:26602:24795:27046", -- [3]
			"26880:26878", -- [4]
			"26880:26878:26881:26879", -- [5]
			"26880:26878:26881:26602", -- [6]
			"26880:26878:26881", -- [7]
			"28623:28615:26877", -- [8]
			"26880:26878:26851", -- [9]
			"26880:26878:26881:26602:24795", -- [10]
			"26880:26878:28196", -- [11]
			"26880:23859:28197", -- [12]
			"26880:26878:26881:28195", -- [13]
			"28623:28615:26877:30869", -- [14]
			"28623:28615", -- [15]
			"28623:28618", -- [16]
			"28623:28615:28674:28574", -- [17]
			"28623:28615:28674:28574:28037", -- [18]
			"28623:28615:28674", -- [19]
			"28623:28615:29721", -- [20]
			"28623:28615:29721:29750", -- [21]
			"28624:32571", -- [22]
			"28623:28615:28674:31069:31078", -- [23]
			"28624:29951", -- [24]
			"28624:29951:29950", -- [25]
			"28624:30569", -- [26]
			"28623:28615:28674:31069:30314", -- [27]
			"28623:28615:28674:30433", -- [28]
			"28623:28615:28674:31069", -- [29]
			"28623:28615:30271", -- [30]
			"28623:28615:28674:33849", -- [31]
			["direct"] = "24061:26880:28623:28624",
			["coord"] = 2572305445,
			["m"] = 490,
			["f"] = 0,
		},
		[26877] = {
			"26878:23859:23736", -- [1]
			"26878:26880:24061", -- [2]
			"26878:23859", -- [3]
			"26881:26602:24795:27046", -- [4]
			"26881:26879", -- [5]
			"26881:26602", -- [6]
			"26878:26880", -- [7]
			"26878:26880:26876", -- [8]
			"26881:26602:24795", -- [9]
			"26851:28196", -- [10]
			"26878:23859:28197", -- [11]
			"26881:28195", -- [12]
			"28615:28623", -- [13]
			"28615:28618", -- [14]
			"28615:28623:28624", -- [15]
			"30869:28574", -- [16]
			"30869:28574:28037", -- [17]
			"28674:29721", -- [18]
			"28674:30433:29750", -- [19]
			"28674:29721:32571", -- [20]
			"30869:31078", -- [21]
			"28674:30433:29750:29951", -- [22]
			"28674:30433:29750:29950", -- [23]
			"28615:28623:28624:30569", -- [24]
			"30869:30314", -- [25]
			"28674:30433", -- [26]
			"28674:31069", -- [27]
			"28674:30271", -- [28]
			"28674:33849", -- [29]
			["m"] = 488,
			["coord"] = 1698185732,
			["direct"] = "26878:26881:26851:30869:28615:28674",
			["f"] = 0,
		},
		[26878] = {
			"23859:23736", -- [1]
			"26880:24061", -- [2]
			"26881:26602:24795:27046", -- [3]
			"26881:26879", -- [4]
			"26881:26602", -- [5]
			"26880:26876", -- [6]
			"26881:26602:24795", -- [7]
			"23859:28197", -- [8]
			"26881:28195", -- [9]
			"26877:30869", -- [10]
			"28615:28623", -- [11]
			"28615:28623:28624", -- [12]
			"26877:30869:28574", -- [13]
			"26881:26602:28037", -- [14]
			"30271:28674", -- [15]
			"28615:29721", -- [16]
			"28615:29721:29750", -- [17]
			"28615:29721:32571", -- [18]
			"26877:30869:31078", -- [19]
			"28615:29721:29750:29951", -- [20]
			"28615:29721:29750:29950", -- [21]
			"28615:28623:28624:30569", -- [22]
			"30271:28674:31069:30314", -- [23]
			"30271:28674:30433", -- [24]
			"30271:28674:31069", -- [25]
			"30271:28674:33849", -- [26]
			["m"] = 488,
			["f"] = 0,
			["direct"] = "23859:26881:26877:26851:26880:28196:28615:28618:30271",
			["coord"] = 3309797249,
		},
		[26879] = {
			"28195:28196:28197:23736", -- [1]
			"28195:28196:26878:26880:24061", -- [2]
			"28195:28196:26878:23859", -- [3]
			"24795:27046", -- [4]
			"28195:28196:26878", -- [5]
			"26881:26877", -- [6]
			"28195:28196:26851", -- [7]
			"28195:28196:26878:26880", -- [8]
			"28195:28196:26878:26880:26876", -- [9]
			"28195:28196", -- [10]
			"28195:28196:28197", -- [11]
			"26881:30869", -- [12]
			"28195:28196:26878:28615:28623", -- [13]
			"28195:28196:26878:28615", -- [14]
			"28195:28196:26878:28618", -- [15]
			"28195:28196:26878:28615:28623:28624", -- [16]
			"26602:28574", -- [17]
			"26602:28037", -- [18]
			"28674:29721", -- [19]
			"28674:30433:29750", -- [20]
			"28674:29721:32571", -- [21]
			"26602:28574:31078", -- [22]
			"28674:30433:29750:29951", -- [23]
			"28674:30433:29750:29950", -- [24]
			"28195:28196:26878:28615:28623:28624:30569", -- [25]
			"26602:28574:31078:30314", -- [26]
			"28674:30433", -- [27]
			"28674:31069", -- [28]
			"28674:30271", -- [29]
			"28674:33849", -- [30]
			["m"] = 486,
			["coord"] = 2531241699,
			["direct"] = "26602:26881:24795:28195:28674",
			["f"] = 0,
		},
		[26880] = {
			"23859:23736", -- [1]
			"26878:26881:26602:24795:27046", -- [2]
			"26878:26881:26879", -- [3]
			"26878:26881:26602", -- [4]
			"26878:26881", -- [5]
			"26878:26877", -- [6]
			"26878:26851", -- [7]
			"26878:26881:26602:24795", -- [8]
			"26878:28196", -- [9]
			"23859:28197", -- [10]
			"26878:26881:28195", -- [11]
			"26878:26877:30869", -- [12]
			"28618:28623", -- [13]
			"28618:28615", -- [14]
			"28618:28623:28624", -- [15]
			"26878:26877:30869:28574", -- [16]
			"26878:26881:26602:28037", -- [17]
			"28618:28615:28674", -- [18]
			"28618:28615:29721", -- [19]
			"28618:28615:29721:29750", -- [20]
			"28618:28623:28624:32571", -- [21]
			"28618:28615:28674:31069:31078", -- [22]
			"28618:28615:29721:29750:29951", -- [23]
			"28618:28615:29721:29750:29950", -- [24]
			"28618:28623:28624:30569", -- [25]
			"28618:28615:28674:31069:30314", -- [26]
			"28618:28615:28674:30433", -- [27]
			"28618:28615:28674:31069", -- [28]
			"28618:28615:30271", -- [29]
			"28618:28615:28674:33849", -- [30]
			["direct"] = "24061:23859:26878:26876:28618",
			["f"] = 0,
			["m"] = 490,
			["coord"] = 1344706413,
		},
		[26881] = {
			"26878:23859:23736", -- [1]
			"26878:26880:24061", -- [2]
			"26878:23859", -- [3]
			"26602:24795:27046", -- [4]
			"26878:26880", -- [5]
			"26878:26880:26876", -- [6]
			"26602:24795", -- [7]
			"28196:28197", -- [8]
			"26878:28615:28623", -- [9]
			"26878:28615", -- [10]
			"26878:28618", -- [11]
			"26878:28615:28623:28624", -- [12]
			"26602:28574", -- [13]
			"26602:28037", -- [14]
			"26877:28674", -- [15]
			"26877:28674:29721", -- [16]
			"26877:28674:30433:29750", -- [17]
			"26877:28674:29721:32571", -- [18]
			"30869:31078", -- [19]
			"26877:28674:30433:29750:29951", -- [20]
			"26877:28674:30433:29750:29950", -- [21]
			"26878:28615:28623:28624:30569", -- [22]
			"30869:30314", -- [23]
			"26877:28674:30433", -- [24]
			"30869:31069", -- [25]
			"26878:30271", -- [26]
			"26877:28674:33849", -- [27]
			["m"] = 488,
			["f"] = 0,
			["direct"] = "26878:26879:26602:26877:26851:28196:28195:30869",
			["coord"] = 1252167107,
		},
		[23859] = {
			"26878:26881:26602:24795:27046", -- [1]
			"26878:26881:26879", -- [2]
			"26878:26881:26602", -- [3]
			"26878:26881", -- [4]
			"26878:26877", -- [5]
			"26878:26851", -- [6]
			"26880:26876", -- [7]
			"26878:26881:26602:24795", -- [8]
			"28197:28196", -- [9]
			"26878:26881:28195", -- [10]
			"26878:26877:30869", -- [11]
			"26880:28618:28623", -- [12]
			"26880:28618:28615", -- [13]
			"26880:28618", -- [14]
			"26880:28618:28623:28624", -- [15]
			"26878:26877:30869:28574", -- [16]
			"26878:26881:26602:28037", -- [17]
			"26880:28618:28615:28674", -- [18]
			"26880:28618:28615:29721", -- [19]
			"26880:28618:28615:29721:29750", -- [20]
			"26880:28618:28623:28624:32571", -- [21]
			"26880:28618:28615:28674:31069:31078", -- [22]
			"26880:28618:28615:29721:29750:29951", -- [23]
			"26880:28618:28615:29721:29750:29950", -- [24]
			"26880:28618:28623:28624:30569", -- [25]
			"26880:28618:28615:28674:31069:30314", -- [26]
			"26880:28618:28615:28674:30433", -- [27]
			"26880:28618:28615:28674:31069", -- [28]
			"26880:28618:28615:30271", -- [29]
			"26880:28618:28615:28674:33849", -- [30]
			["m"] = 491,
			["f"] = 0,
			["direct"] = "23736:24061:26878:26880:28197",
			["coord"] = 1342664869,
		},
		[29721] = {
			"28615:26878:23859:23736", -- [1]
			"28615:28623:26876:24061", -- [2]
			"28615:26878:23859", -- [3]
			"28615:26851:26881:26602:24795:27046", -- [4]
			"28615:26878", -- [5]
			"28674:26879", -- [6]
			"28615:26851:26881:26602", -- [7]
			"28615:26851:26881", -- [8]
			"28615:26877", -- [9]
			"28615:26851", -- [10]
			"28615:28618:26880", -- [11]
			"28615:28623:26876", -- [12]
			"28615:26851:26881:26602:24795", -- [13]
			"28615:26851:28196", -- [14]
			"28615:26878:23859:28197", -- [15]
			"28615:26851:26881:28195", -- [16]
			"28674:30869", -- [17]
			"28615:28623", -- [18]
			"28615:28618", -- [19]
			"28615:28623:28624", -- [20]
			"28674:28574", -- [21]
			"28674:28574:28037", -- [22]
			"29750:30433:31069:31078", -- [23]
			"29750:29951", -- [24]
			"29750:29950", -- [25]
			"28615:28623:28624:30569", -- [26]
			"29750:29950:30314", -- [27]
			"29750:30433", -- [28]
			"29750:30433:31069", -- [29]
			"29750:29950:33849", -- [30]
			["m"] = 495,
			["coord"] = 1747966095,
			["direct"] = "28615:28674:29750:32571:30271",
			["f"] = 0,
		},
		[24061] = {
			"26880:26878:26881:26602:24795:27046", -- [1]
			"26880:26878", -- [2]
			"26880:26878:26881:26879", -- [3]
			"26880:26878:26881:26602", -- [4]
			"26880:26878:26881", -- [5]
			"26880:26878:26877", -- [6]
			"26880:26878:26851", -- [7]
			"26880:26878:26881:26602:24795", -- [8]
			"26880:26878:28196", -- [9]
			"23859:28197", -- [10]
			"26880:26878:26881:28195", -- [11]
			"26880:26878:26877:30869", -- [12]
			"26876:28623", -- [13]
			"26880:28618:28615", -- [14]
			"26880:28618", -- [15]
			"26876:28624", -- [16]
			"26880:26878:26877:30869:28574", -- [17]
			"26880:26878:26881:26602:28037", -- [18]
			"26880:28618:28615:28674", -- [19]
			"26880:28618:28615:29721", -- [20]
			"26880:28618:28615:29721:29750", -- [21]
			"26876:28624:32571", -- [22]
			"26880:28618:28615:28674:31069:31078", -- [23]
			"26876:28624:29951", -- [24]
			"26880:28618:28615:29721:29750:29950", -- [25]
			"26876:28624:30569", -- [26]
			"26880:28618:28615:28674:31069:30314", -- [27]
			"26880:28618:28615:28674:30433", -- [28]
			"26880:28618:28615:28674:31069", -- [29]
			"26880:28618:28615:30271", -- [30]
			"26880:28618:28615:28674:33849", -- [31]
			["direct"] = "23736:23859:26880:26876",
			["coord"] = 2580097316,
			["m"] = 491,
			["f"] = 0,
		},
		[30869] = {
			"26877:26878:23859:23736", -- [1]
			"26877:26878:26880:24061", -- [2]
			"26877:26878:23859", -- [3]
			"28574:26602:24795:27046", -- [4]
			"26877:26878", -- [5]
			"26881:26879", -- [6]
			"28574:26602", -- [7]
			"26877:26851", -- [8]
			"26877:26878:26880", -- [9]
			"26877:26878:26880:26876", -- [10]
			"28574:26602:24795", -- [11]
			"26881:28196", -- [12]
			"26877:26878:23859:28197", -- [13]
			"26881:28195", -- [14]
			"26877:28615:28623", -- [15]
			"26877:28615", -- [16]
			"26877:28615:28618", -- [17]
			"26877:28615:28623:28624", -- [18]
			"28574:28037", -- [19]
			"28674:29721", -- [20]
			"28674:30433:29750", -- [21]
			"28674:29721:32571", -- [22]
			"28674:30433:29750:29951", -- [23]
			"28674:30433:29750:29950", -- [24]
			"26877:28615:28623:28624:30569", -- [25]
			"28674:30433", -- [26]
			"28674:30271", -- [27]
			"31069:33849", -- [28]
			["m"] = 501,
			["f"] = 0,
			["direct"] = "26881:26877:28574:28674:31078:30314:31069",
			["coord"] = 3094564733,
		},
		[32571] = {
			"28624:26876:24061:23736", -- [1]
			"28624:26876:24061", -- [2]
			"28624:26876:26880:23859", -- [3]
			"29721:28615:26851:26881:26602:24795:27046", -- [4]
			"29721:28615:26878", -- [5]
			"29721:28674:26879", -- [6]
			"29721:28615:26851:26881:26602", -- [7]
			"29721:28615:26851:26881", -- [8]
			"29721:28615:26877", -- [9]
			"29721:28615:26851", -- [10]
			"28624:26876:26880", -- [11]
			"28624:26876", -- [12]
			"29721:28615:26851:26881:26602:24795", -- [13]
			"29721:28615:26851:28196", -- [14]
			"28624:26876:26880:23859:28197", -- [15]
			"29721:28615:26851:26881:28195", -- [16]
			"29721:28674:30869", -- [17]
			"28624:28623", -- [18]
			"29721:28615", -- [19]
			"28624:28623:28618", -- [20]
			"29721:28674:28574", -- [21]
			"29721:28674:28574:28037", -- [22]
			"29721:28674", -- [23]
			"29721:29750", -- [24]
			"29951:29950:30314:31078", -- [25]
			"29951:29950", -- [26]
			"28624:30569", -- [27]
			"29951:29950:30314", -- [28]
			"29721:29750:30433", -- [29]
			"29721:29750:30433:31069", -- [30]
			"29721:30271", -- [31]
			"29951:29950:33849", -- [32]
			"29762:29757", -- [35]
			["direct"] = "28624:29721:29951",
			["coord"] = 2686753797,
			["m"] = 495,
			["f"] = 0,
		},
		[23736] = {
			"23859:26878:26881:26602:24795:27046", -- [1]
			"23859:26878", -- [2]
			"23859:26878:26881:26879", -- [3]
			"23859:26878:26881:26602", -- [4]
			"23859:26878:26881", -- [5]
			"23859:26878:26877", -- [6]
			"23859:26878:26851", -- [7]
			"23859:26880", -- [8]
			"24061:26876", -- [9]
			"23859:26878:26881:26602:24795", -- [10]
			"28197:28196", -- [11]
			"28197:28196:28195", -- [12]
			"23859:26878:26877:30869", -- [13]
			"24061:26876:28623", -- [14]
			"23859:26880:28618:28615", -- [15]
			"23859:26880:28618", -- [16]
			"24061:26876:28624", -- [17]
			"28674:28574", -- [18]
			"28674:28574:28037", -- [19]
			"23859:26880:28618:28615:29721", -- [20]
			"23859:26880:28618:28615:29721:29750", -- [21]
			"24061:26876:28624:32571", -- [22]
			"28674:31069:31078", -- [23]
			"24061:26876:28624:29951", -- [24]
			"23859:26880:28618:28615:29721:29750:29950", -- [25]
			"24061:26876:28624:30569", -- [26]
			"28674:31069:30314", -- [27]
			"28674:30433", -- [28]
			"28674:31069", -- [29]
			"23859:26880:28618:28615:30271", -- [30]
			"28674:33849", -- [31]
			["direct"] = "24061:23859:28197:28674",
			["coord"] = 2565448190,
			["m"] = 491,
			["f"] = 0,
		},
		[28037] = {
			"26602:28195:28196:28197:23736", -- [1]
			"26602:26881:26878:26880:24061", -- [2]
			"26602:26881:26878:23859", -- [3]
			"26602:24795:27046", -- [4]
			"26602:26881:26878", -- [5]
			"26602:26879", -- [6]
			"26602:26881", -- [7]
			"28574:30869:26877", -- [8]
			"26602:26881:26851", -- [9]
			"26602:26881:26878:26880", -- [10]
			"28574:28674:28615:28623:26876", -- [11]
			"26602:24795", -- [12]
			"26602:28195:28196", -- [13]
			"26602:28195:28196:28197", -- [14]
			"26602:28195", -- [15]
			"28574:30869", -- [16]
			"28574:28674:28615:28623", -- [17]
			"28574:28674:28615", -- [18]
			"28574:28674:28615:28618", -- [19]
			"28574:28674:28615:28623:28624", -- [20]
			"28574:28674", -- [21]
			"28574:28674:29721", -- [22]
			"28574:28674:30433:29750", -- [23]
			"28574:28674:29721:32571", -- [24]
			"31078:30314:29950:29951", -- [25]
			"31078:30314:29950", -- [26]
			"28574:28674:28615:28623:28624:30569", -- [27]
			"31078:30314", -- [28]
			"28574:28674:30433", -- [29]
			"31078:31069", -- [30]
			"28574:28674:30271", -- [31]
			"31078:30314:33849", -- [32]
			["direct"] = "26602:28574:31078",
			["coord"] = 1087608149,
			["m"] = 493,
			["f"] = 0,
			["requirements"] = "qid:12523"
		},
		[28615] = {
			"26878:23859:23736", -- [1]
			"28623:26876:24061", -- [2]
			"26878:23859", -- [3]
			"26851:26881:26602:24795:27046", -- [4]
			"26851:26881:26879", -- [5]
			"26851:26881:26602", -- [6]
			"26851:26881", -- [7]
			"28618:26880", -- [8]
			"28623:26876", -- [9]
			"26851:26881:26602:24795", -- [10]
			"26851:28196", -- [11]
			"26878:23859:28197", -- [12]
			"26851:26881:28195", -- [13]
			"26877:30869", -- [14]
			"28623:28624", -- [15]
			"28674:28574", -- [16]
			"28674:28574:28037", -- [17]
			"29721:29750", -- [18]
			"29721:32571", -- [19]
			"28674:31069:31078", -- [20]
			"29721:29750:29951", -- [21]
			"29721:29750:29950", -- [22]
			"28623:28624:30569", -- [23]
			"28674:31069:30314", -- [24]
			"28674:30433", -- [25]
			"28674:31069", -- [26]
			"28674:33849", -- [27]
			["m"] = 496,
			["coord"] = 603962466,
			["direct"] = "26878:26877:26851:28623:28618:28674:29721:30271",
			["f"] = 0,
		},
		[30433] = {
			"28674:23736", -- [1]
			"28674:28615:28623:26876:24061", -- [2]
			"28674:30271:26878:23859", -- [3]
			"28674:26879:24795:27046", -- [4]
			"28674:30271:26878", -- [5]
			"28674:26879", -- [6]
			"28674:28574:26602", -- [7]
			"28674:26877:26881", -- [8]
			"28674:26877", -- [9]
			"28674:26851", -- [10]
			"28674:30271:26878:26880", -- [11]
			"28674:28615:28623:26876", -- [12]
			"28674:26879:24795", -- [13]
			"28674:28196", -- [14]
			"28674:30271:26878:23859:28197", -- [15]
			"28674:26877:26881:28195", -- [16]
			"31069:30869", -- [17]
			"28674:28615:28623", -- [18]
			"28674:28615", -- [19]
			"28674:28615:28618", -- [20]
			"28674:28615:28623:28624", -- [21]
			"28674:28574", -- [22]
			"28674:28574:28037", -- [23]
			"28674:29721", -- [24]
			"28674:29721:32571", -- [25]
			"31069:31078", -- [26]
			"29750:29951", -- [27]
			"29750:29950", -- [28]
			"28674:28615:28623:28624:30569", -- [29]
			"28674:30271", -- [30]
			"31069:33849", -- [31]
			["direct"] = "28674:29750:30314:31069",
			["coord"] = 3770468289,
			["m"] = 492,
			["f"] = 0,
		},
		[28618] = {
			"26880:23859:23736", -- [1]
			"28623:26876:24061", -- [2]
			"26880:23859", -- [3]
			"28615:26851:26881:26602:24795:27046", -- [4]
			"28615:26851:26881:26879", -- [5]
			"28615:26851:26881:26602", -- [6]
			"28615:26851:26881", -- [7]
			"28615:26877", -- [8]
			"28615:26851", -- [9]
			"28623:26876", -- [10]
			"28615:26851:26881:26602:24795", -- [11]
			"26878:28196", -- [12]
			"26880:23859:28197", -- [13]
			"28615:26851:26881:28195", -- [14]
			"28615:26877:30869", -- [15]
			"28623:28624", -- [16]
			"28615:28674:28574", -- [17]
			"28615:28674:28574:28037", -- [18]
			"28615:28674", -- [19]
			"28615:29721", -- [20]
			"28615:29721:29750", -- [21]
			"28623:28624:32571", -- [22]
			"28615:28674:31069:31078", -- [23]
			"28615:29721:29750:29951", -- [24]
			"28615:29721:29750:29950", -- [25]
			"28623:28624:30569", -- [26]
			"28615:28674:31069:30314", -- [27]
			"28615:28674:30433", -- [28]
			"28615:28674:31069", -- [29]
			"28615:30271", -- [30]
			"28615:28674:33849", -- [31]
			["direct"] = "26878:26880:28623:28615",
			["coord"] = 1381678745,
			["m"] = 496,
			["f"] = 0,
		},
		[30569] = {
			"28624:26876:24061:23736", -- [1]
			"28624:26876:24061", -- [2]
			"28624:26876:26880:23859", -- [3]
			"28624:28623:28615:26851:26881:26602:24795:27046", -- [4]
			"28624:28623:28618:26878", -- [5]
			"28624:28623:28615:26851:26881:26879", -- [6]
			"28624:28623:28615:26851:26881:26602", -- [7]
			"28624:28623:28615:26851:26881", -- [8]
			"28624:28623:28615:26877", -- [9]
			"28624:28623:28615:26851", -- [10]
			"28624:26876:26880", -- [11]
			"28624:26876", -- [12]
			"28624:28623:28615:26851:26881:26602:24795", -- [13]
			"28624:28623:28615:26851:28196", -- [14]
			"28624:26876:26880:23859:28197", -- [15]
			"28624:28623:28615:26851:26881:28195", -- [16]
			"28624:28623:28615:26877:30869", -- [17]
			"28624:28623", -- [18]
			"28624:28623:28615", -- [19]
			"28624:28623:28618", -- [20]
			"28624:28623:28615:28674:28574", -- [21]
			"28624:28623:28615:28674:28574:28037", -- [22]
			"28624:28623:28615:28674", -- [23]
			"28624:28623:28615:29721", -- [24]
			"28624:28623:28615:29721:29750", -- [25]
			"28624:32571", -- [26]
			"28624:28623:28615:28674:31069:31078", -- [27]
			"28624:29951", -- [28]
			"28624:29951:29950", -- [29]
			"28624:29951:29950:30314", -- [30]
			"28624:28623:28615:28674:30433", -- [31]
			"28624:28623:28615:28674:31069", -- [32]
			"28624:28623:28615:30271", -- [33]
			"28624:29951:29950:33849", -- [34]
			["direct"] = "28624",
			["coord"] = 3025877835,
			["m"] = 496,
			["f"] = 0,
		},
		[27046] = {
			"24795:26602:28195:28196:28197:23736", -- [1]
			"24795:26602:26881:26878:26880:24061", -- [2]
			"24795:26602:26881:26878:23859", -- [3]
			"24795:26602:26881:26878", -- [4]
			"24795:26879", -- [5]
			"24795:26602", -- [6]
			"24795:26602:26881", -- [7]
			"24795:26602:26881:26877", -- [8]
			"24795:26602:26881:26851", -- [9]
			"24795:26602:26881:26878:26880", -- [10]
			"24795:26602:26881:26878:26880:26876", -- [11]
			"24795:26602:28195:28196", -- [12]
			"24795:26602:28195:28196:28197", -- [13]
			"24795:26602:28195", -- [14]
			"24795:26602:26881:30869", -- [15]
			"24795:26602:26881:26878:28615:28623", -- [16]
			"24795:26602:26881:26878:28615", -- [17]
			"24795:26602:26881:26878:28618", -- [18]
			"24795:26602:26881:26878:28615:28623:28624", -- [19]
			"24795:26602:28574", -- [20]
			"24795:26602:28037", -- [21]
			"24795:26602:28574:28674", -- [22]
			"24795:26602:28574:28674:29721", -- [23]
			"24795:26602:28574:28674:30433:29750", -- [24]
			"24795:26602:28574:28674:29721:32571", -- [25]
			"24795:26602:28574:31078", -- [26]
			"24795:26602:28574:31078:30314:29950:29951", -- [27]
			"24795:26602:28574:31078:30314:29950", -- [28]
			"24795:26602:26881:26878:28615:28623:28624:30569", -- [29]
			"24795:26602:28574:31078:30314", -- [30]
			"24795:26602:28574:28674:30433", -- [31]
			"24795:26602:28574:28674:31069", -- [32]
			"24795:26602:28574:28674:30271", -- [33]
			"24795:26602:28574:31078:30314:33849", -- [34]
			["direct"] = "24795",
			["coord"] = 1422481428,
			["m"] = 486,
			["f"] = 0,
		},
		[28196] = {
			"28197:23736", -- [1]
			"26878:26880:24061", -- [2]
			"26878:23859", -- [3]
			"26881:26602:24795:27046", -- [4]
			"26881:26879", -- [5]
			"26881:26602", -- [6]
			"26851:26877", -- [7]
			"26878:26880", -- [8]
			"26878:26880:26876", -- [9]
			"26881:26602:24795", -- [10]
			"26881:30869", -- [11]
			"26878:28615:28623", -- [12]
			"26878:28615", -- [13]
			"26878:28618", -- [14]
			"26878:28615:28623:28624", -- [15]
			"26881:26602:28574", -- [16]
			"26881:26602:28037", -- [17]
			"28674:29721", -- [18]
			"28674:30433:29750", -- [19]
			"28674:29721:32571", -- [20]
			"26881:30869:31078", -- [21]
			"28674:30433:29750:29951", -- [22]
			"28674:30433:29750:29950", -- [23]
			"26878:28615:28623:28624:30569", -- [24]
			"26881:30869:30314", -- [25]
			"28674:30433", -- [26]
			"28674:31069", -- [27]
			"26878:30271", -- [28]
			"28674:33849", -- [29]
			["m"] = 488,
			["f"] = 0,
			["direct"] = "26878:26881:26851:28197:28195:28674",
			["coord"] = 2081603196,
		},
		[28674] = {
			"28615:28623:26876:24061", -- [1]
			"30271:26878:23859", -- [2]
			"26879:24795:27046", -- [3]
			"30271:26878", -- [4]
			"28574:26602", -- [5]
			"26877:26881", -- [6]
			"30271:26878:26880", -- [7]
			"28615:28623:26876", -- [8]
			"26879:24795", -- [9]
			"30271:26878:23859:28197", -- [10]
			"26877:26881:28195", -- [11]
			"28615:28623", -- [12]
			"28615:28618", -- [13]
			"28615:28623:28624", -- [14]
			"28574:28037", -- [15]
			"30433:29750", -- [16]
			"29721:32571", -- [17]
			"31069:31078", -- [18]
			"30433:29750:29951", -- [19]
			"30433:29750:29950", -- [20]
			"28615:28623:28624:30569", -- [21]
			"31069:30314", -- [22]
			["m"] = 504,
			["coord"] = 3092739228,
			["direct"] = "23736:26879:26877:26851:28196:30869:28615:28574:29721:30433:31069:30271:33849",
			["f"] = 1,
		},
		[31069] = {
			"30433:28674:23736", -- [1]
			"30433:28674:28615:28623:26876:24061", -- [2]
			"30433:28674:30271:26878:23859", -- [3]
			"30869:28574:26602:24795:27046", -- [4]
			"30433:28674:30271:26878", -- [5]
			"30869:26881:26879", -- [6]
			"30869:28574:26602", -- [7]
			"30869:26881", -- [8]
			"30869:26877", -- [9]
			"30433:28674:26851", -- [10]
			"30433:28674:30271:26878:26880", -- [11]
			"30433:28674:28615:28623:26876", -- [12]
			"30869:28574:26602:24795", -- [13]
			"30433:28674:28196", -- [14]
			"30433:28674:30271:26878:23859:28197", -- [15]
			"30869:26881:28195", -- [16]
			"30433:28674:28615:28623", -- [17]
			"30433:28674:28615", -- [18]
			"30433:28674:28615:28618", -- [19]
			"30433:28674:28615:28623:28624", -- [20]
			"30869:28574", -- [21]
			"31078:28037", -- [22]
			"30433:28674:29721", -- [23]
			"30433:29750", -- [24]
			"30433:28674:29721:32571", -- [25]
			"30433:29750:29951", -- [26]
			"30433:29750:29950", -- [27]
			"30433:28674:28615:28623:28624:30569", -- [28]
			"30433:28674:30271", -- [29]
			["m"] = 492,
			["coord"] = 3408050485,
			["direct"] = "30869:28674:31078:30314:30433:33849",
			["f"] = 0,
		},
		[30314] = {
			"30433:28674:23736", -- [1]
			"29950:29951:28624:26876:24061", -- [2]
			"30869:26877:26878:23859", -- [3]
			"31078:28574:26602:24795:27046", -- [4]
			"30869:26877:26878", -- [5]
			"31078:28574:26602:26879", -- [6]
			"31078:28574:26602", -- [7]
			"30869:26881", -- [8]
			"30869:26877", -- [9]
			"30869:26877:26851", -- [10]
			"30869:26877:26878:26880", -- [11]
			"29950:29951:28624:26876", -- [12]
			"31078:28574:26602:24795", -- [13]
			"30869:26881:28196", -- [14]
			"30869:26877:26878:23859:28197", -- [15]
			"30869:26881:28195", -- [16]
			"30433:28674:28615:28623", -- [17]
			"30433:28674:28615", -- [18]
			"30433:28674:28615:28618", -- [19]
			"29950:29951:28624", -- [20]
			"31078:28574", -- [21]
			"31078:28037", -- [22]
			"30433:28674", -- [23]
			"30433:28674:29721", -- [24]
			"30433:29750", -- [25]
			"29950:29951:32571", -- [26]
			"29950:29951", -- [27]
			"29950:29951:28624:30569", -- [28]
			"30433:28674:30271", -- [29]
			["m"] = 492,
			["coord"] = 1877360227,
			["direct"] = "30869:31078:29950:30433:31069:33849",
			["f"] = 0,
		},
		[26851] = {
			"26878:23859:23736", -- [1]
			"26878:26880:24061", -- [2]
			"26878:23859", -- [3]
			"26881:26602:24795:27046", -- [4]
			"26881:26879", -- [5]
			"26881:26602", -- [6]
			"26878:26880", -- [7]
			"26878:26880:26876", -- [8]
			"26881:26602:24795", -- [9]
			"26878:23859:28197", -- [10]
			"26881:28195", -- [11]
			"26877:30869", -- [12]
			"28615:28623", -- [13]
			"26878:28618", -- [14]
			"28615:28623:28624", -- [15]
			"26877:30869:28574", -- [16]
			"26881:26602:28037", -- [17]
			"28615:29721", -- [18]
			"28674:30433:29750", -- [19]
			"28615:29721:32571", -- [20]
			"26877:30869:31078", -- [21]
			"28674:30433:29750:29951", -- [22]
			"28674:30433:29750:29950", -- [23]
			"28615:28623:28624:30569", -- [24]
			"28674:31069:30314", -- [25]
			"28674:30433", -- [26]
			"28674:31069", -- [27]
			"26878:30271", -- [28]
			"28674:33849", -- [29]
			["m"] = 488,
			["f"] = 0,
			["direct"] = "26878:26881:26877:28196:28615:28674",
			["coord"] = 2588115855,
		},
		[33849] = {
			"31069:30433:28674:23736", -- [1]
			"29950:29951:28624:26876:24061", -- [2]
			"31069:30433:28674:30271:26878:23859", -- [3]
			"30314:31078:28574:26602:24795:27046", -- [4]
			"31069:30433:28674:30271:26878", -- [5]
			"31069:30869:26881:26879", -- [6]
			"30314:31078:28574:26602", -- [7]
			"31069:30869:26881", -- [8]
			"31069:30869:26877", -- [9]
			"31069:30433:28674:26851", -- [10]
			"31069:30433:28674:30271:26878:26880", -- [11]
			"29950:29951:28624:26876", -- [12]
			"30314:31078:28574:26602:24795", -- [13]
			"31069:30433:28674:28196", -- [14]
			"31069:30433:28674:30271:26878:23859:28197", -- [15]
			"31069:30869:26881:28195", -- [16]
			"31069:30869", -- [17]
			"31069:30433:28674:28615:28623", -- [18]
			"31069:30433:28674:28615", -- [19]
			"31069:30433:28674:28615:28618", -- [20]
			"29950:29951:28624", -- [21]
			"30314:31078:28574", -- [22]
			"30314:31078:28037", -- [23]
			"29950:29750:29721", -- [24]
			"29950:29750", -- [25]
			"29950:29951:32571", -- [26]
			"30314:31078", -- [27]
			"29950:29951", -- [28]
			"29950:29951:28624:30569", -- [29]
			"31069:30433", -- [30]
			"31069:30433:28674:30271", -- [31]
			["direct"] = "28674:29950:30314:31069",
			["coord"] = 3118414356,
			["m"] = 492,
			["f"] = 0,
		},
		[28197] = {
			"23859:24061", -- [1]
			"28196:26881:26602:24795:27046", -- [2]
			"23859:26878", -- [3]
			"28196:26881:26879", -- [4]
			"28196:26881:26602", -- [5]
			"28196:26881", -- [6]
			"23859:26878:26877", -- [7]
			"23859:26878:26851", -- [8]
			"23859:26880", -- [9]
			"23859:26880:26876", -- [10]
			"28196:26881:26602:24795", -- [11]
			"28196:28195", -- [12]
			"28196:26881:30869", -- [13]
			"23859:26880:28618:28623", -- [14]
			"23859:26880:28618:28615", -- [15]
			"23859:26880:28618", -- [16]
			"23859:26880:28618:28623:28624", -- [17]
			"28196:26881:26602:28574", -- [18]
			"28196:26881:26602:28037", -- [19]
			"23859:26880:28618:28615:28674", -- [20]
			"23859:26880:28618:28615:29721", -- [21]
			"23859:26880:28618:28615:29721:29750", -- [22]
			"23859:26880:28618:28623:28624:32571", -- [23]
			"28196:26881:30869:31078", -- [24]
			"23859:26880:28618:28615:29721:29750:29951", -- [25]
			"23859:26880:28618:28615:29721:29750:29950", -- [26]
			"23859:26880:28618:28623:28624:30569", -- [27]
			"23859:26880:28618:28615:28674:31069:30314", -- [28]
			"23859:26880:28618:28615:28674:30433", -- [29]
			"23859:26880:28618:28615:28674:31069", -- [30]
			"23859:26880:28618:28615:30271", -- [31]
			"23859:26880:28618:28615:28674:33849", -- [32]
			["m"] = 491,
			["f"] = 0,
			["direct"] = "23736:23859:28196",
			["coord"] = 1058378765,
		},
	}, -- [4]
	[6] = {
		[61512] = {
			"60416:61744:61474:61759:60230:59186", -- [1]
			"60416:61744:61474:66023", -- [2]
			"60416:61744:61474:61759:60230:59186:59732", -- [3]
			"60416:61744:61474:61759:60230:59186:59727", -- [4]
			"60416:61744:61474:61759:60230:59186:59735:59733", -- [5]
			"60416:61744:61474:61759:60230:59186:59735", -- [6]
			"60416:61744:61474:61759:60230:59186:59736", -- [7]
			"60416:61744:61474:66023:56737", -- [8]
			"60416:61744:61474:61759:60230", -- [9]
			"60416:61744:61121:60231", -- [10]
			"60416:61744:61474:60232", -- [11]
			"60416:61744:61121:60231:59049", -- [12]
			"62901:62903:63500:63501:58843", -- [13]
			"62901:62903:63500:63501:59048", -- [14]
			"62901:62903:63500:63501:59048:65189", -- [15]
			"62901:62903:63500:63501:59048:60441", -- [16]
			"60416:61744:61474", -- [17]
			"60416:61504:61118", -- [18]
			"60416:61744", -- [19]
			"60416:61504:61511", -- [20]
			"60416:61504", -- [21]
			"60416:61473", -- [22]
			"60416:61744:61474:61759", -- [23]
			"60416:61744:61474:61759:62658", -- [24]
			"62901:62903", -- [25]
			"62901:62898", -- [26]
			"62901:62898:62909", -- [27]
			"60416:61744:61121", -- [28]
			"62901:62903:63500:63501", -- [29]
			"63497:63498", -- [30]
			"62901:62903:63500", -- [31]
			"60416:61744:61474:61759:60230:59186:64310", -- [32]
			"62901:62903:63500:63501:65511", -- [33]
			"60416:61744:61121:65865", -- [34]
			"60416:61744:61474:66023:68226", -- [35]
			"60416:61744:61474:61759:60230:59186:71940", -- [36]
			["direct"] = "60416:62901:63497",
			["m"] = 809,
			["coord"] = 1483642710,
			["f"] = 0,
		},
		[62658] = {
			"60230:59186", -- [1]
			"60230:60232:66023", -- [2]
			"60230:59186:59732", -- [3]
			"60230:59186:59727", -- [4]
			"60230:59186:59735:59733", -- [5]
			"60230:59186:59735", -- [6]
			"60230:59186:59736", -- [7]
			"60230:60232:66023:56737", -- [8]
			"60230:60232", -- [9]
			"60231:59049", -- [10]
			"60231:58843", -- [11]
			"60231:59048", -- [12]
			"60231:65189", -- [13]
			"60231:59049:60441", -- [14]
			"61759:61474", -- [15]
			"61759:61474:61118", -- [16]
			"61759:61474:61744", -- [17]
			"61759:61474:61118:61511", -- [18]
			"61759:61474:61504", -- [19]
			"61759:61474:61744:60416", -- [20]
			"61759:61474:61744:61473", -- [21]
			"61759:61474:61744:60416:61512", -- [22]
			"61759:61474:61744:61473:62901", -- [23]
			"61759:61474:61744:61473:62903", -- [24]
			"61759:61474:61744:61473:62903:62898", -- [25]
			"61759:61474:61744:61473:62903:62898:62909", -- [26]
			"60231:58843:63501", -- [27]
			"60231:58843:63501:63498", -- [28]
			"61121:63500", -- [29]
			"61121:63497", -- [30]
			"60230:59186:64310", -- [31]
			"60231:58843:63501:65511", -- [32]
			"61121:65865", -- [33]
			"60231:59049:68226", -- [34]
			"60230:59186:71940", -- [35]
			["direct"] = "60230:60231:61759:61121",
			["m"] = 807,
			["coord"] = 3041607207,
			["f"] = 0,
		},
		[68226] = {
			"66023:59186", -- [1]
			"66023:59727:59732", -- [2]
			"66023:59727", -- [3]
			"66023:59727:59732:59733", -- [4]
			"66023:59186:59735", -- [5]
			"66023:59186:59736", -- [6]
			"66023:56737", -- [7]
			"59049:60231:60230", -- [8]
			"59049:60231", -- [9]
			"66023:60232", -- [10]
			"59049:58843", -- [11]
			"59049:59048", -- [12]
			"59049:65189", -- [13]
			"59049:60441", -- [14]
			"66023:61474", -- [15]
			"66023:61474:61118", -- [16]
			"66023:61474:61744", -- [17]
			"66023:61474:61118:61511", -- [18]
			"66023:61474:61504", -- [19]
			"66023:61474:61744:60416", -- [20]
			"66023:61474:61744:61473", -- [21]
			"66023:61474:61744:60416:61512", -- [22]
			"59049:60231:62658:61759", -- [23]
			"59049:60231:62658", -- [24]
			"66023:61474:61744:61473:62901", -- [25]
			"59049:59048:63501:63500:62903", -- [26]
			"59049:59048:63501:63500:62903:62898", -- [27]
			"59049:59048:63501:63500:62903:62898:62909", -- [28]
			"59049:60231:61121", -- [29]
			"59049:59048:63501", -- [30]
			"59049:59048:63501:63498", -- [31]
			"59049:59048:63501:63500", -- [32]
			"59049:60231:61121:63497", -- [33]
			"66023:56737:64310", -- [34]
			"59049:59048:63501:65511", -- [35]
			"59049:60231:61121:65865", -- [36]
			"66023:59186:71940", -- [37]
			["direct"] = "66023:59049",
			["m"] = 857,
			["coord"] = 3794753723,
			["f"] = 0,
			["requirements"] = "qid:32109"
		},
		[61473] = {
			"61744:61474:61759:60230:59186", -- [1]
			"61744:61474:66023", -- [2]
			"61744:61474:61759:60230:59186:59732", -- [3]
			"61744:61474:61759:60230:59186:59727", -- [4]
			"61744:61474:61759:60230:59186:59735:59733", -- [5]
			"61744:61474:61759:60230:59186:59735", -- [6]
			"61744:61474:61759:60230:59186:59736", -- [7]
			"61744:61474:66023:56737", -- [8]
			"61744:61474:61759:60230", -- [9]
			"61744:61121:60231", -- [10]
			"61744:61474:60232", -- [11]
			"61744:61121:60231:59049", -- [12]
			"62903:63500:63501:58843", -- [13]
			"62903:63500:63501:59048", -- [14]
			"62903:63500:63501:59048:65189", -- [15]
			"62903:63500:63501:59048:60441", -- [16]
			"61744:61474", -- [17]
			"61744:61118", -- [18]
			"61744:61511", -- [19]
			"60416:61504", -- [20]
			"60416:61512", -- [21]
			"61744:61474:61759", -- [22]
			"61744:61474:61759:62658", -- [23]
			"62903:62898", -- [24]
			"62903:62898:62909", -- [25]
			"61744:61121", -- [26]
			"62903:63500:63501", -- [27]
			"62903:63500:63501:63498", -- [28]
			"62903:63500", -- [29]
			"62903:63500:63497", -- [30]
			"61744:61474:61759:60230:59186:64310", -- [31]
			"62903:63500:63501:65511", -- [32]
			"61744:61121:65865", -- [33]
			"61744:61474:66023:68226", -- [34]
			"61744:61474:61759:60230:59186:71940", -- [35]
			["direct"] = "61744:60416:62901:62903",
			["m"] = 809,
			["coord"] = 1887954260,
			["f"] = 0,
		},
		[64310] = {
			"56737:66023", -- [1]
			"59186:59732", -- [2]
			"59186:59727", -- [3]
			"59186:59735:59733", -- [4]
			"59186:59735", -- [5]
			"59186:59736", -- [6]
			"59186:60230", -- [7]
			"59186:60230:60231", -- [8]
			"56737:66023:60232", -- [9]
			"56737:66023:68226:59049", -- [10]
			"59186:60230:60231:58843", -- [11]
			"59186:60230:60231:59048", -- [12]
			"56737:66023:68226:59049:65189", -- [13]
			"56737:66023:68226:59049:60441", -- [14]
			"59186:60230:61759:61474", -- [15]
			"59186:60230:61759:61474:61118", -- [16]
			"59186:60230:61759:61474:61744", -- [17]
			"59186:60230:61759:61474:61118:61511", -- [18]
			"59186:60230:61759:61474:61504", -- [19]
			"59186:60230:61759:61474:61744:60416", -- [20]
			"59186:60230:61759:61474:61744:61473", -- [21]
			"59186:60230:61759:61474:61744:60416:61512", -- [22]
			"59186:60230:61759", -- [23]
			"59186:60230:62658", -- [24]
			"59186:60230:61759:61474:61744:61473:62901", -- [25]
			"59186:60230:61759:61474:61744:61473:62903", -- [26]
			"59186:60230:61759:61474:61744:61473:62903:62898", -- [27]
			"59186:60230:61759:61474:61744:61473:62903:62898:62909", -- [28]
			"59186:60230:61121", -- [29]
			"59186:60230:60231:58843:63501", -- [30]
			"59186:60230:60231:58843:63501:63498", -- [31]
			"59186:60230:61121:63500", -- [32]
			"59186:60230:61121:63497", -- [33]
			"59186:60230:60231:58843:63501:65511", -- [34]
			"59186:60230:61121:65865", -- [35]
			"56737:66023:68226", -- [36]
			"59186:71940", -- [37]
			["direct"] = "59186:56737",
			["m"] = 806,
			["coord"] = 1851633473,
			["f"] = 0,
		},
		[65511] = {
			"63501:58843:60231:60230:59186", -- [1]
			"63501:58843:60231:60232:66023", -- [2]
			"63501:58843:60231:60230:59186:59732", -- [3]
			"63501:58843:60231:60230:59186:59727", -- [4]
			"63501:58843:60231:60230:59186:59735:59733", -- [5]
			"63501:58843:60231:60230:59186:59735", -- [6]
			"63501:58843:60231:60230:59186:59736", -- [7]
			"63501:58843:60231:60232:66023:56737", -- [8]
			"63501:58843:60231:60230", -- [9]
			"63501:58843:60231", -- [10]
			"63501:58843:60231:60232", -- [11]
			"63501:58843:59049", -- [12]
			"63501:58843", -- [13]
			"63501:59048", -- [14]
			"63501:59048:65189", -- [15]
			"63501:59048:60441", -- [16]
			"63501:63500:62903:61473:61744:61474", -- [17]
			"63501:63500:62903:61473:61744:61118", -- [18]
			"63501:63500:62903:61473:61744", -- [19]
			"63501:63500:62903:61473:61744:61511", -- [20]
			"63501:63500:62903:61473:60416:61504", -- [21]
			"63501:63500:62903:61473:60416", -- [22]
			"63501:63500:62903:61473", -- [23]
			"63501:63497:61512", -- [24]
			"63501:58843:60231:62658:61759", -- [25]
			"63501:58843:60231:62658", -- [26]
			"63501:63500:62903:62901", -- [27]
			"63501:63500:62903", -- [28]
			"63501:63500:62903:62898", -- [29]
			"63501:63500:62903:62898:62909", -- [30]
			"63501:61121", -- [31]
			"63501:63500", -- [32]
			"63501:63497", -- [33]
			"63501:58843:60231:60230:59186:64310", -- [34]
			"63501:61121:65865", -- [35]
			"63501:58843:59049:68226", -- [36]
			"63501:58843:60231:60230:59186:71940", -- [37]
			["direct"] = "63501:63498",
			["m"] = 858,
			["coord"] = 1829473930,
			["f"] = 0,
		},
		[63497] = {
			"61121:60230:59186", -- [1]
			"61121:66023", -- [2]
			"61121:60230:59186:59732", -- [3]
			"61121:60230:59186:59727", -- [4]
			"61121:60230:59186:59735:59733", -- [5]
			"61121:60230:59186:59735", -- [6]
			"61121:60230:59186:59736", -- [7]
			"61121:66023:56737", -- [8]
			"61121:60230", -- [9]
			"61121:60231", -- [10]
			"61121:60231:60232", -- [11]
			"61121:60231:59049", -- [12]
			"63501:58843", -- [13]
			"63501:59048", -- [14]
			"63501:59048:65189", -- [15]
			"63501:59048:60441", -- [16]
			"61121:61474", -- [17]
			"61512:60416:61504:61118", -- [18]
			"61121:61744", -- [19]
			"61512:60416:61504:61511", -- [20]
			"61512:60416:61504", -- [21]
			"61512:60416", -- [22]
			"63500:62903:61473", -- [23]
			"61121:62658:61759", -- [24]
			"61121:62658", -- [25]
			"63500:62903:62901", -- [26]
			"63500:62903", -- [27]
			"63500:62903:62898", -- [28]
			"63500:62903:62898:62909", -- [29]
			"61121:60230:59186:64310", -- [30]
			"63501:65511", -- [31]
			"61121:65865", -- [32]
			"61121:60231:59049:68226", -- [33]
			"61121:60230:59186:71940", -- [34]
			["direct"] = "61512:61121:63501:63498:63500",
			["m"] = 811,
			["coord"] = 603966146,
			["f"] = 0,
		},
		[63501] = {
			"58843:60231:60230:59186", -- [1]
			"58843:60231:60232:66023", -- [2]
			"58843:60231:60230:59186:59732", -- [3]
			"58843:60231:60230:59186:59727", -- [4]
			"58843:60231:60230:59186:59735:59733", -- [5]
			"58843:60231:60230:59186:59735", -- [6]
			"58843:60231:60230:59186:59736", -- [7]
			"58843:60231:60232:66023:56737", -- [8]
			"58843:60231:60230", -- [9]
			"58843:60231", -- [10]
			"58843:60231:60232", -- [11]
			"58843:59049", -- [12]
			"59048:65189", -- [13]
			"59048:60441", -- [14]
			"63500:62903:61473:61744:61474", -- [15]
			"63500:62903:61473:61744:61118", -- [16]
			"63500:62903:61473:61744", -- [17]
			"63500:62903:61473:61744:61511", -- [18]
			"63500:62903:61473:60416:61504", -- [19]
			"63500:62903:61473:60416", -- [20]
			"63500:62903:61473", -- [21]
			"63497:61512", -- [22]
			"58843:60231:62658:61759", -- [23]
			"58843:60231:62658", -- [24]
			"63500:62903:62901", -- [25]
			"63500:62903", -- [26]
			"63500:62903:62898", -- [27]
			"63500:62903:62898:62909", -- [28]
			"58843:60231:60230:59186:64310", -- [29]
			"61121:65865", -- [30]
			"58843:59049:68226", -- [31]
			"58843:60231:60230:59186:71940", -- [32]
			["m"] = 858,
			["direct"] = "58843:59048:61121:63498:63500:63497:65511",
			["coord"] = 2397264188,
			["f"] = 0,
		},
		[60416] = {
			"61744:61474:61759:60230:59186", -- [1]
			"61744:61474:66023", -- [2]
			"61744:61474:61759:60230:59186:59732", -- [3]
			"61744:61474:61759:60230:59186:59727", -- [4]
			"61744:61474:61759:60230:59186:59735:59733", -- [5]
			"61744:61474:61759:60230:59186:59735", -- [6]
			"61744:61474:61759:60230:59186:59736", -- [7]
			"61744:61474:66023:56737", -- [8]
			"61744:61474:61759:60230", -- [9]
			"61744:61121:60231", -- [10]
			"61744:61474:60232", -- [11]
			"61744:61121:60231:59049", -- [12]
			"61473:62903:63500:63501:58843", -- [13]
			"61473:62903:63500:63501:59048", -- [14]
			"61473:62903:63500:63501:59048:65189", -- [15]
			"61744:61121:60231:59049:60441", -- [16]
			"61744:61474", -- [17]
			"61504:61118", -- [18]
			"61504:61511", -- [19]
			"61744:61474:61759", -- [20]
			"61744:61474:61759:62658", -- [21]
			"61512:62901", -- [22]
			"61473:62903", -- [23]
			"61512:62901:62898", -- [24]
			"61512:62901:62898:62909", -- [25]
			"61744:61121", -- [26]
			"61473:62903:63500:63501", -- [27]
			"61473:62903:63500:63501:63498", -- [28]
			"61473:62903:63500", -- [29]
			"61512:63497", -- [30]
			"61744:61474:61759:60230:59186:64310", -- [31]
			"61473:62903:63500:63501:65511", -- [32]
			"61744:61121:65865", -- [33]
			"61744:61474:66023:68226", -- [34]
			"61744:61474:61759:60230:59186:71940", -- [35]
			["direct"] = "61744:61504:61473:61512",
			["m"] = 809,
			["coord"] = 1836691981,
			["f"] = 0,
		},
		[58843] = {
			"60231:60230:59186", -- [1]
			"60231:60232:66023", -- [2]
			"60231:60230:59186:59732", -- [3]
			"60231:60230:59186:59727", -- [4]
			"60231:60230:59186:59735:59733", -- [5]
			"60231:60230:59186:59735", -- [6]
			"60231:60230:59186:59736", -- [7]
			"60231:60232:66023:56737", -- [8]
			"60231:60230", -- [9]
			"60231:60232", -- [10]
			"59048:60441", -- [11]
			"60231:62658:61759:61474", -- [12]
			"60231:62658:61759:61474:61118", -- [13]
			"60231:61121:61744", -- [14]
			"60231:62658:61759:61474:61118:61511", -- [15]
			"60231:62658:61759:61474:61504", -- [16]
			"63501:63500:62903:61473:60416", -- [17]
			"63501:63500:62903:61473", -- [18]
			"63501:63497:61512", -- [19]
			"60231:62658:61759", -- [20]
			"60231:62658", -- [21]
			"63501:63500:62903:62901", -- [22]
			"63501:63500:62903", -- [23]
			"63501:63500:62903:62898", -- [24]
			"63501:63500:62903:62898:62909", -- [25]
			"60231:61121", -- [26]
			"63501:63498", -- [27]
			"63501:63500", -- [28]
			"63501:63497", -- [29]
			"60231:60230:59186:64310", -- [30]
			"63501:65511", -- [31]
			"60231:61121:65865", -- [32]
			"59049:68226", -- [33]
			"60231:60230:59186:71940", -- [34]
			["direct"] = "60231:59049:59048:65189:63501",
			["m"] = 807,
			["coord"] = 867145195,
			["f"] = 0,
		},
		[60231] = {
			"60230:59186", -- [1]
			"60232:66023", -- [2]
			"60230:59186:59732", -- [3]
			"60230:59186:59727", -- [4]
			"60230:59186:59735:59733", -- [5]
			"60230:59186:59735", -- [6]
			"60230:59186:59736", -- [7]
			"60232:66023:56737", -- [8]
			"59049:60441", -- [9]
			"62658:61759:61474", -- [10]
			"62658:61759:61474:61118", -- [11]
			"61121:61744", -- [12]
			"62658:61759:61474:61118:61511", -- [13]
			"62658:61759:61474:61504", -- [14]
			"61121:61744:60416", -- [15]
			"61121:61744:61473", -- [16]
			"61121:61744:60416:61512", -- [17]
			"62658:61759", -- [18]
			"61121:61744:61473:62901", -- [19]
			"58843:63501:63500:62903", -- [20]
			"58843:63501:63500:62903:62898", -- [21]
			"58843:63501:63500:62903:62898:62909", -- [22]
			"58843:63501", -- [23]
			"58843:63501:63498", -- [24]
			"58843:63501:63500", -- [25]
			"61121:63497", -- [26]
			"60230:59186:64310", -- [27]
			"58843:63501:65511", -- [28]
			"61121:65865", -- [29]
			"59049:68226", -- [30]
			"60230:59186:71940", -- [31]
			["m"] = 807,
			["direct"] = "60230:60232:59049:58843:59048:65189:62658:61121",
			["coord"] = 2423357661,
			["f"] = 0,

		},
		[71940] = {
			"59186:66023", -- [1]
			"59186:59732", -- [2]
			"59186:59727", -- [3]
			"59186:59735:59733", -- [4]
			"59186:59735", -- [5]
			"59186:59736", -- [6]
			"59186:56737", -- [7]
			"59186:60230", -- [8]
			"59186:60230:60231", -- [9]
			"59186:60230:60232", -- [10]
			"59186:66023:68226:59049", -- [11]
			"59186:60230:60231:58843", -- [12]
			"59186:60230:60231:59048", -- [13]
			"59186:60230:60231:65189", -- [14]
			"59186:66023:68226:59049:60441", -- [15]
			"59186:60230:61759:61474", -- [16]
			"59186:60230:61759:61474:61118", -- [17]
			"59186:60230:61759:61474:61744", -- [18]
			"59186:60230:61759:61474:61118:61511", -- [19]
			"59186:60230:61759:61474:61504", -- [20]
			"59186:60230:61759:61474:61744:60416", -- [21]
			"59186:60230:61759:61474:61744:61473", -- [22]
			"59186:60230:61759:61474:61744:60416:61512", -- [23]
			"59186:60230:61759", -- [24]
			"59186:60230:62658", -- [25]
			"59186:60230:61759:61474:61744:61473:62901", -- [26]
			"59186:60230:61759:61474:61744:61473:62903", -- [27]
			"59186:60230:61759:61474:61744:61473:62903:62898", -- [28]
			"59186:60230:61759:61474:61744:61473:62903:62898:62909", -- [29]
			"59186:60230:61121", -- [30]
			"59186:60230:60231:58843:63501", -- [31]
			"59186:60230:60231:58843:63501:63498", -- [32]
			"59186:60230:61121:63500", -- [33]
			"59186:60230:61121:63497", -- [34]
			"59186:64310", -- [35]
			"59186:60230:60231:58843:63501:65511", -- [36]
			"59186:60230:61121:65865", -- [37]
			"59186:66023:68226", -- [38]
			["direct"] = "59186",
			["m"] = 951,
			["coord"] = 994620813,
			["f"] = 0,
		},
		[59733] = {
			"59732:59727", -- [1]
			"59732:59727:56737", -- [2]
			"59735:59186", -- [3]
			"59735:59186:66023", -- [4]
			"59735:59736", -- [5]
			"59735:59186:60230", -- [6]
			"59735:59186:60230:60231", -- [7]
			"59735:59186:60230:60232", -- [8]
			"59735:59186:66023:68226:59049", -- [9]
			"59735:59186:60230:60231:58843", -- [10]
			"59735:59186:60230:60231:59048", -- [11]
			"59735:59186:60230:60231:65189", -- [12]
			"59735:59186:66023:68226:59049:60441", -- [13]
			"59735:59186:60230:61759:61474", -- [14]
			"59735:59186:60230:61759:61474:61118", -- [15]
			"59735:59186:60230:61759:61474:61744", -- [16]
			"59735:59186:60230:61759:61474:61118:61511", -- [17]
			"59735:59186:60230:61759:61474:61504", -- [18]
			"59735:59186:60230:61759:61474:61744:60416", -- [19]
			"59735:59186:60230:61759:61474:61744:61473", -- [20]
			"59735:59186:60230:61759:61474:61744:60416:61512", -- [21]
			"59735:59186:60230:61759", -- [22]
			"59735:59186:60230:62658", -- [23]
			"59735:59186:60230:61759:61474:61744:61473:62901", -- [24]
			"59735:59186:60230:61759:61474:61744:61473:62903", -- [25]
			"59735:59186:60230:61759:61474:61744:61473:62903:62898", -- [26]
			"59735:59186:60230:61759:61474:61744:61473:62903:62898:62909", -- [27]
			"59735:59186:60230:61121", -- [28]
			"59735:59186:60230:60231:58843:63501", -- [29]
			"59735:59186:60230:60231:58843:63501:63498", -- [30]
			"59735:59186:60230:61121:63500", -- [31]
			"59735:59186:60230:61121:63497", -- [32]
			"59735:59186:64310", -- [33]
			"59735:59186:60230:60231:58843:63501:65511", -- [34]
			"59735:59186:60230:61121:65865", -- [35]
			"59735:59186:66023:68226", -- [36]
			"59735:59186:71940", -- [37]
			["direct"] = "59732:59735",
			["coord"] = 2380414099,
			["m"] = 806,
			["f"] = 0,
		},
		[59735] = {
			"59186:66023", -- [1]
			"59186:59732", -- [2]
			"59186:59727", -- [3]
			"59186:56737", -- [4]
			"59186:60230", -- [5]
			"59186:60230:60231", -- [6]
			"59186:60230:60232", -- [7]
			"59186:60230:60231:58843", -- [8]
			"59186:60230:60231:59048", -- [9]
			"59186:60230:60231:65189", -- [10]
			"59186:60230:61759:61474", -- [11]
			"59186:60230:61759:61474:61118", -- [12]
			"59186:60230:61759:61474:61744", -- [13]
			"59186:60230:61759:61474:61118:61511", -- [14]
			"59186:60230:61759:61474:61504", -- [15]
			"59186:60230:61759:61474:61744:60416", -- [16]
			"59186:60230:61759:61474:61744:61473", -- [17]
			"59186:60230:61759:61474:61744:60416:61512", -- [18]
			"59186:60230:61759", -- [19]
			"59186:60230:62658", -- [20]
			"59186:60230:61759:61474:61744:61473:62901", -- [21]
			"59186:60230:61759:61474:61744:61473:62903", -- [22]
			"59186:60230:61759:61474:61744:61473:62903:62898", -- [23]
			"59186:60230:61759:61474:61744:61473:62903:62898:62909", -- [24]
			"59186:60230:61121", -- [25]
			"59186:60230:60231:58843:63501", -- [26]
			"59186:60230:60231:58843:63501:63498", -- [27]
			"59186:60230:61121:63500", -- [28]
			"59186:60230:61121:63497", -- [29]
			"59186:64310", -- [30]
			"59186:60230:60231:58843:63501:65511", -- [31]
			"59186:66023:68226:59049", -- [32]
			"59186:66023:68226:59049:60441", -- [33]
			"59186:60230:61121:65865", -- [34]
			"59186:66023:68226", -- [35]
			"59186:71940", -- [36]
			["direct"] = "59186:59733:59736",
			["f"] = 0,
			["m"] = 806,
			["coord"] = 2184266964,
		},
		[59048] = {
			"60231:60230:59186", -- [1]
			"60231:60232:66023", -- [2]
			"60231:60230:59186:59732", -- [3]
			"60231:60230:59186:59727", -- [4]
			"60231:60230:59186:59735:59733", -- [5]
			"60231:60230:59186:59735", -- [6]
			"60231:60230:59186:59736", -- [7]
			"60231:60232:66023:56737", -- [8]
			"60231:60230", -- [9]
			"60231:60232", -- [10]
			"60231:62658:61759:61474", -- [11]
			"60231:62658:61759:61474:61118", -- [12]
			"60231:61121:61744", -- [13]
			"60231:62658:61759:61474:61118:61511", -- [14]
			"60231:62658:61759:61474:61504", -- [15]
			"63501:63500:62903:61473:60416", -- [16]
			"63501:63500:62903:61473", -- [17]
			"63501:63497:61512", -- [18]
			"60231:62658:61759", -- [19]
			"60231:62658", -- [20]
			"63501:63500:62903:62901", -- [21]
			"63501:63500:62903", -- [22]
			"63501:63500:62903:62898", -- [23]
			"63501:63500:62903:62898:62909", -- [24]
			"60231:61121", -- [25]
			"63501:63498", -- [26]
			"63501:63500", -- [27]
			"63501:63497", -- [28]
			"60231:60230:59186:64310", -- [29]
			"63501:65511", -- [30]
			"60231:61121:65865", -- [31]
			"59049:68226", -- [32]
			"60231:60230:59186:71940", -- [33]
			["direct"] = "60231:59049:58843:65189:60441:63501",
			["m"] = 857,
			["coord"] = 1078941108,
			["f"] = 0,
		},
		[61759] = {
			"60230:59186", -- [1]
			"60230:60232:66023", -- [2]
			"60230:59186:59732", -- [3]
			"60230:59186:59727", -- [4]
			"60230:59186:59735:59733", -- [5]
			"60230:59186:59735", -- [6]
			"60230:59186:59736", -- [7]
			"60230:60232:66023:56737", -- [8]

			"62658:60231", -- [9]
			"60230:60232", -- [10]
			"62658:60231:59049", -- [11]
			"62658:60231:58843", -- [12]
			"62658:60231:59048", -- [13]
			"62658:60231:65189", -- [14]
			"62658:60231:59049:60441", -- [15]
			"61474:61118", -- [16]
			"61474:61744", -- [17]
			"61474:61118:61511", -- [18]
			"61474:61504", -- [19]
			"61474:61744:60416", -- [20]
			"61474:61744:61473", -- [21]
			"61474:61744:60416:61512", -- [22]
			"61474:61744:61473:62901", -- [23]
			"61474:61744:61473:62903", -- [24]
			"61474:61744:61473:62903:62898", -- [25]
			"61474:61744:61473:62903:62898:62909", -- [26]
			"62658:61121", -- [27]
			"62658:60231:58843:63501", -- [28]
			"62658:60231:58843:63501:63498", -- [29]
			"61474:61744:61473:62903:63500", -- [30]
			"62658:61121:63497", -- [31]
			"60230:59186:64310", -- [32]
			"62658:60231:58843:63501:65511", -- [33]
			"62658:61121:65865", -- [34]
			"60230:60232:66023:68226", -- [35]
			"60230:59186:71940", -- [36]
			["direct"] = "60230:61474:62658",
			["m"] = 873,
			["coord"] = 2433139115,
			["f"] = 0,
		},
		[61511] = {
			"61118:61474:61759:60230:59186", -- [1]
			"61118:61474:66023", -- [2]
			"61118:61474:61759:60230:59186:59732", -- [3]
			"61118:61474:61759:60230:59186:59727", -- [4]
			"61118:61474:61759:60230:59186:59735:59733", -- [5]
			"61118:61474:61759:60230:59186:59735", -- [6]
			"61118:61474:61759:60230:59186:59736", -- [7]
			"61118:61474:66023:56737", -- [8]
			"61118:61474:61759:60230", -- [9]
			"61118:61474:61759:62658:60231", -- [10]
			"61118:61474:60232", -- [11]
			"61118:61474:61759:62658:60231:59049", -- [12]
			"61118:61474:61759:62658:60231:58843", -- [13]
			"61118:61474:61759:62658:60231:59048", -- [14]
			"61118:61474:61759:62658:60231:65189", -- [15]
			"61118:61474:61759:62658:60231:59049:60441", -- [16]
			"61118:61474", -- [17]
			"61504:60416", -- [18]
			"61744:61473", -- [19]
			"61504:60416:61512", -- [20]
			"61118:61474:61759", -- [21]
			"61118:61474:61759:62658", -- [22]
			"61744:61473:62901", -- [23]
			"61744:61473:62903", -- [24]
			"61744:61473:62903:62898", -- [25]
			"61744:61473:62903:62898:62909", -- [26]
			"61744:61121", -- [27]
			"61744:61473:62903:63500:63501", -- [28]
			"61744:61473:62903:63500:63501:63498", -- [29]
			"61744:61473:62903:63500", -- [30]
			"61744:61121:63497", -- [31]
			"61118:61474:61759:60230:59186:64310", -- [32]
			"61744:61473:62903:63500:63501:65511", -- [33]
			"61744:61121:65865", -- [34]
			"61118:61474:66023:68226", -- [35]
			"61118:61474:61759:60230:59186:71940", -- [36]
			["direct"] = "61118:61744:61504",
			["m"] = 809,
			["coord"] = 2681621770,
			["f"] = 0,
		},
		[62901] = {
			"61473:61744:61474:61759:60230:59186", -- [1]
			"61473:61744:61474:66023", -- [2]
			"61473:61744:61474:61759:60230:59186:59732", -- [3]
			"61473:61744:61474:61759:60230:59186:59727", -- [4]
			"61473:61744:61474:61759:60230:59186:59735:59733", -- [5]
			"61473:61744:61474:61759:60230:59186:59735", -- [6]
			"61473:61744:61474:61759:60230:59186:59736", -- [7]
			"61473:61744:61474:66023:56737", -- [8]
			"61473:61744:61474:61759:60230", -- [9]
			"61473:61744:61121:60231", -- [10]
			"61473:61744:61474:60232", -- [11]
			"61473:61744:61121:60231:59049", -- [12]
			"62903:63500:63501:58843", -- [13]
			"62903:63500:63501:59048", -- [14]
			"62903:63500:63501:59048:65189", -- [15]
			"62903:63500:63501:59048:60441", -- [16]
			"61473:61744:61474", -- [17]
			"61512:60416:61504:61118", -- [18]
			"61473:61744", -- [19]
			"61512:60416:61504:61511", -- [20]
			"61512:60416:61504", -- [21]
			"61512:60416", -- [22]
			"61473:61744:61474:61759", -- [23]
			"61473:61744:61474:61759:62658", -- [24]
			"62898:62909", -- [25]
			"61473:61744:61121", -- [26]
			"62903:63500:63501", -- [27]
			"62903:63500:63501:63498", -- [28]
			"62903:63500", -- [29]
			"62903:63500:63497", -- [30]
			"61473:61744:61474:61759:60230:59186:64310", -- [31]
			"62903:63500:63501:65511", -- [32]
			"61473:61744:61121:65865", -- [33]
			"61473:61744:61474:66023:68226", -- [34]
			"61473:61744:61474:61759:60230:59186:71940", -- [35]
			["direct"] = "61473:61512:62903:62898",
			["m"] = 810,
			["coord"] = 3054473921,
			["f"] = 0,
		},
		[59186] = {
			"59735:59733", -- [1]
			"60230:60231", -- [2]
			"60230:60232", -- [3]
			"66023:68226:59049", -- [4]
			"60230:60231:58843", -- [5]
			"60230:60231:59048", -- [6]
			"60230:60231:65189", -- [7]
			"66023:68226:59049:60441", -- [8]
			"60230:61759:61474", -- [9]
			"60230:61759:61474:61118", -- [10]
			"60230:61759:61474:61744", -- [11]
			"60230:61759:61474:61118:61511", -- [12]
			"60230:61759:61474:61504", -- [13]
			"60230:61759:61474:61744:60416", -- [14]
			"60230:61759:61474:61744:61473", -- [15]
			"60230:61759:61474:61744:60416:61512", -- [16]
			"60230:61759", -- [17]
			"60230:62658", -- [18]
			"60230:61759:61474:61744:61473:62901", -- [19]
			"60230:61759:61474:61744:61473:62903", -- [20]
			"60230:61759:61474:61744:61473:62903:62898", -- [21]
			"60230:61759:61474:61744:61473:62903:62898:62909", -- [22]
			"60230:60231:58843:63501", -- [23]
			"60230:60231:58843:63501:63498", -- [24]
			"60230:61121:63500", -- [25]
			"60230:61121:63497", -- [26]
			"60230:60231:58843:63501:65511", -- [27]
			"60230:61121:65865", -- [28]
			"66023:68226", -- [29]
			["m"] = 806,
			["direct"] = "66023:59732:59727:59735:59736:56737:60230:61121:64310:71940",
			["coord"] = 2019915307,
			["f"] = 0,
		},
		[62909] = {
			"62898:62903:61473:61744:61474:61759:60230:59186", -- [1]
			"62898:62903:61473:61744:61474:66023", -- [2]
			"62898:62903:61473:61744:61474:61759:60230:59186:59732", -- [3]
			"62898:62903:61473:61744:61474:61759:60230:59186:59727", -- [4]
			"62898:62903:61473:61744:61474:61759:60230:59186:59735:59733", -- [5]
			"62898:62903:61473:61744:61474:61759:60230:59186:59735", -- [6]
			"62898:62903:61473:61744:61474:61759:60230:59186:59736", -- [7]
			"62898:62903:61473:61744:61474:66023:56737", -- [8]
			"62898:62903:61473:61744:61474:61759:60230", -- [9]
			"62898:62903:63500:63501:58843:60231", -- [10]
			"62898:62903:61473:61744:61474:60232", -- [11]
			"62898:62903:63500:63501:58843:59049", -- [12]
			"62898:62903:63500:63501:58843", -- [13]
			"62898:62903:63500:63501:59048", -- [14]
			"62898:62903:63500:63501:59048:65189", -- [15]
			"62898:62903:63500:63501:59048:60441", -- [16]
			"62898:62903:61473:61744:61474", -- [17]
			"62898:62903:61473:61744:61118", -- [18]
			"62898:62903:61473:61744", -- [19]
			"62898:62903:61473:61744:61511", -- [20]
			"62898:62901:61512:60416:61504", -- [21]
			"62898:62901:61512:60416", -- [22]
			"62898:62903:61473", -- [23]
			"62898:62901:61512", -- [24]
			"62898:62903:61473:61744:61474:61759", -- [25]
			"62898:62903:61473:61744:61474:61759:62658", -- [26]
			"62898:62901", -- [27]
			"62898:62903", -- [28]
			"62898:62903:61473:61744:61121", -- [29]
			"62898:62903:63500:63501", -- [30]
			"62898:62903:63500:63501:63498", -- [31]
			"62898:62903:63500", -- [32]
			"62898:62903:63500:63497", -- [33]
			"62898:62903:61473:61744:61474:61759:60230:59186:64310", -- [34]
			"62898:62903:63500:63501:65511", -- [35]
			"62898:62903:61473:61744:61121:65865", -- [36]
			"62898:62903:61473:61744:61474:66023:68226", -- [37]
			"62898:62903:61473:61744:61474:61759:60230:59186:71940", -- [38]
			["direct"] = "62898",
			["m"] = 810,
			["coord"] = 2149759023,
			["f"] = 0,
		},
		[56737] = {
			"59727:59732", -- [1]
			"59727:59732:59733", -- [2]
			"59186:59735", -- [3]
			"59186:59736", -- [4]
			"66023:60232:60230", -- [5]
			"66023:60232:60231", -- [6]
			"66023:60232", -- [7]
			"66023:68226:59049", -- [8]
			"66023:60232:60231:58843", -- [9]
			"66023:68226:59049:59048", -- [10]
			"66023:68226:59049:65189", -- [11]
			"66023:68226:59049:60441", -- [12]
			"66023:61474", -- [13]
			"66023:61474:61118", -- [14]
			"66023:61474:61744", -- [15]
			"66023:61474:61118:61511", -- [16]
			"66023:61474:61504", -- [17]
			"66023:61474:61744:60416", -- [18]
			"66023:61474:61744:61473", -- [19]
			"66023:61474:61744:60416:61512", -- [20]
			"66023:60232:60230:61759", -- [21]
			"66023:60232:60230:62658", -- [22]
			"66023:61474:61744:61473:62901", -- [23]
			"66023:61474:61744:61473:62903", -- [24]
			"66023:61474:61744:61473:62903:62898", -- [25]
			"66023:61474:61744:61473:62903:62898:62909", -- [26]
			"66023:61121", -- [27]
			"66023:60232:60231:58843:63501", -- [28]
			"66023:60232:60231:58843:63501:63498", -- [29]
			"66023:61121:63500", -- [30]
			"66023:61121:63497", -- [31]
			"66023:60232:60231:58843:63501:65511", -- [32]
			"66023:61121:65865", -- [33]
			"66023:68226", -- [34]
			"59186:71940", -- [35]
			["direct"] = "59186:66023:59727:64310",
			["m"] = 806,
			["coord"] = 2488849181,
			["f"] = 0,
		},
		[66023] = {
			"59727:59732", -- [1]
			"59727:59732:59733", -- [2]
			"59186:59735", -- [3]
			"59186:59736", -- [4]
			"60232:60230", -- [5]
			"60232:60231", -- [6]
			"68226:59049", -- [7]
			"60232:60231:58843", -- [8]
			"68226:59049:59048", -- [9]
			"68226:59049:65189", -- [10]
			"68226:59049:60441", -- [11]
			"61474:61118", -- [12]
			"61474:61744", -- [13]
			"61474:61118:61511", -- [14]
			"61474:61504", -- [15]
			"61474:61744:60416", -- [16]
			"61474:61744:61473", -- [17]
			"61474:61744:60416:61512", -- [18]
			"60232:60230:61759", -- [19]
			"60232:60230:62658", -- [20]
			"61474:61744:61473:62901", -- [21]
			"61474:61744:61473:62903", -- [22]
			"61474:61744:61473:62903:62898", -- [23]
			"61474:61744:61473:62903:62898:62909", -- [24]
			"60232:60231:58843:63501", -- [25]
			"60232:60231:58843:63501:63498", -- [26]
			"61121:63500", -- [27]
			"61121:63497", -- [28]
			"56737:64310", -- [29]
			"60232:60231:58843:63501:65511", -- [30]
			"61121:65865", -- [31]
			"59186:71940", -- [32]
			["m"] = 806,
			["direct"] = "59186:59727:56737:60232:61474:61121:68226",
			["coord"] = 1977276871,
			["f"] = 0,
		},
		[65189] = {
			"60231:60230:59186", -- [1]
			"60231:60232:66023", -- [2]
			"60231:60230:59186:59732", -- [3]
			"60231:60230:59186:59727", -- [4]
			"60231:60230:59186:59735:59733", -- [5]
			"60231:60230:59186:59735", -- [6]
			"60231:60230:59186:59736", -- [7]
			"60231:60232:66023:56737", -- [8]
			"60231:60230", -- [9]
			"60231:60232", -- [10]
			"60231:62658:61759:61474", -- [11]
			"60231:62658:61759:61474:61118", -- [12]
			"60231:61121:61744", -- [13]
			"60231:62658:61759:61474:61118:61511", -- [14]
			"60231:62658:61759:61474:61504", -- [15]
			"59048:63501:63500:62903:61473:60416", -- [16]
			"59048:63501:63500:62903:61473", -- [17]
			"59048:63501:63497:61512", -- [18]
			"60231:62658:61759", -- [19]
			"60231:62658", -- [20]
			"59048:63501:63500:62903:62901", -- [21]
			"59048:63501:63500:62903", -- [22]
			"59048:63501:63500:62903:62898", -- [23]
			"59048:63501:63500:62903:62898:62909", -- [24]
			"60231:61121", -- [25]
			"59048:63501", -- [26]
			"59048:63501:63498", -- [27]
			"59048:63501:63500", -- [28]
			"59048:63501:63497", -- [29]
			"60231:60230:59186:64310", -- [30]
			"59048:63501:65511", -- [31]
			"60231:61121:65865", -- [32]
			"59049:68226", -- [33]
			"60231:60230:59186:71940", -- [34]
			["direct"] = "60231:59049:58843:59048:60441",
			["m"] = 857,
			["coord"] = 1341694345,
			["f"] = 0,
		},
		[61474] = {
			"61759:60230:59186", -- [1]
			"61759:60230:59186:59732", -- [2]
			"61759:60230:59186:59727", -- [3]
			"61759:60230:59186:59735:59733", -- [4]
			"61759:60230:59186:59735", -- [5]
			"61759:60230:59186:59736", -- [6]
			"66023:56737", -- [7]
			"61759:60230", -- [8]
			"61759:62658:60231", -- [9]
			"61759:62658:60231:59049", -- [10]
			"61759:62658:60231:58843", -- [11]
			"61759:62658:60231:59048", -- [12]
			"61759:62658:60231:65189", -- [13]
			"61759:62658:60231:59049:60441", -- [14]
			"61118:61511", -- [15]
			"61744:60416", -- [16]
			"61744:61473", -- [17]
			"61744:60416:61512", -- [18]
			"61759:62658", -- [19]
			"61744:61473:62901", -- [20]
			"61744:61473:62903", -- [21]
			"61744:61473:62903:62898", -- [22]
			"61744:61473:62903:62898:62909", -- [23]
			"61744:61473:62903:63500:63501", -- [24]
			"61744:61473:62903:63500:63501:63498", -- [25]
			"61744:61473:62903:63500", -- [26]
			"61121:63497", -- [27]
			"61759:60230:59186:64310", -- [28]
			"61744:61473:62903:63500:63501:65511", -- [29]
			"61121:65865", -- [30]
			"66023:68226", -- [31]
			"61759:60230:59186:71940", -- [32]
			["m"] = 809,
			["direct"] = "66023:60232:61118:61744:61504:61759:61121",
			["coord"] = 3112759555,
			["f"] = 0,
		},
		[65865] = {
			"61121:60230:59186", -- [1]
			"61121:66023", -- [2]
			"61121:60230:59186:59732", -- [3]
			"61121:60230:59186:59727", -- [4]
			"61121:60230:59186:59735:59733", -- [5]
			"61121:60230:59186:59735", -- [6]
			"61121:60230:59186:59736", -- [7]
			"61121:66023:56737", -- [8]
			"61121:60230", -- [9]
			"61121:60231", -- [10]
			"61121:60231:60232", -- [11]
			"61121:60231:59049", -- [12]
			"61121:60231:58843", -- [13]
			"61121:60231:59048", -- [14]
			"61121:60231:65189", -- [15]
			"61121:60231:59049:60441", -- [16]
			"61121:61474", -- [17]
			"61121:61744:61118", -- [18]
			"61121:61744", -- [19]
			"61121:61744:61511", -- [20]
			"61121:61744:61504", -- [21]
			"61121:61744:60416", -- [22]
			"61121:61744:61473", -- [23]
			"61121:61744:60416:61512", -- [24]
			"61121:62658:61759", -- [25]
			"61121:62658", -- [26]
			"61121:61744:61473:62901", -- [27]
			"61121:61744:61473:62903", -- [28]
			"61121:61744:61473:62903:62898", -- [29]
			"61121:61744:61473:62903:62898:62909", -- [30]
			"61121:63501", -- [31]
			"61121:63497:63498", -- [32]
			"61121:63500", -- [33]
			"61121:63497", -- [34]
			"61121:60230:59186:64310", -- [35]
			"61121:63501:65511", -- [36]
			"61121:60231:59049:68226", -- [37]
			"61121:60230:59186:71940", -- [38]
			["direct"] = "61121",
			["m"] = 858,
			["f"] = 0,
			["coord"] = 3161543925,
		},
		[61121] = {
			"60230:59186:59732", -- [1]
			"60230:59186:59727", -- [2]
			"60230:59186:59735:59733", -- [3]
			"60230:59186:59735", -- [4]
			"60230:59186:59736", -- [5]
			"66023:56737", -- [6]
			"60231:60232", -- [7]
			"60231:59049", -- [8]
			"60231:58843", -- [9]
			"60231:59048", -- [10]
			"60231:65189", -- [11]
			"60231:59049:60441", -- [12]
			"61744:61118", -- [13]
			"61744:61511", -- [14]
			"61744:61504", -- [15]
			"61744:60416", -- [16]
			"61744:61473", -- [17]
			"61744:60416:61512", -- [18]
			"62658:61759", -- [19]
			"61744:61473:62901", -- [20]
			"61744:61473:62903", -- [21]
			"61744:61473:62903:62898", -- [22]
			"61744:61473:62903:62898:62909", -- [23]
			"63497:63498", -- [24]
			"60230:59186:64310", -- [25]
			"63501:65511", -- [26]
			"60231:59049:68226", -- [27]
			"60230:59186:71940", -- [28]
			["m"] = 811,
			["direct"] = "59186:66023:60230:60231:61474:61744:62658:63501:63500:63497:65865",
			["coord"] = 3639844738,
			["f"] = 0,
		},
		[63498] = {
			"63501:58843:60231:60230:59186", -- [1]
			"63501:58843:60231:60232:66023", -- [2]
			"63501:58843:60231:60230:59186:59732", -- [3]
			"63501:58843:60231:60230:59186:59727", -- [4]
			"63501:58843:60231:60230:59186:59735:59733", -- [5]
			"63501:58843:60231:60230:59186:59735", -- [6]
			"63501:58843:60231:60230:59186:59736", -- [7]
			"63501:58843:60231:60232:66023:56737", -- [8]
			"63501:58843:60231:60230", -- [9]
			"63501:58843:60231", -- [10]
			"63501:58843:60231:60232", -- [11]
			"63501:58843:59049", -- [12]
			"63501:58843", -- [13]
			"63501:59048", -- [14]
			"63501:59048:65189", -- [15]
			"63501:59048:60441", -- [16]
			"63501:63500:62903:61473:61744:61474", -- [17]
			"63501:63500:62903:61473:61744:61118", -- [18]
			"63501:63500:62903:61473:61744", -- [19]
			"63501:63500:62903:61473:61744:61511", -- [20]
			"63501:63500:62903:61473:60416:61504", -- [21]
			"63501:63500:62903:61473:60416", -- [22]
			"63501:63500:62903:61473", -- [23]
			"63497:61512", -- [24]
			"63501:58843:60231:62658:61759", -- [25]
			"63501:58843:60231:62658", -- [26]
			"63501:63500:62903:62901", -- [27]
			"63501:63500:62903", -- [28]
			"63501:63500:62903:62898", -- [29]
			"63501:63500:62903:62898:62909", -- [30]
			"63497:61121", -- [31]
			"63501:63500", -- [32]
			"63501:58843:60231:60230:59186:64310", -- [33]
			"63497:61121:65865", -- [34]
			"63501:58843:59049:68226", -- [35]
			"63501:58843:60231:60230:59186:71940", -- [36]
			["direct"] = "63501:63497:65511",
			["m"] = 858,
			["coord"] = 2410197898,
			["f"] = 0,
		},
		[63500] = {
			"63501:58843:60231:60230:59186", -- [1]
			"63501:58843:60231:60232:66023", -- [2]
			"63501:58843:60231:60230:59186:59732", -- [3]
			"63501:58843:60231:60230:59186:59727", -- [4]
			"63501:58843:60231:60230:59186:59735:59733", -- [5]
			"63501:58843:60231:60230:59186:59735", -- [6]
			"63501:58843:60231:60230:59186:59736", -- [7]
			"63501:58843:60231:60232:66023:56737", -- [8]
			"63501:58843:60231:60230", -- [9]
			"63501:58843:60231", -- [10]
			"63501:58843:60231:60232", -- [11]
			"63501:58843:59049", -- [12]
			"63501:58843", -- [13]
			"63501:59048", -- [14]
			"63501:59048:65189", -- [15]
			"63501:59048:60441", -- [16]
			"62903:61473:61744:61474", -- [17]
			"62903:61473:61744:61118", -- [18]
			"62903:61473:61744", -- [19]
			"62903:61473:61744:61511", -- [20]
			"62903:61473:60416:61504", -- [21]
			"62903:61473:60416", -- [22]
			"62903:61473", -- [23]
			"62903:62901:61512", -- [24]
			"63501:58843:60231:62658:61759", -- [25]
			"63501:58843:60231:62658", -- [26]
			"62903:62901", -- [27]
			"62903:62898", -- [28]
			"62903:62898:62909", -- [29]
			"63501:63498", -- [30]
			"63501:58843:60231:60230:59186:64310", -- [31]
			"63501:65511", -- [32]
			"61121:65865", -- [33]
			"63501:58843:59049:68226", -- [34]
			"63501:58843:60231:60230:59186:71940", -- [35]
			["direct"] = "62903:61121:63501:63497",
			["m"] = 858,
			["coord"] = 2156863265,
			["f"] = 0,
		},
		[59727] = {
			"59732:59733", -- [1]
			"59186:59735", -- [2]
			"59186:59736", -- [3]
			"59186:60230", -- [4]
			"66023:60232:60231", -- [5]
			"66023:60232", -- [6]
			"66023:68226:59049", -- [7]
			"66023:60232:60231:58843", -- [8]
			"66023:68226:59049:59048", -- [9]
			"66023:68226:59049:65189", -- [10]
			"66023:68226:59049:60441", -- [11]
			"66023:61474", -- [12]
			"66023:61474:61118", -- [13]
			"66023:61474:61744", -- [14]
			"66023:61474:61118:61511", -- [15]
			"66023:61474:61504", -- [16]
			"66023:61474:61744:60416", -- [17]
			"66023:61474:61744:61473", -- [18]
			"66023:61474:61744:60416:61512", -- [19]
			"59186:60230:61759", -- [20]
			"59186:60230:62658", -- [21]
			"66023:61474:61744:61473:62901", -- [22]
			"66023:61474:61744:61473:62903", -- [23]
			"66023:61474:61744:61473:62903:62898", -- [24]
			"66023:61474:61744:61473:62903:62898:62909", -- [25]
			"66023:61121", -- [26]
			"66023:60232:60231:58843:63501", -- [27]
			"66023:60232:60231:58843:63501:63498", -- [28]
			"66023:61121:63500", -- [29]
			"66023:61121:63497", -- [30]
			"56737:64310", -- [31]
			"66023:60232:60231:58843:63501:65511", -- [32]
			"66023:61121:65865", -- [33]
			"66023:68226", -- [34]
			"59186:71940", -- [35]
			["direct"] = "59186:66023:59732:56737",
			["m"] = 806,
			["coord"] = 2343935577,
			["f"] = 0,
		},
		[60441] = {
			"59049:60231:60230:59186", -- [1]
			"59049:68226:66023", -- [2]
			"59049:60231:60230:59186:59732", -- [3]
			"59049:68226:66023:59727", -- [4]
			"59049:60231:60230:59186:59735:59733", -- [5]
			"59049:60231:60230:59186:59735", -- [6]
			"59049:60231:60230:59186:59736", -- [7]
			"59049:68226:66023:56737", -- [8]
			"59049:60231:60230", -- [9]
			"59049:60231", -- [10]
			"59049:60231:60232", -- [11]
			"65189:58843", -- [12]
			"59049:60231:62658:61759:61474", -- [13]
			"59049:60231:62658:61759:61474:61118", -- [14]
			"59049:60231:61121:61744", -- [15]
			"59049:60231:62658:61759:61474:61118:61511", -- [16]
			"59049:60231:62658:61759:61474:61504", -- [17]
			"59049:60231:61121:61744:60416", -- [18]
			"59049:60231:61121:61744:61473", -- [19]
			"59048:63501:63497:61512", -- [20]
			"59049:60231:62658:61759", -- [21]
			"59049:60231:62658", -- [22]
			"59048:63501:63500:62903:62901", -- [23]
			"59048:63501:63500:62903", -- [24]
			"59048:63501:63500:62903:62898", -- [25]
			"59048:63501:63500:62903:62898:62909", -- [26]
			"59049:60231:61121", -- [27]
			"59048:63501", -- [28]
			"59048:63501:63498", -- [29]
			"59048:63501:63500", -- [30]
			"59048:63501:63497", -- [31]
			"59049:68226:66023:56737:64310", -- [32]
			"59048:63501:65511", -- [33]
			"59049:60231:61121:65865", -- [34]
			"59049:68226", -- [35]
			"59049:60231:60230:59186:71940", -- [36]
			["direct"] = "59049:59048:65189",
			["m"] = 857,
			["coord"] = 2250687510,
			["f"] = 0,
		},
		[60230] = {
			"60232:66023", -- [1]
			"59186:59732", -- [2]
			"59186:59727", -- [3]
			"59186:59735:59733", -- [4]
			"59186:59735", -- [5]
			"59186:59736", -- [6]
			"60232:66023:56737", -- [7]
			"60231:59049", -- [8]
			"60231:58843", -- [9]
			"60231:59048", -- [10]
			"60231:65189", -- [11]
			"60231:59049:60441", -- [12]
			"61759:61474", -- [13]
			"61759:61474:61118", -- [14]
			"61759:61474:61744", -- [15]
			"61759:61474:61118:61511", -- [16]
			"61759:61474:61504", -- [17]
			"61759:61474:61744:60416", -- [18]
			"61759:61474:61744:61473", -- [19]
			"61759:61474:61744:60416:61512", -- [20]
			"61759:61474:61744:61473:62901", -- [21]
			"61759:61474:61744:61473:62903", -- [22]
			"61759:61474:61744:61473:62903:62898", -- [23]
			"61759:61474:61744:61473:62903:62898:62909", -- [24]
			"60231:58843:63501", -- [25]
			"60231:58843:63501:63498", -- [26]
			"61121:63500", -- [27]
			"61121:63497", -- [28]
			"59186:64310", -- [29]
			"60231:58843:63501:65511", -- [30]
			"61121:65865", -- [31]
			"60232:66023:68226", -- [32]
			"59186:71940", -- [33]
			["direct"] = "59186:60231:60232:61759:62658:61121",
			["m"] = 807,
			["coord"] = 3629594111,
			["f"] = 0,
		},
		[60232] = {
			"60230:59186", -- [1]
			"60230:59186:59732", -- [2]
			"66023:59727", -- [3]
			"60230:59186:59735:59733", -- [4]
			"60230:59186:59735", -- [5]
			"60230:59186:59736", -- [6]
			"66023:56737", -- [7]
			"60231:59049", -- [8]
			"60231:58843", -- [9]
			"60231:59048", -- [10]
			"60231:65189", -- [11]
			"60231:59049:60441", -- [12]
			"61474:61118", -- [13]
			"61474:61744", -- [14]
			"61474:61118:61511", -- [15]
			"61474:61504", -- [16]
			"61474:61744:60416", -- [17]
			"61474:61744:61473", -- [18]
			"61474:61744:60416:61512", -- [19]
			"60230:61759", -- [20]
			"60230:62658", -- [21]
			"61474:61744:61473:62901", -- [22]
			"61474:61744:61473:62903", -- [23]
			"61474:61744:61473:62903:62898", -- [24]
			"61474:61744:61473:62903:62898:62909", -- [25]
			"60231:61121", -- [26]
			"60231:58843:63501", -- [27]
			"60231:58843:63501:63498", -- [28]
			"60231:58843:63501:63500", -- [29]
			"60231:61121:63497", -- [30]
			"66023:56737:64310", -- [31]
			"60231:58843:63501:65511", -- [32]
			"60231:61121:65865", -- [33]
			"66023:68226", -- [34]
			"60230:59186:71940", -- [35]
			["direct"] = "66023:60230:60231:61474",
			["m"] = 857,
			["coord"] = 3294762427,
			["f"] = 0,
		},
		[61118] = {
			"61474:61759:60230:59186", -- [1]
			"61474:66023", -- [2]
			"61474:61759:60230:59186:59732", -- [3]
			"61474:61759:60230:59186:59727", -- [4]
			"61474:61759:60230:59186:59735:59733", -- [5]
			"61474:61759:60230:59186:59735", -- [6]
			"61474:61759:60230:59186:59736", -- [7]
			"61474:66023:56737", -- [8]
			"61474:61759:60230", -- [9]
			"61474:61759:62658:60231", -- [10]
			"61474:60232", -- [11]
			"61474:61759:62658:60231:59049", -- [12]
			"61474:61759:62658:60231:58843", -- [13]
			"61474:61759:62658:60231:59048", -- [14]
			"61474:61759:62658:60231:65189", -- [15]
			"61474:61759:62658:60231:59049:60441", -- [16]
			"61504:60416", -- [17]
			"61744:61473", -- [18]
			"61504:60416:61512", -- [19]
			"61474:61759", -- [20]
			"61474:61759:62658", -- [21]
			"61744:61473:62901", -- [22]
			"61744:61473:62903", -- [23]
			"61744:61473:62903:62898", -- [24]
			"61744:61473:62903:62898:62909", -- [25]
			"61744:61121", -- [26]
			"61744:61473:62903:63500:63501", -- [27]
			"61744:61473:62903:63500:63501:63498", -- [28]
			"61744:61473:62903:63500", -- [29]
			"61744:61121:63497", -- [30]
			"61474:61759:60230:59186:64310", -- [31]
			"61744:61473:62903:63500:63501:65511", -- [32]
			"61744:61121:65865", -- [33]
			"61474:66023:68226", -- [34]
			"61474:61759:60230:59186:71940", -- [35]
			["direct"] = "61474:61744:61511:61504",
			["m"] = 809,
			["coord"] = 2847310267,
			["f"] = 0,
		},
		[59732] = {
			"59727:66023", -- [1]
			"59186:59735", -- [2]
			"59186:59736", -- [3]
			"59727:56737", -- [4]
			"59186:60230", -- [5]
			"59186:60230:60231", -- [6]
			"59727:66023:60232", -- [7]
			"59727:66023:68226:59049", -- [8]
			"59186:60230:60231:58843", -- [9]
			"59186:60230:60231:59048", -- [10]
			"59186:60230:60231:65189", -- [11]
			"59727:66023:68226:59049:60441", -- [12]
			"59186:60230:61759:61474", -- [13]
			"59186:60230:61759:61474:61118", -- [14]
			"59186:60230:61759:61474:61744", -- [15]
			"59186:60230:61759:61474:61118:61511", -- [16]
			"59186:60230:61759:61474:61504", -- [17]
			"59186:60230:61759:61474:61744:60416", -- [18]
			"59186:60230:61759:61474:61744:61473", -- [19]
			"59186:60230:61759:61474:61744:60416:61512", -- [20]
			"59186:60230:61759", -- [21]
			"59186:60230:62658", -- [22]
			"59186:60230:61759:61474:61744:61473:62901", -- [23]
			"59186:60230:61759:61474:61744:61473:62903", -- [24]
			"59186:60230:61759:61474:61744:61473:62903:62898", -- [25]
			"59186:60230:61759:61474:61744:61473:62903:62898:62909", -- [26]
			"59186:60230:61121", -- [27]
			"59186:60230:60231:58843:63501", -- [28]
			"59186:60230:60231:58843:63501:63498", -- [29]
			"59186:60230:61121:63500", -- [30]
			"59186:60230:61121:63497", -- [31]
			"59186:64310", -- [32]
			"59186:60230:60231:58843:63501:65511", -- [33]
			"59186:60230:61121:65865", -- [34]
			"59727:66023:68226", -- [35]
			"59186:71940", -- [36]
			["direct"] = "59186:59727:59733",
			["m"] = 806,
			["coord"] = 2449240278,
			["f"] = 0,
		},
		[61744] = {
			"61474:61759:60230:59186", -- [1]
			"61474:66023", -- [2]
			"61474:61759:60230:59186:59732", -- [3]
			"61474:61759:60230:59186:59727", -- [4]
			"61474:61759:60230:59186:59735:59733", -- [5]
			"61474:61759:60230:59186:59735", -- [6]
			"61474:61759:60230:59186:59736", -- [7]
			"61474:66023:56737", -- [8]
			"61474:61759:60230", -- [9]
			"61121:60231", -- [10]
			"61474:60232", -- [11]
			"61121:60231:59049", -- [12]
			"61473:62903:63500:63501:58843", -- [13]
			"61121:60231:59048", -- [14]
			"61121:60231:65189", -- [15]
			"61121:60231:59049:60441", -- [16]
			"60416:61512", -- [17]
			"61474:61759", -- [18]
			"61474:61759:62658", -- [19]
			"61473:62901", -- [20]
			"61473:62903", -- [21]
			"61473:62903:62898", -- [22]
			"61473:62903:62898:62909", -- [23]
			"61473:62903:63500:63501", -- [24]
			"61473:62903:63500:63501:63498", -- [25]
			"61473:62903:63500", -- [26]
			"61121:63497", -- [27]
			"61474:61759:60230:59186:64310", -- [28]
			"61473:62903:63500:63501:65511", -- [29]
			"61121:65865", -- [30]
			"61474:66023:68226", -- [31]
			"61474:61759:60230:59186:71940", -- [32]
			["m"] = 809,
			["direct"] = "61474:61118:61511:61504:60416:61473:61121",
			["coord"] = 2316752809,
			["f"] = 0,
			["requirements"] = "qid:30514"
		},
		[59736] = {
			"59186:66023", -- [1]
			"59186:59732", -- [2]
			"59186:59727", -- [3]
			"59735:59733", -- [4]
			"59186:56737", -- [5]
			"59186:60230", -- [6]
			"59186:60230:60231", -- [7]
			"59186:60230:60232", -- [8]
			"59186:60230:60231:58843", -- [9]
			"59186:60230:60231:59048", -- [10]
			"59186:60230:60231:65189", -- [11]
			"59186:60230:61759:61474", -- [12]
			"59186:60230:61759:61474:61118", -- [13]
			"59186:60230:61759:61474:61744", -- [14]
			"59186:60230:61759:61474:61118:61511", -- [15]
			"59186:60230:61759:61474:61504", -- [16]
			"59186:60230:61759:61474:61744:60416", -- [17]
			"59186:60230:61759:61474:61744:61473", -- [18]
			"59186:60230:61759:61474:61744:60416:61512", -- [19]
			"59186:60230:61759", -- [20]
			"59186:60230:62658", -- [21]
			"59186:60230:61759:61474:61744:61473:62901", -- [22]
			"59186:60230:61759:61474:61744:61473:62903", -- [23]
			"59186:60230:61759:61474:61744:61473:62903:62898", -- [24]
			"59186:60230:61759:61474:61744:61473:62903:62898:62909", -- [25]
			"59186:60230:61121", -- [26]
			"59186:60230:60231:58843:63501", -- [27]
			"59186:60230:60231:58843:63501:63498", -- [28]
			"59186:60230:61121:63500", -- [29]
			"59186:60230:61121:63497", -- [30]
			"59186:64310", -- [31]
			"59186:60230:60231:58843:63501:65511", -- [32]
			"59186:66023:68226:59049", -- [33]
			"59186:66023:68226:59049:60441", -- [34]
			"59186:60230:61121:65865", -- [35]
			"59186:66023:68226", -- [36]
			"59186:71940", -- [37]
			["direct"] = "59186:59735",
			["coord"] = 1871527691,
			["m"] = 806,
			["f"] = 0,
		},
		[62898] = {
			"62903:61473:61744:61474:61759:60230:59186", -- [1]
			"62903:61473:61744:61474:66023", -- [2]
			"62903:61473:61744:61474:61759:60230:59186:59732", -- [3]
			"62903:61473:61744:61474:61759:60230:59186:59727", -- [4]
			"62903:61473:61744:61474:61759:60230:59186:59735:59733", -- [5]
			"62903:61473:61744:61474:61759:60230:59186:59735", -- [6]
			"62903:61473:61744:61474:61759:60230:59186:59736", -- [7]
			"62903:61473:61744:61474:66023:56737", -- [8]
			"62903:61473:61744:61474:61759:60230", -- [9]
			"62903:63500:63501:58843:60231", -- [10]
			"62903:61473:61744:61474:60232", -- [11]
			"62903:63500:63501:58843:59049", -- [12]
			"62903:63500:63501:58843", -- [13]
			"62903:63500:63501:59048", -- [14]
			"62903:63500:63501:59048:65189", -- [15]
			"62903:63500:63501:59048:60441", -- [16]
			"62903:61473:61744:61474", -- [17]
			"62903:61473:61744:61118", -- [18]
			"62903:61473:61744", -- [19]
			"62903:61473:61744:61511", -- [20]
			"62901:61512:60416:61504", -- [21]
			"62901:61512:60416", -- [22]
			"62903:61473", -- [23]
			"62901:61512", -- [24]
			"62903:61473:61744:61474:61759", -- [25]
			"62903:61473:61744:61474:61759:62658", -- [26]
			"62903:61473:61744:61121", -- [27]
			"62903:63500:63501", -- [28]
			"62903:63500:63501:63498", -- [29]
			"62903:63500", -- [30]
			"62903:63500:63497", -- [31]
			"62903:61473:61744:61474:61759:60230:59186:64310", -- [32]
			"62903:63500:63501:65511", -- [33]
			"62903:61473:61744:61121:65865", -- [34]
			"62903:61473:61744:61474:66023:68226", -- [35]
			"62903:61473:61744:61474:61759:60230:59186:71940", -- [36]
			["direct"] = "62901:62903:62909",
			["m"] = 810,
			["coord"] = 2329659992,
			["f"] = 0,
		},
		[61504] = {
			"61474:61759:60230:59186", -- [1]
			"61474:66023", -- [2]
			"61474:61759:60230:59186:59732", -- [3]
			"61474:61759:60230:59186:59727", -- [4]
			"61474:61759:60230:59186:59735:59733", -- [5]
			"61474:61759:60230:59186:59735", -- [6]
			"61474:61759:60230:59186:59736", -- [7]
			"61474:66023:56737", -- [8]
			"61474:61759:60230", -- [9]
			"61474:61759:62658:60231", -- [10]
			"61474:60232", -- [11]
			"61474:61759:62658:60231:59049", -- [12]
			"61474:61759:62658:60231:58843", -- [13]
			"61474:61759:62658:60231:59048", -- [14]
			"61474:61759:62658:60231:65189", -- [15]
			"61474:61759:62658:60231:59049:60441", -- [16]
			"60416:61473", -- [17]
			"60416:61512", -- [18]
			"61474:61759", -- [19]
			"61474:61759:62658", -- [20]
			"60416:61512:62901", -- [21]
			"60416:61473:62903", -- [22]
			"60416:61512:62901:62898", -- [23]
			"60416:61512:62901:62898:62909", -- [24]
			"61744:61121", -- [25]
			"60416:61473:62903:63500:63501", -- [26]
			"60416:61473:62903:63500:63501:63498", -- [27]
			"60416:61473:62903:63500", -- [28]
			"60416:61512:63497", -- [29]
			"61474:61759:60230:59186:64310", -- [30]
			"60416:61473:62903:63500:63501:65511", -- [31]
			"61744:61121:65865", -- [32]
			"61474:66023:68226", -- [33]
			"61474:61759:60230:59186:71940", -- [34]
			["direct"] = "61474:61118:61744:61511:60416",
			["m"] = 809,
			["coord"] = 2481101060,
			["f"] = 0,
		},
		[59049] = {
			"60231:60230:59186", -- [1]
			"68226:66023", -- [2]
			"60231:60230:59186:59732", -- [3]
			"68226:66023:59727", -- [4]
			"60231:60230:59186:59735:59733", -- [5]
			"60231:60230:59186:59735", -- [6]
			"60231:60230:59186:59736", -- [7]
			"68226:66023:56737", -- [8]
			"60231:60230", -- [9]
			"60231:60232", -- [10]
			"60231:62658:61759:61474", -- [11]
			"60231:62658:61759:61474:61118", -- [12]
			"60231:61121:61744", -- [13]
			"60231:62658:61759:61474:61118:61511", -- [14]
			"60231:62658:61759:61474:61504", -- [15]
			"60231:61121:61744:60416", -- [16]
			"60231:61121:61744:61473", -- [17]
			"60231:61121:61744:60416:61512", -- [18]
			"60231:62658:61759", -- [19]
			"60231:62658", -- [20]
			"60231:61121:61744:61473:62901", -- [21]
			"59048:63501:63500:62903", -- [22]
			"59048:63501:63500:62903:62898", -- [23]
			"59048:63501:63500:62903:62898:62909", -- [24]
			"60231:61121", -- [25]
			"59048:63501", -- [26]
			"59048:63501:63498", -- [27]
			"59048:63501:63500", -- [28]
			"60231:61121:63497", -- [29]
			"68226:66023:56737:64310", -- [30]
			"59048:63501:65511", -- [31]
			"60231:61121:65865", -- [32]
			"60231:60230:59186:71940", -- [33]
			["direct"] = "60231:58843:59048:65189:60441:68226",
			["m"] = 857,
			["coord"] = 2909688611,
			["f"] = 0,
		},
		[62903] = {
			"61473:61744:61474:61759:60230:59186", -- [1]
			"61473:61744:61474:66023", -- [2]
			"61473:61744:61474:61759:60230:59186:59732", -- [3]
			"61473:61744:61474:61759:60230:59186:59727", -- [4]
			"61473:61744:61474:61759:60230:59186:59735:59733", -- [5]
			"61473:61744:61474:61759:60230:59186:59735", -- [6]
			"61473:61744:61474:61759:60230:59186:59736", -- [7]
			"61473:61744:61474:66023:56737", -- [8]
			"61473:61744:61474:61759:60230", -- [9]
			"63500:63501:58843:60231", -- [10]
			"61473:61744:61474:60232", -- [11]
			"63500:63501:58843:59049", -- [12]
			"63500:63501:58843", -- [13]
			"63500:63501:59048", -- [14]
			"63500:63501:59048:65189", -- [15]
			"63500:63501:59048:60441", -- [16]
			"61473:61744:61474", -- [17]
			"61473:61744:61118", -- [18]
			"61473:61744", -- [19]
			"61473:61744:61511", -- [20]
			"61473:60416:61504", -- [21]
			"61473:60416", -- [22]
			"62901:61512", -- [23]
			"61473:61744:61474:61759", -- [24]
			"61473:61744:61474:61759:62658", -- [25]
			"62898:62909", -- [26]
			"61473:61744:61121", -- [27]
			"63500:63501", -- [28]
			"63500:63501:63498", -- [29]
			"63500:63497", -- [30]
			"61473:61744:61474:61759:60230:59186:64310", -- [31]
			"63500:63501:65511", -- [32]
			"61473:61744:61121:65865", -- [33]
			"61473:61744:61474:66023:68226", -- [34]
			"61473:61744:61474:61759:60230:59186:71940", -- [35]
			["direct"] = "61473:62901:62898:63500",
			["m"] = 810,
			["coord"] = 3196440685,
			["f"] = 0,
		},
	},
	[7] = {
		[84507] = {
			"81103:76840", -- [1]
			"81103:76839", -- [2]
			"91940:90562:81289:76851", -- [3]
			"91940:90562:76850", -- [4]
			"84993:76787", -- [5]
			"90560:90960:85959", -- [6]
			"91940:80932", -- [7]
			"81060:81061", -- [8]
			"81060:81061:81064", -- [9]
			"91940:80932:81067", -- [10]
			"81060:81061:81064:81068", -- [11]
			"81060:81061:81077", -- [12]
			"81060:81061:81354", -- [13]
			"81103:76839:81284", -- [14]
			"91940:90562:81289", -- [15]
			"81103:76839:81285", -- [16]
			"81060:83567", -- [17]
			"81060:81061:81064:83924", -- [18]
			"84993:82844", -- [19]
			"81060:81061:81064:82309", -- [20]
			"81060:81061:81064:83924:81250", -- [21]
			"81060:81061:81354:84515:84498", -- [22]
			"81060:88584:84504", -- [23]
			"81060:81061:81354:84515:82511", -- [24]
			"81060:81061:81064:84509", -- [25]
			"81060:81061:81354:84515", -- [26]
			"81888:81074", -- [27]
			"81888:86492", -- [28]
			"81888:86492:84700", -- [29]
			"81103:83427", -- [30]
			"81888:86492:85829", -- [31]
			"91940:90562:81289:86685", -- [32]
			"81888:84714", -- [33]
			"81060:88584", -- [34]
			"81060:81061:81064:83924:81250:87395", -- [35]
			"81060:81061:81064:82309:88653", -- [36]
			"84993:82844:88668", -- [37]
			"81888:84714:88757", -- [38]
			"90560:90960", -- [39]
			"90560:92808", -- [40]
			"91940:92809", -- [41]
			["direct"] = "81060:81103:81884:81888:84993:90560:91940",
			["coord"] = 1991830685,
			["m"] = 949,
			["f"] = 0,
		},
		[84700] = {
			"84714:92808:90562:76850:76840", -- [1]
			"84714:92808:90562:76850:76840:76839", -- [2]
			"84714:92808:90562:81289:76851", -- [3]
			"84714:92808:90562:76850", -- [4]
			"85829:76787", -- [5]
			"81884:85959", -- [6]
			"86492:81888:84507:91940:80932", -- [7]
			"81074:81060", -- [8]
			"81074:81060:81061", -- [9]
			"85829:84993:81064", -- [10]
			"81074:81060:81067", -- [11]
			"85829:84993:81064:81068", -- [12]
			"85829:84993:81064:81077", -- [13]
			"81074:81060:81061:81354", -- [14]
			"84714:92808:90562:76850:76840:81284", -- [15]
			"84714:92808:90562:81289", -- [16]
			"84714:92808:90562:76850:81285", -- [17]
			"84714:92808:90562:81103", -- [18]
			"81074:81060:83567", -- [19]
			"85829:84993:82844:83924", -- [20]
			"85829:84993:82844", -- [21]
			"85829:84993:82844:82309", -- [22]
			"85829:84993:82844:81250", -- [23]
			"85829:84993:81064:84509:84498", -- [24]
			"81074:81060:88584:84504", -- [25]
			"85829:84993:81064:84509:84498:82511", -- [26]
			"86492:81888:84507", -- [27]
			"85829:84993:81064:84509", -- [28]
			"81074:81060:81061:81354:84515", -- [29]
			"86492:81888", -- [30]
			"85829:84993", -- [31]
			"84714:92808:90562:76850:83427", -- [32]
			"84714:92808:90562:81289:86685", -- [33]
			"81074:81060:88584", -- [34]
			"85829:76787:87395", -- [35]
			"85829:84993:82844:82309:88653", -- [36]
			"85829:84993:82844:88668", -- [37]
			"84714:88757", -- [38]
			"84714:92808:90960", -- [39]
			"81884:90560", -- [40]
			"86492:81888:84507:91940", -- [41]
			"84714:92808", -- [42]
			"84714:92808:92809", -- [43]
			["direct"] = "81884:81074:86492:85829:84714",
			["f"] = 0,
			["m"] = 949,
			["coord"] = 1850094548,
		},
		[84515] = {
			"84504:76839:76840", -- [1]
			"84504:76839", -- [2]
			"84504:76839:76851", -- [3]
			"84504:76850", -- [4]
			"81354:81064:76787", -- [5]
			"88584:85959", -- [6]
			"81354:80932", -- [7]
			"81354:81061:81060", -- [8]
			"81354:81061", -- [9]
			"81354:81064", -- [10]
			"81354:81067", -- [11]
			"84509:81068", -- [12]
			"84509:81077", -- [13]
			"84504:76839:81284", -- [14]
			"84504:76839:76851:81289", -- [15]
			"84504:81285", -- [16]
			"84498:83567", -- [17]
			"81354:81064:83924", -- [18]
			"81354:81064:83924:82844", -- [19]
			"81354:81064:82309", -- [20]
			"81354:81064:83924:81250", -- [21]
			"81354:80932:91940:84507", -- [22]
			"81354:80932:90560:81884", -- [23]
			"81354:81061:81060:81074", -- [24]
			"81354:81064:84993:86492", -- [25]
			"81354:80932:91940:84507:81888", -- [26]
			"81354:80932:90560:81884:84700", -- [27]
			"81354:81064:84993", -- [28]
			"84504:81285:83427", -- [29]
			"81354:81064:84993:85829", -- [30]
			"84504:76839:81284:86685", -- [31]
			"81354:80932:90560:81884:84714", -- [32]
			"81354:81064:83924:81250:87395", -- [33]
			"84498:83567:88653", -- [34]
			"81354:81064:83924:81250:88668", -- [35]
			"81354:80932:90560:81884:84714:88757", -- [36]
			"81103:90562:90960", -- [37]
			"81354:80932:90560", -- [38]
			"81354:80932:91940", -- [39]
			"81354:80932:92809:92808", -- [40]
			"81354:80932:92809", -- [41]
			["direct"] = "81354:81103:84498:84504:82511:84509:88584",
			["coord"] = 2222870403,
			["m"] = 948,
			["f"] = 0,
		},
		[80932] = {
			"81103:76840", -- [1]
			"81103:76839", -- [2]
			"81103:76840:76851", -- [3]
			"81103:76850", -- [4]
			"91940:84507:84993:76787", -- [5]
			"90562:90960:85959", -- [6]
			"81060:81061", -- [7]
			"81060:81061:81064", -- [8]
			"81354:81077:81068", -- [9]
			"81354:81077", -- [10]
			"81103:76839:81284", -- [11]
			"81103:81289", -- [12]
			"81103:76839:81285", -- [13]
			"81354:84515:84498:83567", -- [14]
			"81060:81061:81064:83924", -- [15]
			"81060:81061:81064:83924:82844", -- [16]
			"81060:81061:81064:82309", -- [17]
			"81060:81061:81064:83924:81250", -- [18]
			"81354:84515:84498", -- [19]
			"81354:84515:84504", -- [20]
			"81354:84515:82511", -- [21]
			"91940:84507", -- [22]
			"81354:81077:84509", -- [23]
			"81354:84515", -- [24]
			"90560:81884", -- [25]
			"81060:81074", -- [26]
			"91940:84507:81888:86492", -- [27]
			"91940:84507:81888", -- [28]
			"90560:81884:84700", -- [29]
			"91940:84507:84993", -- [30]
			"81103:83427", -- [31]
			"91940:84507:81888:86492:85829", -- [32]
			"81103:76840:76851:86685", -- [33]
			"90560:81884:84714", -- [34]
			"81103:88584", -- [35]
			"81060:81061:81064:83924:81250:87395", -- [36]
			"81060:81061:81064:82309:88653", -- [37]
			"81060:81061:81064:83924:81250:88668", -- [38]
			"90560:81884:84714:88757", -- [39]
			"90562:90960", -- [40]
			"92809:92808", -- [41]
			["direct"] = "81060:81067:81354:81103:90560:91940:92809",
			["coord"] = 3452649746,
			["m"] = 946,
			["f"] = 0,
		},
		[82511] = {
			"84504:76839:76840", -- [1]
			"84504:76839", -- [2]
			"84504:76839:76851", -- [3]
			"84504:76850", -- [4]
			"84504:88584:81064:76787", -- [5]
			"84504:76839:76851:81289:85959", -- [6]
			"84504:81067:80932", -- [7]
			"84504:81067:81060", -- [8]
			"84504:88584:81354:81061", -- [9]
			"84504:88584:81064", -- [10]
			"84504:81067", -- [11]
			"83567:84509:81068", -- [12]
			"83567:84509:81077", -- [13]
			"84504:88584:81354", -- [14]
			"84504:76839:81284", -- [15]
			"84504:76839:76851:81289", -- [16]
			"84504:81285", -- [17]
			"84504:88584:81103", -- [18]
			"84504:88584:81064:83924", -- [19]
			"84504:88584:81064:83924:82844", -- [20]
			"83567:82309", -- [21]
			"83567:82309:81250", -- [22]
			"84504:81067:81060:84507", -- [23]
			"83567:84509", -- [24]
			"84504:81067:80932:90560:81884", -- [25]
			"84504:81067:81060:81074", -- [26]
			"84504:81067:81060:81888:86492", -- [27]
			"84504:81067:81060:81888", -- [28]
			"84504:81067:81060:81074:84700", -- [29]
			"84504:81067:81060:84993", -- [30]
			"84504:81285:83427", -- [31]
			"84504:81067:81060:84993:85829", -- [32]
			"84504:76839:81284:86685", -- [33]
			"84504:81067:80932:90560:81884:84714", -- [34]
			"83567:82309:87395", -- [35]
			"83567:88653", -- [36]
			"83567:82309:81250:88668", -- [37]
			"84504:81067:80932:90560:81884:84714:88757", -- [38]
			"84504:76850:90562:90960", -- [39]
			"84504:81067:80932:90560", -- [40]
			"84504:81067:80932:91940", -- [41]
			"84504:76850:90562:92808", -- [42]
			"84504:81067:80932:92809", -- [43]
			["direct"] = "83567:84498:84504:84515:88584",
			["coord"] = 2613754813,
			["m"] = 948,
			["f"] = 0,
		},
		[86492] = {
			"81888:84507:81103:76840", -- [1]
			"81888:84507:81103:76839", -- [2]
			"84714:92808:90562:81289:76851", -- [3]
			"84714:92808:90562:76850", -- [4]
			"85829:76787", -- [5]
			"81074:81884:85959", -- [6]
			"81888:84507:91940:80932", -- [7]
			"81888:81060", -- [8]
			"81888:81060:81061", -- [9]
			"84993:81064", -- [10]
			"81888:81060:81067", -- [11]
			"84993:81064:81068", -- [12]
			"84993:81064:81077", -- [13]
			"81888:81060:81061:81354", -- [14]
			"81888:84507:81103:76839:81284", -- [15]
			"84714:92808:90562:81289", -- [16]
			"81888:81060:88584:81285", -- [17]
			"81888:84507:81103", -- [18]
			"81888:81060:83567", -- [19]
			"84993:82844:83924", -- [20]
			"84993:82844", -- [21]
			"84993:82844:82309", -- [22]
			"84993:82844:81250", -- [23]
			"84993:81064:84509:84498", -- [24]
			"81888:81060:88584:84504", -- [25]
			"81888:81060:81061:81354:84515:82511", -- [26]
			"81888:84507", -- [27]
			"84993:81064:84509", -- [28]
			"81888:81060:81061:81354:84515", -- [29]
			"81074:81884", -- [30]
			"81888:84507:81103:83427", -- [31]
			"84714:92808:90562:81289:86685", -- [32]
			"81888:81060:88584", -- [33]
			"84993:82844:88668:87395", -- [34]
			"84993:82844:82309:88653", -- [35]
			"84993:82844:88668", -- [36]
			"84714:88757", -- [37]
			"81074:81884:90960", -- [38]
			"81888:84507:90560", -- [39]
			"81888:84507:91940", -- [40]
			"84714:92808", -- [41]
			"81888:84507:91940:92809", -- [42]
			["direct"] = "81074:81888:84700:84993:85829:84714",
			["coord"] = 1969982652,
			["m"] = 949,
			["f"] = 0,
		},
		[86685] = {
			"76851:76840", -- [1]
			"76851:76839", -- [2]
			"81289:76850", -- [3]
			"81289:90562:90560:84507:84993:76787", -- [4]
			"81289:85959", -- [5]
			"81289:81103:81067:80932", -- [6]
			"81289:81103:81067:81060", -- [7]
			"81289:76850:81354:81061", -- [8]
			"81289:76850:81354:81064", -- [9]
			"81289:81103:81067", -- [10]
			"81289:76850:81077:81068", -- [11]
			"81289:76850:81077", -- [12]
			"81289:76850:81354", -- [13]
			"81284:81285", -- [14]
			"81289:81103", -- [15]
			"76851:76839:84504:84498:83567", -- [16]
			"81289:76850:81354:81064:83924", -- [17]
			"81289:76850:81354:81064:83924:82844", -- [18]
			"81289:76850:81354:81064:82309", -- [19]
			"81289:76850:81354:81064:83924:81250", -- [20]
			"76851:76839:84504:84498", -- [21]
			"76851:76839:84504", -- [22]
			"76851:76839:84504:82511", -- [23]
			"81289:90562:90560:84507", -- [24]
			"76851:76839:84504:84498:84509", -- [25]
			"76851:76839:84504:84515", -- [26]
			"81289:90562:90960:81884", -- [27]
			"81289:81103:81074", -- [28]
			"81289:90562:92808:84714:86492", -- [29]
			"81289:90562:90560:84507:81888", -- [30]
			"81289:90562:92808:84714:84700", -- [31]
			"81289:90562:90560:84507:84993", -- [32]
			"81284:83427", -- [33]
			"81289:90562:92808:84714:85829", -- [34]
			"81289:90562:92808:84714", -- [35]
			"81289:76850:88584", -- [36]
			"81289:76850:81354:81064:83924:81250:87395", -- [37]
			"81289:76850:81354:81064:82309:88653", -- [38]
			"81289:76850:81354:81064:83924:81250:88668", -- [39]
			"81289:90562:92808:84714:88757", -- [40]
			"81289:90562:90960", -- [41]
			"81289:90562:90560", -- [42]
			"81289:90562:91940", -- [43]
			"81289:90562:92808", -- [44]
			"81289:90562:92809", -- [45]
			["direct"] = "76851:81284:81289",
			["coord"] = 3024716070,
			["m"] = 947,
			["f"] = 0,
		},
		[92808] = {
			"90562:76850:76840", -- [1]
			"90562:76850:76840:76839", -- [2]
			"90562:81289:76851", -- [3]
			"90562:76850", -- [4]
			"90560:84507:84993:76787", -- [5]
			"90960:85959", -- [6]
			"92809:80932", -- [7]
			"90560:91940:81060", -- [8]
			"90560:91940:81060:81061", -- [9]
			"90560:91940:81060:81061:81064", -- [10]
			"92809:80932:81067", -- [11]
			"90560:91940:81060:81061:81064:81068", -- [12]
			"92809:80932:81354:81077", -- [13]
			"92809:80932:81354", -- [14]
			"90562:76850:76840:81284", -- [15]
			"90562:81289", -- [16]
			"90562:76850:81285", -- [17]
			"90562:81103", -- [18]
			"90562:81103:84515:84498:83567", -- [19]
			"90560:91940:81060:81061:81064:83924", -- [20]
			"90560:91940:81060:81061:81064:83924:82844", -- [21]
			"90560:91940:81060:81061:81064:82309", -- [22]
			"90560:91940:81060:81061:81064:83924:81250", -- [23]
			"90562:81103:84515:84498", -- [24]
			"90562:81103:88584:84504", -- [25]
			"90562:81103:88584:82511", -- [26]
			"90560:84507", -- [27]
			"92809:80932:81354:81077:84509", -- [28]
			"90562:81103:84515", -- [29]
			"90560:81884", -- [30]
			"90560:84507:81888:81074", -- [31]
			"84714:86492", -- [32]
			"90560:84507:81888", -- [33]
			"84714:84700", -- [34]
			"90560:84507:84993", -- [35]
			"90562:76850:83427", -- [36]
			"84714:85829", -- [37]
			"90562:81289:86685", -- [38]
			"90562:81103:88584", -- [39]
			"90560:91940:81060:81061:81064:83924:81250:87395", -- [40]
			"90560:91940:81060:81061:81064:82309:88653", -- [41]
			"90560:91940:81060:81061:81064:83924:81250:88668", -- [42]
			"84714:88757", -- [43]
			"90560:91940", -- [44]
			["direct"] = "84714:90960:90560:92809",
			["coord"] = 1867738097,
			["m"] = 945,
			["f"] = 0,
		},
		[81354] = {
			"76850:76840", -- [1]
			"76850:76840:76839", -- [2]
			"76850:81289:76851", -- [3]
			"81064:76787", -- [4]
			"76850:81289:85959", -- [5]
			"81061:81060", -- [6]
			"81077:81068", -- [7]
			"76850:76840:81284", -- [8]
			"76850:81289", -- [9]
			"88584:81285", -- [10]
			"81067:81103", -- [11]
			"84515:84498:83567", -- [12]
			"81064:83924", -- [13]
			"81064:83924:82844", -- [14]
			"81064:82309", -- [15]
			"81064:83924:81250", -- [16]
			"84515:84498", -- [17]
			"84515:84504", -- [18]
			"84515:82511", -- [19]
			"80932:91940:84507", -- [20]
			"81077:84509", -- [21]
			"80932:90560:81884", -- [22]
			"81061:81060:81074", -- [23]
			"81064:84993:86492", -- [24]
			"80932:91940:84507:81888", -- [25]
			"80932:90560:81884:84700", -- [26]
			"81064:84993", -- [27]
			"76850:83427", -- [28]
			"81064:84993:85829", -- [29]
			"76850:81289:86685", -- [30]
			"80932:90560:81884:84714", -- [31]
			"81064:83924:81250:87395", -- [32]
			"81064:82309:88653", -- [33]
			"81064:83924:81250:88668", -- [34]
			"80932:90560:81884:84714:88757", -- [35]
			"80932:90562:90960", -- [36]
			"80932:90560", -- [37]
			"80932:91940", -- [38]
			"80932:92809:92808", -- [39]
			"80932:92809", -- [40]
			["direct"] = "76850:80932:81061:81064:81067:81077:84515:88584",
			["coord"] = 3022230065,
			["m"] = 946,
			["f"] = 0,
		},
		[83567] = {
			"84498:84504:76839:76840", -- [1]
			"84498:84504:76839", -- [2]
			"81285:81284:76851", -- [3]
			"88584:76850", -- [4]
			"84509:81077:81064:76787", -- [5]
			"88584:85959", -- [6]
			"84509:81077:81354:80932", -- [7]
			"84509:81077:81061", -- [8]
			"84498:84504:81067", -- [9]
			"84509:81068", -- [10]
			"84509:81077", -- [11]
			"84509:81077:81354", -- [12]
			"81285:81284", -- [13]
			"81285:81284:76851:81289", -- [14]
			"84509:81068:83924", -- [15]
			"84509:81068:83924:82844", -- [16]
			"82309:81250", -- [17]
			"84498:84504", -- [18]
			"81060:84507", -- [19]
			"84509:84515", -- [20]
			"81060:84507:81884", -- [21]
			"81060:81074", -- [22]
			"84509:81077:81064:84993:86492", -- [23]
			"81060:81888", -- [24]
			"84509:81077:81064:84993:85829:84700", -- [25]
			"84509:81077:81064:84993", -- [26]
			"81285:83427", -- [27]
			"84509:81077:81064:84993:85829", -- [28]
			"81285:81284:86685", -- [29]
			"81060:81074:84714", -- [30]
			"82309:87395", -- [31]
			"82309:81250:88668", -- [32]
			"81060:81074:84714:88757", -- [33]
			"88584:81103:90562:90960", -- [34]
			"84509:81077:81354:80932:90560", -- [35]
			"81060:91940", -- [36]
			"84509:81077:81354:80932:92809:92808", -- [37]
			"84509:81077:81354:80932:92809", -- [38]
			["direct"] = "81060:81064:81285:81103:82309:84498:82511:84509:88584:88653",
			["coord"] = 1676910163,
			["m"] = 948,
			["f"] = 0,
		},
		[81067] = {
			"76850:76840", -- [1]
			"81103:76839", -- [2]
			"76850:81289:76851", -- [3]
			"81354:81064:76787", -- [4]
			"81103:85959", -- [5]
			"81354:81061", -- [6]
			"81354:81064", -- [7]
			"81354:81077:81068", -- [8]
			"76850:76840:81284", -- [9]
			"76850:81289", -- [10]
			"81103:76839:81285", -- [11]
			"81354:84515:84498:83567", -- [12]
			"81354:81064:83924", -- [13]
			"81354:81064:83924:82844", -- [14]
			"81354:81064:82309", -- [15]
			"81354:81064:83924:81250", -- [16]
			"81354:84515:84498", -- [17]
			"81354:84515:82511", -- [18]
			"81060:84507", -- [19]
			"81354:81077:84509", -- [20]
			"81354:84515", -- [21]
			"80932:90560:81884", -- [22]
			"81060:81074", -- [23]
			"81060:81888:86492", -- [24]
			"81060:81888", -- [25]
			"81060:81074:84700", -- [26]
			"81060:84993", -- [27]
			"76850:83427", -- [28]
			"81060:84993:85829", -- [29]
			"76850:81289:86685", -- [30]
			"80932:90560:81884:84714", -- [31]
			"81354:88584", -- [32]
			"81354:81064:83924:81250:87395", -- [33]
			"81354:81064:82309:88653", -- [34]
			"81354:81064:83924:81250:88668", -- [35]
			"80932:90560:81884:84714:88757", -- [36]
			"80932:90562:90960", -- [37]
			"80932:90560", -- [38]
			"80932:91940", -- [39]
			"80932:92809:92808", -- [40]
			"80932:92809", -- [41]
			["direct"] = "76850:80932:81060:81077:81354:81103:84504",
			["coord"] = 3438973280,
			["m"] = 946,
			["f"] = 0,
		},
		[76850] = {
			"76840:76839", -- [1]
			"81289:76851", -- [2]
			"81354:81064:76787", -- [3]
			"81289:85959", -- [4]
			"81067:80932", -- [5]
			"81067:81060", -- [6]
			"81354:81061", -- [7]
			"81354:81064", -- [8]
			"81077:81068", -- [9]
			"76840:81284", -- [10]
			"88584:83567", -- [11]
			"81354:81064:83924", -- [12]
			"81354:81064:83924:82844", -- [13]
			"81354:81064:82309", -- [14]
			"81354:81064:83924:81250", -- [15]
			"88584:84515:84498", -- [16]
			"84504:82511", -- [17]
			"81103:84507", -- [18]
			"88584:84515:84509", -- [19]
			"88584:84515", -- [20]
			"90562:90960:81884", -- [21]
			"81103:81074", -- [22]
			"81103:84507:81888:86492", -- [23]
			"81103:84507:81888", -- [24]
			"90562:92808:84714:84700", -- [25]
			"81103:84507:84993", -- [26]
			"90562:92808:84714:85829", -- [27]
			"81289:86685", -- [28]
			"90562:92808:84714", -- [29]
			"81354:81064:83924:81250:87395", -- [30]
			"81354:81064:82309:88653", -- [31]
			"81354:81064:83924:81250:88668", -- [32]
			"90562:92808:84714:88757", -- [33]
			"90562:90960", -- [34]
			"90562:90560", -- [35]
			"90562:91940", -- [36]
			"90562:92808", -- [37]
			"90562:92809", -- [38]
			["direct"] = "76840:81067:81077:81354:81289:81285:81103:84504:83427:88584",
			["coord"] = 1958494468,
			["m"] = 947,
			["f"] = 0,
		},
		[88757] = {
			"84714:92808:90562:76850:76840", -- [1]
			"84714:92808:90562:76850:76840:76839", -- [2]
			"84714:92808:90562:81289:76851", -- [3]
			"84714:92808:90562:76850", -- [4]
			"84714:85829:76787", -- [5]
			"84714:81884:85959", -- [6]
			"84714:81888:84507:91940:80932", -- [7]
			"84714:81888:81060", -- [8]
			"84714:81888:81060:81061", -- [9]
			"84714:81888:81060:81061:81064", -- [10]
			"84714:81888:81060:81067", -- [11]
			"84714:81888:81060:81061:81064:81068", -- [12]
			"84714:81888:81060:81061:81077", -- [13]
			"84714:81888:81060:81061:81354", -- [14]
			"84714:92808:90562:76850:76840:81284", -- [15]
			"84714:92808:90562:81289", -- [16]
			"84714:92808:90562:76850:81285", -- [17]
			"84714:92808:90562:81103", -- [18]
			"84714:81888:81060:83567", -- [19]
			"84714:86492:84993:82844:83924", -- [20]
			"84714:86492:84993:82844", -- [21]
			"84714:86492:84993:82844:82309", -- [22]
			"84714:86492:84993:82844:81250", -- [23]
			"84714:92808:90562:81103:84515:84498", -- [24]
			"84714:92808:90562:81103:88584:84504", -- [25]
			"84714:92808:90562:81103:88584:82511", -- [26]
			"84714:81888:84507", -- [27]
			"84714:81888:81060:81061:81064:84509", -- [28]
			"84714:92808:90562:81103:84515", -- [29]
			"84714:81884", -- [30]
			"84714:81074", -- [31]
			"84714:86492", -- [32]
			"84714:81888", -- [33]
			"84714:84700", -- [34]
			"84714:86492:84993", -- [35]
			"84714:92808:90562:76850:83427", -- [36]
			"84714:85829", -- [37]
			"84714:92808:90562:81289:86685", -- [38]
			"84714:92808:90562:81103:88584", -- [39]
			"84714:86492:84993:82844:88668:87395", -- [40]
			"84714:86492:84993:82844:82309:88653", -- [41]
			"84714:86492:84993:82844:88668", -- [42]
			"84714:92808:90960", -- [43]
			"84714:81884:90560", -- [44]
			"84714:81888:84507:91940", -- [45]
			"84714:92808", -- [46]
			"84714:92808:92809", -- [47]
			["direct"] = "84714",
			["coord"] = 2952481190,
			["m"] = 949,
			["f"] = 0,
		},
		[88584] = {
			"76850:76840", -- [1]
			"84504:76839", -- [2]
			"81285:81284:76851", -- [3]
			"81064:76787", -- [4]
			"81354:80932", -- [5]
			"81354:81061", -- [6]
			"81354:81067", -- [7]
			"81077:81068", -- [8]
			"81285:81284", -- [9]
			"76850:81289", -- [10]
			"81064:83924", -- [11]
			"81064:83924:82844", -- [12]
			"81064:82309", -- [13]
			"81064:83924:81250", -- [14]
			"84515:84498", -- [15]
			"81060:84507", -- [16]
			"84515:84509", -- [17]
			"81354:80932:90560:81884", -- [18]
			"81060:81074", -- [19]
			"81060:81888:86492", -- [20]
			"81060:81888", -- [21]
			"81060:81074:84700", -- [22]
			"81060:84993", -- [23]
			"81285:83427", -- [24]
			"81060:84993:85829", -- [25]
			"81285:81284:86685", -- [26]
			"81060:81074:84714", -- [27]
			"81064:83924:81250:87395", -- [28]
			"81064:82309:88653", -- [29]
			"81064:83924:81250:88668", -- [30]
			"81060:81074:84714:88757", -- [31]
			"81103:90562:90960", -- [32]
			"81354:80932:90560", -- [33]
			"81060:91940", -- [34]
			"81354:80932:92809:92808", -- [35]
			"81354:80932:92809", -- [36]
			["direct"] = "76850:85959:81060:81064:81077:81354:81285:81103:83567:84504:82511:84515",
			["coord"] = 2820418764,
			["m"] = 948,
			["f"] = 0,
		},
		[92809] = {
			"90562:76850:76840", -- [1]
			"90562:76850:76840:76839", -- [2]
			"90562:81289:76851", -- [3]
			"90562:76850", -- [4]
			"90560:84507:84993:76787", -- [5]
			"90562:90960:85959", -- [6]
			"91940:81060", -- [7]
			"91940:81060:81061", -- [8]
			"91940:81060:81061:81064", -- [9]
			"80932:81067", -- [10]
			"80932:81354:81077:81068", -- [11]
			"80932:81354:81077", -- [12]
			"80932:81354", -- [13]
			"90562:76850:76840:81284", -- [14]
			"90562:81289", -- [15]
			"90562:76850:81285", -- [16]
			"90562:81103", -- [17]
			"80932:81354:84515:84498:83567", -- [18]
			"91940:81060:81061:81064:83924", -- [19]
			"91940:81060:81061:81064:83924:82844", -- [20]
			"91940:81060:81061:81064:82309", -- [21]
			"91940:81060:81061:81064:83924:81250", -- [22]
			"80932:81354:84515:84498", -- [23]
			"90562:81103:88584:84504", -- [24]
			"80932:81354:84515:82511", -- [25]
			"90560:84507", -- [26]
			"80932:81354:81077:84509", -- [27]
			"80932:81354:84515", -- [28]
			"90560:81884", -- [29]
			"90560:84507:81888:81074", -- [30]
			"90560:84507:81888:86492", -- [31]
			"90560:84507:81888", -- [32]
			"90560:81884:84700", -- [33]
			"90560:84507:84993", -- [34]
			"90562:76850:83427", -- [35]
			"90560:81884:85829", -- [36]
			"90562:81289:86685", -- [37]
			"92808:84714", -- [38]
			"90562:81103:88584", -- [39]
			"91940:81060:81061:81064:83924:81250:87395", -- [40]
			"91940:81060:81061:81064:82309:88653", -- [41]
			"91940:81060:81061:81064:83924:81250:88668", -- [42]
			"92808:84714:88757", -- [43]
			"90562:90960", -- [44]
			["direct"] = "80932:90560:91940:92808",
			["coord"] = 1268359494,
			["m"] = 945,
			["f"] = 0,
		},
		[87395] = {
			"81250:83924:81064:81103:76840", -- [1]
			"81250:83924:81068:84509:84515:84504:76839", -- [2]
			"81250:83924:81068:84509:84515:84504:76839:76851", -- [3]
			"81250:83924:81068:81077:76850", -- [4]
			"81250:83924:81064:85959", -- [5]
			"81250:83924:81064:81060:80932", -- [6]
			"81250:83924:81064:81060", -- [7]
			"81250:83924:81064:81061", -- [8]
			"81250:83924:81064", -- [9]
			"81250:83924:81064:81354:81067", -- [10]
			"81250:83924:81068", -- [11]
			"81250:83924:81068:81077", -- [12]
			"81250:83924:81064:81354", -- [13]
			"81250:83924:81068:84509:84515:84504:76839:81284", -- [14]
			"81250:83924:81068:81077:76850:81289", -- [15]
			"81250:83924:81068:84509:84515:84504:81285", -- [16]
			"81250:83924:81064:81103", -- [17]
			"82309:83567", -- [18]
			"81250:83924", -- [19]
			"88668:82844", -- [20]
			"81250:83924:81068:84509:84498", -- [21]
			"81250:83924:81068:84509:84515:84504", -- [22]
			"81250:83924:81068:84509:84498:82511", -- [23]
			"81250:83924:81064:81060:84507", -- [24]
			"81250:83924:81068:84509", -- [25]
			"81250:83924:81068:84509:84515", -- [26]
			"88668:82844:84993:81074:81884", -- [27]
			"88668:82844:84993:81074", -- [28]
			"88668:82844:84993:86492", -- [29]
			"88668:82844:84993:81888", -- [30]
			"76787:85829:84700", -- [31]
			"88668:82844:84993", -- [32]
			"81250:83924:81068:84509:84515:84504:81285:83427", -- [33]
			"76787:85829", -- [34]
			"81250:83924:81068:84509:84515:84504:76839:81284:86685", -- [35]
			"88668:82844:84993:86492:84714", -- [36]
			"81250:83924:81064:88584", -- [37]
			"88668:82844:84993:86492:84714:88757", -- [38]
			"81250:83924:81064:81060:80932:90562:90960", -- [39]
			"81250:83924:81064:81060:91940:90560", -- [40]
			"81250:83924:81064:81060:91940", -- [41]
			"81250:83924:81064:81060:80932:92809:92808", -- [42]
			"81250:83924:81064:81060:80932:92809", -- [43]
			["direct"] = "76787:82309:81250:88653:88668",
			["coord"] = 2178240154,
			["m"] = 950,
			["f"] = 0,
		},
		[76839] = {
			"76840:76850", -- [1]
			"81103:84507:84993:76787", -- [2]
			"76851:81289:85959", -- [3]
			"81103:81067:80932", -- [4]
			"81103:81067:81060", -- [5]
			"81103:81067:81354:81061", -- [6]
			"81103:81067:81354:81064", -- [7]
			"81103:81067", -- [8]
			"81103:81067:81354:81077:81068", -- [9]
			"81103:81067:81354:81077", -- [10]
			"81103:81067:81354", -- [11]
			"76851:81289", -- [12]
			"84504:84498:83567", -- [13]
			"81103:81067:81354:81064:83924", -- [14]
			"81103:81067:81354:81064:83924:82844", -- [15]
			"81103:82309", -- [16]
			"81103:81067:81354:81064:83924:81250", -- [17]
			"84504:84498", -- [18]
			"84504:82511", -- [19]
			"81103:84507", -- [20]
			"84504:84498:84509", -- [21]
			"84504:84515", -- [22]
			"81103:84507:81884", -- [23]
			"81103:81074", -- [24]
			"81103:84507:81888:86492", -- [25]
			"81103:84507:81888", -- [26]
			"76840:76850:90562:92808:84714:84700", -- [27]
			"81103:84507:84993", -- [28]
			"81285:83427", -- [29]
			"81103:84507:81888:86492:85829", -- [30]
			"81284:86685", -- [31]
			"76840:76850:90562:92808:84714", -- [32]
			"84504:88584", -- [33]
			"81103:81067:81354:81064:83924:81250:87395", -- [34]
			"84504:84498:83567:88653", -- [35]
			"81103:81067:81354:81064:83924:81250:88668", -- [36]
			"76840:76850:90562:92808:84714:88757", -- [37]
			"76840:76850:90562:90960", -- [38]
			"81103:81067:80932:90560", -- [39]
			"81103:81067:80932:91940", -- [40]
			"76840:76850:90562:92808", -- [41]
			"76840:76850:90562:92809", -- [42]
			["direct"] = "76840:76851:81284:81285:81103:84504",
			["coord"] = 1748733257,
			["m"] = 947,
			["f"] = 0,
		},
		[81103] = {
			"76840:76851", -- [1]
			"84507:84993:76787", -- [2]
			"81067:81354:81061", -- [3]
			"81067:81354:81077:81068", -- [4]
			"81067:81354:81077", -- [5]
			"81067:81354", -- [6]
			"76839:81284", -- [7]
			"81067:81354:81064:83924", -- [8]
			"81067:81354:81064:83924:82844", -- [9]
			"81067:81354:81064:83924:81250", -- [10]
			"84515:84498", -- [11]
			"88584:84504", -- [12]
			"88584:82511", -- [13]
			"84515:84509", -- [14]
			"84507:81888:86492", -- [15]
			"84507:81888", -- [16]
			"81074:84700", -- [17]
			"84507:84993", -- [18]
			"84507:81888:86492:85829", -- [19]
			"76840:76851:86685", -- [20]
			"90562:92808:84714", -- [21]
			"81067:81354:81064:83924:81250:87395", -- [22]
			"82309:88653", -- [23]
			"81067:81354:81064:83924:81250:88668", -- [24]
			"90562:92808:84714:88757", -- [25]
			"90562:90960", -- [26]
			"81067:80932:90560", -- [27]
			"81067:80932:91940", -- [28]
			"90562:92808", -- [29]
			"90562:92809", -- [30]
			["m"] = 971,
			["coord"] = 2058190561,
			["direct"] = "76840:76839:76850:85959:80932:81060:81064:81067:81289:81285:83567:82309:84507:84515:81884:81074:83427:88584",
			["f"] = 0,
		},
		[84509] = {
			"84515:84504:76839:76840", -- [1]
			"84515:84504:76839", -- [2]
			"84515:84504:76839:76851", -- [3]
			"84515:84504:76850", -- [4]
			"81077:81064:76787", -- [5]
			"84515:88584:85959", -- [6]
			"81077:81354:80932", -- [7]
			"81077:81064:81060", -- [8]
			"81077:81061", -- [9]
			"81077:81067", -- [10]
			"81077:81354", -- [11]
			"84515:84504:76839:81284", -- [12]
			"84515:84504:76839:76851:81289", -- [13]
			"84515:84504:81285", -- [14]
			"84515:81103", -- [15]
			"81068:83924", -- [16]
			"81068:83924:82844", -- [17]
			"81068:83924:82309", -- [18]
			"81068:83924:81250", -- [19]
			"84515:84504", -- [20]
			"84498:82511", -- [21]
			"81077:81064:81060:84507", -- [22]
			"81077:81354:80932:90560:81884", -- [23]
			"81077:81064:81060:81074", -- [24]
			"81077:81064:84993:86492", -- [25]
			"81077:81064:81060:81888", -- [26]
			"81077:81064:84993:85829:84700", -- [27]
			"81077:81064:84993", -- [28]
			"84515:84504:81285:83427", -- [29]
			"81077:81064:84993:85829", -- [30]
			"84515:84504:76839:81284:86685", -- [31]
			"81077:81064:81060:81074:84714", -- [32]
			"84515:88584", -- [33]
			"81068:83924:81250:87395", -- [34]
			"81068:83924:88653", -- [35]
			"81068:83924:81250:88668", -- [36]
			"81077:81064:81060:81074:84714:88757", -- [37]
			"84515:81103:90562:90960", -- [38]
			"81077:81354:80932:90560", -- [39]
			"81077:81064:81060:91940", -- [40]
			"81077:81354:80932:92809:92808", -- [41]
			"81077:81354:80932:92809", -- [42]
			["direct"] = "81064:81068:81077:83567:84498:84515",
			["coord"] = 1586380571,
			["m"] = 948,
			["f"] = 0,
		},
		[81074] = {
			"81103:76840", -- [1]
			"81103:76839", -- [2]
			"81884:90960:90562:81289:76851", -- [3]
			"81884:90960:90562:76850", -- [4]
			"85829:76787", -- [5]
			"81884:85959", -- [6]
			"81060:80932", -- [7]
			"81060:81061", -- [8]
			"81060:81061:81064", -- [9]
			"81060:81067", -- [10]
			"81060:81061:81064:81068", -- [11]
			"81060:81061:81077", -- [12]
			"81060:81061:81354", -- [13]
			"81103:76839:81284", -- [14]
			"81884:90960:90562:81289", -- [15]
			"81060:88584:81285", -- [16]
			"81060:83567", -- [17]
			"81060:81061:81064:83924", -- [18]
			"84993:82844", -- [19]
			"84993:82844:81250", -- [20]
			"81060:81061:81354:84515:84498", -- [21]
			"81060:88584:84504", -- [22]
			"81060:81061:81354:84515:82511", -- [23]
			"81888:84507", -- [24]
			"81060:81061:81064:84509", -- [25]
			"81060:81061:81354:84515", -- [26]
			"81103:83427", -- [27]
			"81884:90960:90562:81289:86685", -- [28]
			"81060:88584", -- [29]
			"84993:82844:88668:87395", -- [30]
			"82309:88653", -- [31]
			"84993:82844:88668", -- [32]
			"84714:88757", -- [33]
			"81884:90960", -- [34]
			"81884:90560", -- [35]
			"81888:84507:91940", -- [36]
			"84714:92808", -- [37]
			"81888:84507:91940:92809", -- [38]
			["direct"] = "81060:81103:82309:81884:86492:81888:84700:84993:85829:84714",
			["coord"] = 2269222887,
			["m"] = 949,
			["f"] = 0,
		},
		[83427] = {
			"81284:76839", -- [1]
			"81284:76851", -- [2]
			"81285:88584:81064:76787", -- [3]
			"81103:81067:80932", -- [4]
			"81103:81067:81060", -- [5]
			"81103:81067:81354:81061", -- [6]
			"81285:88584:81064", -- [7]
			"81103:81067", -- [8]
			"81285:81077:81068", -- [9]
			"81285:81077", -- [10]
			"81103:81067:81354", -- [11]
			"81284:76851:81289", -- [12]
			"81285:83567", -- [13]
			"81285:88584:81064:83924", -- [14]
			"81285:88584:81064:83924:82844", -- [15]
			"81285:88584:81064:82309", -- [16]
			"81285:88584:81064:83924:81250", -- [17]
			"81285:84504:84498", -- [18]
			"81285:84504", -- [19]
			"81285:84504:82511", -- [20]
			"81103:84507", -- [21]
			"81285:84504:84498:84509", -- [22]
			"81285:84504:84515", -- [23]
			"81284:76851:81289:90562:90960:81884", -- [24]
			"81103:81074", -- [25]
			"81103:84507:81888:86492", -- [26]
			"81103:84507:81888", -- [27]
			"81284:76851:81289:90562:92808:84714:84700", -- [28]
			"81103:84507:84993", -- [29]
			"81284:76851:81289:90562:92808:84714:85829", -- [30]
			"81284:86685", -- [31]
			"81284:76851:81289:90562:92808:84714", -- [32]
			"81285:88584", -- [33]
			"81285:88584:81064:83924:81250:87395", -- [34]
			"81285:83567:88653", -- [35]
			"81285:88584:81064:83924:81250:88668", -- [36]
			"81284:76851:81289:90562:92808:84714:88757", -- [37]
			"81284:76851:81289:90562:90960", -- [38]
			"81284:76851:81289:90562:90560", -- [39]
			"81284:76851:81289:90562:91940", -- [40]
			"81284:76851:81289:90562:92808", -- [41]
			"81284:76851:81289:90562:92809", -- [42]
			["direct"] = "76840:76850:85959:81284:81285:81103",
			["coord"] = 2569326670,
			["m"] = 947,
			["f"] = 0,
		},
		[81285] = {
			"76839:76840", -- [1]
			"81284:76851", -- [2]
			"88584:81064:76787", -- [3]
			"88584:81354:80932", -- [4]
			"88584:81060", -- [5]
			"88584:81354:81061", -- [6]
			"88584:81064", -- [7]
			"81103:81067", -- [8]
			"81077:81068", -- [9]
			"88584:81354", -- [10]
			"81284:76851:81289", -- [11]
			"88584:81064:83924", -- [12]
			"88584:81064:83924:82844", -- [13]
			"88584:81064:82309", -- [14]
			"88584:81064:83924:81250", -- [15]
			"84504:84498", -- [16]
			"84504:82511", -- [17]
			"81103:84507", -- [18]
			"84504:84498:84509", -- [19]
			"84504:84515", -- [20]
			"81284:76851:81289:90562:90960:81884", -- [21]
			"81103:81074", -- [22]
			"81103:84507:81888:86492", -- [23]
			"81103:84507:81888", -- [24]
			"81284:76851:81289:90562:92808:84714:84700", -- [25]
			"81103:84507:84993", -- [26]
			"81103:84507:81888:86492:85829", -- [27]
			"81284:86685", -- [28]
			"81284:76851:81289:90562:92808:84714", -- [29]
			"88584:81064:83924:81250:87395", -- [30]
			"83567:88653", -- [31]
			"88584:81064:83924:81250:88668", -- [32]
			"81284:76851:81289:90562:92808:84714:88757", -- [33]
			"81284:76851:81289:90562:90960", -- [34]
			"81284:76851:81289:90562:90560", -- [35]
			"88584:81060:91940", -- [36]
			"81284:76851:81289:90562:92808", -- [37]
			"81284:76851:81289:90562:92809", -- [38]
			["direct"] = "76839:76850:85959:81077:81284:81103:83567:84504:83427:88584",
			["coord"] = 1884407400,
			["m"] = 947,
			["f"] = 0,
		},
		[84714] = {
			"92808:90562:76850:76840", -- [1]
			"92808:90562:76850:76840:76839", -- [2]
			"92808:90562:81289:76851", -- [3]
			"92808:90562:76850", -- [4]
			"85829:76787", -- [5]
			"81884:85959", -- [6]
			"81888:84507:91940:80932", -- [7]
			"81888:81060", -- [8]
			"81888:81060:81061", -- [9]
			"81888:81060:81061:81064", -- [10]
			"81888:81060:81067", -- [11]
			"81888:81060:81061:81064:81068", -- [12]
			"81888:81060:81061:81077", -- [13]
			"81888:81060:81061:81354", -- [14]
			"92808:90562:76850:76840:81284", -- [15]
			"92808:90562:81289", -- [16]
			"92808:90562:76850:81285", -- [17]
			"92808:90562:81103", -- [18]
			"81888:81060:83567", -- [19]
			"86492:84993:82844:83924", -- [20]
			"86492:84993:82844", -- [21]
			"86492:84993:82844:82309", -- [22]
			"86492:84993:82844:81250", -- [23]
			"92808:90562:81103:84515:84498", -- [24]
			"92808:90562:81103:88584:84504", -- [25]
			"92808:90562:81103:88584:82511", -- [26]
			"81888:84507", -- [27]
			"81888:81060:81061:81064:84509", -- [28]
			"92808:90562:81103:84515", -- [29]
			"86492:84993", -- [30]
			"92808:90562:76850:83427", -- [31]
			"92808:90562:81289:86685", -- [32]
			"92808:90562:81103:88584", -- [33]
			"86492:84993:82844:88668:87395", -- [34]
			"86492:84993:82844:82309:88653", -- [35]
			"86492:84993:82844:88668", -- [36]
			"92808:90960", -- [37]
			"81884:90560", -- [38]
			"81888:84507:91940", -- [39]
			"92808:92809", -- [40]
			["direct"] = "81884:81074:86492:81888:84700:85829:88757:92808",
			["coord"] = 2449372519,
			["m"] = 949,
			["f"] = 0,
		},
		[81064] = {
			"81103:76840", -- [1]
			"81103:76839", -- [2]
			"81103:76840:76851", -- [3]
			"81354:76850", -- [4]
			"81060:80932", -- [5]
			"81354:81067", -- [6]
			"81103:76839:81284", -- [7]
			"81354:76850:81289", -- [8]
			"88584:81285", -- [9]
			"83924:82844", -- [10]
			"83924:81250", -- [11]
			"84509:84498", -- [12]
			"84509:84515:84504", -- [13]
			"84509:84498:82511", -- [14]
			"81060:84507", -- [15]
			"84509:84515", -- [16]
			"81060:84507:81884", -- [17]
			"81060:81074", -- [18]
			"84993:86492", -- [19]
			"81060:81888", -- [20]
			"84993:85829:84700", -- [21]
			"88584:81285:83427", -- [22]
			"84993:85829", -- [23]
			"81354:76850:81289:86685", -- [24]
			"81060:81074:84714", -- [25]
			"83924:81250:87395", -- [26]
			"82309:88653", -- [27]
			"83924:81250:88668", -- [28]
			"81060:81074:84714:88757", -- [29]
			"81060:80932:90562:90960", -- [30]
			"81060:91940:90560", -- [31]
			"81060:91940", -- [32]
			"81060:80932:92809:92808", -- [33]
			"81060:80932:92809", -- [34]
			["direct"] = "76787:85959:81060:81061:81068:81077:81354:81103:83567:83924:82309:84509:84993:88584",
			["coord"] = 2201513314,
			["m"] = 946,
			["f"] = 0,
		},
		[81068] = {
			"81077:76850:76840", -- [1]
			"84509:84515:84504:76839", -- [2]
			"84509:84515:84504:76839:76851", -- [3]
			"81077:76850", -- [4]
			"81077:81064:76787", -- [5]
			"81077:81064:85959", -- [6]
			"81077:81354:80932", -- [7]
			"81077:81064:81060", -- [8]
			"81077:81061", -- [9]
			"81077:81067", -- [10]
			"81077:81354", -- [11]
			"84509:84515:84504:76839:81284", -- [12]
			"81077:76850:81289", -- [13]
			"84509:84515:84504:81285", -- [14]
			"81077:81067:81103", -- [15]
			"84509:83567", -- [16]
			"83924:82844", -- [17]
			"83924:82309", -- [18]
			"83924:81250", -- [19]
			"84509:84498", -- [20]
			"84509:84515:84504", -- [21]
			"84509:84498:82511", -- [22]
			"81077:81064:81060:84507", -- [23]
			"84509:84515", -- [24]
			"81077:81354:80932:90560:81884", -- [25]
			"81077:81064:81060:81074", -- [26]
			"81077:81064:84993:86492", -- [27]
			"81077:81064:81060:81888", -- [28]
			"81077:81064:84993:85829:84700", -- [29]
			"81077:81064:84993", -- [30]
			"84509:84515:84504:81285:83427", -- [31]
			"81077:81064:84993:85829", -- [32]
			"84509:84515:84504:76839:81284:86685", -- [33]
			"81077:81064:81060:81074:84714", -- [34]
			"81077:88584", -- [35]
			"83924:81250:87395", -- [36]
			"83924:88653", -- [37]
			"83924:81250:88668", -- [38]
			"81077:81064:81060:81074:84714:88757", -- [39]
			"81077:81354:80932:90562:90960", -- [40]
			"81077:81354:80932:90560", -- [41]
			"81077:81064:81060:91940", -- [42]
			"81077:81354:80932:92809:92808", -- [43]
			"81077:81354:80932:92809", -- [44]
			["direct"] = "81064:81077:83924:84509",
			["coord"] = 1807467694,
			["m"] = 946,
			["f"] = 0,
		},
		[76851] = {
			"81289:76850", -- [1]
			"76840:81103:84507:84993:76787", -- [2]
			"81289:85959", -- [3]
			"76840:81103:81067:80932", -- [4]
			"76840:81103:81067:81060", -- [5]
			"76840:81103:81067:81354:81061", -- [6]
			"76840:81103:81067:81354:81064", -- [7]
			"76840:81103:81067", -- [8]
			"76840:81103:81067:81354:81077:81068", -- [9]
			"76840:81103:81067:81354:81077", -- [10]
			"76840:81103:81067:81354", -- [11]
			"81284:81285", -- [12]
			"76840:81103", -- [13]
			"76839:84504:84498:83567", -- [14]
			"76840:81103:81067:81354:81064:83924", -- [15]
			"76840:81103:81067:81354:81064:83924:82844", -- [16]
			"76840:81103:82309", -- [17]
			"76840:81103:81067:81354:81064:83924:81250", -- [18]
			"76839:84504:84498", -- [19]
			"76839:84504", -- [20]
			"76839:84504:82511", -- [21]
			"76840:81103:84507", -- [22]
			"76839:84504:84498:84509", -- [23]
			"76839:84504:84515", -- [24]
			"81289:90562:90960:81884", -- [25]
			"76840:81103:81074", -- [26]
			"81289:90562:92808:84714:86492", -- [27]
			"76840:81103:84507:81888", -- [28]
			"81289:90562:92808:84714:84700", -- [29]
			"76840:81103:84507:84993", -- [30]
			"81284:83427", -- [31]
			"81289:90562:92808:84714:85829", -- [32]
			"81289:90562:92808:84714", -- [33]
			"81289:76850:88584", -- [34]
			"76840:81103:81067:81354:81064:83924:81250:87395", -- [35]
			"76840:81103:82309:88653", -- [36]
			"76840:81103:81067:81354:81064:83924:81250:88668", -- [37]
			"81289:90562:92808:84714:88757", -- [38]
			"81289:90562:90960", -- [39]
			"81289:90562:90560", -- [40]
			"81289:90562:91940", -- [41]
			"81289:90562:92808", -- [42]
			"81289:90562:92809", -- [43]
			["direct"] = "76840:76839:81284:81289:86685",
			["coord"] = 2550822383,
			["m"] = 947,
			["f"] = 0,
		},
		[90560] = {
			"90562:76850:76840", -- [1]
			"80932:81103:76839", -- [2]
			"90562:81289:76851", -- [3]
			"90562:76850", -- [4]
			"84507:84993:76787", -- [5]
			"90960:85959", -- [6]
			"91940:81060", -- [7]
			"91940:81060:81061", -- [8]
			"91940:81060:81061:81064", -- [9]
			"80932:81067", -- [10]
			"91940:81060:81061:81064:81068", -- [11]
			"80932:81354:81077", -- [12]
			"80932:81354", -- [13]
			"90562:76850:76840:81284", -- [14]
			"90562:81289", -- [15]
			"80932:81103:76839:81285", -- [16]
			"80932:81103", -- [17]
			"80932:81354:84515:84498:83567", -- [18]
			"91940:81060:81061:81064:83924", -- [19]
			"91940:81060:81061:81064:83924:82844", -- [20]
			"91940:81060:81061:81064:82309", -- [21]
			"91940:81060:81061:81064:83924:81250", -- [22]
			"80932:81354:84515:84498", -- [23]
			"80932:81354:84515:84504", -- [24]
			"80932:81354:84515:82511", -- [25]
			"80932:81354:81077:84509", -- [26]
			"80932:81354:84515", -- [27]
			"84507:81888:81074", -- [28]
			"84507:81888:86492", -- [29]
			"84507:81888", -- [30]
			"81884:84700", -- [31]
			"84507:84993", -- [32]
			"90562:76850:83427", -- [33]
			"81884:85829", -- [34]
			"90562:81289:86685", -- [35]
			"81884:84714", -- [36]
			"80932:81103:88584", -- [37]
			"91940:81060:81061:81064:83924:81250:87395", -- [38]
			"91940:81060:81061:81064:82309:88653", -- [39]
			"91940:81060:81061:81064:83924:81250:88668", -- [40]
			"81884:84714:88757", -- [41]
			["direct"] = "80932:84507:81884:90960:91940:92808:92809",
			["coord"] = 1123443650,
			["m"] = 945,
			["f"] = 0,
		},
		[82844] = {
			"83924:81064:81103:76840", -- [1]
			"83924:81068:84509:84515:84504:76839", -- [2]
			"83924:81068:84509:84515:84504:76839:76851", -- [3]
			"83924:81068:81077:76850", -- [4]
			"83924:81064:85959", -- [5]
			"83924:81064:81060:80932", -- [6]
			"83924:81064:81060", -- [7]
			"83924:81064:81061", -- [8]
			"83924:81064", -- [9]
			"83924:81064:81354:81067", -- [10]
			"83924:81068", -- [11]
			"83924:81068:81077", -- [12]
			"83924:81064:81354", -- [13]
			"83924:81068:84509:84515:84504:76839:81284", -- [14]
			"83924:81068:81077:76850:81289", -- [15]
			"83924:81068:84509:84515:84504:81285", -- [16]
			"83924:81064:81103", -- [17]
			"83924:81068:84509:83567", -- [18]
			"83924:81068:84509:84498", -- [19]
			"83924:81068:84509:84515:84504", -- [20]
			"83924:81068:84509:84498:82511", -- [21]
			"84993:84507", -- [22]
			"83924:81068:84509", -- [23]
			"83924:81068:84509:84515", -- [24]
			"84993:81074:81884", -- [25]
			"84993:81074", -- [26]
			"84993:86492", -- [27]
			"84993:81888", -- [28]
			"84993:85829:84700", -- [29]
			"83924:81068:84509:84515:84504:81285:83427", -- [30]
			"84993:85829", -- [31]
			"83924:81068:84509:84515:84504:76839:81284:86685", -- [32]
			"84993:86492:84714", -- [33]
			"83924:81064:88584", -- [34]
			"88668:87395", -- [35]
			"82309:88653", -- [36]
			"84993:86492:84714:88757", -- [37]
			"83924:81064:81060:80932:90562:90960", -- [38]
			"84993:84507:90560", -- [39]
			"83924:81064:81060:91940", -- [40]
			"83924:81064:81060:80932:92809:92808", -- [41]
			"83924:81064:81060:80932:92809", -- [42]
			["direct"] = "76787:83924:82309:81250:84993:88668",
			["coord"] = 3163178020,
			["m"] = 950,
			["f"] = 0,
		},
		[81060] = {
			"80932:81103:76840", -- [1]
			"80932:81103:76839", -- [2]
			"80932:81103:76840:76851", -- [3]
			"81067:76850", -- [4]
			"84993:76787", -- [5]
			"80932:90562:90960:85959", -- [6]
			"81061:81064:81068", -- [7]
			"81061:81077", -- [8]
			"81061:81354", -- [9]
			"80932:81103:76839:81284", -- [10]
			"80932:81103:81289", -- [11]
			"88584:81285", -- [12]
			"81061:81064:83924", -- [13]
			"81061:81064:83924:82844", -- [14]
			"81061:81064:83924:81250", -- [15]
			"81061:81354:84515:84498", -- [16]
			"88584:84504", -- [17]
			"81061:81354:84515:82511", -- [18]
			"81061:81064:84509", -- [19]
			"81061:81354:84515", -- [20]
			"84507:81884", -- [21]
			"81888:86492", -- [22]
			"81074:84700", -- [23]
			"80932:81103:83427", -- [24]
			"84993:85829", -- [25]
			"80932:81103:76840:76851:86685", -- [26]
			"81074:84714", -- [27]
			"81061:81064:83924:81250:87395", -- [28]
			"81061:81064:82309:88653", -- [29]
			"81061:81064:83924:81250:88668", -- [30]
			"81074:84714:88757", -- [31]
			"80932:90562:90960", -- [32]
			"91940:90560", -- [33]
			"80932:92809:92808", -- [34]
			"80932:92809", -- [35]
			["direct"] = "80932:81061:81064:81067:81103:83567:82309:84507:81074:81888:84993:88584:91940",
			["coord"] = 2999400164,
			["m"] = 946,
			["f"] = 0,
		},
		[82309] = {
			"81103:76840", -- [1]
			"83924:81068:84509:84515:84504:76839", -- [2]
			"81103:76840:76851", -- [3]
			"83924:81068:81077:76850", -- [4]
			"82844:76787", -- [5]
			"81064:85959", -- [6]
			"81064:81060:80932", -- [7]
			"81064:81061", -- [8]
			"81064:81354:81067", -- [9]
			"83924:81068", -- [10]
			"83924:81068:81077", -- [11]
			"81064:81354", -- [12]
			"83924:81068:84509:84515:84504:76839:81284", -- [13]
			"81103:81289", -- [14]
			"81064:88584:81285", -- [15]
			"83924:81068:84509:84498", -- [16]
			"83924:81068:84509:84515:84504", -- [17]
			"83567:82511", -- [18]
			"81064:81060:84507", -- [19]
			"83924:81068:84509", -- [20]
			"83924:81068:84509:84515", -- [21]
			"81074:81884", -- [22]
			"82844:84993:86492", -- [23]
			"81064:81060:81888", -- [24]
			"82844:84993:85829:84700", -- [25]
			"82844:84993", -- [26]
			"81064:88584:81285:83427", -- [27]
			"82844:84993:85829", -- [28]
			"83924:81068:84509:84515:84504:76839:81284:86685", -- [29]
			"81074:84714", -- [30]
			"81064:88584", -- [31]
			"81250:88668", -- [32]
			"81074:84714:88757", -- [33]
			"81064:81060:80932:90562:90960", -- [34]
			"81064:81060:91940:90560", -- [35]
			"81064:81060:91940", -- [36]
			"81064:81060:80932:92809:92808", -- [37]
			"81064:81060:80932:92809", -- [38]
			["direct"] = "81060:81064:81103:83567:83924:82844:81250:81074:87395:88653",
			["coord"] = 2730401169,
			["m"] = 950,
			["f"] = 0,
		},
		[81061] = {
			"81354:76850:76840", -- [1]
			"81060:80932:81103:76839", -- [2]
			"81354:76850:81289:76851", -- [3]
			"81354:76850", -- [4]
			"81064:76787", -- [5]
			"81064:85959", -- [6]
			"81060:80932", -- [7]
			"81354:81067", -- [8]
			"81064:81068", -- [9]
			"81354:76850:76840:81284", -- [10]
			"81354:76850:81289", -- [11]
			"81354:88584:81285", -- [12]
			"81060:80932:81103", -- [13]
			"81064:83567", -- [14]
			"81064:83924", -- [15]
			"81064:83924:82844", -- [16]
			"81064:82309", -- [17]
			"81064:83924:81250", -- [18]
			"81354:84515:84498", -- [19]
			"81354:84515:84504", -- [20]
			"81354:84515:82511", -- [21]
			"81060:84507", -- [22]
			"81064:84509", -- [23]
			"81354:84515", -- [24]
			"81060:84507:81884", -- [25]
			"81060:81074", -- [26]
			"81060:81888:86492", -- [27]
			"81060:81888", -- [28]
			"81060:81074:84700", -- [29]
			"81060:84993", -- [30]
			"81354:76850:83427", -- [31]
			"81060:84993:85829", -- [32]
			"81354:76850:81289:86685", -- [33]
			"81060:81074:84714", -- [34]
			"81354:88584", -- [35]
			"81064:83924:81250:87395", -- [36]
			"81064:82309:88653", -- [37]
			"81064:83924:81250:88668", -- [38]
			"81060:81074:84714:88757", -- [39]
			"81060:80932:90562:90960", -- [40]
			"81060:91940:90560", -- [41]
			"81060:91940", -- [42]
			"81060:80932:92809:92808", -- [43]
			"81060:80932:92809", -- [44]
			["direct"] = "81060:81064:81077:81354",
			["coord"] = 2716615112,
			["m"] = 946,
			["f"] = 0,
		},
		[84498] = {
			"84504:76839:76840", -- [1]
			"84504:76839", -- [2]
			"84504:76839:76851", -- [3]
			"84504:76850", -- [4]
			"84509:81077:81064:76787", -- [5]
			"84504:76839:76851:81289:85959", -- [6]
			"84504:81067:80932", -- [7]
			"84504:81067:81060", -- [8]
			"84509:81077:81061", -- [9]
			"84509:81077:81064", -- [10]
			"84504:81067", -- [11]
			"84509:81068", -- [12]
			"84509:81077", -- [13]
			"84515:81354", -- [14]
			"84504:76839:81284", -- [15]
			"84504:76839:76851:81289", -- [16]
			"84504:81285", -- [17]
			"84504:88584:81103", -- [18]
			"84509:81068:83924", -- [19]
			"84509:81068:83924:82844", -- [20]
			"83567:82309", -- [21]
			"84509:81068:83924:81250", -- [22]
			"84504:81067:81060:84507", -- [23]
			"84504:81067:80932:90560:81884", -- [24]
			"84504:81067:81060:81074", -- [25]
			"84509:81077:81064:84993:86492", -- [26]
			"84504:81067:81060:81888", -- [27]
			"84509:81077:81064:84993:85829:84700", -- [28]
			"84509:81077:81064:84993", -- [29]
			"84504:81285:83427", -- [30]
			"84509:81077:81064:84993:85829", -- [31]
			"84504:76839:81284:86685", -- [32]
			"84504:81067:80932:90560:81884:84714", -- [33]
			"84504:88584", -- [34]
			"83567:82309:87395", -- [35]
			"83567:88653", -- [36]
			"84509:81068:83924:81250:88668", -- [37]
			"84504:81067:80932:90560:81884:84714:88757", -- [38]
			"84504:76850:90562:90960", -- [39]
			"84504:81067:80932:90560", -- [40]
			"84504:81067:80932:91940", -- [41]
			"84504:76850:90562:92808", -- [42]
			"84504:81067:80932:92809", -- [43]
			["direct"] = "83567:84504:82511:84509:84515",
			["coord"] = 1985114355,
			["m"] = 948,
			["f"] = 0,
		},
		[81289] = {
			"76840:76839", -- [1]
			"90562:90560:84507:84993:76787", -- [2]
			"81103:81067:80932", -- [3]
			"81103:81067:81060", -- [4]
			"76850:81354:81061", -- [5]
			"76850:81354:81064", -- [6]
			"81103:81067", -- [7]
			"76850:81077:81068", -- [8]
			"76850:81077", -- [9]
			"76850:81354", -- [10]
			"76851:81284", -- [11]
			"76851:81284:81285", -- [12]
			"76840:76839:84504:84498:83567", -- [13]
			"76850:81354:81064:83924", -- [14]
			"76850:81354:81064:83924:82844", -- [15]
			"76850:81354:81064:82309", -- [16]
			"76850:81354:81064:83924:81250", -- [17]
			"76840:76839:84504:84498", -- [18]
			"76840:76839:84504", -- [19]
			"76840:76839:84504:82511", -- [20]
			"90562:90560:84507", -- [21]
			"76840:76839:84504:84498:84509", -- [22]
			"76850:88584:84515", -- [23]
			"90562:90960:81884", -- [24]
			"81103:81074", -- [25]
			"90562:92808:84714:86492", -- [26]
			"90562:90560:84507:81888", -- [27]
			"90562:92808:84714:84700", -- [28]
			"90562:90560:84507:84993", -- [29]
			"76851:81284:83427", -- [30]
			"90562:92808:84714:85829", -- [31]
			"90562:92808:84714", -- [32]
			"76850:88584", -- [33]
			"76850:81354:81064:83924:81250:87395", -- [34]
			"76850:81354:81064:82309:88653", -- [35]
			"76850:81354:81064:83924:81250:88668", -- [36]
			"90562:92808:84714:88757", -- [37]
			"90562:90960", -- [38]
			"90562:90560", -- [39]
			"90562:91940", -- [40]
			"90562:92808", -- [41]
			"90562:92809", -- [42]
			["direct"] = "76840:76851:76850:85959:81103:86685",
			["coord"] = 2520928707,
			["m"] = 947,
			["f"] = 0,
		},
		[85829] = {
			"84714:92808:90562:76850:76840", -- [1]
			"84714:92808:90562:76850:76840:76839", -- [2]
			"84714:92808:90562:81289:76851", -- [3]
			"84714:92808:90562:76850", -- [4]
			"81884:85959", -- [5]
			"84993:81060:80932", -- [6]
			"84993:81060", -- [7]
			"84993:81060:81061", -- [8]
			"84993:81064", -- [9]
			"84993:81060:81067", -- [10]
			"84993:81064:81068", -- [11]
			"84993:81064:81077", -- [12]
			"84993:81060:81061:81354", -- [13]
			"84714:92808:90562:76850:76840:81284", -- [14]
			"84714:92808:90562:81289", -- [15]
			"84993:81060:88584:81285", -- [16]
			"84993:81060:80932:81103", -- [17]
			"84993:81064:83567", -- [18]
			"84993:82844:83924", -- [19]
			"84993:82844", -- [20]
			"84993:82844:82309", -- [21]
			"84993:82844:81250", -- [22]
			"84993:81064:84509:84498", -- [23]
			"84993:81060:88584:84504", -- [24]
			"84993:81064:84509:84498:82511", -- [25]
			"86492:81888:84507", -- [26]
			"84993:81064:84509", -- [27]
			"84993:81064:84509:84515", -- [28]
			"86492:81888", -- [29]
			"84714:92808:90562:76850:83427", -- [30]
			"84714:92808:90562:81289:86685", -- [31]
			"84993:81060:88584", -- [32]
			"76787:87395", -- [33]
			"84993:82844:82309:88653", -- [34]
			"84993:82844:88668", -- [35]
			"84714:88757", -- [36]
			"84714:92808:90960", -- [37]
			"81884:90560", -- [38]
			"86492:81888:84507:91940", -- [39]
			"84714:92808", -- [40]
			"86492:81888:84507:91940:92809", -- [41]
			["direct"] = "76787:81884:81074:86492:84700:84993:84714",
			["f"] = 0,
			["m"] = 949,
			["coord"] = 1700552098,
		},
		[85959] = {
			"81289:76840", -- [1]
			"81289:76840:76839", -- [2]
			"81289:76851", -- [3]
			"81289:76850", -- [4]
			"81884:85829:76787", -- [5]
			"90960:90562:80932", -- [6]
			"90960:91940:81060", -- [7]
			"90960:91940:81060:81061", -- [8]
			"81103:81067", -- [9]
			"81103:81067:81354:81077:81068", -- [10]
			"81103:81067:81354:81077", -- [11]
			"81103:81067:81354", -- [12]
			"81289:76851:81284", -- [13]
			"88584:83567", -- [14]
			"81064:83924", -- [15]
			"81064:83924:82844", -- [16]
			"81064:82309", -- [17]
			"81064:83924:81250", -- [18]
			"81103:84515:84498", -- [19]
			"81289:76840:76839:84504", -- [20]
			"81289:76840:76839:84504:82511", -- [21]
			"90960:90560:84507", -- [22]
			"81103:84515:84509", -- [23]
			"81103:84515", -- [24]
			"81884:81074", -- [25]
			"81884:81074:86492", -- [26]
			"90960:90560:84507:81888", -- [27]
			"81884:84700", -- [28]
			"90960:90560:84507:84993", -- [29]
			"81884:85829", -- [30]
			"81289:86685", -- [31]
			"81884:84714", -- [32]
			"81064:83924:81250:87395", -- [33]
			"81064:82309:88653", -- [34]
			"81064:83924:81250:88668", -- [35]
			"81884:84714:88757", -- [36]
			"90960:90560", -- [37]
			"90960:91940", -- [38]
			"90960:92808", -- [39]
			"90960:90562:92809", -- [40]
			["direct"] = "81064:81289:81285:81103:81884:83427:88584:90960",
			["coord"] = 1321761818,
			["m"] = 1009,
			["f"] = 0,
		},
		[90562] = {
			"76850:76840", -- [1]
			"76850:76840:76839", -- [2]
			"81289:76851", -- [3]
			"90560:84507:84993:76787", -- [4]
			"90960:85959", -- [5]
			"91940:81060", -- [6]
			"91940:81060:81061", -- [7]
			"91940:81060:81061:81064", -- [8]
			"81103:81067", -- [9]
			"80932:81354:81077:81068", -- [10]
			"80932:81354:81077", -- [11]
			"80932:81354", -- [12]
			"76850:76840:81284", -- [13]
			"76850:81285", -- [14]
			"81103:84515:84498:83567", -- [15]
			"91940:81060:81061:81064:83924", -- [16]
			"91940:81060:81061:81064:83924:82844", -- [17]
			"91940:81060:81061:81064:82309", -- [18]
			"91940:81060:81061:81064:83924:81250", -- [19]
			"81103:84515:84498", -- [20]
			"81103:88584:84504", -- [21]
			"81103:88584:82511", -- [22]
			"90560:84507", -- [23]
			"81103:84515:84509", -- [24]
			"81103:84515", -- [25]
			"90960:81884", -- [26]
			"90560:84507:81888:81074", -- [27]
			"92808:84714:86492", -- [28]
			"90560:84507:81888", -- [29]
			"92808:84714:84700", -- [30]
			"90560:84507:84993", -- [31]
			"76850:83427", -- [32]
			"92808:84714:85829", -- [33]
			"81289:86685", -- [34]
			"92808:84714", -- [35]
			"81103:88584", -- [36]
			"91940:81060:81061:81064:83924:81250:87395", -- [37]
			"91940:81060:81061:81064:82309:88653", -- [38]
			"91940:81060:81061:81064:83924:81250:88668", -- [39]
			"92808:84714:88757", -- [40]
			["direct"] = "76850:80932:81289:81103:90960:90560:91940:92808:92809",
			["m"] = 945,
			["coord"] = 2021110714,
			["f"] = 0,
		},
		[81888] = {
			"84507:81103:76840", -- [1]
			"84507:81103:76839", -- [2]
			"84507:91940:90562:81289:76851", -- [3]
			"84507:91940:90562:76850", -- [4]
			"84993:76787", -- [5]
			"84507:90560:90960:85959", -- [6]
			"84507:91940:80932", -- [7]
			"81060:81061", -- [8]
			"81060:81061:81064", -- [9]
			"81060:81067", -- [10]
			"81060:81061:81064:81068", -- [11]
			"81060:81061:81077", -- [12]
			"81060:81061:81354", -- [13]
			"84507:81103:76839:81284", -- [14]
			"84507:91940:90562:81289", -- [15]
			"81060:88584:81285", -- [16]
			"84507:81103", -- [17]
			"81060:83567", -- [18]
			"81060:81061:81064:83924", -- [19]
			"84993:82844", -- [20]
			"81060:81061:81064:82309", -- [21]
			"84993:82844:81250", -- [22]
			"81060:81061:81354:84515:84498", -- [23]
			"81060:88584:84504", -- [24]
			"81060:81061:81354:84515:82511", -- [25]
			"81060:81061:81064:84509", -- [26]
			"81060:81061:81354:84515", -- [27]
			"86492:84700", -- [28]
			"84507:81103:83427", -- [29]
			"86492:85829", -- [30]
			"84507:91940:90562:81289:86685", -- [31]
			"81060:88584", -- [32]
			"84993:82844:88668:87395", -- [33]
			"81060:81061:81064:82309:88653", -- [34]
			"84993:82844:88668", -- [35]
			"84714:88757", -- [36]
			"84507:90560:90960", -- [37]
			"84507:90560", -- [38]
			"84507:91940", -- [39]
			"84507:90560:92808", -- [40]
			"84507:91940:92809", -- [41]
			["direct"] = "81060:84507:81884:81074:86492:84993:84714",
			["coord"] = 1993655344,
			["m"] = 949,
			["f"] = 0,
		},
		[76840] = {
			"81103:84507:84993:76787", -- [1]
			"81289:85959", -- [2]
			"81103:81067:80932", -- [3]
			"81103:81067:81060", -- [4]
			"81103:81067:81354:81061", -- [5]
			"81103:81067:81354:81064", -- [6]
			"81103:81067", -- [7]
			"81103:81067:81354:81077:81068", -- [8]
			"81103:81067:81354:81077", -- [9]
			"81103:81067:81354", -- [10]
			"76839:81285", -- [11]
			"76839:84504:84498:83567", -- [12]
			"81103:81067:81354:81064:83924", -- [13]
			"81103:81067:81354:81064:83924:82844", -- [14]
			"81103:82309", -- [15]
			"81103:81067:81354:81064:83924:81250", -- [16]
			"76839:84504:84498", -- [17]
			"76839:84504", -- [18]
			"76839:84504:82511", -- [19]
			"81103:84507", -- [20]
			"76839:84504:84498:84509", -- [21]
			"76839:84504:84515", -- [22]
			"76850:90562:90960:81884", -- [23]
			"81103:81074", -- [24]
			"81103:84507:81888:86492", -- [25]
			"81103:84507:81888", -- [26]
			"76850:90562:92808:84714:84700", -- [27]
			"81103:84507:84993", -- [28]
			"76850:90562:92808:84714:85829", -- [29]
			"76851:86685", -- [30]
			"76850:90562:92808:84714", -- [31]
			"76850:88584", -- [32]
			"81103:81067:81354:81064:83924:81250:87395", -- [33]
			"81103:82309:88653", -- [34]
			"81103:81067:81354:81064:83924:81250:88668", -- [35]
			"76850:90562:92808:84714:88757", -- [36]
			"76850:90562:90960", -- [37]
			"76850:90562:90560", -- [38]
			"81103:81067:80932:91940", -- [39]
			"76850:90562:92808", -- [40]
			"76850:90562:92809", -- [41]
			["direct"] = "76839:76851:76850:81284:81289:81103:83427",
			["coord"] = 1960928129,
			["m"] = 947,
			["f"] = 0,
		},
		[81250] = {
			"83924:81064:81103:76840", -- [1]
			"83924:81068:84509:84515:84504:76839", -- [2]
			"83924:81068:84509:84515:84504:76839:76851", -- [3]
			"83924:81068:81077:76850", -- [4]
			"82844:76787", -- [5]
			"83924:81064:85959", -- [6]
			"83924:81064:81060:80932", -- [7]
			"83924:81064:81060", -- [8]
			"83924:81064:81061", -- [9]
			"83924:81064", -- [10]
			"83924:81064:81354:81067", -- [11]
			"83924:81068", -- [12]
			"83924:81068:81077", -- [13]
			"83924:81064:81354", -- [14]
			"83924:81068:84509:84515:84504:76839:81284", -- [15]
			"83924:81068:81077:76850:81289", -- [16]
			"83924:81068:84509:84515:84504:81285", -- [17]
			"83924:81064:81103", -- [18]
			"82309:83567", -- [19]
			"83924:81068:84509:84498", -- [20]
			"83924:81068:84509:84515:84504", -- [21]
			"83924:81068:84509:84498:82511", -- [22]
			"83924:81064:81060:84507", -- [23]
			"83924:81068:84509", -- [24]
			"83924:81068:84509:84515", -- [25]
			"82844:84993:81074:81884", -- [26]
			"82844:84993:81074", -- [27]
			"82844:84993:86492", -- [28]
			"82844:84993:81888", -- [29]
			"82844:84993:85829:84700", -- [30]
			"82844:84993", -- [31]
			"83924:81068:84509:84515:84504:81285:83427", -- [32]
			"82844:84993:85829", -- [33]
			"83924:81068:84509:84515:84504:76839:81284:86685", -- [34]
			"82844:84993:86492:84714", -- [35]
			"83924:81064:88584", -- [36]
			"82309:88653", -- [37]
			"82844:84993:86492:84714:88757", -- [38]
			"83924:81064:81060:80932:90562:90960", -- [39]
			"83924:81064:81060:91940:90560", -- [40]
			"83924:81064:81060:91940", -- [41]
			"83924:81064:81060:80932:92809:92808", -- [42]
			"83924:81064:81060:80932:92809", -- [43]
			["direct"] = "83924:82844:82309:87395:88668",
			["coord"] = 2688772126,
			["m"] = 950,
			["f"] = 0,
		},
		[81884] = {
			"90960:90562:76850:76840", -- [1]
			"90960:90562:76850:76840:76839", -- [2]
			"90960:90562:81289:76851", -- [3]
			"90960:90562:76850", -- [4]
			"85829:76787", -- [5]
			"90560:80932", -- [6]
			"81888:81060", -- [7]
			"81888:81060:81061", -- [8]
			"81888:81060:81061:81064", -- [9]
			"90560:80932:81067", -- [10]
			"81888:81060:81061:81064:81068", -- [11]
			"90560:80932:81354:81077", -- [12]
			"90560:80932:81354", -- [13]
			"90960:90562:76850:76840:81284", -- [14]
			"90960:90562:81289", -- [15]
			"90960:90562:76850:81285", -- [16]
			"90560:80932:81354:84515:84498:83567", -- [17]
			"81888:81060:81061:81064:83924", -- [18]
			"81074:84993:82844", -- [19]
			"81074:82309", -- [20]
			"81074:84993:82844:81250", -- [21]
			"90560:80932:81354:84515:84498", -- [22]
			"90560:80932:81354:84515:84504", -- [23]
			"90560:80932:81354:84515:82511", -- [24]
			"90560:80932:81354:81077:84509", -- [25]
			"90560:80932:81354:84515", -- [26]
			"81074:86492", -- [27]
			"81074:84993", -- [28]
			"90960:90562:76850:83427", -- [29]
			"90960:90562:81289:86685", -- [30]
			"90560:80932:81103:88584", -- [31]
			"81074:84993:82844:88668:87395", -- [32]
			"81074:82309:88653", -- [33]
			"81074:84993:82844:88668", -- [34]
			"84714:88757", -- [35]
			"90560:91940", -- [36]
			"90560:92808", -- [37]
			"90560:92809", -- [38]
			["direct"] = "85959:81103:84507:81074:81888:84700:85829:84714:90960:90560",
			["coord"] = 2753663786,
			["m"] = 949,
			["f"] = 0,
		},
		[90960] = {
			"90562:76850:76840", -- [1]
			"90562:76850:76840:76839", -- [2]
			"90562:81289:76851", -- [3]
			"90562:76850", -- [4]
			"90560:84507:84993:76787", -- [5]
			"90562:80932", -- [6]
			"91940:81060", -- [7]
			"91940:81060:81061", -- [8]
			"91940:81060:81061:81064", -- [9]
			"90562:81103:81067", -- [10]
			"90562:80932:81354:81077:81068", -- [11]
			"90562:80932:81354:81077", -- [12]
			"90562:80932:81354", -- [13]
			"90562:76850:76840:81284", -- [14]
			"90562:81289", -- [15]
			"90562:76850:81285", -- [16]
			"90562:81103", -- [17]
			"90562:81103:84515:84498:83567", -- [18]
			"91940:81060:81061:81064:83924", -- [19]
			"91940:81060:81061:81064:83924:82844", -- [20]
			"91940:81060:81061:81064:82309", -- [21]
			"91940:81060:81061:81064:83924:81250", -- [22]
			"90562:81103:84515:84498", -- [23]
			"90562:81103:88584:84504", -- [24]
			"90562:81103:88584:82511", -- [25]
			"90560:84507", -- [26]
			"90562:81103:84515:84509", -- [27]
			"90562:81103:84515", -- [28]
			"81884:81074", -- [29]
			"92808:84714:86492", -- [30]
			"90560:84507:81888", -- [31]
			"81884:84700", -- [32]
			"90560:84507:84993", -- [33]
			"90562:76850:83427", -- [34]
			"81884:85829", -- [35]
			"90562:81289:86685", -- [36]
			"92808:84714", -- [37]
			"90562:81103:88584", -- [38]
			"91940:81060:81061:81064:83924:81250:87395", -- [39]
			"91940:81060:81061:81064:82309:88653", -- [40]
			"91940:81060:81061:81064:83924:81250:88668", -- [41]
			"92808:84714:88757", -- [42]
			"90562:92809", -- [43]
			["direct"] = "85959:81884:90560:91940:92808",
			["f"] = 0,
			["m"] = 945,
			["coord"] = 2470680201,
		},
		[81284] = {
			"76840:76850", -- [1]
			"76840:81103:84507:84993:76787", -- [2]
			"76851:81289:85959", -- [3]
			"76840:81103:81067:80932", -- [4]
			"76840:81103:81067:81060", -- [5]
			"76840:81103:81067:81354:81061", -- [6]
			"76840:81103:81067:81354:81064", -- [7]
			"76840:81103:81067", -- [8]
			"76840:81103:81067:81354:81077:81068", -- [9]
			"76840:81103:81067:81354:81077", -- [10]
			"76840:81103:81067:81354", -- [11]
			"76851:81289", -- [12]
			"76840:81103", -- [13]
			"81285:83567", -- [14]
			"76840:81103:81067:81354:81064:83924", -- [15]
			"76840:81103:81067:81354:81064:83924:82844", -- [16]
			"76840:81103:82309", -- [17]
			"76840:81103:81067:81354:81064:83924:81250", -- [18]
			"76839:84504:84498", -- [19]
			"76839:84504", -- [20]
			"76839:84504:82511", -- [21]
			"76840:81103:84507", -- [22]
			"76839:84504:84498:84509", -- [23]
			"76839:84504:84515", -- [24]
			"76851:81289:90562:90960:81884", -- [25]
			"76840:81103:81074", -- [26]
			"76840:81103:84507:81888:86492", -- [27]
			"76840:81103:84507:81888", -- [28]
			"76851:81289:90562:92808:84714:84700", -- [29]
			"76840:81103:84507:84993", -- [30]
			"76851:81289:90562:92808:84714:85829", -- [31]
			"76851:81289:90562:92808:84714", -- [32]
			"81285:88584", -- [33]
			"76840:81103:81067:81354:81064:83924:81250:87395", -- [34]
			"76840:81103:82309:88653", -- [35]
			"76840:81103:81067:81354:81064:83924:81250:88668", -- [36]
			"76851:81289:90562:92808:84714:88757", -- [37]
			"76851:81289:90562:90960", -- [38]
			"76851:81289:90562:90560", -- [39]
			"76851:81289:90562:91940", -- [40]
			"76851:81289:90562:92808", -- [41]
			"76851:81289:90562:92809", -- [42]
			["direct"] = "76840:76839:76851:81285:83427:86685",
			["coord"] = 2450493706,
			["m"] = 947,
			["f"] = 0,
		},
		[81077] = {
			"76850:76840", -- [1]
			"84509:84515:84504:76839", -- [2]
			"76850:81289:76851", -- [3]
			"81064:76787", -- [4]
			"81064:85959", -- [5]
			"81354:80932", -- [6]
			"81064:81060", -- [7]
			"76850:76840:81284", -- [8]
			"76850:81289", -- [9]
			"81067:81103", -- [10]
			"84509:83567", -- [11]
			"81064:83924", -- [12]
			"81064:83924:82844", -- [13]
			"81064:82309", -- [14]
			"81064:83924:81250", -- [15]
			"84509:84498", -- [16]
			"84509:84515:84504", -- [17]
			"84509:84498:82511", -- [18]
			"81064:81060:84507", -- [19]
			"84509:84515", -- [20]
			"81354:80932:90560:81884", -- [21]
			"81064:81060:81074", -- [22]
			"81064:84993:86492", -- [23]
			"81064:81060:81888", -- [24]
			"81064:84993:85829:84700", -- [25]
			"81064:84993", -- [26]
			"81285:83427", -- [27]
			"81064:84993:85829", -- [28]
			"76850:81289:86685", -- [29]
			"81064:81060:81074:84714", -- [30]
			"81064:83924:81250:87395", -- [31]
			"81064:82309:88653", -- [32]
			"81064:83924:81250:88668", -- [33]
			"81064:81060:81074:84714:88757", -- [34]
			"81354:80932:90562:90960", -- [35]
			"81354:80932:90560", -- [36]
			"81064:81060:91940", -- [37]
			"81354:80932:92809:92808", -- [38]
			"81354:80932:92809", -- [39]
			["direct"] = "76850:81061:81064:81067:81068:81354:81285:84509:88584",
			["coord"] = 2354688007,
			["m"] = 946,
			["f"] = 0,
		},
		[88668] = {
			"81250:83924:81064:81103:76840", -- [1]
			"81250:83924:81068:84509:84515:84504:76839", -- [2]
			"81250:83924:81068:84509:84515:84504:76839:76851", -- [3]
			"81250:83924:81068:81077:76850", -- [4]
			"82844:76787", -- [5]
			"81250:83924:81064:85959", -- [6]
			"81250:83924:81064:81060:80932", -- [7]
			"81250:83924:81064:81060", -- [8]
			"81250:83924:81064:81061", -- [9]
			"81250:83924:81064", -- [10]
			"81250:83924:81064:81354:81067", -- [11]
			"81250:83924:81068", -- [12]
			"81250:83924:81068:81077", -- [13]
			"81250:83924:81064:81354", -- [14]
			"81250:83924:81068:84509:84515:84504:76839:81284", -- [15]
			"81250:83924:81068:81077:76850:81289", -- [16]
			"81250:83924:81068:84509:84515:84504:81285", -- [17]
			"81250:83924:81064:81103", -- [18]
			"81250:82309:83567", -- [19]
			"81250:82309", -- [20]
			"81250:83924:81068:84509:84498", -- [21]
			"81250:83924:81068:84509:84515:84504", -- [22]
			"81250:83924:81068:84509:84498:82511", -- [23]
			"82844:84993:84507", -- [24]
			"81250:83924:81068:84509", -- [25]
			"81250:83924:81068:84509:84515", -- [26]
			"82844:84993:81074:81884", -- [27]
			"82844:84993:81074", -- [28]
			"82844:84993:86492", -- [29]
			"82844:84993:81888", -- [30]
			"82844:84993:85829:84700", -- [31]
			"82844:84993", -- [32]
			"81250:83924:81068:84509:84515:84504:81285:83427", -- [33]
			"82844:84993:85829", -- [34]
			"81250:83924:81068:84509:84515:84504:76839:81284:86685", -- [35]
			"82844:84993:86492:84714", -- [36]
			"81250:83924:81064:88584", -- [37]
			"82844:84993:86492:84714:88757", -- [38]
			"81250:83924:81064:81060:80932:90562:90960", -- [39]
			"81250:83924:81064:81060:91940:90560", -- [40]
			"81250:83924:81064:81060:91940", -- [41]
			"81250:83924:81064:81060:80932:92809:92808", -- [42]
			"81250:83924:81064:81060:80932:92809", -- [43]
			["direct"] = "83924:82844:81250:87395:88653",
			["coord"] = 2673169502,
			["m"] = 950,
			["f"] = 0,
		},
		[91940] = {
			"80932:81103:76840", -- [1]
			"80932:81103:76839", -- [2]
			"90562:81289:76851", -- [3]
			"90562:76850", -- [4]
			"84507:84993:76787", -- [5]
			"90960:85959", -- [6]
			"81060:81061", -- [7]
			"81060:81061:81064", -- [8]
			"80932:81067", -- [9]
			"81060:81061:81064:81068", -- [10]
			"81060:81061:81077", -- [11]
			"80932:81354", -- [12]
			"80932:81103:76839:81284", -- [13]
			"90562:81289", -- [14]
			"80932:81103:76839:81285", -- [15]
			"80932:81103", -- [16]
			"81060:83567", -- [17]
			"81060:81061:81064:83924", -- [18]
			"81060:81061:81064:83924:82844", -- [19]
			"81060:81061:81064:82309", -- [20]
			"81060:81061:81064:83924:81250", -- [21]
			"80932:81354:84515:84498", -- [22]
			"81060:88584:84504", -- [23]
			"80932:81354:84515:82511", -- [24]
			"81060:81061:81064:84509", -- [25]
			"80932:81354:84515", -- [26]
			"84507:81884", -- [27]
			"84507:81888:81074", -- [28]
			"84507:81888:86492", -- [29]
			"84507:81888", -- [30]
			"84507:81888:86492:84700", -- [31]
			"84507:84993", -- [32]
			"80932:81103:83427", -- [33]
			"84507:81888:86492:85829", -- [34]
			"90562:81289:86685", -- [35]
			"84507:81888:84714", -- [36]
			"81060:88584", -- [37]
			"81060:81061:81064:83924:81250:87395", -- [38]
			"81060:81061:81064:82309:88653", -- [39]
			"81060:81061:81064:83924:81250:88668", -- [40]
			"84507:81888:84714:88757", -- [41]
			"92809:92808", -- [42]
			["direct"] = "80932:81060:84507:90960:90560:92809",
			["coord"] = 429164524,
			["m"] = 945,
			["f"] = 0,
		},
		[83924] = {
			"81064:81103:76840", -- [1]
			"81068:84509:84515:84504:76839", -- [2]
			"81068:84509:84515:84504:76839:76851", -- [3]
			"81068:81077:76850", -- [4]
			"82844:76787", -- [5]
			"81064:85959", -- [6]
			"81064:81060:80932", -- [7]
			"81064:81060", -- [8]
			"81064:81061", -- [9]
			"81064:81354:81067", -- [10]
			"81068:81077", -- [11]
			"81064:81354", -- [12]
			"81068:84509:84515:84504:76839:81284", -- [13]
			"81068:81077:76850:81289", -- [14]
			"81068:84509:84515:84504:81285", -- [15]
			"81064:81103", -- [16]
			"81068:84509:83567", -- [17]
			"81068:84509:84498", -- [18]
			"81068:84509:84515:84504", -- [19]
			"81068:84509:84498:82511", -- [20]
			"81064:81060:84507", -- [21]
			"81068:84509", -- [22]
			"81068:84509:84515", -- [23]
			"81064:81060:84507:81884", -- [24]
			"81064:81060:81074", -- [25]
			"82844:84993:86492", -- [26]
			"81064:81060:81888", -- [27]
			"82844:84993:85829:84700", -- [28]
			"82844:84993", -- [29]
			"81068:84509:84515:84504:81285:83427", -- [30]
			"82844:84993:85829", -- [31]
			"81068:84509:84515:84504:76839:81284:86685", -- [32]
			"82844:84993:86492:84714", -- [33]
			"81064:88584", -- [34]
			"81250:87395", -- [35]
			"81250:88668", -- [36]
			"82844:84993:86492:84714:88757", -- [37]
			"81064:81060:80932:90562:90960", -- [38]
			"81064:81060:91940:90560", -- [39]
			"81064:81060:91940", -- [40]
			"81064:81060:80932:92809:92808", -- [41]
			"81064:81060:80932:92809", -- [42]
			["direct"] = "81064:81068:82844:82309:81250:88653",
			["coord"] = 3424812890,
			["m"] = 950,
			["f"] = 0,
		},
		[88653] = {
			"82309:81103:76840", -- [1]
			"83924:81068:84509:84515:84504:76839", -- [2]
			"82309:81103:76840:76851", -- [3]
			"83924:81068:81077:76850", -- [4]
			"88668:82844:76787", -- [5]
			"82309:81064:85959", -- [6]
			"82309:81064:81060:80932", -- [7]
			"82309:81064:81060", -- [8]
			"82309:81064:81061", -- [9]
			"82309:81064", -- [10]
			"82309:81064:81354:81067", -- [11]
			"83924:81068", -- [12]
			"83924:81068:81077", -- [13]
			"82309:81064:81354", -- [14]
			"83924:81068:84509:84515:84504:76839:81284", -- [15]
			"83924:81068:81077:76850:81289", -- [16]
			"83567:81285", -- [17]
			"82309:81103", -- [18]
			"88668:82844", -- [19]
			"88668:81250", -- [20]
			"83924:81068:84509:84498", -- [21]
			"83924:81068:84509:84515:84504", -- [22]
			"83567:82511", -- [23]
			"82309:81064:81060:84507", -- [24]
			"83924:81068:84509", -- [25]
			"83924:81068:84509:84515", -- [26]
			"82309:81074:81884", -- [27]
			"82309:81074", -- [28]
			"88668:82844:84993:86492", -- [29]
			"88668:82844:84993:81888", -- [30]
			"88668:82844:84993:85829:84700", -- [31]
			"88668:82844:84993", -- [32]
			"83567:81285:83427", -- [33]
			"88668:82844:84993:85829", -- [34]
			"83924:81068:84509:84515:84504:76839:81284:86685", -- [35]
			"88668:82844:84993:86492:84714", -- [36]
			"82309:81064:88584", -- [37]
			"88668:82844:84993:86492:84714:88757", -- [38]
			"82309:81064:81060:80932:90562:90960", -- [39]
			"82309:81064:81060:91940:90560", -- [40]
			"82309:81064:81060:91940", -- [41]
			"82309:81064:81060:80932:92809:92808", -- [42]
			"82309:81064:81060:80932:92809", -- [43]
			["direct"] = "83567:83924:82309:87395:88668",
			["coord"] = 2119811622,
			["m"] = 950,
			["f"] = 0,
		},
		[84993] = {
			"81060:80932:81103:76840", -- [1]
			"81060:80932:81103:76839", -- [2]
			"84507:91940:90562:81289:76851", -- [3]
			"84507:91940:90562:76850", -- [4]
			"81074:81884:85959", -- [5]
			"81060:80932", -- [6]
			"81060:81061", -- [7]
			"81060:81067", -- [8]
			"81064:81068", -- [9]
			"81064:81077", -- [10]
			"81060:81061:81354", -- [11]
			"81060:80932:81103:76839:81284", -- [12]
			"84507:91940:90562:81289", -- [13]
			"81060:88584:81285", -- [14]
			"81060:80932:81103", -- [15]
			"81064:83567", -- [16]
			"82844:83924", -- [17]
			"82844:82309", -- [18]
			"82844:81250", -- [19]
			"81064:84509:84498", -- [20]
			"81060:88584:84504", -- [21]
			"81064:84509:84498:82511", -- [22]
			"81064:84509", -- [23]
			"81064:84509:84515", -- [24]
			"81074:81884", -- [25]
			"85829:84700", -- [26]
			"81060:80932:81103:83427", -- [27]
			"84507:91940:90562:81289:86685", -- [28]
			"86492:84714", -- [29]
			"81060:88584", -- [30]
			"82844:88668:87395", -- [31]
			"82844:82309:88653", -- [32]
			"82844:88668", -- [33]
			"86492:84714:88757", -- [34]
			"84507:90560:90960", -- [35]
			"84507:90560", -- [36]
			"84507:91940", -- [37]
			"84507:90560:92808", -- [38]
			"84507:91940:92809", -- [39]
			["direct"] = "76787:81060:81064:82844:84507:81074:86492:81888:85829",
			["coord"] = 3752763433,
			["m"] = 941,
			["f"] = 0,
		},
		[84504] = {
			"76839:76840", -- [1]
			"76839:76851", -- [2]
			"88584:81064:76787", -- [3]
			"76839:76851:81289:85959", -- [4]
			"81067:80932", -- [5]
			"81067:81060", -- [6]
			"88584:81354:81061", -- [7]
			"88584:81064", -- [8]
			"88584:81077:81068", -- [9]
			"88584:81077", -- [10]
			"88584:81354", -- [11]
			"76839:81284", -- [12]
			"76839:76851:81289", -- [13]
			"88584:81103", -- [14]
			"84498:83567", -- [15]
			"88584:81064:83924", -- [16]
			"88584:81064:83924:82844", -- [17]
			"88584:81064:82309", -- [18]
			"88584:81064:83924:81250", -- [19]
			"81067:81060:84507", -- [20]
			"84498:84509", -- [21]
			"81067:80932:90560:81884", -- [22]
			"81067:81060:81074", -- [23]
			"81067:81060:81888:86492", -- [24]
			"81067:81060:81888", -- [25]
			"81067:81060:81074:84700", -- [26]
			"81067:81060:84993", -- [27]
			"81285:83427", -- [28]
			"81067:81060:84993:85829", -- [29]
			"76839:81284:86685", -- [30]
			"81067:80932:90560:81884:84714", -- [31]
			"88584:81064:83924:81250:87395", -- [32]
			"84498:83567:88653", -- [33]
			"88584:81064:83924:81250:88668", -- [34]
			"81067:80932:90560:81884:84714:88757", -- [35]
			"76850:90562:90960", -- [36]
			"81067:80932:90560", -- [37]
			"81067:80932:91940", -- [38]
			"76850:90562:92808", -- [39]
			"81067:80932:92809", -- [40]
			["direct"] = "76839:76850:81067:81285:84498:82511:84515:88584",
			["coord"] = 2660068590,
			["m"] = 948,
			["f"] = 0,
		},
		[76787] = {
			"84993:81060:80932:81103:76840", -- [1]
			"84993:81060:80932:81103:76839", -- [2]
			"84993:84507:91940:90562:81289:76851", -- [3]
			"84993:84507:91940:90562:76850", -- [4]
			"85829:81884:85959", -- [5]
			"84993:81060:80932", -- [6]
			"84993:81060", -- [7]
			"84993:81060:81061", -- [8]
			"84993:81060:81067", -- [9]
			"81064:81068", -- [10]
			"81064:81077", -- [11]
			"81064:81354", -- [12]
			"84993:81060:80932:81103:76839:81284", -- [13]
			"84993:84507:91940:90562:81289", -- [14]
			"81064:88584:81285", -- [15]
			"84993:81060:80932:81103", -- [16]
			"81064:83567", -- [17]
			"82844:83924", -- [18]
			"82844:82309", -- [19]
			"82844:81250", -- [20]
			"81064:84509:84498", -- [21]
			"81064:84509:84515:84504", -- [22]
			"81064:84509:84498:82511", -- [23]
			"84993:84507", -- [24]
			"81064:84509", -- [25]
			"81064:84509:84515", -- [26]
			"85829:81884", -- [27]
			"85829:81074", -- [28]
			"85829:86492", -- [29]
			"84993:81888", -- [30]
			"85829:84700", -- [31]
			"81064:88584:81285:83427", -- [32]
			"84993:84507:91940:90562:81289:86685", -- [33]
			"85829:84714", -- [34]
			"81064:88584", -- [35]
			"82844:82309:88653", -- [36]
			"82844:88668", -- [37]
			"85829:84714:88757", -- [38]
			"84993:84507:90560:90960", -- [39]
			"84993:84507:90560", -- [40]
			"84993:84507:91940", -- [41]
			"84993:84507:90560:92808", -- [42]
			"84993:84507:91940:92809", -- [43]
			["direct"] = "81064:82844:84993:85829:87395",
			["f"] = 0,
			["m"] = 941,
			["coord"] = 2211067641,
		},
	},	
	[8] = {
		[108888] = {
			"88110:90556", -- [1]
			"110971:90639", -- [2]
			"88110:90556:93447", -- [3]
			"88110:90556:93447:93940", -- [4]
			"112866:111624:114666:100550:95688", -- [5]
			"112866:111624:111675:114718:98113:98161", -- [6]
			"112866:111624:111675:114718:111420:98108", -- [7]
			"112866:111624:111675:114718:98113", -- [8]
			"112866:111624:111675:114718:98113:98114", -- [9]
			"112866:111624:114666:100550:94973:97860", -- [10]
			"112866:111624:114666:100550:98968:97868", -- [11]
			"112866:111624:114666:100550:97870", -- [12]
			"112866:111624:114666:100550:98968:97868:98066", -- [13]
			"112866:111624:114666:96565", -- [14]
			"112866:111624:111675:98966", -- [15]
			"112866:111624:114666:100550:98968", -- [16]
			"112866:111624:114666:100550:94973:97860:98972", -- [17]
			"112866:111624:114666:100468", -- [18]`
			"88110:90556:93447:100459", -- [19]
			"112866:111624:114666:100550:94973", -- [20]
			"112866:96813", -- [21]
			"112866:111624:114666:100550", -- [22]
			"112866:111624:111675:98966:100559", -- [23]
			"112866:111624:111675:114718:98113:98161:111314", -- [24]
			"112866:96813:111323", -- [25]
			"112866:111624:111675:98966:111327", -- [26]
			"112866:111624:111675", -- [27]
			"112866:111624", -- [28]
			"112866:111624:111675:114718:111420", -- [29]
			"111418:112926", -- [30]
			"112866:111624:111675:114718", -- [31]
			"112866:111624:114666", -- [32]
			"110971:90639:114837", -- [33]
			"88110:90556:93447:100459:107457", -- [34]
			"112866:96813:120272", -- [35]
			"112866:96813:111323:120118", -- [36]			
			["direct"] = "88110:112866:111418:110971",
			["coord"] = 2070002380,
			["m"] = 1015,
			["f"] = 0,
		},
		[110971] = {
			"88110:90556", -- [1]
			"88110:112866", -- [2]
			"90639:93447", -- [3]
			"90639:93940", -- [4]
			"90639:93447:100459:100468:100550:95688", -- [5]
			"88110:90556:111675:114718:98113:98161", -- [6]
			"88110:90556:111675:114718:111420:98108", -- [7]
			"88110:90556:111675:114718:98113", -- [8]
			"88110:90556:111675:114718:98113:98114", -- [9]
			"90639:93447:100459:100468:100550:94973:97860", -- [10]
			"90639:93447:100459:100468:100550:98968:97868", -- [11]
			"90639:93447:100459:100468:100550:97870", -- [12]
			"90639:93447:100459:100468:100550:98968:97868:98066", -- [13]
			"90639:114666:96565", -- [14]
			"88110:90556:111675:98966", -- [15]
			"90639:93447:100459:100468:100550:98968", -- [16]
			"90639:93447:100459:100468:100550:94973:97860:98972", -- [17]
			"90639:93447:100459:100468", -- [18]
			"90639:93447:100459", -- [19]
			"90639:93447:100459:100468:100550:94973", -- [20]
			"88110:112866:96813", -- [21]
			"90639:93447:100459:100468:100550", -- [22]
			"88110:90556:111675:98966:100559", -- [23]
			"88110:90556:111675:114718:98113:98161:111314", -- [24]
			"88110:112866:96813:111323", -- [25]
			"88110:90556:111675:98966:111327", -- [26]
			"88110:90556:111675", -- [27]
			"88110:90556:111624", -- [28]
			"108888:111418", -- [29]
			"88110:90556:111675:114718:111420", -- [30]
			"108888:111418:112926", -- [31]
			"88110:90556:111675:114718", -- [32]
			"90639:114666", -- [33]
			"90639:114837", -- [34]
			"90639:93940:107457", -- [35]
			"88110:112866:96813:120272", -- [36]
			"88110:112866:96813:111323:120118", -- [37]			
			["direct"] = "90639:88110:108888",
			["coord"] = 1366980243,
			["m"] = 1015,
			["f"] = 0,
		},
		[94973] = {
			"100550:114666:90556", -- [1]
			"100550:114666:90639", -- [2]
			"100550:114666:90556:88110", -- [3]
			"100550:114666:111624:112866", -- [4]
			"100550:100468:100459:93447", -- [5]
			"100550:100468:100459:93940", -- [6]
			"95688:100559:98114:98161", -- [7]
			"95688:100559:98114:98161:98108", -- [8]
			"95688:100559:98114:98113", -- [9]
			"95688:100559:98114", -- [10]
			"97868:98066", -- [11]
			"100550:96565", -- [12]
			"95688:98966", -- [13]
			"97860:98972", -- [14]
			"100550:100468", -- [15]
			"100550:100468:100459", -- [16]
			"100550:114666:111675:96813", -- [17]
			"95688:100559", -- [18]
			"100550:114666:111624:112866:108888", -- [19]
			"97860:111314", -- [20]
			"100550:114666:111675:111323", -- [21]
			"95688:100559:111327", -- [22]
			"100550:114666:111675", -- [23]
			"100550:114666:111624", -- [24]
			"100550:114666:111624:112866:108888:111418", -- [25]
			"100550:114666:90639:110971", -- [26]
			"95688:100559:98114:98113:111420", -- [27]
			"100550:114666:111624:112866:112926", -- [28]
			"100550:96565:114718", -- [29]
			"100550:114666", -- [30]
			"100550:100468:100459:93940:114837", -- [31]
			"97870:107457", -- [32]
			"100550:114666:111675:111323:120272", -- [1]

			"100550:114666:111675:111323:120118", -- [2]			
			["m"] = 1024,
			["f"] = 0,
			["direct"] = "95688:97860:97868:97870:100550:98968",
			["coord"] = 1727301337,
		},
		[120118] = {
			"120272:96813:111624:90556", -- [1]
			"120272:96813:111624:90639", -- [2]
			"120272:96813:112866:88110", -- [3]
			"120272:96813:112866", -- [4]
			"111323:111675:114666:93447", -- [5]
			"111323:111675:114666:100459:93940", -- [6]
			"111323:111420:98113:98114:100559:95688", -- [7]
			"111323:111420:98161", -- [8]
			"111323:111420:98108", -- [9]
			"111323:111420:98113", -- [10]
			"111323:111420:98113:98114", -- [11]
			"111323:111420:98113:98114:100559:97860", -- [12]
			"111323:111675:114666:100550:94973:97868", -- [13]
			"111323:111675:114666:100550:97870", -- [14]
			"111323:111675:114666:100550:94973:97868:98066", -- [15]
			"111323:111675:96565", -- [16]
			"111323:111675:98966", -- [17]
			"111323:111420:98161:111327:98972", -- [18]
			"111323:111675:114666:100468", -- [19]
			"111323:111675:114666:100459", -- [20]
			"111323:111675:114666:100550:94973", -- [21]
			"120272:96813", -- [22]
			"111323:111675:114666:100550", -- [23]
			"111323:111420:98113:98114:100559", -- [24]
			"120272:96813:112866:108888", -- [25]
			"111323:111420:98108:111314", -- [26]
			"111323:111420:98161:111327", -- [27]
			"111323:111675", -- [28]
			"120272:96813:111624", -- [29]
			"120272:96813:111418", -- [30]
			"120272:96813:112866:88110:110971", -- [31]
			"111323:111420", -- [32]
			"111323:112926", -- [33]
			"111323:114718", -- [34]
			"111323:111675:114666", -- [35]
			"120272:96813:111624:90639:114837", -- [36]
			["m"] = 1021,
			["f"] = 0,
			["direct"] = "111323:120272",
			["coord"] = 3037362638,
		},		
		[88110] = {
			"90556:90639", -- [1]
			"90556:93447", -- [2]
			"90556:93447:93940", -- [3]
			"90556:114666:100550:95688", -- [4]
			"90556:111675:114718:98113:98161", -- [5]
			"90556:111675:114718:111420:98108", -- [6]
			"90556:111675:114718:98113", -- [7]
			"90556:111675:114718:98113:98114", -- [8]
			"90556:114666:100550:94973:97860", -- [9]
			"90556:114666:100550:98968:97868", -- [10]
			"90556:114666:100550:97870", -- [11]
			"90556:114666:100550:98968:97868:98066", -- [12]
			"90556:114666:96565", -- [13]
			"90556:111675:98966", -- [14]
			"90556:114666:100550:98968", -- [15]
			"90556:114666:100550:94973:97860:98972", -- [16]
			"90556:93447:100459:100468", -- [17]
			"90556:93447:100459", -- [18]
			"90556:114666:100550:94973", -- [19]
			"112866:96813", -- [20]
			"90556:114666:100550", -- [21]
			"90556:111675:98966:100559", -- [22]
			"90556:111675:114718:98113:98161:111314", -- [23]
			"112866:96813:111323", -- [24]
			"90556:111675:98966:111327", -- [25]
			"90556:111675", -- [26]
			"90556:111624", -- [27]
			"108888:111418", -- [28]
			"90556:111675:114718:111420", -- [29]
			"108888:111418:112926", -- [30]
			"90556:111675:114718", -- [31]
			"90556:114666", -- [32]
			"90556:90639:114837", -- [33]
			"90556:93447:100459:107457", -- [34]
			"90556:114666:100550:98968:97868", -- [10]
			"90556:114666:100550:98968:97868:98066", -- [12]
			"90556:114666:100550:98968", -- [15]
			"112866:96813:120272", -- [10]
			"112866:96813:111323:120118", -- [11]			
			["direct"] = "90556:112866:108888:110971",
			["coord"] = 1914794008,
			["m"] = 1015,
			["f"] = 0,
		},
		[98966] = {
			"96565:114666:90556", -- [1]
			"96565:114666:90639", -- [2]
			"96565:114666:90556:88110", -- [3]
			"111675:111624:112866", -- [4]
			"96565:114666:93447", -- [5]
			"96565:114666:100459:93940", -- [6]
			"98114:98161", -- [7]
			"98114:98161:98108", -- [8]
			"95688:94973:97868", -- [9]
			"95688:94973:97870", -- [10]
			"95688:94973:97868:98066", -- [11]
			"95688:94973:98968", -- [12]
			"97860:98972", -- [13]
			"96565:100468", -- [14]
			"96565:114666:100459", -- [15]
			"95688:94973", -- [16]
			"111675:96813", -- [17]
			"95688:100550", -- [18]
			"111675:111624:112866:108888", -- [19]
			"111327:111314", -- [20]
			"114718:111323", -- [21]
			"111675:111624", -- [22]
			"111675:111624:112866:108888:111418", -- [23]
			"96565:114666:90639:110971", -- [24]
			"98113:111420", -- [25]
			"111675:96813:112926", -- [26]
			"96565:114666", -- [27]
			"96565:114666:100459:93940:114837", -- [28]
			"95688:94973:98968", -- [7]
			"96565:114666:100459:107457", -- [9]
			"114718:111323:120272", -- [1]
			"114718:111323:120118", -- [2]			
			["m"] = 1024,
			["f"] = 0,
			["direct"] = "95688:98113:98114:97860:96565:100559:111327:111675:114718",
			["coord"] = 2440877756,
		},
		[120272] = {
			"96813:111624:90556", -- [1]
			"96813:111624:90639", -- [2]
			"96813:112866:88110", -- [3]
			"96813:112866", -- [4]
			"96813:111624:93447", -- [5]
			"96813:111624:93447:93940", -- [6]
			"111323:111420:98113:98114:100559:95688", -- [7]
			"111323:111420:98161", -- [8]
			"111323:111420:98108", -- [9]
			"111323:111420:98113", -- [10]
			"111323:111420:98113:98114", -- [11]
			"111323:111420:98113:98114:100559:97860", -- [12]
			"111323:111675:114666:100550:94973:97868", -- [13]
			"111323:111675:114666:100550:97870", -- [14]
			"111323:111675:114666:100550:94973:97868:98066", -- [15]
			"111323:111675:96565", -- [16]
			"111323:111675:98966", -- [17]
			"111323:111420:98161:111327:98972", -- [18]
			"111323:111675:114666:100468", -- [19]
			"96813:111624:93447:100459", -- [20]
			"111323:111675:114666:100550:94973", -- [21]
			"111323:111675:114666:100550", -- [22]
			"111323:111420:98113:98114:100559", -- [23]
			"96813:112866:108888", -- [24]
			"111323:111420:98108:111314", -- [25]
			"111323:111420:98161:111327", -- [26]
			"111323:111675", -- [27]
			"96813:111624", -- [28]
			"96813:111418", -- [29]
			"96813:112866:88110:110971", -- [30]
			"111323:111420", -- [31]
			"96813:112926", -- [32]
			"111323:114718", -- [33]
			"111323:111675:114666", -- [34]
			"96813:111624:90639:114837", -- [35]
			["m"] = 1021,
			["f"] = 0,
			["direct"] = "96813:111323:120118",
			["coord"] = 1940890644,
		},		
		[98108] = {
			"98161:98113:114718:111675:90556", -- [1]
			"98161:98113:114718:111675:90639", -- [2]
			"98161:98113:114718:111675:90556:88110", -- [3]
			"111420:96813:112866", -- [4]
			"98161:98113:114718:111675:114666:93447", -- [5]
			"98161:98114:100559:95688:100550:100468:100459:93940", -- [6]
			"98161:98114:100559:95688", -- [7]
			"98161:98113", -- [8]
			"98161:98114", -- [9]
			"98161:98114:100559:97860", -- [10]
			"98161:98114:100559:95688:94973:97868", -- [11]
			"98161:98114:100559:95688:94973:97870", -- [12]
			"98161:111327:98972:98066", -- [13]
			"98161:98114:98966:96565", -- [14]
			"98161:98114:98966", -- [15]
			"98161:98114:100559:95688:94973:98968", -- [16]
			"98161:111327:98972", -- [17]
			"98161:98114:100559:95688:100550:100468", -- [18]
			"98161:98114:100559:95688:100550:100468:100459", -- [19]
			"98161:98114:100559:95688:94973", -- [20]
			"111420:96813", -- [21]
			"98161:98114:100559:95688:100550", -- [22]
			"98161:98114:100559", -- [23]
			"111420:96813:112866:108888", -- [24]
			"111420:111323", -- [25]
			"98161:111327", -- [26]
			"98161:98113:114718:111675", -- [27]
			"98161:98113:114718:111675:111624", -- [28]
			"111420:96813:111418", -- [29]
			"98161:98113:114718:111675:90556:88110:110971", -- [30]
			"111420:111323:112926", -- [31]
			"98161:98113:114718", -- [32]
			"98161:98113:114718:111675:114666", -- [33]
			"98161:98114:100559:95688:100550:100468:100459:93940:114837", -- [34]
			"111420:93465", -- [35]
			"98161:98114:100559:95688:94973:97870:107457", -- [36]
			"111420:111323:120272", -- [1]
			"111420:111323:120118", -- [2]			
			["direct"] = "98161:111314:111420",
			["f"] = 0,
			["m"] = 1017,
			["coord"] = 3098253628,
		},
		[97860] = {
			"95688:100550:114666:90556", -- [1]
			"95688:100550:114666:90639", -- [2]
			"95688:100550:114666:90556:88110", -- [3]
			"95688:100550:114666:111624:112866", -- [4]
			"95688:100550:100468:100459:93447", -- [5]
			"95688:100550:100468:100459:93940", -- [6]
			"100559:98114:98161", -- [7]
			"100559:98114:98161:98108", -- [8]
			"100559:98114:98113", -- [9]
			"100559:98114", -- [10]
			"98968:97870", -- [11]
			"95688:96565", -- [12]
			"95688:100550:100468", -- [13]
			"95688:100550:100468:100459", -- [14]
			"100559:98114:98113:114718:96813", -- [15]
			"95688:100550", -- [16]
			"95688:100550:114666:111624:112866:108888", -- [17]
			"100559:98114:98113:114718:111323", -- [18]
			"100559:111327", -- [19]
			"95688:96565:111675", -- [20]
			"95688:100550:114666:111624", -- [21]
			"95688:100550:114666:111624:112866:108888:111418", -- [22]
			"95688:100550:114666:90639:110971", -- [23]
			"100559:98114:98113:111420", -- [24]
			"100559:98114:98113:114718:96813:112926", -- [25]
			"100559:98114:98113:114718", -- [26]
			"95688:100550:114666", -- [27]
			"95688:100550:100468:100459:93940:114837", -- [28]
			"100559:98114:98113:114718:93465", -- [29]
			"94973:97870:107457", -- [30]
			"100559:98114:98113:114718:111323:120272", -- [2]
			"100559:98114:98113:114718:111323:120118", -- [3]			
			["m"] = 1024,
			["f"] = 0,
			["direct"] = "95688:97868:98066:98966:98972:94973:100559:111314:98968",
			["coord"] = 2258400227,
		},
		[90556] = {
			"93447:93940", -- [1]
			"114666:100550:95688", -- [2]
			"111675:114718:98113:98161", -- [3]
			"111675:114718:111420:98108", -- [4]
			"111675:114718:98113", -- [5]
			"111675:114718:98113:98114", -- [6]
			"114666:100550:94973:97860", -- [7]
			"114666:100550:98968:97868", -- [8]
			"114666:100550:97870", -- [9]
			"114666:100550:98968:97868:98066", -- [10]
			"114666:96565", -- [11]
			"111675:98966", -- [12]
			"114666:100550:98968", -- [13]
			"114666:100550:94973:97860:98972", -- [14]
			"93447:100459:100468", -- [15]
			"93447:100459", -- [16]
			"114666:100550:94973", -- [17]
			"111624:96813", -- [18]
			"114666:100550", -- [19]
			"111675:98966:100559", -- [20]
			"88110:108888", -- [21]
			"111675:114718:98113:98161:111314", -- [22]
			"111624:96813:111323", -- [23]
			"111675:98966:111327", -- [24]
			"88110:108888:111418", -- [25]
			"88110:110971", -- [26]
			"111675:114718:111420", -- [27]
			"112866:112926", -- [28]
			"111675:114718", -- [29]
			"90639:114837", -- [30]
			"111624:96813:111323:93465", -- [31]
			"93447:100459:107457", -- [32]
			"111624:96813:120272", -- [10]
			"111624:96813:111323:120118", -- [11]			
			["m"] = 1015,
			["coord"] = 2079410094,
			["direct"] = "90639:88110:112866:93447:111675:111624:114666",
			["f"] = 0,
		},
		[97868] = {
			"98968:100550:114666:90556", -- [1]
			"98968:100550:114666:90639", -- [2]
			"98968:100550:114666:90556:88110", -- [3]
			"98968:100550:114666:111624:112866", -- [4]
			"98968:100550:100468:100459:93447", -- [5]
			"98968:100550:100468:100459:93940", -- [6]
			"95688:100559:98114:98161", -- [7]
			"95688:100559:98114:98161:98108", -- [8]
			"95688:100559:98114:98113", -- [9]
			"95688:100559:98114", -- [10]
			"95688:96565", -- [11]
			"95688:98966", -- [12]
			"98968:100550:100468", -- [13]
			"98968:100550:100468:100459", -- [14]
			"98968:100550:114666:111675:96813", -- [15]
			"98968:100550", -- [16]
			"95688:100559", -- [17]
			"98968:100550:114666:111624:112866:108888", -- [18]
			"98972:111314", -- [19]
			"98968:100550:114666:111675:111323", -- [20]
			"95688:100559:111327", -- [21]
			"98968:100550:114666:111675", -- [22]
			"98968:100550:114666:111624", -- [23]
			"98968:100550:114666:111624:112866:108888:111418", -- [24]
			"98968:100550:114666:90639:110971", -- [25]
			"95688:100559:98114:98113:111420", -- [26]
			"98968:100550:114666:111624:112866:112926", -- [27]
			"95688:100559:98114:98113:114718", -- [28]
			"98968:100550:114666", -- [29]
			"98968:100550:100468:100459:93940:114837", -- [30]
			"95688:100559:98114:98113:114718:93465", -- [31]			
			"97870:107457", -- [32]
			"95688:100559:98114:98113:114718:111323", -- [12]		
			"95688:100559:98114:98113:114718:111323:120272", -- [20]
			"95688:100559:98114:98113:114718:111323:120118", -- [21]
			["m"] = 1024,
			["f"] = 0,
			["direct"] = "95688:97860:97870:98066:98972:94973:98968",
			["coord"] = 1647666311,
		},
		[112866] = {
			"90556:90639", -- [1]
			"111624:93447", -- [2]
			"111624:93447:93940", -- [3]
			"111624:114666:100550:95688", -- [4]
			"111624:111675:114718:98113:98161", -- [5]
			"111624:111675:114718:111420:98108", -- [6]
			"111624:111675:114718:98113", -- [7]
			"111624:111675:114718:98113:98114", -- [8]
			"111624:114666:100550:94973:97860", -- [9]
			"111624:114666:100550:98968:97868", -- [10]
			"111624:114666:100550:97870", -- [11]
			"111624:114666:100550:98968:97868:98066", -- [12]
			"111624:114666:96565", -- [13]
			"111624:111675:98966", -- [14]
			"111624:114666:100550:98968", -- [15]
			"111624:114666:100550:94973:97860:98972", -- [16]
			"111624:114666:100468", -- [17]
			"111624:93447:100459", -- [18]
			"111624:114666:100550:94973", -- [19]
			"111624:114666:100550", -- [20]
			"111624:111675:98966:100559", -- [21]
			"111624:111675:114718:98113:98161:111314", -- [22]
			"96813:111323", -- [23]
			"111624:111675:98966:111327", -- [24]
			"111624:111675", -- [25]
			"108888:111418", -- [26]
			"88110:110971", -- [27]
			"111624:111675:114718:111420", -- [28]
			"111624:111675:114718", -- [29]
			"111624:114666", -- [30]
			"90556:90639:114837", -- [31]
			"111624:93447:100459:107457", -- [32]
			"111624:114666:100550:98968:97868", -- [1]
			"111624:114666:100550:98968:97868:98066", -- [2]
			"111624:114666:100550:98968", -- [3]		
			"96813:120272", -- [10]
			"96813:111323:120118", -- [11]			
			["m"] = 1015,
			["coord"] = 2414122732,
			["direct"] = "90556:88110:96813:108888:111624:112926",
			["f"] = 0,
		},
		[100459] = {
			"93447:90556", -- [1]
			"93447:90639", -- [2]
			"93447:90556:88110", -- [3]
			"93447:90556:112866", -- [4]
			"100468:100550:95688", -- [5]
			"100468:100550:95688:100559:98114:98161", -- [6]
			"100468:100550:95688:100559:98114:98161:98108", -- [7]
			"100468:100550:95688:100559:98114:98113", -- [8]
			"100468:100550:95688:100559:98114", -- [9]
			"100468:100550:94973:97860", -- [10]
			"100468:100550:98968:97868", -- [11]
			"100468:100550:97870", -- [12]
			"100468:100550:98968:97868:98066", -- [13]
			"100468:96565", -- [14]
			"100468:96565:98966", -- [15]
			"100468:100550:98968", -- [16]
			"100468:100550:94973:97860:98972", -- [17]
			"100468:100550:94973", -- [18]
			"114666:111675:96813", -- [19]
			"100468:100550", -- [20]
			"100468:100550:95688:100559", -- [21]
			"93447:90556:88110:108888", -- [22]
			"100468:100550:95688:100559:111327:111314", -- [23]
			"114666:111675:111323", -- [24]
			"100468:100550:95688:100559:111327", -- [25]
			"114666:111675", -- [26]
			"93447:111624", -- [27]
			"93447:90556:88110:108888:111418", -- [28]
			"93447:90639:110971", -- [29]
			"114666:111675:114718:111420", -- [30]
			"93447:90556:112866:112926", -- [31]
			"114666:111675:114718", -- [32]
			"93940:114837", -- [33]
			"114666:111675:111323:120272", -- [5]
			"114666:111675:111323:120118", -- [6]			
			["direct"] = "93447:93940:100468:114666:107457",
			["coord"] = 2436142042,
			["m"] = 1018,
			["f"] = 0,
		},
		[90639] = {
			"90556:88110", -- [1]
			"90556:112866", -- [2]
			"93447:100459:100468:100550:95688", -- [3]
			"111675:114718:98113:98161", -- [4]
			"111675:114718:111420:98108", -- [5]
			"111675:114718:98113", -- [6]
			"111675:114718:98113:98114", -- [7]
			"93447:100459:100468:100550:94973:97860", -- [8]
			"93447:100459:100468:100550:98968:97868", -- [9]
			"93447:100459:100468:100550:97870", -- [10]
			"93447:100459:100468:100550:98968:97868:98066", -- [11]
			"114666:96565", -- [12]
			"114666:96565:98966", -- [13]
			"93447:100459:100468:100550:98968", -- [14]
			"93447:100459:100468:100550:94973:97860:98972", -- [15]
			"93447:100459:100468", -- [16]
			"93447:100459", -- [17]
			"93447:100459:100468:100550:94973", -- [18]
			"111624:96813", -- [19]
			"93447:100459:100468:100550", -- [20]
			"93447:100459:100468:100550:95688:100559", -- [21]
			"110971:108888", -- [22]
			"111675:114718:98113:98161:111314", -- [23]
			"111675:111323", -- [24]
			"114666:96565:98966:111327", -- [25]
			"110971:108888:111418", -- [26]
			"111675:114718:111420", -- [27]
			"90556:112866:112926", -- [28]
			"111675:114718", -- [29]
			"93940:107457", -- [30]
			"111624:96813:120272", -- [10]
			"111675:111323:120118", -- [11]			
			["m"] = 1015,
			["coord"] = 1752831794,
			["direct"] = "90556:93447:93940:111675:111624:110971:114666:114837",
			["f"] = 0,
		},
		[96565] = {
			"114666:90556", -- [1]
			"114666:90639", -- [2]
			"114666:90556:88110", -- [3]
			"114666:111624:112866", -- [4]
			"114666:93447", -- [5]
			"114666:100459:93940", -- [6]
			"98966:98114:98161", -- [7]
			"114718:111420:98108", -- [8]
			"98966:98113", -- [9]
			"98966:98114", -- [10]
			"95688:97860", -- [11]
			"100550:98968:97868", -- [12]
			"100550:97870", -- [13]
			"100550:98968:97868:98066", -- [14]
			"100550:98968", -- [15]
			"95688:97860:98972", -- [16]
			"114666:100459", -- [17]
			"100550:94973", -- [18]
			"111675:96813", -- [19]
			"98966:100559", -- [20]
			"114666:111624:112866:108888", -- [21]
			"98966:111327:111314", -- [22]
			"111675:111323", -- [23]
			"98966:111327", -- [24]
			"114666:111624", -- [25]
			"114666:111624:112866:108888:111418", -- [26]
			"114666:90639:110971", -- [27]
			"114718:111420", -- [28]
			"111675:96813:112926", -- [29]
			"114666:100459:93940:114837", -- [30]
			"114666:100459:107457", -- [31]
			"111675:111323:120272", -- [3]
			"111675:111323:120118", -- [4]			
			["m"] = 1024,
			["f"] = 0,
			["direct"] = "95688:98966:100468:100550:111675:114718:114666",
			["coord"] = 2029967545,
		},
		[111323] = {
			"111675:114666:100550:94973:97868", -- [1]
			"111675:114666:100550:94973:97868:98066", -- [2]
			["direct"] = "96813:111675:111420:112926:114718:120272:120118",
			["coord"] = 2136880574,
			["m"] = 1021,
			["f"] = 0,
		},		
		[100550] = {
			"114666:90556", -- [1]
			"114666:90639", -- [2]
			"114666:90556:88110", -- [3]
			"114666:111624:112866", -- [4]
			"100468:100459:93447", -- [5]
			"100468:100459:93940", -- [6]
			"95688:100559:98114:98161", -- [7]
			"95688:100559:98114:98161:98108", -- [8]
			"95688:100559:98114:98113", -- [9]
			"95688:100559:98114", -- [10]
			"94973:97860", -- [11]
			"98968:97868", -- [12]
			"98968:97868:98066", -- [13]
			"96565:98966", -- [14]
			"94973:97860:98972", -- [15]
			"100468:100459", -- [16]
			"114666:111675:96813", -- [17]
			"95688:100559", -- [18]
			"114666:111624:112866:108888", -- [19]
			"95688:100559:111327:111314", -- [20]
			"114666:111675:111323", -- [21]
			"95688:100559:111327", -- [22]
			"114666:111675", -- [23]
			"114666:111624", -- [24]
			"114666:111624:112866:108888:111418", -- [25]
			"114666:90639:110971", -- [26]
			"96565:114718:111420", -- [27]
			"114666:111624:112866:112926", -- [28]
			"96565:114718", -- [29]
			"100468:100459:93940:114837", -- [30]
			"100468:100459:107457", -- [31]
			["m"] = 1024,
			["f"] = 0,
			["direct"] = "95688:97870:96565:100468:94973:114666",
			["coord"] = 1542957263,
		},
		[114666] = {
			"90556:88110", -- [1]
			"111624:112866", -- [2]
			"100459:93940", -- [3]
			"100550:95688", -- [4]
			"111675:114718:98113:98161", -- [5]
			"111675:114718:111420:98108", -- [6]
			"111675:114718:98113", -- [7]
			"96565:98966:98114", -- [8]
			"100550:94973:97860", -- [9]
			"100550:98968:97868", -- [10]
			"100550:97870", -- [11]
			"100550:98968:97868:98066", -- [12]
			"96565:98966", -- [13]
			"100550:98968", -- [14]
			"100550:94973:97860:98972", -- [15]
			"100550:94973", -- [16]
			"111675:96813", -- [17]
			"96565:98966:100559", -- [18]
			"111624:112866:108888", -- [19]
			"96565:98966:111327:111314", -- [20]
			"111675:111323", -- [21]
			"96565:98966:111327", -- [22]
			"111624:112866:108888:111418", -- [23]
			"90639:110971", -- [24]
			"111675:114718:111420", -- [25]
			"111624:112866:112926", -- [26]
			"111675:114718", -- [27]
			"100459:93940:114837", -- [28]
			"100459:107457", -- [29]
			["m"] = 1033,
			["coord"] = 1095979364,
			["direct"] = "90556:90639:93447:96565:100468:100459:100550:111675:111624",
			["f"] = 0,
		},
		[93447] = {
			"90556:88110", -- [1]
			"90556:112866", -- [2]
			"100459:100468:100550:95688", -- [3]
			"114666:111675:114718:98113:98161", -- [4]
			"114666:111675:114718:111420:98108", -- [5]
			"114666:111675:114718:98113", -- [6]
			"100459:100468:100550:95688:100559:98114", -- [7]
			"100459:100468:100550:94973:97860", -- [8]
			"100459:100468:100550:98968:97868", -- [9]
			"100459:100468:100550:97870", -- [10]
			"100459:100468:100550:98968:97868:98066", -- [11]
			"114666:96565", -- [12]
			"114666:96565:98966", -- [13]
			"100459:100468:100550:98968", -- [14]
			"100459:100468:100550:94973:97860:98972", -- [15]
			"100459:100468", -- [16]
			"100459:100468:100550:94973", -- [17]
			"111624:96813", -- [18]
			"100459:100468:100550", -- [19]
			"100459:100468:100550:95688:100559", -- [20]
			"90556:88110:108888", -- [21]
			"100459:100468:100550:95688:100559:111327:111314", -- [22]
			"114666:111675:111323", -- [23]
			"100459:100468:100550:95688:100559:111327", -- [24]
			"114666:111675", -- [25]
			"90556:88110:108888:111418", -- [26]
			"90639:110971", -- [27]
			"114666:111675:114718:111420", -- [28]
			"90556:112866:112926", -- [29]
			"114666:111675:114718", -- [30]
			"93940:114837", -- [31]
			"114666:111675:114718:93465", -- [32]
			"100459:107457", -- [33]
			["m"] = 1018,
			["coord"] = 2361768346,
			["direct"] = "90556:90639:93940:100459:111624:114666",
			["f"] = 0,
		},
		[98113] = {
			"114718:111675:90556", -- [1]
			"114718:111675:90639", -- [2]
			"114718:111675:90556:88110", -- [3]
			"114718:111675:111624:112866", -- [4]
			"114718:111675:114666:93447", -- [5]
			"114718:111675:114666:100459:93940", -- [6]
			"98114:100559:95688", -- [7]
			"98161:98108", -- [8]
			"98114:100559:97860", -- [9]
			"98114:100559:95688:94973:97868", -- [10]
			"98114:100559:95688:94973:97870", -- [11]
			"98114:100559:97860:98066", -- [12]
			"98966:96565", -- [13]
			"98114:100559:95688:94973:98968", -- [14]
			"98114:100559:97860:98972", -- [15]
			"98114:100559:95688:100550:100468", -- [16]
			"114718:111675:114666:100459", -- [17]
			"98114:100559:95688:94973", -- [18]
			"114718:96813", -- [19]
			"98114:100559:95688:100550", -- [20]
			"98114:100559", -- [21]
			"114718:111675:111624:112866:108888", -- [22]
			"98161:111314", -- [23]
			"114718:111323", -- [24]
			"114718:111675", -- [25]
			"114718:111675:111624", -- [26]
			"114718:96813:111418", -- [27]
			"114718:111675:90556:88110:110971", -- [28]
			"114718:96813:112926", -- [29]
			"114718:111675:114666", -- [30]
			"114718:111675:90639:114837", -- [31]
			"114718:93465", -- [32]
			"114718:111675:114666:100459:107457", -- [33]
			"114718:111323:120272", -- [1]
			"114718:111323:120118", -- [2]			
			["m"] = 1017,
			["f"] = 0,
			["direct"] = "98161:98114:98966:111327:111420:114718",
			["coord"] = 1607115709,
		},
		[112926] = {
			"112866:90556", -- [1]
			"112866:90556:90639", -- [2]
			"112866:88110", -- [3]
			"112866:111624:93447", -- [4]
			"112866:111624:93447:93940", -- [5]
			"112866:111624:114666:100550:95688", -- [6]
			"111323:111420:98161", -- [7]
			"111323:111420:98108", -- [8]
			"96813:114718:98113", -- [9]
			"96813:114718:98113:98114", -- [10]
			"96813:114718:98113:98114:100559:97860", -- [11]
			"112866:111624:114666:100550:98968:97868", -- [12]
			"112866:111624:114666:100550:97870", -- [13]
			"112866:111624:114666:100550:98968:97868:98066", -- [14]
			"96813:111675:96565", -- [15]
			"96813:111675:98966", -- [16]
			"112866:111624:114666:100550:98968", -- [17]
			"96813:114718:98113:98114:100559:97860:98972", -- [18]
			"112866:111624:114666:100468", -- [19]
			"112866:111624:93447:100459", -- [20]
			"112866:111624:114666:100550:94973", -- [21]
			"112866:111624:114666:100550", -- [22]
			"96813:114718:98113:98114:100559", -- [23]
			"111418:108888", -- [24]
			"111323:111420:98108:111314", -- [25]
			"111323:111420:98161:111327", -- [26]
			"96813:111675", -- [27]
			"112866:111624", -- [28]
			"111418:108888:110971", -- [29]
			"111323:111420", -- [30]
			"96813:114718", -- [31]
			"112866:111624:114666", -- [32]
			"112866:90556:90639:114837", -- [33]
			"111323:93465", -- [34]
			"112866:111624:93447:100459:107457", -- [35]
			"96813:120272", -- [9]
			"111323:120118", -- [10]			
			["direct"] = "112866:96813:111323:111418",
			["coord"] = 1644262929,
			["m"] = 1096,
			["f"] = 0,
		},
		[111418] = {
			"108888:88110:90556", -- [1]
			"108888:110971:90639", -- [2]
			"108888:88110", -- [3]
			"108888:112866", -- [4]
			"108888:88110:90556:93447", -- [5]
			"108888:88110:90556:93447:93940", -- [6]
			"108888:112866:111624:114666:100550:95688", -- [7]
			"96813:111420:98161", -- [8]
			"96813:111420:98108", -- [9]
			"108888:112866:111624:111675:114718:98113", -- [10]
			"108888:112866:111624:111675:114718:98113:98114", -- [11]
			"108888:112866:111624:114666:100550:94973:97860", -- [12]
			"108888:112866:111624:114666:100550:98968:97868", -- [13]
			"108888:112866:111624:114666:100550:97870", -- [14]
			"108888:112866:111624:114666:100550:98968:97868:98066", -- [15]
			"108888:112866:111624:114666:96565", -- [16]
			"108888:112866:111624:111675:98966", -- [17]
			"108888:112866:111624:114666:100550:98968", -- [18]
			"108888:112866:111624:114666:100550:94973:97860:98972", -- [19]
			"108888:112866:111624:114666:100468", -- [20]
			"108888:88110:90556:93447:100459", -- [21]
			"108888:112866:111624:114666:100550:94973", -- [22]
			"108888:112866:111624:114666:100550", -- [23]
			"108888:112866:111624:111675:98966:100559", -- [24]
			"96813:111420:98108:111314", -- [25]
			"96813:111323", -- [26]
			"108888:112866:111624:111675:98966:111327", -- [27]
			"108888:112866:111624:111675", -- [28]
			"108888:112866:111624", -- [29]
			"108888:110971", -- [30]
			"96813:111420", -- [31]
			"108888:112866:111624:111675:114718", -- [32]
			"108888:112866:111624:114666", -- [33]
			"108888:110971:90639:114837", -- [34]
			"96813:111323:93465", -- [35]
			"108888:88110:90556:93447:100459:107457", -- [36]
			"96813:120272", -- [6]
			"96813:111323:120118", -- [7]			
			["direct"] = "96813:108888:112926",
			["coord"] = 2223886929,
			["m"] = 1015,
			["f"] = 0,
		},
		[98066] = {
			"97870:100550:114666:90556", -- [1]
			"97870:100550:114666:90639", -- [2]
			"97870:100550:114666:90556:88110", -- [3]
			"97870:100550:114666:111624:112866", -- [4]
			"97870:100550:100468:100459:93447", -- [5]
			"97870:100550:100468:100459:93940", -- [6]
			"97868:95688", -- [7]
			"98972:111327:98161", -- [8]
			"98972:111327:98161:98108", -- [9]
			"97860:100559:98114:98113", -- [10]
			"97860:100559:98114", -- [11]
			"97870:100550:96565", -- [12]
			"97860:100559:98966", -- [13]
			"97868:98968", -- [14]
			"97870:100550:100468", -- [15]
			"97870:100550:100468:100459", -- [16]
			"97868:94973", -- [17]
			"97870:100550:114666:111675:96813", -- [18]
			"97870:100550", -- [19]
			"97860:100559", -- [20]
			"97870:100550:114666:111624:112866:108888", -- [21]
			"98972:111314", -- [22]
			"97860:100559:98114:98113:114718:111323", -- [23]
			"98972:111327", -- [24]
			"97870:100550:114666:111675", -- [25]
			"97870:100550:114666:111624", -- [26]
			"97870:100550:114666:111624:112866:108888:111418", -- [27]
			"97870:100550:114666:90639:110971", -- [28]
			"98972:111327:98161:111420", -- [29]
			"97870:100550:114666:111624:112866:112926", -- [30]
			"97860:100559:98114:98113:114718", -- [31]
			"97870:100550:114666", -- [32]
			"97870:100550:100468:100459:93940:114837", -- [33]
			"97860:100559:98114:98113:114718:93465", -- [34]
			"97870:107457:93940", -- [35]
			"97870:107457", -- [36]
			"97860:100559:98114:98113:114718:111323:120272", -- [1]
			"97860:100559:98114:98113:114718:111323:120118", -- [2]			
			["direct"] = "97860:97868:97870:98972",
			["f"] = 0,
			["m"] = 1024,
			["coord"] = 1799232164,
		},
		[100468] = {
			"100459:93447:90556", -- [1]
			"100459:93447:90639", -- [2]
			"100459:93447:90556:88110", -- [3]
			"114666:111624:112866", -- [4]
			"100459:93447", -- [5]
			"100459:93940", -- [6]
			"100550:95688", -- [7]
			"100550:95688:100559:98114:98161", -- [8]
			"100550:95688:100559:98114:98161:98108", -- [9]
			"100550:95688:100559:98114:98113", -- [10]
			"100550:95688:100559:98114", -- [11]
			"100550:94973:97860", -- [12]
			"100550:98968:97868", -- [13]
			"100550:97870", -- [14]
			"100550:98968:97868:98066", -- [15]
			"96565:98966", -- [16]
			"100550:98968", -- [17]
			"100550:94973:97860:98972", -- [18]
			"100550:94973", -- [19]
			"114666:111675:96813", -- [20]
			"100550:95688:100559", -- [21]
			"114666:111624:112866:108888", -- [22]
			"100550:95688:100559:111327:111314", -- [23]
			"114666:111675:111323", -- [24]
			"100550:95688:100559:111327", -- [25]
			"114666:111675", -- [26]
			"114666:111624", -- [27]
			"114666:111624:112866:108888:111418", -- [28]
			"100459:93447:90639:110971", -- [29]
			"96565:114718:111420", -- [30]
			"114666:111624:112866:112926", -- [31]
			"96565:114718", -- [32]
			"100459:93940:114837", -- [33]
			"96565:114718:93465", -- [34]
			"100459:107457", -- [35]
			"114666:111675:111323:120272", -- [5]
			"114666:111675:111323:120118", -- [6]			
			["direct"] = "96565:100459:100550:114666",
			["coord"] = 2965013023,
			["m"] = 1018,
			["f"] = 0,
		},
		[95688] = {
			"100550:114666:90556", -- [1]
			"100550:114666:90639", -- [2]
			"100550:114666:90556:88110", -- [3]
			"100550:114666:111624:112866", -- [4]
			"100550:100468:100459:93447", -- [5]
			"100550:100468:100459:93940", -- [6]
			"100559:98114:98161", -- [7]
			"100559:98114:98161:98108", -- [8]
			"100559:98114:98113", -- [9]
			"100559:98114", -- [10]
			"94973:97868:98066", -- [11]
			"97860:98972", -- [12]
			"100550:100468", -- [13]
			"100550:100468:100459", -- [14]
			"96565:111675:96813", -- [15]
			"100550:114666:111624:112866:108888", -- [16]
			"100559:111327:111314", -- [17]
			"100559:98114:98113:114718:111323", -- [18]
			"100559:111327", -- [19]
			"96565:111675", -- [20]
			"100550:114666:111624", -- [21]
			"100550:114666:111624:112866:108888:111418", -- [22]
			"100550:114666:90639:110971", -- [23]
			"100559:98114:98113:111420", -- [24]
			"96565:111675:96813:112926", -- [25]
			"100559:98114:98113:114718", -- [26]
			"100550:114666", -- [27]
			"100550:100468:100459:93940:114837", -- [28]
			"94973:97870:107457", -- [29]
			"100559:98114:98113:114718:111323:120272", -- [1]
			"100559:98114:98113:114718:111323:120118", -- [2]			
			["m"] = 1080,
			["f"] = 0,
			["direct"] = "97860:97868:97870:96565:98966:94973:100550:100559:98968",
			["coord"] = 1920688989,
		},
		[114718] = {
			"111675:90556", -- [1]
			"111675:90639", -- [2]
			"111675:90556:88110", -- [3]
			"111675:111624:112866", -- [4]
			"111675:114666:93447", -- [5]
			"111675:114666:100459:93940", -- [6]
			"98113:98114:100559:95688", -- [7]
			"98113:98161", -- [8]
			"111420:98108", -- [9]
			"98113:98114", -- [10]
			"98113:98114:100559:97860", -- [11]
			"98113:98114:100559:95688:94973:97868", -- [12]
			"96565:100550:97870", -- [13]
			"98113:98114:100559:97860:98066", -- [14]
			"96565:100550:98968", -- [15]
			"98113:98114:100559:97860:98972", -- [16]
			"96565:100468", -- [17]
			"111675:114666:100459", -- [18]
			"98113:98114:100559:95688:94973", -- [19]
			"96565:100550", -- [20]
			"98113:98114:100559", -- [21]
			"111675:111624:112866:108888", -- [22]
			"98113:98161:111314", -- [23]
			"98113:111327", -- [24]
			"111675:111624", -- [25]
			"96813:111418", -- [26]
			"111675:90556:88110:110971", -- [27]
			"96813:112926", -- [28]
			"111675:114666", -- [29]
			"111675:90639:114837", -- [30]
			"111675:114666:100459:107457", -- [1]
			"111323:120272", -- [1]
			"111323:120118", -- [2]			
			["m"] = 1033,
			["coord"] = 2758765422,
			["direct"] = "98113:96565:98966:96813:111323:111675:111420:93465",
			["f"] = 0,
		},
		[98972] = {
			"97860:95688:100550:114666:90556", -- [1]
			"97860:95688:100550:114666:90639", -- [2]
			"97860:95688:100550:114666:90556:88110", -- [3]
			"97860:95688:100550:114666:111624:112866", -- [4]
			"97860:95688:100550:100468:100459:93447", -- [5]
			"97860:95688:100550:100468:100459:93940", -- [6]
			"97860:95688", -- [7]
			"111327:98161", -- [8]
			"111327:98161:98108", -- [9]
			"111327:98113", -- [10]
			"97860:100559:98114", -- [11]
			"97868:97870", -- [12]
			"97860:95688:96565", -- [13]
			"97860:100559:98966", -- [14]
			"97868:98968", -- [15]
			"97860:95688:100550:100468", -- [16]
			"97860:95688:100550:100468:100459", -- [17]
			"97860:94973", -- [18]
			"111327:98113:114718:96813", -- [19]
			"97860:95688:100550", -- [20]
			"97860:100559", -- [21]
			"97860:95688:100550:114666:111624:112866:108888", -- [22]
			"111327:98113:114718:111323", -- [23]
			"97860:95688:96565:111675", -- [24]
			"97860:95688:100550:114666:111624", -- [25]
			"97860:95688:100550:114666:111624:112866:108888:111418", -- [26]
			"97860:95688:100550:114666:90639:110971", -- [27]
			"111327:98161:111420", -- [28]
			"111327:98113:114718:96813:112926", -- [29]
			"111327:98113:114718", -- [30]
			"97860:95688:100550:114666", -- [31]
			"97860:95688:100550:100468:100459:93940:114837", -- [32]
			"111327:98161:111420:93465", -- [33]
			"97868:97870:107457", -- [21]
			"111327:98161:111420:111323", -- [1]
			"111327:98161:111420:111323:120272", -- [2]
			"111327:98161:111420:111323:120118", -- [3]			
			["m"] = 1024,
			["f"] = 0,
			["direct"] = "97860:97868:98066:111314:111327",
			["coord"] = 2490583353,
		},
		[93940] = {
			"93447:90556", -- [1]
			"93447:90556:88110", -- [2]
			"93447:90556:112866", -- [3]
			"100459:100468:100550:95688", -- [4]
			"100459:100468:100550:95688:100559:98114:98161", -- [5]
			"100459:100468:100550:95688:100559:98114:98161:98108", -- [6]
			"100459:100468:100550:95688:100559:98114:98113", -- [7]
			"100459:100468:100550:95688:100559:98114", -- [8]
			"100459:100468:100550:94973:97860", -- [9]
			"100459:100468:100550:98968:97868", -- [10]
			"100459:100468:100550:97870", -- [11]
			"100459:100468:100550:98968:97868:98066", -- [12]
			"100459:100468:96565", -- [13]
			"100459:100468:96565:98966", -- [14]
			"100459:100468:100550:98968", -- [15]
			"100459:100468:100550:94973:97860:98972", -- [16]
			"100459:100468", -- [17]
			"100459:100468:100550:94973", -- [18]
			"93447:111624:96813", -- [19]
			"100459:100468:100550", -- [20]
			"100459:100468:100550:95688:100559", -- [21]
			"93447:90556:88110:108888", -- [22]
			"100459:100468:100550:95688:100559:111327:111314", -- [23]
			"100459:114666:111675:111323", -- [24]
			"100459:100468:100550:95688:100559:111327", -- [25]
			"100459:114666:111675", -- [26]
			"93447:111624", -- [27]
			"93447:90556:88110:108888:111418", -- [28]
			"90639:110971", -- [29]
			"100459:114666:111675:114718:111420", -- [30]
			"93447:90556:112866:112926", -- [31]
			"100459:114666:111675:114718", -- [32]
			"100459:114666", -- [33]
			"100459:114666:111675:114718:93465", -- [34]
			"107457:97870", -- [35]
			"107457:97870:98066", -- [36]
			"100459:100468:100550:98968:97868", -- [4]
			"100459:100468:100550:98968:97868:98066", -- [5]
			"100459:100468:100550:98968", -- [6]
			"93447:111624:96813:120272", -- [5]
			"100459:114666:111675:111323:120118", -- [6]			
			["direct"] = "90639:93447:100459:114837",
			["coord"] = 1813616062,
			["m"] = 1018,
			["f"] = 0,
		},
		[100559] = {
			"98966:96565:114666:90556", -- [1]
			"98966:96565:114666:90639", -- [2]
			"98966:96565:114666:90556:88110", -- [3]
			"98966:111675:111624:112866", -- [4]
			"95688:100550:100468:100459:93447", -- [5]
			"95688:100550:100468:100459:93940", -- [6]
			"98114:98161", -- [7]
			"98114:98161:98108", -- [8]
			"98114:98113", -- [9]
			"95688:94973:97868", -- [10]
			"95688:94973:97870", -- [11]
			"97860:98066", -- [12]
			"98966:96565", -- [13]
			"95688:94973:98968", -- [14]
			"97860:98972", -- [15]
			"95688:100550:100468", -- [16]
			"95688:100550:100468:100459", -- [17]
			"95688:94973", -- [18]
			"98114:98113:114718:96813", -- [19]
			"95688:100550", -- [20]
			"98966:111675:111624:112866:108888", -- [21]
			"111327:111314", -- [22]
			"98114:98113:114718:111323", -- [23]
			"98966:111675", -- [24]
			"98966:111675:111624", -- [25]
			"98966:111675:111624:112866:108888:111418", -- [26]
			"98966:96565:114666:90639:110971", -- [27]
			"98114:98113:111420", -- [28]
			"98114:98113:114718:96813:112926", -- [29]
			"98114:98113:114718", -- [30]
			"98966:96565:114666", -- [31]
			"95688:100550:100468:100459:93940:114837", -- [32]
			"98114:98113:114718:93465", -- [33]
			"95688:94973:97870:107457", -- [34]
			"98114:98113:114718:111323:120272", -- [1]
			"98114:98113:114718:111323:120118", -- [2]			
			["m"] = 1024,
			["f"] = 0,
			["direct"] = "95688:98114:97860:98966:111327",
			["coord"] = 2544674483,
		},
		[98114] = {
			"98113:114718:111675:90556", -- [1]
			"98966:96565:114666:90639", -- [2]
			"98113:114718:111675:90556:88110", -- [3]
			"98113:114718:111675:111624:112866", -- [4]
			"98966:96565:114666:93447", -- [5]
			"100559:95688:100550:100468:100459:93940", -- [6]
			"100559:95688", -- [7]
			"98161:98108", -- [8]
			"100559:97860", -- [9]
			"100559:95688:94973:97868", -- [10]
			"100559:95688:94973:97870", -- [11]
			"100559:97860:98066", -- [12]
			"98966:96565", -- [13]
			"100559:95688:94973:98968", -- [14]
			"100559:97860:98972", -- [15]
			"100559:95688:100550:100468", -- [16]
			"100559:95688:100550:100468:100459", -- [17]
			"100559:95688:94973", -- [18]
			"98113:114718:96813", -- [19]
			"100559:95688:100550", -- [20]
			"98113:114718:111675:111624:112866:108888", -- [21]
			"111327:111314", -- [22]
			"98113:114718:111323", -- [23]
			"98113:114718:111675", -- [24]
			"98113:114718:111675:111624", -- [25]
			"98113:114718:96813:111418", -- [26]
			"98113:114718:111675:90556:88110:110971", -- [27]
			"98113:111420", -- [28]
			"98113:114718:96813:112926", -- [29]
			"98113:114718", -- [30]
			"98966:96565:114666", -- [31]
			"100559:95688:100550:100468:100459:93940:114837", -- [32]
			"98113:114718:93465", -- [33]
			"100559:95688:94973:97870:107457", -- [34]
			"98113:114718:111323:120272", -- [1]
			"98113:114718:111323:120118", -- [2]			
			["m"] = 1017,
			["f"] = 0,
			["direct"] = "98161:98113:98966:100559:111327",
			["coord"] = 1443856804,
		},
		[97870] = {
			"100550:114666:90556", -- [1]
			"100550:114666:90639", -- [2]
			"100550:114666:90556:88110", -- [3]
			"100550:114666:111624:112866", -- [4]
			"100550:100468:100459:93447", -- [5]
			"100550:100468:100459:93940", -- [6]
			"94973:95688:100559:98114:98161", -- [7]
			"94973:95688:100559:98114:98161:98108", -- [8]
			"94973:95688:100559:98114:98113", -- [9]
			"94973:95688:100559:98114", -- [10]
			"97868:97860", -- [11]
			"100550:96565", -- [12]
			"94973:95688:98966", -- [13]
			"97868:98972", -- [14]
			"100550:100468", -- [15]
			"100550:100468:100459", -- [16]
			"100550:114666:111675:96813", -- [17]
			"94973:95688:100559", -- [18]
			"100550:114666:111624:112866:108888", -- [19]
			"97868:98972:111314", -- [20]
			"100550:114666:111675:111323", -- [21]
			"94973:95688:100559:111327", -- [22]
			"100550:114666:111675", -- [23]
			"100550:114666:111624", -- [24]
			"100550:114666:111624:112866:108888:111418", -- [25]
			"100550:114666:90639:110971", -- [26]
			"100550:96565:114718:111420", -- [27]
			"100550:114666:111624:112866:112926", -- [28]
			"100550:96565:114718", -- [29]
			"100550:114666", -- [30]
			"100550:100468:100459:93940:114837", -- [31]
			"107457:93940", -- [32]
			"100550:114666:111675:111323:120272", -- [1]
			"100550:114666:111675:111323:120118", -- [2]			
			["m"] = 1024,
			["f"] = 0,
			["direct"] = "95688:97868:98066:94973:100550:107457:98968",
			["coord"] = 1285317815,
		},
		[111675] = {
			"90556:88110", -- [1]
			"111624:112866", -- [2]
			"114666:93447", -- [3]
			"114666:100459:93940", -- [4]
			"114666:100550:95688", -- [5]
			"114718:98113:98161", -- [6]
			"114718:111420:98108", -- [7]
			"114718:98113", -- [8]
			"114718:98113:98114", -- [9]
			"98966:97860", -- [10]
			"114666:100550:98968:97868", -- [11]
			"114666:100550:97870", -- [12]
			"114666:100550:98968:97868:98066", -- [13]
			"114666:100550:98968", -- [14]
			"98966:97860:98972", -- [15]
			"114666:100468", -- [16]
			"114666:100459", -- [17]
			"114666:100550:94973", -- [18]
			"114666:100550", -- [19]
			"98966:100559", -- [20]
			"111624:112866:108888", -- [21]
			"114718:98113:98161:111314", -- [22]
			"98966:111327", -- [23]
			"111624:112866:108888:111418", -- [24]
			"90556:88110:110971", -- [25]
			"114718:111420", -- [26]
			"96813:112926", -- [27]
			"90639:114837", -- [28]
			"114718:93465", -- [29]
			"114666:100459:107457", -- [30]
			"111323:120272", -- [9]
			"111323:120118", -- [10]			
			["m"] = 1033,
			["coord"] = 1474854536,
			["direct"] = "90556:90639:96565:98966:96813:111323:111624:114718:114666",
			["f"] = 0,
		},
		[111624] = {
			"90556:88110", -- [1]
			"93447:93940", -- [2]
			"114666:100550:95688", -- [3]
			"111675:114718:98113:98161", -- [4]
			"111675:114718:111420:98108", -- [5]
			"111675:114718:98113", -- [6]
			"111675:114718:98113:98114", -- [7]
			"114666:100550:94973:97860", -- [8]
			"114666:100550:98968:97868", -- [9]
			"114666:100550:97870", -- [10]
			"114666:100550:98968:97868:98066", -- [11]
			"114666:96565", -- [12]
			"111675:98966", -- [13]
			"114666:100550:98968", -- [14]
			"114666:100550:94973:97860:98972", -- [15]
			"114666:100468", -- [16]
			"93447:100459", -- [17]
			"114666:100550:94973", -- [18]
			"114666:100550", -- [19]
			"111675:98966:100559", -- [20]
			"112866:108888", -- [21]
			"111675:114718:98113:98161:111314", -- [22]
			"96813:111323", -- [23]
			"111675:98966:111327", -- [24]
			"112866:108888:111418", -- [25]
			"90556:88110:110971", -- [26]
			"111675:114718:111420", -- [27]
			"112866:112926", -- [28]
			"111675:114718", -- [29]
			"90639:114837", -- [30]
			"93940:100459:114666:111675:114718:93465", -- [31]
			"93447:100459:107457", -- [32]
			"96813:120272", -- [10]
			"96813:111323:120118", -- [11]			
			["m"] = 1015,
			["coord"] = 2741258455,
			["direct"] = "90556:90639:112866:93447:96813:111675:114666",
			["f"] = 0,
		},
		[98968] = {
			"100550:114666:90556", -- [1]
			"100550:114666:90639", -- [2]
			"100550:114666:90556:88110", -- [3]
			"100550:114666:111624:112866", -- [4]
			"100550:100468:100459:93447", -- [5]
			"100550:100468:100459:93940", -- [6]
			"95688:100559:98114:98161", -- [7]
			"95688:100559:98114:98161:98108", -- [8]
			"95688:100559:98114:98113", -- [9]
			"95688:100559:98114", -- [10]
			"97868:98066", -- [11]
			"100550:96565", -- [12]
			"95688:98966", -- [13]
			"97868:98972", -- [14]
			"100550:100468", -- [15]
			"100550:100468:100459", -- [16]
			"100550:114666:111675:96813", -- [17]
			"95688:100559", -- [18]
			"100550:114666:111624:112866:108888", -- [19]
			"97860:111314", -- [20]
			"100550:114666:111675:111323", -- [21]
			"95688:100559:111327", -- [22]
			"100550:114666:111675", -- [23]
			"100550:114666:111624", -- [24]
			"100550:114666:111624:112866:108888:111418", -- [25]
			"100550:114666:90639:110971", -- [26]
			"95688:100559:98114:98113:111420", -- [27]
			"100550:114666:111624:112866:112926", -- [28]
			"100550:96565:114718", -- [29]
			"100550:114666", -- [30]
			"100550:100468:100459:93940:114837", -- [31]
			"96565:114666:100459:107457", -- [4]
			["m"] = 1072,
			["f"] = 0,
			["direct"] = "95688:97860:97868:97870:94973:100550",
			["coord"] = 1541228182,
			requirements = "cls:HUNTER", 
		},
		[111420] = {
			"114718:111675:90556", -- [1]
			"114718:111675:90639", -- [2]
			"114718:111675:90556:88110", -- [3]
			"96813:112866", -- [4]
			"114718:111675:114666:93447", -- [5]
			"114718:111675:114666:100459:93940", -- [6]
			"98113:98114:100559:95688", -- [7]
			"98113:98114", -- [8]
			"98113:98114:100559:97860", -- [9]
			"98113:98114:100559:95688:94973:97868", -- [10]
			"98113:98114:100559:95688:94973:97870", -- [11]
			"98161:111327:98972:98066", -- [12]
			"114718:96565", -- [13]
			"98113:98966", -- [14]
			"98113:98114:100559:95688:94973:98968", -- [15]
			"98161:111327:98972", -- [16]
			"114718:96565:100468", -- [17]
			"114718:111675:114666:100459", -- [18]
			"98113:98114:100559:95688:94973", -- [19]
			"98113:98114:100559:95688:100550", -- [20]
			"98113:98114:100559", -- [21]
			"96813:112866:108888", -- [22]
			"98108:111314", -- [23]
			"98161:111327", -- [24]
			"114718:111675", -- [25]
			"114718:111675:111624", -- [26]
			"96813:111418", -- [27]
			"114718:111675:90556:88110:110971", -- [28]
			"111323:112926", -- [29]
			"114718:111675:114666", -- [30]
			"114718:111675:90639:114837", -- [31]
			"114718:111675:114666:100459:107457", -- [32]
			"111323:120272", -- [1]
			"111323:120118", -- [2]			
			["m"] = 1017,
			["coord"] = 2387468240,
			["direct"] = "98161:98108:98113:96813:111323:114718:93465",
			["f"] = 0,
		},
		[111314] = {
			"98161:98113:114718:111675:90556", -- [1]
			"98161:98113:114718:111675:90639", -- [2]
			"98161:98113:114718:111675:90556:88110", -- [3]
			"98161:98113:114718:111675:111624:112866", -- [4]
			"97860:95688:100550:100468:100459:93447", -- [5]
			"97860:95688:100550:100468:100459:93940", -- [6]
			"97860:95688", -- [7]
			"98161:98113", -- [8]
			"111327:98114", -- [9]
			"97860:97868", -- [10]
			"97860:98968:97870", -- [11]
			"98972:98066", -- [12]
			"111327:98966:96565", -- [13]
			"111327:98966", -- [14]
			"97860:98968", -- [15]
			"97860:95688:100550:100468", -- [16]
			"97860:95688:100550:100468:100459", -- [17]
			"97860:94973", -- [18]
			"98108:111420:96813", -- [19]
			"97860:95688:100550", -- [20]
			"111327:100559", -- [21]
			"98161:98113:114718:111675:111624:112866:108888", -- [22]
			"98108:111420:111323", -- [23]
			"98161:98113:114718:111675", -- [24]
			"98161:98113:114718:111675:111624", -- [25]
			"98108:111420:96813:111418", -- [26]
			"98161:98113:114718:111675:90556:88110:110971", -- [27]
			"98108:111420", -- [28]
			"98108:111420:111323:112926", -- [29]
			"98161:98113:114718", -- [30]
			"111327:98966:96565:114666", -- [31]
			"97860:95688:100550:100468:100459:93940:114837", -- [32]
			"97860:94973:97870:107457", -- [33]
			"98161:111420:111323:120272", -- [1]
			"98161:111420:111323:120118", -- [2]			
			["m"] = 1017,
			["f"] = 0,
			["direct"] = "98161:98108:97860:98972:111327",
			["coord"] = 3860798298,
		},
		[98161] = {
			"98113:114718:111675:90556", -- [1]
			"98113:114718:111675:90639", -- [2]
			"98113:114718:111675:90556:88110", -- [3]
			"98113:114718:111675:111624:112866", -- [4]
			"98113:114718:111675:114666:93447", -- [5]
			"98114:100559:95688:100550:100468:100459:93940", -- [6]
			"98114:100559:95688", -- [7]
			"98114:100559:97860", -- [8]
			"98114:100559:95688:94973:97868", -- [9]
			"98114:100559:95688:94973:97870", -- [10]
			"111327:98972:98066", -- [11]
			"98114:98966:96565", -- [12]
			"98114:98966", -- [13]
			"98114:100559:95688:94973:98968", -- [14]
			"111327:98972", -- [15]
			"98114:100559:95688:100550:100468", -- [16]
			"98114:100559:95688:100550:100468:100459", -- [17]
			"98114:100559:95688:94973", -- [18]
			"98113:114718:96813", -- [19]
			"98114:100559:95688:100550", -- [20]
			"98114:100559", -- [21]
			"98113:114718:111675:111624:112866:108888", -- [22]
			"111420:111323", -- [23]
			"98113:114718:111675", -- [24]
			"98113:114718:111675:111624", -- [25]
			"98113:114718:96813:111418", -- [26]
			"98113:114718:111675:90556:88110:110971", -- [27]
			"98113:114718:96813:112926", -- [28]
			"98113:114718", -- [29]
			"98113:114718:111675:114666", -- [30]
			"98114:100559:95688:100550:100468:100459:93940:114837", -- [31]
			"111420:93465", -- [32]
			"98114:100559:95688:94973:97870:107457", -- [33]
			"92560:100559:97860", -- [1]
			"111420:111323:120272", -- [2]
			"111420:111323:120118", -- [3]			
			["m"] = 1017,
			["f"] = 0,
			["direct"] = "98108:98113:98114:111314:111327:111420",
			["coord"] = 2606531108,
		},
		[114837] = {
			"90639:90556", -- [1]
			"90639:90556:88110", -- [2]
			"90639:90556:112866", -- [3]
			"93940:93447", -- [4]
			"93940:100459:100468:100550:95688", -- [5]
			"93940:100459:100468:100550:95688:100559:98114:98161", -- [6]
			"93940:100459:100468:100550:95688:100559:98114:98161:98108", -- [7]
			"93940:100459:100468:100550:95688:100559:98114:98113", -- [8]
			"93940:100459:100468:100550:95688:100559:98114", -- [9]
			"93940:100459:100468:100550:94973:97860", -- [10]
			"93940:100459:100468:100550:98968:97868", -- [11]
			"93940:100459:100468:100550:97870", -- [12]
			"93940:100459:100468:100550:98968:97868:98066", -- [13]
			"93940:100459:100468:96565", -- [14]
			"93940:100459:100468:96565:98966", -- [15]
			"93940:100459:100468:100550:98968", -- [16]
			"93940:100459:100468:100550:94973:97860:98972", -- [17]
			"93940:100459:100468", -- [18]
			"93940:100459", -- [19]
			"93940:100459:100468:100550:94973", -- [20]
			"90639:111624:96813", -- [21]
			"93940:100459:100468:100550", -- [22]
			"93940:100459:100468:100550:95688:100559", -- [23]
			"90639:110971:108888", -- [24]
			"93940:100459:100468:100550:95688:100559:111327:111314", -- [25]
			"93940:100459:114666:111675:111323", -- [26]
			"93940:100459:100468:100550:95688:100559:111327", -- [27]
			"93940:100459:114666:111675", -- [28]
			"90639:111624", -- [29]
			"90639:110971:108888:111418", -- [30]
			"90639:110971", -- [31]
			"93940:100459:114666:111675:114718:111420", -- [32]
			"90639:90556:112866:112926", -- [33]
			"93940:100459:114666:111675:114718", -- [34]
			"93940:100459:114666", -- [35]
			"93940:100459:114666:111675:114718:93465", -- [36]
			"90639:111624:96813:120272", -- [1]
			"93940:100459:114666:111675:111323:120118", -- [2]			
			["direct"] = "90639:93940",
			["coord"] = 1115138655,
			["m"] = 1018,
			["f"] = 0,
		},
		[111327] = {
			"98113:114718:111675:90556", -- [1]
			"98113:114718:111675:90639", -- [2]
			"98113:114718:111675:90556:88110", -- [3]
			"98113:114718:111675:111624:112866", -- [4]
			"98966:96565:114666:93447", -- [5]
			"100559:95688:100550:100468:100459:93940", -- [6]
			"100559:95688", -- [7]
			"98161:98108", -- [8]
			"100559:97860", -- [9]
			"100559:95688:94973:97868", -- [10]
			"100559:95688:94973:97870", -- [11]
			"98972:98066", -- [12]
			"98966:96565", -- [13]
			"100559:95688:94973:98968", -- [14]
			"100559:95688:100550:100468", -- [15]
			"100559:95688:100550:100468:100459", -- [16]
			"100559:95688:94973", -- [17]
			"98113:114718:96813", -- [18]
			"100559:95688:100550", -- [19]
			"98113:114718:111675:111624:112866:108888", -- [20]
			"98113:114718:111323", -- [21]
			"98113:114718:111675", -- [22]
			"98113:114718:111675:111624", -- [23]
			"98113:114718:96813:111418", -- [24]
			"98113:114718:111675:90556:88110:110971", -- [25]
			"98161:111420", -- [26]
			"98113:114718:96813:112926", -- [27]
			"98113:114718", -- [28]
			"98966:96565:114666", -- [29]
			"100559:95688:100550:100468:100459:93940:114837", -- [30]
			"98161:111420:93465", -- [31]
			"100559:95688:94973:97870:107457", -- [32]
			"100559:95688:94973:98968", -- [9]
			["m"] = 1017,
			["f"] = 0,
			["direct"] = "98161:98113:98114:98966:98972:100559:111314",
			["coord"] = 2232703223,
		},
		[96813] = {
			"111624:90556", -- [1]
			"111624:90639", -- [2]
			"112866:88110", -- [3]
			"111624:93447", -- [4]
			"111624:93447:93940", -- [5]
			"111675:114666:100550:95688", -- [6]
			"111420:98161", -- [7]
			"111420:98108", -- [8]
			"114718:98113", -- [9]
			"114718:98113:98114", -- [10]
			"114718:98113:98114:100559:97860", -- [11]
			"111675:114666:100550:98968:97868", -- [12]
			"111675:114666:100550:97870", -- [13]
			"111675:114666:100550:98968:97868:98066", -- [14]
			"111675:96565", -- [15]
			"111675:98966", -- [16]
			"111675:114666:100550:98968", -- [17]
			"114718:98113:98114:100559:97860:98972", -- [18]
			"111675:114666:100468", -- [19]
			"111624:93447:100459", -- [20]
			"111675:114666:100550:94973", -- [21]
			"111675:114666:100550", -- [22]
			"114718:98113:98114:100559", -- [23]
			"112866:108888", -- [24]
			"111420:98108:111314", -- [25]
			"114718:98113:111327", -- [26]
			"112866:88110:110971", -- [27]
			"111675:114666", -- [28]
			"111624:90639:114837", -- [29]
			"111624:93447:100459:107457", -- [30]
			"111323:120118", -- [3]
			["m"] = 1014,
			["direct"] = "112866:111323:111675:111624:111418:111420:112926:114718",
			["coord"] = 3012264314,
			["f"] = 10,
		},
		[111323] = {
			"96813:111624:90556", -- [1]
			"96813:111624:90639", -- [2]
			"96813:112866:88110", -- [3]
			"96813:112866", -- [4]
			"111675:114666:93447", -- [5]
			"111675:114666:100459:93940", -- [6]
			"111420:98113:98114:100559:95688", -- [7]
			"111420:98161", -- [8]
			"111420:98108", -- [9]
			"111420:98113", -- [10]
			"111420:98113:98114", -- [11]
			"111420:98113:98114:100559:97860", -- [12]
			"111675:114666:100550:98968:97868", -- [13]
			"111675:114666:100550:97870", -- [14]
			"111675:114666:100550:98968:97868:98066", -- [15]
			"111675:96565", -- [16]
			"111675:98966", -- [17]
			"111675:114666:100550:98968", -- [18]
			"111420:98161:111327:98972", -- [19]
			"111675:114666:100468", -- [20]
			"111675:114666:100459", -- [21]
			"111675:114666:100550:94973", -- [22]
			"111675:114666:100550", -- [23]
			"111420:98113:98114:100559", -- [24]
			"96813:112866:108888", -- [25]
			"111420:98108:111314", -- [26]
			"111420:98161:111327", -- [27]
			"96813:111624", -- [28]
			"96813:111418", -- [29]
			"96813:112866:88110:110971", -- [30]
			"111675:114666", -- [31]
			"96813:111624:90639:114837", -- [32]
			"111675:114666:100459:107457", -- [33]
			["m"] = 1021,
			["f"] = 0,
			["direct"] = "96813:111675:111420:112926:114718:93465",
			["coord"] = 2136880574,
		},
		[109467] = {
			"109457:109451", -- [1]
			"109469:109558", -- [2]
			"109469:109558:109561", -- [3]
			"109457:109451:109789:109572:109571", -- [4]
			"109457:109451:109789:109572", -- [5]
			"109457:109451:109789", -- [6]
			["m"] = 1033,
			["f"] = 0,
			["direct"] = "109457:109469",
			["coord"] = 3014899171,
			requirements = "cls:HUNTER"
		},
		[109558] = {
			"109469:109467:109457", -- [1]
			"109469:109467:109457:109451", -- [2]
			"109469:109467", -- [3]
			"109561:109571", -- [4]
			"109561:109571:109572", -- [5]
			"109469:109467:109457:109451:109789", -- [6]
			["m"] = 1015,
			["f"] = 0,
			["direct"] = "109469:109561",
			["coord"] = 2188889228,
			requirements = "cls:HUNTER"
		},
		[109469] = {
			"109467:109457", -- [1]
			"109467:109457:109451", -- [2]
			"109558:109561", -- [3]
			"109558:109561:109571", -- [4]
			"109467:109457:109451:109789:109572", -- [5]
			"109467:109457:109451:109789", -- [6]
			["m"] = 1033,
			["f"] = 0,
			["direct"] = "109467:109558",
			["coord"] = 1775293492,
			requirements = "cls:HUNTER"
		},
		[109561] = {
			"109558:109469:109467:109457", -- [1]
			"109571:109572:109789:109451", -- [2]
			"109558:109469:109467", -- [3]
			"109558:109469", -- [4]
			"109571:109572", -- [5]
			"109571:109572:109789", -- [6]
			["m"] = 1015,
			["f"] = 0,
			["direct"] = "109558:109571",
			["coord"] = 1053912676,
			requirements = "cls:HUNTER"
		},
		[109457] = {
			"109467:109469", -- [1]
			"109467:109469:109558", -- [2]
			"109467:109469:109558:109561", -- [3]
			"109451:109789:109572:109571", -- [4]
			"109451:109789:109572", -- [5]
			"109451:109789", -- [6]
			["m"] = 1017,
			["f"] = 0,
			["direct"] = "109451:109467",
			["coord"] = 1635895994,
			requirements = "cls:HUNTER"
		},
		[109789] = {
			"109451:109457", -- [1]
			"109451:109457:109467", -- [2]
			"109451:109457:109467:109469", -- [3]
			"109451:109457:109467:109469:109558", -- [4]
			"109572:109571:109561", -- [5]
			"109572:109571", -- [6]
			["m"] = 1024,
			["f"] = 0,
			["direct"] = "109451:109572",
			["coord"] = 2433723769,
			requirements = "cls:HUNTER"
		},
		[109572] = {
			"109789:109451:109457", -- [1]
			"109789:109451", -- [2]
			"109789:109451:109457:109467", -- [3]
			"109789:109451:109457:109467:109469", -- [4]
			"109571:109561:109558", -- [5]
			"109571:109561", -- [6]
			["m"] = 1072,
			["direct"] = "109571:109789",
			["coord"] = 1708018224,
			["f"] = 0,
			requirements = "cls:HUNTER",
		},
		[109571] = {
			"109572:109789:109451:109457", -- [1]
			"109572:109789:109451", -- [2]
			"109572:109789:109451:109457:109467", -- [3]
			"109561:109558:109469", -- [4]
			"109561:109558", -- [5]
			"109572:109789", -- [6]
			["m"] = 1018,
			["f"] = 0,
			["direct"] = "109561:109572",
			["coord"] = 1894393429,
			requirements = "cls:HUNTER"
		},
		[109451] = {
			"109457:109467", -- [1]
			"109457:109467:109469", -- [2]
			"109457:109467:109469:109558", -- [3]
			"109789:109572:109571:109561", -- [4]
			"109789:109572:109571", -- [5]
			"109789:109572", -- [6]
			["m"] = 1017,
			["f"] = 0,
			["direct"] = "109457:109789",
			["coord"] = 1972394897,
			requirements = "cls:HUNTER"
		},
		[93465] = {
			"111323:96813:111624:90556", -- [1]
			"111323:96813:111624:90639", -- [2]
			"111323:96813:112866:88110", -- [3]
			"111323:96813:112866", -- [4]
			"111323:111675:114666:93447", -- [5]
			"111323:111675:114666:100459:93940", -- [6]
			"111420:98113:98114:100559:95688", -- [7]
			"111420:98161", -- [8]
			"111420:98108", -- [9]
			"111420:98113", -- [10]
			"111420:98113:98114", -- [11]
			"111420:98113:98114:100559:97860", -- [12]
			"111420:98113:98114:100559:95688:94973:97868", -- [13]
			"114718:96565:100550:97870", -- [14]
			"111420:98161:111327:98972:98066", -- [15]
			"114718:96565", -- [16]
			"111420:98113:98966", -- [17]
			"111420:98161:111327:98972", -- [18]
			"114718:96565:100468", -- [19]
			"111323:111675:114666:100459", -- [20]
			"111420:98113:98114:100559:95688:94973", -- [21]
			"111323:96813", -- [22]
			"114718:96565:100550", -- [23]
			"111420:98113:98114:100559", -- [24]
			"111323:96813:112866:108888", -- [25]
			"111420:98108:111314", -- [26]
			"111420:98161:111327", -- [27]
			"111323:111675", -- [28]
			"111323:96813:111624", -- [29]
			"111323:96813:111418", -- [30]
			"111323:96813:112866:88110:110971", -- [31]
			"111323:112926", -- [32]
			"111323:111675:114666", -- [33]
			"111323:96813:111624:90639:114837", -- [34]
			["direct"] = "111323:111420:114718",
			["f"] = 2,
			["m"] = 1021,
			["coord"] = 1130645975,
			requirements = "cls:DEATHKNIGHT"			
		},
		[107457] = {
			"100459:93447:90556", -- [1]
			"93940:90639", -- [2]
			"100459:93447:90556:88110", -- [3]
			"100459:93447:90556:112866", -- [4]
			"100459:93447", -- [5]
			"100459:100468:100550:95688", -- [6]
			"100459:100468:100550:95688:100559:98114:98161", -- [7]
			"100459:100468:100550:95688:100559:98114:98161:98108", -- [8]
			"100459:100468:100550:95688:100559:98114:98113", -- [9]
			"100459:100468:100550:95688:100559:98114", -- [10]
			"97870:97868:97860", -- [11]
			"97870:97868", -- [12]
			"97870:98066", -- [13]
			"100459:100468:96565", -- [14]
			"100459:100468:96565:98966", -- [15]
			"97870:97868:98972", -- [16]
			"100459:100468", -- [17]
			"100459:100468:100550:94973", -- [18]
			"100459:114666:111675:96813", -- [19]
			"100459:100468:100550", -- [20]
			"100459:100468:100550:95688:100559", -- [21]
			"100459:93447:90556:88110:108888", -- [22]
			"97870:97868:98972:111314", -- [23]
			"100459:114666:111675:111323", -- [24]
			"100459:100468:100550:95688:100559:111327", -- [25]
			"100459:114666:111675", -- [26]
			"100459:93447:111624", -- [27]
			"100459:93447:90556:88110:108888:111418", -- [28]
			"93940:90639:110971", -- [29]
			"100459:114666:111675:114718:111420", -- [30]
			"100459:93447:90556:112866:112926", -- [31]
			"100459:114666:111675:114718", -- [32]
			"100459:114666", -- [33]
			["direct"] = "93940:97870:100459",
			["m"] = 1077,
			["coord"] = 2657507100,
			["f"] = 0,
			requirements = "cls:DRUID"	
		},
	},	
	[9] = {
		[118830] = {
			["name"] = "Krokul Hovel, Krokuun",
			["direct"] = "123139:123260:124569:124313:122509:125407:125410:126951:123258:125350",
			["m"] = 1135,
			["coord"] = 2383064171,
			["f"] = 0,
			["isBeacon"] = true,
		},
		[125461] = {
			["name"] = "Vindicaar, Mac'Aree",
			["direct"] = "118830:123139:123260:124569:124313:122509:125407:125410:125514:126951:123258:125350",
			["m"] = 1170,
			["coord"] = 2091072516,
			["f"] = 3,
			["isSpaceship"] = true,
		},
		[122509] = {
			["name"] = "Triumvirate's End, Mac'Aree",
			["direct"] = "118830:123260:124569:125461:124313:125407:125410:126951:123258:125350",
			["m"] = 1170,
			["coord"] = 2270347563,
			["f"] = 0,
			["isBeacon"] = true,
		},
		[123260] = {
			["name"] = "Shattered Fields, Krokuun",
			["direct"] = "118830:123139:124569:124313:122509:125407:125410:126951:123258:125350",
			["m"] = 1135,
			["coord"] = 1731109521,
			["f"] = 0,
			["isBeacon"] = true,
		},
		[126951] = {
			["name"] = "City Center, Mac'Aree",
			["direct"] = "118830:123260:124569:125461:124313:122509:125407:125410:123258:125350",
			["m"] = 1170,
			["coord"] = 2020118034,
			["f"] = 0,
			["isBeacon"] = true,
		},
		[125407] = {
			["name"] = "Hope's Landing, Antoran Wastes",
			["direct"] = "118830:123260:124569:124313:122509:125410:125514:126951:123258:125350",
			["m"] = 1171,
			["coord"] = 3133768023,
			["f"] = 0,
			["isBeacon"] = true,
		},
		[124313] = {
			["name"] = "Conservatory of the Arcane, Mac'Aree",
			["direct"] = "118830:123260:124569:125461:122509:125407:125410:126951:123258:125350",
			["m"] = 1170,
			["coord"] = 2699191586,
			["f"] = 0,
			["isBeacon"] = true,
		},
		[124569] = {
			["name"] = "Destiny Point, Krokuun",
			["direct"] = "118830:123139:123260:124313:122509:125407:125410:126951:123258:125350",
			["m"] = 1135,
			["coord"] = 2692513213,
			["f"] = 0,
			["isBeacon"] = true,
		},
		[125410] = { --Dynamic
			["name"] = "Light's Purchase, Antoran Wastes",
			["direct"] = "118830:123260:124569:124313:122509:125407:125514:126951:123258:125350",
			["m"] = 1171,
			["coord"] = 3119956734,
			["f"] = 0,
			["isBeacon"] = true,
		},
		[125514] = {
			["name"] = "Vindicaar, Antoran Wastes",
			["direct"] = "118830:123139:123260:124569:125461:124313:122509:125407:125410:126951",
			["m"] = 1171,
			["coord"] = 1407291736,
			["f"] = 5,
			["isSpaceship"] = true,
		},
		[123139] = {
			["m"] = 1135,
			["direct"] = "118830:123260:124569:125461:124313:122509:125407:125410:125514:126951",
			["coord"] = 1809529829,
			["f"] = 1,
			["isSpaceship"] = true,
		},
		[125409] = { --Dynamic
            ["name"] = "The Veiled Den, Antoran Wastes",
			["m"] = 1171,
			["f"] = 0,
			["direct"] = "118830:123260:124569:124313:122509:125407:125514:126951:123258:125350",
			["coord"] = 3034464598,
			["isBeacon"] = true,
		}, 
		[125350] = {
			["m"] = 1170,
			["coord"] = 1885086975,
			["direct"] = "118830:123260:124569:125461:124313:123258:122509:125407:125409:126951:123258:125350",
			["f"] = 0,
			["isBeacon"] = true,
		},	
		[123258] = {
			["name"] = "Shadowguard Incursion, Mac'Aree",
			["direct"] = "118830:123260:124569:125461:124313:122509:125407:125350:125409:126951:123258:125350",
			["coord"] = 1294171850,
			["m"] = 1170,
			["f"] = 0,
			["isBeacon"] = true,
		},		
	},
}
}
		end
		local faction = UnitFactionGroup("player")
      
        --Checking for dynamic flight nodes

        --Saving original subtable for Argus (9) for further use.
        TaxiData.copies = TaxiData.copies or {}
        TaxiData.copies[faction] = TaxiData.copies[faction] or {}
        TaxiData.copies[faction][9] = TaxiData.copies[faction][9] or LuaUtils:clone(fullData[faction][9])
        
        --Restoring original table
        fullData[faction][9] = LuaUtils:clone(TaxiData.copies[faction][9])
        
        local result = fullData[faction]
        
        --Checking for mode
        if TaxiData.currentBeaconMode == "veiled-den" then
            result[9][125410] = nil
        end
        
        if TaxiData.currentBeaconMode == "lights-purchase" then
            result[9][125409] = nil
        end
        
		return result
	end

	TaxiData.NonZeroOpenWorldFloors = {
		[504] = 1,
		[321] = 1
	}
	
	TaxiData.ZoneTransData ={
		{
			[471] = {
				[464] = 3433929949,
			},
			[464] = {
				[476] = 1795621192,
				[471] = 1489008043,
				[894] = 2844428923,
			},
			[4] = {
				[11] = 1470197635,
				["321:1"] = 1958355245,
				[891] = 2660224514,
				[889] = 2133634463,
				["4:12"] = "83.2,53.6-4:12:54.9,9.5", -- Skull Rock
				["4:10"] = "59.0,58.3-4:10:32.0,51.8", -- Tiragarde Keep
				["4:19"] = "52.8,28.6-4:19:50.3,90.5", -- Dustwind Cave
				["4:8"] = "45.4,56.1-4:8:72.4,89.4", -- Burning Blade Coven
			},		
			["4:12"] = { 
				[4] = "54.9,9.5-4:0:83.2,53.6",
			},
			["4:10"] = { 
				[4] = "32.0,51.8-4:0:59.0,58.3",
				["4:11"] = "41.9,30.9-4:11:32.4,30.3", -- Great Hall
			},			
			["4:11"] = { 
				["4:10"] = "32.4,30.3-4:10:41.9,30.9", -- Tiragarde Keep
			},
			["4:19"] = { 
				[4] = "50.3,90.5-4:0:52.8,28.6",
			},			
			[61] = {
				[121] = 406263579,
				[161] = 3243834296,
				[141] = 3050468349,
			},
			[11] = {
				[43] = 1845697429,
				["321:1"] = 3159950357,
				[4] = 2970904252,
				["11:20"] = "38.9,69.2-11:20:22.5,88.6", -- Wailing Caverns Cave Entrance
			},
			["11:20"] = {
				[11] = "22.5,88.6-11:20:38.9,69.2",
			},
			[182] = {
				[43] = 2331042556,
				[241] = 2847019394,
				[281] = 2724926957,
			},
			[362] = {
				[9] = 2105215084,
			},
			[9] = {
				[362] = 1733059236,
				[607] = 3009779660,
				[890] = 1931589573,
				["9:6"] = "34.8,61.3-9:6:76.9,56.3", -- Palemane Rock
				["9:7"] = "60.8,47.4-9:7:39.6,90.7|59.3,36.6-9:7:30.4,14.6|59.2,44.0-9:7:28.6,65.2", -- The Venture Co. Mine
			},
			["9:6"] = {
				[9] = "76.9,56.3-9:0:34.8,61.3",
			},
			["9:7"] = {
				[9] = "39.6,90.7-9:0:60.8,47.4|30.4,14.6-9:0:59.3,36.6|28.6,65.2-9:0:59.2,44.0",
			},			
			[181] = {
				[43] = 381269507,
				["321:1"] = 1149093758,
			},
			[101] = {
				[81] = 2319717125,
				[121] = 1870330894,
				["101:21"]  = "28.9,62.6-101:21:24.6,43.5", -- Wicked Grotto **Only Way to Get To Felspore Cavern**
			},
			["101:21"] = {
				["101:22"] = "29.5,62.5-101:22:47.4,88.1|27.7,33.7-101:22:45.5,78.2", -- Felspore Cavern
				[101] = "24.6,43.5-101:0:28.9,62.6"
			},
			["101:22"] = {
				["101:21"] = "29.5,62.5-101:21:27.7,33.7|27.7,33.7-101:21:29.5,62.5",
			},			
			[121] = {
				[101] = 1956579161,
				[61] = 3887818503,
			},
			[606] = {
				[281] = 3704448369,
			},
			[241] = {
				[182] = 1562050176,
				[281] = 1257957714,
			},
			[607] = {				
				[9] = 1721598701,
				[81] = 1294080134,
				[141] = 2346437017,
			},
			[41] = {
				[381] = 1664252166,
				[888] = 2593026176,
				["41:4"] = "45.6,50.6-41:4:52.6,15.5", -- Banethil Barrow Den (Upper Den)
				["41:3"] = "54.5,46.3-41:3:77.6,81.7", -- Fel Rock				
			},
			["41:3"] = {
				[41] = "77.6,81.7-41:0:54.5,46.3",
			},
			["41:4"] = {
				[41] = "52.6,15.5-41:0:45.6,50.6",
				["41:4"] = "52.6,15.5-41:4:45.6,50.6",
				["41:5"] = "24.6,86.0-41:5:29.9,76.4|54.2,36.5-41:5:46.7,39.7", -- Banethil Barrow Den (Lower Den)
			},
			["41:5"] = {
				["41:4"] = "29.9,76.4-41:4:24.6,86.0|46.7,39.7-41:4:54.2,36.5",
			},
			[42] = {
				[43] = 1812196334,
			},
			[43] = {
				[182] = 2377663454,
				[11] = 2954680867,
				[181] = 4142825201,
				[42] = 1050876964,
				[81] = 1589169969,
			},
			[888] = {
				[41] = 2379214874,
				["41:2"] = "39.3,30.4-41:2:45.4,90.3", -- Shadowthread Cave
			},
			["41:2"] = { 
				[888] = "45.4,90.3-888:0:39.3,30.4", -- Shadowthread Cave
			},
			[141] = {
				[607] = 1405712634,
				[61] = 2113466014,
			},
			[889] = {
				[4] = 3014370725,
				["4:8"] = "53.0,21.3-4:8:72.2,89.7", -- Burning Blade Coven
			},
			["4:8"] = {
				[889] = "72.2,89.7-889:0:53.0,21.3",
				[4] = "72.4,89.4-4:0:45.4,56.1",
			},
			[476] = {
				[464] = 2800021803,
			},
			[890] = {
				[9] = 1167338360,
			},
			[720] = {
				[161] = 2967485327,
			},
			[891] = {
				[4] = 1773300482,
				["891:9"] = "59.3,21.8-891:9:53.9,80.5",
			},
			["891:9"] = {
				[891] = "53.9,80.5-891:0:59.3,21.8",
			},
			[161] = {
				[201] = 1196131805,
				[720] = 1057205090,
				[61] = 2199730562,
				["161:15"] = "35.3,42.6-161:15:55.9,36.4|34.8,41.6-161:15:50.4,25.1|34.5,42.4-161:15:47.5,33.6", -- The Noxious Lair
				["161:16"] = "54.5,69.8-161:16:42.2,39.4|55.5,68.2-161:16:51.5,24.3", -- The Gaping Chasm		
				["161:17"] = "64.76,49.98-161:17:52.94,29.33", -- Timeless Tunnel / Caverns of Time			
			},
			["161:15"] = {
				[161] = "55.9,36.4-161:0:35.3,42.6|50.4,25.1-161:0:34.8,41.6|47.5,33.6-161:0:34.5,42.4",
			},
			["161:16"] = {
				[161] = "42.2,39.4-161:0:54.5,69.8|51.5,24.3-161:0:55.5,68.2",
			},
			["161:17"] = {
				[161] = "52.94,29.33-161:0:64.76,49.98",
				["161:18"] = "34.18,75.00-161:18:61.10,53.32",
			},	
			["161:18"] = {
				["161:17"] = "61.10,53.32-161:17:34.18,75.00",
			},		
			[201] = {
				[261] = 1213602709,
				[161] = 3023237278,
			},
			[281] = {
				[182] = 738031305,
				[241] = 744254074,
				[606] = 2513823810,
			},
			[321] = {
				[11] = 1060613085,
				[4] = 2142499060,
				[181] = 3309962086,
				["321:2"] = "42.05,61.21-321:2:24.30,72.48|46.20,66.98-321:2:35.26,91.81|55.57,51.30:321:2:78.31,16.39"	
			},			
			["321:1"] = {
				[11] = 1060613085,
				[4] = 2142499060,
				[181] = 3309962086,
				["321:2"] = "42.05,61.21-321:2:24.30,72.48|46.20,66.98-321:2:35.26,91.81|55.57,51.30-321:2:78.31,16.39"	
			},
			["321:2"] ={
				["321:1"] = "24.30,72.48-321:1:42.05,61.21|35.26,91.81-321:1:46.20,66.98|78.31,16.39-321:1:55.57,51.30"	
			},
			[261] = {
				[201] = 3699253762,
				["261:13"] = "70.4,15.9-261:13:15.1,70.0",
			},
			["261:13"] = {
				[261] = "15.1,70.0-261:0:70.4,15.9",
			},
			[894] = {
				[464] = 900696814,
			},
			[81] = {
				[43] = 3156244453,
				[101] = 1526582946,
				[607] = 3479170838,
			},
			[381] = {
				[41] = 3427234998,
			},
			["521:1"] = {
				["521:2"] = "47.47,32.24-521:2:50.63,92.88", 
			},
			["521:2"] = {
				["521:1"] = "50.63,92.88-521:1:47.47,32.24", 
			},
			["759:1"] = {
				["759:2"] = "89.7,49.8-759:2:24.9,49.4|67.5,52.6-759:2:66.7,48.5", 
				["759:3"] = "66.5,48.3-759:3:45.9,47.6", 
			},
			["759:2"] = {
				["759:1"] = "24.9,49.4-759:1:89.7,49.8|66.7,48.5-759:1:67.5,52.6", 
			},
			["759:3"] = {
				["759:1"] = "45.9,47.6-759:1:66.5,48.3", 
			},
			["699:2"] = {
				["699:3"] = "39.22,34.98-699:3:56.27,24.42",
				["699:3"] = "31.69,72.04-699:3:48.30,74.24",
				["699:3"] = "20.79,19.09-699:3:44.12,13.38",
				["699:4"] = "29.47,42.67-699:4:75.94,39.95",
			},
			["699:3"] = {
				["699:2"] = "56.27,24.42-699:2:39.22,34.98",
				["699:2"] = "48.30,74.24-699:2:31.69,72.04",
				["699:2"] = "44.12,13.38-699:2:20.79,19.09",
			},			
			["699:4"] = {			
				["699:2"] = "75.94,39.95-699:2:29.47,42.67",
			},
			["699:5"] = {
				["699:6"] = "46.43,63.58-699:6:61.27,82.67", 
			},
			["699:6"] = {
				["699:5"] = "61.27,82.67-699:5:46.43,63.58", 
			},
			["688:1"] = {
				["688:2"] = "61.51,71.88-688:2:39.21,31.65", 
			},
			["688:2"] = {
				["688:1"] = "39.21,31.65-688:1:61.51,71.88", 
				["688:3"] = "47.24,79.12-688:3:43.60,61.06", 
			},
			["688:3"] = {
				["688:2"] = "43.60,61.06-688:2:47.24,79.12", 
			},
			["750:1"] = {
				["750:2"] = "15.53,56.75-750:2:28.99,4.84", 
			},
			["750:2"] = {
				["750:1"] = "28.99,4.84-750:1:15.53,56.75", 
			},			
		}, -- [1]
		{
			[27] = {
				[341] = 2527877552,
				[895] = 2130605098,
				[35] = "3840901933|3978316396",
				[866] = 1810672610,
				["27:7"] = "48.9,52.6-27:7:60.8,92.0",  -- Grizzled Den
				["27:6"] = "42.7,64.1-27:6:60.6,11.0|41.1,70.0-27:6:38.0,91.1",  -- Coldridge Pass
			},
			["27:7"] = { 
				[27] = "60.8,92.0-27:0:48.9,52.6",  -- Grizzled Den
			},
			["27:6"] = {
				[27] = "60.6,11.0-27:0:42.7,64.1|38.0,91.1-27:0:41.1,70.0",  -- Coldridge Pass
			},			
			["27:10"] = { 
				[895] = "79.5,84.2-895:0:32.6,37.0", --Gnome Starter
			},
			[700] = {
				[40] = 1168925923,
			},
			[38] = {
				[19] = 1545318364,
				[32] = 543985368,
				[29] = 2862222456,
			},
			[893] = {
				[462] = 2987642217,
			},
			[895] = {
				[27] = 3478884470,
				["895:8"] = "33.3,66.4-895:8:94.6,58.1", -- Frostmane Hold
				["27:10"] = "32.6,37.0-27:10:79.5,84.2", --Gnome Starter
			},
			["895:8"] = {
				[895] = "94.6,58.1-895:0:33.3,66.4", -- Frostmane Hold
			},
			[708] = {
				[709] = 1768041979,
			},
			[39] = {
				[30] = 2659068836,
				[34] = 2940772449,
				["39:17"] = "43.8,73.4-39:17:69.3,23.7:downstairs",
				["39:5"] = "44.5,24.7-39:5:41.1,94.1",
			},
			["39:17"] = {
				[39] = "69.3,23.7-39:0:43.8,73.4:upstairs"
			},
			["39:5"] = {
				[39] = "41.1,94.1-39:0:44.5,24.7"
			},			
			[301] = {
				[30] = 3161450937,
			},
			[16] = {
				[40] = 1693579510,
				[24] = 562777441,
			},
			[20] = {
				[21] = 2331622734,
				[22] = 3910974364,
				[382] = 2671814662,
				[892] = 1601212705,
				["20:13"] = "82.6,33.5-20:13:17.3,82.9|82.3,32.6-20:13:14.5,73.1", -- Scarlet Monastery Entrance
				["20:2"] = "15.41,56.13",
			},
			["20:2"] = {
				[20] = "37.16,6.98",
			},			
			["20:13"] = {
				[20] = "17.3,82.9-20:0:82.6,33.5|14.5,73.1-20:0:82.3,32.6", -- Scarlet Monastery Entrance
			},
			[24] = {
				[21] = 1337762526,
				[22] = 2934649478,
				[26] = 3104147899,
				[16] = 3032070019,
			},
			[28] = {
				[35] = 4054845869,
				[29] = 1476521034,
				[17] = 3529215275,
			},
			["28:14"] =  {
				["29:14"] = "34.8,85.6-29:14:46.47,18.25", -- Blackrock Spire north entrance
				["28:16"] = "46.8,50.8-28:16:58.2,88.5", -- Blackrock Depths chain again - silly two-zone clone dungeon
			},
			["28:16"] = { 
				["29:16"] = "40.2,57.9-29:16:46.2,62.9",
				["28:14"] = "58.2,88.5-28:14:46.8,50.8", -- Blackrock Depths chain again - silly two-zone clone dungeon
			},			
			[32] = {
				[38] = 2689686655,
				[34] = 1163549248,
			},
			[40] = {
				[16] = 2189891355,
				[35] = 2400379773,
				[700] = 3616833899,
			},
			[673] = {
				[37] = 2685678982,
			},
			[864] = {
				[30] = 1092537854,
			},
			[866] = {
				[27] = 4036248582,
				["866:9"] = "52.0,84.6-866:9:12.8,36.8", -- Frostmane Hovel
			},
			["866:9"] = {
				[866] = "12.8,36.8-866:0:52.0,84.6", -- Frostmane Hovel
			},
			[382] = {
				[20] = 2913666833,
			},
			[21] = {
				[20] = 2934637875,
				[24] = 3185036675,
			},
			[29] = {
				[36] = 2859589483,
				[38] = 3630552257,
				[28] = 852114287,
				["29:14"] = "21.0,38.0-29:14:49.50,88.66", -- Blackrock Spire south entrance
			},
			["29:14"] = {
				["29:15"] = "72.0,43.2-29:15:60.5,27.8|66.8,60.7-29:15:41.7,79.6", -- Blackrock Caverns foyer
				["29:16"] = "46.8,50.8-29:16:58.2,88.5", -- Blackrock Depths chain
				["28:14"] = "46.47,18.25-28:14:34.8,85.6", -- Blackrock Spire north entrance
			},
			["29:15"] = {
				["29:14"] = "60.5,27.8-29:14:72.0,43.2|41.7,79.6-29:14:66.8,60.7", -- Blackrock Caverns foyer
			},
			["29:16"] = {
				["29:14"] = "58.2,88.5-29:14:46.8,50.8", -- Blackrock Depths chain
				["28:16"] = "46.2,62.9-28:16:40.2,57.9",
			},
			[34] = {
				[37] = 1943786361,
				[36] = 4083356780,
				[32] = 3728566501,
				[30] = 4047378737,
				[39] = 339059421,
			},
			[892] = {
				[20] = 3150262706,
				["892:12"] = "29.7,30.7-892:12:87.3,52.0", -- Night's Web Hollow
			},
			["892:12"] = {
				[892] = "87.3,52.0-892:0:29.7,30.7", -- Night's Web Hollow
			},
			[894] = {
				[464] = 1219726622,
			},
			[709] = {
				[708] = 2878338652,
			},
			[35] = {
				[40] = 1100943173,
				[28] = 678422584,
				[27] = "387554517|631584798",
			},
			[462] = {
				[893] = 1751864058,
				[480] = 2427748285,
				[463] = 2085874872,
			},
			[463] = {
				[462] = 2077236833,
				["463:1"] = "66.4,28.5-463:1:94.0,35.6|58.3,27.5-463:1:10.0,26.0", -- Amani Catacombs
			},
			["463:1"] = {
				[462] = "94.0,35.6-463:0:66.4,28.5",
				[462] = "10.0,26.0-463:0:58.3,27.5",		
			},			
			[30] = {
				[864] = 1972928331,
				[39] = 848547206,
				[301] = 1576634545,
				[36] = 4202739599,
				[34] = 4017346597,
				["30:19"] = "61.7,53.7-30:19:48.9,90.1", --Jaspermind
				["30:1"] = "38.9,82.3-30:1:39.9,88.0", --Fargomine
				["30:2"] = "38.5,81.5-30:2:35.2,68.4", --Fargomine Lower				
			},
			["30:1"] = { 
				["30:2"] = "55.4,36.3-30:2:56.3,26.0", --Fargomine Lower
				[30] = "39.9,88.0-30:0:38.9,82.3", --Fargomine
			},
			["30:19"] = { 
				[30] = "48.9,90.1-30:0:61.7,53.7", --Fargomine Lower			
			},
			["30:2"] = { 
				[30] = "35.2,68.4-30:0:38.5,81.5", --Fargomine Lower			
			},
			[36] = {
				[30] = 638231076,
				[29] = 1812475232,
				[34] = 395627354,
			},
			[341] = {
				[27] = 171899504,
			},
			[22] = {
				[24] = 1886904705,
				[23] = 3097395133,
				[20] = 1496292123,
				[26] = 2812599147,
			},
			[615] = {
				[610] = 2640525056,
			},
			[464] = {
				[476] = 1795687940,
				[471] = 1591899449,
				[894] = 21556250390,
				["464:2"] = "26.9,76.3-464:2:59.5,88.1", -- Tides' Hollow
				["464:3"] = "45.3,19.4-464:3:21.2,94.6", -- Stillpine Hold				
			},
			["464:2"] = { 
				[464] = "59.5,88.1-464:0:26.9,76.3", -- Tides' Hollow
			},
			["464:3"] = { 
				[464] = "21.2,94.6-464:0:45.3,19.4", -- Stillpine Hold	
			},			
			[471] = {
				[464] = 3830487849,
			},
			[26] = {
				[24] = 99658880,
				[22] = 919484303,
			},
			[37] = {
				[34] = 2233733506,
				[673] = 2202845188,
			},
			[17] = {
				[28] = 355632487,
				["17:18"] = "41.6,11.6-17:18:75.6,36.5", --Uldaman Entrance
			},
			["17:18"] = {
				[17] = "75.6,36.5-17:0:41.6,11.6", --Uldaman Entrance
			},
			[610] = {
				[615] = 2101920817,
			},
			[476] = {
				[464] = 2800154388,
			},
			[19] = {
				[38] = 2099055262,
			},
			[23] = {
				[22] = 422815847,
				["23:20"] = "75.67,52.26",
			},
			["23:20"] = {
				[23] = "36.2,97.23",
				--requirements = "cls:PALADIN",
			},
			[480] = {
				[462] = 3086544408,
			},
			["721:1"] = {
				["721:3"] = "66.1,51.1-721:3:66.0,49.2|56.7,48.3-721:3:58.4,47.7",
				["721:2"] = "59.8,70.2-721:2:64.8,70.9|59.4,63.9-721:2:59.5,59.3",
			},
			["721:2"] = {
				["721:1"] = "64.8,70.9-721:1:59.8,70.2|59.5,59.3-721:1:59.4,63.9",
				["721:3"] = "53.2,52.8-721:3:57.0,51.2|51.1,74.2-721:3:49.9,74.1",
			},
			["721:3"] = {
				["721:1"] = "58.4,47.7-721:1:56.7,48.3|66.0,49.2-721:1:66.1,51.1",
				["721:2"] = "49.9,74.1-721:2:51.1,74.2|57.0,51.2-721:2:53.2,52.8",
				["721:4"] = "46.5,65.8-721:4:45.1,59.5|55.1,37.6-721:4:47.2,42.7",
			},
			["721:4"] = {
				["721:3"] = "47.2,42.7-721:3:55.1,37.6|45.1,59.5-721:3:46.5,65.8",
				["721:5"] = "37.2,34.2-721:5:37.1,32.1",
			},
			["721:5"] = {
				["721:4"] = "37.1,32.1-721:4:37.2,34.2",
				["721:6"] = "33.3,13.3-721:6:30.4,18.7",
			},
			["721:6"] = {
				["721:5"] = "30.4,18.7-721:5:33.3,13.3",
				["721:7"] = "29.0,41.4-721:7:28.4,36.1",
			},
			["721:7"] = {
				["721:6"] = "28.4,36.1-721:6:29.0,41.4|30.7,42.7-721:6:30.6,41.6|36.4,43.3-721:6:36.1,41.3", --cliff
			},
			["691:1"] = {
				["691:2"] = "57.67,50.98-691:2:81.36,46.02|47.05,86.94-691:2:75.38,74.06|34.33,61.78-691:2:61.73,61.55",
			},
			["691:2"] = {
				["691:1"] = "75.38,74.06-691:1:47.05,86.94|61.73,61.55-691:1:34.33,61.78",			
				["691:3"] = "35.21,88.08-691:3:38.60,50.33",
			},
			["691:3"] = {
				["691:2"] = "38.60,50.33-691:2:35.21,88.08",
				["691:4"] = "48.26,71.95-691:4:71.25,77.54",			
			},
			["691:4"] = {
				["691:3"] = "71.25,77.54-691:3:48.26,71.95",			
			},
			["871:1"] = {
				["871:2"] = "55.5,13.8-871:2:47.8,91.1",			
			},
			["871:2"] = {
				["871:1"] = "47.8,91.1-871:1:55.5,13.8",			
			},
			["874:1"] = {
				["874:2"] = "48.4,88.5-874:2:49.1,11.2",			
			},
			["874:2"] = {
				["874:1"] = "49.1,11.2-874:1:48.4,88.5",			
			},
			["898:1"] = {
				["898:2"] = "81.8,23.9-898:2:76.0,26.5",
			},
			["898:2"] = {				
				["898:1"] = "76.0,26.5-898:1:81.8,23.9",
				["898:3"] = "57.5,92.2-898:3:49.7,19.2",
			},
			["898:3"] = {				
				["898:2"] = "49.7,19.2-898:2:57.5,92.2",
				["898:4"] = "49.8,24.0-898:4:49.6,28.2",
			},
			["898:4"] = {
				["898:3"] = "49.6,28.2-898:3:49.8,24.0",
			},
			["764:1"] = {			
				["764:2"] = "14.78,88.35-764:2:27.49,87.84",
				["764:7"] = "34.01,70.58-764:7:23.69,75.12",
			},
			["764:2"] = {			
				["764:1"] = "60.03,13.01-764:1:38.18,39.14|27.49,87.84-764:1:14.78,88.35",
			},			
			["764:7"] = {			
				["764:3"] = "45.49,25.23-764:3:44.44,61.70",
			},
			["764:3"] = {	
				["764:7"] = "60.72,31.88-764:7:47.37,19.47",
				["764:4"] = "45.86,92.67-764:4:48.93,77.89",
			},
			["764:4"] = {	
				["764:3"] = "48.93,77.89-764:3:45.86,92.67",
				["764:5"] = "34.60,55.37-764:5:48.94,77.32",
			},
			["764:5"] = {	
				["764:4"] = "48.94,77.32-764:4:34.60,55.37|56.86,44.93-764:4:54.68,54.74",
				["764:6"] = "34.62,57.88-764:6:48.75,90.71",
			},
			["764:6"] = {	
				["764:5"] = "48.75,90.71-764:5:34.62,57.88",
			},
			["692:1"] = {	
				["692:2"] = "46.08,9.57-692:2:64.77,43.35",
			},
			["692:2"] = {	
				["692:1"] = "64.77,43.35-692:1:46.08,9.57",
			},
			["756:1"] = {	
				["756:2"] = "65.48,60.02-756:2:16.97,88.45",
			},
			["756:2"] = {	
				["756:1"] = "16.97,88.45-756:1:65.48,60.02",
			},
			["753:1"] = {
				["753:2"] = "52.05,20.12-753:2:29.97,17.32|49.93,12.98-753:2:29.37,13.13",
			},
			["753:2"] = {
				["756:1"] = "29.37,13.13-753:1:49.93,12.98",
			},			
			["798:1"] = {
				["798:2"] = "83.13,49.50-798:1:83.07,43.77", 
			},		
			["798:2"] = {
				["798:1"] = "83.07,43.77-798:2:83.13,49.50", 
			},			
		}, -- [2]
		{
			[465] = {
				[478] = 1432676590,
				[467] = 368738667,
			},
			[473] = {
				[478] = 888817067,
			},
			[467] = {
				[465] = 3741099940,
				[477] = "900773613|2874795116",
				[478] = 3548704455,
				[475] = 3022278272,
			},
			[475] = {
				[479] = 3629336664,
				[467] = 2302474188,
			},
			[477] = {
				[467] = "1457660635|3253816387",
			},
			[478] = {
				[467] = 1401359768,
				[465] = 2597989984,
				[473] = 3178728030,
			},
			[479] = {
				[475] = 941198995,
			},
			["727:1"] = {
				["727:2"] = "49.85,29.26-727:2:51.23,28.93|51.38,27.47-727:2:51.48,29.20|48.01,77.81-727:2:46.24,79.55|36.64,73.70-727:2:35.59,72.57", 
			},
			["727:2"] = {
				["727:1"] = "51.23,28.93-727:1:49.85,29.26|46.24,79.55-727:1:48.01,77.81", 
			},
			["730:1"] = {
				["730:2"] = "41.73,22.82-730:2:41.77,31.54", 
			},
			["730:2"] = {
				["730:1"] = "41.77,31.54-730:1:41.73,22.82", 
			},
			["731:1"] = {
				["731:2"] = "65.11,35.34-731:2:89.26,43.76", 
			},	
			["731:2"] = {
				["731:2"] = "89.26,43.76-731:2:65.11,35.34", 
				["731:3"] = "36.51,57.12-731:3:26.97,88.52", 
			},
			["731:3"] = {
				["731:2"] = "26.97,88.52-731:2:36.51,57.12", 
			},
			["723:1"] = {
				["723:2"] = "48.71,95.13-723:2:53.33,94.35", 
			},
			["723:2"] = {
				["723:1"] = "53.33,94.35-723:1:48.71,95.13|44.61,27.42-723:1:51.57,27.55", 
			},
			["722:1"] = {
				["722:2"] = "44.67,17.68-722:2:22.77,12.22", 
			},
			["722:2"] = {
				["722:1"] = "22.77,12.22-722:1:44.67,17.68", 
			},
			["798:1"] = {
				["798:2"] = "82.88,44.83-798:2:83.15,55.44", 
			},
			["798:2"] = {
				["798:1"] = "83.15,55.44-798:1:82.88,44.83", 
			},			
		}, -- [3]
		{
			[486] = {
				[488] = 4163853514,
				[493] = 2230065484,
			},
			[488] = {
				[510] = 2609191972,
				[486] = 493915578,
				[490] = 4002522347,
				[496] = 3821812493,
			},
			[490] = {
				[488] = 400075761,
				[496] = "736775540|1915439138|2605984477",
				[491] = "1545330826|2878324328",
			},
			[491] = {
				[490] = "1137584778|2295139559",
			},
			[492] = {
				[510] = 3826438157,
				[495] = 3560455606,
			},
			[493] = {
				[486] = 1332540447,
			},
			[495] = {
				[510] = 1402136832,
				[492] = 963928072,
			},
			[496] = {
				[488] = 656663382,
				[510] = 393783875,
				[490] = "1213658859|2452812115|3178746509",
			},
			[510] = {
				[488] = 1930214601,
				[495] = 3034797940,
				[496] = 3945829320,
				[492] = 2502836928,
			},
			["504:1"] = {
				["504:2"] = "35.3,44.8-504:1:33.6,45.63-504:1:38.8,45.1-504:2:34.3,43.3|59.76,47.37-504:1:61.2,49.0-504:1:38.8,45.1-504:2:64.4,48.6|48.1,32.4-504:2:48.2,32.4",
			},
			["504:2"] = {
				["504:1"] = "38.8,45.1-504:1:35.3,44.8-504:1:33.6,45.63-504:1:35.3,44.8|64.4,48.6-504:1:38.8,45.1-504:1:61.2,49.0-504:1:59.76,47.37",
			},
			["525:1"] = {
				["525:2"] = "89.0,53.8-525:2:57.0,21.3",
			},
			["525:2"] = {
				["525:1"] = "57.0,21.3-525:1:89.0,53.8",
			},
			["523:1"] = {
				["523:2"] = "48.5,84.7-523:2:34.8,64.5",
			},
			["523:2"] = {
				["523:1"] = "34.8,64.5-523:1:48.5,84.7",
				["523:3"] = "53.5,25.3-523:3:33.1,40.7",
			},	
			["523:3"] = {
				["523:2"] = "33.1,40.7-523:2:53.5,25.3",
			},	
			["524:1"] = {
				["524:2"] = "31.1,75.0-524:2:42.3,76.6|45.9,82.6-524:2:54.2,79.1|54.7,18.0-524:2:59.6,34.1",
			},
			["524:2"] = {
				["524:1"] = "42.3,76.6-524:1:31.1,75.0|54.2,79.1-524:1:45.9,82.6|59.6,34.1-524:1:54.7,18.0",
			},
			["533:2"] = {
				["533:3"] = "41.0,37.3-533:3:70.6,31.6",
				["533:1"] = "50.3,60.4-533:1:22.0,50.7",
			},
			["533:3"] = {
				["533:2"] = "70.6,31.6-533:2:41.0,37.3",
			},
			["534:1"] = {
				["534:2"] = "64.4,71.6-534:2:50.5,71.5",
			},				
			["534:2"] = {
				["534:1"] = "50.5,71.5-534:1:64.4,71.6",
			},				
		}, -- [4]
		{
			[544] = {
				["544:1"] = "31.2,78.6-544:1:48.1,90.0", -- Kaja'mite Cavern
				["544:2"] = "70.0,48.0-544:2:50.0,10.8", -- Volcanoth's Lair
			},
			["544:1"] = { 
				[544] = "48.1,90.0-544:0:31.2,78.6", -- Kaja'mite Cavern
			},
			["544:2"] = {
				[544] = "50.0,10.8-544:0:70.0,48.0", -- Volcanoth's Lair
			},
			[605] = {
				["605:7"] = "65.6,86.7-605:7:64.0,19.6", -- Kaja'Mine Copper
				["605:6"] = "74.3,83.3-605:6:32.9,31.0", -- Kaja'Mine Silver
				["605:5"] = "70.9,76.5-605:5:41.0,75.5", -- Kaja'Mine Gold
			},
			["605:7"] = {
				[605] = "64.0,19.6-605:0:65.6,86.7", -- Kaja'Mine Copper
			},
			["605:6"] = {
				[605] = "32.9,31.0-605:0:74.3,83.3", -- Kaja'Mine Silver
			},
			["605:5"] = {
				[605] = "41.0,75.5-605:0:70.9,76.5", -- Kaja'Mine Gold
			},
			["767:1"] = {
				["767:2"] = "48.9,82.1-767:2:51.0,53.0|50.0,39.7-767:2:50.0,90.1",
			},
			["767:2"] = {
				["767:1"] = "51.0,53.0-767:1:48.9,82.1|50.0,90.1-767:1:50.0,39.7",
			},
			[640] ={
				["640:1"] = "62.78,78.04-640:1:40.43,14.38",
			},
			["640:1"] ={
				[640] = "40.43,14.38-640:0:62.78,78.04",
				["640:2"] = "73.95,79.27-640:2:65.61,72.72",
			},
			["640:2"] ={
				["640:1"] = "65.61,72.72-640:1:73.95,79.27",
			},
		}, -- [5]
		{
			[807] = {
				[857] = "3561129410|510389304",
				[873] = 3034134506,
				[806] = 3845402834,
			},
			[809] = {
				[811] = 2382097092,
				[873] = 3172202871,
				[810] = 1257154184,
				["809:11"] = "52.9,71.3-809:11:56.5,15.9", --The Deeper
				["809:10"] = "50.3,61.7-809:10:74.9,91.5", -- Knucklethump Hole
				["809:9"] = "73.2,73.5-809:9:11.5,30.0", -- Pranksters' Hollow
				["809:8"] = "59.1,52.5-809:8:66.9,82.3", -- Howlingwind Cavern
				["809:17"] = "53.0,46.5-809:17:88.3,54.8", -- Tomb of Conquerors
				["809:20"] = "33.1,26.6-809:20:52.2,11.6", -- Ruins of Korune
				["873:5"] = "73.2,94.6-873:5:25.1,12.5", -- The Ancient Passage
			},
			["809:10"] = {
				[809] = "74.9,91.5-809:0:50.3,61.7", -- Knucklethump Hole
			},
			["809:9"] = {
				[809] = "11.5,30.0-809:0:73.2,73.5", -- Pranksters' Hollow
			},
			["809:8"] = {
				[809] = "66.9,82.3-809:0:59.1,52.5", -- Howlingwind Cavern
			},
			["809:17"] = {
				[809] = "88.3,54.8-809:0:53.0,46.5", -- Tomb of Conquerors
			},	
			["809:11"] = { 
				["809:12"] = "52.4,65.5-809:12:51.6,55.9", --The Deeper2
				[809] = "56.5,15.9-809:0:52.9,71.3", --The Deeper
			},
			["809:20"] = { 
				["809:21"] = "30.9,75.9-809:21:34.3,76.1", -- Crypt of Korune
				[809] = "52.2,11.6-809:0:33.1,26.6" -- Ruins of Korune
			},
			[903] = {
				[811] = "53.8,87.0-811:0:61.5,18.8|26.8,80.7-811:0:59.1,17.9|77.4,69.0-811:0:63.5,17.0",  -- main / west / east
			},			
			["903:1"] = {
				[811] = "53.8,87.0-811:0:61.5,18.8|26.8,80.7-811:0:59.1,17.9|77.4,69.0-811:0:63.5,17.0",  -- main / west / east
				["903:2"] = "22.1,54.4-903:2:27.8,80.6|36.6,21.7-903:2:38.3,36.6|77.5,42.6-903:2:74.4,70.3|58.0,18.5-903:2:55.8,30.0" -- west staircase / west hall / east staircase / east hall
 			},
			["903:2"] = {						
				["903:1"] = "51.28,76.12|27.8,80.6-903:1:22.1,54.4|38.3,36.6-903:1:36.6,21.7|74.4,70.3-903:1:77.5,42.6|55.8,30.0-903:1:58.0,18.5" -- balcony jump / west staircase / west hall / east staircase / east hall
			},				
			[811] = {
				[809] = 1886394282,
				[903] = 2637705065,
				["811:1"] = "61.5,18.8-811:1:53.8,87.0|59.1,17.9-811:1:26.8,80.7|63.5,17.0-811:1:77.4,69.0", -- main / west / east
				["903:1"] = "61.5,18.8-903:1:53.8,87.0|59.1,17.9-903:1:26.8,80.7|63.5,17.0-903:1:77.4,69.0", -- main / west / east
				["811:3"] = "86.8,64.3-811:3:38.6,28.4|85.6,67.4-811:3:25.5,55.8|89.1,63.5-811:3:60.3,18.0", -- main / west / east				
				["811:18"] = "22.2,26.3-811:18:54.0,88.2", -- Guo-Lai Halls
				--["requirements"] = "qid:31511,31512"
			},
 			["811:18"] = {
 				[811] = "54.0,88.2-811:0:22.2,26.3", -- Guo-Lai Halls
				["811:19"] = "64.2,18.8-811:19:66.9,17.7" -- The Hall of Serpent
 			},
			["811:19"] = {
				["811:18"] = "66.9,17.7-811:19:64.2,18.8" -- The Hall of Serpent
			},			
			["811:3"] = {
				[811] = "38.6,28.4-811:0:86.8,64.3|25.5,55.8-811:0:85.6,67.4|60.3,18.0-811:0:89.1,63.5",  -- main / west / east
				["811:4"] = "33.6,78.3-811:4:30.6,52.0|70.4,33.5-811:4:61.7,18.4|52.4,78.9-811:4:56.1,75.7|66.4,63.3-811:4:68.4,63.3" -- west staircase / east staircase / west hall / east hall
			},
			["811:4"] = {
				["811:3"] = "47.5,38.0|30.6,52.0-811:3:33.6,78.3|61.7,18.4-811:3:70.4,33.5|56.1,75.7-811:3:52.4,78.9|68.4,63.3-811:3:66.4,63.3" -- balcony jump
			},					
			[873] = {
				[807] = 2169764215,
				[809] = 1424956768,
				["873:5"] = "50.6,40.4-873:5:63.1,86.4|57.3,13.6-873:5:77.6,36.7", -- The Ancient Passage
			},
			["873:5"] = {
				[873] = "63.1,86.4-873:0:50.6,40.4|77.6,36.7-873:0:57.3,13.6", -- The Ancient Passage
				[809] = "25.1,12.5-809:0:73.2,94.6", -- The Ancient Passage
			},
			[806] = {
				[807] = 1406642189,
				["806:6"] = "45.9,28.9-806:6:75.7,24.7", -- Greenstone Quarry (Outisde --> Upper Quarry)
				["806:15"] = "57.7,31.7-806:15:76.8,20.0", -- The Widow's Wail (Outside of Cave --> Inside Cave)
				["806:16"] = "57.5,27.7-806:16:82.4,47.7", -- Oona Kagu (Outside of Cave --> Inside Cave)				
			},
			["806:6"] = { 
				[806] = "75.7,24.7-806:0:45.9,28.9", -- Greenstone Quarry (Outisde --> Upper Quarry)
				["806:7"] = "39.8,38.0-806:7:51.2,51.0", -- Greenstone Quarry (Upper Quarry --> Lower Quarry)
			},
			["806:7"] = { 
				["806:6"] = "51.2,51.0-806:6:39.8,38.0", -- Greenstone Quarry (Upper Quarry --> Lower Quarry)
			},
			["806:15"] = { 
				[806] = "76.8,20.0-806:0:57.7,31.7", -- The Widow's Wail (Outside of Cave --> Inside Cave)
			},
			["806:16"] = { 
				[806] = "82.4,47.7-806:0:57.5,27.7", -- Oona Kagu (Outside of Cave --> Inside Cave)			
			},			
			[810] = {
				[858] = 2498947948,
				[809] = 3044437654,
				["810:13"] = "33.02,61.24-810:13:20.15,68.46", -- Niuzao Catacombs
			},
			["810:13"] = {
				[810] = "20.15,68.46-810:0:33.02,61.24", -- Niuzao Catacombs
			},
			[857] = {
				[807] = "322804459|1673604347",
				["857:1"] = "80.3,17.8-857:1:33.3,24.4",
			},
			["857:1"] = {
				["857:2"] = "61.6,51.8-857:2:59.5,36.7",
				[857] = "33.3,24.4-857:0:80.3,17.8",
			},
			["857:2"] = {
				["857:2"] = "59.5,36.7-857:1:61.6,51.8",
				["857:3"] = "62.7,39.6-857:3:82.3,36.0",
			},	
			["857:3"] = {
				["857:2"] = "82.3,36.0-857:2:62.7,39.6",
			},				
			[858] = {
				[810] = 1927748412,
			},
			[928] = {
				["928:1"] = "54.6,29.1-928:1:73.1,51.3|49.3,25.5-928:1:38.8,27.1|49.3,25.5-928:1:38.8,27.1", --Ghostly Veins
				["928:2"] = "62.4,40.3-928:2:66.1,77.9", --The Swollen Vault
			},
			["928:1"] = {
				[928] = "73.1,51.3-928:0:54.6,29.1|38.8,27.1-928:0:49.3,25.5|38.8,27.1-928:0:49.3,25.5", --Ghostly Veins
			},
			["928:2"] = {
				[928] = "66.1,77.9-928:0:62.4,40.3", --The Swollen Vault
			},
			[951] = {
				["951:22"] = "43.3,40.8-951:22:44.4,81.0", --Cavern of Lost Spirits
			},
			["951:22"] = { 
				[951] =  "44.4,81.0-951:0:43.3,40.8", --Cavern of Lost Spirits
			},
			["876:1"] = {
				["876:2"] = "28.1,61.1-876:2:32.8,59.2",
			},
			["876:2"] = {
				["876:1"] = "32.8,59.2-876:1:28.1,61.1",
				["876:3"] = "81.5,58.5-876:3:33.8,77.9",
			},
			["876:3"] = {
				["876:2"] = "33.8,77.9-876:2:75.5,33.5",
				["876:4"] = "75.5,33.5-876:4:57.6,31.1",
			},
			["876:4"] = {
				["876:3"] = "57.6,31.1-876:3:75.5,33.5",
			},
			["887:1"] = {
				["887:3"] = "50.3,73.9-887:3:21.6,53.6",
			},
			["887:2"] = {
				["887:3"] = "53.2,81.9-887:3:57.1,80.7",
			},
			["887:3"] = {
				["887:1"] = "21.6,53.6-887:1:50.3,73.9",
				["887:2"] = "57.1,80.7-887:2:53.2,81.9",
			},
			["885:1"] = {
				["885:2"] = "49.0,67.0-885:2:55.8,18.9",
			},
			["885:2"] = {
				["885:1"] = "55.8,18.9-885:1:49.0,67.0",
				["885:3"] = "71.5,76.2-885:3:58.8,24.3",
			},
			["885:3"] = {				
				["885:2"] = "58.8,24.3-885:2:71.5,76.2",
			},
			["867:1"] = {				
				["867:2"] = "27.4,62.7-867:2:39.0,22.0|27.0,68.7-867:2:46.6,42.5",
			},
			["867:2"] = {				
				["867:1"] = "39.0,22.0-867:1:27.4,62.7|46.6,42.5-867:1:27.0,68.7",
			},
			["877:1"] = {			
				["877:2"] = "56.0,88.0-877:2:21.0,85.6",
				["877:3"] = "36.5,81.8-877:3:76.9,81.4|22.1,69.1-877:3:12.3,19.2",
				["877:4"] = "30.7,35.0-877:4:17.0,72.6|44.7,40.1-877:4:51.3,83.9",				
			},
			["877:2"] = {			
				["877:1"] = "21.0,85.6-877:1:56.0,88.0",		
			},
			["877:3"] = {			
				["877:1"] = "76.9,81.4-877:1:36.5,81.8|12.3,19.2-877:1:22.1,69.1",	
			},
			["877:4"] = {			
				["877:1"] = "17.0,72.6-877:1:30.7,35.0|51.3,83.9-877:1:44.7,40.1",	
			},
			["875:1"] = {			
				["875:2"] = "46.3,33.1-875:2:50.0,50.8",	
			},
			["875:2"] = {			
				["875:1"] = "50.0,50.8-875:1:46.3,33.1",	
			},			
		}, -- [6]
		{
			[976] = {
				[941] = "16.21,73.99|57.18,6.60|12.2,72.4",
				["976:27"] = "63.4,72.8-976:27:65.4,55.0", --Frostwall Mine
			},
			[980] = {
				[941] = "16.21,73.99|57.18,6.60|12.2,72.4",
			},
			[981] = {
				[941] = "16.21,73.99|57.18,6.60|12.2,72.4",
			},	
			[982] = {
				[941] = "16.21,73.99|57.18,6.60|12.2,72.4",
			},										
			[941] = {
				[976] = "44.15,68.52|49.63,60.27|44.3,68.7",
				[980] = "44.15,68.52|49.63,60.27|44.3,68.7",
				[981] = "44.15,68.52|49.63,60.27|44.3,68.7",
				[982] = "44.15,68.52|49.63,60.27|44.3,68.7",
				[949] = "87.9,72.4",
				["941:4"] = "29.7,41.5-941:4:71.3,89.6", --Sootstained Mines
				["941:9"] = "65.4,17.5-941:9:27.6,19.3", --Snowfall Alcove
				["941:7"] = "46.0,33.4-941:7:33.2,51.5", --Grulloc's Grotto
				["941:6"] = "63.3,65.7-941:6:24.6,58.6", --The Hunter's Hall
				["941:1"] = "20.9,41.9-941:1:0.5,68.3|23.9,35.1", --Bladespire Citadel	
			},
			["941:1"] = {
				[941] = "0.5,68.3-941:0:20.9,41.9|16.7,33.08",
				["941:2"] = "55.3,25.8-941:2:55.7,18.7", --Bladespire Citadel				
			},
			["941:2"] = {
				["941:1"] = "55.7,18.7-941:2:55.3,25.8", --Bladespire Citadel				
			},
			["941:4"] = {
				[941] = "71.3,89.6-941:0:29.7,41.5", --Sootstained Mines
			},
			["941:9"] = {
				[941] = "27.6,19.3-941:0:65.4,17.5", --Snowfall Alcove
			},
			["941:7"] = {
				[941] = "33.2,51.5-941:0:46.0,33.4", --Grulloc's Grotto
				["941:8"] = "41.9,32.8-941:8:42.0,32.9", --Grulloc's Lair
			},
			["941:8"] = {
				["941:7"] = "42.0,32.9-941:7:41.9,32.8", --Grulloc's Lair
			},
			["941:6"] = {
				[941] = "24.6,58.6-941:0:63.3,65.7", --The Hunter's Hall
			},
			[946] = {
				[950] = "29.7,56.3",
				[949] = "69.9,0.7",
				[947] = "81.0,58.2",
				[948] = "41.9,98.3|57.2,91.3",
				["946:14"] = "41.4,60.1-946:14:49.6,90.4", --Tomb of Souls
				["946:13"] = "58.7,65.0-946:0:58.9,64.8-946:13:34.5,29.4", --Tomb of Lights
				["946:30"] = "46.7,63.6-946:30:42.0,34.6", --The Breached Ossuary
			},
			["946:14"] = {
				[946] = "49.6,90.4-946:0:41.4,60.1", --Tomb of Souls
			},
			["946:13"] = {
				[946] = "34.5,29.4-946:0:58.9,64.8-946:0:58.7,65.0", --Tomb of Lights
			},
			[950] = {
				[946] = "92.4,72.2",
				["950:11"] = "67.0,49.6-950:11:11.8,77.1", --Vault of the Titan
				["950:12"] = "55.0,61.97-950:12:79.1,37.8", --The Underpale
			},
			["950:11"] = {
				[950] = "11.8,77.1-950:0:67.0,49.6", --Vault of the Titan
			},
			["950:12"] = {
				[950] = "8.5,60.1-950:0:47.3,64.5-950:0:47.0,62.0|79.1,37.8-950:0:55.0,61.97", --The Underpale
			},			
			[949] = {
				[946] = "41.6,95.2",
				[941] = "35.9,78.3",
				["949:16"] = "48.3,94.0-949:16:59.1,17.6", --Moira's Bastion
				["949:18"] = "43.7,48.3-949:18:65.5,83.7", --Fissure of Fury				
				["949:20"] = "54.1,55.9-949:20:71.3,73.6", --Cragplume Crater	
			},
			["949:20"] = {
				[949] = "571.3,73.6-949:0:54.1,55.9", --Cragplume Crater					
				["949:21"] = "70.0,45.7-949:21:65.5,54.7", --Cragplume Crater				
			},
			["949:21"] = {
				["949:20"] = "65.5,54.7-949:20:70.0,45.7", --Cragplume Crater					
			},			
			["949:16"]