----------------------------------------------------
-- Dice Companion
-- Core Addon File (Global)
----------------------------------------------------

DiceCompanion = {}
DiceCompanion.name = "Dice Companion"

----------------------------------------------------
-- LOAD & INITIALIZE SAVED VARIABLES (Final Version)
----------------------------------------------------
local initFrame = CreateFrame("Frame")
initFrame:RegisterEvent("ADDON_LOADED")
initFrame:SetScript("OnEvent", function(self, event, addonName)
    -- Match any folder name containing "DiceCompanion"
    if addonName:lower():find("dicecompanion") then
        DiceCompanionDB = DiceCompanionDB or {}
        DiceCompanion.db = DiceCompanionDB

        -- Ensure sub-tables exist
        DiceCompanion.db.settings   = DiceCompanion.db.settings   or {}
        DiceCompanion.db.playerData = DiceCompanion.db.playerData or {}
        DiceCompanion.db.casinoList = DiceCompanion.db.casinoList or {}
    end
end)

----------------------------------------------------
-- MAIN UI FRAME
----------------------------------------------------
local frame = CreateFrame("Frame", "DiceCompanion_MainFrame", UIParent, "BackdropTemplate")
frame:SetSize(400, 450)
frame:SetPoint("CENTER")
frame:SetBackdrop({
  bgFile = "Interface\\DialogFrame\\UI-DialogBox-Background",
  edgeFile = "Interface\\DialogFrame\\UI-DialogBox-Border",
  tile = true, tileSize = 32, edgeSize = 32,
  insets = { left = 11, right = 12, top = 12, bottom = 11 }
})
frame:SetBackdropColor(0, 0, 0, 1)

-- Title background
frame.titleBg = frame:CreateTexture(nil, "ARTWORK")
frame.titleBg:SetTexture("Interface\\DialogFrame\\UI-DialogBox-Header")
frame.titleBg:SetSize(256, 64)
frame.titleBg:SetPoint("TOP", frame, "TOP", 0, 12)

-- Title text
frame.title = frame:CreateFontString(nil, "OVERLAY", "GameFontNormal")
frame.title:SetPoint("TOP", frame.titleBg, "TOP", 0, -14)
frame.title:SetText("Dice Companion")

-- Movable setup
frame:SetMovable(true)
frame:EnableMouse(true)
frame:RegisterForDrag("LeftButton")
frame:SetScript("OnDragStart", frame.StartMoving)
frame:SetScript("OnDragStop", frame.StopMovingOrSizing)
frame:SetClampedToScreen(true)

-- Close button
frame.closeButton = CreateFrame("Button", nil, frame, "UIPanelCloseButton")
frame.closeButton:SetPoint("TOPRIGHT", frame, "TOPRIGHT", -5, -5)
frame.closeButton:SetScript("OnClick", function() frame:Hide() end)

----------------------------------------------------
-- CONTENT FRAMES (Each Tab Displays Different Data)
----------------------------------------------------
frame.contentFrames = {}

frame.contentFrames["MainMenu"] = CreateFrame("Frame", nil, frame)
frame.contentFrames["MainMenu"]:SetAllPoints(frame)
frame.contentFrames["MainMenu"]:Hide()

frame.contentFrames["RollTracker"] = CreateFrame("Frame", nil, frame)
frame.contentFrames["RollTracker"]:SetAllPoints(frame)
frame.contentFrames["RollTracker"]:Hide()

----------------------------------------------------
-- AUTO-HIDE TABS WHEN MAIN UI CLOSES
----------------------------------------------------
hooksecurefunc(frame, "Hide", function()
    if DiceCompanion_MainTab then DiceCompanion_MainTab:Hide() end
    if DiceCompanion_RollTrackerTab then DiceCompanion_RollTrackerTab:Hide() end
    if DiceCompanion_ProfitTrackerTab then DiceCompanion_ProfitTrackerTab:Hide() end
end)

----------------------------------------------------
-- TAB CREATION FUNCTION
----------------------------------------------------
local activeTab = nil

local function SetActiveTab(tabName)
    activeTab = tabName

    -- Update colors
    if tabName == "MainMenu" then
        DiceCompanion_MainTab.text:SetText("|cff00ff00Main Menu|r")
        DiceCompanion_RollTrackerTab.text:SetText("Roll Tracker")
        DiceCompanion_ProfitTrackerTab.text:SetText("Profit Tracker")
    elseif tabName == "RollTracker" then
        DiceCompanion_MainTab.text:SetText("Main Menu")
        DiceCompanion_RollTrackerTab.text:SetText("|cff00ff00Roll Tracker|r")
        DiceCompanion_ProfitTrackerTab.text:SetText("Profit Tracker")
    elseif tabName == "ProfitTracker" then
        DiceCompanion_MainTab.text:SetText("Main Menu")
        DiceCompanion_RollTrackerTab.text:SetText("Roll Tracker")
        DiceCompanion_ProfitTrackerTab.text:SetText("|cff00ff00Profit Tracker|r")
    end

    -- Show/Hide appropriate content
    for name, frame in pairs(DiceCompanion_MainFrame.contentFrames) do
        if name == tabName then
            frame:Show()
        else
            frame:Hide()
        end
    end
end

----------------------------------------------------
-- LEFT SIDE TAB #1: MAIN MENU
----------------------------------------------------
local mainTab = CreateFrame("Button", "DiceCompanion_MainTab", UIParent, "BackdropTemplate")
mainTab:SetSize(256, 64)
mainTab:SetPoint("TOPRIGHT", frame, "TOPLEFT", 60, -20)
mainTab:SetScript("OnClick", function() SetActiveTab("MainMenu") end)

mainTab.bg = mainTab:CreateTexture(nil, "ARTWORK")
mainTab.bg:SetTexture("Interface\\DialogFrame\\UI-DialogBox-Header")
mainTab.bg:SetAllPoints(mainTab)

mainTab.text = mainTab:CreateFontString(nil, "OVERLAY", "GameFontNormal")
mainTab.text:SetPoint("TOP", mainTab, "TOP", 0, -14)
mainTab.text:SetText("Main Menu")

----------------------------------------------------
-- LEFT SIDE TAB #2: ROLL TRACKER
----------------------------------------------------
local rollTab = CreateFrame("Button", "DiceCompanion_RollTrackerTab", UIParent, "BackdropTemplate")
rollTab:SetSize(256, 64)
rollTab:SetPoint("TOPRIGHT", mainTab, "BOTTOMRIGHT", 0, 20)
rollTab:SetScript("OnClick", function() SetActiveTab("RollTracker") end)

rollTab.bg = rollTab:CreateTexture(nil, "ARTWORK")
rollTab.bg:SetTexture("Interface\\DialogFrame\\UI-DialogBox-Header")
rollTab.bg:SetAllPoints(rollTab)

rollTab.text = rollTab:CreateFontString(nil, "OVERLAY", "GameFontNormal")
rollTab.text:SetPoint("TOP", rollTab, "TOP", 0, -14)
rollTab.text:SetText("Roll Tracker")

----------------------------------------------------
-- LEFT SIDE TAB #3: PROFIT TRACKER
----------------------------------------------------
local profitTab = CreateFrame("Button", "DiceCompanion_ProfitTrackerTab", UIParent, "BackdropTemplate")
profitTab:SetSize(256, 64)
profitTab:SetPoint("TOPRIGHT", rollTab, "BOTTOMRIGHT", 0, 20)
profitTab:SetScript("OnClick", function() SetActiveTab("ProfitTracker") end)

profitTab.bg = profitTab:CreateTexture(nil, "ARTWORK")
profitTab.bg:SetTexture("Interface\\DialogFrame\\UI-DialogBox-Header")
profitTab.bg:SetAllPoints(profitTab)

profitTab.text = profitTab:CreateFontString(nil, "OVERLAY", "GameFontNormal")
profitTab.text:SetPoint("TOP", profitTab, "TOP", 0, -14)
profitTab.text:SetText("Profit Tracker")

----------------------------------------------------
-- SHOW ON LOGIN
----------------------------------------------------
local eventFrame = CreateFrame("Frame")
eventFrame:RegisterEvent("PLAYER_LOGIN")
eventFrame:SetScript("OnEvent", function()
    frame:Show()
    mainTab:Show()
    rollTab:Show()
    SetActiveTab("MainMenu") -- Default tab
end)

----------------------------------------------------
-- LINK MAIN MENU FILE
----------------------------------------------------
if DiceCompanion and DiceCompanion.InitializeMainMenu then
    DiceCompanion:InitializeMainMenu()
else
    local hookFrame = CreateFrame("Frame")
    hookFrame:RegisterEvent("PLAYER_LOGIN")
    hookFrame:SetScript("OnEvent", function()
        if DiceCompanion and DiceCompanion.InitializeMainMenu then
            DiceCompanion:InitializeMainMenu()
        end
    end)
end

----------------------------------------------------
-- LINK ROLL TRACKER FILE
----------------------------------------------------
if DiceCompanion and DiceCompanion.InitializeRollTracker then
    DiceCompanion:InitializeRollTracker()
else
    local hookFrame2 = CreateFrame("Frame")
    hookFrame2:RegisterEvent("PLAYER_LOGIN")
    hookFrame2:SetScript("OnEvent", function()
        if DiceCompanion and DiceCompanion.InitializeRollTracker then
            DiceCompanion:InitializeRollTracker()
        end
    end)
end

----------------------------------------------------
-- LINK PROFIT TRACKER FILE
----------------------------------------------------
if DiceCompanion and DiceCompanion.InitializeProfitTracker then
    DiceCompanion:InitializeProfitTracker()
else
    local hookFrame3 = CreateFrame("Frame")
    hookFrame3:RegisterEvent("PLAYER_LOGIN")
    hookFrame3:SetScript("OnEvent", function()
        if DiceCompanion and DiceCompanion.InitializeProfitTracker then
            DiceCompanion:InitializeProfitTracker()
        end
    end)
end

----------------------------------------------------
-- ENSURE MAIN MENU IS DEFAULT TAB
----------------------------------------------------
local ensureMainMenu = CreateFrame("Frame")
ensureMainMenu:RegisterEvent("PLAYER_ENTERING_WORLD")
ensureMainMenu:SetScript("OnEvent", function()
    if DiceCompanion_MainFrame and DiceCompanion_MainFrame:IsShown() then
        SetActiveTab("MainMenu")
    end
end)
