function IsConsumableItemApi(value)
    local result = false
    if value == 109624 then -- Broken Frostweed Stem
        result = true
    elseif value == 109125 then --fireweed
        result = false
    elseif value == 108353 then -- Adder's Tongue Stem
        result = true
    elseif value == 8846 then -- gromsblood
        result = false
    elseif value == 79010 then -- Snow Lily
        result = false 
    elseif value == 124105 then -- Starlight Rose
        result = false
    end
    return result
end

_DPProfessionMockApi = {}
_DPProfessionMockApi.__index = _DPProfessionMockApi

setmetatable(_DPProfessionMockApi, {
  __call = function (cls)
    return cls.new()
  end,
})

function _DPProfessionMockApi.new()
    local self = setmetatable({}, _DPProfessionMockApi)
    self:_init()
    return self
end

function _DPProfessionMockApi._init(self)
	self.firstProf = {}
	self.secondProf = {}
end

function _DPProfessionMockApi.setFirstProf(self, ...)
	local values = ...
	self.firstProf["name"] = values["name"]
	self.firstProf["texture"] = values["texture"]
	self.firstProf["rank"] = values["rank"]
	self.firstProf["maxRank"] = values["maxRank"]
	self.firstProf["numSpells"] = values["numSpells"]
	self.firstProf["spelloffset"] = values["spelloffset"]
	self.firstProf["skillLine"] = values["skillLine"]
	self.firstProf["rankModifier"] = values["rankModifier"]
	self.firstProf["specializationIndex"] = values["specializationIndex"]
	self.firstProf["specializationOffset"] = values["specializationOffset"]
	self.firstProf["index"] = values["index"]
end

function _DPProfessionMockApi.setSecondProf(self, ...)
	local values = ...
	self.secondProf["name"] = values["name"]
	self.secondProf["texture"] = values["texture"]
	self.secondProf["rank"] = values["rank"]
	self.secondProf["maxRank"] = values["maxRank"]
	self.secondProf["numSpells"] = values["numSpells"]
	self.secondProf["spelloffset"] = values["spelloffset"]
	self.secondProf["skillLine"] = values["skillLine"]
	self.secondProf["rankModifier"] = values["rankModifier"]
	self.secondProf["specializationIndex"] = values["specializationIndex"]
	self.secondProf["specializationOffset"] = values["specializationOffset"]
	self.secondProf["index"] = values["index"]
end

function _DPProfessionMockApi.getProfessionInfo(self, index)
	if self.firstProf["index"] == index then
		return self.firstProf["name"], self.firstProf["texture"], self.firstProf["rank"], self.firstProf["maxRank"],self.firstProf["numSpells"],
				self.firstProf["spelloffset"], self.firstProf["skillLine"], self.firstProf["rankModifier"], self.firstProf["specializationIndex"],
				self.firstProf["specializationOffset"]
	elseif self.secondProf["index"] == index then
		return self.secondProf["name"], self.secondProf["texture"], self.secondProf["rank"], self.secondProf["maxRank"],self.secondProf["numSpells"],
				self.secondProf["spelloffset"], self.secondProf["skillLine"], self.secondProf["rankModifier"], self.secondProf["specializationIndex"],
				self.secondProf["specializationOffset"]
	end
	return "!Unknow?", nil, 125, 700, nil,nil,9999,nil,nil, nil
end

function _DPProfessionMockApi.getProfessions(self)
	return self.firstProf["index"], self.secondProf["index"], 20, 21, 22, 23, 24 
end

-- Container Mock Api

_DPContainerMockApi = {}
_DPContainerMockApi.__index = _DPContainerMockApi

setmetatable(_DPContainerMockApi, {
  __call = function (cls)
    return cls.new()
  end,
})

function _DPContainerMockApi.new()
    local self = setmetatable({}, _DPContainerMockApi)
    self:_init()
    return self
end

function _DPContainerMockApi._init(self)
    self.texture = nil
	self.count = nil
	self.locked = nil
	self.quality = nil
	self.readable = nil
	self.lootable = nil
	self.link = nil
	self.isFiltered = nil
	self.sellable = nil
	self.item_id = nil
	self.i = 1
	self.j = 1
end

function _DPContainerMockApi.setBagSlot(self, ...)
    local values = ...
    self.texture = values["texture"] 
	self.count = values["count"]
	self.locked = values["locked"]
	self.quality = values["quality"]
	self.readable = values["readable"]
	self.lootable = values["lootable"]
	self.link = values["link"]
	self.isFiltered = values["isFiltered"]
	self.sellable = values["sellable"]
	self.item_id = values["itemId"]
	if values["i"] ~= nil then
		self.i = values["i"]
	end
	if values["j"] ~= nil then
		self.j = values["j"]
	end
end

function _DPContainerMockApi.returnBagSlot(self, i, j)
	if self.i == i and self.j == j then 
		return  self.texture, self.count, self.locked, self.quality, self.readable, self.lootable, self.link, self.isFiltered, self.sellable, self.item_id
	end
	return nil, nil, nil, nil, nil, nil, nil, nil, nil, nil
end

function _DPContainerMockApi.returnContainerNumSlot(self, i)
	local result = 32 -- Extra Container
	if i == -3 then
		result = 98 -- Reagent Container
	elseif i == -1 then
		result = 22 -- Bank Standard Container
	elseif i == 0 then
		result = 20 -- Standar Container
	end
	return result
end

-- Spell Book Mock Api

_DPSpellBookMockApi = {}
_DPSpellBookMockApi.__index = _DPSpellBookMockApi

setmetatable(_DPSpellBookMockApi, {
  __call = function (cls)
    return cls.new()
  end,
})

function _DPSpellBookMockApi.new()
    local self = setmetatable({}, _DPSpellBookMockApi)
    self:_init()
    return self
end

function _DPSpellBookMockApi._init(self)
	self.spellBook = {}
end

function _DPSpellBookMockApi.setSpellBook(self, spells_id)
	self.spellBook = {}
	for _, spell in ipairs(spells_id) do
		table.insert(self.spellBook, spell)
	end
end

function _DPSpellBookMockApi.haveSpellInBook(self, name)
	local haveSpell = nil
	for _, spell in ipairs(self.spellBook) do
		if name == _DPSpellApi(spell):getSpellName() then
			return name, "Found" 
		end
	end
	return haveSpell
end

bagClass = _DPContainerMockApi()
_spellBook = _DPSpellBookMockApi()
_profApi = _DPProfessionMockApi()