_DPSpellApi = {}
_DPSpellApi.__index = _DPSpellApi

setmetatable(_DPSpellApi, {
  __call = function (cls, index)
    return cls.new(index)
  end,
})

function _DPSpellApi.new(index)
    local self = setmetatable({}, _DPSpellApi)
    self:_init(index)
    return self
end

function _DPSpellApi._init(self, index)
	self._spellIndex = index
end

function _DPSpellApi.getSpellName(self)
    local spell = select(1, GetSpellInfo(self._spellIndex))
	if spell == nil then
		spell = self.unknowSpellName
	end
	return spell
end

function _DPSpellApi.isInSpellBook(self) 
	local exist = true
	if GetSpellBookItemInfo(self:getSpellName()) == nil then
		exist = false
	end
	return exist
end

_DPSpellApi.unknowSpellId = -1
_DPSpellApi.unknowSpellType = "?Unknow!"

_DPSpellApi.spellMilling = 51005
_DPSpellApi.spellDisenchant = 13262
_DPSpellApi.spellProspecting = 31252
-- Legion Mass Milling
_DPSpellApi.spellMassMillAethril = 209658
_DPSpellApi.spellMassMillDreamleaf = 209659
_DPSpellApi.spellMassMillFelwort = 209664
_DPSpellApi.spellMassMillFjarnskaggl = 209661
_DPSpellApi.spellMassMillFoxflower = 209660
_DPSpellApi.spellMassMillStarlightRose = 209662
_DPSpellApi.spellMassMillYserallineSeeds = 210116
_DPSpellApi.spellMassMillAstralGlory = 247861

-- Legion Mass Prospecting
_DPSpellApi.spellMassProspectFelslate = 225904
_DPSpellApi.spellMassProspecLeystone = 225902
_DPSpellApi.spellMassProspectEmpyrium = 247761

_DPSpellApi.unknowSpellName = "?Unknow!"