_DPProfessionApi = {}
_DPProfessionApi.__index = _DPProfessionApi

setmetatable(_DPProfessionApi, {
  __call = function (cls, index)
    return cls.new(index)
  end,
})

function _DPProfessionApi.new(index)
    local self = setmetatable({}, _DPProfessionApi)
    self:_init(index)
    return self
end

function _DPProfessionApi._init(self, index)
	self._profIndex = index
end

function _DPProfessionApi._getProfessionInfo(self)
	return GetProfessionInfo(self:_getProfessionIndex(self))
end

function _DPProfessionApi._getProfessionIndex(self)
	local index = select(self._profIndex, GetProfessions())
	if index == nil then
		index = self.indexNotExist
	end
	return index
end

function _DPProfessionApi.getName(self)
	return select(1, self:_getProfessionInfo())
end

function _DPProfessionApi.getIcon(self)
	return select(2, self:_getProfessionInfo())
end

function _DPProfessionApi.getLevel(self)
	return select(3, self:_getProfessionInfo())
end

function _DPProfessionApi.getMaxLevel(self)
	return select(4, self:_getProfessionInfo())
end

function _DPProfessionApi.getNumAbilities(self)
	return select(5, self:_getProfessionInfo())
end

function _DPProfessionApi.getSpellOffset(self)
	return select(6, self:_getProfessionInfo())
end

function _DPProfessionApi.getSkillId(self)
	return select(7, self:_getProfessionInfo())
end

function _DPProfessionApi.getSkillModifier(self)
	return select(8, self:_getProfessionInfo())
end

function _DPProfessionApi.getSpecIndex(self)
	return select(9, self:_getProfessionInfo())
end

function _DPProfessionApi.getSpecOffset(self)
	return select(10, self:_getProfessionInfo())
end

-- Profession skill constant id
_DPProfessionApi.skillEnchanting = 333
_DPProfessionApi.skilInscription = 773
_DPProfessionApi.skillJewelcrafting = 755

-- Profession Index value which do not exist
_DPProfessionApi.indexNotExist = -1