_DPContainerItemApi = {}
_DPContainerItemApi.__index = _DPContainerItemApi

setmetatable(_DPContainerItemApi, {
  __call = function (cls)
    return cls.new()
  end,
})

function _DPContainerItemApi.new()
    local self = setmetatable({}, _DPContainerItemApi)
    self:_init()
    return self
end

function _DPContainerItemApi._init(self)
	self.i = 0
	self.j = 0
end

function _DPContainerItemApi.setItemPos(self, i, j)
	self.i = i
	self.j = j
end

function _DPContainerItemApi.getTexture(self)
	local texture = select(1, GetContainerItemInfo(self.i, self.j))
	if texture == nil then
		texture = self.unknowTexture
	end
	return texture
end

function _DPContainerItemApi.getStackSize(self)
	local stack_size = select(2, GetContainerItemInfo(self.i, self.j))
	if stack_size == nil then
		stack_size = self.unknowStackSize
	end
	return stack_size
end

function _DPContainerItemApi.isLoked(self)
	local locked = select(3, GetContainerItemInfo(self.i, self.j))
	if locked == nil then
		locked = self.unknowFalse
	end
	return locked
end

function _DPContainerItemApi.isReadable(self)
	local readable = select(5, GetContainerItemInfo(self.i, self.j))
	if readable == nil then
		readable = self.unknowFalse
	end
	return readable
end

function _DPContainerItemApi.isLootable(self)
	local lootable = select(6, GetContainerItemInfo(self.i, self.j))
	if lootable == nil then
		lootable = self.unknowFalse
	end
	return lootable
end

function _DPContainerItemApi.getLink(self)
	local link = select(7, GetContainerItemInfo(self.i, self.j))
	--print(link)
	if link == nil then
		link = self.unknowLink
	end
	return link
end

function _DPContainerItemApi.isFiltered(self)
	local filtered = select(8, GetContainerItemInfo(self.i, self.j))
	if filtered == nil then
		filtered = self.unknowFalse
	end
	return filtered
end

function _DPContainerItemApi.isNotSellable(self)
	local sellable = select(9, GetContainerItemInfo(self.i, self.j))
	if sellable == nil then
		sellable = self.unknowFalse
	end
	return sellable
end

function _DPContainerItemApi.getItemId(self)
	local item_id = select(10, GetContainerItemInfo(self.i, self.j))
	if item_id == nil then
		item_id = self.unknowItemId
	end
	return item_id
end

-- GetItemInfo
function _DPContainerItemApi._getItemInfo(self)
	return GetItemInfo(self:getItemId())
end

function _DPContainerItemApi.getName(self)
	local name = select(1, self:_getItemInfo())
	if name == nil then
		name = self.unknowName
	end
	return name
end

function _DPContainerItemApi.getQuality(self)
	--local quality = select(3, self:_getItemInfo())
	local quality = select(4, GetContainerItemInfo(self.i, self.j))
	if quality == nil then
		quality = self.commonQuality
	end
	return quality
end

function _DPContainerItemApi.getILvl(self)
	--local ilvl = select(4, self:_getItemInfo())
	local ilvl = select(1, GetDetailedItemLevelInfo(self:getLink()))
	if ilvl == nil then
		ilvl = self.unknowIlvl
	end
	return ilvl
end

function _DPContainerItemApi.getReqLevel(self)
	local reqlevel = select(5, self:_getItemInfo())
	if reqlevel == nil then
		reqlevel = self.unknowReqLevel
	end
	return reqlevel
end

function _DPContainerItemApi.getClass(self)
	local class = select(6, self:_getItemInfo())
	if class == nil then
		class = self.unknowClass
	end
	return class
end

function _DPContainerItemApi.getSubClass(self)
	local subclass = select(7, self:_getItemInfo())
	if subclass == nil then
		subclass = self.unknowSubClass
	end
	return subclass
end

function _DPContainerItemApi.getMaxStackSize(self)
	local maxstack = select(8, self:_getItemInfo())
	if maxstack == nil then
		maxstack = self.unknowMaxStackSize
	end
	return maxstack
end

function _DPContainerItemApi.getEquipSlot(self)
	local equipslot = select(9, self:_getItemInfo())
	if equipslot == nil then
		equipslot = self.unknowEquipSlot
	end
	return equipslot
end

function _DPContainerItemApi.getVendorPrice(self)
	local vendor_price = select(11, self:_getItemInfo())
	if vendor_price == nil then
		vendor_price = self.unknowVendorPrice
	end
	return vendor_price
end

function _DPContainerItemApi.getItemClassId(self)
	local arg = select(12, self:_getItemInfo())
	if arg == nil then
		arg = self.unknowClassId
	end
	return arg
end

function _DPContainerItemApi.getItemSubClassId(self)
	local arg = select(13, self:_getItemInfo())
	if arg == nil then
		arg = self.unknowSubClassId
	end
	return arg
end

function _DPContainerItemApi.getUnknowArg(self)
	local arg = select(14, self:_getItemInfo())
	if arg == nil then
		arg = self.unknowArg
	end
	return arg
end
-- Static values 
_DPContainerItemApi.unknowTexture = -1
_DPContainerItemApi.unknowStackSize = -1
_DPContainerItemApi.unknowFalse = false
_DPContainerItemApi.commonQuality = 0
_DPContainerItemApi.unknowLink = "?Unknown!"
_DPContainerItemApi.unknowItemId = -1
_DPContainerItemApi.unknowName = "?Unknown!"
_DPContainerItemApi.unknowIlvl = -1
_DPContainerItemApi.unknowReqLevel = 999999999
_DPContainerItemApi.unknowClass = "?Unknown!"
_DPContainerItemApi.unknowClassId = -1
_DPContainerItemApi.unknowSubClassId = -1
_DPContainerItemApi.unknowSubClass = "?Unknown!"
_DPContainerItemApi.unknowMaxStackSize = -1
_DPContainerItemApi.unknowEquipSlot = "?Unknown!"
_DPContainerItemApi.unknowVendorPrice = -1
_DPContainerItemApi.unknowArg = -1