_DPMacroManager = {}
_DPMacroManager.__index = _DPMacroManager
_DPMacroManager.SUCCESS = "SUCCESS"
_DPMacroManager.FAILED = "FAILED"
_DPMacroManager.CREATED = "CREATED"
_DPMacroManager.DELETED = "DELETED"

-- Macro Names
_DPMacroManager.DISENCHANTUS = "Disenchantus"
_DPMacroManager.MILLINGUS = "Millingus"
_DPMacroManager.PROSPECTINGUS = "Prospectingus"
_DPMacroManager.MASSMILLINGUS = "MassMillingus"
_DPMacroManager.MASSPROSPECTINGUS = "MassProspectingus"

-- Macro Icons
_DPMacroManager.BLUE_BOWL = "237032"
_DPMacroManager.RED_BOWL = "237031"
_DPMacroManager.BLACK_MAGIC_HAND = "645142"
_DPMacroManager.SMALL_ROCK = "133287"
_DPMacroManager.GROUP_OF_SMALL_ROCKS = "134119"

setmetatable(_DPMacroManager, {
  __call = function (cls)
    return cls.new()
  end,
})

function _DPMacroManager.new(index)
    local self = setmetatable({}, _DPMacroManager)
    self:_init()
    return self
end

function _DPMacroManager._init(self)
    self.isCombatModeOn = false
end

function _DPMacroManager.macroCD(self, action, macro, icon, content)
    local result = self.SUCCESS
    if self:canCDMacro() then
	    if action == self.CREATED then
		    result = self:createMacro(macro, icon, "/click " .. content)
		elseif action == self.DELETED then
		    result = self:deleteMacro(macro)
		else
		    result = self.FAILED
		end
	else
	    result = self.FAILED
	end
	return result
end

function _DPMacroManager.deleteMacro(self, macro)
    local result = self.SUCCESS
	if self:macroExist(macro) then
		DeleteMacro(macro)
	else
		result = self.FAILED
	end
    return result
end

function _DPMacroManager.createMacro(self, macro, icon, content)
    local result = self.SUCCESS
	if self:macroExist(macro) == false then
		CreateMacro(macro, icon, content)
	else
		result = self.FAILED
	end
	return result
end

function _DPMacroManager.setCombatMode(self, combatModeOn)
   self.isCombatModeOn = combatModeOn
end

function _DPMacroManager.canCDMacro(self)
   return self.isCombatModeOn ~= true
end

function _DPMacroManager.macroExist(self, macro)
	return GetMacroInfo(macro) ~= nil
end

-- If macro frame is visible. Check name of method if refresh will not work
-- Check if MacroFrame is not nil. Bug reported by Niselma30
-- This part of code always assume that MacroFrame exist.
function _DPMacroManager.updateWoWMacroFrame(self)
	if self.isCombatModeOn == false then
	    -- Check if MacroFrame is not nil
	    if MacroFrame then
	        if MacroFrame:IsVisible() then
				MacroFrame:Hide()
				MacroFrame:Show()
            end
        end
    end
end