DestroyusProApi.oneItemOnStack = 1
DestroyusProApi.numberNotExist = 999999999
DestroyusProApi.unknowNumber = -1

DestroyusProApi.strToNumQuality = {}
DestroyusProApi.strToNumQuality["rare"] = 3
DestroyusProApi.strToNumQuality["epic"] = 4
DestroyusProApi.strToNumQuality["uncommon"] = 2
DestroyusProApi.strToNumQuality["common"] = 1

-- Temporary for translate TODO delete after translating 
DestroyusProApi.strToNumQuality["3"] = 3
DestroyusProApi.strToNumQuality["4"] = 4
DestroyusProApi.strToNumQuality["2"] = 2
DestroyusProApi.strToNumQuality["1"] = 1
-------------------------------------

DestroyusProApi.numToStrQuality = {}
DestroyusProApi.numToStrQuality[1] = "common"
DestroyusProApi.numToStrQuality[2] = "uncommon"
DestroyusProApi.numToStrQuality[3] = "rare"
DestroyusProApi.numToStrQuality[4] = "epic"


ExtraTabFun.setDefault(DestroyusProApi.strToNumQuality, DestroyusProApi.unknowNumber)
ExtraTabFun.setDefault(DestroyusProApi.numToStrQuality, "?unknow!")
							   
function DestroyusProApi.isItemNotSellable(self, isSellable)
	return not isSellable
end

function DestroyusProApi.isItemNotlooked(self, isLoked)
	return not isLoked
end

function DestroyusProApi.isQualityAllowed(self, quality)
	return _G["DestroyusProItemQualityValue"]["uncommon"] == quality or
	   _G["DestroyusProItemQualityValue"]["rare"] == quality or
	   _G["DestroyusProItemQualityValue"]["epic"] == quality
end

function DestroyusProApi.isNotUniqueItem(self, itemId, uniqueItemList)
	local result = true
	for	_, uniqueItemId in ipairs(uniqueItemList) do
		if uniqueItemId == itemId then
		    result = false
		break
		end
	end
	return result 
end

function DestroyusProApi.isOnlyOneMaxStack(self, maxStack)
	return maxStack == self.oneItemOnStack
end

function DestroyusProApi.isItem(self, classId, subClassId, equipSlot)
	return self:isWeapon(classId, subClassId) or 
	       self:isArmor(classId, subClassId) or
	       self:isMiscellaneous(classId, subClassId, equipSlot) or
		   self:isArtifactRelic(classId, subClassId)
end

function DestroyusProApi.isWeapon(self, classId, subClassId)
	return self.itemClassIdWeapon[classId] and 
	       self.itemSubClassIdWeapon[subClassId]
end

function DestroyusProApi.isArmor(self, classId, subClassId)
	return self.itemClassIdArmor[classId] and 
	       self.itemSubClassIdArmor[subClassId]
end

function DestroyusProApi.isMiscellaneous(self, classId, subClassId, equipSlot)
	return self.itemClassIdMiscellaneous[classId] and 
		   self.itemSubClassIdMiscellaneous[subClassId] and
	       self.itemInvTypeMiscellaneous[equipSlot]
end

function DestroyusProApi.isArtifactRelic(self, classId, subClassId)
	return self.itemClassIdGem[classId] and 
	       self.itemSubClassIdArtifactRelic[subClassId]
end

--[[ function DestroyusProApi.getItemProffLvlToDisUncommon(self, itemILvl)
	local result = 1
	if 1 <= itemILvl and itemILvl <= 20 then
		result = 1
	elseif 21 <= itemILvl and itemILvl <= 25 then
		result = 25
	elseif 26 <= itemILvl and itemILvl <= 30 then
		result = 50
	elseif 31 <= itemILvl and itemILvl <= 35 then
		result = 75
	elseif 36 <= itemILvl and itemILvl <= 40 then
		result = 100
	elseif 41 <= itemILvl and itemILvl <= 45 then
		result = 125
	elseif 46 <= itemILvl and itemILvl <= 50 then
		result = 150
	elseif 51 <= itemILvl and itemILvl <= 55 then
		result = 175
	elseif 56 <= itemILvl and itemILvl <= 60 then
		result = 200
	elseif 61 <= itemILvl and itemILvl <= 101 then
		result = 225
	elseif 102 <= itemILvl and itemILvl <= 120 then
		result = 275
	elseif 121 <= itemILvl and itemILvl <= 150 then
		result = 325
	elseif 151 <= itemILvl and itemILvl <= 271 then
		result = 350
	elseif 272 <= itemILvl and itemILvl <= 363 then
		result = 425
	elseif 364 <= itemILvl and itemILvl <= 469 then
		result = 475
	elseif 470 <= itemILvl then
		result = 1
	else
		result = self:getItemProffLvlToDisRest(itemILvl)		
	end
	return result
end

function DestroyusProApi.getItemProffLvlToDisRare(self, itemILvl)
	local result = 1
	if 1 <= itemILvl and itemILvl <= 25 then
		result = 25
	elseif 26 <= itemILvl and itemILvl <= 30 then
		result = 50
	elseif 31 <= itemILvl and itemILvl <= 35 then
		result = 75
	elseif 36 <= itemILvl and itemILvl <= 40 then
		result = 100
	elseif 41 <= itemILvl and itemILvl <= 45 then
		result = 125
	elseif 46 <= itemILvl and itemILvl <= 50 then
		result = 150
	elseif 51 <= itemILvl and itemILvl <= 55 then
		result = 175
	elseif 56 <= itemILvl and itemILvl <= 60 then
		result = 200
	elseif 61 <= itemILvl and itemILvl <= 99 then
		result = 225
	elseif 100 <= itemILvl and itemILvl <= 124 then
		result = 275
	elseif 125 <= itemILvl and itemILvl <= 218 then
		result = 325
	elseif 219 <= itemILvl and itemILvl <= 377 then
		result = 450
	elseif 378 <= itemILvl and itemILvl <= 424 then
		result = 525
	elseif 425 <= itemILvl and itemILvl <= 505 then
		result = 550
	elseif 506 <= itemILvl then
		result = 1
	else
		result = self:getItemProffLvlToDisRest(itemILvl)		
	end
	return result
end

function DestroyusProApi.getItemProffLvlToDisEpic(self, itemILvl)
	local result = 1
	if 1 <= itemILvl and itemILvl <= 35 then
		result = 25
	elseif 36 <= itemILvl and itemILvl <= 40 then
		result = 100
	elseif 41 <= itemILvl and itemILvl <= 45 then
		result = 125
	elseif 46 <= itemILvl and itemILvl <= 50 then
		result = 150
	elseif 51 <= itemILvl and itemILvl <= 55 then
		result = 175
	elseif 56 <= itemILvl and itemILvl <= 60 then
		result = 200
	elseif 61 <= itemILvl and itemILvl <= 99 then
		result = 225
	elseif 100 <= itemILvl and itemILvl <= 199 then
		result = 300
	elseif 200 <= itemILvl and itemILvl <= 350 then
		result = 375
	elseif 351 <= itemILvl and itemILvl <= 419 then
		result = 475
	elseif 420 <= itemILvl and itemILvl <= 629 then
		result = 575
	elseif 630 <= itemILvl then
		result = 1
	else
		result = self:getItemProffLvlToDisRest(itemILvl)	
	end
	return result
end ]]

function DestroyusProApi.getItemProffLvlToDisUncommon(self, itemILvl)
	local result = 1
    if itemILvl <= 0 then
		result = self:getItemProffLvlToDisRest(itemILvl)	
	end
	return result
end

function DestroyusProApi.getItemProffLvlToDisRare(self, itemILvl)
	local result = 1
    if itemILvl <= 0 then
		result = self:getItemProffLvlToDisRest(itemILvl)	
	end
	return result
end

function DestroyusProApi.getItemProffLvlToDisEpic(self, itemILvl)
	local result = 1
    if itemILvl <= 0 then
		result = self:getItemProffLvlToDisRest(itemILvl)	
	end
	return result
end

function DestroyusProApi.getItemProffLvlToDisRest(self, itemILvl)
	return self.numberNotExist
end

function DestroyusProApi.getItemProffLvlToDis(self, itemlvl, quality)
   if itemlvl == nil then
       itemlvl = DestroyusProApi.unknowNumber
   end
   local profLvLReq = self:getItemProffLvlToDisRest(itemlvl)
   if quality == self.strToNumQuality["uncommon"] then
		profLvLReq = self:getItemProffLvlToDisUncommon(itemlvl)
   elseif quality == self.strToNumQuality["rare"] then
		profLvLReq = self:getItemProffLvlToDisRare(itemlvl)
   elseif quality == self.strToNumQuality["epic"] then
		profLvLReq = self:getItemProffLvlToDisEpic(itemlvl)
   end 
   return profLvLReq
end

function DestroyusProApi.haveItemRequiredProfLvlDisenchant(self, profSkillId, itemlvl, quality)
    local profLvLReq = true
	if self.fp:getSkillId() == profSkillId then
		profLvLReq = self:getItemProffLvlToDis(itemlvl, quality) <= self.fp:getLevel()
	elseif self.sp:getSkillId() == profSkillId then
		profLvLReq = self:getItemProffLvlToDis(itemlvl, quality) <= self.sp:getLevel()
	else
		profLvLReq = false
	end
	return profLvLReq
end

function DestroyusProApi.isItemDisenchantable(self, i, j)
	self.cif:setItemPos(i,j)
	return self:isItem(self.cif:getItemClassId(), self.cif:getItemSubClassId(), self.cif:getEquipSlot()) and
	       self:isOnlyOneMaxStack(self.cif:getMaxStackSize()) and 
		   self:isNotUniqueItem(self.cif:getItemId(), self.itemsIdNotForDisenchant) and
		   self:isQualityAllowed(self.cif:getQuality()) and
		   self:isItemNotSellable(self.cif:isNotSellable()) and
		   self:isItemNotlooked(self.cif:isLoked()) and
		   self:haveItemRequiredProfLvlDisenchant(_DPProfessionApi.skillEnchanting,
		                self.cif:getILvl(), self.cif:getQuality())
end