DestroyusProApi.minRequireAmountInStack = 5
DestroyusProApi.minRequireAmountInStackForMasWork = 20 -- Mass Mill/Prospecting stack size

function DestroyusProApi.isQualityHerbAllowed(self, quality)
	return quality >= self.strToNumQuality["common"] and 
		   quality <= self.strToNumQuality["uncommon"] 
end

function DestroyusProApi.isItemNotConsumable(self, item_id)
	return not IsConsumableItem(item_id)
end

function DestroyusProApi.isStackAmountEnough(self, amount)
	return amount >= self.minRequireAmountInStack
end

function DestroyusProApi.isStackAmountEnoughForMasWork(self, amount)
	return amount >= self.minRequireAmountInStackForMasWork
end

function DestroyusProApi.isHerb(self, classId, subClassId)
	return self.itemClassIdTradeGoods[classId] and  self.itemSubClassIdHerbs[subClassId]
end

function DestroyusProApi.isOre(self, classId, subClassId, itemId)
	return self.itemClassIdTradeGoods[classId] and self.itemSubClassIdOres[subClassId] and 
	       self.itemClassOreId[itemId]
end

function DestroyusProApi.haveItemRequiredProfLvl(self, item_id, profSkillId, itemsIlvl)
    local profLvLReq = true
	if self.fp:getSkillId() == profSkillId then
		profLvLReq = itemsIlvl[item_id] <= self.fp:getLevel()
	elseif self.sp:getSkillId() == profSkillId then
		profLvLReq = itemsIlvl[item_id] <= self.sp:getLevel()
	else
		profLvLReq = false
	end
	return profLvLReq
end

function DestroyusProApi.isItemMillingable(self, i, j)
	self.cif:setItemPos(i,j)
	return self:isHerb(self.cif:getItemClassId(), self.cif:getItemSubClassId()) and
		   self:isQualityHerbAllowed(self.cif:getQuality()) and
		   self:isItemNotConsumable(self.cif:getItemId()) and 
		   self:isStackAmountEnough(self.cif:getStackSize()) and
		   self:isItemNotSellable(self.cif:isNotSellable()) and
		   self:isNotUniqueItem(self.cif:getItemId(), self.itemsIdNotForMilling) and
		   self:isItemNotlooked(self.cif:isLoked()) and
		   self:haveItemRequiredProfLvl(self.cif:getItemId(), _DPProfessionApi.skilInscription,
                        self.herbsIlvl)
end

function DestroyusProApi.isItemProspectingable(self, i, j)
	self.cif:setItemPos(i,j)
	return self:isOre(self.cif:getItemClassId(), self.cif:getItemSubClassId(), self.cif:getItemId()) and
		   self:isItemNotConsumable(self.cif:getItemId()) and 
		   self:isStackAmountEnough(self.cif:getStackSize()) and 
		   self:isItemNotSellable(self.cif:isNotSellable()) and
		   self:isItemNotlooked(self.cif:isLoked()) and
		   self:haveItemRequiredProfLvl(self.cif:getItemId(), _DPProfessionApi.skillJewelcrafting,
                        self.oresIlvl)
end

-- Legion Mass Milling
function DestroyusProApi.isItemMassMillingable(self, i, j, herbId)
	self.cif:setItemPos(i,j)
	return herbId == self.cif:getItemId() and
		   self:isHerb(self.cif:getItemClassId(), self.cif:getItemSubClassId()) and
		   self:isStackAmountEnoughForMasWork(self.cif:getStackSize()) and
		   self:isItemNotlooked(self.cif:isLoked()) and
		   self:haveItemRequiredProfLvl(self.cif:getItemId(), _DPProfessionApi.skilInscription,
                        self.herbsIlvl)			
end

-- Legion Mass Prospecting
function DestroyusProApi.isItemMassProspectingable(self, i, j, oreId)
	self.cif:setItemPos(i,j)
	return oreId == self.cif:getItemId() and
		   self:isOre(self.cif:getItemClassId(), self.cif:getItemSubClassId(), self.cif:getItemId()) and
		   self:isStackAmountEnoughForMasWork(self.cif:getStackSize()) and
		   self:isItemNotlooked(self.cif:isLoked()) and
		   self:haveItemRequiredProfLvl(self.cif:getItemId(), _DPProfessionApi.skillJewelcrafting,
                        self.oresIlvl)			
end