_DPFrameApi = {}
_DPFrameApi.__index = _DPFrameApi

setmetatable(_DPFrameApi, {
  __call = function (cls)
    return cls.new()
  end,
})

function _DPFrameApi.new()
    local self = setmetatable({}, _DPFrameApi)
    return self
end

function _DPFrameApi.getWidth(cls)
    w, _ = UIParent:GetSize()
	return w * 0.25625 -- Around 300px
end

function _DPFrameApi.getHeight(cls)
    _, h = UIParent:GetSize()
	return h * 0.3777777777777778 -- -- Around 300px
end

function _DPFrameApi.getTitleWidth(self)
 
	return self:getWidth() - 16
end

function _DPFrameApi.getTitleHeight(self)
 
	return self:getHeight() * 0.1 -- Around 30px
end


function _DPFrameApi.getSettingsHeight(self)
 
	return self:getHeight() * 0.8333333333333333 -- Around 30px
end

function _DPFrameApi.getSettingsWidth(self)
 
	return self:getWidth() * 0.8333333333333333 -- Around 30px
end

function _DPFrameApi.getSettingsHeight(self)
 
	return self:getHeight() * 0.6666666666666667 -- Around 30px
end

_DPFrameApi.BasicBackdrop = {
    bgFile = "Interface/Tooltips/UI-Tooltip-Background",
	edgeFile = "Interface/Tooltips/UI-Tooltip-Border",
	tile = true,
	tileSize = 16,
	edgeSize = 16,
	insets = {left=4, right=4, top=4, bottom=4}
   }
 
_DPFrameApi.BasicBackdropOptions = {
    bgFile = "Interface/Tooltips/UI-Tooltip-Background",
	edgeFile = "",
	tile = true,
	tileSize = 16,
	edgeSize = 16,
	insets = {left=4, right=4, top=4, bottom=4}
   }
 
_DPFrameApi.BasicBackdropPanel = {
    bgFile = "Interface/Tooltips/UI-Tooltip-Background",
	edgeFile = "Interface/Tooltips/UI-Tooltip-Border",
	tile = true,
	tileSize = 8,
	edgeSize = 8,
	insets = {left=2, right=2, top=2, bottom=2}
   }

local frameApi = _DPFrameApi()
-- Main Window Frame for Options
_DPMainSettingsFrame = CreateFrame("Frame", "DestroyusProMainSettingsFrame", UIParent)
_DPMainSettingsFrame:SetBackdrop(frameApi.BasicBackdrop)
_DPMainSettingsFrame:SetFrameStrata("BACKGROUND")
_DPMainSettingsFrame:SetWidth(frameApi:getWidth())
_DPMainSettingsFrame:SetHeight(frameApi:getHeight())
_DPMainSettingsFrame:SetBackdropColor(0, 0, 0)
_DPMainSettingsFrame:SetPoint("CENTER",0,0)
_DPMainSettingsFrame:SetScript("OnShow", _DPSettingsManagerUI.MainFrame_OnShow)

-- Confirm button for hide/accept settings
_DPMainSettingsFrame.okayButton =
                     CreateFrame("Button", "OkayButton",
					_DPMainSettingsFrame, "UIPanelButtonTemplate")
_DPMainSettingsFrame.okayButton:ClearAllPoints()
_DPMainSettingsFrame.okayButton:SetPoint("BOTTOMRIGHT", -8, 8)
_DPMainSettingsFrame.okayButton:SetSize(80 ,22)
_DPMainSettingsFrame.okayButton:SetText("Okay")
_DPMainSettingsFrame.okayButton:SetScript("OnClick", _DPSettingsManagerUI.OkayButton_OnClick)

-- Helper Container to hold rest od the content 
_DPMainSettingsFrame._DPTitleFrame = CreateFrame("Frame", "_DPTitleFrame", _DPMainSettingsFrame)
_DPTitleFrame = _DPMainSettingsFrame._DPTitleFrame
_DPTitleFrame.fonts = {}
_DPTitleFrame:SetBackdrop(_DPFrameApi.BasicBackdrop)
_DPTitleFrame:SetFrameStrata("BACKGROUND")
_DPTitleFrame:SetWidth(frameApi:getTitleWidth())
_DPTitleFrame:SetHeight(frameApi:getTitleHeight())
_DPTitleFrame:SetBackdropColor(0, 0, 0, 0)
_DPTitleFrame:SetPoint("TOPLEFT", 8, -8)

-- Current panel name as string to display 
_DPTitleFrame.fonts["WindowName"] =
              _DPTitleFrame:CreateFontString(nil, "ARTWORK")
_DPTitleFrame.fonts["WindowName"]:SetFont("Fonts\\FRIZQT__.TTF", 16)
_DPTitleFrame.fonts["WindowName"]:SetTextColor(0.5, 0.5, 0.5)
_DPTitleFrame.fonts["WindowName"]:SetAllPoints()
_DPTitleFrame.fonts["WindowName"]:SetText("DestroyusPro 0.1.9.1")

-- Frame holding settings buttons and fonts related to them
_DPMainSettingsFrame._DPOptionFrame = CreateFrame("Frame", "_DPOptionFrame", _DPMainSettingsFrame)
_DPOptionFrame = _DPMainSettingsFrame._DPOptionFrame
_DPOptionFrame.fonts = {}
_DPOptionFrame:SetWidth(frameApi:getSettingsWidth())
_DPOptionFrame:SetHeight(frameApi:getSettingsHeight())
_DPOptionFrame:SetBackdrop(_DPFrameApi.BasicBackdropOptions)
_DPOptionFrame:SetFrameStrata("BACKGROUND")
_DPOptionFrame:SetBackdropColor(0, 0, 0, 0)
_DPOptionFrame:SetPoint("TOPLEFT", 8, -(frameApi:getTitleHeight()+8))
_DPOptionFrame:SetPoint("BOTTOMRIGHT", 8, 32)
_DPOptionFrame:SetPoint("TOPRIGHT", -8, 8)
_DPOptionFrame.fonts["Settings"] =
               _DPOptionFrame:CreateFontString(nil, "ARTWORK")
_DPOptionFrame.fonts["Settings"]:SetFont("Fonts\\FRIZQT__.TTF", 10)
_DPOptionFrame.fonts["Settings"]:SetTextColor(1, 1, 1)
_DPOptionFrame.fonts["Settings"]:SetText("Settings")
_DPOptionFrame.fonts["Settings"]:SetPoint("TOPLEFT", 8, -8)

-- Create Panel Frame for options objects
_DPOptionFrame.panel = CreateFrame("Frame", "_DPOptionPanel", _DPOptionFrame)
_DPOptionFrame.panel.checkButtons = {}
_DPOptionFrame.panel.fonts = {}
_DPOptionFrame.panel:SetBackdrop(frameApi.BasicBackdropPanel)
_DPOptionFrame.panel:SetFrameStrata("BACKGROUND")
_DPOptionFrame.panel:SetWidth(frameApi:getSettingsWidth())
_DPOptionFrame.panel:SetHeight(frameApi:getSettingsHeight())
_DPOptionFrame.panel:SetBackdropColor(0, 0, 0)
_DPOptionFrame.panel:SetPoint("TOPLEFT", 4, -18)
_DPOptionFrame.panel:SetPoint("BOTTOMRIGHT", 4, 4)
_DPOptionFrame.panel:SetPoint("TOPRIGHT", -4, 4)

-- Font string Disenchantus Options
_DPOptionFrame.panel.fonts["DisenchantusQuality"] =
               _DPOptionFrame.panel:CreateFontString(nil, "ARTWORK")
_DPOptionFrame.panel.fonts["DisenchantusQuality"]:SetFont("Fonts\\FRIZQT__.TTF", 10)
_DPOptionFrame.panel.fonts["DisenchantusQuality"]:SetTextColor(1, 1, 1) 
_DPOptionFrame.panel.fonts["DisenchantusQuality"]:SetText("Quality of items for disenchantus")
_DPOptionFrame.panel.fonts["DisenchantusQuality"]:SetPoint("TOPLEFT", 8, -52)

-- Disable DestroyusPro Printouts 
_DPOptionFrame.panel.checkButtons["DisablePrintout"] =
               CreateFrame("CheckButton", "DisablePrintout",
			  _DPOptionFrame.panel, "UICheckButtonTemplate")
_DPOptionFrame.panel.checkButtons["DisablePrintout"]:ClearAllPoints()
_DPOptionFrame.panel.checkButtons["DisablePrintout"]:SetPoint("TOPLEFT", 4, -4)
_G[_DPOptionFrame.panel.checkButtons["DisablePrintout"]:GetName().."Text"]:SetText("Disable printout")
_DPOptionFrame.panel.checkButtons["DisablePrintout"]:SetScript("OnClick",
                     _DPSettingsManagerUI.changeStatePrintout_OnClick)

-- Change quality to uncommon Disenchantus
_DPOptionFrame.panel.checkButtons["UncommonQualityS"] =
               CreateFrame("CheckButton", "UncommonQualityS",
			  _DPOptionFrame.panel, "UICheckButtonTemplate")
_DPOptionFrame.panel.checkButtons["UncommonQualityS"]:ClearAllPoints()
_DPOptionFrame.panel.checkButtons["UncommonQualityS"]:SetPoint("TOPLEFT", 4, -65)
_G[_DPOptionFrame.panel.checkButtons["UncommonQualityS"]:GetName().."Text"]:SetText("Uncommon")
_DPOptionFrame.panel.checkButtons["UncommonQualityS"]:SetScript("OnClick",
               _DPSettingsManagerUI.Uncommon_OnClick)
			   
-- Change quality to rare Disenchantus
_DPOptionFrame.panel.checkButtons["RareQualityS"] =
               CreateFrame("CheckButton", "RareQualityS",
			  _DPOptionFrame.panel, "UICheckButtonTemplate")
_DPOptionFrame.panel.checkButtons["RareQualityS"]:ClearAllPoints()
_DPOptionFrame.panel.checkButtons["RareQualityS"]:SetPoint("TOPLEFT", (frameApi:getSettingsWidth()/2.2), -65)
_G[_DPOptionFrame.panel.checkButtons["RareQualityS"]:GetName().."Text"]:SetText("Rare")
_DPOptionFrame.panel.checkButtons["RareQualityS"]:SetScript("OnClick",
               _DPSettingsManagerUI.Rare_OnClick)

-- Change quality to epic Disenchantus
_DPOptionFrame.panel.checkButtons["EpicQualityS"] =
               CreateFrame("CheckButton", "EpicQualityS",
			  _DPOptionFrame.panel, "UICheckButtonTemplate")
_DPOptionFrame.panel.checkButtons["EpicQualityS"]:ClearAllPoints()
_DPOptionFrame.panel.checkButtons["EpicQualityS"]:SetPoint("TOPLEFT", (frameApi:getSettingsWidth()/1.2), -65)
_G[_DPOptionFrame.panel.checkButtons["EpicQualityS"]:GetName().."Text"]:SetText("Epic")
_DPOptionFrame.panel.checkButtons["EpicQualityS"]:SetScript("OnClick",
               _DPSettingsManagerUI.Epic_OnClick)

-- Create Macro Buttons. 
_DPOptionFrame.panel.fonts["CreateMacro"] =
               _DPOptionFrame.panel:CreateFontString(nil, "ARTWORK")
_DPOptionFrame.panel.fonts["CreateMacro"]:SetFont("Fonts\\FRIZQT__.TTF", 10)
_DPOptionFrame.panel.fonts["CreateMacro"]:SetTextColor(1, 1, 1) 
_DPOptionFrame.panel.fonts["CreateMacro"]:SetText("Create Macro")
_DPOptionFrame.panel.fonts["CreateMacro"]:SetPoint("TOPLEFT", 8, -110)

_DPOptionFrame.panel.checkButtons["MassMillingus"] =
               CreateFrame("CheckButton", "MassMillingusMacro",
			  _DPOptionFrame.panel, "UICheckButtonTemplate")
_DPOptionFrame.panel.checkButtons["MassMillingus"]:ClearAllPoints()
_DPOptionFrame.panel.checkButtons["MassMillingus"]:SetPoint("TOPLEFT", 4, -120)
_G[_DPOptionFrame.panel.checkButtons["MassMillingus"]:GetName().."Text"]:SetText("MassMillingus")
_DPOptionFrame.panel.checkButtons["MassMillingus"]:SetScript("OnClick",
               _DPSettingsManagerUI.MassMilingLegion_OnClick)
-- Disenchantus Macro Create Button
_DPOptionFrame.panel.checkButtons["Disenchantus"] =
               CreateFrame("CheckButton", "DisenchantusMacro",
			  _DPOptionFrame.panel, "UICheckButtonTemplate")
_DPOptionFrame.panel.checkButtons["Disenchantus"]:ClearAllPoints()
_DPOptionFrame.panel.checkButtons["Disenchantus"]:SetPoint("TOPLEFT", (frameApi:getSettingsWidth()/2.2), -120)
_G[_DPOptionFrame.panel.checkButtons["Disenchantus"]:GetName().."Text"]:SetText("Disenchantus")
_DPOptionFrame.panel.checkButtons["Disenchantus"]:SetScript("OnClick",
               _DPSettingsManagerUI.Disenchanting_OnClick)

-- Millingus Macro Create Button
_DPOptionFrame.panel.checkButtons["Millingus"] =
               CreateFrame("CheckButton", "MillingusMacro",
			  _DPOptionFrame.panel, "UICheckButtonTemplate")
_DPOptionFrame.panel.checkButtons["Millingus"]:ClearAllPoints()
_DPOptionFrame.panel.checkButtons["Millingus"]:SetPoint("TOPLEFT", (frameApi:getSettingsWidth()/1.2), -120)
_G[_DPOptionFrame.panel.checkButtons["Millingus"]:GetName().."Text"]:SetText("Millingus")
_DPOptionFrame.panel.checkButtons["Millingus"]:SetScript("OnClick",
               _DPSettingsManagerUI.Miling_OnClick)

			 
-- Prospectingus Macro Create Button
_DPOptionFrame.panel.checkButtons["Prospectingus"] =
               CreateFrame("CheckButton", "ProspectingusMacro",
               _DPOptionFrame.panel, "UICheckButtonTemplate")
_DPOptionFrame.panel.checkButtons["Prospectingus"]:ClearAllPoints()
_DPOptionFrame.panel.checkButtons["Prospectingus"]:SetPoint("TOPLEFT", 4, -145)
_G[_DPOptionFrame.panel.checkButtons["Prospectingus"]:GetName().."Text"]:SetText("Prospectingus")   
_DPOptionFrame.panel.checkButtons["Prospectingus"]:SetScript("OnClick",
               _DPSettingsManagerUI.Prospecting_OnClick)

-- MassProspectingus Macro Create Button
_DPOptionFrame.panel.checkButtons["MassProspectingus"] =
                     CreateFrame("CheckButton", "MassProspectingusMacro", 
					_DPOptionFrame.panel, "UICheckButtonTemplate")
_DPOptionFrame.panel.checkButtons["MassProspectingus"]:ClearAllPoints()
_DPOptionFrame.panel.checkButtons["MassProspectingus"]:SetPoint("TOPLEFT", (frameApi:getSettingsWidth()/2.2), -145)
_G[_DPOptionFrame.panel.checkButtons["MassProspectingus"]:GetName().."Text"]:SetText("MassProspectingus")
_DPOptionFrame.panel.checkButtons["MassProspectingus"]:SetScript("OnClick",
               _DPSettingsManagerUI.MassProspectingLegion_OnClick)

			  
-- Hide Frame
_DPMainSettingsFrame:Hide()
_DPMainSettingsFrame:RegisterEvent("UPDATE_MACROS")
_DPMainSettingsFrame:RegisterEvent("PLAYER_REGEN_DISABLED")
_DPMainSettingsFrame:RegisterEvent("PLAYER_REGEN_ENABLED")
_DPMainSettingsFrame:SetScript("OnEvent", _DPSettingsManagerUI.MainFrame_MacroUpdate)