-- GNU GENERAL PUBLIC LICENSE Version 3
-- Created by Monk3yDev 
-- I will be so happy when this addon become popular.
-- If you want use code from DestroyusPro
-- please let me know about it monk3ydev at gmail dot com 

DestroyusProMain = {}
DestroyusProMain.cif = _DPContainerItemApi()
DestroyusProMain.macroMgr = _DPMacroManager()

DestroyusProMain.buttonNameMilling = "ClickMeForWorkMilling"
DestroyusProMain.buttonNameDisenchanting = "ClickMeForWorkDisenchanting"
DestroyusProMain.buttonNameProspecting = "ClickMeForWorkProspecting"
DestroyusProMain.buttonNameMillingLegion = "ClickMeForWorkMassMillingLegion"
DestroyusProMain.buttonNameMassProspectingLegion = "ClickMeForWorkMassProspectingLegion"

DestroyusPro = DestroyusProApi()

local frame = CreateFrame("Frame", "DestroyusPro")
frame:RegisterEvent("ADDON_LOADED")

-- Milling --
local ClickMeForWorkMilling = CreateFrame("Button", DestroyusProMain.buttonNameMilling, UIParent, "SecureActionButtonTemplate")
ClickMeForWorkMilling:SetAttribute("type", "macro")
ClickMeForWorkMilling:SetAttribute("macrotext", "")
ClickMeForWorkMilling:RegisterEvent("PLAYER_REGEN_DISABLED")
ClickMeForWorkMilling:RegisterEvent("PLAYER_REGEN_ENABLED")

-- Disenchant --
local ClickMeForWorkDisenchanting = CreateFrame("Button", DestroyusProMain.buttonNameDisenchanting, UIParent, "SecureActionButtonTemplate")
ClickMeForWorkDisenchanting:SetAttribute("type", "macro")
ClickMeForWorkDisenchanting:SetAttribute("macrotext", "")
ClickMeForWorkDisenchanting:RegisterEvent("PLAYER_REGEN_DISABLED")
ClickMeForWorkDisenchanting:RegisterEvent("PLAYER_REGEN_ENABLED")

-- Prospecting --
local ClickMeForWorkProspecting = CreateFrame("Button", DestroyusProMain.buttonNameProspecting, UIParent, "SecureActionButtonTemplate")
ClickMeForWorkProspecting:SetAttribute("type", "macro")
ClickMeForWorkProspecting:SetAttribute("macrotext", "")
ClickMeForWorkProspecting:RegisterEvent("PLAYER_REGEN_DISABLED")
ClickMeForWorkProspecting:RegisterEvent("PLAYER_REGEN_ENABLED")

-- Mass Milling legion --
local ClickMeForWorkMassMillingLegion = CreateFrame("Button", DestroyusProMain.buttonNameMillingLegion, UIParent, "SecureActionButtonTemplate")
ClickMeForWorkMassMillingLegion:SetAttribute("type", "macro")
ClickMeForWorkMassMillingLegion:SetAttribute("macrotext", "")
ClickMeForWorkMassMillingLegion:RegisterEvent("PLAYER_REGEN_DISABLED")
ClickMeForWorkMassMillingLegion:RegisterEvent("PLAYER_REGEN_ENABLED")

-- Mass Prospecting legion --
local ClickMeForWorkMassProspectingLegion = CreateFrame("Button", DestroyusProMain.buttonNameMassProspectingLegion, UIParent, "SecureActionButtonTemplate")
ClickMeForWorkMassProspectingLegion:SetAttribute("type", "macro")
ClickMeForWorkMassProspectingLegion:SetAttribute("macrotext", "")
ClickMeForWorkMassProspectingLegion:RegisterEvent("PLAYER_REGEN_DISABLED")
ClickMeForWorkMassProspectingLegion:RegisterEvent("PLAYER_REGEN_ENABLED")

local function prettyLoadQuality()
    local msg = "Quality of items:"
    local allDisabled = true
	if _G["DestroyusProItemQualityValue"]["uncommon"] == DestroyusProApi.strToNumQuality["uncommon"] then
	   msg = msg.." *"..DestroyusProApi.numToStrQuality[_G["DestroyusProItemQualityValue"]["uncommon"]]
	   allDisabled = false
	end
	if _G["DestroyusProItemQualityValue"]["rare"] == DestroyusProApi.strToNumQuality["rare"] then
	   msg = msg.." *"..DestroyusProApi.numToStrQuality[_G["DestroyusProItemQualityValue"]["rare"]]
	   allDisabled = false
	end
	if _G["DestroyusProItemQualityValue"]["epic"] == DestroyusProApi.strToNumQuality["epic"] then
	   msg = msg.." *"..DestroyusProApi.numToStrQuality[_G["DestroyusProItemQualityValue"]["epic"]]
	   allDisabled = false
	end
	if allDisabled then
	   msg = msg.." ".."Disabled. Check settings"
	end
	return msg
end

local function prettyLoadMesssage()
		print("DestroyusPro Addon successfully loaded. " .. prettyLoadQuality())
end

DestroyusProMain.isInCombatMode = false
DestroyusProMain.macroMgr:setCombatMode(false)

local function loadAddonData(self, event, arg1)
    if event == "ADDON_LOADED" and arg1 == 'DestroyusPro' then
		if _G["DestroyusProInitDataFirstLoad"] == nil then
			_G["DestroyusProInitDataFirstLoad"] = true
			_G["DestroyusProItemQualityValue"] = DestroyusProApi.strToNumQuality["uncommon"]
			_G["DestroyusProPrintOutState"] = true
		end
		if _G["DestroyusProInitDataLoadDPVersionWithForm0_1_7"] == nil then
		    _G["DestroyusProItemQualityValue"] = {}
			_G["DestroyusProItemQualityValue"]["uncommon"] = DestroyusProApi.strToNumQuality["uncommon"]
			_G["DestroyusProItemQualityValue"]["rare"] = DestroyusProApi.unknowNumber
			_G["DestroyusProItemQualityValue"]["epic"] = DestroyusProApi.unknowNumber
			_G["DestroyusProInitDataLoadDPVersionWithForm0_1_7"] = true
		end
		prettyLoadMesssage()
	end
end

local function combatMode(self, event, arg1)
	if event == "PLAYER_REGEN_DISABLED" then
		DestroyusProMain.isInCombatMode = true
		DestroyusProMain.macroMgr:setCombatMode(true)
		return nil
	end
	if event == "PLAYER_REGEN_ENABLED" then
		DestroyusProMain.isInCombatMode = false
		DestroyusProMain.macroMgr:setCombatMode(false)
		return nil
	end
end

local function preClickMacroButton(self, event)
	if DestroyusProMain.isInCombatMode == false and DestroyusProMain.buttonCanWorkEnable == true then
	    DestroyusProMain.canLootItemsAfterWork = false
        DestroyusProMain.itemFoundAndWorkStarted = false
		local result = DestroyusProMain.findItemToWork(_DPSpellApi.spellDisenchant)
		self:SetAttribute("macrotext", DestroyusProMain.createMacroUsage(_DPSpellApi.spellDisenchant, result)) --Disenchant
		DestroyusProMain.printResults(_DPSpellApi.spellDisenchant, result)
	end
end

local function preClickMacroButtonMilling(self, event)
	if DestroyusProMain.isInCombatMode == false and DestroyusProMain.buttonCanWorkEnable == true then
	    DestroyusProMain.canLootItemsAfterWork = false
        DestroyusProMain.itemFoundAndWorkStarted = false
		local result = DestroyusProMain.findItemToWork(_DPSpellApi.spellMilling)
		self:SetAttribute("macrotext", DestroyusProMain.createMacroUsage(_DPSpellApi.spellMilling , result)) -- Milling
		DestroyusProMain.printResults(_DPSpellApi.spellMilling , result)
	end
end

local function preClickMacroButtonProspecting(self, event)
	if DestroyusProMain.isInCombatMode == false and DestroyusProMain.buttonCanWorkEnable == true then
	    DestroyusProMain.canLootItemsAfterWork = false
        DestroyusProMain.itemFoundAndWorkStarted = false
		local result = DestroyusProMain.findItemToWork(_DPSpellApi.spellProspecting)
    	self:SetAttribute("macrotext", DestroyusProMain.createMacroUsage(_DPSpellApi.spellProspecting, result)) -- Prospecting
		DestroyusProMain.printResults(_DPSpellApi.spellProspecting, result)
	end
end

local function preClickMacroButtonMassMillingLegion(self, event)
	if DestroyusProMain.isInCombatMode == false and DestroyusProMain.buttonCanWorkEnable == true then
	    DestroyusProMain.canLootItemsAfterWork = false
        DestroyusProMain.itemFoundAndWorkStarted = false
		local result, spellForCast = DestroyusProMain.findItemToWorkMassProf(_DPProfessionApi.skilInscription)
		self:SetAttribute("macrotext", DestroyusProMain.createMacroUsage(spellForCast, result)) -- Mass Milling Legion
		DestroyusProMain.printResults(spellForCast, result)
	end
end

local function preClickMacroButtonMassProspectingLegion(self, event)
	if DestroyusProMain.isInCombatMode == false and DestroyusProMain.buttonCanWorkEnable == true then
		DestroyusProMain.canLootItemsAfterWork = false
        DestroyusProMain.itemFoundAndWorkStarted = false
		local result, spellForCast = DestroyusProMain.findItemToWorkMassProf(_DPProfessionApi.skillJewelcrafting)
		self:SetAttribute("macrotext", DestroyusProMain.createMacroUsage(spellForCast, result)) -- Mass Prospecting Legion
		DestroyusProMain.printResults(spellForCast, result)
	end
end

local function postClickMacroButton(self, event)
	if DestroyusProMain.isInCombatMode == false then
		self:SetAttribute("macrotext", "")
	end
end

local function postClickMacroButtonMilling(self, event)
	if DestroyusProMain.isInCombatMode == false then
		self:SetAttribute("macrotext", "")
	end
end

local function postClickMacroButtonProspecting(self, event)
	if DestroyusProMain.isInCombatMode == false then
		self:SetAttribute("macrotext", "")
	end
end

local function postClickMacroButtonMassMillingLegion(self, event)
	if DestroyusProMain.isInCombatMode == false then
		self:SetAttribute("macrotext", "")
	end
end

local function postClickMacroButtonMassProspectingLegion(self, event)
	if DestroyusProMain.isInCombatMode == false then
		self:SetAttribute("macrotext", "")
	end
end

frame:SetScript("OnEvent", loadAddonData)
-- Set protection to do not create macro in combat
ClickMeForWorkDisenchanting:SetScript("OnEvent", combatMode)
ClickMeForWorkMilling:SetScript("OnEvent", combatMode)
ClickMeForWorkProspecting:SetScript("OnEvent", combatMode)
ClickMeForWorkMassMillingLegion:SetScript("OnEvent", combatMode)
ClickMeForWorkMassProspectingLegion:SetScript("OnEvent", combatMode)

-- Create macro
ClickMeForWorkDisenchanting:SetScript("PreClick", preClickMacroButton)
ClickMeForWorkMilling:SetScript("PreClick", preClickMacroButtonMilling)
ClickMeForWorkProspecting:SetScript("PreClick", preClickMacroButtonProspecting)
ClickMeForWorkMassMillingLegion:SetScript("PreClick", preClickMacroButtonMassMillingLegion)
ClickMeForWorkMassProspectingLegion:SetScript("PreClick", preClickMacroButtonMassProspectingLegion)

-- Clear macro
ClickMeForWorkDisenchanting:SetScript("PostClick", postClickMacroButton)
ClickMeForWorkMilling:SetScript("PostClick", postClickMacroButtonMilling)
ClickMeForWorkProspecting:SetScript("PostClick", postClickMacroButtonProspecting)
ClickMeForWorkMassMillingLegion:SetScript("PostClick", postClickMacroButtonMassMillingLegion)
ClickMeForWorkMassProspectingLegion:SetScript("PostClick", postClickMacroButtonMassProspectingLegion)

function DestroyusProMain.isItemDisenchantableInBag(i, j)
	return DestroyusProMain.isItemDisenchantable(i, j)
end

function DestroyusProMain.isItemMillingableInBag(i, j)
	return DestroyusProMain.isItemMillingable(i, j)
end

function DestroyusProMain.isItemProspectingableInBag(i, j)
	return DestroyusProMain.isItemProspectingable(i, j)
end

-- Legion Mass Milling 
function DestroyusProMain.isAethrilMassMillingableInBag(i, j)
	return DestroyusProMain.isItemMassMillingable(i, j, DestroyusProMain.itemId["Aethril"])
end

function DestroyusProMain.isDreamleafMassMillingableInBag(i, j)
	return DestroyusProMain.isItemMassMillingable(i, j, DestroyusProMain.itemId["Dreamleaf"])
end

function DestroyusProMain.isFelwortMillingableInBag(i, j)
	return DestroyusProMain.isItemMassMillingable(i, j, DestroyusProMain.itemId["Felwort"])
end

function DestroyusProMain.isFjarnskagglMillingableInBag(i, j)
	return DestroyusProMain.isItemMassMillingable(i, j, DestroyusProMain.itemId["Fjarnskaggl"])
end

function DestroyusProMain.isFoxflowerMillingableInBag(i, j)
	return DestroyusProMain.isItemMassMillingable(i, j, DestroyusProMain.itemId["Foxflower"])
end

function DestroyusProMain.isStarlightRoseMillingableInBag(i, j)
	return DestroyusProMain.isItemMassMillingable(i, j, DestroyusProMain.itemId["Starlight Rose"])
end

function DestroyusProMain.isYserallineMillingableInBag(i, j)
	return DestroyusProMain.isItemMassMillingable(i, j, DestroyusProMain.itemId["Yseralline Seed"])
end

function DestroyusProMain.isAstralGloryMillingableInBag(i, j)
	return DestroyusProMain.isItemMassMillingable(i, j, DestroyusProMain.itemId["Astral Glory"])
end

-- Legion Mass Prospecting
function DestroyusProMain.isFelslateProspectingableInBag(i, j)
	return DestroyusProMain.isItemMassProspectingable(i, j, DestroyusProMain.itemId["Felslate"])
end

function DestroyusProMain.isLeystoneProspectingableInBag(i, j)
	return DestroyusProMain.isItemMassProspectingable(i, j, DestroyusProMain.itemId["Leystone Ore"])
end

function DestroyusProMain.isEmpyriumProspectingableInBag(i, j)
	return DestroyusProMain.isItemMassProspectingable(i, j, DestroyusProMain.itemId["Empyrium"])
end

DestroyusProMain.isItemProffesionInBag = {}
DestroyusProMain.isItemProffesionInBag[_DPSpellApi.spellDisenchant] = DestroyusProMain.isItemDisenchantableInBag
DestroyusProMain.isItemProffesionInBag[_DPSpellApi.spellMilling ] = DestroyusProMain.isItemMillingableInBag
DestroyusProMain.isItemProffesionInBag[_DPSpellApi.spellProspecting] = DestroyusProMain.isItemProspectingableInBag
-- Mass Milling Legion 
DestroyusProMain.isItemProffesionInBag[_DPSpellApi.spellMassMillAethril] = DestroyusProMain.isAethrilMassMillingableInBag
DestroyusProMain.isItemProffesionInBag[_DPSpellApi.spellMassMillDreamleaf] = DestroyusProMain.isDreamleafMassMillingableInBag
DestroyusProMain.isItemProffesionInBag[_DPSpellApi.spellMassMillFelwort] = DestroyusProMain.isFelwortMillingableInBag
DestroyusProMain.isItemProffesionInBag[_DPSpellApi.spellMassMillFjarnskaggl] = DestroyusProMain.isFjarnskagglMillingableInBag
DestroyusProMain.isItemProffesionInBag[_DPSpellApi.spellMassMillFoxflower] = DestroyusProMain.isFoxflowerMillingableInBag
DestroyusProMain.isItemProffesionInBag[_DPSpellApi.spellMassMillStarlightRose] = DestroyusProMain.isStarlightRoseMillingableInBag
DestroyusProMain.isItemProffesionInBag[_DPSpellApi.spellMassMillYserallineSeeds] = DestroyusProMain.isYserallineMillingableInBag
DestroyusProMain.isItemProffesionInBag[_DPSpellApi.spellMassMillAstralGlory] = DestroyusProMain.isAstralGloryMillingableInBag
-- Mass Prospecting Legion 
DestroyusProMain.isItemProffesionInBag[_DPSpellApi.spellMassProspectFelslate] = DestroyusProMain.isFelslateProspectingableInBag
DestroyusProMain.isItemProffesionInBag[_DPSpellApi.spellMassProspecLeystone] = DestroyusProMain.isLeystoneProspectingableInBag
DestroyusProMain.isItemProffesionInBag[_DPSpellApi.spellMassProspectEmpyrium] = DestroyusProMain.isEmpyriumProspectingableInBag


function DestroyusProMain.findItemToWork(proffesion)
    local result = {itemFound=false, i=0 ,j=0, link=_DPContainerItemApi.unknowLink}
	--for i = REAGENTBANK_CONTAINER, (NUM_BAG_SLOTS + NUM_BANKBAGSLOTS) do -- -3, 11
	for i = 0, NUM_BAG_SLOTS do
		for j = 1, GetContainerNumSlots(i) do 
			if DestroyusProMain.isItemProffesionInBag[proffesion](i,j) then
				DestroyusProMain.cif:setItemPos(i, j)
				result["itemFound"] = true
				result["i"] = i
				result["j"] = j
				result["link"] = DestroyusProMain.cif:getLink()
				break
			end 
		end 
	end
	return result
end


-- Create macro string for profession 
function DestroyusProMain.createMacroUsage(spell_id, result)
	local macroStr = ""
	if result["itemFound"] then
		local spellName = _DPSpellApi(spell_id):getSpellName()
		local bagIndex = ""
		if result["i"] == BANK_CONTAINER then
			bagIndex = tostring((DestroyusProMain.basicBankSlotNumIndex-1)+result["j"]) -- /use #
		elseif result["i"] == REAGENTBANK_CONTAINER then
			bagIndex = tostring((DestroyusProMain.reagentBankSlotNumIndex-1)+result["j"]) -- /use #
		else
			bagIndex = string.format("%d %d", result["i"], result["j"]) -- /use # #
		end
		macroStr = string.format("/cast %s\n/use %s", spellName, bagIndex)
		DestroyusProMain.itemFoundAndWorkStarted = true -- Move this line from creating macro function
	end
	return macroStr
end

-- Print results of the destroyed item from the bag
function DestroyusProMain.printResults(spell_id, result)
	local spellName = _DPSpellApi(spell_id):getSpellName()
	if result["itemFound"] then
		if _G["DestroyusProPrintOutState"] ~= false then
			print("".. spellName .." => " .. result["link"])
		end
	else
		local msg = ""
		if spell_id == _DPSpellApi.spellDisenchant then
			msg = msg .. prettyLoadQuality()
		end
		print(string.format("Nothing to %s! %s", spellName, msg))
	end
end

function DestroyusProMain.isItemDisenchantable(i, j)
	return DestroyusPro:isItemDisenchantable(i, j)
end

function DestroyusProMain.isItemMillingable(i, j)
	return DestroyusPro:isItemMillingable(i, j)
end

function DestroyusProMain.isItemProspectingable(i, j)
	return DestroyusPro:isItemProspectingable(i, j)
end

function DestroyusProMain.isItemMassMillingable(i, j, herb_id)
	return DestroyusPro:isItemMassMillingable(i, j, herb_id)
end

function DestroyusProMain.isItemMassProspectingable(i, j, ore_id)
	return DestroyusPro:isItemMassProspectingable(i, j, ore_id)
end

function DestroyusProMain.collectMassWorkSpells(spells)
	local collectedSpells = {}
	for _, spell_id in ipairs(spells) do
		if _DPSpellApi(spell_id):isInSpellBook() == true then
			table.insert(collectedSpells, spell_id)
		end
	end
	return collectedSpells
end

function DestroyusProMain.findItemToWorkMassProf(prof)
	local collectedSpells = {}
	local spellForCast = _DPSpellApi.unknowSpellId
	local result = {itemFound=false, i=0 ,j=0, link=_DPContainerItemApi.unknowLink}
	
	if prof == _DPProfessionApi.skilInscription then 
		collectedSpells = DestroyusProMain.collectMassWorkSpells(DestroyusProMain.spellsToFindMassMillLegion)
	    spellForCast = _DPSpellApi.spellMilling  -- Default Message Nothing to Milling
	elseif prof == _DPProfessionApi.skillJewelcrafting then 
		collectedSpells = DestroyusProMain.collectMassWorkSpells(DestroyusProMain.spellsToFindMassProspectingLegion)
	    spellForCast = _DPSpellApi.spellProspecting  -- Default Message Nothing to Prospecting
	end
	
	for _, spell_id in ipairs(collectedSpells) do
		result = DestroyusProMain.findItemToWork(spell_id)
		if result["itemFound"] == true then
			spellForCast = spell_id
			break
		end
	end
	return result, spellForCast
end

function DestroyusProMain.changeStateForPrintout(state)
	_G["DestroyusProPrintOutState"] = state
end

function DestroyusProMain.changeQualityDisenchanting(quality, value)
	_G["DestroyusProItemQualityValue"][quality] = value
end

-- Frame Manager For Looting after Destroyuspro work
DestroyusProMain.lootManagerFrame = CreateFrame("Frame", "DestroyusProLootManagerFrame")
DestroyusProMain.lootManagerFrame:RegisterEvent("LOOT_OPENED")
DestroyusProMain.lootManagerFrame:RegisterEvent("LOOT_CLOSED")
DestroyusProMain.lootManagerFrame:RegisterEvent("UNIT_SPELLCAST_SUCCEEDED")
DestroyusProMain.lootManagerFrame:RegisterEvent("UNIT_SPELLCAST_START")
DestroyusProMain.lootManagerFrame:RegisterEvent("UNIT_SPELLCAST_FAILED")
DestroyusProMain.lootManagerFrame:RegisterEvent("UNIT_SPELLCAST_INTERRUPTED")

DestroyusProMain.canLootItemsAfterWork = false
DestroyusProMain.itemFoundAndWorkStarted = false
DestroyusProMain.buttonCanWorkEnable = true

function DestroyusProMain.DestroyusProLootAfterIsDPSkill(spellId)
      local result = false
      if _DPSpellApi.spellMilling == spellId or
         _DPSpellApi.spellDisenchant == spellId or
         _DPSpellApi.spellProspecting == spellId or
         _DPSpellApi.spellMassMillAethril == spellId or
         _DPSpellApi.spellMassMillDreamleaf == spellId or
         _DPSpellApi.spellMassMillFelwort == spellId or
         _DPSpellApi.spellMassMillFjarnskaggl == spellId or
         _DPSpellApi.spellMassMillFoxflower == spellId or
         _DPSpellApi.spellMassMillStarlightRose == spellId or
         _DPSpellApi.spellMassMillYserallineSeeds == spellId or
         _DPSpellApi.spellMassMillAstralGlory == spellId or
         _DPSpellApi.spellMassProspectFelslate == spellId or
		 _DPSpellApi.spellMassProspecLeystone == spellId or 
		 _DPSpellApi.spellMassProspectEmpyrium == spellId then
		 result = true
	  end
	  return result
end

function DestroyusProMain.DestroyusProLootAfterWork(self, event, arg1, arg2, arg3, arg4, arg5)
    -- Check if spell from DestroyusPro are invoke with successfully
	-- Add protection flag for not invoking more pressing attempts on the macro buttons
	if DestroyusProMain.itemFoundAndWorkStarted and arg1 == "player" and  event == "UNIT_SPELLCAST_START" 
	   and DestroyusProMain.DestroyusProLootAfterIsDPSkill(arg5)  then
		-- Disable work flag
		DestroyusProMain.buttonCanWorkEnable = false
	    return nil
	end

    -- Spell Cast was successfull. Flag with item found is cleared and loot flag is set to true
	-- Second flag will allow collect loot during event with loot
	if DestroyusProMain.itemFoundAndWorkStarted and arg1 == "player" and  event == "UNIT_SPELLCAST_SUCCEEDED" 
	   and DestroyusProMain.DestroyusProLootAfterIsDPSkill(arg5)  then
		DestroyusProMain.itemFoundAndWorkStarted = false
	    DestroyusProMain.canLootItemsAfterWork = true
	    return nil
	end
	
    -- Spell Cast was failed or become interrupted. Flag with item found and loot flag is cleared.
	-- Protection flag for invoking press is enabled 
	if DestroyusProMain.itemFoundAndWorkStarted and arg1 == "player" and 
	  (event == "UNIT_SPELLCAST_INTERRUPTED" or event == "UNIT_SPELLCAST_FAILED") and 
	   DestroyusProMain.DestroyusProLootAfterIsDPSkill(arg5) then
	    DestroyusProMain.itemFoundAndWorkStarted = false
		DestroyusProMain.canLootItemsAfterWork = false
		-- Disable work
		DestroyusProMain.buttonCanWorkEnable = true
		return nil
	end

    -- Spell Cast was failed or become interrupted. Flag with loot is cleared.
	-- Protection flag for invoking press is enabled 
	if DestroyusProMain.canLootItemsAfterWork and event == "LOOT_OPENED" then
	    DestroyusProMain.lootItemsAfterWork()
	    DestroyusProMain.canLootItemsAfterWork = false
	    return nil
	end

    -- In case of the strange behaves all flags are set to thier defaults behaves
	-- when loot is closed
	if event == "LOOT_CLOSED" then
		DestroyusProMain.itemFoundAndWorkStarted = false
		DestroyusProMain.canLootItemsAfterWork = false
		-- Disable work
		DestroyusProMain.buttonCanWorkEnable = true
	end
end

function DestroyusProMain.lootItemsAfterWork()
	for i = 1, GetNumLootItems() do 
	    LootSlot(i)
	end
end

DestroyusProMain.lootManagerFrame:SetScript("OnEvent", DestroyusProMain.DestroyusProLootAfterWork)
---  End of Looter

DestroyusProMain.spellsToFindMassMillLegion = 
   {_DPSpellApi.spellMassMillAethril,
	_DPSpellApi.spellMassMillDreamleaf,
	_DPSpellApi.spellMassMillFelwort,
	_DPSpellApi.spellMassMillFjarnskaggl,
	_DPSpellApi.spellMassMillFoxflower,
	_DPSpellApi.spellMassMillStarlightRose,
	_DPSpellApi.spellMassMillYserallineSeeds,
	_DPSpellApi.spellMassMillAstralGlory} -- _DPSpellApi.spellMilling }
	
DestroyusProMain.spellsToFindMassProspectingLegion =
   {_DPSpellApi.spellMassProspectFelslate,
	_DPSpellApi.spellMassProspecLeystone,
	_DPSpellApi.spellMassProspectEmpyrium} -- _DPSpellApi.spellProspecting }
	
DestroyusProMain.itemId = {}
DestroyusProMain.itemId["Aethril"] = 124101
DestroyusProMain.itemId["Dreamleaf"] = 124102
DestroyusProMain.itemId["Felwort"] = 124106
DestroyusProMain.itemId["Fjarnskaggl"] = 124104
DestroyusProMain.itemId["Foxflower"] = 124103
DestroyusProMain.itemId["Starlight Rose"] = 124105
DestroyusProMain.itemId["Yseralline Seed"] = 128304
DestroyusProMain.itemId["Astral Glory"] = 151565
DestroyusProMain.itemId["Leystone Ore"] = 123918
DestroyusProMain.itemId["Felslate"] = 123919
DestroyusProMain.itemId["Empyrium"] = 151564

DestroyusProMain.basicBankSlotNumIndex = 40
DestroyusProMain.reagentBankSlotNumIndex = 87