local TankHealerMarkFrame = CreateFrame("Frame", "TankHealerMarkFrame")
TankHealerMarkFrame:RegisterEvent("PLAYER_ENTERING_WORLD")
TankHealerMarkFrame:RegisterEvent("GROUP_ROSTER_UPDATE")
TankHealerMarkFrame:RegisterEvent("INSPECT_READY")

TankHealerMarkFrame:SetScript("OnEvent", function(self, event, ...)
	if IsInRaid() then 
		return
	elseif IsInGroup() then
		local ROLEMARKS={["TANK"]=2,["HEALER"]=5}
		for i=1,5 do 
			local role=UnitGroupRolesAssigned("party"..i)
			if ROLEMARKS[role]then 
				SetRaidTarget("party"..i,ROLEMARKS[role])
				--print(i, role)
			end 
		end
		local currentSpecID, currentSpecName = GetSpecializationInfo(GetSpecialization())
		--print("Your current spec:", currentSpecName)
		--print("Your current spec ID:", currentSpecID)
		local roleToken = GetSpecializationRoleByID(currentSpecID)
		--print(roleToken)
		if ROLEMARKS[roleToken]then 
			SetRaidTarget("player", ROLEMARKS[roleToken])
		end
	else
		SetRaidTarget("player", 0)
	end
end)