--------------------------
-- SavedVariables Setup --
--------------------------
local DejaAuras, private = ...
local L = private.L 				--localization

private.defaults = {
	-- Holds all default settings hierarchically.
}

private.defaults.dadefaults = {
	-- Holds all default settings for DejaAuras, specifically.
}

local buffsize
local defaultAuraMask

----------------------------
-- Saved Variables Loader --
----------------------------
local loader = CreateFrame("Frame")
	loader:RegisterEvent("ADDON_LOADED")
	loader:SetScript("OnEvent", function(self, event, arg1)
		if event == "ADDON_LOADED" and arg1 == "DejaAuras" then
			local function initDB(db, dadefaults)
				if type(db) ~= "table" then db = {} end
				if type(dadefaults) ~= "table" then return db end
				for k, v in pairs(dadefaults) do
					if type(v) == "table" then
						db[k] = initDB(db[k], v)
					elseif type(v) ~= type(db[k]) then
						db[k] = v
					end
				end
				return db
			end

			DejaAurasDBPC = initDB(DejaAurasDBPC, private.defaults)
			private.db = DejaAurasDBPC

			self:UnregisterEvent("ADDON_LOADED")
		end
	end)

DejaAuras = {};

local _, private = ...
	private.defaults.dadefaults.optpanelDefaults = {
		point = "RIGHT", 
		relativeTo = "UIParent", 
		relativePoint = "RIGHT", 
		xOffset = 0, 
		yOffset = 0,
	}	
	
-----------------------
-- DA Options Panel --
-----------------------
DejaAuras.panel = CreateFrame( "Frame", "DejaAurasPanel", UIParent );
DejaAuras.panel.name = "DejaAuras";
InterfaceOptions_AddCategory(DejaAuras.panel);

local datitle=CreateFrame("Frame", "DATitle", DejaAurasPanel)
	datitle:SetPoint("TOPLEFT", 5, -5)
	datitle:SetScale(2.0)
	datitle:SetWidth(150)
	datitle:SetHeight(50)
	datitle:Show()

local datitleFS = datitle:CreateFontString(nil, "OVERLAY", "GameFontNormal")
	datitleFS:SetText('|cff00c0ffDejaAuras|r')
	datitleFS:SetPoint("TOPLEFT", 0, 0)
	datitleFS:SetFont("Fonts\\FRIZQT__.TTF", 10)
	
local daresetcheck = CreateFrame("Button", "DAResetButton", DejaAurasPanel, "UIPanelButtonTemplate")
	daresetcheck:ClearAllPoints()
	daresetcheck:SetPoint("BOTTOMLEFT", 5, 5)
	daresetcheck:SetScale(1.25)

	local LOCALE = GetLocale()
		--print (LOCALE)

	if (LOCALE == "ptBR" or LOCALE == "frFR" or LOCALE == "deDE") then
		--print ("ptBR, frFR, deDE = 175")
		LOCALE = 175
	else
		--print ("enUS = 125")
		LOCALE = 125
	end

	daresetcheck:SetWidth(LOCALE)

	daresetcheck:SetHeight(30)
	_G[daresetcheck:GetName() .. "Text"]:SetText(L["Reset to Default"])
	daresetcheck:SetScript("OnClick", function(self, button, down)
 		private.db.dadefaults = private.defaults.dadefaults;
		ReloadUI();
	end)

local DABuffLockFrame = CreateFrame("Frame", "DABuffLockFrame", UIParent)

	DABuffLockFrame:SetClampedToScreen(1)
	DABuffLockFrame:SetFrameStrata("BACKGROUND")
	DABuffLockFrame:SetFrameLevel("1")
	DABuffLockFrame:SetPoint("BOTTOMLEFT", UIParent, "BOTTOMLEFT")
	DABuffLockFrame:SetPoint("TOPRIGHT", UIParent, "TOPRIGHT")
	DABuffLockFrame:Hide()
	
dalockcheck = CreateFrame("CheckButton", "DejaAurasLockAll", DejaAurasPanel, "InterfaceOptionsCheckButtonTemplate")
	dalockcheck:ClearAllPoints()
	dalockcheck:SetPoint("TOPLEFT", 25, -35)
	dalockcheck:SetScale(1.25)
	_G[dalockcheck:GetName() .. "Text"]:SetText("Lock all frames")
	dalockcheck.tooltipText = 'Checked locks all DejaAuras frames. Unchecked unlocks all DejaAuras frames.' --Creates a tooltip on mouseover.
	dalockcheck:SetChecked(true)
	
-- Lock/Unlock Frames
	dalockcheck:SetScript("OnClick", function(self,button,down) 
		if self:GetChecked(true) then
			DABuffLockFrame:Hide()
		else
			DABuffLockFrame:Show()
		end
	end)

	--Create DABuffLockFrame's Text Strings (So the user knows it is unlocked.)
	DABuffLockFrame.text = DABuffLockFrame:CreateFontString("BuffName","OVERLAY","GameTooltipText")
	DABuffLockFrame.text:SetPoint("CENTER", DABuffLockFrame, "CENTER", 0, (GetScreenHeight()/3))
	DABuffLockFrame.text:SetFont("Fonts\\MORPHEUS.TTF", 48, "THINOUTLINE")
	DABuffLockFrame.text:SetTextColor(0, 192, 255, 0.7);
	DABuffLockFrame.text:SetText("DejaAuras");

	
-- Alignment Grid, originally eAlign by Eurytus

local gridSize
local DA_GridLine

local function DA_Align()
	if DA_GridLine then
		DA_GridLine:Hide()
		DA_GridLine = nil		
	end
	DA_GridLine = CreateFrame('Frame', nil, UIParent) 
	DA_GridLine:SetAllPoints(UIParent)
	local w = (GetScreenWidth() / gridSize)
	local h = (GetScreenHeight() / gridSize)
	
	--Vertical Red
	local vert = DA_GridLine:CreateTexture(nil, 'BACKGROUND')
	vert:SetWidth(3)
	vert:SetColorTexture(0, 192, 255, 0.7)
	vert:SetPoint('TOP', DA_GridLine, 'TOP', -1, 0)
	vert:SetPoint('BOTTOM', DA_GridLine, 'BOTTOM', 1, 0)
	--Vertical Positive
	for i = 1, w do
		local t = DA_GridLine:CreateTexture(nil, 'BACKGROUND')
		t:SetWidth(2)
		t:SetColorTexture(0, 0, 0, 0.5)
		t:SetPoint('TOP', DA_GridLine, 'TOP', (i * gridSize), 0)
		t:SetPoint('BOTTOM', DA_GridLine, 'BOTTOM', (i * gridSize), 0)
	end
	--Vertical Negative
	for i = 1, w do
		local t = DA_GridLine:CreateTexture(nil, 'BACKGROUND')
		t:SetWidth(2)
		t:SetColorTexture(0, 0, 0, 0.5)
		t:SetPoint('TOP', DA_GridLine, 'TOP', (-i * gridSize), 0)
		t:SetPoint('BOTTOM', DA_GridLine, 'BOTTOM', (-i * gridSize), 0)
	end
	
	--Horizontal Red
	local horiz = DA_GridLine:CreateTexture(nil, 'BACKGROUND')
	horiz:SetHeight(3)
	horiz:SetColorTexture(0, 192, 255, 0.7)
	horiz:SetPoint('LEFT', DA_GridLine, 'LEFT', 0, -1)
	horiz:SetPoint('RIGHT', DA_GridLine, 'RIGHT', 0, 1)
	--Horizontal Positive
	for i = 1, h do
		local t = DA_GridLine:CreateTexture(nil, 'BACKGROUND')
		t:SetHeight(2)
		t:SetColorTexture(0, 0, 0, 0.5)
		t:SetPoint('LEFT', DA_GridLine, 'LEFT', 0, (i * gridSize))
		t:SetPoint('RIGHT', DA_GridLine, 'RIGHT', 0, (i * gridSize))
	end
	--Horizontal Negative
	for i = 1, h do
		local t = DA_GridLine:CreateTexture(nil, 'BACKGROUND')
		t:SetHeight(2)
		t:SetColorTexture(0, 0, 0, 0.5)
		t:SetPoint('LEFT', DA_GridLine, 'LEFT', 0, (-i * gridSize))
		t:SetPoint('RIGHT', DA_GridLine, 'RIGHT', 0, (-i * gridSize))
	end	
end

local function DA_AlignToggle()
	if DA_GridLine then
		DA_GridLine:Hide()
		DA_GridLine = nil	
	else
		DA_Align()
	end
end

---------------------
-- DA Slash Setup --
---------------------
local RegisteredEvents = {};
local daslash = CreateFrame("Frame", "DejaAurasSlash", UIParent)

daslash:SetScript("OnEvent", function (self, event, ...) 
	if (RegisteredEvents[event]) then 
	return RegisteredEvents[event](self, event, ...) 
	end
end)

function RegisteredEvents:ADDON_LOADED(event, addon, ...)
	if (addon == "DejaAuras") then
		SLASH_DejaAuras1 = (L["/da"])
		SlashCmdList["DejaAuras"] = function (msg, editbox)
			DejaAuras.SlashCmdHandler(msg, editbox)	
	end
	--	DEFAULT_CHAT_FRAME:AddMessage("DejaAuras loaded successfully. For options: Esc>Interface>AddOns or type /da.",0,192,255)
	end
end

for k, v in pairs(RegisteredEvents) do
	daslash:RegisterEvent(k)
end

function DejaAuras.ShowHelp()
	print(L[" "])
	print(L["DejaAuras Quick commands list (/da):"])
	print(L["  /da (u)nlock: Unlocks all DejaAuras frames."])
	print(L["  /da (l)ock: Locks all DejaAuras frames."])
	print(L["  /da (a)lign: Displays the DejaAuras alignment grid."])
	print(L["  /da (c)onfig: Opens DejaAuras Interface Options menu."])
	print(L["  /da reset:  Removes (deletes) all DejaAuras."])
	print(L['Example: Typing "/da u" or "/da unlock" will lock DejaAuras.'])
	print(L[" "])
end

function DejaAuras.SetConfigToDefaults()
	print(L["Resetting config to defaults"])
	DejaAurasDBPC = DefaultConfig
	RELOADUI()
end

function DejaAuras.GetConfigValue(key)
	return DejaAurasDBPC[key]
end

function DejaAuras.PrintPerformanceData()
	UpdateAddOnMemoryUsage()
	local mem = GetAddOnMemoryUsage("DejaAuras")
	print(L["DejaAuras is currently using "] .. mem .. L[" kbytes of memory"])
	collectgarbage(collect)
	UpdateAddOnMemoryUsage()
	mem = GetAddOnMemoryUsage("DejaAuras")
	print(L["DejaAuras is currently using "] .. mem .. L[" kbytes of memory after garbage collection"])
end

function DejaAuras.SlashCmdHandler(msg, editbox)
	--print("command is " .. msg .. "\n")
	if (string.lower(msg) == L["unlock"]) then
		DABuffLockFrame:Show()
		dalockcheck:SetChecked(false)
	elseif (string.lower(msg) == L["u"]) then
		DABuffLockFrame:Show()
		dalockcheck:SetChecked(false)		
	elseif (string.lower(msg) == L["lock"]) then
		DABuffLockFrame:Hide()
		dalockcheck:SetChecked(true)
	elseif (string.lower(msg) == L["l"]) then
		DABuffLockFrame:Hide()
		dalockcheck:SetChecked(true)
	elseif (string.lower(msg) == L["align"]) then
		DA_AlignToggle()
	elseif (string.lower(msg) == L["a"]) then
		DA_AlignToggle()
	elseif (string.lower(msg) == L["config"]) then
		InterfaceOptionsFrame_OpenToCategory("DejaAuras");
		InterfaceOptionsFrame_OpenToCategory("DejaAuras");
		InterfaceOptionsFrame_OpenToCategory("DejaAuras");
	elseif (string.lower(msg) == L["c"]) then
		InterfaceOptionsFrame_OpenToCategory("DejaAuras");
		InterfaceOptionsFrame_OpenToCategory("DejaAuras");
		InterfaceOptionsFrame_OpenToCategory("DejaAuras");
	elseif (string.lower(msg) == L["reset"]) then
		DejaAurasDBPC = private.defaults;
		ReloadUI();		
	elseif (string.lower(msg) == L["dumpconfig"]) then
		print(L["With defaults"])
		for k,v in pairs(DADefaultConfig) do
			print(k,DejaAuras.GetConfigValue(k))
		end
		print(L["Direct table"])
		for k,v in pairs(DADefaultConfig) do
			print(k,v)
		end
	elseif (string.lower(msg) == L["perf"]) then
		DejaAuras.PrintPerformanceData()
	else
		DejaAuras.ShowHelp()
	end
end
	SlashCmdList["DEJAAURAS"] = DejaAuras.SlashCmdHandler;

	private.defaults.dadefaults.Aura_Grid_SizeSliderSetScale = {
		defaultAuraSize = 36,
		defaultGridSize = 36,
	}	

--Background IOP Preview Buff Display Background
local DA_IOPPreviewBuffBackgroundFrame = CreateFrame("Frame", "DA_IOPPreviewBuffBackgroundFrame", DejaAurasPanel)
DA_IOPPreviewBuffBackgroundFrame:RegisterEvent("PLAYER_LOGIN")
DA_IOPPreviewBuffBackgroundFrame:SetSize(216,216)
DA_IOPPreviewBuffBackgroundFrame:SetPoint("TOPRIGHT", DejaAurasPanel, "TOPRIGHT", -48, -72)
			
DA_IOPPreviewBuffBackgroundFrame.icon = DA_IOPPreviewBuffBackgroundFrame:CreateTexture(nil,"BACKGROUND")
DA_IOPPreviewBuffBackgroundFrame.icon:SetAllPoints(DA_IOPPreviewBuffBackgroundFrame)
DA_IOPPreviewBuffBackgroundFrame.icon:SetColorTexture(0, 192, 255, 0.7)

--IOP Preview Buff Display
local DA_IOPPreviewBuffFrame = CreateFrame("Button", "DA_IOPPreviewBuffFrame", DA_IOPPreviewBuffBackgroundFrame, "SecureActionButtonTemplate")
DA_IOPPreviewBuffFrame:RegisterEvent("PLAYER_LOGIN")
DA_IOPPreviewBuffFrame:RegisterForClicks("AnyUp")
DA_IOPPreviewBuffFrame:SetSize(200,200)
DA_IOPPreviewBuffFrame:SetPoint("CENTER", DA_IOPPreviewBuffBackgroundFrame, "CENTER", 0, 0)
			
DA_IOPPreviewBuffFrame.icon = DA_IOPPreviewBuffFrame:CreateTexture(nil,"HIGH")
DA_IOPPreviewBuffFrame.icon:SetAllPoints(DA_IOPPreviewBuffFrame)

DA_IOPPreviewBuffFrame.cooldown = CreateFrame("Cooldown", "DA_IOPPreviewBuffFrame", DA_IOPPreviewBuffFrame, "CooldownFrameTemplate")
DA_IOPPreviewBuffFrame.cooldown:SetEdgeTexture("Interface\\AddOns\\DejaAuras\\Textures\\SetEdgeTexture_Clear");
DA_IOPPreviewBuffFrame.cooldown:SetHideCountdownNumbers(false); -- Hides the countdown numbers regardless of the cvar setting

DA_IOPPreviewBuffFrame.cooldown.charge = DA_IOPPreviewBuffFrame.cooldown:CreateFontString("FontString","OVERLAY","GameTooltipText")
DA_IOPPreviewBuffFrame.cooldown.charge:SetFont("Fonts\\FRIZQT__.TTF", 12, "THINOUTLINE")
DA_IOPPreviewBuffFrame.cooldown.charge:SetTextColor(1, 1, 1);
DA_IOPPreviewBuffFrame.cooldown.charge:SetPoint("BOTTOMRIGHT", DA_IOPPreviewBuffFrame, "BOTTOMRIGHT", 0, 0)
DA_IOPPreviewBuffFrame.cooldown.charge:SetText("1")


DA_IOPPreviewBuffFrame.cooldown.stack = DA_IOPPreviewBuffFrame.cooldown:CreateFontString("FontString","OVERLAY","GameTooltipText")
DA_IOPPreviewBuffFrame.cooldown.stack:SetPoint("BOTTOMRIGHT", DA_IOPPreviewBuffFrame, "BOTTOMRIGHT",  0, 0)

DA_IOPPreviewBuffFrame:SetScript("OnEvent", function(self, event, ...)
	buffsize = private.db.dadefaults.Aura_Grid_SizeSliderSetScale.defaultAuraSize
	defaultAuraMask = private.db.dadefaults.setDefaultAuraMask.defaultAuraMask
	local englishFaction = UnitFactionGroup("player")
	if (englishFaction == "Horde") then
		DA_IOPPreviewBuffFrame.icon:SetTexture("Interface\\Calendar\\UI-Calendar-Event-PVP01")
	else
		DA_IOPPreviewBuffFrame.icon:SetTexture("Interface\\Calendar\\UI-Calendar-Event-PVP02")
	end
	DA_IOPPreviewBuffFrame:SetSize(buffsize, buffsize)
	DA_IOPPreviewBuffFrame.icon:SetMask(defaultAuraMask)
	DA_IOPPreviewBuffFrame.cooldown:SetSwipeTexture(defaultAuraMask)
	DA_IOPPreviewBuffFrame.cooldown:SetScale(buffsize / 40)
end)

-- Default Aura Size Slider:
local DefaultAuraSizeSlider = CreateFrame("Slider", "DefaultAuraSizeSlider", DejaAurasPanel, "OptionsSliderTemplate")
DefaultAuraSizeSlider:RegisterEvent("PLAYER_LOGIN")
DefaultAuraSizeSlider:RegisterEvent("PLAYER_ENTERING_WORLD")
DefaultAuraSizeSlider:RegisterEvent("ADDON_LOADED")
DefaultAuraSizeSlider:SetPoint("TOP", DA_IOPPreviewBuffBackgroundFrame, "BOTTOM", 0, -36)
DefaultAuraSizeSlider:SetWidth(216)
DefaultAuraSizeSlider:SetHeight(10)
DefaultAuraSizeSlider:SetOrientation('HORIZONTAL')
DefaultAuraSizeSlider:SetMinMaxValues(20, 200)
DefaultAuraSizeSlider.minValue, DefaultAuraSizeSlider.maxValue = DefaultAuraSizeSlider:GetMinMaxValues() 
DefaultAuraSizeSlider:SetValueStep(2)
DefaultAuraSizeSlider:SetObeyStepOnDrag(true)

DefaultAuraSizeSlider.tooltipText = 'Scale the default Aura size.' --Creates a tooltip on mouseover.

getglobal(DefaultAuraSizeSlider:GetName() .. 'Low'):SetText(DefaultAuraSizeSlider.minValue); --Sets the left-side slider text (default is "Low").
getglobal(DefaultAuraSizeSlider:GetName() .. 'High'):SetText(DefaultAuraSizeSlider.maxValue); --Sets the right-side slider text (default is "High").

DefaultAuraSizeSlider:Show()
		
DefaultAuraSizeSlider:SetScript("OnEvent", function(self, event, arg1)
	if event == "PLAYER_LOGIN" then
	local auraSlideValue = private.db.dadefaults.Aura_Grid_SizeSliderSetScale.defaultAuraSize
		self:SetValue(auraSlideValue)
		getglobal(DefaultAuraSizeSlider:GetName() .. 'Text'):SetFormattedText("Default Aura Size = (%.0f)", (auraSlideValue)); --Sets the "title" text (top-centre of slider).
	end
end)

DefaultAuraSizeSlider:SetScript("OnValueChanged", function(self, value) 
local auraSlideValue = DefaultAuraSizeSlider:GetValue()
	getglobal(DefaultAuraSizeSlider:GetName() .. 'Text'):SetFormattedText("Default Aura Size = (%.0f)", (auraSlideValue)); --Sets the "title" text (top-centre of slider).
	private.db.dadefaults.Aura_Grid_SizeSliderSetScale.defaultAuraSize = auraSlideValue
	DA_IOPPreviewBuffFrame:SetSize(auraSlideValue, auraSlideValue)
	DA_IOPPreviewBuffFrame.cooldown:SetScale(auraSlideValue / 40)
end)

-- Default Grid Size Slider:
local DefaultGridSizeSlider = CreateFrame("Slider", "DefaultGridSizeSlider", DejaAurasPanel, "OptionsSliderTemplate")
	DefaultGridSizeSlider:RegisterEvent("PLAYER_LOGIN")
	DefaultGridSizeSlider:RegisterEvent("PLAYER_ENTERING_WORLD")
	DefaultGridSizeSlider:RegisterEvent("ADDON_LOADED")
	DefaultGridSizeSlider:SetPoint("TOP", DA_IOPPreviewBuffBackgroundFrame, "BOTTOM", 0, -108)
	DefaultGridSizeSlider:SetWidth(216)
	DefaultGridSizeSlider:SetHeight(10)
	DefaultGridSizeSlider:SetOrientation('HORIZONTAL')
	DefaultGridSizeSlider:SetMinMaxValues(20, 200)
	DefaultGridSizeSlider.minValue, DefaultGridSizeSlider.maxValue = DefaultGridSizeSlider:GetMinMaxValues() 
	DefaultGridSizeSlider:SetValueStep(2)
	DefaultGridSizeSlider:SetObeyStepOnDrag(true)

	DefaultGridSizeSlider.tooltipText = 'Scale the default Grid size' --Creates a tooltip on mouseover.

	getglobal(DefaultGridSizeSlider:GetName() .. 'Low'):SetText(DefaultGridSizeSlider.minValue); --Sets the left-side slider text (default is "Low").
	getglobal(DefaultGridSizeSlider:GetName() .. 'High'):SetText(DefaultGridSizeSlider.maxValue); --Sets the right-side slider text (default is "High").

	DefaultGridSizeSlider:Show()
			
	DefaultGridSizeSlider:SetScript("OnEvent", function(self, event, arg1)
		if event == "PLAYER_LOGIN" then
		local gridSlideValue = private.db.dadefaults.Aura_Grid_SizeSliderSetScale.defaultGridSize
			self:SetValue(gridSlideValue)
			gridSize = gridSlideValue
			if DA_GridLine then
				DA_GridLine:Hide()
				DA_GridLine = nil	
			end
			getglobal(DefaultGridSizeSlider:GetName() .. 'Text'):SetFormattedText("Default Grid Size = (%.0f)", (gridSlideValue)); --Sets the "title" text (top-centre of slider).
		end
	end)

	DefaultGridSizeSlider:SetScript("OnValueChanged", function(self, value) 
	local gridSlideValue = DefaultGridSizeSlider:GetValue()
		gridSize = gridSlideValue
		DA_Align()		
		getglobal(DefaultGridSizeSlider:GetName() .. 'Text'):SetFormattedText("Default Grid Size = (%.0f)", (gridSlideValue)); --Sets the "title" text (top-centre of slider).
		private.db.dadefaults.Aura_Grid_SizeSliderSetScale.defaultGridSize = gridSlideValue
	end)

