local DejaAuras, private = ...
local L = private.L 				--localization

private.defaults.DA_Watched_Auras = {}
private.defaults.DA_AuraPositions = {}
private.defaults.DA_AuraScale = {}
private.defaults.dadefaults.setDefaultAuraMask = {
	defaultAuraMask = "Interface\\ICONS\\Ability_Ambush",
}	
local DA_Watched_Auras_Names = {}

local buffsize
local defaultAuraMask
local DA_IOPPreviewBuffFrame = _G["DA_IOPPreviewBuffFrame"]

local function DA_AuraScale(DA_id, DA_name)
	local dragbuff = _G["DADragBuffFrame"..DA_name]
	-- local cooldown = _G["DACooldownFrame"..DA_name]
	if private.db.DA_AuraScale[DA_id] == nil then
		private.db.DA_AuraScale[DA_id] = buffsize
	end
	dragbuff.name:SetFont("Fonts\\FRIZQT__.TTF", ( private.db.DA_AuraScale[DA_id] * 0.4375 ), "THINOUTLINE")
	dragbuff.scaletext:SetFont("Fonts\\FRIZQT__.TTF", ( private.db.DA_AuraScale[DA_id] * 0.4375 ), "THINOUTLINE")
	dragbuff.buff:SetScale( private.db.DA_AuraScale[DA_id] / 40 )
	dragbuff.cooldown:SetScale( private.db.DA_AuraScale[DA_id] / 40 )
	if (private.db.dadefaults.setDefaultAuraMask.defaultAuraMask == "Interface\\ICONS\\Ability_Ambush") then
		dragbuff:SetSize(private.db.DA_AuraScale[DA_id], private.db.DA_AuraScale[DA_id])
		dragbuff.buff.charge:SetPoint("BOTTOMRIGHT", dragbuff, "BOTTOMRIGHT",  0, 0)
		dragbuff.buff.stack:SetPoint("BOTTOMRIGHT", dragbuff, "BOTTOMRIGHT",  0, 0)
		dragbuff.cooldown.charge:SetPoint("BOTTOMRIGHT", dragbuff, "BOTTOMRIGHT", 0, 0)
		dragbuff.cooldown.stack:SetPoint("BOTTOMRIGHT", dragbuff, "BOTTOMRIGHT",  0, 0)
	else
		dragbuff:SetSize(private.db.DA_AuraScale[DA_id]* 1.13, private.db.DA_AuraScale[DA_id]* 1.13)
		dragbuff.buff.charge:SetPoint("BOTTOMRIGHT", dragbuff, "BOTTOMRIGHT",  -3, 3)
		dragbuff.buff.stack:SetPoint("BOTTOMRIGHT", dragbuff, "BOTTOMRIGHT",  -3, 3)
		dragbuff.cooldown.charge:SetPoint("BOTTOMRIGHT", dragbuff, "BOTTOMRIGHT", -3, 3)
		dragbuff.cooldown.stack:SetPoint("BOTTOMRIGHT", dragbuff, "BOTTOMRIGHT",  -3, 3)
	end
end	

local function DA_Icontexture(DA_infoType, DA_id) --Legacy function to add DA_icontexture to db, remove for release.
	if (DA_infoType == "spell") then
		local _, _, icon = GetSpellInfo(DA_id)
		private.db.DA_Watched_Auras[DA_id].icon = icon
		DA_icontexture = icon
		return(DA_icontexture)
	elseif 	(DA_infoType == "item") then
		local _, _, _, _, _, _, _, _, _, itemTexture = GetItemInfo(DA_id)

		private.db.DA_Watched_Auras[DA_id].itemTexture = itemTexture
		DA_icontexture = itemTexture
		return(DA_icontexture)
	end
end

local function DA_BuffLockCheck(DA_name, DA_icontexture)
	local dragbuff = _G["DADragBuffFrame"..DA_name]
	if DABuffLockFrame:IsShown() then
		dragbuff:RegisterForClicks("AnyUp")
		dragbuff:RegisterEvent("MODIFIER_STATE_CHANGED")
		dragbuff:EnableMouse(true)
		dragbuff:EnableMouseWheel(true)
		dragbuff:SetMovable(true)
		dragbuff:RegisterForDrag("LeftButton","RightButton")
		dragbuff:Show()
		dragbuff.icon:SetTexture(DA_icontexture) --Can add custom textures later if wanted.
		dragbuff.icon:Show()
	else
		dragbuff:RegisterForClicks()
		dragbuff:UnregisterEvent("MODIFIER_STATE_CHANGED")
		dragbuff:EnableMouse(false)
		dragbuff:EnableMouseWheel(false)
		dragbuff:SetMovable(false)
		dragbuff:RegisterForDrag()
		dragbuff:Hide()
		dragbuff.icon:SetTexture(DA_icontexture) --Can add custom textures later if wanted.
		dragbuff.icon:Hide()
	end
end

--#################################################
--## Main Frame Creation/initialization Function ##
--#################################################

local function DA_DragFrames(DA_id, DA_name, DA_infoType, DA_spellIndex, DA_bookType, DA_itemLink, DA_icontexture)
	
	if (DA_icontexture == nil) then
		DA_Icontexture(DA_infoType, DA_id)		
	end
	G_DADragBuffFrame = _G["DADragBuffFrame"..DA_name]
	if (G_DADragBuffFrame == nil) then
		buffsize = private.db.dadefaults.Aura_Grid_SizeSliderSetScale.defaultAuraSize
		defaultAuraMask = private.db.dadefaults.setDefaultAuraMask.defaultAuraMask
		--Create Draggable Frames
		local dragbuff = CreateFrame("Button", "DADragBuffFrame"..DA_name, UIParent)
		dragbuff:SetClampedToScreen(true)

		dragbuff:ClearAllPoints()		
		dragbuff:SetPoint(
			private.db.DA_AuraPositions[DA_id].point, 
			private.db.DA_AuraPositions[DA_id].relativeTo, 
			private.db.DA_AuraPositions[DA_id].relativePoint, 
			private.db.DA_AuraPositions[DA_id].xOffset, 
			private.db.DA_AuraPositions[DA_id].yOffset
			)

		--#####################################################		
		--## Unlocked Frames Textures, Text Strings, Scripts ##
		--#####################################################

		--Create dragbuff Icon Textures
		dragbuff.icon = dragbuff:CreateTexture(nil,"BACKGROUND")
		dragbuff.icon:SetAllPoints("DADragBuffFrame"..DA_name)
		dragbuff.icon:SetMask(defaultAuraMask)
		dragbuff.icon:SetTexture(DA_icontexture) --Can add custom textures later if wanted.

		--Create Background Color texture for debugging
		-- dragbuff.coloroverlay = dragbuff:CreateTexture(nil,"TOOLTIP")
		-- dragbuff.coloroverlay:SetColorTexture(0, 192, 255, 0.7)
		-- dragbuff.coloroverlay:SetMask(defaultAuraMask)
		-- dragbuff.coloroverlay:SetAllPoints("DADragBuffFrame"..DA_name)

		--Create Drag Frame's Name Text Strings
		dragbuff.name = dragbuff:CreateFontString("BuffName","OVERLAY","GameTooltipText")
		dragbuff.name:SetPoint("CENTER", dragbuff, "CENTER", 0, 0)		
		dragbuff.name:SetTextColor(1, 1, 1);

		--Create Drag Frame's Scale Text Strings
		dragbuff.scaletext = dragbuff:CreateFontString("DA_AuraScale","OVERLAY","GameTooltipText")
		dragbuff.scaletext:SetPoint("TOP", dragbuff, "TOP", 0, 0)		
		dragbuff.scaletext:SetTextColor(1, 1, 1);

		dragbuff:SetScript("OnEvent", function(self, event, ...)
			if event == "MODIFIER_STATE_CHANGED" then
				if (MouseIsOver(dragbuff)) then
					if IsControlKeyDown() then
						dragbuff.name:SetText("")
						dragbuff.scaletext:SetText("")
					else
						dragbuff.name:SetText(DA_name);
						dragbuff.scaletext:SetText(private.db.DA_AuraScale[DA_id])
					end
				elseif DABuffLockFrame:IsShown() then
					if IsAltKeyDown() then
						dragbuff.buff:Hide()
						dragbuff.cooldown:Hide()
						dragbuff.name:SetText(DA_name);
						dragbuff.scaletext:SetText(private.db.DA_AuraScale[DA_id])
					else
						dragbuff.buff:Show()
						dragbuff.cooldown:Show()
						dragbuff.name:SetText("")
						dragbuff.scaletext:SetText("")
					end
				end
			end
		end)

		--Mouseover Show Drag Frames' Names Scripts
		dragbuff:SetScript("OnEnter", function(self) 
			if DABuffLockFrame:IsShown() then
				dragbuff.buff:Hide()
				dragbuff.cooldown:Hide()		
				dragbuff.name:SetTextColor(0, 192, 255, 0.7);
				dragbuff.scaletext:SetTextColor(0, 192, 255, 0.7);
				if IsControlKeyDown() then
					dragbuff.name:SetText("")
					dragbuff.scaletext:SetText("")
				else
					dragbuff.name:SetText(DA_name);
					dragbuff.scaletext:SetText(private.db.DA_AuraScale[DA_id])
				end
			end
		end)

		dragbuff:SetScript("OnLeave", function(self)
			if DABuffLockFrame:IsShown() then
				dragbuff.buff:Show()
				dragbuff.cooldown:Show()	
				dragbuff.name:SetTextColor(1, 1, 1);
				dragbuff.scaletext:SetTextColor(1, 1, 1);
			end
			if IsAltKeyDown() then
				return
			else
				dragbuff.name:SetText("")
				dragbuff.scaletext:SetText("")
			end
		end)		

		--Positioning Drag Frame's Scripts
		dragbuff:SetScript("OnDragStart", function(self)
			self:StartMoving() 
			self:SetUserPlaced(true) 
		end)

		dragbuff:SetScript("OnDragStop", function(self) 
			self:StopMovingOrSizing() 
			self:SetUserPlaced(false) 
			
			point, relativeTo, relativePoint, xOfs, yOfs = self:GetPoint(1)
				if ( relativeTo ) then
					relativeTo = relativeTo:GetName();
				else
					relativeTo = self:GetParent():GetName();
				end
			
			private.db.DA_AuraPositions[DA_id].point = point
			private.db.DA_AuraPositions[DA_id].relativeTo = relativeTo
			private.db.DA_AuraPositions[DA_id].relativePoint = relativePoint
			private.db.DA_AuraPositions[DA_id].xOffset = xOfs
			private.db.DA_AuraPositions[DA_id].yOffset = yOfs

			self:ClearAllPoints()		
			self:SetPoint(
				private.db.DA_AuraPositions[DA_id].point, 
				private.db.DA_AuraPositions[DA_id].relativeTo, 
				private.db.DA_AuraPositions[DA_id].relativePoint, 
				private.db.DA_AuraPositions[DA_id].xOffset, 
				private.db.DA_AuraPositions[DA_id].yOffset)
		end)

		buffsize = private.db.dadefaults.Aura_Grid_SizeSliderSetScale.defaultAuraSize

		dragbuff:SetScript("OnMouseWheel", function(self, delta)
			if DABuffLockFrame:IsShown() then
				if IsShiftKeyDown() then
					private.db.DA_AuraScale[DA_id] = ( (math.ceil( private.db.DA_AuraScale[DA_id] / 5 )) * 5 ) + (delta * 5)
				elseif IsControlKeyDown() then
					private.db.DA_AuraScale[DA_id] = ( (math.ceil( private.db.DA_AuraScale[DA_id] / 10 )) * 10 ) + (delta * 10)
				elseif (IsAltKeyDown()) then
					private.db.DA_AuraScale[DA_id] = ( (math.ceil( private.db.DA_AuraScale[DA_id] / 10 )) * 10 ) + (delta * 25)
				else
					private.db.DA_AuraScale[DA_id] = private.db.DA_AuraScale[DA_id] + delta
				end
				if ( private.db.DA_AuraScale[DA_id] < 20 ) then 
					private.db.DA_AuraScale[DA_id] = 20 
				end
				DA_AuraScale(DA_id, DA_name)
				dragbuff.scaletext:SetText(private.db.DA_AuraScale[DA_id])
			end
		end)

		dragbuff:SetScript("OnClick", function (self, button , up)
			if DABuffLockFrame:IsShown() then
				if (button == RightButton) then
					print("Right button clicked on up")
				end
			end
		end)

		--Create Buff Animation Frames
		dragbuff.buff = CreateFrame("Cooldown", "BuffAnimation"..DA_name, dragbuff, "CooldownFrameTemplate")
		dragbuff.buff:SetSwipeTexture(defaultAuraMask)
		dragbuff.buff:SetEdgeTexture("Interface\\AddOns\\DejaAuras\\Textures\\SetEdgeTexture_Clear");
		dragbuff.buff:SetHideCountdownNumbers(false); -- Hides the countdown numbers regardless of the cvar setting

		--Create Buff Textures
		dragbuff.buff.texture = dragbuff.buff:CreateTexture(nil,"BACKGROUND")
		dragbuff.buff.texture:SetAllPoints("BuffAnimation"..DA_name)
		dragbuff.buff.texture:SetMask(defaultAuraMask)
		dragbuff.buff.texture:SetTexture(DA_icontexture) --Can add custom textures later if wanted.

		--Create Buff Stack Count Text Strings
		dragbuff.buff.stack = dragbuff.buff:CreateFontString("FontString","OVERLAY","GameTooltipText")
		dragbuff.buff.stack:SetFont("Fonts\\FRIZQT__.TTF", 12, "THINOUTLINE")
		dragbuff.buff.stack:SetTextColor(1, 1, 1);
		
		--Create Buff Charge Count Text Strings
		dragbuff.buff.charge = dragbuff.buff:CreateFontString("FontString","OVERLAY","GameTooltipText")
		dragbuff.buff.charge:SetFont("Fonts\\FRIZQT__.TTF", 12, "THINOUTLINE")
		dragbuff.buff.charge:SetTextColor(1, 1, 1);

		--Create Active Buff Fade Alpha In & Out Animations
		dragbuff.buff.fadeAnimation = dragbuff.buff:CreateAnimationGroup()

		local bufffadein = dragbuff.buff.fadeAnimation:CreateAnimation("Alpha")
		bufffadein:SetSmoothing("NONE")	
		bufffadein:SetOrder(1)
		bufffadein:SetFromAlpha(1)
		bufffadein:SetToAlpha(0.33)
		bufffadein:SetDuration(0.99) --Blizzard default buff fade time is 0.80.
		
		local bufffadeout = dragbuff.buff.fadeAnimation:CreateAnimation("Alpha")
		bufffadeout:SetSmoothing("NONE")	
		bufffadeout:SetOrder(2)
		bufffadeout:SetFromAlpha(0.33)
		bufffadeout:SetToAlpha(1)
		bufffadeout:SetDuration(0.99)	
	
		--Create Cooldown Animation Frames
		dragbuff.cooldown = CreateFrame("Cooldown", "CooldownAnimation"..DA_name, dragbuff, "CooldownFrameTemplate")
		dragbuff.cooldown:SetSwipeTexture(defaultAuraMask)
		dragbuff.cooldown:SetEdgeTexture("Interface\\AddOns\\DejaAuras\\Textures\\SetEdgeTexture_Clear");
		dragbuff.cooldown:SetHideCountdownNumbers(false); -- Hides the countdown numbers regardless of the cvar setting
		
		--Create Cooldown Textures
		dragbuff.cooldown.texture = dragbuff.cooldown:CreateTexture(nil,"BACKGROUND")
		dragbuff.cooldown.texture:SetAllPoints("CooldownAnimation"..DA_name)
		dragbuff.cooldown.texture:SetMask(defaultAuraMask)
		dragbuff.cooldown.texture:SetTexture(DA_icontexture) --Can add custom textures later if wanted.

		--Create Cooldown Stack Count Text Strings
		dragbuff.cooldown.stack = dragbuff.cooldown:CreateFontString("FontString","OVERLAY","GameTooltipText")
		dragbuff.cooldown.stack:SetFont("Fonts\\FRIZQT__.TTF", 12, "THINOUTLINE")
		dragbuff.cooldown.stack:SetTextColor(1, 1, 1);

		--Create Cooldown Charge Count Text Strings
		dragbuff.cooldown.charge = dragbuff.cooldown:CreateFontString("FontString","OVERLAY","GameTooltipText")
		dragbuff.cooldown.charge:SetFont("Fonts\\FRIZQT__.TTF", 12, "THINOUTLINE")
		dragbuff.cooldown.charge:SetTextColor(1, 1, 1);

		-- Remove Drag Frames from the db with alt+click
		dragbuff:SetScript("OnClick", function(self, button , up)
			if DABuffLockFrame:IsShown() then
				if (button == "RightButton") then
				end
				if (IsAltKeyDown() and IsControlKeyDown()) then
					print("Removed "..DA_name)
					private.db.DA_Watched_Auras[DA_id] = nil
					private.db.DA_Watched_Auras[DA_name] = nil
					private.db.DA_AuraPositions[DA_id] = nil
					private.db.DA_AuraScale[DA_id] = nil
					dragbuff.icon:SetTexture(nil)
					dragbuff.name:SetText("")
					dragbuff.scaletext:SetText("")
					DA_id = nil
					DA_name = nil
					dragbuff:UnregisterEvent("MODIFIER_STATE_CHANGED")
					dragbuff:Hide()
					if (dragbuff == nil) then 
						return
					else
						dragbuff:Hide()
					end
				end
			end
		end)
		DA_BuffLockCheck(DA_name, DA_icontexture)
	end
	DA_BuffLockCheck(DA_name, DA_icontexture)
end

local DA_MonitorFrame = CreateFrame("Button", DA_MonitorFrame, UIParent)
	DA_MonitorFrame:RegisterEvent("PLAYER_ENTERING_WORLD")
	DA_MonitorFrame:RegisterEvent("SPELL_UPDATE_COOLDOWN")
	DA_MonitorFrame:RegisterUnitEvent("UNIT_AURA", "player")

local function DA_Cooldown_OnEvent()
	for k, v in pairs(private.db.DA_Watched_Auras) do
		if (IsAddOnLoaded("DejaAuras")) then
			local auraName = private.db.DA_Watched_Auras[k].spellName
			local dragbuff = _G["DADragBuffFrame"..auraName]
			dragbuff.cooldown:SetSwipeTexture(defaultAuraMask)
			dragbuff.cooldown.texture:SetMask(defaultAuraMask)
			local CDspellId = private.db.DA_Watched_Auras[k].spellID
			local currentCharges, maxCharges, cooldownStart, cooldownDuration = GetSpellCharges(CDspellId)
			local start, duration = GetSpellCooldown(CDspellId);
			if currentCharges == nil then currentCharges = 0 end
			if maxCharges == nil then maxCharges = 0 end
			if cooldownStart == nil then cooldownStart = 0 end
			if cooldownDuration == nil then cooldownDuration = 0 end
			if start == nil then
				local itemName = GetItemInfo(CDspellId)
				if (itemName ~= nil) then
					local startTime = GetItemCooldown(CDspellId)
					start = startTime
				end
			end
			if (maxCharges < 2) then
				dragbuff.buff.charge:SetText("");
				dragbuff.cooldown.charge:SetText("");
			else
				dragbuff.buff.charge:SetText(currentCharges);
				dragbuff.cooldown.charge:SetText(currentCharges);
			end
			if (currentCharges < maxCharges) then
				dragbuff:Show()
				dragbuff.cooldown:Show()
				dragbuff.cooldown:SetCooldown(cooldownStart, cooldownDuration)
			elseif (duration < 2) then -- Global CD throttle, otherwise ALL tracked auras show during the GCD.
				dragbuff:Hide()
			elseif ((GetTime() - start) < duration) then 
				dragbuff:Show()
				dragbuff.cooldown:Show()
				dragbuff.cooldown:SetCooldown(start, duration)
			end
			if DABuffLockFrame:IsShown() then
				dragbuff:Show()
			else
				dragbuff.buff:Hide()
			end
		end
	end
end

local function DA_Buff_OnEvent()
	for i = 1, 40 do
		local auraName = UnitAura("player", i);
		if ( not auraName ) then
			return
		else
			if tContains(DA_Watched_Auras_Names, auraName) then
				local _, _, count, _, auraDuration, expirationTime = UnitAura("player", i);
				local dragbuff = _G["DADragBuffFrame"..auraName]
				--Place Stack Count Text
				if count == nil then count = 0 end
				if count < 2 then
					dragbuff.buff.stack:SetText("");
				else
					dragbuff.buff.stack:SetText(count);
				end		
				--Show Remaining Time Text
				local timeremain = ((expirationTime - GetTime()) - auraDuration)
				local DAStartTime = ( (GetTime() + timeremain) - 1 ) -- Minus one (-1) so it counts down to zero isntead of 1 and coincides with the default buff display.
				dragbuff.buff:SetCooldown( DAStartTime, auraDuration)
				
				local function scanAuras()
					if not dragbuff.buff.fadeAnimation:IsPlaying() then
						dragbuff.buff.fadeAnimation:Play()
						C_Timer.After(2.00, scanAuras)	
					end
				end
				dragbuff.buff:SetSwipeTexture(defaultAuraMask)
				dragbuff.buff.texture:SetMask(defaultAuraMask)
				dragbuff:Show()
				dragbuff.buff.fadeAnimation:Play()
				C_Timer.After(2.00, scanAuras)
				if DABuffLockFrame:IsShown() then
					dragbuff:Show()
				else
					dragbuff.cooldown:Hide()
				end
			end
		end
	end
end

	DA_MonitorFrame:SetScript("OnEvent", function(self, event, arg1, ...)
		if (event == "PLAYER_ENTERING_WORLD") or (event == "SPELL_UPDATE_COOLDOWN") or (arg1 == "player") then
			DA_Cooldown_OnEvent()
			DA_Buff_OnEvent()
		end
	end)

local function DA_Refresh(DA_id, DA_name, DA_infoType, DA_spellIndex, DA_bookType, DA_itemLink, DA_icontexture)
	DA_DragFrames(DA_id, DA_name, DA_infoType, DA_spellIndex, DA_bookType, DA_itemLink, DA_icontexture)
	DA_AuraScale(DA_id, DA_name)
end

local function DejaAuras_Init()
	for i, v in pairs(private.db.DA_Watched_Auras) do
		local DA_id, DA_name, DA_infoType, DA_spellIndex, DA_bookType, DA_itemLink, DA_icontexture = nil
		DA_infoType = private.db.DA_Watched_Auras[i].infoType
		if (DA_infoType == "spell") then
			DA_id = private.db.DA_Watched_Auras[i].spellID
			DA_name = private.db.DA_Watched_Auras[i].spellName
			DA_spellIndex = private.db.DA_Watched_Auras[i].spellIndex
			DA_bookType = private.db.DA_Watched_Auras[i].bookType
			DA_icontexture = private.db.DA_Watched_Auras[i].icon
		elseif 	(DA_infoType == "item") then
			DA_id = private.db.DA_Watched_Auras[i].itemID
			DA_name = private.db.DA_Watched_Auras[i].itemName
			DA_itemLink = private.db.DA_Watched_Auras[i].itemLink
			DA_icontexture = private.db.DA_Watched_Auras[i].itemTexture
		end
		tinsert(DA_Watched_Auras_Names, DA_name)
		buffsize = private.db.dadefaults.Aura_Grid_SizeSliderSetScale.defaultAuraSize
		defaultAuraMask = private.db.dadefaults.setDefaultAuraMask.defaultAuraMask
		if (private.defaults.DA_AuraScale[DA_id] == nil) then
			private.defaults.DA_AuraScale[DA_id] = 36
		end
		if (private.db.DA_AuraPositions[DA_id] == nil) then
			private.db.DA_AuraPositions[DA_id] = {}
			private.db.DA_AuraPositions[DA_id].point = "CENTER"
			private.db.DA_AuraPositions[DA_id].relativeTo = "DABuffLockFrame"
			private.db.DA_AuraPositions[DA_id].relativePoint = "CENTER"
			private.db.DA_AuraPositions[DA_id].xOffset = 0
			private.db.DA_AuraPositions[DA_id].yOffset = 0
		end
		DA_Refresh(DA_id, DA_name, DA_infoType, DA_spellIndex, DA_bookType, DA_itemLink, DA_icontexture)
	end
end

-- Login DejaAuras addon initialization event frame
local DA_InitializationFrame = CreateFrame("Frame", "DA_InitializationFrame", UIParent)
	DA_InitializationFrame:RegisterEvent("PLAYER_LOGIN")
			
	DA_InitializationFrame:SetScript("OnEvent", function(self, event, ...)
		DejaAuras_Init()
	end)

-- Drag 'n' Drop from spellbook logic.
local DA_cursoreventframe = CreateFrame("Frame")
	DA_cursoreventframe:RegisterEvent("ACTIONBAR_SHOWGRID")
	DA_cursoreventframe:RegisterEvent("ACTIONBAR_HIDEGRID")
	DA_cursoreventframe:RegisterEvent("ITEM_LOCKED")

DA_cursoreventframe:SetScript("OnEvent", function(self, event, ...)
	if DABuffLockFrame:IsShown() then
		if (event == "ACTIONBAR_SHOWGRID") then
			local infoType, spellIndex, bookType, spellID = GetCursorInfo()
			if (infoType == "spell") then
				local name = GetSpellInfo(spellID)
				local _, _, icon = GetSpellInfo(spellID)
				if (private.db.DA_Watched_Auras[spellID] ~= nil) then
					print("Spell already exists") 
					return 
				else
					private.db.DA_Watched_Auras[spellID] = {}
					private.db.DA_Watched_Auras[spellID].spellID = spellID
					private.db.DA_Watched_Auras[spellID].spellName = name
					private.db.DA_Watched_Auras[spellID].spellIndex = spellIndex
					private.db.DA_Watched_Auras[spellID].infoType = infoType
					private.db.DA_Watched_Auras[spellID].bookType = bookType
					private.db.DA_Watched_Auras[spellID].icon = icon
					DA_id = spellID
					DA_name = name
					DA_infoType = infoType
					DA_spellIndex = spellIndex
					DA_bookType = bookType
					DA_itemLink = nil
					DA_icontexture = icon
				end
			end
		end
		if (event == "ITEM_LOCKED") then
			local infoType, itemID, itemLink = GetCursorInfo()
			if (infoType == "item") then
				local itemName = GetItemInfo(itemID)
				local _, _, _, _, _, _, _, _, _, itemTexture = GetItemInfo(itemID)
				if (private.db.DA_Watched_Auras[itemID] ~= nil) then
					print("Item already exists") 
					return 
				else
					private.db.DA_Watched_Auras[itemID] = {}
					private.db.DA_Watched_Auras[itemID].itemID = itemID
					private.db.DA_Watched_Auras[itemID].itemName = itemName
					private.db.DA_Watched_Auras[itemID].itemLink = itemLink
					private.db.DA_Watched_Auras[itemID].infoType = infoType
					private.db.DA_Watched_Auras[itemID].itemTexture = itemTexture
					DA_id = itemID
					DA_name = itemName
					DA_infoType = infoType
					DA_spellIndex = nil
					DA_bookType = nil
					DA_itemLink = itemLink
					DA_icontexture = itemTexture
				end
			end
		end
		if (event == "ACTIONBAR_HIDEGRID") then
			buffsize = private.db.dadefaults.Aura_Grid_SizeSliderSetScale.defaultAuraSize
			--Math to place icon where cursor is located (upper left corner of pointer).
			local uiScale, x, y = UIParent:GetEffectiveScale(), GetCursorPosition()
			local xOfs = ((x / uiScale))
			local yOfs = ((y / uiScale) - (buffsize))
			
			if DA_id == nil then --If no ID because spell already exists then return, otherwise set points.
				return 
			else
				private.db.DA_AuraPositions[DA_id] = {}
				private.db.DA_AuraPositions[DA_id].point = "BOTTOMLEFT"
				private.db.DA_AuraPositions[DA_id].relativeTo = "DABuffLockFrame"
				private.db.DA_AuraPositions[DA_id].relativePoint = "BOTTOMLEFT"
				private.db.DA_AuraPositions[DA_id].xOffset = xOfs
				private.db.DA_AuraPositions[DA_id].yOffset = yOfs
			end

			DA_Refresh(DA_id, DA_name, DA_infoType, DA_spellIndex, DA_bookType, DA_itemLink, DA_icontexture)
		end			
	end
end)

DABuffLockFrame:SetScript("OnShow", function(self)
	DejaAuras_Init()
	ToggleSpellBook("spell");
end)

DABuffLockFrame:SetScript("OnHide", function(self)
	DejaAuras_Init()
	ToggleSpellBook("spell");
	DA_Cooldown_OnEvent()
	DA_Buff_OnEvent()
end)

-- --IOP Preview Buff Display
-- DA_IOPPreviewBuffFrame = CreateFrame("Button", "DA_IOPPreviewBuffFrame", DejaAurasPanel, "SecureActionButtonTemplate")
-- DA_IOPPreviewBuffFrame:RegisterEvent("PLAYER_LOGIN")
-- DA_IOPPreviewBuffFrame:RegisterForClicks("AnyUp")
-- DA_IOPPreviewBuffFrame:SetSize(200,200)
-- DA_IOPPreviewBuffFrame:SetPoint("TOPRIGHT", DejaAurasPanel, "TOPRIGHT", -16, -16)
-- DA_IOPPreviewBuffFrame:SetAlpha(0.5)
			
-- DA_IOPPreviewBuffFrame.icon = DA_IOPPreviewBuffFrame:CreateTexture(nil,"BACKGROUND")
-- DA_IOPPreviewBuffFrame.icon:SetAllPoints(DA_IOPPreviewBuffFrame)

-- DA_IOPPreviewBuffFrame:SetScript("OnEvent", function(self, event, ...)
-- 	local englishFaction = UnitFactionGroup("player")
-- 	if (englishFaction == "Horde") then
-- 		DA_IOPPreviewBuffFrame.icon:SetTexture("Interface\\Calendar\\UI-Calendar-Event-PVP01")
-- 	else
-- 		DA_IOPPreviewBuffFrame.icon:SetTexture("Interface\\Calendar\\UI-Calendar-Event-PVP02")
-- 	end
-- 	DA_IOPPreviewBuffFrame:SetSize(buffsize, buffsize)
-- 	DA_IOPPreviewBuffFrame.icon:SetMask(defaultAuraMask)
-- end)

--Alliance/Horde Aura Mask

local AllianceHordeAuraMaskFrame = CreateFrame("Button", "AllianceHordeAuraMaskFrame", DejaAurasPanel, "SecureActionButtonTemplate")
AllianceHordeAuraMaskFrame:RegisterEvent("PLAYER_LOGIN")
AllianceHordeAuraMaskFrame:RegisterForClicks("AnyUp")
AllianceHordeAuraMaskFrame:SetSize(36,36)
AllianceHordeAuraMaskFrame:SetPoint("TOP", DejaAurasPanel, "TOP", -42 , -38)
AllianceHordeAuraMaskFrame:SetNormalTexture("Interface\\FriendsFrame\\PlusManz-Alliance")
AllianceHordeAuraMaskFrame:SetAlpha(0.5)

AllianceHordeAuraMaskFrame.texture = AllianceHordeAuraMaskFrame:CreateTexture(nil,"BACKGROUND")
AllianceHordeAuraMaskFrame.texture:SetAllPoints(AllianceHordeAuraMaskFrame)
-- AllianceHordeAuraMaskFrame.texture:SetColorTexture(0, 192, 255, 0.7)

AllianceHordeAuraMaskFrame:SetScript("OnEvent", function(self, event, ...)
	local englishFaction = UnitFactionGroup("player")
	if (englishFaction == "Horde") then
		AllianceHordeAuraMaskFrame:SetNormalTexture("Interface\\FriendsFrame\\PlusManz-Horde")
	else
		AllianceHordeAuraMaskFrame:SetNormalTexture("Interface\\FriendsFrame\\PlusManz-Alliance")
	end
end)

AllianceHordeAuraMaskFrame:SetScript("OnEnter", function(self)
	self:SetAlpha(1)
	GameTooltip:SetOwner(self, "ANCHOR_TOP")
	local englishFaction = UnitFactionGroup("player")
	if (englishFaction == "Horde") then
		GameTooltip:AddLine('Horde Emblem', 0, 192, 255, 1, 1)
	else
		GameTooltip:AddLine('Alliance Emblem', 0, 192, 255, 1, 1)
	end
	GameTooltip:Show()
end)

AllianceHordeAuraMaskFrame:SetScript("OnLeave", function(self)
	self:SetAlpha(0.5)
	GameTooltip:Hide()
end)

AllianceHordeAuraMaskFrame:SetScript("OnClick", function(self)
	local englishFaction = UnitFactionGroup("player")
	if (englishFaction == "Horde") then
		private.db.dadefaults.setDefaultAuraMask.defaultAuraMask = "Interface\\FriendsFrame\\PlusManz-Horde"
	else
		private.db.dadefaults.setDefaultAuraMask.defaultAuraMask = "Interface\\FriendsFrame\\PlusManz-Alliance"
	end
	DejaAuras_Init()
	DA_Cooldown_OnEvent()
	DA_Buff_OnEvent()
	DA_IOPPreviewBuffFrame.icon:SetMask(defaultAuraMask)
	DA_IOPPreviewBuffFrame.cooldown:SetSwipeTexture(defaultAuraMask)
	DA_IOPPreviewBuffFrame.cooldown:SetCooldown(GetTime(), 30)
end)

--Lordaeron Aura Mask

local LordaeronAuraMaskFrame = CreateFrame("Button", "LordaeronAuraMaskFrame", DejaAurasPanel, "SecureActionButtonTemplate")
LordaeronAuraMaskFrame:RegisterForClicks("AnyUp")
LordaeronAuraMaskFrame:SetSize(36,36)
LordaeronAuraMaskFrame:SetPoint("TOP", DejaAurasPanel, "TOP", -6 , -38)
LordaeronAuraMaskFrame:SetNormalTexture("Interface\\FlavorImages\\ScarletCrusadeLogo")
LordaeronAuraMaskFrame:SetAlpha(0.5)

LordaeronAuraMaskFrame.texture = LordaeronAuraMaskFrame:CreateTexture(nil,"BACKGROUND")
LordaeronAuraMaskFrame.texture:SetAllPoints(LordaeronAuraMaskFrame)
-- LordaeronAuraMaskFrame.texture:SetColorTexture(0, 192, 255, 0.7)

LordaeronAuraMaskFrame:SetScript("OnEnter", function(self)
	self:SetAlpha(1)
	GameTooltip:SetOwner(self, "ANCHOR_TOP")
	GameTooltip:AddLine("Lordaeron Emblem", 0, 192, 255, 1, 1)
	GameTooltip:Show()
end)

LordaeronAuraMaskFrame:SetScript("OnLeave", function(self)
	self:SetAlpha(0.5)
	GameTooltip:Hide()
end)

LordaeronAuraMaskFrame:SetScript("OnClick", function(self)
	private.db.dadefaults.setDefaultAuraMask.defaultAuraMask = "Interface\\FlavorImages\\ScarletCrusadeLogo"
	DejaAuras_Init()
	DA_Cooldown_OnEvent()
	DA_Buff_OnEvent()
	DA_IOPPreviewBuffFrame.icon:SetMask(defaultAuraMask)
	DA_IOPPreviewBuffFrame.cooldown:SetSwipeTexture(defaultAuraMask)
	DA_IOPPreviewBuffFrame.cooldown:SetCooldown(GetTime(), 30)
end)

--Default Aura Mask
local DefaultAuraMaskFrame = CreateFrame("Button", "DefaultAuraMaskFrame", DejaAurasPanel, "SecureActionButtonTemplate")
DefaultAuraMaskFrame:RegisterEvent("PLAYER_LOGIN")
DefaultAuraMaskFrame:RegisterForClicks("AnyUp")
DefaultAuraMaskFrame:SetSize(36,36)
DefaultAuraMaskFrame:SetPoint("TOP", DejaAurasPanel, "TOP", -42, -74)
DefaultAuraMaskFrame:SetNormalTexture("Interface\\Calendar\\UI-Calendar-Event-PVP02")
DefaultAuraMaskFrame:SetAlpha(0.5)
			
DefaultAuraMaskFrame:SetScript("OnEvent", function(self, event, ...)
	local englishFaction = UnitFactionGroup("player")
	if (englishFaction == "Horde") then
		DefaultAuraMaskFrame:SetNormalTexture("Interface\\Calendar\\UI-Calendar-Event-PVP01")
	else
		DefaultAuraMaskFrame:SetNormalTexture("Interface\\Calendar\\UI-Calendar-Event-PVP02")
	end
end)

DefaultAuraMaskFrame:SetScript("OnEnter", function(self)
	self:SetAlpha(1)
	GameTooltip:SetOwner(self, "ANCHOR_TOP")
	GameTooltip:AddLine('Blizzard Default', 0, 192, 255, 1, 1)
	GameTooltip:Show()
end)

DefaultAuraMaskFrame:SetScript("OnLeave", function(self)
	self:SetAlpha(0.5)
	GameTooltip:Hide()
end)

DefaultAuraMaskFrame:SetScript("OnClick", function(self)
	private.db.dadefaults.setDefaultAuraMask.defaultAuraMask = "Interface\\ICONS\\Ability_Ambush"
	DejaAuras_Init()
	DA_Cooldown_OnEvent()
	DA_Buff_OnEvent()
	DA_IOPPreviewBuffFrame.icon:SetMask(defaultAuraMask)
	DA_IOPPreviewBuffFrame.cooldown:SetSwipeTexture(defaultAuraMask)
	DA_IOPPreviewBuffFrame.cooldown:SetCooldown(GetTime(), 30)
end)

--Aura Raid Frame Target Marker Masks

for i=1, 8 do 
	local RaidMarkerAuraMaskFrame = CreateFrame("Button", "RaidMarkerAuraMaskFrame"..i, DejaAurasPanel, "SecureActionButtonTemplate")
	RaidMarkerAuraMaskFrame:RegisterForClicks("AnyUp")
	RaidMarkerAuraMaskFrame:SetSize(36,36)
	RaidMarkerAuraMaskFrame:SetPoint("TOP", DejaAurasPanel, "TOP", -6, -39 + (-36*i))
	RaidMarkerAuraMaskFrame:SetNormalTexture("Interface\\TargetingFrame\\UI-RaidTargetingIcon_"..i..".png")
	RaidMarkerAuraMaskFrame:SetAlpha(0.5)

	RaidMarkerAuraMaskFrame:SetScript("OnEnter", function(self)
		self:SetAlpha(1)
	end)

	RaidMarkerAuraMaskFrame:SetScript("OnLeave", function(self)
		self:SetAlpha(0.5)
	end)

	RaidMarkerAuraMaskFrame:SetScript("OnClick", function(self)
		private.db.dadefaults.setDefaultAuraMask.defaultAuraMask = "Interface\\TARGETINGFRAME\\UI-RaidTargetingIcon_"..i..""
		DejaAuras_Init()
		DA_Cooldown_OnEvent()
		DA_Buff_OnEvent()
		DA_IOPPreviewBuffFrame.icon:SetMask(defaultAuraMask)
		DA_IOPPreviewBuffFrame.cooldown:SetSwipeTexture(defaultAuraMask)
		DA_IOPPreviewBuffFrame.cooldown:SetCooldown(GetTime(), 30)
	end)
end

--Clean Circle Aura Mask

local CleanCircleAuraMaskFrame = CreateFrame("Button", "CleanCircleAuraMaskFrame", DejaAurasPanel, "SecureActionButtonTemplate")
CleanCircleAuraMaskFrame:RegisterForClicks("AnyUp")
CleanCircleAuraMaskFrame:SetSize(36,36)
CleanCircleAuraMaskFrame:SetPoint("TOP", DejaAurasPanel, "TOP", -42 , -110)
CleanCircleAuraMaskFrame:SetNormalTexture("Interface\\AddOns\\DejaAuras\\Textures\\CleanCircleAuraMask")
CleanCircleAuraMaskFrame:SetAlpha(0.5)

CleanCircleAuraMaskFrame.texture = CleanCircleAuraMaskFrame:CreateTexture(nil,"BACKGROUND")
CleanCircleAuraMaskFrame.texture:SetAllPoints(CleanCircleAuraMaskFrame)
-- CleanCircleAuraMaskFrame.texture:SetColorTexture(0, 192, 255, 0.7)

CleanCircleAuraMaskFrame:SetScript("OnEnter", function(self)
	self:SetAlpha(1)
	GameTooltip:SetOwner(self, "ANCHOR_TOP")
	GameTooltip:AddLine('Clean Circle', 0, 192, 255, 1, 1)
	GameTooltip:Show()
end)

CleanCircleAuraMaskFrame:SetScript("OnLeave", function(self)
	self:SetAlpha(0.5)
	GameTooltip:Hide()
end)

CleanCircleAuraMaskFrame:SetScript("OnClick", function(self)
	private.db.dadefaults.setDefaultAuraMask.defaultAuraMask = "Interface\\AddOns\\DejaAuras\\Textures\\CleanCircleAuraMask"
	DejaAuras_Init()
	DA_Cooldown_OnEvent()
	DA_Buff_OnEvent()
	DA_IOPPreviewBuffFrame.icon:SetMask(defaultAuraMask)
	DA_IOPPreviewBuffFrame.cooldown:SetSwipeTexture(defaultAuraMask)
	DA_IOPPreviewBuffFrame.cooldown:SetCooldown(GetTime(), 30)
end)

--Sword 'n' Board Aura Mask

local SwordnBoardAuraMaskFrame = CreateFrame("Button", "SwordnBoardAuraMaskFrame", DejaAurasPanel, "SecureActionButtonTemplate")
SwordnBoardAuraMaskFrame:RegisterForClicks("AnyUp")
SwordnBoardAuraMaskFrame:SetSize(36,36)
SwordnBoardAuraMaskFrame:SetPoint("TOP", DejaAurasPanel, "TOP", -42 , -146)
SwordnBoardAuraMaskFrame:SetNormalTexture("Interface\\PVPFrame\\Icons\\UI_RankedPvP_07")
SwordnBoardAuraMaskFrame:SetAlpha(0.5)

SwordnBoardAuraMaskFrame.texture = SwordnBoardAuraMaskFrame:CreateTexture(nil,"BACKGROUND")
SwordnBoardAuraMaskFrame.texture:SetAllPoints(SwordnBoardAuraMaskFrame)
-- SwordnBoardAuraMaskFrame.texture:SetColorTexture(0, 192, 255, 0.7)

SwordnBoardAuraMaskFrame:SetScript("OnEnter", function(self)
	self:SetAlpha(1)
	GameTooltip:SetOwner(self, "ANCHOR_TOP")
	GameTooltip:AddLine("Sword 'n' Board", 0, 192, 255, 1, 1)
	GameTooltip:Show()
end)

SwordnBoardAuraMaskFrame:SetScript("OnLeave", function(self)
	self:SetAlpha(0.5)
	GameTooltip:Hide()
end)

SwordnBoardAuraMaskFrame:SetScript("OnClick", function(self)
	private.db.dadefaults.setDefaultAuraMask.defaultAuraMask = "Interface\\PVPFrame\\Icons\\UI_RankedPvP_07"
	DejaAuras_Init()
	DA_Cooldown_OnEvent()
	DA_Buff_OnEvent()
	DA_IOPPreviewBuffFrame.icon:SetMask(defaultAuraMask)
	DA_IOPPreviewBuffFrame.cooldown:SetSwipeTexture(defaultAuraMask)
	DA_IOPPreviewBuffFrame.cooldown:SetCooldown(GetTime(), 30)
end)

--Triangle Aura Mask

local TriangleAuraMaskFrame = CreateFrame("Button", "TriangleAuraMaskFrame", DejaAurasPanel, "SecureActionButtonTemplate")
TriangleAuraMaskFrame:RegisterForClicks("AnyUp")
TriangleAuraMaskFrame:SetSize(36,36)
TriangleAuraMaskFrame:SetPoint("TOP", DejaAurasPanel, "TOP", -42 , -182)
TriangleAuraMaskFrame:SetNormalTexture("Interface\\DialogFrame\\UI-Dialog-Icon-AlertNew")
TriangleAuraMaskFrame:SetAlpha(0.5)

TriangleAuraMaskFrame.texture = TriangleAuraMaskFrame:CreateTexture(nil,"BACKGROUND")
TriangleAuraMaskFrame.texture:SetAllPoints(TriangleAuraMaskFrame)
-- TriangleAuraMaskFrame.texture:SetColorTexture(0, 192, 255, 0.7)

TriangleAuraMaskFrame:SetScript("OnEnter", function(self)
	self:SetAlpha(1)
	GameTooltip:SetOwner(self, "ANCHOR_TOP")
	GameTooltip:AddLine('Caution Triangle', 0, 192, 255, 1, 1)
	GameTooltip:Show()
end)

TriangleAuraMaskFrame:SetScript("OnLeave", function(self)
	self:SetAlpha(0.5)
	GameTooltip:Hide()
end)

TriangleAuraMaskFrame:SetScript("OnClick", function(self)
	private.db.dadefaults.setDefaultAuraMask.defaultAuraMask = "Interface\\DialogFrame\\UI-Dialog-Icon-AlertNew"
	DejaAuras_Init()
	DA_Cooldown_OnEvent()
	DA_Buff_OnEvent()
	DA_IOPPreviewBuffFrame.icon:SetMask(defaultAuraMask)
	DA_IOPPreviewBuffFrame.cooldown:SetSwipeTexture(defaultAuraMask)
	DA_IOPPreviewBuffFrame.cooldown:SetCooldown(GetTime(), 30)
end)

--Heart Aura Mask

local HeartAuraMaskFrame = CreateFrame("Button", "HeartAuraMaskFrame", DejaAurasPanel, "SecureActionButtonTemplate")
HeartAuraMaskFrame:RegisterForClicks("AnyUp")
HeartAuraMaskFrame:SetSize(36,36)
HeartAuraMaskFrame:SetPoint("TOP", DejaAurasPanel, "TOP", -42 , -218)
HeartAuraMaskFrame:SetNormalTexture("Interface\\PVPFrame\\PVP-BANNER-EMBLEM-4")
HeartAuraMaskFrame:SetAlpha(0.5)

HeartAuraMaskFrame.texture = HeartAuraMaskFrame:CreateTexture(nil,"BACKGROUND")
HeartAuraMaskFrame.texture:SetAllPoints(HeartAuraMaskFrame)
-- HeartAuraMaskFrame.texture:SetColorTexture(0, 192, 255, 0.7)

HeartAuraMaskFrame:SetScript("OnEnter", function(self)
	self:SetAlpha(1)
	GameTooltip:SetOwner(self, "ANCHOR_TOP")
	GameTooltip:AddLine('Heart, Aww! <3', 0, 192, 255, 1, 1)
	GameTooltip:Show()
end)

HeartAuraMaskFrame:SetScript("OnLeave", function(self)
	self:SetAlpha(0.5)
	GameTooltip:Hide()
end)

HeartAuraMaskFrame:SetScript("OnClick", function(self)
	private.db.dadefaults.setDefaultAuraMask.defaultAuraMask = "Interface\\PVPFrame\\PVP-BANNER-EMBLEM-4"
	DejaAuras_Init()
	DA_Cooldown_OnEvent()
	DA_Buff_OnEvent()
	DA_IOPPreviewBuffFrame.icon:SetMask(defaultAuraMask)
	DA_IOPPreviewBuffFrame.cooldown:SetSwipeTexture(defaultAuraMask)
	DA_IOPPreviewBuffFrame.cooldown:SetCooldown(GetTime(), 30)
end)

--Clean Square Aura Mask

local CleanSquareAuraMaskFrame = CreateFrame("Button", "CleanSquareAuraMaskFrame", DejaAurasPanel, "SecureActionButtonTemplate")
CleanSquareAuraMaskFrame:RegisterForClicks("AnyUp")
CleanSquareAuraMaskFrame:SetSize(36,36)
CleanSquareAuraMaskFrame:SetPoint("TOP", DejaAurasPanel, "TOP", -42 , -254)
CleanSquareAuraMaskFrame:SetNormalTexture("Interface\\AddOns\\DejaAuras\\Textures\\CleanSquareAuraMask")
CleanSquareAuraMaskFrame:SetAlpha(0.5)

CleanSquareAuraMaskFrame.texture = CleanSquareAuraMaskFrame:CreateTexture(nil,"BACKGROUND")
CleanSquareAuraMaskFrame.texture:SetAllPoints(CleanSquareAuraMaskFrame)
-- CleanSquareAuraMaskFrame.texture:SetColorTexture(0, 192, 255, 0.7)

CleanSquareAuraMaskFrame:SetScript("OnEnter", function(self)
	self:SetAlpha(1)
	GameTooltip:SetOwner(self, "ANCHOR_TOP")
	GameTooltip:AddLine('Clean Square', 0, 192, 255, 1, 1)
	GameTooltip:Show()
end)

CleanSquareAuraMaskFrame:SetScript("OnLeave", function(self)
	self:SetAlpha(0.5)
	GameTooltip:Hide()
end)

CleanSquareAuraMaskFrame:SetScript("OnClick", function(self)
	private.db.dadefaults.setDefaultAuraMask.defaultAuraMask = "Interface\\AddOns\\DejaAuras\\Textures\\CleanSquareAuraMask"
	DejaAuras_Init()
	DA_Cooldown_OnEvent()
	DA_Buff_OnEvent()
	DA_IOPPreviewBuffFrame.icon:SetMask(defaultAuraMask)
	DA_IOPPreviewBuffFrame.cooldown:SetSwipeTexture(defaultAuraMask)
	DA_IOPPreviewBuffFrame.cooldown:SetCooldown(GetTime(), 30)
end)

--Plus Sign Aura Mask

local PlusSignAuraMaskFrame = CreateFrame("Button", "PlusSignAuraMaskFrame", DejaAurasPanel, "SecureActionButtonTemplate")
PlusSignAuraMaskFrame:RegisterForClicks("AnyUp")
PlusSignAuraMaskFrame:SetSize(36,36)
PlusSignAuraMaskFrame:SetPoint("TOP", DejaAurasPanel, "TOP", -42 , -290)
PlusSignAuraMaskFrame:SetNormalTexture("Interface\\PaperDollInfoFrame\\Character-Plus")
PlusSignAuraMaskFrame:SetAlpha(0.5)

PlusSignAuraMaskFrame.texture = PlusSignAuraMaskFrame:CreateTexture(nil,"BACKGROUND")
PlusSignAuraMaskFrame.texture:SetAllPoints(PlusSignAuraMaskFrame)
-- PlusSignAuraMaskFrame.texture:SetColorTexture(0, 192, 255, 0.7)

PlusSignAuraMaskFrame:SetScript("OnEnter", function(self)
	self:SetAlpha(1)
	GameTooltip:SetOwner(self, "ANCHOR_TOP")
	GameTooltip:AddLine('Plus Sign', 0, 192, 255, 1, 1)
	GameTooltip:Show()
end)

PlusSignAuraMaskFrame:SetScript("OnLeave", function(self)
	self:SetAlpha(0.5)
	GameTooltip:Hide()
end)

PlusSignAuraMaskFrame:SetScript("OnClick", function(self)
	private.db.dadefaults.setDefaultAuraMask.defaultAuraMask = "Interface\\PaperDollInfoFrame\\Character-Plus"
	DejaAuras_Init()
	DA_Cooldown_OnEvent()
	DA_Buff_OnEvent()
	DA_IOPPreviewBuffFrame.icon:SetMask(defaultAuraMask)
	DA_IOPPreviewBuffFrame.cooldown:SetSwipeTexture(defaultAuraMask)
	DA_IOPPreviewBuffFrame.cooldown:SetCooldown(GetTime(), 30)
end)

--Skull 'n' Crossbones Aura Mask

local SkullnBonesAuraMaskFrame = CreateFrame("Button", "SkullnBonesAuraMaskFrame", DejaAurasPanel, "SecureActionButtonTemplate")
SkullnBonesAuraMaskFrame:RegisterForClicks("AnyUp")
SkullnBonesAuraMaskFrame:SetSize(36,36)
SkullnBonesAuraMaskFrame:SetPoint("TOP", DejaAurasPanel, "TOP", -42 , -326)
SkullnBonesAuraMaskFrame:SetNormalTexture("Interface\\LootFrame\\LootPanel-Icon")
SkullnBonesAuraMaskFrame:SetAlpha(0.5)

SkullnBonesAuraMaskFrame.texture = SkullnBonesAuraMaskFrame:CreateTexture(nil,"BACKGROUND")
SkullnBonesAuraMaskFrame.texture:SetAllPoints(SkullnBonesAuraMaskFrame)
-- SkullnBonesAuraMaskFrame.texture:SetColorTexture(0, 192, 255, 0.7)

SkullnBonesAuraMaskFrame:SetScript("OnEnter", function(self)
	self:SetAlpha(1)
	GameTooltip:SetOwner(self, "ANCHOR_TOP")
	GameTooltip:AddLine("Skull 'n' Crossbones", 0, 192, 255, 1, 1)
	GameTooltip:Show()
end)

SkullnBonesAuraMaskFrame:SetScript("OnLeave", function(self)
	self:SetAlpha(0.5)
	GameTooltip:Hide()
end)

SkullnBonesAuraMaskFrame:SetScript("OnClick", function(self)
	private.db.dadefaults.setDefaultAuraMask.defaultAuraMask = "Interface\\LootFrame\\LootPanel-Icon"
	DejaAuras_Init()
	DA_Cooldown_OnEvent()
	DA_Buff_OnEvent()
	DA_IOPPreviewBuffFrame.icon:SetMask(defaultAuraMask)
	DA_IOPPreviewBuffFrame.cooldown:SetSwipeTexture(defaultAuraMask)
	DA_IOPPreviewBuffFrame.cooldown:SetCooldown(GetTime(), 30)
end)

--Gauntlet Aura Mask

local GauntletAuraMaskFrame = CreateFrame("Button", "GauntletAuraMaskFrame", DejaAurasPanel, "SecureActionButtonTemplate")
GauntletAuraMaskFrame:RegisterForClicks("AnyUp")
GauntletAuraMaskFrame:SetSize(36,36)
GauntletAuraMaskFrame:SetPoint("TOP", DejaAurasPanel, "TOP", -6 , -362)
GauntletAuraMaskFrame:SetNormalTexture("Interface\\PVPFrame\\PVP-Banner-Emblem-7")
GauntletAuraMaskFrame:SetAlpha(0.5)

GauntletAuraMaskFrame.texture = GauntletAuraMaskFrame:CreateTexture(nil,"BACKGROUND")
GauntletAuraMaskFrame.texture:SetAllPoints(GauntletAuraMaskFrame)
-- GauntletAuraMaskFrame.texture:SetColorTexture(0, 192, 255, 0.7)

GauntletAuraMaskFrame:SetScript("OnEnter", function(self)
	self:SetAlpha(1)
	GameTooltip:SetOwner(self, "ANCHOR_TOP")
	GameTooltip:AddLine("Gauntlet", 0, 192, 255, 1, 1)
	GameTooltip:Show()
end)

GauntletAuraMaskFrame:SetScript("OnLeave", function(self)
	self:SetAlpha(0.5)
	GameTooltip:Hide()
end)

GauntletAuraMaskFrame:SetScript("OnClick", function(self)
	private.db.dadefaults.setDefaultAuraMask.defaultAuraMask = "Interface\\PVPFrame\\PVP-Banner-Emblem-7"
	DejaAuras_Init()
	DA_Cooldown_OnEvent()
	DA_Buff_OnEvent()
	DA_IOPPreviewBuffFrame.icon:SetMask(defaultAuraMask)
	DA_IOPPreviewBuffFrame.cooldown:SetSwipeTexture(defaultAuraMask)
	DA_IOPPreviewBuffFrame.cooldown:SetCooldown(GetTime(), 30)
end)

--Hazzard Aura Mask

local HazzardAuraMaskFrame = CreateFrame("Button", "HazzardAuraMaskFrame", DejaAurasPanel, "SecureActionButtonTemplate")
HazzardAuraMaskFrame:RegisterForClicks("AnyUp")
HazzardAuraMaskFrame:SetSize(36,36)
HazzardAuraMaskFrame:SetPoint("TOP", DejaAurasPanel, "TOP", -42 , -362)
HazzardAuraMaskFrame:SetNormalTexture("Interface\\PVPFrame\\PVP-Banner-Emblem-3")
HazzardAuraMaskFrame:SetAlpha(0.5)

HazzardAuraMaskFrame.texture = HazzardAuraMaskFrame:CreateTexture(nil,"BACKGROUND")
HazzardAuraMaskFrame.texture:SetAllPoints(HazzardAuraMaskFrame)
-- HazzardAuraMaskFrame.texture:SetColorTexture(0, 192, 255, 0.7)

HazzardAuraMaskFrame:SetScript("OnEnter", function(self)
	self:SetAlpha(1)
	GameTooltip:SetOwner(self, "ANCHOR_TOP")
	GameTooltip:AddLine("Hazzard", 0, 192, 255, 1, 1)
	GameTooltip:Show()
end)

HazzardAuraMaskFrame:SetScript("OnLeave", function(self)
	self:SetAlpha(0.5)
	GameTooltip:Hide()
end)

HazzardAuraMaskFrame:SetScript("OnClick", function(self)
	private.db.dadefaults.setDefaultAuraMask.defaultAuraMask = "Interface\\PVPFrame\\PVP-Banner-Emblem-3"
	DejaAuras_Init()
	DA_Cooldown_OnEvent()
	DA_Buff_OnEvent()
	DA_IOPPreviewBuffFrame.icon:SetMask(defaultAuraMask)
	DA_IOPPreviewBuffFrame.cooldown:SetSwipeTexture(defaultAuraMask)
	DA_IOPPreviewBuffFrame.cooldown:SetCooldown(GetTime(), 30)
end)

--Gradient Square Aura Mask

local GradientSquareAuraMaskFrame = CreateFrame("Button", "GradientSquareAuraMaskFrame", DejaAurasPanel, "SecureActionButtonTemplate")
GradientSquareAuraMaskFrame:RegisterForClicks("AnyUp")
GradientSquareAuraMaskFrame:SetSize(36,36)
GradientSquareAuraMaskFrame:SetPoint("TOP", DejaAurasPanel, "TOP", -43 , -398) -- Minus 1 on X axis so there is separation is background color texture.
GradientSquareAuraMaskFrame:SetNormalTexture("Interface\\GLUES\\CHARACTERCREATE\\UI-CharacterCreate-IconShadow")
GradientSquareAuraMaskFrame:SetAlpha(0.5)

GradientSquareAuraMaskFrame.texture = GradientSquareAuraMaskFrame:CreateTexture(nil,"BACKGROUND")
GradientSquareAuraMaskFrame.texture:SetAllPoints(GradientSquareAuraMaskFrame)
GradientSquareAuraMaskFrame.texture:SetColorTexture(0, 192, 255, 0.7)

GradientSquareAuraMaskFrame:SetScript("OnEnter", function(self)
	self:SetAlpha(1)
	GameTooltip:SetOwner(self, "ANCHOR_TOP")
	GameTooltip:AddLine('Gradient Edged Square.', 0, 192, 255, 1, 1)
	GameTooltip:Show()
end)

GradientSquareAuraMaskFrame:SetScript("OnLeave", function(self)
	self:SetAlpha(0.5)
	GameTooltip:Hide()
end)

GradientSquareAuraMaskFrame:SetScript("OnClick", function(self)
	private.db.dadefaults.setDefaultAuraMask.defaultAuraMask = "Interface\\GLUES\\CHARACTERCREATE\\UI-CharacterCreate-IconShadow"
	DejaAuras_Init()
	DA_Cooldown_OnEvent()
	DA_Buff_OnEvent()
	DA_IOPPreviewBuffFrame.icon:SetMask(defaultAuraMask)
	DA_IOPPreviewBuffFrame.cooldown:SetSwipeTexture(defaultAuraMask)
	DA_IOPPreviewBuffFrame.cooldown:SetCooldown(GetTime(), 30)
end)

--Gradient Circle Aura Mask

local GradientCircleAuraMaskFrame = CreateFrame("Button", "GradientCircleAuraMaskFrame", DejaAurasPanel, "SecureActionButtonTemplate")
GradientCircleAuraMaskFrame:RegisterForClicks("AnyUp")
GradientCircleAuraMaskFrame:SetSize(36,36)
GradientCircleAuraMaskFrame:SetPoint("TOP", DejaAurasPanel, "TOP", -5 , -398) -- Plus 1 on X axis so there is separation is background color texture.
GradientCircleAuraMaskFrame:SetNormalTexture("Interface\\GLUES\\Models\\UI_NightElf\\gradient5Circle")
GradientCircleAuraMaskFrame:SetAlpha(0.5)

GradientCircleAuraMaskFrame.texture = GradientCircleAuraMaskFrame:CreateTexture(nil,"BACKGROUND")
GradientCircleAuraMaskFrame.texture:SetAllPoints(GradientCircleAuraMaskFrame)
GradientCircleAuraMaskFrame.texture:SetColorTexture(0, 192, 255, 0.7)

GradientCircleAuraMaskFrame:SetScript("OnEnter", function(self)
	self:SetAlpha(1)
	GameTooltip:SetOwner(self, "ANCHOR_TOP")
	GameTooltip:AddLine("Gradient Edged Circle", 0, 192, 255, 1, 1)
	GameTooltip:Show()
end)

GradientCircleAuraMaskFrame:SetScript("OnLeave", function(self)
	self:SetAlpha(0.5)
	GameTooltip:Hide()
end)

GradientCircleAuraMaskFrame:SetScript("OnClick", function(self)
	private.db.dadefaults.setDefaultAuraMask.defaultAuraMask = "Interface\\GLUES\\Models\\UI_NightElf\\gradient5Circle"
	DejaAuras_Init()
	DA_Cooldown_OnEvent()
	DA_Buff_OnEvent()
	DA_IOPPreviewBuffFrame.icon:SetMask(defaultAuraMask)
	DA_IOPPreviewBuffFrame.cooldown:SetSwipeTexture(defaultAuraMask)
	DA_IOPPreviewBuffFrame.cooldown:SetCooldown(GetTime(), 30)
end)
