-- Variables --
local rogueAbilities = {408, 703, 1833, 6770};
local rogueAbilitiesNum = #rogueAbilities;
local rogueAbilitiesNames = {};

local druidAbilities = {1822, 22570}
local druidAbilitiesNum = #druidAbilities;
local druidAbilitiesNames = {};

local pvpFrame = CreateFrame("Frame", "DarkrunePVPFrame");
local settingsFrame = CreateFrame("Frame", "DarkruneSettingsFrame");
local shouted = false;
local expiration = nil;

local prestigeIconPath = "Interface\\PVPFrame\\Icons\\prestige-icon-";

-- Global functions
function DLU.honorLeft()
	local text = "You need %i honor to get to Honor Rank %i";
	local prestige = UnitPrestige("player");
	local restedHonor = GetHonorExhaustion();
	local honorNeeded = UnitHonorMax("player") - UnitHonor("player");
	local nextHonorRank = UnitHonorLevel("player") + 1;
	
	text = format(text, honorNeeded, nextHonorRank);
	if (prestige > 0 and prestige ~= nil) then
		text = format(text .. " (Prestige %i%s)", prestige, DLU.iconToText(prestigeIconPath .. prestige));
	end
	
	text = text .. ".";
	
	if (restedHonor ~= nil and restedHonor > 0) then
		restedHonor = format("|cff%s%i|r", DLU.RGBPercToHex(1.0, 0.71, 0.0), restedHonor);
		text = format(text .. " You have %s rested honor.", restedHonor);
	end
	
	print(text);
end

function DLU.SendAlert(alert, link)
	local alertMessage = format(alert, DLU.prefix, link);
	SendChatMessage(alertMessage, "YELL");
end

-- Settings functions
local function loadAbilityNames(abilityNum, abilities, abilityNames)
	for i = 1, abilityNum do
		local name = GetSpellInfo(abilities[i]);
		abilityNames[i] = name;
	end
end

-- Settings
local function loadTables()
	loadAbilityNames(rogueAbilitiesNum, rogueAbilities, rogueAbilitiesNames);
	loadAbilityNames(druidAbilitiesNum, druidAbilities, druidAbilitiesNames);
end

-- functions
local function checkForDebuffRogue()
	for i = 1, rogueAbilitiesNum do
		if (UnitDebuff("player", rogueAbilitiesNames[i])) then
			local _, _, _, _, _, _, expirationTime, _, _, _, spellId = UnitDebuff("player", rogueAbilitiesNames[i]);
			expiration = expirationTime;
			link = GetSpellLink(spellId);
			
			if (shouted == false) then
				DLU.SendAlert("%s Rogue detected! (got hit by %s)", link);
				shouted = true;
			end
		end
	end
	
	if (expiration ~= nil and expiration <= GetTime()) then
		shouted = false;
		expiration = nil;
	end
end

local function checkForDebuffDruid()
	for i = 1, druidAbilitiesNum do
		if (UnitDebuff("player", druidAbilitiesNames[i])) then
			local _, _, _, _, _, _, expirationTime, _, _, _, spellId = UnitDebuff("player", druidAbilitiesNames[i]);
			expiration = expirationTime;
			link = GetSpellLink(spellId);
			
			if (shouted == false) then
				DLU.SendAlert("%s Druid detected! (got hit by %s)", link);
				shouted = true;
			end
		end
	end
	
	if (expiration ~= nil and expiration <= GetTime()) then
		shouted = false;
		expiration = nil;
	end
end

local function checkForDebuffs()
	if (DLUSettings.pvp.value and UnitInBattleground("player")) then
		checkForDebuffDruid();
		checkForDebuffRogue();
	end
end

-- Adding event --
settingsFrame:RegisterEvent("PLAYER_LOGIN");
settingsFrame:SetScript("OnEvent", function()
DLU.getSettings()
loadTables();

pvpFrame:RegisterEvent("UNIT_AURA");
pvpFrame:SetScript("OnEvent", checkForDebuffs);

settingsFrame:UnregisterEvent("PLAYER_LOGIN");
end)