--
local _, addonData = ...;

-- Frames
local playerFrame = CreateFrame("Frame", "DLUPlayerFrame");
local professionFrame = CreateFrame("Frame", "DLUProfessionFrame");

-- Variables
local maxLevel = GetMaxPlayerLevel();
local class, classFileName = UnitClass("player");
local factionGroup, factionName = UnitFactionGroup("player");

-- Leveling tables
local startingAreas = {4,9,20,27,30,41,462,464};
local levelingTable = {
	[10] = {13,14},
	[60] = {466,485},
	[80] = {606,613,640,700,720,862},
	[90] = {962},
	[100] = {1007},
	[110] = {1184} -- Change this after BfA get's released
};

-- Setting globals
DLU.player.faction = factionName;
DLU.player.level = UnitLevel("player");

function DLU.player.getRidingSkill()
	local riding_data = {33388,33391,34090,34091,90265};
	local riding_skill = 0;
	for i=#riding_data, 1, -1 do
		if (IsSpellKnown(riding_data[i])) then
			riding_skill = i*75;
			break;
		end
	end

	return riding_skill;
end

-- Helper functions
local function getFactionColorId(factionName)
	local factionId = nil;

	if (factionGroup == "Horde") then
		factionId = 0;
	elseif (factionGroup == "Alliance") then
		factionId = 1;
	end

	return factionId;
end

local function getFactionColor(factionName)
	local factionColorId = getFactionColorId(factionName);
	local factionString = nil;
	if (factionColorId ~= nil) then
		factionString = "|cff" .. DLU.RGBPercToHex(PLAYER_FACTION_COLORS[factionColorId].r, PLAYER_FACTION_COLORS[factionColorId].g, PLAYER_FACTION_COLORS[factionColorId].b) .. factionName .. "|r";
	else
		if (factionName ~= "") then
			factionString = factionName;
		else
			factionString = factionGroup;
		end
	end

	return factionString;
end

local function checkLevelingTable()
	for level, zoneId in pairs(levelingTable) do
		local zoneName = GetMapNameByID(zoneId);
		print(format("%s (%i)", zoneName, level));
	end
end

-- Player info --
local characterInfo = {
	name = UnitName("player"),
	gender = DLU.genderTable[UnitSex("player")],
	class = classFileName,
	classWithColor = "|c" .. RAID_CLASS_COLORS[classFileName].colorStr .. class .. "|r",
	race = UnitRace("player"),
	faction = getFactionColor(factionName)
}

-- Functions
local function getExpansionName()
	local expansion = GetExpansionLevel()+1;
	local expansionTable = {"WoW: Vanilla", "WoW: The Burning Crusade", "WoW: Wrath of the Lich King", "WoW: Cataclysm", "WoW: Mists of Pandaria", "WoW: Warlords of Draenor", "WoW: Legion"};

	local expansionName = "Unknown";
	if (expansionTable[expansion] ~= nil) then
		expansionName = expansionTable[expansion];
	end

	return expansionName;
end

local function playerLevelUp(self, event, ...)
	local newLevel = ...;
	DLU.player.level = newLevel;
	
	local mapId = GetCurrentMapAreaID();
	local _, _, _, _, _, _, _, minLevel, maxLevel = GetAreaMapInfo(mapId);
	
	if (DLU.player.level >= maxLevel and maxLevel > 0) then -- Zones without level brackets will tell maxLevel is zero
		local text = addonData.L.ZoneText;
		
		if (levelingTable[newLevel] ~= nil) then
			local zones = #levelingTable[newLevel];
			local counter = 0;
			
			for _, v in ipairs(levelingTable[newLevel]) do
				local zoneName = GetMapNameByID(v);
				if (counter == zones-1) then
					if (#zones > 1) then
						text = format(text .. " or %s", zoneName);
					else
						text = format(text .. "%s", zoneName);
					end
				else
					text = format(text .. ", %s", zoneName);
				end
				counter = counter +1;
			end
		else
			text = format(text .. " another area to level up more quickly");
		end
		
		DLU.createNotification(text, "leveling");
	end
end

-- Events
playerFrame:RegisterEvent("PLAYER_LEVEL_UP");
playerFrame:SetScript("OnEvent", playerLevelUp);