-- Variables --
local maxLevel = GetMaxPlayerLevel();
local partyFrame = CreateFrame("Frame", "DarkrunePartyFrame");
local settingsFrame = CreateFrame("Frame", "DarkruneSettingsFrame");

-- Global functions
function DLU.notifyParty(message)
	local message = format("%s %s", DLU.prefix, message);
	
	if (UnitInParty("player")) then
		if (IsInGroup(LE_PARTY_CATEGORY_INSTANCE)) then
			SendChatMessage(message, "INSTANCE_CHAT");
		elseif (IsInGroup()) then
			SendChatMessage(message, "PARTY");
		end
	end
end

-- Important functions --
local function partyLevelUp(self, event, unitID)
	if (UnitInParty(unitID) and UnitPlayerControlled(unitID) and not UnitIsUnit(unitID, "player") and not IsInRaid() and DLUSettings.party.value) then
		local partyMemberName = UnitName(unitID);
		local _, classFileName = UnitClass(unitID);
		local newLevel = UnitLevel(unitID);
		
		local congratzTable = CLASS_TALENT_LEVELS["DEFAULT"];
		
		if (classFileName == CLASS_SORT_ORDER[2] or classFileName == CLASS_SORT_ORDER[12]) then
			congratzTable = CLASS_TALENT_LEVELS[classFileName];
		end
		
		for _, level in pairs(congratzTable) do
			if (level == newLevel) then
				local randomCongratz = {"Gratz, %s", "Gz, %s", "Keep it up, %s"};
				local congratzString = string.format(randomCongratz[math.random(#randomCongratz)], partyMemberName);
				DLU.notifyParty(congratzString);
				break;
			end
		end
	end
end

-- Adding event --
settingsFrame:RegisterEvent("PLAYER_LOGIN");
settingsFrame:SetScript("OnEvent", function()
DLU.getSettings()

partyFrame:RegisterEvent("UNIT_LEVEL");
partyFrame:SetScript("OnEvent", partyLevelUp);

settingsFrame:UnregisterEvent("PLAYER_LOGIN");
end)