-- Copyright © 2008 - 2016 Xianghar
-- All Rights Reserved.
-- This code is not to be modified or distributed without written permission by the author.
-- Current distribution permissions only include curse.com, wowinterface.com and their respective addon updaters

if select(2,UnitClass("player")) ~= XiTimersClass then return end

local SpellRange = LibStub("SpellRange-1.0")

DHTimers.SpellIDs = {
	Nemesis = 206491,
	FelEruption = 211881,
	Blur = 198589,
	BlurBuff = 212800,
	Netherwalk = 196555,
	DesperateInstincts = 205411,
	Metamorphosis = 191427,
	MetamorphosisBuff = 162264,
	Darkness = 196718,
	DarknessBuff = 209426,
	SpectralSight = 188501,
	ChaosBlades = 211048,
	FelBarrage = 211053,
	MetamorphosisVengeance = 187827,
	ChaosNova = 179057,
	FieryBrand = 204021,
	EyeBeam = 198013,
	ImmolationAura = 178740,
	FelRush = 195072,
	InfernalStrike = 189110,
	VengefulRetreat = 198793,
	DemonSpikes = 203720,
	DemonSpikesBuff = 203819,
	DemonsBite = 162243,
	Shear = 203782,
	BladeDance = 188499,
	SigilOfFlame = 204596,	
	ChaosStrike = 162794,
	SoulCleave = 228477,
	ThrowGlaive = 185123,
	ThrowGlaiveVengeance = 204157,
	Torment = 185245,
	FelBlade = 213241,
	FelEruption = 211881,
	FelDevastation = 212084,
	SpiritBomb = 218679,
	NetherBond = 207810,
	SoulBarrier = 227225,
	SoulFragments = 203981,
	DeathSweep = 210152,
	Annihilation = 201427,
	Shear = 203782,
	Sever = 235964,
}

local SpellIDs = DHTimers.SpellIDs
local BladeDanceID = DHTimers.SpellIDs.BladeDance

XiTimers.SpellData = {
	[SpellIDs.Nemesis] = {
		--Todo: Custom function for debuff
		alt = {
			SpellIDs.FelEruption,
		},
	},
	[SpellIDs.FelEruption] = {
		alt = {
			SpellIDs.Nemesis,
		},
	},
	[SpellIDs.Blur] = {
		buff = SpellIDs.BlurBuff,
		alt = {
			SpellIDs.Netherwalk,
			SpellIDs.DesperateInstincts,
			SpellIDs.Torment,
		},
	},
	[SpellIDs.Netherwalk] = {
		buff = SpellIDs.Netherwalk,
		button = SpellIDs.Blur,
		alt = {
			SpellIDs.Blur,
			SpellIDs.DesperateInstincts,
		},
	},
	[SpellIDs.DesperateInstincts] = {
		buff = SpellIDs.BlurBuff,
		--Todo: Custom timer when buff ends
		alt = {
			SpellIDs.Blur,
			SpellIDs.Netherwalk,
		},
	},
	[SpellIDs.Metamorphosis] = {
		buff = SpellIDs.MetamorphosisBuff,
		alt = {
			SpellIDs.MetamorphosisVengeance,
		},
	},
	[SpellIDs.Darkness] = {
		buff = SpellIDs.DarknessBuff,
	},
	[SpellIDs.SpectralSight] = {
		SpellIDs.SpectralSight,
	},
	[SpellIDs.ChaosBlades] = {
		buff = SpellIDs.ChaosBlades,
		alt = {
			SpellIDs.FelBarrage,
		},
	},
	[SpellIDs.FelBarrage] = {
		alt = {
			SpellIDs.ChaosBlades,
		},
	},
	[SpellIDs.MetamorphosisVengeance] = {
		buff = SpellIDs.MetamorphosisVengeance,
		button = SpellIDs.Metamorphosis,		
	},
	[SpellIDs.ChaosNova] = {
		alt = {
			SpellIDs.FieryBrand,
		},
	},
	[SpellIDs.FieryBrand] = {
		button = SpellIDs.ChaosNova,
	},
	[SpellIDs.EyeBeam] = {
		alt = {
			SpellIDs.ImmolationAura,
		}
	},
	[SpellIDs.ImmolationAura] = {
		buff = SpellIDs.ImmolationAura,
		button = SpellIDs.EyeBeam,
	},
	[SpellIDs.FelRush] = {
		alt = {
			SpellIDs.InfernalStrike,
		},
	},
	[SpellIDs.InfernalStrike] = {
		button = SpellIDs.FelRush,
	},
	[SpellIDs.VengefulRetreat] = {
		alt = {
			SpellIDs.DemonSpikes,
		},
	},
	[SpellIDs.DemonSpikes] = {
		buff = SpellIDs.DemonSpikesBuff,
		button = SpellIDs.VengefulRetreat,
	},
	[SpellIDs.DemonsBite] = {
		alt = {
			SpellIDs.Shear
		},
	},
	[SpellIDs.Shear] = { button = SpellIDs.DemonsBite },
	[SpellIDs.BladeDance] = {
		roles = {
			[1] = {
				continuousUpdate = 
					function(self)
						local inRange = 0
						for i = 1, 40 do
							local unit = "nameplate"..i
							if UnitExists(unit) and not UnitIsFriend("player", unit) then
								if IsItemInRange("item:34368", unit) then
									inRange = inRange + 1
								end								
							end
						end
						if inRange > 0 then
							self.button.count:SetText(inRange)
							self.button.count:Show()
						else
							self.button.count:Hide()
						end
					end,
				tempUpgrade = { SpellIDs.DeathSweep },
			},			
		},
		alt = { SpellIDs.SigilOfFlame },
	},
	[SpellIDs.SigilOfFlame] = { button = SpellIDs.BladeDance },
	[SpellIDs.ChaosStrike] = { alt = { SpellIDs.SoulCleave }, tempUpgrade = { SpellIDs.Annihilation }, },
	[SpellIDs.SoulCleave] = { buff = SpellIDs.SoulFragments, button = SpellIDs.ChaosStrike, noCooldownAfterBuff = true, }, 
	[SpellIDs.ThrowGlaive] = { alt = { SpellIDs.ThrowGlaiveVengeance }, },
	[SpellIDs.ThrowGlaiveVengeance] = { button = SpellIDs.ThrowGlaive },
	[SpellIDs.Torment] = { button = SpellIDs.Blur },
	[SpellIDs.FelBlade] = { alt = { SpellIDs.FelEruption }, },
	[SpellIDs.FelEruption] = { alt = { SpellIDs.FelBlade }, },
	[SpellIDs.FelDevastation] = { alt = { SpellIDs.SpiritBomb }, },
	[SpellIDs.SpiritBomb] = { alt = { SpellIDs.FelDevastation }, },
	[SpellIDs.NetherBond] = {
		buff = SpellIDs.NetherBond,
		alt = {
			SpellIDs.SoulBarrier,
		},
	},
	[SpellIDs.SoulBarrier] = {
		buff = SpellIDs.SoulBarrier,
		alt = {
			SpellIDs.NetherBond,
		},
	},
	[SpellIDs.Shear] = {
		tempUpgrade = { SpellIDs.Sever },
	}
}




