local frame = CreateFrame("Frame");
local loadedFrame = CreateFrame("Frame");
local unloadFrame = CreateFrame("Frame");
local sentCount = 0;
local db;
local ADDON_NAME = "CourtOfSilliness";
local COS = {};
local started = false;
local specialExists = false;
local specialSaid = false;
COS.Channel = "PARTY";
SLASH_COS1, SLASH_COS2 = '/courtofsilliness', '/cos';
local function handler(msg, editbox)
	local command, rest = msg:match("^(%S*)%s*(.-)$");
	 -- Any leading non-whitespace is captured into command;
	 -- the rest (minus leading whitespace) is captured into rest.
	if command == "add" and rest ~= "" then
		COS.AddItem(rest);
	elseif command == "remove" and rest ~= "" then
		COS.RemoveItem(rest);
	elseif command == "list" then
		COS.List();
	elseif command == "random" then
		local item = COS.GetItem();
		if item then
			COS.SendMessage(item)
		end
	elseif command == "clear" then
		COS.Clear();
	elseif command == "start" then
		COS.Clear();
		if rest == "say" then
			COS.Channel = "SAY";
		else
			COS.Channel = "PARTY";
		end
		if(UnitDebuff("player", 213213) == nil) then
			COS.StartTimer();
		end
	elseif command == "change" then
		if rest == "say" then
			COS.Channel = "SAY";
		else
			COS.Channel = "PARTY";
		end
		print('Channel say to ' .. COS.Channel);
	elseif command  == "stop" then
		sentCount = 99;
		print("Court of Silliness stopped. Use /cos start (say/party) to restart");
	else
	  -- If not handled above, display some sort of help message
		print("Syntax: /cos (add|remove|list|clear|change|start|stop) chattype ");
	end
end
SlashCmdList["COS"] = handler;

frame:RegisterEvent("UNIT_AURA");
loadedFrame:RegisterEvent("ADDON_LOADED");
unloadFrame:RegisterEvent("PLAYER_LOGOUT");

function COS.Clear()
	sentCount = 0;
	started = false;
	specialSaid = false;
	for k,v in pairs(COS.Exists) do COS.Exists[k]=nil end
	print("items cleared. Use /cos start (party/say) to restart.");
end

function COS.List() 
	for key,value in pairs(db.Phrases) do print(key,value) end
end
function COS.AddItem(item)
	if not(tContains(db.Phrases, item)) then
		table.insert(db.Phrases, item);
	end
	print(item .. ' added');
end
function COS.RemoveItem(item)
	local i= 1;
	while db.Phrases[i] do
		if ( item == db.Phrases[i] ) then
			table.remove(db.Phrases, i);
			print(item .. ' removed');
			return;
		end
		i = i + 1;
	end
end

function COS.SpecialExists()
	local i = 1;
	if(db.Special ~= nil) then
		while db.Special[i] do
			if(UnitInParty(db.Special[i])) then
				specialExists = true;
				return;
			end;
			i = i + 1;
		end
	end
end

function COS.ItemUsed(item)
	for key, value in pairs(COS.Exists) do
		if(item == value) then
			return true;				
		end
	end
	return false;
end

function COS.GetItem() 
	local count = #(db.Phrases);
	local i = math.random(1,#(db.Phrases));
	local item = db.Phrases[i];
	if(specialExists and specialSaid ~= true) then
		specialSaid = true;
		return db.Special[1] .. db.SpecialPhrase;
	end	
	if(COS.ItemUsed(item) == false) then
		table.insert(COS.Exists, item);
		return item;
	elseif #(db.Phrases) ~= #(COS.Exists) then
		return COS.GetItem();
	else
		print('All items have been used. try /cos clear or /cos start to clear/start over')
	end
end


function COS.StartTimer()
	if(sentCount < 2) then
		C_Timer.After(math.random(14,25), function()
			local item = COS.GetItem();
			if item then
				COS.SendMessage(item);
				sentCount = sentCount + 1;
				COS.StartTimer();
			end
		end)
	end
end


function COS.SendMessage(item)
	if COS.Channel == "PARTY" and UnitInParty("player") then
		SendChatMessage(item, COS.Channel);
	else 
		SendChatMessage(item, "SAY");
	end
end

function COS.SetDefaults()
	CoSSaved.Phrases = {
		[1] = "fuzzy handcuffs",
		[2] = "hates avacado",
		[3] = "cock ring",
		[4] = "nipple piercings",
		[5] = "watches game of thrones",
		[6] = "eats popcorn",
		[7] = "loves platypi",
		[8] = "has gonorea",
		[9] = "enjoys long walks",
		[10] = "hairy feet",
		[11] = "hipster beard",
		[12] = "hates the beatles",
		[13] = "loves new kids on the block",
		[14] = "listens to justin bieber",
		[15] = '24" pythons',
		[16] = "giant pimple on nose",
	};
end
frame:SetScript("OnEvent", function(self, event, msg, sender,...) 	
	local a = UnitDebuff("player",213213)
	if (a and started ~= true) then
		print("starting Court of Silliness... enjoy");
		COS.SpecialExists();
		started = true;
		COS.StartTimer();
	end
end);
loadedFrame:SetScript("OnEvent", function(self,event,addon,...)
	COS.Exists = {}
	if event == "ADDON_LOADED" then
		CoSSaved = CoSSaved or {
		[1] = "fuzzy handcuffs",
		[2] = "hates avacado",
		[3] = "cock ring",
		[4] = "nipple piercings",
		[5] = "watches game of thrones",
		[6] = "eats popcorn",
		[7] = "loves platypi",
		[8] = "has gonorea",
		[9] = "enjoys long walks",
		[10] = "hairy feet",
		[11] = "hipster beard",
		[12] = "hates the beatles",
		[13] = "loves new kids on the block",
		[14] = "listens to justin bieber",
		[15] = '24" pythons',
		[16] = "giant pimple on nose",
		};
		if(CoSSaved.Phrases == nil) then --Add defaults or fix initial release variables
			if(next(CoSSaved) == nil) then
				print('nil');
				COS.SetDefaults();
			else -- fix old variables
				print('fixing')
				local temp = {};
				for k,v in pairs(CoSSaved) do 
					table.insert(temp, CoSSaved[k]);
					CoSSaved[k]=nil; 
				end
				CoSSaved.Phrases = temp;
			end
		end
		db = CoSSaved;
		
	end
end);

unloadFrame:SetScript("OnEvent", function(self)
	CoSSaved = db;
end);