CompletelyCollectedSets = {}
defaults = {
    global = {
        collected = true,
        notCollected = true
    }
};

CompletelyCollectedSets.db = LibStub('AceDB-3.0'):New('CompletelyCompleteSets', defaults);

local frame = CreateFrame("Frame", "CompletelyCollectedSetsEventHanderFrame");
frame:RegisterEvent("ADDON_LOADED");

local BASE_SET_BUTTON_HEIGHT = 46;
local SET_PROGRESS_BAR_MAX_WIDTH = 204;
local IN_PROGRESS_FONT_COLOR = CreateColor(0.251, 0.753, 0.251);

local function eventHandler(_self, event, addon, ...)
    if (addon == 'Blizzard_Collections') then

        function WardrobeFilterDropDown_InitializeBaseSets(_, level)
            local info = UIDropDownMenu_CreateInfo();
            info.keepShownOnClick = true;
            info.isNotRadio = true;

            info.text = COLLECTED;
            info.func = function(_, _, _, value)
                C_TransmogSets.SetBaseSetsFilter(LE_TRANSMOG_SET_FILTER_COLLECTED, false);
                C_TransmogSets.SetBaseSetsFilter(LE_TRANSMOG_SET_FILTER_COLLECTED, true);
                CompletelyCollectedSets.db.collected = value
            end
            info.checked = CompletelyCollectedSets.db.collected;
            UIDropDownMenu_AddButton(info, level);

            info.text = NOT_COLLECTED;
            info.func = function(_, _, _, value)
                C_TransmogSets.SetBaseSetsFilter(LE_TRANSMOG_SET_FILTER_UNCOLLECTED, value);
                CompletelyCollectedSets.db.notCollected = value
            end
            info.checked = C_TransmogSets.GetBaseSetsFilter(LE_TRANSMOG_SET_FILTER_UNCOLLECTED);
            CompletelyCollectedSets.db.notCollected = info.checked;
            UIDropDownMenu_AddButton(info, level);

            UIDropDownMenu_AddSeparator(info);
            -- reset to remove separator
            info = UIDropDownMenu_CreateInfo();
            info.keepShownOnClick = true;
            info.isNotRadio = true;

            info.text = TRANSMOG_SET_PVE;
            info.func = function(_, _, _, value)
                C_TransmogSets.SetBaseSetsFilter(LE_TRANSMOG_SET_FILTER_PVE, value);
            end
            info.checked = C_TransmogSets.GetBaseSetsFilter(LE_TRANSMOG_SET_FILTER_PVE);
            UIDropDownMenu_AddButton(info, level);

            info.text = TRANSMOG_SET_PVP;
            info.func = function(_, _, _, value)
                C_TransmogSets.SetBaseSetsFilter(LE_TRANSMOG_SET_FILTER_PVP, value);
            end
            info.checked = C_TransmogSets.GetBaseSetsFilter(LE_TRANSMOG_SET_FILTER_PVP);
            UIDropDownMenu_AddButton(info, level);
        end

        function WardrobeSetsDataProviderMixin:GetBaseSets()
            if ( not self.baseSets ) then
                local allBaseSets = C_TransmogSets.GetBaseSets();
                if(CompletelyCollectedSets.db.collected) then
                    self.baseSets = allBaseSets;
                elseif (not CompletelyCollectedSets.db.collected and not CompletelyCollectedSets.db.notCollected) then
                    self.baseSets = {};
                else
                    local tempBaseSets = { }

                    for key, value in pairs(allBaseSets) do
                        local variants  = WardrobeSetsDataProviderMixin:GetVariantSets(value.setID)
                        local count = table.getn(variants)

                        if(count == 0 and not value.collected) then
                            table.insert(tempBaseSets, value)
                        end

                        for key2, value2 in pairs(variants) do
                            if(not value2.collected) then
                                table.insert(tempBaseSets, value)
                                break
                            end
                        end
                    end

                    self.baseSets = tempBaseSets
                end

                self:DetermineFavorites();
                self:SortSets(self.baseSets);
            end

            return self.baseSets
        end

        local newSetsDataProvider = CreateFromMixins(WardrobeSetsDataProviderMixin);

        function WardrobeCollectionFrame.SetsCollectionFrame.HandleKey(obj, key)
            if ( not obj:GetSelectedSetID() ) then
                return false;
            end
            local selectedSetID = C_TransmogSets.GetBaseSetID(obj:GetSelectedSetID());
            local _, index = newSetsDataProvider:GetBaseSetByID(selectedSetID);
            if ( not index ) then
                return;
            end
            if ( key == WARDROBE_DOWN_VISUAL_KEY ) then
                index = index + 1;
            elseif ( key == WARDROBE_UP_VISUAL_KEY ) then
                index = index - 1;
            end
            local sets = newSetsDataProvider:GetBaseSets();
            index = Clamp(index, 1, #sets);
            obj:SelectSet(obj:GetDefaultSetIDForBaseSet(sets[index].setID));
            obj:ScrollToSet(sets[index].setID);
        end

        function WardrobeCollectionFrame.SetsCollectionFrame.ScrollToSet(obj, setID)
            local totalHeight = 0;
            local scrollFrameHeight = obj.ScrollFrame:GetHeight();
            local buttonHeight = obj.ScrollFrame.buttonHeight;
            for i, set in ipairs(newSetsDataProvider:GetBaseSets()) do
                if ( set.setID == setID ) then
                    local offset = obj.ScrollFrame.scrollBar:GetValue();
                    if ( totalHeight + buttonHeight > offset + scrollFrameHeight ) then
                        offset = totalHeight + buttonHeight - scrollFrameHeight;
                    elseif ( totalHeight < offset ) then
                        offset = totalHeight;
                    end
                    obj.ScrollFrame.scrollBar:SetValue(offset, true);
                    break;
                end
                totalHeight = totalHeight + buttonHeight;
            end
        end

        function WardrobeCollectionFrame.SetsCollectionFrame.ScrollFrame.Update(obj)
            local offset = HybridScrollFrame_GetOffset(obj);
            local buttons = obj.buttons;
            local baseSets = newSetsDataProvider:GetBaseSets();

            -- show the base set as selected
            local selectedSetID = obj:GetParent():GetSelectedSetID();
            local selectedBaseSetID = selectedSetID and C_TransmogSets.GetBaseSetID(selectedSetID);

            for i = 1, #buttons do
                local button = buttons[i];
                local setIndex = i + offset;
                if ( setIndex <= #baseSets ) then
                    local baseSet = baseSets[setIndex];
                    button:Show();
                    button.Name:SetText(baseSet.name);
                    local topSourcesCollected, topSourcesTotal = newSetsDataProvider:GetSetSourceTopCounts(baseSet.setID);
                    local setCollected = C_TransmogSets.IsBaseSetCollected(baseSet.setID);
                    local color = IN_PROGRESS_FONT_COLOR;
                    if ( setCollected ) then
                        color = NORMAL_FONT_COLOR;
                    elseif ( topSourcesCollected == 0 ) then
                        color = GRAY_FONT_COLOR;
                    end
                    button.Name:SetTextColor(color.r, color.g, color.b);
                    button.Label:SetText(baseSet.label);
                    button.Icon:SetTexture(newSetsDataProvider:GetIconForSet(baseSet.setID));
                    button.Icon:SetDesaturation((topSourcesCollected == 0) and 1 or 0);
                    button.SelectedTexture:SetShown(baseSet.setID == selectedBaseSetID);
                    button.Favorite:SetShown(baseSet.favoriteSetID);
                    button.New:SetShown(newSetsDataProvider:IsBaseSetNew(baseSet.setID));
                    button.setID = baseSet.setID;

                    if ( topSourcesCollected == 0 or setCollected ) then
                        button.ProgressBar:Hide();
                    else
                        button.ProgressBar:Show();
                        button.ProgressBar:SetWidth(SET_PROGRESS_BAR_MAX_WIDTH * topSourcesCollected / topSourcesTotal);
                    end
                    button.IconCover:SetShown(not setCollected);
                else
                    button:Hide();
                end
            end

            local extraHeight = (obj.largeButtonHeight and obj.largeButtonHeight - BASE_SET_BUTTON_HEIGHT) or 0;
            local totalHeight = #baseSets * BASE_SET_BUTTON_HEIGHT + extraHeight;
            HybridScrollFrame_Update(obj, totalHeight, obj:GetHeight());
        end

        WardrobeCollectionFrame.SetsCollectionFrame.ScrollFrame.update = WardrobeCollectionFrame.SetsCollectionFrame.ScrollFrame.Update

        function WardrobeCollectionFrame.SetsCollectionFrame.ScrollFrame.OnEvent(obj, event, ...)
            if ( event == "TRANSMOG_SETS_UPDATE_FAVORITE" ) then
                newSetsDataProvider:RefreshFavorites();
                obj:Update();
            end
        end

        function WardrobeCollectionFrame.SetsCollectionFrame.OnHide(obj)
            obj:UnregisterEvent("GET_ITEM_INFO_RECEIVED");
            obj:UnregisterEvent("TRANSMOG_COLLECTION_ITEM_UPDATE");
            obj:UnregisterEvent("TRANSMOG_COLLECTION_UPDATED");
            newSetsDataProvider:ClearSets();
            WardrobeCollectionFrame_ClearSearch(LE_TRANSMOG_SEARCH_TYPE_BASE_SETS);
        end

        function WardrobeCollectionFrame.SetsCollectionFrame.OnEvent(obj, event, ...)
            if ( event == "GET_ITEM_INFO_RECEIVED" ) then
                local itemID = ...;
                for itemFrame in obj.DetailsFrame.itemFramesPool:EnumerateActive() do
                    if ( itemFrame.itemID == itemID ) then
                        obj:SetItemFrameQuality(itemFrame);
                        break;
                    end
                end
            elseif ( event == "TRANSMOG_COLLECTION_ITEM_UPDATE" ) then
                for itemFrame in obj.DetailsFrame.itemFramesPool:EnumerateActive() do
                    obj:SetItemFrameQuality(itemFrame);
                end
            elseif ( event == "TRANSMOG_COLLECTION_UPDATED" ) then
                newSetsDataProvider:ClearSets();
                obj:Refresh();
                WardrobeCollectionFrame_UpdateProgressBar(C_TransmogSets.GetBaseSetsCounts());
                obj:ClearLatestSource();
            end
        end


        function WardrobeCollectionFrame.SetsCollectionFrame.OnSearchUpdate(obj)
            if ( obj.init ) then
                newSetsDataProvider:ClearBaseSets();
                newSetsDataProvider:ClearVariantSets();
                newSetsDataProvider:ClearUsableSets();
                obj:Refresh();
            end
        end

        function WardrobeCollectionFrame.SetsCollectionFrame.HandleKey(obj, key)
            if ( not obj:GetSelectedSetID() ) then
                return false;
            end
            local selectedSetID = C_TransmogSets.GetBaseSetID(obj:GetSelectedSetID());
            local _, index = newSetsDataProvider:GetBaseSetByID(selectedSetID);
            if ( not index ) then
                return;
            end
            if ( key == WARDROBE_DOWN_VISUAL_KEY ) then
                index = index + 1;
            elseif ( key == WARDROBE_UP_VISUAL_KEY ) then
                index = index - 1;
            end
            local sets = newSetsDataProvider:GetBaseSets();
            index = Clamp(index, 1, #sets);
            obj:SelectSet(obj:GetDefaultSetIDForBaseSet(sets[index].setID));
            obj:ScrollToSet(sets[index].setID);
        end

        function WardrobeCollectionFrame.SetsCollectionFrame.ScrollToSet(obj, setID)
            local totalHeight = 0;
            local scrollFrameHeight = obj.ScrollFrame:GetHeight();
            local buttonHeight = obj.ScrollFrame.buttonHeight;
            for i, set in ipairs(newSetsDataProvider:GetBaseSets()) do
                if ( set.setID == setID ) then
                    local offset = obj.ScrollFrame.scrollBar:GetValue();
                    if ( totalHeight + buttonHeight > offset + scrollFrameHeight ) then
                        offset = totalHeight + buttonHeight - scrollFrameHeight;
                    elseif ( totalHeight < offset ) then
                        offset = totalHeight;
                    end
                    obj.ScrollFrame.scrollBar:SetValue(offset, true);
                    break;
                end
                totalHeight = totalHeight + buttonHeight;
            end
        end
    end
end

frame:SetScript("OnEvent", eventHandler);


