local addonName, addon = ...
CinematicSkipperDB = CinematicSkipperDB or {}

local defaults = {
    skipAll = true,
    skipIfSeen = false,
    skipCinematics = true,
    skipMovies = true,
    skipIntros = true,
    seenVideos = {},
}

local function MergeDefaults(tbl, defs)
    for k, v in pairs(defs) do
        if type(v) == "table" then
            tbl[k] = tbl[k] or {}
            MergeDefaults(tbl[k], v)
        elseif tbl[k] == nil then
            tbl[k] = v
        end
    end
end

local function Print(msg)
    DEFAULT_CHAT_FRAME:AddMessage("|cffffd700[CinematicSkipper]|r "..tostring(msg))
end

local function ShowStatus()
    Print("Current settings:")
    Print("  skipAll: " .. tostring(CinematicSkipperDB.skipAll))
    Print("  skipIfSeen: " .. tostring(CinematicSkipperDB.skipIfSeen))
    Print("  skipCinematics: " .. tostring(CinematicSkipperDB.skipCinematics))
    Print("  skipMovies: " .. tostring(CinematicSkipperDB.skipMovies))
    Print("  skipIntros: " .. tostring(CinematicSkipperDB.skipIntros))
end

local function SetOption(option, value)
    if option == "skipall" then
        CinematicSkipperDB.skipAll = value
        Print("skipAll set to: " .. tostring(value))
    elseif option == "skipifseen" then
        CinematicSkipperDB.skipIfSeen = value
        Print("skipIfSeen set to: " .. tostring(value))
    elseif option == "skipcinematics" then
        CinematicSkipperDB.skipCinematics = value
        Print("skipCinematics set to: " .. tostring(value))
    elseif option == "skipmovies" then
        CinematicSkipperDB.skipMovies = value
        Print("skipMovies set to: " .. tostring(value))
    elseif option == "skipintros" then
        CinematicSkipperDB.skipIntros = value
        Print("skipIntros set to: " .. tostring(value))
    else
        Print("Unknown option: " .. tostring(option))
    end
end

SLASH_CINEMATICSKIPPER1 = "/cskip"
SLASH_CINEMATICSKIPPER2 = "/cinematicskipper"
SlashCmdList["CINEMATICSKIPPER"] = function(msg)
    local args = {}
    for word in msg:gmatch("%S+") do
        table.insert(args, word)
    end

    if #args == 0 or args[1] == "status" then
        ShowStatus()
    elseif args[1] == "skipall" and args[2] then
        SetOption("skipall", args[2] == "on" or args[2] == "true" or args[2] == "1")
    elseif args[1] == "skipifseen" and args[2] then
        SetOption("skipifseen", args[2] == "on" or args[2] == "true" or args[2] == "1")
    elseif args[1] == "skipcinematics" and args[2] then
        SetOption("skipcinematics", args[2] == "on" or args[2] == "true" or args[2] == "1")
    elseif args[1] == "skipmovies" and args[2] then
        SetOption("skipmovies", args[2] == "on" or args[2] == "true" or args[2] == "1")
    elseif args[1] == "skipintros" and args[2] then
        SetOption("skipintros", args[2] == "on" or args[2] == "true" or args[2] == "1")
    elseif args[1] == "help" then
        Print("Usage:")
        Print("/cskip status - Show current settings")
        Print("/cskip skipall on|off")
        Print("/cskip skipifseen on|off")
        Print("/cskip skipcinematics on|off")
        Print("/cskip skipmovies on|off")
        Print("/cskip skipintros on|off")
    else
        Print("Unknown command. Type /cskip help for help.")
    end
end

local frame = CreateFrame("Frame")
frame:RegisterEvent("PLAYER_LOGIN")
frame:SetScript("OnEvent", function(self, event, ...)
    if event == "PLAYER_LOGIN" then
        if not CinematicSkipperDB then CinematicSkipperDB = {} end
        MergeDefaults(CinematicSkipperDB, defaults)
        self:RegisterEvent("CINEMATIC_START")
        -- Try to register PLAY_MOVIE; if unsupported, it's ignored
        pcall(function() self:RegisterEvent("PLAY_MOVIE") end)
    elseif event == "CINEMATIC_START" then
        addon:HandleCinematic(...)
    elseif event == "PLAY_MOVIE" then
        addon:HandleMovie(...)
    end
end)

function addon:HandleCinematic(cinematicID)
    if not CinematicSkipperDB.skipCinematics then return end
    local shouldSkip = CinematicSkipperDB.skipAll
    local charKey = UnitName("player").."-"..(GetRealmName and GetRealmName() or "UnknownRealm")
    if CinematicSkipperDB.skipIfSeen then
        CinematicSkipperDB.seenVideos[charKey] = CinematicSkipperDB.seenVideos[charKey] or {}
        local key = "cinematic"..(cinematicID or 0)
        if not CinematicSkipperDB.seenVideos[charKey][key] then
            CinematicSkipperDB.seenVideos[charKey][key] = true
            shouldSkip = false
        else
            shouldSkip = true
        end
    end
    if shouldSkip and (CinematicFrame_CancelCinematic or (CinematicFrame and CinematicFrame.CancelCinematic)) then
        if CinematicFrame_CancelCinematic then
            CinematicFrame_CancelCinematic()
        elseif CinematicFrame and CinematicFrame.CancelCinematic then
            CinematicFrame:CancelCinematic()
        end
        Print("Cinematic skipped.")
    end
end

function addon:HandleMovie(movieID)
    if not CinematicSkipperDB.skipMovies then return end
    local shouldSkip = CinematicSkipperDB.skipAll
    local charKey = UnitName("player").."-"..(GetRealmName and GetRealmName() or "UnknownRealm")
    if CinematicSkipperDB.skipIfSeen then
        CinematicSkipperDB.seenVideos[charKey] = CinematicSkipperDB.seenVideos[charKey] or {}
        local key = "movie"..(movieID or 0)
        if not CinematicSkipperDB.seenVideos[charKey][key] then
            CinematicSkipperDB.seenVideos[charKey][key] = true
            shouldSkip = false
        else
            shouldSkip = true
        end
    end
    if shouldSkip and _G.MovieFrame and MovieFrame.IsShown and MovieFrame.StopMovie then
        if MovieFrame:IsShown() then
            MovieFrame:StopMovie()
            Print("Movie skipped.")
        end
    end
end
