CC_AskFunc = nil

function CC_UpdateOptionsFrame()
	CC_Options_EnableBox:SetChecked(CC_Vars.enabled)
	CC_Options_ShowBox:SetChecked(CC_Vars.visible)
	CC_Options_MsgBox:SetChecked(CC_Vars.messages)
	CC_Options_ResetBox:SetChecked(CC_Vars.reset)
	CC_Options_CombatBox:SetChecked(CC_Vars.combat)
	CC_Options_TooltipBox:SetChecked(CC_Vars.tooltip)
	
	if (CC_Vars.reset == true) then
		CC_Options_AskResetBox:Disable()
		CC_Options_AskResetBox:SetAlpha(0.7);
	else
		CC_Options_AskResetBox:Enable()
		CC_Options_AskResetBox:SetAlpha(1);
	end
	
	CC_Options_AskResetBox:SetChecked(CC_Vars.askreset)
	
	if (CC_Vars.above == true) then
		UIDropDownMenu_SetText(CC_Options_DropDownMenu, "Up")
	else
		UIDropDownMenu_SetText(CC_Options_DropDownMenu, "Down")
	end
end

function CC_OptionsOnLoad(self)
	CC_Options:Hide()
end

function CC_AnchorDropDownOnClick(self, arg1, arg2, checked)
	CC_Vars.above = arg1
	if (CC_Vars.above == true) then
		UIDropDownMenu_SetText(CC_Options_DropDownMenu, "Up")
		CC_Message(CASHCOUNTER_ANCHOR_ABOVE)
	else
		UIDropDownMenu_SetText(CC_Options_DropDownMenu, "Down")
		CC_Message(CASHCOUNTER_ANCHOR_BELOW)
	end
	CC_SetAnchor()
end

function CC_InitializeDropDown(self, level)
	local info = UIDropDownMenu_CreateInfo()
	info.text = "Up"
	info.func = CC_AnchorDropDownOnClick
	info.checked = CC_Vars.above
	info.arg1 = true
	UIDropDownMenu_AddButton(info, level)
	
	local info = UIDropDownMenu_CreateInfo()
	info.text = "Down"
	info.func = CC_AnchorDropDownOnClick
	info.checked = not CC_Vars.above
	info.arg1 = false
	UIDropDownMenu_AddButton(info, level)
end

function CC_SetBorderColor(r, g, b, a)
	CC_Vars.border.r, CC_Vars.border.g, CC_Vars.border.b, CC_Vars.border.a = r, g, b, a
	CC_Title:SetBackdropBorderColor(r, g, b, a)
	CC_Frame:SetBackdropBorderColor(r, g, b, a)
end
local function borderColorCallback(restore)
	local newR, newG, newB, newA
	
	if restore then
		newR, newG, newB, newA = unpack(restore)
	else
		newA = OpacitySliderFrame:GetValue()
		newR, newG, newB = ColorPickerFrame:GetColorRGB()
	end
	
	CC_SetBorderColor(newR, newG, newB, newA)
end
function CC_ShowBorderColorPicker()
	ColorPickerFrame.opacityFunc, ColorPickerFrame.cancelFunc, ColorPickerFrame.func = nil, nil, nil
	ColorPickerFrame:SetColorRGB(CC_Vars.border.r, CC_Vars.border.g, CC_Vars.border.b)
	ColorPickerFrame.previousValues = {CC_Vars.border.r, CC_Vars.border.g, CC_Vars.border.b, CC_Vars.border.a}
	ColorPickerFrame.opacity 		= CC_Vars.border.a
	ColorPickerFrame.func 			= borderColorCallback
	ColorPickerFrame.opacityFunc 	= borderColorCallback
	ColorPickerFrame.cancelFunc 	= borderColorCallback
	ColorPickerFrame.hasOpacity = true
	ColorPickerFrame:Hide()
	ColorPickerFrame:Show()
end

function CC_SetBackdropColor(r, g, b, a)
	CC_Vars.backdrop.r, CC_Vars.backdrop.g, CC_Vars.backdrop.b, CC_Vars.backdrop.a = r, g, b, a
	CC_Title:SetBackdropColor(r, g, b, a)
	CC_Frame:SetBackdropColor(r, g, b, a)
end
local function backdropColorCallback(restore)
	local newR, newG, newB, newA
	
	if restore then
		newR, newG, newB, newA = unpack(restore)
	else
		newA = OpacitySliderFrame:GetValue()
		newR, newG, newB = ColorPickerFrame:GetColorRGB()
	end
	
	CC_SetBackdropColor(newR, newG, newB, newA)
end
function CC_ShowBackdropColorPicker()
	ColorPickerFrame.opacityFunc, ColorPickerFrame.cancelFunc, ColorPickerFrame.func = nil, nil, nil
	ColorPickerFrame:SetColorRGB(CC_Vars.backdrop.r, CC_Vars.backdrop.g, CC_Vars.backdrop.b)
	ColorPickerFrame.previousValues = {CC_Vars.backdrop.r, CC_Vars.backdrop.g, CC_Vars.backdrop.b, CC_Vars.backdrop.a}
	ColorPickerFrame.opacity 		= CC_Vars.backdrop.a
	ColorPickerFrame.func			= backdropColorCallback
	ColorPickerFrame.opacityFunc	= backdropColorCallback
	ColorPickerFrame.cancelFunc 	= backdropColorCallback
	ColorPickerFrame.hasOpacity = true
	ColorPickerFrame:Hide()
	ColorPickerFrame:Show()
end