BINDING_HEADER_CCHEADER = CASHCOUNTER_TITLE
BINDING_NAME_SHOWHIDE = CASHCOUNTER_SHOWHIDE
BINDING_NAME_ENABLE = CASHCOUNTER_ENABLEDISABLE

local VERSION = {
	release = 1,
	major   = 5,
	minor   = 0
}

CC_Vars = {
	version = VERSION,
	visible = true,
	expanded = true,
	above = false,
	enabled = true,
	messages = true,
	reset = false,
	askreset = true,
	total = 0,
	current = 0,
	gained = 0,
	lost = 0,
	topString = 1,
	combat = false,
	tooltip = true,
	border = {
		r = 0,
		g = 0,
		b = 0,
		a = 0.8
	},
	backdrop = {
		r = 0,
		g = 0,
		b = 0,
		a = 0.6
	}
}

local CC_Strings = {
	current = "",
	total = "",
	gained = "",
	lost = ""
}

local tmpvis = false
local before_combat = false

local function formatCash(amount)
	local gold = floor(abs(amount / 10000))
	local silver = floor(abs(mod(amount / 100, 100)))
	local copper = floor(abs(mod(amount,100)))
	return gold.."g "..silver.."s "..copper.."c"
end

local function getCash()
	CC_Vars.total = CC_Vars.total + (GetMoney() - CC_Vars.current)
	if (GetMoney() < CC_Vars.current) then
		CC_Vars.lost = CC_Vars.lost + (CC_Vars.current - GetMoney())
	elseif (GetMoney() > CC_Vars.current) then
		CC_Vars.gained = CC_Vars.gained + (GetMoney() - CC_Vars.current)
	end
	CC_Vars.current = GetMoney()
end

local function setText()
	if (CC_Vars.expanded == true) then
		CC_Frame_Cash:SetText(CC_Strings.current)
		CC_Frame_Total:SetText(CC_Strings.total)
		CC_Frame_Gained:SetText(CC_Strings.gained)
		CC_Frame_Lost:SetText(CC_Strings.lost)
		CC_Title_Text:SetText(CASHCOUNTER_TITLE)
	else
		if (CC_Vars.topString == 0) then
			CC_Title_Text:SetText(CC_Strings.current)
		elseif (CC_Vars.topString == 1) then
			CC_Title_Text:SetText(CC_Strings.total)
		elseif (CC_Vars.topString == 2) then
			CC_Title_Text:SetText(CC_Strings.gained)
		elseif (CC_Vars.topString == 3) then
			CC_Title_Text:SetText(CC_Strings.lost)
		end
	end
end

local function setStrings()
	if (CC_Vars.total > 0) then
		CC_Strings.total = "Total Earned: "..formatCash(CC_Vars.total)
	elseif (CC_Vars.total < 0) then
		CC_Strings.total = "Total Lost: "..formatCash(CC_Vars.total)
	else
		CC_Strings.total = "Even spent/earned"
	end
	CC_Strings.gained = "Earned: "..formatCash(CC_Vars.gained)
	CC_Strings.lost = "Spent: "..formatCash(CC_Vars.lost)
	CC_Strings.current = "Total: "..formatCash(CC_Vars.current)
end

function CC_SetAnchor()
	CC_Frame:ClearAllPoints()
	if (CC_Vars.above == true) then
		CC_Frame:SetPoint("BOTTOM","CC_Title","TOP")
	else
		CC_Frame:SetPoint("TOP","CC_Title","BOTTOM")
	end
end

function CC_SlashCommand(msg)
	msg = string.lower(msg)
	local args = {}
	for word in string.gmatch(msg, "[^%s]+") do
		table.insert(args, word)
	end
	
	if (args[1] == nil or args[1] == "help") then
		CC_Message(CASHCOUNTER_MOVABLE)
		CC_Message(CASHCOUNTER_USAGE)
		CC_Message("options - "..CASHCOUNTER_OPTION)
		CC_Message("show - "..CASHCOUNTER_SHOW)
		CC_Message("hide - "..CASHCOUNTER_HIDE)
		CC_Message("toggle - "..CASHCOUNTER_TOGGLE)
		CC_Message("enable - "..CASHCOUNTER_ENABLE)
		CC_Message("disable - "..CASHCOUNTER_DISABLE)
		CC_Message("expand up/down - "..CASHCOUNTER_ANCHOR)
		CC_Message("tooltip - "..CASHCOUNTER_TOOLTIP)
		CC_Message("msgs - "..CASHCOUNTER_MESSAGES)
		CC_Message("reset - "..CASHCOUNTER_RESET)
		CC_Message("defaults - "..CASHCOUNTER_DEFAULTS)
		return
	end

	if (args[1] == "enable") then
		CC_Enable()
		
	elseif (args[1] == "disable") then
		CC_Disable()
		
	elseif (args[1] == "show") then
		CC_Show()
		
	elseif (args[1] == "hide") then
		CC_Hide()
		
	elseif (args[1] == "toggle") then
		CC_Visibility()
		
	elseif (args[1] == "tooltip") then
		CC_Vars.tooltip = not CC_Vars.tooltip
		
	elseif (args[1] == "options" or args[1] == "config") then
		CC_Options:Show()
		
	elseif (args[1] == "expand") then
		if (args[2] == "down") then
			CC_Vars.above = false
			CC_Message(CASHCOUNTER_ANCHOR_BELOW)
		elseif (args[2] == "up") then
			CC_Vars.above = true
			CC_Message(CASHCOUNTER_ANCHOR_ABOVE)
		else
			CC_Message(CASHCOUNTER_NOCOMMAND)
		end
		CC_SetAnchor()
		
	elseif (args[1] == "msgs") then
		CC_Vars.messages = not CC_Vars.messages
		
	elseif (args[1] == "reset") then
			CC_Reset_Data()
			
	elseif (args[1] == "defaults") then
			CC_Defaults()
		
	else
		CC_Message(CASHCOUNTER_NOCOMMAND)
	end
	CC_UpdateOptionsFrame()
end

function CC_OnLoad(self)
	SLASH_CASHCOUNTER1 = "/cashcounter"
	SLASH_CASHCOUNTER2 = "/cc"
	SlashCmdList["CASHCOUNTER"] = CC_SlashCommand
	self:RegisterEvent("VARIABLES_LOADED")
	self:RegisterEvent("PLAYER_MONEY")
	self:RegisterEvent("PLAYER_ENTERING_WORLD")
	self:RegisterEvent("PLAYER_REGEN_DISABLED")
	self:RegisterEvent("PLAYER_REGEN_ENABLED")
	self:EnableMouseWheel(true)
end

function CC_Message(msg)
	if (CC_Vars.messages == true) then
		DEFAULT_CHAT_FRAME:AddMessage("[CashCounter]: "..msg)
	end
end

function CC_Visibility()
	if (CC_Vars.visible == true) then
		CC_Hide()
	else
		CC_Show()
	end
end

function CC_Hide()
	CC_Vars.visible = false
	if (CC_Vars.expanded == true) then tmpvis = true
	else tmpvis = false end
	CC_Vars.expanded = false
	CC_Title:Hide()
	CC_Frame:Hide()
	CC_Message(CASHCOUNTER_HIDDEN)
end

function CC_Show()
	if (tmpvis == true) then
		CC_Vars.expanded = true
		CC_Frame:Show()
	end
	CC_Vars.visible = true
	CC_Title:Show()
	CC_Message(CASHCOUNTER_VISIBLE)
end

function CC_Toggle()
	if (CC_Vars.enabled == true) then
		CC_Disable()
	else
		CC_Enable()
	end
end

function CC_Enable()
	CC_Vars.enabled = true
	CC_Message(CASHCOUNTER_ENABLED)
end

function CC_Disable()
	CC_Vars.enabled = false
	CC_Message(CASHCOUNTER_DISABLED)
end

function CC_Reset_Data() -- Reset Data
	CC_Vars.total = 0
	CC_Vars.current = GetMoney()
	CC_Vars.gained = 0
	CC_Vars.lost = 0
	
	getCash()
	setStrings()
	setText()
end

function CC_Defaults() -- Default position, visibility, etc.
	CC_Vars.visible = true
	CC_Vars.expanded = true
	CC_Vars.above = false
	CC_Vars.enabled = true
	CC_Vars.messages = true
	CC_Vars.topString = 1
	CC_Vars.reset = false
	CC_Vars.askreset = true
	CC_Vars.combat = false
	CC_Vars.tooltip = true
	
	CC_Title:ClearAllPoints()
	CC_Title:SetPoint("TOP","UIParent","TOP")
	
	CC_Title:Show()
	CC_Frame:Show()
	CC_SetAnchor()
	setText()
end

function CC_OnEvent(self, event, ...)
    if (event == "VARIABLES_LOADED") then
		-- Version variable added in 1.5.0 Check to see if exists
		if (CC_Vars.version == nil) then
			-- Does not exist, so set to current version
			CC_Vars.version = VERSION
			-- CC_Vars.tooltip added in 1.5.0
			CC_Vars.tooltip = true
			
			-- CC_Vars.border and backdrop did not exists prior to 1.5.0
			if (CC_Vars.border == nil) then
				CC_Vars.border = {
					r = 0,
					b = 0,
					g = 0,
					a = 0.8
				}
			end
			
			if (CC_Vars.backdrop == nil) then
				CC_Vars.backdrop = {
					r = 0,
					b = 0,
					g = 0,
					a = 0.8
				}
			end
		elseif (CC_Vars.version.release == 1 and CC_Vars.version.major == 5 and CC_Vars.version.minor == 0) then
			-- Leaving in to remind myself how to check for versions
		end
	
		if (CC_Vars.reset == false) then
			if (CC_Vars.askreset == true) then
				CC_Reset_Frame:Show()
			end
		elseif (CC_Vars.reset == true) then
			CC_Reset_Data()
		end
		
		if (CC_Vars.visible == false) then
			CC_Title:Hide()
		else
			CC_Title:Show()
		end
		if (CC_Vars.expanded == false) then
			CC_Frame:Hide()
		else
			CC_Frame:Show()
		end
		
		if (CC_Vars.bvis ~= nil) then
			CC_Vars.expanded = CC_Vars.bvis
			CC_Vars.bvis = nil
		end
		
		if (CC_Vars.banchor ~= nil) then
			if (CC_Vars.banchor == "BOTTOM") then CC_Vars.above = true
			else CC_Vars.above = false end
			CC_Vars.banchor = nil
		end
		
		setText()
		CC_SetAnchor()
		
		CC_SetBorderColor(CC_Vars.border.r, CC_Vars.border.g, CC_Vars.border.b, CC_Vars.border.a)
		CC_SetBackdropColor(CC_Vars.backdrop.r, CC_Vars.backdrop.g, CC_Vars.backdrop.b, CC_Vars.backdrop.a)

	elseif (event == "PLAYER_ENTERING_WORLD") then
		CC_Vars.current = GetMoney()
		getCash()
		setStrings()
		setText()
		
    elseif (event == "PLAYER_MONEY") then
		if (CC_Vars.enabled == true) then
			getCash()
			setStrings()
			setText()
		else
			CC_Vars.current = GetMoney()
			CC_Strings.current = "Total: "..formatCash(CC_Vars.current)
			setText()
		end
	
	elseif (event == "PLAYER_REGEN_DISABLED") then
		if (CC_Vars.combat == true) then
			before_combat = CC_Vars.visible
			CC_Hide()
		end
	
	elseif (event == "PLAYER_REGEN_ENABLED") then
		if (CC_Vars.combat == true) then
			if (before_combat == true) then
				CC_Show()
			end
		end
	end
end

function CC_OnEnter(self)
	if (not CC_Vars.tooltip) then return end
	
	GameTooltip_SetDefaultAnchor(GameTooltip, self)
	GameTooltip:SetText(CASHCOUNTER_TITLE)
	if (CC_Vars.enabled == false) then
		GameTooltip:AddLine(CASHCOUNTER_DISABLED)
	else
		GameTooltip:AddLine(CASHCOUNTER_ENABLED)
	end
	GameTooltip:AddLine(CASHCOUNTER_EXPAND)
	GameTooltip:AddLine(CASHCOUNTER_MOVE)
	if (CC_Vars.expanded == false) then GameTooltip:AddLine(CASHCOUNTER_SCROLL) end
	if (CC_Vars.messages == true) then
		GameTooltip:AddLine(CASHCOUNTER_OPTIONS)
	else
		GameTooltip:AddLine(CASHCOUNTER_MESSAGES_DISABLED)
	end
	GameTooltipTextLeft1:SetTextColor(1, 1, 1)
	GameTooltip:Show()
end

function CC_MouseDown(self, button)
	if (button == "LeftButton") then
		if (IsControlKeyDown()) then
			self:StartMoving()
			self.isMoving = true
		elseif (CC_Vars.expanded == true) then
			CC_Frame:Hide()
			CC_Vars.expanded = false
			setText()
		else
			CC_Frame:Show()
			CC_Vars.expanded = true
			setText()
		end
	elseif (button == "RightButton") then
		if (CC_Options:IsShown()) then
			CC_Options:Hide()
		else
			CC_Options:Show()
		end
	end
end

function CC_MouseWheel(self, delta)
	if (delta > 0) then
		CC_Vars.topString = CC_Vars.topString - 1
	else
		CC_Vars.topString = CC_Vars.topString + 1
	end
	if (CC_Vars.topString >= 4) then
		CC_Vars.topString = 0
	elseif (CC_Vars.topString <= -1) then
		CC_Vars.topString = 3
	end
	setText()
end