---------------------------------------------------------------------------------------
-- NxMapData - Map code
-- Copyright 2007-2012 Carbon Based Creations, LLC
---------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------
-- Carbonite - Addon for World of Warcraft(tm)
-- Copyright 2007-2012 Carbon Based Creations, LLC
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.
---------------------------------------------------------------------------------------

local Map = Nx.Map
local L = LibStub("AceLocale-3.0"):GetLocale("Carbonite")

-- X and Y are the absolute position (lower-left corner) on the overall
-- super-zoomed-out continent image (https://github.com/dratr/Carbonite/commits/map-zonesdocs)
Map.MapInfo = {
	[0] = {		-- Dummy
		Name = "Instance",
		X = 0,
		Y = 0,
	},
	[1] = {
		Name = L["Kalimdor"],
		FileName = "Kalimdor",
		X = -2500,
		Y = 200,
	},
	[2] = {
		Name = L["Eastern Kingdoms"],
		FileName = "Azeroth",
		X = 6284,
		Y = -200,
	},
	[3] = {
		Name = L["Outland"],
		FileName = "Expansion01",
		X = 7400,
		Y = -4000,
	},
	[4] = {
		Name = L["Northrend"],
		FileName = "Northrend",
		X = 2500,
		Y = -3000,
	},
	[5] = {
		Name = L["The Maelstrom"],
		FileName = "TheMaelstromContinent",
		X = 1700,
		Y = 1350,
	},
	[6] = {
		Name = L["Pandaria"],
		FileName = "Pandaria",
		X = 2500,
		Y = 4500,
	},
	[7] = {
		Name = L["Draenor"],
		FileName = "Draenor",
		X = -2000,
		Y = -3300,
	},
	[8] = {
		Name = L["Broken Isles"],
		FileName = "BrokenIsles",
		X = 3000,
		Y = -300,
	},
	[9] = {
		Name = L["Argus"],
		FileName = "Argus",
		X = 4250,
		Y = -1800,
	},
	[90] = {
		Name = "BG",
		X = 2000,
		Y = 200,
	},
	[100] = {
		Name = "Instance",
		X = 2000,
		Y = 100,
	},
}

Map.BloodelfXO = -503
Map.BloodelfYO = 516
Map.DraeneiXO = -3500
Map.DraeneiYO = -2010

Map.MapWorldInfo = {

	-- Dummy if we get a zero on startup
	[-1] = {
		1.0,
		0,0,
	},
	[0] = {
		10,
		0, 0,
		0, 0,		-- Index 4,5 XY world position created for zones in continents 1-5, 9
		Overlay = "barrens",
	},
	[4] = {
		Scale = 10.574999267578,
		X = 392.49997558594,
		Y = -361.66665039063,
		Overlay = "durotar",
		Name = L["Durotar"],
	},
	[9] = {
		Scale = 10.899999511719,
		X = -440.83330078125,
		Y = 33.75,
		Overlay = "mulgore",
		Name = L["Mulgore"],
	},
	[11] = {
		Scale = 11.491666656494,
		X = -40.416665649414,
		Y = -362.08332519531,
		Overlay = "barrens",
		Name = L["Northern Barrens"],
		QAchievementIdH = 4933,
	},
	[13] = {
		Scale = 73.59962109375,
		X = -3413.319921875,
		Y = -2559.980078125,
	},
	[14] = {
		Scale = 81.48236328125,
		X = -3634.394140625,
		Y = -2235.26875,
	},
	[16] = {
		Scale = 6.9541665039062,
		X = 225.41665039063,
		Y = 28.333331298828,
		Overlay = "arathi",
		Name = L["Arathi Highlands"],
		QAchievementId = 4896,
	},
	[17] = {
		Scale = 6.1416665039062,
		X = 380.41665039063,
		Y = 1170.8333007813,
		Overlay = "badlands",
		Name = L["Badlands"],
		QAchievementId = 4900,
	},
	[19] = {
		Scale = 7.325,
		X = 238.75,
		Y = 2116.6666015625,
		Overlay = "blastedlands",
		Name = L["Blasted Lands"],
		QAchievementId = 4909,
	},
	[20] = {
		Scale = 9.0374997558594,
		X = -606.66665039063,
		Y = -767.49995117188,
		Overlay = "tirisfal",
		Name = L["Tirisfal Glades"],
	},
	[21] = {
		Scale = 8.3999995117188,
		X = -689.99995117188,
		Y = -333.33332519531,
		Overlay = "silverpine",
		Name = L["Silverpine Forest"],
		QAchievementIdH = 4894,
	},
	[22] = {
		Scale = 8.5999998168945,
		X = -83.333331298828,
		Y = -673.33330078125,
		Overlay = "westernplaguelands",
		Name = L["Western Plaguelands"],
		QAchievementId = 4893,
	},
	[23] = {
		Scale = 8.0625,
		X = 457.5,
		Y = -740.83330078125,
		Overlay = "easternplaguelands",
		Name = L["Eastern Plaguelands"],
		QAchievementId = 4892,
	},
	[24] = {
		Scale = 9.7249997558594,
		X = -369.99997558594,
		Y = -296.25,
		Overlay = "hillsbradfoothills",
		Name = L["Hillsbrad Foothills"],
		QAchievementIdH = 4895,
	},
	[26] = {
		Scale = 7.7,
		X = 315,
		Y = -293.33332519531,
		Overlay = "hinterlands",
		Name = L["The Hinterlands"],
		QAchievementId = 4897,
	},
	[27] = {
		Scale = 9.7958330078125,
		X = -427.5,
		Y = 788.33330078125,
		Overlay = "dunmorogh",
		Name = L["Dun Morogh"],
	},
	[28] = {
		Scale = 4.4624996948242,
		X = 64.583331298828,
		Y = 1220,
		Overlay = "searinggorge",
		Name = L["Searing Gorge"],
		QAchievementId = 4910,
	},
	[29] = {
		Scale = 6.3041663818359,
		X = 92.916662597656,
		Y = 1397.0833007813,
		Overlay = "burningsteppes",
		Name = L["Burning Steppes"],
		QAchievementId = 4901,
	},
	[30] = {
		Scale = 6.9416665039062,
		X = -307.08332519531,
		Y = 1587.9166015625,
		Overlay = "elwynn",
		Name = L["Elwynn Forest"],
	},
	[32] = {
		Scale = 4.9999998779297,
		X = 166.66666259766,
		Y = 1973.333203125,
		Overlay = "deadwindpass",
		Name = L["Deadwind Pass"],
	},
	[34] = {
		Scale = 5.3999998779297,
		X = -166.66666259766,
		Y = 1943.333203125,
		Overlay = "duskwood",
		Name = L["Duskwood"],
		QAchievementIdA = 4907,
	},
	[35] = {
		Scale = 5.5166662597656,
		X = 398.74997558594,
		Y = 897.5,
		Overlay = "lochmodan",
		Name = L["Loch Modan"],
		QAchievementIdA = 4899,
	},
	[36] = {
		Scale = 5.1374997558594,
		X = 295.83332519531,
		Y = 1702.9166015625,
		Overlay = "redridge",
		Name = L["Redridge Mountains"],
		QAchievementIdA = 4902,
	},
	[37] = {
		Scale = 8.1999997558594,
		X = -348.74997558594,
		Y = 2203.333203125,
		Overlay = "stranglethornjungle",
		Name = L["Northern Stranglethorn"],
		QAchievementId = 4906,
	},
	[38] = {
		Scale = 5.016666015625,
		X = 416.25,
		Y = 1907.083203125,
		Overlay = "swampofsorrows",
		Name = L["Swamp of Sorrows"],
		QAchievementId = 4904,
	},
	[39] = {
		Scale = 6.9999996337891,
		X = -603.33330078125,
		Y = 1880,
		Overlay = "westfall",
		Name = L["Westfall"],
		QAchievementIdA = 4903,
	},
	[40] = {
		Scale = 8.2708333740234,
		X = 77.916662597656,
		Y = 429.58330078125,
		Overlay = "wetlands",
		Name = L["Wetlands"],
		QAchievementIdA = 4898,
	},
	[41] = {
		Scale = 11.749999511719,
		X = -847.08330078125,
		Y = -2369.583203125,
		Overlay = "teldrassil",
		Name = L["Teldrassil"],
	},
	[42] = {
		Scale = 12.929166015625,
		X = -603.33330078125,
		Y = -1644.583203125,
		Overlay = "darkshore",
		Name = L["Darkshore"],
		QAchievementIdA = 4928,
	},
	[43] = {
		Scale = 11.533332763672,
		X = -339.99997558594,
		Y = -934.58330078125,
		Overlay = "ashenvale",
		Name = L["Ashenvale"],
		QAchievementId = 4925,
		QAchievementIdH = 4976,
	},
	[61] = {
		Scale = 8.7999993896484,
		X = 86.666662597656,
		Y = 793.33330078125,
		Overlay = "thousandneedles",
		Name = L["Thousand Needles"],
		QAchievementId = 4938,
	},
	[81] = {
		Scale = 11.799999755859,
		X = -780.41665039063,
		Y = -680.83330078125,
		Overlay = "stonetalonmountains",
		Name = L["Stonetalon Mountains"],
		QAchievementId = 4936,
		QAchievementIdH = 4980,
	},
	[101] = {
		Scale = 8.991666015625,
		X = -846.6666015625,
		Y = -90.416662597656,
		Overlay = "desolace",
		Name = L["Desolace"],
		QAchievementId = 4930,
	},
	[121] = {
		Scale = 13.899999511719,
		X = -1088.3333007813,
		Y = 473.33330078125,
		Overlay = "feralas",
		Name = L["Feralas"],
		QAchievementId = 4932,
		QAchievementIdH = 4979,
	},
	[141] = {
		Scale = 10.5,
		X = 195,
		Y = 406.666796875,
		Overlay = "dustwallow",
		Name = L["Dustwallow Marsh"],
		QAchievementId = 4929,
		QAchievementIdH = 4978,
	},
	[161] = {
		Scale = 14.424999031067,
		X = 12.499999237061,
		Y = 1154.1666015625,
		Overlay = "tanaris",
		Name = L["Tanaris"],
		QAchievementId = 4935,
	},
	[181] = {
		Scale = 11.029166992188,
		X = 674.58330078125,
		Y = -1076.25,
		Overlay = "aszhara",
		Name = L["Azshara"],
		QAchievementIdH = 4927,
	},
	[182] = {
		Scale = 12.124999267578,
		X = -359.58332519531,
		Y = -1447.4999023437,
		Overlay = "felwood",
		Name = L["Felwood"],
		QAchievementId = 4931,
	},
	[201] = {
		Scale = 7.3999996337891,
		X = -106.66666259766,
		Y = 1193.3333007813,
		Overlay = "ungorocrater",
		Name = L["Un'Goro Crater"],
		QAchievementId = 4939,
	},
	[241] = {
		Scale = 4.6166665039063,
		X = 276.25,
		Y = -1698.333203125,
		Overlay = "moonglade",
		Name = L["Moonglade"],
	},
	[261] = {
		Scale = 8.1166665039063,
		X = -596.66665039063,
		Y = 1174.5833007813,
		Overlay = "silithus",
		Name = L["Silithus"],
		QAchievementIdA = 4934,
	},
	[281] = {
		Scale = 12.299999755859,
		X = 198.33332519531,
		Y = -1758.75,
		Overlay = "winterspring",
		Name = L["Winterspring"],
		QAchievementId = 4940,
	},
	[301] = {
		Scale = 3.474999917984,
		X = -344.58332519531,
		Y = 1599.1666015625,
		Overlay = "stormwindcity",
		Name = L["Stormwind City"],
		City = true,
		MMOutside = true,
	},
	[321] = {
		Scale = 3.47875,
		X = 701.27080078125,
		Y = -497.33334960938,
		Overlay = "orgrimmar",
		Name = L["Orgrimmar"],
		City = true,
		MMOutside = true,
	},
	[341] = {
		Scale = 1.5812501220703,
		X = 142.71827392578,
		Y = 913.8482421875,
		Overlay = "ironforge",
		Name = L["Ironforge"],
		City = true,
	},
	[362] = {
		Scale = 2.0874998779297,
		X = -103.33332519531,
		Y = 169.99998779297,
		Overlay = "thunderbluff",
		Name = L["Thunder Bluff"],
		City = true,
		MMOutside = true,
	},
	[381] = {
		Scale = 3.0791667480469,
		X = -637.5,
		Y = -2092.9166015625,
		Overlay = "darnassus",
		Name = L["Darnassus"],
		City = true,
		MMOutside = true,
	},
	[382] = {
		Scale = 1.9187500610352,
		X = -174.63852539063,
		Y = -375.5890625,
		Overlay = "undercity",
		Name = L["Undercity"],
		City = true,
	},
	[401] = {
		Name = L["Alterac Valley"],
		Scale = 8.4749997558594,
		X = 16000,
		Y = 2000,
		Short = "AV",
	},
	[443] = {
		Name = L["Warsong Gulch"],
		Scale = 2.2916666259766,
		X = -16000,
		Y = 1000,
		Short = "WG",
	},
	[461] = {
		Name = L["Arathi Basin"],
		Scale = 3.5124998474121,
		X = -16000,
		Y = 0,
		Short = "AB",
	},
	[462] = {
		Scale = 9.85,
		X = 897.5,
		Y = -2208.333203125,
		Overlay = "eversongwoods",
		Name = L["Eversong Woods"],
		XOff = Map.BloodelfXO,
		YOff = Map.BloodelfYO,
		MId = 462,
	},
	[463] = {
		Scale = 6.6,
		X = 1056.6666015625,
		Y = -1653.333203125,
		Overlay = "ghostlands",
		Name = L["Ghostlands"],
		XOff = Map.BloodelfXO,
		YOff = Map.BloodelfYO,
		MId = 462,
		QAchievementIdH = 4908,
	},
	[464] = {
		Scale = 8.141666015625,
		X = 2100,
		Y = 558.75,
		Overlay = "azuremystisle",
		Name = L["Azuremyst Isle"],
		XOff = Map.DraeneiXO,
		YOff = Map.DraeneiYO,
		MId = 464,
	},
	[465] = {
		Scale = 10.329166015625,
		X = -1107.9166015625,
		Y = -296.25,
		Overlay = "hellfire",
		Name = L["Hellfire Peninsula"],
		QAchievementId = 1189,
		QAchievementIdH = 1271,
	},
	[466] = {
		Scale = 34.92815625,
		X = -2599.2078125,
		Y = -1164.271875,
	},
	[467] = {
		Scale = 10.054166992188,
		X = -1895,
		Y = -387.08332519531,
		Overlay = "zangarmarsh",
		Name = L["Zangarmarsh"],
		QAchievementId = 1190,
	},
	[471] = {
		Scale = 2.113541015625,
		X = 2213.2734375,
		Y = 721.93666992188,
		Overlay = "theexodar",
		Name = L["The Exodar"],
		XOff = Map.DraeneiXO,
		YOff = Map.DraeneiYO,
		City = true,
		MId = 464,
	},
	[473] = {
		Scale = 11,
		X = -845,
		Y = 389.58332519531,
		Overlay = "shadowmoonvalley",
		Name = L["Shadowmoon Valley"],
		QAchievementId = 1195,
	},
	[475] = {
		Scale = 10.849999511719,
		X = -1769.1666015625,
		Y = -881.6666015625,
		Overlay = "bladesedgemountains",
		Name = L["Blade's Edge Mountains"],
		QAchievementId = 1193,
	},
	[476] = {
		Scale = 6.524998046875,
		X = 2015,
		Y = 151.66666259766,
		Overlay = "bloodmystisle",
		Name = L["Bloodmyst Isle"],
		XOff = Map.DraeneiXO,
		YOff = Map.DraeneiYO,
		MId = 464,
		QAchievementIdA = 4926,
	},
	[477] = {
		Scale = 11.05,
		X = -2059.1666015625,
		Y = -8.333332824707,
		Overlay = "nagrand",
		Name = L["Nagrand"],
		QAchievementId = 1192,
		QAchievementIdH = 1273,
	},
	[478] = {
		Scale = 10.799999511719,
		X = -1416.6666015625,
		Y = 199.99998779297,
		Overlay = "terokkarforest",
		Name = L["Terokkar Forest"],
		QAchievementId = 1191,
		QAchievementIdH = 1272,
	},
	[479] = {
		Scale = 11.149999343872,
		X = -1096.6666015625,
		Y = -1091.25,
		Overlay = "netherstorm",
		Name = L["Netherstorm"],
		QAchievementId = 1194,
	},
	[480] = {
		Scale = 2.4229169921875,
		X = 1280.15,
		Y = -2030.741796875,
		Overlay = "silvermooncity",
		Name = L["Silvermoon City"],
		XOff = Map.BloodelfXO,
		YOff = Map.BloodelfYO,
		City = true,
		MId = 462,
	},
	[481] = {
		Scale = 2.6125,
		X = -1227.0517578125,
		Y = 294.79089355469,
		Overlay = "shattrathcity",
		Name = L["Shattrath City"],
		MMOutside = true,
	},
	[482] = {
		Name = L["Eye of the Storm"],
		Scale = 4.5416663818359,
		X = -16000,
		Y = 3000,
		Short = "EOS",
	},
	[485] = {
		Scale = 35.502796875,
		X = -1843.43046875,
		Y = -2118.675,
	},
	[486] = {
		Scale = 11.529166015625,
		X = -1714.1666015625,
		Y = -979.58330078125,
		Overlay = "boreantundra",
		Name = L["Borean Tundra"],
		QAchievementId = 33,
		QAchievementIdH = 1358,
	},
	[488] = {
		Scale = 11.216666259766,
		X = -725.41665039063,
		Y = -1115,
		Overlay = "dragonblight",
		Name = L["Dragonblight"],
		QAchievementId = 35,
		QAchievementIdH = 1359,
	},
	[490] = {
		Scale = 10.499999755859,
		X = 222.08332519531,
		Y = -1103.3333007813,
		Overlay = "grizzlyhills",
		Name = L["Grizzly Hills"],
		QAchievementId = 37,
		QAchievementIdH = 1357,
	},
	[491] = {
		Scale = 12.091665771484,
		X = 279.58332519531,
		Y = -623.33330078125,
		Overlay = "howlingfjord",
		Name = L["Howling Fjord"],
		QAchievementId = 34,
		QAchievementIdH = 1356,
	},
	[492] = {
		Scale = 12.541666625977,
		X = -1088.75,
		Y = -1885.4166015625,
		Overlay = "icecrownglacier",
		Name = L["Icecrown"],
		QAchievementId = 40,
	},
	[493] = {
		Scale = 8.7125,
		X = -1385.8333007813,
		Y = -1457.4999023437,
		Overlay = "sholazarbasin",
		Name = L["Sholazar Basin"],
		QAchievementId = 39,
	},
	[495] = {
		Scale = 14.224999267578,
		X = -368.33332519531,
		Y = -2039.583203125,
		Overlay = "thestormpeaks",
		Name = L["The Storm Peaks"],
		QAchievementId = 38,
	},
	[496] = {
		Scale = 9.9875,
		X = 120,
		Y = -1533.7499023437,
		Overlay = "zuldrak",
		Name = L["Zul'Drak"],	-- [11]
		QAchievementId = 36,
	},
	[499] = {
		Scale = 6.654166015625,
		X = 1060.4166015625,
		Y = -2713.7498046875,
		Overlay = "sunwell",
		Name = L["Isle of Quel'Danas"],
		XOff = Map.BloodelfXO,
		YOff = Map.BloodelfYO,
		MId = 462,
	},
	[501] = {
		Scale = 5.9499997558594,
		X = -865.83330078125,
		Y = -1143.3333007813,
		Overlay = "lakewintergrasp",
		Name = L["Wintergrasp"],
		Explored = true,
	},
	[502] = {
		Scale = 6.325,
		X = 809.58330078125,
		Y = -617.5,
		Overlay = "scarletenclave",
		Name = L["Plaguelands: The Scarlet Enclave"],
		XOff = 400,
		YOff = -33,
		City = true,
	},
	[504] = {
		Name = L["Dalaran"],
		Scale = 1.6589 / 1.3,
		X = -200.95,
		Y = -1199.17260156,
		Overlay = "dalaran",
		--MapBaseName = "dalaran1_",
		City = true,
		Alpha = .85,
		ScaleAdjust = 1.3,
		--MapLevel = 1,
	},
	[510] = {
		Scale = 5.4458332519531,
		X = -288.75,
		Y = -1300.4166015625,
		Overlay = "crystalsongforest",
		Name = L["Crystalsong Forest"],
	},
	[512] = {
		Name = L["Strand of the Ancients"],
		Scale = 3.4874998779297,
		X = -14500,
		Y = 0,
		Short = "SoA",
	},
	[539] = {
		BaseMap = 545,
	},
	[540] = {
		Name = L["Isle of Conquest"],
		Scale = 5.3,
		X = -14500,
		Y = 1000,
		Short = "IC",
	},
	[541] = {
		Scale = 7.3541662597656,
		X = -559.58330078125,
		Y = -2156.25,
		Overlay = "hrothgarslanding",
		Name = L["Hrothgar's Landing"],
		Explored = true,
	},
	[544] = {
		Scale = 9.029166015625,
		X = -876.6666015625,
		Y = -576.25,
		Overlay = "thelostisles_terrain2",
		Name = L["The Lost Isles"],
		XOff = 470,
		YOff = 980,
	},
	[545] = {
		Scale = 6.2916665039063,
		X = -687.91665039063,
		Y = 106.66666259766,
		Overlay = "gilneas",
		Name = L["Gilneas"],
	},
	[605] = {
		Scale = 2.7041663818359,
		X = -425.83330078125,
		Y = 1546.2499023437,
		Overlay = "kezan",
		Name = L["Kezan"],
		XOff = 946,
		YOff = -832,
		MId = 605,
	},
	[606] = {
		Scale = 8.4916667480469,
		X = 185.83332519531,
		Y = -1239.1666015625,
		Overlay = "hyjal",
		Name = L["Mount Hyjal"],
		QAchievementId = 4870,
	},
	[607] = {
		Scale = 14.825,
		X = -271.25,
		Y = -40.833331298828,
		Overlay = "southernbarrens",
		Name = L["Southern Barrens"],
		QAchievementId = 4937,
		QAchievementIdH = 4981,
	},
	[610] = {
		Scale = 5.604166015625,
		X = -1014.1666015625,
		Y = 803.74995117188,
		Overlay = "vashjirkelpforest",
		Name = L["Kelp'thar Forest"],
		QAchievementId = 4869,
		QAchievementIdH = 4982,
	},
	[611] = {
		Scale = 1.7791665039063,
		X = -386.66665039063,
		Y = 261.25,
		Overlay = "gilneascity",
		Name = L["Gilneas City"],
	},
	[613] = {
		Scale = 13.891665527344,
		X = -1750.833203125,
		Y = 744.16665039063,
		Overlay = "vashjir",
		Name = L["Vashj'ir"],
	},
	[614] = {
		Scale = 8.15,
		X = -1646.6666015625,
		Y = 981.25,
		Overlay = "vashjirdepths",
		Name = L["Abyssal Depths"],
		QAchievementId = 4869,
		QAchievementIdH = 4982,
	},
	[615] = {
		Scale = 9.6999992675781,
		X = -1336.2499023437,
		Y = 951.25,
		Overlay = "vashjirruins",
		Name = L["Shimmering Expanse"],
		QAchievementId = 4869,
		QAchievementIdH = 4982,
	},
	[626] = {
		Name = L["Twin Peaks"],
		Scale = 2.4291665039062,
		X = -14500,
		Y = 3000,
		Short = "TP",
	},
	[640] = {
		Scale = 10.199999755859,
		X = -610.41665039063,
		Y = -559.16665039063,
		Overlay = "deepholm",
		Name = L["Deepholm"],
		XOff = 1580,
		YOff = 700,
		QAchievementId = 4871,
		MId = 640,
	},
	[673] = {
		Scale = 7.8916662597656,
		X = -421.66665039063,
		Y = 2503.333203125,
		Overlay = "thecapeofstranglethorn",
		Name = L["The Cape of Stranglethorn"],
		QAchievementId = 4905,
	},
	[678] = {
		BaseMap = 545,
	},
	[679] = {
		BaseMap = 545,
	},
	[681] = {
		BaseMap = 544,
	},
	[682] = {
		BaseMap = 544,
	},
	[683] = {
		BaseMap = 606,
	},
	[684] = {
		Scale = 6.2916665039063,
		X = -687.91665039063,
		Y = 106.66666259766,
		Overlay = "ruinsofgilneas",
		Name = L["Ruins of Gilneas"],
		Explored = true,
	},
	[685] = {
		Scale = 1.7791665039063,
		X = -386.66665039063,
		Y = 261.25,
		Overlay = "ruinsofgilneascity",
		Name = L["Ruins of Gilneas City"],
		City = true,
		StartZone = true,
	},
	[689] = {
		Scale = 13.104166015625,
		X = -595.41665039063,
		Y = 2192.9166015625,
		Overlay = "stranglethornvale",
		Name = L["Stranglethorn Vale"],
	},
	[700] = {
		Scale = 10.541666015625,
		X = 487.5,
		Y = 431.25,
		Overlay = "twilighthighlands",
		Name = L["Twilight Highlands"],
		QAchievementId = 4873,
		QAchievementIdH = 5501,
	},
	[708] = {
		Scale = 4.0291665849686,
		X = -402.08332519531,
		Y = 112.08332519531,
		Overlay = "tolbarad",
		Name = L["Tol Barad"],
		XOff = -600,
		YOff = 320,
		MId = 708,
		Explored = true,
	},
	[709] = {
		Scale = 3.675,
		X = -482.5,
		Y = -75.416662597656,
		Overlay = "tolbaraddailyarea",
		Name = L["Tol Barad Peninsula"],
		XOff = -600,
		YOff = 320,
		MId = 708,
		Explored = true,
	},
	[720] = {
		Scale = 12.387499511719,
		X = -488.33330078125,
		Y = 1605.8333007813,
		Overlay = "uldum",
		Name = L["Uldum"],
		QAchievementId = 4872,
	},
	[736] = {
		Name = L["The Battle for Gilneas"],
		Scale = 2.6041665649414,
		X = -14500,
		Y = 2000,
		Short = "TBG",
	},
	[737] = {
		Scale = 3.1,
		X = -311.25,
		Y = -274.16665039063,
		Overlay = "themaelstrom",
		Name = L["The Maelstrom"],
		XOff = 1000,
		YOff = 600,
		City = true,
		Explored = true,
	},
	[748] = {
		BaseMap = 720,
	},
	[751] = {
		Scale = 26,
		X = -311.25,
		Y = -274.16665039063,
	},
	[770] = {
	  BaseMap = 770,
	},
	[772] = {
		Scale = 8.0999996643066,
		X = -778.33330078125,
		Y = 1606.6666015625,
		Overlay = "ahnqirajthefallenkingdom",
		Name = L["Ahn'Qiraj: The Fallen Kingdom"],
	},
	[795] = {
		Scale = 2.3791666259766,
		X = -186.66666259766,
		Y = -340.41665039063,
		Overlay = "moltenfront",
		Name = L["Molten Front"],
		MId = 795,
		UseAId = true,
		Explored = true,
	},
	[806] = {
		Scale = 13.966666015625,
		X = -290.4166015625,
		Y = -730.4166015625,
		Overlay = "thejadeforest",
		Name=L["The Jade Forest"],
	},
	[807] = {
		Scale = 7.850001953125,
		X = -535.8333984375,
		Y = -219.1666015625,
		Overlay = "valleyofthefourwinds",
		Name=L["Valley of the Four Winds"],
	},
	[808] = {
		Scale = 5.341666015625,
		X = -995.833203125,
		Y = -357.0833984375,
		Overlay = "thewanderingisle",
		Name=L["The Wandering Isle"],
		StartZone = true,
		XOff = 500,
		YOff = -1500,
		MId = 808,
		MMOutside = true,
	},
	[809] = {
		Scale = 12.516666015625,
		X = -967.9166015625,
		Y = -1123.75,
		Overlay = "kunlaisummit",
		Name=L["Kun-Lai Summit"],
	},
	[810] = {
		Scale = 11.487498046875,
		X = -1415.833203125,
		Y = -911.6666015625,
		Overlay = "townlongwastes",
		Name=L["Townlong Steppes"],
	},
	[811] = {
		Scale = 5.06666796875,
		X = -496.25,
		Y = -389.5833984375,
		Overlay = "valeofeternalblossoms",
		Name=L["Vale of Eternal Blossoms"],
	},
	[813] = {
		BaseMap = 482,
		Short = "EOS",
	},
	[823] = {
		Scale = 3.716666015625,
		X = -953.7499023437,
		Y = 664.58330078125,
		Overlay = "darkmoonfaireisland",
		Name = L["Darkmoon Island"],
		Explored = true,
		MMOutside = true,
		MId=823,
	},
	[856] = {
		Name = L["Temple of Kotmogu"],
		Scale = 1.679166015625,
		X = -14500,
		Y = 4000,
		Short = "TK",
	},
	[857] = {
		Scale = 9.375001953125,
		X = -589.5833984375,
		Y = 22.083204650879,
		Overlay = "krasarang",
		Name=L["Krasarang Wilds"],
	},
	[858] = {
		Name=L["Dread Wastes"],
		Scale = 10.704166015625,
		X = -1227.9166015625,
		Y = -283.3333984375,
		Overlay = "dreadwastes",
	},
	[860] = {
		Name = L["Silvershard Mines"],
		Scale = 4.499998046875,
		X = -14500,
		Y = 5000,
		Short = "SSM",
		MapBaseName = "STVDiamondMineBG1_",
	},
	[862] = {
		Scale = 31.030600585937,
		X = -1750.5720703125,
		Y = -1335.83203125,
	},
	[864] = {
		Scale = 1.9375,
		X = -37.5,
		Y = 1714.16640625,
		Overlay = "northshire",
		Name = L["Northshire"],
		StartZone = true,
	},
	[866] = {
		Scale = 1.929166015625,
		X = -195.8333984375,
		Y = 1192.5,
		Overlay = "coldridgevalley",
		Name = L["Coldridge Valley"],
		StartZone = true,
	},
	[873] = {
		Scale = 3.5875,
		X = -162.5,
		Y = -337.9166015625,
		Overlay = "thehiddenpass",
		Name=L["The Veiled Stair"],
	},
	[888] = {
		Scale = 2.900001953125,
		X = -298.3333984375,
		Y = -2206.6666015625,
		Overlay = "shadowglenstart",
		Name = L["Shadowglen"],
		StartZone = true,
	},
	[889] = {
		Scale = 2.7,
		X = 728.333203125,
		Y = 0,
		Overlay = "valleyoftrialsstart",
		Name = L["Valley of Trials"],
		StartZone = true,
	},
	[890] = {
		Scale = 3.5333359375,
		X = -46.666796875,
		Y = 515.416796875,
		Overlay = "campnarachestart",
		Name = L["Camp Narache"],
		StartZone = true,
	},
	[891] = {
		Scale = 3.6125,
		X = 898.333203125,
		Y = 105,
		Overlay = "echoislesstart",
		Name = L["Echo Isles"],
		StartZone = true,
	},
	[892] = {
		Scale = 2.17916796875,
		X = -429.5833984375,
		Y = -454.1666015625,
		Overlay = "deathknellstart",
		Name = L["Deathknell"],
		StartZone = true,
	},
	[893] = {
		Scale = 3.2,
		X = 1076.666796875,
		Y = -2166.6666015625,
		Overlay = "sunstriderislestart",
		Name = L["Sunstrider Isle"],
		XOff = Map.BloodelfXO,
		YOff = Map.BloodelfYO,
		MId = 462,
		StartZone = true,
	},
	[894] = {
		Scale = 3.6375,
		X = 2562.91640625,
		Y = 720.833203125,
		Overlay = "ammenvalestart",
		Name = L["Ammen Vale"],
		XOff = Map.DraeneiXO,
		YOff = Map.DraeneiYO,
		MId = 464,
		StartZone = true,
	},
	[895] = {
		Scale = 3.7,
		X = -241.25,
		Y = 945.416796875,
		Overlay = "newtinkertownstart",
		Name = L["New Tinkertown"],
		StartZone = true,
	},
	[903] = {
		Name = L["Shrine of Two Moons"],
		Scale = 0.5,
		X = -217.8,
		Y = 1573.5,
		Alpha=2,
		ScaleAdjust=0.87584,
		City = true,
	},
	[905] = {
		Name = L["Shrine of Seven Stars"],
		Scale = 0.55,
		X = -82,
		Y = 1751,
		ScaleAdjust=0.9469,
		City = true,
	},
	[928] = {
		Scale = 8.27083203125,
		X = -1530.833203125,
		Y = -1629.583203125,
		Overlay = "isleofthethunderking",
		Name = L["Isle of Thunder"],
		Explored = true,
	},
	[929] = {
		Scale = 3.575001953125,
		X = -400.8333984375,
		Y = -1339.583203125,
		Overlay = "isleofgiants",
		Name = L["Isle of Giants"],
		Explored = true,
	},
	[935] = {
		Name = L["Deepwind Gorge"],
		Scale = 2.16666796875,
		X = -13000,
		Y = 0,
		MapBaseName = "GoldRush",
		Short = "DG",
	},
	[941] = {
		Scale = 12.229159912109,
		X = -1501.25,
		Y = -1655,
		Overlay = "frostfireridge",
	},
	[945] = {
		Scale = 10.499999755859,
		X = -341.66599121094,
		Y = -1186.666015625,
		Overlay = "TanaanJungle",
	},
	[946] = {
		Scale = 11.924992156982,
		X = -1166.666015625,
		Y = -885.833984375,
		Overlay = "talador",
	},
	[947] = {
		Scale = 13.4,
		X = -453.75,
		Y = -532.083984375,
		Overlay = "shadowmoonvalleydr",
	},
	[948] = {
		Scale = 12.120840087891,
		X = -936.25,
		Y = -276.66599121094,
		Overlay = "spiresofarak",
	},
	[949] = {
		Scale = 16.3541796875,
		X = -1013.333984375,
		Y = -1917.916015625,
		Overlay = "gorgrond",
	},
	[950] = {
		Scale = 11.35,
		X = -1861.666015625,
		Y = -984.583984375,
		Overlay = "nagranddraenor",
	},
	[951] = {
		Scale = 4.8,
		X = 816.666796875,
		Y = -46.666796875,
		Overlay = "timelessisle",
		Name = L["Timeless Isle"],
		Explored = true,
	},
	[962] = {
		Scale = 45.471564453125,
		X = -2448.46875,
		Y = -2238.6,
	},
	[970] = {
		Scale = 4.8166599121094,
		X = 210.83400878906,
		Y = -968.333984375,
		Overlay = "tanaanjungleintro",
	},
	[971] = {
		Scale = 1.36666796875,
		X = -109.166796875,
		Y = -418.3333984375,
		Garrison = true,
		City = true,
		MMOutside = true,
		Explored = true,
		MapBaseName = "garrisonsmvalliance_tier",
		Overlay = "garrisonsmvalliance_tier1",
	},
	[973] = {
		BaseMap = 971,
	},
	[974] = {
		BaseMap = 971,
	},
	[975] = {
		BaseMap = 971,
	},
	[976] = {
		Scale = 1.404166015625,
		X = -977.083203125,
		Y = -1162.9166015625,
		Garrison = true,
		City = true,
		MMOutside = true,
		Explored = true,
		MapBaseName = "garrisonffhorde_tier",
		Overlay = "garrisonffhorde_tier1",
	},
	[978] = {
		Scale = 6.2458203125,
		X = 534.583984375,
		Y = -1115.416015625,
		Explored = true,
		Overlay = "ashran",
	},
	[980] = {
		BaseMap = 976
	},
	[981] = {
		BaseMap = 976
	},	
	[982] = {
		BaseMap = 976
	},	
	[990] = {
		BaseMap = 976,
	},
	[991] = {
		BaseMap = 971,
	},	
	[1007] = {
		Scale = 37.67636,
		X = -2620.02,
		Y = -1452.426,		
	},	
	[1009] = {
		Scale = 1.375,
		X = 725,
		Y = -781.6666015625,
		Explored = true,
		City = true,
		Overlay = "ashranalliancefactionhub",
	},
	[1010] = {
		Name = L["Tarren Mills vs Southshore"],
		Scale = 4.337498046875,
		X = -13000,
		Y = 1000,
		MapBaseName = "HillsbradFoothillsBG",
		Short = "TvS",
	},
	[1011] = {
		Scale = 1.6,
		X = 717.916796875,
		Y = -1108.333203125,
		Explored = true,
		City = true,
		Overlay = "ashranhordefactionhub",
	},
	[1014] = {
		Scale = 1.8,
		X = -983,
		Y = 112,
		Overlay = "dalaran70",		
		City = true,
		Alpha = .85,
		MapLevel = 1,		
	},
	[1015] = {
		 Scale = 13.179166,
		 X = -1966.25,
		 Y = -361.25,
		 Overlay = "azsuna",
		 Name = L["Azsuna"],
	},
	[1017] = {
		 Scale = 11.60416,
		 X = -1006.666,
		 Y = -1035.416,
		 Overlay = "stormheim",
		 Name = L["Stormheim"],
	},
	[1018] = {
		 Scale = 11.020834,
		 X = -1921.25,
		 Y = -992.9166,
		 Overlay = "valsharah",
		 Name = L["Val'Sharah"]
	},
	[1021] = {
		 Scale = 7.7,
		 X = -983.334,
		 Y = 0.833204,
		 Overlay = "brokenshore",
		 Name = L["Broken Shore"],
	},
	[1024] = {
		 Scale = 14.141666,
		 X = -1537.9166,
		 Y = -1392.5,
		 Overlay = "highmountain",
		 Name = L["Highmountain"],
	},
	[1028] = {
		 Scale = 7.487501968,
		 X = -3105.8334,
		 Y = -514.5834,
		 Overlay = "mardumtheshatteredabyss",
		Name = L["Mardum, The Shattered Abyss"],
		Explored = true,
	},
	[1033] = {
		 Scale = 11.10416,
		 X = -1331.666,
		 Y = -689.166,
		 Overlay = "suramar",
		 Name = L["Suramar"],
	},
	[1080] = {
		Scale = 1.8625,
		X = -960,
		Y = -879.5832,
		Explored = true,
		City = true,		
		Overlay = "thundertotem",
	},
	[1135] = {
		Scale = 7.429172,
		X = -754.584,
		Y = -530.834,
		Name = L["Krokuun"],
		Overlay = "argussurface",
		MId = 1135,
		XOff = -100,
		YOff = 100,
	},
	[1170] = {
		 Scale = 6.5166,
		 X = -2309.16,
		 Y = -1324.584,
		 Name = L["Mac'Aree"],
		 Overlay = "argusmacaree",		 
		 MId = 1170,
		 XOff = 1400,
		 YOff = 500,
	},
	[1171] = {
		 Scale = 6.80006,
		 X = -2255.84,
		 Y = 357.916,
		 Name = L["Antoran Wastes"],
		 Overlay = "arguscore",
		 MId = 1171,
		 XOff = 800,
		 YOff = -900,
	},
	[1184] = {
		 Scale = 13.53196,
		 X = -1457.47,
		 Y = -852.756,
	},
	[9005] = {		-- Blade's Edge Arena
		Name = L["Blade's Edge Arena"],
		1,
		-16000,4000,
		Short = "BEA",
		Arena = true
	},
	[9006] = {		-- Nagrand Arena
		Name = L["Nagrand Arena"],
		1,
		-16000,5000,
		Short = "NA",
		Arena = true
	},
	[9007] = {		-- Ruins of Lordaeron
		Name = L["Ruins of Lordaeron"],
		1,
		-16000,6000,
		Short = "RL",
		Arena = true
	},
	[9014] = {
		Name = L["Tol'vir Proving Grounds"],
		3.0,
		-14500,6000,
		Short = "TPG",
		Arena = true
	},

	[9016] = {
		Name = L["Tigers Peak Arena"],
		1,
		-13000,1000,
		Short = "TPA",
		Arena = true,
	},
}

--------

Map.InstanceInfo = {		-- Blizzard instance maps (SetInstanceMap uses size of 3 for table entries)
}

Map.ZoneOverlays = {

	-- Kalimdor

		["moonglade"] = {
			["shrineofremulos"] = "209,91,271,296",
			["lakeeluneara"] = "219,273,431,319",
			["stormragebarrowdens"] = "542,210,275,346",
			["nighthaven"] = "370,135,346,244",
		},
		["barrens"] = {
			["dreadmistpeak"] = "290,104,241,195",
			["thornhill"] = "481,254,239,231",
			["thestagnantoasis"] = "344,379,336,289",
			["farwatchpost"] = "555,129,207,332",
			["thesludgefen"] = "403,6,257,249",
			["thewailingcaverns"] = "152,318,377,325",
			["thedryhills"] = "116,57,283,270",
			["themerchantcoast"] = "556,456,315,212",
			["boulderlodemine"] = "511,7,278,209",
			["theforgottenpools"] = "100,208,446,256",
			["morshanrampart"] = "258,6,261,216",
			["ratchet"] = "547,379,219,175",
			["thecrossroads"] = "362,275,233,193",
			["groldomfarm"] = "448,127,243,217",
		},
		["winterspring"] = {
			["icethistlehills"] = "581,314,249,217",
			["lakekeltheril"] = "372,268,271,258",
			["starfallvillage"] = "229,33,367,340",
			["mazthoril"] = "399,340,257,238",
			["frostsaberrock"] = "304,0,332,268",
			["timbermawpost"] = "92,302,362,252",
			["thehiddengrove"] = "500,17,333,255",
			["frostwhispergorge"] = "424,474,317,183",
			["everlook"] = "482,195,194,229",
			["owlwingthicket"] = "556,439,254,150",
			["winterfallvillage"] = "588,181,221,209",
			["frostfirehotsprings"] = "93,118,376,289",
		},
		["uldum_terrain1"] = {
			["thegateofunendingcycles"] = "647,15,161,236",
			["thecursedlanding"] = "752,170,237,316",
			["ruinsofammon"] = "217,289,203,249",
			["akhenetfields"] = "471,277,164,185",
			["orsis"] = "264,136,249,243",
			["nahom"] = "583,162,237,194",
			["ramkahen"] = "411,67,228,227",
			["obeliskofthemoon"] = "110,0,400,224",
			["obeliskofthesun"] = "340,282,269,203",
			["thetrailofdevestation"] = "657,349,206,204",
			["cradeloftheancient"] = "341,402,202,169",
			["schnottzslanding"] = "28,221,312,289",
			["marat"] = "406,174,160,193",
			["virnaaldam"] = "479,215,151,144",
			["throneofthefourwinds"] = "229,433,270,229",
			["thevortexpinnacle"] = "656,473,213,195",
			["hallsoforigination"] = "599,184,269,242",
			["templeofuldum"] = "132,127,296,209",
			["obeliskofthestars"] = "551,121,196,170",
			["ruinsofahmtul"] = "365,0,278,173",
			["khartutstomb"] = "542,0,203,215",
			["neferset"] = "407,384,209,254",
			["tahretgrounds"] = "545,193,150,159",
			["lostcityofthetolvir"] = "527,291,233,321",
		},
		["ashenvale"] = {
			["theshrineofassenia"] = "40,275,306,283",
			["nightrun"] = "595,253,221,257",
			["fallenskylake"] = "529,385,287,276",
			["warsonglumbercamp"] = "771,265,231,223",
			["lakefalathim"] = "112,148,184,232",
			["satyrnaar"] = "696,154,235,236",
			["thehowlingvale"] = "473,97,325,239",
			["raynewoodretreat"] = "481,221,231,256",
			["thezoramstrand"] = "0,0,262,390",
			["felfirehill"] = "714,317,277,333",
			["maelstraspost"] = "188,0,246,361",
			["thunderpeak"] = "377,121,203,310",
			["theruinsofstardust"] = "210,331,236,271",
			["orendilsretreat"] = "143,0,244,251",
			["astranaar"] = "255,164,251,271",
			["thistlefurvillage"] = "255,78,314,241",
			["silverwindrefuge"] = "338,335,347,308",
			["boughshadow"] = "836,148,166,211",
		},
		["teldrassil"] = {
			["banethilhollow"] = "374,221,175,235",
			["shadowglen"] = "481,104,241,217",
			["gnarlpinehold"] = "347,355,198,181",
			["thecleft"] = "432,109,144,226",
			["theoracleglade"] = "276,90,194,244",
			["rutheranvillage"] = "329,448,317,220",
			["lakealameth"] = "422,310,289,202",
			["wellspringlake"] = "382,83,165,249",
			["starbreezevillage"] = "544,217,187,196",
			["galardellvalley"] = "466,237,178,186",
			["poolsofarlithrien"] = "345,243,140,210",
			["darnassus"] = "149,181,298,337",
		},
		["mulgore"] = {
			["baeldundigsite"] = "226,220,218,192",
			["winterhoofwaterwell"] = "449,340,174,185",
			["redcloudmesa"] = "286,401,446,264",
			["redrocks"] = "514,43,186,185",
			["ravagedcaravan"] = "435,224,187,165",
			["thunderhornwaterwell"] = "333,202,201,167",
			["theventurecomine"] = "530,138,208,300",
			["wildmanewaterwell"] = "331,0,190,172",
			["thunderbluff"] = "208,62,373,259",
			["windfuryridge"] = "400,0,222,202",
			["bloodhoofvillage"] = "319,273,302,223",
			["stonetalonpass"] = "201,0,237,184",
			["therollingplains"] = "527,291,260,243",
			["palemanerock"] = "248,321,172,205",
			["thegoldenplains"] = "448,101,186,216",
		},
		["hyjal"] = {
			["archimondesvengeance"] = "320,5,270,300",
			["shrineofgoldrinn"] = "116,17,291,321",
			["nordrassil"] = "392,0,537,323",
			["gatesofsothann"] = "622,320,272,334",
			["sethriasroost"] = "139,436,277,232",
			["theregrowth"] = "52,253,441,319",
			["direforgehill"] = "303,197,270,173",
			["ashenlake"] = "6,78,282,418",
			["thescorchedplain"] = "411,216,365,264",
			["thethroneofflame"] = "318,378,419,290",
			["darkwhispergorge"] = "682,128,320,471",
		},
		["felwood"] = {
			["irontreewoods"] = "406,55,261,273",
			["morlosaran"] = "476,484,187,176",
			["bloodvenomfalls"] = "220,231,345,192",
			["jaedenar"] = "234,317,319,176",
			["felpawvillage"] = "471,0,307,161",
			["jadefirerun"] = "303,9,263,199",
			["ruinsofconstellas"] = "278,359,268,214",
			["deadwoodvillage"] = "410,505,173,163",
			["emeraldsanctuary"] = "394,382,274,212",
			["shatterscarvale"] = "243,107,343,250",
			["talonbranchglade"] = "531,57,209,226",
			["jadefireglen"] = "288,458,229,210",
		},
		["darkshore"] = {
			["lordanel"] = "391,54,277,281",
			["eyeofthevortex"] = "300,239,330,192",
			["nazjvel"] = "207,467,244,201",
			["wildbendriver"] = "280,378,314,193",
			["ruinsofauberdine"] = "280,182,203,194",
			["witheringthicket"] = "305,118,328,250",
			["shatterspearvale"] = "596,16,250,241",
			["shatterspearwarcamp"] = "565,0,245,147",
			["ametharan"] = "294,330,326,145",
			["ruinsofmathystra"] = "517,28,200,263",
			["themastersglaive"] = "277,483,303,185",
		},
		["aszhara"] = {
			["bearshead"] = "113,141,256,224",
			["thesecretlab"] = "353,396,184,213",
			["ruinsofarkkoran"] = "575,121,219,193",
			["darnassianbasecamp"] = "343,3,243,262",
			["lakemennar"] = "245,377,210,232",
			["ravencrestmonument"] = "476,401,295,267",
			["stormcliffs"] = "407,403,207,232",
			["theshatteredstrand"] = "316,168,206,329",
			["gallywixpleasurepalace"] = "70,222,250,230",
			["blackmawhold"] = "204,53,260,267",
			["bilgewaterharbor"] = "395,127,587,381",
			["towerofeldara"] = "684,22,306,337",
			["orgimmarreargate"] = "22,344,352,274",
			["bitterreaches"] = "477,0,321,247",
			["ruinsofeldarath"] = "228,229,218,237",
		},
		["ungorocrater"] = {
			["lakkaritarpits"] = "305,0,432,294",
			["ironstoneplateau"] = "706,201,197,222",
			["therollinggarden"] = "565,39,337,321",
			["golakkahotsprings"] = "145,226,309,277",
			["theslitheringscar"] = "335,384,381,274",
			["thescreamingreaches"] = "157,0,332,332",
			["mossypile"] = "328,179,186,185",
			["themarshlands"] = "573,256,263,412",
			["fireplumeridge"] = "356,192,321,288",
			["terrorrun"] = "162,357,316,293",
			["fungalrock"] = "557,0,224,191",
			["marshalsstand"] = "462,330,204,170",
		},
		["desolace"] = {
			["valleyofspears"] = "170,196,321,275",
			["gelkisvillage"] = "207,472,274,196",
			["mannoroccoven"] = "381,357,326,311",
			["thunderaxefortress"] = "440,49,220,205",
			["shokthokar"] = "589,319,309,349",
			["cenarionwildlands"] = "415,156,312,285",
			["sargeron"] = "655,0,317,293",
			["nijelspoint"] = "573,0,231,257",
			["magramterritory"] = "613,170,289,244",
			["thargadscamp"] = "275,376,212,186",
			["tethrisaran"] = "399,0,274,145",
			["kodograveyard"] = "360,273,250,215",
			["ranzjarisle"] = "210,0,161,141",
			["shadowbreakravine"] = "637,402,292,266",
			["shadowpreyvillage"] = "142,369,222,299",
			["slitherbladeshore"] = "208,24,338,342",
		},
		["tanaris"] = {
			["landsendbeach"] = "431,452,224,216",
			["southbreakshore"] = "437,289,274,186",
			["zulfarrak"] = "184,0,315,190",
			["valleryofthewatchers"] = "255,431,269,190",
			["southmoonruins"] = "301,349,232,211",
			["brokenpillar"] = "413,211,195,163",
			["thegapingchasm"] = "448,364,225,187",
			["cavernsoftime"] = "507,238,213,173",
			["gadgetzan"] = "412,92,189,180",
			["dunemaulcompound"] = "305,257,231,177",
			["gadgetzanbay"] = "479,9,254,341",
			["lostriggercover"] = "615,201,178,243",
			["eastmoonruins"] = "380,341,173,163",
			["abyssalsands"] = "297,148,255,194",
			["thistleshrubvalley"] = "185,280,221,293",
			["thenoxiouslair"] = "258,211,179,190",
			["sandsorrowwatch"] = "293,99,214,149",
		},
		["uldum"] = {
			["thegateofunendingcycles"] = "647,15,161,236",
			["thecursedlanding"] = "752,170,237,316",
			["ruinsofammon"] = "217,289,203,249",
			["akhenetfields"] = "471,277,164,185",
			["orsis"] = "264,136,249,243",
			["nahom"] = "583,162,237,194",
			["ramkahen"] = "411,67,228,227",
			["obeliskofthemoon"] = "110,0,400,224",
			["obeliskofthesun"] = "340,282,269,203",
			["thetrailofdevestation"] = "657,349,206,204",
			["cradeloftheancient"] = "341,402,202,169",
			["schnottzslanding"] = "28,221,312,289",
			["marat"] = "406,174,160,193",
			["virnaaldam"] = "479,215,151,144",
			["throneofthefourwinds"] = "229,433,270,229",
			["thevortexpinnacle"] = "656,473,213,195",
			["hallsoforigination"] = "599,184,269,242",
			["templeofuldum"] = "132,127,296,209",
			["obeliskofthestars"] = "551,121,196,170",
			["ruinsofahmtul"] = "365,0,278,173",
			["khartutstomb"] = "542,0,203,215",
			["neferset"] = "407,384,209,254",
			["tahretgrounds"] = "545,193,150,159",
			["lostcityofthetolvir"] = "527,291,233,321",
		},
		["ahnqirajthefallenkingdom"] = {
			["aqkingdom"] = "115,0,887,668",
		},
		["durotar"] = {
			["razormanegrounds"] = "302,264,248,158",
			["echoisles"] = "429,413,330,255",
			["thunderridge"] = "295,48,220,218",
			["skullrock"] = "438,0,208,157",
			["tiragardekeep"] = "462,298,210,200",
			["valleyoftrials"] = "304,312,254,258",
			["southfurywatershed"] = "282,174,244,222",
			["drygulchravine"] = "415,60,236,196",
			["senjinvillage"] = "457,406,192,184",
			["razorhill"] = "431,157,224,227",
			["northwatchfoothold"] = "399,440,162,157",
			["orgrimmar"] = "309,0,259,165",
		},
		["feralas"] = {
			["campmojache"] = "671,181,174,220",
			["feathermoonstronghold"] = "362,237,217,192",
			["darkmistruins"] = "568,287,172,198",
			["writhingdeep"] = "652,298,232,206",
			["ruinsoffeathermoon"] = "186,229,208,204",
			["theforgottencoast"] = "375,343,194,304",
			["feralscar"] = "457,281,191,179",
			["grimtotemcompund"] = "607,170,159,218",
			["ruinsofisildien"] = "467,354,206,237",
			["gordunnioutpost"] = "663,116,192,157",
			["thetwincolossals"] = "271,0,350,334",
			["diremaul"] = "485,101,265,284",
			["lowerwilds"] = "756,191,207,209",
		},
		["silithus"] = {
			["thescarabwall"] = "0,455,580,213",
			["valorsrest"] = "614,0,315,285",
			["twilightbasecamp"] = "100,151,434,231",
			["southwindvillage"] = "550,181,309,243",
			["thecrystalvale"] = "126,0,329,246",
			["hiveashi"] = "345,4,405,267",
			["cenarionhold"] = "427,143,292,260",
			["hiveregal"] = "380,310,489,358",
			["hivezora"] = "0,206,542,367",
		},
		["stonetalonmountains"] = {
			["windshearcrag"] = "533,179,374,287",
			["kromgarfortress"] = "588,341,183,196",
			["stonetalonpeak"] = "265,0,305,244",
			["unearthedgrounds"] = "654,369,265,206",
			["greatwoodvale"] = "602,448,322,220",
			["boulderslideravine"] = "532,512,194,156",
			["cliffwalkerpost"] = "366,95,241,192",
			["webwinderpath"] = "468,263,267,352",
			["sunrockretreat"] = "353,285,222,222",
			["webwinderhollow"] = "479,401,164,258",
			["ruinsofeldrethar"] = "367,411,221,235",
			["battlescarvalley"] = "220,189,290,297",
			["windshearhold"] = "516,289,176,189",
			["thaldarahoverlook"] = "252,121,210,189",
			["malakajin"] = "618,537,211,131",
			["mirkfallonlake"] = "417,143,244,247",
			["thecharredvale"] = "199,368,277,274",
		},
		["southernbarrens"] = {
			["huntershill"] = "300,64,218,178",
			["honorsstand"] = "201,0,315,170",
			["ruinsoftaurajo"] = "244,286,285,171",
			["razorfenkraul"] = "273,528,214,140",
			["vendettapoint"] = "267,196,254,214",
			["forwardcommand"] = "423,251,216,172",
			["battlescar"] = "274,307,384,248",
			["theovergrowth"] = "289,117,355,226",
			["baelmodan"] = "398,457,269,211",
			["northwatchhold"] = "548,147,280,279",
			["frazzlecrazmotherload"] = "269,436,242,195",
		},
		["dustwallow"] = {
			["witchhill"] = "428,0,270,353",
			["theramoreisle"] = "542,223,305,247",
			["direhornpost"] = "358,169,279,301",
			["blackhoofvillage"] = "199,0,344,183",
			["brackenwllvillage"] = "133,59,384,249",
			["alcazisland"] = "656,21,206,200",
			["mudsprocket"] = "109,313,433,351",
			["shadyrestinn"] = "137,188,317,230",
			["thewyrmbog"] = "359,369,436,299",
		},
		["hyjal_terrain1"] = {
			["archimondesvengeance"] = "320,5,270,300",
			["shrineofgoldrinn"] = "116,17,291,321",
			["nordrassil"] = "392,0,537,323",
			["gatesofsothann"] = "622,320,272,334",
			["sethriasroost"] = "139,436,277,232",
			["theregrowth"] = "52,253,441,319",
			["direforgehill"] = "303,197,270,173",
			["ashenlake"] = "6,78,282,418",
			["thescorchedplain"] = "411,216,365,264",
			["thethroneofflame"] = "318,378,419,290",
			["darkwhispergorge"] = "682,128,320,471",
		},
		["thousandneedles"] = {
			["southseaholdfast"] = "756,412,246,256",
			["thetwilightwithering"] = "347,329,374,339",
			["splithoofheights"] = "571,49,431,410",
			["thegreatlift"] = "136,0,272,232",
			["razorfendowns"] = "298,0,361,314",
			["theshimmeringdeep"] = "591,257,411,411",
			["freewindpost"] = "276,186,436,271",
			["highperch"] = "0,134,246,380",
			["rustmauldivesite"] = "527,465,234,203",
			["westreachsummit"] = "0,0,280,325",
			["twilightbulwark"] = "125,241,358,418",
			["darkcloudpinnacle"] = "169,116,317,252",
		},

	-- Eastern Kingdoms

		["vashjirruins"] = {
			["nespirah"] = "460,261,286,269",
			["glimmeringdeepgorge"] = "270,222,272,180",
			["silvertidehollow"] = "150,32,480,319",
			["shimmeringgrotto"] = "400,0,339,278",
			["ruinsofvashjir"] = "217,268,349,361",
			["ruinsoftherseral"] = "554,175,197,223",
			["bethmoraridge"] = "407,445,335,223",
		},
		["duskwood"] = {
			["theyorgenfarmstead"] = "401,396,233,248",
			["addlesstead"] = "32,348,299,296",
			["thetranquilgardenscemetary"] = "627,344,291,244",
			["darkshire"] = "640,128,329,314",
			["brightwoodgrove"] = "497,112,279,399",
			["vulgologremound"] = "228,355,268,282",
			["thehushedbank"] = "0,152,189,307",
			["thedarkenedbank"] = "71,26,931,235",
			["manormistmantle"] = "661,122,219,182",
			["racenhill"] = "96,292,205,157",
			["thetwilightgrove"] = "314,101,320,388",
			["therottingorchard"] = "539,368,291,263",
			["ravenhillcemetary"] = "91,132,323,309",
		},
		["vashjirkelpforest"] = {
			["darkwhispergorge"] = "528,228,220,189",
			["honorstomb"] = "380,43,291,206",
			["legionsfate"] = "210,35,278,315",
			["gnawsboneyard"] = "451,325,311,217",
			["theaccursedreef"] = "365,162,340,225",
			["gubogglesledge"] = "399,280,227,207",
			["holdingpens"] = "456,401,316,267",
		},
		["twilighthighlands_terrain1"] = {
			["victorypoint"] = "302,306,177,159",
			["dragonmawpass"] = "76,120,283,206",
			["bloodgulch"] = "416,205,215,157",
			["obsidianforest"] = "436,380,342,288",
			["thundermar"] = "374,93,238,229",
			["grimbatol"] = "83,223,230,276",
			["theblackbreach"] = "498,121,211,210",
			["wyrmsbend"] = "205,232,191,198",
			["dragonmawport"] = "631,245,251,207",
			["crucibleofcarnage"] = "387,268,203,208",
			["twilightshore"] = "610,345,260,202",
			["vermillionredoubt"] = "71,16,324,264",
			["thegullet"] = "269,179,175,180",
			["humboldtconflaguration"] = "344,89,143,141",
			["gorshakwarcamp"] = "543,220,194,170",
			["highbank"] = "697,403,220,227",
			["crushblow"] = "370,447,182,195",
			["thetwilightcitadel"] = "151,314,361,354",
			["highlandforest"] = "482,330,239,232",
			["thetwilightbreach"] = "312,192,199,212",
			["thekrazzworks"] = "654,0,226,232",
			["slitheringcove"] = "622,169,198,201",
			["thetwilightgate"] = "327,356,165,199",
			["ruinsofdrakgor"] = "296,0,206,182",
			["firebeardspatrol"] = "499,265,215,181",
			["dunwaldruins"] = "395,367,197,218",
			["weepingwound"] = "358,0,214,190",
			["kirthaven"] = "482,0,308,267",
			["glopgutshollow"] = "291,89,174,190",
		},
		["hinterlands"] = {
			["queldanillodge"] = "220,181,241,211",
			["thealtarofzul"] = "357,343,225,196",
			["shaolwatha"] = "565,208,281,261",
			["thecreepingruin"] = "390,252,199,199",
			["zunwatha"] = "152,284,226,225",
			["plaguemistravine"] = "133,105,191,278",
			["shadraalor"] = "220,379,240,196",
			["aeriepeak"] = "0,236,238,267",
			["valorwindlake"] = "286,269,199,212",
			["agolwatha"] = "367,159,208,204",
			["jinthaalor"] = "487,334,287,289",
			["skulkrock"] = "490,195,176,235",
			["seradane"] = "475,5,303,311",
			["theoverlookcliffs"] = "677,267,244,401",
		},
		["blastedlands"] = {
			["serpentscoil"] = "459,97,218,183",
			["nethergardekeep"] = "530,6,295,205",
			["dreadmaulpost"] = "327,182,235,188",
			["altarofstorms"] = "225,110,238,195",
			["riseofthedefiler"] = "375,102,168,170",
			["dreadmaulhold"] = "258,0,272,206",
			["thetaintedforest"] = "132,311,348,357",
			["surwich"] = "333,474,199,191",
			["thedarkportal"] = "368,179,370,298",
			["theredreaches"] = "533,268,268,354",
			["shattershore"] = "578,91,240,270",
			["sunveilexcursion"] = "386,374,233,266",
			["nethergardesupplycamps"] = "436,0,195,199",
			["thetaintedscar"] = "144,175,308,226",
		},
		["wetlands"] = {
			["sundownmarsh"] = "121,63,276,243",
			["blackchannelmarsh"] = "37,240,301,232",
			["dunalgaz"] = "346,419,298,215",
			["slabchiselssurvey"] = "532,352,300,316",
			["satlspray"] = "218,0,250,282",
			["greenwardensgrove"] = "460,102,250,269",
			["raptorridge"] = "599,123,256,245",
			["thelganrock"] = "371,335,258,207",
			["bluegillmarsh"] = "31,102,321,248",
			["mosshidefen"] = "506,232,369,235",
			["direforgehills"] = "506,34,329,228",
			["angerfangencampment"] = "359,201,236,256",
			["whelgarsexcavationsite"] = "185,195,298,447",
			["dunmodr"] = "356,7,257,185",
			["ironbeardstomb"] = "372,76,185,224",
			["menethilharbor"] = "0,297,325,363",
		},
		["easternplaguelands"] = {
			["zulmashar"] = "528,0,286,176",
			["thefungalvale"] = "183,211,274,216",
			["theundercroft"] = "56,457,280,211",
			["lightshopechapel"] = "687,271,196,220",
			["corinscrossing"] = "493,289,186,213",
			["tyrshand"] = "651,414,214,254",
			["eastwalltower"] = "541,184,181,176",
			["northpasstower"] = "401,69,250,192",
			["acherus"] = "774,102,228,273",
			["thondorilriver"] = "0,100,262,526",
			["themarrisstead"] = "133,335,202,202",
			["thenoxiousglade"] = "650,55,297,299",
			["thepestilentscar"] = "383,348,182,320",
			["theinfectisscar"] = "595,263,177,266",
			["terrordale"] = "0,10,258,320",
			["blackwoodlake"] = "382,151,238,231",
			["stratholme"] = "118,0,310,178",
			["quellithienlodge"] = "351,0,277,175",
			["plaguewood"] = "144,40,328,253",
			["darrowshire"] = "211,462,248,206",
			["ruinsofthescarletenclave"] = "738,295,264,373",
			["lightsshieldtower"] = "391,271,243,162",
			["northdale"] = "570,61,265,232",
			["crownguardtower"] = "258,351,202,191",
			["lakemereldar"] = "462,427,266,241",
		},
		["badlands"] = {
			["agmondsend"] = "230,315,342,353",
			["apocryphansrest"] = "0,66,252,353",
			["campcagg"] = "0,281,339,347",
			["uldaman"] = "336,0,266,210",
			["lethlorravine"] = "533,55,469,613",
			["campboff"] = "407,220,274,448",
			["hammertoesdigsite"] = "411,116,209,196",
			["campkosh"] = "504,19,236,260",
			["angorfortress"] = "230,68,285,223",
			["deathwingscar"] = "175,178,328,313",
			["thedustbowl"] = "144,99,214,285",
		},
		["silverpine"] = {
			["northtidesrun"] = "147,0,281,345",
			["thesepulcher"] = "341,157,218,200",
			["forsakenhighcommand"] = "445,0,361,175",
			["thedecrepitfields"] = "471,156,176,152",
			["northtidesbeachhead"] = "323,68,174,199",
			["theforsakenfront"] = "433,327,152,189",
			["valgansfield"] = "461,77,162,172",
			["deepelemmine"] = "483,212,217,198",
			["thebattlefront"] = "349,429,255,180",
			["fenrisisle"] = "581,15,352,302",
			["shadowfangkeep"] = "337,337,179,165",
			["olsensfarthing"] = "312,249,251,167",
			["ambermill"] = "509,250,283,243",
			["berensperil"] = "505,405,318,263",
			["forsakenrearguard"] = "369,0,186,238",
			["thegreymanewall"] = "318,506,409,162",
			["theskitteringdark"] = "236,0,227,172",
		},
		["thecapeofstranglethorn"] = {
			["bootybay"] = "289,341,225,255",
			["gurubashiarena"] = "345,0,238,260",
			["mistvalevalley"] = "408,248,253,242",
			["crystalveinmine"] = "528,73,271,204",
			["wildshore"] = "340,392,236,276",
			["nekmaniwellspring"] = "292,213,246,221",
			["ruinsofaboraz"] = "533,181,184,176",
			["jagueroisle"] = "471,404,240,264",
			["thesundering"] = "452,0,244,209",
			["hardwrenchhideaway"] = "208,116,356,221",
			["ruinsofjubuwal"] = "468,119,155,221",
		},
		["vashjirdepths"] = {
			["abyssalbreach"] = "497,0,491,470",
			["seabrush"] = "415,183,225,250",
			["fireplumetrench"] = "315,110,298,251",
			["lghorek"] = "162,210,306,293",
			["coldlightchasm"] = "266,280,267,374",
			["abandonedreef"] = "50,263,371,394",
			["korthunsend"] = "412,283,370,385",
			["deepfinridge"] = "275,32,363,262",
		},
		["stranglethornjungle"] = {
			["kurzenscompound"] = "499,0,244,238",
			["balalruins"] = "267,168,159,137",
			["thevilereef"] = "140,208,236,224",
			["moshoggogremound"] = "543,253,234,206",
			["ruinsofzulkunda"] = "158,0,228,265",
			["fortlivingston"] = "398,375,230,170",
			["mazthoril"] = "488,364,350,259",
			["nesingwarysexpedition"] = "306,63,227,190",
			["zuuldalaruins"] = "9,22,324,263",
			["kalairuins"] = "354,184,139,150",
			["zulgurub"] = "626,0,376,560",
			["baliamahruins"] = "397,243,239,205",
			["bambala"] = "566,164,190,176",
			["mizjahruins"] = "387,246,157,173",
			["lakenazferiti"] = "413,95,240,228",
			["gromgolbasecamp"] = "298,228,167,179",
			["rebelcamp"] = "306,0,302,166",
		},
		["ruinsofgilneas"] = {
			["gilneaspuzzle"] = "0,0,1002,668",
		},

		["gilneas_terrain2"] = {
			["greymanemanor"] = "141,202,244,241",
			["theblackwald"] = "504,394,280,224",
			["theheadlands"] = "160,0,328,336",
			["crowleyorchard"] = "261,427,210,166",
			["emberstonemine"] = "639,43,281,351",
			["duskhaven"] = "272,333,286,178",
			["tempestsreach"] = "652,290,350,345",
			["korothsden"] = "393,386,222,268",
			["hammondfarmstead"] = "167,352,194,236",
			["haywardfishery"] = "293,449,177,219",
			["stormglenvillage"] = "516,465,321,203",
			["northgatewoods"] = "482,14,282,298",
			["northernheadlands"] = "387,0,267,314",
			["keelharbor"] = "298,95,280,342",
		},
		["searinggorge"] = {
			["blackrockmountain"] = "243,424,304,244",
			["thoriumpoint"] = "255,38,429,301",
			["tannercamp"] = "413,360,571,308",
			["thecauldron"] = "232,171,481,360",
			["blackcharcave"] = "0,361,375,307",
			["grimsiltworksite"] = "531,241,441,266",
			["firewatchridge"] = "0,75,365,393",
			["dustfirevalley"] = "588,0,392,355",
		},
		["elwynn"] = {
			["westbrookgarrison"] = "116,355,269,313",
			["jerodslanding"] = "396,430,230,206",
			["northshirevalley"] = "355,138,295,296",
			["goldshire"] = "247,294,276,231",
			["stromwind"] = "0,0,512,422",
			["stonecairnlake"] = "552,186,340,272",
			["crystallake"] = "417,327,220,207",
			["towerofazora"] = "529,287,270,241",
			["ridgepointtower"] = "708,442,285,194",
			["brackwellpumpkinpatch"] = "532,424,287,216",
			["fargodeepmine"] = "240,420,269,248",
			["eastvaleloggingcamp"] = "703,292,294,243",
		},
		["arathi"] = {
			["refugepoint"] = "293,145,196,270",
			["galensfall"] = "0,144,212,305",
			["northfoldmanor"] = "132,105,227,268",
			["circleofeastbinding"] = "506,126,183,238",
			["bouldergor"] = "171,123,249,278",
			["goshekfarm"] = "430,249,306,248",
			["cirecleofouterbinding"] = "332,273,215,188",
			["hammerfall"] = "581,118,270,271",
			["thandolspan"] = "261,416,237,252",
			["boulderfisthall"] = "327,367,252,258",
			["faldirscove"] = "77,400,273,268",
			["witherbarkvillage"] = "476,359,260,220",
			["stromgardekeep"] = "21,269,284,306",
			["dabyriesfarmstead"] = "404,144,210,227",
			["circleofinnerbinding"] = "201,312,228,227",
			["circleofwestbinding"] = "85,24,220,287",
		},
		["dunmorogh"] = {
			["thegrizzledden"] = "374,287,211,160",
			["coldridgepass"] = "360,340,225,276",
			["kharanos"] = "449,220,184,188",
			["gnomeregan"] = "0,27,409,318",
			["thetundridhills"] = "579,306,174,249",
			["theshimmeringdeep"] = "397,132,171,234",
			["golbolarquarry"] = "663,288,198,251",
			["iceflowlake"] = "263,0,236,358",
			["amberstillranch"] = "595,225,249,183",
			["ironforgeairfield"] = "630,0,308,335",
			["frostmanehold"] = "50,227,437,249",
			["coldridgevalley"] = "100,366,398,302",
			["ironforge"] = "398,0,376,347",
			["helmsbedlake"] = "760,268,218,234",
			["northgateoutpost"] = "765,43,237,366",
			["frostmanefront"] = "469,256,226,335",
		},
		["westfall"] = {
			["thedaggerhills"] = "303,395,292,273",
			["furlbrowspumpkinfarm"] = "394,0,197,213",
			["thegapingchasm"] = "294,168,184,217",
			["jangoloadmine"] = "311,0,196,229",
			["goldcoastquarry"] = "199,79,235,306",
			["themolsenfarm"] = "348,118,202,224",
			["westfalllighthouse"] = "221,477,211,167",
			["sentinelhill"] = "404,226,229,265",
			["demontsplace"] = "203,376,201,195",
			["alexstonfarmstead"] = "167,263,346,222",
			["saldeansfarm"] = "451,81,244,237",
			["moonbrook"] = "308,325,232,213",
			["thedustplains"] = "480,378,317,261",
			["thedeadacre"] = "531,200,193,273",
			["thejansenstead"] = "474,0,202,179",
		},
		["burningsteppes"] = {
			["blackrockpass"] = "419,258,298,410",
			["dreadmaulrock"] = "568,151,274,263",
			["dracodar"] = "0,237,362,431",
			["altarofstorms"] = "0,0,182,360",
			["ruinsofthaurissan"] = "421,0,324,354",
			["blackrockmountain"] = "79,0,281,388",
			["terrorwingpath"] = "646,7,350,341",
			["blackrockstronghold"] = "235,0,320,385",
			["morgansvigil"] = "615,255,383,413",
			["pillarofash"] = "253,255,274,413",
		},
		["westernplaguelands"] = {
			["thebulwark"] = "48,235,316,316",
			["hearthglen"] = "235,0,432,271",
			["caerdarrow"] = "601,390,194,208",
			["sorrowhill"] = "261,448,368,220",
			["felstonefield"] = "229,228,241,212",
			["darrowmerelake"] = "510,354,492,314",
			["northridgelumbercamp"] = "231,123,359,182",
			["thewrithinghaunt"] = "472,332,169,195",
			["thondrorilriver"] = "533,0,311,436",
			["theweepingcave"] = "551,151,185,230",
			["redpinedell"] = "286,211,290,133",
			["dalsonsfarm"] = "300,232,325,192",
			["andorhal"] = "96,343,464,325",
			["gahrronswithering"] = "495,213,241,252",
		},
		["tirisfal"] = {
			["balnirfarmstead"] = "594,324,242,179",
			["venomwebvale"] = "752,150,250,279",
			["thebulwark"] = "709,330,293,338",
			["brill"] = "480,252,199,182",
			["scarletmonastery"] = "740,47,262,262",
			["scarletwatchpost"] = "692,99,161,234",
			["agamandmills"] = "324,90,285,260",
			["brightwaterlake"] = "573,122,210,292",
			["ruinsoflorderon"] = "423,359,390,267",
			["sollidenfarmstead"] = "201,192,286,225",
			["calstonestate"] = "389,255,179,169",
			["coldhearthmanor"] = "418,317,212,177",
			["deathknell"] = "9,207,431,407",
			["nightmarevale"] = "347,325,225,281",
			["crusaderoutpost"] = "686,232,175,210",
			["garrenshaunt"] = "477,129,190,214",
		},
		["redridge"] = {
			["rendersvalley"] = "451,377,427,291",
			["stonewatchkeep"] = "480,0,228,420",
			["lakeridgehighway"] = "148,316,392,352",
			["campeverstill"] = "445,286,189,193",
			["renderscamp"] = "214,0,357,246",
			["lakeeverstill"] = "81,214,464,250",
			["lakeshire"] = "0,110,410,256",
			["althersmill"] = "350,139,228,247",
			["shalewindcanyon"] = "688,283,306,324",
			["stonewatchfalls"] = "525,302,316,182",
			["galardellvalley"] = "574,0,428,463",
			["threecorners"] = "0,256,323,406",
			["redridgecanyons"] = "37,0,413,292",
		},
		["swampofsorrows"] = {
			["splinterspearjunction"] = "194,236,238,343",
			["stagalbog"] = "540,360,347,303",
			["marshtidewatch"] = "478,0,330,342",
			["pooloftears"] = "575,238,257,229",
			["theshiftingmire"] = "331,24,292,360",
			["sorrowmurk"] = "703,80,229,418",
			["ithariuscave"] = "7,242,268,316",
			["mistyreedstrand"] = "600,0,402,668",
			["stonard"] = "297,258,357,308",
			["mistyvalley"] = "0,80,268,285",
			["theharborage"] = "161,79,266,284",
			["bogpaddle"] = "600,0,262,193",
		},
		["lochmodan"] = {
			["thefarstriderlodge"] = "570,209,349,292",
			["stronewroughtdam"] = "339,0,333,200",
			["silverstreammine"] = "221,0,225,252",
			["northgatepass"] = "16,0,319,289",
			["ironbandsexcavationsite"] = "481,296,397,291",
			["stonesplintervalley"] = "177,345,273,294",
			["thelsamar"] = "0,146,455,295",
			["grizzlepawridge"] = "245,324,273,230",
			["valleyofkings"] = "0,311,310,345",
			["theloch"] = "340,81,330,474",
			["mogroshstronghold"] = "549,52,294,249",
		},
		["deadwindpass"] = {
			["deadmanscrossing"] = "83,0,617,522",
			["thevice"] = "433,208,350,449",
			["karazhan"] = "92,310,513,358",
		},
		["hillsbradfoothills"] = {
			["tarrenmill"] = "494,226,165,203",
			["gavinsnaze"] = "344,254,116,129",
			["lordamereinternmentcamp"] = "194,216,250,167",
			["mistyshore"] = "321,42,158,169",
			["nethandersteed"] = "502,373,204,244",
			["hillsbradfields"] = "191,302,302,175",
			["growlesscave"] = "359,191,171,136",
			["theheadland"] = "390,255,105,148",
			["azurelodemine"] = "287,399,180,182",
			["dalarancrater"] = "102,137,316,238",
			["gallowscorner"] = "451,140,155,147",
			["strahnbrad"] = "505,44,275,193",
			["darrowhill"] = "425,279,147,160",
			["southpointtower"] = "59,310,312,254",
			["dandredsfold"] = "341,0,258,113",
			["slaughterhollow"] = "413,55,148,120",
			["soferasnaze"] = "484,166,148,146",
			["ruinsofalterac"] = "347,85,189,181",
			["corrahnsdagger"] = "426,224,135,160",
			["purgationisle"] = "200,505,144,139",
			["crushridgehold"] = "463,101,134,124",
			["dungarok"] = "542,410,269,258",
			["durnholdekeep"] = "565,217,437,451",
			["chillwindpoint"] = "555,68,447,263",
			["theuplands"] = "441,0,212,160",
			["southshore"] = "383,352,229,219",
		},

	-- Jamie exports

	["azuremystisle"] =
	{
		["ammenford"] = "515,279,256,256",
		["ammenvale"] = "527,104,475,512",
		["azurewatch"] = "383,249,256,256",
		["bristlelimbvillage"] = "174,363,256,256",
		["emberglade"] = "488,24,256,256",
		["fairbridgestrand"] = "356,0,256,128",
		["greezlescamp"] = "507,350,256,256",
		["moongrazewoods"] = "449,183,256,256",
		["odesyuslanding"] = "352,378,256,256",
		["podcluster"] = "281,305,256,256",
		["podwreckage"] = "462,349,128,256",
		["siltingshore"] = "291,3,256,256",
		["silvermystisle"] = "23,446,256,222",
		["stillpinehold"] = "365,49,256,256",
		["theexodar"] = "74,85,512,512",
		["valaarsberth"] = "176,303,256,256",
		["wrathscalepoint"] = "220,421,256,247",
	},
	["bladesedgemountains"] =
	{
		["bashirlanding"] = "422,0,256,256",
		["bladedgulch"] = "623,147,256,256",
		["bladesiprehold"] = "314,161,256,507",
		["bloodmaulcamp"] = "412,95,256,256",
		["bloodmauloutpost"] = "342,371,256,297",
		["brokenwilds"] = "733,109,256,256",
		["circleofwrath"] = "439,210,256,256",
		["deathsdoor"] = "512,249,256,419",
		["forgecampanger"] = "586,147,416,256",
		["forgecampterror"] = "144,416,512,252",
		["forgecampwrath"] = "254,176,256,256",
		["grishnath"] = "286,28,256,256",
		["gruulslayer"] = "527,81,256,256",
		["jaggedridge"] = "446,414,256,254",
		["moknathalvillage"] = "658,297,256,256",
		["ravenswood"] = "214,55,512,256",
		["razorridge"] = "533,332,256,336",
		["ridgeofmadness"] = "554,258,256,410",
		["ruuanweald"] = "479,98,256,512",
		["skald"] = "673,71,256,256",
		["sylvanaar"] = "289,350,256,318",
		["thecrystalpine"] = "585,0,256,256",
		["thunderlordstronghold"] = "405,272,256,396",
		["veillashh"] = "271,428,256,240",
		["veilruuan"] = "563,151,256,128",
		["vekhaarstand"] = "629,406,256,256",
		["vortexpinnacle"] = "166,206,256,462",
	},
	["bloodmystisle"] =
	{
		["amberwebpass"] = "44,62,256,512",
		["axxarien"] = "297,136,256,256",
		["blacksiltshore"] = "177,426,512,242",
		["bladewood"] = "367,209,256,256",
		["bloodscaleisle"] = "763,256,239,256",
		["bloodwatch"] = "437,258,256,256",
		["bristlelimbenclave"] = "546,410,256,256",
		["kesselscrossing"] = "517,527,485,141",
		["middenvale"] = "414,406,256,256",
		["mystwood"] = "309,483,256,185",
		["nazzivian"] = "250,404,256,256",
		["ragefeatherridge"] = "481,117,256,256",
		["ruinsofloretharan"] = "556,216,256,256",
		["talonstand"] = "657,78,256,256",
		["telathionscamp"] = "180,216,128,128",
		["thebloodcursedreef"] = "729,54,256,256",
		["thebloodwash"] = "302,27,256,256",
		["thecrimsonreach"] = "555,87,256,256",
		["thecryocore"] = "293,285,256,256",
		["thefoulpool"] = "221,136,256,256",
		["thehiddenreef"] = "205,39,256,256",
		["thelostfold"] = "503,470,256,198",
		["thevectorcoil"] = "43,238,512,430",
		["thewarppiston"] = "451,29,256,256",
		["veridianpoint"] = "637,0,256,256",
		["vindicatorsrest"] = "232,242,256,256",
		["wrathscalelair"] = "598,338,256,256",
		["wyrmscarisland"] = "613,82,256,256",
	},
	["eversongwoods"] =
	{
		["azurebreezecoast"] = "669,228,256,256",
		["duskwithergrounds"] = "605,253,256,256",
		["eastsanctum"] = "460,373,256,256",
		["elrendarfalls"] = "580,399,128,256",
		["fairbreezevilliage"] = "386,386,256,256",
		["farstriderretreat"] = "524,359,256,128",
		["goldenboughpass"] = "243,469,256,128",
		["lakeelrendar"] = "584,471,128,197",
		["northsanctum"] = "361,298,256,256",
		["ruinsofsilvermoon"] = "307,136,256,256",
		["runestonefalithas"] = "378,496,256,172",
		["runestoneshandor"] = "464,494,256,174",
		["satherilshaven"] = "324,384,256,256",
		["silvermooncity"] = "440,87,512,512",
		["stillwhisperpond"] = "474,314,256,256",
		["sunsailanchorage"] = "231,404,256,128",
		["sunstriderisle"] = "195,5,512,512",
		["thegoldenstrand"] = "183,415,128,253",
		["thelivingwood"] = "511,420,128,248",
		["thescortchedgrove"] = "255,507,256,128",
		["thuronslivery"] = "539,305,256,128",
		["torwatha"] = "648,315,256,353",
		["tranquilshore"] = "215,298,256,256",
		["westsanctum"] = "292,319,128,256",
		["zebwatha"] = "554,475,128,193",
	},
	["ghostlands"] =
	{
		["amanipass"] = "598,232,404,436",
		["bleedingziggurat"] = "184,238,256,256",
		["dawnstarspire"] = "575,0,427,256",
		["deatholme"] = "95,375,512,293",
		["elrendarcrossing"] = "326,0,512,256",
		["farstriderenclave"] = "573,136,429,256",
		["goldenmistvillage"] = "44,0,512,512",
		["howlingziggurat"] = "340,219,256,449",
		["isleoftribulations"] = "585,0,256,256",
		["sanctumofthemoon"] = "210,126,256,256",
		["sanctumofthesun"] = "448,150,256,512",
		["suncrownvillage"] = "460,0,512,256",
		["thalassiapass"] = "364,406,256,262",
		["tranquillien"] = "365,2,256,512",
		["windrunnerspire"] = "40,287,256,256",
		["windrunnervillage"] = "60,117,256,512",
		["zebnowa"] = "466,237,512,431",
	},
	["hellfire"] =
	{
		["denofhaalesh"] = "182,412,256,256",
		["expeditionarmory"] = "261,413,512,255",
		["falconwatch"] = "183,326,512,342",
		["fallenskyridge"] = "34,142,256,256",
		["forgecamprage"] = "478,25,512,512",
		["hellfirecitadel"] = "338,210,256,458",
		["honorhold"] = "469,298,256,256",
		["magharpost"] = "206,110,256,256",
		["poolsofaggonar"] = "326,45,256,512",
		["ruinsofshanaar"] = "25,290,256,378",
		["templeoftelhamat"] = "38,152,512,512",
		["thelegionfront"] = "579,128,256,512",
		["thestairofdestiny"] = "737,156,256,512",
		["thrallmar"] = "467,154,256,256",
		["throneofkiljaeden"] = "477,6,512,256",
		["voidridge"] = "705,368,256,256",
		["warpfields"] = "308,408,256,260",
		["zethgor"] = "580,430,422,238",
	},
	["nagrand"] =
	{
		["burningbladeruins"] = "660,334,256,334",
		["clanwatch"] = "532,363,256,256",
		["forgecampfear"] = "36,248,512,420",
		["forgecamphate"] = "162,154,256,256",
		["garadar"] = "431,143,256,256",
		["halaa"] = "335,193,256,256",
		["kilsorrowfortress"] = "558,427,256,241",
		["laughingskullruins"] = "351,52,256,256",
		["oshugun"] = "168,334,512,334",
		["ringoftrials"] = "533,267,256,256",
		["southwindcleft"] = "391,258,256,256",
		["sunspringpost"] = "219,199,256,256",
		["telaar"] = "387,390,256,256",
		["throneoftheelements"] = "504,53,256,256",
		["twilightridge"] = "10,107,256,512",
		["warmaulhill"] = "157,32,256,256",
		["windyreedpass"] = "598,79,256,256",
		["windyreedvillage"] = "666,233,256,256",
		["zangarridge"] = "277,54,256,256",
	},
	["netherstorm"] =
	{
		["area52"] = "241,388,256,128",
		["arklonruins"] = "328,397,256,256",
		["celestialridge"] = "644,173,256,256",
		["ecodomefarfield"] = "396,10,256,256",
		["etheriumstaginggrounds"] = "481,208,256,256",
		["forgebaseog"] = "237,22,256,256",
		["kirinvarvillage"] = "490,523,256,145",
		["manaforgebanar"] = "147,281,256,387",
		["manaforgecoruu"] = "357,489,256,179",
		["manaforgeduro"] = "465,336,256,256",
		["manafrogeara"] = "171,155,256,256",
		["netherstone"] = "411,20,256,256",
		["netherstormbridge"] = "132,294,256,256",
		["ruinedmanaforge"] = "513,138,256,256",
		["ruinsofenkaat"] = "253,301,256,256",
		["ruinsoffarahlon"] = "354,49,512,256",
		["socretharsseat"] = "229,38,256,256",
		["sunfuryhold"] = "454,451,256,217",
		["tempestkeep"] = "593,284,409,384",
		["theheap"] = "239,455,256,213",
		["thescrapfield"] = "356,261,256,256",
		["thestormspire"] = "298,134,256,256",
	},
	["shadowmoonvalley"] =
	{
		["altarofshatar"] = "520,93,256,256",
		["coilskarpoint"] = "348,8,512,512",
		["eclipsepoint"] = "343,310,512,358",
		["illadarpoint"] = "143,256,256,256",
		["legionhold"] = "104,155,512,512",
		["netherwingcliffs"] = "554,308,256,256",
		["netherwingledge"] = "510,445,492,223",
		["shadowmoonvilliage"] = "116,35,512,512",
		["theblacktemple"] = "606,126,396,512",
		["thedeathforge"] = "290,129,256,512",
		["thehandofguldan"] = "394,90,512,512",
		["thewardenscage"] = "469,258,512,410",
		["wildhammerstronghold"] = "168,229,512,439",
	},
	["terokkarforest"] =
	{
		["allerianstronghold"] = "480,277,256,256",
		["auchenaigrounds"] = "247,434,256,234",
		["bleedinghollowclanruins"] = "103,301,256,367",
		["bonechewerruins"] = "521,275,256,256",
		["carrionhill"] = "377,272,256,256",
		["cenarionthicket"] = "314,0,256,256",
		["firewingpoint"] = "617,149,385,512",
		["grangolvarvilliage"] = "143,171,512,256",
		["raastokglade"] = "505,154,256,256",
		["razorthornshelf"] = "478,19,256,256",
		["refugecaravan"] = "316,268,128,256",
		["ringofobservance"] = "310,345,256,256",
		["sethekktomb"] = "245,289,256,256",
		["shattrathcity"] = "104,4,512,512",
		["skethylmountains"] = "449,348,512,320",
		["smolderingcaravan"] = "321,460,256,208",
		["stonebreakerhold"] = "397,165,256,256",
		["thebarrierhills"] = "116,4,256,256",
		["tuurem"] = "455,34,256,512",
		["veilrhaze"] = "222,362,256,256",
		["writhingmound"] = "417,327,256,256",
	},
	["zangarmarsh"] =
	{
		["angoroshgrounds"] = "88,50,256,256",
		["angoroshstronghold"] = "124,0,256,128",
		["bloodscaleenclave"] = "596,412,256,256",
		["cenarionrefuge"] = "694,321,308,256",
		["coilfangreservoir"] = "462,90,256,512",
		["feralfenvillage"] = "314,332,512,336",
		["marshlightlake"] = "81,152,256,256",
		["oreborharborage"] = "329,25,256,512",
		["quaggridge"] = "141,325,256,343",
		["sporeggar"] = "20,202,512,256",
		["telredor"] = "569,112,256,512",
		["thedeadmire"] = "716,128,286,512",
		["thehewnbog"] = "219,51,256,512",
		["thelagoon"] = "512,303,256,256",
		["thespawningglen"] = "31,339,256,256",
		["twinspireruins"] = "342,249,256,256",
		["umbrafenvillage"] = "720,461,256,207",
		["zabrajin"] = "175,232,256,256",
	},

	-- Manually added for patch 2.4
	["sunwell"] =
	{
		["sunsreachharbor"] = "252,252,512,416",
		["sunsreachsanctum"] = "251,4,512,512",
	},

	-- WotLK

	["scarletenclave"] =
	{
		["scarletenclave"] = "0,0,1024,768",	-- FIX!!
	},
	["lakewintergrasp"] = {
		["lakewintergrasp"] = "0,0,1024,768",
	},
	["dalaran"] = {
		["dalaran1_"] = "0,0,1024,768",		-- FIX!!
	},

	["boreantundra"] = {
		["deathsstand"] = "707,181,289,279",
		["templecityofenkilah"] = "712,15,290,292",
		["warsongstronghold"] = "329,237,260,278",
		["riplashstrand"] = "293,383,382,258",
		["thedensofdying"] = "662,11,203,209",
		["thegeyserfields"] = "480,0,375,342",
		["torpsfarm"] = "272,237,186,276",
		["valiancekeep"] = "457,264,259,302",
		["garroshslanding"] = "153,238,267,378",
		["borgorokoutpost"] = "314,0,396,203",
		["amberledge"] = "325,140,244,214",
		["kaskala"] = "509,214,385,316",
		["steeljawscaravan"] = "397,66,244,319",
		["coldarra"] = "50,0,460,381",
	},
	["sholazarbasin"] = {
		["kartakshold"] = "76,375,329,293",
		["theavalanche"] = "596,92,322,265",
		["thesavagethicket"] = "396,51,293,229",
		["thesuntouchedpillar"] = "82,186,455,316",
		["themakersperch"] = "172,135,249,248",
		["themakersoverlook"] = "705,236,233,286",
		["rainspeakercanopy"] = "427,244,207,235",
		["themosslightpillar"] = "265,355,239,313",
		["theglimmeringpillar"] = "308,34,294,327",
		["thelifebloodpillar"] = "501,134,312,369",
		["thestormwrightsshelf"] = "138,58,268,288",
		["riversheart"] = "359,339,468,329",
	},
	["dragonblight"] = {
		["lightsrest"] = "703,7,299,278",
		["galakrondsrest"] = "433,118,258,225",
		["newhearthglen"] = "614,358,214,261",
		["rubydragonshrine"] = "374,208,188,211",
		["icemistvillage"] = "134,165,235,337",
		["venomspite"] = "661,264,226,212",
		["westwindrefugeecamp"] = "42,187,229,299",
		["obsidiandragonshrine"] = "256,104,304,203",
		["naxxramas"] = "691,160,311,272",
		["wyrmresttemple"] = "453,219,317,353",
		["scarletpoint"] = "569,7,235,354",
		["emeralddragonshrine"] = "543,362,196,218",
		["agmarshammer"] = "258,203,236,218",
		["theforgottenshore"] = "698,332,301,286",
		["thecrystalvice"] = "487,0,229,259",
		["angrathar"] = "210,0,306,242",
		["lakeindule"] = "217,313,356,300",
		["coldwindheights"] = "403,0,213,219",
	},
	["crystalsongforest"] = {
		["windrunnersoverlook"] = "444,383,558,285",
		["theunboundthicket"] = "500,105,502,477",
		["theazurefront"] = "0,244,416,424",
		["forlornwoods"] = "129,0,544,668",
		["violetstand"] = "0,176,264,303",
		["thegreattree"] = "0,91,252,260",
		["thedecrepitflow"] = "0,0,288,222",
		["sunreaverscommand"] = "536,40,446,369",
	},
	["howlingfjord"] = {
		["scalawagpoint"] = "168,410,350,258",
		["baleheim"] = "576,170,174,173",
		["giantsrun"] = "572,0,298,306",
		["halgrind"] = "397,208,187,263",
		["utgardekeep"] = "477,216,248,382",
		["vengeancelanding"] = "664,25,223,338",
		["nifflevar"] = "595,240,178,208",
		["emberclutch"] = "283,203,213,256",
		["ivaldsruin"] = "668,223,193,201",
		["cauldrosisle"] = "490,161,181,178",
		["fortwildervar"] = "490,0,251,192",
		["thetwistedglade"] = "420,57,266,210",
		["newagamand"] = "415,360,284,308",
		["baelgunsexcavationsite"] = "621,327,244,305",
		["apothecarycamp"] = "99,37,263,265",
		["ancientlift"] = "342,351,177,191",
		["kamagua"] = "99,278,333,265",
		["gjalerbron"] = "225,0,242,189",
		["explorersleagueoutpost"] = "585,336,232,216",
		["westguardkeep"] = "90,180,347,220",
		["skorn"] = "343,108,238,232",
		["campwinterhoof"] = "354,0,223,209",
		["steelgate"] = "222,100,222,168",
	},
	["zuldrak"] = {
		["zeramas"] = "7,412,307,256",
		["draksotrafields"] = "326,358,286,265",
		["altarofrhunok"] = "431,127,247,304",
		["altarofsseratus"] = "288,168,237,248",
		["kolramas"] = "380,437,302,231",
		["gundrak"] = "629,0,336,297",
		["altarofquetzlun"] = "607,251,261,288",
		["altarofharkoa"] = "533,345,265,257",
		["lightsbreach"] = "181,363,321,305",
		["thrymsend"] = "0,247,272,268",
		["amphitheaterofanguish"] = "289,287,266,254",
		["voltarus"] = "174,191,218,291",
		["altarofmamtoth"] = "575,88,291,258",
		["zimtorga"] = "479,241,249,258",
	},
	["grizzlyhills"] = {
		["grizzlemaw"] = "358,187,294,227",
		["voldrune"] = "176,421,283,247",
		["conquesthold"] = "17,307,332,294",
		["dunargol"] = "547,257,455,400",
		["ragefangshrine"] = "312,294,475,362",
		["drakiljinruins"] = "607,41,351,284",
		["venturebay"] = "18,461,274,207",
		["thormodan"] = "509,0,329,246",
		["granitesprings"] = "7,207,356,224",
		["blueskylogginggrounds"] = "232,129,249,235",
		["draktheronkeep"] = "0,46,382,285",
		["amberpinelodge"] = "217,244,278,290",
		["ursocsden"] = "331,32,328,260",
		["camponeqwah"] = "548,137,324,265",
	},
	["thestormpeaks"] = {
		["frosthold"] = "134,429,244,220",
		["templeofstorms"] = "239,301,169,164",
		["ulduar"] = "218,0,369,265",
		["sparksocketminefield"] = "242,468,251,200",
		["borsbreath"] = "109,375,322,195",
		["engineofthemakers"] = "316,296,210,179",
		["garmsbane"] = "395,470,184,191",
		["dunniffelem"] = "481,285,309,383",
		["narvirscradle"] = "214,144,180,239",
		["nidavelir"] = "108,206,221,200",
		["brunnhildarvillage"] = "339,370,305,298",
		["snowdriftplains"] = "162,143,205,232",
		["valkyrion"] = "98,318,228,158",
		["templeoflife"] = "570,113,182,270",
		["terraceofthemakers"] = "292,122,363,341",
		["thunderfall"] = "627,179,306,484",
	},
	["icecrownglacier"] = {
		["aldurthar"] = "355,37,373,375",
		["corprethar"] = "342,392,308,212",
		["thebombardment"] = "538,181,248,243",
		["onslaughtharbor"] = "0,167,204,268",
		["sindragosasfall"] = "626,31,300,343",
		["thefleshwerks"] = "218,291,219,283",
		["jotunheim"] = "22,122,393,474",
		["valleyofechoes"] = "715,390,269,217",
		["theconflagration"] = "327,305,227,210",
		["thebrokenfront"] = "558,329,283,231",
		["scourgeholme"] = "690,267,245,239",
		["ymirheim"] = "444,276,223,207",
		["theshadowvault"] = "321,15,223,399",
		["argenttournamentground"] = "616,30,314,224",
		["icecrowncitadel"] = "392,466,308,202",
		["valhalas"] = "217,50,238,240",
	},

	-- Patch 3.2
	["hrothgarslanding"] =
	{
--		["hrothgarslanding"] = "0,0,1024,768",
		["hrothgarslanding2"] = "256,0,256,256,1",	-- Just draw 4 parts
		["hrothgarslanding3"] = "512,0,256,256,1",
		["hrothgarslanding6"] = "256,256,256,256,1",
		["hrothgarslanding7"] = "512,256,256,256,1",
	},

	-- Cataclysm
	["tolbarad"] = {
		["tolbarad"] = "0,0,1024,768",			-- Manual
	},
	["tolbaraddailyarea"] = {
		["tolbaraddailyarea"] = "0,0,1024,768",		-- Manual
	},

	["themaelstrom"] = {
		["themaelstrom"] = "0,0,1024,768",		-- Manual
	},
	["thelostisles_terrain2"] = {
		["gallywixdocks"] = "351,21,173,180",
		["alliancebeachhead"] = "129,348,177,172",
		["bilgewaterlumberyard"] = "462,43,248,209",
		["thesavageglen"] = "213,325,231,216",
		["oostan"] = "492,161,210,258",
		["raptorrise"] = "416,368,168,205",
		["warchiefslookout"] = "264,144,159,230",
		["ooomlotvillage"] = "508,345,221,211",
		["scorchedgully"] = "323,185,305,288",
		["ktcoilplatform"] = "433,11,156,142",
		["hordebasecamp"] = "244,458,222,190",
		["lostpeak"] = "581,21,350,517",
		["shipwreckshore"] = "189,408,172,175",
		["skyfalls"] = "416,131,190,186",
		["ruinsofvashelan"] = "440,452,212,216",
		["landingsite"] = "377,359,142,133",
		["theslavepits"] = "279,68,212,193",
	},
	["kezan"] = {
		["bilgewaterport"] = "163,148,694,290",
		["firstbankofkezan"] = "98,325,376,343",
		["swindlestreet"] = "317,232,168,213",
		["theslick"] = "219,108,592,202",
		["kajamine"] = "586,308,354,360",
		["kajarofield"] = "383,260,250,307",
		["gallywixsvilla"] = "0,41,303,452",
		["kezanmap"] = "0,4,1002,664",
		["drudgetown"] = "180,367,351,301",
	},
	["deepholm"] = {
		["stonehearth"] = "0,314,371,354",
		["twilightterrace"] = "297,384,237,198",
		["scouredreach"] = "448,0,516,287",
		["needlerockchasm"] = "20,0,378,359",
		["stormsfurywreckage"] = "458,383,292,285",
		["twilightoverlook"] = "570,420,411,248",
		["deathwingsfall"] = "549,297,454,343",
		["thepaleroost"] = "85,0,467,273",
		["needlerockslag"] = "0,146,370,285",
		["theshatteredfield"] = "141,438,430,230",
		["therazanesthrone"] = "434,0,274,156",
		["crimsonexpanse"] = "540,12,462,400",
		["templeofearth"] = "287,177,355,345",
	},

	["moltenfront"] = {
		["moltenfront"] = "0,0,1024,768",		-- Manual
	},
	-- Pandaria
	["thejadeforest"] = {
		["chuntianmonastery"] = "300,56,227,198",
		["dawnsblossom"] = "325,178,234,210",
		["dreamerspavillion"] = "474,520,218,148",
		["emperorsomen"] = "430,21,202,204",
		["glassfinvillage"] = "525,358,278,310",
		["grookinmound"] = "182,214,253,229",
		["hellscreamshope"] = "181,75,196,166",
		["jademines"] = "400,146,236,142",
		["nectarbreezeorchard"] = "290,330,219,256",
		["nookanooka"] = "189,151,219,205",
		["ruinsofganshi"] = "316,0,196,158",
		["serpentsspine"] = "388,299,191,216",
		["slingtailpits"] = "428,416,179,180",
		["templeofthejadeserpent"] = "468,295,264,211",
		["thearboretum"] = "481,215,242,210",
		["waywardlanding"] = "346,482,219,186",
		["windlessisle"] = "539,43,251,348",
		["wreckoftheskyshark"] = "202,0,210,158",
	},
	["dreadwastes"] = {
		["klaxxivess"] = "458,110,236,204",
		["zanvess"] = "162,385,290,283",
		["brewgarden"] = "351,0,250,218",
		["dreadwaterlake"] = "437,313,322,211",
		["clutchesofshekzeer"] = "341,125,209,318",
		["horridmarch"] = "441,224,323,194",
		["brinymuck"] = "214,311,325,270",
		["soggysgamble"] = "450,406,268,241",
		["terraceofgurthan"] = "593,92,209,234",
		["rikkitunvillage"] = "236,32,218,186",
		["heartoffear"] = "191,122,262,293",
		["kyparivor"] = "485,0,325,190",
	},
	["krasarang"] = {
		["redwingrefuge"] = "317,63,212,265",
		["anglersoutpost"] = "545,205,265,194",
		["templeoftheredcrane"] = "300,215,219,259",
		["dojaniriver"] = "513,3,190,282",
		["krasarangcove"] = "701,19,286,268",
		["thedeepwild"] = "397,59,188,412",
		["lostdynasty"] = "589,27,217,279",
		["fallsongriver"] = "218,77,214,393",
		["thesouthernisles"] = "23,267,252,313",
		["zhusbastion"] = "612,0,306,204",
		["ruinsofdojan"] = "444,44,204,383",
		["theforbiddenjungle"] = "0,79,257,300",
		["ruinsofkorja"] = "125,88,211,395",
		["cradleofchiji"] = "176,376,272,250",
		["ungaingoo"] = "330,498,258,170",
		["nayelilagoon"] = "343,373,246,240",
	},
	["krasarang_terrain1"] = {
		["redwingrefuge"] = "317,63,212,265",
		["anglersoutpost"] = "545,205,265,194",
		["templeoftheredcrane"] = "300,215,219,259",
		["dojaniriver"] = "513,3,190,282",
		["krasarangcove"] = "701,19,295,293",
		["thedeepwild"] = "397,59,188,412",
		["lostdynasty"] = "589,27,217,279",
		["fallsongriver"] = "218,77,214,393",
		["thesouthernisles"] = "0,267,275,329",
		["zhusbastion"] = "612,0,306,204",
		["ruinsofdojan"] = "444,44,204,383",
		["theforbiddenjungle"] = "0,79,257,300",
		["ruinsofkorja"] = "125,88,211,395",
		["cradleofchiji"] = "176,376,272,250",
		["ungaingoo"] = "330,498,258,170",
		["nayelilagoon"] = "343,373,246,240",
	},
	["kunlaisummit"] = {
		["binanvillage"] = "607,470,240,198",
		["mogujia"] = "462,411,253,208",
		["muskpawranch"] = "603,313,229,262",
		["mountneverset"] = "228,264,313,208",
		["zouchinvillage"] = "502,64,298,219",
		["templeofthewhitetiger"] = "587,170,250,260",
		["gateoftheaugust"] = "449,506,261,162",
		["shadopanmonastery"] = "88,92,385,385",
		["theburlaptrail"] = "398,310,310,276",
		["peakofserenity"] = "333,63,287,277",
		["valleyofemperors"] = "453,191,224,241",
		["kotapeak"] = "233,360,252,257",
		["iseoflostsouls"] = "602,4,259,233",
		["fireboughnook"] = "322,496,224,172",
	},
	["valeofeternalblossoms"] = {
		["guolairuins"] = "87,3,337,349",
		["whitemoonshrine"] = "482,10,298,262",
		["mistfallvillage"] = "200,363,310,305",
		["settingsuntraining"] = "0,234,350,429",
		["tushenburialground"] = "349,316,267,308",
		["thestairsascent"] = "556,267,446,359",
		["winterboughglade"] = "4,107,361,333",
		["thegoldenstair"] = "328,16,242,254",
		["whitepetallake"] = "278,170,267,281",
		["thetwinmonoliths"] = "444,97,272,522",
		["mogushanpalace"] = "629,22,373,385",
	},
	["valleyofthefourwinds"] = {
		["thunderfootfields"] = "622,0,380,317",
		["poolsofpurity"] = "513,58,213,246",
		["rumblingterrace"] = "582,301,277,245",
		["paoquanhollow"] = "12,105,273,246",
		["stormsoutbrewery"] = "227,380,257,288",
		["dustbackgorge"] = "0,343,209,308",
		["cliffsofdispair"] = "215,404,510,264",
		["theheartland"] = "253,75,286,392",
		["silkenfields"] = "530,253,254,259",
		["harvesthome"] = "5,239,260,251",
		["gildedfan"] = "438,41,208,292",
		["grandgranery"] = "334,325,314,212",
		["singingmarshes"] = "170,130,175,291",
		["zhusdecent"] = "699,114,303,323",
		["halfhill"] = "438,177,206,245",
		["nesingwarysafari"] = "104,326,249,342",
		["mudmugsplace"] = "561,161,230,217",
		["kuzenvillage"] = "224,74,199,304",
	},
	["townlongwastes"] = {
		["niuzaotemple"] = "213,241,296,359",
		["shanzedao"] = "125,0,300,246",
		["thesumprushes"] = "545,369,271,205",
		["sikvess"] = "306,433,261,235",
		["gaoranblockade"] = "546,468,353,200",
		["mingchicrossroads"] = "417,447,247,221",
		["palewindvillage"] = "692,362,282,306",
		["osulmesa"] = "560,185,238,296",
		["shadopangarrison"] = "413,385,213,170",
		["krivess"] = "420,209,255,269",
		["srivess"] = "92,192,294,283",
	},
	["thewanderingisle"] = {
		["thedawningvalley"] = "325,0,677,667",
		["templeoffivedawns"] = "395,182,607,461",
		["mandorivillage"] = "392,294,610,374",
		["ridgeoflaughingwinds"] = "183,198,313,321",
		["pei-wuforest"] = "351,406,651,262",
		["poolofthepaw"] = "297,324,220,188",
		["skyfirecrash-site"] = "124,405,346,263",
		["therows"] = "504,295,385,373",
		["thesingingpools"] = "545,12,372,475",
		["morningbreezevillage"] = "203,36,261,315",
		["fe-fangvillage"] = "134,9,234,286",
		["thewoodofstaves"] = "13,202,989,466",
	},
	["darkmoonfaireisland"] = {
		["darkmoonfaireisland"] = "0,0,1024,768",
	},
	["thehiddenpass"] = {
		["thehiddencliffs"] = "443,0,294,220",
		["theblackmarket"] = "371,175,479,493",
		["thehiddensteps"] = "412,477,290,191",
	},

	["isleofgiants"] = {
		["isleofgiants"] = "0,0,1024,768",		-- Manual
	},
	["timelessisle"] = {
		["timelessisle"] = "0,0,1024,768",
	},
	["isleofthethunderking"] = {
		["isleofthethunderking"] = "0,0,1024,768",	-- Manual
		["dynamic"] = "0,0,0,0",
	},

	-- Draenor

	["ashranhordefactionhub"] = {		-- 1011
		["ashranhordefactionhub"] = "0,0,1024,768",
	},
	["ashranalliancefactionhub"] = {	-- 1009
		["ashranalliancefactionhub"] = "0,0,1024,768",
	},
	["ashran"] = {				-- 978
		["ashran"] = "0,0,1024,768",
	},
	["frostfireridge"] = {			-- 941
		["bladespirefortress"] = "38,117,356,303",
		["bloodmaulstronghold"] = "311,4,258,217",
		["bonesofagurak"] = "729,319,273,349",
		["daggermawravine"] = "284,91,255,191",
		["frostwinddunes"] = "121,0,274,214",
		["grimfrosthill"] = "597,210,178,203",
		["grombolash"] = "483,33,217,239",
		["gromgar"] = "505,323,282,341",
		["hordegarrison"] = "336,327,267,257",
		["ironsiegeworks"] = "673,156,329,294",
		["ironwaystation"] = "641,304,199,335",
		["magnarok"] = "609,33,213,278",
		["nogarrison"] = "336,327,267,257",
		["stonefangoutpost"] = "306,281,251,191",
		["theboneslag"] = "290,192,256,210",
		["thecracklingplains"] = "439,137,266,293",
		["worgol"] = "72,292,317,233",
	},
	["garrisonffhorde_tier1"] = {		-- 976
		["garrisonffhorde_tier1"] = "0,0,1024,768",
	},
	["garrisonsmvalliance_tier1"] = {	-- 971
		["garrisonsmvalliance_tier1"] = "0,0,1024,768",
	},
	["gorgrond"] = {			-- 949
		["bastionrise"] = "283,507,324,161",
		["beastwatch"] = "383,371,166,161",
		["easternruin"] = "525,260,210,193",
		["evermorn"] = "281,444,297,181",
		["foundry"] = "455,74,211,221",
		["foundrysouth"] = "454,183,217,180",
		["gronncanyon"] = "258,213,279,241",
		["highlandpass"] = "547,73,285,323",
		["highpass"] = "411,250,209,225",
		["irondocks"] = "350,0,315,180",
		["mushrooms"] = "444,323,253,198",
		["stonemaularena"] = "259,335,217,178",
		["stonemaulsouth"] = "275,416,208,142",
		["stripmine"] = "312,77,250,232",
		["tangleheart"] = "451,372,262,221",
	},
	["nagranddraenor"] = {			-- 950
		["ancestral"] = "239,259,234,191",
		["brokenprecipice"] = "256,12,305,227",
		["elementals"] = "588,0,286,274",
		["grommashar"] = "600,367,256,301",
		["hallvalor"] = "766,118,236,372",
		["highmaul"] = "0,0,471,437",
		["ironfistharbor"] = "283,354,236,242",
		["lokrath"] = "382,187,316,221",
		["margoks"] = "753,380,249,288",
		["mushrooms"] = "746,25,250,287",
		["oshugun"] = "366,323,262,266",
		["ringofblood"] = "430,0,263,287",
		["ringoftrials"] = "523,159,354,315",
		["sunspringwatch"] = "312,98,274,254",
		["telaar"] = "461,353,296,272",
	},
	["spiresofarak"] = {			-- 948
		["bloodbladeredoubt"] = "334,210,209,154",
		["bloodmanevalley"] = "410,350,229,246",
		["centerravennest"] = "444,255,188,190",
		["clutchpop"] = "533,382,217,224",
		["eastmushrooms"] = "649,155,182,244",
		["emptygarrison"] = "282,261,190,187",
		["howlingcrag"] = "459,0,382,274",
		["nwcorner"] = "102,0,314,304",
		["sethekkhollow"] = "520,127,238,295",
		["skettis"] = "289,0,371,174",
		["solospirenorth"] = "429,84,196,284",
		["solospiresouth"] = "374,276,169,178",
		["southport"] = "310,328,197,179",
		["veilakraz"] = "281,83,252,230",
		["veilzekk"] = "521,268,198,232",
		["venturecove"] = "465,475,226,193",
		["writhingmire"] = "197,198,229,213",
	},
	["shadowmoonvalleydr"] = {		-- 947
		["anguishfortress"] = "140,160,309,264",
		["darktideroost"] = "468,467,282,201",
		["elodor"] = "426,0,291,266",
		["embaari"] = "270,158,346,252",
		["garrison"] = "194,0,223,279",
		["gloomshade"] = "319,5,229,240",
		["gulvar"] = "26,0,260,309",
		["karabor"] = "537,150,393,318",
		["nogarrison"] = "194,0,223,279",
		["shazgul"] = "259,315,282,225",
		["shimmeringmoor"] = "453,306,288,261",
		["socrethar"] = "383,411,202,201",
		["swisland"] = "309,460,173,160",
	},
	["talador"] = {				-- 946
		["aruuna"] = "597,178,389,234",
		["auchindoun"] = "338,356,309,262",
		["centerisles"] = "546,228,252,280",
		["courtofsouls"] = "150,264,307,229",
		["fortwrynn"] = "567,42,292,235",
		["gordalfortress"] = "548,378,423,290",
		["gulrok"] = "165,364,278,270",
		["northgate"] = "571,0,398,149",
		["orunaicoast"] = "427,0,279,267",
		["seentrance"] = "685,298,308,276",
		["shattrath"] = "173,22,406,367",
		["telmor"] = "207,511,497,157",
		["tomboflights"] = "352,271,326,212",
		["tuurem"] = "472,148,225,224",
		["zangarra"] = "713,35,287,277",
	},
	["TanaanJungle"] = {			-- 945
		["darkportal"] = "637,136,333,437",		
		["draeneisw"] = "81,367,174,208",
		["fangrila"] = "429,392,343,264",
		["felforge"] = "392,187,223,183",
		["ironfront"] = "0,264,209,245",	
		["ironharbor"] = "303,62,189,294",		
		["kiljaeden"] = "392,23,365,276",
		["kranak"] = "54,94,338,254",
		["lionswatch"] = "465,313,270,208",
		["marshlands"] = "296,383,246,218",
		["shanaar"] = "170,354,248,314",
		["volmar"] = "501,171,238,229",
		["zethgol"] = "118,194,274,251",
		["hellfirecitadel"] = "254,262,327,241",										
	},
	["tanaanjungleintro"] = {		-- 970
		["tanaanjungleintro"] = "0,0,1024,768",
	},
	["azsuna"] = {
		["faronaar"] = "166,202,330,265",
		["felblaze"] = "594,0,239,303",
		["greenway"] = "450,95,247,184",
		["isleofthewatchers"] = "281,401,321,267",
		["llothienhighlands"] = "219,69,351,245",
		["lostorchard"] = "257,0,315,185",
		["narthalas"] = "441,173,272,192",
		["oceanuscove"] = "396,244,206,266",
		["ruinedsanctum"] = "523,233,220,288",
		["templelights"] = "481,340,181,243",
		["zarkhenar"] = "477,0,288,195",
	},
    ["stormheim"] = {
		["aggrammarsvault"] = "361,210,199,185",
		["blackbeakoverlook"] = "154,129,297,210",
		["dreadwake"] = "457,412,215,247",
		["dreyrgrot"] = "689,266,132,145",
		["greywatch"] = "648,339,173,163",
		["hallsofvalor"] = "585,372,252,280",
		["haustvald"] = "612,187,200,174",
		["hrydshal"] = "0,353,631,315",
		["mawofnashal"] = "17,0,509,251",
		["morheim"] = "741,313,150,180",
		["nastrondir"] = "345,95,241,194",
		["qatchmansrock"] = "623,81,135,162",
		["runewood"] = "592,226,194,214",
		["shieldsrest"] = "689,0,289,172",
		["skoldashil"] = "506,345,177,169",
		["stormsreach"] = "510,118,180,160",
		["talonrest"] = "316,282,291,208",
		["tideskornharbor"] = "479,183,205,199",
		["valdisdall"] = "522,288,186,158",
		["weepingbluffs"] = "56,185,386,314",		
    },	
	["valsharah"] = {
		["andutalah"] = "587,250,241,240",
		["blackrookhold"] = "262,175,250,253",
		["bradensbrook"] = "259,275,311,244",
		["dreamgrove"] = "283,0,294,364",
		["gloamingreef"] = "136,274,239,301",
		["groveofcenarius"] = "457,351,171,150",
		["lorlathil"] = "467,413,177,156",
		["mistvale"] = "610,18,274,344",
		["moonclawvale"] = "549,380,254,281",
		["shalanir"] = "419,0,326,360",
		["smolderhide"] = "324,480,341,188",
		["templeofelune"] = "459,240,216,219",
		["thastalah"] = "342,416,218,168",		
	},
	["brokenshore"] = {
	    ["brokenvalley"] = "254,84,338,322",	
	    ["deadwoodlanding"] = "220,260,182,245",
	    ["deliverancepoint"] = "312,302,387,314",
	    ["felragestrand"] = "596,100,332,276",
	    ["soulruin"] = "389,180,338,270",	    
		["thelosttemple"] = "632,169,308,244",
	    ["theweepingterrace"] = "350,13,276,213",
	    ["tombofsargeras"] = "500,0,312,301",		
	},
	["highmountain"] = {
		["bloodhunthighlands"] = "307,75,297,250",
		["feltotem"] = "172,31,256,326",
		["frosthoofwatch"] = "391,408,186,213",
		["ironhornenclave"] = "452,410,288,258",
		["nightwatchersperch"] = "0,244,344,295",
		["pinerockbasin"] = "323,249,217,148",
		["riverbend"] = "314,360,214,308",
		["rockawayshallows"] = "469,45,207,302",
		["shipwreckcove"] = "331,0,283,170",
		["skyhorn"] = "357,179,311,229",
		["stonehoofwatch"] = "494,236,341,328",
		["sylvanfalls"] = "0,342,445,326",
		["thundertotem"] = "332,302,244,199",
		["trueshotlodge"] = "249,236,172,204",
		["cavea"] = "445,190,110,98",
	},	
	["suramar"] = {
		["ambervale"] = "132,179,222,311",
		["crimsonthicket"] = "492,0,327,381",
		["falanaar"] = "23,136,248,317",
		["felsoulhold"] = "183,305,289,363",
		["grandpromenade"] = "344,285,355,291",
		["jandvik"] = "583,0,419,538",
		["moonguardstronghold"] = "58,0,480,245",
		["moonwhispergulch"] = "201,0,428,316",
		["ruinsofeluneeth"] = "264,226,221,224",
		["suramarcity"] = "390,331,470,337",
		["telanor"] = "327,0,387,372",
	},
	["mardumtheshatteredabyss"] = {
		["mardumtheshatteredabyss"] = "0,0,1024,768",
	},	
	["argussurface"] = {
		["annihilanpits"] = "371,178,296,336",
		["krokulhovel"] = "428,364,307,304",
		["nathraxas"] = "167,0,835,422",
		["petrifiedforest"] = "557,289,445,379",
		["shatteredfields"] = "37,138,498,530",
	},
	["argusmacaree"] = {
		["conservatory"] = "498,111,313,353",
		["ruinsoforonaar"] = "278,284,265,310",
		["seatoftriumvirate"] = "265,54,463,519",
		["shadowguard"] = "0,0,498,461",
		["triumvirates"] = "410,375,284,264",
		["upperterrace"] = "0,0,701,323",
	},
	["arguscore"] = {
		["defiledpath"] = "293,0,626,385",
		["felfirearmory"] = "0,0,660,668",
		["terminus"] = "535,238,467,430",
	},	
}

--------
-- OLD From Textures\Minimap\md5translate.trs
-- From art.mpq World\Minimaps

Map.OLMapBlks = {		-- Expansion01

	[1334] = "",
	[1335] = "",
	[1429] = "",
	[1430] = "",
	[1431] = "",
	[1432] = "",
	[1433] = "",
	[1434] = "",
	[1435] = "",
	[1436] = "",
	[1437] = "",
	[1528] = "",
	[1529] = "",
	[1530] = "",
	[1531] = "",
	[1532] = "",
	[1533] = "",
	[1534] = "",
	[1535] = "",
	[1536] = "",
	[1537] = "",
	[1538] = "",
	[1628] = "",
	[1629] = "",
	[1630] = "",
	[1631] = "",
	[1632] = "",
	[1633] = "",
	[1634] = "",
	[1635] = "",
	[1636] = "",
	[1637] = "",
	[1638] = "",
	[1725] = "",
	[1726] = "",
	[1727] = "",
	[1728] = "",
	[1729] = "",
	[1730] = "",
	[1731] = "",
	[1732] = "",
	[1733] = "",
	[1734] = "",
	[1735] = "",
	[1736] = "",
	[1737] = "",
	[1738] = "",
	[1824] = "",
	[1825] = "",
	[1826] = "",
	[1827] = "",
	[1828] = "",
	[1829] = "",
	[1830] = "",
	[1831] = "",
	[1832] = "",
	[1833] = "",
	[1834] = "",
	[1835] = "",
	[1836] = "",
	[1837] = "",
	[1838] = "",
	[1924] = "",
	[1925] = "",
	[1926] = "",
	[1927] = "",
	[1928] = "",
	[1929] = "",
	[1930] = "",
	[1931] = "",
	[1932] = "",
	[1933] = "",
	[1934] = "",
	[1935] = "",
	[1936] = "",
	[1937] = "",
	[1938] = "",
	[1939] = "",
	[1940] = "",
	[2024] = "",
	[2025] = "",
	[2026] = "",
	[2027] = "",
	[2028] = "",
	[2029] = "",
	[2030] = "",
	[2031] = "",
	[2032] = "",
	[2033] = "",
	[2034] = "",
	[2035] = "",
	[2036] = "",
	[2037] = "",
	[2038] = "",
	[2039] = "",
	[2040] = "",
	[2123] = "",
	[2124] = "",
	[2125] = "",
	[2126] = "",
	[2127] = "",
	[2128] = "",
	[2129] = "",
	[2130] = "",
	[2131] = "",
	[2132] = "",
	[2133] = "",
	[2134] = "",
	[2135] = "",
	[2136] = "",
	[2137] = "",
	[2138] = "",
	[2139] = "",
	[2140] = "",
	[2223] = "",
	[2224] = "",
	[2225] = "",
	[2226] = "",
	[2227] = "",
	[2228] = "",
	[2229] = "",
	[2230] = "",
	[2231] = "",
	[2232] = "",
	[2233] = "",
	[2234] = "",
	[2235] = "",
	[2236] = "",
	[2237] = "",
	[2238] = "",
	[2239] = "",
	[2240] = "",
	[2323] = "",
	[2324] = "",
	[2325] = "",
	[2326] = "",
	[2327] = "",
	[2328] = "",
	[2329] = "",
	[2330] = "",
	[2331] = "",
	[2332] = "",
	[2333] = "",
	[2334] = "",
	[2335] = "",
	[2336] = "",
	[2337] = "",
	[2338] = "",
	[2339] = "",
	[2340] = "",
	[2422] = "",
	[2423] = "",
	[2424] = "",
	[2425] = "",
	[2426] = "",
	[2427] = "",
	[2430] = "",
	[2431] = "",
	[2432] = "",
	[2433] = "",
	[2434] = "",
	[2435] = "",
	[2436] = "",
	[2437] = "",
	[2438] = "",
	[2439] = "",
	[2440] = "",
	[2522] = "",
	[2523] = "",
	[2524] = "",
	[2525] = "",
	[2526] = "",
	[2527] = "",
	[2528] = "",
	[2530] = "",
	[2531] = "",
	[2532] = "",
	[2533] = "",
	[2534] = "",
	[2535] = "",
	[2536] = "",
	[2537] = "",
	[2538] = "",
	[2539] = "",
	[2540] = "",
	[2622] = "",
	[2623] = "",
	[2624] = "",
	[2625] = "",
	[2626] = "",
	[2627] = "",
	[2628] = "",
	[2629] = "",
	[2630] = "",
	[2631] = "",
	[2632] = "",
	[2633] = "",
	[2634] = "",
	[2635] = "",
	[2636] = "",
	[2637] = "",
	[2638] = "",
	[2639] = "",
	[2640] = "",
	[2722] = "",
	[2723] = "",
	[2724] = "",
	[2725] = "",
	[2726] = "",
	[2727] = "",
	[2728] = "",
	[2729] = "",
	[2730] = "",
	[2731] = "",
	[2732] = "",
	[2733] = "",
	[2734] = "",
	[2735] = "",
	[2736] = "",
	[2737] = "",
	[2738] = "",
	[2739] = "",
	[2740] = "",
	[2823] = "",
	[2824] = "",
	[2825] = "",
	[2826] = "",
	[2827] = "",
	[2828] = "",
	[2829] = "",
	[2830] = "",
	[2831] = "",
	[2832] = "",
	[2833] = "",
	[2834] = "",
	[2836] = "",
	[2837] = "",
	[2838] = "",
	[2839] = "",
	[2840] = "",
	[2841] = "",
	[2923] = "",
	[2924] = "",
	[2925] = "",
	[2926] = "",
	[2930] = "",
	[2931] = "",
	[2932] = "",
	[2933] = "",
	[2934] = "",
	[2936] = "",
	[2937] = "",
	[2938] = "",
	[2939] = "",
	[2940] = "",
	[2941] = "",
	[3026] = "",
	[3031] = "",
	[3032] = "",
	[3033] = "",
	[3034] = "",
	[3036] = "",
	[3037] = "",
	[3038] = "",
	[3039] = "",
	[3040] = "",
	[3041] = "",
	[3042] = "",
	[3132] = "",
	[3136] = "",
	[3137] = "",
	[3138] = "",
	[3139] = "",
	[3140] = "",
	[3141] = "",
	[3142] = "",
	[3237] = "",
	[3238] = "",
	[3239] = "",
	[3240] = "",
	[3241] = "",
	[3242] = "",
	[3337] = "",
	[3338] = "",
	[3339] = "",
}

Map.BloodelfMapBlks = {	-- Expansion01

--	[4010] = "",	-- Dark blue

	[4116] = "",
	[4117] = "",
	[4118] = "",

	[4211] = "",
	[4212] = "",
	[4213] = "",
	[4214] = "",
	[4215] = "",
	[4216] = "",
	[4217] = "",
	[4218] = "",
	[4219] = "",
	[4220] = "",
	[4221] = "",

	[4306] = "",
	[4307] = "",
	[4308] = "",
	[4309] = "",
	[4310] = "",
	[4311] = "",
	[4312] = "",
	[4313] = "",
	[4314] = "",
	[4315] = "",
	[4316] = "",
	[4317] = "",
	[4318] = "",
	[4319] = "",
	[4320] = "",
	[4321] = "",

	[4406] = "",
	[4407] = "",
	[4408] = "",
	[4409] = "",
	[4410] = "",
	[4411] = "",
	[4412] = "",
	[4413] = "",
	[4414] = "",
	[4415] = "",
	[4416] = "",
	[4417] = "",
	[4418] = "",
	[4419] = "",
	[4420] = "",
	[4421] = "",

	[4506] = "",
	[4507] = "",
	[4508] = "",
	[4509] = "",
	[4510] = "",
	[4511] = "",
	[4512] = "",
	[4513] = "",
	[4514] = "",
	[4515] = "",
	[4516] = "",
	[4517] = "",
	[4518] = "",
	[4519] = "",
	[4520] = "",
	[4521] = "",

	[4606] = "",
	[4607] = "",
	[4608] = "",
	[4609] = "",
	[4610] = "",
	[4611] = "",
	[4612] = "",
	[4613] = "",
	[4614] = "",
	[4615] = "",
	[4616] = "",
	[4617] = "",
	[4618] = "",
	[4619] = "",
	[4620] = "",
	[4621] = "",

	[4713] = "",
	[4714] = "",
	[4715] = "",
	[4716] = "",
	[4717] = "",
	[4718] = "",
	[4719] = "",
	[4720] = "",
}

Map.DraeneiMapBlks = {	-- Expansion01

	[5034] = "",
	[5035] = "",

	[5133] = "",
	[5134] = "",
	[5135] = "",
	[5136] = "",
	[5137] = "",
	[5140] = "",
	[5141] = "",
	[5142] = "",

	[5233] = "",
	[5234] = "",
	[5235] = "",
	[5236] = "",
	[5237] = "",
	[5238] = "",
	[5239] = "",
	[5240] = "",
	[5241] = "",
	[5242] = "",

	[5333] = "",
	[5334] = "",
	[5335] = "",
	[5336] = "",
	[5337] = "",
	[5338] = "",
	[5339] = "",
	[5340] = "",
	[5341] = "",
	[5342] = "",

	[5433] = "",
	[5434] = "",
	[5435] = "",
	[5436] = "",
	[5437] = "",
	[5438] = "",
	[5439] = "",
	[5440] = "",
	[5441] = "",

	[5533] = "",
	[5534] = "",
	[5535] = "",
	[5536] = "",
	[5537] = "",
	[5538] = "",
	[5539] = "",
	[5540] = "",
	[5541] = "",

	[5633] = "",
	[5634] = "",
	[5635] = "",
	[5636] = "",
	[5637] = "",
	[5638] = "",
	[5639] = "",
	[5640] = "",
	[5641] = "",

	[5737] = "",
	[5738] = "",
	[5739] = "",
	[5740] = "",
	[5741] = "",

	[5837] = "",
	[5838] = "",
	[5839] = "",
	[5840] = "",
	[5841] = "",

	[5938] = "",
	[5939] = "",
	[5940] = "",
}

Map.KalMapBlks = {	-- Kalimdor

	[2341] = "",
	[2342] = "",
	[2343] = "",
	[2344] = "",
	[2345] = "",

	[2439] = "",
	[2440] = "",
	[2441] = "",
	[2442] = "",
	[2443] = "",
	[2444] = "",
	[2445] = "",

	[2512] = "",
	[2513] = "",
	[2514] = "",
	[2515] = "",
	[2533] = "",
	[2534] = "",
	[2535] = "",
	[2536] = "",
	[2537] = "",
	[2538] = "",
	[2539] = "",
	[2540] = "",
	[2541] = "",
	[2542] = "",
	[2543] = "",
	[2544] = "",
	[2545] = "",
	[2546] = "",

	[2611] = "",
	[2612] = "",
	[2613] = "",
	[2614] = "",
	[2615] = "",
	[2616] = "",
	[2624] = "",
	[2625] = "",
	[2626] = "",
	[2627] = "",
	[2628] = "",
	[2629] = "",
	[2630] = "",
	[2631] = "",
	[2632] = "",
	[2633] = "",
	[2634] = "",
	[2635] = "",
	[2636] = "",
	[2637] = "",
	[2638] = "",
	[2639] = "",
	[2640] = "",
	[2641] = "",
	[2642] = "",
	[2643] = "",
	[2644] = "",
	[2645] = "",
	[2646] = "",
	[2647] = "",
	[2648] = "",
	[2649] = "",
	[2650] = "",
	[2651] = "",

	[2709] = "",
	[2710] = "",
	[2711] = "",
	[2712] = "",
	[2713] = "",
	[2714] = "",
	[2715] = "",
	[2716] = "",
	[2717] = "",
	[2718] = "",
	[2719] = "",
	[2720] = "",
	[2721] = "",
	[2722] = "",
	[2723] = "",
	[2724] = "",
	[2725] = "",
	[2726] = "",
	[2727] = "",
	[2728] = "",
	[2729] = "",
	[2730] = "",
	[2731] = "",
	[2732] = "",
	[2733] = "",
	[2734] = "",
	[2735] = "",
	[2736] = "",
	[2737] = "",
	[2738] = "",
	[2739] = "",
	[2740] = "",
	[2741] = "",
	[2742] = "",
	[2743] = "",
	[2744] = "",
	[2745] = "",
	[2746] = "",
	[2747] = "",
	[2748] = "",
	[2749] = "",
	[2750] = "",
	[2751] = "",
	[2752] = "",

	[2809] = "",
	[2810] = "",
	[2811] = "",
	[2812] = "",
	[2813] = "",
	[2814] = "",
	[2815] = "",
	[2816] = "",
	[2817] = "",
	[2818] = "",
	[2819] = "",
	[2820] = "",
	[2821] = "",
	[2822] = "",
	[2823] = "",
	[2824] = "",
	[2825] = "",
	[2826] = "",
	[2827] = "",
	[2828] = "",
	[2829] = "",
	[2830] = "",
	[2831] = "",
	[2832] = "",
	[2833] = "",
	[2834] = "",
	[2835] = "",
	[2836] = "",
	[2837] = "",
	[2838] = "",
	[2839] = "",
	[2840] = "",
	[2841] = "",
	[2842] = "",
	[2843] = "",
	[2844] = "",
	[2845] = "",
	[2846] = "",
	[2847] = "",
	[2848] = "",
	[2849] = "",
	[2850] = "",
	[2851] = "",
	[2852] = "",

	[2909] = "",
	[2910] = "",
	[2911] = "",
	[2912] = "",
	[2913] = "",
	[2914] = "",
	[2915] = "",
	[2916] = "",
	[2917] = "",
	[2918] = "",
	[2919] = "",
	[2920] = "",
	[2921] = "",
	[2922] = "",
	[2923] = "",
	[2924] = "",
	[2925] = "",
	[2926] = "",
	[2927] = "",
	[2928] = "",
	[2929] = "",
	[2930] = "",
	[2931] = "",
	[2932] = "",
	[2933] = "",
	[2934] = "",
	[2935] = "",
	[2936] = "",
	[2937] = "",
	[2938] = "",
	[2939] = "",
	[2940] = "",
	[2941] = "",
	[2942] = "",
	[2943] = "",
	[2944] = "",
	[2945] = "",
	[2946] = "",
	[2947] = "",
	[2948] = "",
	[2949] = "",
	[2950] = "",
	[2951] = "",
	[2952] = "",

	[3009] = "",
	[3010] = "",
	[3011] = "",
	[3012] = "",
	[3013] = "",
	[3014] = "",
	[3015] = "",
	[3016] = "",
	[3017] = "",
	[3018] = "",
	[3019] = "",
	[3020] = "",
	[3021] = "",
	[3022] = "",
	[3023] = "",
	[3024] = "",
	[3025] = "",
	[3026] = "",
	[3027] = "",
	[3028] = "",
	[3029] = "",
	[3030] = "",
	[3031] = "",
	[3032] = "",
	[3033] = "",
	[3034] = "",
	[3035] = "",
	[3036] = "",
	[3037] = "",
	[3038] = "",
	[3039] = "",
	[3040] = "",
	[3041] = "",
	[3042] = "",
	[3043] = "",
	[3044] = "",
	[3045] = "",
	[3046] = "",
	[3047] = "",
	[3048] = "",
	[3049] = "",
	[3050] = "",
	[3051] = "",
	[3052] = "",

	[3109] = "",
	[3110] = "",
	[3111] = "",
	[3112] = "",
	[3113] = "",
	[3114] = "",
	[3115] = "",
	[3116] = "",
	[3117] = "",
	[3118] = "",
	[3119] = "",
	[3120] = "",
	[3121] = "",
	[3122] = "",
	[3123] = "",
	[3124] = "",
	[3125] = "",
	[3126] = "",
	[3127] = "",
	[3128] = "",
	[3129] = "",
	[3130] = "",
	[3131] = "",
	[3132] = "",
	[3133] = "",
	[3134] = "",
	[3135] = "",
	[3136] = "",
	[3137] = "",
	[3138] = "",
	[3139] = "",
	[3140] = "",
	[3141] = "",
	[3142] = "",
	[3143] = "",
	[3144] = "",
	[3145] = "",
	[3146] = "",
	[3147] = "",
	[3148] = "",
	[3149] = "",
	[3150] = "",
	[3151] = "",
	[3152] = "",
	[3153] = "",

	[3210] = "",
	[3211] = "",
	[3212] = "",
	[3213] = "",
	[3214] = "",
	[3215] = "",
	[3216] = "",
	[3217] = "",
	[3218] = "",
	[3219] = "",
	[3220] = "",
	[3221] = "",
	[3222] = "",
	[3223] = "",
	[3224] = "",
	[3225] = "",
	[3226] = "",
	[3227] = "",
	[3228] = "",
	[3229] = "",
	[3230] = "",
	[3231] = "",
	[3232] = "",
	[3233] = "",
	[3234] = "",
	[3235] = "",
	[3236] = "",
	[3237] = "",
	[3238] = "",
	[3239] = "",
	[3240] = "",
	[3241] = "",
	[3242] = "",
	[3243] = "",
	[3244] = "",
	[3245] = "",
	[3246] = "",
	[3247] = "",
	[3248] = "",
	[3249] = "",
	[3250] = "",
	[3251] = "",
	[3252] = "",
	[3253] = "",

	[3311] = "",
	[3312] = "",
	[3313] = "",
	[3314] = "",
	[3315] = "",
	[3316] = "",
	[3317] = "",
	[3318] = "",
	[3319] = "",
	[3320] = "",
	[3321] = "",
	[3322] = "",
	[3323] = "",
	[3324] = "",
	[3325] = "",
	[3326] = "",
	[3327] = "",
	[3328] = "",
	[3329] = "",
	[3330] = "",
	[3331] = "",
	[3332] = "",
	[3333] = "",
	[3334] = "",
	[3335] = "",
	[3336] = "",
	[3337] = "",
	[3338] = "",
	[3339] = "",
	[3340] = "",
	[3341] = "",
	[3342] = "",
	[3343] = "",
	[3344] = "",
	[3345] = "",
	[3346] = "",
	[3347] = "",
	[3348] = "",
	[3349] = "",
	[3350] = "",
	[3351] = "",
	[3352] = "",
	[3353] = "",

	[3415] = "",
	[3416] = "",
	[3417] = "",
	[3418] = "",
	[3419] = "",
	[3420] = "",
	[3421] = "",
	[3422] = "",
	[3423] = "",
	[3424] = "",
	[3425] = "",
	[3426] = "",
	[3427] = "",
	[3428] = "",
	[3429] = "",
	[3430] = "",
	[3431] = "",
	[3432] = "",
	[3433] = "",
	[3434] = "",
	[3435] = "",
	[3436] = "",
	[3437] = "",
	[3438] = "",
	[3439] = "",
	[3440] = "",
	[3441] = "",
	[3442] = "",
	[3443] = "",
	[3444] = "",
	[3445] = "",
	[3446] = "",
	[3447] = "",
	[3448] = "",
	[3449] = "",
	[3450] = "",
	[3451] = "",
	[3452] = "",
	[3453] = "",

	[3515] = "",
	[3516] = "",
	[3517] = "",
	[3518] = "",
	[3519] = "",
	[3520] = "",
	[3521] = "",
	[3522] = "",
	[3523] = "",
	[3524] = "",
	[3525] = "",
	[3526] = "",
	[3527] = "",
	[3528] = "",
	[3529] = "",
	[3530] = "",
	[3531] = "",
	[3532] = "",
	[3533] = "",
	[3534] = "",
	[3535] = "",
	[3536] = "",
	[3537] = "",
	[3538] = "",
	[3539] = "",
	[3540] = "",
	[3541] = "",
	[3542] = "",
	[3543] = "",
	[3544] = "",
	[3545] = "",
	[3546] = "",
	[3547] = "",
	[3548] = "",
	[3549] = "",
	[3550] = "",
	[3551] = "",
	[3552] = "",
	[3553] = "",

	[3615] = "",
	[3616] = "",
	[3617] = "",
	[3618] = "",
	[3619] = "",
	[3620] = "",
	[3621] = "",
	[3622] = "",
	[3623] = "",
	[3624] = "",
	[3625] = "",
	[3626] = "",
	[3627] = "",
	[3628] = "",
	[3629] = "",
	[3630] = "",
	[3631] = "",
	[3632] = "",
	[3633] = "",
	[3634] = "",
	[3635] = "",
	[3636] = "",
	[3637] = "",
	[3638] = "",
	[3639] = "",
	[3640] = "",
	[3641] = "",
	[3642] = "",
	[3643] = "",
	[3644] = "",
	[3645] = "",
	[3646] = "",
	[3647] = "",
	[3648] = "",
	[3649] = "",
	[3650] = "",
	[3651] = "",
	[3652] = "",
	[3653] = "",

	[3714] = "",
	[3715] = "",
	[3716] = "",
	[3717] = "",
	[3718] = "",
	[3719] = "",
	[3720] = "",
	[3721] = "",
	[3722] = "",
	[3723] = "",
	[3724] = "",
	[3725] = "",
	[3726] = "",
	[3727] = "",
	[3728] = "",
	[3729] = "",
	[3730] = "",
	[3731] = "",
	[3732] = "",
	[3733] = "",
	[3734] = "",
	[3735] = "",
	[3736] = "",
	[3737] = "",
	[3738] = "",
	[3739] = "",
	[3740] = "",
	[3741] = "",
	[3742] = "",
	[3743] = "",
	[3744] = "",
	[3745] = "",
	[3746] = "",
	[3747] = "",
	[3748] = "",
	[3749] = "",
	[3750] = "",
	[3751] = "",
	[3752] = "",

	[3814] = "",
	[3815] = "",
	[3816] = "",
	[3817] = "",
	[3818] = "",
	[3819] = "",
	[3820] = "",
	[3821] = "",
	[3822] = "",
	[3823] = "",
	[3824] = "",
	[3825] = "",
	[3826] = "",
	[3827] = "",
	[3828] = "",
	[3829] = "",
	[3830] = "",
	[3831] = "",
	[3832] = "",
	[3833] = "",
	[3834] = "",
	[3835] = "",
	[3836] = "",
	[3837] = "",
	[3838] = "",
	[3839] = "",
	[3840] = "",
	[3841] = "",
	[3842] = "",
	[3843] = "",
	[3844] = "",
	[3845] = "",
	[3846] = "",
	[3847] = "",
	[3848] = "",
	[3849] = "",
	[3850] = "",
	[3851] = "",

	[3914] = "",
	[3915] = "",
	[3916] = "",
	[3917] = "",
	[3918] = "",
	[3919] = "",
	[3920] = "",
	[3921] = "",
	[3922] = "",
	[3923] = "",
	[3924] = "",
	[3925] = "",
	[3926] = "",
	[3927] = "",
	[3928] = "",
	[3929] = "",
	[3930] = "",
	[3931] = "",
	[3932] = "",
	[3933] = "",
	[3934] = "",
	[3935] = "",
	[3936] = "",
	[3937] = "",
	[3938] = "",
	[3939] = "",
	[3940] = "",
	[3941] = "",
	[3942] = "",
	[3943] = "",
	[3944] = "",
	[3945] = "",
	[3946] = "",
	[3947] = "",
	[3948] = "",
	[3949] = "",
	[3950] = "",
	[3951] = "",

	[4014] = "",
	[4015] = "",
	[4016] = "",
	[4017] = "",
	[4018] = "",
	[4019] = "",
	[4020] = "",
	[4021] = "",
	[4022] = "",
	[4023] = "",
	[4024] = "",
	[4025] = "",
	[4026] = "",
	[4027] = "",
	[4028] = "",
	[4029] = "",
	[4030] = "",
	[4031] = "",
	[4032] = "",
	[4033] = "",
	[4034] = "",
	[4035] = "",
	[4036] = "",
	[4037] = "",
	[4038] = "",
	[4039] = "",
	[4040] = "",
	[4041] = "",
	[4042] = "",
	[4043] = "",
	[4044] = "",
	[4045] = "",
	[4046] = "",
	[4047] = "",
	[4048] = "",
	[4049] = "",
	[4050] = "",
	[4051] = "",

	[4115] = "",
	[4116] = "",
	[4117] = "",
	[4118] = "",
	[4119] = "",
	[4120] = "",
	[4121] = "",
	[4122] = "",
	[4123] = "",
	[4124] = "",
	[4125] = "",
	[4126] = "",
	[4127] = "",
	[4128] = "",
	[4129] = "",
	[4130] = "",
	[4131] = "",
	[4132] = "",
	[4133] = "",
	[4134] = "",
	[4135] = "",
	[4136] = "",
	[4137] = "",
	[4138] = "",
	[4139] = "",
	[4140] = "",
	[4141] = "",
	[4142] = "",
	[4143] = "",
	[4144] = "",
	[4145] = "",
	[4146] = "",
	[4147] = "",
	[4148] = "",
	[4149] = "",
	[4150] = "",
	[4151] = "",

	[4216] = "",
	[4217] = "",
	[4218] = "",
	[4219] = "",
	[4220] = "",
	[4221] = "",
	[4222] = "",
	[4223] = "",
	[4224] = "",
	[4225] = "",
	[4226] = "",
	[4227] = "",
	[4228] = "",
	[4229] = "",
	[4230] = "",
	[4231] = "",
	[4232] = "",
	[4233] = "",
	[4234] = "",
	[4235] = "",
	[4236] = "",
	[4237] = "",
	[4238] = "",
	[4239] = "",
	[4240] = "",
	[4241] = "",
	[4242] = "",
	[4243] = "",
	[4244] = "",
	[4245] = "",
	[4246] = "",
	[4247] = "",
	[4248] = "",
	[4249] = "",
	[4250] = "",
	[4251] = "",

	[4316] = "",
	[4317] = "",
	[4318] = "",
	[4319] = "",
	[4320] = "",
	[4321] = "",
	[4322] = "",
	[4323] = "",
	[4324] = "",
	[4325] = "",
	[4326] = "",
	[4327] = "",
	[4328] = "",
	[4329] = "",
	[4330] = "",
	[4331] = "",
	[4332] = "",
	[4333] = "",
	[4334] = "",
	[4335] = "",
	[4344] = "",
	[4345] = "",
	[4346] = "",
	[4347] = "",
	[4348] = "",
	[4349] = "",

	[4421] = "",
	[4422] = "",
	[4423] = "",
	[4424] = "",
	[4425] = "",
	[4426] = "",
	[4427] = "",
	[4428] = "",
	[4429] = "",

	[4521] = "",
	[4522] = "",
	[4523] = "",
	[4524] = "",
	[4525] = "",
	[4526] = "",
	[4527] = "",
	[4528] = "",
	[4529] = "",

	[4621] = "",
	[4622] = "",
	[4623] = "",
	[4624] = "",
	[4625] = "",
	[4626] = "",
	[4627] = "",
	[4628] = "",
	[4629] = "",

	[4722] = "",
	[4723] = "",
	[4724] = "",
}

Map.EkMapBlks = {

	-- Use noLiquid maps
	[1741] = "1",
	[1742] = "1",
	[1743] = "1",
	[1744] = "1",
	[1745] = "1",
	[1746] = "1",
	[1841] = "1",
	[1842] = "1",
	[1843] = "1",
	[1844] = "1",
	[1845] = "1",
	[1846] = "1",
	[1941] = "1",
	[1942] = "1",
	[1943] = "1",
	[1944] = "1",
	[1945] = "1",
	[1946] = "1",
	[2039] = "1",
	[2040] = "1",
	[2041] = "1",
	[2042] = "1",
	[2043] = "1",
	[2044] = "1",
	[2045] = "1",
	[2046] = "1",
	[2139] = "1",
	[2140] = "1",
	[2141] = "1",
	[2142] = "1",
	[2143] = "1",
	[2144] = "1",
	[2145] = "1",
	[2146] = "1",
	[2239] = "1",
	[2240] = "1",
	[2241] = "1",
	[2242] = "1",
	[2243] = "1",
	[2244] = "1",
	[2245] = "1",
	[2246] = "1",
	[2339] = "1",
	[2340] = "1",
	[2341] = "1",
	[2342] = "1",
	[2343] = "1",
	[2344] = "1",
	[2345] = "1",
	[2346] = "1",
	[2439] = "1",
	[2440] = "1",
	[2441] = "1",
	[2442] = "1",
	[2443] = "1",
	[2444] = "1",
	[2445] = "1",
	[2446] = "1",
	[2539] = "1",
	[2540] = "1",
	[2541] = "1",
	[2542] = "1",
	[2543] = "1",
	[2544] = "1",
	[2545] = "1",
	[2546] = "1",
	[2639] = "1",
	[2640] = "1",
	[2641] = "1",
	[2642] = "1",
	[2643] = "1",
	[2644] = "1",
	[2645] = "1",

	[2627] = "",
	[2628] = "",
	[2629] = "",
	[2630] = "",
	[2631] = "",
	[2632] = "",
	[2633] = "",
	[2634] = "",
	[2635] = "",
	[2636] = "",
	[2637] = "",
	[2652] = "",
	[2653] = "",
	[2654] = "",

	[2726] = "",
	[2727] = "",
	[2728] = "",
	[2729] = "",
	[2730] = "",
	[2731] = "",
	[2732] = "",
	[2733] = "",
	[2734] = "",
	[2735] = "",
	[2736] = "",
	[2737] = "",
	[2749] = "",
	[2750] = "",
	[2751] = "",
	[2752] = "",
	[2753] = "",
	[2754] = "",

	[2825] = "",
	[2826] = "",
	[2827] = "",
	[2828] = "",
	[2829] = "",
	[2830] = "",
	[2831] = "",
	[2832] = "",
	[2833] = "",
	[2834] = "",
	[2835] = "",
	[2836] = "",
	[2837] = "",
	[2838] = "",
	[2839] = "",
	[2840] = "",
	[2841] = "",
	[2842] = "",
	[2843] = "",
	[2844] = "",
	[2845] = "",
	[2846] = "",
	[2847] = "",
	[2848] = "",
	[2849] = "",
	[2850] = "",
	[2851] = "",
	[2852] = "",
	[2853] = "",
	[2854] = "",
	[2855] = "",
	[2856] = "",
	[2857] = "",
	[2858] = "",
	[2859] = "",

	[2925] = "",
	[2926] = "",
	[2927] = "",
	[2928] = "",
	[2929] = "",
	[2930] = "",
	[2931] = "",
	[2932] = "",
	[2933] = "",
	[2934] = "",
	[2935] = "",
	[2936] = "",
	[2937] = "",
	[2938] = "",
	[2939] = "",
	[2940] = "",
	[2941] = "",
	[2942] = "",
	[2943] = "",
	[2944] = "",
	[2945] = "",
	[2946] = "",
	[2947] = "",
	[2948] = "",
	[2949] = "",
	[2950] = "",
	[2951] = "",
	[2952] = "",
	[2953] = "",
	[2954] = "",
	[2955] = "",
	[2956] = "",
	[2957] = "",
	[2958] = "",
	[2959] = "",
	[2960] = "",

	[3025] = "",
	[3026] = "",
	[3027] = "",
	[3028] = "",
	[3029] = "",
	[3030] = "",
	[3031] = "",
	[3032] = "",
	[3033] = "",
	[3034] = "",
	[3035] = "",
	[3036] = "",
	[3037] = "",
	[3038] = "",
	[3039] = "",
	[3040] = "",
	[3041] = "",
	[3042] = "",
	[3043] = "",
	[3044] = "",
	[3045] = "",
	[3046] = "",
	[3047] = "",
	[3048] = "",
	[3049] = "",
	[3050] = "",
	[3051] = "",
	[3052] = "",
	[3053] = "",
	[3054] = "",
	[3055] = "",
	[3056] = "",
	[3057] = "",
	[3058] = "",
	[3059] = "",
	[3060] = "",

	[3125] = "",
	[3126] = "",
	[3127] = "",
	[3128] = "",
	[3129] = "",
	[3130] = "",
	[3131] = "",
	[3132] = "",
	[3133] = "",
	[3134] = "",
	[3135] = "",
	[3136] = "",
	[3137] = "",
	[3138] = "",
	[3139] = "",
	[3140] = "",
	[3141] = "",
	[3142] = "",
	[3143] = "",
	[3144] = "",
	[3145] = "",
	[3146] = "",
	[3147] = "",
	[3148] = "",
	[3149] = "",
	[3150] = "",
	[3151] = "",
	[3152] = "",
	[3153] = "",
	[3154] = "",
	[3155] = "",
	[3156] = "",
	[3157] = "",
	[3158] = "",
	[3159] = "",
	[3160] = "",

	[3225] = "",
	[3226] = "",
	[3227] = "",
	[3228] = "",
	[3229] = "",
	[3230] = "",
	[3231] = "",
	[3232] = "",
	[3233] = "",
	[3234] = "",
	[3235] = "",
	[3236] = "",
	[3237] = "",
	[3238] = "",
	[3239] = "",
	[3240] = "",
	[3241] = "",
	[3242] = "",
	[3243] = "",
	[3244] = "",
	[3245] = "",
	[3246] = "",
	[3247] = "",
	[3248] = "",
	[3249] = "",
	[3250] = "",
	[3251] = "",
	[3252] = "",
	[3253] = "",
	[3254] = "",
	[3255] = "",
	[3256] = "",
	[3257] = "",
	[3258] = "",
	[3259] = "",
	[3260] = "",

	[3325] = "",
	[3326] = "",
	[3327] = "",
	[3328] = "",
	[3329] = "",
	[3330] = "",
	[3331] = "",
	[3332] = "",
	[3333] = "",
	[3334] = "",
	[3335] = "",
	[3336] = "",
	[3337] = "",
	[3338] = "",
	[3339] = "",
	[3340] = "",
	[3341] = "",
	[3342] = "",
	[3343] = "",
	[3344] = "",
	[3345] = "",
	[3346] = "",
	[3347] = "",
	[3348] = "",
	[3349] = "",
	[3350] = "",
	[3351] = "",
	[3352] = "",
	[3353] = "",
	[3354] = "",
	[3355] = "",
	[3356] = "",
	[3357] = "",
	[3358] = "",
	[3359] = "",
	[3360] = "",

	[3425] = "",
	[3426] = "",
	[3427] = "",
	[3428] = "",
	[3429] = "",
	[3430] = "",
	[3431] = "",
	[3432] = "",
	[3433] = "",
	[3434] = "",
	[3435] = "",
	[3436] = "",
	[3437] = "",
	[3438] = "",
	[3439] = "",
	[3440] = "",
	[3441] = "",
	[3442] = "",
	[3443] = "",
	[3444] = "",
	[3445] = "",
	[3446] = "",
	[3447] = "",
	[3448] = "",
	[3449] = "",
	[3450] = "",
	[3451] = "",
	[3452] = "",
	[3453] = "",
	[3454] = "",
	[3455] = "",
	[3456] = "",
	[3457] = "",
	[3458] = "",
	[3459] = "",
	[3460] = "",

	[3524] = "",
	[3525] = "",
	[3526] = "",
	[3527] = "",
	[3528] = "",
	[3529] = "",
	[3530] = "",
	[3531] = "",
	[3532] = "",
	[3533] = "",
	[3534] = "",
	[3535] = "",
	[3536] = "",
	[3537] = "",
	[3538] = "",
	[3539] = "",
	[3540] = "",
	[3541] = "",
	[3542] = "",
	[3543] = "",
	[3544] = "",
	[3545] = "",
	[3546] = "",
	[3547] = "",
	[3548] = "",
	[3549] = "",
	[3550] = "",
	[3551] = "",
	[3552] = "",
	[3553] = "",
	[3554] = "",
	[3555] = "",
	[3556] = "",
	[3557] = "",
	[3558] = "",

	[3623] = "",
	[3624] = "",
	[3625] = "",
	[3626] = "",
	[3627] = "",
	[3628] = "",
	[3629] = "",
	[3630] = "",
	[3631] = "",
	[3632] = "",
	[3633] = "",
	[3634] = "",
	[3635] = "",
	[3636] = "",
	[3637] = "",
	[3638] = "",
	[3639] = "",
	[3640] = "",
	[3641] = "",
	[3642] = "",
	[3643] = "",
	[3644] = "",
	[3645] = "",
	[3646] = "",
	[3647] = "",
	[3648] = "",
	[3649] = "",
	[3650] = "",
	[3651] = "",
	[3652] = "",
	[3653] = "",
	[3654] = "",
	[3655] = "",
	[3656] = "",

	[3723] = "",
	[3724] = "",
	[3725] = "",
	[3726] = "",
	[3727] = "",
	[3728] = "",
	[3729] = "",
	[3730] = "",
	[3731] = "",
	[3732] = "",
	[3733] = "",
	[3734] = "",
	[3735] = "",
	[3736] = "",
	[3737] = "",
	[3738] = "",
	[3739] = "",
	[3740] = "",
	[3741] = "",
	[3742] = "",
	[3743] = "",
	[3744] = "",
	[3745] = "",
	[3746] = "",
	[3747] = "",
	[3748] = "",
	[3749] = "",
	[3750] = "",
	[3751] = "",
	[3752] = "",
	[3753] = "",
	[3754] = "",
	[3755] = "",
	[3756] = "",

	[3823] = "",
	[3824] = "",
	[3825] = "",
	[3826] = "",
	[3827] = "",
	[3828] = "",
	[3829] = "",
	[3830] = "",
	[3831] = "",
	[3832] = "",
	[3833] = "",
	[3834] = "",
	[3835] = "",
	[3836] = "",
	[3837] = "",
	[3838] = "",
	[3839] = "",
	[3840] = "",
	[3841] = "",
	[3842] = "",
	[3843] = "",
	[3844] = "",
	[3845] = "",
	[3846] = "",
	[3847] = "",
	[3848] = "",
	[3849] = "",
	[3850] = "",
	[3851] = "",
	[3852] = "",
	[3853] = "",
	[3854] = "",
	[3855] = "",

	[3923] = "",
	[3924] = "",
	[3925] = "",
	[3926] = "",
	[3927] = "",
	[3928] = "",
	[3929] = "",
	[3930] = "",
	[3931] = "",
	[3932] = "",
	[3933] = "",
	[3934] = "",
	[3935] = "",
	[3936] = "",
	[3937] = "",
	[3938] = "",
	[3939] = "",
	[3940] = "",
	[3941] = "",
	[3942] = "",
	[3943] = "",
	[3944] = "",
	[3945] = "",
	[3946] = "",
	[3947] = "",
	[3948] = "",
	[3949] = "",
	[3950] = "",
	[3951] = "",
	[3952] = "",
	[3953] = "",
	[3954] = "",
	[3955] = "",

	[4023] = "",
	[4024] = "",
	[4025] = "",
	[4026] = "",
	[4027] = "",
	[4028] = "",
	[4029] = "",
	[4030] = "",
	[4031] = "",
	[4032] = "",
	[4033] = "",
	[4034] = "",
	[4035] = "",
	[4036] = "",
	[4037] = "",
	[4038] = "",
	[4039] = "",
	[4040] = "",
	[4041] = "",
	[4042] = "",
	[4043] = "",
	[4044] = "",
	[4045] = "",
	[4046] = "",
	[4047] = "",
	[4048] = "",
	[4049] = "",
	[4050] = "",
	[4051] = "",
	[4052] = "",
	[4053] = "",

	[4123] = "",
	[4124] = "",
	[4125] = "",
	[4126] = "",
	[4127] = "",
	[4128] = "",
	[4129] = "",
	[4130] = "",
	[4131] = "",
	[4132] = "",
	[4133] = "",
	[4136] = "",
	[4137] = "",
	[4138] = "",
	[4139] = "",
	[4140] = "",
	[4141] = "",
	[4142] = "",
	[4143] = "",
	[4144] = "",
	[4145] = "",
	[4146] = "",
	[4147] = "",
	[4148] = "",
	[4149] = "",
	[4150] = "",
	[4151] = "",
	[4152] = "",

	[4224] = "",
	[4225] = "",
	[4226] = "",
	[4227] = "",
	[4228] = "",
	[4229] = "",
	[4230] = "",
	[4236] = "",
	[4237] = "",
	[4238] = "",
	[4239] = "",
	[4240] = "",
	[4241] = "",
	[4242] = "",

	[4325] = "",
	[4326] = "",
	[4327] = "",
	[4328] = "",
	[4329] = "",
	[4336] = "",
	[4337] = "",
	[4338] = "",
	[4339] = "",
	[4340] = "",
	[4341] = "",

	[4425] = "",
	[4426] = "",
	[4436] = "",
	[4437] = "",
	[4438] = "",
	[4439] = "",
	[4440] = "",
	[4441] = "",
}

Map.NRMapBlks = {	-- Northrend
	[1609] = "",
	[1610] = "",
	[1611] = "",
	[1612] = "",
	[1613] = "",
	[1614] = "",
	[1615] = "",
	[1616] = "",
	[1617] = "",
	[1618] = "",
	[1619] = "",
	[1620] = "",
	[1621] = "",
	[1622] = "",
	[1623] = "",
	[1624] = "",
	[1625] = "",
	[1626] = "",
	[1627] = "",
	[1628] = "",
	[1629] = "",
	[1630] = "",
	[1631] = "",
	[1632] = "",
	[1633] = "",
	[1709] = "",
	[1710] = "",
	[1711] = "",
	[1712] = "",
	[1713] = "",
	[1714] = "",
	[1715] = "",
	[1716] = "",
	[1717] = "",
	[1718] = "",
	[1719] = "",
	[1720] = "",
	[1721] = "",
	[1722] = "",
	[1723] = "",
	[1724] = "",
	[1725] = "",
	[1726] = "",
	[1727] = "",
	[1728] = "",
	[1729] = "",
	[1730] = "",
	[1731] = "",
	[1732] = "",
	[1733] = "",
	[1809] = "",
	[1810] = "",
	[1811] = "",
	[1812] = "",
	[1813] = "",
	[1814] = "",
	[1815] = "",
	[1816] = "",
	[1817] = "",
	[1818] = "",
	[1819] = "",
	[1820] = "",
	[1821] = "",
	[1822] = "",
	[1823] = "",
	[1824] = "",
	[1825] = "",
	[1826] = "",
	[1827] = "",
	[1828] = "",
	[1829] = "",
	[1830] = "",
	[1831] = "",
	[1832] = "",
	[1833] = "",
	[1909] = "",
	[1910] = "",
	[1911] = "",
	[1912] = "",
	[1913] = "",
	[1914] = "",
	[1915] = "",
	[1916] = "",
	[1917] = "",
	[1918] = "",
	[1919] = "",
	[1920] = "",
	[1921] = "",
	[1922] = "",
	[1923] = "",
	[1924] = "",
	[1925] = "",
	[1926] = "",
	[1927] = "",
	[1928] = "",
	[1929] = "",
	[1930] = "",
	[1931] = "",
	[1932] = "",
	[1933] = "",
	[2009] = "",
	[2010] = "",
	[2011] = "",
	[2012] = "",
	[2013] = "",
	[2014] = "",
	[2015] = "",
	[2016] = "",
	[2017] = "",
	[2018] = "",
	[2019] = "",
	[2020] = "",
	[2021] = "",
	[2022] = "",
	[2023] = "",
	[2024] = "",
	[2025] = "",
	[2026] = "",
	[2027] = "",
	[2028] = "",
	[2029] = "",
	[2030] = "",
	[2031] = "",
	[2032] = "",
	[2033] = "",
	[2109] = "",
	[2110] = "",
	[2111] = "",
	[2112] = "",
	[2113] = "",
	[2114] = "",
	[2115] = "",
	[2116] = "",
	[2117] = "",
	[2118] = "",
	[2119] = "",
	[2120] = "",
	[2121] = "",
	[2122] = "",
	[2123] = "",
	[2124] = "",
	[2125] = "",
	[2126] = "",
	[2127] = "",
	[2128] = "",
	[2129] = "",
	[2130] = "",
	[2131] = "",
	[2132] = "",
	[2133] = "",
	[2209] = "",
	[2210] = "",
	[2211] = "",
	[2212] = "",
	[2213] = "",
	[2214] = "",
	[2215] = "",
	[2216] = "",
	[2217] = "",
	[2218] = "",
	[2219] = "",
	[2220] = "",
	[2221] = "",
	[2222] = "",
	[2223] = "",
	[2224] = "",
	[2225] = "",
	[2226] = "",
	[2227] = "",
	[2228] = "",
	[2229] = "",
	[2230] = "",
	[2231] = "",
	[2232] = "",
	[2233] = "",
	[2309] = "",
	[2310] = "",
	[2311] = "",
	[2312] = "",
	[2313] = "",
	[2314] = "",
	[2315] = "",
	[2316] = "",
	[2317] = "",
	[2318] = "",
	[2319] = "",
	[2320] = "",
	[2321] = "",
	[2322] = "",
	[2323] = "",
	[2324] = "",
	[2325] = "",
	[2326] = "",
	[2327] = "",
	[2328] = "",
	[2329] = "",
	[2330] = "",
	[2331] = "",
	[2332] = "",
	[2333] = "",
	[2409] = "",
	[2410] = "",
	[2411] = "",
	[2412] = "",
	[2413] = "",
	[2414] = "",
	[2415] = "",
	[2416] = "",
	[2417] = "",
	[2418] = "",
	[2419] = "",
	[2420] = "",
	[2421] = "",
	[2422] = "",
	[2423] = "",
	[2424] = "",
	[2425] = "",
	[2426] = "",
	[2427] = "",
	[2428] = "",
	[2429] = "",
	[2430] = "",
	[2431] = "",
	[2432] = "",
	[2433] = "",
	[2509] = "",
	[2510] = "",
	[2511] = "",
	[2512] = "",
	[2513] = "",
	[2514] = "",
	[2515] = "",
	[2516] = "",
	[2517] = "",
	[2518] = "",
	[2519] = "",
	[2520] = "",
	[2521] = "",
	[2522] = "",
	[2523] = "",
	[2524] = "",
	[2525] = "",
	[2526] = "",
	[2527] = "",
	[2528] = "",
	[2529] = "",
	[2530] = "",
	[2531] = "",
	[2532] = "",
	[2533] = "",
	[2609] = "",
	[2610] = "",
	[2611] = "",
	[2612] = "",
	[2613] = "",
	[2614] = "",
	[2615] = "",
	[2616] = "",
	[2617] = "",
	[2618] = "",
	[2619] = "",
	[2620] = "",
	[2621] = "",
	[2622] = "",
	[2623] = "",
	[2624] = "",
	[2625] = "",
	[2626] = "",
	[2627] = "",
	[2628] = "",
	[2629] = "",
	[2630] = "",
	[2631] = "",
	[2632] = "",
	[2633] = "",
	[2709] = "",
	[2710] = "",
	[2711] = "",
	[2712] = "",
	[2713] = "",
	[2714] = "",
	[2715] = "",
	[2716] = "",
	[2717] = "",
	[2718] = "",
	[2719] = "",
	[2720] = "",
	[2721] = "",
	[2722] = "",
	[2723] = "",
	[2724] = "",
	[2725] = "",
	[2726] = "",
	[2727] = "",
	[2728] = "",
	[2729] = "",
	[2730] = "",
	[2731] = "",
	[2732] = "",
	[2733] = "",
	[2809] = "",
	[2810] = "",
	[2811] = "",
	[2812] = "",
	[2813] = "",
	[2814] = "",
	[2815] = "",
	[2816] = "",
	[2817] = "",
	[2818] = "",
	[2819] = "",
	[2820] = "",
	[2821] = "",
	[2822] = "",
	[2823] = "",
	[2824] = "",
	[2825] = "",
	[2826] = "",
	[2827] = "",
	[2828] = "",
	[2829] = "",
	[2830] = "",
	[2831] = "",
	[2832] = "",
	[2833] = "",
	[2909] = "",
	[2910] = "",
	[2911] = "",
	[2912] = "",
	[2913] = "",
	[2914] = "",
	[2915] = "",
	[2916] = "",
	[2917] = "",
	[2918] = "",
	[2919] = "",
	[2920] = "",
	[2921] = "",
	[2922] = "",
	[2923] = "",
	[2924] = "",
	[2925] = "",
	[2926] = "",
	[2927] = "",
	[2928] = "",
	[2929] = "",
	[2930] = "",
	[2931] = "",
	[2932] = "",
	[2933] = "",
	[3009] = "",
	[3010] = "",
	[3011] = "",
	[3012] = "",
	[3013] = "",
	[3014] = "",
	[3015] = "",
	[3016] = "",
	[3017] = "",
	[3018] = "",
	[3019] = "",
	[3020] = "",
	[3021] = "",
	[3022] = "",
	[3023] = "",
	[3024] = "",
	[3025] = "",
	[3026] = "",
	[3027] = "",
	[3028] = "",
	[3029] = "",
	[3030] = "",
	[3031] = "",
	[3032] = "",
	[3033] = "",
	[3109] = "",
	[3110] = "",
	[3111] = "",
	[3112] = "",
	[3113] = "",
	[3114] = "",
	[3115] = "",
	[3116] = "",
	[3117] = "",
	[3118] = "",
	[3119] = "",
	[3120] = "",
	[3121] = "",
	[3122] = "",
	[3123] = "",
	[3124] = "",
	[3125] = "",
	[3126] = "",
	[3127] = "",
	[3128] = "",
	[3129] = "",
	[3130] = "",
	[3131] = "",
	[3132] = "",
	[3133] = "",
	[3209] = "",
	[3210] = "",
	[3211] = "",
	[3212] = "",
	[3213] = "",
	[3214] = "",
	[3215] = "",
	[3216] = "",
	[3217] = "",
	[3218] = "",
	[3219] = "",
	[3220] = "",
	[3221] = "",
	[3222] = "",
	[3223] = "",
	[3224] = "",
	[3225] = "",
	[3226] = "",
	[3227] = "",
	[3228] = "",
	[3229] = "",
	[3230] = "",
	[3231] = "",
	[3232] = "",
	[3233] = "",
	[3309] = "",
	[3310] = "",
	[3311] = "",
	[3312] = "",
	[3313] = "",
	[3314] = "",
	[3315] = "",
	[3316] = "",
	[3317] = "",
	[3318] = "",
	[3319] = "",
	[3320] = "",
	[3321] = "",
	[3322] = "",
	[3323] = "",
	[3324] = "",
	[3325] = "",
	[3326] = "",
	[3327] = "",
	[3328] = "",
	[3329] = "",
	[3330] = "",
	[3331] = "",
	[3332] = "",
	[3333] = "",
	[3409] = "",
	[3410] = "",
	[3411] = "",
	[3412] = "",
	[3413] = "",
	[3414] = "",
	[3415] = "",
	[3416] = "",
	[3417] = "",
	[3418] = "",
	[3419] = "",
	[3420] = "",
	[3421] = "",
	[3422] = "",
	[3423] = "",
	[3424] = "",
	[3425] = "",
	[3426] = "",
	[3427] = "",
	[3428] = "",
	[3429] = "",
	[3430] = "",
	[3431] = "",
	[3432] = "",
	[3433] = "",
	[3509] = "",
	[3510] = "",
	[3511] = "",
	[3512] = "",
	[3513] = "",
	[3514] = "",
	[3515] = "",
	[3516] = "",
	[3517] = "",
	[3518] = "",
	[3519] = "",
	[3520] = "",
	[3521] = "",
	[3522] = "",
	[3523] = "",
	[3524] = "",
	[3525] = "",
	[3526] = "",
	[3527] = "",
	[3528] = "",
	[3529] = "",
	[3530] = "",
	[3531] = "",
	[3532] = "",
	[3533] = "",
	[3609] = "",
	[3610] = "",
	[3611] = "",
	[3612] = "",
	[3613] = "",
	[3614] = "",
	[3615] = "",
	[3616] = "",
	[3617] = "",
	[3618] = "",
	[3619] = "",
	[3620] = "",
	[3621] = "",
	[3622] = "",
	[3623] = "",
	[3624] = "",
	[3625] = "",
	[3626] = "",
	[3627] = "",
	[3628] = "",
	[3629] = "",
	[3630] = "",
	[3631] = "",
	[3632] = "",
	[3633] = "",
	[3709] = "",
	[3710] = "",
	[3711] = "",
	[3712] = "",
	[3713] = "",
	[3714] = "",
	[3715] = "",
	[3716] = "",
	[3717] = "",
	[3718] = "",
	[3719] = "",
	[3720] = "",
	[3721] = "",
	[3722] = "",
	[3723] = "",
	[3724] = "",
	[3725] = "",
	[3726] = "",
	[3727] = "",
	[3728] = "",
	[3729] = "",
	[3730] = "",
	[3731] = "",
	[3732] = "",
	[3733] = "",
	[3809] = "",
	[3810] = "",
	[3811] = "",
	[3812] = "",
	[3813] = "",
	[3814] = "",
	[3815] = "",
	[3816] = "",
	[3817] = "",
	[3818] = "",
	[3819] = "",
	[3820] = "",
	[3821] = "",
	[3822] = "",
	[3823] = "",
	[3824] = "",
	[3825] = "",
	[3826] = "",
	[3827] = "",
	[3828] = "",
	[3829] = "",
	[3830] = "",
	[3831] = "",
	[3832] = "",
	[3833] = "",
	[3909] = "",
	[3910] = "",
	[3911] = "",
	[3912] = "",
	[3913] = "",
	[3914] = "",
	[3915] = "",
	[3916] = "",
	[3917] = "",
	[3918] = "",
	[3919] = "",
	[3920] = "",
	[3921] = "",
	[3922] = "",
	[3923] = "",
	[3924] = "",
	[3925] = "",
	[3926] = "",
	[3927] = "",
	[3928] = "",
	[3929] = "",
	[3930] = "",
	[3931] = "",
	[3932] = "",
	[3933] = "",
	[4009] = "",
	[4010] = "",
	[4011] = "",
	[4012] = "",
	[4013] = "",
	[4014] = "",
	[4015] = "",
	[4016] = "",
	[4017] = "",
	[4018] = "",
	[4019] = "",
	[4020] = "",
	[4021] = "",
	[4022] = "",
	[4023] = "",
	[4024] = "",
	[4025] = "",
	[4026] = "",
	[4027] = "",
	[4028] = "",
	[4029] = "",
	[4030] = "",
	[4031] = "",
	[4032] = "",
	[4033] = "",
	[4109] = "",
	[4110] = "",
	[4111] = "",
	[4112] = "",
	[4113] = "",
	[4114] = "",
	[4115] = "",
	[4116] = "",
	[4117] = "",
	[4118] = "",
	[4119] = "",
	[4120] = "",
	[4121] = "",
	[4122] = "",
	[4123] = "",
	[4124] = "",
	[4125] = "",
	[4126] = "",
	[4127] = "",
	[4128] = "",
	[4129] = "",
	[4130] = "",
	[4131] = "",
	[4132] = "",
	[4133] = "",
	[4209] = "",
	[4210] = "",
	[4211] = "",
	[4212] = "",
	[4213] = "",
	[4214] = "",
	[4215] = "",
	[4216] = "",
	[4217] = "",
	[4218] = "",
	[4219] = "",
	[4220] = "",
	[4221] = "",
	[4222] = "",
	[4223] = "",
	[4224] = "",
	[4225] = "",
	[4226] = "",
	[4227] = "",
	[4228] = "",
	[4229] = "",
	[4230] = "",
	[4231] = "",
	[4232] = "",
	[4233] = "",
	[4309] = "",
	[4310] = "",
	[4311] = "",
	[4312] = "",
	[4313] = "",
	[4314] = "",
	[4315] = "",
	[4316] = "",
	[4317] = "",
	[4318] = "",
	[4319] = "",
	[4320] = "",
	[4321] = "",
	[4322] = "",
	[4323] = "",
	[4324] = "",
	[4325] = "",
	[4326] = "",
	[4327] = "",
	[4328] = "",
	[4329] = "",
	[4330] = "",
	[4331] = "",
	[4332] = "",
	[4333] = "",
	[4409] = "",
	[4410] = "",
	[4411] = "",
	[4412] = "",
	[4413] = "",
	[4414] = "",
	[4415] = "",
	[4416] = "",
	[4417] = "",
	[4418] = "",
	[4419] = "",
	[4420] = "",
	[4421] = "",
	[4422] = "",
	[4423] = "",
	[4424] = "",
	[4425] = "",
	[4426] = "",
	[4427] = "",
	[4428] = "",
	[4429] = "",
	[4430] = "",
	[4431] = "",
	[4432] = "",
	[4433] = "",
	[4509] = "",
	[4510] = "",
	[4511] = "",
	[4512] = "",
	[4513] = "",
	[4514] = "",
	[4515] = "",
	[4516] = "",
	[4517] = "",
	[4518] = "",
	[4519] = "",
	[4520] = "",
	[4521] = "",
	[4522] = "",
	[4523] = "",
	[4524] = "",
	[4525] = "",
	[4526] = "",
	[4527] = "",
	[4528] = "",
	[4529] = "",
	[4530] = "",
	[4531] = "",
	[4532] = "",
	[4533] = "",
}

Map.TolBaradMapBlks = {
	[2731] = "",
	[2732] = "",
	[2733] = "",
	[2734] = "",
	[2735] = "",
	[2831] = "",
	[2832] = "",
	[2833] = "",
	[2834] = "",
	[2835] = "",
	[2931] = "",
	[2932] = "",
	[2933] = "",
	[2934] = "",
	[2935] = "",
	[3031] = "",
	[3032] = "",
	[3033] = "",
	[3034] = "",
	[3035] = "",
	[3131] = "",
	[3132] = "",
	[3133] = "",
	[3134] = "",
	[3135] = "",
}

-- Need??
-- Deephome (26,25 -> 35,34)
-- MaelstromZone (28,28 -> 32,32)

Map.LIMapBlks = {	-- LostIsles (32,51 max)
	[2426] = "",
	[2427] = "",
	[2428] = "",
	[2429] = "",
	[2430] = "",
	[2431] = "",
	[2432] = "",
	[2526] = "",
	[2527] = "",
	[2528] = "",
	[2529] = "",
	[2530] = "",
	[2531] = "",
	[2532] = "",
	[2626] = "",
	[2627] = "",
	[2628] = "",
	[2629] = "",
	[2630] = "",
	[2631] = "",
	[2632] = "",
	[2726] = "",
	[2727] = "",
	[2728] = "",
	[2729] = "",
	[2730] = "",
	[2731] = "",
	[2732] = "",
	[2826] = "",
	[2827] = "",
	[2828] = "",
	[2829] = "",
	[2830] = "",
	[2831] = "",
	[2832] = "",
	[2926] = "",
	[2927] = "",
	[2928] = "",
	[2929] = "",
	[2930] = "",
	[2931] = "",
	[2932] = "",
	[3026] = "",
	[3027] = "",
	[3028] = "",
	[3029] = "",
	[3030] = "",
	[3031] = "",
	[3032] = "",
	[3126] = "",
	[3127] = "",
	[3128] = "",
	[3129] = "",
	[3130] = "",
	[3131] = "",
}

Map.DeepholmMapBlks = {
	[2728] = "",
	[2729] = "",
	[2730] = "",
	[2731] = "",
	[2827] = "",
	[2828] = "",
	[2829] = "",
	[2830] = "",
	[2831] = "",
	[2832] = "",
	[2927] = "",
	[2928] = "",
	[2929] = "",
	[2930] = "",
	[2931] = "",
	[2932] = "",
	[3027] = "",
	[3028] = "",
	[3029] = "",
	[3030] = "",
	[3031] = "",
	[3032] = "",
	[3127] = "",
	[3128] = "",
	[3129] = "",
	[3130] = "",
	[3131] = "",
	[3132] = "",
	[3227] = "",
	[3228] = "",
	[3229] = "",
	[3230] = "",
	[3231] = "",
	[3232] = "",
	[3328] = "",
	[3329] = "",
	[3330] = "",
	[3331] = "",
}

Map.KezanMapBlks = {
	[2648] = "",
	[2649] = "",
	[2650] = "",
	[2651] = "",
	[2746] = "",
	[2747] = "",
	[2748] = "",
	[2749] = "",
	[2750] = "",
	[2751] = "",
	[2846] = "",
	[2847] = "",
	[2848] = "",
	[2849] = "",
	[2850] = "",
	[2851] = "",
	[2946] = "",
	[2947] = "",
	[2948] = "",
	[2949] = "",
	[2950] = "",
	[2951] = "",
	[3046] = "",
	[3047] = "",
	[3048] = "",
	[3049] = "",
	[3050] = "",
	[3051] = "",
	[3148] = "",
	[3149] = "",
	[3150] = "",
	[3151] = "",
}

Map.MoltenFrontMapBlks = {
	[3028] = "",
	[3029] = "",
	[3030] = "",
	[3031] = "",
	[3128] = "",
	[3129] = "",
	[3130] = "",
	[3131] = "",
	[3228] = "",
	[3229] = "",
	[3230] = "",
	[3231] = "",
	[3328] = "",
	[3329] = "",
	[3330] = "",
	[3331] = "",
}

Map.DarkMoonFaireBlks = {
	[1636] = "",
	[1637] = "",
	[1638] = "",
	[1639] = "",
	[1640] = "",
	[1641] = "",
	[1642] = "",
	[1736] = "",
	[1737] = "",
	[1738] = "",
	[1739] = "",
	[1740] = "",
	[1741] = "",
	[1742] = "",
	[1836] = "",
	[1837] = "",
	[1838] = "",
	[1839] = "",
	[1840] = "",
	[1841] = "",
	[1842] = "",
	[1936] = "",
	[1937] = "",
	[1938] = "",
	[1939] = "",
	[1940] = "",
	[1941] = "",
	[1942] = "",
	[2036] = "",
	[2037] = "",
	[2038] = "",
	[2039] = "",
	[2040] = "",
	[2041] = "",
	[2042] = "",
	[2136] = "",
	[2137] = "",
	[2138] = "",
	[2139] = "",
	[2140] = "",
	[2141] = "",
	[2142] = "",
	[2236] = "",
	[2237] = "",
	[2238] = "",
	[2239] = "",
	[2240] = "",
	[2241] = "",
	[2242] = "",
}

Map.PandariaMapBlks = {
	[1818] = "",
	[1819] = "",
	[1820] = "",
	[1821] = "",
	[1822] = "",
	[1823] = "",
	[1824] = "",
	[1825] = "",
	[1826] = "",
	[1827] = "",
	[1828] = "",
	[1829] = "",
	[1830] = "",
	[1831] = "",
	[1832] = "",
	[1833] = "",
	[1834] = "",
	[1835] = "",
	[1836] = "",
	[1837] = "",
	[1838] = "",
	[1839] = "",
	[1840] = "",
	[1841] = "",
	[1918] = "",
	[1919] = "",
	[1920] = "",
	[1921] = "",
	[1922] = "",
	[1923] = "",
	[1924] = "",
	[1925] = "",
	[1926] = "",
	[1927] = "",
	[1928] = "",
	[1929] = "",
	[1930] = "",
	[1931] = "",
	[1932] = "",
	[1933] = "",
	[1934] = "",
	[1935] = "",
	[1936] = "",
	[1937] = "",
	[1938] = "",
	[1939] = "",
	[1940] = "",
	[1941] = "",
	[2018] = "",
	[2019] = "",
	[2020] = "",
	[2021] = "",
	[2022] = "",
	[2023] = "",
	[2024] = "",
	[2025] = "",
	[2026] = "",
	[2027] = "",
	[2028] = "",
	[2029] = "",
	[2030] = "",
	[2031] = "",
	[2032] = "",
	[2033] = "",
	[2034] = "",
	[2035] = "",
	[2036] = "",
	[2037] = "",
	[2038] = "",
	[2039] = "",
	[2040] = "",
	[2041] = "",
	[2118] = "",
	[2119] = "",
	[2120] = "",
	[2121] = "",
	[2122] = "",
	[2123] = "",
	[2124] = "",
	[2125] = "",
	[2126] = "",
	[2127] = "",
	[2128] = "",
	[2129] = "",
	[2130] = "",
	[2131] = "",
	[2132] = "",
	[2133] = "",
	[2134] = "",
	[2135] = "",
	[2136] = "",
	[2137] = "",
	[2138] = "",
	[2139] = "",
	[2140] = "",
	[2141] = "",
	[2218] = "",
	[2219] = "",
	[2220] = "",
	[2221] = "",
	[2222] = "",
	[2223] = "",
	[2224] = "",
	[2225] = "",
	[2226] = "",
	[2227] = "",
	[2228] = "",
	[2229] = "",
	[2230] = "",
	[2231] = "",
	[2232] = "",
	[2233] = "",
	[2234] = "",
	[2235] = "",
	[2236] = "",
	[2237] = "",
	[2238] = "",
	[2239] = "",
	[2240] = "",
	[2241] = "",
	[2318] = "",
	[2319] = "",
	[2320] = "",
	[2321] = "",
	[2322] = "",
	[2323] = "",
	[2324] = "",
	[2325] = "",
	[2326] = "",
	[2327] = "",
	[2328] = "",
	[2329] = "",
	[2330] = "",
	[2331] = "",
	[2332] = "",
	[2333] = "",
	[2334] = "",
	[2335] = "",
	[2336] = "",
	[2337] = "",
	[2338] = "",
	[2339] = "",
	[2340] = "",
	[2341] = "",
	[2418] = "",
	[2419] = "",
	[2420] = "",
	[2421] = "",
	[2422] = "",
	[2423] = "",
	[2424] = "",
	[2425] = "",
	[2426] = "",
	[2427] = "",
	[2428] = "",
	[2429] = "",
	[2430] = "",
	[2431] = "",
	[2432] = "",
	[2433] = "",
	[2434] = "",
	[2435] = "",
	[2436] = "",
	[2437] = "",
	[2438] = "",
	[2439] = "",
	[2440] = "",
	[2441] = "",
	[2518] = "",
	[2519] = "",
	[2520] = "",
	[2521] = "",
	[2522] = "",
	[2523] = "",
	[2524] = "",
	[2525] = "",
	[2526] = "",
	[2527] = "",
	[2528] = "",
	[2529] = "",
	[2530] = "",
	[2531] = "",
	[2532] = "",
	[2533] = "",
	[2534] = "",
	[2535] = "",
	[2536] = "",
	[2537] = "",
	[2538] = "",
	[2539] = "",
	[2540] = "",
	[2541] = "",
	[2618] = "",
	[2619] = "",
	[2620] = "",
	[2621] = "",
	[2622] = "",
	[2623] = "",
	[2624] = "",
	[2625] = "",
	[2626] = "",
	[2627] = "",
	[2628] = "",
	[2629] = "",
	[2630] = "",
	[2631] = "",
	[2632] = "",
	[2633] = "",
	[2634] = "",
	[2635] = "",
	[2636] = "",
	[2637] = "",
	[2638] = "",
	[2639] = "",
	[2640] = "",
	[2641] = "",
	[2718] = "",
	[2719] = "",
	[2720] = "",
	[2721] = "",
	[2722] = "",
	[2723] = "",
	[2724] = "",
	[2725] = "",
	[2726] = "",
	[2727] = "",
	[2728] = "",
	[2729] = "",
	[2730] = "",
	[2731] = "",
	[2732] = "",
	[2733] = "",
	[2734] = "",
	[2735] = "",
	[2736] = "",
	[2737] = "",
	[2738] = "",
	[2739] = "",
	[2740] = "",
	[2741] = "",
	[2818] = "",
	[2819] = "",
	[2820] = "",
	[2821] = "",
	[2822] = "",
	[2823] = "",
	[2824] = "",
	[2825] = "",
	[2826] = "",
	[2827] = "",
	[2828] = "",
	[2829] = "",
	[2830] = "",
	[2831] = "",
	[2832] = "",
	[2833] = "",
	[2834] = "",
	[2835] = "",
	[2836] = "",
	[2837] = "",
	[2838] = "",
	[2839] = "",
	[2840] = "",
	[2841] = "",
	[2918] = "",
	[2919] = "",
	[2920] = "",
	[2921] = "",
	[2922] = "",
	[2923] = "",
	[2924] = "",
	[2925] = "",
	[2926] = "",
	[2927] = "",
	[2928] = "",
	[2929] = "",
	[2930] = "",
	[2931] = "",
	[2932] = "",
	[2933] = "",
	[2934] = "",
	[2935] = "",
	[2936] = "",
	[2937] = "",
	[2938] = "",
	[2939] = "",
	[2940] = "",
	[2941] = "",
	[3018] = "",
	[3019] = "",
	[3020] = "",
	[3021] = "",
	[3022] = "",
	[3023] = "",
	[3024] = "",
	[3025] = "",
	[3026] = "",
	[3027] = "",
	[3028] = "",
	[3029] = "",
	[3030] = "",
	[3031] = "",
	[3032] = "",
	[3033] = "",
	[3034] = "",
	[3035] = "",
	[3036] = "",
	[3037] = "",
	[3038] = "",
	[3039] = "",
	[3040] = "",
	[3041] = "",
	[3118] = "",
	[3119] = "",
	[3120] = "",
	[3121] = "",
	[3122] = "",
	[3123] = "",
	[3124] = "",
	[3125] = "",
	[3126] = "",
	[3127] = "",
	[3128] = "",
	[3129] = "",
	[3130] = "",
	[3131] = "",
	[3132] = "",
	[3133] = "",
	[3134] = "",
	[3135] = "",
	[3136] = "",
	[3137] = "",
	[3138] = "",
	[3139] = "",
	[3140] = "",
	[3141] = "",
	[3218] = "",
	[3219] = "",
	[3220] = "",
	[3221] = "",
	[3222] = "",
	[3223] = "",
	[3224] = "",
	[3225] = "",
	[3226] = "",
	[3227] = "",
	[3228] = "",
	[3229] = "",
	[3230] = "",
	[3231] = "",
	[3232] = "",
	[3233] = "",
	[3234] = "",
	[3235] = "",
	[3236] = "",
	[3237] = "",
	[3238] = "",
	[3239] = "",
	[3240] = "",
	[3241] = "",
	[3318] = "",
	[3319] = "",
	[3320] = "",
	[3321] = "",
	[3322] = "",
	[3323] = "",
	[3324] = "",
	[3325] = "",
	[3326] = "",
	[3327] = "",
	[3328] = "",
	[3329] = "",
	[3330] = "",
	[3331] = "",
	[3332] = "",
	[3333] = "",
	[3334] = "",
	[3335] = "",
	[3336] = "",
	[3337] = "",
	[3338] = "",
	[3339] = "",
	[3340] = "",
	[3341] = "",
	[3418] = "",
	[3419] = "",
	[3420] = "",
	[3421] = "",
	[3422] = "",
	[3423] = "",
	[3424] = "",
	[3425] = "",
	[3426] = "",
	[3427] = "",
	[3428] = "",
	[3429] = "",
	[3430] = "",
	[3431] = "",
	[3432] = "",
	[3433] = "",
	[3434] = "",
	[3435] = "",
	[3436] = "",
	[3437] = "",
	[3438] = "",
	[3439] = "",
	[3440] = "",
	[3441] = "",
	[3518] = "",
	[3519] = "",
	[3520] = "",
	[3521] = "",
	[3522] = "",
	[3523] = "",
	[3524] = "",
	[3525] = "",
	[3526] = "",
	[3527] = "",
	[3528] = "",
	[3529] = "",
	[3530] = "",
	[3531] = "",
	[3532] = "",
	[3533] = "",
	[3534] = "",
	[3535] = "",
	[3536] = "",
	[3537] = "",
	[3538] = "",
	[3539] = "",
	[3540] = "",
	[3541] = "",
	[3618] = "",
	[3619] = "",
	[3620] = "",
	[3621] = "",
	[3622] = "",
	[3623] = "",
	[3624] = "",
	[3625] = "",
	[3626] = "",
	[3627] = "",
	[3628] = "",
	[3629] = "",
	[3630] = "",
	[3631] = "",
	[3632] = "",
	[3633] = "",
	[3634] = "",
	[3635] = "",
	[3636] = "",
	[3637] = "",
	[3638] = "",
	[3639] = "",
	[3640] = "",
	[3641] = "",
	[3718] = "",
	[3719] = "",
	[3720] = "",
	[3721] = "",
	[3722] = "",
	[3723] = "",
	[3724] = "",
	[3725] = "",
	[3726] = "",
	[3727] = "",
	[3728] = "",
	[3729] = "",
	[3730] = "",
	[3731] = "",
	[3732] = "",
	[3733] = "",
	[3734] = "",
	[3735] = "",
	[3736] = "",
	[3737] = "",
	[3738] = "",
	[3739] = "",
	[3740] = "",
	[3741] = "",
	[3818] = "",
	[3819] = "",
	[3820] = "",
	[3821] = "",
	[3822] = "",
	[3823] = "",
	[3824] = "",
	[3825] = "",
	[3826] = "",
	[3827] = "",
	[3828] = "",
	[3829] = "",
	[3830] = "",
	[3831] = "",
	[3832] = "",
	[3833] = "",
	[3834] = "",
	[3835] = "",
	[3836] = "",
	[3837] = "",
	[3838] = "",
	[3839] = "",
	[3840] = "",
	[3841] = "",
	[3918] = "",
	[3919] = "",
	[3920] = "",
	[3921] = "",
	[3922] = "",
	[3923] = "",
	[3924] = "",
	[3925] = "",
	[3926] = "",
	[3927] = "",
	[3928] = "",
	[3929] = "",
	[3930] = "",
	[3931] = "",
	[3932] = "",
	[3933] = "",
	[3934] = "",
	[3935] = "",
	[3936] = "",
	[3937] = "",
	[3938] = "",
	[3939] = "",
	[3940] = "",
	[3941] = "",
	[4018] = "",
	[4019] = "",
	[4020] = "",
	[4021] = "",
	[4022] = "",
	[4023] = "",
	[4024] = "",
	[4025] = "",
	[4026] = "",
	[4027] = "",
	[4028] = "",
	[4029] = "",
	[4030] = "",
	[4031] = "",
	[4032] = "",
	[4033] = "",
	[4034] = "",
	[4035] = "",
	[4036] = "",
	[4037] = "",
	[4038] = "",
	[4039] = "",
	[4040] = "",
	[4041] = "",
	[4118] = "",
	[4119] = "",
	[4120] = "",
	[4121] = "",
	[4122] = "",
	[4123] = "",
	[4124] = "",
	[4125] = "",
	[4126] = "",
	[4127] = "",
	[4128] = "",
	[4129] = "",
	[4130] = "",
	[4131] = "",
	[4132] = "",
	[4133] = "",
	[4134] = "",
	[4135] = "",
	[4136] = "",
	[4137] = "",
	[4138] = "",
	[4139] = "",
	[4140] = "",
	[4141] = "",
	[4218] = "",
	[4219] = "",
	[4220] = "",
	[4221] = "",
	[4222] = "",
	[4223] = "",
	[4224] = "",
	[4225] = "",
	[4226] = "",
	[4227] = "",
	[4228] = "",
	[4229] = "",
	[4230] = "",
	[4231] = "",
	[4232] = "",
	[4233] = "",
	[4234] = "",
	[4235] = "",
	[4236] = "",
	[4237] = "",
	[4238] = "",
	[4239] = "",
	[4240] = "",
	[4241] = "",
	[4318] = "",
	[4319] = "",
	[4320] = "",
	[4321] = "",
	[4322] = "",
	[4323] = "",
	[4324] = "",
	[4325] = "",
	[4326] = "",
	[4327] = "",
	[4328] = "",
	[4329] = "",
	[4330] = "",
	[4331] = "",
	[4332] = "",
	[4333] = "",
	[4334] = "",
	[4335] = "",
	[4336] = "",
	[4337] = "",
	[4338] = "",
	[4339] = "",
	[4340] = "",
	[4341] = "",
}

Map.TheWanderingIsleMapBlks={
	[2328]="",
	[2329]="",
	[2330]="",
	[2331]="",
	[2428]="",
	[2429]="",
	[2430]="",
	[2431]="",
	[2528]="",
	[2529]="",
	[2530]="",
	[2531]="",
	[2628]="",
	[2629]="",
	[2630]="",
	[2631]="",
	[2728]="",
	[2729]="",
	[2730]="",
	[2731]="",
}

Map.DraenorMapBlks = {
	[1220]="",
	[1221]="",
	[1222]="",
	[1223]="",
	[1224]="",
	[1225]="",
	[1226]="",
	[1227]="",
	[1228]="",
	[1229]="",
	[1320]="",
	[1321]="",
	[1322]="",
	[1323]="",
	[1324]="",
	[1325]="",
	[1326]="",
	[1327]="",
	[1328]="",
	[1329]="",
	[1420]="",
	[1421]="",
	[1422]="",
	[1423]="",
	[1424]="",
	[1425]="",
	[1426]="",
	[1427]="",
	[1428]="",
	[1429]="",
	[1520]="",
	[1521]="",
	[1522]="",
	[1523]="",
	[1524]="",
	[1525]="",
	[1526]="",
	[1527]="",
	[1528]="",
	[1529]="",
	[1620]="",
	[1621]="",
	[1622]="",
	[1623]="",
	[1624]="",
	[1625]="",
	[1626]="",
	[1627]="",
	[1628]="",
	[1629]="",
	[1711]="",
	[1712]="",
	[1713]="",
	[1714]="",
	[1715]="",
	[1716]="",
	[1717]="",
	[1718]="",
	[1719]="",
	[1720]="",
	[1721]="",
	[1722]="",
	[1723]="",
	[1724]="",
	[1725]="",
	[1726]="",
	[1727]="",
	[1728]="",
	[1729]="",
	[1730]="",
	[1731]="",
	[1732]="",
	[1733]="",
	[1734]="",
	[1735]="",
	[1736]="",
	[1737]="",
	[1738]="",
	[1739]="",
	[1811]="",
	[1812]="",
	[1813]="",
	[1814]="",
	[1815]="",
	[1816]="",
	[1817]="",
	[1818]="",
	[1819]="",
	[1820]="",
	[1821]="",
	[1822]="",
	[1823]="",
	[1824]="",
	[1825]="",
	[1826]="",
	[1827]="",
	[1828]="",
	[1829]="",
	[1830]="",
	[1831]="",
	[1832]="",
	[1833]="",
	[1834]="",
	[1835]="",
	[1836]="",
	[1837]="",
	[1838]="",
	[1839]="",
	[1911]="",
	[1912]="",
	[1913]="",
	[1914]="",
	[1915]="",
	[1916]="",
	[1917]="",
	[1918]="",
	[1919]="",
	[1920]="",
	[1921]="",
	[1922]="",
	[1923]="",
	[1924]="",
	[1925]="",
	[1926]="",
	[1927]="",
	[1928]="",
	[1929]="",
	[1930]="",
	[1931]="",
	[1932]="",
	[1933]="",
	[1934]="",
	[1935]="",
	[1936]="",
	[1937]="",
	[1938]="",
	[1939]="",
	[2011]="",
	[2012]="",
	[2013]="",
	[2014]="",
	[2015]="",
	[2016]="",
	[2017]="",
	[2018]="",
	[2019]="",
	[2020]="",
	[2021]="",
	[2022]="",
	[2023]="",
	[2024]="",
	[2025]="",
	[2026]="",
	[2027]="",
	[2028]="",
	[2029]="",
	[2030]="",
	[2031]="",
	[2032]="",
	[2033]="",
	[2034]="",
	[2035]="",
	[2036]="",
	[2037]="",
	[2038]="",
	[2039]="",
	[2111]="",
	[2112]="",
	[2113]="",
	[2114]="",
	[2115]="",
	[2116]="",
	[2117]="",
	[2118]="",
	[2119]="",
	[2120]="",
	[2121]="",
	[2122]="",
	[2123]="",
	[2124]="",
	[2125]="",
	[2126]="",
	[2127]="",
	[2128]="",
	[2129]="",
	[2130]="",
	[2131]="",
	[2132]="",
	[2133]="",
	[2134]="",
	[2135]="",
	[2136]="",
	[2137]="",
	[2138]="",
	[2139]="",
	[2211]="",
	[2212]="",
	[2213]="",
	[2214]="",
	[2215]="",
	[2216]="",
	[2217]="",
	[2218]="",
	[2219]="",
	[2220]="",
	[2221]="",
	[2222]="",
	[2223]="",
	[2224]="",
	[2225]="",
	[2226]="",
	[2227]="",
	[2228]="",
	[2229]="",
	[2230]="",
	[2231]="",
	[2232]="",
	[2233]="",
	[2234]="",
	[2235]="",
	[2236]="",
	[2237]="",
	[2238]="",
	[2239]="",
	[2311]="",
	[2312]="",
	[2313]="",
	[2314]="",
	[2315]="",
	[2316]="",
	[2317]="",
	[2318]="",
	[2319]="",
	[2320]="",
	[2321]="",
	[2322]="",
	[2323]="",
	[2324]="",
	[2325]="",
	[2326]="",
	[2327]="",
	[2328]="",
	[2329]="",
	[2330]="",
	[2331]="",
	[2332]="",
	[2333]="",
	[2334]="",
	[2335]="",
	[2336]="",
	[2337]="",
	[2338]="",
	[2339]="",
	[2411]="",
	[2412]="",
	[2413]="",
	[2414]="",
	[2415]="",
	[2416]="",
	[2417]="",
	[2418]="",
	[2419]="",
	[2420]="",
	[2421]="",
	[2422]="",
	[2423]="",
	[2424]="",
	[2425]="",
	[2426]="",
	[2427]="",
	[2428]="",
	[2429]="",
	[2430]="",
	[2431]="",
	[2432]="",
	[2433]="",
	[2434]="",
	[2435]="",
	[2436]="",
	[2437]="",
	[2438]="",
	[2439]="",
	[2511]="",
	[2512]="",
	[2513]="",
	[2514]="",
	[2515]="",
	[2516]="",
	[2517]="",
	[2518]="",
	[2519]="",
	[2520]="",
	[2521]="",
	[2522]="",
	[2523]="",
	[2524]="",
	[2525]="",
	[2526]="",
	[2527]="",
	[2528]="",
	[2529]="",
	[2530]="",
	[2531]="",
	[2532]="",
	[2533]="",
	[2534]="",
	[2535]="",
	[2536]="",
	[2537]="",
	[2538]="",
	[2539]="",
	[2611]="",
	[2612]="",
	[2613]="",
	[2614]="",
	[2615]="",
	[2616]="",
	[2617]="",
	[2618]="",
	[2619]="",
	[2620]="",
	[2621]="",
	[2622]="",
	[2623]="",
	[2624]="",
	[2625]="",
	[2626]="",
	[2627]="",
	[2628]="",
	[2629]="",
	[2630]="",
	[2631]="",
	[2632]="",
	[2633]="",
	[2634]="",
	[2635]="",
	[2636]="",
	[2637]="",
	[2638]="",
	[2639]="",
	[2711]="",
	[2712]="",
	[2713]="",
	[2714]="",
	[2715]="",
	[2716]="",
	[2717]="",
	[2718]="",
	[2719]="",
	[2720]="",
	[2721]="",
	[2722]="",
	[2723]="",
	[2724]="",
	[2725]="",
	[2726]="",
	[2727]="",
	[2728]="",
	[2729]="",
	[2730]="",
	[2731]="",
	[2732]="",
	[2733]="",
	[2734]="",
	[2735]="",
	[2736]="",
	[2737]="",
	[2738]="",
	[2739]="",
	[2811]="",
	[2812]="",
	[2813]="",
	[2814]="",
	[2815]="",
	[2816]="",
	[2817]="",
	[2818]="",
	[2819]="",
	[2820]="",
	[2821]="",
	[2822]="",
	[2823]="",
	[2824]="",
	[2825]="",
	[2826]="",
	[2827]="",
	[2828]="",
	[2829]="",
	[2830]="",
	[2831]="",
	[2832]="",
	[2833]="",
	[2834]="",
	[2835]="",
	[2836]="",
	[2837]="",
	[2838]="",
	[2839]="",
	[2911]="",
	[2912]="",
	[2913]="",
	[2914]="",
	[2915]="",
	[2916]="",
	[2917]="",
	[2918]="",
	[2919]="",
	[2920]="",
	[2921]="",
	[2922]="",
	[2923]="",
	[2924]="",
	[2925]="",
	[2926]="",
	[2927]="",
	[2928]="",
	[2929]="",
	[2930]="",
	[2931]="",
	[2932]="",
	[2933]="",
	[2934]="",
	[2935]="",
	[2936]="",
	[2937]="",
	[2938]="",
	[2939]="",
	[3011]="",
	[3012]="",
	[3013]="",
	[3014]="",
	[3015]="",
	[3016]="",
	[3017]="",
	[3018]="",
	[3019]="",
	[3020]="",
	[3021]="",
	[3022]="",
	[3023]="",
	[3024]="",
	[3025]="",
	[3026]="",
	[3027]="",
	[3028]="",
	[3029]="",
	[3030]="",
	[3031]="",
	[3032]="",
	[3033]="",
	[3034]="",
	[3035]="",
	[3036]="",
	[3037]="",
	[3038]="",
	[3039]="",
	[3111]="",
	[3112]="",
	[3113]="",
	[3114]="",
	[3115]="",
	[3116]="",
	[3117]="",
	[3118]="",
	[3119]="",
	[3120]="",
	[3121]="",
	[3122]="",
	[3123]="",
	[3124]="",
	[3125]="",
	[3126]="",
	[3127]="",
	[3128]="",
	[3129]="",
	[3130]="",
	[3131]="",
	[3132]="",
	[3133]="",
	[3134]="",
	[3135]="",
	[3136]="",
	[3137]="",
	[3138]="",
	[3139]="",
	[3211]="",
	[3212]="",
	[3213]="",
	[3214]="",
	[3215]="",
	[3216]="",
	[3217]="",
	[3218]="",
	[3219]="",
	[3220]="",
	[3221]="",
	[3222]="",
	[3223]="",
	[3224]="",
	[3225]="",
	[3226]="",
	[3227]="",
	[3228]="",
	[3229]="",
	[3230]="",
	[3231]="",
	[3232]="",
	[3233]="",
	[3234]="",
	[3235]="",
	[3236]="",
	[3237]="",
	[3238]="",
	[3239]="",
	[3311]="",
	[3312]="",
	[3313]="",
	[3314]="",
	[3315]="",
	[3316]="",
	[3317]="",
	[3318]="",
	[3319]="",
	[3320]="",
	[3321]="",
	[3322]="",
	[3323]="",
	[3324]="",
	[3325]="",
	[3326]="",
	[3327]="",
	[3328]="",
	[3329]="",
	[3330]="",
	[3331]="",
	[3332]="",
	[3333]="",
	[3334]="",
	[3335]="",
	[3336]="",
	[3337]="",
	[3338]="",
	[3339]="",
	[3411]="",
	[3412]="",
	[3413]="",
	[3414]="",
	[3415]="",
	[3416]="",
	[3417]="",
	[3418]="",
	[3419]="",
	[3420]="",
	[3421]="",
	[3422]="",
	[3423]="",
	[3424]="",
	[3425]="",
	[3426]="",
	[3427]="",
	[3428]="",
	[3429]="",
	[3430]="",
	[3431]="",
	[3432]="",
	[3433]="",
	[3434]="",
	[3435]="",
	[3436]="",
	[3437]="",
	[3438]="",
	[3439]="",
	[3511]="",
	[3512]="",
	[3513]="",
	[3514]="",
	[3515]="",
	[3516]="",
	[3517]="",
	[3518]="",
	[3519]="",
	[3520]="",
	[3521]="",
	[3522]="",
	[3523]="",
	[3524]="",
	[3525]="",
	[3526]="",
	[3527]="",
	[3528]="",
	[3529]="",
	[3530]="",
	[3531]="",
	[3532]="",
	[3533]="",
	[3534]="",
	[3535]="",
	[3536]="",
	[3537]="",
	[3538]="",
	[3539]="",
	[3611]="",
	[3612]="",
	[3613]="",
	[3614]="",
	[3615]="",
	[3616]="",
	[3617]="",
	[3618]="",
	[3619]="",
	[3620]="",
	[3621]="",
	[3622]="",
	[3623]="",
	[3624]="",
	[3625]="",
	[3626]="",
	[3627]="",
	[3628]="",
	[3629]="",
	[3630]="",
	[3631]="",
	[3632]="",
	[3633]="",
	[3634]="",
	[3635]="",
	[3636]="",
	[3637]="",
	[3638]="",
	[3639]="",
	[3711]="",
	[3712]="",
	[3713]="",
	[3714]="",
	[3715]="",
	[3716]="",
	[3717]="",
	[3718]="",
	[3719]="",
	[3720]="",
	[3721]="",
	[3722]="",
	[3723]="",
	[3724]="",
	[3725]="",
	[3726]="",
	[3727]="",
	[3728]="",
	[3729]="",
	[3730]="",
	[3731]="",
	[3732]="",
	[3733]="",
	[3734]="",
	[3735]="",
	[3736]="",
	[3737]="",
	[3738]="",
	[3739]="",
	[3811]="",
	[3812]="",
	[3813]="",
	[3814]="",
	[3815]="",
	[3816]="",
	[3817]="",
	[3818]="",
	[3819]="",
	[3820]="",
	[3821]="",
	[3822]="",
	[3823]="",
	[3824]="",
	[3825]="",
	[3826]="",
	[3827]="",
	[3828]="",
	[3829]="",
	[3830]="",
	[3831]="",
	[3832]="",
	[3833]="",
	[3834]="",
	[3835]="",
	[3836]="",
	[3837]="",
	[3838]="",
	[3839]="",
	[3911]="",
	[3912]="",
	[3913]="",
	[3914]="",
	[3915]="",
	[3916]="",
	[3917]="",
	[3918]="",
	[3919]="",
	[3920]="",
	[3921]="",
	[3922]="",
	[3923]="",
	[3924]="",
	[3925]="",
	[3926]="",
	[3927]="",
	[3928]="",
	[3929]="",
	[3930]="",
	[3931]="",
	[3932]="",
	[3933]="",
	[3934]="",
	[3935]="",
	[3936]="",
	[3937]="",
	[3938]="",
	[3939]="",
	[4011]="",
	[4012]="",
	[4013]="",
	[4014]="",
	[4015]="",
	[4016]="",
	[4017]="",
	[4018]="",
	[4019]="",
	[4020]="",
	[4021]="",
	[4022]="",
	[4023]="",
	[4024]="",
	[4025]="",
	[4026]="",
	[4027]="",
	[4028]="",
	[4029]="",
	[4030]="",
	[4031]="",
	[4032]="",
	[4033]="",
	[4034]="",
	[4035]="",
	[4036]="",
	[4037]="",
	[4038]="",
	[4039]="",
	[4111]="",
	[4112]="",
	[4113]="",
	[4114]="",
	[4115]="",
	[4116]="",
	[4117]="",
	[4118]="",
	[4119]="",
	[4120]="",
	[4121]="",
	[4122]="",
	[4123]="",
	[4124]="",
	[4125]="",
	[4126]="",
	[4127]="",
	[4128]="",
	[4129]="",
	[4130]="",
	[4131]="",
	[4132]="",
	[4133]="",
	[4134]="",
	[4135]="",
	[4136]="",
	[4137]="",
	[4138]="",
	[4139]="",
	[4211]="",
	[4212]="",
	[4213]="",
	[4214]="",
	[4215]="",
	[4216]="",
	[4217]="",
	[4218]="",
	[4219]="",
	[4220]="",
	[4221]="",
	[4222]="",
	[4223]="",
	[4224]="",
	[4225]="",
	[4226]="",
	[4227]="",
	[4228]="",
	[4229]="",
	[4230]="",
	[4231]="",
	[4232]="",
	[4233]="",
	[4234]="",
	[4235]="",
	[4236]="",
	[4237]="",
	[4238]="",
	[4239]="",
	[4311]="",
	[4312]="",
	[4313]="",
	[4314]="",
	[4315]="",
	[4316]="",
	[4317]="",
	[4318]="",
	[4319]="",
	[4320]="",
	[4321]="",
	[4322]="",
	[4323]="",
	[4324]="",
	[4325]="",
	[4326]="",
	[4327]="",
	[4328]="",
	[4329]="",
	[4330]="",
	[4331]="",
	[4332]="",
	[4333]="",
	[4334]="",
	[4335]="",
	[4336]="",
	[4337]="",
	[4338]="",
	[4339]="",
	[4411]="",
	[4412]="",
	[4413]="",
	[4414]="",
	[4415]="",
	[4416]="",
	[4417]="",
	[4418]="",
	[4419]="",
	[4420]="",
	[4421]="",
	[4422]="",
	[4423]="",
	[4424]="",
	[4425]="",
	[4426]="",
	[4427]="",
	[4428]="",
	[4429]="",
	[4430]="",
	[4431]="",
	[4432]="",
	[4433]="",
	[4434]="",
	[4435]="",
	[4436]="",
	[4437]="",
	[4438]="",
	[4439]="",
}

Map.BrokenIslesMapBlks = {
	[1117]="",
	[1118]="",
	[1119]="",
	[1120]="",
	[1121]="",
	[1122]="",
	[1123]="",
	[1124]="",
	[1125]="",
	[1126]="",
	[1127]="",
	[1128]="",
	[1129]="",
	[1130]="",
	[1131]="",
	[1132]="",
	[1133]="",
	[1134]="",
	[1135]="",
	[1136]="",
	[1137]="",
	[1138]="",
	[1139]="",
	[1140]="",
	[1141]="",
	[1142]="",
	[1143]="",
	[1217]="",
	[1218]="",
	[1219]="",
	[1220]="",
	[1221]="",
	[1222]="",
	[1223]="",
	[1224]="",
	[1225]="",
	[1226]="",
	[1227]="",
	[1228]="",
	[1229]="",
	[1230]="",
	[1231]="",
	[1232]="",
	[1233]="",
	[1234]="",
	[1235]="",
	[1236]="",
	[1237]="",
	[1238]="",
	[1239]="",
	[1240]="",
	[1241]="",
	[1242]="",
	[1243]="",
	[1317]="",
	[1318]="",
	[1319]="",
	[1320]="",
	[1321]="",
	[1322]="",
	[1323]="",
	[1324]="",
	[1325]="",
	[1326]="",
	[1327]="",
	[1328]="",
	[1329]="",
	[1330]="",
	[1331]="",
	[1332]="",
	[1333]="",
	[1334]="",
	[1335]="",
	[1336]="",
	[1337]="",
	[1338]="",
	[1339]="",
	[1340]="",
	[1341]="",
	[1342]="",
	[1343]="",
	[1417]="",
	[1418]="",
	[1419]="",
	[1420]="",
	[1421]="",
	[1422]="",
	[1423]="",
	[1424]="",
	[1425]="",
	[1426]="",
	[1427]="",
	[1428]="",
	[1429]="",
	[1430]="",
	[1431]="",
	[1432]="",
	[1433]="",
	[1434]="",
	[1435]="",
	[1436]="",
	[1437]="",
	[1438]="",
	[1439]="",
	[1440]="",
	[1441]="",
	[1442]="",
	[1443]="",
	[1517]="",
	[1518]="",
	[1519]="",
	[1520]="",
	[1521]="",
	[1522]="",
	[1523]="",
	[1524]="",
	[1525]="",
	[1526]="",
	[1527]="",
	[1528]="",
	[1529]="",
	[1530]="",
	[1531]="",
	[1532]="",
	[1533]="",
	[1534]="",
	[1535]="",
	[1536]="",
	[1537]="",
	[1538]="",
	[1539]="",
	[1540]="",
	[1541]="",
	[1542]="",
	[1543]="",
	[1617]="",
	[1618]="",
	[1619]="",
	[1620]="",
	[1621]="",
	[1622]="",
	[1623]="",
	[1624]="",
	[1625]="",
	[1626]="",
	[1627]="",
	[1628]="",
	[1629]="",
	[1630]="",
	[1631]="",
	[1632]="",
	[1633]="",
	[1634]="",
	[1635]="",
	[1636]="",
	[1637]="",
	[1638]="",
	[1639]="",
	[1640]="",
	[1641]="",
	[1642]="",
	[1643]="",
	[1717]="",
	[1718]="",
	[1719]="",
	[1720]="",
	[1721]="",
	[1722]="",
	[1723]="",
	[1724]="",
	[1725]="",
	[1726]="",
	[1727]="",
	[1728]="",
	[1729]="",
	[1730]="",
	[1731]="",
	[1732]="",
	[1733]="",
	[1734]="",
	[1735]="",
	[1736]="",
	[1737]="",
	[1738]="",
	[1739]="",
	[1740]="",
	[1741]="",
	[1742]="",
	[1743]="",
	[1817]="",
	[1818]="",
	[1819]="",
	[1820]="",
	[1821]="",
	[1822]="",
	[1823]="",
	[1824]="",
	[1825]="",
	[1826]="",
	[1827]="",
	[1828]="",
	[1829]="",
	[1830]="",
	[1831]="",
	[1832]="",
	[1833]="",
	[1834]="",
	[1835]="",
	[1836]="",
	[1837]="",
	[1838]="",
	[1839]="",
	[1840]="",
	[1841]="",
	[1842]="",
	[1843]="",
	[1917]="",
	[1918]="",
	[1919]="",
	[1920]="",
	[1921]="",
	[1922]="",
	[1923]="",
	[1924]="",
	[1925]="",
	[1926]="",
	[1927]="",
	[1928]="",
	[1929]="",
	[1930]="",
	[1931]="",
	[1932]="",
	[1933]="",
	[1934]="",
	[1935]="",
	[1936]="",
	[1937]="",
	[1938]="",
	[1939]="",
	[1940]="",
	[1941]="",
	[1942]="",
	[1943]="",
	[2017]="",
	[2018]="",
	[2019]="",
	[2020]="",
	[2021]="",
	[2022]="",
	[2023]="",
	[2024]="",
	[2025]="",
	[2026]="",
	[2027]="",
	[2028]="",
	[2029]="",
	[2030]="",
	[2031]="",
	[2032]="",
	[2033]="",
	[2034]="",
	[2035]="",
	[2036]="",
	[2037]="",
	[2038]="",
	[2039]="",
	[2040]="",
	[2041]="",
	[2042]="",
	[2043]="",
	[2117]="",
	[2118]="",
	[2119]="",
	[2120]="",
	[2121]="",
	[2122]="",
	[2123]="",
	[2124]="",
	[2125]="",
	[2126]="",
	[2127]="",
	[2128]="",
	[2129]="",
	[2130]="",
	[2131]="",
	[2132]="",
	[2133]="",
	[2134]="",
	[2135]="",
	[2136]="",
	[2137]="",
	[2138]="",
	[2139]="",
	[2140]="",
	[2141]="",
	[2142]="",
	[2143]="",
	[2217]="",
	[2218]="",
	[2219]="",
	[2220]="",
	[2221]="",
	[2222]="",
	[2223]="",
	[2224]="",
	[2225]="",
	[2226]="",
	[2227]="",
	[2228]="",
	[2229]="",
	[2230]="",
	[2231]="",
	[2232]="",
	[2233]="",
	[2234]="",
	[2235]="",
	[2236]="",
	[2237]="",
	[2238]="",
	[2239]="",
	[2240]="",
	[2241]="",
	[2242]="",
	[2243]="",
	[2317]="",
	[2318]="",
	[2319]="",
	[2320]="",
	[2321]="",
	[2322]="",
	[2323]="",
	[2324]="",
	[2325]="",
	[2326]="",
	[2327]="",
	[2328]="",
	[2329]="",
	[2330]="",
	[2331]="",
	[2332]="",
	[2333]="",
	[2334]="",
	[2335]="",
	[2336]="",
	[2337]="",
	[2338]="",
	[2339]="",
	[2340]="",
	[2341]="",
	[2342]="",
	[2343]="",
	[2417]="",
	[2418]="",
	[2419]="",
	[2420]="",
	[2421]="",
	[2422]="",
	[2423]="",
	[2424]="",
	[2425]="",
	[2426]="",
	[2427]="",
	[2428]="",
	[2429]="",
	[2430]="",
	[2431]="",
	[2432]="",
	[2433]="",
	[2434]="",
	[2435]="",
	[2436]="",
	[2437]="",
	[2438]="",
	[2439]="",
	[2440]="",
	[2441]="",
	[2442]="",
	[2443]="",
	[2517]="",
	[2518]="",
	[2519]="",
	[2520]="",
	[2521]="",
	[2522]="",
	[2523]="",
	[2524]="",
	[2525]="",
	[2526]="",
	[2527]="",
	[2528]="",
	[2529]="",
	[2530]="",
	[2531]="",
	[2532]="",
	[2533]="",
	[2534]="",
	[2535]="",
	[2536]="",
	[2537]="",
	[2538]="",
	[2539]="",
	[2540]="",
	[2541]="",
	[2542]="",
	[2543]="",
	[2617]="",
	[2618]="",
	[2619]="",
	[2620]="",
	[2621]="",
	[2622]="",
	[2623]="",
	[2624]="",
	[2625]="",
	[2626]="",
	[2627]="",
	[2628]="",
	[2629]="",
	[2630]="",
	[2631]="",
	[2632]="",
	[2633]="",
	[2634]="",
	[2635]="",
	[2636]="",
	[2637]="",
	[2638]="",
	[2639]="",
	[2640]="",
	[2641]="",
	[2642]="",
	[2643]="",
	[2717]="",
	[2718]="",
	[2719]="",
	[2720]="",
	[2721]="",
	[2722]="",
	[2723]="",
	[2724]="",
	[2725]="",
	[2726]="",
	[2727]="",
	[2728]="",
	[2729]="",
	[2730]="",
	[2731]="",
	[2732]="",
	[2733]="",
	[2734]="",
	[2735]="",
	[2736]="",
	[2737]="",
	[2738]="",
	[2739]="",
	[2740]="",
	[2741]="",
	[2742]="",
	[2743]="",
	[2817]="",
	[2818]="",
	[2819]="",
	[2820]="",
	[2821]="",
	[2822]="",
	[2823]="",
	[2824]="",
	[2825]="",
	[2826]="",
	[2827]="",
	[2828]="",
	[2829]="",
	[2830]="",
	[2831]="",
	[2832]="",
	[2833]="",
	[2834]="",
	[2835]="",
	[2836]="",
	[2837]="",
	[2838]="",
	[2839]="",
	[2840]="",
	[2841]="",
	[2842]="",
	[2843]="",
	[2917]="",
	[2918]="",
	[2919]="",
	[2920]="",
	[2921]="",
	[2922]="",
	[2923]="",
	[2924]="",
	[2925]="",
	[2926]="",
	[2927]="",
	[2928]="",
	[2929]="",
	[2930]="",
	[2931]="",
	[2932]="",
	[2933]="",
	[2934]="",
	[2935]="",
	[2936]="",
	[2937]="",
	[2938]="",
	[2939]="",
	[2940]="",
	[2941]="",
	[2942]="",
	[2943]="",
	[3017]="",
	[3018]="",
	[3019]="",
	[3020]="",
	[3021]="",
	[3022]="",
	[3023]="",
	[3024]="",
	[3025]="",
	[3026]="",
	[3027]="",
	[3028]="",
	[3029]="",
	[3030]="",
	[3031]="",
	[3032]="",
	[3033]="",
	[3034]="",
	[3035]="",
	[3036]="",
	[3037]="",
	[3038]="",
	[3039]="",
	[3040]="",
	[3041]="",
	[3042]="",
	[3043]="",
	[3117]="",
	[3118]="",
	[3119]="",
	[3120]="",
	[3121]="",
	[3122]="",
	[3123]="",
	[3124]="",
	[3125]="",
	[3126]="",
	[3127]="",
	[3128]="",
	[3129]="",
	[3130]="",
	[3131]="",
	[3132]="",
	[3133]="",
	[3134]="",
	[3135]="",
	[3136]="",
	[3137]="",
	[3138]="",
	[3139]="",
	[3140]="",
	[3141]="",
	[3142]="",
	[3143]="",
	[3217]="",
	[3218]="",
	[3219]="",
	[3220]="",
	[3221]="",
	[3222]="",
	[3223]="",
	[3224]="",
	[3225]="",
	[3226]="",
	[3227]="",
	[3228]="",
	[3229]="",
	[3230]="",
	[3231]="",
	[3232]="",
	[3233]="",
	[3234]="",
	[3235]="",
	[3236]="",
	[3237]="",
	[3238]="",
	[3239]="",
	[3240]="",
	[3241]="",
	[3242]="",
	[3243]="",
	[3317]="",
	[3318]="",
	[3319]="",
	[3320]="",
	[3321]="",
	[3322]="",
	[3323]="",
	[3324]="",
	[3325]="",
	[3326]="",
	[3327]="",
	[3328]="",
	[3329]="",
	[3330]="",
	[3331]="",
	[3332]="",
	[3333]="",
	[3334]="",
	[3335]="",
	[3336]="",
	[3337]="",
	[3338]="",
	[3339]="",
	[3340]="",
	[3341]="",
	[3342]="",
	[3343]="",
	[3417]="",
	[3418]="",
	[3419]="",
	[3420]="",
	[3421]="",
	[3422]="",
	[3423]="",
	[3424]="",
	[3425]="",
	[3426]="",
	[3427]="",
	[3428]="",
	[3429]="",
	[3430]="",
	[3431]="",
	[3432]="",
	[3433]="",
	[3434]="",
	[3435]="",
	[3436]="",
	[3437]="",
	[3438]="",
	[3439]="",
	[3440]="",
	[3441]="",
	[3442]="",
	[3443]="",
	[3517]="",
	[3518]="",
	[3519]="",
	[3520]="",
	[3521]="",
	[3522]="",
	[3523]="",
	[3524]="",
	[3525]="",
	[3526]="",
	[3527]="",
	[3528]="",
	[3529]="",
	[3530]="",
	[3531]="",
	[3532]="",
	[3533]="",
	[3534]="",
	[3535]="",
	[3536]="",
	[3537]="",
	[3538]="",
	[3539]="",
	[3540]="",
	[3541]="",
	[3542]="",
	[3543]="",
	[3617]="",
	[3618]="",
	[3619]="",
	[3620]="",
	[3621]="",
	[3622]="",
	[3623]="",
	[3624]="",
	[3625]="",
	[3626]="",
	[3627]="",
	[3628]="",
	[3629]="",
	[3630]="",
	[3631]="",
	[3632]="",
	[3633]="",
	[3634]="",
	[3635]="",
	[3636]="",
	[3637]="",
	[3638]="",
	[3639]="",
	[3640]="",
	[3641]="",
	[3642]="",
	[3643]="",
	[3717]="",
	[3718]="",
	[3719]="",
	[3720]="",
	[3721]="",
	[3722]="",
	[3723]="",
	[3724]="",
	[3725]="",
	[3726]="",
	[3727]="",
	[3728]="",
	[3729]="",
	[3730]="",
	[3731]="",
	[3732]="",
	[3733]="",
	[3734]="",
	[3735]="",
	[3736]="",
	[3737]="",
	[3738]="",
	[3739]="",
	[3740]="",
	[3741]="",
	[3742]="",
	[3743]="",
}

Map.Argus1MapBlks = {
	[2627]="",
	[2628]="",
	[2629]="",
	[2630]="",	
	[2631]="",	
	[2727]="",
	[2728]="",
	[2729]="",
	[2730]="",	
	[2731]="",
	[2827]="",
	[2828]="",
	[2829]="",
	[2830]="",	
	[2831]="",
	[2927]="",
	[2928]="",
	[2929]="",
	[2930]="",	
	[2931]="",
	[3027]="",
	[3028]="",
	[3029]="",
	[3030]="",	
	[3031]="",		
}

Map.Argus2MapBlks = {
	[1135]="",
	[1136]="",
	[1137]="",
	[1138]="",
	[1139]="",
	[1235]="",
	[1236]="",
	[1237]="",
	[1238]="",
	[1239]="",
	[1335]="",
	[1336]="",
	[1337]="",
	[1338]="",
	[1339]="",
	[1435]="",
	[1436]="",
	[1437]="",
	[1438]="",
	[1439]="",
	[1535]="",
	[1536]="",
	[1537]="",
	[1538]="",
	[1539]="",
	[1635]="",
	[1636]="",
	[1637]="",
	[1638]="",
	[1639]="",
}

Map.Argus3MapBlks = {
	[1119]="",
	[1120]="",
	[1121]="",
	[1122]="",
	[1123]="",
	[1219]="",
	[1220]="",
	[1221]="",
	[1222]="",
	[1223]="",	
	[1319]="",
	[1320]="",
	[1321]="",
	[1322]="",
	[1323]="",	
	[1419]="",
	[1420]="",
	[1421]="",
	[1422]="",
	[1423]="",	
	[1519]="",
	[1520]="",
	[1521]="",
	[1522]="",
	[1523]="",	
}

Map.MiniMapBlks = {
	[1] = {
		Map.KalMapBlks,
		1908,
		19, 8,
		 Map.MapWorldInfo[13].X + Map.MapInfo[1].X + 2025.753921875, Map.MapWorldInfo[13].Y + Map.MapInfo[1].Y + -0.476021875,
		"World\\Minimaps\\Kalimdor"
	},
	[2] = {
		Map.EkMapBlks,
		2420,
		24, 20,
		Map.MapWorldInfo[14].X + Map.MapInfo[2].X + 2780.985220625, Map.MapWorldInfo[14].Y + Map.MapInfo[2].Y + 954.557004,
		"World\\Minimaps\\Azeroth"
	},
	[3] = {
		Map.OLMapBlks,
		1221,
		12, 21,
		Map.MapWorldInfo[466].X + Map.MapInfo[3].X + 465.4, Map.MapWorldInfo[466].Y + Map.MapInfo[3].Y + -9.7,
		"World\\Minimaps\\Expansion01"
	},
	[4] = {
		Map.NRMapBlks,
		1109,
		11, 09,
		Map.MapWorldInfo[485].X + Map.MapInfo[4].X + -397.1, Map.MapWorldInfo[485].Y + Map.MapInfo[4].Y + -334.1,
		"World\\Minimaps\\Northrend"
	},
	[5] = {
		Map.LIMapBlks,
		2324,
		23, 24,
		Map.MapWorldInfo[751].X + Map.MapInfo[5].X + -178.84, Map.MapWorldInfo[751].Y + Map.MapInfo[5].Y + 401.76665039063,
		"World\\Minimaps\\LostIsles"
	},
	[6] = {
		Map.PandariaMapBlks,
		1816,
		18, 16,
		Map.MapWorldInfo[862].X + Map.MapInfo[6].X + 256.3, Map.MapWorldInfo[862].Y + Map.MapInfo[6].Y + -371.0,
		"World\\Minimaps\\HawaiiMainLand"
	},
	[7] = {
		Map.DraenorMapBlks,
		1220,
		12, 20,
		Map.MapWorldInfo[962].X + Map.MapInfo[7].X + 314.8, Map.MapWorldInfo[962].Y + Map.MapInfo[7].Y + 958.6,
		"World\\Minimaps\\Draenor"
	},
	[8] = {
		Map.BrokenIslesMapBlks,
		1117,
		11, 17,
		Map.MapWorldInfo[1007].X + Map.MapInfo[8].X + 380, Map.MapWorldInfo[1007].Y + Map.MapInfo[8].Y - 147.8,
		"World\\Minimaps\\Troll Raid"
	},
	[464] = {
		Map.DraeneiMapBlks,
		5033,
		50, 33,
		Map.MapWorldInfo[13].X + Map.MapInfo[1].X + 1833.076104875, Map.MapWorldInfo[13].Y + Map.MapInfo[1].Y + 656.598490125,
		"World\\Minimaps\\Expansion01"
	},
	[462] = {
		Map.BloodelfMapBlks,
		4111,
		41, 11,
		Map.MapWorldInfo[14].X + Map.MapInfo[2].X + 4091.405261625, Map.MapWorldInfo[14].Y + Map.MapInfo[2].Y + 511.140381,
		"World\\Minimaps\\Expansion01"
	},
	[708] = {
		Map.TolBaradMapBlks,
		2731,
		27, 31,
		Map.MapWorldInfo[14].X + Map.MapInfo[2].X + 2500.940740625, Map.MapWorldInfo[14].Y + Map.MapInfo[2].Y + 2448.61535,
		"World\\Minimaps\\TolBarad"
	},
	[795] = {
		Map.MoltenFrontMapBlks,
		2725,		-- 2725 to 3531
		27, 25,
		Map.MapWorldInfo[795].X + Map.MapInfo[1].X + 3152.92266259766, Map.MapWorldInfo[795].Y + Map.MapInfo[1].Y + -2105.97034960937,
		"World\\Minimaps\\FirelandsDailies"
	},
	[640] = {		-- 2625 to 3534
		Map.DeepholmMapBlks,
		2625,
		26, 25,
		Map.MapWorldInfo[751].X + Map.MapInfo[5].X + 1251.16, Map.MapWorldInfo[751].Y + Map.MapInfo[5].Y + 228.97665039063,
		"World\\Minimaps\\Deephome"
	},
	[605] = {
		Map.KezanMapBlks,
		2324,
		23, 24,
		Map.MapWorldInfo[751].X + Map.MapInfo[5].X + 297.05, Map.MapWorldInfo[751].Y + Map.MapInfo[5].Y + -1411.53334960937,
		"World\\Minimaps\\LostIsles"
	},
	[808] = {
		Map.TheWanderingIsleMapBlks,
		 2328,
		 23,28,
		 Map.MapWorldInfo[808].X + Map.MapWorldInfo[808].XOff + Map.MapInfo[6].X  + 35.7, Map.MapWorldInfo[808].Y + Map.MapWorldInfo[808].YOff + Map.MapInfo[6].Y-69.55,
		 "World\\Minimaps\\NewRaceStartZone"
	},
	[823] = {
		Map.DarkMoonFaireBlks,
		1636,
		16, 36,
		Map.MapWorldInfo[823].X + Map.MapInfo[5].X + -253,Map.MapWorldInfo[823].Y + Map.MapInfo[5].Y + -238,
		"World\\Minimaps\\DarkmoonFaire"
	},	
	[1135] = {
		Map.Argus1MapBlks,
		2627,
		26, 27,
		Map.MapWorldInfo[1135].X + Map.MapWorldInfo[1135].XOff + Map.MapInfo[9].X + 114.1, Map.MapWorldInfo[1135].Y + Map.MapWorldInfo[1135].YOff + Map.MapInfo[9].Y + -2.6,
		"World\\Minimaps\\Argus 1"
	},
	[1170] = {
		Map.Argus3MapBlks,
		1119,
		11, 19,
		Map.MapWorldInfo[1170].X + Map.MapWorldInfo[1170].XOff + Map.MapInfo[9].X + 69.1, Map.MapWorldInfo[1170].Y + Map.MapWorldInfo[1170].YOff + Map.MapInfo[9].Y + -62.6,
		"World\\Minimaps\\Argus 1"
	},
	[1171] = {
		Map.Argus2MapBlks,
		1135,
		11, 35,
		Map.MapWorldInfo[1171].X + Map.MapWorldInfo[1171].XOff + Map.MapInfo[9].X + 15.7, Map.MapWorldInfo[1171].Y + Map.MapWorldInfo[1171].YOff + Map.MapInfo[9].Y + -37.6,
		"World\\Minimaps\\Argus 1"
	},	
}

--------
-- Get minimap info for map
-- (map id)
-- ret: table, x, y

function Nx.Map:GetMiniInfo (mapId)

	local winfo = self.MapWorldInfo[mapId]
	if not winfo then return end
	local id = winfo.MId

	if not id then
		id = winfo.Cont

		if not id then
			return
		end

		if id == 9 then		-- BGs?
			return
		end

		local info = self.MapInfo[id]
		if not info then
			return
		end
	end

	local t = self.MiniMapBlks[id]

	if not t then			-- "Isle of Quel'Danas"??

--		if NxData.DebugMap then
--			Nx.prt ("GetMiniInfo: missing %s", id)
--		end
		return
	end

	return t, t[5], t[6]
end

--------
-- Get minimap block file name (256x256 texture)

function Nx.Map:GetMiniBlkName (miniT, x, y)

	local off = x * 100 + y

--	Nx.prtCtrl ("%s, %s, %s = %s", x, y, off, off + miniT[2])

	--V4

	local v = miniT[1][off + miniT[2]]

	if v then

		if #v > 0 then
			return format ("%s\\noLiquid_map%02d_%02d", miniT[7], x + miniT[3], y + miniT[4])
		end
		if (strfind(miniT[7],"HawaiiMainLand")) then
			local hasFac = false
			for factionIndex = 1, GetNumFactions() do
				local name, description, standingId, bottomValue, topValue, earnedValue, atWarWith,canToggleAtWar, isHeader, isCollapsed, hasRep, isWatched, isChild = GetFactionInfo(factionIndex)
				if (name == "Operation: Shieldwall") or (name == "Dominance Offensive") then
					hasFac = true
				end
			end
			if (hasFac) then
				if ((x + miniT[3] == 33) or (x + miniT[3] == 34)) and ((y + miniT[4] == 33) or (y + miniT[4] == 34)) then
					return format("World\\Minimaps\\AllianceBeachDailyArea\\map%02d_%02d", x + miniT[3], y + miniT[4])
				end
				if ((x + miniT[3] == 27) or (x + miniT[3] == 28)) and ((y + miniT[4] == 35) or (y + miniT[4] == 36) or (y + miniT[4] == 37) or (y + miniT[4] == 38)) then
					return format("World\\Minimaps\\HordeBeachDailyArea\\map%02d_%02d", x + miniT[3], y + miniT[4])
				end
			end
			if (x + miniT[3] >= 18) and (x + miniT[3] <= 25) and (y + miniT[4] >= 17) and (y + miniT[4] <= 24) then
				return format("World\\Minimaps\\MoguIslandDailyArea\\map%02d_%02d",x+miniT[3], y + miniT[4]-2)
			end
		  return format ("%s\\map%02d_%02d", miniT[7], x + miniT[3], y + miniT[4])
		else
			return format ("%s\\map%02d_%02d", miniT[7], x + miniT[3], y + miniT[4])
		end

	end
end

Map.MapLevels={
	[811] = { [3] = 6010, [4] = 6011, },
	[903] = { [1] = 6012, [2] = 6013, },
	[905] = { [3] = 6010, [4] = 6011, },
	[504] = { [2] = 4014, },
	[321] = { [2] = 1034, },
}

-------------------------------------------------------------------------------
-- EOF
