local E = select(2, ...)

local WMM = CreateFrame("Frame")
-- /dump EJ_GetInstanceByIndex(2, false) -- By using instance IDs, we can get the real ID here
-- Global string list can be found on https://github.com/tekkub/wow-globalstrings/tree/master/GlobalStrings
-- Important strings: RAID, INSTANCE

-- Syntax:
-- [continentIndex] = {
--	[zoneIndex] = {
--		[internalNum] = {InstanceID, IsRaid, MapPosX, MapPosY, OPTIONALSubZoneText},
--	}
-- }

--[[----------------------------------------------------------------------

	SoO 72.52, 44.14
	Temple of the Jade Serpent: 56.17, 57.86
	Shado-Pan Monastery: 36.70, 47.43
	Siege of Niuzao Temple: 34.67, 81.47
	Heart of Fear: 38.92, 34.99
	Gate of the Setting Sun: 15.85, 74.34
	Stormstout Brewery: 36.06, 69.12
	Mogu'shan Palace: 80.74, 32.86
	Mogu'shan Terrace: 59.61, 39.19
	Terrace of Endless Spring: 48.44, 61.45
	Throne of Thunder: 63.59, 32.39
	Shadowmoon Burial Grounds: 31.92, 42.48
	Skyreach: 35.59, 33.58
	Auchindoun: 46.30, 73.94
	Highmaul: 32.95, 38.39
	Bloodmaul Slag Mines: 49.86, 24.76
	Iron Docks: 45.38, 13.54
	Blackrock Foundry: 51.34, 28.52
	Grimrail Depot: 55.24, 32.07
	The Everbloom: 59.59, 45.52
	Hellfire Citadel: 45.54, 53.60
	The Stockade: 51.45, 68.16
	Deadmines: 42.56, 71.84
	Return to Karazhan: 46.83, 70.06
	Karazhan: 47.04, 74.96
	Temple of Atal'Hakkar: 69.67, 53.62
	Blackwing Descent: 23.19, 26.37
	Blackwing Lair: 64.36, 70.84
	Upper Blackrock Spire: 27.28, 24.03
	Lower Blackrock Spire: 27.58, 25.29
	Blackrock Caverns: 65.16, 60.60
	Blackrock Depths & Molten Core: 43.61, 48.44
	Molten Core: 54.28, 83.44
	Blackrock Depths: 14.53, 9.22
	Blackrock Caverns (seperate Map): 27.37, 27.87
	Gnomeregan: 32.89, 37.02
	The Bastion of Twilight: 34.05, 77.89
	Grim Batol: 19.21, 54.11
	Shadowfang Keep: 44.93, 67.92
	Scarlet Monastery & Scarlet Halls: 82.59, 33.49
	Scarlet Halls (seperate Map): 78.04, 56.66
	Scarlet Monastery (seperate Map): 69.65, 26.44
	Scholomance: 69.74, 73.44
	Stratholme: Main Gate: 26.43, 11.60
	Stratholme: Service Entrance: 43.46, 19.46
	Zul'Aman: 82.00, 64.33
	Zul'Gurub: 72.00, 32.90
	The Stonecore: 47.39, 52.06
	Baradin Hold: 46.07, 47.97
	Lost City of the Tol'vir: 60.51, 64.10
	Halls of Origination: 71.88, 52.17
	The Vortex Pinnacle: 76.71, 84.37
	Throne of the Four Winds: 38.49, 80.56
	Ruins of Ahn'Qiraj: 58.95, 14.16
	Temple of Ahn'Qiraj: 46.79, 7.50
	Ahn'Qiraj: 35.94, 83.13 (Silithus)
	Caverns of Time Entrance: 64.76, 49.99
	End Time: 57.46, 29.51
	Dragon Soul: 62.02, 27.28
	Hour of Twilight: 66.66, 29.44
	Battle for Mount Hyjal: 35.91, 16.03
	Escape from Durnholde Keep: 26.87, 36.16
	Well of Eternity: 22.66, 64.27
	Opening of the Dark Portal: 36.76, 83.44
	The Culling of Stratholme: 57.13, 82.63
	Razorfen Downs: 47.57, 23.61
	Razorfen Kraul: 47.50, 23.58
	Dire Maul: Capital Gardens: 60.32, 30.23
	Dire Maul: Warpwood Quarter: 64.84, 30.30
	Dire Maul: Gordock Commons: 62.47, 24.89
	Maraudon Entrance: 29.52, 62.51
	Maraudon: The Wicked Grotto: 51.51, 24.52 (sep. Map: Faulsporenhöhle)
	Maraudon: Foulspore Cavern: 78.23, 55.44 (sep. Map: Die Tückische Höhle)
	Maraudon: Earth Song Falls: 44.55, 76.66 (sep. Map: Faulsporenhöhle)
	Blackfathom Deeps: 14.13, 13.96
	Wailing Caverns Entrance: 38.91, 69.37
	Uldaman Entrance: 41.85, 11.55
	Ragefire Chasm: 67.66, 50.63 (sep. Map: Kluft der Schatten)
	Hellfire Ramparts: 47.76, 53.52
	Shattered Halls: 48.21, 51.85
	Blood Furnace: 46.15, 51.67
	Magtheridon's Lair: 46.51, 52.84
	Tempest Keep: The Eye: 73.57, 63.73
	The Botanica: 71.62, 55.19
	The Mechanar: 70.48, 69.55
	The Arcatraz: 74.30, 57.79
	Gruul's Lair: 68.17, 24.37
	Coilfang Reservoir (Echsenkessel) Entrance: 50.36, 40.80
	Auchenai Crypts: 37.32, 65.62
	Shadow Labyrinth: 39.63, 69.14
	Sethekk Halls: 41.99, 65.60
	Mana-Tombs: 39.65, 62.25
	Black Temple: 71.02, 46.21
	Sunwell Plateau: 44.26, 45.51
	Magisters' Terrace: 61.03, 30.74
	Eye of Eternity: 27.58, 26.63
	The Oculus: 27.61, 26.57
	Azjol-Nerub: 26.01, 50.83
	Ahn'kahet: The Old Kingdom: 28.35, 51.66
	The Nexus: 27.49, 26.11
	Vault of Archavon: 50.00, 16.53
	Icecrown Citadel: 53.24, 85.22
	Pit of Saron: 54.70, 91.62
	Halls of Reflection: 55.13, 90.82
	The Forge of Souls: 54.71, 90.02
	Halls of Stone: 39.64, 26.91
	Ulduar: 41.56, 17.99
	Halls of Lightning: 45.34, 21.43
	The Violet Hold: 66.37, 67.73
	Ruby Sanctum: 61.19, 52.74
	Obsidian Sanctum: 60.00, 56.73
	Naxxramas: 87.35, 50.99
	Gundrak: 76.28, 21.20
	Drak'Tharon Keep: 28.58, 86.94 (Zul'Drak)
	Utgarde Pinnacle: 57.22, 46.49
	Utgarde Keep: 58.01, 50.04
	Trial of the Crusader: 75.17, 21.81
	Trial of the Champion: 74.18, 20.41
	Firelands: 47.61, 77.89
	Throne of the Tides: 70.85, 29.42

----------------------------------------------------------------------]]--

WMM.Markers = {
	-- Kalimdor
	[1] = {
		-- Desolace
		[9] = {
			[1] = {232, false, 50.00, 50.00}, -- Maraudon
		},
		-- Dustwallow Marsh
		[15] = {
			[1] = {760, true, 52.48, 76.51}, -- Onyxias Lair
		},
		-- Ashenvale
		[16] = {
			[1] = {240, false, 50.00, 50.00}, -- Blackfathoms Deeps
		},
		-- Feralas
		[17] = {
			[1] = {230, false, 50.00, 50.00}, -- Diremaul
		},
		-- Hyjal
		[18] = {
			[1] = {78, true, 47.61, 77.89}, -- Firelands
		},
		-- Northern Barrens
		[22] = {
			[1] = {240, false, 38.91, 69.37}, -- Wailing Caverns
		},
		-- Silithus
		[24] = {
			[1] = {743, true, 58.95, 14.16}, -- Ruins of Ahn'Qiraj
			[2] = {744, true, 46.79, 7.50}, -- Temple of Ahn'Qiraj
		},
		-- Southern Barrens
		[26] = {
			[1] = {234, false, 41.02, 94.65}, -- Kral der Klingenhauer
		},
		-- Tanaris
		[28] = {
			[1] = {241, false, 39.22, 21.62}, -- Zul'Farrak
			[2] = {187, true, 60.82, 21.14, "CavernsofTime", 667}, -- Dragonsoul
			[3] = {186, false, 68.41, 29.53, "CavernsofTime", 667}, -- Hour of Twilight
		},
		-- Thousand Needles
		[29] = {
			[1] = {233, false, 46.63, 23.52}, -- Hügel der Klingenhauer
		},
		-- Uldum
		[32] = {
			[1] = {68, false, 76.71, 84.37}, -- The Vortex Pinnacle
			[2] = {74, true, 38.49, 80.56}, -- Throne of the Four Winds
		},
	},
	-- Eastern Kingdoms
	[2] = {
		-- Abyssal Deeps
		[1] = {
			[1] = {65, false, 70.85, 29.42}, -- Throne of Tides
		},
	},
	-- Outland
	[3] = {
		
	},
	-- Northrend
	[4] = {
		
	},
	-- The Maelstrom
	[5] = {
		-- Deepholm
		[4] = {
			
		},
	},
	-- Pandaria
	[6] = {
		-- Everblossom
		[1] = {
			[1] = {369, true, 72.52, 44.14}, -- Siege of Orgrimmar
			[2] = {303, false, 15.85, 74.34}, -- Gate of the Setting Sun
			[3] = {321, false, 80.74, 32.86}, -- Mogu'shan Palace
		},
		-- The Jadeforest
		[2] = {
			[1] = {313, false, 56.17, 57.86}, -- Temple of the Jade Serpent
		},
		-- The Hidden Stairs
		[3] = {
			[1] = {320, true, 48.44, 61.45}, -- Terrace of Endless Spring
		},
		-- Isle of Thunder
		[5] = {
			[1] = {362, true, 63.59, 32.39}, -- Throne of Thunder
		},
		-- Kun-Lai
		[7] = {
			[1] = {312, false, 36.70, 47.43}, -- Shado-Pan Monastery
			[2] = {317, true, 59.61, 39.19}, -- Mogu'Shan Vault
		},
		-- Schreckensöde
		[8] = {
			[1] = {330, true, 38.92, 34.99}, -- Heart of Fear
		},
		-- Valley of Four Winds
		[11] = {
			[1] = {302, false, 36.06, 69.12}, -- Stormstout Brewery
		},
		-- Tonlong
		[12] = {
			[1] = {324, false, 34.67, 81.47}, -- Siege of Niuzao Zemple
		},
	},
	-- Draenor
	[7] = {
		-- Frostfire Ridge
		[2] = {
			[1] = {385, false, 49.86, 24.76}, -- Bloodmaul Slag Mines
		},
		-- Gorgrond
		[4] = {
			[1] = {558, false, 45.38, 13.54}, -- Iron Docks
			[2] = {457, true, 51.34, 28.52}, -- Blackrock Foundry
			[3] = {536, false, 55.24, 32.07}, -- Grimrail Depot
			[4] = {556, false, 59.59, 45.52}, -- The Everbloom
		},
		-- Nagrand
		[7] = {
			[1] = {477, true, 32.59, 38.39}, -- Highmaul
		},
		-- Shadowmoon Valley
		[8] = {
			[1] = {537, false, 31.92, 42.48}, -- Shadowmoon Burial Grounds
		},
		-- Peaks of Arak
		[9] = {
			[1] = {476, false, 35.59, 33.58}, -- Skyreach
		},
		-- Talador
		[11] = {
			[1] = {547, false, 46.30, 73.94}, -- Auchindoun
		},
		-- Tanaan Jungle
		[12] = {
			[1] = {669, true, 45.54, 53.60}, -- Hellfire Citadel
		},
	},
	[8] = {
		
	},
	[9] = {
		
	},
}

E:AddModule("WorldmapMarkers", WMM)