local E = select(2, ...)
local CO, L = E:LoadModules("Config", "Locale")

local WM = CreateFrame("Frame")
WM.CurrentContinent, WM.CurrentZone, WM.MapInfo = nil, nil, nil
WM.Buttons = {}
WM.ButtonSize = 36


-- INCOMING_RESURRECT_CHANGED
-- [[Interface\RaidFrame\Raid-Icon-Rez]]

local WMM = nil

function WM:UpdateCurrentZone()
	self.CurrentContinent 	= GetCurrentMapContinent()
	self.CurrentZone		= GetCurrentMapZone()
	self.MapInfo			= { GetMapInfo() }
end

-- The second return value of GetMapInfo() seems to be an accurate ID for the currently viewed zone
-- Fourth return value is a bool wether the current viewed map is a micro-dungeon aka. subzone
-- So we have to combine the MapContinent and MapZone with those values to receive an accurate view of what's displayed on the map.
-- /dump GetMapInfo()

-- Use GetPOITextureCoords(INDEX) somehow
function WM:SetTexCoord(object, type)
	-- local coords = { GetPOITextureCoords(1) }
	if type == true then
		object:SetTexCoord(0.475, 0.42, 0.1275, 0.18)
		-- object:SetTexCoord(coords[1], coords[2], coords[3], coords[4])
	else
		object:SetTexCoord(0.3725, 0.4275, 0.1275, 0.18)
	end
end

function WM:CheckVisibility(object)
	if not object then return end
	
	-- If currently viewed map is a mini-dungeon
	if self.MapInfo[4] == true then
		-- If object is not in a mini-dungeon [sub-zone]
		if object.isInMiniDungeon == false then
			object:Hide()
		else
			-- If sub-zone floor matches
			if object.floor == self.MapInfo[2] then
				object:Show()
			else
				object:Hide()
			end
		end
	else
		-- If object is not in a mini-dungeon
		if object.isInMiniDungeon == false then
			object:Show()
		else
			object:Hide()
		end
	end
end

function WM:__Update(self, event, ...)
	self:UpdateCurrentZone()
	
	self.mapWidth = WorldMapButton:GetWidth()
	self.mapHeight = WorldMapButton:GetHeight()
	
	E:debugprint("Continent: " .. self.CurrentContinent .. " - Zone: " .. self.CurrentZone)
	
	-- Entrance Texture: 1121272
	-- Correct tex coord for Raid Icon: 0.475, 0.42, 0.1275, 0.18
	-- Correct tex coord for Dungeon Icon: 0.3725, 0.4275, 0.1275, 0.18
	
	-- print(table.getn(WM.Buttons))
	for k, v in pairs(WM.Buttons) do
		v:Hide()
	end
	
	self.CurrentMarkerSet = nil
	
	if WMM.Markers[self.CurrentContinent] then
		if WMM.Markers[self.CurrentContinent][self.CurrentZone] then
			self.CurrentMarkerSet = WMM.Markers[self.CurrentContinent][self.CurrentZone]
			
			for k, instance in pairs(self.CurrentMarkerSet) do
				if type(instance) == "table" then
					self.currentInstanceInfo = { EJ_GetInstanceInfo(instance[1]) }
					
					if self.currentInstanceInfo and self.currentInstanceInfo[1] then
						self.currentInstanceName 	= self.currentInstanceInfo[1]
						self.currentInstanceDesc 	= self.currentInstanceInfo[2]
						self.currentInstanceX 		= instance[3]
						self.currentInstanceY 		= instance[4]
						
						if self.Buttons[instance[1]] then
							WM:CheckVisibility(self.Buttons[instance[1]])
							--self.Buttons[instance[1]]:Show()
						else
							self.Buttons[instance[1]] = CreateFrame("Button")
							self.Buttons[instance[1]]:SetSize(WM.ButtonSize, WM.ButtonSize)
							self.Buttons[instance[1]]:SetPoint("TOPLEFT", WorldMapButton, "TOPLEFT", ((self.currentInstanceX / 100) * self.mapWidth) - (WM.ButtonSize / 2), -(((self.currentInstanceY / 100) * self.mapHeight) - (WM.ButtonSize / 2)))
							self.Buttons[instance[1]]:SetParent(WorldMapButton)
							
							self.Buttons[instance[1]].instanceName = self.currentInstanceName
							self.Buttons[instance[1]].instanceDesc = self.currentInstanceDesc
							self.Buttons[instance[1]].isRaid = instance[2]
							
							-- GetLFGDungeonInfo(INDEX)
							-- GetRFDungeonInfo(INDEX)
							
							self.Buttons[instance[1]]:EnableMouse(true)
							-- self.Buttons[instance[1]]:SetScript("OnEnter", WorldMapPOI_OnEnter)
							self.Buttons[instance[1]]:SetScript("OnEnter", function(self)
								if self.isRaid then
									WorldMapFrame_SetAreaLabel(WORLDMAP_AREA_LABEL_TYPE.POI, self.instanceName, RAID)
								else
									WorldMapFrame_SetAreaLabel(WORLDMAP_AREA_LABEL_TYPE.POI, self.instanceName, CALENDAR_TYPE_DUNGEON)
								end
							end)
							self.Buttons[instance[1]]:SetScript("OnLeave", function(self)
								WorldMapFrame_ClearAreaLabel(WORLDMAP_AREA_LABEL_TYPE.POI)
								WorldMapTooltip:Hide()
							end)
							
							
							self.Buttons[instance[1]].Icon = self.Buttons[instance[1]]:CreateTexture(instance[1], "OVERLAY")
							self.Buttons[instance[1]].Icon:SetAllPoints(self.Buttons[instance[1]])
							self.Buttons[instance[1]].Icon:SetParent(self.Buttons[instance[1]])
							self.Buttons[instance[1]].Icon:SetTexture(1121272)
							WM:SetTexCoord(self.Buttons[instance[1]].Icon, instance[2])
							
							self.Buttons[instance[1]]:SetHighlightTexture("Interface/WorldMap/UI-QuestPoi-NumberIcons");
							self.Buttons[instance[1]]:GetHighlightTexture():SetTexCoord(0.625, 0.750, 0.875, 1);
							
							if instance[5] then
								self.Buttons[instance[1]].isInMiniDungeon = true
								self.Buttons[instance[1]].floor = instance[6]
							else
								self.Buttons[instance[1]].isInMiniDungeon = false
							end
							
							WM:CheckVisibility(self.Buttons[instance[1]])
						end
					end
				end
			end
		end
	end
end

function WM:InitMarkers()
	self:UnregisterEvent("ADDON_LOADED")
	
	WMM = E:GetModule("WorldmapMarkers")
	self:RegisterEvent("WORLD_MAP_UPDATE")
end

function WM:Init()
	self.db = CO.db.profile.worldmap
	
	if not IsAddOnLoaded("CUI_WorldmapMarkers") then
		self:RegisterEvent("ADDON_LOADED")
	else
		WM:InitMarkers()
	end
	self:SetScript("OnEvent", function(self, event, ...)
		if event == "ADDON_LOADED" then
			if ... == "CUI_WorldmapMarkers" then
				WM:InitMarkers()
			end
		
			return
		end
		self:__Update(self, event, ...)
	end)
end

E:AddModule("Worldmap", WM)