local E = select(2, ...) -- Engine
local CO,LOC,UF,AB,LT,AUR,TT,MM = E:LoadModules("Config", "Locale", "Unitframes", "Actionbars", "Layout", "Auras", "Tooltip", "Minimap")

local _
local CUI_MinimapBorder, CUI_MinimapBackground
local FramesToHide = {MinimapBorder, MinimapBorderTop, MinimapZoomIn, MinimapZoomOut}
local QuetMode = false
local MINIMAP_MASK_TEXTURE, MINIMAP_BORDER_TEXTURE, MINIMAP_BACKGROUND_TEXTURE, MINIMAP_PLAYERICON_TEXTURE

	MINIMAP_MASK_TEXTURE = [[Interface\AddOns\CUI\Textures\minimap\maskModern]]
	MINIMAP_BORDER_TEXTURE = [[Interface\AddOns\CUI\Textures\minimap\borderModern]]
	MINIMAP_BACKGROUND_TEXTURE = [[Interface\AddOns\CUI\Textures\minimap\background]]
	MINIMAP_PLAYERICON_TEXTURE = [[Interface\AddOns\CUI\Textures\minimap\playerIcon]]
	
local GetMinimapShape = GetMinimapShape

	
do
	--if select(3, UnitClass("player")) == 11 then 
	if UnitName("player") == "Arenima" then
		QuetMode = true
	end
end

function MM:LoadMinimapStyle()
	local Update = function(Object, Size, Texture, TextureCoord)
		Object = Minimap:CreateTexture(nil)
		Object:ClearAllPoints()
		Object:SetPoint("CENTER", Minimap, "CENTER", 0, 0)
		Object:SetSize(Size,Size)
		Object:SetTexture(Texture)
		Object:SetTexCoord(TextureCoord[1],TextureCoord[2],TextureCoord[3],TextureCoord[4])
	end
	local Frames = {
		["CUI_MinimapBorder"] 		= {140, MINIMAP_BORDER_TEXTURE, {0,1,0,1}},
		-- ["CUI_MinimapBackground"] 	= {140, MINIMAP_BACKGROUND_TEXTURE, {0,1,0,1}},
	}
	for k,v in pairs(Frames) do
		Update(k, v[1],v[2],v[3])
	end
	
	local Mover = E:CreateMover(MinimapCluster, "Minimap", "TOPRIGHT")
	E:RepositionMover(Mover, "TOPRIGHT", 0, 0)
	
	Minimap:SetMaskTexture(MINIMAP_MASK_TEXTURE)
	--MinimapCluster:SetPoint("TOPRIGHT", E.Parent, "TOPRIGHT") -- Fix for Order Hall and to correct positioning
	MM:EnableMouseZoom()
	MM:HideBlizzard()
	
	if QuetMode == true then Minimap:SetPlayerTexture(MINIMAP_PLAYERICON_TEXTURE) end
end

function MM:HideBlizzard()
	for k,v in pairs(FramesToHide) do
		v:Hide()
	end
end

function MM:EnableMouseZoom()
	Minimap:EnableMouseWheel(true)
	Minimap:SetScript('OnMouseWheel', function(self, delta)
		if delta > 0 then
			Minimap_ZoomIn()
		else
			Minimap_ZoomOut() 
		end
	end)
end

-- Causes the minimap buttons to correctly follow the new shape
-- We simply override the function global c:
GetMinimapShape = function() return "SQUARE" end

function MM:Init()
	CO = E:GetModule("Config")
	MM:LoadMinimapStyle()
	
	Minimap:SetArchBlobRingScalar(0)
	Minimap:SetQuestBlobRingScalar(0)
end

E:AddModule("Minimap", MM)